import{s as Kt,f as At,n as Ot,o as te}from"../chunks/scheduler.37c15a92.js";import{S as ee,i as le,g as i,s as a,r,A as se,h as o,f as l,c as n,j as vt,u,x as p,k as f,y as ae,a as s,v as h,d,t as M,w as c}from"../chunks/index.7cb9c9b8.js";import{C as L}from"../chunks/CodeBlock.abae2786.js";import{C as ne}from"../chunks/CourseFloatingBanner.df82c153.js";import{H as kt,E as ie}from"../chunks/getInferenceSnippets.725a12c2.js";function oe(_t){let w,P,V,D,T,K,J,O,g,qt='Depending on the NLP task that you’re working with and the specific use case or application, your data and the annotation task will look differently. For this section of the course, we’ll use <a href="https://huggingface.co/datasets/SetFit/ag_news" rel="nofollow">a dataset collecting news</a> to complete two tasks: a text classification on the topic of each text and a token classification to identify the named entities mentioned.',tt,m,Rt,et,y,Et="It is possible to import datasets from the Hub using the Argilla UI directly, but we’ll be using the SDK to learn how we can make further edits to the data if needed.",lt,j,st,b,Zt="The first step is to connect to our Argilla instance as we did in the previous section:",at,I,nt,U,Bt="We can now think about the settings of our dataset in Argilla. These represent the annotation task we’ll do over our data. First, we can load the dataset from the Hub and inspect its features, so that we can make sure that we configure the dataset correctly.",it,$,ot,x,Gt="These are the features of our dataset:",pt,C,rt,A,Ft="It contains a <code>text</code> and also some initial labels for the text classification. We’ll add those to our dataset settings together with a <code>spans</code> question for the named entities:",ut,v,ht,k,Xt="Let’s dive a bit deeper into what these settings mean. First, we’ve defined <strong>fields</strong>, these include the information that we’ll be annotating. In this case, we only have one field and it comes in the form of a text, so we’ve choosen a <code>TextField</code>.",dt,_,Wt="Then, we define <strong>questions</strong> that represent the tasks that we want to perform on our data:",Mt,q,zt="<li>For the text classification task we’ve chosen a <code>LabelQuestion</code> and we used the unique values of the <code>label_text</code> column as our labels, to make sure that the question is compatible with the labels that already exist in the dataset.</li> <li>For the token classification task, we’ll need a <code>SpanQuestion</code>. We’ve defined a set of labels that we’ll be using for that task, plus the field on which we’ll be drawing the spans.</li>",ct,R,Qt='To learn more about all the available types of fields and questions and other advanced settings, like metadata and vectors, go to the <a href="https://docs.argilla.io/latest/how_to_guides/dataset/#define-dataset-settings" rel="nofollow">Argilla docs</a>.',mt,E,ft,Z,Ht="Now that we’ve defined some settings, we can create the dataset:",wt,B,Tt,G,Nt="The dataset now appears in our Argilla instance, but you will see that it’s empty:",Jt,F,St,gt,X,Lt="Now we need to add the records that we’ll be annotating i.e., the rows in our dataset. To do that, we’ll simply need to log the data as records and provide a mapping for those elements that don’t have the same name in the hub and Argilla datasets:",yt,W,jt,z,Vt="In our mapping, we’ve specified that the <code>label_text</code> column in the dataset should be mapped to the question with the name <code>label</code>. In this way, we’ll use the existing labels in the dataset as pre-annotations so we can annotate faster.",bt,Q,Yt="While the records continue to log, you can already start working with your dataset in the Argilla UI. At this point, it should look like this:",It,H,Pt,Ut,N,Dt="Now our dataset is ready to start annotating!",$t,S,xt,Y,Ct;return T=new kt({props:{title:"Load your dataset to Argilla",local:"load-your-dataset-to-argilla",headingTag:"h1"}}),J=new ne({props:{chapter:10,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter10/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter10/section3.ipynb"}]}}),j=new kt({props:{title:"Configure your dataset",local:"configure-your-dataset",headingTag:"h2"}}),I=new L({props:{code:"aW1wb3J0JTIwYXJnaWxsYSUyMGFzJTIwcmclMEElMEFIRl9UT0tFTiUyMCUzRCUyMCUyMi4uLiUyMiUyMCUyMCUyMyUyMG9ubHklMjBmb3IlMjBwcml2YXRlJTIwc3BhY2VzJTBBJTBBY2xpZW50JTIwJTNEJTIwcmcuQXJnaWxsYSglMEElMjAlMjAlMjAlMjBhcGlfdXJsJTNEJTIyLi4uJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMi4uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlM0QlN0IlMjJBdXRob3JpemF0aW9uJTIyJTNBJTIwZiUyMkJlYXJlciUyMCU3QkhGX1RPS0VOJTdEJTIyJTdEJTJDJTIwJTIwJTIzJTIwb25seSUyMGZvciUyMHByaXZhdGUlMjBzcGFjZXMlMEEp",highlighted:`<span class="hljs-keyword">import</span> argilla <span class="hljs-keyword">as</span> rg

HF_TOKEN = <span class="hljs-string">&quot;...&quot;</span>  <span class="hljs-comment"># only for private spaces</span>

client = rg.Argilla(
    api_url=<span class="hljs-string">&quot;...&quot;</span>,
    api_key=<span class="hljs-string">&quot;...&quot;</span>,
    headers={<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>},  <span class="hljs-comment"># only for private spaces</span>
)`,wrap:!1}}),$=new L({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJTZXRGaXQlMkZhZ19uZXdzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhLmZlYXR1cmVz",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

data = load_dataset(<span class="hljs-string">&quot;SetFit/ag_news&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
data.features`,wrap:!1}}),C=new L({props:{code:"JTdCJ3RleHQnJTNBJTIwVmFsdWUoZHR5cGUlM0Qnc3RyaW5nJyUyQyUyMGlkJTNETm9uZSklMkMlMEElMjAnbGFiZWwnJTNBJTIwVmFsdWUoZHR5cGUlM0QnaW50NjQnJTJDJTIwaWQlM0ROb25lKSUyQyUwQSUyMCdsYWJlbF90ZXh0JyUzQSUyMFZhbHVlKGR0eXBlJTNEJ3N0cmluZyclMkMlMjBpZCUzRE5vbmUpJTdE",highlighted:`{<span class="hljs-string">&#x27;text&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label_text&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),v=new L({props:{code:"c2V0dGluZ3MlMjAlM0QlMjByZy5TZXR0aW5ncyglMEElMjAlMjAlMjAlMjBmaWVsZHMlM0QlNUJyZy5UZXh0RmllbGQobmFtZSUzRCUyMnRleHQlMjIpJTVEJTJDJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb25zJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmcuTGFiZWxRdWVzdGlvbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEJTIybGFiZWwlMjIlMkMlMjB0aXRsZSUzRCUyMkNsYXNzaWZ5JTIwdGhlJTIwdGV4dCUzQSUyMiUyQyUyMGxhYmVscyUzRGRhdGEudW5pcXVlKCUyMmxhYmVsX3RleHQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJnLlNwYW5RdWVzdGlvbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEJTIyZW50aXRpZXMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCUyMkhpZ2hsaWdodCUyMGFsbCUyMHRoZSUyMGVudGl0aWVzJTIwaW4lMjB0aGUlMjB0ZXh0JTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyUEVSU09OJTIyJTJDJTIwJTIyT1JHJTIyJTJDJTIwJTIyTE9DJTIyJTJDJTIwJTIyRVZFTlQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBKQ==",highlighted:`settings = rg.Settings(
    fields=[rg.TextField(name=<span class="hljs-string">&quot;text&quot;</span>)],
    questions=[
        rg.LabelQuestion(
            name=<span class="hljs-string">&quot;label&quot;</span>, title=<span class="hljs-string">&quot;Classify the text:&quot;</span>, labels=data.unique(<span class="hljs-string">&quot;label_text&quot;</span>)
        ),
        rg.SpanQuestion(
            name=<span class="hljs-string">&quot;entities&quot;</span>,
            title=<span class="hljs-string">&quot;Highlight all the entities in the text:&quot;</span>,
            labels=[<span class="hljs-string">&quot;PERSON&quot;</span>, <span class="hljs-string">&quot;ORG&quot;</span>, <span class="hljs-string">&quot;LOC&quot;</span>, <span class="hljs-string">&quot;EVENT&quot;</span>],
            field=<span class="hljs-string">&quot;text&quot;</span>,
        ),
    ],
)`,wrap:!1}}),E=new kt({props:{title:"Upload the dataset",local:"upload-the-dataset",headingTag:"h2"}}),B=new L({props:{code:"ZGF0YXNldCUyMCUzRCUyMHJnLkRhdGFzZXQobmFtZSUzRCUyMmFnX25ld3MlMjIlMkMlMjBzZXR0aW5ncyUzRHNldHRpbmdzKSUwQSUwQWRhdGFzZXQuY3JlYXRlKCk=",highlighted:`dataset = rg.Dataset(name=<span class="hljs-string">&quot;ag_news&quot;</span>, settings=settings)

dataset.create()`,wrap:!1}}),W=new L({props:{code:"ZGF0YXNldC5yZWNvcmRzLmxvZyhkYXRhJTJDJTIwbWFwcGluZyUzRCU3QiUyMmxhYmVsX3RleHQlMjIlM0ElMjAlMjJsYWJlbCUyMiU3RCk=",highlighted:'dataset.records.log(data, mapping={<span class="hljs-string">&quot;label_text&quot;</span>: <span class="hljs-string">&quot;label&quot;</span>})',wrap:!1}}),S=new ie({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter10/3.mdx"}}),{c(){w=i("meta"),P=a(),V=i("p"),D=a(),r(T.$$.fragment),K=a(),r(J.$$.fragment),O=a(),g=i("p"),g.innerHTML=qt,tt=a(),m=i("iframe"),et=a(),y=i("p"),y.textContent=Et,lt=a(),r(j.$$.fragment),st=a(),b=i("p"),b.textContent=Zt,at=a(),r(I.$$.fragment),nt=a(),U=i("p"),U.textContent=Bt,it=a(),r($.$$.fragment),ot=a(),x=i("p"),x.textContent=Gt,pt=a(),r(C.$$.fragment),rt=a(),A=i("p"),A.innerHTML=Ft,ut=a(),r(v.$$.fragment),ht=a(),k=i("p"),k.innerHTML=Xt,dt=a(),_=i("p"),_.innerHTML=Wt,Mt=a(),q=i("ul"),q.innerHTML=zt,ct=a(),R=i("p"),R.innerHTML=Qt,mt=a(),r(E.$$.fragment),ft=a(),Z=i("p"),Z.textContent=Ht,wt=a(),r(B.$$.fragment),Tt=a(),G=i("p"),G.textContent=Nt,Jt=a(),F=i("img"),gt=a(),X=i("p"),X.textContent=Lt,yt=a(),r(W.$$.fragment),jt=a(),z=i("p"),z.innerHTML=Vt,bt=a(),Q=i("p"),Q.textContent=Yt,It=a(),H=i("img"),Ut=a(),N=i("p"),N.textContent=Dt,$t=a(),r(S.$$.fragment),xt=a(),Y=i("p"),this.h()},l(t){const e=se("svelte-u9bgzb",document.head);w=o(e,"META",{name:!0,content:!0}),e.forEach(l),P=n(t),V=o(t,"P",{}),vt(V).forEach(l),D=n(t),u(T.$$.fragment,t),K=n(t),u(J.$$.fragment,t),O=n(t),g=o(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-21xmjs"&&(g.innerHTML=qt),tt=n(t),m=o(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),vt(m).forEach(l),et=n(t),y=o(t,"P",{"data-svelte-h":!0}),p(y)!=="svelte-1nj4pzu"&&(y.textContent=Et),lt=n(t),u(j.$$.fragment,t),st=n(t),b=o(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-tteoxx"&&(b.textContent=Zt),at=n(t),u(I.$$.fragment,t),nt=n(t),U=o(t,"P",{"data-svelte-h":!0}),p(U)!=="svelte-qr4xxl"&&(U.textContent=Bt),it=n(t),u($.$$.fragment,t),ot=n(t),x=o(t,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1tgrrsi"&&(x.textContent=Gt),pt=n(t),u(C.$$.fragment,t),rt=n(t),A=o(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-qqdqqz"&&(A.innerHTML=Ft),ut=n(t),u(v.$$.fragment,t),ht=n(t),k=o(t,"P",{"data-svelte-h":!0}),p(k)!=="svelte-14iwfy7"&&(k.innerHTML=Xt),dt=n(t),_=o(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1ps5pnk"&&(_.innerHTML=Wt),Mt=n(t),q=o(t,"UL",{"data-svelte-h":!0}),p(q)!=="svelte-1pt9e0q"&&(q.innerHTML=zt),ct=n(t),R=o(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-12o3rnk"&&(R.innerHTML=Qt),mt=n(t),u(E.$$.fragment,t),ft=n(t),Z=o(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-kgkkua"&&(Z.textContent=Ht),wt=n(t),u(B.$$.fragment,t),Tt=n(t),G=o(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-3nv5zt"&&(G.textContent=Nt),Jt=n(t),F=o(t,"IMG",{src:!0,alt:!0}),gt=n(t),X=o(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-q63n9y"&&(X.textContent=Lt),yt=n(t),u(W.$$.fragment,t),jt=n(t),z=o(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-3kvwa0"&&(z.innerHTML=Vt),bt=n(t),Q=o(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-hjqveo"&&(Q.textContent=Yt),It=n(t),H=o(t,"IMG",{src:!0,alt:!0}),Ut=n(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-akh87c"&&(N.textContent=Dt),$t=n(t),u(S.$$.fragment,t),xt=n(t),Y=o(t,"P",{}),vt(Y).forEach(l),this.h()},h(){f(w,"name","hf:doc:metadata"),f(w,"content",pe),At(m.src,Rt="https://huggingface.co/datasets/SetFit/ag_news/embed/viewer/default/train")||f(m,"src",Rt),f(m,"frameborder","0"),f(m,"width","100%"),f(m,"height","560px"),At(F.src,St="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter10/empty_dataset.png")||f(F,"src",St),f(F,"alt","Screenshot of the empty dataset."),At(H.src,Pt="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter10/argilla_initial_dataset.png")||f(H,"src",Pt),f(H,"alt","Screenshot of the dataset in Argilla.")},m(t,e){ae(document.head,w),s(t,P,e),s(t,V,e),s(t,D,e),h(T,t,e),s(t,K,e),h(J,t,e),s(t,O,e),s(t,g,e),s(t,tt,e),s(t,m,e),s(t,et,e),s(t,y,e),s(t,lt,e),h(j,t,e),s(t,st,e),s(t,b,e),s(t,at,e),h(I,t,e),s(t,nt,e),s(t,U,e),s(t,it,e),h($,t,e),s(t,ot,e),s(t,x,e),s(t,pt,e),h(C,t,e),s(t,rt,e),s(t,A,e),s(t,ut,e),h(v,t,e),s(t,ht,e),s(t,k,e),s(t,dt,e),s(t,_,e),s(t,Mt,e),s(t,q,e),s(t,ct,e),s(t,R,e),s(t,mt,e),h(E,t,e),s(t,ft,e),s(t,Z,e),s(t,wt,e),h(B,t,e),s(t,Tt,e),s(t,G,e),s(t,Jt,e),s(t,F,e),s(t,gt,e),s(t,X,e),s(t,yt,e),h(W,t,e),s(t,jt,e),s(t,z,e),s(t,bt,e),s(t,Q,e),s(t,It,e),s(t,H,e),s(t,Ut,e),s(t,N,e),s(t,$t,e),h(S,t,e),s(t,xt,e),s(t,Y,e),Ct=!0},p:Ot,i(t){Ct||(d(T.$$.fragment,t),d(J.$$.fragment,t),d(j.$$.fragment,t),d(I.$$.fragment,t),d($.$$.fragment,t),d(C.$$.fragment,t),d(v.$$.fragment,t),d(E.$$.fragment,t),d(B.$$.fragment,t),d(W.$$.fragment,t),d(S.$$.fragment,t),Ct=!0)},o(t){M(T.$$.fragment,t),M(J.$$.fragment,t),M(j.$$.fragment,t),M(I.$$.fragment,t),M($.$$.fragment,t),M(C.$$.fragment,t),M(v.$$.fragment,t),M(E.$$.fragment,t),M(B.$$.fragment,t),M(W.$$.fragment,t),M(S.$$.fragment,t),Ct=!1},d(t){t&&(l(P),l(V),l(D),l(K),l(O),l(g),l(tt),l(m),l(et),l(y),l(lt),l(st),l(b),l(at),l(nt),l(U),l(it),l(ot),l(x),l(pt),l(rt),l(A),l(ut),l(ht),l(k),l(dt),l(_),l(Mt),l(q),l(ct),l(R),l(mt),l(ft),l(Z),l(wt),l(Tt),l(G),l(Jt),l(F),l(gt),l(X),l(yt),l(jt),l(z),l(bt),l(Q),l(It),l(H),l(Ut),l(N),l($t),l(xt),l(Y)),l(w),c(T,t),c(J,t),c(j,t),c(I,t),c($,t),c(C,t),c(v,t),c(E,t),c(B,t),c(W,t),c(S,t)}}}const pe='{"title":"Load your dataset to Argilla","local":"load-your-dataset-to-argilla","sections":[{"title":"Configure your dataset","local":"configure-your-dataset","sections":[],"depth":2},{"title":"Upload the dataset","local":"upload-the-dataset","sections":[],"depth":2}],"depth":1}';function re(_t){return te(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class me extends ee{constructor(w){super(),le(this,w,re,oe,Kt,{})}}export{me as component};
