import{s as ys,a as ps,n as Us,o as js}from"../chunks/scheduler.ea9963d4.js";import{S as ws,i as Is,e as j,s as t,c as n,h as ms,a as w,d as a,b as e,f as Ts,g as J,j as I,k as _l,l as is,m as M,n as T,t as y,o as p,p as U}from"../chunks/index.2ecb6441.js";import{C as cs,H as m,E as us}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b27212aa.js";import{C as c}from"../chunks/CodeBlock.5675cb3b.js";function Cs(xl){let i,tl,al,el,u,nl,C,Jl,o,zl="A GGUF parser that works on remotely hosted files.",Tl,h,yl,sl,Xl,pl,A,ql='Spec: <a href="https://github.com/ggerganov/ggml/blob/master/docs/gguf.md" rel="nofollow">https://github.com/ggerganov/ggml/blob/master/docs/gguf.md</a>',Ul,g,Dl='Reference implementation (Python): <a href="https://github.com/ggerganov/llama.cpp/blob/master/gguf-py/gguf/gguf_reader.py" rel="nofollow">https://github.com/ggerganov/llama.cpp/blob/master/gguf-py/gguf/gguf_reader.py</a>',jl,d,wl,r,Il,f,ml,b,il,G,cl,Z,ul,S,Cl,B,ol,$,Ol="You can get metadata with type information by setting <code>typedMetadata: true</code>. This provides both the original value and its GGUF data type:",hl,k,Al,V,gl,Q,Pl='By default, known fields in <code>metadata</code> are typed. This includes various fields found in <a href="https://github.com/ggerganov/llama.cpp" rel="nofollow">llama.cpp</a>, <a href="https://github.com/ggerganov/whisper.cpp" rel="nofollow">whisper.cpp</a> and <a href="https://github.com/ggerganov/ggml" rel="nofollow">ggml</a>.',dl,R,rl,Y,fl,E,Kl='Because GGUF format can be used to store tensors, we can technically use it for other usages. For example, storing <a href="https://github.com/ggerganov/llama.cpp/pull/5970" rel="nofollow">control vectors</a>, <a href="https://github.com/ggerganov/llama.cpp/pull/2632" rel="nofollow">lora weights</a>, etc.',bl,N,ls="In case you want to use your own GGUF metadata structure, you can disable strict typing by casting the parse output to <code>GGUFParseOutput&lt;{ strict: false }&gt;</code>:",Gl,L,Zl,W,Sl,F,ss='This package provides a CLI equivalent to <a href="https://github.com/ggml-org/llama.cpp/blob/7a2c913e66353362d7f28d612fd3c9d51a831eda/gguf-py/gguf/scripts/gguf_dump.py" rel="nofollow"><code>gguf_dump.py</code></a> script. You can dump GGUF metadata and list of tensors using this command:',Bl,v,$l,H,as="Example for the output:",kl,_,Vl,x,Ms="Alternatively, you can install this package as global, which will provide the <code>gguf-view</code> command:",Ql,z,Rl,X,Yl,q,ts="The Hub supports all file formats and has built-in features for GGUF format.",El,D,es='Find more information at: <a href="http://hf.co/docs/hub/gguf" rel="nofollow">http://hf.co/docs/hub/gguf</a>.',Nl,O,Ll,P,ns='<li><a href="https://github.com/hyparam/hyllama" rel="nofollow">https://github.com/hyparam/hyllama</a> by @platypii (MIT license)</li> <li><a href="https://github.com/ahoylabs/gguf.js" rel="nofollow">https://github.com/ahoylabs/gguf.js</a> by @biw @dkogut1996 @spencekim (MIT license)</li>',Wl,K,Js="🔥❤️",Fl,ll,vl,Ml,Hl;return u=new cs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new m({props:{title:"@huggingface/gguf",local:"huggingfacegguf",headingTag:"h1"}}),h=new m({props:{title:"Spec",local:"spec",headingTag:"h2"}}),d=new m({props:{title:"Install",local:"install",headingTag:"h2"}}),r=new c({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGZ2d1Zg==",highlighted:"npm install @huggingface/gguf",wrap:!1}}),f=new m({props:{title:"Usage",local:"usage",headingTag:"h2"}}),b=new m({props:{title:"Basic usage",local:"basic-usage",headingTag:"h3"}}),G=new c({props:{code:"aW1wb3J0JTIwJTdCJTIwR0dNTFF1YW50aXphdGlvblR5cGUlMkMlMjBnZ3VmJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGZ2d1ZiUyMiUzQiUwQSUwQSUyRiUyRiUyMHJlbW90ZSUyMEdHVUYlMjBmaWxlJTIwZnJvbSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZUaGVCbG9rZSUyRkxsYW1hLTItN0ItQ2hhdC1HR1VGJTBBY29uc3QlMjBVUkxfTExBTUElMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGVGhlQmxva2UlMkZMbGFtYS0yLTdCLUNoYXQtR0dVRiUyRnJlc29sdmUlMkYxOTEyMzliJTJGbGxhbWEtMi03Yi1jaGF0LlEyX0suZ2d1ZiUyMiUzQiUwQSUwQWNvbnN0JTIwJTdCJTIwbWV0YWRhdGElMkMlMjB0ZW5zb3JJbmZvcyUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ2d1ZihVUkxfTExBTUEpJTNCJTBBJTBBY29uc29sZS5sb2cobWV0YWRhdGEpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwdmVyc2lvbiUzQSUyMDIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjB0ZW5zb3JfY291bnQlM0ElMjAyOTFuJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwa3ZfY291bnQlM0ElMjAxOW4lMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJnZW5lcmFsLmFyY2hpdGVjdHVyZSUyMiUzQSUyMCUyMmxsYW1hJTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZ2VuZXJhbC5maWxlX3R5cGUlMjIlM0ElMjAxMCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMmdlbmVyYWwubmFtZSUyMiUzQSUyMCUyMkxMYU1BJTIwdjIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAuLi4lMEElMkYlMkYlMjAlN0QlMEElMEFjb25zb2xlLmxvZyh0ZW5zb3JJbmZvcyklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwJTIydG9rZW5fZW1iZC53ZWlnaHQlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaGFwZSUzQSUyMCU1QjQwOTZuJTJDJTIwMzIwMDBuJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHR5cGUlM0ElMjBHR01MUXVhbnRpemF0aW9uVHlwZS5RMl9LJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwLi4uJTIwJTJDJTBBJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZSUzQSUyMCUyMm91dHB1dF9ub3JtLndlaWdodCUyMiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNoYXBlJTNBJTIwJTVCNDA5Nm4lNUQlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzQSUyMEdHTUxRdWFudGl6YXRpb25UeXBlLkYzMiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyRiUyRiUyMCU1RCUwQQ==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">GGMLQuantizationType</span>, gguf } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/gguf&quot;</span>;

<span class="hljs-comment">// remote GGUF file from https://huggingface.co/TheBloke/Llama-2-7B-Chat-GGUF</span>
<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">URL_LLAMA</span> = <span class="hljs-string">&quot;https://huggingface.co/TheBloke/Llama-2-7B-Chat-GGUF/resolve/191239b/llama-2-7b-chat.Q2_K.gguf&quot;</span>;

<span class="hljs-keyword">const</span> { metadata, tensorInfos } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(<span class="hljs-variable constant_">URL_LLAMA</span>);

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(metadata);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//     version: 2,</span>
<span class="hljs-comment">//     tensor_count: 291n,</span>
<span class="hljs-comment">//     kv_count: 19n,</span>
<span class="hljs-comment">//     &quot;general.architecture&quot;: &quot;llama&quot;,</span>
<span class="hljs-comment">//     &quot;general.file_type&quot;: 10,</span>
<span class="hljs-comment">//     &quot;general.name&quot;: &quot;LLaMA v2&quot;,</span>
<span class="hljs-comment">//     ...</span>
<span class="hljs-comment">// }</span>

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(tensorInfos);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//     {</span>
<span class="hljs-comment">//         name: &quot;token_embd.weight&quot;,</span>
<span class="hljs-comment">//         shape: [4096n, 32000n],</span>
<span class="hljs-comment">//         dtype: GGMLQuantizationType.Q2_K,</span>
<span class="hljs-comment">//     },</span>

<span class="hljs-comment">//     ... ,</span>

<span class="hljs-comment">//     {</span>
<span class="hljs-comment">//         name: &quot;output_norm.weight&quot;,</span>
<span class="hljs-comment">//         shape: [4096n],</span>
<span class="hljs-comment">//         dtype: GGMLQuantizationType.F32,</span>
<span class="hljs-comment">//     }</span>
<span class="hljs-comment">// ]</span>
`,wrap:!1}}),Z=new m({props:{title:"Reading a local file",local:"reading-a-local-file",headingTag:"h3"}}),S=new c({props:{code:"JTJGJTJGJTIwUmVhZGluZyUyMGElMjBsb2NhbCUyMGZpbGUuJTIwKE5vdCUyMHN1cHBvcnRlZCUyMG9uJTIwYnJvd3NlciklMEFjb25zdCUyMCU3QiUyMG1ldGFkYXRhJTJDJTIwdGVuc29ySW5mb3MlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMGdndWYoJTBBJTIwJTIwJy4lMkZteV9tb2RlbC5nZ3VmJyUyQyUwQSUyMCUyMCU3QiUyMGFsbG93TG9jYWxGaWxlJTNBJTIwdHJ1ZSUyMCU3RCUyQyUwQSklM0I=",highlighted:`<span class="hljs-comment">// Reading a local file. (Not supported on browser)</span>
<span class="hljs-keyword">const</span> { metadata, tensorInfos } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(
  <span class="hljs-string">&#x27;./my_model.gguf&#x27;</span>,
  { <span class="hljs-attr">allowLocalFile</span>: <span class="hljs-literal">true</span> },
);`,wrap:!1}}),B=new m({props:{title:"Typed metadata",local:"typed-metadata",headingTag:"h3"}}),k=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">GGMLQuantizationType</span>, <span class="hljs-title class_">GGUFValueType</span>, gguf } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/gguf&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">URL_LLAMA</span> = <span class="hljs-string">&quot;https://huggingface.co/TheBloke/Llama-2-7B-Chat-GGUF/resolve/191239b/llama-2-7b-chat.Q2_K.gguf&quot;</span>;

<span class="hljs-keyword">const</span> { metadata, typedMetadata } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(<span class="hljs-variable constant_">URL_LLAMA</span>, { <span class="hljs-attr">typedMetadata</span>: <span class="hljs-literal">true</span> });

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(typedMetadata);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//     version: { value: 2, type: GGUFValueType.UINT32 },</span>
<span class="hljs-comment">//     tensor_count: { value: 291n, type: GGUFValueType.UINT64 },</span>
<span class="hljs-comment">//     kv_count: { value: 19n, type: GGUFValueType.UINT64 },</span>
<span class="hljs-comment">//     &quot;general.architecture&quot;: { value: &quot;llama&quot;, type: GGUFValueType.STRING },</span>
<span class="hljs-comment">//     &quot;general.file_type&quot;: { value: 10, type: GGUFValueType.UINT32 },</span>
<span class="hljs-comment">//     &quot;general.name&quot;: { value: &quot;LLaMA v2&quot;, type: GGUFValueType.STRING },</span>
<span class="hljs-comment">//     &quot;llama.attention.head_count&quot;: { value: 32, type: GGUFValueType.UINT32 },</span>
<span class="hljs-comment">//     &quot;llama.attention.layer_norm_rms_epsilon&quot;: { value: 9.999999974752427e-7, type: GGUFValueType.FLOAT32 },</span>
<span class="hljs-comment">//     &quot;tokenizer.ggml.tokens&quot;: { value: [&quot;&lt;unk&gt;&quot;, &quot;&lt;s&gt;&quot;, &quot;&lt;/s&gt;&quot;, ...], type: GGUFValueType.ARRAY, subType: GGUFValueType.STRING },</span>
<span class="hljs-comment">//     &quot;tokenizer.ggml.scores&quot;: { value: [0.0, -1000.0, -1000.0, ...], type: GGUFValueType.ARRAY, subType: GGUFValueType.FLOAT32 },</span>
<span class="hljs-comment">//     ...</span>
<span class="hljs-comment">// }</span>

<span class="hljs-comment">// Access both value and type information</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(typedMetadata[<span class="hljs-string">&quot;general.architecture&quot;</span>].<span class="hljs-property">value</span>); <span class="hljs-comment">// &quot;llama&quot;</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(typedMetadata[<span class="hljs-string">&quot;general.architecture&quot;</span>].<span class="hljs-property">type</span>);  <span class="hljs-comment">// GGUFValueType.STRING (8)</span>

<span class="hljs-comment">// For arrays, subType indicates the type of array elements</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(typedMetadata[<span class="hljs-string">&quot;tokenizer.ggml.tokens&quot;</span>].<span class="hljs-property">type</span>);    <span class="hljs-comment">// GGUFValueType.ARRAY (9)  </span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(typedMetadata[<span class="hljs-string">&quot;tokenizer.ggml.tokens&quot;</span>].<span class="hljs-property">subType</span>); <span class="hljs-comment">// GGUFValueType.STRING (8)</span>`,wrap:!1}}),V=new m({props:{title:"Strictly typed",local:"strictly-typed",headingTag:"h3"}}),R=new c({props:{code:"Y29uc3QlMjAlN0IlMjBtZXRhZGF0YSUyQyUyMHRlbnNvckluZm9zJTIwJTdEJTIwJTNEJTIwYXdhaXQlMjBnZ3VmKFVSTF9NT0RFTCklM0IlMEElMEElMkYlMkYlMjBUeXBlJTIwY2hlY2slMjBmb3IlMjBtb2RlbCUyMGFyY2hpdGVjdHVyZSUyMGF0JTIwcnVudGltZSUwQWlmJTIwKG1ldGFkYXRhJTVCJTIyZ2VuZXJhbC5hcmNoaXRlY3R1cmUlMjIlNUQlMjAlM0QlM0QlM0QlMjAlMjJsbGFtYSUyMiklMjAlN0IlMEElMEElMjAlMjAlMkYlMkYlMjAlMjJsbGFtYS5hdHRlbnRpb24uaGVhZF9jb3VudCUyMiUyMGlzJTIwYSUyMHZhbGlkJTIwa2V5JTIwZm9yJTIwbGxhbWElMjBhcmNoaXRlY3R1cmUlMkMlMjB0aGlzJTIwaXMlMjB0eXBlZCUyMGFzJTIwYSUyMG51bWJlciUwQSUyMCUyMGNvbnNvbGUubG9nKG1vZGVsJTVCJTIybGxhbWEuYXR0ZW50aW9uLmhlYWRfY291bnQlMjIlNUQpJTNCJTBBJTBBJTIwJTIwJTJGJTJGJTIwJTIybWFtYmEuc3NtLmNvbnZfa2VybmVsJTIyJTIwaXMlMjBhbiUyMGludmFsaWQlMjBrZXklMkMlMjBiZWNhdXNlJTIwaXQlMjByZXF1aXJlcyUyMG1vZGVsJTIwYXJjaGl0ZWN0dXJlJTIwdG8lMjBiZSUyMG1hbWJhJTBBJTIwJTIwY29uc29sZS5sb2cobW9kZWwlNUIlMjJtYW1iYS5zc20uY29udl9rZXJuZWwlMjIlNUQpJTNCJTIwJTJGJTJGJTIwZXJyb3IlMEElN0Q=",highlighted:`<span class="hljs-keyword">const</span> { metadata, tensorInfos } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(<span class="hljs-variable constant_">URL_MODEL</span>);

<span class="hljs-comment">// Type check for model architecture at runtime</span>
<span class="hljs-keyword">if</span> (metadata[<span class="hljs-string">&quot;general.architecture&quot;</span>] === <span class="hljs-string">&quot;llama&quot;</span>) {

  <span class="hljs-comment">// &quot;llama.attention.head_count&quot; is a valid key for llama architecture, this is typed as a number</span>
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(model[<span class="hljs-string">&quot;llama.attention.head_count&quot;</span>]);

  <span class="hljs-comment">// &quot;mamba.ssm.conv_kernel&quot; is an invalid key, because it requires model architecture to be mamba</span>
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(model[<span class="hljs-string">&quot;mamba.ssm.conv_kernel&quot;</span>]); <span class="hljs-comment">// error</span>
}`,wrap:!1}}),Y=new m({props:{title:"Disable strictly typed",local:"disable-strictly-typed",headingTag:"h3"}}),L=new c({props:{code:"Y29uc3QlMjAlN0IlMjBtZXRhZGF0YSUyQyUyMHRlbnNvckluZm9zJTIwJTdEJTNBJTIwR0dVRlBhcnNlT3V0cHV0JTNDJTdCJTIwc3RyaWN0JTNBJTIwZmFsc2UlMjAlN0QlM0UlMjAlM0QlMjBhd2FpdCUyMGdndWYoVVJMX0xMQU1BKSUzQg==",highlighted:'<span class="hljs-keyword">const</span> { metadata, tensorInfos }: <span class="hljs-title class_">GGUFParseOutput</span>&lt;{ <span class="hljs-attr">strict</span>: <span class="hljs-literal">false</span> }&gt; = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(<span class="hljs-variable constant_">URL_LLAMA</span>);',wrap:!1}}),W=new m({props:{title:"Command line interface",local:"command-line-interface",headingTag:"h2"}}),v=new c({props:{code:"bnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZnZ3VmJTIwbXlfbW9kZWwuZ2d1ZiUwQSUwQSUyMyUyMG9yJTJDJTIwd2l0aCUyMGElMjByZW1vdGUlMjBHR1VGJTIwZmlsZSUzQSUwQSUyMyUyMG5weCUyMCU0MGh1Z2dpbmdmYWNlJTJGZ2d1ZiUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZiYXJ0b3dza2klMkZMbGFtYS0zLjItMUItSW5zdHJ1Y3QtR0dVRiUyRnJlc29sdmUlMkZtYWluJTJGTGxhbWEtMy4yLTFCLUluc3RydWN0LVE0X0tfTS5nZ3Vm",highlighted:`npx @huggingface/gguf my_model.gguf

<span class="hljs-comment"># or, with a remote GGUF file:</span>
<span class="hljs-comment"># npx @huggingface/gguf https://huggingface.co/bartowski/Llama-3.2-1B-Instruct-GGUF/resolve/main/Llama-3.2-1B-Instruct-Q4_K_M.gguf</span>`,wrap:!1}}),_=new c({props:{code:"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",highlighted:`* Dumping <span class="hljs-number">36</span> key/value pair(s)
  Idx | <span class="hljs-type">Count</span>  | <span class="hljs-type">Value</span>                                                                            
  ----|<span class="hljs-type">--------|----------------------------------------------------------------------------------
    1</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">version</span> = <span class="hljs-number">3</span>                                                                      
    <span class="hljs-number">2</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">tensor_count</span> = <span class="hljs-number">292</span>                                                               
    <span class="hljs-number">3</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">kv_count</span> = <span class="hljs-number">33</span>                                                                    
    <span class="hljs-number">4</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.architecture = <span class="hljs-string">&quot;llama&quot;</span>                                                   
    <span class="hljs-number">5</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.type = <span class="hljs-string">&quot;model&quot;</span>                                                           
    <span class="hljs-number">6</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.name = <span class="hljs-string">&quot;Meta Llama 3.1 8B Instruct&quot;</span>                                      
    <span class="hljs-number">7</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.finetune = <span class="hljs-string">&quot;Instruct&quot;</span>                                                    
    <span class="hljs-number">8</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.basename = <span class="hljs-string">&quot;Meta-Llama-3.1&quot;</span>                                                   

[truncated]

* Dumping <span class="hljs-number">292</span> tensor(s)
  Idx | <span class="hljs-type">Num</span> Elements | <span class="hljs-type">Shape</span>                          | <span class="hljs-type">Data</span> <span class="hljs-keyword">Type</span> | <span class="hljs-type">Name</span>                     
  ----|<span class="hljs-type">--------------|--------------------------------|-----------|--------------------------
    1</span> |           <span class="hljs-type">64</span> |     <span class="hljs-type">64</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span> | <span class="hljs-type">F32</span>       | <span class="hljs-type">rope_freqs</span>.weight        
    <span class="hljs-number">2</span> |    <span class="hljs-type">525336576</span> |   <span class="hljs-type">4096</span>, <span class="hljs-number">128256</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span> | <span class="hljs-type">Q4_K</span>      | <span class="hljs-type">token_embd</span>.weight        
    <span class="hljs-number">3</span> |         <span class="hljs-type">4096</span> |   <span class="hljs-type">4096</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span> | <span class="hljs-type">F32</span>       | <span class="hljs-type">blk</span><span class="hljs-number">.0</span>.attn_norm.weight   
    <span class="hljs-number">4</span> |     <span class="hljs-type">58720256</span> |  <span class="hljs-type">14336</span>,   <span class="hljs-number">4096</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span> | <span class="hljs-type">Q6_K</span>      | <span class="hljs-type">blk</span><span class="hljs-number">.0</span>.ffn_down.weight

[truncated]`,wrap:!1}}),z=new c({props:{code:"bnBtJTIwaSUyMC1nJTIwJTQwaHVnZ2luZ2ZhY2UlMkZnZ3VmJTBBZ2d1Zi12aWV3JTIwbXlfbW9kZWwuZ2d1Zg==",highlighted:`npm i -g @huggingface/gguf
gguf-view my_model.gguf`,wrap:!1}}),X=new m({props:{title:"Hugging Face Hub",local:"hugging-face-hub",headingTag:"h2"}}),O=new m({props:{title:"Acknowledgements & Inspirations",local:"acknowledgements--inspirations",headingTag:"h2"}}),ll=new us({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/gguf/README.md"}}),{c(){i=j("meta"),tl=t(),al=j("p"),el=t(),n(u.$$.fragment),nl=t(),n(C.$$.fragment),Jl=t(),o=j("p"),o.textContent=zl,Tl=t(),n(h.$$.fragment),yl=t(),sl=j("img"),pl=t(),A=j("p"),A.innerHTML=ql,Ul=t(),g=j("p"),g.innerHTML=Dl,jl=t(),n(d.$$.fragment),wl=t(),n(r.$$.fragment),Il=t(),n(f.$$.fragment),ml=t(),n(b.$$.fragment),il=t(),n(G.$$.fragment),cl=t(),n(Z.$$.fragment),ul=t(),n(S.$$.fragment),Cl=t(),n(B.$$.fragment),ol=t(),$=j("p"),$.innerHTML=Ol,hl=t(),n(k.$$.fragment),Al=t(),n(V.$$.fragment),gl=t(),Q=j("p"),Q.innerHTML=Pl,dl=t(),n(R.$$.fragment),rl=t(),n(Y.$$.fragment),fl=t(),E=j("p"),E.innerHTML=Kl,bl=t(),N=j("p"),N.innerHTML=ls,Gl=t(),n(L.$$.fragment),Zl=t(),n(W.$$.fragment),Sl=t(),F=j("p"),F.innerHTML=ss,Bl=t(),n(v.$$.fragment),$l=t(),H=j("p"),H.textContent=as,kl=t(),n(_.$$.fragment),Vl=t(),x=j("p"),x.innerHTML=Ms,Ql=t(),n(z.$$.fragment),Rl=t(),n(X.$$.fragment),Yl=t(),q=j("p"),q.textContent=ts,El=t(),D=j("p"),D.innerHTML=es,Nl=t(),n(O.$$.fragment),Ll=t(),P=j("ul"),P.innerHTML=ns,Wl=t(),K=j("p"),K.textContent=Js,Fl=t(),n(ll.$$.fragment),vl=t(),Ml=j("p"),this.h()},l(l){const s=ms("svelte-u9bgzb",document.head);i=w(s,"META",{name:!0,content:!0}),s.forEach(a),tl=e(l),al=w(l,"P",{}),Ts(al).forEach(a),el=e(l),J(u.$$.fragment,l),nl=e(l),J(C.$$.fragment,l),Jl=e(l),o=w(l,"P",{"data-svelte-h":!0}),I(o)!=="svelte-fetsp6"&&(o.textContent=zl),Tl=e(l),J(h.$$.fragment,l),yl=e(l),sl=w(l,"IMG",{src:!0}),pl=e(l),A=w(l,"P",{"data-svelte-h":!0}),I(A)!=="svelte-1oqo4ac"&&(A.innerHTML=ql),Ul=e(l),g=w(l,"P",{"data-svelte-h":!0}),I(g)!=="svelte-9ned1"&&(g.innerHTML=Dl),jl=e(l),J(d.$$.fragment,l),wl=e(l),J(r.$$.fragment,l),Il=e(l),J(f.$$.fragment,l),ml=e(l),J(b.$$.fragment,l),il=e(l),J(G.$$.fragment,l),cl=e(l),J(Z.$$.fragment,l),ul=e(l),J(S.$$.fragment,l),Cl=e(l),J(B.$$.fragment,l),ol=e(l),$=w(l,"P",{"data-svelte-h":!0}),I($)!=="svelte-1v5d16n"&&($.innerHTML=Ol),hl=e(l),J(k.$$.fragment,l),Al=e(l),J(V.$$.fragment,l),gl=e(l),Q=w(l,"P",{"data-svelte-h":!0}),I(Q)!=="svelte-117gony"&&(Q.innerHTML=Pl),dl=e(l),J(R.$$.fragment,l),rl=e(l),J(Y.$$.fragment,l),fl=e(l),E=w(l,"P",{"data-svelte-h":!0}),I(E)!=="svelte-mha1ue"&&(E.innerHTML=Kl),bl=e(l),N=w(l,"P",{"data-svelte-h":!0}),I(N)!=="svelte-ix27qg"&&(N.innerHTML=ls),Gl=e(l),J(L.$$.fragment,l),Zl=e(l),J(W.$$.fragment,l),Sl=e(l),F=w(l,"P",{"data-svelte-h":!0}),I(F)!=="svelte-6r7bxk"&&(F.innerHTML=ss),Bl=e(l),J(v.$$.fragment,l),$l=e(l),H=w(l,"P",{"data-svelte-h":!0}),I(H)!=="svelte-7lmy1n"&&(H.textContent=as),kl=e(l),J(_.$$.fragment,l),Vl=e(l),x=w(l,"P",{"data-svelte-h":!0}),I(x)!=="svelte-faupl"&&(x.innerHTML=Ms),Ql=e(l),J(z.$$.fragment,l),Rl=e(l),J(X.$$.fragment,l),Yl=e(l),q=w(l,"P",{"data-svelte-h":!0}),I(q)!=="svelte-3kh4"&&(q.textContent=ts),El=e(l),D=w(l,"P",{"data-svelte-h":!0}),I(D)!=="svelte-3cfra"&&(D.innerHTML=es),Nl=e(l),J(O.$$.fragment,l),Ll=e(l),P=w(l,"UL",{"data-svelte-h":!0}),I(P)!=="svelte-1n1957i"&&(P.innerHTML=ns),Wl=e(l),K=w(l,"P",{"data-svelte-h":!0}),I(K)!=="svelte-bgm0mh"&&(K.textContent=Js),Fl=e(l),J(ll.$$.fragment,l),vl=e(l),Ml=w(l,"P",{}),Ts(Ml).forEach(a),this.h()},h(){_l(i,"name","hf:doc:metadata"),_l(i,"content",os),ps(sl.src,Xl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/gguf-spec.png")||_l(sl,"src",Xl)},m(l,s){is(document.head,i),M(l,tl,s),M(l,al,s),M(l,el,s),T(u,l,s),M(l,nl,s),T(C,l,s),M(l,Jl,s),M(l,o,s),M(l,Tl,s),T(h,l,s),M(l,yl,s),M(l,sl,s),M(l,pl,s),M(l,A,s),M(l,Ul,s),M(l,g,s),M(l,jl,s),T(d,l,s),M(l,wl,s),T(r,l,s),M(l,Il,s),T(f,l,s),M(l,ml,s),T(b,l,s),M(l,il,s),T(G,l,s),M(l,cl,s),T(Z,l,s),M(l,ul,s),T(S,l,s),M(l,Cl,s),T(B,l,s),M(l,ol,s),M(l,$,s),M(l,hl,s),T(k,l,s),M(l,Al,s),T(V,l,s),M(l,gl,s),M(l,Q,s),M(l,dl,s),T(R,l,s),M(l,rl,s),T(Y,l,s),M(l,fl,s),M(l,E,s),M(l,bl,s),M(l,N,s),M(l,Gl,s),T(L,l,s),M(l,Zl,s),T(W,l,s),M(l,Sl,s),M(l,F,s),M(l,Bl,s),T(v,l,s),M(l,$l,s),M(l,H,s),M(l,kl,s),T(_,l,s),M(l,Vl,s),M(l,x,s),M(l,Ql,s),T(z,l,s),M(l,Rl,s),T(X,l,s),M(l,Yl,s),M(l,q,s),M(l,El,s),M(l,D,s),M(l,Nl,s),T(O,l,s),M(l,Ll,s),M(l,P,s),M(l,Wl,s),M(l,K,s),M(l,Fl,s),T(ll,l,s),M(l,vl,s),M(l,Ml,s),Hl=!0},p:Us,i(l){Hl||(y(u.$$.fragment,l),y(C.$$.fragment,l),y(h.$$.fragment,l),y(d.$$.fragment,l),y(r.$$.fragment,l),y(f.$$.fragment,l),y(b.$$.fragment,l),y(G.$$.fragment,l),y(Z.$$.fragment,l),y(S.$$.fragment,l),y(B.$$.fragment,l),y(k.$$.fragment,l),y(V.$$.fragment,l),y(R.$$.fragment,l),y(Y.$$.fragment,l),y(L.$$.fragment,l),y(W.$$.fragment,l),y(v.$$.fragment,l),y(_.$$.fragment,l),y(z.$$.fragment,l),y(X.$$.fragment,l),y(O.$$.fragment,l),y(ll.$$.fragment,l),Hl=!0)},o(l){p(u.$$.fragment,l),p(C.$$.fragment,l),p(h.$$.fragment,l),p(d.$$.fragment,l),p(r.$$.fragment,l),p(f.$$.fragment,l),p(b.$$.fragment,l),p(G.$$.fragment,l),p(Z.$$.fragment,l),p(S.$$.fragment,l),p(B.$$.fragment,l),p(k.$$.fragment,l),p(V.$$.fragment,l),p(R.$$.fragment,l),p(Y.$$.fragment,l),p(L.$$.fragment,l),p(W.$$.fragment,l),p(v.$$.fragment,l),p(_.$$.fragment,l),p(z.$$.fragment,l),p(X.$$.fragment,l),p(O.$$.fragment,l),p(ll.$$.fragment,l),Hl=!1},d(l){l&&(a(tl),a(al),a(el),a(nl),a(Jl),a(o),a(Tl),a(yl),a(sl),a(pl),a(A),a(Ul),a(g),a(jl),a(wl),a(Il),a(ml),a(il),a(cl),a(ul),a(Cl),a(ol),a($),a(hl),a(Al),a(gl),a(Q),a(dl),a(rl),a(fl),a(E),a(bl),a(N),a(Gl),a(Zl),a(Sl),a(F),a(Bl),a($l),a(H),a(kl),a(Vl),a(x),a(Ql),a(Rl),a(Yl),a(q),a(El),a(D),a(Nl),a(Ll),a(P),a(Wl),a(K),a(Fl),a(vl),a(Ml)),a(i),U(u,l),U(C,l),U(h,l),U(d,l),U(r,l),U(f,l),U(b,l),U(G,l),U(Z,l),U(S,l),U(B,l),U(k,l),U(V,l),U(R,l),U(Y,l),U(L,l),U(W,l),U(v,l),U(_,l),U(z,l),U(X,l),U(O,l),U(ll,l)}}}const os='{"title":"@huggingface/gguf","local":"huggingfacegguf","sections":[{"title":"Spec","local":"spec","sections":[],"depth":2},{"title":"Install","local":"install","sections":[],"depth":2},{"title":"Usage","local":"usage","sections":[{"title":"Basic usage","local":"basic-usage","sections":[],"depth":3},{"title":"Reading a local file","local":"reading-a-local-file","sections":[],"depth":3},{"title":"Typed metadata","local":"typed-metadata","sections":[],"depth":3},{"title":"Strictly typed","local":"strictly-typed","sections":[],"depth":3},{"title":"Disable strictly typed","local":"disable-strictly-typed","sections":[],"depth":3}],"depth":2},{"title":"Command line interface","local":"command-line-interface","sections":[],"depth":2},{"title":"Hugging Face Hub","local":"hugging-face-hub","sections":[],"depth":2},{"title":"Acknowledgements & Inspirations","local":"acknowledgements--inspirations","sections":[],"depth":2}],"depth":1}';function hs(xl){return js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fs extends ws{constructor(i){super(),Is(this,i,hs,Cs,ys,{})}}export{fs as component};
