import{s as sn,o as en}from"../chunks/scheduler.37c15a92.js";import{S as ln,i as nn,g as y,s as a,r as p,A as an,h,f as l,c as t,j as Kl,u as M,x as i,k as Ol,y as tn,a as n,v as r,d as m,t as j,w as u}from"../chunks/index.7cb9c9b8.js";import{Y as pn}from"../chunks/Youtube.8666c400.js";import{C as c}from"../chunks/CodeBlock.abae2786.js";import{C as Mn}from"../chunks/CourseFloatingBanner.df82c153.js";import{F as rn}from"../chunks/FrameworkSwitchCourse.97630871.js";import{H as T,E as mn}from"../chunks/getInferenceSnippets.b6a8c7d2.js";function jn(cl){let J,Ws,b,zs,o,Rs,w,Gs,U,qs,d,Ls,f,Jl="In this section, we’ll take a closer look at creating and using models. We’ll use the <code>AutoModel</code> class, which is handy when you want to instantiate any model from a checkpoint.",Ys,I,Fs,A,Tl="Let’s begin by examining what happens when we instantiate an <code>AutoModel</code>:",Ps,k,Ks,$,bl='Similar to the tokenizer, the <code>from_pretrained()</code> method will download and cache the model data from the Hugging Face Hub. As mentioned previously, the checkpoint name corresponds to a specific model architecture and weights, in this case a BERT model with a basic architecture (12 layers, 768 hidden size, 12 attention heads) and cased inputs (meaning that the uppercase/lowercase distinction is important). There are many checkpoints available on the Hub — you can explore them <a href="https://huggingface.co/models" rel="nofollow">here</a>.',Os,D,ol="The <code>AutoModel</code> class and its associates are actually simple wrappers designed to fetch the appropriate model architecture for a given checkpoint. It’s an “auto” class meaning it will guess the appropriate model architecture for you and instantiate the correct model class. However, if you know the type of model you want to use, you can use the class that defines its architecture directly:",se,g,ee,C,le,x,wl="Saving a model is as simple as saving a tokenizer. In fact, the models actually have the same <code>save_pretrained()</code> method, which saves the model’s weights and architecture configuration:",ne,E,ae,v,Ul="This will save two files to your disk:",te,Q,pe,Z,dl="If you look inside the <em>config.json</em> file, you’ll see all the necessary attributes needed to build the model architecture. This file also contains some metadata, such as where the checkpoint originated and what 🤗 Transformers version you were using when you last saved the checkpoint.",Me,S,fl="The <em>pytorch_model.safetensors</em> file is known as the state dictionary; it contains all your model’s weights. The two files work together: the configuration file is needed to know about the model architecture, while the model weights are the parameters of the model.",re,N,Il="To reuse a saved model, use the <code>from_pretrained()</code> method again:",me,V,je,_,Al='A wonderful feature of the 🤗 Transformers library is the ability to easily share models and tokenizers with the community. To do this, make sure you have an account on <a href="https://huggingface.co" rel="nofollow">Hugging Face</a>. If you’re using a notebook, you can easily log in with this:',ue,B,ye,H,kl="Otherwise, at your terminal run:",he,W,ie,z,$l="Then you can push the model to the Hub with the <code>push_to_hub()</code> method:",ce,X,Je,R,Dl="This will upload the model files to the Hub, in a repository under your namespace named <em>my-awesome-model</em>. Then, anyone can load your model with the <code>from_pretrained()</code> method!",Te,G,be,q,gl="You can do a lot more with the Hub API:",oe,L,Cl="<li>Push a model from a local repository</li> <li>Update specific files without re-uploading everything</li> <li>Add model cards to document the model’s abilities, limitations, known biases, etc.</li>",we,Y,xl='See <a href="https://huggingface.co/docs/huggingface_hub/how-to-upstream" rel="nofollow">the documentation</a> for a complete tutorial on this, or check out the advanced <a href="/course/chapter4">Chapter 4</a>.',Ue,F,de,P,El='Transformer models handle text by turning the inputs into numbers. Here we will look at exactly what happens when your text is processed by the tokenizer. We’ve already seen in <a href="/course/chapter1">Chapter 1</a> that tokenizers split the text into tokens and then convert these tokens into numbers. We can see this conversion through a simple tokenizer:',fe,K,Ie,O,Ae,ss,vl="We get a dictionary with the following fields:",ke,es,Ql="<li>input_ids: numerical representations of your tokens</li> <li>token_type_ids: these tell the model which part of the input is sentence A and which is sentence B (discussed more in the next section)</li> <li>attention_mask: this indicates which tokens should be attended to and which should not (discussed more in a bit)</li>",$e,ls,Zl="We can decode the input IDs to get back the original text:",De,ns,ge,as,Ce,ts,Sl="You’ll notice that the tokenizer has added special tokens — <code>[CLS]</code> and <code>[SEP]</code> — required by the model. Not all models need special tokens; they’re utilized when a model was pretrained with them, in which case the tokenizer needs to add them as that model expects these tokens.",xe,ps,Nl="You can encode multiple sentences at once, either by batching them together (we’ll discuss this soon) or by passing a list:",Ee,Ms,ve,rs,Qe,ms,Vl="Note that when passing multiple sentences, the tokenizer returns a list for each sentence for each dictionary value. We can also ask the tokenizer to return tensors directly from PyTorch:",Ze,js,Se,us,Ne,ys,_l="But there’s a problem: the two lists don’t have the same length! Arrays and tensors need to be rectangular, so we can’t simply convert these lists to a PyTorch tensor (or NumPy array). The tokenizer provides an option for that: padding.",Ve,hs,_e,is,Bl="If we ask the tokenizer to pad the inputs, it will make all sentences the same length by adding a special padding token to the sentences that are shorter than the longest one:",Be,cs,He,Js,We,Ts,Hl="Now we have rectangular tensors! Note that the padding tokens have been encoded into input IDs with ID 0, and they have an attention mask value of 0 as well. This is because those padding tokens shouldn’t be analyzed by the model: they’re not part of the actual sentence.",ze,bs,Xe,os,Wl="The tensors might get too big to be processed by the model. For instance, BERT was only pretrained with sequences up to 512 tokens, so it cannot process longer sequences. If you have sequences longer than the model can handle, you’ll need to truncate them with the <code>truncation</code> parameter:",Re,ws,Ge,Us,qe,ds,zl="By combining the padding and truncation arguments, you can make sure your tensors have the exact size you need:",Le,fs,Ye,Is,Fe,As,Pe,ks,Xl="Special tokens (or at least the concept of them) is particularly important to BERT and derived models. These tokens are added to better represent the sentence boundaries, such as the beginning of a sentence (<code>[CLS]</code>) or separator between sentences (<code>[SEP]</code>). Let’s look at a simple example:",Ke,$s,Oe,Ds,sl,gs,Rl="These special tokens are automatically added by the tokenizer. Not all models need special tokens; they are primarily used when a model was pretrained with them, in which case the tokenizer will add them since the model expects them.",el,Cs,ll,xs,Gl="Here’s a concrete example. Consider these encoded sequences:",nl,Es,al,vs,ql="Once tokenized, we have:",tl,Qs,pl,Zs,Ll="This is a list of encoded sequences: a list of lists. Tensors only accept rectangular shapes (think matrices). This “array” is already of rectangular shape, so converting it to a tensor is easy:",Ml,Ss,rl,Ns,ml,Vs,Yl="Making use of the tensors with the model is extremely simple — we just call the model with the inputs:",jl,_s,ul,Bs,Fl=`While the model accepts a lot of different arguments, only the input IDs are necessary. We’ll explain what the other arguments do and when they are required later,
but first we need to take a closer look at the tokenizers that build the inputs that a Transformer model can understand.`,yl,Hs,hl,Xs,il;return o=new rn({props:{fw:cl[0]}}),w=new T({props:{title:"Models",local:"the-models",headingTag:"h1"}}),U=new Mn({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter2/section3_pt.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter2/section3_pt.ipynb"}]}}),d=new pn({props:{id:"AhChOFRegn4"}}),I=new T({props:{title:"Creating a Transformer",local:"creating-a-transformer",headingTag:"h2"}}),k=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)`,wrap:!1}}),g=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQmVydE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel

model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)`,wrap:!1}}),C=new T({props:{title:"Loading and saving",local:"loading-and-saving",headingTag:"h2"}}),E=new c({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMmRpcmVjdG9yeV9vbl9teV9jb21wdXRlciUyMik=",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;directory_on_my_computer&quot;</span>)',wrap:!1}}),Q=new c({props:{code:"bHMlMjBkaXJlY3Rvcnlfb25fbXlfY29tcHV0ZXIlMEElMEFjb25maWcuanNvbiUyMG1vZGVsLnNhZmV0ZW5zb3Jz",highlighted:`ls <span class="hljs-keyword">directory_on_my_computer
</span>
<span class="hljs-built_in">config</span>.<span class="hljs-keyword">json </span>model.safetensors`,wrap:!1}}),V=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJkaXJlY3Rvcnlfb25fbXlfY29tcHV0ZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;directory_on_my_computer&quot;</span>)`,wrap:!1}}),B=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),W=new c({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),X=new c({props:{code:"bW9kZWwucHVzaF90b19odWIoJTIybXktYXdlc29tZS1tb2RlbCUyMik=",highlighted:'model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)',wrap:!1}}),G=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ5b3VyLXVzZXJuYW1lJTJGbXktYXdlc29tZS1tb2RlbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;your-username/my-awesome-model&quot;</span>)`,wrap:!1}}),F=new T({props:{title:"Encoding text",local:"encoding-text",headingTag:"h2"}}),K=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMEknbSUyMGElMjBzaW5nbGUlMjBzZW50ZW5jZSElMjIpJTBBcHJpbnQoZW5jb2RlZF9pbnB1dCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

encoded_input = tokenizer(<span class="hljs-string">&quot;Hello, I&#x27;m a single sentence!&quot;</span>)
<span class="hljs-built_in">print</span>(encoded_input)`,wrap:!1}}),O=new c({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjAlNUIxMDElMkMlMjA4NjY3JTJDJTIwMTE3JTJDJTIwMTAwMCUyQyUyMDEwNDUlMkMlMjAxMDA1JTJDJTIwMTA0OSUyQyUyMDIyMzUlMkMlMjAxNzY2MiUyQyUyMDEyMTcyJTJDJTIwMTAxMiUyQyUyMDEwMiU1RCUyQyUyMCUwQSUyMCd0b2tlbl90eXBlX2lkcyclM0ElMjAlNUIwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlNUQlMkMlMjAlMEElMjAnYXR0ZW50aW9uX21hc2snJTNBJTIwJTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVEJTdE",highlighted:`{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">8667</span>, <span class="hljs-number">117</span>, <span class="hljs-number">1000</span>, <span class="hljs-number">1045</span>, <span class="hljs-number">1005</span>, <span class="hljs-number">1049</span>, <span class="hljs-number">2235</span>, <span class="hljs-number">17662</span>, <span class="hljs-number">12172</span>, <span class="hljs-number">1012</span>, <span class="hljs-number">102</span>], 
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], 
 <span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]}`,wrap:!1}}),ns=new c({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGVkX2lucHV0JTVCJTIyaW5wdXRfaWRzJTIyJTVEKQ==",highlighted:'tokenizer.decode(encoded_input[<span class="hljs-string">&quot;input_ids&quot;</span>])',wrap:!1}}),as=new c({props:{code:"JTIyJTVCQ0xTJTVEJTIwSGVsbG8lMkMlMjBJJ20lMjBhJTIwc2luZ2xlJTIwc2VudGVuY2UhJTIwJTVCU0VQJTVEJTIy",highlighted:'<span class="hljs-string">&quot;[CLS] Hello, I&#x27;m a single sentence! [SEP]&quot;</span>',wrap:!1}}),Ms=new c({props:{code:"ZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMjJIb3clMjBhcmUlMjB5b3UlM0YlMjIlMkMlMjAlMjJJJ20lMjBmaW5lJTJDJTIwdGhhbmslMjB5b3UhJTIyKSUwQXByaW50KGVuY29kZWRfaW5wdXQp",highlighted:`encoded_input = tokenizer(<span class="hljs-string">&quot;How are you?&quot;</span>, <span class="hljs-string">&quot;I&#x27;m fine, thank you!&quot;</span>)
<span class="hljs-built_in">print</span>(encoded_input)`,wrap:!1}}),rs=new c({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjAlNUIxMDElMkMlMjAxNzMxJTJDJTIwMTEzMiUyQyUyMDExMjglMkMlMjAxMzYlMkMlMjAxMDIlMkMlMjAxNDYlMkMlMjAxMTIlMkMlMjAxODIlMkMlMjAyNTAzJTJDJTIwMTE3JTJDJTIwNjI0MyUyQyUyMDExMjglMkMlMjAxMDYlMkMlMjAxMDIlNUQlMkMlMjAndG9rZW5fdHlwZV9pZHMnJTNBJTIwJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVEJTJDJTIwJ2F0dGVudGlvbl9tYXNrJyUzQSUyMCU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSU1RCU3RA==",highlighted:'{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">1731</span>, <span class="hljs-number">1132</span>, <span class="hljs-number">1128</span>, <span class="hljs-number">136</span>, <span class="hljs-number">102</span>, <span class="hljs-number">146</span>, <span class="hljs-number">112</span>, <span class="hljs-number">182</span>, <span class="hljs-number">2503</span>, <span class="hljs-number">117</span>, <span class="hljs-number">6243</span>, <span class="hljs-number">1128</span>, <span class="hljs-number">106</span>, <span class="hljs-number">102</span>], <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>], <span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]}',wrap:!1}}),js=new c({props:{code:"ZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMjJIb3clMjBhcmUlMjB5b3UlM0YlMjIlMkMlMjAlMjJJJ20lMjBmaW5lJTJDJTIwdGhhbmslMjB5b3UhJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludChlbmNvZGVkX2lucHV0KQ==",highlighted:`encoded_input = tokenizer(<span class="hljs-string">&quot;How are you?&quot;</span>, <span class="hljs-string">&quot;I&#x27;m fine, thank you!&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(encoded_input)`,wrap:!1}}),us=new c({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjB0ZW5zb3IoJTVCJTVCJTIwMTAxJTJDJTIwMTczMSUyQyUyMDExMzIlMkMlMjAxMTI4JTJDJTIwJTIwMTM2JTJDJTIwJTIwMTAyJTJDJTIwJTIwMTQ2JTJDJTIwJTIwMTEyJTJDJTIwJTIwMTgyJTJDJTIwMjUwMyUyQyUyMCUyMDExNyUyQyUyMDYyNDMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxMTI4JTJDJTIwJTIwMTA2JTJDJTIwJTIwMTAyJTVEJTVEKSUyQyUyMCd0b2tlbl90eXBlX2lkcyclM0ElMjB0ZW5zb3IoJTVCJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVEJTVEKSUyQyUyMCdhdHRlbnRpb25fbWFzayclM0ElMjB0ZW5zb3IoJTVCJTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVEJTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;input_ids&#x27;</span>: tensor([[ <span class="hljs-number">101</span>, <span class="hljs-number">1731</span>, <span class="hljs-number">1132</span>, <span class="hljs-number">1128</span>,  <span class="hljs-number">136</span>,  <span class="hljs-number">102</span>,  <span class="hljs-number">146</span>,  <span class="hljs-number">112</span>,  <span class="hljs-number">182</span>, <span class="hljs-number">2503</span>,  <span class="hljs-number">117</span>, <span class="hljs-number">6243</span>,
         <span class="hljs-number">1128</span>,  <span class="hljs-number">106</span>,  <span class="hljs-number">102</span>]]), <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: tensor([[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]), <span class="hljs-string">&#x27;attention_mask&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]])}`,wrap:!1}}),hs=new T({props:{title:"Padding inputs",local:"padding-inputs",headingTag:"h3"}}),cs=new c({props:{code:"ZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjJIb3clMjBhcmUlMjB5b3UlM0YlMjIlMkMlMjAlMjJJJ20lMjBmaW5lJTJDJTIwdGhhbmslMjB5b3UhJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQXByaW50KGVuY29kZWRfaW5wdXQp",highlighted:`encoded_input = tokenizer(
    [<span class="hljs-string">&quot;How are you?&quot;</span>, <span class="hljs-string">&quot;I&#x27;m fine, thank you!&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
)
<span class="hljs-built_in">print</span>(encoded_input)`,wrap:!1}}),Js=new c({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjB0ZW5zb3IoJTVCJTVCJTIwJTIwMTAxJTJDJTIwJTIwMTczMSUyQyUyMCUyMDExMzIlMkMlMjAlMjAxMTI4JTJDJTIwJTIwJTIwMTM2JTJDJTIwJTIwJTIwMTAyJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMCUyMDEwMSUyQyUyMCUyMDEwNDUlMkMlMjAlMjAxMDA1JTJDJTIwJTIwMTA0OSUyQyUyMCUyMDI1MDMlMkMlMjAlMjAlMjAxMTclMkMlMjAlMjA1NzYzJTJDJTIwJTIwMTEyOCUyQyUyMCUyMCUyMDEzNiUyQyUyMCUyMCUyMDEwMiU1RCU1RCklMkMlMjAlMEElMjAndG9rZW5fdHlwZV9pZHMnJTNBJTIwdGVuc29yKCU1QiU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTVEJTVEKSUyQyUyMCUwQSUyMCdhdHRlbnRpb25fbWFzayclM0ElMjB0ZW5zb3IoJTVCJTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElNUQlNUQpJTdE",highlighted:`{<span class="hljs-string">&#x27;input_ids&#x27;</span>: tensor([[  <span class="hljs-number">101</span>,  <span class="hljs-number">1731</span>,  <span class="hljs-number">1132</span>,  <span class="hljs-number">1128</span>,   <span class="hljs-number">136</span>,   <span class="hljs-number">102</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>],
         [  <span class="hljs-number">101</span>,  <span class="hljs-number">1045</span>,  <span class="hljs-number">1005</span>,  <span class="hljs-number">1049</span>,  <span class="hljs-number">2503</span>,   <span class="hljs-number">117</span>,  <span class="hljs-number">5763</span>,  <span class="hljs-number">1128</span>,   <span class="hljs-number">136</span>,   <span class="hljs-number">102</span>]]), 
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: tensor([[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
         [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]]), 
 <span class="hljs-string">&#x27;attention_mask&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]])}`,wrap:!1}}),bs=new T({props:{title:"Truncating inputs",local:"truncating-inputs",headingTag:"h3"}}),ws=new c({props:{code:"ZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBhJTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMGxvbmclMjBzZW50ZW5jZS4lMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUwQSklMEFwcmludChlbmNvZGVkX2lucHV0JTVCJTIyaW5wdXRfaWRzJTIyJTVEKQ==",highlighted:`encoded_input = tokenizer(
    <span class="hljs-string">&quot;This is a very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very long sentence.&quot;</span>,
    truncation=<span class="hljs-literal">True</span>,
)
<span class="hljs-built_in">print</span>(encoded_input[<span class="hljs-string">&quot;input_ids&quot;</span>])`,wrap:!1}}),Us=new c({props:{code:"JTVCMTAxJTJDJTIwMTE4OCUyQyUyMDExMTAlMkMlMjAxNzAlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTE3OSUyQyUyMDU2NTAlMkMlMjAxMTklMkMlMjAxMDIlNUQ=",highlighted:'[<span class="hljs-number">101</span>, <span class="hljs-number">1188</span>, <span class="hljs-number">1110</span>, <span class="hljs-number">170</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1179</span>, <span class="hljs-number">5650</span>, <span class="hljs-number">119</span>, <span class="hljs-number">102</span>]',wrap:!1}}),fs=new c({props:{code:"ZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjJIb3clMjBhcmUlMjB5b3UlM0YlMjIlMkMlMjAlMjJJJ20lMjBmaW5lJTJDJTIwdGhhbmslMjB5b3UhJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9sZW5ndGglM0Q1JTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFwcmludChlbmNvZGVkX2lucHV0KQ==",highlighted:`encoded_input = tokenizer(
    [<span class="hljs-string">&quot;How are you?&quot;</span>, <span class="hljs-string">&quot;I&#x27;m fine, thank you!&quot;</span>],
    padding=<span class="hljs-literal">True</span>,
    truncation=<span class="hljs-literal">True</span>,
    max_length=<span class="hljs-number">5</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
<span class="hljs-built_in">print</span>(encoded_input)`,wrap:!1}}),Is=new c({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjB0ZW5zb3IoJTVCJTVCJTIwJTIwMTAxJTJDJTIwJTIwMTczMSUyQyUyMCUyMDExMzIlMkMlMjAlMjAxMTI4JTJDJTIwJTIwJTIwMTAyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTIwJTIwMTAxJTJDJTIwJTIwMTA0NSUyQyUyMCUyMDEwMDUlMkMlMjAlMjAxMDQ5JTJDJTIwJTIwJTIwMTAyJTVEJTVEKSUyQyUyMCUwQSUyMCd0b2tlbl90eXBlX2lkcyclM0ElMjB0ZW5zb3IoJTVCJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCU1RCU1RCklMkMlMjAlMEElMjAnYXR0ZW50aW9uX21hc2snJTNBJTIwdGVuc29yKCU1QiU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElNUQlNUQpJTdE",highlighted:`{<span class="hljs-string">&#x27;input_ids&#x27;</span>: tensor([[  <span class="hljs-number">101</span>,  <span class="hljs-number">1731</span>,  <span class="hljs-number">1132</span>,  <span class="hljs-number">1128</span>,   <span class="hljs-number">102</span>],
         [  <span class="hljs-number">101</span>,  <span class="hljs-number">1045</span>,  <span class="hljs-number">1005</span>,  <span class="hljs-number">1049</span>,   <span class="hljs-number">102</span>]]), 
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: tensor([[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
         [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]]), 
 <span class="hljs-string">&#x27;attention_mask&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]])}`,wrap:!1}}),As=new T({props:{title:"Adding special tokens",local:"adding-special-tokens",headingTag:"h3"}}),$s=new c({props:{code:"ZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMjJIb3clMjBhcmUlMjB5b3UlM0YlMjIpJTBBcHJpbnQoZW5jb2RlZF9pbnB1dCU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEF0b2tlbml6ZXIuZGVjb2RlKGVuY29kZWRfaW5wdXQlNUIlMjJpbnB1dF9pZHMlMjIlNUQp",highlighted:`encoded_input = tokenizer(<span class="hljs-string">&quot;How are you?&quot;</span>)
<span class="hljs-built_in">print</span>(encoded_input[<span class="hljs-string">&quot;input_ids&quot;</span>])
tokenizer.decode(encoded_input[<span class="hljs-string">&quot;input_ids&quot;</span>])`,wrap:!1}}),Ds=new c({props:{code:"JTVCMTAxJTJDJTIwMTczMSUyQyUyMDExMzIlMkMlMjAxMTI4JTJDJTIwMTM2JTJDJTIwMTAyJTVEJTBBJyU1QkNMUyU1RCUyMEhvdyUyMGFyZSUyMHlvdSUzRiUyMCU1QlNFUCU1RCc=",highlighted:`[<span class="hljs-number">101</span>, <span class="hljs-number">1731</span>, <span class="hljs-number">1132</span>, <span class="hljs-number">1128</span>, <span class="hljs-number">136</span>, <span class="hljs-number">102</span>]
<span class="hljs-string">&#x27;[CLS] How are you? [SEP]&#x27;</span>`,wrap:!1}}),Cs=new T({props:{title:"Why is all of this necessary?",local:"why-is-all-of-this-necessary",headingTag:"h3"}}),Es=new c({props:{code:"c2VxdWVuY2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIySSd2ZSUyMGJlZW4lMjB3YWl0aW5nJTIwZm9yJTIwYSUyMEh1Z2dpbmdGYWNlJTIwY291cnNlJTIwbXklMjB3aG9sZSUyMGxpZmUuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySSUyMGhhdGUlMjB0aGlzJTIwc28lMjBtdWNoISUyMiUyQyUwQSU1RA==",highlighted:`sequences = [
    <span class="hljs-string">&quot;I&#x27;ve been waiting for a HuggingFace course my whole life.&quot;</span>,
    <span class="hljs-string">&quot;I hate this so much!&quot;</span>,
]`,wrap:!1}}),Qs=new c({props:{code:"ZW5jb2RlZF9zZXF1ZW5jZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxMDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxMDQ1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTAwNSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIzMTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyMDQyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMzQwMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIwMDUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxMDM3JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTc2NjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxMjE3MiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDI2MDclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyMDI2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMjg3OCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIxNjYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxMDEyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTAyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVCMTAxJTJDJTIwMTA0NSUyQyUyMDUyMjMlMkMlMjAyMDIzJTJDJTIwMjA2MSUyQyUyMDIxNzIlMkMlMjA5OTklMkMlMjAxMDIlNUQlMkMlMEElNUQ=",highlighted:`encoded_sequences = [
    [
        <span class="hljs-number">101</span>,
        <span class="hljs-number">1045</span>,
        <span class="hljs-number">1005</span>,
        <span class="hljs-number">2310</span>,
        <span class="hljs-number">2042</span>,
        <span class="hljs-number">3403</span>,
        <span class="hljs-number">2005</span>,
        <span class="hljs-number">1037</span>,
        <span class="hljs-number">17662</span>,
        <span class="hljs-number">12172</span>,
        <span class="hljs-number">2607</span>,
        <span class="hljs-number">2026</span>,
        <span class="hljs-number">2878</span>,
        <span class="hljs-number">2166</span>,
        <span class="hljs-number">1012</span>,
        <span class="hljs-number">102</span>,
    ],
    [<span class="hljs-number">101</span>, <span class="hljs-number">1045</span>, <span class="hljs-number">5223</span>, <span class="hljs-number">2023</span>, <span class="hljs-number">2061</span>, <span class="hljs-number">2172</span>, <span class="hljs-number">999</span>, <span class="hljs-number">102</span>],
]`,wrap:!1}}),Ss=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoZW5jb2RlZF9zZXF1ZW5jZXMp",highlighted:`<span class="hljs-keyword">import</span> torch

model_inputs = torch.tensor(encoded_sequences)`,wrap:!1}}),Ns=new T({props:{title:"Using the tensors as inputs to the model",local:"using-the-tensors-as-inputs-to-the-model",headingTag:"h3"}}),_s=new c({props:{code:"b3V0cHV0JTIwJTNEJTIwbW9kZWwobW9kZWxfaW5wdXRzKQ==",highlighted:"output = model(model_inputs)",wrap:!1}}),Hs=new mn({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter2/3.mdx"}}),{c(){J=y("meta"),Ws=a(),b=y("p"),zs=a(),p(o.$$.fragment),Rs=a(),p(w.$$.fragment),Gs=a(),p(U.$$.fragment),qs=a(),p(d.$$.fragment),Ls=a(),f=y("p"),f.innerHTML=Jl,Ys=a(),p(I.$$.fragment),Fs=a(),A=y("p"),A.innerHTML=Tl,Ps=a(),p(k.$$.fragment),Ks=a(),$=y("p"),$.innerHTML=bl,Os=a(),D=y("p"),D.innerHTML=ol,se=a(),p(g.$$.fragment),ee=a(),p(C.$$.fragment),le=a(),x=y("p"),x.innerHTML=wl,ne=a(),p(E.$$.fragment),ae=a(),v=y("p"),v.textContent=Ul,te=a(),p(Q.$$.fragment),pe=a(),Z=y("p"),Z.innerHTML=dl,Me=a(),S=y("p"),S.innerHTML=fl,re=a(),N=y("p"),N.innerHTML=Il,me=a(),p(V.$$.fragment),je=a(),_=y("p"),_.innerHTML=Al,ue=a(),p(B.$$.fragment),ye=a(),H=y("p"),H.textContent=kl,he=a(),p(W.$$.fragment),ie=a(),z=y("p"),z.innerHTML=$l,ce=a(),p(X.$$.fragment),Je=a(),R=y("p"),R.innerHTML=Dl,Te=a(),p(G.$$.fragment),be=a(),q=y("p"),q.textContent=gl,oe=a(),L=y("ul"),L.innerHTML=Cl,we=a(),Y=y("p"),Y.innerHTML=xl,Ue=a(),p(F.$$.fragment),de=a(),P=y("p"),P.innerHTML=El,fe=a(),p(K.$$.fragment),Ie=a(),p(O.$$.fragment),Ae=a(),ss=y("p"),ss.textContent=vl,ke=a(),es=y("ul"),es.innerHTML=Ql,$e=a(),ls=y("p"),ls.textContent=Zl,De=a(),p(ns.$$.fragment),ge=a(),p(as.$$.fragment),Ce=a(),ts=y("p"),ts.innerHTML=Sl,xe=a(),ps=y("p"),ps.textContent=Nl,Ee=a(),p(Ms.$$.fragment),ve=a(),p(rs.$$.fragment),Qe=a(),ms=y("p"),ms.textContent=Vl,Ze=a(),p(js.$$.fragment),Se=a(),p(us.$$.fragment),Ne=a(),ys=y("p"),ys.textContent=_l,Ve=a(),p(hs.$$.fragment),_e=a(),is=y("p"),is.textContent=Bl,Be=a(),p(cs.$$.fragment),He=a(),p(Js.$$.fragment),We=a(),Ts=y("p"),Ts.textContent=Hl,ze=a(),p(bs.$$.fragment),Xe=a(),os=y("p"),os.innerHTML=Wl,Re=a(),p(ws.$$.fragment),Ge=a(),p(Us.$$.fragment),qe=a(),ds=y("p"),ds.textContent=zl,Le=a(),p(fs.$$.fragment),Ye=a(),p(Is.$$.fragment),Fe=a(),p(As.$$.fragment),Pe=a(),ks=y("p"),ks.innerHTML=Xl,Ke=a(),p($s.$$.fragment),Oe=a(),p(Ds.$$.fragment),sl=a(),gs=y("p"),gs.textContent=Rl,el=a(),p(Cs.$$.fragment),ll=a(),xs=y("p"),xs.textContent=Gl,nl=a(),p(Es.$$.fragment),al=a(),vs=y("p"),vs.textContent=ql,tl=a(),p(Qs.$$.fragment),pl=a(),Zs=y("p"),Zs.textContent=Ll,Ml=a(),p(Ss.$$.fragment),rl=a(),p(Ns.$$.fragment),ml=a(),Vs=y("p"),Vs.textContent=Yl,jl=a(),p(_s.$$.fragment),ul=a(),Bs=y("p"),Bs.textContent=Fl,yl=a(),p(Hs.$$.fragment),hl=a(),Xs=y("p"),this.h()},l(s){const e=an("svelte-u9bgzb",document.head);J=h(e,"META",{name:!0,content:!0}),e.forEach(l),Ws=t(s),b=h(s,"P",{}),Kl(b).forEach(l),zs=t(s),M(o.$$.fragment,s),Rs=t(s),M(w.$$.fragment,s),Gs=t(s),M(U.$$.fragment,s),qs=t(s),M(d.$$.fragment,s),Ls=t(s),f=h(s,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1nloweu"&&(f.innerHTML=Jl),Ys=t(s),M(I.$$.fragment,s),Fs=t(s),A=h(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-17aypug"&&(A.innerHTML=Tl),Ps=t(s),M(k.$$.fragment,s),Ks=t(s),$=h(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-1rqsf14"&&($.innerHTML=bl),Os=t(s),D=h(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-gay9y4"&&(D.innerHTML=ol),se=t(s),M(g.$$.fragment,s),ee=t(s),M(C.$$.fragment,s),le=t(s),x=h(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-hdwas9"&&(x.innerHTML=wl),ne=t(s),M(E.$$.fragment,s),ae=t(s),v=h(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1mevt8f"&&(v.textContent=Ul),te=t(s),M(Q.$$.fragment,s),pe=t(s),Z=h(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1dlg86"&&(Z.innerHTML=dl),Me=t(s),S=h(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1lituvv"&&(S.innerHTML=fl),re=t(s),N=h(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1h4c2vc"&&(N.innerHTML=Il),me=t(s),M(V.$$.fragment,s),je=t(s),_=h(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-ddgh4s"&&(_.innerHTML=Al),ue=t(s),M(B.$$.fragment,s),ye=t(s),H=h(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-l3oiw9"&&(H.textContent=kl),he=t(s),M(W.$$.fragment,s),ie=t(s),z=h(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1pzfpy5"&&(z.innerHTML=$l),ce=t(s),M(X.$$.fragment,s),Je=t(s),R=h(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1nxdobe"&&(R.innerHTML=Dl),Te=t(s),M(G.$$.fragment,s),be=t(s),q=h(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1wh37ph"&&(q.textContent=gl),oe=t(s),L=h(s,"UL",{"data-svelte-h":!0}),i(L)!=="svelte-103qsj1"&&(L.innerHTML=Cl),we=t(s),Y=h(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1ml54wi"&&(Y.innerHTML=xl),Ue=t(s),M(F.$$.fragment,s),de=t(s),P=h(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1i2mfbj"&&(P.innerHTML=El),fe=t(s),M(K.$$.fragment,s),Ie=t(s),M(O.$$.fragment,s),Ae=t(s),ss=h(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-mgm01i"&&(ss.textContent=vl),ke=t(s),es=h(s,"UL",{"data-svelte-h":!0}),i(es)!=="svelte-1n80xkj"&&(es.innerHTML=Ql),$e=t(s),ls=h(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-954hsi"&&(ls.textContent=Zl),De=t(s),M(ns.$$.fragment,s),ge=t(s),M(as.$$.fragment,s),Ce=t(s),ts=h(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-w3oug8"&&(ts.innerHTML=Sl),xe=t(s),ps=h(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-kdmifw"&&(ps.textContent=Nl),Ee=t(s),M(Ms.$$.fragment,s),ve=t(s),M(rs.$$.fragment,s),Qe=t(s),ms=h(s,"P",{"data-svelte-h":!0}),i(ms)!=="svelte-zcnpfw"&&(ms.textContent=Vl),Ze=t(s),M(js.$$.fragment,s),Se=t(s),M(us.$$.fragment,s),Ne=t(s),ys=h(s,"P",{"data-svelte-h":!0}),i(ys)!=="svelte-1jvf30l"&&(ys.textContent=_l),Ve=t(s),M(hs.$$.fragment,s),_e=t(s),is=h(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-1frpdsp"&&(is.textContent=Bl),Be=t(s),M(cs.$$.fragment,s),He=t(s),M(Js.$$.fragment,s),We=t(s),Ts=h(s,"P",{"data-svelte-h":!0}),i(Ts)!=="svelte-1dmy5z2"&&(Ts.textContent=Hl),ze=t(s),M(bs.$$.fragment,s),Xe=t(s),os=h(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-1jolo2s"&&(os.innerHTML=Wl),Re=t(s),M(ws.$$.fragment,s),Ge=t(s),M(Us.$$.fragment,s),qe=t(s),ds=h(s,"P",{"data-svelte-h":!0}),i(ds)!=="svelte-48hc6q"&&(ds.textContent=zl),Le=t(s),M(fs.$$.fragment,s),Ye=t(s),M(Is.$$.fragment,s),Fe=t(s),M(As.$$.fragment,s),Pe=t(s),ks=h(s,"P",{"data-svelte-h":!0}),i(ks)!=="svelte-1mklzwf"&&(ks.innerHTML=Xl),Ke=t(s),M($s.$$.fragment,s),Oe=t(s),M(Ds.$$.fragment,s),sl=t(s),gs=h(s,"P",{"data-svelte-h":!0}),i(gs)!=="svelte-2judgi"&&(gs.textContent=Rl),el=t(s),M(Cs.$$.fragment,s),ll=t(s),xs=h(s,"P",{"data-svelte-h":!0}),i(xs)!=="svelte-zezeea"&&(xs.textContent=Gl),nl=t(s),M(Es.$$.fragment,s),al=t(s),vs=h(s,"P",{"data-svelte-h":!0}),i(vs)!=="svelte-k5jj6q"&&(vs.textContent=ql),tl=t(s),M(Qs.$$.fragment,s),pl=t(s),Zs=h(s,"P",{"data-svelte-h":!0}),i(Zs)!=="svelte-y3q2fn"&&(Zs.textContent=Ll),Ml=t(s),M(Ss.$$.fragment,s),rl=t(s),M(Ns.$$.fragment,s),ml=t(s),Vs=h(s,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-1et2den"&&(Vs.textContent=Yl),jl=t(s),M(_s.$$.fragment,s),ul=t(s),Bs=h(s,"P",{"data-svelte-h":!0}),i(Bs)!=="svelte-1suqc52"&&(Bs.textContent=Fl),yl=t(s),M(Hs.$$.fragment,s),hl=t(s),Xs=h(s,"P",{}),Kl(Xs).forEach(l),this.h()},h(){Ol(J,"name","hf:doc:metadata"),Ol(J,"content",un)},m(s,e){tn(document.head,J),n(s,Ws,e),n(s,b,e),n(s,zs,e),r(o,s,e),n(s,Rs,e),r(w,s,e),n(s,Gs,e),r(U,s,e),n(s,qs,e),r(d,s,e),n(s,Ls,e),n(s,f,e),n(s,Ys,e),r(I,s,e),n(s,Fs,e),n(s,A,e),n(s,Ps,e),r(k,s,e),n(s,Ks,e),n(s,$,e),n(s,Os,e),n(s,D,e),n(s,se,e),r(g,s,e),n(s,ee,e),r(C,s,e),n(s,le,e),n(s,x,e),n(s,ne,e),r(E,s,e),n(s,ae,e),n(s,v,e),n(s,te,e),r(Q,s,e),n(s,pe,e),n(s,Z,e),n(s,Me,e),n(s,S,e),n(s,re,e),n(s,N,e),n(s,me,e),r(V,s,e),n(s,je,e),n(s,_,e),n(s,ue,e),r(B,s,e),n(s,ye,e),n(s,H,e),n(s,he,e),r(W,s,e),n(s,ie,e),n(s,z,e),n(s,ce,e),r(X,s,e),n(s,Je,e),n(s,R,e),n(s,Te,e),r(G,s,e),n(s,be,e),n(s,q,e),n(s,oe,e),n(s,L,e),n(s,we,e),n(s,Y,e),n(s,Ue,e),r(F,s,e),n(s,de,e),n(s,P,e),n(s,fe,e),r(K,s,e),n(s,Ie,e),r(O,s,e),n(s,Ae,e),n(s,ss,e),n(s,ke,e),n(s,es,e),n(s,$e,e),n(s,ls,e),n(s,De,e),r(ns,s,e),n(s,ge,e),r(as,s,e),n(s,Ce,e),n(s,ts,e),n(s,xe,e),n(s,ps,e),n(s,Ee,e),r(Ms,s,e),n(s,ve,e),r(rs,s,e),n(s,Qe,e),n(s,ms,e),n(s,Ze,e),r(js,s,e),n(s,Se,e),r(us,s,e),n(s,Ne,e),n(s,ys,e),n(s,Ve,e),r(hs,s,e),n(s,_e,e),n(s,is,e),n(s,Be,e),r(cs,s,e),n(s,He,e),r(Js,s,e),n(s,We,e),n(s,Ts,e),n(s,ze,e),r(bs,s,e),n(s,Xe,e),n(s,os,e),n(s,Re,e),r(ws,s,e),n(s,Ge,e),r(Us,s,e),n(s,qe,e),n(s,ds,e),n(s,Le,e),r(fs,s,e),n(s,Ye,e),r(Is,s,e),n(s,Fe,e),r(As,s,e),n(s,Pe,e),n(s,ks,e),n(s,Ke,e),r($s,s,e),n(s,Oe,e),r(Ds,s,e),n(s,sl,e),n(s,gs,e),n(s,el,e),r(Cs,s,e),n(s,ll,e),n(s,xs,e),n(s,nl,e),r(Es,s,e),n(s,al,e),n(s,vs,e),n(s,tl,e),r(Qs,s,e),n(s,pl,e),n(s,Zs,e),n(s,Ml,e),r(Ss,s,e),n(s,rl,e),r(Ns,s,e),n(s,ml,e),n(s,Vs,e),n(s,jl,e),r(_s,s,e),n(s,ul,e),n(s,Bs,e),n(s,yl,e),r(Hs,s,e),n(s,hl,e),n(s,Xs,e),il=!0},p(s,[e]){const Pl={};e&1&&(Pl.fw=s[0]),o.$set(Pl)},i(s){il||(m(o.$$.fragment,s),m(w.$$.fragment,s),m(U.$$.fragment,s),m(d.$$.fragment,s),m(I.$$.fragment,s),m(k.$$.fragment,s),m(g.$$.fragment,s),m(C.$$.fragment,s),m(E.$$.fragment,s),m(Q.$$.fragment,s),m(V.$$.fragment,s),m(B.$$.fragment,s),m(W.$$.fragment,s),m(X.$$.fragment,s),m(G.$$.fragment,s),m(F.$$.fragment,s),m(K.$$.fragment,s),m(O.$$.fragment,s),m(ns.$$.fragment,s),m(as.$$.fragment,s),m(Ms.$$.fragment,s),m(rs.$$.fragment,s),m(js.$$.fragment,s),m(us.$$.fragment,s),m(hs.$$.fragment,s),m(cs.$$.fragment,s),m(Js.$$.fragment,s),m(bs.$$.fragment,s),m(ws.$$.fragment,s),m(Us.$$.fragment,s),m(fs.$$.fragment,s),m(Is.$$.fragment,s),m(As.$$.fragment,s),m($s.$$.fragment,s),m(Ds.$$.fragment,s),m(Cs.$$.fragment,s),m(Es.$$.fragment,s),m(Qs.$$.fragment,s),m(Ss.$$.fragment,s),m(Ns.$$.fragment,s),m(_s.$$.fragment,s),m(Hs.$$.fragment,s),il=!0)},o(s){j(o.$$.fragment,s),j(w.$$.fragment,s),j(U.$$.fragment,s),j(d.$$.fragment,s),j(I.$$.fragment,s),j(k.$$.fragment,s),j(g.$$.fragment,s),j(C.$$.fragment,s),j(E.$$.fragment,s),j(Q.$$.fragment,s),j(V.$$.fragment,s),j(B.$$.fragment,s),j(W.$$.fragment,s),j(X.$$.fragment,s),j(G.$$.fragment,s),j(F.$$.fragment,s),j(K.$$.fragment,s),j(O.$$.fragment,s),j(ns.$$.fragment,s),j(as.$$.fragment,s),j(Ms.$$.fragment,s),j(rs.$$.fragment,s),j(js.$$.fragment,s),j(us.$$.fragment,s),j(hs.$$.fragment,s),j(cs.$$.fragment,s),j(Js.$$.fragment,s),j(bs.$$.fragment,s),j(ws.$$.fragment,s),j(Us.$$.fragment,s),j(fs.$$.fragment,s),j(Is.$$.fragment,s),j(As.$$.fragment,s),j($s.$$.fragment,s),j(Ds.$$.fragment,s),j(Cs.$$.fragment,s),j(Es.$$.fragment,s),j(Qs.$$.fragment,s),j(Ss.$$.fragment,s),j(Ns.$$.fragment,s),j(_s.$$.fragment,s),j(Hs.$$.fragment,s),il=!1},d(s){s&&(l(Ws),l(b),l(zs),l(Rs),l(Gs),l(qs),l(Ls),l(f),l(Ys),l(Fs),l(A),l(Ps),l(Ks),l($),l(Os),l(D),l(se),l(ee),l(le),l(x),l(ne),l(ae),l(v),l(te),l(pe),l(Z),l(Me),l(S),l(re),l(N),l(me),l(je),l(_),l(ue),l(ye),l(H),l(he),l(ie),l(z),l(ce),l(Je),l(R),l(Te),l(be),l(q),l(oe),l(L),l(we),l(Y),l(Ue),l(de),l(P),l(fe),l(Ie),l(Ae),l(ss),l(ke),l(es),l($e),l(ls),l(De),l(ge),l(Ce),l(ts),l(xe),l(ps),l(Ee),l(ve),l(Qe),l(ms),l(Ze),l(Se),l(Ne),l(ys),l(Ve),l(_e),l(is),l(Be),l(He),l(We),l(Ts),l(ze),l(Xe),l(os),l(Re),l(Ge),l(qe),l(ds),l(Le),l(Ye),l(Fe),l(Pe),l(ks),l(Ke),l(Oe),l(sl),l(gs),l(el),l(ll),l(xs),l(nl),l(al),l(vs),l(tl),l(pl),l(Zs),l(Ml),l(rl),l(ml),l(Vs),l(jl),l(ul),l(Bs),l(yl),l(hl),l(Xs)),l(J),u(o,s),u(w,s),u(U,s),u(d,s),u(I,s),u(k,s),u(g,s),u(C,s),u(E,s),u(Q,s),u(V,s),u(B,s),u(W,s),u(X,s),u(G,s),u(F,s),u(K,s),u(O,s),u(ns,s),u(as,s),u(Ms,s),u(rs,s),u(js,s),u(us,s),u(hs,s),u(cs,s),u(Js,s),u(bs,s),u(ws,s),u(Us,s),u(fs,s),u(Is,s),u(As,s),u($s,s),u(Ds,s),u(Cs,s),u(Es,s),u(Qs,s),u(Ss,s),u(Ns,s),u(_s,s),u(Hs,s)}}}const un='{"title":"Models","local":"the-models","sections":[{"title":"Creating a Transformer","local":"creating-a-transformer","sections":[],"depth":2},{"title":"Loading and saving","local":"loading-and-saving","sections":[],"depth":2},{"title":"Encoding text","local":"encoding-text","sections":[{"title":"Padding inputs","local":"padding-inputs","sections":[],"depth":3},{"title":"Truncating inputs","local":"truncating-inputs","sections":[],"depth":3},{"title":"Adding special tokens","local":"adding-special-tokens","sections":[],"depth":3},{"title":"Why is all of this necessary?","local":"why-is-all-of-this-necessary","sections":[],"depth":3},{"title":"Using the tensors as inputs to the model","local":"using-the-tensors-as-inputs-to-the-model","sections":[],"depth":3}],"depth":2}],"depth":1}';function yn(cl,J,Ws){let b="pt";return en(()=>{const zs=new URLSearchParams(window.location.search);Ws(0,b=zs.get("fw")||"pt")}),[b]}class Un extends ln{constructor(J){super(),nn(this,J,yn,jn,sn,{})}}export{Un as component};
