import{s as ve,o as Xe,n as Ee}from"../chunks/scheduler.65852ee5.js";import{S as Ne,i as Ve,g as M,s as a,r,A as Qe,h as o,f as e,c as n,j as Re,u as p,x as i,k as We,y as He,a as s,v as c,d as y,t as d,w as j}from"../chunks/index.aa74147d.js";import{T as Ye}from"../chunks/Tip.bb8ccac8.js";import{D as _e,C as h}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as w,E as Fe}from"../chunks/EditOnGithub.4eda6a96.js";function Se(Xl){let J,U="The code below will be updated once the Inference API recipe is finished.";return{c(){J=M("p"),J.textContent=U},l(T){J=o(T,"P",{"data-svelte-h":!0}),i(J)!=="svelte-1b5x1p8"&&(J.textContent=U)},m(T,Wl){s(T,J,Wl)},p:Ee,d(T){T&&e(J)}}}function xe(Xl){let J,U,T,Wl,m,El,I,Nl,b,Dt='<em>Authored by: <a href="https://huggingface.co/MoritzLaurer" rel="nofollow">Moritz Laurer</a></em>',Vl,g,Pt="This notebook illustrates the workflow for systematically evaluating LLM outputs and creating LLM training data. You can start by using this notebook to evaluate the zero-shot performance of your favorite LLM on your task without any fine-tuning. If you want to improve performance, you can then easily reuse this workflow to create training data.",Ql,f,Kt="<strong>Example use case: code generation.</strong> In this tutorial, we demonstrate how to create high-quality test and train data for code generation tasks. The same workflow can, however, be adapted to any other task relevant to your specific use case.",Hl,C,Ot="<strong>In this notebook, we:</strong>",Yl,A,le="<li>Download data for the example task.</li> <li>Prompt two LLMs to respond to these tasks. This results in “synthetic data” to speed up manual data creation.</li> <li>Create an Argilla annotation interface on HF Spaces to compare and evaluate the outputs from the two LLMs.</li> <li>Upload the example data and the zero-shot LLM responses into the Argilla annotation interface.</li> <li>Download the annotated data.</li>",_l,B,te="You can adapt this notebook to your needs, e.g., using a different LLM and API provider for step (2) or adapting the annotation task in step (3).",Fl,G,Sl,Z,xl,k,zl,R,$l,W,ee='First, we download an example dataset containing LLMs’ code generation tasks. We want to evaluate how well two different LLMs perform on these code-generation tasks. We use instructions from the <a href="https://huggingface.co/datasets/bigcode/self-oss-instruct-sc2-exec-filter-50k" rel="nofollow">bigcode/self-oss-instruct-sc2-exec-filter-50k</a> dataset that was used to train the <a href="https://huggingface.co/bigcode/starcoder2-15b-instruct-v0.1" rel="nofollow">StarCoder2-Instruct</a> model.',ql,v,Ll,X,se="Dataset structure:\n Dataset(&#123;\n    features: ['fingerprint', 'sha1', 'seed', 'response', 'concepts', 'prompt', 'instruction', 'id'],\n    num_rows: 3\n}) \n\nExample instructions:\n ['Write a Python function named `get_value` that takes a matrix (represented by a list of lists) and a tuple of indices, and returns the value at that index in the matrix. The function should handle index out of range errors by returning None.', 'Write a Python function `check_collision` that takes a list of `rectangles` as input and checks if there are any collisions between any two rectangles. A rectangle is represented as a tuple (x, y, w, h) where (x, y) is the top-left corner of the rectangle, `w` is the width, and `h` is the height.\\n\\nThe function should return True if any pair of rectangles collide, and False otherwise. Use an iterative approach and check for collisions based on the bounding box collision detection algorithm. If a collision is found, return True immediately without checking for more collisions.']\n",Dl,E,Pl,N,Kl,V,ae='Before sending the instructions to an LLM API, we need to format the instructions with the correct <code>chat_template</code> for each of the models we want to evaluate. This essentially entails wrapping some special tokens around the instructions. See the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">docs</a> on chat templates for details.',Ol,Q,lt,H,ne=`First prompt formatted for mistralai/Mixtral-8x7B-Instruct-v0.1:

 <s>[INST] Write a Python function named \`get_value\` that takes a matrix (represented by a list of lists) and a tuple of indices, and returns the value at that index in the matrix. The function should handle index out of range errors by returning None. [/INST] 


First prompt formatted for meta-llama/Meta-Llama-3-70B-Instruct:

 &lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;

Write a Python function named \`get_value\` that takes a matrix (represented by a list of lists) and a tuple of indices, and returns the value at that index in the matrix. The function should handle index out of range errors by returning None.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
</s>`,tt,Y,et,_,Me='Now, we can send the instructions to the APIs for both LLMs to get outputs we can evaluate. We first define some parameters for generating the responses correctly. Hugging Face’s LLM APIs are powered by <a href="https://huggingface.co/docs/text-generation-inference/index" rel="nofollow">Text Generation Inference (TGI)</a> containers. See the TGI OpenAPI specifications <a href="https://huggingface.github.io/text-generation-inference/#/Text%20Generation%20Inference/generate" rel="nofollow">here</a> and the explanations of different parameters in the Transformers Generation Parameters <a href="https://huggingface.co/docs/transformers/v4.30.0/main_classes/text_generation#transformers.GenerationConfig" rel="nofollow">docs</a>.',st,F,at,S,oe='Now, we can make a standard API request to the Serverless Inference API (<a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">docs</a>). Note that the Serverless Inference API is mostly for testing and is rate-limited. For testing without rate limits, you can create your own API via the HF Dedicated Endpoints (<a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">docs</a>). See also our corresponding tutorials in the <a href="https://huggingface.co/learn/cookbook/index" rel="nofollow">Open Source AI Cookbook</a>.',nt,u,Mt,x,ot,z,ie=`---First generation of mistralai/Mixtral-8x7B-Instruct-v0.1:
Here's a Python function that meets your requirements:

\`\`\`python
def get_value(matrix, indices):
    try:
        return matrix[indices[0]][indices[1]]
    except IndexError:
        return None
\`\`\`

This function takes a matrix (represented by a list of lists) and a tuple of indices as input. It first tries to access the value at the given indices in the matrix. If the indices are out of range, it catches the \`IndexError\` exception and returns \`None\`.


---First generation of meta-llama/Meta-Llama-3-70B-Instruct:
Here is a Python function that does what you described:
\`\`\`
def get_value(matrix, indices):
    try:
        row, col = indices
        return matrix[row][col]
    except IndexError:
        return None
\`\`\`
Here's an explanation of how the function works:

1. The function takes two arguments: \`matrix\` (a list of lists) and \`indices\` (a tuple of two integers, representing the row and column indices).
2. The function tries to access the value at the specified indices using \`matrix[row][col]\`.
3. If the indices are out of range (i.e., \`row\` or \`col\` is greater than the length of the corresponding dimension of the matrix), an \`IndexError\` exception is raised.
4. The \`except\` block catches the \`IndexError\` exception and returns \`None\` instead of raising an error.

Here's an example usage of the function:
\`\`\`
matrix = [[1, 2, 3], [4, 5, 6], [7, 8, 9]]

print(get_value(matrix, (0, 0)))  &num; prints 1
print(get_value(matrix, (1, 1)))  &num; prints 5
print(get_value(matrix, (3, 0)))  &num; prints None (out of range)
print(get_value(matrix, (0, 3)))  &num; prints None (out of range)
\`\`\`
I hope this helps! Let me know if you have any questions.
`,it,$,rt,q,re="We can now store the LLM outputs in a dataset together with the original instructions.",pt,L,ct,D,yt,P,pe='We use <a href="https://argilla.io/" rel="nofollow">Argilla</a>, a collaboration tool for AI engineers and domain experts who need to build high-quality datasets for their projects.',dt,K,ce='We run Argilla via a HF Space, which you can set up with just a few clicks without any local setup. You can create the HF Argilla Space by following <a href="https://docs.argilla.io/latest/getting_started/quickstart/" rel="nofollow">these instructions</a>. For further configuration on HF Argilla Spaces, see also the detailed <a href="https://docs.argilla.io/latest/getting_started/how-to-configure-argilla-on-huggingface/" rel="nofollow">documentation</a>. If you want, you can also run Argilla locally via Argilla’s docker containers (see <a href="https://docs.argilla.io/latest/getting_started/how-to-deploy-argilla-with-docker/" rel="nofollow">Argilla docs</a>).',jt,O,ye='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/argilla-login-screen.png" alt="Argilla login screen"/>',Jt,ll,wt,tl,de="Before we can tailor the dataset to our specific task and upload the data that will be shown in the UI, we need to first set up a few things.",ht,el,je="<strong>Connecting this notebook to Argilla:</strong> We can now connect this notebook to Argilla to programmatically configure your dataset and upload/download data.",Tt,sl,ut,al,Ut,nl,mt,Ml,Je="Writing good guidelines for your human annotators is just as important (and difficult) as writing good training code. Good instructions should fulfill the following criteria:",It,ol,we="<li><strong>Simple and clear</strong>: The guidelines should be simple and clear to understand for people who do not know anything about your task yet. Always ask at least one colleague to reread the guidelines to make sure that there are no ambiguities.</li> <li><strong>Reproducible and explicit</strong>: All information for doing the annotation task should be contained in the guidelines. A common mistake is to create informal interpretations of the guidelines during conversations with selected annotators. Future annotators will not have this information and might do the task differently than intended if it is not made explicit in the guidelines.</li> <li><strong>Short and comprehensive</strong>: The guidelines should as short as possible, while containing all necessary information. Annotators tend not to read long guidelines properly, so try to keep them as short as possible, while remaining comprehensive.</li>",bt,il,he='Note that creating annotator guidelines is an iterative process. It is good practice to do a few dozen annotations yourself and refine the guidelines based on your learnings from the data before assigning the task to others. Versioning the guidelines can also help as the task evolves over time. See further tips in this <a href="https://argilla.io/blog/annotation-guidelines-practices/" rel="nofollow">blog post</a>.',gt,rl,ft,pl,Te="<strong>Cumulative ratings vs. Likert scales:</strong> Note that the guidelines above ask the annotators to do cumulative ratings by adding points for explicit criteria. An alternative approach are “Likert scales”, where annotators are asked to rate responses on a continuous scale e.g. from 1 (very bad) to 3 (mediocre) to 5 (very good). We generally recommend cumulative ratings, because they force you and the annotators to make quality criteria explicit, while just rating a response as “4” (good) is ambiguous and will be interpreted differently by different annotators.",Ct,cl,At,yl,ue='We can now create our own <code>code-llm</code> task with the fields, questions, and metadata required for annotation. For more information on configuring the Argilla dataset, see the <a href="https://docs.argilla.io/latest/how_to_guides/dataset/#create-a-dataset" rel="nofollow">Argilla docs</a>.',Bt,dl,Gt,jl,Ue="After running the code above, you will see the new custom <code>code-llm</code> dataset in Argilla (and any other dataset you might have created before).",Zt,Jl,kt,wl,me="At this point, the dataset is still empty. Let’s load some data with the code below.",Rt,hl,Wt,Tl,Ie="<strong>The Argilla UI for annotation</strong> will look similar to this:",vt,ul,be='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/argilla-code-llm.png" alt="Argilla UI"/>',Xt,Ul,Et,ml,ge='That’s it, we’ve created our Argilla dataset and we can now start annotating in the UI! By default, the records will be completed when they have 1 annotation. Check these guides, to know how to <a href="https://docs.argilla.io/latest/how_to_guides/distribution/" rel="nofollow">automatically distribute the annotation task</a> and <a href="https://docs.argilla.io/latest/how_to_guides/annotate/" rel="nofollow">annotate in Argilla</a>.',Nt,Il,fe="<strong>Important</strong>: If you use Argilla in a HF Space, you’d to activate persistent storage so that your data is safely stored and not automatically deleted after a while. For production settings, make sure that persistent storage is activated <strong>before</strong> making any annotations to avoid data loss.",Vt,bl,Qt,gl,Ce='After annotating, you can pull the data from Argilla and simply store and process them locally in any tabular format (see <a href="https://docs.argilla.io/latest/how_to_guides/import_export/" rel="nofollow">docs here</a>). You can also download the filtered version of the dataset (<a href="https://docs.argilla.io/latest/how_to_guides/query/" rel="nofollow">docs</a>).',Ht,fl,Yt,Cl,_t,Al,Ft,Bl,Ae="That’s it! You’ve created synthetic LLM data with the HF inference API, created a dataset in Argilla, uploaded the LLM data into Argilla, evaluated/corrected the data, and after annotation you have downloaded the data in a simple tabular format for downstream use.",St,Gl,Be="We have specifically designed the pipeline and the interface for <strong>two main use-cases</strong>:",xt,Zl,Ge='<li>Evaluation: You can now simply use the numeric scores in the <code>score_response_1</code> and <code>score_response_2</code> columns to calculate which model was better overall. You can also inspect responses with very low or high ratings for a detailed error analysis. As you test or train different models, you can reuse this pipeline and track improvements of different models over time.</li> <li>Training: After annotating enough data, you can create a train-test split from the data and fine-tune your own model. You can either use highly rated response texts for supervised fine-tuning with the the <a href="https://huggingface.co/docs/trl/en/sft_trainer" rel="nofollow">TRL SFTTrainer</a>, or you can directly use the ratings for preference-tuning techniques like DPO with the <a href="https://huggingface.co/docs/trl/en/dpo_trainer" rel="nofollow">TRL DPOTrainer</a>. See the <a href="https://huggingface.co/docs/trl/en/index" rel="nofollow">TRL docs</a> for the pros and cons of different LLM fine-tuning techniques.</li>',zt,kl,Ze='<strong>Adapt and improve:</strong> Many things can be improved to tailor this pipeline to your specific use-cases. For example, you can prompt an LLM to evaluate the outputs of the two LLMs with instructions very similar to the guidelines for human annotators (“LLM-as-a-judge” approach). This can help further speed up your evaluation pipeline. See our <a href="https://huggingface.co/learn/cookbook/llm_judge" rel="nofollow">LLM-as-a-judge recipe</a> for an example implementation of LLM-as-a-judge and our overall <a href="https://huggingface.co/learn/cookbook/index" rel="nofollow">Open-Source AI Cookbook</a> for many other ideas.',$t,Rl,qt,vl,Lt;return m=new _e({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/update-table-rendering/notebooks/en/enterprise_cookbook_argilla.ipynb"}]}}),I=new w({props:{title:"Data Annotation with Argilla Spaces",local:"data-annotation-with-argilla-spaces",headingTag:"h1"}}),G=new w({props:{title:"Install required packages and connect to HF Hub",local:"install-required-packages-and-connect-to-hf-hub",headingTag:"h2"}}),Z=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjBhcmdpbGxhfiUzRDIuMC4wJTBBIXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnN+JTNENC40MC4wJTBBIXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0c34lM0QyLjE5LjAlMEEhcGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1Yn4lM0QwLjIzLjI=",highlighted:`!pip install argilla~=<span class="hljs-number">2.0</span><span class="hljs-number">.0</span>
!pip install transformers~=<span class="hljs-number">4.40</span><span class="hljs-number">.0</span>
!pip install datasets~=<span class="hljs-number">2.19</span><span class="hljs-number">.0</span>
!pip install huggingface_hub~=<span class="hljs-number">0.23</span><span class="hljs-number">.2</span>`,wrap:!1}}),k=new h({props:{code:"JTIzJTIwTG9naW4lMjB0byUyMHRoZSUyMEhGJTIwSHViLiUyMFdlJTIwcmVjb21tZW5kJTIwdXNpbmclMjB0aGlzJTIwbG9naW4lMjBtZXRob2QlMjAlMEElMjMlMjB0byUyMGF2b2lkJTIwdGhlJTIwbmVlZCUyMHRvJTIwZXhwbGljaXRseSUyMHN0b3JlJTIweW91ciUyMEhGJTIwdG9rZW4lMjBpbiUyMHZhcmlhYmxlcyUyMCUwQWltcG9ydCUyMGh1Z2dpbmdmYWNlX2h1YiUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmUlMEFodWdnaW5nZmFjZV9odWIubG9naW4oYWRkX3RvX2dpdF9jcmVkZW50aWFsJTNEVHJ1ZSk=",highlighted:`<span class="hljs-comment"># Login to the HF Hub. We recommend using this login method </span>
<span class="hljs-comment"># to avoid the need to explicitly store your HF token in variables </span>
<span class="hljs-keyword">import</span> huggingface_hub
!git config --<span class="hljs-keyword">global</span> credential.helper store
huggingface_hub.login(add_to_git_credential=<span class="hljs-literal">True</span>)`,wrap:!1}}),R=new w({props:{title:"Download example task data",local:"download-example-task-data",headingTag:"h2"}}),v=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwU21hbGwlMjBzYW1wbGUlMjBmb3IlMjBmYXN0ZXIlMjB0ZXN0aW5nJTBBZGF0YXNldF9jb2RldGFzayUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJiaWdjb2RlJTJGc2VsZi1vc3MtaW5zdHJ1Y3Qtc2MyLWV4ZWMtZmlsdGVyLTUwayUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lNUIlM0EzJTVEJTIyKSUwQXByaW50KCUyMkRhdGFzZXQlMjBzdHJ1Y3R1cmUlM0ElNUNuJTIyJTJDJTIwZGF0YXNldF9jb2RldGFzayUyQyUyMCUyMiU1Q24lMjIpJTBBJTBBJTIzJTIwV2UlMjBhcmUlMjBvbmx5JTIwaW50ZXJlc3RlZCUyMGluJTIwdGhlJTIwaW5zdHJ1Y3Rpb25zJTJGcHJvbXB0cyUyMHByb3ZpZGVkJTIwaW4lMjB0aGUlMjBkYXRhc2V0JTBBaW5zdHJ1Y3Rpb25zX2xzdCUyMCUzRCUyMGRhdGFzZXRfY29kZXRhc2slNUIlMjJpbnN0cnVjdGlvbiUyMiU1RCUwQXByaW50KCUyMkV4YW1wbGUlMjBpbnN0cnVjdGlvbnMlM0ElNUNuJTIyJTJDJTIwaW5zdHJ1Y3Rpb25zX2xzdCU1QiUzQTIlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Small sample for faster testing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_codetask = load_dataset(<span class="hljs-string">&quot;bigcode/self-oss-instruct-sc2-exec-filter-50k&quot;</span>, split=<span class="hljs-string">&quot;train[:3]&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Dataset structure:\\n&quot;</span>, dataset_codetask, <span class="hljs-string">&quot;\\n&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We are only interested in the instructions/prompts provided in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>instructions_lst = dataset_codetask[<span class="hljs-string">&quot;instruction&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Example instructions:\\n&quot;</span>, instructions_lst[:<span class="hljs-number">2</span>])`,wrap:!1}}),E=new w({props:{title:"Prompt two LLMs on the example task",local:"prompt-two-llms-on-the-example-task",headingTag:"h2"}}),N=new w({props:{title:"Formatting the instructions with a chat_template",local:"formatting-the-instructions-with-a-chattemplate",headingTag:"h4"}}),Q=new h({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply correct chat formatting to instructions from the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>models_to_compare = [<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>, <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">format_prompt</span>(<span class="hljs-params">prompt, tokenizer</span>):
<span class="hljs-meta">... </span>    messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}]
<span class="hljs-meta">... </span>    messages_tokenized = tokenizer.apply_chat_template(
<span class="hljs-meta">... </span>        messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> messages_tokenized


<span class="hljs-meta">&gt;&gt;&gt; </span>prompts_formatted_dic = {}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> model <span class="hljs-keyword">in</span> models_to_compare:
<span class="hljs-meta">... </span>    tokenizer = AutoTokenizer.from_pretrained(model)

<span class="hljs-meta">... </span>    prompt_formatted = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> instruction <span class="hljs-keyword">in</span> instructions_lst:
<span class="hljs-meta">... </span>        prompt_formatted.append(format_prompt(instruction, tokenizer))

<span class="hljs-meta">... </span>    prompts_formatted_dic.update({model: prompt_formatted})


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;\\nFirst prompt formatted for <span class="hljs-subst">{models_to_compare[<span class="hljs-number">0</span>]}</span>:\\n\\n&quot;</span>,
<span class="hljs-meta">... </span>    prompts_formatted_dic[models_to_compare[<span class="hljs-number">0</span>]][<span class="hljs-number">0</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;\\n\\n&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;First prompt formatted for <span class="hljs-subst">{models_to_compare[<span class="hljs-number">1</span>]}</span>:\\n\\n&quot;</span>,
<span class="hljs-meta">... </span>    prompts_formatted_dic[models_to_compare[<span class="hljs-number">1</span>]][<span class="hljs-number">0</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;\\n\\n&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Y=new w({props:{title:"Sending the instructions to the HF Inference API",local:"sending-the-instructions-to-the-hf-inference-api",headingTag:"h4"}}),F=new h({props:{code:"Z2VuZXJhdGlvbl9wYXJhbXMlMjAlM0QlMjBkaWN0KCUwQSUyMCUyMCUyMCUyMCUyMyUyMHdlJTIwdXNlJTIwbG93JTIwdGVtcGVyYXR1cmUlMjBhbmQlMjB0b3BfcCUyMHRvJTIwcmVkdWNlJTIwY3JlYXRpdml0eSUyMGFuZCUyMGluY3JlYXNlJTIwbGlrZWxpaG9vZCUyMG9mJTIwaGlnaGx5JTIwcHJvYmFibGUlMjB0b2tlbnMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUwQSUyMCUyMCUyMCUyMHRvcF9wJTNEMC42MCUyQyUwQSUyMCUyMCUyMCUyMHRvcF9rJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHJlcGV0aXRpb25fcGVuYWx0eSUzRDEuMCUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDUxMiUyMColMjAyJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX2Z1bGxfdGV4dCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwc2VlZCUzRDQyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwZGV0YWlscyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBzdG9wJTNEJTVCJTIyJTNDJTdDRU5EX09GX1RVUk5fVE9LRU4lN0MlM0UlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBncmFtbWFyJTNEJTdCJTIydHlwZSUyMiUzQSUyMCUyMmpzb24lMjIlN0QlMEElMjAlMjAlMjAlMjBtYXhfdGltZSUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwd2FpdF9mb3JfbW9kZWwlM0RGYWxzZSUyQyUwQSk=",highlighted:`generation_params = <span class="hljs-built_in">dict</span>(
    <span class="hljs-comment"># we use low temperature and top_p to reduce creativity and increase likelihood of highly probable tokens</span>
    temperature=<span class="hljs-number">0.2</span>,
    top_p=<span class="hljs-number">0.60</span>,
    top_k=<span class="hljs-literal">None</span>,
    repetition_penalty=<span class="hljs-number">1.0</span>,
    do_sample=<span class="hljs-literal">True</span>,
    max_new_tokens=<span class="hljs-number">512</span> * <span class="hljs-number">2</span>,
    return_full_text=<span class="hljs-literal">False</span>,
    seed=<span class="hljs-number">42</span>,
    <span class="hljs-comment"># details=True,</span>
    <span class="hljs-comment"># stop=[&quot;&lt;|END_OF_TURN_TOKEN|&gt;&quot;],</span>
    <span class="hljs-comment"># grammar={&quot;type&quot;: &quot;json&quot;}</span>
    max_time=<span class="hljs-literal">None</span>,
    stream=<span class="hljs-literal">False</span>,
    use_cache=<span class="hljs-literal">False</span>,
    wait_for_model=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),u=new Ye({props:{warning:!1,$$slots:{default:[Se]},$$scope:{ctx:Xl}}}),x=new h({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Hint: use asynchronous API calls (and dedicated endpoints) to increase speed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">payload=<span class="hljs-literal">None</span>, api_url=<span class="hljs-literal">None</span></span>):
<span class="hljs-meta">... </span>    response = requests.post(api_url, headers=headers, json=payload)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> response.json()


<span class="hljs-meta">&gt;&gt;&gt; </span>headers = {<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{huggingface_hub.get_token()}</span>&quot;</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>output_dic = {}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> model <span class="hljs-keyword">in</span> models_to_compare:
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Create API urls for each model</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># When using dedicated endpoints, you can reuse the same code and simply replace this URL</span>
<span class="hljs-meta">... </span>    api_url = <span class="hljs-string">&quot;https://api-inference.huggingface.co/models/&quot;</span> + model

<span class="hljs-meta">... </span>    <span class="hljs-comment"># send requests to API</span>
<span class="hljs-meta">... </span>    output_lst = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> prompt <span class="hljs-keyword">in</span> tqdm(prompt_formatted):
<span class="hljs-meta">... </span>        output = query(payload={<span class="hljs-string">&quot;inputs&quot;</span>: prompt, <span class="hljs-string">&quot;parameters&quot;</span>: {**generation_params}}, api_url=api_url)
<span class="hljs-meta">... </span>        output_lst.append(output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>])

<span class="hljs-meta">... </span>    output_dic.update({model: output_lst})

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;---First generation of <span class="hljs-subst">{models_to_compare[<span class="hljs-number">0</span>]}</span>:\\n<span class="hljs-subst">{output_dic[models_to_compare[<span class="hljs-number">0</span>]][<span class="hljs-number">0</span>]}</span>\\n\\n&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;---First generation of <span class="hljs-subst">{models_to_compare[<span class="hljs-number">1</span>]}</span>:\\n<span class="hljs-subst">{output_dic[models_to_compare[<span class="hljs-number">1</span>]][<span class="hljs-number">0</span>]}</span>&quot;</span>)`,wrap:!1}}),$=new w({props:{title:"Store the LLM outputs in a dataset",local:"store-the-llm-outputs-in-a-dataset",headingTag:"h4"}}),L=new h({props:{code:"JTIzJTIwY3JlYXRlJTIwYSUyMEhGJTIwZGF0YXNldCUyMHdpdGglMjB0aGUlMjBpbnN0cnVjdGlvbnMlMjBhbmQlMjBtb2RlbCUyMG91dHB1dHMlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluc3RydWN0aW9ucyUyMiUzQSUyMGluc3RydWN0aW9uc19sc3QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXNwb25zZV9tb2RlbF8xJTIyJTNBJTIwb3V0cHV0X2RpYyU1Qm1vZGVsc190b19jb21wYXJlJTVCMCU1RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlc3BvbnNlX21vZGVsXzIlMjIlM0ElMjBvdXRwdXRfZGljJTVCbW9kZWxzX3RvX2NvbXBhcmUlNUIxJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKSUwQSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-comment"># create a HF dataset with the instructions and model outputs</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict(
    {
        <span class="hljs-string">&quot;instructions&quot;</span>: instructions_lst,
        <span class="hljs-string">&quot;response_model_1&quot;</span>: output_dic[models_to_compare[<span class="hljs-number">0</span>]],
        <span class="hljs-string">&quot;response_model_2&quot;</span>: output_dic[models_to_compare[<span class="hljs-number">1</span>]],
    }
)

dataset`,wrap:!1}}),D=new w({props:{title:"Create and configure your Argilla dataset",local:"create-and-configure-your-argilla-dataset",headingTag:"h2"}}),ll=new w({props:{title:"Programmatically interact with Argilla",local:"programmatically-interact-with-argilla",headingTag:"h4"}}),sl=new h({props:{code:"JTIzJTIwQWZ0ZXIlMjBzdGFydGluZyUyMHRoZSUyMEFyZ2lsbGElMjBTcGFjZSUyMChvciUyMGxvY2FsJTIwZG9ja2VyJTIwY29udGFpbmVyKSUyMHlvdSUyMGNhbiUyMGNvbm5lY3QlMjB0byUyMHRoZSUyMFNwYWNlJTIwd2l0aCUyMHRoZSUyMGNvZGUlMjBiZWxvdy4lMEFpbXBvcnQlMjBhcmdpbGxhJTIwYXMlMjByZyUwQSUwQWNsaWVudCUyMCUzRCUyMHJnLkFyZ2lsbGEoJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGdXNlcm5hbWUtc3BhY2VuYW1lLmhmLnNwYWNlJTIyJTJDJTIwJTIwJTIzJTIwTG9jYWxseSUzQSUyMCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E2OTAwJTIyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMnlvdXItYXBpa2V5JTIyJTJDJTIwJTIwJTIzJTIwWW91J2xsJTIwZmluZCUyMGl0JTIwaW4lMjB0aGUlMjBVSSUyMCUyMk15JTIwU2V0dGluZ3MlMjAlM0UlMjBBUEklMjBrZXklMjIlMEElMjAlMjAlMjAlMjAlMjMlMjBUbyUyMHVzZSUyMGElMjBwcml2YXRlJTIwSEYlMjBBcmdpbGxhJTIwU3BhY2UlMkMlMjBhbHNvJTIwcGFzcyUyMHlvdXIlMjBIRiUyMHRva2VuJTBBJTIwJTIwJTIwJTIwaGVhZGVycyUzRCU3QiUyMkF1dGhvcml6YXRpb24lMjIlM0ElMjBmJTIyQmVhcmVyJTIwJTdCaHVnZ2luZ2ZhY2VfaHViLmdldF90b2tlbigpJTdEJTIyJTdEJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># After starting the Argilla Space (or local docker container) you can connect to the Space with the code below.</span>
<span class="hljs-keyword">import</span> argilla <span class="hljs-keyword">as</span> rg

client = rg.Argilla(
    api_url=<span class="hljs-string">&quot;https://username-spacename.hf.space&quot;</span>,  <span class="hljs-comment"># Locally: &quot;http://localhost:6900&quot;</span>
    api_key=<span class="hljs-string">&quot;your-apikey&quot;</span>,  <span class="hljs-comment"># You&#x27;ll find it in the UI &quot;My Settings &gt; API key&quot;</span>
    <span class="hljs-comment"># To use a private HF Argilla Space, also pass your HF token</span>
    headers={<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{huggingface_hub.get_token()}</span>&quot;</span>},
)`,wrap:!1}}),al=new h({props:{code:"dXNlciUyMCUzRCUyMGNsaWVudC5tZSUwQXVzZXI=",highlighted:`user = client.me
user`,wrap:!1}}),nl=new w({props:{title:"Write good annotator guidelines",local:"write-good-annotator-guidelines",headingTag:"h4"}}),rl=new h({props:{code:"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",highlighted:`annotator_guidelines = <span class="hljs-string">&quot;&quot;&quot;\\
Your task is to evaluate the responses of two LLMs to code generation tasks. 

First, you need to score each response on a scale from 0 to 7. You add points to your final score based on the following criteria:
- Add up to +2 points, if the code is properly commented, with inline comments and doc strings for functions.
- Add up to +2 points, if the code contains a good example for testing. 
- Add up to +3 points, if the code runs and works correctly. Copy the code into an IDE and test it with at least two different inputs. Attribute one point if the code is overall correct, but has some issues. Attribute three points if the code is fully correct and robust against different scenarios. 
Your resulting final score can be any value between 0 to 7. 

If both responses have a final score of &lt;= 4, select one response and correct it manually in the text field. 
The corrected response must fulfill all criteria from above. 
&quot;&quot;&quot;</span>

rating_tooltip = <span class="hljs-string">&quot;&quot;&quot;\\
- Add up to +2 points, if the code is properly commented, with inline comments and doc strings for functions.
- Add up to +2 points, if the code contains a good example for testing. 
- Add up to +3 points, if the code runs and works correctly. Copy the code into an IDE and test it with at least two different inputs. Attribute one point if the code works mostly correctly, but has some issues. Attribute three points if the code is fully correct and robust against different scenarios. 
&quot;&quot;&quot;</span>`,wrap:!1}}),cl=new w({props:{title:"Tailor your Argilla dataset to your specific task",local:"tailor-your-argilla-dataset-to-your-specific-task",headingTag:"h4"}}),dl=new h({props:{code:"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",highlighted:`dataset_argilla_name = <span class="hljs-string">&quot;code-llm&quot;</span>
workspace_name = <span class="hljs-string">&quot;argilla&quot;</span>
reuse_existing_dataset = <span class="hljs-literal">False</span>  <span class="hljs-comment"># for easier iterative testing</span>

<span class="hljs-comment"># Configure your dataset settings</span>
settings = rg.Settings(
    <span class="hljs-comment"># The overall annotation guidelines, which human annotators can refer back to inside of the interface</span>
    guidelines=<span class="hljs-string">&quot;my guidelines&quot;</span>,
    fields=[
        rg.TextField(name=<span class="hljs-string">&quot;instruction&quot;</span>, title=<span class="hljs-string">&quot;Instruction:&quot;</span>, use_markdown=<span class="hljs-literal">True</span>, required=<span class="hljs-literal">True</span>),
        rg.TextField(
            name=<span class="hljs-string">&quot;generation_1&quot;</span>,
            title=<span class="hljs-string">&quot;Response model 1:&quot;</span>,
            use_markdown=<span class="hljs-literal">True</span>,
            required=<span class="hljs-literal">True</span>,
        ),
        rg.TextField(
            name=<span class="hljs-string">&quot;generation_2&quot;</span>,
            title=<span class="hljs-string">&quot;Response model 2:&quot;</span>,
            use_markdown=<span class="hljs-literal">True</span>,
            required=<span class="hljs-literal">True</span>,
        ),
    ],
    <span class="hljs-comment"># These are the questions we ask annotators about the fields in the dataset</span>
    questions=[
        rg.RatingQuestion(
            name=<span class="hljs-string">&quot;score_response_1&quot;</span>,
            title=<span class="hljs-string">&quot;Your score for the response of model 1:&quot;</span>,
            description=<span class="hljs-string">&quot;0=very bad, 7=very good&quot;</span>,
            values=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>],
            required=<span class="hljs-literal">True</span>,
        ),
        rg.RatingQuestion(
            name=<span class="hljs-string">&quot;score_response_2&quot;</span>,
            title=<span class="hljs-string">&quot;Your score for the response of model 2:&quot;</span>,
            description=<span class="hljs-string">&quot;0=very bad, 7=very good&quot;</span>,
            values=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>],
            required=<span class="hljs-literal">True</span>,
        ),
        rg.LabelQuestion(
            name=<span class="hljs-string">&quot;which_response_corrected&quot;</span>,
            title=<span class="hljs-string">&quot;If both responses score below 4, select a response to correct:&quot;</span>,
            description=<span class="hljs-string">&quot;Select the response you will correct in the text field below.&quot;</span>,
            labels=[<span class="hljs-string">&quot;Response 1&quot;</span>, <span class="hljs-string">&quot;Response 2&quot;</span>, <span class="hljs-string">&quot;Combination of both&quot;</span>, <span class="hljs-string">&quot;Neither&quot;</span>],
            required=<span class="hljs-literal">False</span>,
        ),
        rg.TextQuestion(
            name=<span class="hljs-string">&quot;correction&quot;</span>,
            title=<span class="hljs-string">&quot;Paste the selected response below and correct it manually:&quot;</span>,
            description=<span class="hljs-string">&quot;Your corrected response must fulfill all criteria from the annotation guidelines.&quot;</span>,
            use_markdown=<span class="hljs-literal">True</span>,
            required=<span class="hljs-literal">False</span>,
        ),
        rg.TextQuestion(
            name=<span class="hljs-string">&quot;comments&quot;</span>,
            title=<span class="hljs-string">&quot;Annotator Comments&quot;</span>,
            description=<span class="hljs-string">&quot;Add any additional comments here. E.g.: edge cases, issues with the interface etc.&quot;</span>,
            use_markdown=<span class="hljs-literal">True</span>,
            required=<span class="hljs-literal">False</span>,
        ),
    ],
    metadata=[
        rg.TermsMetadataProperty(
            name=<span class="hljs-string">&quot;source-dataset&quot;</span>,
            title=<span class="hljs-string">&quot;Original dataset source&quot;</span>,
        ),
    ],
    allow_extra_metadata=<span class="hljs-literal">False</span>,
)

<span class="hljs-keyword">if</span> reuse_existing_dataset:
    dataset_argilla = client.datasets(dataset_argilla_name, workspace=workspace_name)
<span class="hljs-keyword">else</span>:
    dataset_argilla = rg.Dataset(
        name=dataset_argilla_name,
        settings=settings,
        workspace=workspace_name,
    )
    <span class="hljs-keyword">if</span> client.datasets(dataset_argilla_name, workspace=workspace_name) <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        client.datasets(dataset_argilla_name, workspace=workspace_name).delete()
    dataset_argilla = dataset_argilla.create()

dataset_argilla`,wrap:!1}}),Jl=new w({props:{title:"Load the data to Argilla",local:"load-the-data-to-argilla",headingTag:"h4"}}),hl=new h({props:{code:"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",highlighted:`<span class="hljs-comment"># Iterate over the samples in the dataset</span>
records = [
    rg.Record(
        fields={
            <span class="hljs-string">&quot;instruction&quot;</span>: example[<span class="hljs-string">&quot;instructions&quot;</span>],
            <span class="hljs-string">&quot;generation_1&quot;</span>: example[<span class="hljs-string">&quot;response_model_1&quot;</span>],
            <span class="hljs-string">&quot;generation_2&quot;</span>: example[<span class="hljs-string">&quot;response_model_2&quot;</span>],
        },
        metadata={
            <span class="hljs-string">&quot;source-dataset&quot;</span>: <span class="hljs-string">&quot;bigcode/self-oss-instruct-sc2-exec-filter-50k&quot;</span>,
        },
        <span class="hljs-comment"># Optional: add suggestions from an LLM-as-a-judge system</span>
        <span class="hljs-comment"># They will be indicated with a sparkle icon and shown as pre-filled responses</span>
        <span class="hljs-comment"># It will speed up manual annotation</span>
        <span class="hljs-comment"># suggestions=[</span>
        <span class="hljs-comment">#     rg.Suggestion(</span>
        <span class="hljs-comment">#         question_name=&quot;score_response_1&quot;,</span>
        <span class="hljs-comment">#         value=example[&quot;llm_judge_rating&quot;],</span>
        <span class="hljs-comment">#         agent=&quot;llama-3-70b-instruct&quot;,</span>
        <span class="hljs-comment">#     ),</span>
        <span class="hljs-comment"># ],</span>
    )
    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> dataset
]

<span class="hljs-keyword">try</span>:
    dataset_argilla.records.log(records)
<span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Exception:&quot;</span>, e)`,wrap:!1}}),Ul=new w({props:{title:"Annotate",local:"annotate",headingTag:"h2"}}),bl=new w({props:{title:"Download annotated data",local:"download-annotated-data",headingTag:"h2"}}),fl=new h({props:{code:"YW5ub3RhdGVkX2RhdGFzZXQlMjAlM0QlMjBjbGllbnQuZGF0YXNldHMoZGF0YXNldF9hcmdpbGxhX25hbWUlMkMlMjB3b3Jrc3BhY2UlM0R3b3Jrc3BhY2VfbmFtZSklMEElMEFoZl9kYXRhc2V0JTIwJTNEJTIwYW5ub3RhdGVkX2RhdGFzZXQucmVjb3Jkcy50b19kYXRhc2V0cygpJTBBJTBBJTIzJTIwVGhpcyUyMEhGJTIwZGF0YXNldCUyMGNhbiUyMHRoZW4lMjBiZSUyMGZvcm1hdHRlZCUyQyUyMHN0b3JlZCUyMGFuZCUyMHByb2Nlc3NlZCUyMGludG8lMjBhbnklMjB0YWJ1bGFyJTIwZGF0YSUyMGZvcm1hdCUwQWhmX2RhdGFzZXQudG9fcGFuZGFzKCk=",highlighted:`annotated_dataset = client.datasets(dataset_argilla_name, workspace=workspace_name)

hf_dataset = annotated_dataset.records.to_datasets()

<span class="hljs-comment"># This HF dataset can then be formatted, stored and processed into any tabular data format</span>
hf_dataset.to_pandas()`,wrap:!1}}),Cl=new h({props:{code:"JTIzJTIwU3RvcmUlMjB0aGUlMjBkYXRhc2V0JTIwbG9jYWxseSUwQWhmX2RhdGFzZXQudG9fY3N2KCUyMmFyZ2lsbGEtZGF0YXNldC1sb2NhbC5jc3YlMjIpJTIwJTIwJTIzJTIwU2F2ZSUyMGFzJTIwQ1NWJTBBJTIzJTIwaGZfZGF0YXNldC50b19qc29uKCUyMmFyZ2lsbGEtZGF0YXNldC1sb2NhbC5qc29uJTIyKSUyMCUyMCUyMyUyMFNhdmUlMjBhcyUyMEpTT04lMEElMjMlMjBoZl9kYXRhc2V0LnNhdmVfdG9fZGlzayglMjJhcmdpbGxhLWRhdGFzZXQtbG9jYWwlMjIpJTIwJTIwJTIzJTIwU2F2ZSUyMGFzJTIwYSUyMCU2MGRhdGFzZXRzLkRhdGFzZXQlNjAlMjBpbiUyMHRoZSUyMGxvY2FsJTIwZmlsZXN5c3RlbSUwQSUyMyUyMGhmX2RhdGFzZXQudG9fcGFycXVldCgpJTIwJTIwJTIzJTIwU2F2ZSUyMGFzJTIwUGFycXVldA==",highlighted:`<span class="hljs-comment"># Store the dataset locally</span>
hf_dataset.to_csv(<span class="hljs-string">&quot;argilla-dataset-local.csv&quot;</span>)  <span class="hljs-comment"># Save as CSV</span>
<span class="hljs-comment"># hf_dataset.to_json(&quot;argilla-dataset-local.json&quot;)  # Save as JSON</span>
<span class="hljs-comment"># hf_dataset.save_to_disk(&quot;argilla-dataset-local&quot;)  # Save as a \`datasets.Dataset\` in the local filesystem</span>
<span class="hljs-comment"># hf_dataset.to_parquet()  # Save as Parquet</span>`,wrap:!1}}),Al=new w({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),Rl=new Fe({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/enterprise_cookbook_argilla.md"}}),{c(){J=M("meta"),U=a(),T=M("p"),Wl=a(),r(m.$$.fragment),El=a(),r(I.$$.fragment),Nl=a(),b=M("p"),b.innerHTML=Dt,Vl=a(),g=M("p"),g.textContent=Pt,Ql=a(),f=M("p"),f.innerHTML=Kt,Hl=a(),C=M("p"),C.innerHTML=Ot,Yl=a(),A=M("ol"),A.innerHTML=le,_l=a(),B=M("p"),B.textContent=te,Fl=a(),r(G.$$.fragment),Sl=a(),r(Z.$$.fragment),xl=a(),r(k.$$.fragment),zl=a(),r(R.$$.fragment),$l=a(),W=M("p"),W.innerHTML=ee,ql=a(),r(v.$$.fragment),Ll=a(),X=M("pre"),X.textContent=se,Dl=a(),r(E.$$.fragment),Pl=a(),r(N.$$.fragment),Kl=a(),V=M("p"),V.innerHTML=ae,Ol=a(),r(Q.$$.fragment),lt=a(),H=M("pre"),H.innerHTML=ne,tt=a(),r(Y.$$.fragment),et=a(),_=M("p"),_.innerHTML=Me,st=a(),r(F.$$.fragment),at=a(),S=M("p"),S.innerHTML=oe,nt=a(),r(u.$$.fragment),Mt=a(),r(x.$$.fragment),ot=a(),z=M("pre"),z.textContent=ie,it=a(),r($.$$.fragment),rt=a(),q=M("p"),q.textContent=re,pt=a(),r(L.$$.fragment),ct=a(),r(D.$$.fragment),yt=a(),P=M("p"),P.innerHTML=pe,dt=a(),K=M("p"),K.innerHTML=ce,jt=a(),O=M("p"),O.innerHTML=ye,Jt=a(),r(ll.$$.fragment),wt=a(),tl=M("p"),tl.textContent=de,ht=a(),el=M("p"),el.innerHTML=je,Tt=a(),r(sl.$$.fragment),ut=a(),r(al.$$.fragment),Ut=a(),r(nl.$$.fragment),mt=a(),Ml=M("p"),Ml.textContent=Je,It=a(),ol=M("ul"),ol.innerHTML=we,bt=a(),il=M("p"),il.innerHTML=he,gt=a(),r(rl.$$.fragment),ft=a(),pl=M("p"),pl.innerHTML=Te,Ct=a(),r(cl.$$.fragment),At=a(),yl=M("p"),yl.innerHTML=ue,Bt=a(),r(dl.$$.fragment),Gt=a(),jl=M("p"),jl.innerHTML=Ue,Zt=a(),r(Jl.$$.fragment),kt=a(),wl=M("p"),wl.textContent=me,Rt=a(),r(hl.$$.fragment),Wt=a(),Tl=M("p"),Tl.innerHTML=Ie,vt=a(),ul=M("p"),ul.innerHTML=be,Xt=a(),r(Ul.$$.fragment),Et=a(),ml=M("p"),ml.innerHTML=ge,Nt=a(),Il=M("p"),Il.innerHTML=fe,Vt=a(),r(bl.$$.fragment),Qt=a(),gl=M("p"),gl.innerHTML=Ce,Ht=a(),r(fl.$$.fragment),Yt=a(),r(Cl.$$.fragment),_t=a(),r(Al.$$.fragment),Ft=a(),Bl=M("p"),Bl.textContent=Ae,St=a(),Gl=M("p"),Gl.innerHTML=Be,xt=a(),Zl=M("ol"),Zl.innerHTML=Ge,zt=a(),kl=M("p"),kl.innerHTML=Ze,$t=a(),r(Rl.$$.fragment),qt=a(),vl=M("p"),this.h()},l(l){const t=Qe("svelte-u9bgzb",document.head);J=o(t,"META",{name:!0,content:!0}),t.forEach(e),U=n(l),T=o(l,"P",{}),Re(T).forEach(e),Wl=n(l),p(m.$$.fragment,l),El=n(l),p(I.$$.fragment,l),Nl=n(l),b=o(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-phy2er"&&(b.innerHTML=Dt),Vl=n(l),g=o(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1l9ba3b"&&(g.textContent=Pt),Ql=n(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-l6uth4"&&(f.innerHTML=Kt),Hl=n(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1j66clp"&&(C.innerHTML=Ot),Yl=n(l),A=o(l,"OL",{"data-svelte-h":!0}),i(A)!=="svelte-99p1uo"&&(A.innerHTML=le),_l=n(l),B=o(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-t4uezl"&&(B.textContent=te),Fl=n(l),p(G.$$.fragment,l),Sl=n(l),p(Z.$$.fragment,l),xl=n(l),p(k.$$.fragment,l),zl=n(l),p(R.$$.fragment,l),$l=n(l),W=o(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-lyfwpf"&&(W.innerHTML=ee),ql=n(l),p(v.$$.fragment,l),Ll=n(l),X=o(l,"PRE",{"data-svelte-h":!0}),i(X)!=="svelte-ky4em7"&&(X.textContent=se),Dl=n(l),p(E.$$.fragment,l),Pl=n(l),p(N.$$.fragment,l),Kl=n(l),V=o(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1i1rnp2"&&(V.innerHTML=ae),Ol=n(l),p(Q.$$.fragment,l),lt=n(l),H=o(l,"PRE",{"data-svelte-h":!0}),i(H)!=="svelte-dhulxx"&&(H.innerHTML=ne),tt=n(l),p(Y.$$.fragment,l),et=n(l),_=o(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1x769ch"&&(_.innerHTML=Me),st=n(l),p(F.$$.fragment,l),at=n(l),S=o(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-dksij3"&&(S.innerHTML=oe),nt=n(l),p(u.$$.fragment,l),Mt=n(l),p(x.$$.fragment,l),ot=n(l),z=o(l,"PRE",{"data-svelte-h":!0}),i(z)!=="svelte-10h0gq9"&&(z.textContent=ie),it=n(l),p($.$$.fragment,l),rt=n(l),q=o(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1rfbvc"&&(q.textContent=re),pt=n(l),p(L.$$.fragment,l),ct=n(l),p(D.$$.fragment,l),yt=n(l),P=o(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-o96d5a"&&(P.innerHTML=pe),dt=n(l),K=o(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1t6w574"&&(K.innerHTML=ce),jt=n(l),O=o(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1t9619c"&&(O.innerHTML=ye),Jt=n(l),p(ll.$$.fragment,l),wt=n(l),tl=o(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-1083lvv"&&(tl.textContent=de),ht=n(l),el=o(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-11y3hwk"&&(el.innerHTML=je),Tt=n(l),p(sl.$$.fragment,l),ut=n(l),p(al.$$.fragment,l),Ut=n(l),p(nl.$$.fragment,l),mt=n(l),Ml=o(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-ezpv3g"&&(Ml.textContent=Je),It=n(l),ol=o(l,"UL",{"data-svelte-h":!0}),i(ol)!=="svelte-1na5fga"&&(ol.innerHTML=we),bt=n(l),il=o(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-1qpaxi2"&&(il.innerHTML=he),gt=n(l),p(rl.$$.fragment,l),ft=n(l),pl=o(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-1h73c1v"&&(pl.innerHTML=Te),Ct=n(l),p(cl.$$.fragment,l),At=n(l),yl=o(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-15ob2rx"&&(yl.innerHTML=ue),Bt=n(l),p(dl.$$.fragment,l),Gt=n(l),jl=o(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-4sijlc"&&(jl.innerHTML=Ue),Zt=n(l),p(Jl.$$.fragment,l),kt=n(l),wl=o(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-19sqfel"&&(wl.textContent=me),Rt=n(l),p(hl.$$.fragment,l),Wt=n(l),Tl=o(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-no5ez3"&&(Tl.innerHTML=Ie),vt=n(l),ul=o(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-1tsxy4g"&&(ul.innerHTML=be),Xt=n(l),p(Ul.$$.fragment,l),Et=n(l),ml=o(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-1fthso6"&&(ml.innerHTML=ge),Nt=n(l),Il=o(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-lspd45"&&(Il.innerHTML=fe),Vt=n(l),p(bl.$$.fragment,l),Qt=n(l),gl=o(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-mh9wpg"&&(gl.innerHTML=Ce),Ht=n(l),p(fl.$$.fragment,l),Yt=n(l),p(Cl.$$.fragment,l),_t=n(l),p(Al.$$.fragment,l),Ft=n(l),Bl=o(l,"P",{"data-svelte-h":!0}),i(Bl)!=="svelte-6tbqup"&&(Bl.textContent=Ae),St=n(l),Gl=o(l,"P",{"data-svelte-h":!0}),i(Gl)!=="svelte-1nz4tc1"&&(Gl.innerHTML=Be),xt=n(l),Zl=o(l,"OL",{"data-svelte-h":!0}),i(Zl)!=="svelte-1nta8f4"&&(Zl.innerHTML=Ge),zt=n(l),kl=o(l,"P",{"data-svelte-h":!0}),i(kl)!=="svelte-afghff"&&(kl.innerHTML=Ze),$t=n(l),p(Rl.$$.fragment,l),qt=n(l),vl=o(l,"P",{}),Re(vl).forEach(e),this.h()},h(){We(J,"name","hf:doc:metadata"),We(J,"content",ze)},m(l,t){He(document.head,J),s(l,U,t),s(l,T,t),s(l,Wl,t),c(m,l,t),s(l,El,t),c(I,l,t),s(l,Nl,t),s(l,b,t),s(l,Vl,t),s(l,g,t),s(l,Ql,t),s(l,f,t),s(l,Hl,t),s(l,C,t),s(l,Yl,t),s(l,A,t),s(l,_l,t),s(l,B,t),s(l,Fl,t),c(G,l,t),s(l,Sl,t),c(Z,l,t),s(l,xl,t),c(k,l,t),s(l,zl,t),c(R,l,t),s(l,$l,t),s(l,W,t),s(l,ql,t),c(v,l,t),s(l,Ll,t),s(l,X,t),s(l,Dl,t),c(E,l,t),s(l,Pl,t),c(N,l,t),s(l,Kl,t),s(l,V,t),s(l,Ol,t),c(Q,l,t),s(l,lt,t),s(l,H,t),s(l,tt,t),c(Y,l,t),s(l,et,t),s(l,_,t),s(l,st,t),c(F,l,t),s(l,at,t),s(l,S,t),s(l,nt,t),c(u,l,t),s(l,Mt,t),c(x,l,t),s(l,ot,t),s(l,z,t),s(l,it,t),c($,l,t),s(l,rt,t),s(l,q,t),s(l,pt,t),c(L,l,t),s(l,ct,t),c(D,l,t),s(l,yt,t),s(l,P,t),s(l,dt,t),s(l,K,t),s(l,jt,t),s(l,O,t),s(l,Jt,t),c(ll,l,t),s(l,wt,t),s(l,tl,t),s(l,ht,t),s(l,el,t),s(l,Tt,t),c(sl,l,t),s(l,ut,t),c(al,l,t),s(l,Ut,t),c(nl,l,t),s(l,mt,t),s(l,Ml,t),s(l,It,t),s(l,ol,t),s(l,bt,t),s(l,il,t),s(l,gt,t),c(rl,l,t),s(l,ft,t),s(l,pl,t),s(l,Ct,t),c(cl,l,t),s(l,At,t),s(l,yl,t),s(l,Bt,t),c(dl,l,t),s(l,Gt,t),s(l,jl,t),s(l,Zt,t),c(Jl,l,t),s(l,kt,t),s(l,wl,t),s(l,Rt,t),c(hl,l,t),s(l,Wt,t),s(l,Tl,t),s(l,vt,t),s(l,ul,t),s(l,Xt,t),c(Ul,l,t),s(l,Et,t),s(l,ml,t),s(l,Nt,t),s(l,Il,t),s(l,Vt,t),c(bl,l,t),s(l,Qt,t),s(l,gl,t),s(l,Ht,t),c(fl,l,t),s(l,Yt,t),c(Cl,l,t),s(l,_t,t),c(Al,l,t),s(l,Ft,t),s(l,Bl,t),s(l,St,t),s(l,Gl,t),s(l,xt,t),s(l,Zl,t),s(l,zt,t),s(l,kl,t),s(l,$t,t),c(Rl,l,t),s(l,qt,t),s(l,vl,t),Lt=!0},p(l,[t]){const ke={};t&2&&(ke.$$scope={dirty:t,ctx:l}),u.$set(ke)},i(l){Lt||(y(m.$$.fragment,l),y(I.$$.fragment,l),y(G.$$.fragment,l),y(Z.$$.fragment,l),y(k.$$.fragment,l),y(R.$$.fragment,l),y(v.$$.fragment,l),y(E.$$.fragment,l),y(N.$$.fragment,l),y(Q.$$.fragment,l),y(Y.$$.fragment,l),y(F.$$.fragment,l),y(u.$$.fragment,l),y(x.$$.fragment,l),y($.$$.fragment,l),y(L.$$.fragment,l),y(D.$$.fragment,l),y(ll.$$.fragment,l),y(sl.$$.fragment,l),y(al.$$.fragment,l),y(nl.$$.fragment,l),y(rl.$$.fragment,l),y(cl.$$.fragment,l),y(dl.$$.fragment,l),y(Jl.$$.fragment,l),y(hl.$$.fragment,l),y(Ul.$$.fragment,l),y(bl.$$.fragment,l),y(fl.$$.fragment,l),y(Cl.$$.fragment,l),y(Al.$$.fragment,l),y(Rl.$$.fragment,l),Lt=!0)},o(l){d(m.$$.fragment,l),d(I.$$.fragment,l),d(G.$$.fragment,l),d(Z.$$.fragment,l),d(k.$$.fragment,l),d(R.$$.fragment,l),d(v.$$.fragment,l),d(E.$$.fragment,l),d(N.$$.fragment,l),d(Q.$$.fragment,l),d(Y.$$.fragment,l),d(F.$$.fragment,l),d(u.$$.fragment,l),d(x.$$.fragment,l),d($.$$.fragment,l),d(L.$$.fragment,l),d(D.$$.fragment,l),d(ll.$$.fragment,l),d(sl.$$.fragment,l),d(al.$$.fragment,l),d(nl.$$.fragment,l),d(rl.$$.fragment,l),d(cl.$$.fragment,l),d(dl.$$.fragment,l),d(Jl.$$.fragment,l),d(hl.$$.fragment,l),d(Ul.$$.fragment,l),d(bl.$$.fragment,l),d(fl.$$.fragment,l),d(Cl.$$.fragment,l),d(Al.$$.fragment,l),d(Rl.$$.fragment,l),Lt=!1},d(l){l&&(e(U),e(T),e(Wl),e(El),e(Nl),e(b),e(Vl),e(g),e(Ql),e(f),e(Hl),e(C),e(Yl),e(A),e(_l),e(B),e(Fl),e(Sl),e(xl),e(zl),e($l),e(W),e(ql),e(Ll),e(X),e(Dl),e(Pl),e(Kl),e(V),e(Ol),e(lt),e(H),e(tt),e(et),e(_),e(st),e(at),e(S),e(nt),e(Mt),e(ot),e(z),e(it),e(rt),e(q),e(pt),e(ct),e(yt),e(P),e(dt),e(K),e(jt),e(O),e(Jt),e(wt),e(tl),e(ht),e(el),e(Tt),e(ut),e(Ut),e(mt),e(Ml),e(It),e(ol),e(bt),e(il),e(gt),e(ft),e(pl),e(Ct),e(At),e(yl),e(Bt),e(Gt),e(jl),e(Zt),e(kt),e(wl),e(Rt),e(Wt),e(Tl),e(vt),e(ul),e(Xt),e(Et),e(ml),e(Nt),e(Il),e(Vt),e(Qt),e(gl),e(Ht),e(Yt),e(_t),e(Ft),e(Bl),e(St),e(Gl),e(xt),e(Zl),e(zt),e(kl),e($t),e(qt),e(vl)),e(J),j(m,l),j(I,l),j(G,l),j(Z,l),j(k,l),j(R,l),j(v,l),j(E,l),j(N,l),j(Q,l),j(Y,l),j(F,l),j(u,l),j(x,l),j($,l),j(L,l),j(D,l),j(ll,l),j(sl,l),j(al,l),j(nl,l),j(rl,l),j(cl,l),j(dl,l),j(Jl,l),j(hl,l),j(Ul,l),j(bl,l),j(fl,l),j(Cl,l),j(Al,l),j(Rl,l)}}}const ze='{"title":"Data Annotation with Argilla Spaces","local":"data-annotation-with-argilla-spaces","sections":[{"title":"Install required packages and connect to HF Hub","local":"install-required-packages-and-connect-to-hf-hub","sections":[],"depth":2},{"title":"Download example task data","local":"download-example-task-data","sections":[],"depth":2},{"title":"Prompt two LLMs on the example task","local":"prompt-two-llms-on-the-example-task","sections":[{"title":"Formatting the instructions with a chat_template","local":"formatting-the-instructions-with-a-chattemplate","sections":[],"depth":4},{"title":"Sending the instructions to the HF Inference API","local":"sending-the-instructions-to-the-hf-inference-api","sections":[],"depth":4},{"title":"Store the LLM outputs in a dataset","local":"store-the-llm-outputs-in-a-dataset","sections":[],"depth":4}],"depth":2},{"title":"Create and configure your Argilla dataset","local":"create-and-configure-your-argilla-dataset","sections":[{"title":"Programmatically interact with Argilla","local":"programmatically-interact-with-argilla","sections":[],"depth":4},{"title":"Write good annotator guidelines","local":"write-good-annotator-guidelines","sections":[],"depth":4},{"title":"Tailor your Argilla dataset to your specific task","local":"tailor-your-argilla-dataset-to-your-specific-task","sections":[],"depth":4},{"title":"Load the data to Argilla","local":"load-the-data-to-argilla","sections":[],"depth":4}],"depth":2},{"title":"Annotate","local":"annotate","sections":[],"depth":2},{"title":"Download annotated data","local":"download-annotated-data","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function $e(Xl){return Xe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Ne{constructor(J){super(),Ve(this,J,$e,xe,ve,{})}}export{Oe as component};
