import{s as jt,n as bt,o as ut}from"../chunks/scheduler.65852ee5.js";import{S as It,i as Zt,g as M,s as a,r as o,A as Ct,h as i,f as t,c as n,j as Tt,u as y,x as p,k as ht,y as Gt,a as s,v as m,d as J,t as w,w as r}from"../chunks/index.aa74147d.js";import{D as Bt,C as U}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as d,E as ft}from"../chunks/EditOnGithub.4eda6a96.js";function gt(Ye){let c,Bl,Cl,fl,T,gl,h,Wl,j,_e='<em>Authored by: <a href="https://github.com/AkiRusProd" rel="nofollow">Rustam Akimov</a></em>',vl,b,Ee="This notebook shows how to use Stable Diffusion to interpolate between images.  Image interpolation using Stable Diffusion is the process of creating intermediate images that smoothly transition from one given image to another, using a generative model based on diffusion.",Xl,u,He="Here are some various use cases for image interpolation with Stable Diffusion:",Vl,I,Se="<li>Data Augmentation: Stable Diffusion can augment training data for machine learning models by generating synthetic images that lie between existing data points. This can improve the generalization and robustness of machine learning models, especially in tasks like image generation, classification or object detection.</li> <li>Product Design and Prototyping: Stable Diffusion can aid in product design by generating variations of product designs or prototypes with subtle differences. This can be useful for exploring design alternatives, conducting user studies, or visualizing design iterations before committing to physical prototypes.</li> <li>Content Generation for Media Production: In media production, such as film and video editing, Stable Diffusion can be used to generate intermediate frames between key frames, enabling smoother transitions and enhancing visual storytelling. This can save time and resources compared to manual frame-by-frame editing.</li>",kl,Z,Qe="In the context of image interpolation, Stable Diffusion models are often used to navigate through a high-dimensional latent space. Each dimension represents a specific feature that has been learned by the model. By walking through this latent space and interpolating between different latent representations of images, the model is able to generate a sequence of intermediate images which show a smooth transition between the original images. There are two types of latents in stable diffusion: prompt latents and image latents.",Rl,C,xe="Latent space walking involves moving through a latent space along a path defined by two or more points (representing images). By carefully selecting these points and the path between them, it is possible to control the features of the generated images, such as style, content, and other visual aspects.",Al,G,ze="In this Notebook, we will explore examples of image interpolation using Stable Diffusion and demonstrate how latent space walking can be implemented and utilized to create smooth transitions between images. We’ll provide code snippets and visualizations that illustrate this process in action, allowing for a deeper understanding of how generative models can manipulate and morph image representations in meaningful ways.",Yl,B,Ne="First, let’s install all the required modules.",_l,f,El,g,Fe="Import modules",Hl,W,Sl,v,$e="Let’s check if CUDA is available.",Ql,X,xl,V,De=`These settings are used to optimize the performance of PyTorch models on CUDA-enabled GPUs, especially when using mixed precision training or inference, which can be beneficial in terms of speed and memory usage.<br/>
Source: <a href="https://huggingface.co/docs/diffusers/optimization/fp16#memory-efficient-attention" rel="nofollow">https://huggingface.co/docs/diffusers/optimization/fp16#memory-efficient-attention</a>`,zl,k,Nl,R,Fl,A,Le='The <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> model and the <a href="https://huggingface.co/docs/diffusers/en/api/schedulers/lms_discrete" rel="nofollow"><code>LMSDiscreteScheduler</code></a> scheduler were chosen to generate images. Despite being an older technology, it continues to enjoy popularity due to its fast performance, minimal memory requirements, and the availability of numerous community fine-tuned models built on top of SD1.5. However, you are free to experiment with other models and schedulers to compare the results.',$l,Y,Dl,_,qe="These methods are designed to reduce the memory consumed by the GPU. If you have enough VRAM, you can skip this cell.",Ll,E,Ke=`More detailed information can be found here: <a href="https://huggingface.co/docs/diffusers/en/optimization/opt_overview" rel="nofollow">https://huggingface.co/docs/diffusers/en/optimization/opt_overview</a><br/>
In particular, information about the following methods can be found here: <a href="https://huggingface.co/docs/diffusers/optimization/memory" rel="nofollow">https://huggingface.co/docs/diffusers/optimization/memory</a>`,ql,H,Kl,S,Pe="The <code>display_images</code> function converts a list of image arrays into a GIF, saves it to a specified path and returns the GIF object for display. It names the GIF file using the current time and handles any errors by printing them out.",Pl,Q,Ol,x,le,z,Oe="<li><code>seed</code>: This variable is used to set a specific random seed for reproducibility.</li> <li><code>generator</code>: This is set to a PyTorch random number generator object if a seed is provided, otherwise it is None. It ensures that the operations using it have reproducible outcomes.</li> <li><code>guidance_scale</code>: This parameter controls the extent to which the model should follow the prompt in text-to-image generation tasks, with higher values leading to stronger adherence to the prompt.</li> <li><code>num_inference_steps</code>: This specifies the number of steps the model takes to generate an image. More steps can lead to a higher quality image but take longer to generate.</li> <li><code>num_interpolation_steps</code>: This determines the number of steps used when interpolating between two points in the latent space, affecting the smoothness of transitions in generated       animations.</li> <li><code>height</code>: The height of the generated images in pixels.</li> <li><code>width</code>: The width of the generated images in pixels.</li> <li><code>save_path</code>: The file system path where the generated gifs will be saved.</li>",ee,N,te,F,se,$,lt="In this example, interpolation between positive and negative prompt embeddings allows exploration of space between two conceptual points defined by prompts, potentially leading to variety of images blending characteristics dictated by prompts gradually. In this case, interpolation involves adding scaled deltas to original embeddings, creating a series of new embeddings that will be used later to generate images with smooth transitions between different states based on the original prompt.",ae,D,et='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/sd_interpolation_1.gif" alt="Example 1"/>',ne,L,tt="First of all, we need to tokenize and obtain embeddings for both positive and negative text prompts. The positive prompt guides the image generation towards the desired characteristics, while the negative prompt steers it away from unwanted features.",Me,q,ie,K,st="Now let’s look at the code part that generates a random initial vector using a normal distribution that is structured to match the dimensions expected by the diffusion model (UNet). This allows for the reproducibility of the results by optionally using a random number generator. After creating the initial vector, the code performs a series of interpolations between the two embeddings (positive and negative prompts), by incrementally adding a small step size for each iteration. The results are stored in a list named “walked_embeddings”.",pe,P,oe,O,at="Finally, let’s generate a series of images based on interpolated embeddings and then displaying these images. We’ll iterate over an array of embeddings, using each to generate an image with specified characteristics like height, width, and other parameters relevant to image generation. Then we’ll collect these images into a list. Once generation is complete we’ll call the <code>display_image</code> function to save and display these images as GIF at a given save path.",ye,ll,me,el,Je,tl,nt="Unlike the first example, in this one, we are performing interpolation between the two embeddings of the diffusion model itself, not the prompts. Please note that in this case, we use the slerp function for interpolation. However, there is nothing stopping us from adding a constant value to one embedding instead.",we,sl,Mt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/sd_interpolation_2.gif" alt="Example 2"/>',re,al,it="The function presented below stands for Spherical Linear Interpolation. It is a method of interpolation on the surface of a sphere. This function is commonly used in computer graphics to animate rotations in a smooth manner and can also be used to interpolate between high-dimensional data points in machine learning, such as latent vectors used in generative models.",Ue,nl,pt=`The source is from Andrej Karpathy’s gist: <a href="https://gist.github.com/karpathy/00103b0037c5aaea32fe1da1af553355" rel="nofollow">https://gist.github.com/karpathy/00103b0037c5aaea32fe1da1af553355</a>.<br/>
A more detailed explanation of this method can be found at: <a href="https://en.wikipedia.org/wiki/Slerp" rel="nofollow">https://en.wikipedia.org/wiki/Slerp</a>.`,ce,Ml,de,il,Te,pl,he,ol,ot="In contrast to the first example, where we moved away from a single prompt, in this example, we will be interpolating between any number of prompts. To do so, we will take consecutive pairs of prompts and create smooth transitions between them. Then, we will combine the interpolations of these consecutive pairs, and instruct the model to generate images based on them. For interpolation we will use the slerp function, as in the second example.",je,yl,yt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/sd_interpolation_3.gif" alt="Example 3"/>',be,ml,mt="Once again, let’s tokenize and obtain embeddings but this time for multiple positive and negative text prompts.",ue,Jl,Ie,wl,Jt="As stated earlier, we will take consecutive pairs of prompts and create smooth transitions between them with <code>slerp</code> function.",Ze,rl,Ce,Ul,wt="Finally, we need to generate images based on the embeddings.",Ge,cl,Be,dl,fe,Tl,rt='This example was taken from: <a href="https://keras.io/examples/generative/random_walks_with_stable_diffusion/" rel="nofollow">https://keras.io/examples/generative/random_walks_with_stable_diffusion/</a>',ge,hl,Ut="Let’s imagine that we have two noise components, which we’ll call x and y. We start by moving from 0 to 2π and at each step we add the cosine of x and the sine of y to the result. Using this approach, at the end of our movement we end up with the same noise values ​​that we started with. This means that vectors end up turning into themselves, ending our movement.",We,jl,ct='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/sd_interpolation_4.gif" alt="Example 4"/>',ve,bl,Xe,ul,Ve,Il,dt="Moving forward, you can explore various parameters such as guidance scale, seed, and number of interpolation steps to observe how they affect the generated images. Additionally, consider trying out different prompts and schedulers to further enhance your results. Another valuable step would be to implement linear interpolation (<code>linspace</code>) instead of spherical linear interpolation (<code>slerp</code>) and compare the results to gain deeper insights into the interpolation process.",ke,Zl,Re,Gl,Ae;return T=new Bt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/issue-179-benchmarking-tgi/notebooks/en/stable_diffusion_interpolation.ipynb"}]}}),h=new d({props:{title:"Images Interpolation with Stable Diffusion",local:"images-interpolation-with-stable-diffusion",headingTag:"h2"}}),f=new U({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGRpZmZ1c2VycyUyMHRyYW5zZm9ybWVycyUyMHhmb3JtZXJzJTIwYWNjZWxlcmF0ZSUwQSFwaXAlMjBpbnN0YWxsJTIwLXElMjBudW1weSUyMHNjaXB5JTIwZnRmeSUyMFBpbGxvdw==",highlighted:`!pip install -q diffusers transformers xformers accelerate
!pip install -q numpy scipy ftfy Pillow`,wrap:!1}}),W=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBvcyUwQSUwQWltcG9ydCUyMHRpbWUlMEElMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwSVB5dGhvbiUyMGltcG9ydCUyMGRpc3BsYXklMjBhcyUyMElQZGlzcGxheSUwQWZyb20lMjB0cWRtLmF1dG8lMjBpbXBvcnQlMjB0cWRtJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBERElNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwUE5ETVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRXVsZXJBbmNlc3RyYWxEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMEEpJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvZ2dpbmclMEElMEFsb2dnaW5nLnNldF92ZXJib3NpdHlfZXJyb3IoKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">import</span> time

<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> IPython <span class="hljs-keyword">import</span> display <span class="hljs-keyword">as</span> IPdisplay
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDIMScheduler,
    PNDMScheduler,
    LMSDiscreteScheduler,
    DPMSolverMultistepScheduler,
    EulerAncestralDiscreteScheduler,
    EulerDiscreteScheduler,
)
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> logging

logging.set_verbosity_error()`,wrap:!1}}),X=new U({props:{code:"cHJpbnQodG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSklMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMik=",highlighted:`<span class="hljs-built_in">print</span>(torch.cuda.is_available())

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)`,wrap:!1}}),k=new U({props:{code:"dG9yY2guYmFja2VuZHMuY3Vkbm4uYmVuY2htYXJrJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLmJhY2tlbmRzLmN1ZGEubWF0bXVsLmFsbG93X3RmMzIlMjAlM0QlMjBUcnVl",highlighted:`torch.backends.cudnn.benchmark = <span class="hljs-literal">True</span>
torch.backends.cuda.matmul.allow_tf32 = <span class="hljs-literal">True</span>`,wrap:!1}}),R=new d({props:{title:"Model",local:"model",headingTag:"h3"}}),Y=new U({props:{code:"bW9kZWxfbmFtZV9vcl9wYXRoJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciglMEElMjAlMjAlMjAlMjBiZXRhX3N0YXJ0JTNEMC4wMDA4NSUyQyUyMGJldGFfZW5kJTNEMC4wMTIlMkMlMjBiZXRhX3NjaGVkdWxlJTNEJTIyc2NhbGVkX2xpbmVhciUyMiUyQyUyMG51bV90cmFpbl90aW1lc3RlcHMlM0QxMDAwJTBBKSUwQSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyJTJDJTBBKS50byhkZXZpY2UpJTBBJTBBJTIzJTIwRGlzYWJsZSUyMGltYWdlJTIwZ2VuZXJhdGlvbiUyMHByb2dyZXNzJTIwYmFyJTJDJTIwd2UnbGwlMjBkaXNwbGF5JTIwb3VyJTIwb3duJTBBcGlwZS5zZXRfcHJvZ3Jlc3NfYmFyX2NvbmZpZyhkaXNhYmxlJTNEVHJ1ZSk=",highlighted:`model_name_or_path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

scheduler = LMSDiscreteScheduler(
    beta_start=<span class="hljs-number">0.00085</span>, beta_end=<span class="hljs-number">0.012</span>, beta_schedule=<span class="hljs-string">&quot;scaled_linear&quot;</span>, num_train_timesteps=<span class="hljs-number">1000</span>
)


pipe = StableDiffusionPipeline.from_pretrained(
    model_name_or_path,
    scheduler=scheduler,
    torch_dtype=torch.float32,
).to(device)

<span class="hljs-comment"># Disable image generation progress bar, we&#x27;ll display our own</span>
pipe.set_progress_bar_config(disable=<span class="hljs-literal">True</span>)`,wrap:!1}}),H=new U({props:{code:"JTIzJTIwT2ZmbG9hZGluZyUyMHRoZSUyMHdlaWdodHMlMjB0byUyMHRoZSUyMENQVSUyMGFuZCUyMG9ubHklMjBsb2FkaW5nJTIwdGhlbSUyMG9uJTIwdGhlJTIwR1BVJTIwY2FuJTIwcmVkdWNlJTIwbWVtb3J5JTIwY29uc3VtcHRpb24lMjB0byUyMGxlc3MlMjB0aGFuJTIwM0dCLiUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEElMjMlMjBUaWdodGVyJTIwb3JkZXJpbmclMjBvZiUyMG1lbW9yeSUyMHRlbnNvcnMuJTBBcGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQSUwQSUyMyUyMERlY29kaW5nJTIwbGFyZ2UlMjBiYXRjaGVzJTIwb2YlMjBpbWFnZXMlMjB3aXRoJTIwbGltaXRlZCUyMFZSQU0lMjBvciUyMGJhdGNoZXMlMjB3aXRoJTIwMzIlMjBpbWFnZXMlMjBvciUyMG1vcmUlMjBieSUyMGRlY29kaW5nJTIwdGhlJTIwYmF0Y2hlcyUyMG9mJTIwbGF0ZW50cyUyMG9uZSUyMGltYWdlJTIwYXQlMjBhJTIwdGltZS4lMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTBBJTIzJTIwU3BsaXR0aW5nJTIwdGhlJTIwaW1hZ2UlMjBpbnRvJTIwb3ZlcmxhcHBpbmclMjB0aWxlcyUyQyUyMGRlY29kaW5nJTIwdGhlJTIwdGlsZXMlMkMlMjBhbmQlMjB0aGVuJTIwYmxlbmRpbmclMjB0aGUlMjBvdXRwdXRzJTIwdG9nZXRoZXIlMjB0byUyMGNvbXBvc2UlMjB0aGUlMjBmaW5hbCUyMGltYWdlLiUwQXBpcGUuZW5hYmxlX3ZhZV90aWxpbmcoKSUwQSUwQSUyMyUyMFVzaW5nJTIwRmxhc2glMjBBdHRlbnRpb24lM0IlMjBJZiUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwJTNFJTNEJTIwMi4wJTIwaW5zdGFsbGVkJTJDJTIweW91JTIwc2hvdWxkJTIwbm90JTIwZXhwZWN0JTIwYSUyMHNwZWVkLXVwJTIwZm9yJTIwaW5mZXJlbmNlJTIwd2hlbiUyMGVuYWJsaW5nJTIweGZvcm1lcnMuJTBBcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-comment"># Offloading the weights to the CPU and only loading them on the GPU can reduce memory consumption to less than 3GB.</span>
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Tighter ordering of memory tensors.</span>
pipe.unet.to(memory_format=torch.channels_last)

<span class="hljs-comment"># Decoding large batches of images with limited VRAM or batches with 32 images or more by decoding the batches of latents one image at a time.</span>
pipe.enable_vae_slicing()

<span class="hljs-comment"># Splitting the image into overlapping tiles, decoding the tiles, and then blending the outputs together to compose the final image.</span>
pipe.enable_vae_tiling()

<span class="hljs-comment"># Using Flash Attention; If you have PyTorch &gt;= 2.0 installed, you should not expect a speed-up for inference when enabling xformers.</span>
pipe.enable_xformers_memory_efficient_attention()`,wrap:!1}}),Q=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">display_images</span>(<span class="hljs-params">images, save_path</span>):
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Convert each image in the &#x27;images&#x27; list from an array to an Image object.</span>
        images = [Image.fromarray(np.array(image[<span class="hljs-number">0</span>], dtype=np.uint8)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]

        <span class="hljs-comment"># Generate a file name based on the current time, replacing colons with hyphens</span>
        <span class="hljs-comment"># to ensure the filename is valid for file systems that don&#x27;t allow colons.</span>
        filename = time.strftime(<span class="hljs-string">&quot;%H:%M:%S&quot;</span>, time.localtime()).replace(<span class="hljs-string">&quot;:&quot;</span>, <span class="hljs-string">&quot;-&quot;</span>)
        <span class="hljs-comment"># Save the first image in the list as a GIF file at the &#x27;save_path&#x27; location.</span>
        <span class="hljs-comment"># The rest of the images in the list are added as subsequent frames to the GIF.</span>
        <span class="hljs-comment"># The GIF will play each frame for 100 milliseconds and will loop indefinitely.</span>
        images[<span class="hljs-number">0</span>].save(
            <span class="hljs-string">f&quot;<span class="hljs-subst">{save_path}</span>/<span class="hljs-subst">{filename}</span>.gif&quot;</span>,
            save_all=<span class="hljs-literal">True</span>,
            append_images=images[<span class="hljs-number">1</span>:],
            duration=<span class="hljs-number">100</span>,
            loop=<span class="hljs-number">0</span>,
        )
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># If there is an error during the process, print the exception message.</span>
        <span class="hljs-built_in">print</span>(e)

    <span class="hljs-comment"># Return the saved GIF as an IPython display object so it can be displayed in a notebook.</span>
    <span class="hljs-keyword">return</span> IPdisplay.Image(<span class="hljs-string">f&quot;<span class="hljs-subst">{save_path}</span>/<span class="hljs-subst">{filename}</span>.gif&quot;</span>)`,wrap:!1}}),x=new d({props:{title:"Generation parameters",local:"generation-parameters",headingTag:"h3"}}),N=new U({props:{code:"JTIzJTIwVGhlJTIwc2VlZCUyMGlzJTIwc2V0JTIwdG8lMjAlMjJOb25lJTIyJTJDJTIwYmVjYXVzZSUyMHdlJTIwd2FudCUyMGRpZmZlcmVudCUyMHJlc3VsdHMlMjBlYWNoJTIwdGltZSUyMHdlJTIwcnVuJTIwdGhlJTIwZ2VuZXJhdGlvbi4lMEFzZWVkJTIwJTNEJTIwTm9uZSUwQSUwQWlmJTIwc2VlZCUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKHNlZWQpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUyMCUzRCUyME5vbmUlMEElMEElMjMlMjBUaGUlMjBndWlkYW5jZSUyMHNjYWxlJTIwaXMlMjBzZXQlMjB0byUyMGl0cyUyMG5vcm1hbCUyMHJhbmdlJTIwKDclMjAtJTIwMTApLiUwQWd1aWRhbmNlX3NjYWxlJTIwJTNEJTIwOCUwQSUwQSUyMyUyMFRoZSUyMG51bWJlciUyMG9mJTIwaW5mZXJlbmNlJTIwc3RlcHMlMjB3YXMlMjBjaG9zZW4lMjBlbXBpcmljYWxseSUyMHRvJTIwZ2VuZXJhdGUlMjBhbiUyMGFjY2VwdGFibGUlMjBwaWN0dXJlJTIwd2l0aGluJTIwYW4lMjBhY2NlcHRhYmxlJTIwdGltZS4lMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwMTUlMEElMEElMjMlMjBUaGUlMjBoaWdoZXIlMjB5b3UlMjBzZXQlMjB0aGlzJTIwdmFsdWUlMkMlMjB0aGUlMjBzbW9vdGhlciUyMHRoZSUyMGludGVycG9sYXRpb25zJTIwd2lsbCUyMGJlLiUyMEhvd2V2ZXIlMkMlMjB0aGUlMjBnZW5lcmF0aW9uJTIwdGltZSUyMHdpbGwlMjBpbmNyZWFzZS4lMjBUaGlzJTIwdmFsdWUlMjB3YXMlMjBjaG9zZW4lMjBlbXBpcmljYWxseS4lMEFudW1faW50ZXJwb2xhdGlvbl9zdGVwcyUyMCUzRCUyMDMwJTBBJTBBJTIzJTIwSSUyMHdvdWxkJTIwbm90JTIwcmVjb21tZW5kJTIwbGVzcyUyMHRoYW4lMjA1MTIlMjBvbiUyMGVpdGhlciUyMGRpbWVuc2lvbi4lMjBUaGlzJTIwaXMlMjBiZWNhdXNlJTIwdGhpcyUyMG1vZGVsJTIwd2FzJTIwdHJhaW5lZCUyMG9uJTIwNTEyeDUxMiUyMGltYWdlJTIwcmVzb2x1dGlvbi4lMEFoZWlnaHQlMjAlM0QlMjA1MTIlMEF3aWR0aCUyMCUzRCUyMDUxMiUwQSUwQSUyMyUyMFRoZSUyMHBhdGglMjB3aGVyZSUyMHRoZSUyMGdlbmVyYXRlZCUyMEdJRnMlMjB3aWxsJTIwYmUlMjBzYXZlZCUwQXNhdmVfcGF0aCUyMCUzRCUyMCUyMiUyRm91dHB1dCUyMiUwQSUwQWlmJTIwbm90JTIwb3MucGF0aC5leGlzdHMoc2F2ZV9wYXRoKSUzQSUwQSUyMCUyMCUyMCUyMG9zLm1ha2VkaXJzKHNhdmVfcGF0aCk=",highlighted:`<span class="hljs-comment"># The seed is set to &quot;None&quot;, because we want different results each time we run the generation.</span>
seed = <span class="hljs-literal">None</span>

<span class="hljs-keyword">if</span> seed <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    generator = torch.manual_seed(seed)
<span class="hljs-keyword">else</span>:
    generator = <span class="hljs-literal">None</span>

<span class="hljs-comment"># The guidance scale is set to its normal range (7 - 10).</span>
guidance_scale = <span class="hljs-number">8</span>

<span class="hljs-comment"># The number of inference steps was chosen empirically to generate an acceptable picture within an acceptable time.</span>
num_inference_steps = <span class="hljs-number">15</span>

<span class="hljs-comment"># The higher you set this value, the smoother the interpolations will be. However, the generation time will increase. This value was chosen empirically.</span>
num_interpolation_steps = <span class="hljs-number">30</span>

<span class="hljs-comment"># I would not recommend less than 512 on either dimension. This is because this model was trained on 512x512 image resolution.</span>
height = <span class="hljs-number">512</span>
width = <span class="hljs-number">512</span>

<span class="hljs-comment"># The path where the generated GIFs will be saved</span>
save_path = <span class="hljs-string">&quot;/output&quot;</span>

<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(save_path):
    os.makedirs(save_path)`,wrap:!1}}),F=new d({props:{title:"Example 1: Prompt interpolation",local:"example-1-prompt-interpolation",headingTag:"h3"}}),q=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># The text prompt that describes the desired output image.</span>
prompt = <span class="hljs-string">&quot;Epic shot of Sweden, ultra detailed lake with an ren dear, nostalgic vintage, ultra cozy and inviting, wonderful light atmosphere, fairy, little photorealistic, digital painting, sharp focus, ultra cozy and inviting, wish to be there. very detailed, arty, should rank high on youtube for a dream trip.&quot;</span>
<span class="hljs-comment"># A negative prompt that can be used to steer the generation away from certain features; here, it is empty.</span>
negative_prompt = <span class="hljs-string">&quot;poorly drawn,cartoon, 2d, disfigured, bad art, deformed, poorly drawn, extra limbs, close up, b&amp;w, weird colors, blurry&quot;</span>

<span class="hljs-comment"># The step size for the interpolation in the latent space.</span>
step_size = <span class="hljs-number">0.001</span>

<span class="hljs-comment"># Tokenizing and encoding the prompt into embeddings.</span>
prompt_tokens = pipe.tokenizer(
    prompt,
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    max_length=pipe.tokenizer.model_max_length,
    truncation=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
prompt_embeds = pipe.text_encoder(prompt_tokens.input_ids.to(device))[<span class="hljs-number">0</span>]


<span class="hljs-comment"># Tokenizing and encoding the negative prompt into embeddings.</span>
<span class="hljs-keyword">if</span> negative_prompt <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    negative_prompt = [<span class="hljs-string">&quot;&quot;</span>]

negative_prompt_tokens = pipe.tokenizer(
    negative_prompt,
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    max_length=pipe.tokenizer.model_max_length,
    truncation=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
negative_prompt_embeds = pipe.text_encoder(negative_prompt_tokens.input_ids.to(device))[<span class="hljs-number">0</span>]`,wrap:!1}}),P=new U({props:{code:"JTIzJTIwR2VuZXJhdGluZyUyMGluaXRpYWwlMjBsYXRlbnQlMjB2ZWN0b3JzJTIwZnJvbSUyMGElMjByYW5kb20lMjBub3JtYWwlMjBkaXN0cmlidXRpb24lMkMlMjB3aXRoJTIwdGhlJTIwb3B0aW9uJTIwdG8lMjB1c2UlMjBhJTIwZ2VuZXJhdG9yJTIwZm9yJTIwcmVwcm9kdWNpYmlsaXR5LiUwQWxhdGVudHMlMjAlM0QlMjB0b3JjaC5yYW5kbiglMEElMjAlMjAlMjAlMjAoMSUyQyUyMHBpcGUudW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBoZWlnaHQlMjAlMkYlMkYlMjA4JTJDJTIwd2lkdGglMjAlMkYlMkYlMjA4KSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSklMEElMEF3YWxrZWRfZW1iZWRkaW5ncyUyMCUzRCUyMCU1QiU1RCUwQSUwQSUyMyUyMEludGVycG9sYXRpbmclMjBiZXR3ZWVuJTIwZW1iZWRkaW5ncyUyMGZvciUyMHRoZSUyMGdpdmVuJTIwbnVtYmVyJTIwb2YlMjBpbnRlcnBvbGF0aW9uJTIwc3RlcHMuJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UobnVtX2ludGVycG9sYXRpb25fc3RlcHMpJTNBJTBBJTIwJTIwJTIwJTIwd2Fsa2VkX2VtYmVkZGluZ3MuYXBwZW5kKCU1QnByb21wdF9lbWJlZHMlMjAlMkIlMjBzdGVwX3NpemUlMjAqJTIwaSUyQyUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlMjAlMkIlMjBzdGVwX3NpemUlMjAqJTIwaSU1RCk=",highlighted:`<span class="hljs-comment"># Generating initial latent vectors from a random normal distribution, with the option to use a generator for reproducibility.</span>
latents = torch.randn(
    (<span class="hljs-number">1</span>, pipe.unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
    generator=generator,
)

walked_embeddings = []

<span class="hljs-comment"># Interpolating between embeddings for the given number of interpolation steps.</span>
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_interpolation_steps):
    walked_embeddings.append([prompt_embeds + step_size * i, negative_prompt_embeds + step_size * i])`,wrap:!1}}),ll=new U({props:{code:"JTIzJTIwR2VuZXJhdGluZyUyMGltYWdlcyUyMHVzaW5nJTIwdGhlJTIwaW50ZXJwb2xhdGVkJTIwZW1iZWRkaW5ncy4lMEFpbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjBsYXRlbnQlMjBpbiUyMHRxZG0od2Fsa2VkX2VtYmVkZGluZ3MpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VzLmFwcGVuZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhlaWdodCUzRGhlaWdodCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpZHRoJTNEd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRGxhdGVudCU1QjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbGF0ZW50JTVCMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0RudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhdGVudHMlM0RsYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKS5pbWFnZXMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIzJTIwRGlzcGxheSUyMG9mJTIwc2F2ZWQlMjBnZW5lcmF0ZWQlMjBpbWFnZXMuJTBBZGlzcGxheV9pbWFnZXMoaW1hZ2VzJTJDJTIwc2F2ZV9wYXRoKQ==",highlighted:`<span class="hljs-comment"># Generating images using the interpolated embeddings.</span>
images = []
<span class="hljs-keyword">for</span> latent <span class="hljs-keyword">in</span> tqdm(walked_embeddings):
    images.append(
        pipe(
            height=height,
            width=width,
            num_images_per_prompt=<span class="hljs-number">1</span>,
            prompt_embeds=latent[<span class="hljs-number">0</span>],
            negative_prompt_embeds=latent[<span class="hljs-number">1</span>],
            num_inference_steps=num_inference_steps,
            guidance_scale=guidance_scale,
            generator=generator,
            latents=latents,
        ).images
    )

<span class="hljs-comment"># Display of saved generated images.</span>
display_images(images, save_path)`,wrap:!1}}),el=new d({props:{title:"Example 2: Diffusion latents interpolation for a single prompt",local:"example-2-diffusion-latents-interpolation-for-a-single-prompt",headingTag:"h3"}}),Ml=new U({props:{code:"ZGVmJTIwc2xlcnAodjAlMkMlMjB2MSUyQyUyMG51bSUyQyUyMHQwJTNEMCUyQyUyMHQxJTNEMSklM0ElMEElMjAlMjAlMjAlMjB2MCUyMCUzRCUyMHYwLmRldGFjaCgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjB2MSUyMCUzRCUyMHYxLmRldGFjaCgpLmNwdSgpLm51bXB5KCklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBpbnRlcnBvbGF0aW9uKHQlMkMlMjB2MCUyQyUyMHYxJTJDJTIwRE9UX1RIUkVTSE9MRCUzRDAuOTk5NSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjJoZWxwZXIlMjBmdW5jdGlvbiUyMHRvJTIwc3BoZXJpY2FsbHklMjBpbnRlcnBvbGF0ZSUyMHR3byUyMGFycmF5cyUyMHYxJTIwdjIlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkb3QlMjAlM0QlMjBucC5zdW0odjAlMjAqJTIwdjElMjAlMkYlMjAobnAubGluYWxnLm5vcm0odjApJTIwKiUyMG5wLmxpbmFsZy5ub3JtKHYxKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBucC5hYnMoZG90KSUyMCUzRSUyMERPVF9USFJFU0hPTEQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2MiUyMCUzRCUyMCgxJTIwLSUyMHQpJTIwKiUyMHYwJTIwJTJCJTIwdCUyMColMjB2MSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aGV0YV8wJTIwJTNEJTIwbnAuYXJjY29zKGRvdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaW5fdGhldGFfMCUyMCUzRCUyMG5wLnNpbih0aGV0YV8wKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRoZXRhX3QlMjAlM0QlMjB0aGV0YV8wJTIwKiUyMHQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaW5fdGhldGFfdCUyMCUzRCUyMG5wLnNpbih0aGV0YV90KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHMwJTIwJTNEJTIwbnAuc2luKHRoZXRhXzAlMjAtJTIwdGhldGFfdCklMjAlMkYlMjBzaW5fdGhldGFfMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHMxJTIwJTNEJTIwc2luX3RoZXRhX3QlMjAlMkYlMjBzaW5fdGhldGFfMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHYyJTIwJTNEJTIwczAlMjAqJTIwdjAlMjAlMkIlMjBzMSUyMColMjB2MSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHYyJTBBJTBBJTIwJTIwJTIwJTIwdCUyMCUzRCUyMG5wLmxpbnNwYWNlKHQwJTJDJTIwdDElMkMlMjBudW0pJTBBJTBBJTIwJTIwJTIwJTIwdjMlMjAlM0QlMjB0b3JjaC50ZW5zb3IobnAuYXJyYXkoJTVCaW50ZXJwb2xhdGlvbih0JTVCaSU1RCUyQyUyMHYwJTJDJTIwdjEpJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobnVtKSU1RCkpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdjM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">slerp</span>(<span class="hljs-params">v0, v1, num, t0=<span class="hljs-number">0</span>, t1=<span class="hljs-number">1</span></span>):
    v0 = v0.detach().cpu().numpy()
    v1 = v1.detach().cpu().numpy()

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">interpolation</span>(<span class="hljs-params">t, v0, v1, DOT_THRESHOLD=<span class="hljs-number">0.9995</span></span>):
        <span class="hljs-string">&quot;&quot;&quot;helper function to spherically interpolate two arrays v1 v2&quot;&quot;&quot;</span>
        dot = np.<span class="hljs-built_in">sum</span>(v0 * v1 / (np.linalg.norm(v0) * np.linalg.norm(v1)))
        <span class="hljs-keyword">if</span> np.<span class="hljs-built_in">abs</span>(dot) &gt; DOT_THRESHOLD:
            v2 = (<span class="hljs-number">1</span> - t) * v0 + t * v1
        <span class="hljs-keyword">else</span>:
            theta_0 = np.arccos(dot)
            sin_theta_0 = np.sin(theta_0)
            theta_t = theta_0 * t
            sin_theta_t = np.sin(theta_t)
            s0 = np.sin(theta_0 - theta_t) / sin_theta_0
            s1 = sin_theta_t / sin_theta_0
            v2 = s0 * v0 + s1 * v1
        <span class="hljs-keyword">return</span> v2

    t = np.linspace(t0, t1, num)

    v3 = torch.tensor(np.array([interpolation(t[i], v0, v1) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num)]))

    <span class="hljs-keyword">return</span> v3`,wrap:!1}}),il=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># The text prompt that describes the desired output image.</span>
prompt = (
    <span class="hljs-string">&quot;Sci-fi digital painting of an alien landscape with otherworldly plants, strange creatures, and distant planets.&quot;</span>
)
<span class="hljs-comment"># A negative prompt that can be used to steer the generation away from certain features.</span>
negative_prompt = <span class="hljs-string">&quot;poorly drawn,cartoon, 3d, disfigured, bad art, deformed, poorly drawn, extra limbs, close up, b&amp;w, weird colors, blurry&quot;</span>

<span class="hljs-comment"># Generating initial latent vectors from a random normal distribution. In this example two latent vectors are generated, which will serve as start and end points for the interpolation.</span>
<span class="hljs-comment"># These vectors are shaped to fit the input requirements of the diffusion model&#x27;s U-Net architecture.</span>
latents = torch.randn(
    (<span class="hljs-number">2</span>, pipe.unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
    generator=generator,
)

<span class="hljs-comment"># Getting our latent embeddings</span>
interpolated_latents = slerp(latents[<span class="hljs-number">0</span>], latents[<span class="hljs-number">1</span>], num_interpolation_steps)

<span class="hljs-comment"># Generating images using the interpolated embeddings.</span>
images = []
<span class="hljs-keyword">for</span> latent_vector <span class="hljs-keyword">in</span> tqdm(interpolated_latents):
    images.append(
        pipe(
            prompt,
            height=height,
            width=width,
            negative_prompt=negative_prompt,
            num_images_per_prompt=<span class="hljs-number">1</span>,
            num_inference_steps=num_inference_steps,
            guidance_scale=guidance_scale,
            generator=generator,
            latents=latent_vector[<span class="hljs-literal">None</span>, ...],
        ).images
    )

<span class="hljs-comment"># Display of saved generated images.</span>
display_images(images, save_path)`,wrap:!1}}),pl=new d({props:{title:"Example 3: Interpolation between multiple prompts",local:"example-3-interpolation-between-multiple-prompts",headingTag:"h3"}}),Jl=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># Text prompts that describes the desired output image.</span>
prompts = [
    <span class="hljs-string">&quot;A cute dog in a beautiful field of lavander colorful flowers everywhere, perfect lighting, leica summicron 35mm f2.0, kodak portra 400, film grain&quot;</span>,
    <span class="hljs-string">&quot;A cute cat in a beautiful field of lavander colorful flowers everywhere, perfect lighting, leica summicron 35mm f2.0, kodak portra 400, film grain&quot;</span>,
]
<span class="hljs-comment"># Negative prompts that can be used to steer the generation away from certain features.</span>
negative_prompts = [
    <span class="hljs-string">&quot;poorly drawn,cartoon, 2d, sketch, cartoon, drawing, anime, disfigured, bad art, deformed, poorly drawn, extra limbs, close up, b&amp;w, weird colors, blurry&quot;</span>,
    <span class="hljs-string">&quot;poorly drawn,cartoon, 2d, sketch, cartoon, drawing, anime, disfigured, bad art, deformed, poorly drawn, extra limbs, close up, b&amp;w, weird colors, blurry&quot;</span>,
]

<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> The number of prompts must match the number of negative prompts</span>

batch_size = <span class="hljs-built_in">len</span>(prompts)

<span class="hljs-comment"># Tokenizing and encoding prompts into embeddings.</span>
prompts_tokens = pipe.tokenizer(
    prompts,
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    max_length=pipe.tokenizer.model_max_length,
    truncation=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
prompts_embeds = pipe.text_encoder(prompts_tokens.input_ids.to(device))[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Tokenizing and encoding negative prompts into embeddings.</span>
<span class="hljs-keyword">if</span> negative_prompts <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    negative_prompts = [<span class="hljs-string">&quot;&quot;</span>] * batch_size

negative_prompts_tokens = pipe.tokenizer(
    negative_prompts,
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    max_length=pipe.tokenizer.model_max_length,
    truncation=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
negative_prompts_embeds = pipe.text_encoder(negative_prompts_tokens.input_ids.to(device))[<span class="hljs-number">0</span>]`,wrap:!1}}),rl=new U({props:{code:"JTIzJTIwR2VuZXJhdGluZyUyMGluaXRpYWwlMjBVLU5ldCUyMGxhdGVudCUyMHZlY3RvcnMlMjBmcm9tJTIwYSUyMHJhbmRvbSUyMG5vcm1hbCUyMGRpc3RyaWJ1dGlvbi4lMEFsYXRlbnRzJTIwJTNEJTIwdG9yY2gucmFuZG4oJTBBJTIwJTIwJTIwJTIwKDElMkMlMjBwaXBlLnVuZXQuY29uZmlnLmluX2NoYW5uZWxzJTJDJTIwaGVpZ2h0JTIwJTJGJTJGJTIwOCUyQyUyMHdpZHRoJTIwJTJGJTJGJTIwOCklMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEEpJTBBJTBBJTIzJTIwSW50ZXJwb2xhdGluZyUyMGJldHdlZW4lMjBlbWJlZGRpbmdzJTIwcGFpcnMlMjBmb3IlMjB0aGUlMjBnaXZlbiUyMG51bWJlciUyMG9mJTIwaW50ZXJwb2xhdGlvbiUyMHN0ZXBzLiUwQWludGVycG9sYXRlZF9wcm9tcHRfZW1iZWRzJTIwJTNEJTIwJTVCJTVEJTBBaW50ZXJwb2xhdGVkX25lZ2F0aXZlX3Byb21wdHNfZW1iZWRzJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoYmF0Y2hfc2l6ZSUyMC0lMjAxKSUzQSUwQSUyMCUyMCUyMCUyMGludGVycG9sYXRlZF9wcm9tcHRfZW1iZWRzLmFwcGVuZChzbGVycChwcm9tcHRzX2VtYmVkcyU1QmklNUQlMkMlMjBwcm9tcHRzX2VtYmVkcyU1QmklMjAlMkIlMjAxJTVEJTJDJTIwbnVtX2ludGVycG9sYXRpb25fc3RlcHMpKSUwQSUyMCUyMCUyMCUyMGludGVycG9sYXRlZF9uZWdhdGl2ZV9wcm9tcHRzX2VtYmVkcy5hcHBlbmQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2xlcnAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0c19lbWJlZHMlNUJpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0c19lbWJlZHMlNUJpJTIwJTJCJTIwMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9pbnRlcnBvbGF0aW9uX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCklMEElMEFpbnRlcnBvbGF0ZWRfcHJvbXB0X2VtYmVkcyUyMCUzRCUyMHRvcmNoLmNhdChpbnRlcnBvbGF0ZWRfcHJvbXB0X2VtYmVkcyUyQyUyMGRpbSUzRDApLnRvKGRldmljZSklMEElMEFpbnRlcnBvbGF0ZWRfbmVnYXRpdmVfcHJvbXB0c19lbWJlZHMlMjAlM0QlMjB0b3JjaC5jYXQoaW50ZXJwb2xhdGVkX25lZ2F0aXZlX3Byb21wdHNfZW1iZWRzJTJDJTIwZGltJTNEMCkudG8oZGV2aWNlKQ==",highlighted:`<span class="hljs-comment"># Generating initial U-Net latent vectors from a random normal distribution.</span>
latents = torch.randn(
    (<span class="hljs-number">1</span>, pipe.unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
    generator=generator,
)

<span class="hljs-comment"># Interpolating between embeddings pairs for the given number of interpolation steps.</span>
interpolated_prompt_embeds = []
interpolated_negative_prompts_embeds = []
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size - <span class="hljs-number">1</span>):
    interpolated_prompt_embeds.append(slerp(prompts_embeds[i], prompts_embeds[i + <span class="hljs-number">1</span>], num_interpolation_steps))
    interpolated_negative_prompts_embeds.append(
        slerp(
            negative_prompts_embeds[i],
            negative_prompts_embeds[i + <span class="hljs-number">1</span>],
            num_interpolation_steps,
        )
    )

interpolated_prompt_embeds = torch.cat(interpolated_prompt_embeds, dim=<span class="hljs-number">0</span>).to(device)

interpolated_negative_prompts_embeds = torch.cat(interpolated_negative_prompts_embeds, dim=<span class="hljs-number">0</span>).to(device)`,wrap:!1}}),cl=new U({props:{code:"JTIzJTIwR2VuZXJhdGluZyUyMGltYWdlcyUyMHVzaW5nJTIwdGhlJTIwaW50ZXJwb2xhdGVkJTIwZW1iZWRkaW5ncy4lMEFpbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjBwcm9tcHRfZW1iZWRzJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2VtYmVkcyUyMGluJTIwdHFkbSglMEElMjAlMjAlMjAlMjB6aXAoaW50ZXJwb2xhdGVkX3Byb21wdF9lbWJlZHMlMkMlMjBpbnRlcnBvbGF0ZWRfbmVnYXRpdmVfcHJvbXB0c19lbWJlZHMpJTJDJTBBJTIwJTIwJTIwJTIwdG90YWwlM0RsZW4oaW50ZXJwb2xhdGVkX3Byb21wdF9lbWJlZHMpJTJDJTBBKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcy5hcHBlbmQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoZWlnaHQlM0RoZWlnaHQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aWR0aCUzRHdpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzJTVCTm9uZSUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTVCTm9uZSUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0RudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhdGVudHMlM0RsYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKS5pbWFnZXMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIzJTIwRGlzcGxheSUyMG9mJTIwc2F2ZWQlMjBnZW5lcmF0ZWQlMjBpbWFnZXMuJTBBZGlzcGxheV9pbWFnZXMoaW1hZ2VzJTJDJTIwc2F2ZV9wYXRoKQ==",highlighted:`<span class="hljs-comment"># Generating images using the interpolated embeddings.</span>
images = []
<span class="hljs-keyword">for</span> prompt_embeds, negative_prompt_embeds <span class="hljs-keyword">in</span> tqdm(
    <span class="hljs-built_in">zip</span>(interpolated_prompt_embeds, interpolated_negative_prompts_embeds),
    total=<span class="hljs-built_in">len</span>(interpolated_prompt_embeds),
):
    images.append(
        pipe(
            height=height,
            width=width,
            num_images_per_prompt=<span class="hljs-number">1</span>,
            prompt_embeds=prompt_embeds[<span class="hljs-literal">None</span>, ...],
            negative_prompt_embeds=negative_prompt_embeds[<span class="hljs-literal">None</span>, ...],
            num_inference_steps=num_inference_steps,
            guidance_scale=guidance_scale,
            generator=generator,
            latents=latents,
        ).images
    )

<span class="hljs-comment"># Display of saved generated images.</span>
display_images(images, save_path)`,wrap:!1}}),dl=new d({props:{title:"Example 4: Circular walk through the diffusion latent space for a single prompt",local:"example-4-circular-walk-through-the-diffusion-latent-space-for-a-single-prompt",headingTag:"h3"}}),bl=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># The text prompt that describes the desired output image.</span>
prompt = <span class="hljs-string">&quot;Beautiful sea sunset, warm light, Aivazovsky style&quot;</span>
<span class="hljs-comment"># A negative prompt that can be used to steer the generation away from certain features</span>
negative_prompt = <span class="hljs-string">&quot;picture frames&quot;</span>

<span class="hljs-comment"># Generating initial latent vectors from a random normal distribution to create a loop interpolation between them.</span>
latents = torch.randn(
    (<span class="hljs-number">2</span>, <span class="hljs-number">1</span>, pipe.unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
    generator=generator,
)


<span class="hljs-comment"># Calculation of looped embeddings</span>
walk_noise_x = latents[<span class="hljs-number">0</span>].to(device)
walk_noise_y = latents[<span class="hljs-number">1</span>].to(device)

<span class="hljs-comment"># Walking on a trigonometric circle</span>
walk_scale_x = torch.cos(torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, num_interpolation_steps) * np.pi).to(device)
walk_scale_y = torch.sin(torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, num_interpolation_steps) * np.pi).to(device)

<span class="hljs-comment"># Applying interpolation to noise</span>
noise_x = torch.tensordot(walk_scale_x, walk_noise_x, dims=<span class="hljs-number">0</span>)
noise_y = torch.tensordot(walk_scale_y, walk_noise_y, dims=<span class="hljs-number">0</span>)

circular_latents = noise_x + noise_y

<span class="hljs-comment"># Generating images using the interpolated embeddings.</span>
images = []
<span class="hljs-keyword">for</span> latent_vector <span class="hljs-keyword">in</span> tqdm(circular_latents):
    images.append(
        pipe(
            prompt,
            height=height,
            width=width,
            negative_prompt=negative_prompt,
            num_images_per_prompt=<span class="hljs-number">1</span>,
            num_inference_steps=num_inference_steps,
            guidance_scale=guidance_scale,
            generator=generator,
            latents=latent_vector,
        ).images
    )

<span class="hljs-comment"># Display of saved generated images.</span>
display_images(images, save_path)`,wrap:!1}}),ul=new d({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),Zl=new ft({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/stable_diffusion_interpolation.md"}}),{c(){c=M("meta"),Bl=a(),Cl=M("p"),fl=a(),o(T.$$.fragment),gl=a(),o(h.$$.fragment),Wl=a(),j=M("p"),j.innerHTML=_e,vl=a(),b=M("p"),b.textContent=Ee,Xl=a(),u=M("p"),u.textContent=He,Vl=a(),I=M("ul"),I.innerHTML=Se,kl=a(),Z=M("p"),Z.textContent=Qe,Rl=a(),C=M("p"),C.textContent=xe,Al=a(),G=M("p"),G.textContent=ze,Yl=a(),B=M("p"),B.textContent=Ne,_l=a(),o(f.$$.fragment),El=a(),g=M("p"),g.textContent=Fe,Hl=a(),o(W.$$.fragment),Sl=a(),v=M("p"),v.textContent=$e,Ql=a(),o(X.$$.fragment),xl=a(),V=M("p"),V.innerHTML=De,zl=a(),o(k.$$.fragment),Nl=a(),o(R.$$.fragment),Fl=a(),A=M("p"),A.innerHTML=Le,$l=a(),o(Y.$$.fragment),Dl=a(),_=M("p"),_.textContent=qe,Ll=a(),E=M("p"),E.innerHTML=Ke,ql=a(),o(H.$$.fragment),Kl=a(),S=M("p"),S.innerHTML=Pe,Pl=a(),o(Q.$$.fragment),Ol=a(),o(x.$$.fragment),le=a(),z=M("ul"),z.innerHTML=Oe,ee=a(),o(N.$$.fragment),te=a(),o(F.$$.fragment),se=a(),$=M("p"),$.textContent=lt,ae=a(),D=M("p"),D.innerHTML=et,ne=a(),L=M("p"),L.textContent=tt,Me=a(),o(q.$$.fragment),ie=a(),K=M("p"),K.textContent=st,pe=a(),o(P.$$.fragment),oe=a(),O=M("p"),O.innerHTML=at,ye=a(),o(ll.$$.fragment),me=a(),o(el.$$.fragment),Je=a(),tl=M("p"),tl.textContent=nt,we=a(),sl=M("p"),sl.innerHTML=Mt,re=a(),al=M("p"),al.textContent=it,Ue=a(),nl=M("p"),nl.innerHTML=pt,ce=a(),o(Ml.$$.fragment),de=a(),o(il.$$.fragment),Te=a(),o(pl.$$.fragment),he=a(),ol=M("p"),ol.textContent=ot,je=a(),yl=M("p"),yl.innerHTML=yt,be=a(),ml=M("p"),ml.textContent=mt,ue=a(),o(Jl.$$.fragment),Ie=a(),wl=M("p"),wl.innerHTML=Jt,Ze=a(),o(rl.$$.fragment),Ce=a(),Ul=M("p"),Ul.textContent=wt,Ge=a(),o(cl.$$.fragment),Be=a(),o(dl.$$.fragment),fe=a(),Tl=M("p"),Tl.innerHTML=rt,ge=a(),hl=M("p"),hl.textContent=Ut,We=a(),jl=M("p"),jl.innerHTML=ct,ve=a(),o(bl.$$.fragment),Xe=a(),o(ul.$$.fragment),Ve=a(),Il=M("p"),Il.innerHTML=dt,ke=a(),o(Zl.$$.fragment),Re=a(),Gl=M("p"),this.h()},l(l){const e=Ct("svelte-u9bgzb",document.head);c=i(e,"META",{name:!0,content:!0}),e.forEach(t),Bl=n(l),Cl=i(l,"P",{}),Tt(Cl).forEach(t),fl=n(l),y(T.$$.fragment,l),gl=n(l),y(h.$$.fragment,l),Wl=n(l),j=i(l,"P",{"data-svelte-h":!0}),p(j)!=="svelte-xo5wq0"&&(j.innerHTML=_e),vl=n(l),b=i(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-13o2aov"&&(b.textContent=Ee),Xl=n(l),u=i(l,"P",{"data-svelte-h":!0}),p(u)!=="svelte-ubo7tx"&&(u.textContent=He),Vl=n(l),I=i(l,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-he0og3"&&(I.innerHTML=Se),kl=n(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1pybxoa"&&(Z.textContent=Qe),Rl=n(l),C=i(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-axm9ar"&&(C.textContent=xe),Al=n(l),G=i(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-16porze"&&(G.textContent=ze),Yl=n(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-13zokni"&&(B.textContent=Ne),_l=n(l),y(f.$$.fragment,l),El=n(l),g=i(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1tw65d0"&&(g.textContent=Fe),Hl=n(l),y(W.$$.fragment,l),Sl=n(l),v=i(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1hwxkpg"&&(v.textContent=$e),Ql=n(l),y(X.$$.fragment,l),xl=n(l),V=i(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-157lcra"&&(V.innerHTML=De),zl=n(l),y(k.$$.fragment,l),Nl=n(l),y(R.$$.fragment,l),Fl=n(l),A=i(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1xuhc40"&&(A.innerHTML=Le),$l=n(l),y(Y.$$.fragment,l),Dl=n(l),_=i(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-ule0bd"&&(_.textContent=qe),Ll=n(l),E=i(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1cnpf90"&&(E.innerHTML=Ke),ql=n(l),y(H.$$.fragment,l),Kl=n(l),S=i(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1x293fi"&&(S.innerHTML=Pe),Pl=n(l),y(Q.$$.fragment,l),Ol=n(l),y(x.$$.fragment,l),le=n(l),z=i(l,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-avta92"&&(z.innerHTML=Oe),ee=n(l),y(N.$$.fragment,l),te=n(l),y(F.$$.fragment,l),se=n(l),$=i(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-t1vj9q"&&($.textContent=lt),ae=n(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1x05mg4"&&(D.innerHTML=et),ne=n(l),L=i(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-19kzzzg"&&(L.textContent=tt),Me=n(l),y(q.$$.fragment,l),ie=n(l),K=i(l,"P",{"data-svelte-h":!0}),p(K)!=="svelte-szx5hm"&&(K.textContent=st),pe=n(l),y(P.$$.fragment,l),oe=n(l),O=i(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1oqz59z"&&(O.innerHTML=at),ye=n(l),y(ll.$$.fragment,l),me=n(l),y(el.$$.fragment,l),Je=n(l),tl=i(l,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-1y6nb0t"&&(tl.textContent=nt),we=n(l),sl=i(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-zqtywg"&&(sl.innerHTML=Mt),re=n(l),al=i(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-1it4256"&&(al.textContent=it),Ue=n(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-1winyti"&&(nl.innerHTML=pt),ce=n(l),y(Ml.$$.fragment,l),de=n(l),y(il.$$.fragment,l),Te=n(l),y(pl.$$.fragment,l),he=n(l),ol=i(l,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-15a2nb7"&&(ol.textContent=ot),je=n(l),yl=i(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-1uv5js0"&&(yl.innerHTML=yt),be=n(l),ml=i(l,"P",{"data-svelte-h":!0}),p(ml)!=="svelte-u335b5"&&(ml.textContent=mt),ue=n(l),y(Jl.$$.fragment,l),Ie=n(l),wl=i(l,"P",{"data-svelte-h":!0}),p(wl)!=="svelte-1rpvl23"&&(wl.innerHTML=Jt),Ze=n(l),y(rl.$$.fragment,l),Ce=n(l),Ul=i(l,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-1sxcfxg"&&(Ul.textContent=wt),Ge=n(l),y(cl.$$.fragment,l),Be=n(l),y(dl.$$.fragment,l),fe=n(l),Tl=i(l,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-pjhh7v"&&(Tl.innerHTML=rt),ge=n(l),hl=i(l,"P",{"data-svelte-h":!0}),p(hl)!=="svelte-1v4hr5x"&&(hl.textContent=Ut),We=n(l),jl=i(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-1h51p8s"&&(jl.innerHTML=ct),ve=n(l),y(bl.$$.fragment,l),Xe=n(l),y(ul.$$.fragment,l),Ve=n(l),Il=i(l,"P",{"data-svelte-h":!0}),p(Il)!=="svelte-a25mhu"&&(Il.innerHTML=dt),ke=n(l),y(Zl.$$.fragment,l),Re=n(l),Gl=i(l,"P",{}),Tt(Gl).forEach(t),this.h()},h(){ht(c,"name","hf:doc:metadata"),ht(c,"content",Wt)},m(l,e){Gt(document.head,c),s(l,Bl,e),s(l,Cl,e),s(l,fl,e),m(T,l,e),s(l,gl,e),m(h,l,e),s(l,Wl,e),s(l,j,e),s(l,vl,e),s(l,b,e),s(l,Xl,e),s(l,u,e),s(l,Vl,e),s(l,I,e),s(l,kl,e),s(l,Z,e),s(l,Rl,e),s(l,C,e),s(l,Al,e),s(l,G,e),s(l,Yl,e),s(l,B,e),s(l,_l,e),m(f,l,e),s(l,El,e),s(l,g,e),s(l,Hl,e),m(W,l,e),s(l,Sl,e),s(l,v,e),s(l,Ql,e),m(X,l,e),s(l,xl,e),s(l,V,e),s(l,zl,e),m(k,l,e),s(l,Nl,e),m(R,l,e),s(l,Fl,e),s(l,A,e),s(l,$l,e),m(Y,l,e),s(l,Dl,e),s(l,_,e),s(l,Ll,e),s(l,E,e),s(l,ql,e),m(H,l,e),s(l,Kl,e),s(l,S,e),s(l,Pl,e),m(Q,l,e),s(l,Ol,e),m(x,l,e),s(l,le,e),s(l,z,e),s(l,ee,e),m(N,l,e),s(l,te,e),m(F,l,e),s(l,se,e),s(l,$,e),s(l,ae,e),s(l,D,e),s(l,ne,e),s(l,L,e),s(l,Me,e),m(q,l,e),s(l,ie,e),s(l,K,e),s(l,pe,e),m(P,l,e),s(l,oe,e),s(l,O,e),s(l,ye,e),m(ll,l,e),s(l,me,e),m(el,l,e),s(l,Je,e),s(l,tl,e),s(l,we,e),s(l,sl,e),s(l,re,e),s(l,al,e),s(l,Ue,e),s(l,nl,e),s(l,ce,e),m(Ml,l,e),s(l,de,e),m(il,l,e),s(l,Te,e),m(pl,l,e),s(l,he,e),s(l,ol,e),s(l,je,e),s(l,yl,e),s(l,be,e),s(l,ml,e),s(l,ue,e),m(Jl,l,e),s(l,Ie,e),s(l,wl,e),s(l,Ze,e),m(rl,l,e),s(l,Ce,e),s(l,Ul,e),s(l,Ge,e),m(cl,l,e),s(l,Be,e),m(dl,l,e),s(l,fe,e),s(l,Tl,e),s(l,ge,e),s(l,hl,e),s(l,We,e),s(l,jl,e),s(l,ve,e),m(bl,l,e),s(l,Xe,e),m(ul,l,e),s(l,Ve,e),s(l,Il,e),s(l,ke,e),m(Zl,l,e),s(l,Re,e),s(l,Gl,e),Ae=!0},p:bt,i(l){Ae||(J(T.$$.fragment,l),J(h.$$.fragment,l),J(f.$$.fragment,l),J(W.$$.fragment,l),J(X.$$.fragment,l),J(k.$$.fragment,l),J(R.$$.fragment,l),J(Y.$$.fragment,l),J(H.$$.fragment,l),J(Q.$$.fragment,l),J(x.$$.fragment,l),J(N.$$.fragment,l),J(F.$$.fragment,l),J(q.$$.fragment,l),J(P.$$.fragment,l),J(ll.$$.fragment,l),J(el.$$.fragment,l),J(Ml.$$.fragment,l),J(il.$$.fragment,l),J(pl.$$.fragment,l),J(Jl.$$.fragment,l),J(rl.$$.fragment,l),J(cl.$$.fragment,l),J(dl.$$.fragment,l),J(bl.$$.fragment,l),J(ul.$$.fragment,l),J(Zl.$$.fragment,l),Ae=!0)},o(l){w(T.$$.fragment,l),w(h.$$.fragment,l),w(f.$$.fragment,l),w(W.$$.fragment,l),w(X.$$.fragment,l),w(k.$$.fragment,l),w(R.$$.fragment,l),w(Y.$$.fragment,l),w(H.$$.fragment,l),w(Q.$$.fragment,l),w(x.$$.fragment,l),w(N.$$.fragment,l),w(F.$$.fragment,l),w(q.$$.fragment,l),w(P.$$.fragment,l),w(ll.$$.fragment,l),w(el.$$.fragment,l),w(Ml.$$.fragment,l),w(il.$$.fragment,l),w(pl.$$.fragment,l),w(Jl.$$.fragment,l),w(rl.$$.fragment,l),w(cl.$$.fragment,l),w(dl.$$.fragment,l),w(bl.$$.fragment,l),w(ul.$$.fragment,l),w(Zl.$$.fragment,l),Ae=!1},d(l){l&&(t(Bl),t(Cl),t(fl),t(gl),t(Wl),t(j),t(vl),t(b),t(Xl),t(u),t(Vl),t(I),t(kl),t(Z),t(Rl),t(C),t(Al),t(G),t(Yl),t(B),t(_l),t(El),t(g),t(Hl),t(Sl),t(v),t(Ql),t(xl),t(V),t(zl),t(Nl),t(Fl),t(A),t($l),t(Dl),t(_),t(Ll),t(E),t(ql),t(Kl),t(S),t(Pl),t(Ol),t(le),t(z),t(ee),t(te),t(se),t($),t(ae),t(D),t(ne),t(L),t(Me),t(ie),t(K),t(pe),t(oe),t(O),t(ye),t(me),t(Je),t(tl),t(we),t(sl),t(re),t(al),t(Ue),t(nl),t(ce),t(de),t(Te),t(he),t(ol),t(je),t(yl),t(be),t(ml),t(ue),t(Ie),t(wl),t(Ze),t(Ce),t(Ul),t(Ge),t(Be),t(fe),t(Tl),t(ge),t(hl),t(We),t(jl),t(ve),t(Xe),t(Ve),t(Il),t(ke),t(Re),t(Gl)),t(c),r(T,l),r(h,l),r(f,l),r(W,l),r(X,l),r(k,l),r(R,l),r(Y,l),r(H,l),r(Q,l),r(x,l),r(N,l),r(F,l),r(q,l),r(P,l),r(ll,l),r(el,l),r(Ml,l),r(il,l),r(pl,l),r(Jl,l),r(rl,l),r(cl,l),r(dl,l),r(bl,l),r(ul,l),r(Zl,l)}}}const Wt='{"title":"Images Interpolation with Stable Diffusion","local":"images-interpolation-with-stable-diffusion","sections":[{"title":"Model","local":"model","sections":[],"depth":3},{"title":"Generation parameters","local":"generation-parameters","sections":[],"depth":3},{"title":"Example 1: Prompt interpolation","local":"example-1-prompt-interpolation","sections":[],"depth":3},{"title":"Example 2: Diffusion latents interpolation for a single prompt","local":"example-2-diffusion-latents-interpolation-for-a-single-prompt","sections":[],"depth":3},{"title":"Example 3: Interpolation between multiple prompts","local":"example-3-interpolation-between-multiple-prompts","sections":[],"depth":3},{"title":"Example 4: Circular walk through the diffusion latent space for a single prompt","local":"example-4-circular-walk-through-the-diffusion-latent-space-for-a-single-prompt","sections":[],"depth":3}],"depth":2}';function vt(Ye){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends It{constructor(c){super(),Zt(this,c,vt,gt,jt,{})}}export{At as component};
