import{s as zt,o as Vt,n as Rt}from"../chunks/scheduler.6062bdaf.js";import{S as Xt,i as Bt,g as s,s as r,r as g,A as Wt,h as d,f as o,c as n,j as $,u,x as f,k as M,y as t,a as m,v as h,d as _,t as x,w as b}from"../chunks/index.4bca734e.js";import{T as Gt}from"../chunks/Tip.b9ac1f03.js";import{D as C}from"../chunks/Docstring.d7918b6d.js";import{C as Zt}from"../chunks/CodeBlock.fa01571c.js";import{E as Yt}from"../chunks/ExampleCodeBlock.d27cbfa4.js";import{H as Ce,E as Qt}from"../chunks/EditOnGithub.74ab2baa.js";function Kt(me){let p,F="It is possible to know which tasks are supported for a model for a given backend, by doing:",v,k,y;return k=new Zt({props:{code:"ZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzLnRhc2tzJTIwaW1wb3J0JTIwVGFza3NNYW5hZ2VyJTBBJTBBbW9kZWxfdHlwZSUyMCUzRCUyMCUyMmRpc3RpbGJlcnQlMjIlMEElMjMlMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGZvciUyMHRoZSUyME9OTlglMjBleHBvcnQuJTBBYmFja2VuZCUyMCUzRCUyMCUyMm9ubnglMjIlMEFkaXN0aWxiZXJ0X3Rhc2tzJTIwJTNEJTIwbGlzdChUYXNrc01hbmFnZXIuZ2V0X3N1cHBvcnRlZF90YXNrc19mb3JfbW9kZWxfdHlwZShtb2RlbF90eXBlJTJDJTIwYmFja2VuZCkua2V5cygpKSUwQSUwQXByaW50KGRpc3RpbGJlcnRfdGFza3Mp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.tasks <span class="hljs-keyword">import</span> TasksManager

<span class="hljs-meta">&gt;&gt;&gt; </span>model_type = <span class="hljs-string">&quot;distilbert&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, for the ONNX export.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>backend = <span class="hljs-string">&quot;onnx&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>distilbert_tasks = <span class="hljs-built_in">list</span>(TasksManager.get_supported_tasks_for_model_type(model_type, backend).keys())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(distilbert_tasks)
[<span class="hljs-string">&#x27;default&#x27;</span>, <span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;text-classification&#x27;</span>, <span class="hljs-string">&#x27;multiple-choice&#x27;</span>, <span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;question-answering&#x27;</span>]`,wrap:!1}}),{c(){p=s("p"),p.textContent=F,v=r(),g(k.$$.fragment)},l(i){p=d(i,"P",{"data-svelte-h":!0}),f(p)!=="svelte-af61zr"&&(p.textContent=F),v=n(i),u(k.$$.fragment,i)},m(i,T){m(i,p,T),m(i,v,T),h(k,i,T),y=!0},p:Rt,i(i){y||(_(k.$$.fragment,i),y=!0)},o(i){x(k.$$.fragment,i),y=!1},d(i){i&&(o(p),o(v)),b(k,i)}}}function eo(me){let p,F="Example:",v,k,y;return k=new Zt({props:{code:"cmVnaXN0ZXJfZm9yX25ld19iYWNrZW5kJTIwJTNEJTIwY3JlYXRlX3JlZ2lzdGVyKCUyMm5ldy1iYWNrZW5kJTIyKSUwQSUwQSU0MHJlZ2lzdGVyX2Zvcl9uZXdfYmFja2VuZCglMjJiZXJ0JTIyJTJDJTIwJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMCUyMnRva2VuLWNsYXNzaWZpY2F0aW9uJTIyKSUwQWNsYXNzJTIwQmVydE5ld0JhY2tlbmRDb25maWcoTmV3QmFja2VuZENvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>register_for_new_backend = create_register(<span class="hljs-string">&quot;new-backend&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>@register_for_new_backend(<span class="hljs-string">&quot;bert&quot;</span>, <span class="hljs-string">&quot;text-classification&quot;</span>, <span class="hljs-string">&quot;token-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">BertNewBackendConfig</span>(<span class="hljs-title class_ inherited__">NewBackendConfig</span>):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">pass</span>`,wrap:!1}}),{c(){p=s("p"),p.textContent=F,v=r(),g(k.$$.fragment)},l(i){p=d(i,"P",{"data-svelte-h":!0}),f(p)!=="svelte-11lpom8"&&(p.textContent=F),v=n(i),u(k.$$.fragment,i)},m(i,T){m(i,p,T),m(i,v,T),h(k,i,T),y=!0},p:Rt,i(i){y||(_(k.$$.fragment,i),y=!0)},o(i){x(k.$$.fragment,i),y=!1},d(i){i&&(o(p),o(v)),b(k,i)}}}function to(me){let p,F,v,k,y,i,T,Tt="Exporting a model from one framework to some format (also called backend here) involves specifying inputs and outputs information that the export function needs. The way <code>optimum.exporters</code> is structured for each backend is as follows:",Fe,R,$t="<li>Configuration classes containing the information for each model to perform the export.</li> <li>Exporting functions using the proper configuration for the model to export.</li>",De,Z,Mt='The role of the <a href="/docs/optimum/pr_1948/en/exporters/task_manager#optimum.exporters.TasksManager">TasksManager</a> is to be the main entry-point to load a model given a name and a task, and to get the proper configuration for a given (architecture, backend) couple. That way, there is a centralized place to register the <code>task -&gt; model class</code> and <code>(architecture, backend) -&gt; configuration</code> mappings. This allows the export functions to use this, and to rely on the various checks it provides.',Ne,z,je,V,wt="The tasks supported might depend on the backend, but here are the mappings between a task name and the auto class for both PyTorch and TensorFlow.",Pe,j,He,X,qe,B,Ct="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-generation</code>, <code>text-generation-with-past</code></td> <td><code>AutoModelForCausalLM</code></td></tr> <tr><td><code>feature-extraction</code>, <code>feature-extraction-with-past</code></td> <td><code>AutoModel</code></td></tr> <tr><td><code>fill-mask</code></td> <td><code>AutoModelForMaskedLM</code></td></tr> <tr><td><code>question-answering</code></td> <td><code>AutoModelForQuestionAnswering</code></td></tr> <tr><td><code>text2text-generation</code>, <code>text2text-generation-with-past</code></td> <td><code>AutoModelForSeq2SeqLM</code></td></tr> <tr><td><code>text-classification</code></td> <td><code>AutoModelForSequenceClassification</code></td></tr> <tr><td><code>token-classification</code></td> <td><code>AutoModelForTokenClassification</code></td></tr> <tr><td><code>multiple-choice</code></td> <td><code>AutoModelForMultipleChoice</code></td></tr> <tr><td><code>image-classification</code></td> <td><code>AutoModelForImageClassification</code></td></tr> <tr><td><code>object-detection</code></td> <td><code>AutoModelForObjectDetection</code></td></tr> <tr><td><code>image-segmentation</code></td> <td><code>AutoModelForImageSegmentation</code></td></tr> <tr><td><code>masked-im</code></td> <td><code>AutoModelForMaskedImageModeling</code></td></tr> <tr><td><code>semantic-segmentation</code></td> <td><code>AutoModelForSemanticSegmentation</code></td></tr> <tr><td><code>automatic-speech-recognition</code></td> <td><code>AutoModelForSpeechSeq2Seq</code></td></tr></tbody>",Ie,W,Ae,G,Ft="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-generation</code>, <code>text-generation-with-past</code></td> <td><code>TFAutoModelForCausalLM</code></td></tr> <tr><td><code>default</code>, <code>default-with-past</code></td> <td><code>TFAutoModel</code></td></tr> <tr><td><code>fill-mask</code></td> <td><code>TFAutoModelForMaskedLM</code></td></tr> <tr><td><code>question-answering</code></td> <td><code>TFAutoModelForQuestionAnswering</code></td></tr> <tr><td><code>text2text-generation</code>, <code>text2text-generation-with-past</code></td> <td><code>TFAutoModelForSeq2SeqLM</code></td></tr> <tr><td><code>text-classification</code></td> <td><code>TFAutoModelForSequenceClassification</code></td></tr> <tr><td><code>token-classification</code></td> <td><code>TFAutoModelForTokenClassification</code></td></tr> <tr><td><code>multiple-choice</code></td> <td><code>TFAutoModelForMultipleChoice</code></td></tr> <tr><td><code>semantic-segmentation</code></td> <td><code>TFAutoModelForSemanticSegmentation</code></td></tr></tbody>",Oe,Y,Ue,l,Q,Ye,pe,Dt="Handles the <code>task name -&gt; model class</code> and <code>architecture -&gt; configuration</code> mappings.",Qe,D,K,Ke,ge,Nt="Creates a register function for the specified backend.",et,P,tt,w,ee,ot,ue,jt="Determines the framework to use for the export.",rt,fe,Pt="The priority is in the following order:",nt,he,Ht="<li>User input via <code>framework</code>.</li> <li>If local checkpoint is provided, use the same framework as the checkpoint.</li> <li>If model repo, try to infer the framework from the cache if available, else from the Hub.</li> <li>If could not infer, use available framework in environment, with priority given to PyTorch.</li>",at,H,te,st,_e,qt="Retrieves all the possible tasks.",dt,q,oe,it,xe,It="Gets the <code>ExportConfigConstructor</code> for a model (or alternatively for a model type) and task combination.",lt,I,re,ct,be,At="Attempts to retrieve an AutoModel class from a task name.",mt,A,ne,pt,ke,Ot="Retrieves a model from its name and the task to be enabled.",gt,O,ae,ut,ye,Ut="Returns the list of supported architectures by the exporter for a given task. Transformers-specific.",ft,U,se,ht,ve,Lt="Retrieves the <code>task -&gt; exporter backend config constructors</code> map from the model type.",_t,L,de,xt,Te,Et="Infers the library from the model repo.",bt,E,ie,kt,$e,Jt="Infers the task from the model repo.",yt,J,le,vt,Me,St=`Updates the model for export. This function is suitable to make required changes to the models from different
libraries to follow transformers style.`,Le,ce,Ee,we,Je;return y=new Ce({props:{title:"The Tasks Manager",local:"the-tasks-manager",headingTag:"h1"}}),z=new Ce({props:{title:"Task names",local:"task-names",headingTag:"h2"}}),j=new Gt({props:{$$slots:{default:[Kt]},$$scope:{ctx:me}}}),X=new Ce({props:{title:"PyTorch",local:"pytorch",headingTag:"h3"}}),W=new Ce({props:{title:"TensorFlow",local:"tensorflow",headingTag:"h3"}}),Y=new Ce({props:{title:"Reference",local:"optimum.exporters.TasksManager",headingTag:"h2"}}),Q=new C({props:{name:"class optimum.exporters.TasksManager",anchor:"optimum.exporters.TasksManager",parameters:[],source:"https://github.com/huggingface/optimum/blob/vr_1948/optimum/exporters/tasks.py#L141"}}),K=new C({props:{name:"create_register",anchor:"optimum.exporters.TasksManager.create_register",parameters:[{name:"backend",val:": str"},{name:"overwrite_existing",val:": bool = False"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.create_register.backend",description:`<strong>backend</strong> (<code>str</code>) &#x2014;
The name of the backend that the register function will handle.`,name:"backend"},{anchor:"optimum.exporters.TasksManager.create_register.overwrite_existing",description:`<strong>overwrite_existing</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not the register function is allowed to overwrite an already existing config.`,name:"overwrite_existing"}],source:"https://github.com/huggingface/optimum/blob/vr_1948/optimum/exporters/tasks.py#L1144",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A decorator taking the model type and a the
supported tasks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Callable[[str, Tuple[str, ...]], Callable[[Type], Type]]</code></p>
`}}),P=new Yt({props:{anchor:"optimum.exporters.TasksManager.create_register.example",$$slots:{default:[eo]},$$scope:{ctx:me}}}),ee=new C({props:{name:"determine_framework",anchor:"optimum.exporters.TasksManager.determine_framework",parameters:[{name:"model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"subfolder",val:": str = ''"},{name:"framework",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/root/.cache/huggingface/hub'"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.determine_framework.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either the model id of a model repo on the Hugging Face Hub, or a path to a local directory
containing a model.`,name:"model_name_or_path"},{anchor:"optimum.exporters.TasksManager.determine_framework.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.determine_framework.framework",description:`<strong>framework</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The framework to use for the export. See above for priority if none provided.`,name:"framework"}],source:"https://github.com/huggingface/optimum/blob/vr_1948/optimum/exporters/tasks.py#L1450",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The framework to use for the export.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),te=new C({props:{name:"get_all_tasks",anchor:"optimum.exporters.TasksManager.get_all_tasks",parameters:[],source:"https://github.com/huggingface/optimum/blob/vr_1948/optimum/exporters/tasks.py#L1852",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>all the possible tasks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`}}),oe=new C({props:{name:"get_exporter_config_constructor",anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor",parameters:[{name:"exporter",val:": str"},{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel'), NoneType] = None"},{name:"task",val:": str = 'feature-extraction'"},{name:"model_type",val:": typing.Optional[str] = None"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"exporter_config_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"library_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.exporter",description:`<strong>exporter</strong> (<code>str</code>) &#x2014;
The exporter to use.`,name:"exporter"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.model",description:`<strong>model</strong> (<code>Optional[Union[PreTrainedModel, TFPreTrainedModel]]</code>, defaults to <code>None</code>) &#x2014;
The instance of the model.`,name:"model"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;feature-extraction&quot;</code>) &#x2014;
The task to retrieve the config for.`,name:"task"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.model_type",description:`<strong>model_type</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The model type to retrieve the config for.`,name:"model_type"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.model_name",description:`<strong>model_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The name attribute of the model object, only used for the exception message.`,name:"model_name"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.exporter_config_kwargs",description:`<strong>exporter_config_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Arguments that will be passed to the exporter config class when building the config constructor.`,name:"exporter_config_kwargs"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/vr_1948/optimum/exporters/tasks.py#L2007",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>ExportConfig</code> constructor for the requested backend.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ExportConfigConstructor</code></p>
`}}),re=new C({props:{name:"get_model_class_for_task",anchor:"optimum.exporters.TasksManager.get_model_class_for_task",parameters:[{name:"task",val:": str"},{name:"framework",val:": str = 'pt'"},{name:"model_type",val:": typing.Optional[str] = None"},{name:"model_class_name",val:": typing.Optional[str] = None"},{name:"library",val:": str = 'transformers'"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task required.`,name:"task"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.framework",description:`<strong>framework</strong> (<code>str</code>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The framework to use for the export.`,name:"framework"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.model_type",description:`<strong>model_type</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The model type to retrieve the model class for. Some architectures need a custom class to be loaded,
and can not be loaded from auto class.`,name:"model_type"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.model_class_name",description:`<strong>model_class_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
A model class name, allowing to override the default class that would be detected for the task. This
parameter is useful for example for &#x201C;automatic-speech-recognition&#x201D;, that may map to
AutoModelForSpeechSeq2Seq or to AutoModelForCTC.`,name:"model_class_name"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.library",description:`<strong>library</strong> (<code>str</code>, defaults to <code>transformers</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library"}],source:"https://github.com/huggingface/optimum/blob/vr_1948/optimum/exporters/tasks.py#L1302",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The AutoModel class corresponding to the task.</p>
`}}),ne=new C({props:{name:"get_model_from_task",anchor:"optimum.exporters.TasksManager.get_model_from_task",parameters:[{name:"task",val:": str"},{name:"model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"framework",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/root/.cache/huggingface/hub'"},{name:"torch_dtype",val:": typing.Optional[ForwardRef('torch.dtype')] = None"},{name:"device",val:": typing.Union[ForwardRef('torch.device'), str, NoneType] = None"},{name:"library_name",val:": str = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_model_from_task.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task required.`,name:"task"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either the model id of a model repo on the Hugging Face Hub, or a path to a local directory
containing a model.`,name:"model_name_or_path"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.framework",description:`<strong>framework</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The framework to use for the export. See <code>TasksManager.determine_framework</code> for the priority should
none be provided.`,name:"framework"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.torch_dtype",description:`<strong>torch_dtype</strong> (<code>Optional[torch.dtype]</code>, defaults to <code>None</code>) &#x2014;
Data type to load the model on. PyTorch-only argument.`,name:"torch_dtype"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
Device to initialize the model on. PyTorch-only argument. For PyTorch, defaults to &#x201C;cpu&#x201D;.`,name:"device"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Keyword arguments to pass to the model <code>.from_pretrained()</code> method.`,name:"model_kwargs"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;. See <code>TasksManager.infer_library_from_model</code> for the priority should
none be provided.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/vr_1948/optimum/exporters/tasks.py#L1874",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The instance of the model.</p>
`}}),ae=new C({props:{name:"get_supported_model_type_for_task",anchor:"optimum.exporters.TasksManager.get_supported_model_type_for_task",parameters:[{name:"task",val:": str"},{name:"exporter",val:": str"}],source:"https://github.com/huggingface/optimum/blob/vr_1948/optimum/exporters/tasks.py#L1261"}}),se=new C({props:{name:"get_supported_tasks_for_model_type",anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type",parameters:[{name:"model_type",val:": str"},{name:"exporter",val:": str"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"library_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.model_type",description:`<strong>model_type</strong> (<code>str</code>) &#x2014;
The model type to retrieve the supported tasks for.`,name:"model_type"},{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.exporter",description:`<strong>exporter</strong> (<code>str</code>) &#x2014;
The name of the exporter.`,name:"exporter"},{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.model_name",description:`<strong>model_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The name attribute of the model object, only used for the exception message.`,name:"model_name"},{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/vr_1948/optimum/exporters/tasks.py#L1199",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary mapping each task to a corresponding <code>ExportConfig</code>
constructor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>TaskNameToExportConfigDict</code></p>
`}}),de=new C({props:{name:"infer_library_from_model",anchor:"optimum.exporters.TasksManager.infer_library_from_model",parameters:[{name:"model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/root/.cache/huggingface/hub'"},{name:"library_name",val:": typing.Optional[str] = None"},{name:"use_auth_token",val:": typing.Union[str, bool, NoneType] = None"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.infer_library_from_model.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>str</code>) &#x2014;
The model to infer the task from. This can either be the name of a repo on the HuggingFace Hub, an
instance of a model, or a model class.`,name:"model_name_or_path"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library_name"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
Deprecated. Please use the <code>token</code> argument instead.`,name:"use_auth_token"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"}],source:"https://github.com/huggingface/optimum/blob/vr_1948/optimum/exporters/tasks.py#L1713",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The library name automatically detected from the model repo.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),ie=new C({props:{name:"infer_task_from_model",anchor:"optimum.exporters.TasksManager.infer_task_from_model",parameters:[{name:"model",val:": typing.Union[str, ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel'), typing.Type]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.infer_task_from_model.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to infer the task from. This can either be the name of a repo on the HuggingFace Hub, an
instance of a model, or a model class.`,name:"model"},{anchor:"optimum.exporters.TasksManager.infer_task_from_model.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.infer_task_from_model.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>,  defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"}],source:"https://github.com/huggingface/optimum/blob/vr_1948/optimum/exporters/tasks.py#L1654",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The task name automatically detected from the model repo.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),le=new C({props:{name:"standardize_model_attributes",anchor:"optimum.exporters.TasksManager.standardize_model_attributes",parameters:[{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel')]"},{name:"library_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either the model id of a model repo on the Hugging Face Hub, or a path to a local directory
containing a model.`,name:"model_name_or_path"},{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.model",description:`<strong>model</strong> (<code>Union[PreTrainedModel, TFPreTrainedModel]</code>) &#x2014;
The instance of the model.`,name:"model"},{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;:
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/vr_1948/optimum/exporters/tasks.py#L1800"}}),ce=new Qt({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/exporters/task_manager.mdx"}}),{c(){p=s("meta"),F=r(),v=s("p"),k=r(),g(y.$$.fragment),i=r(),T=s("p"),T.innerHTML=Tt,Fe=r(),R=s("ul"),R.innerHTML=$t,De=r(),Z=s("p"),Z.innerHTML=Mt,Ne=r(),g(z.$$.fragment),je=r(),V=s("p"),V.textContent=wt,Pe=r(),g(j.$$.fragment),He=r(),g(X.$$.fragment),qe=r(),B=s("table"),B.innerHTML=Ct,Ie=r(),g(W.$$.fragment),Ae=r(),G=s("table"),G.innerHTML=Ft,Oe=r(),g(Y.$$.fragment),Ue=r(),l=s("div"),g(Q.$$.fragment),Ye=r(),pe=s("p"),pe.innerHTML=Dt,Qe=r(),D=s("div"),g(K.$$.fragment),Ke=r(),ge=s("p"),ge.textContent=Nt,et=r(),g(P.$$.fragment),tt=r(),w=s("div"),g(ee.$$.fragment),ot=r(),ue=s("p"),ue.textContent=jt,rt=r(),fe=s("p"),fe.textContent=Pt,nt=r(),he=s("ol"),he.innerHTML=Ht,at=r(),H=s("div"),g(te.$$.fragment),st=r(),_e=s("p"),_e.textContent=qt,dt=r(),q=s("div"),g(oe.$$.fragment),it=r(),xe=s("p"),xe.innerHTML=It,lt=r(),I=s("div"),g(re.$$.fragment),ct=r(),be=s("p"),be.textContent=At,mt=r(),A=s("div"),g(ne.$$.fragment),pt=r(),ke=s("p"),ke.textContent=Ot,gt=r(),O=s("div"),g(ae.$$.fragment),ut=r(),ye=s("p"),ye.textContent=Ut,ft=r(),U=s("div"),g(se.$$.fragment),ht=r(),ve=s("p"),ve.innerHTML=Lt,_t=r(),L=s("div"),g(de.$$.fragment),xt=r(),Te=s("p"),Te.textContent=Et,bt=r(),E=s("div"),g(ie.$$.fragment),kt=r(),$e=s("p"),$e.textContent=Jt,yt=r(),J=s("div"),g(le.$$.fragment),vt=r(),Me=s("p"),Me.textContent=St,Le=r(),g(ce.$$.fragment),Ee=r(),we=s("p"),this.h()},l(e){const a=Wt("svelte-u9bgzb",document.head);p=d(a,"META",{name:!0,content:!0}),a.forEach(o),F=n(e),v=d(e,"P",{}),$(v).forEach(o),k=n(e),u(y.$$.fragment,e),i=n(e),T=d(e,"P",{"data-svelte-h":!0}),f(T)!=="svelte-ab4qq0"&&(T.innerHTML=Tt),Fe=n(e),R=d(e,"UL",{"data-svelte-h":!0}),f(R)!=="svelte-g9sbqh"&&(R.innerHTML=$t),De=n(e),Z=d(e,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1gl7bh8"&&(Z.innerHTML=Mt),Ne=n(e),u(z.$$.fragment,e),je=n(e),V=d(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-1bgg04"&&(V.textContent=wt),Pe=n(e),u(j.$$.fragment,e),He=n(e),u(X.$$.fragment,e),qe=n(e),B=d(e,"TABLE",{"data-svelte-h":!0}),f(B)!=="svelte-52hvyl"&&(B.innerHTML=Ct),Ie=n(e),u(W.$$.fragment,e),Ae=n(e),G=d(e,"TABLE",{"data-svelte-h":!0}),f(G)!=="svelte-1b4ycm7"&&(G.innerHTML=Ft),Oe=n(e),u(Y.$$.fragment,e),Ue=n(e),l=d(e,"DIV",{class:!0});var c=$(l);u(Q.$$.fragment,c),Ye=n(c),pe=d(c,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-11ax9pk"&&(pe.innerHTML=Dt),Qe=n(c),D=d(c,"DIV",{class:!0});var N=$(D);u(K.$$.fragment,N),Ke=n(N),ge=d(N,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-1hg58vd"&&(ge.textContent=Nt),et=n(N),u(P.$$.fragment,N),N.forEach(o),tt=n(c),w=d(c,"DIV",{class:!0});var S=$(w);u(ee.$$.fragment,S),ot=n(S),ue=d(S,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-rshgf5"&&(ue.textContent=jt),rt=n(S),fe=d(S,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-1wbth9c"&&(fe.textContent=Pt),nt=n(S),he=d(S,"OL",{"data-svelte-h":!0}),f(he)!=="svelte-17imzut"&&(he.innerHTML=Ht),S.forEach(o),at=n(c),H=d(c,"DIV",{class:!0});var Se=$(H);u(te.$$.fragment,Se),st=n(Se),_e=d(Se,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-1u59gs0"&&(_e.textContent=qt),Se.forEach(o),dt=n(c),q=d(c,"DIV",{class:!0});var Re=$(q);u(oe.$$.fragment,Re),it=n(Re),xe=d(Re,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-77ppuy"&&(xe.innerHTML=It),Re.forEach(o),lt=n(c),I=d(c,"DIV",{class:!0});var Ze=$(I);u(re.$$.fragment,Ze),ct=n(Ze),be=d(Ze,"P",{"data-svelte-h":!0}),f(be)!=="svelte-dfgadj"&&(be.textContent=At),Ze.forEach(o),mt=n(c),A=d(c,"DIV",{class:!0});var ze=$(A);u(ne.$$.fragment,ze),pt=n(ze),ke=d(ze,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-xnksbg"&&(ke.textContent=Ot),ze.forEach(o),gt=n(c),O=d(c,"DIV",{class:!0});var Ve=$(O);u(ae.$$.fragment,Ve),ut=n(Ve),ye=d(Ve,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-1tobybd"&&(ye.textContent=Ut),Ve.forEach(o),ft=n(c),U=d(c,"DIV",{class:!0});var Xe=$(U);u(se.$$.fragment,Xe),ht=n(Xe),ve=d(Xe,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-h2w0ej"&&(ve.innerHTML=Lt),Xe.forEach(o),_t=n(c),L=d(c,"DIV",{class:!0});var Be=$(L);u(de.$$.fragment,Be),xt=n(Be),Te=d(Be,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-gsde3z"&&(Te.textContent=Et),Be.forEach(o),bt=n(c),E=d(c,"DIV",{class:!0});var We=$(E);u(ie.$$.fragment,We),kt=n(We),$e=d(We,"P",{"data-svelte-h":!0}),f($e)!=="svelte-upyqbj"&&($e.textContent=Jt),We.forEach(o),yt=n(c),J=d(c,"DIV",{class:!0});var Ge=$(J);u(le.$$.fragment,Ge),vt=n(Ge),Me=d(Ge,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-3l6tv0"&&(Me.textContent=St),Ge.forEach(o),c.forEach(o),Le=n(e),u(ce.$$.fragment,e),Ee=n(e),we=d(e,"P",{}),$(we).forEach(o),this.h()},h(){M(p,"name","hf:doc:metadata"),M(p,"content",oo),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){t(document.head,p),m(e,F,a),m(e,v,a),m(e,k,a),h(y,e,a),m(e,i,a),m(e,T,a),m(e,Fe,a),m(e,R,a),m(e,De,a),m(e,Z,a),m(e,Ne,a),h(z,e,a),m(e,je,a),m(e,V,a),m(e,Pe,a),h(j,e,a),m(e,He,a),h(X,e,a),m(e,qe,a),m(e,B,a),m(e,Ie,a),h(W,e,a),m(e,Ae,a),m(e,G,a),m(e,Oe,a),h(Y,e,a),m(e,Ue,a),m(e,l,a),h(Q,l,null),t(l,Ye),t(l,pe),t(l,Qe),t(l,D),h(K,D,null),t(D,Ke),t(D,ge),t(D,et),h(P,D,null),t(l,tt),t(l,w),h(ee,w,null),t(w,ot),t(w,ue),t(w,rt),t(w,fe),t(w,nt),t(w,he),t(l,at),t(l,H),h(te,H,null),t(H,st),t(H,_e),t(l,dt),t(l,q),h(oe,q,null),t(q,it),t(q,xe),t(l,lt),t(l,I),h(re,I,null),t(I,ct),t(I,be),t(l,mt),t(l,A),h(ne,A,null),t(A,pt),t(A,ke),t(l,gt),t(l,O),h(ae,O,null),t(O,ut),t(O,ye),t(l,ft),t(l,U),h(se,U,null),t(U,ht),t(U,ve),t(l,_t),t(l,L),h(de,L,null),t(L,xt),t(L,Te),t(l,bt),t(l,E),h(ie,E,null),t(E,kt),t(E,$e),t(l,yt),t(l,J),h(le,J,null),t(J,vt),t(J,Me),m(e,Le,a),h(ce,e,a),m(e,Ee,a),m(e,we,a),Je=!0},p(e,[a]){const c={};a&2&&(c.$$scope={dirty:a,ctx:e}),j.$set(c);const N={};a&2&&(N.$$scope={dirty:a,ctx:e}),P.$set(N)},i(e){Je||(_(y.$$.fragment,e),_(z.$$.fragment,e),_(j.$$.fragment,e),_(X.$$.fragment,e),_(W.$$.fragment,e),_(Y.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(P.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(re.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(de.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(ce.$$.fragment,e),Je=!0)},o(e){x(y.$$.fragment,e),x(z.$$.fragment,e),x(j.$$.fragment,e),x(X.$$.fragment,e),x(W.$$.fragment,e),x(Y.$$.fragment,e),x(Q.$$.fragment,e),x(K.$$.fragment,e),x(P.$$.fragment,e),x(ee.$$.fragment,e),x(te.$$.fragment,e),x(oe.$$.fragment,e),x(re.$$.fragment,e),x(ne.$$.fragment,e),x(ae.$$.fragment,e),x(se.$$.fragment,e),x(de.$$.fragment,e),x(ie.$$.fragment,e),x(le.$$.fragment,e),x(ce.$$.fragment,e),Je=!1},d(e){e&&(o(F),o(v),o(k),o(i),o(T),o(Fe),o(R),o(De),o(Z),o(Ne),o(je),o(V),o(Pe),o(He),o(qe),o(B),o(Ie),o(Ae),o(G),o(Oe),o(Ue),o(l),o(Le),o(Ee),o(we)),o(p),b(y,e),b(z,e),b(j,e),b(X,e),b(W,e),b(Y,e),b(Q),b(K),b(P),b(ee),b(te),b(oe),b(re),b(ne),b(ae),b(se),b(de),b(ie),b(le),b(ce,e)}}}const oo='{"title":"The Tasks Manager","local":"the-tasks-manager","sections":[{"title":"Task names","local":"task-names","sections":[{"title":"PyTorch","local":"pytorch","sections":[],"depth":3},{"title":"TensorFlow","local":"tensorflow","sections":[],"depth":3}],"depth":2},{"title":"Reference","local":"optimum.exporters.TasksManager","sections":[],"depth":2}],"depth":1}';function ro(me){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class po extends Xt{constructor(p){super(),Bt(this,p,ro,to,zt,{})}}export{po as component};
