import{s as fl,f as Ze,n as Cl,o as Il}from"../chunks/scheduler.37c15a92.js";import{S as vl,i as Bl,g as o,s as n,r as y,A as Al,h as i,f as l,c as a,j as We,u as m,x as M,k as r,y as Zl,a as s,v as c,d as u,t as j,w as h}from"../chunks/index.2bf4358c.js";import{C as Ae}from"../chunks/CodeBlock.4e987730.js";import{H as dt}from"../chunks/Heading.8ada512a.js";import{E as Wl}from"../chunks/index.3b54d7fe.js";function Hl(He){let w,gt,bt,Jt,U,ft,d,Ee="In the last section, we learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by <strong>handling much of the heavy lifting for you</strong>.",Ct,b,ke="In this tutorial, <strong>you’ll create your very first Agent</strong> capable of performing actions such as image generation, web search, time zone checking and much more!",It,T,Ge="You will also publish your agent <strong>on a Hugging Face Space so you can share it with friends and colleagues</strong>.",vt,g,_e="Let’s get started!",Bt,J,At,f,xe,Zt,C,Qe="To make this Agent, we’re going to use <code>smolagents</code>, a library that <strong>provides a framework for developing your agents with ease</strong>.",Wt,I,Se="This lightweight library is designed for simplicity, but it abstracts away much of the complexity of building an Agent, allowing you to focus on designing your agent’s behavior.",Ht,v,Re='We’re going to get deeper into smolagents in the next Unit. Meanwhile, you can also check this <a href="https://huggingface.co/blog/smolagents" target="_blank">blog post</a> or the library’s <a href="https://github.com/huggingface/smolagents" target="_blank">repo in GitHub</a>.',Et,B,Xe="In short, <code>smolagents</code> is a library that focuses on <strong>codeAgent</strong>, a kind of agent that performs <strong>“Actions”</strong> through code blocks, and then <strong>“Observes”</strong> results by executing the code.",kt,A,ze="Here is an example of what we’ll build!",Gt,Z,Ne="We provided our agent with an <strong>Image generation tool</strong> and asked it to generate an image of a cat.",_t,W,Ve="The agent inside <code>smolagents</code> is going to have the <strong>same behaviors as the custom one we built previously</strong>: it’s going <strong>to think, act and observe in cycle</strong> until it reaches a final answer:",xt,p,Fe,Qt,H,$e="Exciting, right?",St,E,Rt,k,Le='To start, duplicate this Space: <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',Xt,G,Ye='<p>Thanks to <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> for this template! 🙌</p>',zt,_,qe="Duplicating this space means <strong>creating a local copy on your own profile</strong>:",Nt,x,Pe,Vt,Q,De="After duplicating the Space, you’ll need to add your Hugging Face API token so your agent can access the model API:",Ft,S,Ke='<li>First, get your Hugging Face token from <a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens</a> with permission for inference, if you don’t already have one</li> <li>Go to your duplicated Space and click on the <strong>Settings</strong> tab</li> <li>Scroll down to the <strong>Variables and Secrets</strong> section and click <strong>New Secret</strong></li> <li>Create a secret with the name <code>HF_TOKEN</code> and paste your token as the value</li> <li>Click <strong>Save</strong> to store your token securely</li>',$t,R,Oe='Throughout this lesson, the only file you will need to modify is the (currently incomplete) <strong>“app.py”</strong>. You can see here the <a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">original one in the template</a>. To find yours, go to your copy of the space, then click the <code>Files</code> tab and then on <code>app.py</code> in the directory listing.',Lt,X,tl="Let’s break down the code together:",Yt,z,el="<li>The file begins with some simple but necessary library imports</li>",qt,N,Pt,V,ll="As outlined earlier, we will directly use the <strong>CodeAgent</strong> class from <strong>smolagents</strong>.",Dt,F,Kt,$,sl='Now let’s get into the tools! If you want a refresher about tools, don’t hesitate to go back to the <a href="tools">Tools</a> section of the course.',Ot,L,te,Y,nl="The Tools are what we are encouraging you to build in this section! We give you two examples:",ee,q,al="<li>A <strong>non-working dummy Tool</strong> that you can modify to make something useful.</li> <li>An <strong>actually working Tool</strong> that gets the current time somewhere in the world.</li>",le,P,ol="To define your tool it is important to:",se,D,il="<li>Provide input and output types for your function, like in <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>A well formatted docstring</strong>. <code>smolagents</code> is expecting all the arguments to have a <strong>textual description in the docstring</strong>.</li>",ne,K,ae,O,Ml='It uses <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> as the LLM engine. This is a very capable model that we’ll access via the serverless API.',oe,tt,ie,et,pl="This Agent still uses the <code>InferenceClient</code> we saw in an earlier section behind the <strong>HfApiModel</strong> class!",Me,lt,rl="We will give more in-depth examples when we present the framework in Unit 2. For now, you need to focus on <strong>adding new tools to the list of tools</strong> using the <code>tools</code> parameter of your Agent.",pe,st,yl="For example, you could use the <code>DuckDuckGoSearchTool</code> that was imported in the first line of the code, or you can examine the <code>image_generation_tool</code> that is loaded from the Hub later in the code.",re,nt,ml="<strong>Adding tools will give your agent new capabilities</strong>, try to be creative here!",ye,at,me,ot,cl="The agent’s system prompt is stored in a seperate <code>prompts.yaml</code> file. This file contains predefined instructions that guide the agent’s behavior.",ce,it,ul="Storing prompts in a YAML file allows for easy customization and reuse across different agents or use cases.",ue,Mt,jl='You can check the <a href="https://huggingface.co/spaces/agents-course/First_agent_template/tree/main" rel="nofollow">Space’s file structure</a> to see where the <code>prompts.yaml</code> file is located and how it’s organized within the project.',je,pt,hl="The complete “app.py”:",he,rt,we,yt,wl="Your <strong>Goal</strong> is to get familiar with the Space and the Agent.",Ue,mt,Ul="Currently, the agent in the template <strong>does not use any tools, so try to provide it with some of the pre-made ones or even make some new tools yourself!</strong>",de,ct,dl="We are eagerly waiting for your amazing agents output in the discord channel <strong>#agents-course-showcase</strong>!",be,Te,ge,ut,bl="Congratulations, you’ve built your first Agent! Don’t hesitate to share it with your friends and colleagues.",Je,jt,Tl="Since this is your first try, it’s perfectly normal if it’s a little buggy or slow. In future units, we’ll learn how to build even better Agents.",fe,ht,gl="The best way to learn is to try, so don’t hesitate to update it, add more tools, try with another model, etc.",Ce,wt,Jl="In the next section, you’re going to fill the final Quiz and get your certificate!",Ie,Ut,ve,Tt,Be;return U=new dt({props:{title:"Let’s Create Our First Agent Using smolagents",local:"lets-create-our-first-agent-using-smolagents",headingTag:"h1"}}),J=new dt({props:{title:"What is smolagents?",local:"what-is-smolagents",headingTag:"h2"}}),E=new dt({props:{title:"Let’s build our Agent!",local:"lets-build-our-agent",headingTag:"h2"}}),N=new Ae({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEZpbmFsQW5zd2VyVG9vbCUyQyUyMEhmQXBpTW9kZWwlMkMlMjBsb2FkX3Rvb2wlMkMlMjB0b29sJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMHB5dHolMEFpbXBvcnQlMjB5YW1s",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, FinalAnswerTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml`,wrap:!1}}),F=new dt({props:{title:"The Tools",local:"the-tools",headingTag:"h3"}}),L=new Ae({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),K=new dt({props:{title:"The Agent",local:"the-agent",headingTag:"h3"}}),tt=new Ae({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEhmQXBpTW9kZWwoJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDIwOTYlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJ1F3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCclMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcm9sZV9jb252ZXJzaW9ucyUzRE5vbmUlMkMlMEEpJTBBJTBBd2l0aCUyMG9wZW4oJTIycHJvbXB0cy55YW1sJTIyJTJDJTIwJ3InKSUyMGFzJTIwc3RyZWFtJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUyMCUzRCUyMHlhbWwuc2FmZV9sb2FkKHN0cmVhbSklMEElMjAlMjAlMjAlMjAlMEElMjMlMjBXZSdyZSUyMGNyZWF0aW5nJTIwb3VyJTIwQ29kZUFnZW50JTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCZmluYWxfYW5zd2VyJTVEJTJDJTIwJTIzJTIwYWRkJTIweW91ciUyMHRvb2xzJTIwaGVyZSUyMChkb24ndCUyMHJlbW92ZSUyMGZpbmFsX2Fuc3dlciklMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q2JTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGdyYW1tYXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfdGVtcGxhdGVzJTNEcHJvbXB0X3RlbXBsYXRlcyUwQSklMEElMEFHcmFkaW9VSShhZ2VudCkubGF1bmNoKCk=",highlighted:`final_answer = FinalAnswerTool()
model = HfApiModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># We&#x27;re creating our CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),at=new dt({props:{title:"The System Prompt",local:"the-system-prompt",headingTag:"h3"}}),rt=new Ae({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Below is an example of a tool that does nothing. Amaze us with your creativity!</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
    model = HfApiModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Load system prompt from prompt.yaml file</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates <span class="hljs-comment"># Pass system prompt to CodeAgent</span>
)


GradioUI(agent).launch()`,wrap:!1}}),Ut=new Wl({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tutorial.mdx"}}),{c(){w=o("meta"),gt=n(),bt=o("p"),Jt=n(),y(U.$$.fragment),ft=n(),d=o("p"),d.innerHTML=Ee,Ct=n(),b=o("p"),b.innerHTML=ke,It=n(),T=o("p"),T.innerHTML=Ge,vt=n(),g=o("p"),g.textContent=_e,Bt=n(),y(J.$$.fragment),At=n(),f=o("img"),Zt=n(),C=o("p"),C.innerHTML=Qe,Wt=n(),I=o("p"),I.textContent=Se,Ht=n(),v=o("p"),v.innerHTML=Re,Et=n(),B=o("p"),B.innerHTML=Xe,kt=n(),A=o("p"),A.textContent=ze,Gt=n(),Z=o("p"),Z.innerHTML=Ne,_t=n(),W=o("p"),W.innerHTML=Ve,xt=n(),p=o("iframe"),Qt=n(),H=o("p"),H.textContent=$e,St=n(),y(E.$$.fragment),Rt=n(),k=o("p"),k.innerHTML=Le,Xt=n(),G=o("blockquote"),G.innerHTML=Ye,zt=n(),_=o("p"),_.innerHTML=qe,Nt=n(),x=o("img"),Vt=n(),Q=o("p"),Q.textContent=De,Ft=n(),S=o("ol"),S.innerHTML=Ke,$t=n(),R=o("p"),R.innerHTML=Oe,Lt=n(),X=o("p"),X.textContent=tl,Yt=n(),z=o("ul"),z.innerHTML=el,qt=n(),y(N.$$.fragment),Pt=n(),V=o("p"),V.innerHTML=ll,Dt=n(),y(F.$$.fragment),Kt=n(),$=o("p"),$.innerHTML=sl,Ot=n(),y(L.$$.fragment),te=n(),Y=o("p"),Y.textContent=nl,ee=n(),q=o("ol"),q.innerHTML=al,le=n(),P=o("p"),P.textContent=ol,se=n(),D=o("ol"),D.innerHTML=il,ne=n(),y(K.$$.fragment),ae=n(),O=o("p"),O.innerHTML=Ml,oe=n(),y(tt.$$.fragment),ie=n(),et=o("p"),et.innerHTML=pl,Me=n(),lt=o("p"),lt.innerHTML=rl,pe=n(),st=o("p"),st.innerHTML=yl,re=n(),nt=o("p"),nt.innerHTML=ml,ye=n(),y(at.$$.fragment),me=n(),ot=o("p"),ot.innerHTML=cl,ce=n(),it=o("p"),it.textContent=ul,ue=n(),Mt=o("p"),Mt.innerHTML=jl,je=n(),pt=o("p"),pt.textContent=hl,he=n(),y(rt.$$.fragment),we=n(),yt=o("p"),yt.innerHTML=wl,Ue=n(),mt=o("p"),mt.innerHTML=Ul,de=n(),ct=o("p"),ct.innerHTML=dl,be=n(),Te=o("hr"),ge=n(),ut=o("p"),ut.textContent=bl,Je=n(),jt=o("p"),jt.textContent=Tl,fe=n(),ht=o("p"),ht.textContent=gl,Ce=n(),wt=o("p"),wt.textContent=Jl,Ie=n(),y(Ut.$$.fragment),ve=n(),Tt=o("p"),this.h()},l(t){const e=Al("svelte-u9bgzb",document.head);w=i(e,"META",{name:!0,content:!0}),e.forEach(l),gt=a(t),bt=i(t,"P",{}),We(bt).forEach(l),Jt=a(t),m(U.$$.fragment,t),ft=a(t),d=i(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-gmmoh4"&&(d.innerHTML=Ee),Ct=a(t),b=i(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-isl0ka"&&(b.innerHTML=ke),It=a(t),T=i(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-zy1mev"&&(T.innerHTML=Ge),vt=a(t),g=i(t,"P",{"data-svelte-h":!0}),M(g)!=="svelte-4b3xjd"&&(g.textContent=_e),Bt=a(t),m(J.$$.fragment,t),At=a(t),f=i(t,"IMG",{src:!0,alt:!0}),Zt=a(t),C=i(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1bet7no"&&(C.innerHTML=Qe),Wt=a(t),I=i(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-oceeap"&&(I.textContent=Se),Ht=a(t),v=i(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1wfbi7x"&&(v.innerHTML=Re),Et=a(t),B=i(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1kxxgvd"&&(B.innerHTML=Xe),kt=a(t),A=i(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1x3dozw"&&(A.textContent=ze),Gt=a(t),Z=i(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1kwa3nr"&&(Z.innerHTML=Ne),_t=a(t),W=i(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-4nw0u8"&&(W.innerHTML=Ve),xt=a(t),p=i(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),We(p).forEach(l),Qt=a(t),H=i(t,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1riubhm"&&(H.textContent=$e),St=a(t),m(E.$$.fragment,t),Rt=a(t),k=i(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-3pukde"&&(k.innerHTML=Le),Xt=a(t),G=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(G)!=="svelte-1lji2e8"&&(G.innerHTML=Ye),zt=a(t),_=i(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-xpoxi8"&&(_.innerHTML=qe),Nt=a(t),x=i(t,"IMG",{src:!0,alt:!0}),Vt=a(t),Q=i(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1to4f3l"&&(Q.textContent=De),Ft=a(t),S=i(t,"OL",{"data-svelte-h":!0}),M(S)!=="svelte-1dpkmu0"&&(S.innerHTML=Ke),$t=a(t),R=i(t,"P",{"data-svelte-h":!0}),M(R)!=="svelte-e4oew5"&&(R.innerHTML=Oe),Lt=a(t),X=i(t,"P",{"data-svelte-h":!0}),M(X)!=="svelte-xgl3rm"&&(X.textContent=tl),Yt=a(t),z=i(t,"UL",{"data-svelte-h":!0}),M(z)!=="svelte-g8ecnx"&&(z.innerHTML=el),qt=a(t),m(N.$$.fragment,t),Pt=a(t),V=i(t,"P",{"data-svelte-h":!0}),M(V)!=="svelte-eq9rdr"&&(V.innerHTML=ll),Dt=a(t),m(F.$$.fragment,t),Kt=a(t),$=i(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-1qrccm5"&&($.innerHTML=sl),Ot=a(t),m(L.$$.fragment,t),te=a(t),Y=i(t,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-qrpozm"&&(Y.textContent=nl),ee=a(t),q=i(t,"OL",{"data-svelte-h":!0}),M(q)!=="svelte-12muy28"&&(q.innerHTML=al),le=a(t),P=i(t,"P",{"data-svelte-h":!0}),M(P)!=="svelte-mmcol7"&&(P.textContent=ol),se=a(t),D=i(t,"OL",{"data-svelte-h":!0}),M(D)!=="svelte-p349vr"&&(D.innerHTML=il),ne=a(t),m(K.$$.fragment,t),ae=a(t),O=i(t,"P",{"data-svelte-h":!0}),M(O)!=="svelte-16qafzg"&&(O.innerHTML=Ml),oe=a(t),m(tt.$$.fragment,t),ie=a(t),et=i(t,"P",{"data-svelte-h":!0}),M(et)!=="svelte-1o74ygl"&&(et.innerHTML=pl),Me=a(t),lt=i(t,"P",{"data-svelte-h":!0}),M(lt)!=="svelte-t0wd0t"&&(lt.innerHTML=rl),pe=a(t),st=i(t,"P",{"data-svelte-h":!0}),M(st)!=="svelte-1m08tlu"&&(st.innerHTML=yl),re=a(t),nt=i(t,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-13ckn13"&&(nt.innerHTML=ml),ye=a(t),m(at.$$.fragment,t),me=a(t),ot=i(t,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-116yn5j"&&(ot.innerHTML=cl),ce=a(t),it=i(t,"P",{"data-svelte-h":!0}),M(it)!=="svelte-dchyno"&&(it.textContent=ul),ue=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-1sn4nls"&&(Mt.innerHTML=jl),je=a(t),pt=i(t,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-11duvvf"&&(pt.textContent=hl),he=a(t),m(rt.$$.fragment,t),we=a(t),yt=i(t,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-1djj761"&&(yt.innerHTML=wl),Ue=a(t),mt=i(t,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-1xqfrp"&&(mt.innerHTML=Ul),de=a(t),ct=i(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-h3h5uq"&&(ct.innerHTML=dl),be=a(t),Te=i(t,"HR",{}),ge=a(t),ut=i(t,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-1vcdjz4"&&(ut.textContent=bl),Je=a(t),jt=i(t,"P",{"data-svelte-h":!0}),M(jt)!=="svelte-10mjkny"&&(jt.textContent=Tl),fe=a(t),ht=i(t,"P",{"data-svelte-h":!0}),M(ht)!=="svelte-10xgfu5"&&(ht.textContent=gl),Ce=a(t),wt=i(t,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-1s9m3df"&&(wt.textContent=Jl),Ie=a(t),m(Ut.$$.fragment,t),ve=a(t),Tt=i(t,"P",{}),We(Tt).forEach(l),this.h()},h(){r(w,"name","hf:doc:metadata"),r(w,"content",El),Ze(f.src,xe="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||r(f,"src",xe),r(f,"alt","smolagents"),r(p,"width","560"),r(p,"height","315"),Ze(p.src,Fe="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||r(p,"src",Fe),r(p,"title","YouTube video player"),r(p,"frameborder","0"),r(p,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),r(p,"referrerpolicy","strict-origin-when-cross-origin"),p.allowFullscreen="",Ze(x.src,Pe="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||r(x,"src",Pe),r(x,"alt","Duplicate")},m(t,e){Zl(document.head,w),s(t,gt,e),s(t,bt,e),s(t,Jt,e),c(U,t,e),s(t,ft,e),s(t,d,e),s(t,Ct,e),s(t,b,e),s(t,It,e),s(t,T,e),s(t,vt,e),s(t,g,e),s(t,Bt,e),c(J,t,e),s(t,At,e),s(t,f,e),s(t,Zt,e),s(t,C,e),s(t,Wt,e),s(t,I,e),s(t,Ht,e),s(t,v,e),s(t,Et,e),s(t,B,e),s(t,kt,e),s(t,A,e),s(t,Gt,e),s(t,Z,e),s(t,_t,e),s(t,W,e),s(t,xt,e),s(t,p,e),s(t,Qt,e),s(t,H,e),s(t,St,e),c(E,t,e),s(t,Rt,e),s(t,k,e),s(t,Xt,e),s(t,G,e),s(t,zt,e),s(t,_,e),s(t,Nt,e),s(t,x,e),s(t,Vt,e),s(t,Q,e),s(t,Ft,e),s(t,S,e),s(t,$t,e),s(t,R,e),s(t,Lt,e),s(t,X,e),s(t,Yt,e),s(t,z,e),s(t,qt,e),c(N,t,e),s(t,Pt,e),s(t,V,e),s(t,Dt,e),c(F,t,e),s(t,Kt,e),s(t,$,e),s(t,Ot,e),c(L,t,e),s(t,te,e),s(t,Y,e),s(t,ee,e),s(t,q,e),s(t,le,e),s(t,P,e),s(t,se,e),s(t,D,e),s(t,ne,e),c(K,t,e),s(t,ae,e),s(t,O,e),s(t,oe,e),c(tt,t,e),s(t,ie,e),s(t,et,e),s(t,Me,e),s(t,lt,e),s(t,pe,e),s(t,st,e),s(t,re,e),s(t,nt,e),s(t,ye,e),c(at,t,e),s(t,me,e),s(t,ot,e),s(t,ce,e),s(t,it,e),s(t,ue,e),s(t,Mt,e),s(t,je,e),s(t,pt,e),s(t,he,e),c(rt,t,e),s(t,we,e),s(t,yt,e),s(t,Ue,e),s(t,mt,e),s(t,de,e),s(t,ct,e),s(t,be,e),s(t,Te,e),s(t,ge,e),s(t,ut,e),s(t,Je,e),s(t,jt,e),s(t,fe,e),s(t,ht,e),s(t,Ce,e),s(t,wt,e),s(t,Ie,e),c(Ut,t,e),s(t,ve,e),s(t,Tt,e),Be=!0},p:Cl,i(t){Be||(u(U.$$.fragment,t),u(J.$$.fragment,t),u(E.$$.fragment,t),u(N.$$.fragment,t),u(F.$$.fragment,t),u(L.$$.fragment,t),u(K.$$.fragment,t),u(tt.$$.fragment,t),u(at.$$.fragment,t),u(rt.$$.fragment,t),u(Ut.$$.fragment,t),Be=!0)},o(t){j(U.$$.fragment,t),j(J.$$.fragment,t),j(E.$$.fragment,t),j(N.$$.fragment,t),j(F.$$.fragment,t),j(L.$$.fragment,t),j(K.$$.fragment,t),j(tt.$$.fragment,t),j(at.$$.fragment,t),j(rt.$$.fragment,t),j(Ut.$$.fragment,t),Be=!1},d(t){t&&(l(gt),l(bt),l(Jt),l(ft),l(d),l(Ct),l(b),l(It),l(T),l(vt),l(g),l(Bt),l(At),l(f),l(Zt),l(C),l(Wt),l(I),l(Ht),l(v),l(Et),l(B),l(kt),l(A),l(Gt),l(Z),l(_t),l(W),l(xt),l(p),l(Qt),l(H),l(St),l(Rt),l(k),l(Xt),l(G),l(zt),l(_),l(Nt),l(x),l(Vt),l(Q),l(Ft),l(S),l($t),l(R),l(Lt),l(X),l(Yt),l(z),l(qt),l(Pt),l(V),l(Dt),l(Kt),l($),l(Ot),l(te),l(Y),l(ee),l(q),l(le),l(P),l(se),l(D),l(ne),l(ae),l(O),l(oe),l(ie),l(et),l(Me),l(lt),l(pe),l(st),l(re),l(nt),l(ye),l(me),l(ot),l(ce),l(it),l(ue),l(Mt),l(je),l(pt),l(he),l(we),l(yt),l(Ue),l(mt),l(de),l(ct),l(be),l(Te),l(ge),l(ut),l(Je),l(jt),l(fe),l(ht),l(Ce),l(wt),l(Ie),l(ve),l(Tt)),l(w),h(U,t),h(J,t),h(E,t),h(N,t),h(F,t),h(L,t),h(K,t),h(tt,t),h(at,t),h(rt,t),h(Ut,t)}}}const El='{"title":"Let’s Create Our First Agent Using smolagents","local":"lets-create-our-first-agent-using-smolagents","sections":[{"title":"What is smolagents?","local":"what-is-smolagents","sections":[],"depth":2},{"title":"Let’s build our Agent!","local":"lets-build-our-agent","sections":[{"title":"The Tools","local":"the-tools","sections":[],"depth":3},{"title":"The Agent","local":"the-agent","sections":[],"depth":3},{"title":"The System Prompt","local":"the-system-prompt","sections":[],"depth":3}],"depth":2}],"depth":1}';function kl(He){return Il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rl extends vl{constructor(w){super(),Bl(this,w,kl,Hl,fl,{})}}export{Rl as component};
