import{s as ha,n as Ma,o as ya}from"../chunks/scheduler.9bc65507.js";import{S as oa,i as ga,g as p,s as n,r,A as ua,h as i,f as l,c as e,j as Fs,u as m,x as c,k as ja,y as U,a,v as j,d as h,t as M,w as y}from"../chunks/index.707bf1b6.js";import{C as g}from"../chunks/CodeBlock.54a9f38d.js";import{H as o,E as Ja}from"../chunks/EditOnGithub.922df6ba.js";function Ua(Tl){let u,Ss,Es,As,x,Ls,T,bl="🤗 Transformersは、自然言語処理（NLP）、コンピュータビジョン、音声処理などの最新の事前学習済みモデルのライブラリです。このライブラリには、Transformerモデルだけでなく、コンピュータビジョンタスク向けのモダンな畳み込みニューラルネットワークなど、Transformer以外のモデルも含まれています。現代のスマートフォン、アプリ、テレビなど、最も人気のある消費者製品の多くには、深層学習技術が使用されています。スマートフォンで撮影した写真から背景オブジェクトを削除したいですか？これはパノプティック・セグメンテーション（まだ何を意味するかわからなくても心配しないでください、以下のセクションで説明します！）のタスクの一例です。",Ps,b,dl="このページでは、🤗 Transformersライブラリを使用して、たった3行のコードで解決できるさまざまな音声および音声、コンピュータビジョン、NLPタスクの概要を提供します！",Ks,d,Ds,w,wl="音声と音声処理のタスクは、他のモダリティとは少し異なります。なぜなら、入力としての生の音声波形は連続的な信号であるからです。テキストとは異なり、生の音声波形は文章を単語に分割できるようにきれいに分割できません。これを解決するために、通常、生の音声信号は定期的な間隔でサンプリングされます。間隔内でより多くのサンプルを取ると、サンプリングレートが高くなり、音声はより元の音声ソースに近づきます。",Os,f,fl="以前のアプローチでは、音声を前処理してそれから有用な特徴を抽出しました。しかし、現在では、生の音声波形を特徴エンコーダに直接フィードし、音声表現を抽出することから始めることが一般的です。これにより、前処理ステップが簡素化され、モデルは最も重要な特徴を学習できます。",st,C,tt,Z,Cl="音声分類は、事前に定義されたクラスのセットから音声データにラベルを付けるタスクです。これは多くの具体的なアプリケーションを含む広範なカテゴリであり、いくつかの例は次のとおりです：",lt,I,Zl="<li>音響シーン分類：音声にシーンラベルを付ける（「オフィス」、「ビーチ」、「スタジアム」）</li> <li>音響イベント検出：音声に音声イベントラベルを付ける（「車のクラクション」、「クジラの呼び声」、「ガラスの破裂」）</li> <li>タギング：複数の音を含む音声にラベルを付ける（鳥の鳴き声、会議でのスピーカー識別）</li> <li>音楽分類：音楽にジャンルラベルを付ける（「メタル」、「ヒップホップ」、「カントリー」）</li>",at,$,nt,B,et,W,Il="自動音声認識（ASR）は音声をテキストに変換します。これは、人間のコミュニケーションの自然な形式である音声の一部として、部分的にそのような一般的なオーディオタスクの一つです。今日、ASRシステムはスピーカー、スマートフォン、自動車などの「スマート」テクノロジープロダクトに組み込まれています。私たちは仮想アシスタントに音楽を再生してもらったり、リマインダーを設定してもらったり、天気を教えてもらったりできます。",pt,G,$l="しかし、Transformerアーキテクチャが助けた主要な課題の一つは、低リソース言語におけるものです。大量の音声データで事前トレーニングし、低リソース言語でラベル付き音声データをわずか1時間だけでファインチューニングすることでも、以前のASRシステムと比較して高品質な結果を得ることができます。以前のASRシステムは100倍以上のラベル付きデータでトレーニングされていましたが、Transformerアーキテクチャはこの問題に貢献しました。",it,k,ct,H,rt,q,Bl='最初で初めて成功したコンピュータビジョンのタスクの一つは、<a href="glossary#convolution">畳み込みニューラルネットワーク（CNN）</a>を使用して郵便番号の画像を認識することでした。画像はピクセルから構成され、各ピクセルには数値があります。これにより、画像をピクセル値の行列として簡単に表現できます。特定のピクセル値の組み合わせは、画像の色を記述します。',mt,v,Wl="コンピュータビジョンのタスクを解決する一般的な方法は次の2つです：",jt,V,Gl="<li>畳み込みを使用して、低レベルの特徴から高レベルの抽象的な情報まで、画像の階層的な特徴を学習する。</li> <li>画像をパッチに分割し、各画像パッチが画像全体とどのように関連しているかを徐々に学習するためにTransformerを使用する。CNNが好むボトムアップアプローチとは異なり、これはぼんやりとした画像から始めて徐々に焦点を合わせるようなものです。</li>",ht,N,Mt,R,kl="画像分類は、事前に定義されたクラスのセットから画像全体にラベルを付けます。多くの分類タスクと同様に、画像分類には多くの実用的な用途があり、その一部は次のとおりです：",yt,z,Hl="<li>医療：疾患の検出や患者の健康の監視に使用するために医療画像にラベルを付ける</li> <li>環境：森林伐採の監視、野生地の管理情報、または山火事の検出に使用するために衛星画像にラベルを付ける</li> <li>農業：作物の健康を監視するための作物の画像や、土地利用の監視のための衛星画像にラベルを付ける</li> <li>生態学：野生動物の個体数を監視したり、絶滅危惧種を追跡するために動植物の種の画像にラベルを付ける</li>",ot,Q,gt,Y,ut,X,ql="画像分類とは異なり、オブジェクト検出は画像内の複数のオブジェクトを識別し、オブジェクトの位置を画像内で定義する境界ボックスによって特定します。オブジェクト検出の例には次のような用途があります：",Jt,E,vl="<li>自動運転車：他の車両、歩行者、信号機などの日常の交通オブジェクトを検出</li> <li>リモートセンシング：災害モニタリング、都市計画、天候予測</li> <li>欠陥検出：建物のクラックや構造上の損傷、製造上の欠陥を検出</li>",Ut,_,xt,F,Tt,S,Vl="画像セグメンテーションは、画像内のすべてのピクセルをクラスに割り当てるピクセルレベルのタスクです。これはオブジェクト検出とは異なり、オブジェクトをラベル付けし、予測するために境界ボックスを使用する代わりに、セグメンテーションはより詳細になります。セグメンテーションはピクセルレベルでオブジェクトを検出できます。画像セグメンテーションにはいくつかのタイプがあります：",bt,A,Nl="<li>インスタンスセグメンテーション：オブジェクトのクラスをラベル付けするだけでなく、オブジェクトの個別のインスタンス（“犬-1”、“犬-2”）もラベル付けします。</li> <li>パノプティックセグメンテーション：セマンティックセグメンテーションとインスタンスセグメンテーションの組み合わせ。セマンティッククラスごとに各ピクセルにラベルを付け、オブジェクトの個別のインスタンスもラベル付けします。</li>",dt,L,Rl="セグメンテーションタスクは、自動運転車にとって、周囲の世界のピクセルレベルのマップを作成し、歩行者や他の車両を安全に回避できるようにするのに役立ちます。また、医療画像では、タスクの細かい粒度が異常な細胞や臓器の特徴を識別するのに役立ちます。画像セグメンテーションは、eコマースで衣類を仮想的に試着したり、カメラを通じて実世界にオブジェクトを重ねて拡張現実の体験を作成したりするためにも使用できます。",wt,P,ft,K,Ct,D,zl="深度推定は、画像内の各ピクセルがカメラからの距離を予測します。このコンピュータビジョンタスクは、特にシーンの理解と再構築に重要です。たとえば、自動運転車では、歩行者、交通標識、他の車などの物体がどれだけ遠いかを理解し、障害物や衝突を回避するために必要です。深度情報はまた、2D画像から3D表現を構築し、生物学的構造や建物の高品質な3D表現を作成するのに役立ちます。",Zt,O,Ql="深度推定には次の2つのアプローチがあります：",It,ss,Yl="<li>ステレオ：深度は、わずかに異なる角度からの同じ画像の2つの画像を比較して推定されます。</li> <li>モノキュラー：深度は単一の画像から推定されます。</li>",$t,ts,Bt,ls,Wt,as,Xl="NLPタスクは、テキストが私たちにとって自然なコミュニケーション手段であるため、最も一般的なタスクの一つです。モデルが認識するための形式にテキストを変換するには、トークン化が必要です。これは、テキストのシーケンスを単語やサブワード（トークン）に分割し、それらのトークンを数字に変換することを意味します。その結果、テキストのシーケンスを数字のシーケンスとして表現し、一度数字のシーケンスがあれば、さまざまなNLPタスクを解決するためにモデルに入力できます！",Gt,ns,kt,es,El="どんなモダリティの分類タスクと同様に、テキスト分類は事前に定義されたクラスのセットからテキストのシーケンス（文レベル、段落、またはドキュメントであることがあります）にラベルを付けます。テキスト分類には多くの実用的な用途があり、その一部は次のとおりです：",Ht,ps,_l="<li>感情分析：<code>positive</code>や<code>negative</code>のような極性に従ってテキストにラベルを付け、政治、金融、マーケティングなどの分野での意思決定をサポートします。</li> <li>コンテンツ分類：テキストをトピックに従ってラベル付けし、ニュースやソーシャルメディアのフィード内の情報を整理し、フィルタリングするのに役立ちます（<code>天気</code>、<code>スポーツ</code>、<code>金融</code>など）。</li>",qt,is,vt,cs,Vt,rs,Fl='どんなNLPタスクでも、テキストはテキストのシーケンスを個々の単語やサブワードに分割して前処理されます。これらは<a href="/glossary#token">トークン</a>として知られています。トークン分類は、事前に定義されたクラスのセットから各トークンにラベルを割り当てます。',Nt,ms,Sl="トークン分類の一般的なタイプは次の2つです：",Rt,js,Al="<li>固有表現認識（NER）：組織、人物、場所、日付などのエンティティのカテゴリに従ってトークンにラベルを付けます。NERは特にバイオメディカル環境で人気であり、遺伝子、タンパク質、薬物名などをラベル付けできます。</li> <li>品詞タグ付け（POS）：名詞、動詞、形容詞などの品詞に従ってトークンにラベルを付けます。POSは、翻訳システムが同じ単語が文法的にどのように異なるかを理解するのに役立ちます（名詞としての「銀行」と動詞としての「銀行」など）。</li>",zt,hs,Qt,Ms,Yt,ys,Ll="質問応答は、コンテキスト（オープンドメイン）を含む場合と含まない場合（クローズドドメイン）がある場合もある、別のトークンレベルのタスクで、質問に対する回答を返します。このタスクは、仮想アシスタントにレストランが営業しているかどうかのような質問をするときに発生します。また、顧客や技術サポートを提供し、検索エンジンがあなたが求めている関連情報を取得するのにも役立ちます。",Xt,os,Pl="質問応答の一般的なタイプは次の2つです：",Et,gs,Kl='<li>抽出型：質問と一部のコンテキストが与えられた場合、モデルがコンテキストから抽出する必要のあるテキストのスパンが回答となります。</li> <li>抽象的：質問と一部のコンテキストが与えられた場合、回答はコンテキストから生成されます。このアプローチは、<a href="/docs/transformers/pr_31197/ja/main_classes/pipelines#transformers.QuestionAnsweringPipeline">QuestionAnsweringPipeline</a>ではなく<a href="/docs/transformers/pr_31197/ja/main_classes/pipelines#transformers.Text2TextGenerationPipeline">Text2TextGenerationPipeline</a>で処理されます。</li>',_t,us,Ft,Js,St,Us,Dl="要約は、長いテキストから短いバージョンを作成し、元の文書の意味の大部分を保ちながら試みるタスクです。要約はシーケンスからシーケンスへのタスクであり、入力よりも短いテキストシーケンスを出力します。要約を行うことで、読者が主要なポイントを迅速に理解できるようにするのに役立つ長文書がたくさんあります。法案、法的および財務文書、特許、科学論文など、読者の時間を節約し読書の支援となる文書の例があります。",At,xs,Ol="質問応答と同様に、要約には2つのタイプがあります：",Lt,Ts,sa='<li>抽出的要約：元のテキストから最も重要な文を識別して抽出します。</li> <li>抽象的要約：元のテキストからターゲットの要約（入力文書に含まれていない新しい単語を含むことがあります）を生成します。<a href="/docs/transformers/pr_31197/ja/main_classes/pipelines#transformers.SummarizationPipeline">SummarizationPipeline</a>は抽象的なアプローチを使用しています。</li>',Pt,bs,Kt,ds,Dt,ws,ta="翻訳は、ある言語のテキストシーケンスを別の言語に変換する作業です。これは異なるバックグラウンドを持つ人々がコミュニケーションをとるのに役立ち、広範な観客にコンテンツを翻訳して伝えるのに役立ち、新しい言語を学ぶのを支援する学習ツールにもなります。要約と共に、翻訳はシーケンス間のタスクであり、モデルは入力シーケンスを受け取り、ターゲットの出力シーケンスを返します。",Ot,fs,la="初期の翻訳モデルは主に単一言語でしたが、最近では多言語モデルに対する関心が高まり、多くの言語対で翻訳できるような多言語モデルに注目が集まっています。",sl,Cs,tl,Zs,ll,Is,aa="言語モデリングは、テキストのシーケンス内の単語を予測するタスクです。事前学習された言語モデルは、多くの他のダウンストリームタスクに対してファインチューニングできるため、非常に人気のあるNLPタスクとなっています。最近では、ゼロショットまたはフューショット学習を実証する大規模な言語モデル（LLM）に大きな関心が寄せられています。これは、モデルが明示的にトレーニングされていないタスクを解決できることを意味します！言語モデルは、流暢で説得力のあるテキストを生成するために使用できますが、テキストが常に正確であるわけではないため、注意が必要です。",al,$s,na="言語モデリングには2つのタイプがあります：",nl,J,Bs,Ys,ea="因果的：モデルの目標は、シーケンス内の次のトークンを予測することであり、将来のトークンはマスクされます。",Jl,Ws,Ul,Gs,Xs,pa="マスクされた：モデルの目的は、シーケンス内のトークン全体にアクセスしながら、シーケンス内のマスクされたトークンを予測することです。",xl,ks,el,Hs,pl,qs,ia="マルチモーダルタスクは、特定の問題を解決するために複数のデータモダリティ（テキスト、画像、音声、ビデオ）を処理するためにモデルを必要とします。画像キャプショニングは、モデルが入力として画像を受け取り、画像を説明するテキストのシーケンスまたは画像のいくつかの特性を出力するマルチモーダルタスクの例です。",il,vs,ca="マルチモーダルモデルは異なるデータタイプまたはモダリティで作業しますが、内部的には前処理ステップがモデルにすべてのデータタイプを埋め込み（データに関する意味のある情報を保持するベクトルまたは数字のリスト）に変換するのを支援します。画像キャプショニングのようなタスクでは、モデルは画像の埋め込みとテキストの埋め込みの間の関係を学習します。",cl,Vs,rl,Ns,ra="ドキュメント質問応答は、ドキュメントからの自然言語の質問に答えるタスクです。テキストを入力とするトークンレベルの質問応答タスクとは異なり、ドキュメント質問応答はドキュメントの画像とそのドキュメントに関する質問を受け取り、答えを返します。ドキュメント質問応答は構造化されたドキュメントを解析し、それから重要な情報を抽出するために使用できます。以下の例では、レシートから合計金額とお釣りを抽出することができます。",ml,Rs,jl,zs,ma='このページが各モダリティのタスクの種類とそれぞれの重要性についての追加の背景情報を提供できたことを願っています。次の <a href="tasks_explained">セクション</a> では、🤗 トランスフォーマーがこれらのタスクを解決するために <strong>どのように</strong> 動作するかを学びます。',hl,Qs,Ml,_s,yl;return x=new o({props:{title:"What 🤗 Transformers can do",local:"what--transformers-can-do",headingTag:"h1"}}),d=new o({props:{title:"Audio",local:"audio",headingTag:"h2"}}),C=new o({props:{title:"Audio classification",local:"audio-classification",headingTag:"h3"}}),$=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyc3VwZXJiJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWVyJTIyKSUwQXByZWRzJTIwJTNEJTIwY2xhc3NpZmllciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTdEJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlNUQlMEFwcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;superb/hubert-base-superb-er&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4532</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;hap&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3622</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sad&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0943</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;neu&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0903</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;ang&#x27;</span>}]`,wrap:!1}}),B=new o({props:{title:"Automatic speech recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),k=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMiklMEF0cmFuc2NyaWJlciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),H=new o({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),N=new o({props:{title:"Image classification",local:"image-classification",headingTag:"h3"}}),Q=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGNsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByaW50KCpwcmVkcyUyQyUyMHNlcCUzRCUyMiU1Q24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}`,wrap:!1}}),Y=new o({props:{title:"Object detection",local:"object-detection",headingTag:"h3"}}),_=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyb2JqZWN0LWRldGVjdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGRldGVjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpcGVsaW5lLWNhdC1jaG9uay5qcGVnJTIyJTBBKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTJDJTIwJTIyYm94JTIyJTNBJTIwcHJlZCU1QiUyMmJveCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(task=<span class="hljs-string">&quot;object-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = detector(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>], <span class="hljs-string">&quot;box&quot;</span>: pred[<span class="hljs-string">&quot;box&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9865</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">178</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">154</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">882</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">598</span>}}]`,wrap:!1}}),F=new o({props:{title:"Image segmentation",local:"image-segmentation",headingTag:"h3"}}),P=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLXNlZ21lbnRhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMHNlZ21lbnRlciglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQSklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJpbnQoKnByZWRzJTJDJTIwc2VwJTNEJTIyJTVDbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>segmenter = pipeline(task=<span class="hljs-string">&quot;image-segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = segmenter(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9879</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;LABEL_184&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9973</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9972</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>}`,wrap:!1}}),K=new o({props:{title:"Depth estimation",local:"depth-estimation",headingTag:"h3"}}),ts=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmRlcHRoLWVzdGltYXRpb24lMjIpJTBBcHJlZHMlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = depth_estimator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ls=new o({props:{title:"Natural language processing",local:"natural-language-processing",headingTag:"h2"}}),ns=new o({props:{title:"Text classification",local:"text-classification",headingTag:"h3"}}),is=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzZW50aW1lbnQtYW5hbHlzaXMlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjB0aGUlMjBiZXN0JTIwdGhpbmclMjBzaW5jZSUyMHNsaWNlZCUyMGJyZWFkISUyMiklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;sentiment-analysis&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is the best thing since sliced bread!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9991</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>}]`,wrap:!1}}),cs=new o({props:{title:"Token classification",local:"token-classification",headingTag:"h3"}}),hs=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJuZXIlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwRnJlbmNoJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBOZXclMjBZb3JrJTIwQ2l0eS4lMjIpJTBBcHJlZHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnRpdHklMjIlM0ElMjBwcmVkJTVCJTIyZW50aXR5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluZGV4JTIyJTNBJTIwcHJlZCU1QiUyMmluZGV4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd29yZCUyMiUzQSUyMHByZWQlNUIlMjJ3b3JkJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhcnQlMjIlM0ElMjBwcmVkJTVCJTIyc3RhcnQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmQlMjIlM0ElMjBwcmVkJTVCJTIyZW5kJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlMEElNUQlMEFwcmludCgqcHJlZHMlMkMlMjBzZXAlM0QlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;ner&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is a French company based in New York City.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;entity&quot;</span>: pred[<span class="hljs-string">&quot;entity&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;index&quot;</span>: pred[<span class="hljs-string">&quot;index&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;word&quot;</span>: pred[<span class="hljs-string">&quot;word&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;start&quot;</span>: pred[<span class="hljs-string">&quot;start&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;end&quot;</span>: pred[<span class="hljs-string">&quot;end&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9968</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Hu&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">2</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9293</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;##gging&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">7</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9763</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Face&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">12</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-MISC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9983</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">6</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;French&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">18</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">24</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;New&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">42</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">45</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9987</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;York&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">46</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">50</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9992</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">12</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;City&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">51</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">55</span>}`,wrap:!1}}),Ms=new o({props:{title:"Question answering",local:"question-answering",headingTag:"h3"}}),us=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcXVlc3Rpb25fYW5zd2VyZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyKSUwQXByZWRzJTIwJTNEJTIwcXVlc3Rpb25fYW5zd2VyZXIoJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjByZXBvc2l0b3J5JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzRCUyMlRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMHJlcG9zaXRvcnklMjBpcyUyMGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJTIyJTJDJTBBKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJzY29yZSUzQSUyMCU3QnJvdW5kKHByZWRzJTVCJ3Njb3JlJyU1RCUyQyUyMDQpJTdEJTJDJTIwc3RhcnQlM0ElMjAlN0JwcmVkcyU1QidzdGFydCclNUQlN0QlMkMlMjBlbmQlM0ElMjAlN0JwcmVkcyU1QidlbmQnJTVEJTdEJTJDJTIwYW5zd2VyJTNBJTIwJTdCcHJlZHMlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>question_answerer = pipeline(task=<span class="hljs-string">&quot;question-answering&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the name of the repository?&quot;</span>,
<span class="hljs-meta">... </span>    context=<span class="hljs-string">&quot;The name of the repository is huggingface/transformers&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;score: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(preds[<span class="hljs-string">&#x27;score&#x27;</span>], <span class="hljs-number">4</span>)}</span>, start: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;start&#x27;</span>]}</span>, end: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;end&#x27;</span>]}</span>, answer: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
<span class="hljs-meta">... </span>)
score: <span class="hljs-number">0.9327</span>, start: <span class="hljs-number">30</span>, end: <span class="hljs-number">54</span>, answer: huggingface/transformers`,wrap:!1}}),Js=new o({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),bs=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc3VtbWFyaXplciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzdW1tYXJpemF0aW9uJTIyKSUwQXN1bW1hcml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySW4lMjB0aGlzJTIwd29yayUyQyUyMHdlJTIwcHJlc2VudGVkJTIwdGhlJTIwVHJhbnNmb3JtZXIlMkMlMjB0aGUlMjBmaXJzdCUyMHNlcXVlbmNlJTIwdHJhbnNkdWN0aW9uJTIwbW9kZWwlMjBiYXNlZCUyMGVudGlyZWx5JTIwb24lMjBhdHRlbnRpb24lMkMlMjByZXBsYWNpbmclMjB0aGUlMjByZWN1cnJlbnQlMjBsYXllcnMlMjBtb3N0JTIwY29tbW9ubHklMjB1c2VkJTIwaW4lMjBlbmNvZGVyLWRlY29kZXIlMjBhcmNoaXRlY3R1cmVzJTIwd2l0aCUyMG11bHRpLWhlYWRlZCUyMHNlbGYtYXR0ZW50aW9uLiUyMEZvciUyMHRyYW5zbGF0aW9uJTIwdGFza3MlMkMlMjB0aGUlMjBUcmFuc2Zvcm1lciUyMGNhbiUyMGJlJTIwdHJhaW5lZCUyMHNpZ25pZmljYW50bHklMjBmYXN0ZXIlMjB0aGFuJTIwYXJjaGl0ZWN0dXJlcyUyMGJhc2VkJTIwb24lMjByZWN1cnJlbnQlMjBvciUyMGNvbnZvbHV0aW9uYWwlMjBsYXllcnMuJTIwT24lMjBib3RoJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tR2VybWFuJTIwYW5kJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tRnJlbmNoJTIwdHJhbnNsYXRpb24lMjB0YXNrcyUyQyUyMHdlJTIwYWNoaWV2ZSUyMGElMjBuZXclMjBzdGF0ZSUyMG9mJTIwdGhlJTIwYXJ0LiUyMEluJTIwdGhlJTIwZm9ybWVyJTIwdGFzayUyMG91ciUyMGJlc3QlMjBtb2RlbCUyMG91dHBlcmZvcm1zJTIwZXZlbiUyMGFsbCUyMHByZXZpb3VzbHklMjByZXBvcnRlZCUyMGVuc2VtYmxlcy4lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer = pipeline(task=<span class="hljs-string">&quot;summarization&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;In this work, we presented the Transformer, the first sequence transduction model based entirely on attention, replacing the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention. For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers. On both WMT 2014 English-to-German and WMT 2014 English-to-French translation tasks, we achieve a new state of the art. In the former task our best model outperforms even all previously reported ensembles.&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;summary_text&#x27;</span>: <span class="hljs-string">&#x27; The Transformer is the first sequence transduction model based entirely on attention . It replaces the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention . For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers .&#x27;</span>}]`,wrap:!1}}),ds=new o({props:{title:"Translation",local:"translation",headingTag:"h3"}}),Cs=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdGV4dCUyMCUzRCUyMCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEZyZW5jaCUzQSUyMEh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjBwbGF0Zm9ybSUyMGZvciUyMG1hY2hpbmUlMjBsZWFybmluZy4lMjIlMEF0cmFuc2xhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRyYW5zbGF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJnb29nbGUtdDUlMkZ0NS1zbWFsbCUyMiklMEF0cmFuc2xhdG9yKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;translate English to French: Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>translator = pipeline(task=<span class="hljs-string">&quot;translation&quot;</span>, model=<span class="hljs-string">&quot;google-t5/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>translator(text)
[{<span class="hljs-string">&#x27;translation_text&#x27;</span>: <span class="hljs-string">&quot;Hugging Face est une tribune communautaire de l&#x27;apprentissage des machines.&quot;</span>}]`,wrap:!1}}),Zs=new o({props:{title:"言語モデリング",local:"言語モデリング",headingTag:"h3"}}),Ws=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySHVnZ2luZyUyMEZhY2UlMjBpcyUyMGElMjBjb21tdW5pdHktYmFzZWQlMjBvcGVuLXNvdXJjZSUyMHBsYXRmb3JtJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIpJTBBZ2VuZXJhdG9yKHByb21wdCklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCU0tJUA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(prompt)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),ks=new g({props:{code:"dGV4dCUyMCUzRCUyMCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjAlM0NtYXNrJTNFJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWZpbGxfbWFzayUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJmaWxsLW1hc2slMjIpJTBBcHJlZHMlMjAlM0QlMjBmaWxsX21hc2sodGV4dCUyQyUyMHRvcF9rJTNEMSklMEFwcmVkcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b2tlbiUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRva2VuX3N0ciUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbl9zdHIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzZXF1ZW5jZSUyMiUzQSUyMHByZWQlNUIlMjJzZXF1ZW5jZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTBBJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hugging Face is a community-based open-source &lt;mask&gt; for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_mask = pipeline(task=<span class="hljs-string">&quot;fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = fill_mask(text, top_k=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token&quot;</span>: pred[<span class="hljs-string">&quot;token&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token_str&quot;</span>: pred[<span class="hljs-string">&quot;token_str&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;sequence&quot;</span>: pred[<span class="hljs-string">&quot;sequence&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2236</span>,
  <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">1761</span>,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27; platform&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hugging Face is a community-based open-source platform for machine learning.&#x27;</span>}]`,wrap:!1}}),Hs=new o({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),Vs=new o({props:{title:"Document question answering",local:"document-question-answering",headingTag:"h3"}}),Rs=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZXhhbXBsZS1kb2N1bWVudHMlMkZyZXNvbHZlJTJGbWFpbiUyRmpwZWdfaW1hZ2VzJTJGMi5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFkb2NfcXVlc3Rpb25fYW5zd2VyZXIlMjAlM0QlMjBwaXBlbGluZSglMjJkb2N1bWVudC1xdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMm1hZ29yc2h1bm92JTJGbGF5b3V0bG0taW52b2ljZXMlMjIpJTBBcHJlZHMlMjAlM0QlMjBkb2NfcXVlc3Rpb25fYW5zd2VyZXIoJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjB0b3RhbCUyMGFtb3VudCUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEEpJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/example-documents/resolve/main/jpeg_images/2.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>doc_question_answerer = pipeline(<span class="hljs-string">&quot;document-question-answering&quot;</span>, model=<span class="hljs-string">&quot;magorshunov/layoutlm-invoices&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = doc_question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the total amount?&quot;</span>,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.8531</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;17,000&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">4</span>}]`,wrap:!1}}),Qs=new Ja({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/task_summary.md"}}),{c(){u=p("meta"),Ss=n(),Es=p("p"),As=n(),r(x.$$.fragment),Ls=n(),T=p("p"),T.textContent=bl,Ps=n(),b=p("p"),b.textContent=dl,Ks=n(),r(d.$$.fragment),Ds=n(),w=p("p"),w.textContent=wl,Os=n(),f=p("p"),f.textContent=fl,st=n(),r(C.$$.fragment),tt=n(),Z=p("p"),Z.textContent=Cl,lt=n(),I=p("ul"),I.innerHTML=Zl,at=n(),r($.$$.fragment),nt=n(),r(B.$$.fragment),et=n(),W=p("p"),W.textContent=Il,pt=n(),G=p("p"),G.textContent=$l,it=n(),r(k.$$.fragment),ct=n(),r(H.$$.fragment),rt=n(),q=p("p"),q.innerHTML=Bl,mt=n(),v=p("p"),v.textContent=Wl,jt=n(),V=p("ol"),V.innerHTML=Gl,ht=n(),r(N.$$.fragment),Mt=n(),R=p("p"),R.textContent=kl,yt=n(),z=p("ul"),z.innerHTML=Hl,ot=n(),r(Q.$$.fragment),gt=n(),r(Y.$$.fragment),ut=n(),X=p("p"),X.textContent=ql,Jt=n(),E=p("ul"),E.innerHTML=vl,Ut=n(),r(_.$$.fragment),xt=n(),r(F.$$.fragment),Tt=n(),S=p("p"),S.textContent=Vl,bt=n(),A=p("ul"),A.innerHTML=Nl,dt=n(),L=p("p"),L.textContent=Rl,wt=n(),r(P.$$.fragment),ft=n(),r(K.$$.fragment),Ct=n(),D=p("p"),D.textContent=zl,Zt=n(),O=p("p"),O.textContent=Ql,It=n(),ss=p("ul"),ss.innerHTML=Yl,$t=n(),r(ts.$$.fragment),Bt=n(),r(ls.$$.fragment),Wt=n(),as=p("p"),as.textContent=Xl,Gt=n(),r(ns.$$.fragment),kt=n(),es=p("p"),es.textContent=El,Ht=n(),ps=p("ul"),ps.innerHTML=_l,qt=n(),r(is.$$.fragment),vt=n(),r(cs.$$.fragment),Vt=n(),rs=p("p"),rs.innerHTML=Fl,Nt=n(),ms=p("p"),ms.textContent=Sl,Rt=n(),js=p("ul"),js.innerHTML=Al,zt=n(),r(hs.$$.fragment),Qt=n(),r(Ms.$$.fragment),Yt=n(),ys=p("p"),ys.textContent=Ll,Xt=n(),os=p("p"),os.textContent=Pl,Et=n(),gs=p("ul"),gs.innerHTML=Kl,_t=n(),r(us.$$.fragment),Ft=n(),r(Js.$$.fragment),St=n(),Us=p("p"),Us.textContent=Dl,At=n(),xs=p("p"),xs.textContent=Ol,Lt=n(),Ts=p("ul"),Ts.innerHTML=sa,Pt=n(),r(bs.$$.fragment),Kt=n(),r(ds.$$.fragment),Dt=n(),ws=p("p"),ws.textContent=ta,Ot=n(),fs=p("p"),fs.textContent=la,sl=n(),r(Cs.$$.fragment),tl=n(),r(Zs.$$.fragment),ll=n(),Is=p("p"),Is.textContent=aa,al=n(),$s=p("p"),$s.textContent=na,nl=n(),J=p("ul"),Bs=p("li"),Ys=p("p"),Ys.textContent=ea,Jl=n(),r(Ws.$$.fragment),Ul=n(),Gs=p("li"),Xs=p("p"),Xs.textContent=pa,xl=n(),r(ks.$$.fragment),el=n(),r(Hs.$$.fragment),pl=n(),qs=p("p"),qs.textContent=ia,il=n(),vs=p("p"),vs.textContent=ca,cl=n(),r(Vs.$$.fragment),rl=n(),Ns=p("p"),Ns.textContent=ra,ml=n(),r(Rs.$$.fragment),jl=n(),zs=p("p"),zs.innerHTML=ma,hl=n(),r(Qs.$$.fragment),Ml=n(),_s=p("p"),this.h()},l(s){const t=ua("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(l),Ss=e(s),Es=i(s,"P",{}),Fs(Es).forEach(l),As=e(s),m(x.$$.fragment,s),Ls=e(s),T=i(s,"P",{"data-svelte-h":!0}),c(T)!=="svelte-ek4mfb"&&(T.textContent=bl),Ps=e(s),b=i(s,"P",{"data-svelte-h":!0}),c(b)!=="svelte-1rw5e2u"&&(b.textContent=dl),Ks=e(s),m(d.$$.fragment,s),Ds=e(s),w=i(s,"P",{"data-svelte-h":!0}),c(w)!=="svelte-15dyqe4"&&(w.textContent=wl),Os=e(s),f=i(s,"P",{"data-svelte-h":!0}),c(f)!=="svelte-lal6en"&&(f.textContent=fl),st=e(s),m(C.$$.fragment,s),tt=e(s),Z=i(s,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1k2664o"&&(Z.textContent=Cl),lt=e(s),I=i(s,"UL",{"data-svelte-h":!0}),c(I)!=="svelte-1qvj2e6"&&(I.innerHTML=Zl),at=e(s),m($.$$.fragment,s),nt=e(s),m(B.$$.fragment,s),et=e(s),W=i(s,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1m26psw"&&(W.textContent=Il),pt=e(s),G=i(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-r87y6j"&&(G.textContent=$l),it=e(s),m(k.$$.fragment,s),ct=e(s),m(H.$$.fragment,s),rt=e(s),q=i(s,"P",{"data-svelte-h":!0}),c(q)!=="svelte-18036m9"&&(q.innerHTML=Bl),mt=e(s),v=i(s,"P",{"data-svelte-h":!0}),c(v)!=="svelte-ymmeyz"&&(v.textContent=Wl),jt=e(s),V=i(s,"OL",{"data-svelte-h":!0}),c(V)!=="svelte-v4gh81"&&(V.innerHTML=Gl),ht=e(s),m(N.$$.fragment,s),Mt=e(s),R=i(s,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1mp36i8"&&(R.textContent=kl),yt=e(s),z=i(s,"UL",{"data-svelte-h":!0}),c(z)!=="svelte-j3igwn"&&(z.innerHTML=Hl),ot=e(s),m(Q.$$.fragment,s),gt=e(s),m(Y.$$.fragment,s),ut=e(s),X=i(s,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1xlgwtm"&&(X.textContent=ql),Jt=e(s),E=i(s,"UL",{"data-svelte-h":!0}),c(E)!=="svelte-vyf034"&&(E.innerHTML=vl),Ut=e(s),m(_.$$.fragment,s),xt=e(s),m(F.$$.fragment,s),Tt=e(s),S=i(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-ryfffz"&&(S.textContent=Vl),bt=e(s),A=i(s,"UL",{"data-svelte-h":!0}),c(A)!=="svelte-1rz6dd1"&&(A.innerHTML=Nl),dt=e(s),L=i(s,"P",{"data-svelte-h":!0}),c(L)!=="svelte-rbr5j5"&&(L.textContent=Rl),wt=e(s),m(P.$$.fragment,s),ft=e(s),m(K.$$.fragment,s),Ct=e(s),D=i(s,"P",{"data-svelte-h":!0}),c(D)!=="svelte-qofxu2"&&(D.textContent=zl),Zt=e(s),O=i(s,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1npln10"&&(O.textContent=Ql),It=e(s),ss=i(s,"UL",{"data-svelte-h":!0}),c(ss)!=="svelte-1i4tid3"&&(ss.innerHTML=Yl),$t=e(s),m(ts.$$.fragment,s),Bt=e(s),m(ls.$$.fragment,s),Wt=e(s),as=i(s,"P",{"data-svelte-h":!0}),c(as)!=="svelte-1m59zxk"&&(as.textContent=Xl),Gt=e(s),m(ns.$$.fragment,s),kt=e(s),es=i(s,"P",{"data-svelte-h":!0}),c(es)!=="svelte-1a39rcj"&&(es.textContent=El),Ht=e(s),ps=i(s,"UL",{"data-svelte-h":!0}),c(ps)!=="svelte-1wx0y2z"&&(ps.innerHTML=_l),qt=e(s),m(is.$$.fragment,s),vt=e(s),m(cs.$$.fragment,s),Vt=e(s),rs=i(s,"P",{"data-svelte-h":!0}),c(rs)!=="svelte-mrs7ie"&&(rs.innerHTML=Fl),Nt=e(s),ms=i(s,"P",{"data-svelte-h":!0}),c(ms)!=="svelte-l02yas"&&(ms.textContent=Sl),Rt=e(s),js=i(s,"UL",{"data-svelte-h":!0}),c(js)!=="svelte-109mihx"&&(js.innerHTML=Al),zt=e(s),m(hs.$$.fragment,s),Qt=e(s),m(Ms.$$.fragment,s),Yt=e(s),ys=i(s,"P",{"data-svelte-h":!0}),c(ys)!=="svelte-edc05x"&&(ys.textContent=Ll),Xt=e(s),os=i(s,"P",{"data-svelte-h":!0}),c(os)!=="svelte-1vhjwqv"&&(os.textContent=Pl),Et=e(s),gs=i(s,"UL",{"data-svelte-h":!0}),c(gs)!=="svelte-bfk8hs"&&(gs.innerHTML=Kl),_t=e(s),m(us.$$.fragment,s),Ft=e(s),m(Js.$$.fragment,s),St=e(s),Us=i(s,"P",{"data-svelte-h":!0}),c(Us)!=="svelte-oh104g"&&(Us.textContent=Dl),At=e(s),xs=i(s,"P",{"data-svelte-h":!0}),c(xs)!=="svelte-1i939bz"&&(xs.textContent=Ol),Lt=e(s),Ts=i(s,"UL",{"data-svelte-h":!0}),c(Ts)!=="svelte-i2xbsx"&&(Ts.innerHTML=sa),Pt=e(s),m(bs.$$.fragment,s),Kt=e(s),m(ds.$$.fragment,s),Dt=e(s),ws=i(s,"P",{"data-svelte-h":!0}),c(ws)!=="svelte-1eoa6ft"&&(ws.textContent=ta),Ot=e(s),fs=i(s,"P",{"data-svelte-h":!0}),c(fs)!=="svelte-fyu2t"&&(fs.textContent=la),sl=e(s),m(Cs.$$.fragment,s),tl=e(s),m(Zs.$$.fragment,s),ll=e(s),Is=i(s,"P",{"data-svelte-h":!0}),c(Is)!=="svelte-ts71z3"&&(Is.textContent=aa),al=e(s),$s=i(s,"P",{"data-svelte-h":!0}),c($s)!=="svelte-ph2wi1"&&($s.textContent=na),nl=e(s),J=i(s,"UL",{});var ol=Fs(J);Bs=i(ol,"LI",{});var gl=Fs(Bs);Ys=i(gl,"P",{"data-svelte-h":!0}),c(Ys)!=="svelte-e09crk"&&(Ys.textContent=ea),Jl=e(gl),m(Ws.$$.fragment,gl),gl.forEach(l),Ul=e(ol),Gs=i(ol,"LI",{});var ul=Fs(Gs);Xs=i(ul,"P",{"data-svelte-h":!0}),c(Xs)!=="svelte-1vyw9g3"&&(Xs.textContent=pa),xl=e(ul),m(ks.$$.fragment,ul),ul.forEach(l),ol.forEach(l),el=e(s),m(Hs.$$.fragment,s),pl=e(s),qs=i(s,"P",{"data-svelte-h":!0}),c(qs)!=="svelte-9np98f"&&(qs.textContent=ia),il=e(s),vs=i(s,"P",{"data-svelte-h":!0}),c(vs)!=="svelte-miuti3"&&(vs.textContent=ca),cl=e(s),m(Vs.$$.fragment,s),rl=e(s),Ns=i(s,"P",{"data-svelte-h":!0}),c(Ns)!=="svelte-1q7jq3c"&&(Ns.textContent=ra),ml=e(s),m(Rs.$$.fragment,s),jl=e(s),zs=i(s,"P",{"data-svelte-h":!0}),c(zs)!=="svelte-1ik2fe4"&&(zs.innerHTML=ma),hl=e(s),m(Qs.$$.fragment,s),Ml=e(s),_s=i(s,"P",{}),Fs(_s).forEach(l),this.h()},h(){ja(u,"name","hf:doc:metadata"),ja(u,"content",xa)},m(s,t){U(document.head,u),a(s,Ss,t),a(s,Es,t),a(s,As,t),j(x,s,t),a(s,Ls,t),a(s,T,t),a(s,Ps,t),a(s,b,t),a(s,Ks,t),j(d,s,t),a(s,Ds,t),a(s,w,t),a(s,Os,t),a(s,f,t),a(s,st,t),j(C,s,t),a(s,tt,t),a(s,Z,t),a(s,lt,t),a(s,I,t),a(s,at,t),j($,s,t),a(s,nt,t),j(B,s,t),a(s,et,t),a(s,W,t),a(s,pt,t),a(s,G,t),a(s,it,t),j(k,s,t),a(s,ct,t),j(H,s,t),a(s,rt,t),a(s,q,t),a(s,mt,t),a(s,v,t),a(s,jt,t),a(s,V,t),a(s,ht,t),j(N,s,t),a(s,Mt,t),a(s,R,t),a(s,yt,t),a(s,z,t),a(s,ot,t),j(Q,s,t),a(s,gt,t),j(Y,s,t),a(s,ut,t),a(s,X,t),a(s,Jt,t),a(s,E,t),a(s,Ut,t),j(_,s,t),a(s,xt,t),j(F,s,t),a(s,Tt,t),a(s,S,t),a(s,bt,t),a(s,A,t),a(s,dt,t),a(s,L,t),a(s,wt,t),j(P,s,t),a(s,ft,t),j(K,s,t),a(s,Ct,t),a(s,D,t),a(s,Zt,t),a(s,O,t),a(s,It,t),a(s,ss,t),a(s,$t,t),j(ts,s,t),a(s,Bt,t),j(ls,s,t),a(s,Wt,t),a(s,as,t),a(s,Gt,t),j(ns,s,t),a(s,kt,t),a(s,es,t),a(s,Ht,t),a(s,ps,t),a(s,qt,t),j(is,s,t),a(s,vt,t),j(cs,s,t),a(s,Vt,t),a(s,rs,t),a(s,Nt,t),a(s,ms,t),a(s,Rt,t),a(s,js,t),a(s,zt,t),j(hs,s,t),a(s,Qt,t),j(Ms,s,t),a(s,Yt,t),a(s,ys,t),a(s,Xt,t),a(s,os,t),a(s,Et,t),a(s,gs,t),a(s,_t,t),j(us,s,t),a(s,Ft,t),j(Js,s,t),a(s,St,t),a(s,Us,t),a(s,At,t),a(s,xs,t),a(s,Lt,t),a(s,Ts,t),a(s,Pt,t),j(bs,s,t),a(s,Kt,t),j(ds,s,t),a(s,Dt,t),a(s,ws,t),a(s,Ot,t),a(s,fs,t),a(s,sl,t),j(Cs,s,t),a(s,tl,t),j(Zs,s,t),a(s,ll,t),a(s,Is,t),a(s,al,t),a(s,$s,t),a(s,nl,t),a(s,J,t),U(J,Bs),U(Bs,Ys),U(Bs,Jl),j(Ws,Bs,null),U(J,Ul),U(J,Gs),U(Gs,Xs),U(Gs,xl),j(ks,Gs,null),a(s,el,t),j(Hs,s,t),a(s,pl,t),a(s,qs,t),a(s,il,t),a(s,vs,t),a(s,cl,t),j(Vs,s,t),a(s,rl,t),a(s,Ns,t),a(s,ml,t),j(Rs,s,t),a(s,jl,t),a(s,zs,t),a(s,hl,t),j(Qs,s,t),a(s,Ml,t),a(s,_s,t),yl=!0},p:Ma,i(s){yl||(h(x.$$.fragment,s),h(d.$$.fragment,s),h(C.$$.fragment,s),h($.$$.fragment,s),h(B.$$.fragment,s),h(k.$$.fragment,s),h(H.$$.fragment,s),h(N.$$.fragment,s),h(Q.$$.fragment,s),h(Y.$$.fragment,s),h(_.$$.fragment,s),h(F.$$.fragment,s),h(P.$$.fragment,s),h(K.$$.fragment,s),h(ts.$$.fragment,s),h(ls.$$.fragment,s),h(ns.$$.fragment,s),h(is.$$.fragment,s),h(cs.$$.fragment,s),h(hs.$$.fragment,s),h(Ms.$$.fragment,s),h(us.$$.fragment,s),h(Js.$$.fragment,s),h(bs.$$.fragment,s),h(ds.$$.fragment,s),h(Cs.$$.fragment,s),h(Zs.$$.fragment,s),h(Ws.$$.fragment,s),h(ks.$$.fragment,s),h(Hs.$$.fragment,s),h(Vs.$$.fragment,s),h(Rs.$$.fragment,s),h(Qs.$$.fragment,s),yl=!0)},o(s){M(x.$$.fragment,s),M(d.$$.fragment,s),M(C.$$.fragment,s),M($.$$.fragment,s),M(B.$$.fragment,s),M(k.$$.fragment,s),M(H.$$.fragment,s),M(N.$$.fragment,s),M(Q.$$.fragment,s),M(Y.$$.fragment,s),M(_.$$.fragment,s),M(F.$$.fragment,s),M(P.$$.fragment,s),M(K.$$.fragment,s),M(ts.$$.fragment,s),M(ls.$$.fragment,s),M(ns.$$.fragment,s),M(is.$$.fragment,s),M(cs.$$.fragment,s),M(hs.$$.fragment,s),M(Ms.$$.fragment,s),M(us.$$.fragment,s),M(Js.$$.fragment,s),M(bs.$$.fragment,s),M(ds.$$.fragment,s),M(Cs.$$.fragment,s),M(Zs.$$.fragment,s),M(Ws.$$.fragment,s),M(ks.$$.fragment,s),M(Hs.$$.fragment,s),M(Vs.$$.fragment,s),M(Rs.$$.fragment,s),M(Qs.$$.fragment,s),yl=!1},d(s){s&&(l(Ss),l(Es),l(As),l(Ls),l(T),l(Ps),l(b),l(Ks),l(Ds),l(w),l(Os),l(f),l(st),l(tt),l(Z),l(lt),l(I),l(at),l(nt),l(et),l(W),l(pt),l(G),l(it),l(ct),l(rt),l(q),l(mt),l(v),l(jt),l(V),l(ht),l(Mt),l(R),l(yt),l(z),l(ot),l(gt),l(ut),l(X),l(Jt),l(E),l(Ut),l(xt),l(Tt),l(S),l(bt),l(A),l(dt),l(L),l(wt),l(ft),l(Ct),l(D),l(Zt),l(O),l(It),l(ss),l($t),l(Bt),l(Wt),l(as),l(Gt),l(kt),l(es),l(Ht),l(ps),l(qt),l(vt),l(Vt),l(rs),l(Nt),l(ms),l(Rt),l(js),l(zt),l(Qt),l(Yt),l(ys),l(Xt),l(os),l(Et),l(gs),l(_t),l(Ft),l(St),l(Us),l(At),l(xs),l(Lt),l(Ts),l(Pt),l(Kt),l(Dt),l(ws),l(Ot),l(fs),l(sl),l(tl),l(ll),l(Is),l(al),l($s),l(nl),l(J),l(el),l(pl),l(qs),l(il),l(vs),l(cl),l(rl),l(Ns),l(ml),l(jl),l(zs),l(hl),l(Ml),l(_s)),l(u),y(x,s),y(d,s),y(C,s),y($,s),y(B,s),y(k,s),y(H,s),y(N,s),y(Q,s),y(Y,s),y(_,s),y(F,s),y(P,s),y(K,s),y(ts,s),y(ls,s),y(ns,s),y(is,s),y(cs,s),y(hs,s),y(Ms,s),y(us,s),y(Js,s),y(bs,s),y(ds,s),y(Cs,s),y(Zs,s),y(Ws),y(ks),y(Hs,s),y(Vs,s),y(Rs,s),y(Qs,s)}}}const xa='{"title":"What 🤗 Transformers can do","local":"what--transformers-can-do","sections":[{"title":"Audio","local":"audio","sections":[{"title":"Audio classification","local":"audio-classification","sections":[],"depth":3},{"title":"Automatic speech recognition","local":"automatic-speech-recognition","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"Image classification","local":"image-classification","sections":[],"depth":3},{"title":"Object detection","local":"object-detection","sections":[],"depth":3},{"title":"Image segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Depth estimation","local":"depth-estimation","sections":[],"depth":3}],"depth":2},{"title":"Natural language processing","local":"natural-language-processing","sections":[{"title":"Text classification","local":"text-classification","sections":[],"depth":3},{"title":"Token classification","local":"token-classification","sections":[],"depth":3},{"title":"Question answering","local":"question-answering","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"言語モデリング","local":"言語モデリング","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Document question answering","local":"document-question-answering","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ta(Tl){return ya(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ca extends oa{constructor(u){super(),ga(this,u,Ta,Ua,ha,{})}}export{Ca as component};
