import{s as Vt,o as Yt,n as Pe}from"../chunks/scheduler.9bc65507.js";import{S as Qt,i as Ht,g as M,s as n,r as m,A as Et,h as i,f as t,c as a,j as Gt,u as y,x as p,k as xt,y as zt,a as s,v as r,d as c,t as d,w as J}from"../chunks/index.707bf1b6.js";import{T as Le}from"../chunks/Tip.c2ecdbf4.js";import{C as T}from"../chunks/CodeBlock.54a9f38d.js";import{H as Nl,E as Ft}from"../chunks/EditOnGithub.922df6ba.js";function St(U){let o,j="モデルがライブラリ内のモデルと非常に似ている場合、このモデルと同じ構成を再利用できます。";return{c(){o=M("p"),o.textContent=j},l(w){o=i(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-ezhjpv"&&(o.textContent=j)},m(w,f){s(w,o,f)},p:Pe,d(w){w&&t(o)}}}function Lt(U){let o,j="このAPIは実験的であり、次のリリースでわずかな変更があるかもしれません。";return{c(){o=M("p"),o.textContent=j},l(w){o=i(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-x2rm6d"&&(o.textContent=j)},m(w,f){s(w,o,f)},p:Pe,d(w){w&&t(o)}}}function Pt(U){let o,j="ライブラリからモデリングファイルをコピーする場合、ファイルの先頭にあるすべての相対インポートを<code>transformers</code>パッケージからインポートに置き換える必要があります。";return{c(){o=M("p"),o.innerHTML=j},l(w){o=i(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-18u9vuk"&&(o.innerHTML=j)},m(w,f){s(w,o,f)},p:Pe,d(w){w&&t(o)}}}function qt(U){let o,j,w,f,I,Rl,_,qe="🤗 Transformersライブラリは、簡単に拡張できるように設計されています。すべてのモデルはリポジトリの特定のサブフォルダに完全にコード化されており、抽象化はありません。したがって、モデリングファイルをコピーして調整することが簡単です。",vl,Z,De="新しいモデルを書いている場合、ゼロから始める方が簡単かもしれません。このチュートリアルでは、カスタムモデルとその設定をどのように書き、Transformers内で使用できるようにし、コードに依存する共同体と共有する方法を説明します。ライブラリに存在しない場合でも、誰でも使用できるようにします。",Xl,h,Ke='これを実証するために、<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timmライブラリ</a>のResNetクラスを<a href="/docs/transformers/pr_31197/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>にラップすることによって、ResNetモデルを使用します。',Gl,g,xl,$,Oe="モデルに取り組む前に、まずその設定を書きましょう。モデルの設定は、モデルを構築するために必要なすべての情報を含むオブジェクトです。次のセクションで見るように、モデルは初期化するために<code>config</code>しか受け取ることができないため、そのオブジェクトができるだけ完全である必要があります。",Vl,A,lt="この例では、ResNetクラスのいくつかの引数を取得し、調整したいかもしれないとします。異なる設定は、異なるタイプのResNetを提供します。その後、これらの引数を確認した後、それらの引数を単に格納します。",Yl,k,Ql,B,et="重要なことを3つ覚えておくべきポイントは次のとおりです：",Hl,N,tt="<li><code>PretrainedConfig</code> を継承する必要があります。</li> <li>あなたの <code>PretrainedConfig</code> の <code>__init__</code> は任意の kwargs を受け入れる必要があります。</li> <li>これらの <code>kwargs</code> は親クラスの <code>__init__</code> に渡す必要があります。</li>",El,W,st=`継承は、🤗 Transformers ライブラリのすべての機能を取得できるようにするためです。他の2つの制約は、
<code>PretrainedConfig</code> が設定しているフィールド以外にも多くのフィールドを持っていることから来ています。
<code>from_pretrained</code> メソッドで設定を再ロードする場合、これらのフィールドはあなたの設定に受け入れられ、
その後、親クラスに送信される必要があります。`,zl,R,nt=`設定の <code>model_type</code> を定義すること（ここでは <code>model_type=&quot;resnet&quot;</code>）は、
自動クラスにモデルを登録したい場合を除いては必須ではありません（最後のセクションを参照）。`,Fl,v,at=`これで、ライブラリの他のモデル設定と同様に、設定を簡単に作成して保存できます。
以下は、resnet50d 設定を作成して保存する方法の例です：`,Sl,X,Ll,G,Mt="これにより、<code>custom-resnet</code> フォルダ内に <code>config.json</code> という名前のファイルが保存されます。その後、<code>from_pretrained</code> メソッドを使用して構成を再ロードできます。",Pl,x,ql,V,it='また、<a href="/docs/transformers/pr_31197/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> クラスの他のメソッドを使用することもできます。たとえば、<a href="/docs/transformers/pr_31197/ja/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> を使用して、設定を直接 Hub にアップロードできます。',Dl,Y,Kl,Q,pt='ResNet の設定ができたので、モデルを書き始めることができます。実際には2つのモデルを書きます。1つはバッチの画像から隠れた特徴を抽出するモデル（<a href="/docs/transformers/pr_31197/ja/model_doc/bert#transformers.BertModel">BertModel</a> のようなもの）で、もう1つは画像分類に適したモデル（<a href="/docs/transformers/pr_31197/ja/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a> のようなもの）です。',Ol,H,ot="前述したように、この例をシンプルに保つために、モデルの緩いラッパーのみを書きます。このクラスを書く前に行う必要がある唯一のことは、ブロックタイプと実際のブロッククラスの間のマップです。その後、すべてを <code>ResNet</code> クラスに渡して設定からモデルを定義します：",le,E,ee,z,mt="画像を分類するモデルの場合、forwardメソッドを変更するだけです：",te,F,se,S,yt=`両方の場合、<code>PreTrainedModel</code>から継承し、<code>config</code>を使用してスーパークラスの初期化を呼び出します（通常の<code>torch.nn.Module</code>を書くときのような感じです）。
<code>config_class</code>を設定する行は必須ではありませんが、（最後のセクションを参照）、モデルを自動クラスに登録したい場合に使用できます。`,ne,u,ae,L,rt=`モデルが返す内容は何でも構いませんが、ラベルが渡されるときに損失を含む辞書を返す（<code>ResnetModelForImageClassification</code>のように行ったもの）と、
モデルを<a href="/docs/transformers/pr_31197/ja/main_classes/trainer#transformers.Trainer">Trainer</a>クラス内で直接使用できるようになります。独自のトレーニングループまたは他のライブラリを使用する予定である限り、
別の出力形式を使用することも問題ありません。`,Me,P,ct="さて、モデルクラスができたので、1つ作成しましょう：",ie,q,pe,D,dt=`再度、<a href="/docs/transformers/pr_31197/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>のいずれかのメソッド、例えば<a href="/docs/transformers/pr_31197/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>や
<a href="/docs/transformers/pr_31197/ja/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>などを使用できます。次のセクションでは、モデルの重みをコードと一緒に
Hugging Face Hub にプッシュする方法を見てみます。
しかし、まずはモデル内に事前学習済みの重みをロードしましょう。`,oe,K,Jt=`独自のユースケースでは、おそらく独自のデータでカスタムモデルをトレーニングすることになるでしょう。
このチュートリアルではスピードアップのために、resnet50dの事前学習済みバージョンを使用します。
私たちのモデルはそれをラップするだけなので、これらの重みを転送するのは簡単です：`,me,O,ye,ll,wt=`さて、<a href="/docs/transformers/pr_31197/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>または<a href="/docs/transformers/pr_31197/ja/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>を実行したときに、
モデルのコードが保存されるようにする方法を見てみましょう。`,re,el,ce,C,de,tl,Tt=`まず、モデルが<code>.py</code>ファイルに完全に定義されていることを確認してください。
ファイルは相対インポートを他のファイルに依存できますが、すべてのファイルが同じディレクトリにある限り（まだこの機能ではサブモジュールはサポートしていません）、問題ありません。
この例では、現在の作業ディレクトリ内に名前が「resnet_model」のフォルダを作成し、その中に<code>modeling_resnet.py</code>ファイルと<code>configuration_resnet.py</code>ファイルを定義します。
構成ファイルには<code>ResnetConfig</code>のコードが含まれ、モデリングファイルには<code>ResnetModel</code>と<code>ResnetModelForImageClassification</code>のコードが含まれています。`,Je,sl,we,nl,jt="<code>__init__.py</code>は空であっても問題ありません。Pythonが<code>resnet_model</code>をモジュールとして検出できるようにするために存在します。",Te,b,je,al,ft="既存の設定やモデルを再利用（またはサブクラス化）できることに注意してください。",fe,Ml,Ut="コミュニティとモデルを共有するために、次の手順に従ってください：まず、新しく作成したファイルからResNetモデルと設定をインポートします：",Ue,il,ue,pl,ut="次に、<code>save_pretrained</code>メソッドを使用してこれらのオブジェクトのコードファイルをコピーし、特定のAutoクラス（特にモデルの場合）に正しく登録するようライブラリに指示する必要があります。次のように実行します：",Ce,ol,be,ml,Ct=`注意: 設定については自動クラスを指定する必要はありません（設定用の自動クラスは1つしかなく、<a href="/docs/transformers/pr_31197/ja/model_doc/auto#transformers.AutoConfig">AutoConfig</a>です）が、
モデルについては異なります。カスタムモデルは多くの異なるタスクに適している可能性があるため、
モデルが正確な自動クラスのうちどれに適しているかを指定する必要があります。`,Ie,yl,bt="次に、前述のように設定とモデルを作成しましょう：",_e,rl,Ze,cl,It="モデルをHubに送信するには、ログインしていることを確認してください。ターミナルで次のコマンドを実行します：",he,dl,ge,Jl,_t="またはノートブックから：",$e,wl,Ae,Tl,Zt="次に、次のようにして、独自の名前空間にプッシュできます（または、メンバーである組織にプッシュできます）：",ke,jl,Be,fl,ht='モデリングの重みとJSON形式の構成に加えて、このフォルダー「custom-resnet50d」内のモデリングおよび構成「.py」ファイルもコピーされ、結果はHubにアップロードされました。結果はこの<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>で確認できます。',Ne,Ul,gt='詳細については、<a href="model_sharing">Hubへのプッシュ方法</a>を参照してください。',We,ul,Re,Cl,$t=`自動クラスと <code>from_pretrained</code> メソッドを使用して、リポジトリ内のカスタムコードファイルと共に任意の構成、モデル、またはトークナイザを使用できます。 Hubにアップロードされるすべてのファイルとコードはマルウェアのスキャンが実施されます（詳細は<a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hubセキュリティ</a>ドキュメンテーションを参照してください）、しかし、依然として悪意のあるコードを実行しないために、モデルコードと作者を確認する必要があります。
<code>trust_remote_code=True</code> を設定してカスタムコードを持つモデルを使用できます：`,ve,bl,Xe,Il,At="コミットハッシュを「revision」として渡すことも強く推奨されています。これにより、モデルの作者がコードを悪意のある新しい行で更新しなかったことを確認できます（モデルの作者を完全に信頼している場合を除きます）。",Ge,_l,xe,Zl,kt="モデルリポジトリのコミット履歴をブラウジングする際には、任意のコミットのコミットハッシュを簡単にコピーできるボタンがあります。",Ve,hl,Ye,gl,Bt=`🤗 Transformersを拡張するライブラリを作成している場合、独自のモデルを含めるために自動クラスを拡張したい場合があります。
これはコードをHubにプッシュすることとは異なり、ユーザーはカスタムモデルを取得するためにあなたのライブラリをインポートする必要があります
（Hubからモデルコードを自動的にダウンロードするのとは対照的です）。`,Qe,$l,Nt=`構成に既存のモデルタイプと異なる <code>model_type</code> 属性がある限り、またあなたのモデルクラスが適切な <code>config_class</code> 属性を持っている限り、
次のようにそれらを自動クラスに追加できます：`,He,Al,Ee,kl,Wt=`注意: <code>AutoConfig</code> にカスタム設定を登録する際の最初の引数は、カスタム設定の <code>model_type</code> と一致する必要があります。
また、任意の自動モデルクラスにカスタムモデルを登録する際の最初の引数は、それらのモデルの <code>config_class</code> と一致する必要があります。`,ze,Bl,Fe,Wl,Se;return I=new Nl({props:{title:"Sharing custom models",local:"sharing-custom-models",headingTag:"h1"}}),g=new Nl({props:{title:"Writing a custom configuration",local:"writing-a-custom-configuration",headingTag:"h2"}}),k=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),X=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),x=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),Y=new Nl({props:{title:"Writing a custom model",local:"writing-a-custom-model",headingTag:"h2"}}),E=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),F=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),u=new Le({props:{$$slots:{default:[St]},$$scope:{ctx:U}}}),q=new T({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new T({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),el=new Nl({props:{title:"Sending the code to the Hub",local:"sending-the-code-to-the-hub",headingTag:"h2"}}),C=new Le({props:{warning:!0,$$slots:{default:[Lt]},$$scope:{ctx:U}}}),sl=new T({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),b=new Le({props:{warning:!0,$$slots:{default:[Pt]},$$scope:{ctx:U}}}),il=new T({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),ol=new T({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),rl=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),dl=new T({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),wl=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),jl=new T({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),ul=new Nl({props:{title:"Using a model with custom code",local:"using-a-model-with-custom-code",headingTag:"h2"}}),bl=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),_l=new T({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),hl=new Nl({props:{title:"Registering a model with custom code to the auto classes",local:"registering-a-model-with-custom-code-to-the-auto-classes",headingTag:"h2"}}),Al=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),Bl=new Ft({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/custom_models.md"}}),{c(){o=M("meta"),j=n(),w=M("p"),f=n(),m(I.$$.fragment),Rl=n(),_=M("p"),_.textContent=qe,vl=n(),Z=M("p"),Z.textContent=De,Xl=n(),h=M("p"),h.innerHTML=Ke,Gl=n(),m(g.$$.fragment),xl=n(),$=M("p"),$.innerHTML=Oe,Vl=n(),A=M("p"),A.textContent=lt,Yl=n(),m(k.$$.fragment),Ql=n(),B=M("p"),B.textContent=et,Hl=n(),N=M("ul"),N.innerHTML=tt,El=n(),W=M("p"),W.innerHTML=st,zl=n(),R=M("p"),R.innerHTML=nt,Fl=n(),v=M("p"),v.textContent=at,Sl=n(),m(X.$$.fragment),Ll=n(),G=M("p"),G.innerHTML=Mt,Pl=n(),m(x.$$.fragment),ql=n(),V=M("p"),V.innerHTML=it,Dl=n(),m(Y.$$.fragment),Kl=n(),Q=M("p"),Q.innerHTML=pt,Ol=n(),H=M("p"),H.innerHTML=ot,le=n(),m(E.$$.fragment),ee=n(),z=M("p"),z.textContent=mt,te=n(),m(F.$$.fragment),se=n(),S=M("p"),S.innerHTML=yt,ne=n(),m(u.$$.fragment),ae=n(),L=M("p"),L.innerHTML=rt,Me=n(),P=M("p"),P.textContent=ct,ie=n(),m(q.$$.fragment),pe=n(),D=M("p"),D.innerHTML=dt,oe=n(),K=M("p"),K.textContent=Jt,me=n(),m(O.$$.fragment),ye=n(),ll=M("p"),ll.innerHTML=wt,re=n(),m(el.$$.fragment),ce=n(),m(C.$$.fragment),de=n(),tl=M("p"),tl.innerHTML=Tt,Je=n(),m(sl.$$.fragment),we=n(),nl=M("p"),nl.innerHTML=jt,Te=n(),m(b.$$.fragment),je=n(),al=M("p"),al.textContent=ft,fe=n(),Ml=M("p"),Ml.textContent=Ut,Ue=n(),m(il.$$.fragment),ue=n(),pl=M("p"),pl.innerHTML=ut,Ce=n(),m(ol.$$.fragment),be=n(),ml=M("p"),ml.innerHTML=Ct,Ie=n(),yl=M("p"),yl.textContent=bt,_e=n(),m(rl.$$.fragment),Ze=n(),cl=M("p"),cl.textContent=It,he=n(),m(dl.$$.fragment),ge=n(),Jl=M("p"),Jl.textContent=_t,$e=n(),m(wl.$$.fragment),Ae=n(),Tl=M("p"),Tl.textContent=Zt,ke=n(),m(jl.$$.fragment),Be=n(),fl=M("p"),fl.innerHTML=ht,Ne=n(),Ul=M("p"),Ul.innerHTML=gt,We=n(),m(ul.$$.fragment),Re=n(),Cl=M("p"),Cl.innerHTML=$t,ve=n(),m(bl.$$.fragment),Xe=n(),Il=M("p"),Il.textContent=At,Ge=n(),m(_l.$$.fragment),xe=n(),Zl=M("p"),Zl.textContent=kt,Ve=n(),m(hl.$$.fragment),Ye=n(),gl=M("p"),gl.textContent=Bt,Qe=n(),$l=M("p"),$l.innerHTML=Nt,He=n(),m(Al.$$.fragment),Ee=n(),kl=M("p"),kl.innerHTML=Wt,ze=n(),m(Bl.$$.fragment),Fe=n(),Wl=M("p"),this.h()},l(l){const e=Et("svelte-u9bgzb",document.head);o=i(e,"META",{name:!0,content:!0}),e.forEach(t),j=a(l),w=i(l,"P",{}),Gt(w).forEach(t),f=a(l),y(I.$$.fragment,l),Rl=a(l),_=i(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-gxna3m"&&(_.textContent=qe),vl=a(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1nn0sjo"&&(Z.textContent=De),Xl=a(l),h=i(l,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1uwojg5"&&(h.innerHTML=Ke),Gl=a(l),y(g.$$.fragment,l),xl=a(l),$=i(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-bwvin"&&($.innerHTML=Oe),Vl=a(l),A=i(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1q4nzi3"&&(A.textContent=lt),Yl=a(l),y(k.$$.fragment,l),Ql=a(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1xagbsn"&&(B.textContent=et),Hl=a(l),N=i(l,"UL",{"data-svelte-h":!0}),p(N)!=="svelte-18ieeo"&&(N.innerHTML=tt),El=a(l),W=i(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1hhagdn"&&(W.innerHTML=st),zl=a(l),R=i(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-u1g66p"&&(R.innerHTML=nt),Fl=a(l),v=i(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1cqw2yw"&&(v.textContent=at),Sl=a(l),y(X.$$.fragment,l),Ll=a(l),G=i(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-j8wp82"&&(G.innerHTML=Mt),Pl=a(l),y(x.$$.fragment,l),ql=a(l),V=i(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-35a0fk"&&(V.innerHTML=it),Dl=a(l),y(Y.$$.fragment,l),Kl=a(l),Q=i(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-13lqwco"&&(Q.innerHTML=pt),Ol=a(l),H=i(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-rnqflg"&&(H.innerHTML=ot),le=a(l),y(E.$$.fragment,l),ee=a(l),z=i(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-xqb496"&&(z.textContent=mt),te=a(l),y(F.$$.fragment,l),se=a(l),S=i(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1gy8gfa"&&(S.innerHTML=yt),ne=a(l),y(u.$$.fragment,l),ae=a(l),L=i(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1ys0jpn"&&(L.innerHTML=rt),Me=a(l),P=i(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-c12zx8"&&(P.textContent=ct),ie=a(l),y(q.$$.fragment,l),pe=a(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1i20b68"&&(D.innerHTML=dt),oe=a(l),K=i(l,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1ysoenl"&&(K.textContent=Jt),me=a(l),y(O.$$.fragment,l),ye=a(l),ll=i(l,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-1c3uuo7"&&(ll.innerHTML=wt),re=a(l),y(el.$$.fragment,l),ce=a(l),y(C.$$.fragment,l),de=a(l),tl=i(l,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-12w8qw2"&&(tl.innerHTML=Tt),Je=a(l),y(sl.$$.fragment,l),we=a(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-161l0tk"&&(nl.innerHTML=jt),Te=a(l),y(b.$$.fragment,l),je=a(l),al=i(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-1sofoh7"&&(al.textContent=ft),fe=a(l),Ml=i(l,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-10ja7ra"&&(Ml.textContent=Ut),Ue=a(l),y(il.$$.fragment,l),ue=a(l),pl=i(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-14w73fp"&&(pl.innerHTML=ut),Ce=a(l),y(ol.$$.fragment,l),be=a(l),ml=i(l,"P",{"data-svelte-h":!0}),p(ml)!=="svelte-1vrrdpb"&&(ml.innerHTML=Ct),Ie=a(l),yl=i(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-x4hehz"&&(yl.textContent=bt),_e=a(l),y(rl.$$.fragment,l),Ze=a(l),cl=i(l,"P",{"data-svelte-h":!0}),p(cl)!=="svelte-4gjqmb"&&(cl.textContent=It),he=a(l),y(dl.$$.fragment,l),ge=a(l),Jl=i(l,"P",{"data-svelte-h":!0}),p(Jl)!=="svelte-170hls0"&&(Jl.textContent=_t),$e=a(l),y(wl.$$.fragment,l),Ae=a(l),Tl=i(l,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-j85q6g"&&(Tl.textContent=Zt),ke=a(l),y(jl.$$.fragment,l),Be=a(l),fl=i(l,"P",{"data-svelte-h":!0}),p(fl)!=="svelte-1v5wui"&&(fl.innerHTML=ht),Ne=a(l),Ul=i(l,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-1r595oo"&&(Ul.innerHTML=gt),We=a(l),y(ul.$$.fragment,l),Re=a(l),Cl=i(l,"P",{"data-svelte-h":!0}),p(Cl)!=="svelte-1rhh9p5"&&(Cl.innerHTML=$t),ve=a(l),y(bl.$$.fragment,l),Xe=a(l),Il=i(l,"P",{"data-svelte-h":!0}),p(Il)!=="svelte-6ln3mo"&&(Il.textContent=At),Ge=a(l),y(_l.$$.fragment,l),xe=a(l),Zl=i(l,"P",{"data-svelte-h":!0}),p(Zl)!=="svelte-1mlo6re"&&(Zl.textContent=kt),Ve=a(l),y(hl.$$.fragment,l),Ye=a(l),gl=i(l,"P",{"data-svelte-h":!0}),p(gl)!=="svelte-1dtzfm7"&&(gl.textContent=Bt),Qe=a(l),$l=i(l,"P",{"data-svelte-h":!0}),p($l)!=="svelte-1xrka00"&&($l.innerHTML=Nt),He=a(l),y(Al.$$.fragment,l),Ee=a(l),kl=i(l,"P",{"data-svelte-h":!0}),p(kl)!=="svelte-1eri869"&&(kl.innerHTML=Wt),ze=a(l),y(Bl.$$.fragment,l),Fe=a(l),Wl=i(l,"P",{}),Gt(Wl).forEach(t),this.h()},h(){xt(o,"name","hf:doc:metadata"),xt(o,"content",Dt)},m(l,e){zt(document.head,o),s(l,j,e),s(l,w,e),s(l,f,e),r(I,l,e),s(l,Rl,e),s(l,_,e),s(l,vl,e),s(l,Z,e),s(l,Xl,e),s(l,h,e),s(l,Gl,e),r(g,l,e),s(l,xl,e),s(l,$,e),s(l,Vl,e),s(l,A,e),s(l,Yl,e),r(k,l,e),s(l,Ql,e),s(l,B,e),s(l,Hl,e),s(l,N,e),s(l,El,e),s(l,W,e),s(l,zl,e),s(l,R,e),s(l,Fl,e),s(l,v,e),s(l,Sl,e),r(X,l,e),s(l,Ll,e),s(l,G,e),s(l,Pl,e),r(x,l,e),s(l,ql,e),s(l,V,e),s(l,Dl,e),r(Y,l,e),s(l,Kl,e),s(l,Q,e),s(l,Ol,e),s(l,H,e),s(l,le,e),r(E,l,e),s(l,ee,e),s(l,z,e),s(l,te,e),r(F,l,e),s(l,se,e),s(l,S,e),s(l,ne,e),r(u,l,e),s(l,ae,e),s(l,L,e),s(l,Me,e),s(l,P,e),s(l,ie,e),r(q,l,e),s(l,pe,e),s(l,D,e),s(l,oe,e),s(l,K,e),s(l,me,e),r(O,l,e),s(l,ye,e),s(l,ll,e),s(l,re,e),r(el,l,e),s(l,ce,e),r(C,l,e),s(l,de,e),s(l,tl,e),s(l,Je,e),r(sl,l,e),s(l,we,e),s(l,nl,e),s(l,Te,e),r(b,l,e),s(l,je,e),s(l,al,e),s(l,fe,e),s(l,Ml,e),s(l,Ue,e),r(il,l,e),s(l,ue,e),s(l,pl,e),s(l,Ce,e),r(ol,l,e),s(l,be,e),s(l,ml,e),s(l,Ie,e),s(l,yl,e),s(l,_e,e),r(rl,l,e),s(l,Ze,e),s(l,cl,e),s(l,he,e),r(dl,l,e),s(l,ge,e),s(l,Jl,e),s(l,$e,e),r(wl,l,e),s(l,Ae,e),s(l,Tl,e),s(l,ke,e),r(jl,l,e),s(l,Be,e),s(l,fl,e),s(l,Ne,e),s(l,Ul,e),s(l,We,e),r(ul,l,e),s(l,Re,e),s(l,Cl,e),s(l,ve,e),r(bl,l,e),s(l,Xe,e),s(l,Il,e),s(l,Ge,e),r(_l,l,e),s(l,xe,e),s(l,Zl,e),s(l,Ve,e),r(hl,l,e),s(l,Ye,e),s(l,gl,e),s(l,Qe,e),s(l,$l,e),s(l,He,e),r(Al,l,e),s(l,Ee,e),s(l,kl,e),s(l,ze,e),r(Bl,l,e),s(l,Fe,e),s(l,Wl,e),Se=!0},p(l,[e]){const Rt={};e&2&&(Rt.$$scope={dirty:e,ctx:l}),u.$set(Rt);const vt={};e&2&&(vt.$$scope={dirty:e,ctx:l}),C.$set(vt);const Xt={};e&2&&(Xt.$$scope={dirty:e,ctx:l}),b.$set(Xt)},i(l){Se||(c(I.$$.fragment,l),c(g.$$.fragment,l),c(k.$$.fragment,l),c(X.$$.fragment,l),c(x.$$.fragment,l),c(Y.$$.fragment,l),c(E.$$.fragment,l),c(F.$$.fragment,l),c(u.$$.fragment,l),c(q.$$.fragment,l),c(O.$$.fragment,l),c(el.$$.fragment,l),c(C.$$.fragment,l),c(sl.$$.fragment,l),c(b.$$.fragment,l),c(il.$$.fragment,l),c(ol.$$.fragment,l),c(rl.$$.fragment,l),c(dl.$$.fragment,l),c(wl.$$.fragment,l),c(jl.$$.fragment,l),c(ul.$$.fragment,l),c(bl.$$.fragment,l),c(_l.$$.fragment,l),c(hl.$$.fragment,l),c(Al.$$.fragment,l),c(Bl.$$.fragment,l),Se=!0)},o(l){d(I.$$.fragment,l),d(g.$$.fragment,l),d(k.$$.fragment,l),d(X.$$.fragment,l),d(x.$$.fragment,l),d(Y.$$.fragment,l),d(E.$$.fragment,l),d(F.$$.fragment,l),d(u.$$.fragment,l),d(q.$$.fragment,l),d(O.$$.fragment,l),d(el.$$.fragment,l),d(C.$$.fragment,l),d(sl.$$.fragment,l),d(b.$$.fragment,l),d(il.$$.fragment,l),d(ol.$$.fragment,l),d(rl.$$.fragment,l),d(dl.$$.fragment,l),d(wl.$$.fragment,l),d(jl.$$.fragment,l),d(ul.$$.fragment,l),d(bl.$$.fragment,l),d(_l.$$.fragment,l),d(hl.$$.fragment,l),d(Al.$$.fragment,l),d(Bl.$$.fragment,l),Se=!1},d(l){l&&(t(j),t(w),t(f),t(Rl),t(_),t(vl),t(Z),t(Xl),t(h),t(Gl),t(xl),t($),t(Vl),t(A),t(Yl),t(Ql),t(B),t(Hl),t(N),t(El),t(W),t(zl),t(R),t(Fl),t(v),t(Sl),t(Ll),t(G),t(Pl),t(ql),t(V),t(Dl),t(Kl),t(Q),t(Ol),t(H),t(le),t(ee),t(z),t(te),t(se),t(S),t(ne),t(ae),t(L),t(Me),t(P),t(ie),t(pe),t(D),t(oe),t(K),t(me),t(ye),t(ll),t(re),t(ce),t(de),t(tl),t(Je),t(we),t(nl),t(Te),t(je),t(al),t(fe),t(Ml),t(Ue),t(ue),t(pl),t(Ce),t(be),t(ml),t(Ie),t(yl),t(_e),t(Ze),t(cl),t(he),t(ge),t(Jl),t($e),t(Ae),t(Tl),t(ke),t(Be),t(fl),t(Ne),t(Ul),t(We),t(Re),t(Cl),t(ve),t(Xe),t(Il),t(Ge),t(xe),t(Zl),t(Ve),t(Ye),t(gl),t(Qe),t($l),t(He),t(Ee),t(kl),t(ze),t(Fe),t(Wl)),t(o),J(I,l),J(g,l),J(k,l),J(X,l),J(x,l),J(Y,l),J(E,l),J(F,l),J(u,l),J(q,l),J(O,l),J(el,l),J(C,l),J(sl,l),J(b,l),J(il,l),J(ol,l),J(rl,l),J(dl,l),J(wl,l),J(jl,l),J(ul,l),J(bl,l),J(_l,l),J(hl,l),J(Al,l),J(Bl,l)}}}const Dt='{"title":"Sharing custom models","local":"sharing-custom-models","sections":[{"title":"Writing a custom configuration","local":"writing-a-custom-configuration","sections":[],"depth":2},{"title":"Writing a custom model","local":"writing-a-custom-model","sections":[],"depth":2},{"title":"Sending the code to the Hub","local":"sending-the-code-to-the-hub","sections":[],"depth":2},{"title":"Using a model with custom code","local":"using-a-model-with-custom-code","sections":[],"depth":2},{"title":"Registering a model with custom code to the auto classes","local":"registering-a-model-with-custom-code-to-the-auto-classes","sections":[],"depth":2}],"depth":1}';function Kt(U){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends Qt{constructor(o){super(),Ht(this,o,Kt,qt,Vt,{})}}export{ns as component};
