import{s as Kt,n as Ot,o as se}from"../chunks/scheduler.25b97de1.js";import{S as te,i as ee,g as p,s as l,r as c,A as ae,h as i,f as e,c as n,j as Pt,u as r,x as o,k as d,y as le,a,v as m,d as h,t as g,w as M}from"../chunks/index.d9030fc9.js";import{C as y}from"../chunks/CodeBlock.e6cd0d95.js";import{D as ne}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as us,E as pe}from"../chunks/EditOnGithub.91d95064.js";function ie(Jt){let j,bs,js,Js,T,Us,C,ws,W,Ut=`Traditionally, models used for <a href="object_detection">object detection</a> require labeled image datasets for training,
and are limited to detecting the set of classes from the training data.`,xs,v,wt=`Zero-shot object detection is supported by the <a href="../model_doc/owlvit">OWL-ViT</a> model which uses a different approach. OWL-ViT
is an open-vocabulary object detector. It means that it can detect objects in images based on free-text queries without
the need to fine-tune the model on labeled datasets.`,fs,I,xt=`OWL-ViT leverages multi-modal representations to perform open-vocabulary detection. It combines <a href="../model_doc/clip">CLIP</a> with
lightweight object classification and localization heads. Open-vocabulary detection is achieved by embedding free-text queries with the text encoder of CLIP and using them as input to the object classification and localization heads.
associate images and their corresponding textual descriptions, and ViT processes image patches as inputs. The authors
of OWL-ViT first trained CLIP from scratch and then fine-tuned OWL-ViT end to end on standard object detection datasets using
a bipartite matching loss.`,Ts,k,ft="With this approach, the model can detect objects based on textual descriptions without prior training on labeled datasets.",Cs,$,Tt="In this guide, you will learn how to use OWL-ViT:",Ws,z,Ct="<li>to detect objects based on text prompts</li> <li>for batch object detection</li> <li>for image-guided object detection</li>",vs,Z,Wt="Before you begin, make sure you have all the necessary libraries installed:",Is,_,ks,Q,$s,R,vt=`The simplest way to try out inference with OWL-ViT is to use it in a <a href="/docs/transformers/pr_31197/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>. Instantiate a pipeline
for zero-shot object detection from a <a href="https://huggingface.co/models?other=owlvit" rel="nofollow">checkpoint on the Hugging Face Hub</a>:`,zs,V,Zs,B,It=`Next, choose an image you’d like to detect objects in. Here we’ll use the image of astronaut Eileen Collins that is
a part of the <a href="https://www.nasa.gov/multimedia/imagegallery/index.html" rel="nofollow">NASA</a> Great Images dataset.`,_s,H,Qs,u,kt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_1.png" alt="Astronaut Eileen Collins"/>',Rs,N,$t=`Pass the image and the candidate object labels to look for to the pipeline.
Here we pass the image directly; other suitable options include a local path to an image or an image url. We also pass text descriptions for all items we want to query the image for.`,Vs,q,Bs,X,zt="Let’s visualize the predictions:",Hs,G,Ns,b,Zt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_2.png" alt="Visualized predictions on NASA image"/>',qs,Y,Xs,E,_t=`Now that you’ve seen how to use the zero-shot object detection pipeline, let’s replicate the same
result manually.`,Gs,S,Qt=`Start by loading the model and associated processor from a <a href="https://huggingface.co/models?other=owlvit" rel="nofollow">checkpoint on the Hugging Face Hub</a>.
Here we’ll use the same checkpoint as before:`,Ys,F,Es,L,Rt="Let’s take a different image to switch things up.",Ss,A,Fs,J,Vt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_3.png" alt="Beach photo"/>',Ls,D,Bt=`Use the processor to prepare the inputs for the model. The processor combines an image processor that prepares the
image for the model by resizing and normalizing it, and a <a href="/docs/transformers/pr_31197/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> that takes care of the text inputs.`,As,P,Ds,K,Ht=`Pass the inputs through the model, post-process, and visualize the results. Since the image processor resized images before
feeding them to the model, you need to use the <a href="/docs/transformers/pr_31197/en/model_doc/owlvit#transformers.OwlViTImageProcessor.post_process_object_detection">post_process_object_detection()</a> method to make sure the predicted bounding
boxes have the correct coordinates relative to the original image:`,Ps,O,Ks,U,Nt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',Os,ss,st,ts,qt=`You can pass multiple sets of images and text queries to search for different (or same) objects in several images.
Let’s use both an astronaut image and the beach image together.
For batch processing, you should pass text queries as a nested list to the processor and images as lists of PIL images,
PyTorch tensors, or NumPy arrays.`,tt,es,et,as,Xt=`Previously for post-processing you passed the single image’s size as a tensor, but you can also pass a tuple, or, in case
of several images, a list of tuples. Let’s create predictions for the two examples, and visualize the second one (<code>image_idx = 1</code>).`,at,ls,lt,w,Gt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',nt,ns,pt,ps,Yt=`In addition to zero-shot object detection with text queries, OWL-ViT offers image-guided object detection. This means
you can use an image query to find similar objects in the target image.
Unlike text queries, only a single example image is allowed.`,it,is,Et=`Let’s take an image with two cats on a couch as a target image, and an image of a single cat
as a query:`,ot,os,ct,cs,St="Let’s take a quick look at the images:",rt,rs,mt,x,Ft='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_5.png" alt="Cats"/>',ht,ms,Lt="In the preprocessing step, instead of text queries, you now need to use <code>query_images</code>:",gt,hs,Mt,gs,At=`For predictions, instead of passing the inputs to the model, pass them to <a href="/docs/transformers/pr_31197/en/model_doc/owlvit#transformers.OwlViTForObjectDetection.image_guided_detection">image_guided_detection()</a>. Draw the predictions
as before except now there are no labels.`,yt,Ms,jt,f,Dt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_6.png" alt="Cats with bounding boxes"/>',dt,ys,ut,ds,bt;return T=new us({props:{title:"Zero-shot object detection",local:"zero-shot-object-detection",headingTag:"h1"}}),C=new ne({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/zero_shot_object_detection.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/zero_shot_object_detection.ipynb"}]}}),_=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),Q=new us({props:{title:"Zero-shot object detection pipeline",local:"zero-shot-object-detection-pipeline",headingTag:"h2"}}),V=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNi1lbnNlbWJsZSUyMiUwQWRldGVjdG9yJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0RjaGVja3BvaW50JTJDJTIwdGFzayUzRCUyMnplcm8tc2hvdC1vYmplY3QtZGV0ZWN0aW9uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;zero-shot-object-detection&quot;</span>)`,wrap:!1}}),H=new y({props:{code:"aW1wb3J0JTIwc2tpbWFnZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWltYWdlJTIwJTNEJTIwc2tpbWFnZS5kYXRhLmFzdHJvbmF1dCgpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkobnAudWludDgoaW1hZ2UpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> skimage
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = skimage.data.astronaut()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(np.uint8(image)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),q=new y({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXRlY3RvciglMEElMjAlMjAlMjAlMjBpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJodW1hbiUyMGZhY2UlMjIlMkMlMjAlMjJyb2NrZXQlMjIlMkMlMjAlMjJuYXNhJTIwYmFkZ2UlMjIlMkMlMjAlMjJzdGFyLXNwYW5nbGVkJTIwYmFubmVyJTIyJTVEJTJDJTBBKSUwQXByZWRpY3Rpb25z",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = detector(
<span class="hljs-meta">... </span>    image,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>predictions
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3571370542049408</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;human face&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">180</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">71</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">271</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">178</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.28099656105041504</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">129</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">348</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">206</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">427</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2110239565372467</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">350</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: -<span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">468</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">288</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13790413737297058</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;star-spangled banner&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">105</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">509</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.11950037628412247</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">277</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">338</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">327</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">380</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10649408400058746</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">358</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">64</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">424</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">280</span>}}]`,wrap:!1}}),G=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlRHJhdyUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZSklMEElMEFmb3IlMjBwcmVkaWN0aW9uJTIwaW4lMjBwcmVkaWN0aW9ucyUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJib3glMjIlNUQlMEElMjAlMjAlMjAlMjBsYWJlbCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJsYWJlbCUyMiU1RCUwQSUyMCUyMCUyMCUyMHNjb3JlJTIwJTNEJTIwcHJlZGljdGlvbiU1QiUyMnNjb3JlJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIweG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCUyMCUzRCUyMGJveC52YWx1ZXMoKSUwQSUyMCUyMCUyMCUyMGRyYXcucmVjdGFuZ2xlKCh4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4KSUyQyUyMG91dGxpbmUlM0QlMjJyZWQlMjIlMkMlMjB3aWR0aCUzRDEpJTBBJTIwJTIwJTIwJTIwZHJhdy50ZXh0KCh4bWluJTJDJTIweW1pbiklMkMlMjBmJTIyJTdCbGFiZWwlN0QlM0ElMjAlN0Jyb3VuZChzY29yZSUyQzIpJTdEJTIyJTJDJTIwZmlsbCUzRCUyMndoaXRlJTIyKSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> ImageDraw

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> prediction <span class="hljs-keyword">in</span> predictions:
<span class="hljs-meta">... </span>    box = prediction[<span class="hljs-string">&quot;box&quot;</span>]
<span class="hljs-meta">... </span>    label = prediction[<span class="hljs-string">&quot;label&quot;</span>]
<span class="hljs-meta">... </span>    score = prediction[<span class="hljs-string">&quot;score&quot;</span>]

<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box.values()
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{label}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),Y=new us({props:{title:"Text-prompted zero-shot object detection by hand",local:"text-prompted-zero-shot-object-detection-by-hand",headingTag:"h2"}}),F=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),A=new y({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRm9qMHplWTJMdGs0JTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4elpXRnlZMmg4TVRSOGZIQnBZMjVwWTN4bGJud3dmSHg4ZkRFMk56YzBPVEUxTkRrJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlt",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/oj0zeY2Ltk4/download?ixid=MnwxMjA3fDB8MXxzZWFyY2h8MTR8fHBpY25pY3xlbnwwfHx8fDE2Nzc0OTE1NDk&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>im = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>im`,wrap:!1}}),P=new y({props:{code:"dGV4dF9xdWVyaWVzJTIwJTNEJTIwJTVCJTIyaGF0JTIyJTJDJTIwJTIyYm9vayUyMiUyQyUyMCUyMnN1bmdsYXNzZXMlMjIlMkMlMjAlMjJjYW1lcmElMjIlNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRfcXVlcmllcyUyQyUyMGltYWdlcyUzRGltJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=im, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),O=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbS5zaXplJTVCJTNBJTNBLTElNUQlNUQpJTBBJTIwJTIwJTIwJTIwcmVzdWx0cyUyMCUzRCUyMHByb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfb2JqZWN0X2RldGVjdGlvbihvdXRwdXRzJTJDJTIwdGhyZXNob2xkJTNEMC4xJTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzKSU1QjAlNUQlMEElMEFkcmF3JTIwJTNEJTIwSW1hZ2VEcmF3LkRyYXcoaW0pJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWxhYmVscyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQudG9saXN0KCklMEFib3hlcyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJib3hlcyUyMiU1RC50b2xpc3QoKSUwQSUwQWZvciUyMGJveCUyQyUyMHNjb3JlJTJDJTIwbGFiZWwlMjBpbiUyMHppcChib3hlcyUyQyUyMHNjb3JlcyUyQyUyMGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjB4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4JTIwJTNEJTIwYm94JTBBJTIwJTIwJTIwJTIwZHJhdy5yZWN0YW5nbGUoKHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXgpJTJDJTIwb3V0bGluZSUzRCUyMnJlZCUyMiUyQyUyMHdpZHRoJTNEMSklMEElMjAlMjAlMjAlMjBkcmF3LnRleHQoKHhtaW4lMkMlMjB5bWluKSUyQyUyMGYlMjIlN0J0ZXh0X3F1ZXJpZXMlNUJsYWJlbCU1RCU3RCUzQSUyMCU3QnJvdW5kKHNjb3JlJTJDMiklN0QlMjIlMkMlMjBmaWxsJTNEJTIyd2hpdGUlMjIpJTBBJTBBaW0=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([im.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(im)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>im`,wrap:!1}}),ss=new us({props:{title:"Batch processing",local:"batch-processing",headingTag:"h2"}}),es=new y({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCaW1hZ2UlMkMlMjBpbSU1RCUwQXRleHRfcXVlcmllcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU1QiUyMmh1bWFuJTIwZmFjZSUyMiUyQyUyMCUyMnJvY2tldCUyMiUyQyUyMCUyMm5hc2ElMjBiYWRnZSUyMiUyQyUyMCUyMnN0YXItc3BhbmdsZWQlMjBiYW5uZXIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJoYXQlMjIlMkMlMjAlMjJib29rJTIyJTJDJTIwJTIyc3VuZ2xhc3NlcyUyMiUyQyUyMCUyMmNhbWVyYSUyMiU1RCUyQyUwQSU1RCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dF9xdWVyaWVzJTJDJTIwaW1hZ2VzJTNEaW1hZ2VzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>images = [image, im]
<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>],
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),ls=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlMjAlM0QlMjAlNUJ4LnNpemUlNUIlM0ElM0EtMSU1RCUyMGZvciUyMHglMjBpbiUyMGltYWdlcyU1RCUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuMSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklMEElMEFpbWFnZV9pZHglMjAlM0QlMjAxJTBBZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlcyU1QmltYWdlX2lkeCU1RCklMEElMEFzY29yZXMlMjAlM0QlMjByZXN1bHRzJTVCaW1hZ2VfaWR4JTVEJTVCJTIyc2NvcmVzJTIyJTVELnRvbGlzdCgpJTBBbGFiZWxzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmxhYmVscyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIycmVkJTIyJTJDJTIwd2lkdGglM0QxKSUwQSUyMCUyMCUyMCUyMGRyYXcudGV4dCgoeG1pbiUyQyUyMHltaW4pJTJDJTIwZiUyMiU3QnRleHRfcXVlcmllcyU1QmltYWdlX2lkeCU1RCU1QmxhYmVsJTVEJTdEJTNBJTIwJTdCcm91bmQoc2NvcmUlMkMyKSU3RCUyMiUyQyUyMGZpbGwlM0QlMjJ3aGl0ZSUyMiklMEElMEFpbWFnZXMlNUJpbWFnZV9pZHglNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = [x.size[::-<span class="hljs-number">1</span>] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> images]
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_idx = <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(images[image_idx])

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[image_idx][<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[image_idx][<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[image_idx][<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[image_idx][label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images[image_idx]`,wrap:!1}}),ns=new us({props:{title:"Image-guided object detection",local:"image-guided-object-detection",headingTag:"h2"}}),os=new y({props:{code:"dXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlX3RhcmdldCUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFxdWVyeV91cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDA1MjQyODAuanBnJTIyJTBBcXVlcnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChxdWVyeV91cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_target = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>query_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000524280.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query_image = Image.<span class="hljs-built_in">open</span>(requests.get(query_url, stream=<span class="hljs-literal">True</span>).raw)`,wrap:!1}}),rs=new y({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4JTIwJTNEJTIwcGx0LnN1YnBsb3RzKDElMkMlMjAyKSUwQWF4JTVCMCU1RC5pbXNob3coaW1hZ2VfdGFyZ2V0KSUwQWF4JTVCMSU1RC5pbXNob3cocXVlcnlfaW1hZ2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, ax = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">0</span>].imshow(image_target)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">1</span>].imshow(query_image)`,wrap:!1}}),hs=new y({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlX3RhcmdldCUyQyUyMHF1ZXJ5X2ltYWdlcyUzRHF1ZXJ5X2ltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image_target, query_images=query_image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Ms=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5pbWFnZV9ndWlkZWRfZGV0ZWN0aW9uKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbWFnZV90YXJnZXQuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2ltYWdlX2d1aWRlZF9kZXRlY3Rpb24ob3V0cHV0cyUzRG91dHB1dHMlMkMlMjB0YXJnZXRfc2l6ZXMlM0R0YXJnZXRfc2l6ZXMpJTVCMCU1RCUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZV90YXJnZXQpJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIyd2hpdGUlMjIlMkMlMjB3aWR0aCUzRDQpJTBBJTBBaW1hZ2VfdGFyZ2V0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model.image_guided_detection(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([image_target.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_image_guided_detection(outputs=outputs, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image_target)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;white&quot;</span>, width=<span class="hljs-number">4</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_target`,wrap:!1}}),ys=new pe({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/zero_shot_object_detection.md"}}),{c(){j=p("meta"),bs=l(),js=p("p"),Js=l(),c(T.$$.fragment),Us=l(),c(C.$$.fragment),ws=l(),W=p("p"),W.innerHTML=Ut,xs=l(),v=p("p"),v.innerHTML=wt,fs=l(),I=p("p"),I.innerHTML=xt,Ts=l(),k=p("p"),k.textContent=ft,Cs=l(),$=p("p"),$.textContent=Tt,Ws=l(),z=p("ul"),z.innerHTML=Ct,vs=l(),Z=p("p"),Z.textContent=Wt,Is=l(),c(_.$$.fragment),ks=l(),c(Q.$$.fragment),$s=l(),R=p("p"),R.innerHTML=vt,zs=l(),c(V.$$.fragment),Zs=l(),B=p("p"),B.innerHTML=It,_s=l(),c(H.$$.fragment),Qs=l(),u=p("div"),u.innerHTML=kt,Rs=l(),N=p("p"),N.textContent=$t,Vs=l(),c(q.$$.fragment),Bs=l(),X=p("p"),X.textContent=zt,Hs=l(),c(G.$$.fragment),Ns=l(),b=p("div"),b.innerHTML=Zt,qs=l(),c(Y.$$.fragment),Xs=l(),E=p("p"),E.textContent=_t,Gs=l(),S=p("p"),S.innerHTML=Qt,Ys=l(),c(F.$$.fragment),Es=l(),L=p("p"),L.textContent=Rt,Ss=l(),c(A.$$.fragment),Fs=l(),J=p("div"),J.innerHTML=Vt,Ls=l(),D=p("p"),D.innerHTML=Bt,As=l(),c(P.$$.fragment),Ds=l(),K=p("p"),K.innerHTML=Ht,Ps=l(),c(O.$$.fragment),Ks=l(),U=p("div"),U.innerHTML=Nt,Os=l(),c(ss.$$.fragment),st=l(),ts=p("p"),ts.textContent=qt,tt=l(),c(es.$$.fragment),et=l(),as=p("p"),as.innerHTML=Xt,at=l(),c(ls.$$.fragment),lt=l(),w=p("div"),w.innerHTML=Gt,nt=l(),c(ns.$$.fragment),pt=l(),ps=p("p"),ps.textContent=Yt,it=l(),is=p("p"),is.textContent=Et,ot=l(),c(os.$$.fragment),ct=l(),cs=p("p"),cs.textContent=St,rt=l(),c(rs.$$.fragment),mt=l(),x=p("div"),x.innerHTML=Ft,ht=l(),ms=p("p"),ms.innerHTML=Lt,gt=l(),c(hs.$$.fragment),Mt=l(),gs=p("p"),gs.innerHTML=At,yt=l(),c(Ms.$$.fragment),jt=l(),f=p("div"),f.innerHTML=Dt,dt=l(),c(ys.$$.fragment),ut=l(),ds=p("p"),this.h()},l(s){const t=ae("svelte-u9bgzb",document.head);j=i(t,"META",{name:!0,content:!0}),t.forEach(e),bs=n(s),js=i(s,"P",{}),Pt(js).forEach(e),Js=n(s),r(T.$$.fragment,s),Us=n(s),r(C.$$.fragment,s),ws=n(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1g13my9"&&(W.innerHTML=Ut),xs=n(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1l6ldib"&&(v.innerHTML=wt),fs=n(s),I=i(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1r22rri"&&(I.innerHTML=xt),Ts=n(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-c41x80"&&(k.textContent=ft),Cs=n(s),$=i(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-leihjc"&&($.textContent=Tt),Ws=n(s),z=i(s,"UL",{"data-svelte-h":!0}),o(z)!=="svelte-v8ep8v"&&(z.innerHTML=Ct),vs=n(s),Z=i(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1c9nexd"&&(Z.textContent=Wt),Is=n(s),r(_.$$.fragment,s),ks=n(s),r(Q.$$.fragment,s),$s=n(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1mjp4gi"&&(R.innerHTML=vt),zs=n(s),r(V.$$.fragment,s),Zs=n(s),B=i(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-henpll"&&(B.innerHTML=It),_s=n(s),r(H.$$.fragment,s),Qs=n(s),u=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(u)!=="svelte-17qmfee"&&(u.innerHTML=kt),Rs=n(s),N=i(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-baa5my"&&(N.textContent=$t),Vs=n(s),r(q.$$.fragment,s),Bs=n(s),X=i(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-af5rkc"&&(X.textContent=zt),Hs=n(s),r(G.$$.fragment,s),Ns=n(s),b=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-1fwpqdn"&&(b.innerHTML=Zt),qs=n(s),r(Y.$$.fragment,s),Xs=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-xqdy1u"&&(E.textContent=_t),Gs=n(s),S=i(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-x1kygm"&&(S.innerHTML=Qt),Ys=n(s),r(F.$$.fragment,s),Es=n(s),L=i(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1g7c1zc"&&(L.textContent=Rt),Ss=n(s),r(A.$$.fragment,s),Fs=n(s),J=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-owux8y"&&(J.innerHTML=Vt),Ls=n(s),D=i(s,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1ctaqek"&&(D.innerHTML=Bt),As=n(s),r(P.$$.fragment,s),Ds=n(s),K=i(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-20mcdj"&&(K.innerHTML=Ht),Ps=n(s),r(O.$$.fragment,s),Ks=n(s),U=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-1m863ar"&&(U.innerHTML=Nt),Os=n(s),r(ss.$$.fragment,s),st=n(s),ts=i(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-16j89af"&&(ts.textContent=qt),tt=n(s),r(es.$$.fragment,s),et=n(s),as=i(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-1si811t"&&(as.innerHTML=Xt),at=n(s),r(ls.$$.fragment,s),lt=n(s),w=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1m863ar"&&(w.innerHTML=Gt),nt=n(s),r(ns.$$.fragment,s),pt=n(s),ps=i(s,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-c78gkh"&&(ps.textContent=Yt),it=n(s),is=i(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-1kqxako"&&(is.textContent=Et),ot=n(s),r(os.$$.fragment,s),ct=n(s),cs=i(s,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-1yw5ubp"&&(cs.textContent=St),rt=n(s),r(rs.$$.fragment,s),mt=n(s),x=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(x)!=="svelte-y78yu"&&(x.innerHTML=Ft),ht=n(s),ms=i(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-34zysh"&&(ms.innerHTML=Lt),gt=n(s),r(hs.$$.fragment,s),Mt=n(s),gs=i(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-1p976m9"&&(gs.innerHTML=At),yt=n(s),r(Ms.$$.fragment,s),jt=n(s),f=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-1f4dev0"&&(f.innerHTML=Dt),dt=n(s),r(ys.$$.fragment,s),ut=n(s),ds=i(s,"P",{}),Pt(ds).forEach(e),this.h()},h(){d(j,"name","hf:doc:metadata"),d(j,"content",oe),d(u,"class","flex justify-center"),d(b,"class","flex justify-center"),d(J,"class","flex justify-center"),d(U,"class","flex justify-center"),d(w,"class","flex justify-center"),d(x,"class","flex justify-center"),d(f,"class","flex justify-center")},m(s,t){le(document.head,j),a(s,bs,t),a(s,js,t),a(s,Js,t),m(T,s,t),a(s,Us,t),m(C,s,t),a(s,ws,t),a(s,W,t),a(s,xs,t),a(s,v,t),a(s,fs,t),a(s,I,t),a(s,Ts,t),a(s,k,t),a(s,Cs,t),a(s,$,t),a(s,Ws,t),a(s,z,t),a(s,vs,t),a(s,Z,t),a(s,Is,t),m(_,s,t),a(s,ks,t),m(Q,s,t),a(s,$s,t),a(s,R,t),a(s,zs,t),m(V,s,t),a(s,Zs,t),a(s,B,t),a(s,_s,t),m(H,s,t),a(s,Qs,t),a(s,u,t),a(s,Rs,t),a(s,N,t),a(s,Vs,t),m(q,s,t),a(s,Bs,t),a(s,X,t),a(s,Hs,t),m(G,s,t),a(s,Ns,t),a(s,b,t),a(s,qs,t),m(Y,s,t),a(s,Xs,t),a(s,E,t),a(s,Gs,t),a(s,S,t),a(s,Ys,t),m(F,s,t),a(s,Es,t),a(s,L,t),a(s,Ss,t),m(A,s,t),a(s,Fs,t),a(s,J,t),a(s,Ls,t),a(s,D,t),a(s,As,t),m(P,s,t),a(s,Ds,t),a(s,K,t),a(s,Ps,t),m(O,s,t),a(s,Ks,t),a(s,U,t),a(s,Os,t),m(ss,s,t),a(s,st,t),a(s,ts,t),a(s,tt,t),m(es,s,t),a(s,et,t),a(s,as,t),a(s,at,t),m(ls,s,t),a(s,lt,t),a(s,w,t),a(s,nt,t),m(ns,s,t),a(s,pt,t),a(s,ps,t),a(s,it,t),a(s,is,t),a(s,ot,t),m(os,s,t),a(s,ct,t),a(s,cs,t),a(s,rt,t),m(rs,s,t),a(s,mt,t),a(s,x,t),a(s,ht,t),a(s,ms,t),a(s,gt,t),m(hs,s,t),a(s,Mt,t),a(s,gs,t),a(s,yt,t),m(Ms,s,t),a(s,jt,t),a(s,f,t),a(s,dt,t),m(ys,s,t),a(s,ut,t),a(s,ds,t),bt=!0},p:Ot,i(s){bt||(h(T.$$.fragment,s),h(C.$$.fragment,s),h(_.$$.fragment,s),h(Q.$$.fragment,s),h(V.$$.fragment,s),h(H.$$.fragment,s),h(q.$$.fragment,s),h(G.$$.fragment,s),h(Y.$$.fragment,s),h(F.$$.fragment,s),h(A.$$.fragment,s),h(P.$$.fragment,s),h(O.$$.fragment,s),h(ss.$$.fragment,s),h(es.$$.fragment,s),h(ls.$$.fragment,s),h(ns.$$.fragment,s),h(os.$$.fragment,s),h(rs.$$.fragment,s),h(hs.$$.fragment,s),h(Ms.$$.fragment,s),h(ys.$$.fragment,s),bt=!0)},o(s){g(T.$$.fragment,s),g(C.$$.fragment,s),g(_.$$.fragment,s),g(Q.$$.fragment,s),g(V.$$.fragment,s),g(H.$$.fragment,s),g(q.$$.fragment,s),g(G.$$.fragment,s),g(Y.$$.fragment,s),g(F.$$.fragment,s),g(A.$$.fragment,s),g(P.$$.fragment,s),g(O.$$.fragment,s),g(ss.$$.fragment,s),g(es.$$.fragment,s),g(ls.$$.fragment,s),g(ns.$$.fragment,s),g(os.$$.fragment,s),g(rs.$$.fragment,s),g(hs.$$.fragment,s),g(Ms.$$.fragment,s),g(ys.$$.fragment,s),bt=!1},d(s){s&&(e(bs),e(js),e(Js),e(Us),e(ws),e(W),e(xs),e(v),e(fs),e(I),e(Ts),e(k),e(Cs),e($),e(Ws),e(z),e(vs),e(Z),e(Is),e(ks),e($s),e(R),e(zs),e(Zs),e(B),e(_s),e(Qs),e(u),e(Rs),e(N),e(Vs),e(Bs),e(X),e(Hs),e(Ns),e(b),e(qs),e(Xs),e(E),e(Gs),e(S),e(Ys),e(Es),e(L),e(Ss),e(Fs),e(J),e(Ls),e(D),e(As),e(Ds),e(K),e(Ps),e(Ks),e(U),e(Os),e(st),e(ts),e(tt),e(et),e(as),e(at),e(lt),e(w),e(nt),e(pt),e(ps),e(it),e(is),e(ot),e(ct),e(cs),e(rt),e(mt),e(x),e(ht),e(ms),e(gt),e(Mt),e(gs),e(yt),e(jt),e(f),e(dt),e(ut),e(ds)),e(j),M(T,s),M(C,s),M(_,s),M(Q,s),M(V,s),M(H,s),M(q,s),M(G,s),M(Y,s),M(F,s),M(A,s),M(P,s),M(O,s),M(ss,s),M(es,s),M(ls,s),M(ns,s),M(os,s),M(rs,s),M(hs,s),M(Ms,s),M(ys,s)}}}const oe='{"title":"Zero-shot object detection","local":"zero-shot-object-detection","sections":[{"title":"Zero-shot object detection pipeline","local":"zero-shot-object-detection-pipeline","sections":[],"depth":2},{"title":"Text-prompted zero-shot object detection by hand","local":"text-prompted-zero-shot-object-detection-by-hand","sections":[],"depth":2},{"title":"Batch processing","local":"batch-processing","sections":[],"depth":2},{"title":"Image-guided object detection","local":"image-guided-object-detection","sections":[],"depth":2}],"depth":1}';function ce(Jt){return se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ye extends te{constructor(j){super(),ee(this,j,ce,ie,Kt,{})}}export{ye as component};
