import{s as Mt,f as xt,o as jt,n as Te}from"../chunks/scheduler.25b97de1.js";import{S as Jt,i as $t,g as d,s as r,r as u,A as kt,h as m,f as o,c as l,j as ae,u as g,x as h,k as F,y as f,a,v as b,d as _,t as T,w as y}from"../chunks/index.d9030fc9.js";import{T as vt}from"../chunks/Tip.baa67368.js";import{D as _e}from"../chunks/Docstring.e257edda.js";import{C as nt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as ot}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{P as Ct}from"../chunks/PipelineTag.5f100392.js";import{H as ge,E as Ut}from"../chunks/EditOnGithub.91d95064.js";function It(k){let n,w="Examples:",i,c,p;return c=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhYmxlVHJhbnNmb3JtZXJNb2RlbCUyQyUyMFRhYmxlVHJhbnNmb3JtZXJDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwVGFibGUlMjBUcmFuc2Zvcm1lciUyMG1pY3Jvc29mdCUyRnRhYmxlLXRyYW5zZm9ybWVyLWRldGVjdGlvbiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBUYWJsZVRyYW5zZm9ybWVyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwbWljcm9zb2Z0JTJGdGFibGUtdHJhbnNmb3JtZXItZGV0ZWN0aW9uJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBUYWJsZVRyYW5zZm9ybWVyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TableTransformerModel, TableTransformerConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Table Transformer microsoft/table-transformer-detection style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = TableTransformerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the microsoft/table-transformer-detection style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TableTransformerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=d("p"),n.textContent=w,i=r(),u(c.$$.fragment)},l(s){n=m(s,"P",{"data-svelte-h":!0}),h(n)!=="svelte-kvfsh7"&&(n.textContent=w),i=l(s),g(c.$$.fragment,s)},m(s,v){a(s,n,v),a(s,i,v),b(c,s,v),p=!0},p:Te,i(s){p||(_(c.$$.fragment,s),p=!0)},o(s){T(c.$$.fragment,s),p=!1},d(s){s&&(o(n),o(i)),y(c,s)}}}function Wt(k){let n,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=w},l(i){n=m(i,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=w)},m(i,c){a(i,n,c)},p:Te,d(i){i&&o(n)}}}function Zt(k){let n,w="Examples:",i,c,p;return c=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRhYmxlVHJhbnNmb3JtZXJNb2RlbCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBoZl9odWJfZG93bmxvYWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmaWxlX3BhdGglMjAlM0QlMjBoZl9odWJfZG93bmxvYWQocmVwb19pZCUzRCUyMm5pZWxzciUyRmV4YW1wbGUtcGRmJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyZXhhbXBsZV9wZGYucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlX3BhdGgpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGdGFibGUtdHJhbnNmb3JtZXItZGV0ZWN0aW9uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVGFibGVUcmFuc2Zvcm1lck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZ0YWJsZS10cmFuc2Zvcm1lci1kZXRlY3Rpb24lMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMHRoZSUyMGxhc3QlMjBoaWRkZW4lMjBzdGF0ZXMlMjBhcmUlMjB0aGUlMjBmaW5hbCUyMHF1ZXJ5JTIwZW1iZWRkaW5ncyUyMG9mJTIwdGhlJTIwVHJhbnNmb3JtZXIlMjBkZWNvZGVyJTBBJTIzJTIwdGhlc2UlMjBhcmUlMjBvZiUyMHNoYXBlJTIwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhpZGRlbl9zaXplKSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TableTransformerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;nielsr/example-pdf&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, filename=<span class="hljs-string">&quot;example_pdf.png&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(file_path).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/table-transformer-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TableTransformerModel.from_pretrained(<span class="hljs-string">&quot;microsoft/table-transformer-detection&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the last hidden states are the final query embeddings of the Transformer decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># these are of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">15</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){n=d("p"),n.textContent=w,i=r(),u(c.$$.fragment)},l(s){n=m(s,"P",{"data-svelte-h":!0}),h(n)!=="svelte-kvfsh7"&&(n.textContent=w),i=l(s),g(c.$$.fragment,s)},m(s,v){a(s,n,v),a(s,i,v),b(c,s,v),p=!0},p:Te,i(s){p||(_(c.$$.fragment,s),p=!0)},o(s){T(c.$$.fragment,s),p=!1},d(s){s&&(o(n),o(i)),y(c,s)}}}function Ft(k){let n,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=w},l(i){n=m(i,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=w)},m(i,c){a(i,n,c)},p:Te,d(i){i&&o(n)}}}function Gt(k){let n,w="Examples:",i,c,p;return c=new nt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TableTransformerForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;nielsr/example-pdf&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, filename=<span class="hljs-string">&quot;example_pdf.png&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(file_path).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/table-transformer-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TableTransformerForObjectDetection.from_pretrained(<span class="hljs-string">&quot;microsoft/table-transformer-detection&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected table <span class="hljs-keyword">with</span> confidence <span class="hljs-number">1.0</span> at location [<span class="hljs-number">202.1</span>, <span class="hljs-number">210.59</span>, <span class="hljs-number">1119.22</span>, <span class="hljs-number">385.09</span>]`,wrap:!1}}),{c(){n=d("p"),n.textContent=w,i=r(),u(c.$$.fragment)},l(s){n=m(s,"P",{"data-svelte-h":!0}),h(n)!=="svelte-kvfsh7"&&(n.textContent=w),i=l(s),g(c.$$.fragment,s)},m(s,v){a(s,n,v),a(s,i,v),b(c,s,v),p=!0},p:Te,i(s){p||(_(c.$$.fragment,s),p=!0)},o(s){T(c.$$.fragment,s),p=!1},d(s){s&&(o(n),o(i)),y(c,s)}}}function zt(k){let n,w,i,c,p,s,v,ye,V,st=`The Table Transformer model was proposed in <a href="https://arxiv.org/abs/2110.00061" rel="nofollow">PubTables-1M: Towards comprehensive table extraction from unstructured documents</a> by
Brandon Smock, Rohith Pesala, Robin Abraham. The authors introduce a new dataset, PubTables-1M, to benchmark progress in table extraction from unstructured documents,
as well as table structure recognition and functional analysis. The authors train 2 <a href="detr">DETR</a> models, one for table detection and one for table structure recognition, dubbed Table Transformers.`,we,X,at="The abstract from the paper is the following:",ve,H,rt=`<em>Recently, significant progress has been made applying machine learning to the problem of table structure inference and extraction from unstructured documents.
However, one of the greatest challenges remains the creation of datasets with complete, unambiguous ground truth at scale. To address this, we develop a new, more
comprehensive dataset for table extraction, called PubTables-1M. PubTables-1M contains nearly one million tables from scientific articles, supports multiple input
modalities, and contains detailed header and location information for table structures, making it useful for a wide variety of modeling approaches. It also addresses a significant
source of ground truth inconsistency observed in prior datasets called oversegmentation, using a novel canonicalization procedure. We demonstrate that these improvements lead to a
significant increase in training performance and a more reliable estimate of model performance at evaluation for table structure recognition. Further, we show that transformer-based
object detection models trained on PubTables-1M produce excellent results for all three tasks of detection, structure recognition, and functional analysis without the need for any
special customization for these tasks.</em>`,Me,G,lt,xe,E,it='Table detection and table structure recognition clarified. Taken from the <a href="https://arxiv.org/abs/2110.00061">original paper</a>.',je,P,ct=`The authors released 2 models, one for <a href="https://huggingface.co/microsoft/table-transformer-detection" rel="nofollow">table detection</a> in
documents, one for <a href="https://huggingface.co/microsoft/table-transformer-structure-recognition" rel="nofollow">table structure recognition</a>
(the task of recognizing the individual rows, columns etc. in a table).`,Je,D,dt=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be
found <a href="https://github.com/microsoft/table-transformer" rel="nofollow">here</a>.`,$e,Q,ke,O,Ce,Y,mt='<li>A demo notebook for the Table Transformer can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Table%20Transformer" rel="nofollow">here</a>.</li> <li>It turns out padding of images is quite important for detection. An interesting Github thread with replies from the authors can be found <a href="https://github.com/microsoft/table-transformer/issues/68" rel="nofollow">here</a>.</li>',Ue,L,Ie,j,S,Be,re,ft=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_31197/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a>. It is used to
instantiate a Table Transformer model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the Table Transformer
<a href="https://huggingface.co/microsoft/table-transformer-detection" rel="nofollow">microsoft/table-transformer-detection</a> architecture.`,Re,le,pt=`Configuration objects inherit from <a href="/docs/transformers/pr_31197/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31197/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ve,z,We,A,Ze,M,K,Xe,ie,ht=`The bare Table Transformer Model (consisting of a backbone and encoder-decoder Transformer) outputting raw
hidden-states without any specific head on top.`,He,ce,ut=`This model inherits from <a href="/docs/transformers/pr_31197/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ee,de,gt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Pe,C,ee,De,me,bt='The <a href="/docs/transformers/pr_31197/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a> forward method, overrides the <code>__call__</code> special method.',Qe,N,Oe,q,Fe,te,Ge,x,oe,Ye,fe,_t=`Table Transformer Model (consisting of a backbone and encoder-decoder Transformer) with object detection heads on
top, for tasks such as COCO detection.`,Le,pe,Tt=`This model inherits from <a href="/docs/transformers/pr_31197/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Se,he,yt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ae,U,ne,Ke,ue,wt='The <a href="/docs/transformers/pr_31197/en/model_doc/table-transformer#transformers.TableTransformerForObjectDetection">TableTransformerForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',et,B,tt,R,ze,se,Ne,be,qe;return p=new ge({props:{title:"Table Transformer",local:"table-transformer",headingTag:"h1"}}),v=new ge({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Q=new ge({props:{title:"Resources",local:"resources",headingTag:"h2"}}),O=new Ct({props:{pipeline:"object-detection"}}),L=new ge({props:{title:"TableTransformerConfig",local:"transformers.TableTransformerConfig",headingTag:"h2"}}),S=new _e({props:{name:"class transformers.TableTransformerConfig",anchor:"transformers.TableTransformerConfig",parameters:[{name:"use_timm_backbone",val:" = True"},{name:"backbone_config",val:" = None"},{name:"num_channels",val:" = 3"},{name:"num_queries",val:" = 100"},{name:"encoder_layers",val:" = 6"},{name:"encoder_ffn_dim",val:" = 2048"},{name:"encoder_attention_heads",val:" = 8"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 8"},{name:"encoder_layerdrop",val:" = 0.0"},{name:"decoder_layerdrop",val:" = 0.0"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"init_xavier_std",val:" = 1.0"},{name:"auxiliary_loss",val:" = False"},{name:"position_embedding_type",val:" = 'sine'"},{name:"backbone",val:" = 'resnet50'"},{name:"use_pretrained_backbone",val:" = True"},{name:"backbone_kwargs",val:" = None"},{name:"dilation",val:" = False"},{name:"class_cost",val:" = 1"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"mask_loss_coefficient",val:" = 1"},{name:"dice_loss_coefficient",val:" = 1"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"eos_coefficient",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TableTransformerConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <a href="/docs/transformers/pr_31197/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a>
API.`,name:"use_timm_backbone"},{anchor:"transformers.TableTransformerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>use_timm_backbone</code> is set to <code>False</code> in which
case it will default to <code>ResNetConfig()</code>.`,name:"backbone_config"},{anchor:"transformers.TableTransformerConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.TableTransformerConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of object queries, i.e. detection slots. This is the maximal number of objects
<a href="/docs/transformers/pr_31197/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a> can detect in a single image. For COCO, we recommend 100 queries.`,name:"num_queries"},{anchor:"transformers.TableTransformerConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the layers.`,name:"d_model"},{anchor:"transformers.TableTransformerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.TableTransformerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.TableTransformerConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.TableTransformerConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.TableTransformerConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.TableTransformerConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.TableTransformerConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.TableTransformerConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.TableTransformerConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.TableTransformerConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.TableTransformerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.TableTransformerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.TableTransformerConfig.encoder_layerdrop",description:`<strong>encoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the encoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"encoder_layerdrop"},{anchor:"transformers.TableTransformerConfig.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.TableTransformerConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.TableTransformerConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sine&quot;</code>) &#x2014;
Type of position embeddings to be used on top of the image features. One of <code>&quot;sine&quot;</code> or <code>&quot;learned&quot;</code>.`,name:"position_embedding_type"},{anchor:"transformers.TableTransformerConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.TableTransformerConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, <code>True</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.TableTransformerConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.TableTransformerConfig.dilation",description:`<strong>dilation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to replace stride with dilation in the last convolutional block (DC5). Only supported when
<code>use_timm_backbone</code> = <code>True</code>.`,name:"dilation"},{anchor:"transformers.TableTransformerConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.TableTransformerConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.TableTransformerConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.TableTransformerConfig.mask_loss_coefficient",description:`<strong>mask_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the Focal loss in the panoptic segmentation loss.`,name:"mask_loss_coefficient"},{anchor:"transformers.TableTransformerConfig.dice_loss_coefficient",description:`<strong>dice_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the DICE/F-1 loss in the panoptic segmentation loss.`,name:"dice_loss_coefficient"},{anchor:"transformers.TableTransformerConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.TableTransformerConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.TableTransformerConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"}],source:"https://github.com/huggingface/transformers/blob/vr_31197/src/transformers/models/table_transformer/configuration_table_transformer.py#L32"}}),z=new ot({props:{anchor:"transformers.TableTransformerConfig.example",$$slots:{default:[It]},$$scope:{ctx:k}}}),A=new ge({props:{title:"TableTransformerModel",local:"transformers.TableTransformerModel",headingTag:"h2"}}),K=new _e({props:{name:"class transformers.TableTransformerModel",anchor:"transformers.TableTransformerModel",parameters:[{name:"config",val:": TableTransformerConfig"}],parametersDescription:[{anchor:"transformers.TableTransformerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31197/en/model_doc/table-transformer#transformers.TableTransformerConfig">TableTransformerConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_31197/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31197/src/transformers/models/table_transformer/modeling_table_transformer.py#L1120"}}),ee=new _e({props:{name:"forward",anchor:"transformers.TableTransformerModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.TableTransformerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/pr_31197/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a>. See <a href="/docs/transformers/pr_31197/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TableTransformerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.TableTransformerModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.TableTransformerModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.TableTransformerModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.TableTransformerModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.TableTransformerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TableTransformerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TableTransformerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31197/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31197/src/transformers/models/table_transformer/modeling_table_transformer.py#L1162",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.table_transformer.modeling_table_transformer.TableTransformerModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31197/en/model_doc/table-transformer#transformers.TableTransformerConfig"
>TableTransformerConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(config.decoder_layers, batch_size, sequence_length, hidden_size)</code>, <em>optional</em>, returned when <code>config.auxiliary_loss=True</code>) — Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.table_transformer.modeling_table_transformer.TableTransformerModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),N=new vt({props:{$$slots:{default:[Wt]},$$scope:{ctx:k}}}),q=new ot({props:{anchor:"transformers.TableTransformerModel.forward.example",$$slots:{default:[Zt]},$$scope:{ctx:k}}}),te=new ge({props:{title:"TableTransformerForObjectDetection",local:"transformers.TableTransformerForObjectDetection",headingTag:"h2"}}),oe=new _e({props:{name:"class transformers.TableTransformerForObjectDetection",anchor:"transformers.TableTransformerForObjectDetection",parameters:[{name:"config",val:": TableTransformerConfig"}],parametersDescription:[{anchor:"transformers.TableTransformerForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31197/en/model_doc/table-transformer#transformers.TableTransformerConfig">TableTransformerConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_31197/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31197/src/transformers/models/table_transformer/modeling_table_transformer.py#L1289"}}),ne=new _e({props:{name:"forward",anchor:"transformers.TableTransformerForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.TableTransformerForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/pr_31197/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a>. See <a href="/docs/transformers/pr_31197/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TableTransformerForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.TableTransformerForObjectDetection.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.TableTransformerForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.TableTransformerForObjectDetection.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.TableTransformerForObjectDetection.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.TableTransformerForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TableTransformerForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TableTransformerForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31197/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TableTransformerForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_31197/src/transformers/models/table_transformer/modeling_table_transformer.py#L1323",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.table_transformer.modeling_table_transformer.TableTransformerObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31197/en/model_doc/table-transformer#transformers.TableTransformerConfig"
>TableTransformerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <code>~TableTransformerImageProcessor.post_process_object_detection</code> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.table_transformer.modeling_table_transformer.TableTransformerObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new vt({props:{$$slots:{default:[Ft]},$$scope:{ctx:k}}}),R=new ot({props:{anchor:"transformers.TableTransformerForObjectDetection.forward.example",$$slots:{default:[Gt]},$$scope:{ctx:k}}}),se=new Ut({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/table-transformer.md"}}),{c(){n=d("meta"),w=r(),i=d("p"),c=r(),u(p.$$.fragment),s=r(),u(v.$$.fragment),ye=r(),V=d("p"),V.innerHTML=st,we=r(),X=d("p"),X.textContent=at,ve=r(),H=d("p"),H.innerHTML=rt,Me=r(),G=d("img"),xe=r(),E=d("small"),E.innerHTML=it,je=r(),P=d("p"),P.innerHTML=ct,Je=r(),D=d("p"),D.innerHTML=dt,$e=r(),u(Q.$$.fragment),ke=r(),u(O.$$.fragment),Ce=r(),Y=d("ul"),Y.innerHTML=mt,Ue=r(),u(L.$$.fragment),Ie=r(),j=d("div"),u(S.$$.fragment),Be=r(),re=d("p"),re.innerHTML=ft,Re=r(),le=d("p"),le.innerHTML=pt,Ve=r(),u(z.$$.fragment),We=r(),u(A.$$.fragment),Ze=r(),M=d("div"),u(K.$$.fragment),Xe=r(),ie=d("p"),ie.textContent=ht,He=r(),ce=d("p"),ce.innerHTML=ut,Ee=r(),de=d("p"),de.innerHTML=gt,Pe=r(),C=d("div"),u(ee.$$.fragment),De=r(),me=d("p"),me.innerHTML=bt,Qe=r(),u(N.$$.fragment),Oe=r(),u(q.$$.fragment),Fe=r(),u(te.$$.fragment),Ge=r(),x=d("div"),u(oe.$$.fragment),Ye=r(),fe=d("p"),fe.textContent=_t,Le=r(),pe=d("p"),pe.innerHTML=Tt,Se=r(),he=d("p"),he.innerHTML=yt,Ae=r(),U=d("div"),u(ne.$$.fragment),Ke=r(),ue=d("p"),ue.innerHTML=wt,et=r(),u(B.$$.fragment),tt=r(),u(R.$$.fragment),ze=r(),u(se.$$.fragment),Ne=r(),be=d("p"),this.h()},l(e){const t=kt("svelte-u9bgzb",document.head);n=m(t,"META",{name:!0,content:!0}),t.forEach(o),w=l(e),i=m(e,"P",{}),ae(i).forEach(o),c=l(e),g(p.$$.fragment,e),s=l(e),g(v.$$.fragment,e),ye=l(e),V=m(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-1eh4n85"&&(V.innerHTML=st),we=l(e),X=m(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-vfdo9a"&&(X.textContent=at),ve=l(e),H=m(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-15fvuyo"&&(H.innerHTML=rt),Me=l(e),G=m(e,"IMG",{src:!0,alt:!0,width:!0}),xe=l(e),E=m(e,"SMALL",{"data-svelte-h":!0}),h(E)!=="svelte-xusvwd"&&(E.innerHTML=it),je=l(e),P=m(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-1rds34j"&&(P.innerHTML=ct),Je=l(e),D=m(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-ynmngv"&&(D.innerHTML=dt),$e=l(e),g(Q.$$.fragment,e),ke=l(e),g(O.$$.fragment,e),Ce=l(e),Y=m(e,"UL",{"data-svelte-h":!0}),h(Y)!=="svelte-4dtp4u"&&(Y.innerHTML=mt),Ue=l(e),g(L.$$.fragment,e),Ie=l(e),j=m(e,"DIV",{class:!0});var I=ae(j);g(S.$$.fragment,I),Be=l(I),re=m(I,"P",{"data-svelte-h":!0}),h(re)!=="svelte-1fx4lbc"&&(re.innerHTML=ft),Re=l(I),le=m(I,"P",{"data-svelte-h":!0}),h(le)!=="svelte-md2p13"&&(le.innerHTML=pt),Ve=l(I),g(z.$$.fragment,I),I.forEach(o),We=l(e),g(A.$$.fragment,e),Ze=l(e),M=m(e,"DIV",{class:!0});var J=ae(M);g(K.$$.fragment,J),Xe=l(J),ie=m(J,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-q3yild"&&(ie.textContent=ht),He=l(J),ce=m(J,"P",{"data-svelte-h":!0}),h(ce)!=="svelte-141rmkj"&&(ce.innerHTML=ut),Ee=l(J),de=m(J,"P",{"data-svelte-h":!0}),h(de)!=="svelte-hswkmf"&&(de.innerHTML=gt),Pe=l(J),C=m(J,"DIV",{class:!0});var W=ae(C);g(ee.$$.fragment,W),De=l(W),me=m(W,"P",{"data-svelte-h":!0}),h(me)!=="svelte-1f7ogk0"&&(me.innerHTML=bt),Qe=l(W),g(N.$$.fragment,W),Oe=l(W),g(q.$$.fragment,W),W.forEach(o),J.forEach(o),Fe=l(e),g(te.$$.fragment,e),Ge=l(e),x=m(e,"DIV",{class:!0});var $=ae(x);g(oe.$$.fragment,$),Ye=l($),fe=m($,"P",{"data-svelte-h":!0}),h(fe)!=="svelte-14j6uvi"&&(fe.textContent=_t),Le=l($),pe=m($,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-141rmkj"&&(pe.innerHTML=Tt),Se=l($),he=m($,"P",{"data-svelte-h":!0}),h(he)!=="svelte-hswkmf"&&(he.innerHTML=yt),Ae=l($),U=m($,"DIV",{class:!0});var Z=ae(U);g(ne.$$.fragment,Z),Ke=l(Z),ue=m(Z,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-13cy2h0"&&(ue.innerHTML=wt),et=l(Z),g(B.$$.fragment,Z),tt=l(Z),g(R.$$.fragment,Z),Z.forEach(o),$.forEach(o),ze=l(e),g(se.$$.fragment,e),Ne=l(e),be=m(e,"P",{}),ae(be).forEach(o),this.h()},h(){F(n,"name","hf:doc:metadata"),F(n,"content",Nt),xt(G.src,lt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/table_transformer_architecture.jpeg")||F(G,"src",lt),F(G,"alt","drawing"),F(G,"width","600"),F(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){f(document.head,n),a(e,w,t),a(e,i,t),a(e,c,t),b(p,e,t),a(e,s,t),b(v,e,t),a(e,ye,t),a(e,V,t),a(e,we,t),a(e,X,t),a(e,ve,t),a(e,H,t),a(e,Me,t),a(e,G,t),a(e,xe,t),a(e,E,t),a(e,je,t),a(e,P,t),a(e,Je,t),a(e,D,t),a(e,$e,t),b(Q,e,t),a(e,ke,t),b(O,e,t),a(e,Ce,t),a(e,Y,t),a(e,Ue,t),b(L,e,t),a(e,Ie,t),a(e,j,t),b(S,j,null),f(j,Be),f(j,re),f(j,Re),f(j,le),f(j,Ve),b(z,j,null),a(e,We,t),b(A,e,t),a(e,Ze,t),a(e,M,t),b(K,M,null),f(M,Xe),f(M,ie),f(M,He),f(M,ce),f(M,Ee),f(M,de),f(M,Pe),f(M,C),b(ee,C,null),f(C,De),f(C,me),f(C,Qe),b(N,C,null),f(C,Oe),b(q,C,null),a(e,Fe,t),b(te,e,t),a(e,Ge,t),a(e,x,t),b(oe,x,null),f(x,Ye),f(x,fe),f(x,Le),f(x,pe),f(x,Se),f(x,he),f(x,Ae),f(x,U),b(ne,U,null),f(U,Ke),f(U,ue),f(U,et),b(B,U,null),f(U,tt),b(R,U,null),a(e,ze,t),b(se,e,t),a(e,Ne,t),a(e,be,t),qe=!0},p(e,[t]){const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),z.$set(I);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),N.$set(J);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),q.$set(W);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),B.$set($);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),R.$set(Z)},i(e){qe||(_(p.$$.fragment,e),_(v.$$.fragment,e),_(Q.$$.fragment,e),_(O.$$.fragment,e),_(L.$$.fragment,e),_(S.$$.fragment,e),_(z.$$.fragment,e),_(A.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(N.$$.fragment,e),_(q.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(B.$$.fragment,e),_(R.$$.fragment,e),_(se.$$.fragment,e),qe=!0)},o(e){T(p.$$.fragment,e),T(v.$$.fragment,e),T(Q.$$.fragment,e),T(O.$$.fragment,e),T(L.$$.fragment,e),T(S.$$.fragment,e),T(z.$$.fragment,e),T(A.$$.fragment,e),T(K.$$.fragment,e),T(ee.$$.fragment,e),T(N.$$.fragment,e),T(q.$$.fragment,e),T(te.$$.fragment,e),T(oe.$$.fragment,e),T(ne.$$.fragment,e),T(B.$$.fragment,e),T(R.$$.fragment,e),T(se.$$.fragment,e),qe=!1},d(e){e&&(o(w),o(i),o(c),o(s),o(ye),o(V),o(we),o(X),o(ve),o(H),o(Me),o(G),o(xe),o(E),o(je),o(P),o(Je),o(D),o($e),o(ke),o(Ce),o(Y),o(Ue),o(Ie),o(j),o(We),o(Ze),o(M),o(Fe),o(Ge),o(x),o(ze),o(Ne),o(be)),o(n),y(p,e),y(v,e),y(Q,e),y(O,e),y(L,e),y(S),y(z),y(A,e),y(K),y(ee),y(N),y(q),y(te,e),y(oe),y(ne),y(B),y(R),y(se,e)}}}const Nt='{"title":"Table Transformer","local":"table-transformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"TableTransformerConfig","local":"transformers.TableTransformerConfig","sections":[],"depth":2},{"title":"TableTransformerModel","local":"transformers.TableTransformerModel","sections":[],"depth":2},{"title":"TableTransformerForObjectDetection","local":"transformers.TableTransformerForObjectDetection","sections":[],"depth":2}],"depth":1}';function qt(k){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends Jt{constructor(n){super(),$t(this,n,qt,zt,Mt,{})}}export{Qt as component};
