import{s as so,o as ao,n as J}from"../chunks/scheduler.25b97de1.js";import{S as ro,i as lo,g as p,s as l,r as u,A as io,h as m,f as s,c as i,j as v,u as h,x as T,k as x,y as c,a as d,v as _,d as M,t as b,w as C}from"../chunks/index.d9030fc9.js";import{T as ut}from"../chunks/Tip.baa67368.js";import{D as P}from"../chunks/Docstring.e257edda.js";import{C as S}from"../chunks/CodeBlock.e6cd0d95.js";import{E as ge}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as ht,E as co}from"../chunks/EditOnGithub.91d95064.js";function po(I){let n,g='This model is based on <code>CLIPModel</code>, use it like you would use the original <a href="clip">CLIP</a>.';return{c(){n=p("p"),n.innerHTML=g},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-r1r37q"&&(n.innerHTML=g)},m(a,r){d(a,n,r)},p:J,d(a){a&&s(n)}}}function mo(I){let n,g="Example:",a,r,f;return r=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFsdENMSVBDb25maWclMkMlMjBBbHRDTElQTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQWx0Q0xJUENvbmZpZyUyMHdpdGglMjBCQUFJJTJGQWx0Q0xJUCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBBbHRDTElQQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQWx0Q0xJUE1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBCQUFJJTJGQWx0Q0xJUCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQWx0Q0xJUE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZyUwQSUwQSUyMyUyMFdlJTIwY2FuJTIwYWxzbyUyMGluaXRpYWxpemUlMjBhJTIwQWx0Q0xJUENvbmZpZyUyMGZyb20lMjBhJTIwQWx0Q0xJUFRleHRDb25maWclMjBhbmQlMjBhJTIwQWx0Q0xJUFZpc2lvbkNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBBbHRDTElQVGV4dCUyMGFuZCUyMEFsdENMSVBWaXNpb24lMjBjb25maWd1cmF0aW9uJTBBY29uZmlnX3RleHQlMjAlM0QlMjBBbHRDTElQVGV4dENvbmZpZygpJTBBY29uZmlnX3Zpc2lvbiUyMCUzRCUyMEFsdENMSVBWaXNpb25Db25maWcoKSUwQSUwQWNvbmZpZyUyMCUzRCUyMEFsdENMSVBDb25maWcuZnJvbV90ZXh0X3Zpc2lvbl9jb25maWdzKGNvbmZpZ190ZXh0JTJDJTIwY29uZmlnX3Zpc2lvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AltCLIPConfig, AltCLIPModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPConfig with BAAI/AltCLIP style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = AltCLIPConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPModel (with random weights) from the BAAI/AltCLIP style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also initialize a AltCLIPConfig from a AltCLIPTextConfig and a AltCLIPVisionConfig</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPText and AltCLIPVision configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text = AltCLIPTextConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>config_vision = AltCLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>config = AltCLIPConfig.from_text_vision_configs(config_text, config_vision)`,wrap:!1}}),{c(){n=p("p"),n.textContent=g,a=l(),u(r.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=g),a=i(t),h(r.$$.fragment,t)},m(t,y){d(t,n,y),d(t,a,y),_(r,t,y),f=!0},p:J,i(t){f||(M(r.$$.fragment,t),f=!0)},o(t){b(r.$$.fragment,t),f=!1},d(t){t&&(s(n),s(a)),C(r,t)}}}function fo(I){let n,g="Examples:",a,r,f;return r=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFsdENMSVBUZXh0TW9kZWwlMkMlMjBBbHRDTElQVGV4dENvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBBbHRDTElQVGV4dENvbmZpZyUyMHdpdGglMjBCQUFJJTJGQWx0Q0xJUCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBBbHRDTElQVGV4dENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEFsdENMSVBUZXh0TW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMEJBQUklMkZBbHRDTElQJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBBbHRDTElQVGV4dE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AltCLIPTextModel, AltCLIPTextConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPTextConfig with BAAI/AltCLIP style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = AltCLIPTextConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPTextModel (with random weights) from the BAAI/AltCLIP style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPTextModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=p("p"),n.textContent=g,a=l(),u(r.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=g),a=i(t),h(r.$$.fragment,t)},m(t,y){d(t,n,y),d(t,a,y),_(r,t,y),f=!0},p:J,i(t){f||(M(r.$$.fragment,t),f=!0)},o(t){b(r.$$.fragment,t),f=!1},d(t){t&&(s(n),s(a)),C(r,t)}}}function go(I){let n,g="Example:",a,r,f;return r=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFsdENMSVBWaXNpb25Db25maWclMkMlMjBBbHRDTElQVmlzaW9uTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQWx0Q0xJUFZpc2lvbkNvbmZpZyUyMHdpdGglMjBCQUFJJTJGQWx0Q0xJUCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBBbHRDTElQVmlzaW9uQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQWx0Q0xJUFZpc2lvbk1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBCQUFJJTJGQWx0Q0xJUCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQWx0Q0xJUFZpc2lvbk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AltCLIPVisionConfig, AltCLIPVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPVisionConfig with BAAI/AltCLIP style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = AltCLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a AltCLIPVisionModel (with random weights) from the BAAI/AltCLIP style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPVisionModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=p("p"),n.textContent=g,a=l(),u(r.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=g),a=i(t),h(r.$$.fragment,t)},m(t,y){d(t,n,y),d(t,a,y),_(r,t,y),f=!0},p:J,i(t){f||(M(r.$$.fragment,t),f=!0)},o(t){b(r.$$.fragment,t),f=!1},d(t){t&&(s(n),s(a)),C(r,t)}}}function uo(I){let n,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=g},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=g)},m(a,r){d(a,n,r)},p:J,d(a){a&&s(n)}}}function ho(I){let n,g="Examples:",a,r,f;return r=new S({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEFsdENMSVBNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQWx0Q0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMkMlMjBpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUwQSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzX3Blcl9pbWFnZSUyMCUzRCUyMG91dHB1dHMubG9naXRzX3Blcl9pbWFnZSUyMCUyMCUyMyUyMHRoaXMlMjBpcyUyMHRoZSUyMGltYWdlLXRleHQlMjBzaW1pbGFyaXR5JTIwc2NvcmUlMEFwcm9icyUyMCUzRCUyMGxvZ2l0c19wZXJfaW1hZ2Uuc29mdG1heChkaW0lM0QxKSUyMCUyMCUyMyUyMHdlJTIwY2FuJTIwdGFrZSUyMHRoZSUyMHNvZnRtYXglMjB0byUyMGdldCUyMHRoZSUyMGxhYmVsJTIwcHJvYmFiaWxpdGllcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AltCLIPModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPModel.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){n=p("p"),n.textContent=g,a=l(),u(r.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=g),a=i(t),h(r.$$.fragment,t)},m(t,y){d(t,n,y),d(t,a,y),_(r,t,y),f=!0},p:J,i(t){f||(M(r.$$.fragment,t),f=!0)},o(t){b(r.$$.fragment,t),f=!1},d(t){t&&(s(n),s(a)),C(r,t)}}}function _o(I){let n,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=g},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=g)},m(a,r){d(a,n,r)},p:J,d(a){a&&s(n)}}}function Mo(I){let n,g="Examples:",a,r,f;return r=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBbHRDTElQTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMEFsdENMSVBNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRkFsdENMSVAlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRkFsdENMSVAlMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0QlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBdGV4dF9mZWF0dXJlcyUyMCUzRCUyMG1vZGVsLmdldF90ZXh0X2ZlYXR1cmVzKCoqaW5wdXRzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AltCLIPModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPModel.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_features = model.get_text_features(**inputs)`,wrap:!1}}),{c(){n=p("p"),n.textContent=g,a=l(),u(r.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=g),a=i(t),h(r.$$.fragment,t)},m(t,y){d(t,n,y),d(t,a,y),_(r,t,y),f=!0},p:J,i(t){f||(M(r.$$.fragment,t),f=!0)},o(t){b(r.$$.fragment,t),f=!1},d(t){t&&(s(n),s(a)),C(r,t)}}}function bo(I){let n,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=g},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=g)},m(a,r){d(a,n,r)},p:J,d(a){a&&s(n)}}}function Co(I){let n,g="Examples:",a,r,f;return r=new S({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEFsdENMSVBNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQWx0Q0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFpbWFnZV9mZWF0dXJlcyUyMCUzRCUyMG1vZGVsLmdldF9pbWFnZV9mZWF0dXJlcygqKmlucHV0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AltCLIPModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPModel.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_features = model.get_image_features(**inputs)`,wrap:!1}}),{c(){n=p("p"),n.textContent=g,a=l(),u(r.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=g),a=i(t),h(r.$$.fragment,t)},m(t,y){d(t,n,y),d(t,a,y),_(r,t,y),f=!0},p:J,i(t){f||(M(r.$$.fragment,t),f=!0)},o(t){b(r.$$.fragment,t),f=!1},d(t){t&&(s(n),s(a)),C(r,t)}}}function To(I){let n,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=g},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=g)},m(a,r){d(a,n,r)},p:J,d(a){a&&s(n)}}}function yo(I){let n,g="Examples:",a,r,f;return r=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBbHRDTElQVGV4dE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBBbHRDTElQVGV4dE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEElMEF0ZXh0cyUyMCUzRCUyMCU1QiUyMml0J3MlMjBhJTIwY2F0JTIyJTJDJTIwJTIyaXQncyUyMGElMjBkb2clMjIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRzJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsYXN0X2hpZGRlbl9zdGF0ZSUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFwb29sZWRfb3V0cHV0JTIwJTNEJTIwb3V0cHV0cy5wb29sZXJfb3V0cHV0JTIwJTIwJTIzJTIwcG9vbGVkJTIwQ0xTJTIwc3RhdGVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AltCLIPTextModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPTextModel.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>texts = [<span class="hljs-string">&quot;it&#x27;s a cat&quot;</span>, <span class="hljs-string">&quot;it&#x27;s a dog&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=texts, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled CLS states</span>`,wrap:!1}}),{c(){n=p("p"),n.textContent=g,a=l(),u(r.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=g),a=i(t),h(r.$$.fragment,t)},m(t,y){d(t,n,y),d(t,a,y),_(r,t,y),f=!0},p:J,i(t){f||(M(r.$$.fragment,t),f=!0)},o(t){b(r.$$.fragment,t),f=!1},d(t){t&&(s(n),s(a)),C(r,t)}}}function Io(I){let n,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=g},l(a){n=m(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=g)},m(a,r){d(a,n,r)},p:J,d(a){a&&s(n)}}}function vo(I){let n,g="Examples:",a,r,f;return r=new S({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEFsdENMSVBWaXNpb25Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQWx0Q0xJUFZpc2lvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbGFzdF9oaWRkZW5fc3RhdGUlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBcG9vbGVkX291dHB1dCUyMCUzRCUyMG91dHB1dHMucG9vbGVyX291dHB1dCUyMCUyMCUyMyUyMHBvb2xlZCUyMENMUyUyMHN0YXRlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AltCLIPVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPVisionModel.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled CLS states</span>`,wrap:!1}}),{c(){n=p("p"),n.textContent=g,a=l(),u(r.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=g),a=i(t),h(r.$$.fragment,t)},m(t,y){d(t,n,y),d(t,a,y),_(r,t,y),f=!0},p:J,i(t){f||(M(r.$$.fragment,t),f=!0)},o(t){b(r.$$.fragment,t),f=!1},d(t){t&&(s(n),s(a)),C(r,t)}}}function xo(I){let n,g,a,r,f,t,y,Mt,ue,Ln=`The AltCLIP model was proposed in <a href="https://arxiv.org/abs/2211.06679v2" rel="nofollow">AltCLIP: Altering the Language Encoder in CLIP for Extended Language Capabilities</a> by Zhongzhi Chen, Guang Liu, Bo-Wen Zhang, Fulong Ye, Qinghong Yang, Ledell Wu. AltCLIP
(Altering the Language Encoder in CLIP) is a neural network trained on a variety of image-text and text-text pairs. By switching CLIP’s
text encoder with a pretrained multilingual text encoder XLM-R, we could obtain very close performances with CLIP on almost all tasks, and extended original CLIP’s capabilities such as multilingual understanding.`,bt,he,jn="The abstract from the paper is the following:",Ct,_e,An=`<em>In this work, we present a conceptually simple and effective method to train a strong bilingual multimodal representation model.
Starting from the pretrained multimodal representation model CLIP released by OpenAI, we switched its text encoder with a pretrained
multilingual text encoder XLM-R, and aligned both languages and image representations by a two-stage training schema consisting of
teacher learning and contrastive learning. We validate our method through evaluations of a wide range of tasks. We set new state-of-the-art
performances on a bunch of tasks including ImageNet-CN, Flicker30k- CN, and COCO-CN. Further, we obtain very close performances with
CLIP on almost all tasks, suggesting that one can simply alter the text encoder in CLIP for extended capabilities such as multilingual understanding.</em>`,Tt,Me,kn='This model was contributed by <a href="https://huggingface.co/jongjyh" rel="nofollow">jongjyh</a>.',yt,be,It,Ce,Un=`The usage of AltCLIP is very similar to the CLIP. the difference between CLIP is the text encoder. Note that we use bidirectional attention instead of casual attention
and we take the [CLS] token in XLM-R to represent text embedding.`,vt,Te,zn=`AltCLIP is a multi-modal vision and language model. It can be used for image-text similarity and for zero-shot image
classification. AltCLIP uses a ViT like transformer to get visual features and a bidirectional language model to get the text
features. Both the text and visual features are then projected to a latent space with identical dimension. The dot
product between the projected image and text features is then used as a similar score.`,xt,ye,Bn=`To feed images to the Transformer encoder, each image is split into a sequence of fixed-size non-overlapping patches,
which are then linearly embedded. A [CLS] token is added to serve as representation of an entire image. The authors
also add absolute position embeddings, and feed the resulting sequence of vectors to a standard Transformer encoder.
The <a href="/docs/transformers/pr_31091/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> can be used to resize (or rescale) and normalize images for the model.`,wt,Ie,Wn=`The <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPProcessor">AltCLIPProcessor</a> wraps a <a href="/docs/transformers/pr_31091/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> and a <a href="/docs/transformers/pr_31091/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> into a single instance to both
encode the text and prepare the images. The following example shows how to get the image-text similarity scores using
<a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPProcessor">AltCLIPProcessor</a> and <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a>.`,$t,ve,Pt,Y,Jt,xe,Lt,w,we,Ft,Ke,Zn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a>. It is used to instantiate an
AltCLIP model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the AltCLIP
<a href="https://huggingface.co/BAAI/AltCLIP" rel="nofollow">BAAI/AltCLIP</a> architecture.`,qt,et,Vn=`Configuration objects inherit from <a href="/docs/transformers/pr_31091/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31091/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Xt,D,St,O,$e,Yt,tt,Hn=`Instantiate a <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPConfig">AltCLIPConfig</a> (or a derived class) from altclip text model configuration and altclip vision
model configuration.`,jt,Pe,At,L,Je,Dt,nt,En=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPTextModel">AltCLIPTextModel</a>. It is used to instantiate a
AltCLIP text model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the AltCLIP
<a href="https://huggingface.co/BAAI/AltCLIP" rel="nofollow">BAAI/AltCLIP</a> architecture.`,Ot,ot,Qn=`Configuration objects inherit from <a href="/docs/transformers/pr_31091/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31091/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Kt,K,kt,Le,Ut,j,je,en,st,Gn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a>. It is used to instantiate an
AltCLIP model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the AltCLIP
<a href="https://huggingface.co/BAAI/AltCLIP" rel="nofollow">BAAI/AltCLIP</a> architecture.`,tn,at,Nn=`Configuration objects inherit from <a href="/docs/transformers/pr_31091/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31091/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,nn,ee,zt,Ae,Rn="## AltCLIPProcessor[[transformers.AltCLIPProcessor]]",Bt,$,ke,on,rt,Fn=`Constructs a AltCLIP processor which wraps a CLIP image processor and a XLM-Roberta tokenizer into a single
processor.`,sn,lt,qn=`<a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPProcessor">AltCLIPProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_31091/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> and <a href="/docs/transformers/pr_31091/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a>. See
the <code>__call__()</code> and <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPProcessor.decode">decode()</a> for more information.`,an,te,Ue,rn,it,Xn=`This method forwards all its arguments to XLMRobertaTokenizerFast’s <a href="/docs/transformers/pr_31091/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>.
Please refer to the docstring of this method for more information.`,ln,ne,ze,dn,dt,Sn=`This method forwards all its arguments to XLMRobertaTokenizerFast’s <a href="/docs/transformers/pr_31091/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please
refer to the docstring of this method for more information.`,Wt,Be,Yn="## AltCLIPModel[[transformers.AltCLIPModel]]",Zt,A,We,cn,z,Ze,pn,ct,Dn='The <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> forward method, overrides the <code>__call__</code> special method.',mn,oe,fn,se,gn,B,Ve,un,pt,On='The <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> forward method, overrides the <code>__call__</code> special method.',hn,ae,_n,re,Mn,W,He,bn,mt,Kn='The <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> forward method, overrides the <code>__call__</code> special method.',Cn,le,Tn,ie,Vt,Ee,eo="## AltCLIPTextModel[[transformers.AltCLIPTextModel]]",Ht,q,Qe,yn,Z,Ge,In,ft,to='The <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPTextModel">AltCLIPTextModel</a> forward method, overrides the <code>__call__</code> special method.',vn,de,xn,ce,Et,Ne,no="## AltCLIPVisionModel[[transformers.AltCLIPVisionModel]]",Qt,X,Re,wn,V,Fe,$n,gt,oo='The <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPVisionModel">AltCLIPVisionModel</a> forward method, overrides the <code>__call__</code> special method.',Pn,pe,Jn,me,Gt,qe,Nt,_t,Rt;return f=new ht({props:{title:"AltCLIP",local:"altclip",headingTag:"h1"}}),y=new ht({props:{title:"Overview",local:"overview",headingTag:"h2"}}),be=new ht({props:{title:"Usage tips and example",local:"usage-tips-and-example",headingTag:"h2"}}),ve=new S({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQWx0Q0xJUE1vZGVsJTJDJTIwQWx0Q0xJUFByb2Nlc3NvciUwQSUwQW1vZGVsJTIwJTNEJTIwQWx0Q0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBbHRDTElQUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGQWx0Q0xJUCUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0QlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMkMlMjBpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzX3Blcl9pbWFnZSUyMCUzRCUyMG91dHB1dHMubG9naXRzX3Blcl9pbWFnZSUyMCUyMCUyMyUyMHRoaXMlMjBpcyUyMHRoZSUyMGltYWdlLXRleHQlMjBzaW1pbGFyaXR5JTIwc2NvcmUlMEFwcm9icyUyMCUzRCUyMGxvZ2l0c19wZXJfaW1hZ2Uuc29mdG1heChkaW0lM0QxKSUyMCUyMCUyMyUyMHdlJTIwY2FuJTIwdGFrZSUyMHRoZSUyMHNvZnRtYXglMjB0byUyMGdldCUyMHRoZSUyMGxhYmVsJTIwcHJvYmFiaWxpdGllcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AltCLIPModel, AltCLIPProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AltCLIPModel.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AltCLIPProcessor.from_pretrained(<span class="hljs-string">&quot;BAAI/AltCLIP&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),Y=new ut({props:{$$slots:{default:[po]},$$scope:{ctx:I}}}),xe=new ht({props:{title:"AltCLIPConfig",local:"transformers.AltCLIPConfig",headingTag:"h2"}}),we=new P({props:{name:"class transformers.AltCLIPConfig",anchor:"transformers.AltCLIPConfig",parameters:[{name:"text_config",val:" = None"},{name:"vision_config",val:" = None"},{name:"projection_dim",val:" = 768"},{name:"logit_scale_init_value",val:" = 2.6592"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AltCLIPConfig.text_config",description:`<strong>text_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPTextConfig">AltCLIPTextConfig</a>.`,name:"text_config"},{anchor:"transformers.AltCLIPConfig.vision_config",description:`<strong>vision_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPVisionConfig">AltCLIPVisionConfig</a>.`,name:"vision_config"},{anchor:"transformers.AltCLIPConfig.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimentionality of text and vision projection layers.`,name:"projection_dim"},{anchor:"transformers.AltCLIPConfig.logit_scale_init_value",description:`<strong>logit_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 2.6592) &#x2014;
The inital value of the <em>logit_scale</em> paramter. Default is used as per the original CLIP implementation.`,name:"logit_scale_init_value"},{anchor:"transformers.AltCLIPConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/configuration_altclip.py#L255"}}),D=new ge({props:{anchor:"transformers.AltCLIPConfig.example",$$slots:{default:[mo]},$$scope:{ctx:I}}}),$e=new P({props:{name:"from_text_vision_configs",anchor:"transformers.AltCLIPConfig.from_text_vision_configs",parameters:[{name:"text_config",val:": AltCLIPTextConfig"},{name:"vision_config",val:": AltCLIPVisionConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/configuration_altclip.py#L390",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPConfig"
>AltCLIPConfig</a></p>
`}}),Pe=new ht({props:{title:"AltCLIPTextConfig",local:"transformers.AltCLIPTextConfig",headingTag:"h2"}}),Je=new P({props:{name:"class transformers.AltCLIPTextConfig",anchor:"transformers.AltCLIPTextConfig",parameters:[{name:"vocab_size",val:" = 250002"},{name:"hidden_size",val:" = 1024"},{name:"num_hidden_layers",val:" = 24"},{name:"num_attention_heads",val:" = 16"},{name:"intermediate_size",val:" = 4096"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 514"},{name:"type_vocab_size",val:" = 1"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"position_embedding_type",val:" = 'absolute'"},{name:"use_cache",val:" = True"},{name:"project_dim",val:" = 768"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AltCLIPTextConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 250002) &#x2014;
Vocabulary size of the AltCLIP model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPTextModel">AltCLIPTextModel</a>.`,name:"vocab_size"},{anchor:"transformers.AltCLIPTextConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.AltCLIPTextConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.AltCLIPTextConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.AltCLIPTextConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.AltCLIPTextConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.AltCLIPTextConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.AltCLIPTextConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.AltCLIPTextConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 514) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.AltCLIPTextConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPTextModel">AltCLIPTextModel</a>`,name:"type_vocab_size"},{anchor:"transformers.AltCLIPTextConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.AltCLIPTextConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.AltCLIPTextConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.AltCLIPTextConfig.pad_token_id",description:"<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014; The id of the <em>padding</em> token.",name:"pad_token_id"},{anchor:"transformers.AltCLIPTextConfig.bos_token_id",description:"<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; The id of the <em>beginning-of-sequence</em> token.",name:"bos_token_id"},{anchor:"transformers.AltCLIPTextConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.AltCLIPTextConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;absolute&quot;</code>) &#x2014;
Type of position embedding. Choose one of <code>&quot;absolute&quot;</code>, <code>&quot;relative_key&quot;</code>, <code>&quot;relative_key_query&quot;</code>. For
positional embeddings use <code>&quot;absolute&quot;</code>. For more information on <code>&quot;relative_key&quot;</code>, please refer to
<a href="https://arxiv.org/abs/1803.02155" rel="nofollow">Self-Attention with Relative Position Representations (Shaw et al.)</a>.
For more information on <code>&quot;relative_key_query&quot;</code>, please refer to <em>Method 4</em> in <a href="https://arxiv.org/abs/2009.13658" rel="nofollow">Improve Transformer Models
with Better Relative Position Embeddings (Huang et al.)</a>.`,name:"position_embedding_type"},{anchor:"transformers.AltCLIPTextConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.AltCLIPTextConfig.project_dim",description:`<strong>project_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
The dimentions of the teacher model before the mapping layer.`,name:"project_dim"}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/configuration_altclip.py#L27"}}),K=new ge({props:{anchor:"transformers.AltCLIPTextConfig.example",$$slots:{default:[fo]},$$scope:{ctx:I}}}),Le=new ht({props:{title:"AltCLIPVisionConfig",local:"transformers.AltCLIPVisionConfig",headingTag:"h2"}}),je=new P({props:{name:"class transformers.AltCLIPVisionConfig",anchor:"transformers.AltCLIPVisionConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"intermediate_size",val:" = 3072"},{name:"projection_dim",val:" = 512"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 32"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AltCLIPVisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.AltCLIPVisionConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.AltCLIPVisionConfig.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimentionality of text and vision projection layers.`,name:"projection_dim"},{anchor:"transformers.AltCLIPVisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.AltCLIPVisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.AltCLIPVisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.AltCLIPVisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.AltCLIPVisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.AltCLIPVisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> \`<code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.AltCLIPVisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.AltCLIPVisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.AltCLIPVisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.AltCLIPVisionConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/configuration_altclip.py#L145"}}),ee=new ge({props:{anchor:"transformers.AltCLIPVisionConfig.example",$$slots:{default:[go]},$$scope:{ctx:I}}}),ke=new P({props:{name:"class transformers.AltCLIPProcessor",anchor:"transformers.AltCLIPProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AltCLIPProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/pr_31091/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.AltCLIPProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/pr_31091/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/processing_altclip.py#L25"}}),Ue=new P({props:{name:"batch_decode",anchor:"transformers.AltCLIPProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/processing_altclip.py#L114"}}),ze=new P({props:{name:"decode",anchor:"transformers.AltCLIPProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/processing_altclip.py#L121"}}),We=new P({props:{name:"class transformers.AltCLIPModel",anchor:"transformers.AltCLIPModel",parameters:[{name:"config",val:": AltCLIPConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/modeling_altclip.py#L1465"}}),Ze=new P({props:{name:"forward",anchor:"transformers.AltCLIPModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"return_loss",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.AltCLIPModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31091/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31091/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31091/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.AltCLIPModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.AltCLIPModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.AltCLIPModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/pr_31091/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_31091/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.AltCLIPModel.forward.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.AltCLIPModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AltCLIPModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AltCLIPModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31091/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/modeling_altclip.py#L1592",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.altclip.modeling_altclip.AltCLIPOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.altclip.configuration_altclip.AltCLIPConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image:(<code>torch.FloatTensor</code></strong> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text:(<code>torch.FloatTensor</code></strong> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds(<code>torch.FloatTensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPTextModel"
>AltCLIPTextModel</a>.</li>
<li><strong>image_embeds(<code>torch.FloatTensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPVisionModel"
>AltCLIPVisionModel</a>.</li>
<li><strong>text_model_output(<code>BaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPTextModel"
>AltCLIPTextModel</a>.</li>
<li><strong>vision_model_output(<code>BaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPVisionModel"
>AltCLIPVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.altclip.modeling_altclip.AltCLIPOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oe=new ut({props:{$$slots:{default:[uo]},$$scope:{ctx:I}}}),se=new ge({props:{anchor:"transformers.AltCLIPModel.forward.example",$$slots:{default:[ho]},$$scope:{ctx:I}}}),Ve=new P({props:{name:"get_text_features",anchor:"transformers.AltCLIPModel.get_text_features",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"token_type_ids",val:" = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.AltCLIPModel.get_text_features.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31091/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31091/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31091/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.AltCLIPModel.get_text_features.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.AltCLIPModel.get_text_features.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.AltCLIPModel.get_text_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AltCLIPModel.get_text_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AltCLIPModel.get_text_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31091/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/modeling_altclip.py#L1499",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The text embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPTextModel"
>AltCLIPTextModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>text_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),ae=new ut({props:{$$slots:{default:[_o]},$$scope:{ctx:I}}}),re=new ge({props:{anchor:"transformers.AltCLIPModel.get_text_features.example",$$slots:{default:[Mo]},$$scope:{ctx:I}}}),He=new P({props:{name:"get_image_features",anchor:"transformers.AltCLIPModel.get_image_features",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.AltCLIPModel.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/pr_31091/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_31091/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.AltCLIPModel.get_image_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AltCLIPModel.get_image_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AltCLIPModel.get_image_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31091/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/modeling_altclip.py#L1546",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The image embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_31091/en/model_doc/altclip#transformers.AltCLIPVisionModel"
>AltCLIPVisionModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),le=new ut({props:{$$slots:{default:[bo]},$$scope:{ctx:I}}}),ie=new ge({props:{anchor:"transformers.AltCLIPModel.get_image_features.example",$$slots:{default:[Co]},$$scope:{ctx:I}}}),Qe=new P({props:{name:"class transformers.AltCLIPTextModel",anchor:"transformers.AltCLIPTextModel",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/modeling_altclip.py#L1373"}}),Ge=new P({props:{name:"forward",anchor:"transformers.AltCLIPTextModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.AltCLIPTextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31091/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31091/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31091/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.AltCLIPTextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.AltCLIPTextModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.AltCLIPTextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AltCLIPTextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AltCLIPTextModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31091/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/modeling_altclip.py#L1392",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndProjection</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.altclip.configuration_altclip.AltCLIPTextConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>projection_state</strong> (<code>tuple(torch.FloatTensor)</code>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> of shape <code>(batch_size,config.project_dim)</code>.</p>
<p>Text embeddings before the projection layer, used to mimic the last hidden state of the teacher encoder.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndProjection</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),de=new ut({props:{$$slots:{default:[To]},$$scope:{ctx:I}}}),ce=new ge({props:{anchor:"transformers.AltCLIPTextModel.forward.example",$$slots:{default:[yo]},$$scope:{ctx:I}}}),Re=new P({props:{name:"class transformers.AltCLIPVisionModel",anchor:"transformers.AltCLIPVisionModel",parameters:[{name:"config",val:": AltCLIPVisionConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/modeling_altclip.py#L1142"}}),Fe=new P({props:{name:"forward",anchor:"transformers.AltCLIPVisionModel.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.AltCLIPVisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/pr_31091/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_31091/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.AltCLIPVisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.AltCLIPVisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.AltCLIPVisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31091/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31091/src/transformers/models/altclip/modeling_altclip.py#L1155",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31091/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.altclip.configuration_altclip.AltCLIPVisionConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31091/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pe=new ut({props:{$$slots:{default:[Io]},$$scope:{ctx:I}}}),me=new ge({props:{anchor:"transformers.AltCLIPVisionModel.forward.example",$$slots:{default:[vo]},$$scope:{ctx:I}}}),qe=new co({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/altclip.md"}}),{c(){n=p("meta"),g=l(),a=p("p"),r=l(),u(f.$$.fragment),t=l(),u(y.$$.fragment),Mt=l(),ue=p("p"),ue.innerHTML=Ln,bt=l(),he=p("p"),he.textContent=jn,Ct=l(),_e=p("p"),_e.innerHTML=An,Tt=l(),Me=p("p"),Me.innerHTML=kn,yt=l(),u(be.$$.fragment),It=l(),Ce=p("p"),Ce.textContent=Un,vt=l(),Te=p("p"),Te.textContent=zn,xt=l(),ye=p("p"),ye.innerHTML=Bn,wt=l(),Ie=p("p"),Ie.innerHTML=Wn,$t=l(),u(ve.$$.fragment),Pt=l(),u(Y.$$.fragment),Jt=l(),u(xe.$$.fragment),Lt=l(),w=p("div"),u(we.$$.fragment),Ft=l(),Ke=p("p"),Ke.innerHTML=Zn,qt=l(),et=p("p"),et.innerHTML=Vn,Xt=l(),u(D.$$.fragment),St=l(),O=p("div"),u($e.$$.fragment),Yt=l(),tt=p("p"),tt.innerHTML=Hn,jt=l(),u(Pe.$$.fragment),At=l(),L=p("div"),u(Je.$$.fragment),Dt=l(),nt=p("p"),nt.innerHTML=En,Ot=l(),ot=p("p"),ot.innerHTML=Qn,Kt=l(),u(K.$$.fragment),kt=l(),u(Le.$$.fragment),Ut=l(),j=p("div"),u(je.$$.fragment),en=l(),st=p("p"),st.innerHTML=Gn,tn=l(),at=p("p"),at.innerHTML=Nn,nn=l(),u(ee.$$.fragment),zt=l(),Ae=p("p"),Ae.textContent=Rn,Bt=l(),$=p("div"),u(ke.$$.fragment),on=l(),rt=p("p"),rt.textContent=Fn,sn=l(),lt=p("p"),lt.innerHTML=qn,an=l(),te=p("div"),u(Ue.$$.fragment),rn=l(),it=p("p"),it.innerHTML=Xn,ln=l(),ne=p("div"),u(ze.$$.fragment),dn=l(),dt=p("p"),dt.innerHTML=Sn,Wt=l(),Be=p("p"),Be.textContent=Yn,Zt=l(),A=p("div"),u(We.$$.fragment),cn=l(),z=p("div"),u(Ze.$$.fragment),pn=l(),ct=p("p"),ct.innerHTML=Dn,mn=l(),u(oe.$$.fragment),fn=l(),u(se.$$.fragment),gn=l(),B=p("div"),u(Ve.$$.fragment),un=l(),pt=p("p"),pt.innerHTML=On,hn=l(),u(ae.$$.fragment),_n=l(),u(re.$$.fragment),Mn=l(),W=p("div"),u(He.$$.fragment),bn=l(),mt=p("p"),mt.innerHTML=Kn,Cn=l(),u(le.$$.fragment),Tn=l(),u(ie.$$.fragment),Vt=l(),Ee=p("p"),Ee.textContent=eo,Ht=l(),q=p("div"),u(Qe.$$.fragment),yn=l(),Z=p("div"),u(Ge.$$.fragment),In=l(),ft=p("p"),ft.innerHTML=to,vn=l(),u(de.$$.fragment),xn=l(),u(ce.$$.fragment),Et=l(),Ne=p("p"),Ne.textContent=no,Qt=l(),X=p("div"),u(Re.$$.fragment),wn=l(),V=p("div"),u(Fe.$$.fragment),$n=l(),gt=p("p"),gt.innerHTML=oo,Pn=l(),u(pe.$$.fragment),Jn=l(),u(me.$$.fragment),Gt=l(),u(qe.$$.fragment),Nt=l(),_t=p("p"),this.h()},l(e){const o=io("svelte-u9bgzb",document.head);n=m(o,"META",{name:!0,content:!0}),o.forEach(s),g=i(e),a=m(e,"P",{}),v(a).forEach(s),r=i(e),h(f.$$.fragment,e),t=i(e),h(y.$$.fragment,e),Mt=i(e),ue=m(e,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-u3ci1i"&&(ue.innerHTML=Ln),bt=i(e),he=m(e,"P",{"data-svelte-h":!0}),T(he)!=="svelte-vfdo9a"&&(he.textContent=jn),Ct=i(e),_e=m(e,"P",{"data-svelte-h":!0}),T(_e)!=="svelte-fr1ot4"&&(_e.innerHTML=An),Tt=i(e),Me=m(e,"P",{"data-svelte-h":!0}),T(Me)!=="svelte-zmfqz"&&(Me.innerHTML=kn),yt=i(e),h(be.$$.fragment,e),It=i(e),Ce=m(e,"P",{"data-svelte-h":!0}),T(Ce)!=="svelte-1kvq7kq"&&(Ce.textContent=Un),vt=i(e),Te=m(e,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-zjm5tb"&&(Te.textContent=zn),xt=i(e),ye=m(e,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-15r7q60"&&(ye.innerHTML=Bn),wt=i(e),Ie=m(e,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-bhz47t"&&(Ie.innerHTML=Wn),$t=i(e),h(ve.$$.fragment,e),Pt=i(e),h(Y.$$.fragment,e),Jt=i(e),h(xe.$$.fragment,e),Lt=i(e),w=m(e,"DIV",{class:!0});var k=v(w);h(we.$$.fragment,k),Ft=i(k),Ke=m(k,"P",{"data-svelte-h":!0}),T(Ke)!=="svelte-115hquw"&&(Ke.innerHTML=Zn),qt=i(k),et=m(k,"P",{"data-svelte-h":!0}),T(et)!=="svelte-14hzmz"&&(et.innerHTML=Vn),Xt=i(k),h(D.$$.fragment,k),St=i(k),O=m(k,"DIV",{class:!0});var Xe=v(O);h($e.$$.fragment,Xe),Yt=i(Xe),tt=m(Xe,"P",{"data-svelte-h":!0}),T(tt)!=="svelte-1vtdiyh"&&(tt.innerHTML=Hn),Xe.forEach(s),k.forEach(s),jt=i(e),h(Pe.$$.fragment,e),At=i(e),L=m(e,"DIV",{class:!0});var H=v(L);h(Je.$$.fragment,H),Dt=i(H),nt=m(H,"P",{"data-svelte-h":!0}),T(nt)!=="svelte-3g5c9f"&&(nt.innerHTML=En),Ot=i(H),ot=m(H,"P",{"data-svelte-h":!0}),T(ot)!=="svelte-14hzmz"&&(ot.innerHTML=Qn),Kt=i(H),h(K.$$.fragment,H),H.forEach(s),kt=i(e),h(Le.$$.fragment,e),Ut=i(e),j=m(e,"DIV",{class:!0});var E=v(j);h(je.$$.fragment,E),en=i(E),st=m(E,"P",{"data-svelte-h":!0}),T(st)!=="svelte-1x08y62"&&(st.innerHTML=Gn),tn=i(E),at=m(E,"P",{"data-svelte-h":!0}),T(at)!=="svelte-1faitoz"&&(at.innerHTML=Nn),nn=i(E),h(ee.$$.fragment,E),E.forEach(s),zt=i(e),Ae=m(e,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-jl42a2"&&(Ae.textContent=Rn),Bt=i(e),$=m(e,"DIV",{class:!0});var U=v($);h(ke.$$.fragment,U),on=i(U),rt=m(U,"P",{"data-svelte-h":!0}),T(rt)!=="svelte-1rdismf"&&(rt.textContent=Fn),sn=i(U),lt=m(U,"P",{"data-svelte-h":!0}),T(lt)!=="svelte-1y3ctzm"&&(lt.innerHTML=qn),an=i(U),te=m(U,"DIV",{class:!0});var Se=v(te);h(Ue.$$.fragment,Se),rn=i(Se),it=m(Se,"P",{"data-svelte-h":!0}),T(it)!=="svelte-186f49p"&&(it.innerHTML=Xn),Se.forEach(s),ln=i(U),ne=m(U,"DIV",{class:!0});var Ye=v(ne);h(ze.$$.fragment,Ye),dn=i(Ye),dt=m(Ye,"P",{"data-svelte-h":!0}),T(dt)!=="svelte-1b45hof"&&(dt.innerHTML=Sn),Ye.forEach(s),U.forEach(s),Wt=i(e),Be=m(e,"P",{"data-svelte-h":!0}),T(Be)!=="svelte-innxzo"&&(Be.textContent=Yn),Zt=i(e),A=m(e,"DIV",{class:!0});var Q=v(A);h(We.$$.fragment,Q),cn=i(Q),z=m(Q,"DIV",{class:!0});var G=v(z);h(Ze.$$.fragment,G),pn=i(G),ct=m(G,"P",{"data-svelte-h":!0}),T(ct)!=="svelte-1npwymi"&&(ct.innerHTML=Dn),mn=i(G),h(oe.$$.fragment,G),fn=i(G),h(se.$$.fragment,G),G.forEach(s),gn=i(Q),B=m(Q,"DIV",{class:!0});var N=v(B);h(Ve.$$.fragment,N),un=i(N),pt=m(N,"P",{"data-svelte-h":!0}),T(pt)!=="svelte-1npwymi"&&(pt.innerHTML=On),hn=i(N),h(ae.$$.fragment,N),_n=i(N),h(re.$$.fragment,N),N.forEach(s),Mn=i(Q),W=m(Q,"DIV",{class:!0});var R=v(W);h(He.$$.fragment,R),bn=i(R),mt=m(R,"P",{"data-svelte-h":!0}),T(mt)!=="svelte-1npwymi"&&(mt.innerHTML=Kn),Cn=i(R),h(le.$$.fragment,R),Tn=i(R),h(ie.$$.fragment,R),R.forEach(s),Q.forEach(s),Vt=i(e),Ee=m(e,"P",{"data-svelte-h":!0}),T(Ee)!=="svelte-whpt86"&&(Ee.textContent=eo),Ht=i(e),q=m(e,"DIV",{class:!0});var De=v(q);h(Qe.$$.fragment,De),yn=i(De),Z=m(De,"DIV",{class:!0});var F=v(Z);h(Ge.$$.fragment,F),In=i(F),ft=m(F,"P",{"data-svelte-h":!0}),T(ft)!=="svelte-1me6708"&&(ft.innerHTML=to),vn=i(F),h(de.$$.fragment,F),xn=i(F),h(ce.$$.fragment,F),F.forEach(s),De.forEach(s),Et=i(e),Ne=m(e,"P",{"data-svelte-h":!0}),T(Ne)!=="svelte-ohzz24"&&(Ne.textContent=no),Qt=i(e),X=m(e,"DIV",{class:!0});var Oe=v(X);h(Re.$$.fragment,Oe),wn=i(Oe),V=m(Oe,"DIV",{class:!0});var fe=v(V);h(Fe.$$.fragment,fe),$n=i(fe),gt=m(fe,"P",{"data-svelte-h":!0}),T(gt)!=="svelte-1hiuzui"&&(gt.innerHTML=oo),Pn=i(fe),h(pe.$$.fragment,fe),Jn=i(fe),h(me.$$.fragment,fe),fe.forEach(s),Oe.forEach(s),Gt=i(e),h(qe.$$.fragment,e),Nt=i(e),_t=m(e,"P",{}),v(_t).forEach(s),this.h()},h(){x(n,"name","hf:doc:metadata"),x(n,"content",wo),x(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){c(document.head,n),d(e,g,o),d(e,a,o),d(e,r,o),_(f,e,o),d(e,t,o),_(y,e,o),d(e,Mt,o),d(e,ue,o),d(e,bt,o),d(e,he,o),d(e,Ct,o),d(e,_e,o),d(e,Tt,o),d(e,Me,o),d(e,yt,o),_(be,e,o),d(e,It,o),d(e,Ce,o),d(e,vt,o),d(e,Te,o),d(e,xt,o),d(e,ye,o),d(e,wt,o),d(e,Ie,o),d(e,$t,o),_(ve,e,o),d(e,Pt,o),_(Y,e,o),d(e,Jt,o),_(xe,e,o),d(e,Lt,o),d(e,w,o),_(we,w,null),c(w,Ft),c(w,Ke),c(w,qt),c(w,et),c(w,Xt),_(D,w,null),c(w,St),c(w,O),_($e,O,null),c(O,Yt),c(O,tt),d(e,jt,o),_(Pe,e,o),d(e,At,o),d(e,L,o),_(Je,L,null),c(L,Dt),c(L,nt),c(L,Ot),c(L,ot),c(L,Kt),_(K,L,null),d(e,kt,o),_(Le,e,o),d(e,Ut,o),d(e,j,o),_(je,j,null),c(j,en),c(j,st),c(j,tn),c(j,at),c(j,nn),_(ee,j,null),d(e,zt,o),d(e,Ae,o),d(e,Bt,o),d(e,$,o),_(ke,$,null),c($,on),c($,rt),c($,sn),c($,lt),c($,an),c($,te),_(Ue,te,null),c(te,rn),c(te,it),c($,ln),c($,ne),_(ze,ne,null),c(ne,dn),c(ne,dt),d(e,Wt,o),d(e,Be,o),d(e,Zt,o),d(e,A,o),_(We,A,null),c(A,cn),c(A,z),_(Ze,z,null),c(z,pn),c(z,ct),c(z,mn),_(oe,z,null),c(z,fn),_(se,z,null),c(A,gn),c(A,B),_(Ve,B,null),c(B,un),c(B,pt),c(B,hn),_(ae,B,null),c(B,_n),_(re,B,null),c(A,Mn),c(A,W),_(He,W,null),c(W,bn),c(W,mt),c(W,Cn),_(le,W,null),c(W,Tn),_(ie,W,null),d(e,Vt,o),d(e,Ee,o),d(e,Ht,o),d(e,q,o),_(Qe,q,null),c(q,yn),c(q,Z),_(Ge,Z,null),c(Z,In),c(Z,ft),c(Z,vn),_(de,Z,null),c(Z,xn),_(ce,Z,null),d(e,Et,o),d(e,Ne,o),d(e,Qt,o),d(e,X,o),_(Re,X,null),c(X,wn),c(X,V),_(Fe,V,null),c(V,$n),c(V,gt),c(V,Pn),_(pe,V,null),c(V,Jn),_(me,V,null),d(e,Gt,o),_(qe,e,o),d(e,Nt,o),d(e,_t,o),Rt=!0},p(e,[o]){const k={};o&2&&(k.$$scope={dirty:o,ctx:e}),Y.$set(k);const Xe={};o&2&&(Xe.$$scope={dirty:o,ctx:e}),D.$set(Xe);const H={};o&2&&(H.$$scope={dirty:o,ctx:e}),K.$set(H);const E={};o&2&&(E.$$scope={dirty:o,ctx:e}),ee.$set(E);const U={};o&2&&(U.$$scope={dirty:o,ctx:e}),oe.$set(U);const Se={};o&2&&(Se.$$scope={dirty:o,ctx:e}),se.$set(Se);const Ye={};o&2&&(Ye.$$scope={dirty:o,ctx:e}),ae.$set(Ye);const Q={};o&2&&(Q.$$scope={dirty:o,ctx:e}),re.$set(Q);const G={};o&2&&(G.$$scope={dirty:o,ctx:e}),le.$set(G);const N={};o&2&&(N.$$scope={dirty:o,ctx:e}),ie.$set(N);const R={};o&2&&(R.$$scope={dirty:o,ctx:e}),de.$set(R);const De={};o&2&&(De.$$scope={dirty:o,ctx:e}),ce.$set(De);const F={};o&2&&(F.$$scope={dirty:o,ctx:e}),pe.$set(F);const Oe={};o&2&&(Oe.$$scope={dirty:o,ctx:e}),me.$set(Oe)},i(e){Rt||(M(f.$$.fragment,e),M(y.$$.fragment,e),M(be.$$.fragment,e),M(ve.$$.fragment,e),M(Y.$$.fragment,e),M(xe.$$.fragment,e),M(we.$$.fragment,e),M(D.$$.fragment,e),M($e.$$.fragment,e),M(Pe.$$.fragment,e),M(Je.$$.fragment,e),M(K.$$.fragment,e),M(Le.$$.fragment,e),M(je.$$.fragment,e),M(ee.$$.fragment,e),M(ke.$$.fragment,e),M(Ue.$$.fragment,e),M(ze.$$.fragment,e),M(We.$$.fragment,e),M(Ze.$$.fragment,e),M(oe.$$.fragment,e),M(se.$$.fragment,e),M(Ve.$$.fragment,e),M(ae.$$.fragment,e),M(re.$$.fragment,e),M(He.$$.fragment,e),M(le.$$.fragment,e),M(ie.$$.fragment,e),M(Qe.$$.fragment,e),M(Ge.$$.fragment,e),M(de.$$.fragment,e),M(ce.$$.fragment,e),M(Re.$$.fragment,e),M(Fe.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(qe.$$.fragment,e),Rt=!0)},o(e){b(f.$$.fragment,e),b(y.$$.fragment,e),b(be.$$.fragment,e),b(ve.$$.fragment,e),b(Y.$$.fragment,e),b(xe.$$.fragment,e),b(we.$$.fragment,e),b(D.$$.fragment,e),b($e.$$.fragment,e),b(Pe.$$.fragment,e),b(Je.$$.fragment,e),b(K.$$.fragment,e),b(Le.$$.fragment,e),b(je.$$.fragment,e),b(ee.$$.fragment,e),b(ke.$$.fragment,e),b(Ue.$$.fragment,e),b(ze.$$.fragment,e),b(We.$$.fragment,e),b(Ze.$$.fragment,e),b(oe.$$.fragment,e),b(se.$$.fragment,e),b(Ve.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(He.$$.fragment,e),b(le.$$.fragment,e),b(ie.$$.fragment,e),b(Qe.$$.fragment,e),b(Ge.$$.fragment,e),b(de.$$.fragment,e),b(ce.$$.fragment,e),b(Re.$$.fragment,e),b(Fe.$$.fragment,e),b(pe.$$.fragment,e),b(me.$$.fragment,e),b(qe.$$.fragment,e),Rt=!1},d(e){e&&(s(g),s(a),s(r),s(t),s(Mt),s(ue),s(bt),s(he),s(Ct),s(_e),s(Tt),s(Me),s(yt),s(It),s(Ce),s(vt),s(Te),s(xt),s(ye),s(wt),s(Ie),s($t),s(Pt),s(Jt),s(Lt),s(w),s(jt),s(At),s(L),s(kt),s(Ut),s(j),s(zt),s(Ae),s(Bt),s($),s(Wt),s(Be),s(Zt),s(A),s(Vt),s(Ee),s(Ht),s(q),s(Et),s(Ne),s(Qt),s(X),s(Gt),s(Nt),s(_t)),s(n),C(f,e),C(y,e),C(be,e),C(ve,e),C(Y,e),C(xe,e),C(we),C(D),C($e),C(Pe,e),C(Je),C(K),C(Le,e),C(je),C(ee),C(ke),C(Ue),C(ze),C(We),C(Ze),C(oe),C(se),C(Ve),C(ae),C(re),C(He),C(le),C(ie),C(Qe),C(Ge),C(de),C(ce),C(Re),C(Fe),C(pe),C(me),C(qe,e)}}}const wo='{"title":"AltCLIP","local":"altclip","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips and example","local":"usage-tips-and-example","sections":[],"depth":2},{"title":"AltCLIPConfig","local":"transformers.AltCLIPConfig","sections":[],"depth":2},{"title":"AltCLIPTextConfig","local":"transformers.AltCLIPTextConfig","sections":[],"depth":2},{"title":"AltCLIPVisionConfig","local":"transformers.AltCLIPVisionConfig","sections":[],"depth":2}],"depth":1}';function $o(I){return ao(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zo extends ro{constructor(n){super(),lo(this,n,$o,xo,so,{})}}export{zo as component};
