import{s as nr,o as rr,n as jl}from"../chunks/scheduler.37c15a92.js";import{S as or,i as pr,g as n,s,r as p,A as cr,h as r,f as l,c as i,j as sr,u as c,x as o,k as ir,y as mr,a,v as m,d,t as u,w as M}from"../chunks/index.2bf4358c.js";import{T as fl}from"../chunks/Tip.363c041f.js";import{Y as dr}from"../chunks/Youtube.1e50a667.js";import{C as y}from"../chunks/CodeBlock.4e987730.js";import{C as ur}from"../chunks/CourseFloatingBanner.9ff4c771.js";import{F as Mr}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as j,E as Jr}from"../chunks/getInferenceSnippets.24b50994.js";function yr(f){let J,T="✏️ <strong>Prova tu!</strong> Controlla che tutto sia corretto nel secondo elemento del training set.";return{c(){J=n("p"),J.innerHTML=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-4bjsze"&&(J.innerHTML=T)},m(b,h){a(b,J,h)},p:jl,d(b){b&&l(J)}}}function br(f){let J,T="Nella prossima parte del corso, esamineremo tecniche più avanzate che possono aiutare a ridurre l’impatto sulla memoria e ad affinare i modelli più grandi.";return{c(){J=n("p"),J.textContent=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-q2er6j"&&(J.textContent=T)},m(b,h){a(b,J,h)},p:jl,d(b){b&&l(J)}}}function Tr(f){let J,T="💡 Bisogna sempre assicurarsi di poter eseguire <code>trainer.evaluate()</code> prima di lanciare <code>trainer.train()</code>, per evitare di sprecare molte risorse di calcolo prima di incorrere in un errore.";return{c(){J=n("p"),J.innerHTML=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1wy054r"&&(J.innerHTML=T)},m(b,h){a(b,J,h)},p:jl,d(b){b&&l(J)}}}function hr(f){let J,T="💡 Se si utilizza un ciclo di addestramento manuale, per il debug della pipeline di addestramento valgono gli stessi passaggi, ma è più facile separarli. Assicurati però di non aver dimenticato il <code>model.eval()</code> o il <code>model.train()</code> nei punti giusti, o lo <code>zero_grad()</code> a ogni passo!";return{c(){J=n("p"),J.innerHTML=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-17w7sr0"&&(J.innerHTML=T)},m(b,h){a(b,J,h)},p:jl,d(b){b&&l(J)}}}function fr(f){let J,T="⚠️ Se effettui un addestramento in modo distribuito, stampa campioni del set di dati in ogni processo e controlla molto attentamente che ottieni la stessa cosa. Un bug comune è la presenza di una qualche fonte di casualità nella creazione dei dati che fa sì che ogni processo abbia una versione diversa del set di dati.";return{c(){J=n("p"),J.textContent=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-yqzwsk"&&(J.textContent=T)},m(b,h){a(b,J,h)},p:jl,d(b){b&&l(J)}}}function jr(f){let J,T="💡 Se i dati di addestramento sono sbilanciati, assicurati di creare un batch di dati di addestramento contenente tutte le label.";return{c(){J=n("p"),J.textContent=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1ueptnc"&&(J.textContent=T)},m(b,h){a(b,J,h)},p:jl,d(b){b&&l(J)}}}function wr(f){let J,T="⚠️ Sarà necessario ricreare il modello e il <code>Trainer</code> dopo questo test, poiché il modello ottenuto probabilmente non sarà in grado di recuperare e imparare qualcosa di utile sul set di dati completo.";return{c(){J=n("p"),J.innerHTML=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-wtiz5s"&&(J.innerHTML=T)},m(b,h){a(b,J,h)},p:jl,d(b){b&&l(J)}}}function Ur(f){let J,T,b,h,w,Ul,k,gl,B,$l,W,wi='Hai scritto un bello script per addestrare o affinare un modello su un determinato compito, seguendo scrupolosamente i consigli del <a href="/course/chapter7">Capitolo 7</a>. Ma quando lanci il comando <code>trainer.train()</code>, succede qualcosa di orribile: si ottiene un errore 😱! O peggio, tutto sembra andare bene e il training viene eseguito senza errori, ma il modello che ne risulta fa schifo. In questa sezione mostreremo cosa è possibile fare per eseguire il debug di questo tipo di problemi.',Cl,X,Zl,R,vl,z,Ui="Il problema quando si ha un errore da <code>trainer.train()</code> è che potrebbe provenire da più fonti, poiché il <code>Trainer</code> di solito mette insieme molte cose. Converte i dataset in <em>dataloader</em>, quindi l’errore potrebbe essere dato da qualcosa di sbagliato nel dataset stesso, o da un problema qualche problema nel provare a raggruppare in un batch elementi del dataset. Poi prende un batch di dati e lo invia al modello, quindi il problema potrebbe anche essere nel codice del modello. Successivamente, calcola i gradienti ed esegue la fase di ottimizzazione, quindi il problema potrebbe essere nel tuo <em>optimizer</em>. E anche se tutto va bene per il training, qualcosa potrebbe andare storto durante la valutazione se c’è un problema con la metrica selezionata.",Il,G,gi="Il modo migliore per eseguire il debug di un errore che si verifica in <code>trainer.train()</code> è quello di esaminare manualmente l’intera pipeline per vedere dove le cose sono andate storte. L’errore è spesso molto facile da risolvere.",kl,V,$i='Per dimostrarlo, useremo il seguente script che ha lo scopo di affinare un modello DistilBERT sul <a href="https://huggingface.co/datasets/glue" rel="nofollow">dataset MNLI</a>:',Bl,_,Wl,Y,Ci="Se provi a eseguirlo, otterrai un errore piuttosto criptico:",Xl,x,Rl,F,zl,A,Zi="Non c’è bisogno di dirlo, ma se i dati sono corrotti, il <code>Trainer</code> non sarà in grado di formare i batch e tanto meno di addestrare il modello. Quindi, per prima cosa, è necessario dare un’occhiata a cosa c’è nel training set(<em>insieme di addestramento</em>).",Gl,H,vi="Per evitare di passare infinite ore a cercare di risolvere qualcosa che non è la fonte del bug, consigliamo di usare <code>trainer.train_dataset</code> per controllare l’insieme di dati e nient’altro. Quindi facciamo così:",Vl,Q,_l,N,Yl,E,Ii="Hai notato qualcosa di sbagliato? Questo, insieme al messaggio di errore sulla mancanza di <code>input_ids</code>, dovrebbe farci capire che qui abbiamo testo, non numeri che invece il modello può interpretare. In questo caso, l’errore originale è molto fuorviante, perché il <code>Trainer</code> rimuove automaticamente le colonne che non corrispondono alla firma del modello (cioè i parametri che il modello si aspetta). Ciò significa che in questo caso tutto, a parte <em>label</em>, è stato scartato. Non c’è stato quindi nessun problema nel creare i batch di dati e poi inviarli al modello, invece è il modello che a sua volta si è lamentato di non aver ricevuto l’input corretto.",xl,q,ki="Perché i dati non sono stati processati? Abbiamo usato il metodo <code>Dataset.map()</code> sui set di dati per applicare il tokenizer a ogni campione. Ma se si osserva attentamente il codice, si noterà che abbiamo commesso un errore nel passare i training set e il validation set (<em>insieme di valutazione</em>) al <code>Trainer</code>. Qui invece di usare <code>tokenized_datasets</code>, abbiamo usato <code>raw_datasets</code> 🤦. Quindi correggiamo questo errore!",Fl,S,Al,L,Bi="Questo nuovo codice ora darà un errore diverso (un miglioramento!):",Hl,D,Ql,P,Wi="Osservando il traceback, si nota che l’errore si verifica nel punto in cui i dati vengono raccolti:",Nl,K,El,O,Xi="Quindi, bisogna concentrarsi su questo. Prima di farlo, però, finiamo d’ispezionare i nostri dati, per essere sicuri al 100% che siano corretti.",ql,ee,Ri="Una cosa da fare sempre quando si esegue il debug di una sessione di addestramento è dare un’occhiata agli input del modello decodificati. Non possiamo dare un senso ai numeri che gli diamo direttamente in pasto, quindi dobbiamo guardare cosa rappresentano quei numeri. Nella computer vision, ad esempio, ciò significa guardare le immagini decodificate dei pixel passati, nel campo del riconoscimento vocale significa ascoltare i campioni audio decodificati e per il nostro esempio di NLP significa usare il nostro tokenizer per decodificare gli input:",Sl,te,Ll,le,Dl,ae,zi="Questo sembra corretto. Si dovrebbe fare così per tutte le chiavi degli input:",Pl,se,Kl,ie,Ol,ne,Gi="Si noti che le chiavi che non corrispondono a input accettati dal modello saranno automaticamente scartate, quindi qui terremo solo <code>input_ids</code>, <code>attention_mask</code> e <code>label</code> (che sarà rinominata <code>labels</code>). Per ricontrollare la firma del modello, si può stampare la classe del modello e poi controllare la sua documentazione:",ea,re,ta,oe,la,pe,Vi='Quindi, nel nostro caso, possiamo controllare i parametri accettati in <a href="https://huggingface.co/transformers/model_doc/distilbert.html#distilbertforsequenceclassification" rel="nofollow">questa pagina</a>. Il <code>Trainer</code> registrerà anche le colonne che sta scartando.',aa,ce,_i="Abbiamo controllato che gli ID in ingresso siano corretti decodificandoli. Il prossimo passo è la <code>attention_mask</code>:",sa,me,ia,de,na,ue,Yi="Poiché non abbiamo applicato il padding nel nostro preprocessing, questo sembra perfettamente naturale. Per essere sicuri che non ci siano problemi con la attention mask (<em>maschera di attenzione</em>), controlliamo che sia della stessa lunghezza dei nostri ID di input:",ra,Me,oa,Je,pa,ye,xi="Bene! Infine, controlliamo la nostra label:",ca,be,ma,Te,da,he,Fi="Come gli ID degli input, si tratta di un numero che non ha senso di per sé. Come abbiamo visto prima, la mappa tra gli interi e i nomi delle label è memorizzata all’interno dell’attributo <code>names</code> della corrispondente <em>feature</em> del dataset:",ua,fe,Ma,je,Ja,we,Ai="Quindi <code>1</code> significa <code>neutral</code> (<em>neutro</em>), il che significa che le due frasi viste sopra non sono in contraddizione e che la prima non implica la seconda. Sembra corretto!",ya,Ue,Hi="Non abbiamo token type ID (<em>ID del tipo di token</em>) qui, perché DistilBERT non li prevede; se li hai nel tuo modello, devi anche assicurarti che corrispondano correttamente alla posizione della prima e della seconda frase nell’input.",ba,U,Ta,ge,Qi="In questo caso, il controllo viene effettuato solo sul training set, ma è necessario ricontrollare allo stesso modo anche il validation set e il test set.",ha,$e,Ni="Ora che sappiamo che i nostri set di dati sono corretti, è il momento di verificare la fase successiva della pipeline di addestramento.",fa,Ce,ja,Ze,Ei="La prossima cosa che può andare storta nella pipeline di addestramento è quando il <code>Trainer</code> cerca di formare dei batch dal training o dal validation set. Una volta che si è sicuri che i set di dati del <code>Trainer</code> sono corretti, si può provare a formare manualmente un batch eseguendo quanto segue (sostituire <code>train</code> con <code>eval</code> per il dataloader di validazione):",wa,ve,Ua,Ie,qi="Questo codice crea il training dataloader (<em>caricatore di dati di addestramento</em>), quindi lo itera, fermandosi alla prima iterazione. Se il codice viene eseguito senza errori, si ha il primo batch di addestramento che può essere ispezionato; se il codice dà errore, si sa con certezza che il problema è nel dataloader, come in questo caso:",ga,ke,$a,Be,Si="L’ispezione dell’ultimo frame del traceback dovrebbe essere sufficiente a fornire un indizio, ma cerchiamo di scavare un po’ più a fondo. La maggior parte dei problemi durante la creazione dei batch si verifica a causa del raggruppamento degli esempi in un singolo batch, quindi la prima cosa da controllare in caso di dubbio è quale <code>collate_fn</code> il tuo <code>DataLoader</code> sta usando:",Ca,We,Za,Xe,va,Re,Li="È il <code>default_data_collator</code>, ma non è quello che vogliamo in questo caso. Vogliamo che i nostri esempi siano espansi fino ad essere come la frase più lunga del batch, cosa che viene fatta dal collettore <code>DataCollatorWithPadding</code>. Questo collatore di dati dovrebbe essere usato di default da <code>Trainer</code>, quindi perché non viene usato qui?",Ia,ze,Di="La risposta è che non abbiamo passato il <code>tokenizer</code> al <code>Trainer</code>, quindi non ha potuto creare il <code>DataCollatorWithPadding</code> che volevamo. In pratica, non si dovrebbe mai esitare a passare esplicitamente il collettore di dati che si vuole usare, per essere sicuri di evitare questo tipo di errori. Adattiamo il nostro codice per fare esattamente questo:",ka,Ge,Ba,Ve,Pi="La buona notizia? Non riceviamo più lo stesso errore di prima, il che è sicuramente un miglioramento. La cattiva notizia? Otteniamo invece un famigerato errore CUDA:",Wa,_e,Xa,Ye,Ki="Questo è un male perché gli errori di CUDA sono estremamente difficili da debuggare in generale. Vedremo tra poco come risolvere questo problema, ma prima terminiamo l’analisi della creazione di batch.",Ra,xe,Oi="Se siete sicuri che il tuo collettore di dati è quello giusto, dovresti provare ad applicarlo su un paio di campioni del tuo set di dati:",za,Fe,Ga,Ae,en="Questo codice fallirà perché il <code>train_dataset</code> contiene colonne di tipo stringa, che il <code>Trainer</code> solitamente rimuove. È possibile rimuoverle manualmente o, se si vuole replicare esattamente ciò che il <code>Trainer</code> fa dietro le quinte, si può chiamare il metodo privato <code>Trainer._remove_unused_columns()</code> che fa questo:",Va,He,_a,Qe,tn="Se l’errore persiste, si potrebbe eseguire manualmente il debug di ciò che accade all’interno del collettore di dati.",Ya,Ne,ln="Ora che abbiamo eseguito il debug del processo di creazione del batch, è il momento di passarne uno attraverso il modello!",xa,Ee,Fa,qe,an="Dovrebbe essere possibile ottenere un batch eseguendo il seguente comando:",Aa,Se,Ha,Le,sn="Se si esegue questo codice in un notebook, è possibile che si verifichi un errore CUDA simile a quello visto in precedenza, nel qual caso è necessario riavviare il notebook e rieseguire l’ultimo snippet senza la riga <code>trainer.train()</code>. Questa è la seconda cosa più fastidiosa degli errori CUDA: rompono irrimediabilmente il kernel. La cosa più fastidiosa è che sono difficili da debuggare.",Qa,De,nn="Perché? Questo ha a che fare con il modo in cui funzionano le GPU. Sono estremamente efficienti nell’eseguire molte operazioni in parallelo, ma l’inconveniente è che quando una di queste istruzioni produce un errore, non lo si sa immediatamente. È solo quando il programma chiama una sincronizzazione dei processi multipli sulla GPU che esso si accorge che qualcosa è andato storto, quindi l’errore viene effettivamente sollevato in un punto che non ha niente a che fare con ciò che lo ha creato. Per esempio, se guardiamo il nostro traceback precedente, l’errore è stato sollevato durante il backward pass (<em>percorso discendente</em>), ma vedremo tra un minuto che in realtà deriva da qualcosa nel forward pass (<em>percorso ascendente</em>).",Na,Pe,rn="Come si fa a fare il debug di questi errori? La risposta è semplice: non lo facciamo. A meno che l’errore CUDA non sia un errore out-of-memory (il che significa che la memoria della GPU non è sufficiente), si dovrebbe sempre tornare alla CPU per eseguire il debug.",Ea,Ke,on="Per fare questo nel nostro caso, dobbiamo semplicemente rimettere il modello sulla CPU e chiamarlo sul nostro batch — il batch restituito dal <code>DataLoader</code> non è ancora stato spostato sulla GPU:",qa,Oe,Sa,et,La,tt,pn="Quindi, il quadro si fa più chiaro. Invece di avere un errore CUDA, ora abbiamo un <code>IndexError</code> nel calcolo della loss (<em>funzione di perdita</em>) (quindi niente a che fare con il backward pass, come abbiamo detto prima). Più precisamente, possiamo vedere che è il target 2 a creare l’errore, quindi questo è un ottimo momento per controllare il numero di label del nostro modello:",Da,lt,Pa,at,Ka,st,cn="Con due label, solo gli 0 e gli 1 sono ammessi come target, ma secondo il messaggio di errore abbiamo ottenuto un 2. Ottenere un 2 è in realtà normale: se ricordiamo i nomi delle etichette che abbiamo estratto in precedenza, ce n’erano tre, quindi abbiamo gli indici 0, 1 e 2 nel nostro dataset. Il problema è che non l’abbiamo detto al nostro modello, il quale si sarebbe dovuto creare con tre label. Quindi, risolviamo il problema!",Oa,it,es,nt,mn="Non abbiamo ancora incluso la riga <code>trainer.train()</code>, per prendere tempo e verificare che tutto sia a posto. Se richiediamo un batch e lo passiamo al nostro modello, ora funziona senza errori!",ts,rt,ls,ot,dn="Il passo successivo consiste nel tornare a usare la GPU e verificare che tutto funzioni ancora:",as,pt,ss,ct,un="Se si verifica ancora un errore, assicurarsi di riavviare il notebook ed eseguire solo l’ultima versione dello script.",is,mt,ns,dt,Mn="Ora che sappiamo che possiamo costruire batch che passano effettivamente attraverso il modello, siamo pronti per la fase successiva della pipeline di addestramento: calcolare i gradienti ed eseguire una fase di ottimizzazione.",rs,ut,Jn="La prima parte consiste nel richiamare il metodo <code>backward()</code> sulla loss:",os,Mt,ps,Jt,yn="È abbastanza raro che si verifichi un errore in questa fase, ma se si verifica, assicurati di tornare ad usare la CPU per ottenere un messaggio di errore più utile.",cs,yt,bn="Per eseguire la fase di ottimizzazione, è sufficiente creare l’oggetto <code>optimizer</code> e richiamare il suo metodo <code>step()</code>:",ms,bt,ds,Tt,Tn="Anche in questo caso, se si utilizza l’ottimizzatore predefinito nel <code>Trainer</code>, non si dovrebbe ottenere un errore in questa fase, ma se hai un ottimizzatore personalizzato, potrebbero esserci dei problemi da risolvere. Non dimenticare di tornare alla CPU se ottieni uno strano errore CUDA in questa fase. A proposito di errori CUDA, prima abbiamo menzionato un caso speciale. Vediamo ora questo caso.",us,ht,Ms,ft,hn="Ogni volta che si riceve un messaggio di errore che inizia con <code>RuntimeError: CUDA out of memory</code>, indica che la memoria della GPU è esaurita. Questo errore non è direttamente collegato al codice e può verificarsi anche con uno script che funziona perfettamente. Questo errore significa che si è tentato di mettere troppe cose nella memoria interna della GPU e che si è verificato un errore. Come per altri errori di CUDA, è necessario riavviare il kernel per poter eseguire nuovamente l’allenamento.",Js,jt,fn="Per risolvere questo problema, è sufficiente utilizzare meno spazio sulla GPU, cosa che spesso è più facile a dirsi che a farsi. Per prima cosa, assicuratevi di non avere due modelli sulla GPU contemporaneamente (a meno che non sia necessario per il vostro problema, ovviamente). Poi, è probabile che si debba ridurre la dimensione del batch, in quanto influisce direttamente sulle dimensioni di tutti gli output intermedi del modello e dei loro gradienti. Se il problema persiste, si può considerare di utilizzare una versione più piccola del modello.",ys,g,bs,wt,Ts,Ut,jn="Ora che abbiamo risolto tutti i problemi con il nostro codice, tutto è perfetto e l’addestramento dovrebbe girare senza intoppi, giusto? Non così veloce! Se si esegue il comando <code>trainer.train()</code>, all’inizio sembrerà tutto a posto, ma dopo un po’ si otterrà il seguente risultato:",hs,gt,fs,$t,js,Ct,wn="Ti accorgerai che questo errore compare durante la fase di valutazione, quindi è l’ultima cosa che dobbiamo debuggare.",ws,Zt,Un="È possibile eseguire il ciclo di valutazione del <code>Trainer</code> indipendentemente dall’addestramento, in questo modo:",Us,vt,gs,It,$s,$,Cs,kt,gn="Prima di tentare il debug di un problema nel ciclo di valutazione, è necessario assicurarsi di aver dato un’occhiata ai dati, di essere in grado di generare correttamente un batch e di poter eseguire il modello su di esso. Abbiamo completato tutti questi passaggi, quindi il codice seguente può essere eseguito senza errori:",Zs,Bt,vs,Wt,$n="L’errore arriva più tardi, alla fine della fase di valutazione, e se guardiamo il traceback vediamo questo:",Is,Xt,ks,Rt,Cn="Questo ci dice che l’errore ha origine nel modulo <code>datasets/metric.py</code>, quindi si tratta di un problema con la nostra funzione <code>compute_metrics()</code>. La funzione accetta una tupla con i logit e le label come array NumPy, quindi proviamo a dargliela in pasto:",Bs,zt,Ws,Gt,Xs,Vt,Zn="Otteniamo lo stesso errore, quindi il problema risiede sicuramente in quella funzione. Se guardiamo al suo codice, vediamo che sta solo trasferendo le <code>predictions</code> e le <code>labels</code> a <code>metric.compute()</code>. C’è quindi un problema con questo metodo? Non proprio. Diamo una rapida occhiata alle dimensioni:",Rs,_t,zs,Yt,Gs,xt,vn="Le nostre previsioni sono ancora dei logit, non le vere previsioni, ed è per questo che la metrica restituisce questo errore (un po’ oscuro). La soluzione è abbastanza semplice: basta aggiungere un argmax nella funzione <code>compute_metrics()</code>:",Vs,Ft,_s,At,Ys,Ht,In="Ora il nostro errore è stato risolto! Questo era l’ultimo, quindi il nostro script ora addestrerà correttamente un modello.",xs,Qt,kn="Per riferimento, ecco lo script completamente corretto:",Fs,Nt,As,Et,Bn="In questo caso, non ci sono più problemi e il nostro script affinerà un modello che dovrebbe dare risultati ragionevoli. Ma cosa possiamo fare quando l’addestramento procede senza errori e il modello addestrato non funziona affatto bene? Questa è la parte più difficile di machine learning e ti mostreremo alcune tecniche che possono aiutarti.",Hs,C,Qs,qt,Ns,St,Wn="Cosa possiamo fare per eseguire il debug di un addestramento che viene completato senza errori, ma che non produce buoni risultati? Qui ti daremo alcuni suggerimenti, ma sappi che questo tipo di debugging è la parte più difficile di machine learning e non esiste una soluzione magica.",Es,Lt,qs,Dt,Xn="Il tuo modello imparerà qualcosa solo se è effettivamente possibile imparare qualcosa dai tuoi dati. Se c’è un bug che corrompe i dati o le label sono assegnate in modo casuale, è molto probabile che non si riesca ad addestrare il modello sul dataset. Quindi, inizia sempre con un doppio controllo degli input e delle label decodificate e poniti le seguenti domande:",Ss,Pt,Rn="<li>I dati decodificati sono comprensibili?</li> <li>Sei d’accordo con le label?</li> <li>C’è una label più comune delle altre?</li> <li>Quale dovrebbe essere la funzione di perdita/metrica se il modello predicesse una risposta a caso/sempre la stessa risposta?</li>",Ls,Z,Ds,Kt,zn="Dopo aver esaminato i dati, esamina alcune previsioni del modello e decodificale. Se il modello prevede sempre la stessa cosa, potrebbe essere perché il tuo set di dati è influenzato verso una categoria (per i problemi di classificazione); tecniche come fare oversampling (<em>sovra-campionamento</em>) delle classi rare potrebbero aiutare.",Ps,Ot,Gn="Se la funzione di perdita/metrica ottenuta con il tuo modello iniziale è molto diversa da quella che ci si aspetterebbe per le previsioni casuali, ricontrolla il modo in cui viene calcolata la funzione o la metrica, perché probabilmente c’è un bug. Se si utilizzano diverse funzioni che aggiungi alla fine, assicurati che siano della stessa grandezza.",Ks,el,Vn="Quando sei sicuro/a che i dati sono perfetti, puoi verificare se il modello è in grado di addestrarsi su di essi con un semplice test.",Os,tl,ei,ll,_n="L’overfitting è di solito qualcosa che cerchiamo di evitare durante l’addestramento, poiché significa che il modello non sta imparando a riconoscere le proprietà generali che vogliamo, ma sta invece memorizzando i campioni di addestramento. Tuttavia, provare ad addestrare il modello su un batch più e più volte è un buon test per verificare se il problema così come è stato inquadrato può essere risolto dal modello che si sta cercando di addestrare. Inoltre, ti aiuterà a capire se il learning rate (<em>tasso di apprendimento</em>) iniziale è troppo alta.",ti,al,Yn="Una volta definito il <code>Trainer</code>, è molto semplice: basta prendere un batch dal training set, ed eseguire un piccolo ciclo di addestramento manuale utilizzando solo quel batch per qualcosa come 20 step:",li,sl,ai,v,si,il,xn="Il modello risultante dovrebbe avere risultati quasi perfetti sullo stesso <code>batch</code>. Calcoliamo la metrica sulle previsioni risultanti:",ii,nl,ni,rl,ri,ol,Fn="100% di accuratezza, questo è un bell’esempio di overfitting (il che significa che se provi il tuo modello su qualsiasi altra frase, molto probabilmente ti darà una risposta sbagliata)!",oi,pl,An="Se non si riesci a far sì che il modello ottenga risultati perfetti come questo, significa che c’è qualcosa di sbagliato nel modo in cui si è impostato il problema o con i dati, e quindi dovresti risolvere questa cosa. Solo quando riesci a superare il test di overfitting puoi essere sicuro/a che il tuo modello possa effettivamente imparare qualcosa.",pi,I,ci,cl,mi,ml,Hn="Hyperparameter tuning (<em>calibrazione degli iperparametri</em>) è sempre considerato come la parte più difficile di machine learning, ma è solo l’ultimo passo per aiutarti a migliorare un po’ la metrica. Nella maggior parte dei casi, gli iperparametri predefiniti del <code>Trainer</code> funzionano bene per dare buoni risultati, quindi non ci si deve lanciare in una ricerca di iperparametri dispendiosa in termini di tempo e di costi, finché non si è ottenuto qualcosa che batta la baseline (<em>base di partenza</em>) che si ha sul dataset.",di,dl,Qn="Una volta ottenuto un modello sufficientemente buono, si può iniziare a modificarlo un po’. Non provare a eseguire l’addestramento un migliaio di volte con iperparametri diversi, ma confronta un paio di esecuzioni che hanno valori diversi per un iperparametro così da avere un’idea di quale abbia il maggiore impatto.",ui,ul,Nn="Se stai modificando il modello stesso, mantieni le cose semplici e non provare nulla che non possa essere ragionevolmente giustificato. Assicurati sempre di rifare il test di overfitting per verificare che la modifica non abbia avuto conseguenze indesiderate.",Mi,Ml,Ji,Jl,En='Speriamo che in questa sezione tu abbia trovato qualche consiglio utile a risolvere il tuo problema, ma se così non fosse, ricordati che puoi sempre chiedere aiuto alla community nei <a href="https://discuss.huggingface.co/" rel="nofollow">forum</a>.',yi,yl,qn="Qui di seguito sono riportate alcune risorse aggiuntive che potrebbero rivelarsi utili:",bi,bl,Sn='<li><a href="https://docs.google.com/presentation/d/1yHLPvPhUs2KGI5ZWo0sU-PKU3GimAk3iTsI38Z-B5Gw/edit#slide=id.p" rel="nofollow">“Reproducibility as a vehicle for engineering best practices”</a> di Joel Grus</li> <li><a href="https://towardsdatascience.com/checklist-for-debugging-neural-networks-d8b2a9434f21" rel="nofollow">“Checklist for debugging neural networks”</a> di Cecelia Shao</li> <li><a href="https://medium.com/@keeper6928/how-to-unit-test-machine-learning-code-57cf6fd81765" rel="nofollow">“How to unit test machine learning code”</a> di Chase Roberts</li> <li><a href="http://karpathy.github.io/2019/04/25/recipe/" rel="nofollow">“A Recipe for Training Neural Networks”</a> di Andrej Karpathy</li>',Ti,Tl,Ln="Naturalmente, non tutti i problemi che incontrerai durante l’addestramento delle reti neurali sono colpa tua! Se si incontra qualcosa nella libreria 🤗 Transformers o 🤗 Datasets che non sembra corretto, è possibile che si sia trovato un bug. Dovresti assolutamente segnalarcelo e nella prossima sezione ti spiegheremo esattamente come fare.",hi,hl,fi,wl,ji;return w=new Mr({props:{fw:f[0]}}),k=new j({props:{title:"Fare il debug della training pipeline",local:"fare-il-debug-della-training-pipeline",headingTag:"h1"}}),B=new ur({props:{chapter:8,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/it/chapter8/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/it/chapter8/section4.ipynb"}]}}),X=new j({props:{title:"Fare il debug della training pipeline",local:"fare-il-debug-della-training-pipeline",headingTag:"h2"}}),R=new dr({props:{id:"L-WSwUWde1U"}}),_=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, load_metric
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=raw_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=raw_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),x=new y({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBZb3UlMjBoYXZlJTIwdG8lMjBzcGVjaWZ5JTIwZWl0aGVyJTIwaW5wdXRfaWRzJTIwb3IlMjBpbnB1dHNfZW1iZWRzJw==",highlighted:'<span class="hljs-string">&#x27;ValueError: You have to specify either input_ids or inputs_embeds&#x27;</span>',wrap:!1}}),F=new j({props:{title:"Controlla i dati",local:"controlla-i-dati",headingTag:"h3"}}),Q=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RA==",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),N=new y({props:{code:"JTdCJ2h5cG90aGVzaXMnJTNBJTIwJ1Byb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHklMjBhcmUlMjB3aGF0JTIwbWFrZSUyMGNyZWFtJTIwc2tpbW1pbmclMjB3b3JrLiUyMCclMkMlMEElMjAnaWR4JyUzQSUyMDAlMkMlMEElMjAnbGFiZWwnJTNBJTIwMSUyQyUwQSUyMCdwcmVtaXNlJyUzQSUyMCdDb25jZXB0dWFsbHklMjBjcmVhbSUyMHNraW1taW5nJTIwaGFzJTIwdHdvJTIwYmFzaWMlMjBkaW1lbnNpb25zJTIwLSUyMHByb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHkuJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;hypothesis&#x27;</span>: <span class="hljs-string">&#x27;Product and geography are what make cream skimming work. &#x27;</span>,
 <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;premise&#x27;</span>: <span class="hljs-string">&#x27;Conceptually cream skimming has two basic dimensions - product and geography.&#x27;</span>}`,wrap:!1}}),S=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, load_metric
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),D=new y({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0MyUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjAzNykn",highlighted:'<span class="hljs-string">&#x27;ValueError: expected sequence of length 43 at dim 1 (got 37)&#x27;</span>',wrap:!1}}),K=new y({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaA==",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch`,wrap:!1}}),te=new y({props:{code:"dG9rZW5pemVyLmRlY29kZSh0cmFpbmVyLnRyYWluX2RhdGFzZXQlNUIwJTVEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKQ==",highlighted:'tokenizer.decode(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>])',wrap:!1}}),le=new y({props:{code:"JyU1QkNMUyU1RCUyMGNvbmNlcHR1YWxseSUyMGNyZWFtJTIwc2tpbW1pbmclMjBoYXMlMjB0d28lMjBiYXNpYyUyMGRpbWVuc2lvbnMlMjAtJTIwcHJvZHVjdCUyMGFuZCUyMGdlb2dyYXBoeS4lMjAlNUJTRVAlNUQlMjBwcm9kdWN0JTIwYW5kJTIwZ2VvZ3JhcGh5JTIwYXJlJTIwd2hhdCUyMG1ha2UlMjBjcmVhbSUyMHNraW1taW5nJTIwd29yay4lMjAlNUJTRVAlNUQn",highlighted:'<span class="hljs-string">&#x27;[CLS] conceptually cream skimming has two basic dimensions - product and geography. [SEP] product and geography are what make cream skimming work. [SEP]&#x27;</span>',wrap:!1}}),se=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RC5rZXlzKCk=",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>].keys()',wrap:!1}}),ie=new y({props:{code:"ZGljdF9rZXlzKCU1QidhdHRlbnRpb25fbWFzayclMkMlMjAnaHlwb3RoZXNpcyclMkMlMjAnaWR4JyUyQyUyMCdpbnB1dF9pZHMnJTJDJTIwJ2xhYmVsJyUyQyUyMCdwcmVtaXNlJyU1RCk=",highlighted:'dict_keys([<span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;hypothesis&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;premise&#x27;</span>])',wrap:!1}}),re=new y({props:{code:"dHlwZSh0cmFpbmVyLm1vZGVsKQ==",highlighted:'<span class="hljs-built_in">type</span>(trainer.model)',wrap:!1}}),oe=new y({props:{code:"dHJhbnNmb3JtZXJzLm1vZGVscy5kaXN0aWxiZXJ0Lm1vZGVsaW5nX2Rpc3RpbGJlcnQuRGlzdGlsQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24=",highlighted:"transformers.models.distilbert.modeling_distilbert.DistilBertForSequenceClassification",wrap:!1}}),me=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]',wrap:!1}}),de=new y({props:{code:"JTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSU1RA==",highlighted:'[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]',wrap:!1}}),Me=new y({props:{code:"bGVuKHRyYWluZXIudHJhaW5fZGF0YXNldCU1QjAlNUQlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCklMjAlM0QlM0QlMjBsZW4oJTBBJTIwJTIwJTIwJTIwdHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQSk=",highlighted:`<span class="hljs-built_in">len</span>(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]) == <span class="hljs-built_in">len</span>(
    trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>]
)`,wrap:!1}}),Je=new y({props:{code:"VHJ1ZQ==",highlighted:'<span class="hljs-literal">True</span>',wrap:!1}}),be=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmxhYmVsJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;label&quot;</span>]',wrap:!1}}),Te=new y({props:{code:"MQ==",highlighted:'<span class="hljs-number">1</span>',wrap:!1}}),fe=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0LmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXM=",highlighted:'trainer.train_dataset.features[<span class="hljs-string">&quot;label&quot;</span>].names',wrap:!1}}),je=new y({props:{code:"JTVCJ2VudGFpbG1lbnQnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ2NvbnRyYWRpY3Rpb24nJTVE",highlighted:'[<span class="hljs-string">&#x27;entailment&#x27;</span>, <span class="hljs-string">&#x27;neutral&#x27;</span>, <span class="hljs-string">&#x27;contradiction&#x27;</span>]',wrap:!1}}),U=new fl({props:{$$slots:{default:[yr]},$$scope:{ctx:f}}}),Ce=new j({props:{title:"Dai dataset ai dataloader",local:"dai-dataset-ai-dataloader",headingTag:"h3"}}),ve=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),ke=new y({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQSUwQVZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0NSUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjA3Nik=",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch

ValueError: expected sequence of length <span class="hljs-number">45</span> at dim <span class="hljs-number">1</span> (got <span class="hljs-number">76</span>)`,wrap:!1}}),We=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBZGF0YV9jb2xsYXRvcg==",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
data_collator`,wrap:!1}}),Xe=new y({props:{code:"JTNDZnVuY3Rpb24lMjB0cmFuc2Zvcm1lcnMuZGF0YS5kYXRhX2NvbGxhdG9yLmRlZmF1bHRfZGF0YV9jb2xsYXRvcihmZWF0dXJlcyUzQSUyMExpc3QlNUJJbnB1dERhdGFDbGFzcyU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JyklMjAtJTNFJTIwRGljdCU1QnN0ciUyQyUyMEFueSU1RCUzRQ==",highlighted:'&lt;function transformers.data.data_collator.default_data_collator(features: <span class="hljs-type">List</span>[InputDataClass], return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]&gt;',wrap:!1}}),Ge=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, load_metric
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),_e=new y({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ1VEQSUyMGVycm9yJTNBJTIwQ1VCTEFTX1NUQVRVU19BTExPQ19GQUlMRUQlMjB3aGVuJTIwY2FsbGluZyUyMCU2MGN1Ymxhc0NyZWF0ZShoYW5kbGUpJTYw",highlighted:"RuntimeError: CUDA error: CUBLAS_STATUS_ALLOC_FAILED when calling `cublasCreate(handle)`",wrap:!1}}),Fe=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QnRyYWluZXIudHJhaW5fZGF0YXNldCU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSg0KSU1RCk=",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
batch = data_collator([trainer.train_dataset[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),He=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYWN0dWFsX3RyYWluX3NldCUyMCUzRCUyMHRyYWluZXIuX3JlbW92ZV91bnVzZWRfY29sdW1ucyh0cmFpbmVyLnRyYWluX2RhdGFzZXQpJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QmFjdHVhbF90cmFpbl9zZXQlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklNUQp",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
actual_train_set = trainer._remove_unused_columns(trainer.train_dataset)
batch = data_collator([actual_train_set[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),Ee=new j({props:{title:"Passaggio attraverso il modello",local:"passaggio-attraverso-il-modello",headingTag:"h3"}}),Se=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),Oe=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:"outputs = trainer.model.cpu()(**batch)",wrap:!1}}),et=new y({props:{code:"fiUyRi5weWVudiUyRnZlcnNpb25zJTJGMy43LjklMkZlbnZzJTJGYmFzZSUyRmxpYiUyRnB5dGhvbjMuNyUyRnNpdGUtcGFja2FnZXMlMkZ0b3JjaCUyRm5uJTJGZnVuY3Rpb25hbC5weSUyMGluJTIwbmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBzaXplX2F2ZXJhZ2UlMkMlMjBpZ25vcmVfaW5kZXglMkMlMjByZWR1Y2UlMkMlMjByZWR1Y3Rpb24pJTBBJTIwJTIwJTIwMjM4NiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAyMzg3JTIwJTIwJTIwJTIwJTIwaWYlMjBkaW0lMjAlM0QlM0QlMjAyJTNBJTBBLSUzRSUyMDIzODglMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXQlMjAlM0QlMjB0b3JjaC5fQy5fbm4ubmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBfUmVkdWN0aW9uLmdldF9lbnVtKHJlZHVjdGlvbiklMkMlMjBpZ25vcmVfaW5kZXgpJTBBJTIwJTIwJTIwMjM4OSUyMCUyMCUyMCUyMCUyMGVsaWYlMjBkaW0lMjAlM0QlM0QlMjA0JTNBJTBBJTIwJTIwJTIwMjM5MCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldCUyMCUzRCUyMHRvcmNoLl9DLl9ubi5ubGxfbG9zczJkKGlucHV0JTJDJTIwdGFyZ2V0JTJDJTIwd2VpZ2h0JTJDJTIwX1JlZHVjdGlvbi5nZXRfZW51bShyZWR1Y3Rpb24pJTJDJTIwaWdub3JlX2luZGV4KSUwQSUwQUluZGV4RXJyb3IlM0ElMjBUYXJnZXQlMjAyJTIwaXMlMjBvdXQlMjBvZiUyMGJvdW5kcy4=",highlighted:`~/.pyenv/versions/<span class="hljs-number">3.7</span><span class="hljs-number">.9</span>/envs/base/lib/python3<span class="hljs-number">.7</span>/site-packages/torch/nn/functional.py <span class="hljs-keyword">in</span> nll_loss(<span class="hljs-built_in">input</span>, target, weight, size_average, ignore_index, reduce, reduction)
   <span class="hljs-number">2386</span>         )
   <span class="hljs-number">2387</span>     <span class="hljs-keyword">if</span> dim == <span class="hljs-number">2</span>:
-&gt; <span class="hljs-number">2388</span>         ret = torch._C._nn.nll_loss(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)
   <span class="hljs-number">2389</span>     <span class="hljs-keyword">elif</span> dim == <span class="hljs-number">4</span>:
   <span class="hljs-number">2390</span>         ret = torch._C._nn.nll_loss2d(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)

IndexError: Target <span class="hljs-number">2</span> <span class="hljs-keyword">is</span> out of bounds.`,wrap:!1}}),lt=new y({props:{code:"dHJhaW5lci5tb2RlbC5jb25maWcubnVtX2xhYmVscw==",highlighted:"trainer.model.config.num_labels",wrap:!1}}),at=new y({props:{code:"Mg==",highlighted:'<span class="hljs-number">2</span>',wrap:!1}}),it=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, load_metric
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),rt=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBb3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

outputs = trainer.model.cpu()(**batch)`,wrap:!1}}),pt=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQW91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsLnRvKGRldmljZSkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

outputs = trainer.model.to(device)(**batch)`,wrap:!1}}),mt=new j({props:{title:"Esecuzione di un passaggio di ottimizzazione",local:"esecuzione-di-un-passaggio-di-ottimizzazione",headingTag:"h3"}}),Mt=new y({props:{code:"bG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvc3MuYmFja3dhcmQoKQ==",highlighted:`loss = outputs.loss
loss.backward()`,wrap:!1}}),bt=new y({props:{code:"dHJhaW5lci5jcmVhdGVfb3B0aW1pemVyKCklMEF0cmFpbmVyLm9wdGltaXplci5zdGVwKCk=",highlighted:`trainer.create_optimizer()
trainer.optimizer.step()`,wrap:!1}}),ht=new j({props:{title:"Come gestire gli errori out-of-memory di CUDA",local:"come-gestire-gli-errori-out-of-memory-di-cuda",headingTag:"h3"}}),g=new fl({props:{$$slots:{default:[br]},$$scope:{ctx:f}}}),wt=new j({props:{title:"Valutazione del modello",local:"valutazione-del-modello",headingTag:"h3"}}),gt=new y({props:{code:"JTIzJTIwVGhpcyUyMHdpbGwlMjB0YWtlJTIwYSUyMGxvbmclMjB0aW1lJTIwYW5kJTIwZXJyb3IlMjBvdXQlMkMlMjBzbyUyMHlvdSUyMHNob3VsZG4ndCUyMHJ1biUyMHRoaXMlMjBjZWxsJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-comment"># This will take a long time and error out, so you shouldn&#x27;t run this cell</span>
trainer.train()`,wrap:!1}}),$t=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),vt=new y({props:{code:"dHJhaW5lci5ldmFsdWF0ZSgp",highlighted:"trainer.evaluate()",wrap:!1}}),It=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),$=new fl({props:{$$slots:{default:[Tr]},$$scope:{ctx:f}}}),Bt=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X2V2YWxfZGF0YWxvYWRlcigpJTNBJTBBJTIwJTIwJTIwJTIwYnJlYWslMEElMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwdHJhaW5lci5tb2RlbCgqKmJhdGNoKQ==",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_eval_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)`,wrap:!1}}),Xt=new y({props:{code:"fiUyRmdpdCUyRmRhdGFzZXRzJTJGc3JjJTJGZGF0YXNldHMlMkZtZXRyaWMucHklMjBpbiUyMGFkZF9iYXRjaChzZWxmJTJDJTIwcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzKSUwQSUyMCUyMCUyMCUyMDQzMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMDQzMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCJTIycHJlZGljdGlvbnMlMjIlM0ElMjBwcmVkaWN0aW9ucyUyQyUyMCUyMnJlZmVyZW5jZXMlMjIlM0ElMjByZWZlcmVuY2VzJTdEJTBBLS0lM0UlMjA0MzMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMHNlbGYuaW5mby5mZWF0dXJlcy5lbmNvZGVfYmF0Y2goYmF0Y2gpJTBBJTIwJTIwJTIwJTIwNDM0JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLndyaXRlciUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMDQzNSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuX2luaXRfd3JpdGVyKCk=",highlighted:`~/git/datasets/src/datasets/metric.py <span class="hljs-keyword">in</span> add_batch(self, predictions, references)
    <span class="hljs-number">431</span>         <span class="hljs-string">&quot;&quot;&quot;
    432         batch = {&quot;predictions&quot;: predictions, &quot;references&quot;: references}
--&gt; 433         batch = self.info.features.encode_batch(batch)
    434         if self.writer is None:
    435             self._init_writer()</span>`,wrap:!1}}),zt=new y({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cy5jcHUoKS5udW1weSgpJTBBbGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQuY3B1KCkubnVtcHkoKSUwQSUwQWNvbXB1dGVfbWV0cmljcygocHJlZGljdGlvbnMlMkMlMjBsYWJlbHMpKQ==",highlighted:`predictions = outputs.logits.cpu().numpy()
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>].cpu().numpy()

compute_metrics((predictions, labels))`,wrap:!1}}),Gt=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),_t=new y({props:{code:"cHJlZGljdGlvbnMuc2hhcGUlMkMlMjBsYWJlbHMuc2hhcGU=",highlighted:"predictions.shape, labels.shape",wrap:!1}}),Yt=new y({props:{code:"KCg4JTJDJTIwMyklMkMlMjAoOCUyQykp",highlighted:'((<span class="hljs-number">8</span>, <span class="hljs-number">3</span>), (<span class="hljs-number">8</span>,))',wrap:!1}}),Ft=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMpJTBBJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkaWN0aW9ucyUyQyUyMGxhYmVscykp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


compute_metrics((predictions, labels))`,wrap:!1}}),At=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuNjI1JTdE",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.625</span>}',wrap:!1}}),Nt=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, load_metric
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),C=new fl({props:{$$slots:{default:[hr]},$$scope:{ctx:f}}}),qt=new j({props:{title:"Debug degli errori silenziosi durante l’addestramento",local:"debug-degli-errori-silenziosi-durante-laddestramento",headingTag:"h2"}}),Lt=new j({props:{title:"Controllare i dati (di nuovo!)",local:"controllare-i-dati-di-nuovo",headingTag:"h3"}}),Z=new fl({props:{warning:!0,$$slots:{default:[fr]},$$scope:{ctx:f}}}),tl=new j({props:{title:"Fare overfitting del modello su un batch",local:"fare-overfitting-del-modello-su-un-batch",headingTag:"h3"}}),sl=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEF0cmFpbmVyLmNyZWF0ZV9vcHRpbWl6ZXIoKSUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDIwKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnplcm9fZ3JhZCgp",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
trainer.create_optimizer()

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">20</span>):
    outputs = trainer.model(**batch)
    loss = outputs.loss
    loss.backward()
    trainer.optimizer.step()
    trainer.optimizer.zero_grad()`,wrap:!1}}),v=new fl({props:{$$slots:{default:[jr]},$$scope:{ctx:f}}}),nl=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBcHJlZHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxhYmVscyUyMCUzRCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkcy5jcHUoKS5udW1weSgpJTJDJTIwbGFiZWxzLmNwdSgpLm51bXB5KCkpKQ==",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)
preds = outputs.logits
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>]

compute_metrics((preds.cpu().numpy(), labels.cpu().numpy()))`,wrap:!1}}),rl=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDEuMCU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">1.0</span>}',wrap:!1}}),I=new fl({props:{warning:!0,$$slots:{default:[wr]},$$scope:{ctx:f}}}),cl=new j({props:{title:"Non calibrare niente prima di avere una prima baseline",local:"non-calibrare-niente-prima-di-avere-una-prima-baseline",headingTag:"h3"}}),Ml=new j({props:{title:"Chiedere aiuto",local:"chiedere-aiuto",headingTag:"h3"}}),hl=new Jr({props:{source:"https://github.com/huggingface/course/blob/main/chapters/it/chapter8/4.mdx"}}),{c(){J=n("meta"),T=s(),b=n("p"),h=s(),p(w.$$.fragment),Ul=s(),p(k.$$.fragment),gl=s(),p(B.$$.fragment),$l=s(),W=n("p"),W.innerHTML=wi,Cl=s(),p(X.$$.fragment),Zl=s(),p(R.$$.fragment),vl=s(),z=n("p"),z.innerHTML=Ui,Il=s(),G=n("p"),G.innerHTML=gi,kl=s(),V=n("p"),V.innerHTML=$i,Bl=s(),p(_.$$.fragment),Wl=s(),Y=n("p"),Y.textContent=Ci,Xl=s(),p(x.$$.fragment),Rl=s(),p(F.$$.fragment),zl=s(),A=n("p"),A.innerHTML=Zi,Gl=s(),H=n("p"),H.innerHTML=vi,Vl=s(),p(Q.$$.fragment),_l=s(),p(N.$$.fragment),Yl=s(),E=n("p"),E.innerHTML=Ii,xl=s(),q=n("p"),q.innerHTML=ki,Fl=s(),p(S.$$.fragment),Al=s(),L=n("p"),L.textContent=Bi,Hl=s(),p(D.$$.fragment),Ql=s(),P=n("p"),P.textContent=Wi,Nl=s(),p(K.$$.fragment),El=s(),O=n("p"),O.textContent=Xi,ql=s(),ee=n("p"),ee.textContent=Ri,Sl=s(),p(te.$$.fragment),Ll=s(),p(le.$$.fragment),Dl=s(),ae=n("p"),ae.textContent=zi,Pl=s(),p(se.$$.fragment),Kl=s(),p(ie.$$.fragment),Ol=s(),ne=n("p"),ne.innerHTML=Gi,ea=s(),p(re.$$.fragment),ta=s(),p(oe.$$.fragment),la=s(),pe=n("p"),pe.innerHTML=Vi,aa=s(),ce=n("p"),ce.innerHTML=_i,sa=s(),p(me.$$.fragment),ia=s(),p(de.$$.fragment),na=s(),ue=n("p"),ue.innerHTML=Yi,ra=s(),p(Me.$$.fragment),oa=s(),p(Je.$$.fragment),pa=s(),ye=n("p"),ye.textContent=xi,ca=s(),p(be.$$.fragment),ma=s(),p(Te.$$.fragment),da=s(),he=n("p"),he.innerHTML=Fi,ua=s(),p(fe.$$.fragment),Ma=s(),p(je.$$.fragment),Ja=s(),we=n("p"),we.innerHTML=Ai,ya=s(),Ue=n("p"),Ue.innerHTML=Hi,ba=s(),p(U.$$.fragment),Ta=s(),ge=n("p"),ge.textContent=Qi,ha=s(),$e=n("p"),$e.textContent=Ni,fa=s(),p(Ce.$$.fragment),ja=s(),Ze=n("p"),Ze.innerHTML=Ei,wa=s(),p(ve.$$.fragment),Ua=s(),Ie=n("p"),Ie.innerHTML=qi,ga=s(),p(ke.$$.fragment),$a=s(),Be=n("p"),Be.innerHTML=Si,Ca=s(),p(We.$$.fragment),Za=s(),p(Xe.$$.fragment),va=s(),Re=n("p"),Re.innerHTML=Li,Ia=s(),ze=n("p"),ze.innerHTML=Di,ka=s(),p(Ge.$$.fragment),Ba=s(),Ve=n("p"),Ve.textContent=Pi,Wa=s(),p(_e.$$.fragment),Xa=s(),Ye=n("p"),Ye.textContent=Ki,Ra=s(),xe=n("p"),xe.textContent=Oi,za=s(),p(Fe.$$.fragment),Ga=s(),Ae=n("p"),Ae.innerHTML=en,Va=s(),p(He.$$.fragment),_a=s(),Qe=n("p"),Qe.textContent=tn,Ya=s(),Ne=n("p"),Ne.textContent=ln,xa=s(),p(Ee.$$.fragment),Fa=s(),qe=n("p"),qe.textContent=an,Aa=s(),p(Se.$$.fragment),Ha=s(),Le=n("p"),Le.innerHTML=sn,Qa=s(),De=n("p"),De.innerHTML=nn,Na=s(),Pe=n("p"),Pe.textContent=rn,Ea=s(),Ke=n("p"),Ke.innerHTML=on,qa=s(),p(Oe.$$.fragment),Sa=s(),p(et.$$.fragment),La=s(),tt=n("p"),tt.innerHTML=pn,Da=s(),p(lt.$$.fragment),Pa=s(),p(at.$$.fragment),Ka=s(),st=n("p"),st.textContent=cn,Oa=s(),p(it.$$.fragment),es=s(),nt=n("p"),nt.innerHTML=mn,ts=s(),p(rt.$$.fragment),ls=s(),ot=n("p"),ot.textContent=dn,as=s(),p(pt.$$.fragment),ss=s(),ct=n("p"),ct.textContent=un,is=s(),p(mt.$$.fragment),ns=s(),dt=n("p"),dt.textContent=Mn,rs=s(),ut=n("p"),ut.innerHTML=Jn,os=s(),p(Mt.$$.fragment),ps=s(),Jt=n("p"),Jt.textContent=yn,cs=s(),yt=n("p"),yt.innerHTML=bn,ms=s(),p(bt.$$.fragment),ds=s(),Tt=n("p"),Tt.innerHTML=Tn,us=s(),p(ht.$$.fragment),Ms=s(),ft=n("p"),ft.innerHTML=hn,Js=s(),jt=n("p"),jt.textContent=fn,ys=s(),p(g.$$.fragment),bs=s(),p(wt.$$.fragment),Ts=s(),Ut=n("p"),Ut.innerHTML=jn,hs=s(),p(gt.$$.fragment),fs=s(),p($t.$$.fragment),js=s(),Ct=n("p"),Ct.textContent=wn,ws=s(),Zt=n("p"),Zt.innerHTML=Un,Us=s(),p(vt.$$.fragment),gs=s(),p(It.$$.fragment),$s=s(),p($.$$.fragment),Cs=s(),kt=n("p"),kt.textContent=gn,Zs=s(),p(Bt.$$.fragment),vs=s(),Wt=n("p"),Wt.textContent=$n,Is=s(),p(Xt.$$.fragment),ks=s(),Rt=n("p"),Rt.innerHTML=Cn,Bs=s(),p(zt.$$.fragment),Ws=s(),p(Gt.$$.fragment),Xs=s(),Vt=n("p"),Vt.innerHTML=Zn,Rs=s(),p(_t.$$.fragment),zs=s(),p(Yt.$$.fragment),Gs=s(),xt=n("p"),xt.innerHTML=vn,Vs=s(),p(Ft.$$.fragment),_s=s(),p(At.$$.fragment),Ys=s(),Ht=n("p"),Ht.textContent=In,xs=s(),Qt=n("p"),Qt.textContent=kn,Fs=s(),p(Nt.$$.fragment),As=s(),Et=n("p"),Et.textContent=Bn,Hs=s(),p(C.$$.fragment),Qs=s(),p(qt.$$.fragment),Ns=s(),St=n("p"),St.textContent=Wn,Es=s(),p(Lt.$$.fragment),qs=s(),Dt=n("p"),Dt.textContent=Xn,Ss=s(),Pt=n("ul"),Pt.innerHTML=Rn,Ls=s(),p(Z.$$.fragment),Ds=s(),Kt=n("p"),Kt.innerHTML=zn,Ps=s(),Ot=n("p"),Ot.textContent=Gn,Ks=s(),el=n("p"),el.textContent=Vn,Os=s(),p(tl.$$.fragment),ei=s(),ll=n("p"),ll.innerHTML=_n,ti=s(),al=n("p"),al.innerHTML=Yn,li=s(),p(sl.$$.fragment),ai=s(),p(v.$$.fragment),si=s(),il=n("p"),il.innerHTML=xn,ii=s(),p(nl.$$.fragment),ni=s(),p(rl.$$.fragment),ri=s(),ol=n("p"),ol.textContent=Fn,oi=s(),pl=n("p"),pl.textContent=An,pi=s(),p(I.$$.fragment),ci=s(),p(cl.$$.fragment),mi=s(),ml=n("p"),ml.innerHTML=Hn,di=s(),dl=n("p"),dl.textContent=Qn,ui=s(),ul=n("p"),ul.textContent=Nn,Mi=s(),p(Ml.$$.fragment),Ji=s(),Jl=n("p"),Jl.innerHTML=En,yi=s(),yl=n("p"),yl.textContent=qn,bi=s(),bl=n("ul"),bl.innerHTML=Sn,Ti=s(),Tl=n("p"),Tl.textContent=Ln,hi=s(),p(hl.$$.fragment),fi=s(),wl=n("p"),this.h()},l(e){const t=cr("svelte-u9bgzb",document.head);J=r(t,"META",{name:!0,content:!0}),t.forEach(l),T=i(e),b=r(e,"P",{}),sr(b).forEach(l),h=i(e),c(w.$$.fragment,e),Ul=i(e),c(k.$$.fragment,e),gl=i(e),c(B.$$.fragment,e),$l=i(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-oons04"&&(W.innerHTML=wi),Cl=i(e),c(X.$$.fragment,e),Zl=i(e),c(R.$$.fragment,e),vl=i(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-yuehgd"&&(z.innerHTML=Ui),Il=i(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1vfby3"&&(G.innerHTML=gi),kl=i(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-n2uzsr"&&(V.innerHTML=$i),Bl=i(e),c(_.$$.fragment,e),Wl=i(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1142yq6"&&(Y.textContent=Ci),Xl=i(e),c(x.$$.fragment,e),Rl=i(e),c(F.$$.fragment,e),zl=i(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-d33wq2"&&(A.innerHTML=Zi),Gl=i(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-135ov84"&&(H.innerHTML=vi),Vl=i(e),c(Q.$$.fragment,e),_l=i(e),c(N.$$.fragment,e),Yl=i(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-cqtrap"&&(E.innerHTML=Ii),xl=i(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1u5e5w1"&&(q.innerHTML=ki),Fl=i(e),c(S.$$.fragment,e),Al=i(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1f2dpvs"&&(L.textContent=Bi),Hl=i(e),c(D.$$.fragment,e),Ql=i(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-10dlgl9"&&(P.textContent=Wi),Nl=i(e),c(K.$$.fragment,e),El=i(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1smbcnr"&&(O.textContent=Xi),ql=i(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1qi5643"&&(ee.textContent=Ri),Sl=i(e),c(te.$$.fragment,e),Ll=i(e),c(le.$$.fragment,e),Dl=i(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-2lxf0o"&&(ae.textContent=zi),Pl=i(e),c(se.$$.fragment,e),Kl=i(e),c(ie.$$.fragment,e),Ol=i(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-p2ursw"&&(ne.innerHTML=Gi),ea=i(e),c(re.$$.fragment,e),ta=i(e),c(oe.$$.fragment,e),la=i(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-v4xkk"&&(pe.innerHTML=Vi),aa=i(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1104rpz"&&(ce.innerHTML=_i),sa=i(e),c(me.$$.fragment,e),ia=i(e),c(de.$$.fragment,e),na=i(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-16pihx1"&&(ue.innerHTML=Yi),ra=i(e),c(Me.$$.fragment,e),oa=i(e),c(Je.$$.fragment,e),pa=i(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1cfu9nl"&&(ye.textContent=xi),ca=i(e),c(be.$$.fragment,e),ma=i(e),c(Te.$$.fragment,e),da=i(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-12oyv9w"&&(he.innerHTML=Fi),ua=i(e),c(fe.$$.fragment,e),Ma=i(e),c(je.$$.fragment,e),Ja=i(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1ph2bbc"&&(we.innerHTML=Ai),ya=i(e),Ue=r(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-io8wo7"&&(Ue.innerHTML=Hi),ba=i(e),c(U.$$.fragment,e),Ta=i(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1f8l9un"&&(ge.textContent=Qi),ha=i(e),$e=r(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1wcpo2k"&&($e.textContent=Ni),fa=i(e),c(Ce.$$.fragment,e),ja=i(e),Ze=r(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1qbf1v6"&&(Ze.innerHTML=Ei),wa=i(e),c(ve.$$.fragment,e),Ua=i(e),Ie=r(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-cm85vj"&&(Ie.innerHTML=qi),ga=i(e),c(ke.$$.fragment,e),$a=i(e),Be=r(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1wuui5u"&&(Be.innerHTML=Si),Ca=i(e),c(We.$$.fragment,e),Za=i(e),c(Xe.$$.fragment,e),va=i(e),Re=r(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-dg70m6"&&(Re.innerHTML=Li),Ia=i(e),ze=r(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1azvl87"&&(ze.innerHTML=Di),ka=i(e),c(Ge.$$.fragment,e),Ba=i(e),Ve=r(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-o804dd"&&(Ve.textContent=Pi),Wa=i(e),c(_e.$$.fragment,e),Xa=i(e),Ye=r(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-11eb86j"&&(Ye.textContent=Ki),Ra=i(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-c3yr03"&&(xe.textContent=Oi),za=i(e),c(Fe.$$.fragment,e),Ga=i(e),Ae=r(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-10f6kik"&&(Ae.innerHTML=en),Va=i(e),c(He.$$.fragment,e),_a=i(e),Qe=r(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1qy836m"&&(Qe.textContent=tn),Ya=i(e),Ne=r(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1jxb9re"&&(Ne.textContent=ln),xa=i(e),c(Ee.$$.fragment,e),Fa=i(e),qe=r(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1jo2f0k"&&(qe.textContent=an),Aa=i(e),c(Se.$$.fragment,e),Ha=i(e),Le=r(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1nf53su"&&(Le.innerHTML=sn),Qa=i(e),De=r(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-1m58vxq"&&(De.innerHTML=nn),Na=i(e),Pe=r(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-1l13w1c"&&(Pe.textContent=rn),Ea=i(e),Ke=r(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-1o77zbp"&&(Ke.innerHTML=on),qa=i(e),c(Oe.$$.fragment,e),Sa=i(e),c(et.$$.fragment,e),La=i(e),tt=r(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-7af71d"&&(tt.innerHTML=pn),Da=i(e),c(lt.$$.fragment,e),Pa=i(e),c(at.$$.fragment,e),Ka=i(e),st=r(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-r6vhnq"&&(st.textContent=cn),Oa=i(e),c(it.$$.fragment,e),es=i(e),nt=r(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-utmeky"&&(nt.innerHTML=mn),ts=i(e),c(rt.$$.fragment,e),ls=i(e),ot=r(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-dq73ex"&&(ot.textContent=dn),as=i(e),c(pt.$$.fragment,e),ss=i(e),ct=r(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-gwlw2w"&&(ct.textContent=un),is=i(e),c(mt.$$.fragment,e),ns=i(e),dt=r(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-16nyvye"&&(dt.textContent=Mn),rs=i(e),ut=r(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-12vqrqe"&&(ut.innerHTML=Jn),os=i(e),c(Mt.$$.fragment,e),ps=i(e),Jt=r(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-yiimkc"&&(Jt.textContent=yn),cs=i(e),yt=r(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-xg78hk"&&(yt.innerHTML=bn),ms=i(e),c(bt.$$.fragment,e),ds=i(e),Tt=r(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-7wvbov"&&(Tt.innerHTML=Tn),us=i(e),c(ht.$$.fragment,e),Ms=i(e),ft=r(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1xjgmfh"&&(ft.innerHTML=hn),Js=i(e),jt=r(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-z9hjuk"&&(jt.textContent=fn),ys=i(e),c(g.$$.fragment,e),bs=i(e),c(wt.$$.fragment,e),Ts=i(e),Ut=r(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-7dspo7"&&(Ut.innerHTML=jn),hs=i(e),c(gt.$$.fragment,e),fs=i(e),c($t.$$.fragment,e),js=i(e),Ct=r(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-103takw"&&(Ct.textContent=wn),ws=i(e),Zt=r(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-cpi9zs"&&(Zt.innerHTML=Un),Us=i(e),c(vt.$$.fragment,e),gs=i(e),c(It.$$.fragment,e),$s=i(e),c($.$$.fragment,e),Cs=i(e),kt=r(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-18r78mm"&&(kt.textContent=gn),Zs=i(e),c(Bt.$$.fragment,e),vs=i(e),Wt=r(e,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-12a6eh4"&&(Wt.textContent=$n),Is=i(e),c(Xt.$$.fragment,e),ks=i(e),Rt=r(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-1fz7k57"&&(Rt.innerHTML=Cn),Bs=i(e),c(zt.$$.fragment,e),Ws=i(e),c(Gt.$$.fragment,e),Xs=i(e),Vt=r(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-noq9wi"&&(Vt.innerHTML=Zn),Rs=i(e),c(_t.$$.fragment,e),zs=i(e),c(Yt.$$.fragment,e),Gs=i(e),xt=r(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1lqh3e1"&&(xt.innerHTML=vn),Vs=i(e),c(Ft.$$.fragment,e),_s=i(e),c(At.$$.fragment,e),Ys=i(e),Ht=r(e,"P",{"data-svelte-h":!0}),o(Ht)!=="svelte-lt88y"&&(Ht.textContent=In),xs=i(e),Qt=r(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-1rw0eah"&&(Qt.textContent=kn),Fs=i(e),c(Nt.$$.fragment,e),As=i(e),Et=r(e,"P",{"data-svelte-h":!0}),o(Et)!=="svelte-1yq201f"&&(Et.textContent=Bn),Hs=i(e),c(C.$$.fragment,e),Qs=i(e),c(qt.$$.fragment,e),Ns=i(e),St=r(e,"P",{"data-svelte-h":!0}),o(St)!=="svelte-r6p8wy"&&(St.textContent=Wn),Es=i(e),c(Lt.$$.fragment,e),qs=i(e),Dt=r(e,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-juxokd"&&(Dt.textContent=Xn),Ss=i(e),Pt=r(e,"UL",{"data-svelte-h":!0}),o(Pt)!=="svelte-1ygrnog"&&(Pt.innerHTML=Rn),Ls=i(e),c(Z.$$.fragment,e),Ds=i(e),Kt=r(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-n5w149"&&(Kt.innerHTML=zn),Ps=i(e),Ot=r(e,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-1dmtka"&&(Ot.textContent=Gn),Ks=i(e),el=r(e,"P",{"data-svelte-h":!0}),o(el)!=="svelte-wddm9m"&&(el.textContent=Vn),Os=i(e),c(tl.$$.fragment,e),ei=i(e),ll=r(e,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-x29dj2"&&(ll.innerHTML=_n),ti=i(e),al=r(e,"P",{"data-svelte-h":!0}),o(al)!=="svelte-d51vi8"&&(al.innerHTML=Yn),li=i(e),c(sl.$$.fragment,e),ai=i(e),c(v.$$.fragment,e),si=i(e),il=r(e,"P",{"data-svelte-h":!0}),o(il)!=="svelte-13qqe72"&&(il.innerHTML=xn),ii=i(e),c(nl.$$.fragment,e),ni=i(e),c(rl.$$.fragment,e),ri=i(e),ol=r(e,"P",{"data-svelte-h":!0}),o(ol)!=="svelte-ugnqo2"&&(ol.textContent=Fn),oi=i(e),pl=r(e,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-1luvbcs"&&(pl.textContent=An),pi=i(e),c(I.$$.fragment,e),ci=i(e),c(cl.$$.fragment,e),mi=i(e),ml=r(e,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-gth42h"&&(ml.innerHTML=Hn),di=i(e),dl=r(e,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-1ytlvoo"&&(dl.textContent=Qn),ui=i(e),ul=r(e,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-1q3oxbc"&&(ul.textContent=Nn),Mi=i(e),c(Ml.$$.fragment,e),Ji=i(e),Jl=r(e,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-1824t5s"&&(Jl.innerHTML=En),yi=i(e),yl=r(e,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-1guizfr"&&(yl.textContent=qn),bi=i(e),bl=r(e,"UL",{"data-svelte-h":!0}),o(bl)!=="svelte-rloazi"&&(bl.innerHTML=Sn),Ti=i(e),Tl=r(e,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-14oh3jw"&&(Tl.textContent=Ln),hi=i(e),c(hl.$$.fragment,e),fi=i(e),wl=r(e,"P",{}),sr(wl).forEach(l),this.h()},h(){ir(J,"name","hf:doc:metadata"),ir(J,"content",gr)},m(e,t){mr(document.head,J),a(e,T,t),a(e,b,t),a(e,h,t),m(w,e,t),a(e,Ul,t),m(k,e,t),a(e,gl,t),m(B,e,t),a(e,$l,t),a(e,W,t),a(e,Cl,t),m(X,e,t),a(e,Zl,t),m(R,e,t),a(e,vl,t),a(e,z,t),a(e,Il,t),a(e,G,t),a(e,kl,t),a(e,V,t),a(e,Bl,t),m(_,e,t),a(e,Wl,t),a(e,Y,t),a(e,Xl,t),m(x,e,t),a(e,Rl,t),m(F,e,t),a(e,zl,t),a(e,A,t),a(e,Gl,t),a(e,H,t),a(e,Vl,t),m(Q,e,t),a(e,_l,t),m(N,e,t),a(e,Yl,t),a(e,E,t),a(e,xl,t),a(e,q,t),a(e,Fl,t),m(S,e,t),a(e,Al,t),a(e,L,t),a(e,Hl,t),m(D,e,t),a(e,Ql,t),a(e,P,t),a(e,Nl,t),m(K,e,t),a(e,El,t),a(e,O,t),a(e,ql,t),a(e,ee,t),a(e,Sl,t),m(te,e,t),a(e,Ll,t),m(le,e,t),a(e,Dl,t),a(e,ae,t),a(e,Pl,t),m(se,e,t),a(e,Kl,t),m(ie,e,t),a(e,Ol,t),a(e,ne,t),a(e,ea,t),m(re,e,t),a(e,ta,t),m(oe,e,t),a(e,la,t),a(e,pe,t),a(e,aa,t),a(e,ce,t),a(e,sa,t),m(me,e,t),a(e,ia,t),m(de,e,t),a(e,na,t),a(e,ue,t),a(e,ra,t),m(Me,e,t),a(e,oa,t),m(Je,e,t),a(e,pa,t),a(e,ye,t),a(e,ca,t),m(be,e,t),a(e,ma,t),m(Te,e,t),a(e,da,t),a(e,he,t),a(e,ua,t),m(fe,e,t),a(e,Ma,t),m(je,e,t),a(e,Ja,t),a(e,we,t),a(e,ya,t),a(e,Ue,t),a(e,ba,t),m(U,e,t),a(e,Ta,t),a(e,ge,t),a(e,ha,t),a(e,$e,t),a(e,fa,t),m(Ce,e,t),a(e,ja,t),a(e,Ze,t),a(e,wa,t),m(ve,e,t),a(e,Ua,t),a(e,Ie,t),a(e,ga,t),m(ke,e,t),a(e,$a,t),a(e,Be,t),a(e,Ca,t),m(We,e,t),a(e,Za,t),m(Xe,e,t),a(e,va,t),a(e,Re,t),a(e,Ia,t),a(e,ze,t),a(e,ka,t),m(Ge,e,t),a(e,Ba,t),a(e,Ve,t),a(e,Wa,t),m(_e,e,t),a(e,Xa,t),a(e,Ye,t),a(e,Ra,t),a(e,xe,t),a(e,za,t),m(Fe,e,t),a(e,Ga,t),a(e,Ae,t),a(e,Va,t),m(He,e,t),a(e,_a,t),a(e,Qe,t),a(e,Ya,t),a(e,Ne,t),a(e,xa,t),m(Ee,e,t),a(e,Fa,t),a(e,qe,t),a(e,Aa,t),m(Se,e,t),a(e,Ha,t),a(e,Le,t),a(e,Qa,t),a(e,De,t),a(e,Na,t),a(e,Pe,t),a(e,Ea,t),a(e,Ke,t),a(e,qa,t),m(Oe,e,t),a(e,Sa,t),m(et,e,t),a(e,La,t),a(e,tt,t),a(e,Da,t),m(lt,e,t),a(e,Pa,t),m(at,e,t),a(e,Ka,t),a(e,st,t),a(e,Oa,t),m(it,e,t),a(e,es,t),a(e,nt,t),a(e,ts,t),m(rt,e,t),a(e,ls,t),a(e,ot,t),a(e,as,t),m(pt,e,t),a(e,ss,t),a(e,ct,t),a(e,is,t),m(mt,e,t),a(e,ns,t),a(e,dt,t),a(e,rs,t),a(e,ut,t),a(e,os,t),m(Mt,e,t),a(e,ps,t),a(e,Jt,t),a(e,cs,t),a(e,yt,t),a(e,ms,t),m(bt,e,t),a(e,ds,t),a(e,Tt,t),a(e,us,t),m(ht,e,t),a(e,Ms,t),a(e,ft,t),a(e,Js,t),a(e,jt,t),a(e,ys,t),m(g,e,t),a(e,bs,t),m(wt,e,t),a(e,Ts,t),a(e,Ut,t),a(e,hs,t),m(gt,e,t),a(e,fs,t),m($t,e,t),a(e,js,t),a(e,Ct,t),a(e,ws,t),a(e,Zt,t),a(e,Us,t),m(vt,e,t),a(e,gs,t),m(It,e,t),a(e,$s,t),m($,e,t),a(e,Cs,t),a(e,kt,t),a(e,Zs,t),m(Bt,e,t),a(e,vs,t),a(e,Wt,t),a(e,Is,t),m(Xt,e,t),a(e,ks,t),a(e,Rt,t),a(e,Bs,t),m(zt,e,t),a(e,Ws,t),m(Gt,e,t),a(e,Xs,t),a(e,Vt,t),a(e,Rs,t),m(_t,e,t),a(e,zs,t),m(Yt,e,t),a(e,Gs,t),a(e,xt,t),a(e,Vs,t),m(Ft,e,t),a(e,_s,t),m(At,e,t),a(e,Ys,t),a(e,Ht,t),a(e,xs,t),a(e,Qt,t),a(e,Fs,t),m(Nt,e,t),a(e,As,t),a(e,Et,t),a(e,Hs,t),m(C,e,t),a(e,Qs,t),m(qt,e,t),a(e,Ns,t),a(e,St,t),a(e,Es,t),m(Lt,e,t),a(e,qs,t),a(e,Dt,t),a(e,Ss,t),a(e,Pt,t),a(e,Ls,t),m(Z,e,t),a(e,Ds,t),a(e,Kt,t),a(e,Ps,t),a(e,Ot,t),a(e,Ks,t),a(e,el,t),a(e,Os,t),m(tl,e,t),a(e,ei,t),a(e,ll,t),a(e,ti,t),a(e,al,t),a(e,li,t),m(sl,e,t),a(e,ai,t),m(v,e,t),a(e,si,t),a(e,il,t),a(e,ii,t),m(nl,e,t),a(e,ni,t),m(rl,e,t),a(e,ri,t),a(e,ol,t),a(e,oi,t),a(e,pl,t),a(e,pi,t),m(I,e,t),a(e,ci,t),m(cl,e,t),a(e,mi,t),a(e,ml,t),a(e,di,t),a(e,dl,t),a(e,ui,t),a(e,ul,t),a(e,Mi,t),m(Ml,e,t),a(e,Ji,t),a(e,Jl,t),a(e,yi,t),a(e,yl,t),a(e,bi,t),a(e,bl,t),a(e,Ti,t),a(e,Tl,t),a(e,hi,t),m(hl,e,t),a(e,fi,t),a(e,wl,t),ji=!0},p(e,[t]){const Dn={};t&1&&(Dn.fw=e[0]),w.$set(Dn);const Pn={};t&2&&(Pn.$$scope={dirty:t,ctx:e}),U.$set(Pn);const Kn={};t&2&&(Kn.$$scope={dirty:t,ctx:e}),g.$set(Kn);const On={};t&2&&(On.$$scope={dirty:t,ctx:e}),$.$set(On);const er={};t&2&&(er.$$scope={dirty:t,ctx:e}),C.$set(er);const tr={};t&2&&(tr.$$scope={dirty:t,ctx:e}),Z.$set(tr);const lr={};t&2&&(lr.$$scope={dirty:t,ctx:e}),v.$set(lr);const ar={};t&2&&(ar.$$scope={dirty:t,ctx:e}),I.$set(ar)},i(e){ji||(d(w.$$.fragment,e),d(k.$$.fragment,e),d(B.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(_.$$.fragment,e),d(x.$$.fragment,e),d(F.$$.fragment,e),d(Q.$$.fragment,e),d(N.$$.fragment,e),d(S.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(oe.$$.fragment,e),d(me.$$.fragment,e),d(de.$$.fragment,e),d(Me.$$.fragment,e),d(Je.$$.fragment,e),d(be.$$.fragment,e),d(Te.$$.fragment,e),d(fe.$$.fragment,e),d(je.$$.fragment,e),d(U.$$.fragment,e),d(Ce.$$.fragment,e),d(ve.$$.fragment,e),d(ke.$$.fragment,e),d(We.$$.fragment,e),d(Xe.$$.fragment,e),d(Ge.$$.fragment,e),d(_e.$$.fragment,e),d(Fe.$$.fragment,e),d(He.$$.fragment,e),d(Ee.$$.fragment,e),d(Se.$$.fragment,e),d(Oe.$$.fragment,e),d(et.$$.fragment,e),d(lt.$$.fragment,e),d(at.$$.fragment,e),d(it.$$.fragment,e),d(rt.$$.fragment,e),d(pt.$$.fragment,e),d(mt.$$.fragment,e),d(Mt.$$.fragment,e),d(bt.$$.fragment,e),d(ht.$$.fragment,e),d(g.$$.fragment,e),d(wt.$$.fragment,e),d(gt.$$.fragment,e),d($t.$$.fragment,e),d(vt.$$.fragment,e),d(It.$$.fragment,e),d($.$$.fragment,e),d(Bt.$$.fragment,e),d(Xt.$$.fragment,e),d(zt.$$.fragment,e),d(Gt.$$.fragment,e),d(_t.$$.fragment,e),d(Yt.$$.fragment,e),d(Ft.$$.fragment,e),d(At.$$.fragment,e),d(Nt.$$.fragment,e),d(C.$$.fragment,e),d(qt.$$.fragment,e),d(Lt.$$.fragment,e),d(Z.$$.fragment,e),d(tl.$$.fragment,e),d(sl.$$.fragment,e),d(v.$$.fragment,e),d(nl.$$.fragment,e),d(rl.$$.fragment,e),d(I.$$.fragment,e),d(cl.$$.fragment,e),d(Ml.$$.fragment,e),d(hl.$$.fragment,e),ji=!0)},o(e){u(w.$$.fragment,e),u(k.$$.fragment,e),u(B.$$.fragment,e),u(X.$$.fragment,e),u(R.$$.fragment,e),u(_.$$.fragment,e),u(x.$$.fragment,e),u(F.$$.fragment,e),u(Q.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(oe.$$.fragment,e),u(me.$$.fragment,e),u(de.$$.fragment,e),u(Me.$$.fragment,e),u(Je.$$.fragment,e),u(be.$$.fragment,e),u(Te.$$.fragment,e),u(fe.$$.fragment,e),u(je.$$.fragment,e),u(U.$$.fragment,e),u(Ce.$$.fragment,e),u(ve.$$.fragment,e),u(ke.$$.fragment,e),u(We.$$.fragment,e),u(Xe.$$.fragment,e),u(Ge.$$.fragment,e),u(_e.$$.fragment,e),u(Fe.$$.fragment,e),u(He.$$.fragment,e),u(Ee.$$.fragment,e),u(Se.$$.fragment,e),u(Oe.$$.fragment,e),u(et.$$.fragment,e),u(lt.$$.fragment,e),u(at.$$.fragment,e),u(it.$$.fragment,e),u(rt.$$.fragment,e),u(pt.$$.fragment,e),u(mt.$$.fragment,e),u(Mt.$$.fragment,e),u(bt.$$.fragment,e),u(ht.$$.fragment,e),u(g.$$.fragment,e),u(wt.$$.fragment,e),u(gt.$$.fragment,e),u($t.$$.fragment,e),u(vt.$$.fragment,e),u(It.$$.fragment,e),u($.$$.fragment,e),u(Bt.$$.fragment,e),u(Xt.$$.fragment,e),u(zt.$$.fragment,e),u(Gt.$$.fragment,e),u(_t.$$.fragment,e),u(Yt.$$.fragment,e),u(Ft.$$.fragment,e),u(At.$$.fragment,e),u(Nt.$$.fragment,e),u(C.$$.fragment,e),u(qt.$$.fragment,e),u(Lt.$$.fragment,e),u(Z.$$.fragment,e),u(tl.$$.fragment,e),u(sl.$$.fragment,e),u(v.$$.fragment,e),u(nl.$$.fragment,e),u(rl.$$.fragment,e),u(I.$$.fragment,e),u(cl.$$.fragment,e),u(Ml.$$.fragment,e),u(hl.$$.fragment,e),ji=!1},d(e){e&&(l(T),l(b),l(h),l(Ul),l(gl),l($l),l(W),l(Cl),l(Zl),l(vl),l(z),l(Il),l(G),l(kl),l(V),l(Bl),l(Wl),l(Y),l(Xl),l(Rl),l(zl),l(A),l(Gl),l(H),l(Vl),l(_l),l(Yl),l(E),l(xl),l(q),l(Fl),l(Al),l(L),l(Hl),l(Ql),l(P),l(Nl),l(El),l(O),l(ql),l(ee),l(Sl),l(Ll),l(Dl),l(ae),l(Pl),l(Kl),l(Ol),l(ne),l(ea),l(ta),l(la),l(pe),l(aa),l(ce),l(sa),l(ia),l(na),l(ue),l(ra),l(oa),l(pa),l(ye),l(ca),l(ma),l(da),l(he),l(ua),l(Ma),l(Ja),l(we),l(ya),l(Ue),l(ba),l(Ta),l(ge),l(ha),l($e),l(fa),l(ja),l(Ze),l(wa),l(Ua),l(Ie),l(ga),l($a),l(Be),l(Ca),l(Za),l(va),l(Re),l(Ia),l(ze),l(ka),l(Ba),l(Ve),l(Wa),l(Xa),l(Ye),l(Ra),l(xe),l(za),l(Ga),l(Ae),l(Va),l(_a),l(Qe),l(Ya),l(Ne),l(xa),l(Fa),l(qe),l(Aa),l(Ha),l(Le),l(Qa),l(De),l(Na),l(Pe),l(Ea),l(Ke),l(qa),l(Sa),l(La),l(tt),l(Da),l(Pa),l(Ka),l(st),l(Oa),l(es),l(nt),l(ts),l(ls),l(ot),l(as),l(ss),l(ct),l(is),l(ns),l(dt),l(rs),l(ut),l(os),l(ps),l(Jt),l(cs),l(yt),l(ms),l(ds),l(Tt),l(us),l(Ms),l(ft),l(Js),l(jt),l(ys),l(bs),l(Ts),l(Ut),l(hs),l(fs),l(js),l(Ct),l(ws),l(Zt),l(Us),l(gs),l($s),l(Cs),l(kt),l(Zs),l(vs),l(Wt),l(Is),l(ks),l(Rt),l(Bs),l(Ws),l(Xs),l(Vt),l(Rs),l(zs),l(Gs),l(xt),l(Vs),l(_s),l(Ys),l(Ht),l(xs),l(Qt),l(Fs),l(As),l(Et),l(Hs),l(Qs),l(Ns),l(St),l(Es),l(qs),l(Dt),l(Ss),l(Pt),l(Ls),l(Ds),l(Kt),l(Ps),l(Ot),l(Ks),l(el),l(Os),l(ei),l(ll),l(ti),l(al),l(li),l(ai),l(si),l(il),l(ii),l(ni),l(ri),l(ol),l(oi),l(pl),l(pi),l(ci),l(mi),l(ml),l(di),l(dl),l(ui),l(ul),l(Mi),l(Ji),l(Jl),l(yi),l(yl),l(bi),l(bl),l(Ti),l(Tl),l(hi),l(fi),l(wl)),l(J),M(w,e),M(k,e),M(B,e),M(X,e),M(R,e),M(_,e),M(x,e),M(F,e),M(Q,e),M(N,e),M(S,e),M(D,e),M(K,e),M(te,e),M(le,e),M(se,e),M(ie,e),M(re,e),M(oe,e),M(me,e),M(de,e),M(Me,e),M(Je,e),M(be,e),M(Te,e),M(fe,e),M(je,e),M(U,e),M(Ce,e),M(ve,e),M(ke,e),M(We,e),M(Xe,e),M(Ge,e),M(_e,e),M(Fe,e),M(He,e),M(Ee,e),M(Se,e),M(Oe,e),M(et,e),M(lt,e),M(at,e),M(it,e),M(rt,e),M(pt,e),M(mt,e),M(Mt,e),M(bt,e),M(ht,e),M(g,e),M(wt,e),M(gt,e),M($t,e),M(vt,e),M(It,e),M($,e),M(Bt,e),M(Xt,e),M(zt,e),M(Gt,e),M(_t,e),M(Yt,e),M(Ft,e),M(At,e),M(Nt,e),M(C,e),M(qt,e),M(Lt,e),M(Z,e),M(tl,e),M(sl,e),M(v,e),M(nl,e),M(rl,e),M(I,e),M(cl,e),M(Ml,e),M(hl,e)}}}const gr='{"title":"Fare il debug della training pipeline","local":"fare-il-debug-della-training-pipeline","sections":[{"title":"Fare il debug della training pipeline","local":"fare-il-debug-della-training-pipeline","sections":[{"title":"Controlla i dati","local":"controlla-i-dati","sections":[],"depth":3},{"title":"Dai dataset ai dataloader","local":"dai-dataset-ai-dataloader","sections":[],"depth":3},{"title":"Passaggio attraverso il modello","local":"passaggio-attraverso-il-modello","sections":[],"depth":3},{"title":"Esecuzione di un passaggio di ottimizzazione","local":"esecuzione-di-un-passaggio-di-ottimizzazione","sections":[],"depth":3},{"title":"Come gestire gli errori out-of-memory di CUDA","local":"come-gestire-gli-errori-out-of-memory-di-cuda","sections":[],"depth":3},{"title":"Valutazione del modello","local":"valutazione-del-modello","sections":[],"depth":3}],"depth":2},{"title":"Debug degli errori silenziosi durante l’addestramento","local":"debug-degli-errori-silenziosi-durante-laddestramento","sections":[{"title":"Controllare i dati (di nuovo!)","local":"controllare-i-dati-di-nuovo","sections":[],"depth":3},{"title":"Fare overfitting del modello su un batch","local":"fare-overfitting-del-modello-su-un-batch","sections":[],"depth":3},{"title":"Non calibrare niente prima di avere una prima baseline","local":"non-calibrare-niente-prima-di-avere-una-prima-baseline","sections":[],"depth":3},{"title":"Chiedere aiuto","local":"chiedere-aiuto","sections":[],"depth":3}],"depth":2}],"depth":1}';function $r(f,J,T){let b="pt";return rr(()=>{const h=new URLSearchParams(window.location.search);T(0,b=h.get("fw")||"pt")}),[b]}class Rr extends or{constructor(J){super(),pr(this,J,$r,Ur,nr,{})}}export{Rr as component};
