import{s as Re,o as Ye,n as Se}from"../chunks/scheduler.b108d059.js";import{S as We,i as Ae,g as p,s as a,r,A as ze,h as i,f as l,c as n,j as Ze,u as o,x as j,k as Be,y as _e,a as t,v as c,d as M,t as m,w as h}from"../chunks/index.008de539.js";import{T as He}from"../chunks/Tip.aeb15ab7.js";import{C as f}from"../chunks/CodeBlock.3968c746.js";import{H as $,E as Xe}from"../chunks/EditOnGithub.d1c48e3d.js";function Qe(js){let y,U='Although you can always use the <a href="https://github.com/huggingface/transformers" rel="nofollow">Python library</a> for server-side inference, using Transformers.js means that you can write all of your code in JavaScript (instead of having to set up and communicate with a separate Python process).';return{c(){y=p("p"),y.innerHTML=U},l(u){y=i(u,"P",{"data-svelte-h":!0}),j(y)!=="svelte-k7e8xo"&&(y.innerHTML=U)},m(u,w){t(u,y,w)},p:Se,d(u){u&&l(y)}}}function Ve(js){let y,U="Since we use lazy loading, the first request made to the server will also be responsible for loading the pipeline. If you would like to begin loading the pipeline as soon as the server starts running, you can add the following line of code after defining <code>MyClassificationPipeline</code>:",u,w,T;return w=new f({props:{code:"TXlDbGFzc2lmaWNhdGlvblBpcGVsaW5lLmdldEluc3RhbmNlKCklM0I=",highlighted:'<span class="hljs-title class_">MyClassificationPipeline</span>.<span class="hljs-title function_">getInstance</span>();',wrap:!1}}),{c(){y=p("p"),y.innerHTML=U,u=a(),r(w.$$.fragment)},l(d){y=i(d,"P",{"data-svelte-h":!0}),j(y)!=="svelte-1ym4f5o"&&(y.innerHTML=U),u=n(d),o(w.$$.fragment,d)},m(d,J){t(d,y,J),t(d,u,J),c(w,d,J),T=!0},p:Se,i(d){T||(M(w.$$.fragment,d),T=!0)},o(d){m(w.$$.fragment,d),T=!1},d(d){d&&(l(y),l(u)),h(w,d)}}}function Le(js){let y,U,u,w,T,d,J,ce="Although Transformers.js was originally designed to be used in the browser, it’s also able to run inference on the server. In this tutorial, we will design a simple Node.js API that uses Transformers.js for sentiment analysis.",us,g,Me="We’ll also show you how to use the library in both CommonJS and ECMAScript modules, so you can choose the module system that works best for your project:",ws,I,me=`<li><a href="#ecmascript-modules-esm">ECMAScript modules (ESM)</a> - The official standard format
to package JavaScript code for reuse. It’s the default module system in modern
browsers, with modules imported using <code>import</code> and exported using <code>export</code>.
Fortunately, starting with version 13.2.0, Node.js has stable support of ES modules.</li> <li><a href="#commonjs">CommonJS</a> - The default module system in Node.js. In this system,
modules are imported using <code>require()</code> and exported using <code>module.exports</code>.</li>`,fs,b,Ts,v,he="<strong>Useful links:</strong>",Js,x,ye='<li>Source code (<a href="https://github.com/xenova/transformers.js/tree/main/examples/node/esm/app.js" rel="nofollow">ESM</a> or <a href="https://github.com/xenova/transformers.js/tree/main/examples/node/commonjs/app.js" rel="nofollow">CommonJS</a>)</li> <li><a href="https://huggingface.co/docs/transformers.js" rel="nofollow">Documentation</a></li>',Us,N,$s,G,je='<li><a href="https://nodejs.org/en/" rel="nofollow">Node.js</a> version 18+</li> <li><a href="https://www.npmjs.com/" rel="nofollow">npm</a> version 9+</li>',bs,k,Cs,E,de='Let’s start by creating a new Node.js project and installing Transformers.js via <a href="https://www.npmjs.com/package/@xenova/transformers" rel="nofollow">NPM</a>:',gs,Z,Is,B,ue='Next, create a new file called <code>app.js</code>, which will be the entry point for our application. Depending on whether you’re using <a href="#ecmascript-modules-esm">ECMAScript modules</a> or <a href="#commonjs">CommonJS</a>, you will need to do some things differently (see below).',vs,H,we='We’ll also create a helper class called <code>MyClassificationPipeline</code> control the loading of the pipeline. It uses the <a href="https://en.wikipedia.org/wiki/Singleton_pattern" rel="nofollow">singleton pattern</a> to lazily create a single instance of the pipeline when <code>getInstance</code> is first called, and uses this pipeline for all subsequent calls:',xs,S,Ns,R,fe="To indicate that your project uses ECMAScript modules, you need to add <code>&quot;type&quot;: &quot;module&quot;</code> to your <code>package.json</code>:",Gs,Y,ks,W,Te="Next, you will need to add the following imports to the top of <code>app.js</code>:",Es,A,Zs,z,Je="Following that, let’s import Transformers.js and define the <code>MyClassificationPipeline</code> class.",Bs,_,Hs,X,Ss,Q,Ue="Start by adding the following imports to the top of <code>app.js</code>:",Rs,V,Ys,L,$e='Following that, let’s import Transformers.js and define the <code>MyClassificationPipeline</code> class. Since Transformers.js is an ESM module, we will need to dynamically import the library using the <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/import" rel="nofollow"><code>import()</code></a> function:',Ws,F,As,q,zs,P,be='Next, let’s create a basic server with the built-in <a href="https://nodejs.org/api/http.html#http" rel="nofollow">HTTP</a> module. We will listen for requests made to the server (using the <code>/classify</code> endpoint), extract the <code>text</code> query parameter, and run this through the pipeline.',_s,D,Xs,C,Qs,O,Ce="To start the server, run the following command:",Vs,K,Ls,ss,ge='The server should be live at <a href="http://127.0.0.1:3000/" rel="nofollow">http://127.0.0.1:3000/</a>, which you can visit in your web browser. You should see the following message:',Fs,es,qs,ls,Ie='This is because we aren’t targeting the <code>/classify</code> endpoint with a valid <code>text</code> query parameter. Let’s try again, this time with a valid request. For example, you can visit <a href="http://127.0.0.1:3000/classify?text=I%20love%20Transformers.js" rel="nofollow">http://127.0.0.1:3000/classify?text=I%20love%20Transformers.js</a> and you should see:',Ps,ts,Ds,as,ve="Great! We’ve successfully created a basic HTTP server that uses Transformers.js to classify text.",Os,ns,Ks,ps,se,is,xe="By default, the first time you run the application, it will download the model files and cache them on your file system (in <code>./node_modules/@xenova/transformers/.cache/</code>). All subsequent requests will then use this model. You can change the location of the cache by setting <code>env.cacheDir</code>. For example, to cache the model in the <code>.cache</code> directory in the current working directory, you can add:",ee,rs,le,os,te,cs,Ne="If you want to use local model files, you can set <code>env.localModelPath</code> as follows:",ae,Ms,ne,ms,Ge="You can also disable loading of remote models by setting <code>env.allowRemoteModels</code> to <code>false</code>:",pe,hs,ie,ys,re,ds,oe;return T=new $({props:{title:"Server-side Inference in Node.js",local:"server-side-inference-in-nodejs",headingTag:"h1"}}),b=new He({props:{$$slots:{default:[Qe]},$$scope:{ctx:js}}}),N=new $({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),k=new $({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),Z=new f({props:{code:"bnBtJTIwaW5pdCUyMC15JTBBbnBtJTIwaSUyMCU0MHhlbm92YSUyRnRyYW5zZm9ybWVycw==",highlighted:`npm init -y
npm i @xenova/transformers`,wrap:!1}}),S=new $({props:{title:"ECMAScript modules (ESM)",local:"ecmascript-modules-esm",headingTag:"h3"}}),Y=new f({props:{code:"JTdCJTBBJTIwJTIwLi4uJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm1vZHVsZSUyMiUyQyUwQSUyMCUyMC4uLiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  ...
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;module&quot;</span><span class="hljs-punctuation">,</span>
  ...
<span class="hljs-punctuation">}</span>`,wrap:!1}}),A=new f({props:{code:"aW1wb3J0JTIwaHR0cCUyMGZyb20lMjAnaHR0cCclM0IlMEFpbXBvcnQlMjBxdWVyeXN0cmluZyUyMGZyb20lMjAncXVlcnlzdHJpbmcnJTNCJTBBaW1wb3J0JTIwdXJsJTIwZnJvbSUyMCd1cmwnJTNC",highlighted:`<span class="hljs-keyword">import</span> http <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;http&#x27;</span>;
<span class="hljs-keyword">import</span> querystring <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;querystring&#x27;</span>;
<span class="hljs-keyword">import</span> url <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;url&#x27;</span>;`,wrap:!1}}),_=new f({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMkMlMjBlbnYlMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFjbGFzcyUyME15Q2xhc3NpZmljYXRpb25QaXBlbGluZSUyMCU3QiUwQSUyMCUyMHN0YXRpYyUyMHRhc2slMjAlM0QlMjAndGV4dC1jbGFzc2lmaWNhdGlvbiclM0IlMEElMjAlMjBzdGF0aWMlMjBtb2RlbCUyMCUzRCUyMCdYZW5vdmElMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCclM0IlMEElMjAlMjBzdGF0aWMlMjBpbnN0YW5jZSUyMCUzRCUyMG51bGwlM0IlMEElMEElMjAlMjBzdGF0aWMlMjBhc3luYyUyMGdldEluc3RhbmNlKHByb2dyZXNzX2NhbGxiYWNrJTIwJTNEJTIwbnVsbCklMjAlN0IlMEElMjAlMjAlMjAlMjBpZiUyMCh0aGlzLmluc3RhbmNlJTIwJTNEJTNEJTNEJTIwbnVsbCklMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjBOT1RFJTNBJTIwVW5jb21tZW50JTIwdGhpcyUyMHRvJTIwY2hhbmdlJTIwdGhlJTIwY2FjaGUlMjBkaXJlY3RvcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjBlbnYuY2FjaGVEaXIlMjAlM0QlMjAnLiUyRi5jYWNoZSclM0IlMEElMEElMjAlMjAlMjAlMjAlMjAlMjB0aGlzLmluc3RhbmNlJTIwJTNEJTIwcGlwZWxpbmUodGhpcy50YXNrJTJDJTIwdGhpcy5tb2RlbCUyQyUyMCU3QiUyMHByb2dyZXNzX2NhbGxiYWNrJTIwJTdEKSUzQiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRoaXMuaW5zdGFuY2UlM0IlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-keyword">import</span> { pipeline, env } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyClassificationPipeline</span> {
  <span class="hljs-keyword">static</span> task = <span class="hljs-string">&#x27;text-classification&#x27;</span>;
  <span class="hljs-keyword">static</span> model = <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>;
  <span class="hljs-keyword">static</span> instance = <span class="hljs-literal">null</span>;

  <span class="hljs-keyword">static</span> <span class="hljs-keyword">async</span> <span class="hljs-title function_">getInstance</span>(<span class="hljs-params">progress_callback = <span class="hljs-literal">null</span></span>) {
    <span class="hljs-keyword">if</span> (<span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> === <span class="hljs-literal">null</span>) {
      <span class="hljs-comment">// <span class="hljs-doctag">NOTE:</span> Uncomment this to change the cache directory</span>
      <span class="hljs-comment">// env.cacheDir = &#x27;./.cache&#x27;;</span>

      <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> = <span class="hljs-title function_">pipeline</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">task</span>, <span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span>, { progress_callback });
    }

    <span class="hljs-keyword">return</span> <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span>;
  }
}`,wrap:!1}}),X=new $({props:{title:"CommonJS",local:"commonjs",headingTag:"h3"}}),V=new f({props:{code:"Y29uc3QlMjBodHRwJTIwJTNEJTIwcmVxdWlyZSgnaHR0cCcpJTNCJTBBY29uc3QlMjBxdWVyeXN0cmluZyUyMCUzRCUyMHJlcXVpcmUoJ3F1ZXJ5c3RyaW5nJyklM0IlMEFjb25zdCUyMHVybCUyMCUzRCUyMHJlcXVpcmUoJ3VybCcpJTNC",highlighted:`<span class="hljs-keyword">const</span> http = <span class="hljs-built_in">require</span>(<span class="hljs-string">&#x27;http&#x27;</span>);
<span class="hljs-keyword">const</span> querystring = <span class="hljs-built_in">require</span>(<span class="hljs-string">&#x27;querystring&#x27;</span>);
<span class="hljs-keyword">const</span> url = <span class="hljs-built_in">require</span>(<span class="hljs-string">&#x27;url&#x27;</span>);`,wrap:!1}}),F=new f({props:{code:"Y2xhc3MlMjBNeUNsYXNzaWZpY2F0aW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjBzdGF0aWMlMjB0YXNrJTIwJTNEJTIwJ3RleHQtY2xhc3NpZmljYXRpb24nJTNCJTBBJTIwJTIwc3RhdGljJTIwbW9kZWwlMjAlM0QlMjAnWGVub3ZhJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnJTNCJTBBJTIwJTIwc3RhdGljJTIwaW5zdGFuY2UlMjAlM0QlMjBudWxsJTNCJTBBJTBBJTIwJTIwc3RhdGljJTIwYXN5bmMlMjBnZXRJbnN0YW5jZShwcm9ncmVzc19jYWxsYmFjayUyMCUzRCUyMG51bGwpJTIwJTdCJTBBJTIwJTIwJTIwJTIwaWYlMjAodGhpcy5pbnN0YW5jZSUyMCUzRCUzRCUzRCUyMG51bGwpJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTIwRHluYW1pY2FsbHklMjBpbXBvcnQlMjB0aGUlMjBUcmFuc2Zvcm1lcnMuanMlMjBsaWJyYXJ5JTBBJTIwJTIwJTIwJTIwJTIwJTIwbGV0JTIwJTdCJTIwcGlwZWxpbmUlMkMlMjBlbnYlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMGltcG9ydCgnJTQweGVub3ZhJTJGdHJhbnNmb3JtZXJzJyklM0IlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjBOT1RFJTNBJTIwVW5jb21tZW50JTIwdGhpcyUyMHRvJTIwY2hhbmdlJTIwdGhlJTIwY2FjaGUlMjBkaXJlY3RvcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjBlbnYuY2FjaGVEaXIlMjAlM0QlMjAnLiUyRi5jYWNoZSclM0IlMEElMEElMjAlMjAlMjAlMjAlMjAlMjB0aGlzLmluc3RhbmNlJTIwJTNEJTIwcGlwZWxpbmUodGhpcy50YXNrJTJDJTIwdGhpcy5tb2RlbCUyQyUyMCU3QiUyMHByb2dyZXNzX2NhbGxiYWNrJTIwJTdEKSUzQiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRoaXMuaW5zdGFuY2UlM0IlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyClassificationPipeline</span> {
  <span class="hljs-keyword">static</span> task = <span class="hljs-string">&#x27;text-classification&#x27;</span>;
  <span class="hljs-keyword">static</span> model = <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>;
  <span class="hljs-keyword">static</span> instance = <span class="hljs-literal">null</span>;

  <span class="hljs-keyword">static</span> <span class="hljs-keyword">async</span> <span class="hljs-title function_">getInstance</span>(<span class="hljs-params">progress_callback = <span class="hljs-literal">null</span></span>) {
    <span class="hljs-keyword">if</span> (<span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> === <span class="hljs-literal">null</span>) {
      <span class="hljs-comment">// Dynamically import the Transformers.js library</span>
      <span class="hljs-keyword">let</span> { pipeline, env } = <span class="hljs-keyword">await</span> <span class="hljs-keyword">import</span>(<span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>);

      <span class="hljs-comment">// <span class="hljs-doctag">NOTE:</span> Uncomment this to change the cache directory</span>
      <span class="hljs-comment">// env.cacheDir = &#x27;./.cache&#x27;;</span>

      <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> = <span class="hljs-title function_">pipeline</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">task</span>, <span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span>, { progress_callback });
    }

    <span class="hljs-keyword">return</span> <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span>;
  }
}`,wrap:!1}}),q=new $({props:{title:"Creating a basic HTTP server",local:"creating-a-basic-http-server",headingTag:"h2"}}),D=new f({props:{code:"JTJGJTJGJTIwRGVmaW5lJTIwdGhlJTIwSFRUUCUyMHNlcnZlciUwQWNvbnN0JTIwc2VydmVyJTIwJTNEJTIwaHR0cC5jcmVhdGVTZXJ2ZXIoKSUzQiUwQWNvbnN0JTIwaG9zdG5hbWUlMjAlM0QlMjAnMTI3LjAuMC4xJyUzQiUwQWNvbnN0JTIwcG9ydCUyMCUzRCUyMDMwMDAlM0IlMEElMEElMkYlMkYlMjBMaXN0ZW4lMjBmb3IlMjByZXF1ZXN0cyUyMG1hZGUlMjB0byUyMHRoZSUyMHNlcnZlciUwQXNlcnZlci5vbigncmVxdWVzdCclMkMlMjBhc3luYyUyMChyZXElMkMlMjByZXMpJTIwJTNEJTNFJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwUGFyc2UlMjB0aGUlMjByZXF1ZXN0JTIwVVJMJTBBJTIwJTIwY29uc3QlMjBwYXJzZWRVcmwlMjAlM0QlMjB1cmwucGFyc2UocmVxLnVybCklM0IlMEElMEElMjAlMjAlMkYlMkYlMjBFeHRyYWN0JTIwdGhlJTIwcXVlcnklMjBwYXJhbWV0ZXJzJTBBJTIwJTIwY29uc3QlMjAlN0IlMjB0ZXh0JTIwJTdEJTIwJTNEJTIwcXVlcnlzdHJpbmcucGFyc2UocGFyc2VkVXJsLnF1ZXJ5KSUzQiUwQSUwQSUyMCUyMCUyRiUyRiUyMFNldCUyMHRoZSUyMHJlc3BvbnNlJTIwaGVhZGVycyUwQSUyMCUyMHJlcy5zZXRIZWFkZXIoJ0NvbnRlbnQtVHlwZSclMkMlMjAnYXBwbGljYXRpb24lMkZqc29uJyklM0IlMEElMEElMjAlMjBsZXQlMjByZXNwb25zZSUzQiUwQSUyMCUyMGlmJTIwKHBhcnNlZFVybC5wYXRobmFtZSUyMCUzRCUzRCUzRCUyMCclMkZjbGFzc2lmeSclMjAlMjYlMjYlMjB0ZXh0KSUyMCU3QiUwQSUyMCUyMCUyMCUyMGNvbnN0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwTXlDbGFzc2lmaWNhdGlvblBpcGVsaW5lLmdldEluc3RhbmNlKCklM0IlMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih0ZXh0KSUzQiUwQSUyMCUyMCUyMCUyMHJlcy5zdGF0dXNDb2RlJTIwJTNEJTIwMjAwJTNCJTBBJTIwJTIwJTdEJTIwZWxzZSUyMCU3QiUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwJTdCJTIwJ2Vycm9yJyUzQSUyMCdCYWQlMjByZXF1ZXN0JyUyMCU3RCUwQSUyMCUyMCUyMCUyMHJlcy5zdGF0dXNDb2RlJTIwJTNEJTIwNDAwJTNCJTBBJTIwJTIwJTdEJTBBJTBBJTIwJTIwJTJGJTJGJTIwU2VuZCUyMHRoZSUyMEpTT04lMjByZXNwb25zZSUwQSUyMCUyMHJlcy5lbmQoSlNPTi5zdHJpbmdpZnkocmVzcG9uc2UpKSUzQiUwQSU3RCklM0IlMEElMEFzZXJ2ZXIubGlzdGVuKHBvcnQlMkMlMjBob3N0bmFtZSUyQyUyMCgpJTIwJTNEJTNFJTIwJTdCJTBBJTIwJTIwY29uc29sZS5sb2coJTYwU2VydmVyJTIwcnVubmluZyUyMGF0JTIwaHR0cCUzQSUyRiUyRiUyNCU3Qmhvc3RuYW1lJTdEJTNBJTI0JTdCcG9ydCU3RCUyRiU2MCklM0IlMEElN0QpJTNCJTBB",highlighted:`<span class="hljs-comment">// Define the HTTP server</span>
<span class="hljs-keyword">const</span> server = http.<span class="hljs-title function_">createServer</span>();
<span class="hljs-keyword">const</span> hostname = <span class="hljs-string">&#x27;127.0.0.1&#x27;</span>;
<span class="hljs-keyword">const</span> port = <span class="hljs-number">3000</span>;

<span class="hljs-comment">// Listen for requests made to the server</span>
server.<span class="hljs-title function_">on</span>(<span class="hljs-string">&#x27;request&#x27;</span>, <span class="hljs-keyword">async</span> (req, res) =&gt; {
  <span class="hljs-comment">// Parse the request URL</span>
  <span class="hljs-keyword">const</span> parsedUrl = url.<span class="hljs-title function_">parse</span>(req.<span class="hljs-property">url</span>);

  <span class="hljs-comment">// Extract the query parameters</span>
  <span class="hljs-keyword">const</span> { text } = querystring.<span class="hljs-title function_">parse</span>(parsedUrl.<span class="hljs-property">query</span>);

  <span class="hljs-comment">// Set the response headers</span>
  res.<span class="hljs-title function_">setHeader</span>(<span class="hljs-string">&#x27;Content-Type&#x27;</span>, <span class="hljs-string">&#x27;application/json&#x27;</span>);

  <span class="hljs-keyword">let</span> response;
  <span class="hljs-keyword">if</span> (parsedUrl.<span class="hljs-property">pathname</span> === <span class="hljs-string">&#x27;/classify&#x27;</span> &amp;&amp; text) {
    <span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title class_">MyClassificationPipeline</span>.<span class="hljs-title function_">getInstance</span>();
    response = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text);
    res.<span class="hljs-property">statusCode</span> = <span class="hljs-number">200</span>;
  } <span class="hljs-keyword">else</span> {
    response = { <span class="hljs-string">&#x27;error&#x27;</span>: <span class="hljs-string">&#x27;Bad request&#x27;</span> }
    res.<span class="hljs-property">statusCode</span> = <span class="hljs-number">400</span>;
  }

  <span class="hljs-comment">// Send the JSON response</span>
  res.<span class="hljs-title function_">end</span>(<span class="hljs-title class_">JSON</span>.<span class="hljs-title function_">stringify</span>(response));
});

server.<span class="hljs-title function_">listen</span>(port, hostname, <span class="hljs-function">() =&gt;</span> {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">\`Server running at http://<span class="hljs-subst">\${hostname}</span>:<span class="hljs-subst">\${port}</span>/\`</span>);
});
`,wrap:!1}}),C=new He({props:{$$slots:{default:[Ve]},$$scope:{ctx:js}}}),K=new f({props:{code:"bm9kZSUyMGFwcC5qcw==",highlighted:"node app.js",wrap:!1}}),es=new f({props:{code:"JTdCJTIyZXJyb3IlMjIlM0ElMjJCYWQlMjByZXF1ZXN0JTIyJTdE",highlighted:'<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;error&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;Bad request&quot;</span><span class="hljs-punctuation">}</span>',wrap:!1}}),ts=new f({props:{code:"JTVCJTdCJTIybGFiZWwlMjIlM0ElMjJQT1NJVElWRSUyMiUyQyUyMnNjb3JlJTIyJTNBMC45OTk2NzIxMTQ4NDkwOTA2JTdEJTVE",highlighted:'<span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;label&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;POSITIVE&quot;</span><span class="hljs-punctuation">,</span><span class="hljs-attr">&quot;score&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-number">0.9996721148490906</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>',wrap:!1}}),ns=new $({props:{title:"(Optional) Customization",local:"optional-customization",headingTag:"h2"}}),ps=new $({props:{title:"Model caching",local:"model-caching",headingTag:"h3"}}),rs=new f({props:{code:"ZW52LmNhY2hlRGlyJTIwJTNEJTIwJy4lMkYuY2FjaGUnJTNC",highlighted:'env.<span class="hljs-property">cacheDir</span> = <span class="hljs-string">&#x27;./.cache&#x27;</span>;',wrap:!1}}),os=new $({props:{title:"Use local models",local:"use-local-models",headingTag:"h3"}}),Ms=new f({props:{code:"JTJGJTJGJTIwU3BlY2lmeSUyMGElMjBjdXN0b20lMjBsb2NhdGlvbiUyMGZvciUyMG1vZGVscyUyMChkZWZhdWx0cyUyMHRvJTIwJyUyRm1vZGVscyUyRicpLiUwQWVudi5sb2NhbE1vZGVsUGF0aCUyMCUzRCUyMCclMkZwYXRoJTJGdG8lMkZtb2RlbHMlMkYnJTNC",highlighted:`<span class="hljs-comment">// Specify a custom location for models (defaults to &#x27;/models/&#x27;).</span>
env.<span class="hljs-property">localModelPath</span> = <span class="hljs-string">&#x27;/path/to/models/&#x27;</span>;`,wrap:!1}}),hs=new f({props:{code:"JTJGJTJGJTIwRGlzYWJsZSUyMHRoZSUyMGxvYWRpbmclMjBvZiUyMHJlbW90ZSUyMG1vZGVscyUyMGZyb20lMjB0aGUlMjBIdWdnaW5nJTIwRmFjZSUyMEh1YiUzQSUwQWVudi5hbGxvd1JlbW90ZU1vZGVscyUyMCUzRCUyMGZhbHNlJTNC",highlighted:`<span class="hljs-comment">// Disable the loading of remote models from the Hugging Face Hub:</span>
env.<span class="hljs-property">allowRemoteModels</span> = <span class="hljs-literal">false</span>;`,wrap:!1}}),ys=new Xe({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/tutorials/node.md"}}),{c(){y=p("meta"),U=a(),u=p("p"),w=a(),r(T.$$.fragment),d=a(),J=p("p"),J.textContent=ce,us=a(),g=p("p"),g.textContent=Me,ws=a(),I=p("ul"),I.innerHTML=me,fs=a(),r(b.$$.fragment),Ts=a(),v=p("p"),v.innerHTML=he,Js=a(),x=p("ul"),x.innerHTML=ye,Us=a(),r(N.$$.fragment),$s=a(),G=p("ul"),G.innerHTML=je,bs=a(),r(k.$$.fragment),Cs=a(),E=p("p"),E.innerHTML=de,gs=a(),r(Z.$$.fragment),Is=a(),B=p("p"),B.innerHTML=ue,vs=a(),H=p("p"),H.innerHTML=we,xs=a(),r(S.$$.fragment),Ns=a(),R=p("p"),R.innerHTML=fe,Gs=a(),r(Y.$$.fragment),ks=a(),W=p("p"),W.innerHTML=Te,Es=a(),r(A.$$.fragment),Zs=a(),z=p("p"),z.innerHTML=Je,Bs=a(),r(_.$$.fragment),Hs=a(),r(X.$$.fragment),Ss=a(),Q=p("p"),Q.innerHTML=Ue,Rs=a(),r(V.$$.fragment),Ys=a(),L=p("p"),L.innerHTML=$e,Ws=a(),r(F.$$.fragment),As=a(),r(q.$$.fragment),zs=a(),P=p("p"),P.innerHTML=be,_s=a(),r(D.$$.fragment),Xs=a(),r(C.$$.fragment),Qs=a(),O=p("p"),O.textContent=Ce,Vs=a(),r(K.$$.fragment),Ls=a(),ss=p("p"),ss.innerHTML=ge,Fs=a(),r(es.$$.fragment),qs=a(),ls=p("p"),ls.innerHTML=Ie,Ps=a(),r(ts.$$.fragment),Ds=a(),as=p("p"),as.textContent=ve,Os=a(),r(ns.$$.fragment),Ks=a(),r(ps.$$.fragment),se=a(),is=p("p"),is.innerHTML=xe,ee=a(),r(rs.$$.fragment),le=a(),r(os.$$.fragment),te=a(),cs=p("p"),cs.innerHTML=Ne,ae=a(),r(Ms.$$.fragment),ne=a(),ms=p("p"),ms.innerHTML=Ge,pe=a(),r(hs.$$.fragment),ie=a(),r(ys.$$.fragment),re=a(),ds=p("p"),this.h()},l(s){const e=ze("svelte-u9bgzb",document.head);y=i(e,"META",{name:!0,content:!0}),e.forEach(l),U=n(s),u=i(s,"P",{}),Ze(u).forEach(l),w=n(s),o(T.$$.fragment,s),d=n(s),J=i(s,"P",{"data-svelte-h":!0}),j(J)!=="svelte-vfkn35"&&(J.textContent=ce),us=n(s),g=i(s,"P",{"data-svelte-h":!0}),j(g)!=="svelte-a8f7x7"&&(g.textContent=Me),ws=n(s),I=i(s,"UL",{"data-svelte-h":!0}),j(I)!=="svelte-9qlumf"&&(I.innerHTML=me),fs=n(s),o(b.$$.fragment,s),Ts=n(s),v=i(s,"P",{"data-svelte-h":!0}),j(v)!=="svelte-1kriz5m"&&(v.innerHTML=he),Js=n(s),x=i(s,"UL",{"data-svelte-h":!0}),j(x)!=="svelte-1jbtrzy"&&(x.innerHTML=ye),Us=n(s),o(N.$$.fragment,s),$s=n(s),G=i(s,"UL",{"data-svelte-h":!0}),j(G)!=="svelte-1qy4daj"&&(G.innerHTML=je),bs=n(s),o(k.$$.fragment,s),Cs=n(s),E=i(s,"P",{"data-svelte-h":!0}),j(E)!=="svelte-1w613qw"&&(E.innerHTML=de),gs=n(s),o(Z.$$.fragment,s),Is=n(s),B=i(s,"P",{"data-svelte-h":!0}),j(B)!=="svelte-7flmsa"&&(B.innerHTML=ue),vs=n(s),H=i(s,"P",{"data-svelte-h":!0}),j(H)!=="svelte-1dmzt6g"&&(H.innerHTML=we),xs=n(s),o(S.$$.fragment,s),Ns=n(s),R=i(s,"P",{"data-svelte-h":!0}),j(R)!=="svelte-nul6wy"&&(R.innerHTML=fe),Gs=n(s),o(Y.$$.fragment,s),ks=n(s),W=i(s,"P",{"data-svelte-h":!0}),j(W)!=="svelte-44hxyv"&&(W.innerHTML=Te),Es=n(s),o(A.$$.fragment,s),Zs=n(s),z=i(s,"P",{"data-svelte-h":!0}),j(z)!=="svelte-1va2gp1"&&(z.innerHTML=Je),Bs=n(s),o(_.$$.fragment,s),Hs=n(s),o(X.$$.fragment,s),Ss=n(s),Q=i(s,"P",{"data-svelte-h":!0}),j(Q)!=="svelte-1nm1y09"&&(Q.innerHTML=Ue),Rs=n(s),o(V.$$.fragment,s),Ys=n(s),L=i(s,"P",{"data-svelte-h":!0}),j(L)!=="svelte-1qn48sh"&&(L.innerHTML=$e),Ws=n(s),o(F.$$.fragment,s),As=n(s),o(q.$$.fragment,s),zs=n(s),P=i(s,"P",{"data-svelte-h":!0}),j(P)!=="svelte-aklufa"&&(P.innerHTML=be),_s=n(s),o(D.$$.fragment,s),Xs=n(s),o(C.$$.fragment,s),Qs=n(s),O=i(s,"P",{"data-svelte-h":!0}),j(O)!=="svelte-1orujzn"&&(O.textContent=Ce),Vs=n(s),o(K.$$.fragment,s),Ls=n(s),ss=i(s,"P",{"data-svelte-h":!0}),j(ss)!=="svelte-52uecr"&&(ss.innerHTML=ge),Fs=n(s),o(es.$$.fragment,s),qs=n(s),ls=i(s,"P",{"data-svelte-h":!0}),j(ls)!=="svelte-tmlcgt"&&(ls.innerHTML=Ie),Ps=n(s),o(ts.$$.fragment,s),Ds=n(s),as=i(s,"P",{"data-svelte-h":!0}),j(as)!=="svelte-xomwwl"&&(as.textContent=ve),Os=n(s),o(ns.$$.fragment,s),Ks=n(s),o(ps.$$.fragment,s),se=n(s),is=i(s,"P",{"data-svelte-h":!0}),j(is)!=="svelte-znv5ud"&&(is.innerHTML=xe),ee=n(s),o(rs.$$.fragment,s),le=n(s),o(os.$$.fragment,s),te=n(s),cs=i(s,"P",{"data-svelte-h":!0}),j(cs)!=="svelte-tw138n"&&(cs.innerHTML=Ne),ae=n(s),o(Ms.$$.fragment,s),ne=n(s),ms=i(s,"P",{"data-svelte-h":!0}),j(ms)!=="svelte-1tbr80q"&&(ms.innerHTML=Ge),pe=n(s),o(hs.$$.fragment,s),ie=n(s),o(ys.$$.fragment,s),re=n(s),ds=i(s,"P",{}),Ze(ds).forEach(l),this.h()},h(){Be(y,"name","hf:doc:metadata"),Be(y,"content",Fe)},m(s,e){_e(document.head,y),t(s,U,e),t(s,u,e),t(s,w,e),c(T,s,e),t(s,d,e),t(s,J,e),t(s,us,e),t(s,g,e),t(s,ws,e),t(s,I,e),t(s,fs,e),c(b,s,e),t(s,Ts,e),t(s,v,e),t(s,Js,e),t(s,x,e),t(s,Us,e),c(N,s,e),t(s,$s,e),t(s,G,e),t(s,bs,e),c(k,s,e),t(s,Cs,e),t(s,E,e),t(s,gs,e),c(Z,s,e),t(s,Is,e),t(s,B,e),t(s,vs,e),t(s,H,e),t(s,xs,e),c(S,s,e),t(s,Ns,e),t(s,R,e),t(s,Gs,e),c(Y,s,e),t(s,ks,e),t(s,W,e),t(s,Es,e),c(A,s,e),t(s,Zs,e),t(s,z,e),t(s,Bs,e),c(_,s,e),t(s,Hs,e),c(X,s,e),t(s,Ss,e),t(s,Q,e),t(s,Rs,e),c(V,s,e),t(s,Ys,e),t(s,L,e),t(s,Ws,e),c(F,s,e),t(s,As,e),c(q,s,e),t(s,zs,e),t(s,P,e),t(s,_s,e),c(D,s,e),t(s,Xs,e),c(C,s,e),t(s,Qs,e),t(s,O,e),t(s,Vs,e),c(K,s,e),t(s,Ls,e),t(s,ss,e),t(s,Fs,e),c(es,s,e),t(s,qs,e),t(s,ls,e),t(s,Ps,e),c(ts,s,e),t(s,Ds,e),t(s,as,e),t(s,Os,e),c(ns,s,e),t(s,Ks,e),c(ps,s,e),t(s,se,e),t(s,is,e),t(s,ee,e),c(rs,s,e),t(s,le,e),c(os,s,e),t(s,te,e),t(s,cs,e),t(s,ae,e),c(Ms,s,e),t(s,ne,e),t(s,ms,e),t(s,pe,e),c(hs,s,e),t(s,ie,e),c(ys,s,e),t(s,re,e),t(s,ds,e),oe=!0},p(s,[e]){const ke={};e&2&&(ke.$$scope={dirty:e,ctx:s}),b.$set(ke);const Ee={};e&2&&(Ee.$$scope={dirty:e,ctx:s}),C.$set(Ee)},i(s){oe||(M(T.$$.fragment,s),M(b.$$.fragment,s),M(N.$$.fragment,s),M(k.$$.fragment,s),M(Z.$$.fragment,s),M(S.$$.fragment,s),M(Y.$$.fragment,s),M(A.$$.fragment,s),M(_.$$.fragment,s),M(X.$$.fragment,s),M(V.$$.fragment,s),M(F.$$.fragment,s),M(q.$$.fragment,s),M(D.$$.fragment,s),M(C.$$.fragment,s),M(K.$$.fragment,s),M(es.$$.fragment,s),M(ts.$$.fragment,s),M(ns.$$.fragment,s),M(ps.$$.fragment,s),M(rs.$$.fragment,s),M(os.$$.fragment,s),M(Ms.$$.fragment,s),M(hs.$$.fragment,s),M(ys.$$.fragment,s),oe=!0)},o(s){m(T.$$.fragment,s),m(b.$$.fragment,s),m(N.$$.fragment,s),m(k.$$.fragment,s),m(Z.$$.fragment,s),m(S.$$.fragment,s),m(Y.$$.fragment,s),m(A.$$.fragment,s),m(_.$$.fragment,s),m(X.$$.fragment,s),m(V.$$.fragment,s),m(F.$$.fragment,s),m(q.$$.fragment,s),m(D.$$.fragment,s),m(C.$$.fragment,s),m(K.$$.fragment,s),m(es.$$.fragment,s),m(ts.$$.fragment,s),m(ns.$$.fragment,s),m(ps.$$.fragment,s),m(rs.$$.fragment,s),m(os.$$.fragment,s),m(Ms.$$.fragment,s),m(hs.$$.fragment,s),m(ys.$$.fragment,s),oe=!1},d(s){s&&(l(U),l(u),l(w),l(d),l(J),l(us),l(g),l(ws),l(I),l(fs),l(Ts),l(v),l(Js),l(x),l(Us),l($s),l(G),l(bs),l(Cs),l(E),l(gs),l(Is),l(B),l(vs),l(H),l(xs),l(Ns),l(R),l(Gs),l(ks),l(W),l(Es),l(Zs),l(z),l(Bs),l(Hs),l(Ss),l(Q),l(Rs),l(Ys),l(L),l(Ws),l(As),l(zs),l(P),l(_s),l(Xs),l(Qs),l(O),l(Vs),l(Ls),l(ss),l(Fs),l(qs),l(ls),l(Ps),l(Ds),l(as),l(Os),l(Ks),l(se),l(is),l(ee),l(le),l(te),l(cs),l(ae),l(ne),l(ms),l(pe),l(ie),l(re),l(ds)),l(y),h(T,s),h(b,s),h(N,s),h(k,s),h(Z,s),h(S,s),h(Y,s),h(A,s),h(_,s),h(X,s),h(V,s),h(F,s),h(q,s),h(D,s),h(C,s),h(K,s),h(es,s),h(ts,s),h(ns,s),h(ps,s),h(rs,s),h(os,s),h(Ms,s),h(hs,s),h(ys,s)}}}const Fe='{"title":"Server-side Inference in Node.js","local":"server-side-inference-in-nodejs","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Getting started","local":"getting-started","sections":[{"title":"ECMAScript modules (ESM)","local":"ecmascript-modules-esm","sections":[],"depth":3},{"title":"CommonJS","local":"commonjs","sections":[],"depth":3}],"depth":2},{"title":"Creating a basic HTTP server","local":"creating-a-basic-http-server","sections":[],"depth":2},{"title":"(Optional) Customization","local":"optional-customization","sections":[{"title":"Model caching","local":"model-caching","sections":[],"depth":3},{"title":"Use local models","local":"use-local-models","sections":[],"depth":3}],"depth":2}],"depth":1}';function qe(js){return Ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends We{constructor(y){super(),Ae(this,y,qe,Le,Re,{})}}export{el as component};
