import{s as ne,n as ie,o as pe}from"../chunks/scheduler.c57aa7ef.js";import{S as oe,i as de,g as i,s,r as C,A as Me,h as p,f as l,c as n,j as ae,u as I,x as d,k as se,y as re,a,v as E,d as Z,t as k,w as B}from"../chunks/index.c50cb18e.js";import{C as D}from"../chunks/CodeBlock.34f0a53d.js";import{H as me,E as ce}from"../chunks/EditOnGithub.958a8a49.js";function ye(z){let o,A,j,W,M,G,r,L='With PEFT, you can inject trainable adapters into any <code>torch</code> module which allows you to use adapter methods without relying on the modeling classes in PEFT. Currently, PEFT supports injecting <a href="../conceptual_guides/adapter#low-rank-adaptation-lora">LoRA</a>, <a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">AdaLoRA</a>, and <a href="../conceptual_guides/ia3">IA3</a> into models because for these adapters, inplace modification of the model is sufficient for finetuning it.',g,m,K="Check the table below to see when you should inject adapters.",V,c,P="<thead><tr><th>Pros</th> <th>Cons</th></tr></thead> <tbody><tr><td>the model is modified inplace, keeping all the original attributes and methods</td> <td>manually write the <code>from_pretrained</code> and <code>save_pretrained</code> utility functions from Hugging Face to save and load adapters</td></tr> <tr><td>works for any <code>torch</code> module and modality</td> <td>doesn’t work with any of the utility methods provided by <code>PeftModel</code> such as disabling and merging adapters</td></tr></tbody>",R,y,q='To perform the adapter injection, use the <a href="/docs/peft/pr_1891/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> method. This method takes 3 arguments, the PEFT config, the model, and an optional adapter name. You can also attach multiple adapters to the model if you call <a href="/docs/peft/pr_1891/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> multiple times with different adapter names.',Q,u,O="For example, to inject LoRA adapters into the <code>linear</code> submodule of the <code>DummyModel</code> module:",X,T,x,J,ee="Print the model to see that the adapters have been correctly injected.",v,w,$,f,te='To only save the adapter, use the <a href="/docs/peft/pr_1891/en/package_reference/peft_model#peft.get_peft_model_state_dict">get_peft_model_state_dict()</a> function:',F,h,Y,U,le="Otherwise, <code>model.state_dict()</code> returns the full state dict of the model.",H,b,N,_,S;return M=new me({props:{title:"Adapter injection",local:"adapter-injection",headingTag:"h1"}}),T=new D({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsJTJDJTIwTG9yYUNvbmZpZyUwQSUwQWNsYXNzJTIwRHVtbXlNb2RlbCh0b3JjaC5ubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmVtYmVkZGluZyUyMCUzRCUyMHRvcmNoLm5uLkVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGluZWFyJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sbV9oZWFkJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwaW5wdXRfaWRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmVtYmVkZGluZyhpbnB1dF9pZHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubGluZWFyKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubG1faGVhZCh4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEElMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwciUzRDY0JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmxpbmVhciUyMiU1RCUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMER1bW15TW9kZWwoKSUwQW1vZGVsJTIwJTNEJTIwaW5qZWN0X2FkYXB0ZXJfaW5fbW9kZWwobG9yYV9jb25maWclMkMlMjBtb2RlbCklMEElMEFkdW1teV9pbnB1dHMlMjAlM0QlMjB0b3JjaC5Mb25nVGVuc29yKCU1QiU1QjAlMkMlMjAxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTVEJTVEKSUwQWR1bW15X291dHB1dHMlMjAlM0QlMjBtb2RlbChkdW1teV9pbnB1dHMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> inject_adapter_in_model, LoraConfig

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.embedding = torch.nn.Embedding(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.linear = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.lm_head = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, input_ids</span>):
        x = self.embedding(input_ids)
        x = self.linear(x)
        x = self.lm_head(x)
        <span class="hljs-keyword">return</span> x


lora_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    target_modules=[<span class="hljs-string">&quot;linear&quot;</span>],
)

model = DummyModel()
model = inject_adapter_in_model(lora_config, model)

dummy_inputs = torch.LongTensor([[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>]])
dummy_outputs = model(dummy_inputs)`,wrap:!1}}),w=new D({props:{code:"RHVtbXlNb2RlbCglMEElMjAlMjAoZW1iZWRkaW5nKSUzQSUyMEVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMChsaW5lYXIpJTNBJTIwTGluZWFyKCUwQSUyMCUyMCUyMCUyMGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKGxvcmFfZHJvcG91dCklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMERyb3BvdXQocCUzRDAuMSUyQyUyMGlucGxhY2UlM0RGYWxzZSklMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwKGxvcmFfQSklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNENjQlMkMlMjBiaWFzJTNERmFsc2UpJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMChsb3JhX0IpJTNBJTIwTW9kdWxlRGljdCglMEElMjAlMjAlMjAlMjAlMjAlMjAoZGVmYXVsdCklM0ElMjBMaW5lYXIoaW5fZmVhdHVyZXMlM0Q2NCUyQyUyMG91dF9mZWF0dXJlcyUzRDEwJTJDJTIwYmlhcyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQSklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQiklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjApJTBBJTIwJTIwKGxtX2hlYWQpJTNBJTIwTGluZWFyKGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlKSUwQSk=",highlighted:`DummyModel(
  (embedding): Embedding(10, 10)
  (linear): Linear(
    in_features=10, out_features=10, bias=True
    (lora_dropout): ModuleDict(
      (default): Dropout(p=0.1, inplace=False)
    )
    (lora_A): ModuleDict(
      (default): Linear(in_features=10, out_features=64, bias=False)
    )
    (lora_B): ModuleDict(
      (default): Linear(in_features=64, out_features=10, bias=False)
    )
    (lora_embedding_A): ParameterDict()
    (lora_embedding_B): ParameterDict()
  )
  (lm_head): Linear(in_features=10, out_features=10, bias=True)
)`,wrap:!1}}),h=new D({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0JTBBJTBBcGVmdF9zdGF0ZV9kaWN0JTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWxfc3RhdGVfZGljdChtb2RlbCklMEFwcmludChwZWZ0X3N0YXRlX2RpY3Qp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model_state_dict

peft_state_dict = get_peft_model_state_dict(model)
<span class="hljs-built_in">print</span>(peft_state_dict)`,wrap:!1}}),b=new ce({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/low_level_api.md"}}),{c(){o=i("meta"),A=s(),j=i("p"),W=s(),C(M.$$.fragment),G=s(),r=i("p"),r.innerHTML=L,g=s(),m=i("p"),m.textContent=K,V=s(),c=i("table"),c.innerHTML=P,R=s(),y=i("p"),y.innerHTML=q,Q=s(),u=i("p"),u.innerHTML=O,X=s(),C(T.$$.fragment),x=s(),J=i("p"),J.textContent=ee,v=s(),C(w.$$.fragment),$=s(),f=i("p"),f.innerHTML=te,F=s(),C(h.$$.fragment),Y=s(),U=i("p"),U.innerHTML=le,H=s(),C(b.$$.fragment),N=s(),_=i("p"),this.h()},l(e){const t=Me("svelte-u9bgzb",document.head);o=p(t,"META",{name:!0,content:!0}),t.forEach(l),A=n(e),j=p(e,"P",{}),ae(j).forEach(l),W=n(e),I(M.$$.fragment,e),G=n(e),r=p(e,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1sptwg7"&&(r.innerHTML=L),g=n(e),m=p(e,"P",{"data-svelte-h":!0}),d(m)!=="svelte-mj4045"&&(m.textContent=K),V=n(e),c=p(e,"TABLE",{"data-svelte-h":!0}),d(c)!=="svelte-j2tc6m"&&(c.innerHTML=P),R=n(e),y=p(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1o4amtu"&&(y.innerHTML=q),Q=n(e),u=p(e,"P",{"data-svelte-h":!0}),d(u)!=="svelte-tifeyo"&&(u.innerHTML=O),X=n(e),I(T.$$.fragment,e),x=n(e),J=p(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-3xa704"&&(J.textContent=ee),v=n(e),I(w.$$.fragment,e),$=n(e),f=p(e,"P",{"data-svelte-h":!0}),d(f)!=="svelte-z5gykk"&&(f.innerHTML=te),F=n(e),I(h.$$.fragment,e),Y=n(e),U=p(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1hk759o"&&(U.innerHTML=le),H=n(e),I(b.$$.fragment,e),N=n(e),_=p(e,"P",{}),ae(_).forEach(l),this.h()},h(){se(o,"name","hf:doc:metadata"),se(o,"content",ue)},m(e,t){re(document.head,o),a(e,A,t),a(e,j,t),a(e,W,t),E(M,e,t),a(e,G,t),a(e,r,t),a(e,g,t),a(e,m,t),a(e,V,t),a(e,c,t),a(e,R,t),a(e,y,t),a(e,Q,t),a(e,u,t),a(e,X,t),E(T,e,t),a(e,x,t),a(e,J,t),a(e,v,t),E(w,e,t),a(e,$,t),a(e,f,t),a(e,F,t),E(h,e,t),a(e,Y,t),a(e,U,t),a(e,H,t),E(b,e,t),a(e,N,t),a(e,_,t),S=!0},p:ie,i(e){S||(Z(M.$$.fragment,e),Z(T.$$.fragment,e),Z(w.$$.fragment,e),Z(h.$$.fragment,e),Z(b.$$.fragment,e),S=!0)},o(e){k(M.$$.fragment,e),k(T.$$.fragment,e),k(w.$$.fragment,e),k(h.$$.fragment,e),k(b.$$.fragment,e),S=!1},d(e){e&&(l(A),l(j),l(W),l(G),l(r),l(g),l(m),l(V),l(c),l(R),l(y),l(Q),l(u),l(X),l(x),l(J),l(v),l($),l(f),l(F),l(Y),l(U),l(H),l(N),l(_)),l(o),B(M,e),B(T,e),B(w,e),B(h,e),B(b,e)}}}const ue='{"title":"Adapter injection","local":"adapter-injection","sections":[],"depth":1}';function Te(z){return pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ue extends oe{constructor(o){super(),de(this,o,Te,ye,ne,{})}}export{Ue as component};
