import{s as Vt,o as Et,n as Ue}from"../chunks/scheduler.c57aa7ef.js";import{S as Nt,i as xt,g as w,s as o,r as M,A as Ht,h as U,f as a,c as r,j as zt,u as d,x as b,k as ut,y as qt,a as l,v as f,d as y,t as h,w as u}from"../chunks/index.c50cb18e.js";import{T as Jt}from"../chunks/Tip.9268b0ca.js";import{C as j}from"../chunks/CodeBlock.34f0a53d.js";import{H as we,E as St}from"../chunks/EditOnGithub.958a8a49.js";import{H as Lt,a as ht}from"../chunks/HfOption.189bbdfa.js";function Dt($){let s,T='Some familiarity with the general process of training an image classification model would be really helpful and allow you to focus on the low-rank decomposition methods. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/image_classification" rel="nofollow">Image classification</a> guide first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!';return{c(){s=w("p"),s.innerHTML=T},l(i){s=U(i,"P",{"data-svelte-h":!0}),b(s)!=="svelte-122rdqq"&&(s.innerHTML=T)},m(i,p){l(i,s,p)},p:Ue,d(i){i&&a(s)}}}function Pt($){let s,T='Call the <a href="/docs/peft/pr_1887/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of parameters of <a href="/docs/peft/pr_1887/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!';return{c(){s=w("p"),s.innerHTML=T},l(i){s=U(i,"P",{"data-svelte-h":!0}),b(s)!=="svelte-265d5"&&(s.innerHTML=T)},m(i,p){l(i,s,p)},p:Ue,d(i){i&&a(s)}}}function Kt($){let s,T='<a href="../conceptual_guides/adapter#low-rank-adaptation-lora">LoRA</a> decomposes the weight update matrix into <em>two</em> smaller matrices. The size of these low-rank matrices is determined by its <em>rank</em> or <code>r</code>. A higher rank means the model has more parameters to train, but it also means the model has more learning capacity. You’ll also want to specify the <code>target_modules</code> which determine where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>lora_alpha</code> (scaling factor), <code>bias</code> (whether <code>none</code>, <code>all</code> or only the LoRA bias parameters should be trained), and <code>modules_to_save</code> (the modules apart from the LoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/pr_1887/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>.',i,p,c;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiU1RCUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKSUwQW1vZGVsLnByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKCklMEElMjJ0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjA2NjclMkM0OTMlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA4NiUyQzU0MyUyQzgxOCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuNzcxMjc3NTA0NzY2NDI5NCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    lora_dropout=<span class="hljs-number">0.1</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 667,493 || all params: 86,543,818 || trainable%: 0.7712775047664294&quot;</span>`,wrap:!1}}),{c(){s=w("p"),s.innerHTML=T,i=o(),M(p.$$.fragment)},l(n){s=U(n,"P",{"data-svelte-h":!0}),b(s)!=="svelte-ra3kvb"&&(s.innerHTML=T),i=r(n),d(p.$$.fragment,n)},m(n,J){l(n,s,J),l(n,i,J),f(p,n,J),c=!0},p:Ue,i(n){c||(y(p.$$.fragment,n),c=!0)},o(n){h(p.$$.fragment,n),c=!1},d(n){n&&(a(s),a(i)),u(p,n)}}}function Ot($){let s,T='<a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">LoHa</a> decomposes the weight update matrix into <em>four</em> smaller matrices and each pair of smaller matrices is combined with the Hadamard product. This allows the weight update matrix to keep the same number of trainable parameters when compared to LoRA, but with a higher rank (<code>r^2</code> for LoHA when compared to <code>2*r</code> for LoRA). The size of the smaller matrices is determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoHa layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/pr_1887/en/package_reference/loha#peft.LoHaConfig">LoHaConfig</a>.',i,p,c;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0hhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0hhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMSUyQzI1NyUyQzMxNyUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDg3JTJDMTMzJTJDNjQyJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS40NDI5NzUzNzc5ODMxNjc2JTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoHaConfig, get_peft_model

config = LoHaConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 1,257,317 || all params: 87,133,642 || trainable%: 1.4429753779831676&quot;</span>`,wrap:!1}}),{c(){s=w("p"),s.innerHTML=T,i=o(),M(p.$$.fragment)},l(n){s=U(n,"P",{"data-svelte-h":!0}),b(s)!=="svelte-14tx5is"&&(s.innerHTML=T),i=r(n),d(p.$$.fragment,n)},m(n,J){l(n,s,J),l(n,i,J),f(p,n,J),c=!0},p:Ue,i(n){c||(y(p.$$.fragment,n),c=!0)},o(n){h(p.$$.fragment,n),c=!1},d(n){n&&(a(s),a(i)),u(p,n)}}}function ea($){let s,T='<a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">LoKr</a> expresses the weight update matrix as a decomposition of a Kronecker product, creating a block matrix that is able to preserve the rank of the original weight matrix. The size of the smaller matrices are determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoKr layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/pr_1887/en/package_reference/lokr#peft.LoKrConfig">LoKrConfig</a>.',i,p,c;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0tyQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0tyQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMTE2JTJDMDY5JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkMxNzIlMkMwNDIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjEzMzE0OTM0MTYyMDMzMjgyJTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoKrConfig, get_peft_model

config = LoKrConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 116,069 || all params: 87,172,042 || trainable%: 0.13314934162033282&quot;</span>`,wrap:!1}}),{c(){s=w("p"),s.innerHTML=T,i=o(),M(p.$$.fragment)},l(n){s=U(n,"P",{"data-svelte-h":!0}),b(s)!=="svelte-h4w9u1"&&(s.innerHTML=T),i=r(n),d(p.$$.fragment,n)},m(n,J){l(n,s,J),l(n,i,J),f(p,n,J),c=!0},p:Ue,i(n){c||(y(p.$$.fragment,n),c=!0)},o(n){h(p.$$.fragment,n),c=!1},d(n){n&&(a(s),a(i)),u(p,n)}}}function ta($){let s,T='<a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">AdaLoRA</a> efficiently manages the LoRA parameter budget by assigning important weight matrices more parameters and pruning less important ones. In contrast, LoRA evenly distributes parameters across all modules. You can control the average desired <em>rank</em> or <code>r</code> of the matrices, and which modules to apply AdaLoRA to with <code>target_modules</code>. Other important parameters to set are <code>lora_alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the AdaLoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/pr_1887/en/package_reference/adalora#peft.AdaLoraConfig">AdaLoraConfig</a>.',i,p,c;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBZGFMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBBZGFMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwaW5pdF9yJTNEMTIlMkMlMEElMjAlMjAlMjAlMjB0aW5pdCUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHRmaW5hbCUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBkZWx0YVQlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNTIwJTJDMzI1JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkM2MTQlMkM3MjIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjU5Mzg3ODUwMzY2MDYwNjIlMjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AdaLoraConfig, get_peft_model

config = AdaLoraConfig(
    r=<span class="hljs-number">8</span>,
    init_r=<span class="hljs-number">12</span>,
    tinit=<span class="hljs-number">200</span>,
    tfinal=<span class="hljs-number">1000</span>,
    deltaT=<span class="hljs-number">10</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 520,325 || all params: 87,614,722 || trainable%: 0.5938785036606062&quot;</span>`,wrap:!1}}),{c(){s=w("p"),s.innerHTML=T,i=o(),M(p.$$.fragment)},l(n){s=U(n,"P",{"data-svelte-h":!0}),b(s)!=="svelte-18dj8s1"&&(s.innerHTML=T),i=r(n),d(p.$$.fragment,n)},m(n,J){l(n,s,J),l(n,i,J),f(p,n,J),c=!0},p:Ue,i(n){c||(y(p.$$.fragment,n),c=!0)},o(n){h(p.$$.fragment,n),c=!1},d(n){n&&(a(s),a(i)),u(p,n)}}}function aa($){let s,T,i,p,c,n,J,B;return s=new ht({props:{id:"loras",option:"LoRA",$$slots:{default:[Kt]},$$scope:{ctx:$}}}),i=new ht({props:{id:"loras",option:"LoHa",$$slots:{default:[Ot]},$$scope:{ctx:$}}}),c=new ht({props:{id:"loras",option:"LoKr",$$slots:{default:[ea]},$$scope:{ctx:$}}}),J=new ht({props:{id:"loras",option:"AdaLoRA",$$slots:{default:[ta]},$$scope:{ctx:$}}}),{c(){M(s.$$.fragment),T=o(),M(i.$$.fragment),p=o(),M(c.$$.fragment),n=o(),M(J.$$.fragment)},l(m){d(s.$$.fragment,m),T=r(m),d(i.$$.fragment,m),p=r(m),d(c.$$.fragment,m),n=r(m),d(J.$$.fragment,m)},m(m,g){f(s,m,g),l(m,T,g),f(i,m,g),l(m,p,g),f(c,m,g),l(m,n,g),f(J,m,g),B=!0},p(m,g){const Te={};g&2&&(Te.$$scope={dirty:g,ctx:m}),s.$set(Te);const v={};g&2&&(v.$$scope={dirty:g,ctx:m}),i.$set(v);const C={};g&2&&(C.$$scope={dirty:g,ctx:m}),c.$set(C);const be={};g&2&&(be.$$scope={dirty:g,ctx:m}),J.$set(be)},i(m){B||(y(s.$$.fragment,m),y(i.$$.fragment,m),y(c.$$.fragment,m),y(J.$$.fragment,m),B=!0)},o(m){h(s.$$.fragment,m),h(i.$$.fragment,m),h(c.$$.fragment,m),h(J.$$.fragment,m),B=!1},d(m){m&&(a(T),a(p),a(n)),u(s,m),u(i,m),u(c,m),u(J,m)}}}function la($){let s,T='AdaLoRA has an <a href="/docs/peft/pr_1887/en/package_reference/adalora#peft.AdaLoraModel.update_and_allocate">update_and_allocate()</a> method that should be called at each training step to update the parameter budget and mask, otherwise the adaptation step is not performed. This requires writing a custom training loop or subclassing the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> to incorporate this method. As an example, take a look at this <a href="https://github.com/huggingface/peft/blob/912ad41e96e03652cabf47522cd876076f7a0c4f/examples/conditional_generation/peft_adalora_seq2seq.py#L120" rel="nofollow">custom training loop</a>.';return{c(){s=w("p"),s.innerHTML=T},l(i){s=U(i,"P",{"data-svelte-h":!0}),b(s)!=="svelte-z09p5z"&&(s.innerHTML=T)},m(i,p){l(i,s,p)},p:Ue,d(i){i&&a(s)}}}function sa($){let s,T,i,p,c,n,J,B="A popular way to efficiently train large models is to insert (typically in the attention blocks) smaller trainable matrices that are a low-rank decomposition of the delta weight matrix to be learnt during finetuning. The pretrained model’s original weight matrix is frozen and only the smaller matrices are updated during training. This reduces the number of trainable parameters, reducing memory usage and training time which can be very expensive for large models.",m,g,Te='There are several different ways to express the weight matrix as a low-rank decomposition, but <a href="../conceptual_guides/adapter#low-rank-adaptation-lora">Low-Rank Adaptation (LoRA)</a> is the most common method. The PEFT library supports several other LoRA variants, such as <a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">Low-Rank Hadamard Product (LoHa)</a>, <a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">Low-Rank Kronecker Product (LoKr)</a>, and <a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">Adaptive Low-Rank Adaptation (AdaLoRA)</a>. You can learn more about how these methods work conceptually in the <a href="../conceptual_guides/adapter">Adapters</a> guide. If you’re interested in applying these methods to other tasks and use cases like semantic segmentation, token classification, take a look at our <a href="https://huggingface.co/collections/PEFT/notebooks-6573b28b33e5a4bf5b157fc1" rel="nofollow">notebook collection</a>!',v,C,be="This guide will show you how to quickly train an image classification model - with a low-rank decomposition method - to identify the class of food shown in an image.",je,_,$e,Q,wt="Before you begin, make sure you have all the necessary libraries installed.",Ce,R,_e,G,Ze,X,Ut='In this guide, you’ll use the <a href="https://huggingface.co/datasets/food101" rel="nofollow">Food-101</a> dataset which contains images of 101 food classes (take a look at the <a href="https://huggingface.co/datasets/food101/viewer/default/train" rel="nofollow">dataset viewer</a> to get a better idea of what the dataset looks like).',Ie,F,Tt='Load the dataset with the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">load_dataset</a> function.',ke,Y,We,A,bt="Each food class is labeled with an integer, so to make it easier to understand what these integers represent, you’ll create a <code>label2id</code> and <code>id2label</code> dictionary to map the integer to its class label.",Be,z,ve,V,gt="Load an image processor to properly resize and normalize the pixel values of the training and evaluation images.",Qe,E,Re,N,jt="You can also use the image processor to prepare some transformation functions for data augmentation and pixel scaling.",Ge,x,Xe,H,$t='Define the training and validation datasets, and use the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.set_transform" rel="nofollow">set_transform</a> function to apply the transformations on-the-fly.',Fe,q,Ye,S,Ct="Finally, you’ll need a data collator to create a batch of training and evaluation data and convert the labels to <code>torch.tensor</code> objects.",Ae,L,ze,D,Ve,P,_t='Now let’s load a pretrained model to use as the base model. This guide uses the <a href="https://huggingface.co/google/vit-base-patch16-224-in21k" rel="nofollow">google/vit-base-patch16-224-in21k</a> model, but you can use any image classification model you want. Pass the <code>label2id</code> and <code>id2label</code> dictionaries to the model so it knows how to map the integer labels to their class labels, and you can optionally pass the <code>ignore_mismatched_sizes=True</code> parameter if you’re finetuning a checkpoint that has already been finetuned.',Ee,K,Ne,O,xe,ee,Zt='Every PEFT method requires a configuration that holds all the parameters specifying how the PEFT method should be applied. Once the configuration is setup, pass it to the <a href="/docs/peft/pr_1887/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/pr_1887/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',He,Z,qe,I,Se,te,Le,ae,It='For training, let’s use the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from Transformers. The <code>Trainer</code> contains a PyTorch training loop, and when you’re ready, call <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a> to start training. To customize the training run, configure the training hyperparameters in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> class. With LoRA-like methods, you can afford to use a higher batch size and learning rate.',De,k,Pe,le,Ke,se,kt='Begin training with <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a>.',Oe,ne,et,oe,tt,re,Wt='Once training is complete, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.',at,ie,lt,pe,Bt='Call <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> to save your model to your repositoy.',st,me,nt,ce,ot,Me,vt="Let’s load the model from the Hub and test it out on a food image.",rt,de,it,W,Qt='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg"/>',pt,fe,Rt="Convert the image to RGB and return the underlying PyTorch tensors.",mt,ye,ct,he,Gt="Now run the model and return the predicted class!",Mt,ue,dt,Je,ft,ge,yt;return c=new we({props:{title:"LoRA methods",local:"lora-methods",headingTag:"h1"}}),_=new Jt({props:{$$slots:{default:[Dt]},$$scope:{ctx:$}}}),R=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcGVmdCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRz",highlighted:"pip install -q peft transformers datasets",wrap:!1}}),G=new we({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),Y=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZm9vZDEwMSUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)`,wrap:!1}}),z=new j({props:{code:"bGFiZWxzJTIwJTNEJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVELm5hbWVzJTBBbGFiZWwyaWQlMkMlMjBpZDJsYWJlbCUyMCUzRCUyMGRpY3QoKSUyQyUyMGRpY3QoKSUwQWZvciUyMGklMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjBsYWJlbDJpZCU1QmxhYmVsJTVEJTIwJTNEJTIwaSUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTVCaSU1RCUyMCUzRCUyMGxhYmVsJTBBJTBBaWQybGFiZWwlNUIyJTVEJTBBJTIyYmFrbGF2YSUyMg==",highlighted:`labels = ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>].names
label2id, id2label = <span class="hljs-built_in">dict</span>(), <span class="hljs-built_in">dict</span>()
<span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(labels):
    label2id[label] = i
    id2label[i] = label

id2label[<span class="hljs-number">2</span>]
<span class="hljs-string">&quot;baklava&quot;</span>`,wrap:!1}}),E=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQtaW4yMWslMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>)`,wrap:!1}}),x=new j({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ2VudGVyQ3JvcCUyQyUwQSUyMCUyMCUyMCUyMENvbXBvc2UlMkMlMEElMjAlMjAlMjAlMjBOb3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbVJlc2l6ZWRDcm9wJTJDJTBBJTIwJTIwJTIwJTIwUmVzaXplJTJDJTBBJTIwJTIwJTIwJTIwVG9UZW5zb3IlMkMlMEEpJTBBJTBBbm9ybWFsaXplJTIwJTNEJTIwTm9ybWFsaXplKG1lYW4lM0RpbWFnZV9wcm9jZXNzb3IuaW1hZ2VfbWVhbiUyQyUyMHN0ZCUzRGltYWdlX3Byb2Nlc3Nvci5pbWFnZV9zdGQpJTBBdHJhaW5fdHJhbnNmb3JtcyUyMCUzRCUyMENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tUmVzaXplZENyb3AoaW1hZ2VfcHJvY2Vzc29yLnNpemUlNUIlMjJoZWlnaHQlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBdmFsX3RyYW5zZm9ybXMlMjAlM0QlMjBDb21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlc2l6ZShpbWFnZV9wcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDZW50ZXJDcm9wKGltYWdlX3Byb2Nlc3Nvci5zaXplJTVCJTIyaGVpZ2h0JTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVfYmF0Y2glNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjAlNUJ0cmFpbl90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaCUwQSUwQWRlZiUyMHByZXByb2Nlc3NfdmFsKGV4YW1wbGVfYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZV9iYXRjaCU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnZhbF90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaA==",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
    CenterCrop,
    Compose,
    Normalize,
    RandomHorizontalFlip,
    RandomResizedCrop,
    Resize,
    ToTensor,
)

normalize = Normalize(mean=image_processor.image_mean, std=image_processor.image_std)
train_transforms = Compose(
    [
        RandomResizedCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        RandomHorizontalFlip(),
        ToTensor(),
        normalize,
    ]
)

val_transforms = Compose(
    [
        Resize(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        CenterCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        ToTensor(),
        normalize,
    ]
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [train_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_val</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch`,wrap:!1}}),q=new j({props:{code:"dHJhaW5fZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVEJTBBdmFsX2RzJTIwJTNEJTIwZHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTBBJTBBdHJhaW5fZHMuc2V0X3RyYW5zZm9ybShwcmVwcm9jZXNzX3RyYWluKSUwQXZhbF9kcy5zZXRfdHJhbnNmb3JtKHByZXByb2Nlc3NfdmFsKQ==",highlighted:`train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
val_ds = ds[<span class="hljs-string">&quot;validation&quot;</span>]

train_ds.set_transform(preprocess_train)
val_ds.set_transform(preprocess_val)`,wrap:!1}}),L=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBjb2xsYXRlX2ZuKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QmV4YW1wbGUlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZXhhbXBsZSU1QiUyMmxhYmVsJTIyJTVEJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwcGl4ZWxfdmFsdWVzJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwbGFiZWxzJTdE",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    pixel_values = torch.stack([example[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}`,wrap:!1}}),D=new we({props:{title:"Model",local:"model",headingTag:"h2"}}),K=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUyMFRyYWluZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, TrainingArguments, Trainer

model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),O=new we({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),Z=new Jt({props:{$$slots:{default:[Pt]},$$scope:{ctx:$}}}),I=new Lt({props:{id:"loras",options:["LoRA","LoHa","LoKr","AdaLoRA"],$$slots:{default:[aa]},$$scope:{ctx:$}}}),te=new we({props:{title:"Training",local:"training",headingTag:"h3"}}),k=new Jt({props:{warning:!0,$$slots:{default:[la]},$$scope:{ctx:$}}}),le=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQWFjY291bnQlMjAlM0QlMjAlMjJzdGV2aGxpdSUyMiUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjBmJTIyJTdCYWNjb3VudCU3RCUyRmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrLWxvcmElMjIlMEFiYXRjaF9zaXplJTIwJTNEJTIwMTI4JTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlZnRfbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfdW51c2VkX2NvbHVtbnMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0Q1ZS0zJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

account = <span class="hljs-string">&quot;stevhliu&quot;</span>
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/google/vit-base-patch16-224-in21k-lora&quot;</span>
batch_size = <span class="hljs-number">128</span>

args = TrainingArguments(
    peft_model_id,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">5e-3</span>,
    per_device_train_batch_size=batch_size,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    per_device_eval_batch_size=batch_size,
    fp16=<span class="hljs-literal">True</span>,
    num_train_epochs=<span class="hljs-number">5</span>,
    logging_steps=<span class="hljs-number">10</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
)`,wrap:!1}}),ne=new j({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdmFsX2RzJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEaW1hZ2VfcHJvY2Vzc29yJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGNvbGxhdGVfZm4lMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`trainer = Trainer(
    model,
    args,
    train_dataset=train_ds,
    eval_dataset=val_ds,
    tokenizer=image_processor,
    data_collator=collate_fn,
)
trainer.train()`,wrap:!1}}),oe=new we({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),ie=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),me=new j({props:{code:"bW9kZWwucHVzaF90b19odWIocGVmdF9tb2RlbF9pZCk=",highlighted:"model.push_to_hub(peft_model_id)",wrap:!1}}),ce=new we({props:{title:"Inference",local:"inference",headingTag:"h2"}}),de=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTJDJTIwUGVmdE1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyc3RldmhsaXUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1pbjIxay1sb3JhJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLmJhc2VfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwJTIyc3RldmhsaXUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1pbjIxay1sb3JhJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnNheWFrcGF1bCUyRnNhbXBsZS1kYXRhc2V0cyUyRnJlc29sdmUlMkZtYWluJTJGYmVpZ25ldHMuanBlZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig, PeftModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

config = PeftConfig.from_pretrained(<span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(
    config.base_model_name_or_path,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)
model = PeftModel.from_pretrained(model, <span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image`,wrap:!1}}),ye=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'encoding = image_processor(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ue=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kaW5nKSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCklMEElMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMGJlaWduZXRzJTIy",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**encoding)
    logits = outputs.logits

predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
<span class="hljs-string">&quot;Predicted class: beignets&quot;</span>`,wrap:!1}}),Je=new St({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/task_guides/lora_based_methods.md"}}),{c(){s=w("meta"),T=o(),i=w("p"),p=o(),M(c.$$.fragment),n=o(),J=w("p"),J.textContent=B,m=o(),g=w("p"),g.innerHTML=Te,v=o(),C=w("p"),C.textContent=be,je=o(),M(_.$$.fragment),$e=o(),Q=w("p"),Q.textContent=wt,Ce=o(),M(R.$$.fragment),_e=o(),M(G.$$.fragment),Ze=o(),X=w("p"),X.innerHTML=Ut,Ie=o(),F=w("p"),F.innerHTML=Tt,ke=o(),M(Y.$$.fragment),We=o(),A=w("p"),A.innerHTML=bt,Be=o(),M(z.$$.fragment),ve=o(),V=w("p"),V.textContent=gt,Qe=o(),M(E.$$.fragment),Re=o(),N=w("p"),N.textContent=jt,Ge=o(),M(x.$$.fragment),Xe=o(),H=w("p"),H.innerHTML=$t,Fe=o(),M(q.$$.fragment),Ye=o(),S=w("p"),S.innerHTML=Ct,Ae=o(),M(L.$$.fragment),ze=o(),M(D.$$.fragment),Ve=o(),P=w("p"),P.innerHTML=_t,Ee=o(),M(K.$$.fragment),Ne=o(),M(O.$$.fragment),xe=o(),ee=w("p"),ee.innerHTML=Zt,He=o(),M(Z.$$.fragment),qe=o(),M(I.$$.fragment),Se=o(),M(te.$$.fragment),Le=o(),ae=w("p"),ae.innerHTML=It,De=o(),M(k.$$.fragment),Pe=o(),M(le.$$.fragment),Ke=o(),se=w("p"),se.innerHTML=kt,Oe=o(),M(ne.$$.fragment),et=o(),M(oe.$$.fragment),tt=o(),re=w("p"),re.innerHTML=Wt,at=o(),M(ie.$$.fragment),lt=o(),pe=w("p"),pe.innerHTML=Bt,st=o(),M(me.$$.fragment),nt=o(),M(ce.$$.fragment),ot=o(),Me=w("p"),Me.textContent=vt,rt=o(),M(de.$$.fragment),it=o(),W=w("div"),W.innerHTML=Qt,pt=o(),fe=w("p"),fe.textContent=Rt,mt=o(),M(ye.$$.fragment),ct=o(),he=w("p"),he.textContent=Gt,Mt=o(),M(ue.$$.fragment),dt=o(),M(Je.$$.fragment),ft=o(),ge=w("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);s=U(t,"META",{name:!0,content:!0}),t.forEach(a),T=r(e),i=U(e,"P",{}),zt(i).forEach(a),p=r(e),d(c.$$.fragment,e),n=r(e),J=U(e,"P",{"data-svelte-h":!0}),b(J)!=="svelte-3c4mx2"&&(J.textContent=B),m=r(e),g=U(e,"P",{"data-svelte-h":!0}),b(g)!=="svelte-1mec8a1"&&(g.innerHTML=Te),v=r(e),C=U(e,"P",{"data-svelte-h":!0}),b(C)!=="svelte-3yvnz9"&&(C.textContent=be),je=r(e),d(_.$$.fragment,e),$e=r(e),Q=U(e,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-1rdzhb1"&&(Q.textContent=wt),Ce=r(e),d(R.$$.fragment,e),_e=r(e),d(G.$$.fragment,e),Ze=r(e),X=U(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-l33v6t"&&(X.innerHTML=Ut),Ie=r(e),F=U(e,"P",{"data-svelte-h":!0}),b(F)!=="svelte-zwwqy7"&&(F.innerHTML=Tt),ke=r(e),d(Y.$$.fragment,e),We=r(e),A=U(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-1a5q7dy"&&(A.innerHTML=bt),Be=r(e),d(z.$$.fragment,e),ve=r(e),V=U(e,"P",{"data-svelte-h":!0}),b(V)!=="svelte-13cytaa"&&(V.textContent=gt),Qe=r(e),d(E.$$.fragment,e),Re=r(e),N=U(e,"P",{"data-svelte-h":!0}),b(N)!=="svelte-1p1x6w4"&&(N.textContent=jt),Ge=r(e),d(x.$$.fragment,e),Xe=r(e),H=U(e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-xbqbtr"&&(H.innerHTML=$t),Fe=r(e),d(q.$$.fragment,e),Ye=r(e),S=U(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-mznco7"&&(S.innerHTML=Ct),Ae=r(e),d(L.$$.fragment,e),ze=r(e),d(D.$$.fragment,e),Ve=r(e),P=U(e,"P",{"data-svelte-h":!0}),b(P)!=="svelte-akpunr"&&(P.innerHTML=_t),Ee=r(e),d(K.$$.fragment,e),Ne=r(e),d(O.$$.fragment,e),xe=r(e),ee=U(e,"P",{"data-svelte-h":!0}),b(ee)!=="svelte-14x5mc4"&&(ee.innerHTML=Zt),He=r(e),d(Z.$$.fragment,e),qe=r(e),d(I.$$.fragment,e),Se=r(e),d(te.$$.fragment,e),Le=r(e),ae=U(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-wcjxic"&&(ae.innerHTML=It),De=r(e),d(k.$$.fragment,e),Pe=r(e),d(le.$$.fragment,e),Ke=r(e),se=U(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-ntqszh"&&(se.innerHTML=kt),Oe=r(e),d(ne.$$.fragment,e),et=r(e),d(oe.$$.fragment,e),tt=r(e),re=U(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-vaxac6"&&(re.innerHTML=Wt),at=r(e),d(ie.$$.fragment,e),lt=r(e),pe=U(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-1qc4exu"&&(pe.innerHTML=Bt),st=r(e),d(me.$$.fragment,e),nt=r(e),d(ce.$$.fragment,e),ot=r(e),Me=U(e,"P",{"data-svelte-h":!0}),b(Me)!=="svelte-1whrqzq"&&(Me.textContent=vt),rt=r(e),d(de.$$.fragment,e),it=r(e),W=U(e,"DIV",{class:!0,"data-svelte-h":!0}),b(W)!=="svelte-sucph9"&&(W.innerHTML=Qt),pt=r(e),fe=U(e,"P",{"data-svelte-h":!0}),b(fe)!=="svelte-1nlb27h"&&(fe.textContent=Rt),mt=r(e),d(ye.$$.fragment,e),ct=r(e),he=U(e,"P",{"data-svelte-h":!0}),b(he)!=="svelte-1mvhoi"&&(he.textContent=Gt),Mt=r(e),d(ue.$$.fragment,e),dt=r(e),d(Je.$$.fragment,e),ft=r(e),ge=U(e,"P",{}),zt(ge).forEach(a),this.h()},h(){ut(s,"name","hf:doc:metadata"),ut(s,"content",na),ut(W,"class","flex justify-center")},m(e,t){qt(document.head,s),l(e,T,t),l(e,i,t),l(e,p,t),f(c,e,t),l(e,n,t),l(e,J,t),l(e,m,t),l(e,g,t),l(e,v,t),l(e,C,t),l(e,je,t),f(_,e,t),l(e,$e,t),l(e,Q,t),l(e,Ce,t),f(R,e,t),l(e,_e,t),f(G,e,t),l(e,Ze,t),l(e,X,t),l(e,Ie,t),l(e,F,t),l(e,ke,t),f(Y,e,t),l(e,We,t),l(e,A,t),l(e,Be,t),f(z,e,t),l(e,ve,t),l(e,V,t),l(e,Qe,t),f(E,e,t),l(e,Re,t),l(e,N,t),l(e,Ge,t),f(x,e,t),l(e,Xe,t),l(e,H,t),l(e,Fe,t),f(q,e,t),l(e,Ye,t),l(e,S,t),l(e,Ae,t),f(L,e,t),l(e,ze,t),f(D,e,t),l(e,Ve,t),l(e,P,t),l(e,Ee,t),f(K,e,t),l(e,Ne,t),f(O,e,t),l(e,xe,t),l(e,ee,t),l(e,He,t),f(Z,e,t),l(e,qe,t),f(I,e,t),l(e,Se,t),f(te,e,t),l(e,Le,t),l(e,ae,t),l(e,De,t),f(k,e,t),l(e,Pe,t),f(le,e,t),l(e,Ke,t),l(e,se,t),l(e,Oe,t),f(ne,e,t),l(e,et,t),f(oe,e,t),l(e,tt,t),l(e,re,t),l(e,at,t),f(ie,e,t),l(e,lt,t),l(e,pe,t),l(e,st,t),f(me,e,t),l(e,nt,t),f(ce,e,t),l(e,ot,t),l(e,Me,t),l(e,rt,t),f(de,e,t),l(e,it,t),l(e,W,t),l(e,pt,t),l(e,fe,t),l(e,mt,t),f(ye,e,t),l(e,ct,t),l(e,he,t),l(e,Mt,t),f(ue,e,t),l(e,dt,t),f(Je,e,t),l(e,ft,t),l(e,ge,t),yt=!0},p(e,[t]){const Xt={};t&2&&(Xt.$$scope={dirty:t,ctx:e}),_.$set(Xt);const Ft={};t&2&&(Ft.$$scope={dirty:t,ctx:e}),Z.$set(Ft);const Yt={};t&2&&(Yt.$$scope={dirty:t,ctx:e}),I.$set(Yt);const At={};t&2&&(At.$$scope={dirty:t,ctx:e}),k.$set(At)},i(e){yt||(y(c.$$.fragment,e),y(_.$$.fragment,e),y(R.$$.fragment,e),y(G.$$.fragment,e),y(Y.$$.fragment,e),y(z.$$.fragment,e),y(E.$$.fragment,e),y(x.$$.fragment,e),y(q.$$.fragment,e),y(L.$$.fragment,e),y(D.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(Z.$$.fragment,e),y(I.$$.fragment,e),y(te.$$.fragment,e),y(k.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(ie.$$.fragment,e),y(me.$$.fragment,e),y(ce.$$.fragment,e),y(de.$$.fragment,e),y(ye.$$.fragment,e),y(ue.$$.fragment,e),y(Je.$$.fragment,e),yt=!0)},o(e){h(c.$$.fragment,e),h(_.$$.fragment,e),h(R.$$.fragment,e),h(G.$$.fragment,e),h(Y.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(x.$$.fragment,e),h(q.$$.fragment,e),h(L.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(Z.$$.fragment,e),h(I.$$.fragment,e),h(te.$$.fragment,e),h(k.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(de.$$.fragment,e),h(ye.$$.fragment,e),h(ue.$$.fragment,e),h(Je.$$.fragment,e),yt=!1},d(e){e&&(a(T),a(i),a(p),a(n),a(J),a(m),a(g),a(v),a(C),a(je),a($e),a(Q),a(Ce),a(_e),a(Ze),a(X),a(Ie),a(F),a(ke),a(We),a(A),a(Be),a(ve),a(V),a(Qe),a(Re),a(N),a(Ge),a(Xe),a(H),a(Fe),a(Ye),a(S),a(Ae),a(ze),a(Ve),a(P),a(Ee),a(Ne),a(xe),a(ee),a(He),a(qe),a(Se),a(Le),a(ae),a(De),a(Pe),a(Ke),a(se),a(Oe),a(et),a(tt),a(re),a(at),a(lt),a(pe),a(st),a(nt),a(ot),a(Me),a(rt),a(it),a(W),a(pt),a(fe),a(mt),a(ct),a(he),a(Mt),a(dt),a(ft),a(ge)),a(s),u(c,e),u(_,e),u(R,e),u(G,e),u(Y,e),u(z,e),u(E,e),u(x,e),u(q,e),u(L,e),u(D,e),u(K,e),u(O,e),u(Z,e),u(I,e),u(te,e),u(k,e),u(le,e),u(ne,e),u(oe,e),u(ie,e),u(me,e),u(ce,e),u(de,e),u(ye,e),u(ue,e),u(Je,e)}}}const na='{"title":"LoRA methods","local":"lora-methods","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function oa($){return Et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class da extends Nt{constructor(s){super(),xt(this,s,oa,sa,Vt,{})}}export{da as component};
