import{s as ns,o as ss,n as gt}from"../chunks/scheduler.b108d059.js";import{S as as,i as os,g as o,s,r,A as is,h as i,f as l,c as a,j as b,u as M,x as c,k as ls,y as m,a as n,v as p,d,t as h,w as T}from"../chunks/index.008de539.js";import{T as ft}from"../chunks/Tip.aeb15ab7.js";import{C as J}from"../chunks/CodeBlock.3968c746.js";import{H as f,E as us}from"../chunks/EditOnGithub.d1c48e3d.js";function cs(g){let u,U='GPU support on Cloud Run is only available as a waitlisted public preview. If you’re interested in trying out the feature, <a href="https://cloud.google.com/run/quotas#increase" rel="nofollow">request a quota increase</a> for <code>Total Nvidia L4 GPU allocation, per project per region</code>. At the time of writing this example, NVIDIA L4 GPUs (24GiB VRAM) are the only available GPUs on Cloud Run; enabling automatic scaling up to 7 instances by default (more available via quota), as well as scaling down to zero instances when there are no requests.';return{c(){u=o("p"),u.innerHTML=U},l(y){u=i(y,"P",{"data-svelte-h":!0}),c(u)!=="svelte-1bcphve"&&(u.innerHTML=U)},m(y,w){n(y,u,w)},p:gt,d(y){y&&l(u)}}}function rs(g){let u,U="The first time you deploy a new container on Cloud Run it will take around 5 minutes to deploy as it needs to import it from the Google Cloud Artifact Registry, but on the follow up deployments it will take less time as the image has been already imported before.";return{c(){u=o("p"),u.textContent=U},l(y){u=i(y,"P",{"data-svelte-h":!0}),c(u)!=="svelte-18e6hwd"&&(u.textContent=U)},m(y,w){n(y,u,w)},p:gt,d(y){y&&l(u)}}}function Ms(g){let u,U='The alternatives mentioned below are for development scenarios, and should not be used in production-ready scenarios as is. The approach below is following the guide defined in <a href="https://cloud.google.com/run/docs/authenticating/developers" rel="nofollow">Cloud Run Documentation - Authenticate Developers</a>; but you can find every other guide as mentioned above in <a href="https://cloud.google.com/run/docs/authenticating/overview" rel="nofollow">Cloud Run Documentation - Authentication overview</a>.';return{c(){u=o("p"),u.innerHTML=U},l(y){u=i(y,"P",{"data-svelte-h":!0}),c(u)!=="svelte-1qznp3b"&&(u.innerHTML=U)},m(y,w){n(y,u,w)},p:gt,d(y){y&&l(u)}}}function ps(g){let u,U="Note that the examples below are using the <code>/v1/chat/completions</code> TGI endpoint with is OpenAI-compatible, meaning that both <code>cURL</code> and Python are just some proposals, but any OpenAI-compatible client can be used instead.";return{c(){u=o("p"),u.innerHTML=U},l(y){u=i(y,"P",{"data-svelte-h":!0}),c(u)!=="svelte-11wzgde"&&(u.innerHTML=U)},m(y,w){n(y,u,w)},p:gt,d(y){y&&l(u)}}}function ds(g){let u,U="The access token is short-lived and will expire, typically after 1 hour; if you want to extend the lifetime of the token you can do so via the <code>--lifetime</code> argument within the same command, up until 12 hours (value needs to be specified in seconds). Otherwise, you can also generate a new token by running the same command again.";return{c(){u=o("p"),u.innerHTML=U},l(y){u=i(y,"P",{"data-svelte-h":!0}),c(u)!=="svelte-1w15y80"&&(u.innerHTML=U)},m(y,w){n(y,u,w)},p:gt,d(y){y&&l(u)}}}function hs(g){let u,U="Note that the examples below are using the <code>/v1/chat/completions</code> TGI endpoint with is OpenAI-compatible, meaning that both <code>cURL</code> and Python are just some proposals, but any OpenAI-compatible client can be used instead.";return{c(){u=o("p"),u.innerHTML=U},l(y){u=i(y,"P",{"data-svelte-h":!0}),c(u)!=="svelte-11wzgde"&&(u.innerHTML=U)},m(y,w){n(y,u,w)},p:gt,d(y){y&&l(u)}}}function Ts(g){let u,U,y,w,Z,jt,x,Mn="Meta Llama 3.1 is the latest open LLM from Meta, released in July 2024. Meta Llama 3.1 comes in three sizes: 8B for efficient deployment and development on consumer-size GPU, 70B for large-scale AI native applications, and 405B for synthetic data, LLM as a Judge or distillation; among other use cases. Text Generation Inference (TGI) is a toolkit developed by Hugging Face for deploying and serving LLMs, with high performance text generation. Google Cloud Run is a serverless container platform that allows developers to deploy and manage containerized applications without managing infrastructure, enabling automatic scaling and billing only for usage.",It,G,pn="This example showcases how to deploy an LLM from the Hugging Face Hub, in this case Meta Llama 3.1 8B Instruct model quantized to INT4 using AWQ, with the Hugging Face DLC for TGI on Google Cloud Run with GPU support (on preview).",$t,v,bt,L,vt,q,dn='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',At,Q,hn="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",Vt,k,Et,_,Tn="Then you need to login into your Google Cloud account and set the project ID you want to use to deploy Cloud Run.",Nt,W,Rt,B,yn="Once you are logged in, you need to enable the Cloud Run API, which is required for the Hugging Face DLC for TGI deployment on Cloud Run.",St,X,Zt,F,xt,Y,mn="Once you are all set, you can call the <code>gcloud beta run deploy</code> command (still on beta because GPU support is on preview, as mentioned above).",Gt,P,Jn="The <code>gcloud beta run deploy</code> command needs you to specify the following parameters:",Lt,H,Un='<li><code>--image</code>: The container image URI to deploy.</li> <li><code>--args</code>: The arguments to pass to the container entrypoint, being <code>text-generation-launcher</code> for the Hugging Face DLC for TGI. Read more about the supported arguments at <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher" rel="nofollow">Text-generation-launcher arguments</a>.<ul><li><code>--model-id</code>: The model ID to use, in this case, <a href="https://huggingface.co/hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4" rel="nofollow"><code>hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4</code></a>.</li> <li><code>--quantize</code>: The quantization method to use, in this case, <code>awq</code>. If not specified, it will be retrieved from the <code>quantization_config-&gt;quant_method</code> in the <code>config.json</code> file.</li></ul></li> <li><code>--port</code>: The port the container listens to.</li> <li><code>--cpu</code> and <code>--memory</code>: The number of CPUs and amount of memory to allocate to the container. Needs to be set to 8 and 32GiB, respectively; as that’s a requirement for using the GPU.</li> <li><code>--no-cpu-throttling</code>: Disables CPU throttling, which is required for using the GPU.</li> <li><code>--gpu</code> and <code>--gpu-type</code>: The number of GPUs and the GPU type to use. Needs to be set to 1 and <code>nvidia-l4</code>, respectively; as at the time of writing this tutorial, those are the only available options as Cloud Run on GPUs is still under preview.</li> <li><code>--max-instances</code>: The maximum number of instances to run, set to 3, but default value is 7. Alternatively, one could set it to 1 too, but that could eventually lead to downtime during infrastructure migrations, so anything above 1 is recommended.</li> <li><code>--concurrency</code>: the maximum number of concurrent requests per instance, set to 64. The value is not arbitrary, but determined after running and evaluating the results of <a href="https://github.com/huggingface/text-generation-inference/tree/main/benchmark" rel="nofollow"><code>text-generation-benchmark</code></a>, as the most optimal balance between throughput and latency; where the current default for TGI being 128 is a bit too much. Note that this value is also aligned with the <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher#maxconcurrentrequests" rel="nofollow"><code>--max-concurrent-requests</code></a> argument in TGI.</li> <li><code>--region</code>: The region to deploy the Cloud Run service.</li> <li><code>--no-allow-unauthenticated</code>: Disables unauthenticated access to the service, which is a good practice as adds an authentication layer managed by Google Cloud IAM.</li>',qt,D,Qt,z,wn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/cloud-run/tgi-deployment/imgs/cloud-run-deployment.png" alt="Cloud Run Deployment"/>',kt,O,fn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/cloud-run/tgi-deployment/imgs/cloud-run-details.png" alt="Cloud Run Deployment Details"/>',_t,A,Wt,K,Bt,ee,gn='Once deployed, you can send requests to the service via any of the supported TGI endpoints, check <a href="https://huggingface.github.io/text-generation-inference/" rel="nofollow">TGI’s OpenAPI Specification</a> to see all the available endpoints and their respective parameters.',Xt,te,Cn="All Cloud Run services are deployed privately by default, which means that they can’t be accessed without providing authentication credentials in the request headers. These services are secured by IAM and are only callable by Project Owners, Project Editors, and Cloud Run Admins and Cloud Run Invokers.",Ft,le,jn="In this case, a couple of alternatives to enable developer access will be showcased; while the other use cases are out of the scope of this example, as those are either not secure due to the authentication being disabled (for public access scenarios), or require additional setup for a production-ready scenarios (service-to-service authentication, end-user access).",Yt,V,Pt,ne,Ht,se,In="Cloud Run Proxy runs a server on localhost that proxies requests to the specified Cloud Run Service with credentials attached; which is useful for testing and experimentation.",Dt,ae,zt,oe,$n='Then you can send requests to the deployed service on Cloud Run, using the <a href="http://localhost:8080" rel="nofollow">http://localhost:8080</a> URL, with no authentication, exposed by the proxy as shown in the examples below.',Ot,E,Kt,ie,el,ue,bn="To send a POST request to the TGI service using <code>cURL</code>, you can run the following command:",tl,ce,ll,re,nl,Me,vn="To run the inference using Python, you can either use the <code>huggingface_hub</code> Python SDK (recommended) or the <code>openai</code> Python SDK.",sl,pe,al,de,An="You can install it via <code>pip</code> as <code>pip install --upgrade --quiet huggingface_hub</code>, and then run:",ol,he,il,Te,ul,ye,Vn="You can install it via <code>pip</code> as <code>pip install --upgrade openai</code>, and then run:",cl,me,rl,Je,Ml,Ue,En="Cloud Run Service has an unique URL assigned that can be used to send requests from anywhere, using the Google Cloud Credentials with Cloud Run Invoke access to the service; which is the recommended approach as it’s more secure and consistent than using the Cloud Run Proxy.",pl,we,Nn="The URL of the Cloud Run service can be obtained via the following command (assigned to the <code>SERVICE_URL</code> variable for convenience):",dl,fe,hl,ge,Rn="Then you can send requests to the deployed service on Cloud Run, using the <code>SERVICE_URL</code> and any Google Cloud Credentials with Cloud Run Invoke access. For setting up the credentials there are multiple approaches, some of those are listed below:",Tl,N,j,pt,Sn="Using the default identity token from the Google Cloud SDK:",Dl,dt,Zn="<li>Via <code>gcloud</code> as:</li>",zl,Ce,Ol,ht,xn="<li>Via Python as:</li>",Kl,je,en,Tt,Gn="<p>Using a Service Account with Cloud Run Invoke access, which can either be done with any of the following approaches:</p> <ul><li>Create a Service Account before the Cloud Run Service was created, and then set the <code>--service-account</code> flag to the Service Account email when creating the Cloud Run Service. And use an Access Token for that Service Account only using <code>gcloud auth print-access-token --impersonate-service-account=SERVICE_ACCOUNT_EMAIL</code>.</li> <li>Create a Service Account after the Cloud Run Service was created, and then update the Cloud Run Service to use the Service Account. And use an Access Token for that Service Account only using <code>gcloud auth print-access-token --impersonate-service-account=SERVICE_ACCOUNT_EMAIL</code>.</li></ul>",yl,Ie,Ln="The recommended approach is to use a Service Account (SA), as the access can be controlled better and the permissions are more granular; as the Cloud Run Service was not created using a SA, which is another nice option, you need to now create the SA, gran it the necessary permissions, update the Cloud Run Service to use the SA, and then generate an access token to set as the authentication token within the requests, that can be revoked later once you are done using it.",ml,C,$e,yt,qn="Set the <code>SERVICE_ACCOUNT_NAME</code> environment variable for convenience:",tn,be,ln,ve,mt,Qn="Create the Service Account:",nn,Ae,sn,Ve,Jt,kn="Grant the Service Account the Cloud Run Invoker role:",an,Ee,on,Ne,Ut,_n="Update the Cloud Run service to use the Service Account:",un,Re,cn,Se,wt,Wn="Generate the Access Token for the Service Account:",rn,Ze,Jl,R,Ul,xe,Bn="Now you can already dive into the different alternatives for sending the requests to the deployed Cloud Run Service using the <code>SERVICE_URL</code> AND <code>ACCESS_TOKEN</code> as described above.",wl,S,fl,Ge,gl,Le,Xn="To send a POST request to the TGI service using <code>cURL</code>, you can run the following command:",Cl,qe,jl,Qe,Il,ke,Fn="To run the inference using Python, you can either use the <code>huggingface_hub</code> Python SDK (recommended) or the <code>openai</code> Python SDK.",$l,_e,bl,We,Yn="You can install it via <code>pip</code> as <code>pip install --upgrade --quiet huggingface_hub</code>, and then run:",vl,Be,Al,Xe,Vl,Fe,Pn="You can install it via <code>pip</code> as <code>pip install --upgrade openai</code>, and then run:",El,Ye,Nl,Pe,Rl,He,Hn="Finally, once you are done using TGI on the Cloud Run Service, you can safely delete it to avoid incurring in unnecessary costs e.g. if the Cloud Run services are inadvertently invoked more times than your monthly Cloud Run invokement allocation in the free tier.",Sl,De,Dn='To delete the Cloud Run Service you can either go to the Google Cloud Console at <a href="https://console.cloud.google.com/run" rel="nofollow">https://console.cloud.google.com/run</a> and delete it manually; or use the Google Cloud SDK via <code>gcloud</code> as follows:',Zl,ze,xl,Oe,zn="If you prefer to scale it down to zero instances without deleting it, you can use the following command:",Gl,Ke,Ll,et,On='Additionally, if you followed the steps in <a href="#via-cloud-run-service-url">via Cloud Run Service URL</a> and generated a Service Account and an access token, you can either remove the Service Account, or just revoke the access token if it is still valid.',ql,tt,Kn="<li>(recommended) Revoke the Access Token as</li>",Ql,lt,kl,nt,es="<li>(optional) Delete the Service Account as:</li>",_l,st,Wl,at,Bl,ot,ts='<li><a href="https://cloud.google.com/run/docs" rel="nofollow">Cloud Run Documentation - Overview</a></li> <li><a href="https://cloud.google.com/blog/products/application-development/run-your-ai-inference-applications-on-cloud-run-with-nvidia-gpus" rel="nofollow">Google Cloud Blog - Run your AI inference applications on Cloud Run with NVIDIA GPUs</a></li>',Xl,it,Fl,Ct,Yl;return Z=new f({props:{title:"Deploy Meta Llama 3.1 8B with Text Generation Inference on Cloud Run",local:"deploy-meta-llama-31-8b-with-text-generation-inference-on-cloud-run",headingTag:"h1"}}),v=new ft({props:{$$slots:{default:[cs]},$$scope:{ctx:g}}}),L=new f({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),k=new J({props:{code:"ZXhwb3J0JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQWV4cG9ydCUyMExPQ0FUSU9OJTNEdXMtY2VudHJhbDElMjAlMjMlMjBvciUyMGFueSUyMGxvY2F0aW9uJTIwd2hlcmUlMjBDbG91ZCUyMFJ1biUyMG9mZmVycyUyMEdQVXMlM0ElMjBodHRwcyUzQSUyRiUyRmNsb3VkLmdvb2dsZS5jb20lMkZydW4lMkZkb2NzJTJGbG9jYXRpb25zJTIzZ3B1JTBBZXhwb3J0JTIwQ09OVEFJTkVSX1VSSSUzRHVzLWRvY2tlci5wa2cuZGV2JTJGZGVlcGxlYXJuaW5nLXBsYXRmb3JtLXJlbGVhc2UlMkZnY3IuaW8lMkZodWdnaW5nZmFjZS10ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlLWN1MTIxLjItMi51YnVudHUyMjA0LnB5MzEwJTBBZXhwb3J0JTIwU0VSVklDRV9OQU1FJTNEdGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZQ==",highlighted:`<span class="hljs-built_in">export</span> PROJECT_ID=your-project-id
<span class="hljs-built_in">export</span> LOCATION=us-central1 <span class="hljs-comment"># or any location where Cloud Run offers GPUs: https://cloud.google.com/run/docs/locations#gpu</span>
<span class="hljs-built_in">export</span> CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu121.2-2.ubuntu2204.py310
<span class="hljs-built_in">export</span> SERVICE_NAME=text-generation-inference`,wrap:!1}}),W=new J({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMGxvZ2luJTBBZ2Nsb3VkJTIwYXV0aCUyMGFwcGxpY2F0aW9uLWRlZmF1bHQlMjBsb2dpbiUyMCUyMCUyMyUyMEZvciUyMGxvY2FsJTIwZGV2ZWxvcG1lbnQlMEFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`gcloud auth login
gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
gcloud config <span class="hljs-built_in">set</span> project <span class="hljs-variable">$PROJECT_ID</span>`,wrap:!1}}),X=new J({props:{code:"Z2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBydW4uZ29vZ2xlYXBpcy5jb20=",highlighted:'gcloud services <span class="hljs-built_in">enable</span> run.googleapis.com',wrap:!1}}),F=new f({props:{title:"Deploy TGI on Cloud Run",local:"deploy-tgi-on-cloud-run",headingTag:"h2"}}),D=new J({props:{code:"Z2Nsb3VkJTIwYmV0YSUyMHJ1biUyMGRlcGxveSUyMCUyNFNFUlZJQ0VfTkFNRSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0taW1hZ2UlM0QlMjRDT05UQUlORVJfVVJJJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1hcmdzJTNEJTIyLS1tb2RlbC1pZCUzRGh1Z2dpbmctcXVhbnRzJTJGTWV0YS1MbGFtYS0zLjEtOEItSW5zdHJ1Y3QtQVdRLUlOVDQlMkMtLXF1YW50aXplJTNEYXdxJTJDLS1tYXgtY29uY3VycmVudC1yZXF1ZXN0cyUzRDY0JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wb3J0JTNEODA4MCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY3B1JTNEOCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWVtb3J5JTNEMzJHaSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbm8tY3B1LXRocm90dGxpbmclMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdwdSUzRDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdwdS10eXBlJTNEbnZpZGlhLWw0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXgtaW5zdGFuY2VzJTNEMyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY29uY3VycmVuY3klM0Q2NCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04lMjAlNUMlMEElMjAlMjAlMjAlMjAtLW5vLWFsbG93LXVuYXV0aGVudGljYXRlZA==",highlighted:`gcloud beta run deploy <span class="hljs-variable">$SERVICE_NAME</span> \\
    --image=<span class="hljs-variable">$CONTAINER_URI</span> \\
    --args=<span class="hljs-string">&quot;--model-id=hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4,--quantize=awq,--max-concurrent-requests=64&quot;</span> \\
    --port=8080 \\
    --cpu=8 \\
    --memory=32Gi \\
    --no-cpu-throttling \\
    --gpu=1 \\
    --gpu-type=nvidia-l4 \\
    --max-instances=3 \\
    --concurrency=64 \\
    --region=<span class="hljs-variable">$LOCATION</span> \\
    --no-allow-unauthenticated`,wrap:!1}}),A=new ft({props:{$$slots:{default:[rs]},$$scope:{ctx:g}}}),K=new f({props:{title:"Inference on Cloud Run",local:"inference-on-cloud-run",headingTag:"h2"}}),V=new ft({props:{$$slots:{default:[Ms]},$$scope:{ctx:g}}}),ne=new f({props:{title:"Via Cloud Run Proxy",local:"via-cloud-run-proxy",headingTag:"h3"}}),ae=new J({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBwcm94eSUyMCUyNFNFUlZJQ0VfTkFNRSUyMC0tcmVnaW9uJTIwJTI0TE9DQVRJT04=",highlighted:'gcloud run services proxy <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span>',wrap:!1}}),E=new ft({props:{$$slots:{default:[ps]},$$scope:{ctx:g}}}),ie=new f({props:{title:"cURL",local:"curl",headingTag:"h4"}}),ce=new J({props:{code:"Y3VybCUyMGh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGdjElMkZjaGF0JTJGY29tcGxldGlvbnMlMjAlNUMlMEElMjAlMjAlMjAlMjAtWCUyMFBPU1QlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCdDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLWQlMjAnJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWwlMjIlM0ElMjAlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWF4X3Rva2VucyUyMiUzQSUyMDEyOCUwQSUyMCUyMCUyMCUyMCU3RCc=",highlighted:`curl http://localhost:8080/v1/chat/completions \\
    -X POST \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tgi&quot;,
        &quot;messages&quot;: [
            {
                &quot;role&quot;: &quot;system&quot;,
                &quot;content&quot;: &quot;You are a helpful assistant.&quot;
            },
            {
                &quot;role&quot;: &quot;user&quot;,
                &quot;content&quot;: &quot;What is Deep Learning?&quot;
            }
        ],
        &quot;max_tokens&quot;: 128
    }&#x27;</span>`,wrap:!1}}),re=new f({props:{title:"Python",local:"python",headingTag:"h4"}}),pe=new f({props:{title:"huggingface_hub",local:"huggingfacehub",headingTag:"h5"}}),he=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTIyJTJDJTIwYXBpX2tleSUzRCUyMi0lMjIpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMG1vZGVsJTNEJTIyaHVnZ2luZy1xdWFudHMlMkZNZXRhLUxsYW1hLTMuMS04Qi1JbnN0cnVjdC1BV1EtSU5UNCUyMiUyQyUwQSUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBEZWVwJTIwTGVhcm5pbmclM0YlMjIlN0QlMkMlMEElMjAlMjAlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNEMTI4JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(base_url=<span class="hljs-string">&quot;http://localhost:8080&quot;</span>, api_key=<span class="hljs-string">&quot;-&quot;</span>)

chat_completion = client.chat.completions.create(
  model=<span class="hljs-string">&quot;hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4&quot;</span>,
  messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>},
  ],
  max_tokens=<span class="hljs-number">128</span>,
)`,wrap:!1}}),Te=new f({props:{title:"openai",local:"openai",headingTag:"h5"}}),me=new J({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQWNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGdjElMkYlMjIlMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyLSUyMiUyQyUwQSklMEElMEFjaGF0X2NvbXBsZXRpb24lMjAlM0QlMjBjbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEyOCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:8080/v1/&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>,
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>},
    ],
    max_tokens=<span class="hljs-number">128</span>,
)`,wrap:!1}}),Je=new f({props:{title:"(recommended) Via Cloud Run Service URL",local:"recommended-via-cloud-run-service-url",headingTag:"h3"}}),fe=new J({props:{code:"U0VSVklDRV9VUkwlM0QlMjQoZ2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBkZXNjcmliZSUyMCUyNFNFUlZJQ0VfTkFNRSUyMC0tcmVnaW9uJTIwJTI0TE9DQVRJT04lMjAtLWZvcm1hdCUyMCd2YWx1ZShzdGF0dXMudXJsKScp",highlighted:'SERVICE_URL=$(gcloud run services describe <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span> --format <span class="hljs-string">&#x27;value(status.url)&#x27;</span>)',wrap:!1}}),Ce=new J({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMHByaW50LWlkZW50aXR5LXRva2Vu",highlighted:"gcloud auth print-identity-token",wrap:!1}}),je=new J({props:{code:"aW1wb3J0JTIwZ29vZ2xlLmF1dGglMEFmcm9tJTIwZ29vZ2xlLmF1dGgudHJhbnNwb3J0LnJlcXVlc3RzJTIwaW1wb3J0JTIwUmVxdWVzdCUyMGFzJTIwR29vZ2xlQXV0aFJlcXVlc3QlMEElMEFhdXRoX3JlcSUyMCUzRCUyMEdvb2dsZUF1dGhSZXF1ZXN0KCklMEFjcmVkcyUyQyUyMF8lMjAlM0QlMjBnb29nbGUuYXV0aC5kZWZhdWx0KCklMEFjcmVkcy5yZWZyZXNoKGF1dGhfcmVxKSUwQSUwQWlkX3Rva2VuJTIwJTNEJTIwY3JlZHMuaWRfdG9rZW4=",highlighted:`<span class="hljs-keyword">import</span> google.auth
<span class="hljs-keyword">from</span> google.auth.transport.requests <span class="hljs-keyword">import</span> Request <span class="hljs-keyword">as</span> GoogleAuthRequest

auth_req = GoogleAuthRequest()
creds, _ = google.auth.default()
creds.refresh(auth_req)

id_token = creds.id_token`,wrap:!1}}),be=new J({props:{code:"ZXhwb3J0JTIwU0VSVklDRV9BQ0NPVU5UX05BTUUlM0R0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlLWludm9rZXI=",highlighted:'<span class="hljs-built_in">export</span> SERVICE_ACCOUNT_NAME=text-generation-inference-invoker',wrap:!1}}),Ae=new J({props:{code:"Z2Nsb3VkJTIwaWFtJTIwc2VydmljZS1hY2NvdW50cyUyMGNyZWF0ZSUyMCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1F",highlighted:'gcloud iam service-accounts create <span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>',wrap:!1}}),Ee=new J({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBhZGQtaWFtLXBvbGljeS1iaW5kaW5nJTIwJTI0U0VSVklDRV9OQU1FJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tZW1iZXIlM0QlMjJzZXJ2aWNlQWNjb3VudCUzQSUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcm9sZSUzRCUyMnJvbGVzJTJGcnVuLmludm9rZXIlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlZ2lvbiUzRCUyNExPQ0FUSU9O",highlighted:`gcloud run services add-iam-policy-binding <span class="hljs-variable">$SERVICE_NAME</span> \\
    --member=<span class="hljs-string">&quot;serviceAccount:<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com&quot;</span> \\
    --role=<span class="hljs-string">&quot;roles/run.invoker&quot;</span> \\
    --region=<span class="hljs-variable">$LOCATION</span>`,wrap:!1}}),Re=new J({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjB1cGRhdGUlMjAlMjRTRVJWSUNFX05BTUUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNlcnZpY2UtYWNjb3VudCUyMCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVnaW9uJTNEJTI0UkVHSU9O",highlighted:`gcloud run services update <span class="hljs-variable">$SERVICE_NAME</span> \\
    --service-account <span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com \\
    --region=<span class="hljs-variable">$REGION</span>`,wrap:!1}}),Ze=new J({props:{code:"ZXhwb3J0JTIwQUNDRVNTX1RPS0VOJTNEJTI0KGdjbG91ZCUyMGF1dGglMjBwcmludC1hY2Nlc3MtdG9rZW4lMjAtLWltcGVyc29uYXRlLXNlcnZpY2UtYWNjb3VudCUzRCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSk=",highlighted:'<span class="hljs-built_in">export</span> ACCESS_TOKEN=$(gcloud auth print-access-token --impersonate-service-account=<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com)',wrap:!1}}),R=new ft({props:{warning:!0,$$slots:{default:[ds]},$$scope:{ctx:g}}}),S=new ft({props:{$$slots:{default:[hs]},$$scope:{ctx:g}}}),Ge=new f({props:{title:"cURL",local:"curl",headingTag:"h4"}}),qe=new J({props:{code:"Y3VybCUyMCUyNFNFUlZJQ0VfVVJMJTJGdjElMkZjaGF0JTJGY29tcGxldGlvbnMlMjAlNUMlMEElMjAlMjAlMjAlMjAtWCUyMFBPU1QlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCdBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTI0QUNDRVNTX1RPS0VOJyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJ0NvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbiclMjAlNUMlMEElMjAlMjAlMjAlMjAtZCUyMCclN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtb2RlbCUyMiUzQSUyMCUyMnRnaSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBEZWVwJTIwTGVhcm5pbmclM0YlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMTI4JTBBJTIwJTIwJTIwJTIwJTdEJw==",highlighted:`curl <span class="hljs-variable">$SERVICE_URL</span>/v1/chat/completions \\
    -X POST \\
    -H <span class="hljs-string">&#x27;Authorization: Bearer $ACCESS_TOKEN&#x27;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tgi&quot;,
        &quot;messages&quot;: [
            {
                &quot;role&quot;: &quot;system&quot;,
                &quot;content&quot;: &quot;You are a helpful assistant.&quot;
            },
            {
                &quot;role&quot;: &quot;user&quot;,
                &quot;content&quot;: &quot;What is Deep Learning?&quot;
            }
        ],
        &quot;max_tokens&quot;: 128
    }&#x27;</span>`,wrap:!1}}),Qe=new f({props:{title:"Python",local:"python",headingTag:"h4"}}),_e=new f({props:{title:"huggingface_hub",local:"huggingfacehub",headingTag:"h5"}}),Be=new J({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNEb3MuZ2V0ZW52KCUyMlNFUlZJQ0VfVVJMJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyQUNDRVNTX1RPS0VOJTIyKSUyQyUwQSklMEElMEFjaGF0X2NvbXBsZXRpb24lMjAlM0QlMjBjbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwbW9kZWwlM0QlMjJodWdnaW5nLXF1YW50cyUyRk1ldGEtTGxhbWEtMy4xLThCLUluc3RydWN0LUFXUS1JTlQ0JTIyJTJDJTBBJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMERlZXAlMjBMZWFybmluZyUzRiUyMiU3RCUyQyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMG1heF90b2tlbnMlM0QxMjglMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(
    base_url=os.getenv(<span class="hljs-string">&quot;SERVICE_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;ACCESS_TOKEN&quot;</span>),
)

chat_completion = client.chat.completions.create(
  model=<span class="hljs-string">&quot;hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4&quot;</span>,
  messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>},
  ],
  max_tokens=<span class="hljs-number">128</span>,
)`,wrap:!1}}),Xe=new f({props:{title:"openai",local:"openai",headingTag:"h5"}}),Ye=new J({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBY2xpZW50JTIwJTNEJTIwT3BlbkFJKCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNEb3MuZ2V0ZW52KCUyMlNFUlZJQ0VfVVJMJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyQUNDRVNTX1RPS0VOJTIyKSUyQyUwQSklMEElMEFjaGF0X2NvbXBsZXRpb24lMjAlM0QlMjBjbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEyOCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

client = OpenAI(
    base_url=os.getenv(<span class="hljs-string">&quot;SERVICE_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;ACCESS_TOKEN&quot;</span>),
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>},
    ],
    max_tokens=<span class="hljs-number">128</span>,
)`,wrap:!1}}),Pe=new f({props:{title:"Resource clean up",local:"resource-clean-up",headingTag:"h2"}}),ze=new J({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBkZWxldGUlMjAlMjRTRVJWSUNFX05BTUUlMjAtLXJlZ2lvbiUyMCUyNExPQ0FUSU9O",highlighted:'gcloud run services delete <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span>',wrap:!1}}),Ke=new J({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjB1cGRhdGUlMjAlMjRTRVJWSUNFX05BTUUlMjAtLXJlZ2lvbiUyMCUyNExPQ0FUSU9OJTIwLS1wbGF0Zm9ybSUyMG1hbmFnZWQlMjAtLW1heC1pbnN0YW5jZXMlMjAw",highlighted:'gcloud run services update <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span> --platform managed --max-instances 0',wrap:!1}}),lt=new J({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMHJldm9rZSUyMC0taW1wZXJzb25hdGUtc2VydmljZS1hY2NvdW50JTNEJTI0U0VSVklDRV9BQ0NPVU5UX05BTUUlNDAlMjRQUk9KRUNUX0lELmlhbS5nc2VydmljZWFjY291bnQuY29t",highlighted:'gcloud auth revoke --impersonate-service-account=<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com',wrap:!1}}),st=new J({props:{code:"Z2Nsb3VkJTIwaWFtJTIwc2VydmljZS1hY2NvdW50cyUyMGRlbGV0ZSUyMCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbQ==",highlighted:'gcloud iam service-accounts delete <span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com',wrap:!1}}),at=new f({props:{title:"References",local:"references",headingTag:"h2"}}),it=new us({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/cloud-run-tgi-deployment.mdx"}}),{c(){u=o("meta"),U=s(),y=o("p"),w=s(),r(Z.$$.fragment),jt=s(),x=o("p"),x.textContent=Mn,It=s(),G=o("p"),G.textContent=pn,$t=s(),r(v.$$.fragment),bt=s(),r(L.$$.fragment),vt=s(),q=o("p"),q.innerHTML=dn,At=s(),Q=o("p"),Q.textContent=hn,Vt=s(),r(k.$$.fragment),Et=s(),_=o("p"),_.textContent=Tn,Nt=s(),r(W.$$.fragment),Rt=s(),B=o("p"),B.textContent=yn,St=s(),r(X.$$.fragment),Zt=s(),r(F.$$.fragment),xt=s(),Y=o("p"),Y.innerHTML=mn,Gt=s(),P=o("p"),P.innerHTML=Jn,Lt=s(),H=o("ul"),H.innerHTML=Un,qt=s(),r(D.$$.fragment),Qt=s(),z=o("p"),z.innerHTML=wn,kt=s(),O=o("p"),O.innerHTML=fn,_t=s(),r(A.$$.fragment),Wt=s(),r(K.$$.fragment),Bt=s(),ee=o("p"),ee.innerHTML=gn,Xt=s(),te=o("p"),te.textContent=Cn,Ft=s(),le=o("p"),le.textContent=jn,Yt=s(),r(V.$$.fragment),Pt=s(),r(ne.$$.fragment),Ht=s(),se=o("p"),se.textContent=In,Dt=s(),r(ae.$$.fragment),zt=s(),oe=o("p"),oe.innerHTML=$n,Ot=s(),r(E.$$.fragment),Kt=s(),r(ie.$$.fragment),el=s(),ue=o("p"),ue.innerHTML=bn,tl=s(),r(ce.$$.fragment),ll=s(),r(re.$$.fragment),nl=s(),Me=o("p"),Me.innerHTML=vn,sl=s(),r(pe.$$.fragment),al=s(),de=o("p"),de.innerHTML=An,ol=s(),r(he.$$.fragment),il=s(),r(Te.$$.fragment),ul=s(),ye=o("p"),ye.innerHTML=Vn,cl=s(),r(me.$$.fragment),rl=s(),r(Je.$$.fragment),Ml=s(),Ue=o("p"),Ue.textContent=En,pl=s(),we=o("p"),we.innerHTML=Nn,dl=s(),r(fe.$$.fragment),hl=s(),ge=o("p"),ge.innerHTML=Rn,Tl=s(),N=o("ul"),j=o("li"),pt=o("p"),pt.textContent=Sn,Dl=s(),dt=o("ul"),dt.innerHTML=Zn,zl=s(),r(Ce.$$.fragment),Ol=s(),ht=o("ul"),ht.innerHTML=xn,Kl=s(),r(je.$$.fragment),en=s(),Tt=o("li"),Tt.innerHTML=Gn,yl=s(),Ie=o("p"),Ie.textContent=Ln,ml=s(),C=o("ul"),$e=o("li"),yt=o("p"),yt.innerHTML=qn,tn=s(),r(be.$$.fragment),ln=s(),ve=o("li"),mt=o("p"),mt.textContent=Qn,nn=s(),r(Ae.$$.fragment),sn=s(),Ve=o("li"),Jt=o("p"),Jt.textContent=kn,an=s(),r(Ee.$$.fragment),on=s(),Ne=o("li"),Ut=o("p"),Ut.textContent=_n,un=s(),r(Re.$$.fragment),cn=s(),Se=o("li"),wt=o("p"),wt.textContent=Wn,rn=s(),r(Ze.$$.fragment),Jl=s(),r(R.$$.fragment),Ul=s(),xe=o("p"),xe.innerHTML=Bn,wl=s(),r(S.$$.fragment),fl=s(),r(Ge.$$.fragment),gl=s(),Le=o("p"),Le.innerHTML=Xn,Cl=s(),r(qe.$$.fragment),jl=s(),r(Qe.$$.fragment),Il=s(),ke=o("p"),ke.innerHTML=Fn,$l=s(),r(_e.$$.fragment),bl=s(),We=o("p"),We.innerHTML=Yn,vl=s(),r(Be.$$.fragment),Al=s(),r(Xe.$$.fragment),Vl=s(),Fe=o("p"),Fe.innerHTML=Pn,El=s(),r(Ye.$$.fragment),Nl=s(),r(Pe.$$.fragment),Rl=s(),He=o("p"),He.textContent=Hn,Sl=s(),De=o("p"),De.innerHTML=Dn,Zl=s(),r(ze.$$.fragment),xl=s(),Oe=o("p"),Oe.textContent=zn,Gl=s(),r(Ke.$$.fragment),Ll=s(),et=o("p"),et.innerHTML=On,ql=s(),tt=o("ul"),tt.innerHTML=Kn,Ql=s(),r(lt.$$.fragment),kl=s(),nt=o("ul"),nt.innerHTML=es,_l=s(),r(st.$$.fragment),Wl=s(),r(at.$$.fragment),Bl=s(),ot=o("ul"),ot.innerHTML=ts,Xl=s(),r(it.$$.fragment),Fl=s(),Ct=o("p"),this.h()},l(e){const t=is("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(l),U=a(e),y=i(e,"P",{}),b(y).forEach(l),w=a(e),M(Z.$$.fragment,e),jt=a(e),x=i(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-rqjgi7"&&(x.textContent=Mn),It=a(e),G=i(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1dwjfkk"&&(G.textContent=pn),$t=a(e),M(v.$$.fragment,e),bt=a(e),M(L.$$.fragment,e),vt=a(e),q=i(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-1o67gfb"&&(q.innerHTML=dn),At=a(e),Q=i(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1i8n6rq"&&(Q.textContent=hn),Vt=a(e),M(k.$$.fragment,e),Et=a(e),_=i(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-pfbeqd"&&(_.textContent=Tn),Nt=a(e),M(W.$$.fragment,e),Rt=a(e),B=i(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1usj4y5"&&(B.textContent=yn),St=a(e),M(X.$$.fragment,e),Zt=a(e),M(F.$$.fragment,e),xt=a(e),Y=i(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-v1hrv3"&&(Y.innerHTML=mn),Gt=a(e),P=i(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-1edwfmt"&&(P.innerHTML=Jn),Lt=a(e),H=i(e,"UL",{"data-svelte-h":!0}),c(H)!=="svelte-17pp1sv"&&(H.innerHTML=Un),qt=a(e),M(D.$$.fragment,e),Qt=a(e),z=i(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-h7x8wp"&&(z.innerHTML=wn),kt=a(e),O=i(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-epx368"&&(O.innerHTML=fn),_t=a(e),M(A.$$.fragment,e),Wt=a(e),M(K.$$.fragment,e),Bt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1d9o3zj"&&(ee.innerHTML=gn),Xt=a(e),te=i(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-1gzo66i"&&(te.textContent=Cn),Ft=a(e),le=i(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1p7twmj"&&(le.textContent=jn),Yt=a(e),M(V.$$.fragment,e),Pt=a(e),M(ne.$$.fragment,e),Ht=a(e),se=i(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1n42sxg"&&(se.textContent=In),Dt=a(e),M(ae.$$.fragment,e),zt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-yd30oz"&&(oe.innerHTML=$n),Ot=a(e),M(E.$$.fragment,e),Kt=a(e),M(ie.$$.fragment,e),el=a(e),ue=i(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-1ks8djk"&&(ue.innerHTML=bn),tl=a(e),M(ce.$$.fragment,e),ll=a(e),M(re.$$.fragment,e),nl=a(e),Me=i(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-wqgbww"&&(Me.innerHTML=vn),sl=a(e),M(pe.$$.fragment,e),al=a(e),de=i(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-u758zp"&&(de.innerHTML=An),ol=a(e),M(he.$$.fragment,e),il=a(e),M(Te.$$.fragment,e),ul=a(e),ye=i(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-1bjj57d"&&(ye.innerHTML=Vn),cl=a(e),M(me.$$.fragment,e),rl=a(e),M(Je.$$.fragment,e),Ml=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-1o5h253"&&(Ue.textContent=En),pl=a(e),we=i(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-7kvofg"&&(we.innerHTML=Nn),dl=a(e),M(fe.$$.fragment,e),hl=a(e),ge=i(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-niuemd"&&(ge.innerHTML=Rn),Tl=a(e),N=i(e,"UL",{});var ut=b(N);j=i(ut,"LI",{});var I=b(j);pt=i(I,"P",{"data-svelte-h":!0}),c(pt)!=="svelte-4rg0sg"&&(pt.textContent=Sn),Dl=a(I),dt=i(I,"UL",{"data-svelte-h":!0}),c(dt)!=="svelte-1vwi62o"&&(dt.innerHTML=Zn),zl=a(I),M(Ce.$$.fragment,I),Ol=a(I),ht=i(I,"UL",{"data-svelte-h":!0}),c(ht)!=="svelte-b6nbfv"&&(ht.innerHTML=xn),Kl=a(I),M(je.$$.fragment,I),I.forEach(l),en=a(ut),Tt=i(ut,"LI",{"data-svelte-h":!0}),c(Tt)!=="svelte-1v3f4rq"&&(Tt.innerHTML=Gn),ut.forEach(l),yl=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-18iwnqm"&&(Ie.textContent=Ln),ml=a(e),C=i(e,"UL",{});var $=b(C);$e=i($,"LI",{});var ct=b($e);yt=i(ct,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-tbapg4"&&(yt.innerHTML=qn),tn=a(ct),M(be.$$.fragment,ct),ct.forEach(l),ln=a($),ve=i($,"LI",{});var rt=b(ve);mt=i(rt,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-1nwc9xz"&&(mt.textContent=Qn),nn=a(rt),M(Ae.$$.fragment,rt),rt.forEach(l),sn=a($),Ve=i($,"LI",{});var Mt=b(Ve);Jt=i(Mt,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-19ickcu"&&(Jt.textContent=kn),an=a(Mt),M(Ee.$$.fragment,Mt),Mt.forEach(l),on=a($),Ne=i($,"LI",{});var Pl=b(Ne);Ut=i(Pl,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-1izpwqg"&&(Ut.textContent=_n),un=a(Pl),M(Re.$$.fragment,Pl),Pl.forEach(l),cn=a($),Se=i($,"LI",{});var Hl=b(Se);wt=i(Hl,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-v6tnr5"&&(wt.textContent=Wn),rn=a(Hl),M(Ze.$$.fragment,Hl),Hl.forEach(l),$.forEach(l),Jl=a(e),M(R.$$.fragment,e),Ul=a(e),xe=i(e,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-ur1pan"&&(xe.innerHTML=Bn),wl=a(e),M(S.$$.fragment,e),fl=a(e),M(Ge.$$.fragment,e),gl=a(e),Le=i(e,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-1ks8djk"&&(Le.innerHTML=Xn),Cl=a(e),M(qe.$$.fragment,e),jl=a(e),M(Qe.$$.fragment,e),Il=a(e),ke=i(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-wqgbww"&&(ke.innerHTML=Fn),$l=a(e),M(_e.$$.fragment,e),bl=a(e),We=i(e,"P",{"data-svelte-h":!0}),c(We)!=="svelte-u758zp"&&(We.innerHTML=Yn),vl=a(e),M(Be.$$.fragment,e),Al=a(e),M(Xe.$$.fragment,e),Vl=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-1bjj57d"&&(Fe.innerHTML=Pn),El=a(e),M(Ye.$$.fragment,e),Nl=a(e),M(Pe.$$.fragment,e),Rl=a(e),He=i(e,"P",{"data-svelte-h":!0}),c(He)!=="svelte-qym8z6"&&(He.textContent=Hn),Sl=a(e),De=i(e,"P",{"data-svelte-h":!0}),c(De)!=="svelte-1sjp15c"&&(De.innerHTML=Dn),Zl=a(e),M(ze.$$.fragment,e),xl=a(e),Oe=i(e,"P",{"data-svelte-h":!0}),c(Oe)!=="svelte-6b9l4r"&&(Oe.textContent=zn),Gl=a(e),M(Ke.$$.fragment,e),Ll=a(e),et=i(e,"P",{"data-svelte-h":!0}),c(et)!=="svelte-l00oox"&&(et.innerHTML=On),ql=a(e),tt=i(e,"UL",{"data-svelte-h":!0}),c(tt)!=="svelte-hs3g2x"&&(tt.innerHTML=Kn),Ql=a(e),M(lt.$$.fragment,e),kl=a(e),nt=i(e,"UL",{"data-svelte-h":!0}),c(nt)!=="svelte-1toh59e"&&(nt.innerHTML=es),_l=a(e),M(st.$$.fragment,e),Wl=a(e),M(at.$$.fragment,e),Bl=a(e),ot=i(e,"UL",{"data-svelte-h":!0}),c(ot)!=="svelte-182evf3"&&(ot.innerHTML=ts),Xl=a(e),M(it.$$.fragment,e),Fl=a(e),Ct=i(e,"P",{}),b(Ct).forEach(l),this.h()},h(){ls(u,"name","hf:doc:metadata"),ls(u,"content",ys)},m(e,t){m(document.head,u),n(e,U,t),n(e,y,t),n(e,w,t),p(Z,e,t),n(e,jt,t),n(e,x,t),n(e,It,t),n(e,G,t),n(e,$t,t),p(v,e,t),n(e,bt,t),p(L,e,t),n(e,vt,t),n(e,q,t),n(e,At,t),n(e,Q,t),n(e,Vt,t),p(k,e,t),n(e,Et,t),n(e,_,t),n(e,Nt,t),p(W,e,t),n(e,Rt,t),n(e,B,t),n(e,St,t),p(X,e,t),n(e,Zt,t),p(F,e,t),n(e,xt,t),n(e,Y,t),n(e,Gt,t),n(e,P,t),n(e,Lt,t),n(e,H,t),n(e,qt,t),p(D,e,t),n(e,Qt,t),n(e,z,t),n(e,kt,t),n(e,O,t),n(e,_t,t),p(A,e,t),n(e,Wt,t),p(K,e,t),n(e,Bt,t),n(e,ee,t),n(e,Xt,t),n(e,te,t),n(e,Ft,t),n(e,le,t),n(e,Yt,t),p(V,e,t),n(e,Pt,t),p(ne,e,t),n(e,Ht,t),n(e,se,t),n(e,Dt,t),p(ae,e,t),n(e,zt,t),n(e,oe,t),n(e,Ot,t),p(E,e,t),n(e,Kt,t),p(ie,e,t),n(e,el,t),n(e,ue,t),n(e,tl,t),p(ce,e,t),n(e,ll,t),p(re,e,t),n(e,nl,t),n(e,Me,t),n(e,sl,t),p(pe,e,t),n(e,al,t),n(e,de,t),n(e,ol,t),p(he,e,t),n(e,il,t),p(Te,e,t),n(e,ul,t),n(e,ye,t),n(e,cl,t),p(me,e,t),n(e,rl,t),p(Je,e,t),n(e,Ml,t),n(e,Ue,t),n(e,pl,t),n(e,we,t),n(e,dl,t),p(fe,e,t),n(e,hl,t),n(e,ge,t),n(e,Tl,t),n(e,N,t),m(N,j),m(j,pt),m(j,Dl),m(j,dt),m(j,zl),p(Ce,j,null),m(j,Ol),m(j,ht),m(j,Kl),p(je,j,null),m(N,en),m(N,Tt),n(e,yl,t),n(e,Ie,t),n(e,ml,t),n(e,C,t),m(C,$e),m($e,yt),m($e,tn),p(be,$e,null),m(C,ln),m(C,ve),m(ve,mt),m(ve,nn),p(Ae,ve,null),m(C,sn),m(C,Ve),m(Ve,Jt),m(Ve,an),p(Ee,Ve,null),m(C,on),m(C,Ne),m(Ne,Ut),m(Ne,un),p(Re,Ne,null),m(C,cn),m(C,Se),m(Se,wt),m(Se,rn),p(Ze,Se,null),n(e,Jl,t),p(R,e,t),n(e,Ul,t),n(e,xe,t),n(e,wl,t),p(S,e,t),n(e,fl,t),p(Ge,e,t),n(e,gl,t),n(e,Le,t),n(e,Cl,t),p(qe,e,t),n(e,jl,t),p(Qe,e,t),n(e,Il,t),n(e,ke,t),n(e,$l,t),p(_e,e,t),n(e,bl,t),n(e,We,t),n(e,vl,t),p(Be,e,t),n(e,Al,t),p(Xe,e,t),n(e,Vl,t),n(e,Fe,t),n(e,El,t),p(Ye,e,t),n(e,Nl,t),p(Pe,e,t),n(e,Rl,t),n(e,He,t),n(e,Sl,t),n(e,De,t),n(e,Zl,t),p(ze,e,t),n(e,xl,t),n(e,Oe,t),n(e,Gl,t),p(Ke,e,t),n(e,Ll,t),n(e,et,t),n(e,ql,t),n(e,tt,t),n(e,Ql,t),p(lt,e,t),n(e,kl,t),n(e,nt,t),n(e,_l,t),p(st,e,t),n(e,Wl,t),p(at,e,t),n(e,Bl,t),n(e,ot,t),n(e,Xl,t),p(it,e,t),n(e,Fl,t),n(e,Ct,t),Yl=!0},p(e,[t]){const ut={};t&2&&(ut.$$scope={dirty:t,ctx:e}),v.$set(ut);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),A.$set(I);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),V.$set($);const ct={};t&2&&(ct.$$scope={dirty:t,ctx:e}),E.$set(ct);const rt={};t&2&&(rt.$$scope={dirty:t,ctx:e}),R.$set(rt);const Mt={};t&2&&(Mt.$$scope={dirty:t,ctx:e}),S.$set(Mt)},i(e){Yl||(d(Z.$$.fragment,e),d(v.$$.fragment,e),d(L.$$.fragment,e),d(k.$$.fragment,e),d(W.$$.fragment,e),d(X.$$.fragment,e),d(F.$$.fragment,e),d(D.$$.fragment,e),d(A.$$.fragment,e),d(K.$$.fragment,e),d(V.$$.fragment,e),d(ne.$$.fragment,e),d(ae.$$.fragment,e),d(E.$$.fragment,e),d(ie.$$.fragment,e),d(ce.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(he.$$.fragment,e),d(Te.$$.fragment,e),d(me.$$.fragment,e),d(Je.$$.fragment,e),d(fe.$$.fragment,e),d(Ce.$$.fragment,e),d(je.$$.fragment,e),d(be.$$.fragment,e),d(Ae.$$.fragment,e),d(Ee.$$.fragment,e),d(Re.$$.fragment,e),d(Ze.$$.fragment,e),d(R.$$.fragment,e),d(S.$$.fragment,e),d(Ge.$$.fragment,e),d(qe.$$.fragment,e),d(Qe.$$.fragment,e),d(_e.$$.fragment,e),d(Be.$$.fragment,e),d(Xe.$$.fragment,e),d(Ye.$$.fragment,e),d(Pe.$$.fragment,e),d(ze.$$.fragment,e),d(Ke.$$.fragment,e),d(lt.$$.fragment,e),d(st.$$.fragment,e),d(at.$$.fragment,e),d(it.$$.fragment,e),Yl=!0)},o(e){h(Z.$$.fragment,e),h(v.$$.fragment,e),h(L.$$.fragment,e),h(k.$$.fragment,e),h(W.$$.fragment,e),h(X.$$.fragment,e),h(F.$$.fragment,e),h(D.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(V.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),h(E.$$.fragment,e),h(ie.$$.fragment,e),h(ce.$$.fragment,e),h(re.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(Te.$$.fragment,e),h(me.$$.fragment,e),h(Je.$$.fragment,e),h(fe.$$.fragment,e),h(Ce.$$.fragment,e),h(je.$$.fragment,e),h(be.$$.fragment,e),h(Ae.$$.fragment,e),h(Ee.$$.fragment,e),h(Re.$$.fragment,e),h(Ze.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(Ge.$$.fragment,e),h(qe.$$.fragment,e),h(Qe.$$.fragment,e),h(_e.$$.fragment,e),h(Be.$$.fragment,e),h(Xe.$$.fragment,e),h(Ye.$$.fragment,e),h(Pe.$$.fragment,e),h(ze.$$.fragment,e),h(Ke.$$.fragment,e),h(lt.$$.fragment,e),h(st.$$.fragment,e),h(at.$$.fragment,e),h(it.$$.fragment,e),Yl=!1},d(e){e&&(l(U),l(y),l(w),l(jt),l(x),l(It),l(G),l($t),l(bt),l(vt),l(q),l(At),l(Q),l(Vt),l(Et),l(_),l(Nt),l(Rt),l(B),l(St),l(Zt),l(xt),l(Y),l(Gt),l(P),l(Lt),l(H),l(qt),l(Qt),l(z),l(kt),l(O),l(_t),l(Wt),l(Bt),l(ee),l(Xt),l(te),l(Ft),l(le),l(Yt),l(Pt),l(Ht),l(se),l(Dt),l(zt),l(oe),l(Ot),l(Kt),l(el),l(ue),l(tl),l(ll),l(nl),l(Me),l(sl),l(al),l(de),l(ol),l(il),l(ul),l(ye),l(cl),l(rl),l(Ml),l(Ue),l(pl),l(we),l(dl),l(hl),l(ge),l(Tl),l(N),l(yl),l(Ie),l(ml),l(C),l(Jl),l(Ul),l(xe),l(wl),l(fl),l(gl),l(Le),l(Cl),l(jl),l(Il),l(ke),l($l),l(bl),l(We),l(vl),l(Al),l(Vl),l(Fe),l(El),l(Nl),l(Rl),l(He),l(Sl),l(De),l(Zl),l(xl),l(Oe),l(Gl),l(Ll),l(et),l(ql),l(tt),l(Ql),l(kl),l(nt),l(_l),l(Wl),l(Bl),l(ot),l(Xl),l(Fl),l(Ct)),l(u),T(Z,e),T(v,e),T(L,e),T(k,e),T(W,e),T(X,e),T(F,e),T(D,e),T(A,e),T(K,e),T(V,e),T(ne,e),T(ae,e),T(E,e),T(ie,e),T(ce,e),T(re,e),T(pe,e),T(he,e),T(Te,e),T(me,e),T(Je,e),T(fe,e),T(Ce),T(je),T(be),T(Ae),T(Ee),T(Re),T(Ze),T(R,e),T(S,e),T(Ge,e),T(qe,e),T(Qe,e),T(_e,e),T(Be,e),T(Xe,e),T(Ye,e),T(Pe,e),T(ze,e),T(Ke,e),T(lt,e),T(st,e),T(at,e),T(it,e)}}}const ys='{"title":"Deploy Meta Llama 3.1 8B with Text Generation Inference on Cloud Run","local":"deploy-meta-llama-31-8b-with-text-generation-inference-on-cloud-run","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Deploy TGI on Cloud Run","local":"deploy-tgi-on-cloud-run","sections":[],"depth":2},{"title":"Inference on Cloud Run","local":"inference-on-cloud-run","sections":[{"title":"Via Cloud Run Proxy","local":"via-cloud-run-proxy","sections":[{"title":"cURL","local":"curl","sections":[],"depth":4},{"title":"Python","local":"python","sections":[{"title":"huggingface_hub","local":"huggingfacehub","sections":[],"depth":5},{"title":"openai","local":"openai","sections":[],"depth":5}],"depth":4}],"depth":3},{"title":"(recommended) Via Cloud Run Service URL","local":"recommended-via-cloud-run-service-url","sections":[{"title":"cURL","local":"curl","sections":[],"depth":4},{"title":"Python","local":"python","sections":[{"title":"huggingface_hub","local":"huggingfacehub","sections":[],"depth":5},{"title":"openai","local":"openai","sections":[],"depth":5}],"depth":4}],"depth":3}],"depth":2},{"title":"Resource clean up","local":"resource-clean-up","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function ms(g){return ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cs extends as{constructor(u){super(),os(this,u,ms,Ts,ns,{})}}export{Cs as component};
