import{s as Xt,n as Nt,o as Ht}from"../chunks/scheduler.b108d059.js";import{S as Yt,i as Qt,g as a,s,r as c,A as Pt,h as i,f as n,c as o,j as Wt,u,x as r,k as Ft,y as zt,a as l,v as p,d,t as M,w as m}from"../chunks/index.008de539.js";import{C as h}from"../chunks/CodeBlock.3968c746.js";import{H as pe,E as Dt}from"../chunks/EditOnGithub.d1c48e3d.js";function Ot(pt){let g,me,de,he,T,ge,f,dt='<a href="https://github.com/huggingface/trl" rel="nofollow">Transformer Reinforcement Learning (TRL)</a> is a framework developed by Hugging Face to fine-tune and align both transformer language and diffusion models using methods such as Supervised Fine-Tuning (SFT), Reward Modeling (RM), Proximal Policy Optimization (PPO), Direct Preference Optimization (DPO), and others. On the other hand, Vertex AI is a Machine Learning (ML) platform that lets you train and deploy ML models and AI applications, and customize large language models (LLMs) for use in your AI-powered applications.',Te,y,Mt="This example showcases how to create a custom training job on Vertex AI running the Hugging Face PyTorch DLC for training, using the TRL CLI to fine-tune a 7B LLM with SFT + LoRA in a single GPU.",fe,J,ye,w,mt='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',Je,j,ht="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",we,b,je,I,gt="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",be,U,Ie,C,Tt="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",Ue,v,Ce,A,ft="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",ve,L,Ae,R,Le,_,yt="You can use an existing bucket for storing the fine-tuning artifacts, if you already have a bucket, feel free to skip this step and jump onto the next one.",Re,$,Jt="As the Vertex AI job will generate artifacts, you need to specify a Google Cloud Storage (GCS) Bucket to dump those artifacts into. So on, you need to create a GCS Bucket via the <code>gcloud storage buckets create</code> subcommand as follows:",_e,x,$e,E,xe,S,wt="Once you have configured the environment and created the GCS Bucket (if applicable), you can proceed with the definition of the <code>CustomContainerTrainingJob</code>, which is a standard container job that runs on Vertex AI running a container, being the Hugging Face PyTorch DLC for training.",Ee,k,Se,B,jt="You now need to define a <code>CustomContainerTrainingJob</code> that runs on the Hugging Face PyTorch DLC for training, that needs to set the <code>trl sft</code> command capturing the arguments that will be provided whenever the job runs.",ke,G,bt="Note that the <code>CustomContainerTrainingJob</code> will override the default <code>ENTRYPOINT</code> provided within the container URI provided, so if the <code>ENTRYPOINT</code> is already prepared to receive the arguments, then there’s no need to define a custom <code>command</code>.",Be,V,Ge,Z,Ve,q,It='Before proceeding to the <code>CustomContainerTrainingJob</code> via the Hugging Face PyTorch DLC for training, you need to define first the configuration required for the job to run successfully i.e. which GPU is capable of fine-tuning <a href="https://huggingface.co/mistralai/Mistral-7B-v0.3" rel="nofollow"><code>mistralai/Mistral-7B-v0.3</code></a> in <code>bfloat16</code> with LoRA adapters.',Ze,W,Ut='As a rough calculation, you could assume that the amount of GPU VRAM required to fine-tune a model in half precision is about four times the model size (read more about it in <a href="https://blog.eleuther.ai/transformer-math/" rel="nofollow">Eleuther AI - Transformer Math 101</a>).',qe,F,Ct='Alternatively, if your model is uploaded to the Hugging Face Hub, you can check the numbers in the community space <a href="https://huggingface.co/spaces/Vokturz/can-it-run-llm" rel="nofollow"><code>Vokturz/can-it-run-llm</code></a>, which does those calculations for you, based the model to fine-tune and the available hardware.',We,X,vt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-lora-sft-fine-tuning-on-vertex-ai/assets/can-it-run-llm.png" alt="&#39;Vokturz/can-it-run-llm&#39; for &#39;mistralai/Mistral-7B-v0.3&#39;"/>',Fe,N,Xe,H,At='As mentioned before, the job will run the LoRA Supervised Fine-Tuning (SFT) with the TRL CLI on top of <a href="https://huggingface.co/mistralai/Mistral-7B-v0.3" rel="nofollow"><code>mistralai/Mistral-7B-v0.3</code></a> in <code>bfloat16</code> using <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow"><code>timdettmers/openassistant-guanaco</code></a>, which is a subset from <a href="https://huggingface.co/datasets/OpenAssistant/oasst1" rel="nofollow"><code>OpenAssistant/oasst1</code></a> with ~10k samples.',Ne,Y,Lt=`Once you have decided which resources to use to run the job, you need to define the hyper parameters accordingly to ensure that the selected instance is capable of running the job.
Some of the hparams that you may want to look into to avoid running into OOM errors are the following:`,He,Q,Rt='<li><strong>LoRA / QLoRA</strong>: you may need to tweak the rank, denoted by <code>r</code>, which defines the fraction of trainable parameters for each linear layer included meaning that the lower the less memory consumption.</li> <li><strong>Optimizer</strong>: by default the AdamW optimizer will be used, but alternatively lower precision optimizers can be used to reduce the memory as well e.g. <code>adamw_bnb_8bit</code> (for more information on 8-bit optimizers check <a href="https://huggingface.co/docs/bitsandbytes/main/en/optimizers" rel="nofollow">https://huggingface.co/docs/bitsandbytes/main/en/optimizers</a>).</li> <li><strong>Batch size</strong>: you can tweak this so as to use a lower batch size when running into OOM, or you can also tweak the gradient accumulation steps to simulate a similar batch size for updating the gradients, but providing less inputs within a batch a time e.g. <code>batch_size=8</code> and <code>gradient_accumulation=1</code> is effectively the same as <code>batch_size=4</code> and <code>gradient_accumulation=2</code>.</li>',Ye,P,_t='As the <code>CustomContainerTrainingJob</code> defines the command <code>trl sft</code> the arguments to be provided are listed either in the Python reference at <a href="https://huggingface.co/docs/trl/en/sft_trainer#trl.SFTConfig" rel="nofollow">trl.SFTConfig</a> or via the <code>trl sft --help</code> command.',Qe,z,$t='Read more about the TRL CLI at <a href="https://huggingface.co/docs/trl/en/clis" rel="nofollow">https://huggingface.co/docs/trl/en/clis</a>.',Pe,D,xt='It’s important to note that since GCS FUSE is used to mount the bucket as a directory within the running container job, the mounted path follows the formatting <code>/gcs/&lt;BUCKET_NAME&gt;</code>. More information at <a href="https://cloud.google.com/vertex-ai/docs/training/code-requirements" rel="nofollow">https://cloud.google.com/vertex-ai/docs/training/code-requirements</a>. So the <code>output_dir</code> needs to be set to the mounted GCS Bucket, meaning that anything the <code>SFTTrainer</code> writes there will be automatically uploaded to the GCS Bucket.',ze,O,De,K,Et="Then you need to call the <code>submit</code> method on the <code>aiplatform.CustomContainerTrainingJob</code>, which is a non-blocking method that will schedule the job without blocking the execution.",Oe,ee,St="The arguments provided to the <code>submit</code> method are listed below:",Ke,te,kt='<li><p><strong><code>args</code></strong> defines the list of arguments to be provided to the <code>trl sft</code> command, provided as <code>trl sft --arg_1=value ...</code>.</p></li> <li><p><strong><code>replica_count</code></strong> defines the number of replicas to run the job in, for training normally this value will be set to one.</p></li> <li><p><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> define the machine i.e. Compute Engine instance, the accelerator (if any), and the number of accelerators (ranging from 1 to 8); respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</p></li> <li><p><strong><code>base_output_dir</code></strong> defines the base directory that will be mounted within the running container from the GCS Bucket, conditioned by the <code>staging_bucket</code> argument provided to the <code>aiplatform.init</code> initially.</p></li> <li><p>(optional) <strong><code>environment_variables</code></strong> defines the environment variables to define within the running container. As you are fine-tuning a gated model i.e. <a href="https://huggingface.co/mistralai/Mistral-7B-v0.3" rel="nofollow"><code>mistralai/Mistral-7B-v0.3</code></a>, you need to set the <code>HF_TOKEN</code> environment variable. Additionally, some other environment variables are defined to set the cache path (<code>HF_HOME</code>) and to ensure that the logging messages are streamed to Google Cloud Logs Explorer properly (<code>TRL_USE_RICH</code>, <code>ACCELERATE_LOG_LEVEL</code>, <code>TRANSFORMERS_LOG_LEVEL</code>, and <code>TQDM_POSITION</code>).</p></li> <li><p>(optional) <strong><code>timeout</code></strong> and <strong><code>create_request_timeout</code></strong> define the timeouts in seconds before interrupting the job execution or the job creation request (time to allocate required resources and start the execution), respectively.</p></li>',et,ne,tt,le,nt,se,lt,oe,Bt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-lora-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-pipeline-scheduled.png" alt="Pipeline created in Vertex AI"/>',st,ae,Gt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-lora-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-pipeline-completed.png" alt="Vertex AI Pipeline successfully completed"/>',ot,ie,Vt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-lora-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-pipeline-logs.png" alt="Vertex AI Pipeline logs"/>',at,re,Zt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-lora-sft-fine-tuning-on-vertex-ai/assets/gcs-bucket-artifacts.png" alt="GCS Bucket with uploaded artifacts"/>',it,ce,qt='Finally, you can upload the fine-tuned model to the Hugging Face Hub, or just keep it within the Google Cloud Storage (GCS) Bucket. Later on, you will be able to run the inference on top of it after <a href="https://huggingface.co/docs/trl/main/en/use_model#use-adapters-peft" rel="nofollow">merging the adapters</a> via either the Hugging Face PyTorch DLC for inference via the <code>pipeline</code> in <code>transformers</code>, or via the Hugging Face DLC for TGI (as the model is fine-tuned for <code>text-generation</code>).',rt,ue,ct,Me,ut;return T=new pe({props:{title:"Fine-tune LLMs using SFT + LoRA with TRL’s CLI on Vertex AI",local:"fine-tune-llms-using-sft--lora-with-trls-cli-on-vertex-ai",headingTag:"h1"}}),J=new pe({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),b=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),U=new h({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMEJVQ0tFVF9VUkklM0RncyUzQSUyRiUyRmhmLXZlcnRleC1waXBlbGluZXMlMEElMjVlbnYlMjBDT05UQUlORVJfVVJJJTNEdXMtZG9ja2VyLnBrZy5kZXYlMkZkZWVwbGVhcm5pbmctcGxhdGZvcm0tcmVsZWFzZSUyRmdjci5pbyUyRmh1Z2dpbmdmYWNlLXB5dG9yY2gtdHJhaW5pbmctY3UxMjEuMi0zLnRyYW5zZm9ybWVycy40LTQyLnVidW50dTIyMDQucHkzMTA=",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env BUCKET_URI=gs://hf-vertex-pipelines
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-pytorch-training-cu121<span class="hljs-number">.2</span>-<span class="hljs-number">3.</span>transformers<span class="hljs-number">.4</span>-<span class="hljs-number">42.</span>ubuntu2204.py310`,wrap:!1}}),v=new h({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),L=new h({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),R=new pe({props:{title:"Optional: Create bucket in GCS",local:"optional-create-bucket-in-gcs",headingTag:"h2"}}),x=new h({props:{code:"IWdjbG91ZCUyMHN0b3JhZ2UlMjBidWNrZXRzJTIwY3JlYXRlJTIwJTI0QlVDS0VUX1VSSSUyMC0tcHJvamVjdCUyMCUyNFBST0pFQ1RfSUQlMjAtLWxvY2F0aW9uJTNEJTI0TE9DQVRJT04lMjAtLWRlZmF1bHQtc3RvcmFnZS1jbGFzcyUzRFNUQU5EQVJEJTIwLS11bmlmb3JtLWJ1Y2tldC1sZXZlbC1hY2Nlc3M=",highlighted:'!gcloud storage buckets create $BUCKET_URI --project $PROJECT_ID --location=$LOCATION --default-storage-<span class="hljs-keyword">class</span>=STANDARD --uniform-bucket-level-access',wrap:!1}}),E=new pe({props:{title:"Prepare CustomContainerTrainingJob",local:"prepare-customcontainertrainingjob",headingTag:"h2"}}),k=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBJTIwJTIwJTIwJTIwc3RhZ2luZ19idWNrZXQlM0Rvcy5nZXRlbnYoJTIyQlVDS0VUX1VSSSUyMiklMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
    staging_bucket=os.getenv(<span class="hljs-string">&quot;BUCKET_URI&quot;</span>),
)`,wrap:!1}}),V=new h({props:{code:"am9iJTIwJTNEJTIwYWlwbGF0Zm9ybS5DdXN0b21Db250YWluZXJUcmFpbmluZ0pvYiglMEElMjAlMjAlMjAlMjBkaXNwbGF5X25hbWUlM0QlMjJ0cmwtbG9yYS1zZnQlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250YWluZXJfdXJpJTNEb3MuZ2V0ZW52KCUyMkNPTlRBSU5FUl9VUkklMjIpJTJDJTBBJTIwJTIwJTIwJTIwY29tbWFuZCUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLWMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnZXhlYyUyMHRybCUyMHNmdCUyMCUyMiUyNCU0MCUyMiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`job = aiplatform.CustomContainerTrainingJob(
    display_name=<span class="hljs-string">&quot;trl-lora-sft&quot;</span>,
    container_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    command=[
        <span class="hljs-string">&quot;sh&quot;</span>,
        <span class="hljs-string">&quot;-c&quot;</span>,
        <span class="hljs-string">&#x27;exec trl sft &quot;$@&quot;&#x27;</span>,
        <span class="hljs-string">&quot;--&quot;</span>,
    ],
)`,wrap:!1}}),Z=new pe({props:{title:"Define CustomContainerTrainingJob Requirements",local:"define-customcontainertrainingjob-requirements",headingTag:"h2"}}),N=new pe({props:{title:"Run CustomContainerTrainingJob",local:"run-customcontainertrainingjob",headingTag:"h2"}}),O=new h({props:{code:"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",highlighted:`args = [
    <span class="hljs-comment"># MODEL</span>
    <span class="hljs-string">&quot;--model_name_or_path=mistralai/Mistral-7B-v0.3&quot;</span>,
    <span class="hljs-string">&quot;--torch_dtype=bfloat16&quot;</span>,
    <span class="hljs-string">&quot;--attn_implementation=flash_attention_2&quot;</span>,
    <span class="hljs-comment"># DATASET</span>
    <span class="hljs-string">&quot;--dataset_name=timdettmers/openassistant-guanaco&quot;</span>,
    <span class="hljs-string">&quot;--dataset_text_field=text&quot;</span>,
    <span class="hljs-comment"># PEFT</span>
    <span class="hljs-string">&quot;--use_peft&quot;</span>,
    <span class="hljs-string">&quot;--lora_r=16&quot;</span>,
    <span class="hljs-string">&quot;--lora_alpha=32&quot;</span>,
    <span class="hljs-string">&quot;--lora_dropout=0.1&quot;</span>,
    <span class="hljs-string">&quot;--lora_target_modules=all-linear&quot;</span>,
    <span class="hljs-comment"># TRAINER</span>
    <span class="hljs-string">&quot;--bf16&quot;</span>,
    <span class="hljs-string">&quot;--max_seq_length=1024&quot;</span>,
    <span class="hljs-string">&quot;--per_device_train_batch_size=2&quot;</span>,
    <span class="hljs-string">&quot;--gradient_accumulation_steps=8&quot;</span>,
    <span class="hljs-string">&quot;--gradient_checkpointing&quot;</span>,
    <span class="hljs-string">&quot;--learning_rate=0.0002&quot;</span>,
    <span class="hljs-string">&quot;--lr_scheduler_type=cosine&quot;</span>,
    <span class="hljs-string">&quot;--optim=adamw_bnb_8bit&quot;</span>,
    <span class="hljs-string">&quot;--num_train_epochs=1&quot;</span>,
    <span class="hljs-string">&quot;--logging_steps=10&quot;</span>,
    <span class="hljs-string">&quot;--do_eval&quot;</span>,
    <span class="hljs-string">&quot;--eval_steps=100&quot;</span>,
    <span class="hljs-string">&quot;--report_to=none&quot;</span>,
    <span class="hljs-string">f&quot;--output_dir=<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;BUCKET_URI&#x27;</span>).replace(<span class="hljs-string">&#x27;gs://&#x27;</span>, <span class="hljs-string">&#x27;/gcs/&#x27;</span>)}</span>/Mistral-7B-v0.3-LoRA-SFT-Guanaco&quot;</span>,
    <span class="hljs-string">&quot;--overwrite_output_dir&quot;</span>,
    <span class="hljs-string">&quot;--seed=42&quot;</span>,
    <span class="hljs-string">&quot;--log_level=debug&quot;</span>,
]`,wrap:!1}}),ne=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwaHVnZ2luZ2ZhY2VfaHVi",highlighted:"!pip install --upgrade --quiet huggingface_hub",wrap:!1}}),le=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),se=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQSUwQWpvYi5zdWJtaXQoJTBBJTIwJTIwJTIwJTIwYXJncyUzRGFyZ3MlMkMlMEElMjAlMjAlMjAlMjByZXBsaWNhX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMG1hY2hpbmVfdHlwZSUzRCUyMmcyLXN0YW5kYXJkLTEyJTIyJTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3JfdHlwZSUzRCUyMk5WSURJQV9MNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMGJhc2Vfb3V0cHV0X2RpciUzRGYlMjIlN0Jvcy5nZXRlbnYoJ0JVQ0tFVF9VUkknKSU3RCUyRk1pc3RyYWwtN0ItdjAuMy1Mb1JBLVNGVC1HdWFuYWNvJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW52aXJvbm1lbnRfdmFyaWFibGVzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySEZfSE9NRSUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhGX1RPS0VOJTIyJTNBJTIwZ2V0X3Rva2VuKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUUkxfVVNFX1JJQ0glMjIlM0ElMjAlMjIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQUNDRUxFUkFURV9MT0dfTEVWRUwlMjIlM0ElMjAlMjJJTkZPJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVFJBTlNGT1JNRVJTX0xPR19MRVZFTCUyMiUzQSUyMCUyMklORk8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUUURNX1BPU0lUSU9OJTIyJTNBJTIwJTIyLTElMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjB0aW1lb3V0JTNENjAlMjAqJTIwNjAlMjAqJTIwMyUyQyUyMCUyMCUyMyUyMDMlMjBob3VycyUyMCgxMDgwMHMpJTBBJTIwJTIwJTIwJTIwY3JlYXRlX3JlcXVlc3RfdGltZW91dCUzRDYwJTIwKiUyMDEwJTJDJTIwJTIwJTIzJTIwMTAlMjBtaW51dGVzJTIwKDYwMHMpJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token

job.submit(
    args=args,
    replica_count=<span class="hljs-number">1</span>,
    machine_type=<span class="hljs-string">&quot;g2-standard-12&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_L4&quot;</span>,
    accelerator_count=<span class="hljs-number">1</span>,
    base_output_dir=<span class="hljs-string">f&quot;<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;BUCKET_URI&#x27;</span>)}</span>/Mistral-7B-v0.3-LoRA-SFT-Guanaco&quot;</span>,
    environment_variables={
        <span class="hljs-string">&quot;HF_HOME&quot;</span>: <span class="hljs-string">&quot;/root/.cache/huggingface&quot;</span>,
        <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: get_token(),
        <span class="hljs-string">&quot;TRL_USE_RICH&quot;</span>: <span class="hljs-string">&quot;0&quot;</span>,
        <span class="hljs-string">&quot;ACCELERATE_LOG_LEVEL&quot;</span>: <span class="hljs-string">&quot;INFO&quot;</span>,
        <span class="hljs-string">&quot;TRANSFORMERS_LOG_LEVEL&quot;</span>: <span class="hljs-string">&quot;INFO&quot;</span>,
        <span class="hljs-string">&quot;TQDM_POSITION&quot;</span>: <span class="hljs-string">&quot;-1&quot;</span>,
    },
    timeout=<span class="hljs-number">60</span> * <span class="hljs-number">60</span> * <span class="hljs-number">3</span>,  <span class="hljs-comment"># 3 hours (10800s)</span>
    create_request_timeout=<span class="hljs-number">60</span> * <span class="hljs-number">10</span>,  <span class="hljs-comment"># 10 minutes (600s)</span>
)`,wrap:!1}}),ue=new Dt({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-trl-lora-sft-fine-tuning-on-vertex-ai.mdx"}}),{c(){g=a("meta"),me=s(),de=a("p"),he=s(),c(T.$$.fragment),ge=s(),f=a("p"),f.innerHTML=dt,Te=s(),y=a("p"),y.textContent=Mt,fe=s(),c(J.$$.fragment),ye=s(),w=a("p"),w.innerHTML=mt,Je=s(),j=a("p"),j.innerHTML=ht,we=s(),c(b.$$.fragment),je=s(),I=a("p"),I.textContent=gt,be=s(),c(U.$$.fragment),Ie=s(),C=a("p"),C.textContent=Tt,Ue=s(),c(v.$$.fragment),Ce=s(),A=a("p"),A.textContent=ft,ve=s(),c(L.$$.fragment),Ae=s(),c(R.$$.fragment),Le=s(),_=a("p"),_.textContent=yt,Re=s(),$=a("p"),$.innerHTML=Jt,_e=s(),c(x.$$.fragment),$e=s(),c(E.$$.fragment),xe=s(),S=a("p"),S.innerHTML=wt,Ee=s(),c(k.$$.fragment),Se=s(),B=a("p"),B.innerHTML=jt,ke=s(),G=a("p"),G.innerHTML=bt,Be=s(),c(V.$$.fragment),Ge=s(),c(Z.$$.fragment),Ve=s(),q=a("p"),q.innerHTML=It,Ze=s(),W=a("p"),W.innerHTML=Ut,qe=s(),F=a("p"),F.innerHTML=Ct,We=s(),X=a("p"),X.innerHTML=vt,Fe=s(),c(N.$$.fragment),Xe=s(),H=a("p"),H.innerHTML=At,Ne=s(),Y=a("p"),Y.textContent=Lt,He=s(),Q=a("ul"),Q.innerHTML=Rt,Ye=s(),P=a("p"),P.innerHTML=_t,Qe=s(),z=a("p"),z.innerHTML=$t,Pe=s(),D=a("p"),D.innerHTML=xt,ze=s(),c(O.$$.fragment),De=s(),K=a("p"),K.innerHTML=Et,Oe=s(),ee=a("p"),ee.innerHTML=St,Ke=s(),te=a("ul"),te.innerHTML=kt,et=s(),c(ne.$$.fragment),tt=s(),c(le.$$.fragment),nt=s(),c(se.$$.fragment),lt=s(),oe=a("p"),oe.innerHTML=Bt,st=s(),ae=a("p"),ae.innerHTML=Gt,ot=s(),ie=a("p"),ie.innerHTML=Vt,at=s(),re=a("p"),re.innerHTML=Zt,it=s(),ce=a("p"),ce.innerHTML=qt,rt=s(),c(ue.$$.fragment),ct=s(),Me=a("p"),this.h()},l(e){const t=Pt("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(n),me=o(e),de=i(e,"P",{}),Wt(de).forEach(n),he=o(e),u(T.$$.fragment,e),ge=o(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1r6b2zf"&&(f.innerHTML=dt),Te=o(e),y=i(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-inbnn8"&&(y.textContent=Mt),fe=o(e),u(J.$$.fragment,e),ye=o(e),w=i(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1o67gfb"&&(w.innerHTML=mt),Je=o(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1ebrquh"&&(j.innerHTML=ht),we=o(e),u(b.$$.fragment,e),je=o(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1i8n6rq"&&(I.textContent=gt),be=o(e),u(U.$$.fragment,e),Ie=o(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-15nvzfz"&&(C.textContent=Tt),Ue=o(e),u(v.$$.fragment,e),Ce=o(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1nm8o2l"&&(A.textContent=ft),ve=o(e),u(L.$$.fragment,e),Ae=o(e),u(R.$$.fragment,e),Le=o(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-16rwlsp"&&(_.textContent=yt),Re=o(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-48jxyw"&&($.innerHTML=Jt),_e=o(e),u(x.$$.fragment,e),$e=o(e),u(E.$$.fragment,e),xe=o(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-169vc8o"&&(S.innerHTML=wt),Ee=o(e),u(k.$$.fragment,e),Se=o(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1hb0nvg"&&(B.innerHTML=jt),ke=o(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-wppr6n"&&(G.innerHTML=bt),Be=o(e),u(V.$$.fragment,e),Ge=o(e),u(Z.$$.fragment,e),Ve=o(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1rqb4bn"&&(q.innerHTML=It),Ze=o(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-gy0104"&&(W.innerHTML=Ut),qe=o(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1qv2h88"&&(F.innerHTML=Ct),We=o(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-o8obxb"&&(X.innerHTML=vt),Fe=o(e),u(N.$$.fragment,e),Xe=o(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1a7nnjo"&&(H.innerHTML=At),Ne=o(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-oq0ay8"&&(Y.textContent=Lt),He=o(e),Q=i(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-1lf0452"&&(Q.innerHTML=Rt),Ye=o(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1h96pqn"&&(P.innerHTML=_t),Qe=o(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1u6w4tj"&&(z.innerHTML=$t),Pe=o(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1s7zwy8"&&(D.innerHTML=xt),ze=o(e),u(O.$$.fragment,e),De=o(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1dy7udt"&&(K.innerHTML=Et),Oe=o(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-c8lo6u"&&(ee.innerHTML=St),Ke=o(e),te=i(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-2jgcyb"&&(te.innerHTML=kt),et=o(e),u(ne.$$.fragment,e),tt=o(e),u(le.$$.fragment,e),nt=o(e),u(se.$$.fragment,e),lt=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-f1y78y"&&(oe.innerHTML=Bt),st=o(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1s1iqv7"&&(ae.innerHTML=Gt),ot=o(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-dhsoks"&&(ie.innerHTML=Vt),at=o(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-yuwmcb"&&(re.innerHTML=Zt),it=o(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1uovfna"&&(ce.innerHTML=qt),rt=o(e),u(ue.$$.fragment,e),ct=o(e),Me=i(e,"P",{}),Wt(Me).forEach(n),this.h()},h(){Ft(g,"name","hf:doc:metadata"),Ft(g,"content",Kt)},m(e,t){zt(document.head,g),l(e,me,t),l(e,de,t),l(e,he,t),p(T,e,t),l(e,ge,t),l(e,f,t),l(e,Te,t),l(e,y,t),l(e,fe,t),p(J,e,t),l(e,ye,t),l(e,w,t),l(e,Je,t),l(e,j,t),l(e,we,t),p(b,e,t),l(e,je,t),l(e,I,t),l(e,be,t),p(U,e,t),l(e,Ie,t),l(e,C,t),l(e,Ue,t),p(v,e,t),l(e,Ce,t),l(e,A,t),l(e,ve,t),p(L,e,t),l(e,Ae,t),p(R,e,t),l(e,Le,t),l(e,_,t),l(e,Re,t),l(e,$,t),l(e,_e,t),p(x,e,t),l(e,$e,t),p(E,e,t),l(e,xe,t),l(e,S,t),l(e,Ee,t),p(k,e,t),l(e,Se,t),l(e,B,t),l(e,ke,t),l(e,G,t),l(e,Be,t),p(V,e,t),l(e,Ge,t),p(Z,e,t),l(e,Ve,t),l(e,q,t),l(e,Ze,t),l(e,W,t),l(e,qe,t),l(e,F,t),l(e,We,t),l(e,X,t),l(e,Fe,t),p(N,e,t),l(e,Xe,t),l(e,H,t),l(e,Ne,t),l(e,Y,t),l(e,He,t),l(e,Q,t),l(e,Ye,t),l(e,P,t),l(e,Qe,t),l(e,z,t),l(e,Pe,t),l(e,D,t),l(e,ze,t),p(O,e,t),l(e,De,t),l(e,K,t),l(e,Oe,t),l(e,ee,t),l(e,Ke,t),l(e,te,t),l(e,et,t),p(ne,e,t),l(e,tt,t),p(le,e,t),l(e,nt,t),p(se,e,t),l(e,lt,t),l(e,oe,t),l(e,st,t),l(e,ae,t),l(e,ot,t),l(e,ie,t),l(e,at,t),l(e,re,t),l(e,it,t),l(e,ce,t),l(e,rt,t),p(ue,e,t),l(e,ct,t),l(e,Me,t),ut=!0},p:Nt,i(e){ut||(d(T.$$.fragment,e),d(J.$$.fragment,e),d(b.$$.fragment,e),d(U.$$.fragment,e),d(v.$$.fragment,e),d(L.$$.fragment,e),d(R.$$.fragment,e),d(x.$$.fragment,e),d(E.$$.fragment,e),d(k.$$.fragment,e),d(V.$$.fragment,e),d(Z.$$.fragment,e),d(N.$$.fragment,e),d(O.$$.fragment,e),d(ne.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ue.$$.fragment,e),ut=!0)},o(e){M(T.$$.fragment,e),M(J.$$.fragment,e),M(b.$$.fragment,e),M(U.$$.fragment,e),M(v.$$.fragment,e),M(L.$$.fragment,e),M(R.$$.fragment,e),M(x.$$.fragment,e),M(E.$$.fragment,e),M(k.$$.fragment,e),M(V.$$.fragment,e),M(Z.$$.fragment,e),M(N.$$.fragment,e),M(O.$$.fragment,e),M(ne.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),M(ue.$$.fragment,e),ut=!1},d(e){e&&(n(me),n(de),n(he),n(ge),n(f),n(Te),n(y),n(fe),n(ye),n(w),n(Je),n(j),n(we),n(je),n(I),n(be),n(Ie),n(C),n(Ue),n(Ce),n(A),n(ve),n(Ae),n(Le),n(_),n(Re),n($),n(_e),n($e),n(xe),n(S),n(Ee),n(Se),n(B),n(ke),n(G),n(Be),n(Ge),n(Ve),n(q),n(Ze),n(W),n(qe),n(F),n(We),n(X),n(Fe),n(Xe),n(H),n(Ne),n(Y),n(He),n(Q),n(Ye),n(P),n(Qe),n(z),n(Pe),n(D),n(ze),n(De),n(K),n(Oe),n(ee),n(Ke),n(te),n(et),n(tt),n(nt),n(lt),n(oe),n(st),n(ae),n(ot),n(ie),n(at),n(re),n(it),n(ce),n(rt),n(ct),n(Me)),n(g),m(T,e),m(J,e),m(b,e),m(U,e),m(v,e),m(L,e),m(R,e),m(x,e),m(E,e),m(k,e),m(V,e),m(Z,e),m(N,e),m(O,e),m(ne,e),m(le,e),m(se,e),m(ue,e)}}}const Kt='{"title":"Fine-tune LLMs using SFT + LoRA with TRL’s CLI on Vertex AI","local":"fine-tune-llms-using-sft--lora-with-trls-cli-on-vertex-ai","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Optional: Create bucket in GCS","local":"optional-create-bucket-in-gcs","sections":[],"depth":2},{"title":"Prepare CustomContainerTrainingJob","local":"prepare-customcontainertrainingjob","sections":[],"depth":2},{"title":"Define CustomContainerTrainingJob Requirements","local":"define-customcontainertrainingjob-requirements","sections":[],"depth":2},{"title":"Run CustomContainerTrainingJob","local":"run-customcontainertrainingjob","sections":[],"depth":2}],"depth":1}';function en(pt){return Ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class on extends Yt{constructor(g){super(),Qt(this,g,en,Ot,Xt,{})}}export{on as component};
