import{s as ul,n as pl,o as Ml}from"../chunks/scheduler.b108d059.js";import{S as dl,i as ml,g as o,s,r as c,A as hl,h as a,f as l,c as i,j as rl,u,x as r,k as cl,y as gl,a as n,v as p,d as M,t as d,w as m}from"../chunks/index.008de539.js";import{C as h}from"../chunks/CodeBlock.3968c746.js";import{H as ye,E as fl}from"../chunks/EditOnGithub.d1c48e3d.js";function yl(Ct){let g,je,Te,Je,f,be,y,It='<a href="https://github.com/huggingface/trl" rel="nofollow">Transformer Reinforcement Learning (TRL)</a> is a framework developed by Hugging Face to fine-tune and align both transformer language and diffusion models using methods such as Supervised Fine-Tuning (SFT), Reward Modeling (RM), Proximal Policy Optimization (PPO), Direct Preference Optimization (DPO), and others. On the other hand, Vertex AI is a Machine Learning (ML) platform that lets you train and deploy ML models and AI applications, and customize large language models (LLMs) for use in your AI-powered applications.',Ue,T,vt="This example showcases how to create a custom training job on Vertex AI running the Hugging Face PyTorch DLC for training, using the TRL CLI to full fine-tune a 7B LLM with SFT in a multi-GPU setting.",Ce,w,Ie,j,At='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',ve,J,_t="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",Ae,b,_e,U,Zt="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",Ze,C,Re,I,Rt="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",Ee,v,Ve,A,Et="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",xe,_,Be,Z,Le,R,Vt="You can use an existing bucket for storing the fine-tuning artifacts, if you already have a bucket, feel free to skip this step and jump onto the next one.",Ge,E,xt="As the Vertex AI job will generate artifacts, you need to specify a Google Cloud Storage (GCS) Bucket to dump those artifacts into. So on, you need to create a GCS Bucket via the <code>gcloud storage buckets create</code> subcommand as follows:",$e,V,Se,x,ke,B,Bt="Once you have configured the environment and created the GCS Bucket (if applicable), you can proceed with the definition of the <code>CustomContainerTrainingJob</code>, which is a standard container job that runs on Vertex AI running a container, being the Hugging Face PyTorch DLC for training.",Fe,L,We,G,Lt="Before proceeding with the definition of the <code>CustomContainerTrainingJob</code>, you need to define the <code>accelerate</code> configuration file that you want to use when running the <code>trl sft</code> command, required as you are in a multi-GPU environment, otherwise the default configuration will be used and may not be getting the most when running the fine-tuning job on multiple GPUs.",Xe,$,Gt="You need to define the DeepSpeed Zero3 configuration by creating the following <code>deepspeed.yaml</code> file locally, containing the configuration that will be used to run the SFT fine-tuning in a distributed setting on multiple GPUs. Some of the values defined within the following configuration file are:",qe,S,$t="<li><code>mixed_precision=bf16</code> as the fine-tuning will be in <code>bfloat16</code></li> <li><code>num_processes=4</code> as the fine-tuning will run on 4 A100 GPUs</li> <li><code>num_machines=1</code> and <code>same_network=true</code> as the GPUs are within the same single instance</li>",Ne,k,St='Note that DeepSpeed Zero3 has been selected as the distributed configuration for <code>accelerate</code>, but any other can be used and configured via the <code>accelerate config</code> command, that will prompt the different configurations; or just explore some pre-defined configuration files in the <a href="https://github.com/huggingface/accelerate/tree/main/examples/config_yaml_templates" rel="nofollow">Accelerate Config Zoo</a>.',He,F,Qe,W,kt="You now need to define a <code>CustomContainerTrainingJob</code> that runs on the Hugging Face PyTorch DLC for training, that needs to run the following sequential steps:",Ye,X,Ft="<li>Create the <code>$HF_HOME/accelerate</code> path (if not existing already) as the <code>accelerate</code> config will be dumped there.</li> <li>Write the content of the <code>deepspeed.yaml</code> configuration file into the cache under the <code>default_config.yaml</code> name (as that’s <code>accelerate</code> default path i.e. the configuration that will be used for the fine-tuning job).</li> <li>Add the <code>trl sft</code> command capturing the arguments that will be provided whenever the job runs.</li>",ze,q,Wt="Note that the <code>CustomContainerTrainingJob</code> will override the default <code>ENTRYPOINT</code> provided within the container URI provided, so if the <code>ENTRYPOINT</code> is already suited to receive the arguments, then there’s no need to define a custom <code>command</code>.",Pe,N,De,H,Oe,Q,Xt='Before proceeding to the <code>CustomContainerTrainingJob</code> via the Hugging Face PyTorch DLC for training, you need to define first the configuration required for the job to run successfully i.e. which GPU is capable of fine-tuning <a href="https://huggingface.co/mistralai/Mistral-7B-v0.3" rel="nofollow"><code>mistralai/Mistral-7B-v0.3</code></a> in <code>bfloat16</code>.',Ke,Y,qt='As a rough calculation, you could assume that the amount of GPU VRAM required to fine-tune a model in half precision is about four times the model size (read more about it in <a href="https://blog.eleuther.ai/transformer-math/" rel="nofollow">Eleuther AI - Transformer Math 101</a>).',et,z,Nt='Alternatively, if your model is uploaded to the Hugging Face Hub, you can check the numbers in the community space <a href="https://huggingface.co/spaces/Vokturz/can-it-run-llm" rel="nofollow"><code>Vokturz/can-it-run-llm</code></a>, which does those calculations for you, based the model to fine-tune and the available hardware.',tt,P,Ht='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/can-it-run-llm.png" alt="&#39;Vokturz/can-it-run-llm&#39; for &#39;mistralai/Mistral-7B-v0.3&#39;"/>',lt,D,nt,O,Qt='As mentioned before, the job will run the Supervised Fine-Tuning (SFT) with the TRL CLI on top of <a href="https://huggingface.co/mistralai/Mistral-7B-v0.3" rel="nofollow"><code>mistralai/Mistral-7B-v0.3</code></a> in <code>bfloat16</code> using <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow"><code>timdettmers/openassistant-guanaco</code></a>, which is a subset from <a href="https://huggingface.co/datasets/OpenAssistant/oasst1" rel="nofollow"><code>OpenAssistant/oasst1</code></a> with ~10k samples.',st,K,Yt=`Once you have decided which resources to use to run the job, you need to define the hyper parameters accordingly to ensure that the selected instance is capable of running the job.
Some of the hparams that you may want to look into to avoid running into OOM errors are the following:`,it,ee,zt='<li><strong>Optimizer</strong>: by default the AdamW optimizer will be used, but alternatively lower precision optimizers can be used to reduce the memory as well e.g. <code>adamw_bnb_8bit</code> (for more information on 8-bit optimizers check <a href="https://huggingface.co/docs/bitsandbytes/main/en/optimizers" rel="nofollow">https://huggingface.co/docs/bitsandbytes/main/en/optimizers</a>).</li> <li><strong>Batch size</strong>: you can tweak this so as to use a lower batch size when running into OOM, or you can also tweak the gradient accumulation steps to simulate a similar batch size for updating the gradients, but providing less inputs within a batch a time e.g. <code>batch_size=8</code> and <code>gradient_accumulation=1</code> is effectively the same as <code>batch_size=4</code> and <code>gradient_accumulation=2</code>.</li>',ot,te,Pt='As the <code>CustomContainerTrainingJob</code> defines the command <code>trl sft</code> the arguments to be provided are listed either in the Python reference at <a href="https://huggingface.co/docs/trl/en/sft_trainer#trl.SFTConfig" rel="nofollow">trl.SFTConfig</a> or via the <code>trl sft --help</code> command.',at,le,Dt='Read more about the TRL CLI at <a href="https://huggingface.co/docs/trl/en/clis" rel="nofollow">https://huggingface.co/docs/trl/en/clis</a>.',rt,ne,Ot='It’s important to note that since GCS FUSE is used to mount the bucket as a directory within the running container job, the mounted path follows the formatting <code>/gcs/&lt;BUCKET_NAME&gt;</code>. More information at <a href="https://cloud.google.com/vertex-ai/docs/training/code-requirements" rel="nofollow">https://cloud.google.com/vertex-ai/docs/training/code-requirements</a>. So the <code>output_dir</code> needs to be set to the mounted GCS Bucket, meaning that anything the <code>SFTTrainer</code> writes there will be automatically uploaded to the GCS Bucket.',ct,se,ut,ie,Kt="Then you need to call the <code>submit</code> method on the <code>aiplatform.CustomContainerTrainingJob</code>, which is a non-blocking method that will schedule the job without blocking the execution.",pt,oe,el="The arguments provided to the <code>submit</code> method are listed below:",Mt,ae,tl='<li><p><strong><code>args</code></strong> defines the list of arguments to be provided to the <code>trl sft</code> command, provided as <code>trl sft --arg_1=value ...</code>.</p></li> <li><p><strong><code>replica_count</code></strong> defines the number of replicas to run the job in, for training normally this value will be set to one.</p></li> <li><p><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> define the machine i.e. Compute Engine instance, the accelerator (if any), and the number of accelerators (ranging from 1 to 8); respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</p></li> <li><p><strong><code>base_output_dir</code></strong> defines the base directory that will be mounted within the running container from the GCS Bucket, conditioned by the <code>staging_bucket</code> argument provided to the <code>aiplatform.init</code> initially.</p></li> <li><p>(optional) <strong><code>environment_variables</code></strong> defines the environment variables to define within the running container. As you are fine-tuning a gated model i.e. <a href="https://huggingface.co/mistralai/Mistral-7B-v0.3" rel="nofollow"><code>mistralai/Mistral-7B-v0.3</code></a>, you need to set the <code>HF_TOKEN</code> environment variable. Additionally, some other environment variables are defined to set the cache path (<code>HF_HOME</code>) and to ensure that the logging messages are streamed to Google Cloud Logs Explorer properly (<code>TRL_USE_RICH</code>, <code>ACCELERATE_LOG_LEVEL</code>, <code>TRANSFORMERS_LOG_LEVEL</code>, and <code>TQDM_POSITION</code>).</p></li> <li><p>(optional) <strong><code>timeout</code></strong> and <strong><code>create_request_timeout</code></strong> define the timeouts in seconds before interrupting the job execution or the job creation request (time to allocate required resources and start the execution), respectively.</p></li> <li><p>(optional) <strong><code>boot_disk_size</code></strong> defines the size in GiB of the boot disk, increased to store not only the model weights but also all the intermediate checkpoints if any; otherwise, it defaults to 100GiB which may not be sufficient in some cases.</p></li>',dt,re,mt,ce,ht,ue,gt,pe,ll='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-pipeline-scheduled.png" alt="Pipeline created in Vertex AI"/>',ft,Me,nl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-pipeline-completed.png" alt="Vertex AI Pipeline successfully completed"/>',yt,de,sl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-pipeline-logs.png" alt="Vertex AI Pipeline logs"/>',Tt,me,il='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-run.png" alt="Vertex AI Run"/>',wt,he,ol='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/gcs-bucket-artifacts.png" alt="GCS Bucket with uploaded artifacts"/>',jt,ge,al="Finally, you can upload the fine-tuned model to the Hugging Face Hub, or just keep it within the Google Cloud Storage (GCS) Bucket. Later on, you will be able to run the inference on top of it via either the Hugging Face PyTorch DLC for inference via the <code>pipeline</code> in <code>transformers</code>, or via the Hugging Face DLC for TGI (as the model is fine-tuned for <code>text-generation</code>).",Jt,fe,bt,we,Ut;return f=new ye({props:{title:"Fine-tune LLMs using SFT with TRL’s CLI on Vertex AI",local:"fine-tune-llms-using-sft-with-trls-cli-on-vertex-ai",headingTag:"h1"}}),w=new ye({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),b=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),C=new h({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMEJVQ0tFVF9VUkklM0RncyUzQSUyRiUyRmhmLXZlcnRleC1waXBlbGluZXMlMEElMjVlbnYlMjBDT05UQUlORVJfVVJJJTNEdXMtZG9ja2VyLnBrZy5kZXYlMkZkZWVwbGVhcm5pbmctcGxhdGZvcm0tcmVsZWFzZSUyRmdjci5pbyUyRmh1Z2dpbmdmYWNlLXB5dG9yY2gtdHJhaW5pbmctY3UxMjEuMi0zLnRyYW5zZm9ybWVycy40LTQyLnVidW50dTIyMDQucHkzMTA=",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env BUCKET_URI=gs://hf-vertex-pipelines
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-pytorch-training-cu121<span class="hljs-number">.2</span>-<span class="hljs-number">3.</span>transformers<span class="hljs-number">.4</span>-<span class="hljs-number">42.</span>ubuntu2204.py310`,wrap:!1}}),v=new h({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),_=new h({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),Z=new ye({props:{title:"Optional: Create bucket in GCS",local:"optional-create-bucket-in-gcs",headingTag:"h2"}}),V=new h({props:{code:"IWdjbG91ZCUyMHN0b3JhZ2UlMjBidWNrZXRzJTIwY3JlYXRlJTIwJTI0QlVDS0VUX1VSSSUyMC0tcHJvamVjdCUyMCUyNFBST0pFQ1RfSUQlMjAtLWxvY2F0aW9uJTNEJTI0TE9DQVRJT04lMjAtLWRlZmF1bHQtc3RvcmFnZS1jbGFzcyUzRFNUQU5EQVJEJTIwLS11bmlmb3JtLWJ1Y2tldC1sZXZlbC1hY2Nlc3M=",highlighted:'!gcloud storage buckets create $BUCKET_URI --project $PROJECT_ID --location=$LOCATION --default-storage-<span class="hljs-keyword">class</span>=STANDARD --uniform-bucket-level-access',wrap:!1}}),x=new ye({props:{title:"Prepare CustomContainerTrainingJob",local:"prepare-customcontainertrainingjob",headingTag:"h2"}}),L=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBJTIwJTIwJTIwJTIwc3RhZ2luZ19idWNrZXQlM0Rvcy5nZXRlbnYoJTIyQlVDS0VUX1VSSSUyMiklMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
    staging_bucket=os.getenv(<span class="hljs-string">&quot;BUCKET_URI&quot;</span>),
)`,wrap:!1}}),F=new h({props:{code:"JTI1JTI1d3JpdGVmaWxlJTIwJTIyLiUyRmFzc2V0cyUyRmRlZXBzcGVlZC55YW1sJTIyJTBBY29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWJ1ZyUzQSUyMGZhbHNlJTBBZGVlcHNwZWVkX2NvbmZpZyUzQSUwQSUyMCUyMGRlZXBzcGVlZF9tdWx0aW5vZGVfbGF1bmNoZXIlM0ElMjBzdGFuZGFyZCUwQSUyMCUyMG9mZmxvYWRfb3B0aW1pemVyX2RldmljZSUzQSUyMG5vbmUlMEElMjAlMjBvZmZsb2FkX3BhcmFtX2RldmljZSUzQSUyMG5vbmUlMEElMjAlMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBJTIwJTIwemVybzNfc2F2ZV8xNmJpdF9tb2RlbCUzQSUyMHRydWUlMEElMjAlMjB6ZXJvX3N0YWdlJTNBJTIwMyUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGJmMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDQlMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdHB1X2VudiUzQSUyMCU1QiU1RCUwQXRwdV91c2VfY2x1c3RlciUzQSUyMGZhbHNlJTBBdHB1X3VzZV9zdWRvJTNBJTIwZmFsc2UlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`%%writefile <span class="hljs-string">&quot;./assets/deepspeed.yaml&quot;</span>
compute_environment: LOCAL_MACHINE
debug: false
deepspeed_config:
  deepspeed_multinode_launcher: standard
  offload_optimizer_device: none
  offload_param_device: none
  zero3_init_flag: true
  zero3_save_16bit_model: true
  zero_stage: <span class="hljs-number">3</span>
distributed_type: DEEPSPEED
downcast_bf16: <span class="hljs-string">&#x27;no&#x27;</span>
machine_rank: <span class="hljs-number">0</span>
main_training_function: main
mixed_precision: bf16
num_machines: <span class="hljs-number">1</span>
num_processes: <span class="hljs-number">4</span>
rdzv_backend: static
same_network: true
tpu_env: []
tpu_use_cluster: false
tpu_use_sudo: false
use_cpu: false`,wrap:!1}}),N=new h({props:{code:"am9iJTIwJTNEJTIwYWlwbGF0Zm9ybS5DdXN0b21Db250YWluZXJUcmFpbmluZ0pvYiglMEElMjAlMjAlMjAlMjBkaXNwbGF5X25hbWUlM0QlMjJ0cmwtZnVsbC1zZnQlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250YWluZXJfdXJpJTNEb3MuZ2V0ZW52KCUyMkNPTlRBSU5FUl9VUkklMjIpJTJDJTBBJTIwJTIwJTIwJTIwY29tbWFuZCUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLWMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjAlMjYlMjYlMjAlMjIuam9pbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWtkaXIlMjAtcCUyMCUyNEhGX0hPTUUlMkZhY2NlbGVyYXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMmVjaG8lMjAlNUMlMjIlN0JvcGVuKCcuJTJGYXNzZXRzJTJGZGVlcHNwZWVkLnlhbWwnKS5yZWFkKCklN0QlNUMlMjIlMjAlM0UlMjAlMjRIRl9IT01FJTJGYWNjZWxlcmF0ZSUyRmRlZmF1bHRfY29uZmlnLnlhbWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnZXhlYyUyMHRybCUyMHNmdCUyMCUyMiUyNCU0MCUyMiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBKQ==",highlighted:`job = aiplatform.CustomContainerTrainingJob(
    display_name=<span class="hljs-string">&quot;trl-full-sft&quot;</span>,
    container_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    command=[
        <span class="hljs-string">&quot;sh&quot;</span>,
        <span class="hljs-string">&quot;-c&quot;</span>,
        <span class="hljs-string">&quot; &amp;&amp; &quot;</span>.join(
            (
                <span class="hljs-string">&quot;mkdir -p $HF_HOME/accelerate&quot;</span>,
                <span class="hljs-string">f&quot;echo \\&quot;<span class="hljs-subst">{<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;./assets/deepspeed.yaml&#x27;</span>).read()}</span>\\&quot; &gt; $HF_HOME/accelerate/default_config.yaml&quot;</span>,
                <span class="hljs-string">&#x27;exec trl sft &quot;$@&quot;&#x27;</span>,
            )
        ),
        <span class="hljs-string">&quot;--&quot;</span>,
    ],
)`,wrap:!1}}),H=new ye({props:{title:"Define CustomContainerTrainingJob Requirements",local:"define-customcontainertrainingjob-requirements",headingTag:"h2"}}),D=new ye({props:{title:"Run CustomContainerTrainingJob",local:"run-customcontainertrainingjob",headingTag:"h2"}}),se=new h({props:{code:"YXJncyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMyUyME1PREVMJTBBJTIwJTIwJTIwJTIwJTIyLS1tb2RlbF9uYW1lX29yX3BhdGglM0RtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLXRvcmNoX2R0eXBlJTNEYmZsb2F0MTYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLWF0dG5faW1wbGVtZW50YXRpb24lM0RmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMERBVEFTRVQlMEElMjAlMjAlMjAlMjAlMjItLWRhdGFzZXRfbmFtZSUzRHRpbWRldHRtZXJzJTJGb3BlbmFzc2lzdGFudC1ndWFuYWNvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1kYXRhc2V0X3RleHRfZmllbGQlM0R0ZXh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwVFJBSU5FUiUwQSUyMCUyMCUyMCUyMCUyMi0tYmYxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tbWF4X3NlcV9sZW5ndGglM0QxMDI0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0QyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1ncmFkaWVudF9jaGVja3BvaW50aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1ncmFkaWVudF9jaGVja3BvaW50aW5nX3VzZV9yZWVudHJhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLWxlYXJuaW5nX3JhdGUlM0QwLjAwMDAyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1scl9zY2hlZHVsZXJfdHlwZSUzRGNvc2luZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tb3B0aW0lM0RhZGFtd19ibmJfOGJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tbnVtX3RyYWluX2Vwb2NocyUzRDElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLWxvZ2dpbmdfc3RlcHMlM0QxMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tZG9fZXZhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tZXZhbF9zdGVwcyUzRDEwMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tc2F2ZV9zdHJhdGVneSUzRGVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1yZXBvcnRfdG8lM0Rub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZiUyMi0tb3V0cHV0X2RpciUzRCU3Qm9zLmdldGVudignQlVDS0VUX1VSSScpLnJlcGxhY2UoJ2dzJTNBJTJGJTJGJyUyQyUyMCclMkZnY3MlMkYnKSU3RCUyRk1pc3RyYWwtN0ItdjAuMy1TRlQtR3VhbmFjbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tb3ZlcndyaXRlX291dHB1dF9kaXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLXNlZWQlM0Q0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tbG9nX2xldmVsJTNEaW5mbyUyMiUyQyUwQSU1RA==",highlighted:`args = [
    <span class="hljs-comment"># MODEL</span>
    <span class="hljs-string">&quot;--model_name_or_path=mistralai/Mistral-7B-v0.3&quot;</span>,
    <span class="hljs-string">&quot;--torch_dtype=bfloat16&quot;</span>,
    <span class="hljs-string">&quot;--attn_implementation=flash_attention_2&quot;</span>,
    <span class="hljs-comment"># DATASET</span>
    <span class="hljs-string">&quot;--dataset_name=timdettmers/openassistant-guanaco&quot;</span>,
    <span class="hljs-string">&quot;--dataset_text_field=text&quot;</span>,
    <span class="hljs-comment"># TRAINER</span>
    <span class="hljs-string">&quot;--bf16&quot;</span>,
    <span class="hljs-string">&quot;--max_seq_length=1024&quot;</span>,
    <span class="hljs-string">&quot;--per_device_train_batch_size=2&quot;</span>,
    <span class="hljs-string">&quot;--gradient_accumulation_steps=4&quot;</span>,
    <span class="hljs-string">&quot;--gradient_checkpointing&quot;</span>,
    <span class="hljs-string">&quot;--gradient_checkpointing_use_reentrant&quot;</span>,
    <span class="hljs-string">&quot;--learning_rate=0.00002&quot;</span>,
    <span class="hljs-string">&quot;--lr_scheduler_type=cosine&quot;</span>,
    <span class="hljs-string">&quot;--optim=adamw_bnb_8bit&quot;</span>,
    <span class="hljs-string">&quot;--num_train_epochs=1&quot;</span>,
    <span class="hljs-string">&quot;--logging_steps=10&quot;</span>,
    <span class="hljs-string">&quot;--do_eval&quot;</span>,
    <span class="hljs-string">&quot;--eval_steps=100&quot;</span>,
    <span class="hljs-string">&quot;--save_strategy=epoch&quot;</span>,
    <span class="hljs-string">&quot;--report_to=none&quot;</span>,
    <span class="hljs-string">f&quot;--output_dir=<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;BUCKET_URI&#x27;</span>).replace(<span class="hljs-string">&#x27;gs://&#x27;</span>, <span class="hljs-string">&#x27;/gcs/&#x27;</span>)}</span>/Mistral-7B-v0.3-SFT-Guanaco&quot;</span>,
    <span class="hljs-string">&quot;--overwrite_output_dir&quot;</span>,
    <span class="hljs-string">&quot;--seed=42&quot;</span>,
    <span class="hljs-string">&quot;--log_level=info&quot;</span>,
]`,wrap:!1}}),re=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwaHVnZ2luZ2ZhY2VfaHVi",highlighted:"!pip install --upgrade --quiet huggingface_hub",wrap:!1}}),ce=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),ue=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQSUwQWpvYi5zdWJtaXQoJTBBJTIwJTIwJTIwJTIwYXJncyUzRGFyZ3MlMkMlMEElMjAlMjAlMjAlMjByZXBsaWNhX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMG1hY2hpbmVfdHlwZSUzRCUyMmEyLWhpZ2hncHUtNGclMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl90eXBlJTNEJTIyTlZJRElBX1RFU0xBX0ExMDAlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl9jb3VudCUzRDQlMkMlMEElMjAlMjAlMjAlMjBiYXNlX291dHB1dF9kaXIlM0RmJTIyJTdCb3MuZ2V0ZW52KCdCVUNLRVRfVVJJJyklN0QlMkZNaXN0cmFsLTdCLXYwLjMtU0ZULUd1YW5hY28lMjIlMkMlMEElMjAlMjAlMjAlMjBlbnZpcm9ubWVudF92YXJpYWJsZXMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIRl9IT01FJTIyJTNBJTIwJTIyJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySEZfVE9LRU4lMjIlM0ElMjBnZXRfdG9rZW4oKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRSTF9VU0VfUklDSCUyMiUzQSUyMCUyMjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJBQ0NFTEVSQVRFX0xPR19MRVZFTCUyMiUzQSUyMCUyMklORk8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUUkFOU0ZPUk1FUlNfTE9HX0xFVkVMJTIyJTNBJTIwJTIySU5GTyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRRRE1fUE9TSVRJT04lMjIlM0ElMjAlMjItMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHRpbWVvdXQlM0Q2MCUyMColMjA2MCUyMColMjAzJTJDJTIwJTIwJTIzJTIwMyUyMGhvdXJzJTIwKDEwODAwcyklMEElMjAlMjAlMjAlMjBjcmVhdGVfcmVxdWVzdF90aW1lb3V0JTNENjAlMjAqJTIwMTAlMkMlMjAlMjAlMjMlMjAxMCUyMG1pbnV0ZXMlMjAoNjAwcyklMEElMjAlMjAlMjAlMjBib290X2Rpc2tfc2l6ZV9nYiUzRDI1MCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token

job.submit(
    args=args,
    replica_count=<span class="hljs-number">1</span>,
    machine_type=<span class="hljs-string">&quot;a2-highgpu-4g&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_TESLA_A100&quot;</span>,
    accelerator_count=<span class="hljs-number">4</span>,
    base_output_dir=<span class="hljs-string">f&quot;<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;BUCKET_URI&#x27;</span>)}</span>/Mistral-7B-v0.3-SFT-Guanaco&quot;</span>,
    environment_variables={
        <span class="hljs-string">&quot;HF_HOME&quot;</span>: <span class="hljs-string">&quot;/root/.cache/huggingface&quot;</span>,
        <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: get_token(),
        <span class="hljs-string">&quot;TRL_USE_RICH&quot;</span>: <span class="hljs-string">&quot;0&quot;</span>,
        <span class="hljs-string">&quot;ACCELERATE_LOG_LEVEL&quot;</span>: <span class="hljs-string">&quot;INFO&quot;</span>,
        <span class="hljs-string">&quot;TRANSFORMERS_LOG_LEVEL&quot;</span>: <span class="hljs-string">&quot;INFO&quot;</span>,
        <span class="hljs-string">&quot;TQDM_POSITION&quot;</span>: <span class="hljs-string">&quot;-1&quot;</span>,
    },
    timeout=<span class="hljs-number">60</span> * <span class="hljs-number">60</span> * <span class="hljs-number">3</span>,  <span class="hljs-comment"># 3 hours (10800s)</span>
    create_request_timeout=<span class="hljs-number">60</span> * <span class="hljs-number">10</span>,  <span class="hljs-comment"># 10 minutes (600s)</span>
    boot_disk_size_gb=<span class="hljs-number">250</span>,
)`,wrap:!1}}),fe=new fl({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-trl-full-sft-fine-tuning-on-vertex-ai.mdx"}}),{c(){g=o("meta"),je=s(),Te=o("p"),Je=s(),c(f.$$.fragment),be=s(),y=o("p"),y.innerHTML=It,Ue=s(),T=o("p"),T.textContent=vt,Ce=s(),c(w.$$.fragment),Ie=s(),j=o("p"),j.innerHTML=At,ve=s(),J=o("p"),J.innerHTML=_t,Ae=s(),c(b.$$.fragment),_e=s(),U=o("p"),U.textContent=Zt,Ze=s(),c(C.$$.fragment),Re=s(),I=o("p"),I.textContent=Rt,Ee=s(),c(v.$$.fragment),Ve=s(),A=o("p"),A.textContent=Et,xe=s(),c(_.$$.fragment),Be=s(),c(Z.$$.fragment),Le=s(),R=o("p"),R.textContent=Vt,Ge=s(),E=o("p"),E.innerHTML=xt,$e=s(),c(V.$$.fragment),Se=s(),c(x.$$.fragment),ke=s(),B=o("p"),B.innerHTML=Bt,Fe=s(),c(L.$$.fragment),We=s(),G=o("p"),G.innerHTML=Lt,Xe=s(),$=o("p"),$.innerHTML=Gt,qe=s(),S=o("ul"),S.innerHTML=$t,Ne=s(),k=o("p"),k.innerHTML=St,He=s(),c(F.$$.fragment),Qe=s(),W=o("p"),W.innerHTML=kt,Ye=s(),X=o("ol"),X.innerHTML=Ft,ze=s(),q=o("p"),q.innerHTML=Wt,Pe=s(),c(N.$$.fragment),De=s(),c(H.$$.fragment),Oe=s(),Q=o("p"),Q.innerHTML=Xt,Ke=s(),Y=o("p"),Y.innerHTML=qt,et=s(),z=o("p"),z.innerHTML=Nt,tt=s(),P=o("p"),P.innerHTML=Ht,lt=s(),c(D.$$.fragment),nt=s(),O=o("p"),O.innerHTML=Qt,st=s(),K=o("p"),K.textContent=Yt,it=s(),ee=o("ul"),ee.innerHTML=zt,ot=s(),te=o("p"),te.innerHTML=Pt,at=s(),le=o("p"),le.innerHTML=Dt,rt=s(),ne=o("p"),ne.innerHTML=Ot,ct=s(),c(se.$$.fragment),ut=s(),ie=o("p"),ie.innerHTML=Kt,pt=s(),oe=o("p"),oe.innerHTML=el,Mt=s(),ae=o("ul"),ae.innerHTML=tl,dt=s(),c(re.$$.fragment),mt=s(),c(ce.$$.fragment),ht=s(),c(ue.$$.fragment),gt=s(),pe=o("p"),pe.innerHTML=ll,ft=s(),Me=o("p"),Me.innerHTML=nl,yt=s(),de=o("p"),de.innerHTML=sl,Tt=s(),me=o("p"),me.innerHTML=il,wt=s(),he=o("p"),he.innerHTML=ol,jt=s(),ge=o("p"),ge.innerHTML=al,Jt=s(),c(fe.$$.fragment),bt=s(),we=o("p"),this.h()},l(e){const t=hl("svelte-u9bgzb",document.head);g=a(t,"META",{name:!0,content:!0}),t.forEach(l),je=i(e),Te=a(e,"P",{}),rl(Te).forEach(l),Je=i(e),u(f.$$.fragment,e),be=i(e),y=a(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1r6b2zf"&&(y.innerHTML=It),Ue=i(e),T=a(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1rm13w4"&&(T.textContent=vt),Ce=i(e),u(w.$$.fragment,e),Ie=i(e),j=a(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1o67gfb"&&(j.innerHTML=At),ve=i(e),J=a(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1ebrquh"&&(J.innerHTML=_t),Ae=i(e),u(b.$$.fragment,e),_e=i(e),U=a(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1i8n6rq"&&(U.textContent=Zt),Ze=i(e),u(C.$$.fragment,e),Re=i(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-15nvzfz"&&(I.textContent=Rt),Ee=i(e),u(v.$$.fragment,e),Ve=i(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1nm8o2l"&&(A.textContent=Et),xe=i(e),u(_.$$.fragment,e),Be=i(e),u(Z.$$.fragment,e),Le=i(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-16rwlsp"&&(R.textContent=Vt),Ge=i(e),E=a(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-48jxyw"&&(E.innerHTML=xt),$e=i(e),u(V.$$.fragment,e),Se=i(e),u(x.$$.fragment,e),ke=i(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-169vc8o"&&(B.innerHTML=Bt),Fe=i(e),u(L.$$.fragment,e),We=i(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-5olot6"&&(G.innerHTML=Lt),Xe=i(e),$=a(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1tdnehm"&&($.innerHTML=Gt),qe=i(e),S=a(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-oihk84"&&(S.innerHTML=$t),Ne=i(e),k=a(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-jsb5oe"&&(k.innerHTML=St),He=i(e),u(F.$$.fragment,e),Qe=i(e),W=a(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-w5gycc"&&(W.innerHTML=kt),Ye=i(e),X=a(e,"OL",{"data-svelte-h":!0}),r(X)!=="svelte-1q4i1bb"&&(X.innerHTML=Ft),ze=i(e),q=a(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-s9vx5u"&&(q.innerHTML=Wt),Pe=i(e),u(N.$$.fragment,e),De=i(e),u(H.$$.fragment,e),Oe=i(e),Q=a(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1hcwwpn"&&(Q.innerHTML=Xt),Ke=i(e),Y=a(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-gy0104"&&(Y.innerHTML=qt),et=i(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1qv2h88"&&(z.innerHTML=Nt),tt=i(e),P=a(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-93ywpw"&&(P.innerHTML=Ht),lt=i(e),u(D.$$.fragment,e),nt=i(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-9gv9c8"&&(O.innerHTML=Qt),st=i(e),K=a(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-oq0ay8"&&(K.textContent=Yt),it=i(e),ee=a(e,"UL",{"data-svelte-h":!0}),r(ee)!=="svelte-tb4cna"&&(ee.innerHTML=zt),ot=i(e),te=a(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1h96pqn"&&(te.innerHTML=Pt),at=i(e),le=a(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1u6w4tj"&&(le.innerHTML=Dt),rt=i(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1s7zwy8"&&(ne.innerHTML=Ot),ct=i(e),u(se.$$.fragment,e),ut=i(e),ie=a(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1dy7udt"&&(ie.innerHTML=Kt),pt=i(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-c8lo6u"&&(oe.innerHTML=el),Mt=i(e),ae=a(e,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-3qxazp"&&(ae.innerHTML=tl),dt=i(e),u(re.$$.fragment,e),mt=i(e),u(ce.$$.fragment,e),ht=i(e),u(ue.$$.fragment,e),gt=i(e),pe=a(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-13bkehl"&&(pe.innerHTML=ll),ft=i(e),Me=a(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-7d5aoo"&&(Me.innerHTML=nl),yt=i(e),de=a(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-120stu7"&&(de.innerHTML=sl),Tt=i(e),me=a(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-i2tmwy"&&(me.innerHTML=il),wt=i(e),he=a(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1fqsw"&&(he.innerHTML=ol),jt=i(e),ge=a(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-kn7urm"&&(ge.innerHTML=al),Jt=i(e),u(fe.$$.fragment,e),bt=i(e),we=a(e,"P",{}),rl(we).forEach(l),this.h()},h(){cl(g,"name","hf:doc:metadata"),cl(g,"content",Tl)},m(e,t){gl(document.head,g),n(e,je,t),n(e,Te,t),n(e,Je,t),p(f,e,t),n(e,be,t),n(e,y,t),n(e,Ue,t),n(e,T,t),n(e,Ce,t),p(w,e,t),n(e,Ie,t),n(e,j,t),n(e,ve,t),n(e,J,t),n(e,Ae,t),p(b,e,t),n(e,_e,t),n(e,U,t),n(e,Ze,t),p(C,e,t),n(e,Re,t),n(e,I,t),n(e,Ee,t),p(v,e,t),n(e,Ve,t),n(e,A,t),n(e,xe,t),p(_,e,t),n(e,Be,t),p(Z,e,t),n(e,Le,t),n(e,R,t),n(e,Ge,t),n(e,E,t),n(e,$e,t),p(V,e,t),n(e,Se,t),p(x,e,t),n(e,ke,t),n(e,B,t),n(e,Fe,t),p(L,e,t),n(e,We,t),n(e,G,t),n(e,Xe,t),n(e,$,t),n(e,qe,t),n(e,S,t),n(e,Ne,t),n(e,k,t),n(e,He,t),p(F,e,t),n(e,Qe,t),n(e,W,t),n(e,Ye,t),n(e,X,t),n(e,ze,t),n(e,q,t),n(e,Pe,t),p(N,e,t),n(e,De,t),p(H,e,t),n(e,Oe,t),n(e,Q,t),n(e,Ke,t),n(e,Y,t),n(e,et,t),n(e,z,t),n(e,tt,t),n(e,P,t),n(e,lt,t),p(D,e,t),n(e,nt,t),n(e,O,t),n(e,st,t),n(e,K,t),n(e,it,t),n(e,ee,t),n(e,ot,t),n(e,te,t),n(e,at,t),n(e,le,t),n(e,rt,t),n(e,ne,t),n(e,ct,t),p(se,e,t),n(e,ut,t),n(e,ie,t),n(e,pt,t),n(e,oe,t),n(e,Mt,t),n(e,ae,t),n(e,dt,t),p(re,e,t),n(e,mt,t),p(ce,e,t),n(e,ht,t),p(ue,e,t),n(e,gt,t),n(e,pe,t),n(e,ft,t),n(e,Me,t),n(e,yt,t),n(e,de,t),n(e,Tt,t),n(e,me,t),n(e,wt,t),n(e,he,t),n(e,jt,t),n(e,ge,t),n(e,Jt,t),p(fe,e,t),n(e,bt,t),n(e,we,t),Ut=!0},p:pl,i(e){Ut||(M(f.$$.fragment,e),M(w.$$.fragment,e),M(b.$$.fragment,e),M(C.$$.fragment,e),M(v.$$.fragment,e),M(_.$$.fragment,e),M(Z.$$.fragment,e),M(V.$$.fragment,e),M(x.$$.fragment,e),M(L.$$.fragment,e),M(F.$$.fragment,e),M(N.$$.fragment,e),M(H.$$.fragment,e),M(D.$$.fragment,e),M(se.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(ue.$$.fragment,e),M(fe.$$.fragment,e),Ut=!0)},o(e){d(f.$$.fragment,e),d(w.$$.fragment,e),d(b.$$.fragment,e),d(C.$$.fragment,e),d(v.$$.fragment,e),d(_.$$.fragment,e),d(Z.$$.fragment,e),d(V.$$.fragment,e),d(x.$$.fragment,e),d(L.$$.fragment,e),d(F.$$.fragment,e),d(N.$$.fragment,e),d(H.$$.fragment,e),d(D.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(fe.$$.fragment,e),Ut=!1},d(e){e&&(l(je),l(Te),l(Je),l(be),l(y),l(Ue),l(T),l(Ce),l(Ie),l(j),l(ve),l(J),l(Ae),l(_e),l(U),l(Ze),l(Re),l(I),l(Ee),l(Ve),l(A),l(xe),l(Be),l(Le),l(R),l(Ge),l(E),l($e),l(Se),l(ke),l(B),l(Fe),l(We),l(G),l(Xe),l($),l(qe),l(S),l(Ne),l(k),l(He),l(Qe),l(W),l(Ye),l(X),l(ze),l(q),l(Pe),l(De),l(Oe),l(Q),l(Ke),l(Y),l(et),l(z),l(tt),l(P),l(lt),l(nt),l(O),l(st),l(K),l(it),l(ee),l(ot),l(te),l(at),l(le),l(rt),l(ne),l(ct),l(ut),l(ie),l(pt),l(oe),l(Mt),l(ae),l(dt),l(mt),l(ht),l(gt),l(pe),l(ft),l(Me),l(yt),l(de),l(Tt),l(me),l(wt),l(he),l(jt),l(ge),l(Jt),l(bt),l(we)),l(g),m(f,e),m(w,e),m(b,e),m(C,e),m(v,e),m(_,e),m(Z,e),m(V,e),m(x,e),m(L,e),m(F,e),m(N,e),m(H,e),m(D,e),m(se,e),m(re,e),m(ce,e),m(ue,e),m(fe,e)}}}const Tl='{"title":"Fine-tune LLMs using SFT with TRL’s CLI on Vertex AI","local":"fine-tune-llms-using-sft-with-trls-cli-on-vertex-ai","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Optional: Create bucket in GCS","local":"optional-create-bucket-in-gcs","sections":[],"depth":2},{"title":"Prepare CustomContainerTrainingJob","local":"prepare-customcontainertrainingjob","sections":[],"depth":2},{"title":"Define CustomContainerTrainingJob Requirements","local":"define-customcontainertrainingjob-requirements","sections":[],"depth":2},{"title":"Run CustomContainerTrainingJob","local":"run-customcontainertrainingjob","sections":[],"depth":2}],"depth":1}';function wl(Ct){return Ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cl extends dl{constructor(g){super(),ml(this,g,wl,yl,ul,{})}}export{Cl as component};
