import{s as hn,n as un,o as yn}from"../chunks/scheduler.b108d059.js";import{S as mn,i as jn,g as o,s as a,r as p,A as Un,h as i,f as l,c as s,j as rn,u as d,x as M,k as cn,y as Jn,a as n,v as r,d as c,t as h,w as u}from"../chunks/index.008de539.js";import{C as y}from"../chunks/CodeBlock.3968c746.js";import{H as m,E as Tn}from"../chunks/EditOnGithub.d1c48e3d.js";function wn(yl){let j,Fe,Ee,Xe,U,Se,J,ml='<a href="https://huggingface.co/blog/llama31" rel="nofollow">Meta Llama 3.1</a> is the latest open LLM from Meta, a follow up iteration of Llama 3, released in July 2024. Meta Llama 3.1 comes in three sizes: 8B for efficient deployment and development on consumer-size GPU, 70B for large-scale AI native applications, and 405B for synthetic data, LLM as a Judge or distillation; among other use cases. Amongst Meta Llama 3.1 new features, the ones to highlight are: a large context length of 128K tokens (vs original 8K), multilingual capabilities, tool usage capabilities, and a more permissive license.',Le,T,jl='This example showcases how to deploy <a href="https://hf.co/meta-llama/Meta-Llama-3.1-405B-Instruct-FP8" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-405B-Instruct-FP8</code></a> on Vertex AI with an A3 accelerator-optimized instance with 8 NVIDIA H100s via the Hugging Face purpose-built Deep Learning Container (DLC) for Text Generation Inference (TGI) on Google Cloud.',Ye,w,Ul='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-llama-3-1-405b-on-vertex-ai/assets/model-in-hf-hub.png" alt="&#39;meta-llama/Meta-Llama-3.1-405B-Instruct-FP8&#39; in the Hugging Face Hub"/>',ze,g,qe,f,Jl='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',De,b,Tl="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",Pe,I,Oe,C,wl="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",Ke,G,et,A,gl="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",tt,v,lt,Z,fl="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",nt,N,at,B,bl='Once everything is set up, you can already initialize the Vertex AI session via the <a href="https://github.com/googleapis/python-aiplatform" rel="nofollow"><code>google-cloud-aiplatform</code></a> Python SDK as follows:',st,W,ot,_,it,V,Il='To serve <a href="https://hf.co/meta-llama/Meta-Llama-3.1-405B-Instruct-FP8" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-405B-Instruct-FP8</code></a> you need an instance with at least 400GiB of GPU VRAM that supports the FP8 data-type, and the A3 accelerator-optimized machines on Google Cloud are the machines you would need to use.',Mt,x,Cl='Even if the A3 accelerator-optimized machines with 8 x NVIDIA H100 80GB GPUs are available within Google Cloud, you will still need to request a custom quota increase in Google Cloud, as those need a specific approval. Note that the A3 accelerator-optimized machines are only available in some zones, so make sure to check the availability of both A3 High or even A3 Mega per zone at <a href="https://cloud.google.com/compute/docs/gpus/gpu-regions-zones" rel="nofollow">Compute Engine - GPU regions and zones</a>.',pt,R,Gl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-llama-3-1-405b-on-vertex-ai/assets/a3-general-availability.png" alt="A3 availability in Google Cloud"/>',dt,$,Al="In this case, to request a quota increase to use the machine with 8 NVIDIA H100s you will need to increase the following quotas:",rt,k,vl="<li><code>Service: Vertex AI API</code> and <code>Name: Custom model serving Nvidia H100 80GB GPUs per region</code> set to <strong>8</strong></li> <li><code>Service: Vertex AI API</code> and <code>Name: Custom model serving A3 CPUs per region</code> set to <strong>208</strong></li>",ct,Q,Zl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-llama-3-1-405b-on-vertex-ai/assets/a3-quota-request.png" alt="A3 Quota Request in Google Cloud"/>',ht,E,Nl='Read more on how to request a quota increase at <a href="https://cloud.google.com/docs/quotas/view-manage" rel="nofollow">Google Cloud Documentation - View and manage quotas</a>.',ut,H,yt,F,Bl='Since <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-405B-Instruct-FP8" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-405B-Instruct-FP8</code></a> is a gated model, you need to login into your Hugging Face Hub account, accept the gating requirements, and then generate an access token either with fine-grained read access to the gated model only (recommended), or read-access to your account.',mt,X,Wl='Read more about <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">access tokens for the Hugging Face Hub</a>.',jt,S,_l='To authenticate, you can either use the <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow"><code>huggingface_hub</code></a> Python SDK as shown below (recommended), or just set the environment variable <code>HF_TOKEN</code> instead.',Ut,L,Jt,Y,Tt,z,Vl="Then you can already “upload” the model i.e. register the model on Vertex AI. It is not an upload per se, since the model will be automatically downloaded from the Hugging Face Hub in the Hugging Face DLC for TGI on startup via the <code>MODEL_ID</code> environment variable, so what is uploaded is only the configuration, not the model weights.",wt,q,xl="Before going into the code, let’s quickly review the arguments provided to the <code>upload</code> method:",gt,D,Rl='<li><strong><code>display_name</code></strong> is the name that will be shown in the Vertex AI Model Registry.</li> <li><strong><code>serving_container_image_uri</code></strong> is the location of the Hugging Face DLC for TGI that will be used for serving the model.</li> <li><strong><code>serving_container_environment_variables</code></strong> are the environment variables that will be used during the container runtime, so these are aligned with the environment variables defined by TGI via the <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher" rel="nofollow"><code>text-generation-launcher</code></a>, which exposes some environment variables such as the following:<ul><li><code>MODEL_ID</code> the model ID on the Hugging Face Hub.</li> <li><code>NUM_SHARD</code> the number of shards to use i.e. the number of GPUs to use, in this case set to 8 as a node with 8 NVIDIA H100s will be used.</li> <li><code>HUGGING_FACE_HUB_TOKEN</code> is the Hugging Face Hub token, required as <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-405B-Instruct-FP8" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-405B-Instruct-FP8</code></a> is a gated model.</li> <li><code>HF_HUB_ENABLE_HF_TRANSFER</code> to enable a faster download speed via the <a href="https://github.com/huggingface/hf_transfer" rel="nofollow"><code>hf_transfer</code></a> library.</li></ul></li>',ft,P,$l='For more information on the supported arguments, check <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload" rel="nofollow"><code>aiplatform.Model.upload</code> Python reference</a>.',bt,O,It,K,kl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-llama-3-1-405b-on-vertex-ai/assets/vertex-ai-model.png" alt="Meta Llama 3.1 405B FP8 registered on Vertex AI"/>',Ct,ee,Gt,te,Ql="Once Meta Llama 3.1 405B is registered on Vertex AI Model Registry, you can already deploy it on a Vertex AI Endpoint with the Hugging Face DLC for TGI.",At,le,El="The <code>deploy</code> method will link the previously created endpoint resource with the model that contains the configuration of the serving container, and then, it will deploy the model on Vertex AI in the specified instance.",vt,ne,Hl="Before going into the code, let’s quickly review the arguments provided to the <code>deploy</code> method:",Zt,ae,Fl='<li><strong><code>endpoint</code></strong> is the endpoint to deploy the model to, which is optional, and by default will be set to the model display name with the <code>_endpoint</code> suffix.</li> <li><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> are arguments that define which instance to use, and additionally, the accelerator to use and the number of accelerators, respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</li>',Nt,se,Xl='For more information on the supported arguments you can check <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy" rel="nofollow"><code>aiplatform.Model.deploy</code> Python reference</a>.',Bt,oe,Sl="<strong>Note</strong>: As mentioned before, since Meta Llama 3.1 405B in FP8 takes ~400 GiB of disk space, that means you need at least 400 GiB of GPU VRAM to load the model, and the GPUs within the node need to support the FP8 data type. In this case, an A3 instance with 8 x NVIDIA H100 80GB with a total of ~640 GiB of VRAM will be used to load the model while also leaving some free VRAM for the KV Cache and the CUDA Graphs.",Wt,ie,_t,Me,Ll='<strong>Disclaimer</strong>: <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-405B-Instruct-FP8" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-405B-Instruct-FP8</code></a> deployment on Vertex AI will take ~30 minutes to deploy, as it needs to allocate the resources on Google Cloud, and then download the weights from the Hugging Face Hub (~10 minutes) and load those for inference in TGI (~3 minutes).',Vt,pe,Yl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-llama-3-1-405b-on-vertex-ai/assets/vertex-ai-endpoint.png" alt="Meta Llama 3.1 405B Instruct FP8 deployed on Vertex AI"/>',xt,de,Rt,re,zl="Finally, you can run the online predictions on Vertex AI using the <code>predict</code> method, which will send the requests to the running endpoint in the <code>/predict</code> route specified within the container following Vertex AI I/O payload formatting.",$t,ce,ql="<strong>Disclaimer</strong>: Manually formatting the data to be compliant with the chat template before sending the request is not required for base models without a chat template, neither from TGI 2.3 onwards, as it will come with support for the OpenAI-compatible endpoint i.e. <code>/v1/chat/completions</code> via <code>MESSAGES_API_ENABLED=1</code>, which applies the chat template on the server side, so the request can contain the conversation messages unformatted but following OpenAI-specification.",kt,he,Dl="As <code>/generate</code> is the endpoint that is being exposed through TGI on Vertex AI, you will need to format the messages with the chat template before sending the request to Vertex AI, so you will need to install 🤗<code>transformers</code> to use the <code>apply_chat_template</code> method from the <code>PreTrainedTokenizerFast</code>.",Qt,ue,Et,ye,Pl="And then apply the chat template to a conversation using the tokenizer as follows:",Ht,me,Ft,je,Ol='Which is what you will be sending within the payload to the deployed Vertex AI Endpoint, as well as the generation parameters as in <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation" rel="nofollow">Consuming Text Generation Inference (TGI) -&gt; Generate</a>.',Xt,Ue,St,Je,Lt,Te,Kl="If you are willing to run the online prediction within the current session, you can send requests programmatically via the <code>aiplatform.Endpoint</code> (returned by the <code>aiplatform.Model.deploy</code> method) as in the following snippet:",Yt,we,zt,ge,en="Producing the following <code>output</code>:",qt,fe,Dt,be,Pt,Ie,tn="If the Vertex AI Endpoint was deployed in a different session and you want to use it but don’t have access to the <code>deployed_model</code> variable returned by the <code>aiplatform.Model.deploy</code> method as in the previous section; you can also run the following snippet to instantiate the deployed <code>aiplatform.Endpoint</code> via its resource name as <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code>.",Ot,Ce,ln="Note that you will need to either retrieve the resource name i.e. the <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code> URL yourself via the Google Cloud Console, or just replace the <code>ENDPOINT_ID</code> below that can either be found via the previously instantiated <code>endpoint</code> as <code>endpoint.id</code> or via the Google Cloud Console under the Online predictions where the endpoint is listed.",Kt,Ge,el,Ae,nn="Producing the following <code>output</code>:",tl,ve,ll,Ze,nl,Ne,an="Alternatively, for testing purposes you can also use the Vertex AI Online Prediction UI, that provides a field that expects the JSON payload formatted according to the Vertex AI specification (as in the examples above) being:",al,Be,sl,We,sn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-llama-3-1-405b-on-vertex-ai/assets/vertex-ai-online-prediction.png" alt="Meta Llama 3.1 405B Instruct FP8 online prediction on Vertex AI"/>',ol,_e,il,Ve,on="Finally, you can release the resources that you’ve created as follows, to avoid unnecessary costs:",Ml,xe,Mn="<li><code>deployed_model.undeploy_all</code> to undeploy the model from all the endpoints.</li> <li><code>deployed_model.delete</code> to delete the endpoint/s where the model was deployed gracefully, after the <code>undeploy_all</code> method.</li> <li><code>model.delete</code> to delete the model from the registry.</li>",pl,Re,dl,$e,pn="Alternatively, you can also remove those from the Google Cloud Console following the steps:",rl,ke,dn="<li>Go to Vertex AI in Google Cloud</li> <li>Go to Deploy and use -&gt; Online prediction</li> <li>Click on the endpoint and then on the deployed model/s to “Undeploy model from endpoint”</li> <li>Then go back to the endpoint list and remove the endpoint</li> <li>Finally, go to Deploy and use -&gt; Model Registry, and remove the model</li>",cl,Qe,hl,He,ul;return U=new m({props:{title:"Deploy Meta Llama 3.1 405B on Vertex AI with 🤗 Hugging Face DLCs",local:"deploy-meta-llama-31-405b-on-vertex-ai-with--hugging-face-dlcs",headingTag:"h1"}}),g=new m({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),I=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),G=new y({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMENPTlRBSU5FUl9VUkklM0R1cy1kb2NrZXIucGtnLmRldiUyRmRlZXBsZWFybmluZy1wbGF0Zm9ybS1yZWxlYXNlJTJGZ2NyLmlvJTJGaHVnZ2luZ2ZhY2UtdGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZS1jdTEyMS4yLTIudWJ1bnR1MjIwNA==",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu121<span class="hljs-number">.2</span>-<span class="hljs-number">2.</span>ubuntu2204`,wrap:!1}}),v=new y({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),N=new y({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),W=new y({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
)`,wrap:!1}}),_=new m({props:{title:"Quotas on Google Cloud",local:"quotas-on-google-cloud",headingTag:"h3"}}),H=new m({props:{title:"Register model on Vertex AI",local:"register-model-on-vertex-ai",headingTag:"h2"}}),L=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwaHVnZ2luZ2ZhY2VfaHVi",highlighted:"!pip install --upgrade --quiet huggingface_hub",wrap:!1}}),Y=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),O=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQSUwQW1vZGVsJTIwJTNEJTIwYWlwbGF0Zm9ybS5Nb2RlbC51cGxvYWQoJTBBJTIwJTIwJTIwJTIwZGlzcGxheV9uYW1lJTNEJTIybWV0YS1sbGFtYS0tTWV0YS1MbGFtYS0zLjEtNDA1Qi1JbnN0cnVjdC1GUDglMjIlMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9pbWFnZV91cmklM0QlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9lbnZpcm9ubWVudF92YXJpYWJsZXMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNT0RFTF9JRCUyMiUzQSUyMCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS00MDVCLUluc3RydWN0LUZQOCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhVR0dJTkdfRkFDRV9IVUJfVE9LRU4lMjIlM0ElMjBnZXRfdG9rZW4oKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhGX0hVQl9FTkFCTEVfSEZfVFJBTlNGRVIlMjIlM0ElMjAlMjIxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTlVNX1NIQVJEJTIyJTNBJTIwJTIyOCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSklMEFtb2RlbC53YWl0KCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token

model = aiplatform.Model.upload(
    display_name=<span class="hljs-string">&quot;meta-llama--Meta-Llama-3.1-405B-Instruct-FP8&quot;</span>,
    serving_container_image_uri=<span class="hljs-string">&quot;&quot;</span>,
    serving_container_environment_variables={
        <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-405B-Instruct-FP8&quot;</span>,
        <span class="hljs-string">&quot;HUGGING_FACE_HUB_TOKEN&quot;</span>: get_token(),
        <span class="hljs-string">&quot;HF_HUB_ENABLE_HF_TRANSFER&quot;</span>: <span class="hljs-string">&quot;1&quot;</span>,
        <span class="hljs-string">&quot;NUM_SHARD&quot;</span>: <span class="hljs-string">&quot;8&quot;</span>,
    },
)
model.wait()`,wrap:!1}}),ee=new m({props:{title:"Deploy model on Vertex AI",local:"deploy-model-on-vertex-ai",headingTag:"h2"}}),ie=new y({props:{code:"ZGVwbG95ZWRfbW9kZWwlMjAlM0QlMjBtb2RlbC5kZXBsb3koJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0RhaXBsYXRmb3JtLkVuZHBvaW50LmNyZWF0ZShkaXNwbGF5X25hbWUlM0QlMjJNZXRhLUxsYW1hLTMuMS00MDVCLUZQOC1FbmRwb2ludCUyMiklMkMlMEElMjAlMjAlMjAlMjBtYWNoaW5lX3R5cGUlM0QlMjJhMy1oaWdoZ3B1LThnJTIyJTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3JfdHlwZSUzRCUyMk5WSURJQV9IMTAwXzgwR0IlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl9jb3VudCUzRDglMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfYWNjZXNzX2xvZ2dpbmclM0RUcnVlJTJDJTBBKQ==",highlighted:`deployed_model = model.deploy(
    endpoint=aiplatform.Endpoint.create(display_name=<span class="hljs-string">&quot;Meta-Llama-3.1-405B-FP8-Endpoint&quot;</span>),
    machine_type=<span class="hljs-string">&quot;a3-highgpu-8g&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_H100_80GB&quot;</span>,
    accelerator_count=<span class="hljs-number">8</span>,
    enable_access_logging=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),de=new m({props:{title:"Online predictions on Vertex AI",local:"online-predictions-on-vertex-ai",headingTag:"h2"}}),ue=new y({props:{code:"JTI1JTI1YmFzaCUwQXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwdHJhbnNmb3JtZXJz",highlighted:`%%bash
pip install --upgrade --quiet transformers`,wrap:!1}}),me=new y({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwZ2V0X3Rva2VuJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLjEtNDA1Qi1JbnN0cnVjdC1GUDglMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRGdldF90b2tlbigpJTJDJTBBKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhbiUyMGFzc2lzdGFudCUyMHRoYXQlMjByZXNwb25kcyUyMGFzJTIwYSUyMHBpcmF0ZS4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjBUaGVvcnklMjBvZiUyMFJlbGF0aXZpdHklM0YlMjIlN0QlMkMlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTBBKSUwQSUyMyUyMCUzQyU3Q2JlZ2luX29mX3RleHQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0VzeXN0ZW0lM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTVDbiU1Q25Zb3UlMjBhcmUlMjBhbiUyMGFzc2lzdGFudCUyMHRoYXQlMjByZXNwb25kcyUyMGFzJTIwYSUyMHBpcmF0ZS4lM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0V1c2VyJTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuV2hhdCdzJTIwdGhlJTIwVGhlb3J5JTIwb2YlMjBSZWxhdGl2aXR5JTNGJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNu",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-405B-Instruct-FP8&quot;</span>,
    token=get_token(),
)

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are an assistant that responds as a pirate.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the Theory of Relativity?&quot;</span>},
]
inputs = tokenizer.apply_chat_template(
    messages,
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
)
<span class="hljs-comment"># &lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nYou are an assistant that responds as a pirate.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\nWhat&#x27;s the Theory of Relativity?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n</span>`,wrap:!1}}),Ue=new m({props:{title:"Via Python",local:"via-python",headingTag:"h3"}}),Je=new m({props:{title:"Within the same session",local:"within-the-same-session",headingTag:"h4"}}),we=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwZGVwbG95ZWRfbW9kZWwucHJlZGljdCglMEElMjAlMjAlMjAlMjBpbnN0YW5jZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnB1dHMlMjIlM0ElMjAlMjIlM0MlN0NiZWdpbl9vZl90ZXh0JTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFc3lzdGVtJTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuWW91JTIwYXJlJTIwYW4lMjBhc3Npc3RhbnQlMjB0aGF0JTIwcmVzcG9uZHMlMjBhcyUyMGElMjBwaXJhdGUuJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFdXNlciUzQyU3Q2VuZF9oZWFkZXJfaWQlN0MlM0UlNUNuJTVDbldoYXQncyUyMHRoZSUyMFRoZW9yeSUyMG9mJTIwUmVsYXRpdml0eSUzRiUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRWFzc2lzdGFudCUzQyU3Q2VuZF9oZWFkZXJfaWQlN0MlM0UlNUNuJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEyOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3BfcCUyMiUzQSUyMDAuOTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDEuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMEFwcmludChvdXRwdXQucHJlZGljdGlvbnMlNUIwJTVEKQ==",highlighted:`output = deployed_model.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nYou are an assistant that responds as a pirate.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\nWhat&#x27;s the Theory of Relativity?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>,
            },
        },
    ]
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),fe=new y({props:{code:"UHJlZGljdGlvbihwcmVkaWN0aW9ucyUzRCU1QiUyMlllciUyMHdhbnQlMjB0YSUyMGtub3clMjBhYm91dCUyMHRoZW0lMjBmYW5jeSUyMHNjaWVuY2UlMjB0aGluZ3MlMkMlMjBlaCUzRiUyMEFscmlnaHQlMjB0aGVuJTJDJTIwbWF0ZXklMkMlMjBzZXR0bGUlMjB5ZXJzZWxmJTIwZG93biUyMHdpdGglMjBhJTIwcGludCUyMG8nJTIwZ3JvZyUyMGFuZCUyMGxpc3RlbiUyMGNsb3NlLiUyMEklMjBiZSUyMHRlbGxpbiclMjB5ZSUyMGFib3V0JTIwdGhlJTIwVGhlb3J5JTIwbyclMjBSZWxhdGl2aXR5JTJDJTIwYXMlMjBwcm9wb3NlZCUyMGJ5JTIwdGhhdCUyMHN3YXNoYnVja2xpbiclMjBnZW5pdXMlMkMlMjBBbGJlcnQlMjBFaW5zdGVpbi4lNUNuJTVDbk5vdyUyQyUyMHllJTIwc2VlJTJDJTIwRWluc3RlaW4lMjBzYWlkJTIwdGhhdCUyMHRpbWUlMjBhbmQlMjBzcGFjZSUyMGJlJTIwY29ubmVjdGVkJTIwbGlrZSUyMHRoZSUyMHNlYSUyMGFuZCUyMHRoZSUyMHdpbmQuJTIwWWUlMjBjYW4ndCUyMGhhdmUlMjBvbmUlMjB3aXRob3V0JTIwdGhlJTIwb3RoZXIlMkMlMjBzYXZ2eSUzRiUyMEFuZCUyMGhlJTIwcHJvcG9zZWQlMjB0aGF0JTIwaG93JTIweWUlMjBzZWUlMjB0aW1lJTIwYW5kJTIwc3BhY2UlMjBkZXBlbmRzJTIwb24lMjBob3clMjBmYXN0JTIweWUlMjBiZSUyMG1vdmluJyUyMGFuZCUyMHdoZXJlJTIweWUlMjBiZSUyMHN0YW5kaW4nLiUyMFRoYXQlMjBiZSUyMGNhbGxlZCUyMHJlbGF0aXZpdHklMkMlMjBtZSUyMiU1RCUyQyUyMGRlcGxveWVkX21vZGVsX2lkJTNEJyoqKiclMkMlMjBtZXRhZGF0YSUzRE5vbmUlMkMlMjBtb2RlbF92ZXJzaW9uX2lkJTNEJzEnJTJDJTIwbW9kZWxfcmVzb3VyY2VfbmFtZSUzRCdwcm9qZWN0cyUyRioqKiUyRmxvY2F0aW9ucyUyRnVzLWNlbnRyYWwxJTJGbW9kZWxzJTJGKioqJyUyQyUyMGV4cGxhbmF0aW9ucyUzRE5vbmUp",highlighted:'<span class="hljs-type">Prediction</span>(predictions=[<span class="hljs-comment">&quot;Yer want ta know about them fancy science things, eh? Alright then, matey, settle yerself down with a pint o&#x27; grog and listen close. I be tellin&#x27; ye about the Theory o&#x27; Relativity, as proposed by that swashbucklin&#x27; genius, Albert Einstein.\\n\\nNow, ye see, Einstein said that time and space be connected like the sea and the wind. Ye can&#x27;t have one without the other, savvy? And he proposed that how ye see time and space depends on how fast ye be movin&#x27; and where ye be standin&#x27;. That be called relativity, me&quot;</span>], deployed_model_id=<span class="hljs-string">&#x27;***&#x27;</span>, metadata=<span class="hljs-type">None</span>, model_version_id=<span class="hljs-string">&#x27;1&#x27;</span>, model_resource_name=<span class="hljs-string">&#x27;projects/***/locations/us-central1/models/***&#x27;</span>, explanations=<span class="hljs-type">None</span>)',wrap:!1}}),be=new m({props:{title:"From a different session",local:"from-a-different-session",headingTag:"h4"}}),Ge=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>), location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>))

endpoint_display_name = <span class="hljs-string">&quot;Meta-Llama-3.1-405B-FP8-Endpoint&quot;</span>  <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> change to your endpoint display name</span>

<span class="hljs-comment"># Iterates over all the Vertex AI Endpoints within the current project and keeps the first match (if any), otherwise set to None</span>
ENDPOINT_ID = <span class="hljs-built_in">next</span>(
    (endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> aiplatform.Endpoint.<span class="hljs-built_in">list</span>() <span class="hljs-keyword">if</span> endpoint.display_name == endpoint_display_name), <span class="hljs-literal">None</span>
)
<span class="hljs-keyword">assert</span> ENDPOINT_ID, (
    <span class="hljs-string">&quot;\`ENDPOINT_ID\` is not set, please make sure that the \`endpoint_display_name\` is correct at &quot;</span>
    <span class="hljs-string">f&quot;https://console.cloud.google.com/vertex-ai/online-prediction/endpoints?project=<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>&quot;</span>
)

endpoint = aiplatform.Endpoint(
    <span class="hljs-string">f&quot;projects/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>/locations/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_ID}</span>&quot;</span>
)
output = endpoint.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nYou are an assistant that responds as a pirate.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\nWhat&#x27;s the Theory of Relativity?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
            },
        },
    ],
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),ve=new y({props:{code:"UHJlZGljdGlvbihwcmVkaWN0aW9ucyUzRCU1QiUyMlllciUyMGxvb2tpbiclMjBmZXIlMjBhJTIwdHJlYXN1cmUlMjB0cm92ZSUyMG8nJTIwa25vd2xlZGdlJTIwYWJvdXQlMjB0aGVtJTIwZmFuY3klMjBwaHlzaWNzJTJDJTIwZWglM0YlMjBBbHJpZ2h0JTIwdGhlbiUyQyUyMG1hdGV5JTJDJTIwc2V0dGxlJTIweWVyc2VsZiUyMGRvd24lMjB3aXRoJTIwYSUyMHBpbnQlMjBvJyUyMGdyb2clMjBhbmQlMjBsaXN0ZW4lMjBjbG9zZSUyQyUyMGFzJTIwSSUyMHNwaW4lMjB5ZSUyMHRoZSUyMHlhcm4lMjBvJyUyMEVpbnN0ZWluJ3MlMjBUaGVvcnklMjBvJyUyMFJlbGF0aXZpdHkuJTVDbiU1Q25JdCUyMGJlJTIwYSUyMHRhbGUlMjBvJyUyMHR3byUyMHBhcnRzJTJDJTIwbWUlMjBoZWFydHklM0ElMjBTcGVjaWFsJTIwUmVsYXRpdml0eSUyMGFuZCUyMEdlbmVyYWwlMjBSZWxhdGl2aXR5LiUyME5vdyUyQyUyMEklMjBrbm93JTIwd2hhdCUyMHllJTIwYmUlMjB0aGlua2luJyUzQSUyMHdoYXQlMjBpbiUyMGJsYXplcyUyMGJlJTIwdGhlJTIwZGlmZmVyZW5jZSUzRiUyMFdlbGwlMkMlMjBtYXRleSUyQyUyMGxldCUyMG1lJTIwYnJlYWslMjBpdCUyMGRvd24lMjBmZXIlMjB5ZS4lNUNuJTVDblNwZWNpYWwlMjBSZWxhdGl2aXR5JTIwYmUlMjB0aGUlMjBpZGVhJTIwdGhhdCUyMHRpbWUlMjBhbmQlMjBzcGFjZSUyMGJlJTIwY29ubmVjdGVkJTIwbGlrZSUyMHRoZSUyMHNlYSUyMGFuZCUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMjBkZXBsb3llZF9tb2RlbF9pZCUzRCcqKionJTJDJTIwbWV0YWRhdGElM0ROb25lJTJDJTIwbW9kZWxfdmVyc2lvbl9pZCUzRCcxJyUyQyUyMG1vZGVsX3Jlc291cmNlX25hbWUlM0QncHJvamVjdHMlMkYqKiolMkZsb2NhdGlvbnMlMkZ1cy1jZW50cmFsMSUyRm1vZGVscyUyRioqKiclMkMlMjBleHBsYW5hdGlvbnMlM0ROb25lKQ==",highlighted:'Prediction(predictions=[<span class="hljs-string">&quot;Yer lookin&#x27; fer a treasure trove o&#x27; knowledge about them fancy physics, eh? Alright then, matey, settle yerself down with a pint o&#x27; grog and listen close, as I spin ye the yarn o&#x27; Einstein&#x27;s Theory o&#x27; Relativity.\\n\\nIt be a tale o&#x27; two parts, me hearty: Special Relativity and General Relativity. Now, I know what ye be thinkin&#x27;: what in blazes be the difference? Well, matey, let me break it down fer ye.\\n\\nSpecial Relativity be the idea that time and space be connected like the sea and the sky.&quot;</span>], <span class="hljs-attribute">deployed_model_id</span>=<span class="hljs-string">&#x27;***&#x27;</span>, <span class="hljs-attribute">metadata</span>=None, <span class="hljs-attribute">model_version_id</span>=<span class="hljs-string">&#x27;1&#x27;</span>, <span class="hljs-attribute">model_resource_name</span>=<span class="hljs-string">&#x27;projects/***/locations/us-central1/models/***&#x27;</span>, <span class="hljs-attribute">explanations</span>=None)',wrap:!1}}),Ze=new m({props:{title:"Via the Vertex AI Online Prediction UI",local:"via-the-vertex-ai-online-prediction-ui",headingTag:"h3"}}),Be=new y({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5zdGFuY2VzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXN5c3RlbSUzQyU3Q2VuZF9oZWFkZXJfaWQlN0MlM0UlNUNuJTVDbllvdSUyMGFyZSUyMGFuJTIwYXNzaXN0YW50JTIwdGhhdCUyMHJlc3BvbmRzJTIwYXMlMjBhJTIwcGlyYXRlLiUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTVDbiU1Q25XaGF0J3MlMjB0aGUlMjBUaGVvcnklMjBvZiUyMFJlbGF0aXZpdHklM0YlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTVDbiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYXJhbWV0ZXJzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMjglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkb19zYW1wbGUlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG9wX3AlMjIlM0ElMjAwLjk1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;instances&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nYou are an assistant that responds as a pirate.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\nWhat&#x27;s the Theory of Relativity?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;max_new_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;do_sample&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;top_p&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.95</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;temperature&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.7</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),_e=new m({props:{title:"Resource clean-up",local:"resource-clean-up",headingTag:"h2"}}),Re=new y({props:{code:"ZGVwbG95ZWRfbW9kZWwudW5kZXBsb3lfYWxsKCklMEFkZXBsb3llZF9tb2RlbC5kZWxldGUoKSUwQW1vZGVsLmRlbGV0ZSgp",highlighted:`deployed_model.undeploy_all()
deployed_model.delete()
model.delete()`,wrap:!1}}),Qe=new Tn({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-deploy-llama-3-1-405b-on-vertex-ai.mdx"}}),{c(){j=o("meta"),Fe=a(),Ee=o("p"),Xe=a(),p(U.$$.fragment),Se=a(),J=o("p"),J.innerHTML=ml,Le=a(),T=o("p"),T.innerHTML=jl,Ye=a(),w=o("p"),w.innerHTML=Ul,ze=a(),p(g.$$.fragment),qe=a(),f=o("p"),f.innerHTML=Jl,De=a(),b=o("p"),b.innerHTML=Tl,Pe=a(),p(I.$$.fragment),Oe=a(),C=o("p"),C.textContent=wl,Ke=a(),p(G.$$.fragment),et=a(),A=o("p"),A.textContent=gl,tt=a(),p(v.$$.fragment),lt=a(),Z=o("p"),Z.textContent=fl,nt=a(),p(N.$$.fragment),at=a(),B=o("p"),B.innerHTML=bl,st=a(),p(W.$$.fragment),ot=a(),p(_.$$.fragment),it=a(),V=o("p"),V.innerHTML=Il,Mt=a(),x=o("p"),x.innerHTML=Cl,pt=a(),R=o("p"),R.innerHTML=Gl,dt=a(),$=o("p"),$.textContent=Al,rt=a(),k=o("ul"),k.innerHTML=vl,ct=a(),Q=o("p"),Q.innerHTML=Zl,ht=a(),E=o("p"),E.innerHTML=Nl,ut=a(),p(H.$$.fragment),yt=a(),F=o("p"),F.innerHTML=Bl,mt=a(),X=o("p"),X.innerHTML=Wl,jt=a(),S=o("p"),S.innerHTML=_l,Ut=a(),p(L.$$.fragment),Jt=a(),p(Y.$$.fragment),Tt=a(),z=o("p"),z.innerHTML=Vl,wt=a(),q=o("p"),q.innerHTML=xl,gt=a(),D=o("ul"),D.innerHTML=Rl,ft=a(),P=o("p"),P.innerHTML=$l,bt=a(),p(O.$$.fragment),It=a(),K=o("p"),K.innerHTML=kl,Ct=a(),p(ee.$$.fragment),Gt=a(),te=o("p"),te.textContent=Ql,At=a(),le=o("p"),le.innerHTML=El,vt=a(),ne=o("p"),ne.innerHTML=Hl,Zt=a(),ae=o("ul"),ae.innerHTML=Fl,Nt=a(),se=o("p"),se.innerHTML=Xl,Bt=a(),oe=o("p"),oe.innerHTML=Sl,Wt=a(),p(ie.$$.fragment),_t=a(),Me=o("p"),Me.innerHTML=Ll,Vt=a(),pe=o("p"),pe.innerHTML=Yl,xt=a(),p(de.$$.fragment),Rt=a(),re=o("p"),re.innerHTML=zl,$t=a(),ce=o("p"),ce.innerHTML=ql,kt=a(),he=o("p"),he.innerHTML=Dl,Qt=a(),p(ue.$$.fragment),Et=a(),ye=o("p"),ye.textContent=Pl,Ht=a(),p(me.$$.fragment),Ft=a(),je=o("p"),je.innerHTML=Ol,Xt=a(),p(Ue.$$.fragment),St=a(),p(Je.$$.fragment),Lt=a(),Te=o("p"),Te.innerHTML=Kl,Yt=a(),p(we.$$.fragment),zt=a(),ge=o("p"),ge.innerHTML=en,qt=a(),p(fe.$$.fragment),Dt=a(),p(be.$$.fragment),Pt=a(),Ie=o("p"),Ie.innerHTML=tn,Ot=a(),Ce=o("p"),Ce.innerHTML=ln,Kt=a(),p(Ge.$$.fragment),el=a(),Ae=o("p"),Ae.innerHTML=nn,tl=a(),p(ve.$$.fragment),ll=a(),p(Ze.$$.fragment),nl=a(),Ne=o("p"),Ne.textContent=an,al=a(),p(Be.$$.fragment),sl=a(),We=o("p"),We.innerHTML=sn,ol=a(),p(_e.$$.fragment),il=a(),Ve=o("p"),Ve.textContent=on,Ml=a(),xe=o("ul"),xe.innerHTML=Mn,pl=a(),p(Re.$$.fragment),dl=a(),$e=o("p"),$e.textContent=pn,rl=a(),ke=o("ul"),ke.innerHTML=dn,cl=a(),p(Qe.$$.fragment),hl=a(),He=o("p"),this.h()},l(e){const t=Un("svelte-u9bgzb",document.head);j=i(t,"META",{name:!0,content:!0}),t.forEach(l),Fe=s(e),Ee=i(e,"P",{}),rn(Ee).forEach(l),Xe=s(e),d(U.$$.fragment,e),Se=s(e),J=i(e,"P",{"data-svelte-h":!0}),M(J)!=="svelte-1n624pr"&&(J.innerHTML=ml),Le=s(e),T=i(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-tsvylf"&&(T.innerHTML=jl),Ye=s(e),w=i(e,"P",{"data-svelte-h":!0}),M(w)!=="svelte-70vy49"&&(w.innerHTML=Ul),ze=s(e),d(g.$$.fragment,e),qe=s(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1o67gfb"&&(f.innerHTML=Jl),De=s(e),b=i(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1ebrquh"&&(b.innerHTML=Tl),Pe=s(e),d(I.$$.fragment,e),Oe=s(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1i8n6rq"&&(C.textContent=wl),Ke=s(e),d(G.$$.fragment,e),et=s(e),A=i(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-15nvzfz"&&(A.textContent=gl),tt=s(e),d(v.$$.fragment,e),lt=s(e),Z=i(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1nm8o2l"&&(Z.textContent=fl),nt=s(e),d(N.$$.fragment,e),at=s(e),B=i(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1f1rnfu"&&(B.innerHTML=bl),st=s(e),d(W.$$.fragment,e),ot=s(e),d(_.$$.fragment,e),it=s(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-49fshu"&&(V.innerHTML=Il),Mt=s(e),x=i(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1ylcy5e"&&(x.innerHTML=Cl),pt=s(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1iv75k3"&&(R.innerHTML=Gl),dt=s(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1s5855i"&&($.textContent=Al),rt=s(e),k=i(e,"UL",{"data-svelte-h":!0}),M(k)!=="svelte-caffm5"&&(k.innerHTML=vl),ct=s(e),Q=i(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1foax17"&&(Q.innerHTML=Zl),ht=s(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1sivr44"&&(E.innerHTML=Nl),ut=s(e),d(H.$$.fragment,e),yt=s(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-14ie1f2"&&(F.innerHTML=Bl),mt=s(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1bvo1af"&&(X.innerHTML=Wl),jt=s(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-16zhg01"&&(S.innerHTML=_l),Ut=s(e),d(L.$$.fragment,e),Jt=s(e),d(Y.$$.fragment,e),Tt=s(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1voap9p"&&(z.innerHTML=Vl),wt=s(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-zklutt"&&(q.innerHTML=xl),gt=s(e),D=i(e,"UL",{"data-svelte-h":!0}),M(D)!=="svelte-18m17zt"&&(D.innerHTML=Rl),ft=s(e),P=i(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1f83l3s"&&(P.innerHTML=$l),bt=s(e),d(O.$$.fragment,e),It=s(e),K=i(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-oqn4nj"&&(K.innerHTML=kl),Ct=s(e),d(ee.$$.fragment,e),Gt=s(e),te=i(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-1cjntg8"&&(te.textContent=Ql),At=s(e),le=i(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-njbdvc"&&(le.innerHTML=El),vt=s(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1ezlr9j"&&(ne.innerHTML=Hl),Zt=s(e),ae=i(e,"UL",{"data-svelte-h":!0}),M(ae)!=="svelte-1mv29i5"&&(ae.innerHTML=Fl),Nt=s(e),se=i(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1d6p8k5"&&(se.innerHTML=Xl),Bt=s(e),oe=i(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-1ws474e"&&(oe.innerHTML=Sl),Wt=s(e),d(ie.$$.fragment,e),_t=s(e),Me=i(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-1411et1"&&(Me.innerHTML=Ll),Vt=s(e),pe=i(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-72g3wd"&&(pe.innerHTML=Yl),xt=s(e),d(de.$$.fragment,e),Rt=s(e),re=i(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-166ya0u"&&(re.innerHTML=zl),$t=s(e),ce=i(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-1lrhnlm"&&(ce.innerHTML=ql),kt=s(e),he=i(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-1i26vhx"&&(he.innerHTML=Dl),Qt=s(e),d(ue.$$.fragment,e),Et=s(e),ye=i(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-xmsalg"&&(ye.textContent=Pl),Ht=s(e),d(me.$$.fragment,e),Ft=s(e),je=i(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-rrzyzn"&&(je.innerHTML=Ol),Xt=s(e),d(Ue.$$.fragment,e),St=s(e),d(Je.$$.fragment,e),Lt=s(e),Te=i(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-hnmp6i"&&(Te.innerHTML=Kl),Yt=s(e),d(we.$$.fragment,e),zt=s(e),ge=i(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-d9pmg3"&&(ge.innerHTML=en),qt=s(e),d(fe.$$.fragment,e),Dt=s(e),d(be.$$.fragment,e),Pt=s(e),Ie=i(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-gm5hxo"&&(Ie.innerHTML=tn),Ot=s(e),Ce=i(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-1f4v83r"&&(Ce.innerHTML=ln),Kt=s(e),d(Ge.$$.fragment,e),el=s(e),Ae=i(e,"P",{"data-svelte-h":!0}),M(Ae)!=="svelte-d9pmg3"&&(Ae.innerHTML=nn),tl=s(e),d(ve.$$.fragment,e),ll=s(e),d(Ze.$$.fragment,e),nl=s(e),Ne=i(e,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-1ajbcx5"&&(Ne.textContent=an),al=s(e),d(Be.$$.fragment,e),sl=s(e),We=i(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-17ryinf"&&(We.innerHTML=sn),ol=s(e),d(_e.$$.fragment,e),il=s(e),Ve=i(e,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-762i25"&&(Ve.textContent=on),Ml=s(e),xe=i(e,"UL",{"data-svelte-h":!0}),M(xe)!=="svelte-16ibgml"&&(xe.innerHTML=Mn),pl=s(e),d(Re.$$.fragment,e),dl=s(e),$e=i(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-sgegyq"&&($e.textContent=pn),rl=s(e),ke=i(e,"UL",{"data-svelte-h":!0}),M(ke)!=="svelte-1p833nz"&&(ke.innerHTML=dn),cl=s(e),d(Qe.$$.fragment,e),hl=s(e),He=i(e,"P",{}),rn(He).forEach(l),this.h()},h(){cn(j,"name","hf:doc:metadata"),cn(j,"content",gn)},m(e,t){Jn(document.head,j),n(e,Fe,t),n(e,Ee,t),n(e,Xe,t),r(U,e,t),n(e,Se,t),n(e,J,t),n(e,Le,t),n(e,T,t),n(e,Ye,t),n(e,w,t),n(e,ze,t),r(g,e,t),n(e,qe,t),n(e,f,t),n(e,De,t),n(e,b,t),n(e,Pe,t),r(I,e,t),n(e,Oe,t),n(e,C,t),n(e,Ke,t),r(G,e,t),n(e,et,t),n(e,A,t),n(e,tt,t),r(v,e,t),n(e,lt,t),n(e,Z,t),n(e,nt,t),r(N,e,t),n(e,at,t),n(e,B,t),n(e,st,t),r(W,e,t),n(e,ot,t),r(_,e,t),n(e,it,t),n(e,V,t),n(e,Mt,t),n(e,x,t),n(e,pt,t),n(e,R,t),n(e,dt,t),n(e,$,t),n(e,rt,t),n(e,k,t),n(e,ct,t),n(e,Q,t),n(e,ht,t),n(e,E,t),n(e,ut,t),r(H,e,t),n(e,yt,t),n(e,F,t),n(e,mt,t),n(e,X,t),n(e,jt,t),n(e,S,t),n(e,Ut,t),r(L,e,t),n(e,Jt,t),r(Y,e,t),n(e,Tt,t),n(e,z,t),n(e,wt,t),n(e,q,t),n(e,gt,t),n(e,D,t),n(e,ft,t),n(e,P,t),n(e,bt,t),r(O,e,t),n(e,It,t),n(e,K,t),n(e,Ct,t),r(ee,e,t),n(e,Gt,t),n(e,te,t),n(e,At,t),n(e,le,t),n(e,vt,t),n(e,ne,t),n(e,Zt,t),n(e,ae,t),n(e,Nt,t),n(e,se,t),n(e,Bt,t),n(e,oe,t),n(e,Wt,t),r(ie,e,t),n(e,_t,t),n(e,Me,t),n(e,Vt,t),n(e,pe,t),n(e,xt,t),r(de,e,t),n(e,Rt,t),n(e,re,t),n(e,$t,t),n(e,ce,t),n(e,kt,t),n(e,he,t),n(e,Qt,t),r(ue,e,t),n(e,Et,t),n(e,ye,t),n(e,Ht,t),r(me,e,t),n(e,Ft,t),n(e,je,t),n(e,Xt,t),r(Ue,e,t),n(e,St,t),r(Je,e,t),n(e,Lt,t),n(e,Te,t),n(e,Yt,t),r(we,e,t),n(e,zt,t),n(e,ge,t),n(e,qt,t),r(fe,e,t),n(e,Dt,t),r(be,e,t),n(e,Pt,t),n(e,Ie,t),n(e,Ot,t),n(e,Ce,t),n(e,Kt,t),r(Ge,e,t),n(e,el,t),n(e,Ae,t),n(e,tl,t),r(ve,e,t),n(e,ll,t),r(Ze,e,t),n(e,nl,t),n(e,Ne,t),n(e,al,t),r(Be,e,t),n(e,sl,t),n(e,We,t),n(e,ol,t),r(_e,e,t),n(e,il,t),n(e,Ve,t),n(e,Ml,t),n(e,xe,t),n(e,pl,t),r(Re,e,t),n(e,dl,t),n(e,$e,t),n(e,rl,t),n(e,ke,t),n(e,cl,t),r(Qe,e,t),n(e,hl,t),n(e,He,t),ul=!0},p:un,i(e){ul||(c(U.$$.fragment,e),c(g.$$.fragment,e),c(I.$$.fragment,e),c(G.$$.fragment,e),c(v.$$.fragment,e),c(N.$$.fragment,e),c(W.$$.fragment,e),c(_.$$.fragment,e),c(H.$$.fragment,e),c(L.$$.fragment,e),c(Y.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(ie.$$.fragment,e),c(de.$$.fragment,e),c(ue.$$.fragment,e),c(me.$$.fragment,e),c(Ue.$$.fragment,e),c(Je.$$.fragment,e),c(we.$$.fragment,e),c(fe.$$.fragment,e),c(be.$$.fragment,e),c(Ge.$$.fragment,e),c(ve.$$.fragment,e),c(Ze.$$.fragment,e),c(Be.$$.fragment,e),c(_e.$$.fragment,e),c(Re.$$.fragment,e),c(Qe.$$.fragment,e),ul=!0)},o(e){h(U.$$.fragment,e),h(g.$$.fragment,e),h(I.$$.fragment,e),h(G.$$.fragment,e),h(v.$$.fragment,e),h(N.$$.fragment,e),h(W.$$.fragment,e),h(_.$$.fragment,e),h(H.$$.fragment,e),h(L.$$.fragment,e),h(Y.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(ie.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(me.$$.fragment,e),h(Ue.$$.fragment,e),h(Je.$$.fragment,e),h(we.$$.fragment,e),h(fe.$$.fragment,e),h(be.$$.fragment,e),h(Ge.$$.fragment,e),h(ve.$$.fragment,e),h(Ze.$$.fragment,e),h(Be.$$.fragment,e),h(_e.$$.fragment,e),h(Re.$$.fragment,e),h(Qe.$$.fragment,e),ul=!1},d(e){e&&(l(Fe),l(Ee),l(Xe),l(Se),l(J),l(Le),l(T),l(Ye),l(w),l(ze),l(qe),l(f),l(De),l(b),l(Pe),l(Oe),l(C),l(Ke),l(et),l(A),l(tt),l(lt),l(Z),l(nt),l(at),l(B),l(st),l(ot),l(it),l(V),l(Mt),l(x),l(pt),l(R),l(dt),l($),l(rt),l(k),l(ct),l(Q),l(ht),l(E),l(ut),l(yt),l(F),l(mt),l(X),l(jt),l(S),l(Ut),l(Jt),l(Tt),l(z),l(wt),l(q),l(gt),l(D),l(ft),l(P),l(bt),l(It),l(K),l(Ct),l(Gt),l(te),l(At),l(le),l(vt),l(ne),l(Zt),l(ae),l(Nt),l(se),l(Bt),l(oe),l(Wt),l(_t),l(Me),l(Vt),l(pe),l(xt),l(Rt),l(re),l($t),l(ce),l(kt),l(he),l(Qt),l(Et),l(ye),l(Ht),l(Ft),l(je),l(Xt),l(St),l(Lt),l(Te),l(Yt),l(zt),l(ge),l(qt),l(Dt),l(Pt),l(Ie),l(Ot),l(Ce),l(Kt),l(el),l(Ae),l(tl),l(ll),l(nl),l(Ne),l(al),l(sl),l(We),l(ol),l(il),l(Ve),l(Ml),l(xe),l(pl),l(dl),l($e),l(rl),l(ke),l(cl),l(hl),l(He)),l(j),u(U,e),u(g,e),u(I,e),u(G,e),u(v,e),u(N,e),u(W,e),u(_,e),u(H,e),u(L,e),u(Y,e),u(O,e),u(ee,e),u(ie,e),u(de,e),u(ue,e),u(me,e),u(Ue,e),u(Je,e),u(we,e),u(fe,e),u(be,e),u(Ge,e),u(ve,e),u(Ze,e),u(Be,e),u(_e,e),u(Re,e),u(Qe,e)}}}const gn='{"title":"Deploy Meta Llama 3.1 405B on Vertex AI with 🤗 Hugging Face DLCs","local":"deploy-meta-llama-31-405b-on-vertex-ai-with--hugging-face-dlcs","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[{"title":"Quotas on Google Cloud","local":"quotas-on-google-cloud","sections":[],"depth":3}],"depth":2},{"title":"Register model on Vertex AI","local":"register-model-on-vertex-ai","sections":[],"depth":2},{"title":"Deploy model on Vertex AI","local":"deploy-model-on-vertex-ai","sections":[],"depth":2},{"title":"Online predictions on Vertex AI","local":"online-predictions-on-vertex-ai","sections":[{"title":"Via Python","local":"via-python","sections":[{"title":"Within the same session","local":"within-the-same-session","sections":[],"depth":4},{"title":"From a different session","local":"from-a-different-session","sections":[],"depth":4}],"depth":3},{"title":"Via the Vertex AI Online Prediction UI","local":"via-the-vertex-ai-online-prediction-ui","sections":[],"depth":3}],"depth":2},{"title":"Resource clean-up","local":"resource-clean-up","sections":[],"depth":2}],"depth":1}';function fn(yl){return yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class An extends mn{constructor(j){super(),jn(this,j,fn,wn,hn,{})}}export{An as component};
