import{s as Fl,n as Hl,o as Sl}from"../chunks/scheduler.b108d059.js";import{S as ql,i as Ll,g as o,s,r,A as Yl,h as i,f as l,c as a,j as El,u as c,x as p,k as Ql,y as zl,a as n,v as M,d,t as m,w as u}from"../chunks/index.008de539.js";import{C as y}from"../chunks/CodeBlock.3968c746.js";import{H as h,E as Dl}from"../chunks/EditOnGithub.d1c48e3d.js";function Pl(Kt){let T,Be,_e,We,J,$e,w,el="Gemma is a family of lightweight, state-of-the-art open models built from the same research and technology used to create the Gemini models, developed by Google DeepMind and other teams across Google. Text Generation Inference (TGI) is a toolkit developed by Hugging Face for deploying and serving LLMs, with high performance text generation. And, Google Vertex AI is a Machine Learning (ML) platform that lets you train and deploy ML models and AI applications, and customize large language models (LLMs) for use in your AI-powered applications.",ke,g,tl='This example showcases how to deploy any supported text-generation model, in this case <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a>, from the Hugging Face Hub on Vertex AI using the TGI DLC available in Google Cloud Platform (GCP).',Re,U,ll='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/model-in-hf-hub.png" alt="&#39;google/gemma-7b-it&#39; in the Hugging Face Hub"/>',Xe,j,Ee,b,nl='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',Qe,I,sl="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",Fe,f,He,C,al="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",Se,v,qe,Z,ol="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",Le,G,Ye,A,il="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",ze,x,De,V,Pe,_,pl="Once everything is set up, you can already initialize the Vertex AI session via the <code>google-cloud-aiplatform</code> Python SDK as follows:",Oe,N,Ke,B,rl='As <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> is a gated model, you need to login into your Hugging Face Hub account with a read-access token either fine-grained with access to the gated model, or just overall read-access to your account. More information on how to generate a read-only access token for the Hugging Face Hub in the instructions at <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">https://huggingface.co/docs/hub/en/security-tokens</a>.',et,W,tt,$,lt,k,cl="Then you can already “upload” the model i.e. register the model on Vertex AI. It is not an upload per se, since the model will be automatically downloaded from the Hugging Face Hub in the Hugging Face DLC for TGI on startup via the <code>MODEL_ID</code> environment variable, so what is uploaded is only the configuration, not the model weights.",nt,R,Ml="Before going into the code, let’s quickly review the arguments provided to the <code>upload</code> method:",st,X,dl='<li><p><strong><code>display_name</code></strong> is the name that will be shown in the Vertex AI Model Registry.</p></li> <li><p><strong><code>serving_container_image_uri</code></strong> is the location of the Hugging Face DLC for TGI that will be used for serving the model.</p></li> <li><p><strong><code>serving_container_environment_variables</code></strong> are the environment variables that will be used during the container runtime, so these are aligned with the environment variables defined by <code>text-generation-inference</code>, which are analog to the <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher" rel="nofollow"><code>text-generation-launcher</code> arguments</a>. Additionally, the Hugging Face DLCs for TGI also capture the <code>AIP_</code> environment variables from Vertex AI as in <a href="https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements" rel="nofollow">Vertex AI Documentation - Custom container requirements for prediction</a>.</p> <ul><li><code>MODEL_ID</code> is the identifier of the model in the Hugging Face Hub. To explore all the supported models you can check <a href="https://huggingface.co/models?sort=trending&amp;other=text-generation-inference" rel="nofollow">https://huggingface.co/models?sort=trending&amp;other=text-generation-inference</a>.</li> <li><code>NUM_SHARD</code> is the number of shards to use if you don’t want to use all GPUs on a given machine e.g. if you have two GPUs but you just want to use one for TGI then <code>NUM_SHARD=1</code>, otherwise it matches the <code>CUDA_VISIBLE_DEVICES</code>.</li> <li><code>MAX_INPUT_TOKENS</code> is the maximum allowed input length (expressed in number of tokens), the larger it is, the larger the prompt can be, but also more memory will be consumed.</li> <li><code>MAX_TOTAL_TOKENS</code> is the most important value to set as it defines the “memory budget” of running clients requests, the larger this value, the larger amount each request will be in your RAM and the less effective batching can be.</li> <li><code>MAX_BATCH_PREFILL_TOKENS</code> limits the number of tokens for the prefill operation, as it takes the most memory and is compute bound, it is interesting to limit the number of requests that can be sent.</li> <li><code>HUGGING_FACE_HUB_TOKEN</code> is the Hugging Face Hub token, required as <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> is a gated model.</li></ul></li> <li><p>(optional) <strong><code>serving_container_ports</code></strong> is the port where the Vertex AI endpoint will be exposed, by default 8080.</p></li>',at,E,ml='For more information on the supported <code>aiplatform.Model.upload</code> arguments, check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload</a>.',ot,Q,it,F,ul='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/vertex-ai-model.png" alt="Model on Vertex AI Model Registry"/>',pt,H,rt,S,yl="After the model is registered on Vertex AI, you need to define the endpoint that you want to deploy the model to, and then link the model deployment to that endpoint resource.",ct,q,hl="To do so, you need to call the method <code>aiplatform.Endpoint.create</code> to create a new Vertex AI endpoint resource (which is not linked to a model or anything usable yet).",Mt,L,dt,Y,Tl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/vertex-ai-endpoint.png" alt="Vertex AI Endpoint created"/>',mt,z,Jl="Now you can deploy the registered model in an endpoint on Vertex AI.",ut,D,wl="The <code>deploy</code> method will link the previously created endpoint resource with the model that contains the configuration of the serving container, and then, it will deploy the model on Vertex AI in the specified instance.",yt,P,gl="Before going into the code, let’s quickly review the arguments provided to the <code>deploy</code> method:",ht,O,Ul='<li><strong><code>endpoint</code></strong> is the endpoint to deploy the model to, which is optional, and by default will be set to the model display name with the <code>_endpoint</code> suffix.</li> <li><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> are arguments that define which instance to use, and additionally, the accelerator to use and the number of accelerators, respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</li>',Tt,K,jl='For more information on the supported <code>aiplatform.Model.deploy</code> arguments, you can check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy</a>.',Jt,ee,wt,te,bl="<strong>WARNING</strong>: <em>The Vertex AI endpoint deployment via the <code>deploy</code> method may take from 15 to 25 minutes.</em>",gt,le,Il='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/vertex-ai-endpoint-run.png" alt="Vertex AI Endpoint running the model"/>',Ut,ne,fl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/vertex-ai-endpoint-logs.png" alt="Vertex AI Endpoint logs in Cloud Logging"/>',jt,se,bt,ae,Cl="Finally, you can run the online predictions on Vertex AI using the <code>predict</code> method, which will send the requests to the running endpoint in the <code>/predict</code> route specified within the container following Vertex AI I/O payload formatting.",It,oe,vl='As you are serving a <code>text-generation</code> model, you will need to make sure that the chat template, if any, is applied correctly to the input conversation; meaning that <code>transformers</code> need to be installed so as to instantiate the <code>tokenizer</code> for <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> and run the <code>apply_chat_template</code> method over the input conversation before sending the input within the payload to the Vertex AI endpoint.',ft,ie,Ct,pe,Zl="After the installation is complete, the following snippet will apply the chat template to the conversation:",vt,re,Zt,ce,Gl='Which is what you will be sending within the payload to the deployed Vertex AI Endpoint, as well as the generation parameters as in <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation" rel="nofollow">https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation</a>.',Gt,Me,At,de,xt,me,Al="If you are willing to run the online prediction within the current session, you can send requests programmatically via the <code>aiplatform.Endpoint</code> (returned by the <code>aiplatform.Model.deploy</code> method) as in the following snippet:",Vt,ue,_t,ye,xl="Producing the following <code>output</code>:",Nt,he,Bt,Te,Vl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/vertex-ai-endpoint-logs-predict.png" alt="Vertex AI Endpoint logs in Cloud Logging after predict"/>',Wt,Je,$t,we,_l="If the Vertex AI Endpoint was deployed in a different session and you want to use it but don’t have access to the <code>deployed_model</code> variable returned by the <code>aiplatform.Model.deploy</code> method as in the previous section; you can also run the following snippet to instantiate the deployed <code>aiplatform.Endpoint</code> via its resource name as <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code>.",kt,ge,Nl="Note that you will need to either retrieve the resource name i.e. the <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code> URL yourself via the Google Cloud Console, or just replace the <code>ENDPOINT_ID</code> below that can either be found via the previously instantiated <code>endpoint</code> as <code>endpoint.id</code> or via the Google Cloud Console under the Online predictions where the endpoint is listed.",Rt,Ue,Xt,je,Et,be,Bl="Alternatively, for testing purposes you can also use the Vertex AI Online Prediction UI, that provides a field that expects the JSON payload formatted according to the Vertex AI specification (as in the examples above) being:",Qt,Ie,Ft,fe,Wl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-on-vertex-ai/assets/vertex-ai-online-prediction.png" alt="Vertex AI Endpoint online inference"/>',Ht,Ce,St,ve,$l="Finally, you can already release the resources that you’ve created as follows, to avoid unnecessary costs:",qt,Ze,kl="<li><code>deployed_model.undeploy_all</code> to undeploy the model from all the endpoints.</li> <li><code>deployed_model.delete</code> to delete the endpoint/s where the model was deployed gracefully, after the <code>undeploy_all</code> method.</li> <li><code>model.delete</code> to delete the model from the registry.</li>",Lt,Ge,Yt,Ae,Rl="Alternatively, you can also remove those from the Google Cloud Console following the steps:",zt,xe,Xl="<li>Go to Vertex AI in Google Cloud</li> <li>Go to Deploy and use -&gt; Online prediction</li> <li>Click on the endpoint and then on the deployed model/s to “Undeploy model from endpoint”</li> <li>Then go back to the endpoint list and remove the endpoint</li> <li>Finally, go to Deploy and use -&gt; Model Registry, and remove the model</li>",Dt,Ve,Pt,Ne,Ot;return J=new h({props:{title:"Deploy Gemma 7B with TGI on Vertex AI",local:"deploy-gemma-7b-with-tgi-on-vertex-ai",headingTag:"h1"}}),j=new h({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),f=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),v=new y({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMENPTlRBSU5FUl9VUkklM0R1cy1kb2NrZXIucGtnLmRldiUyRmRlZXBsZWFybmluZy1wbGF0Zm9ybS1yZWxlYXNlJTJGZ2NyLmlvJTJGaHVnZ2luZ2ZhY2UtdGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZS1jdTEyMS4yLTIudWJ1bnR1MjIwNC5weTMxMA==",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu121<span class="hljs-number">.2</span>-<span class="hljs-number">2.</span>ubuntu2204.py310`,wrap:!1}}),G=new y({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),x=new y({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),V=new h({props:{title:"Register model on Vertex AI",local:"register-model-on-vertex-ai",headingTag:"h2"}}),N=new y({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
)`,wrap:!1}}),W=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwaHVnZ2luZ2ZhY2VfaHVi",highlighted:"!pip install --upgrade --quiet huggingface_hub",wrap:!1}}),$=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),Q=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQSUwQW1vZGVsJTIwJTNEJTIwYWlwbGF0Zm9ybS5Nb2RlbC51cGxvYWQoJTBBJTIwJTIwJTIwJTIwZGlzcGxheV9uYW1lJTNEJTIyZ29vZ2xlLS1nZW1tYS03Yi1pdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX2ltYWdlX3VyaSUzRG9zLmdldGVudiglMjJDT05UQUlORVJfVVJJJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX2Vudmlyb25tZW50X3ZhcmlhYmxlcyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtN2ItaXQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOVU1fU0hBUkQlMjIlM0ElMjAlMjIxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX1RPS0VOUyUyMiUzQSUyMCUyMjUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1BWF9UT1RBTF9UT0tFTlMlMjIlM0ElMjAlMjIxMDI0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0JBVENIX1BSRUZJTExfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhVR0dJTkdfRkFDRV9IVUJfVE9LRU4lMjIlM0ElMjBnZXRfdG9rZW4oKSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX3BvcnRzJTNEJTVCODA4MCU1RCUyQyUwQSklMEFtb2RlbC53YWl0KCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token

model = aiplatform.Model.upload(
    display_name=<span class="hljs-string">&quot;google--gemma-7b-it&quot;</span>,
    serving_container_image_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    serving_container_environment_variables={
        <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;google/gemma-7b-it&quot;</span>,
        <span class="hljs-string">&quot;NUM_SHARD&quot;</span>: <span class="hljs-string">&quot;1&quot;</span>,
        <span class="hljs-string">&quot;MAX_INPUT_TOKENS&quot;</span>: <span class="hljs-string">&quot;512&quot;</span>,
        <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
        <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
        <span class="hljs-string">&quot;HUGGING_FACE_HUB_TOKEN&quot;</span>: get_token(),
    },
    serving_container_ports=[<span class="hljs-number">8080</span>],
)
model.wait()`,wrap:!1}}),H=new h({props:{title:"Deploy model on Vertex AI",local:"deploy-model-on-vertex-ai",headingTag:"h2"}}),L=new y({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBhaXBsYXRmb3JtLkVuZHBvaW50LmNyZWF0ZShkaXNwbGF5X25hbWUlM0QlMjJnb29nbGUtLWdlbW1hLTdiLWl0LWVuZHBvaW50JTIyKQ==",highlighted:'endpoint = aiplatform.Endpoint.create(display_name=<span class="hljs-string">&quot;google--gemma-7b-it-endpoint&quot;</span>)',wrap:!1}}),ee=new y({props:{code:"ZGVwbG95ZWRfbW9kZWwlMjAlM0QlMjBtb2RlbC5kZXBsb3koJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0RlbmRwb2ludCUyQyUwQSUyMCUyMCUyMCUyMG1hY2hpbmVfdHlwZSUzRCUyMmcyLXN0YW5kYXJkLTQlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl90eXBlJTNEJTIyTlZJRElBX0w0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3JfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`deployed_model = model.deploy(
    endpoint=endpoint,
    machine_type=<span class="hljs-string">&quot;g2-standard-4&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_L4&quot;</span>,
    accelerator_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),se=new h({props:{title:"Online predictions on Vertex AI",local:"online-predictions-on-vertex-ai",headingTag:"h2"}}),ie=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwdHJhbnNmb3JtZXJz",highlighted:"!pip install --upgrade --quiet transformers",wrap:!1}}),re=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtN2ItaXQlMjIlMkMlMjB0b2tlbiUzRGdldF90b2tlbigpKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCdzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTdEJTJDJTBBJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUwQSklMEElMjMlMjAlM0Nib3MlM0UlM0NzdGFydF9vZl90dXJuJTNFdXNlciU1Q25XaGF0J3MlMjBEZWVwJTIwTGVhcm5pbmclM0YlM0NlbmRfb2ZfdHVybiUzRSU1Q24lM0NzdGFydF9vZl90dXJuJTNFbW9kZWwlNUNu",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-7b-it&quot;</span>, token=get_token())

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s Deep Learning?&quot;</span>},
]

inputs = tokenizer.apply_chat_template(
    messages,
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
)
<span class="hljs-comment"># &lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n</span>`,wrap:!1}}),Me=new h({props:{title:"Via Python",local:"via-python",headingTag:"h3"}}),de=new h({props:{title:"Within the same session",local:"within-the-same-session",headingTag:"h4"}}),ue=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwZGVwbG95ZWRfbW9kZWwucHJlZGljdCglMEElMjAlMjAlMjAlMjBpbnN0YW5jZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnB1dHMlMjIlM0ElMjAlMjIlM0Nib3MlM0UlM0NzdGFydF9vZl90dXJuJTNFdXNlciU1Q25XaGF0J3MlMjBEZWVwJTIwTGVhcm5pbmclM0YlM0NlbmRfb2ZfdHVybiUzRSU1Q24lM0NzdGFydF9vZl90dXJuJTNFbW9kZWwlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1ldGVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRvcF9wJTIyJTNBJTIwMC45NSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQXByaW50KG91dHB1dC5wcmVkaWN0aW9ucyU1QjAlNUQp",highlighted:`output = deployed_model.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">256</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>,
            },
        },
    ]
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),he=new y({props:{code:"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",highlighted:'<span class="hljs-constructor">Prediction(<span class="hljs-params">predictions</span>=[&#x27;\\<span class="hljs-params">n</span>\\<span class="hljs-params">nDeep</span> <span class="hljs-params">learning</span> <span class="hljs-params">is</span> <span class="hljs-params">a</span> <span class="hljs-params">type</span> <span class="hljs-params">of</span> <span class="hljs-params">machine</span> <span class="hljs-params">learning</span> <span class="hljs-params">that</span> <span class="hljs-params">uses</span> <span class="hljs-params">artificial</span> <span class="hljs-params">neural</span> <span class="hljs-params">networks</span> <span class="hljs-params">to</span> <span class="hljs-params">learn</span> <span class="hljs-params">from</span> <span class="hljs-params">large</span> <span class="hljs-params">amounts</span> <span class="hljs-params">of</span> <span class="hljs-params">data</span>, <span class="hljs-params">making</span> <span class="hljs-params">it</span> <span class="hljs-params">a</span> <span class="hljs-params">powerful</span> <span class="hljs-params">tool</span> <span class="hljs-params">for</span> <span class="hljs-params">various</span> <span class="hljs-params">tasks</span>, <span class="hljs-params">including</span> <span class="hljs-params">image</span> <span class="hljs-params">recognition</span>, <span class="hljs-params">natural</span> <span class="hljs-params">language</span> <span class="hljs-params">processing</span>, <span class="hljs-params">and</span> <span class="hljs-params">speech</span> <span class="hljs-params">recognition</span>.\\<span class="hljs-params">n</span>\\<span class="hljs-params">n</span><span class="hljs-operator">**</span>Key Concepts:<span class="hljs-operator">**</span>\\<span class="hljs-params">n</span>\\<span class="hljs-params">n</span><span class="hljs-operator">*</span> <span class="hljs-operator">**</span>Artificial Neural Networks (ANNs)</span>:** Structures that mimic the interconnected neurons <span class="hljs-keyword">in</span> the brain.\\n* **Deep Learning Architectures:** Multi-layered ANNs that learn hierarchical features from data.\\n* **Transfer Learning:** Reusing learned features from one task <span class="hljs-keyword">to</span> improve performance on another.\\n\\n**Types <span class="hljs-keyword">of</span> Deep Learning:**\\n\\n* **Supervised Learning:** Models are trained on labeled data, where inputs are paired <span class="hljs-keyword">with</span> corresponding outputs.\\n* **Unsupervised Learning:** Models learn patterns from unlabeled data, such <span class="hljs-keyword">as</span> clustering <span class="hljs-keyword">or</span> dimensionality reduction.\\n* **Reinforcement Learning:** Models learn through trial-<span class="hljs-keyword">and</span>-error by interacting <span class="hljs-keyword">with</span> an environment <span class="hljs-keyword">to</span> optimize a task.\\n\\n**Benefits:**\\n\\n* **High Accuracy:** Deep learning models can achieve high accuracy on complex tasks.\\n* **Adaptability:** Deep learning models can adapt <span class="hljs-keyword">to</span> <span class="hljs-keyword">new</span> data <span class="hljs-keyword">and</span> tasks.\\n* **Scalability:** Deep learning models can handle large amounts <span class="hljs-keyword">of</span> data.\\n\\n**Applications:**\\n\\n* Image recognition\\n* Natural language processing (NLP)\\n&#x27;], deployed_model_id=&#x27;***&#x27;, metadata=None, model_version_id=<span class="hljs-character">&#x27;1&#x27;</span>, model_resource_name=&#x27;projects<span class="hljs-comment">/***/</span>locations/us-central1/models<span class="hljs-comment">/***&#x27;, explanations=None)</span>',wrap:!1}}),Je=new h({props:{title:"From a different session",local:"from-a-different-session",headingTag:"h4"}}),Ue=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>), location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>))

endpoint_display_name = <span class="hljs-string">&quot;google--gemma-7b-it-endpoint&quot;</span>  <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> change to your endpoint display name</span>

<span class="hljs-comment"># Iterates over all the Vertex AI Endpoints within the current project and keeps the first match (if any), otherwise set to None</span>
ENDPOINT_ID = <span class="hljs-built_in">next</span>(
    (endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> aiplatform.Endpoint.<span class="hljs-built_in">list</span>() <span class="hljs-keyword">if</span> endpoint.display_name == endpoint_display_name), <span class="hljs-literal">None</span>
)
<span class="hljs-keyword">assert</span> ENDPOINT_ID, (
    <span class="hljs-string">&quot;\`ENDPOINT_ID\` is not set, please make sure that the \`endpoint_display_name\` is correct at &quot;</span>
    <span class="hljs-string">f&quot;https://console.cloud.google.com/vertex-ai/online-prediction/endpoints?project=<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>&quot;</span>
)

endpoint = aiplatform.Endpoint(
    <span class="hljs-string">f&quot;projects/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>/locations/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_ID}</span>&quot;</span>
)
output = endpoint.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
            },
        },
    ],
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),je=new h({props:{title:"Via the Vertex AI Online Prediction UI",local:"via-the-vertex-ai-online-prediction-ui",headingTag:"h3"}}),Ie=new y({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5zdGFuY2VzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTNDYm9zJTNFJTNDc3RhcnRfb2ZfdHVybiUzRXVzZXIlNUNuV2hhdCdzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTNDZW5kX29mX3R1cm4lM0UlNUNuJTNDc3RhcnRfb2ZfdHVybiUzRW1vZGVsJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEyOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3BfcCUyMiUzQSUyMDAuOTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDAuNyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;instances&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;max_new_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;do_sample&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;top_p&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.95</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;temperature&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.7</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ce=new h({props:{title:"Resource clean-up",local:"resource-clean-up",headingTag:"h2"}}),Ge=new y({props:{code:"ZGVwbG95ZWRfbW9kZWwudW5kZXBsb3lfYWxsKCklMEFkZXBsb3llZF9tb2RlbC5kZWxldGUoKSUwQW1vZGVsLmRlbGV0ZSgp",highlighted:`deployed_model.undeploy_all()
deployed_model.delete()
model.delete()`,wrap:!1}}),Ve=new Dl({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-deploy-gemma-on-vertex-ai.mdx"}}),{c(){T=o("meta"),Be=s(),_e=o("p"),We=s(),r(J.$$.fragment),$e=s(),w=o("p"),w.textContent=el,ke=s(),g=o("p"),g.innerHTML=tl,Re=s(),U=o("p"),U.innerHTML=ll,Xe=s(),r(j.$$.fragment),Ee=s(),b=o("p"),b.innerHTML=nl,Qe=s(),I=o("p"),I.innerHTML=sl,Fe=s(),r(f.$$.fragment),He=s(),C=o("p"),C.textContent=al,Se=s(),r(v.$$.fragment),qe=s(),Z=o("p"),Z.textContent=ol,Le=s(),r(G.$$.fragment),Ye=s(),A=o("p"),A.textContent=il,ze=s(),r(x.$$.fragment),De=s(),r(V.$$.fragment),Pe=s(),_=o("p"),_.innerHTML=pl,Oe=s(),r(N.$$.fragment),Ke=s(),B=o("p"),B.innerHTML=rl,et=s(),r(W.$$.fragment),tt=s(),r($.$$.fragment),lt=s(),k=o("p"),k.innerHTML=cl,nt=s(),R=o("p"),R.innerHTML=Ml,st=s(),X=o("ul"),X.innerHTML=dl,at=s(),E=o("p"),E.innerHTML=ml,ot=s(),r(Q.$$.fragment),it=s(),F=o("p"),F.innerHTML=ul,pt=s(),r(H.$$.fragment),rt=s(),S=o("p"),S.textContent=yl,ct=s(),q=o("p"),q.innerHTML=hl,Mt=s(),r(L.$$.fragment),dt=s(),Y=o("p"),Y.innerHTML=Tl,mt=s(),z=o("p"),z.textContent=Jl,ut=s(),D=o("p"),D.innerHTML=wl,yt=s(),P=o("p"),P.innerHTML=gl,ht=s(),O=o("ul"),O.innerHTML=Ul,Tt=s(),K=o("p"),K.innerHTML=jl,Jt=s(),r(ee.$$.fragment),wt=s(),te=o("p"),te.innerHTML=bl,gt=s(),le=o("p"),le.innerHTML=Il,Ut=s(),ne=o("p"),ne.innerHTML=fl,jt=s(),r(se.$$.fragment),bt=s(),ae=o("p"),ae.innerHTML=Cl,It=s(),oe=o("p"),oe.innerHTML=vl,ft=s(),r(ie.$$.fragment),Ct=s(),pe=o("p"),pe.textContent=Zl,vt=s(),r(re.$$.fragment),Zt=s(),ce=o("p"),ce.innerHTML=Gl,Gt=s(),r(Me.$$.fragment),At=s(),r(de.$$.fragment),xt=s(),me=o("p"),me.innerHTML=Al,Vt=s(),r(ue.$$.fragment),_t=s(),ye=o("p"),ye.innerHTML=xl,Nt=s(),r(he.$$.fragment),Bt=s(),Te=o("p"),Te.innerHTML=Vl,Wt=s(),r(Je.$$.fragment),$t=s(),we=o("p"),we.innerHTML=_l,kt=s(),ge=o("p"),ge.innerHTML=Nl,Rt=s(),r(Ue.$$.fragment),Xt=s(),r(je.$$.fragment),Et=s(),be=o("p"),be.textContent=Bl,Qt=s(),r(Ie.$$.fragment),Ft=s(),fe=o("p"),fe.innerHTML=Wl,Ht=s(),r(Ce.$$.fragment),St=s(),ve=o("p"),ve.textContent=$l,qt=s(),Ze=o("ul"),Ze.innerHTML=kl,Lt=s(),r(Ge.$$.fragment),Yt=s(),Ae=o("p"),Ae.textContent=Rl,zt=s(),xe=o("ul"),xe.innerHTML=Xl,Dt=s(),r(Ve.$$.fragment),Pt=s(),Ne=o("p"),this.h()},l(e){const t=Yl("svelte-u9bgzb",document.head);T=i(t,"META",{name:!0,content:!0}),t.forEach(l),Be=a(e),_e=i(e,"P",{}),El(_e).forEach(l),We=a(e),c(J.$$.fragment,e),$e=a(e),w=i(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-9afh3f"&&(w.textContent=el),ke=a(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-20yaz"&&(g.innerHTML=tl),Re=a(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1ui776m"&&(U.innerHTML=ll),Xe=a(e),c(j.$$.fragment,e),Ee=a(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1o67gfb"&&(b.innerHTML=nl),Qe=a(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1ebrquh"&&(I.innerHTML=sl),Fe=a(e),c(f.$$.fragment,e),He=a(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1i8n6rq"&&(C.textContent=al),Se=a(e),c(v.$$.fragment,e),qe=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-15nvzfz"&&(Z.textContent=ol),Le=a(e),c(G.$$.fragment,e),Ye=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1nm8o2l"&&(A.textContent=il),ze=a(e),c(x.$$.fragment,e),De=a(e),c(V.$$.fragment,e),Pe=a(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-14aynbe"&&(_.innerHTML=pl),Oe=a(e),c(N.$$.fragment,e),Ke=a(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1q9bebj"&&(B.innerHTML=rl),et=a(e),c(W.$$.fragment,e),tt=a(e),c($.$$.fragment,e),lt=a(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1voap9p"&&(k.innerHTML=cl),nt=a(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-zklutt"&&(R.innerHTML=Ml),st=a(e),X=i(e,"UL",{"data-svelte-h":!0}),p(X)!=="svelte-dc0uiu"&&(X.innerHTML=dl),at=a(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1flszm1"&&(E.innerHTML=ml),ot=a(e),c(Q.$$.fragment,e),it=a(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1u5p2tx"&&(F.innerHTML=ul),pt=a(e),c(H.$$.fragment,e),rt=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-2nwexf"&&(S.textContent=yl),ct=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1lovlvw"&&(q.innerHTML=hl),Mt=a(e),c(L.$$.fragment,e),dt=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-6zzg54"&&(Y.innerHTML=Tl),mt=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-it668a"&&(z.textContent=Jl),ut=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-njbdvc"&&(D.innerHTML=wl),yt=a(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1ezlr9j"&&(P.innerHTML=gl),ht=a(e),O=i(e,"UL",{"data-svelte-h":!0}),p(O)!=="svelte-1mv29i5"&&(O.innerHTML=Ul),Tt=a(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-9p37qa"&&(K.innerHTML=jl),Jt=a(e),c(ee.$$.fragment,e),wt=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-mraq68"&&(te.innerHTML=bl),gt=a(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1lquhxz"&&(le.innerHTML=Il),Ut=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-7673na"&&(ne.innerHTML=fl),jt=a(e),c(se.$$.fragment,e),bt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-166ya0u"&&(ae.innerHTML=Cl),It=a(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-17alodq"&&(oe.innerHTML=vl),ft=a(e),c(ie.$$.fragment,e),Ct=a(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-rj4r5t"&&(pe.textContent=Zl),vt=a(e),c(re.$$.fragment,e),Zt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-nq4b4r"&&(ce.innerHTML=Gl),Gt=a(e),c(Me.$$.fragment,e),At=a(e),c(de.$$.fragment,e),xt=a(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-hnmp6i"&&(me.innerHTML=Al),Vt=a(e),c(ue.$$.fragment,e),_t=a(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-d9pmg3"&&(ye.innerHTML=xl),Nt=a(e),c(he.$$.fragment,e),Bt=a(e),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1hgwx6d"&&(Te.innerHTML=Vl),Wt=a(e),c(Je.$$.fragment,e),$t=a(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-gm5hxo"&&(we.innerHTML=_l),kt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1f4v83r"&&(ge.innerHTML=Nl),Rt=a(e),c(Ue.$$.fragment,e),Xt=a(e),c(je.$$.fragment,e),Et=a(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1ajbcx5"&&(be.textContent=Bl),Qt=a(e),c(Ie.$$.fragment,e),Ft=a(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1d7odg"&&(fe.innerHTML=Wl),Ht=a(e),c(Ce.$$.fragment,e),St=a(e),ve=i(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-l6tvv1"&&(ve.textContent=$l),qt=a(e),Ze=i(e,"UL",{"data-svelte-h":!0}),p(Ze)!=="svelte-16ibgml"&&(Ze.innerHTML=kl),Lt=a(e),c(Ge.$$.fragment,e),Yt=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-sgegyq"&&(Ae.textContent=Rl),zt=a(e),xe=i(e,"UL",{"data-svelte-h":!0}),p(xe)!=="svelte-1p833nz"&&(xe.innerHTML=Xl),Dt=a(e),c(Ve.$$.fragment,e),Pt=a(e),Ne=i(e,"P",{}),El(Ne).forEach(l),this.h()},h(){Ql(T,"name","hf:doc:metadata"),Ql(T,"content",Ol)},m(e,t){zl(document.head,T),n(e,Be,t),n(e,_e,t),n(e,We,t),M(J,e,t),n(e,$e,t),n(e,w,t),n(e,ke,t),n(e,g,t),n(e,Re,t),n(e,U,t),n(e,Xe,t),M(j,e,t),n(e,Ee,t),n(e,b,t),n(e,Qe,t),n(e,I,t),n(e,Fe,t),M(f,e,t),n(e,He,t),n(e,C,t),n(e,Se,t),M(v,e,t),n(e,qe,t),n(e,Z,t),n(e,Le,t),M(G,e,t),n(e,Ye,t),n(e,A,t),n(e,ze,t),M(x,e,t),n(e,De,t),M(V,e,t),n(e,Pe,t),n(e,_,t),n(e,Oe,t),M(N,e,t),n(e,Ke,t),n(e,B,t),n(e,et,t),M(W,e,t),n(e,tt,t),M($,e,t),n(e,lt,t),n(e,k,t),n(e,nt,t),n(e,R,t),n(e,st,t),n(e,X,t),n(e,at,t),n(e,E,t),n(e,ot,t),M(Q,e,t),n(e,it,t),n(e,F,t),n(e,pt,t),M(H,e,t),n(e,rt,t),n(e,S,t),n(e,ct,t),n(e,q,t),n(e,Mt,t),M(L,e,t),n(e,dt,t),n(e,Y,t),n(e,mt,t),n(e,z,t),n(e,ut,t),n(e,D,t),n(e,yt,t),n(e,P,t),n(e,ht,t),n(e,O,t),n(e,Tt,t),n(e,K,t),n(e,Jt,t),M(ee,e,t),n(e,wt,t),n(e,te,t),n(e,gt,t),n(e,le,t),n(e,Ut,t),n(e,ne,t),n(e,jt,t),M(se,e,t),n(e,bt,t),n(e,ae,t),n(e,It,t),n(e,oe,t),n(e,ft,t),M(ie,e,t),n(e,Ct,t),n(e,pe,t),n(e,vt,t),M(re,e,t),n(e,Zt,t),n(e,ce,t),n(e,Gt,t),M(Me,e,t),n(e,At,t),M(de,e,t),n(e,xt,t),n(e,me,t),n(e,Vt,t),M(ue,e,t),n(e,_t,t),n(e,ye,t),n(e,Nt,t),M(he,e,t),n(e,Bt,t),n(e,Te,t),n(e,Wt,t),M(Je,e,t),n(e,$t,t),n(e,we,t),n(e,kt,t),n(e,ge,t),n(e,Rt,t),M(Ue,e,t),n(e,Xt,t),M(je,e,t),n(e,Et,t),n(e,be,t),n(e,Qt,t),M(Ie,e,t),n(e,Ft,t),n(e,fe,t),n(e,Ht,t),M(Ce,e,t),n(e,St,t),n(e,ve,t),n(e,qt,t),n(e,Ze,t),n(e,Lt,t),M(Ge,e,t),n(e,Yt,t),n(e,Ae,t),n(e,zt,t),n(e,xe,t),n(e,Dt,t),M(Ve,e,t),n(e,Pt,t),n(e,Ne,t),Ot=!0},p:Hl,i(e){Ot||(d(J.$$.fragment,e),d(j.$$.fragment,e),d(f.$$.fragment,e),d(v.$$.fragment,e),d(G.$$.fragment,e),d(x.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(W.$$.fragment,e),d($.$$.fragment,e),d(Q.$$.fragment,e),d(H.$$.fragment,e),d(L.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(Me.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(he.$$.fragment,e),d(Je.$$.fragment,e),d(Ue.$$.fragment,e),d(je.$$.fragment,e),d(Ie.$$.fragment,e),d(Ce.$$.fragment,e),d(Ge.$$.fragment,e),d(Ve.$$.fragment,e),Ot=!0)},o(e){m(J.$$.fragment,e),m(j.$$.fragment,e),m(f.$$.fragment,e),m(v.$$.fragment,e),m(G.$$.fragment,e),m(x.$$.fragment,e),m(V.$$.fragment,e),m(N.$$.fragment,e),m(W.$$.fragment,e),m($.$$.fragment,e),m(Q.$$.fragment,e),m(H.$$.fragment,e),m(L.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(Me.$$.fragment,e),m(de.$$.fragment,e),m(ue.$$.fragment,e),m(he.$$.fragment,e),m(Je.$$.fragment,e),m(Ue.$$.fragment,e),m(je.$$.fragment,e),m(Ie.$$.fragment,e),m(Ce.$$.fragment,e),m(Ge.$$.fragment,e),m(Ve.$$.fragment,e),Ot=!1},d(e){e&&(l(Be),l(_e),l(We),l($e),l(w),l(ke),l(g),l(Re),l(U),l(Xe),l(Ee),l(b),l(Qe),l(I),l(Fe),l(He),l(C),l(Se),l(qe),l(Z),l(Le),l(Ye),l(A),l(ze),l(De),l(Pe),l(_),l(Oe),l(Ke),l(B),l(et),l(tt),l(lt),l(k),l(nt),l(R),l(st),l(X),l(at),l(E),l(ot),l(it),l(F),l(pt),l(rt),l(S),l(ct),l(q),l(Mt),l(dt),l(Y),l(mt),l(z),l(ut),l(D),l(yt),l(P),l(ht),l(O),l(Tt),l(K),l(Jt),l(wt),l(te),l(gt),l(le),l(Ut),l(ne),l(jt),l(bt),l(ae),l(It),l(oe),l(ft),l(Ct),l(pe),l(vt),l(Zt),l(ce),l(Gt),l(At),l(xt),l(me),l(Vt),l(_t),l(ye),l(Nt),l(Bt),l(Te),l(Wt),l($t),l(we),l(kt),l(ge),l(Rt),l(Xt),l(Et),l(be),l(Qt),l(Ft),l(fe),l(Ht),l(St),l(ve),l(qt),l(Ze),l(Lt),l(Yt),l(Ae),l(zt),l(xe),l(Dt),l(Pt),l(Ne)),l(T),u(J,e),u(j,e),u(f,e),u(v,e),u(G,e),u(x,e),u(V,e),u(N,e),u(W,e),u($,e),u(Q,e),u(H,e),u(L,e),u(ee,e),u(se,e),u(ie,e),u(re,e),u(Me,e),u(de,e),u(ue,e),u(he,e),u(Je,e),u(Ue,e),u(je,e),u(Ie,e),u(Ce,e),u(Ge,e),u(Ve,e)}}}const Ol='{"title":"Deploy Gemma 7B with TGI on Vertex AI","local":"deploy-gemma-7b-with-tgi-on-vertex-ai","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Register model on Vertex AI","local":"register-model-on-vertex-ai","sections":[],"depth":2},{"title":"Deploy model on Vertex AI","local":"deploy-model-on-vertex-ai","sections":[],"depth":2},{"title":"Online predictions on Vertex AI","local":"online-predictions-on-vertex-ai","sections":[{"title":"Via Python","local":"via-python","sections":[{"title":"Within the same session","local":"within-the-same-session","sections":[],"depth":4},{"title":"From a different session","local":"from-a-different-session","sections":[],"depth":4}],"depth":3},{"title":"Via the Vertex AI Online Prediction UI","local":"via-the-vertex-ai-online-prediction-ui","sections":[],"depth":3}],"depth":2},{"title":"Resource clean-up","local":"resource-clean-up","sections":[],"depth":2}],"depth":1}';function Kl(Kt){return Sl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sn extends ql{constructor(T){super(),Ll(this,T,Kl,Pl,Fl,{})}}export{sn as component};
