import{s as Sn,n as Fn,o as Qn}from"../chunks/scheduler.b108d059.js";import{S as Hn,i as Ln,g as o,s,r,A as Yn,h as i,f as l,c as a,j as Xn,u as c,x as p,k as En,y as qn,a as n,v as M,d,t as m,w as u}from"../chunks/index.008de539.js";import{C as h}from"../chunks/CodeBlock.3968c746.js";import{H as y,E as zn}from"../chunks/EditOnGithub.d1c48e3d.js";function Dn(_l){let T,tt,Ke,lt,J,nt,w,Xl="Gemma is a family of lightweight, state-of-the-art open models built from the same research and technology used to create the Gemini models, developed by Google DeepMind and other teams across Google. Text Generation Inference (TGI) is a toolkit developed by Hugging Face for deploying and serving LLMs, with high performance text generation. And, Google Vertex AI is a Machine Learning (ML) platform that lets you train and deploy ML models and AI applications, and customize large language models (LLMs) for use in your AI-powered applications.",st,g,El='This example showcases how to deploy any supported text-generation model, in this case <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a>, downloaded from the Hugging Face Hub and uploaded to a Google Cloud Storage (GCS) Bucket, on Vertex AI using the Hugging Face DLC for TGI available in Google Cloud Platform (GCP).',at,U,Sl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/model-in-hf-hub.png" alt="&#39;google/gemma-7b-it&#39; in the Hugging Face Hub"/>',ot,j,it,b,Fl='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',pt,f,Ql="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",rt,I,ct,C,Hl="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",Mt,Z,dt,v,Ll="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",mt,G,ut,A,Yl="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",ht,B,yt,V,Tt,x,ql="Unless you already have a GCS Bucket with the artifact that you want to serve, please follow the instructions below in order to create a new bucket and download and upload the model weights into it.",Jt,R,zl="To create the bucket on Google Cloud Storage (GCS), you first need to ensure that the name is unique for the new bucket or if a bucket with the same name already exists. To do so, both the <code>gsutil</code> SDK and the <code>crcmod</code> Python package need to be installed in advance as follows:",wt,k,gt,$,Dl="Then you can check whether the bucket exists in GCS, and create it if it doesn’t, with the following bash script:",Ut,W,jt,N,Pl='If either the bucket was created or if the bucket existed in advance, you can already upload <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> from either the Hugging Face Hub, or local storage.',bt,_,ft,X,Ol="If the model is available locally, e.g. under the Hugging Face cache path at <code>~/.cache/huggingface/hub/models--google--gemma-7b-it/snapshots/8adab6a35fdbcdae0ae41ab1f711b1bc8d05727e</code>, you should run the following script to upload it to the GCS Bucket.",It,E,Ct,S,Zt,F,Kl='Alternatively, you can also upload the model to the GCS Bucket from the Hugging Face Hub. As <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> is a gated model, you need to login into your Hugging Face Hub account with a read-access token either fine-grained with access to the gated model, or just overall read-access to your account.',vt,Q,en='More information on how to generate a read-only access token for the Hugging Face Hub in the instructions at <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">https://huggingface.co/docs/hub/en/security-tokens</a>.',Gt,H,At,L,Bt,Y,tn="After <code>huggingface_hub</code> installation and login are completed, you can run the following bash script to download the model locally within a temporary directory, and then upload those to the GCS Bucket.",Vt,q,xt,z,ln='To see the end to end script, please check <a href="https://github.com/huggingface/Google-Cloud-Containers/blob/main/scripts/upload_model_to_gcs.sh" rel="nofollow"><code>./scripts/upload_model_to_gcs.sh</code></a> within the root directory of this repository.',Rt,D,nn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/gcs-model-artifact.png" alt="GCS Bucket with model artifact"/>',kt,P,$t,O,sn="Once everything is set up, you can already initialize the Vertex AI session via the <code>google-cloud-aiplatform</code> Python SDK as follows:",Wt,K,Nt,ee,an="Then you can already “upload” the model i.e. register the model on Vertex AI. It is not an upload per se, since the model will be automatically downloaded from the GCS Bucket URI on startup, so what is uploaded is only the configuration, not the model weights.",_t,te,on="Before going into the code, let’s quickly review the arguments provided to the <code>upload</code> method:",Xt,le,pn='<li><p><strong><code>display_name</code></strong> is the name that will be shown in the Vertex AI Model Registry.</p></li> <li><p><strong><code>artifact_uri</code></strong> is the path to the directory with the artifact within the GCS Bucket.</p></li> <li><p><strong><code>serving_container_image_uri</code></strong> is the location of the Hugging Face DLC for TGI that will be used for serving the model.</p></li> <li><p><strong><code>serving_container_environment_variables</code></strong> are the environment variables that will be used during the container runtime, so these are aligned with the environment variables defined by <code>text-generation-inference</code>, which are analog to the <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher" rel="nofollow"><code>text-generation-launcher</code> arguments</a>. Additionally, the Hugging Face DLCs for TGI also capture the <code>AIP_</code> environment variables from Vertex AI as in <a href="https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements" rel="nofollow">Vertex AI Documentation - Custom container requirements for prediction</a>.</p> <ul><li><code>NUM_SHARD</code> is the number of shards to use if you don’t want to use all GPUs on a given machine e.g. if you have two GPUs but you just want to use one for TGI then <code>NUM_SHARD=1</code>, otherwise it matches the <code>CUDA_VISIBLE_DEVICES</code>.</li> <li><code>MAX_INPUT_TOKENS</code> is the maximum allowed input length (expressed in number of tokens), the larger it is, the larger the prompt can be, but also more memory will be consumed.</li> <li><code>MAX_TOTAL_TOKENS</code> is the most important value to set as it defines the “memory budget” of running clients requests, the larger this value, the larger amount each request will be in your RAM and the less effective batching can be.</li> <li><code>MAX_BATCH_PREFILL_TOKENS</code> limits the number of tokens for the prefill operation, as it takes the most memory and is compute bound, it is interesting to limit the number of requests that can be sent.</li> <li><code>HUGGING_FACE_HUB_TOKEN</code> is the Hugging Face Hub token, required as <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> is a gated model.</li></ul></li> <li><p>(optional) <strong><code>serving_container_ports</code></strong> is the port where the Vertex AI endpoint will be exposed, by default 8080.</p></li>',Et,ne,rn='For more information on the supported <code>aiplatform.Model.upload</code> arguments, check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload</a>.',St,se,Ft,ae,cn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-model.png" alt="Model on Vertex AI Model Registry"/>',Qt,oe,Mn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-model-path.png" alt="Model on Vertex AI Model Registry with path to GCS"/>',Ht,ie,Lt,pe,dn="After the model is registered on Vertex AI, you need to define the endpoint that you want to deploy the model to, and then link the model deployment to that endpoint resource.",Yt,re,mn="To do so, you need to call the method <code>aiplatform.Endpoint.create</code> to create a new Vertex AI endpoint resource (which is not linked to a model or anything usable yet).",qt,ce,zt,Me,un='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-endpoint.png" alt="Vertex AI Endpoint created"/>',Dt,de,hn="Now you can deploy the registered model in an endpoint on Vertex AI.",Pt,me,yn="The <code>deploy</code> method will link the previously created endpoint resource with the model that contains the configuration of the serving container, and then, it will deploy the model on Vertex AI in the specified instance.",Ot,ue,Tn="Before going into the code, let’s quicklyl review the arguments provided to the <code>deploy</code> method:",Kt,he,Jn='<li><strong><code>endpoint</code></strong> is the endpoint to deploy the model to, which is optional, and by default will be set to the model display name with the <code>_endpoint</code> suffix.</li> <li><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> are arguments that define which instance to use, and additionally, the accelerator to use and the number of accelerators, respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</li>',el,ye,wn='For more information on the supported <code>aiplatform.Model.deploy</code> arguments, you can check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy</a>.',tl,Te,ll,Je,gn="<strong>WARNING</strong>: <em>The Vertex AI endpoint deployment via the <code>deploy</code> method may take from 15 to 25 minutes.</em>",nl,we,Un='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-endpoint-run.png" alt="Vertex AI Endpoint running the model"/>',sl,ge,jn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-endpoint-logs.png" alt="Vertex AI Endpoint logs in Cloud Logging"/>',al,Ue,ol,je,bn="Finally, you can run the online predictions on Vertex AI using the <code>predict</code> method, which will send the requests to the running endpoint in the <code>/predict</code> route specified within the container following Vertex AI I/O payload formatting.",il,be,fn='As you are serving a <code>text-generation</code> model, you will need to make sure that the chat template, if any, is applied correctly to the input conversation; meaning that <code>transformers</code> need to be installed so as to instantiate the <code>tokenizer</code> for <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> and run the <code>apply_chat_template</code> method over the input conversation before sending the input within the payload to the Vertex AI endpoint.',pl,fe,rl,Ie,In="After the installation is complete, the following snippet will apply the chat template to the conversation:",cl,Ce,Ml,Ze,Cn='Which is what you will be sending within the payload to the deployed Vertex AI Endpoint, as well as the generation parameters as in <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation" rel="nofollow">https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation</a>.',dl,ve,ml,Ge,ul,Ae,Zn="If you are willing to run the online prediction within the current session, you can send requests programmatically via the <code>aiplatform.Endpoint</code> (returned by the <code>aiplatform.Model.deploy</code> method) as in the following snippet:",hl,Be,yl,Ve,vn="Producing the following <code>output</code>:",Tl,xe,Jl,Re,wl,ke,Gn="If the Vertex AI Endpoint was deployed in a different session and you want to use it but don’t have access to the <code>deployed_model</code> variable returned by the <code>aiplatform.Model.deploy</code> method as in the previous section; you can also run the following snippet to instantiate the deployed <code>aiplatform.Endpoint</code> via its resource name as <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code>.",gl,$e,An="Note that you will need to either retrieve the resource name i.e. the <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code> URL yourself via the Google Cloud Console, or just replace the <code>ENDPOINT_ID</code> below that can either be found via the previously instantiated <code>endpoint</code> as <code>endpoint.id</code> or via the Google Cloud Console under the Online predictions where the endpoint is listed.",Ul,We,jl,Ne,bl,_e,Bn="Alternatively, for testing purposes you can also use the Vertex AI Online Prediction UI, that provides a field that expects the JSON payload formatted according to the Vertex AI specification (as in the examples above) being:",fl,Xe,Il,Ee,Vn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-online-prediction.png" alt="Vertex AI Endpoint online inference"/>',Cl,Se,Zl,Fe,xn="Finally, you can already release the resources that you’ve created as follows, to avoid unnecessary costs:",vl,Qe,Rn="<li><code>deployed_model.undeploy_all</code> to undeploy the model from all the endpoints.</li> <li><code>deployed_model.delete</code> to delete the endpoint/s where the model was deployed gracefully, after the <code>undeploy_all</code> method.</li> <li><code>model.delete</code> to delete the model from the registry.</li>",Gl,He,kn="Note that when deleting the model from Vertex AI, as it’s stored within a GCS Bucket, neither the bucket nor its contents will be removed when removing the model from Vertex AI.",Al,Le,Bl,Ye,$n="Alternatively, you can also remove those from the Google Cloud Console following the steps:",Vl,qe,Wn="<li>Go to Vertex AI in Google Cloud</li> <li>Go to Deploy and use -&gt; Online prediction</li> <li>Click on the endpoint and then on the deployed model/s to “Undeploy model from endpoint”</li> <li>Then go back to the endpoint list and remove the endpoint</li> <li>Finally, go to Deploy and use -&gt; Model Registry, and remove the model</li>",xl,ze,Nn="Additionally, you may also want to remove the GCS Bucket, to do so, you can use the following <code>gcloud</code> command:",Rl,De,kl,Pe,_n="Or, alternatively, just remove the bucket and/or its contents from the Google Cloud Console.",$l,Oe,Wl,et,Nl;return J=new y({props:{title:"Deploy Gemma 7B from GCS with TGI on Vertex AI",local:"deploy-gemma-7b-from-gcs-with-tgi-on-vertex-ai",headingTag:"h1"}}),j=new y({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),I=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),Z=new h({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMEJVQ0tFVF9VUkklMjBncyUzQSUyRiUyRmhmLXRnaS12ZXJ0ZXgtYWklMEElMjVlbnYlMjBBUlRJRkFDVF9OQU1FJTIwZ29vZ2xlLS1nZW1tYS03Yi1pdCUwQSUyNWVudiUyMENPTlRBSU5FUl9VUkklM0R1cy1kb2NrZXIucGtnLmRldiUyRmRlZXBsZWFybmluZy1wbGF0Zm9ybS1yZWxlYXNlJTJGZ2NyLmlvJTJGaHVnZ2luZ2ZhY2UtdGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZS1jdTEyMS4yLTIudWJ1bnR1MjIwNC5weTMxMA==",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env BUCKET_URI gs://hf-tgi-vertex-ai
%env ARTIFACT_NAME google--gemma-7b-it
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu121<span class="hljs-number">.2</span>-<span class="hljs-number">2.</span>ubuntu2204.py310`,wrap:!1}}),G=new h({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),B=new h({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),V=new y({props:{title:"Optional: Create bucket and upload model from Hub in GCS",local:"optional-create-bucket-and-upload-model-from-hub-in-gcs",headingTag:"h2"}}),k=new h({props:{code:"IWdjbG91ZCUyMGNvbXBvbmVudHMlMjBpbnN0YWxsJTIwZ3N1dGlsJTBBIXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwY3JjbW9k",highlighted:`!gcloud components install gsutil
!pip install --upgrade --quiet crcmod`,wrap:!1}}),W=new h({props:{code:"JTI1JTI1YmFzaCUwQSUwQSUyMyUyMFBhcnNlJTIwdGhlJTIwYnVja2V0JTIwZnJvbSUyMHRoZSUyMHByb3ZpZGVkJTIwJTI0QlVDS0VUX1VSSSUyMHBhdGglMjBpLmUuJTIwZ2l2ZW4lMjBncyUzQSUyRiUyRmJ1Y2tldC1uYW1lJTJGZGlyJTJDJTIwZXh0cmFjdCUyMGJ1Y2tldC1uYW1lJTBBQlVDS0VUX05BTUUlM0QlMjQoZWNobyUyMCUyNEJVQ0tFVF9VUkklMjAlN0MlMjBjdXQlMjAtZCclMkYnJTIwLWYzKSUwQSUyMyUyMENoZWNrJTIwaWYlMjB0aGUlMjBidWNrZXQlMjBleGlzdHMlMkMlMjBpZiUyMG5vdCUyMGNyZWF0ZSUyMGl0JTBBaWYlMjAlNUIlMjAteiUyMCUyMiUyNChnc3V0aWwlMjBscyUyMCU3QyUyMGdyZXAlMjBncyUzQSUyRiUyRiUyNEJVQ0tFVF9OQU1FKSUyMiUyMCU1RCUzQiUyMHRoZW4lMEElMjAlMjAlMjAlMjBnY2xvdWQlMjBzdG9yYWdlJTIwYnVja2V0cyUyMGNyZWF0ZSUyMGdzJTNBJTJGJTJGJTI0QlVDS0VUX05BTUUlMjAtLXByb2plY3QlM0QlMjRQUk9KRUNUX0lEJTIwLS1sb2NhdGlvbiUzRCUyNExPQ0FUSU9OJTIwLS1kZWZhdWx0LXN0b3JhZ2UtY2xhc3MlM0RTVEFOREFSRCUyMC0tdW5pZm9ybS1idWNrZXQtbGV2ZWwtYWNjZXNzJTBBZmk=",highlighted:`%%bash

<span class="hljs-comment"># Parse the bucket from the provided $BUCKET_URI path i.e. given gs://bucket-name/dir, extract bucket-name</span>
BUCKET_NAME=$(echo $BUCKET_URI | cut -d<span class="hljs-string">&#x27;/&#x27;</span> -f3)
<span class="hljs-comment"># Check if the bucket exists, if not create it</span>
<span class="hljs-keyword">if</span> [ -z <span class="hljs-string">&quot;$(gsutil ls | grep gs://$BUCKET_NAME)&quot;</span> ]; then
    gcloud storage buckets create gs://$BUCKET_NAME --project=$PROJECT_ID --location=$LOCATION --default-storage-<span class="hljs-keyword">class</span>=STANDARD --uniform-bucket-level-access
fi`,wrap:!1}}),_=new y({props:{title:"Artifact from disk / local storage",local:"artifact-from-disk--local-storage",headingTag:"h3"}}),E=new h({props:{code:"JTI1JTI1YmFzaCUwQSUyMyUyMFVwbG9hZCUyMHRoZSUyMG1vZGVsJTIwdG8lMjBHb29nbGUlMjBDbG91ZCUyMFN0b3JhZ2UlMEFMT0NBTF9ESVIlM0R+JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLWdvb2dsZS0tZ2VtbWEtN2ItaXQlMkZzbmFwc2hvdHMlMkY4YWRhYjZhMzVmZGJjZGFlMGFlNDFhYjFmNzExYjFiYzhkMDU3MjdlJTBBaWYlMjAlNUIlMjAtZCUyMCUyMiUyNExPQ0FMX0RJUiUyMiUyMCU1RCUzQiUyMHRoZW4lMEElMjAlMjAlMjAlMjBnc3V0aWwlMjAtbyUyMEdTVXRpbCUzQXBhcmFsbGVsX2NvbXBvc2l0ZV91cGxvYWRfdGhyZXNob2xkJTNEMTUwTSUyMC1tJTIwY3AlMjAtciUyMCUyNExPQ0FMX0RJUiUyRiolMjAlMjRCVUNLRVRfVVJJJTJGJTI0QVJUSUZBQ1RfTkFNRSUwQWZp",highlighted:`%%bash
<span class="hljs-comment"># Upload the model to Google Cloud Storage</span>
LOCAL_DIR=~/.cache/huggingface/hub/models--google--gemma-7b-it/snapshots/8adab6a35fdbcdae0ae41ab1f711b1bc8d05727e
<span class="hljs-keyword">if</span> [ -d <span class="hljs-string">&quot;$LOCAL_DIR&quot;</span> ]; then
    gsutil -o GSUtil:parallel_composite_upload_threshold=150M -m cp -r $LOCAL_DIR/* $BUCKET_URI/$ARTIFACT_NAME
fi`,wrap:!1}}),S=new y({props:{title:"Artifact from Hugging Face Hub",local:"artifact-from-hugging-face-hub",headingTag:"h3"}}),H=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJodWdnaW5nZmFjZV9odWIlNUJoZl90cmFuc2ZlciU1RCUyMiUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:'!pip install <span class="hljs-string">&quot;huggingface_hub[hf_transfer]&quot;</span> --upgrade --quiet',wrap:!1}}),L=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),q=new h({props:{code:"JTI1JTI1YmFzaCUwQSUyMyUyMEVuc3VyZSUyMHRoZSUyMG5lY2Vzc2FyeSUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIwYXJlJTIwc2V0JTBBZXhwb3J0JTIwSEZfSFVCX0VOQUJMRV9IRl9UUkFOU0ZFUiUzRDElMEElMEElMjMlMjAlMjMlMjBDcmVhdGUlMjBhJTIwbG9jYWwlMjBkaXJlY3RvcnklMjB0byUyMHN0b3JlJTIwdGhlJTIwZG93bmxvYWRlZCUyMG1vZGVscyUwQUxPQ0FMX0RJUiUzRCUyMnRtcCUyRmdvb2dsZS0tZ2VtbWEtN2ItaXQlMjIlMEFta2RpciUyMC1wJTIwJTI0TE9DQUxfRElSJTBBJTBBJTIzJTIwJTIzJTIwRG93bmxvYWQlMjBtb2RlbHMlMjBmcm9tJTIwSHVnZ2luZ0ZhY2UlMkMlMjBleGNsdWRpbmclMjBjZXJ0YWluJTIwZmlsZSUyMHR5cGVzJTBBaHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBnb29nbGUlMkZnZW1tYS03Yi1pdCUyMC0tZXhjbHVkZSUyMCUyMiouYmluJTIyJTIwJTIyKi5wdGglMjIlMjAlMjIqLmdndWYlMjIlMjAlMjIuZ2l0YXR0cmlidXRlcyUyMiUyMC0tbG9jYWwtZGlyJTIwJTI0TE9DQUxfRElSJTBBJTBBJTIzJTIwVXBsb2FkJTIwdGhlJTIwZG93bmxvYWRlZCUyMG1vZGVscyUyMHRvJTIwR29vZ2xlJTIwQ2xvdWQlMjBTdG9yYWdlJTBBZ3N1dGlsJTIwLW8lMjBHU1V0aWwlM0FwYXJhbGxlbF9jb21wb3NpdGVfdXBsb2FkX3RocmVzaG9sZCUzRDE1ME0lMjAtbSUyMGNwJTIwLWUlMjAtciUyMCUyNExPQ0FMX0RJUiUyRiolMjAlMjRCVUNLRVRfVVJJJTJGJTI0QVJUSUZBQ1RfTkFNRSUwQSUwQSUyMyUyMFJlbW92ZSUyMGFsbCUyMGZpbGVzJTIwYW5kJTIwaGlkZGVuJTIwZmlsZXMlMjBpbiUyMHRoZSUyMHRhcmdldCUyMGRpcmVjdG9yeSUwQXJtJTIwLXJmJTIwdG1wJTJG",highlighted:`%%bash
<span class="hljs-comment"># Ensure the necessary environment variables are set</span>
export HF_HUB_ENABLE_HF_TRANSFER=<span class="hljs-number">1</span>

<span class="hljs-comment"># # Create a local directory to store the downloaded models</span>
LOCAL_DIR=<span class="hljs-string">&quot;tmp/google--gemma-7b-it&quot;</span>
mkdir -p $LOCAL_DIR

<span class="hljs-comment"># # Download models from HuggingFace, excluding certain file types</span>
huggingface-cli download google/gemma-7b-it --exclude <span class="hljs-string">&quot;*.bin&quot;</span> <span class="hljs-string">&quot;*.pth&quot;</span> <span class="hljs-string">&quot;*.gguf&quot;</span> <span class="hljs-string">&quot;.gitattributes&quot;</span> --local-<span class="hljs-built_in">dir</span> $LOCAL_DIR

<span class="hljs-comment"># Upload the downloaded models to Google Cloud Storage</span>
gsutil -o GSUtil:parallel_composite_upload_threshold=150M -m cp -e -r $LOCAL_DIR/* $BUCKET_URI/$ARTIFACT_NAME

<span class="hljs-comment"># Remove all files and hidden files in the target directory</span>
rm -rf tmp/`,wrap:!1}}),P=new y({props:{title:"Register model on Vertex AI",local:"register-model-on-vertex-ai",headingTag:"h2"}}),K=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBJTIwJTIwJTIwJTIwc3RhZ2luZ19idWNrZXQlM0Rvcy5nZXRlbnYoJTIyQlVDS0VUX1VSSSUyMiklMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
    staging_bucket=os.getenv(<span class="hljs-string">&quot;BUCKET_URI&quot;</span>),
)`,wrap:!1}}),se=new h({props:{code:"bW9kZWwlMjAlM0QlMjBhaXBsYXRmb3JtLk1vZGVsLnVwbG9hZCglMEElMjAlMjAlMjAlMjBkaXNwbGF5X25hbWUlM0QlMjJnb29nbGUtLWdlbW1hLTdiLWl0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJ0aWZhY3RfdXJpJTNEZiUyMiU3Qm9zLmdldGVudignQlVDS0VUX1VSSScpJTdEJTJGJTdCb3MuZ2V0ZW52KCdBUlRJRkFDVF9OQU1FJyklN0QlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9pbWFnZV91cmklM0Rvcy5nZXRlbnYoJTIyQ09OVEFJTkVSX1VSSSUyMiklMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9lbnZpcm9ubWVudF92YXJpYWJsZXMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOVU1fU0hBUkQlMjIlM0ElMjAlMjIxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX1RPS0VOUyUyMiUzQSUyMCUyMjUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1BWF9UT1RBTF9UT0tFTlMlMjIlM0ElMjAlMjIxMDI0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0JBVENIX1BSRUZJTExfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX3BvcnRzJTNEJTVCODA4MCU1RCUyQyUwQSklMEFtb2RlbC53YWl0KCk=",highlighted:`model = aiplatform.Model.upload(
    display_name=<span class="hljs-string">&quot;google--gemma-7b-it&quot;</span>,
    artifact_uri=<span class="hljs-string">f&quot;<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;BUCKET_URI&#x27;</span>)}</span>/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;ARTIFACT_NAME&#x27;</span>)}</span>&quot;</span>,
    serving_container_image_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    serving_container_environment_variables={
        <span class="hljs-string">&quot;NUM_SHARD&quot;</span>: <span class="hljs-string">&quot;1&quot;</span>,
        <span class="hljs-string">&quot;MAX_INPUT_TOKENS&quot;</span>: <span class="hljs-string">&quot;512&quot;</span>,
        <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
        <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
    },
    serving_container_ports=[<span class="hljs-number">8080</span>],
)
model.wait()`,wrap:!1}}),ie=new y({props:{title:"Deploy model on Vertex AI",local:"deploy-model-on-vertex-ai",headingTag:"h2"}}),ce=new h({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBhaXBsYXRmb3JtLkVuZHBvaW50LmNyZWF0ZShkaXNwbGF5X25hbWUlM0QlMjJnb29nbGUtLWdlbW1hLTdiLWl0LWVuZHBvaW50JTIyKQ==",highlighted:'endpoint = aiplatform.Endpoint.create(display_name=<span class="hljs-string">&quot;google--gemma-7b-it-endpoint&quot;</span>)',wrap:!1}}),Te=new h({props:{code:"ZGVwbG95ZWRfbW9kZWwlMjAlM0QlMjBtb2RlbC5kZXBsb3koJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0RlbmRwb2ludCUyQyUwQSUyMCUyMCUyMCUyMG1hY2hpbmVfdHlwZSUzRCUyMmcyLXN0YW5kYXJkLTQlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl90eXBlJTNEJTIyTlZJRElBX0w0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3JfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`deployed_model = model.deploy(
    endpoint=endpoint,
    machine_type=<span class="hljs-string">&quot;g2-standard-4&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_L4&quot;</span>,
    accelerator_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),Ue=new y({props:{title:"Online predictions on Vertex AI",local:"online-predictions-on-vertex-ai",headingTag:"h2"}}),fe=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwdHJhbnNmb3JtZXJz",highlighted:"!pip install --upgrade --quiet transformers",wrap:!1}}),Ce=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtN2ItaXQlMjIlMkMlMjB0b2tlbiUzRGdldF90b2tlbigpKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCdzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTdEJTJDJTBBJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUwQSklMEElMjMlMjAlM0Nib3MlM0UlM0NzdGFydF9vZl90dXJuJTNFdXNlciU1Q25XaGF0J3MlMjBEZWVwJTIwTGVhcm5pbmclM0YlM0NlbmRfb2ZfdHVybiUzRSU1Q24lM0NzdGFydF9vZl90dXJuJTNFbW9kZWwlNUNu",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-7b-it&quot;</span>, token=get_token())

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s Deep Learning?&quot;</span>},
]

inputs = tokenizer.apply_chat_template(
    messages,
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
)
<span class="hljs-comment"># &lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n</span>`,wrap:!1}}),ve=new y({props:{title:"Via Python",local:"via-python",headingTag:"h3"}}),Ge=new y({props:{title:"Within the same session",local:"within-the-same-session",headingTag:"h4"}}),Be=new h({props:{code:"b3V0cHV0JTIwJTNEJTIwZGVwbG95ZWRfbW9kZWwucHJlZGljdCglMEElMjAlMjAlMjAlMjBpbnN0YW5jZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnB1dHMlMjIlM0ElMjAlMjIlM0Nib3MlM0UlM0NzdGFydF9vZl90dXJuJTNFdXNlciU1Q25XaGF0J3MlMjBEZWVwJTIwTGVhcm5pbmclM0YlM0NlbmRfb2ZfdHVybiUzRSU1Q24lM0NzdGFydF9vZl90dXJuJTNFbW9kZWwlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1ldGVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRvcF9wJTIyJTNBJTIwMC45NSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQXByaW50KG91dHB1dC5wcmVkaWN0aW9ucyU1QjAlNUQp",highlighted:`output = deployed_model.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">256</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>,
            },
        },
    ]
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),xe=new h({props:{code:"UHJlZGljdGlvbihwcmVkaWN0aW9ucyUzRCU1QiclNUNuJTVDbkRlZXAlMjBsZWFybmluZyUyMGlzJTIwYSUyMHR5cGUlMjBvZiUyMG1hY2hpbmUlMjBsZWFybmluZyUyMHRoYXQlMjB1c2VzJTIwYXJ0aWZpY2lhbCUyMG5ldXJhbCUyMG5ldHdvcmtzJTIwdG8lMjBsZWFybiUyMGZyb20lMjBsYXJnZSUyMGFtb3VudHMlMjBvZiUyMGRhdGElMkMlMjBtYWtpbmclMjBpdCUyMGElMjBwb3dlcmZ1bCUyMHRvb2wlMjBmb3IlMjB2YXJpb3VzJTIwdGFza3MlMkMlMjBpbmNsdWRpbmclMjBpbWFnZSUyMHJlY29nbml0aW9uJTJDJTIwbmF0dXJhbCUyMGxhbmd1YWdlJTIwcHJvY2Vzc2luZyUyQyUyMGFuZCUyMHNwZWVjaCUyMHJlY29nbml0aW9uLiU1Q24lNUNuKipLZXklMjBDb25jZXB0cyUzQSoqJTVDbiU1Q24qJTIwKipBcnRpZmljaWFsJTIwTmV1cmFsJTIwTmV0d29ya3MlMjAoQU5OcyklM0EqKiUyMFN0cnVjdHVyZXMlMjB0aGF0JTIwbWltaWMlMjB0aGUlMjBpbnRlcmNvbm5lY3RlZCUyMG5ldXJvbnMlMjBpbiUyMHRoZSUyMGJyYWluLiU1Q24qJTIwKipEZWVwJTIwTGVhcm5pbmclMjBBcmNoaXRlY3R1cmVzJTNBKiolMjBNdWx0aS1sYXllcmVkJTIwQU5OcyUyMHRoYXQlMjBsZWFybiUyMGhpZXJhcmNoaWNhbCUyMGZlYXR1cmVzJTIwZnJvbSUyMGRhdGEuJTVDbiolMjAqKlRyYW5zZmVyJTIwTGVhcm5pbmclM0EqKiUyMFJldXNpbmclMjBsZWFybmVkJTIwZmVhdHVyZXMlMjBmcm9tJTIwb25lJTIwdGFzayUyMHRvJTIwaW1wcm92ZSUyMHBlcmZvcm1hbmNlJTIwb24lMjBhbm90aGVyLiU1Q24lNUNuKipUeXBlcyUyMG9mJTIwRGVlcCUyMExlYXJuaW5nJTNBKiolNUNuJTVDbiolMjAqKlN1cGVydmlzZWQlMjBMZWFybmluZyUzQSoqJTIwTW9kZWxzJTIwYXJlJTIwdHJhaW5lZCUyMG9uJTIwbGFiZWxlZCUyMGRhdGElMkMlMjB3aGVyZSUyMGlucHV0cyUyMGFyZSUyMHBhaXJlZCUyMHdpdGglMjBjb3JyZXNwb25kaW5nJTIwb3V0cHV0cy4lNUNuKiUyMCoqVW5zdXBlcnZpc2VkJTIwTGVhcm5pbmclM0EqKiUyME1vZGVscyUyMGxlYXJuJTIwcGF0dGVybnMlMjBmcm9tJTIwdW5sYWJlbGVkJTIwZGF0YSUyQyUyMHN1Y2glMjBhcyUyMGNsdXN0ZXJpbmclMjBvciUyMGRpbWVuc2lvbmFsaXR5JTIwcmVkdWN0aW9uLiU1Q24qJTIwKipSZWluZm9yY2VtZW50JTIwTGVhcm5pbmclM0EqKiUyME1vZGVscyUyMGxlYXJuJTIwdGhyb3VnaCUyMHRyaWFsLWFuZC1lcnJvciUyMGJ5JTIwaW50ZXJhY3RpbmclMjB3aXRoJTIwYW4lMjBlbnZpcm9ubWVudCUyMHRvJTIwb3B0aW1pemUlMjBhJTIwdGFzay4lNUNuJTVDbioqQmVuZWZpdHMlM0EqKiU1Q24lNUNuKiUyMCoqSGlnaCUyMEFjY3VyYWN5JTNBKiolMjBEZWVwJTIwbGVhcm5pbmclMjBtb2RlbHMlMjBjYW4lMjBhY2hpZXZlJTIwaGlnaCUyMGFjY3VyYWN5JTIwb24lMjBjb21wbGV4JTIwdGFza3MuJTVDbiolMjAqKkFkYXB0YWJpbGl0eSUzQSoqJTIwRGVlcCUyMGxlYXJuaW5nJTIwbW9kZWxzJTIwY2FuJTIwYWRhcHQlMjB0byUyMG5ldyUyMGRhdGElMjBhbmQlMjB0YXNrcy4lNUNuKiUyMCoqU2NhbGFiaWxpdHklM0EqKiUyMERlZXAlMjBsZWFybmluZyUyMG1vZGVscyUyMGNhbiUyMGhhbmRsZSUyMGxhcmdlJTIwYW1vdW50cyUyMG9mJTIwZGF0YS4lNUNuJTVDbioqQXBwbGljYXRpb25zJTNBKiolNUNuJTVDbiolMjBJbWFnZSUyMHJlY29nbml0aW9uJTVDbiolMjBOYXR1cmFsJTIwbGFuZ3VhZ2UlMjBwcm9jZXNzaW5nJTIwKE5MUCklNUNuJyU1RCUyQyUyMGRlcGxveWVkX21vZGVsX2lkJTNEJyoqKiclMkMlMjBtZXRhZGF0YSUzRE5vbmUlMkMlMjBtb2RlbF92ZXJzaW9uX2lkJTNEJzEnJTJDJTIwbW9kZWxfcmVzb3VyY2VfbmFtZSUzRCdwcm9qZWN0cyUyRioqKiUyRmxvY2F0aW9ucyUyRnVzLWNlbnRyYWwxJTJGbW9kZWxzJTJGKioqJyUyQyUyMGV4cGxhbmF0aW9ucyUzRE5vbmUp",highlighted:'<span class="hljs-constructor">Prediction(<span class="hljs-params">predictions</span>=[&#x27;\\<span class="hljs-params">n</span>\\<span class="hljs-params">nDeep</span> <span class="hljs-params">learning</span> <span class="hljs-params">is</span> <span class="hljs-params">a</span> <span class="hljs-params">type</span> <span class="hljs-params">of</span> <span class="hljs-params">machine</span> <span class="hljs-params">learning</span> <span class="hljs-params">that</span> <span class="hljs-params">uses</span> <span class="hljs-params">artificial</span> <span class="hljs-params">neural</span> <span class="hljs-params">networks</span> <span class="hljs-params">to</span> <span class="hljs-params">learn</span> <span class="hljs-params">from</span> <span class="hljs-params">large</span> <span class="hljs-params">amounts</span> <span class="hljs-params">of</span> <span class="hljs-params">data</span>, <span class="hljs-params">making</span> <span class="hljs-params">it</span> <span class="hljs-params">a</span> <span class="hljs-params">powerful</span> <span class="hljs-params">tool</span> <span class="hljs-params">for</span> <span class="hljs-params">various</span> <span class="hljs-params">tasks</span>, <span class="hljs-params">including</span> <span class="hljs-params">image</span> <span class="hljs-params">recognition</span>, <span class="hljs-params">natural</span> <span class="hljs-params">language</span> <span class="hljs-params">processing</span>, <span class="hljs-params">and</span> <span class="hljs-params">speech</span> <span class="hljs-params">recognition</span>.\\<span class="hljs-params">n</span>\\<span class="hljs-params">n</span><span class="hljs-operator">**</span>Key Concepts:<span class="hljs-operator">**</span>\\<span class="hljs-params">n</span>\\<span class="hljs-params">n</span><span class="hljs-operator">*</span> <span class="hljs-operator">**</span>Artificial Neural Networks (ANNs)</span>:** Structures that mimic the interconnected neurons <span class="hljs-keyword">in</span> the brain.\\n* **Deep Learning Architectures:** Multi-layered ANNs that learn hierarchical features from data.\\n* **Transfer Learning:** Reusing learned features from one task <span class="hljs-keyword">to</span> improve performance on another.\\n\\n**Types <span class="hljs-keyword">of</span> Deep Learning:**\\n\\n* **Supervised Learning:** Models are trained on labeled data, where inputs are paired <span class="hljs-keyword">with</span> corresponding outputs.\\n* **Unsupervised Learning:** Models learn patterns from unlabeled data, such <span class="hljs-keyword">as</span> clustering <span class="hljs-keyword">or</span> dimensionality reduction.\\n* **Reinforcement Learning:** Models learn through trial-<span class="hljs-keyword">and</span>-error by interacting <span class="hljs-keyword">with</span> an environment <span class="hljs-keyword">to</span> optimize a task.\\n\\n**Benefits:**\\n\\n* **High Accuracy:** Deep learning models can achieve high accuracy on complex tasks.\\n* **Adaptability:** Deep learning models can adapt <span class="hljs-keyword">to</span> <span class="hljs-keyword">new</span> data <span class="hljs-keyword">and</span> tasks.\\n* **Scalability:** Deep learning models can handle large amounts <span class="hljs-keyword">of</span> data.\\n\\n**Applications:**\\n\\n* Image recognition\\n* Natural language processing (NLP)\\n&#x27;], deployed_model_id=&#x27;***&#x27;, metadata=None, model_version_id=<span class="hljs-character">&#x27;1&#x27;</span>, model_resource_name=&#x27;projects<span class="hljs-comment">/***/</span>locations/us-central1/models<span class="hljs-comment">/***&#x27;, explanations=None)</span>',wrap:!1}}),Re=new y({props:{title:"From a different session",local:"from-a-different-session",headingTag:"h4"}}),We=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>), location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>))

endpoint_display_name = <span class="hljs-string">&quot;google--gemma-7b-it-endpoint&quot;</span>  <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> change to your endpoint display name</span>

<span class="hljs-comment"># Iterates over all the Vertex AI Endpoints within the current project and keeps the first match (if any), otherwise set to None</span>
ENDPOINT_ID = <span class="hljs-built_in">next</span>(
    (endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> aiplatform.Endpoint.<span class="hljs-built_in">list</span>() <span class="hljs-keyword">if</span> endpoint.display_name == endpoint_display_name), <span class="hljs-literal">None</span>
)
<span class="hljs-keyword">assert</span> ENDPOINT_ID, (
    <span class="hljs-string">&quot;\`ENDPOINT_ID\` is not set, please make sure that the \`endpoint_display_name\` is correct at &quot;</span>
    <span class="hljs-string">f&quot;https://console.cloud.google.com/vertex-ai/online-prediction/endpoints?project=<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>&quot;</span>
)

endpoint = aiplatform.Endpoint(
    <span class="hljs-string">f&quot;projects/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>/locations/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_ID}</span>&quot;</span>
)
output = endpoint.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
            },
        },
    ],
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),Ne=new y({props:{title:"Via the Vertex AI Online Prediction UI",local:"via-the-vertex-ai-online-prediction-ui",headingTag:"h3"}}),Xe=new h({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5zdGFuY2VzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTNDYm9zJTNFJTNDc3RhcnRfb2ZfdHVybiUzRXVzZXIlNUNuV2hhdCdzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTNDZW5kX29mX3R1cm4lM0UlNUNuJTNDc3RhcnRfb2ZfdHVybiUzRW1vZGVsJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEyOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3BfcCUyMiUzQSUyMDAuOTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDAuNyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;instances&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;max_new_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;do_sample&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;top_p&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.95</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;temperature&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.7</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Se=new y({props:{title:"Resource clean-up",local:"resource-clean-up",headingTag:"h2"}}),Le=new h({props:{code:"ZGVwbG95ZWRfbW9kZWwudW5kZXBsb3lfYWxsKCklMEFkZXBsb3llZF9tb2RlbC5kZWxldGUoKSUwQW1vZGVsLmRlbGV0ZSgp",highlighted:`deployed_model.undeploy_all()
deployed_model.delete()
model.delete()`,wrap:!1}}),De=new h({props:{code:"IWdjbG91ZCUyMHN0b3JhZ2UlMjBybSUyMC1yJTIwJTI0QlVDS0VUX1VSSQ==",highlighted:"!gcloud storage rm -r $BUCKET_URI",wrap:!1}}),Oe=new zn({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-deploy-gemma-from-gcs-on-vertex-ai.mdx"}}),{c(){T=o("meta"),tt=s(),Ke=o("p"),lt=s(),r(J.$$.fragment),nt=s(),w=o("p"),w.textContent=Xl,st=s(),g=o("p"),g.innerHTML=El,at=s(),U=o("p"),U.innerHTML=Sl,ot=s(),r(j.$$.fragment),it=s(),b=o("p"),b.innerHTML=Fl,pt=s(),f=o("p"),f.innerHTML=Ql,rt=s(),r(I.$$.fragment),ct=s(),C=o("p"),C.textContent=Hl,Mt=s(),r(Z.$$.fragment),dt=s(),v=o("p"),v.textContent=Ll,mt=s(),r(G.$$.fragment),ut=s(),A=o("p"),A.textContent=Yl,ht=s(),r(B.$$.fragment),yt=s(),r(V.$$.fragment),Tt=s(),x=o("p"),x.textContent=ql,Jt=s(),R=o("p"),R.innerHTML=zl,wt=s(),r(k.$$.fragment),gt=s(),$=o("p"),$.textContent=Dl,Ut=s(),r(W.$$.fragment),jt=s(),N=o("p"),N.innerHTML=Pl,bt=s(),r(_.$$.fragment),ft=s(),X=o("p"),X.innerHTML=Ol,It=s(),r(E.$$.fragment),Ct=s(),r(S.$$.fragment),Zt=s(),F=o("p"),F.innerHTML=Kl,vt=s(),Q=o("p"),Q.innerHTML=en,Gt=s(),r(H.$$.fragment),At=s(),r(L.$$.fragment),Bt=s(),Y=o("p"),Y.innerHTML=tn,Vt=s(),r(q.$$.fragment),xt=s(),z=o("p"),z.innerHTML=ln,Rt=s(),D=o("p"),D.innerHTML=nn,kt=s(),r(P.$$.fragment),$t=s(),O=o("p"),O.innerHTML=sn,Wt=s(),r(K.$$.fragment),Nt=s(),ee=o("p"),ee.textContent=an,_t=s(),te=o("p"),te.innerHTML=on,Xt=s(),le=o("ul"),le.innerHTML=pn,Et=s(),ne=o("p"),ne.innerHTML=rn,St=s(),r(se.$$.fragment),Ft=s(),ae=o("p"),ae.innerHTML=cn,Qt=s(),oe=o("p"),oe.innerHTML=Mn,Ht=s(),r(ie.$$.fragment),Lt=s(),pe=o("p"),pe.textContent=dn,Yt=s(),re=o("p"),re.innerHTML=mn,qt=s(),r(ce.$$.fragment),zt=s(),Me=o("p"),Me.innerHTML=un,Dt=s(),de=o("p"),de.textContent=hn,Pt=s(),me=o("p"),me.innerHTML=yn,Ot=s(),ue=o("p"),ue.innerHTML=Tn,Kt=s(),he=o("ul"),he.innerHTML=Jn,el=s(),ye=o("p"),ye.innerHTML=wn,tl=s(),r(Te.$$.fragment),ll=s(),Je=o("p"),Je.innerHTML=gn,nl=s(),we=o("p"),we.innerHTML=Un,sl=s(),ge=o("p"),ge.innerHTML=jn,al=s(),r(Ue.$$.fragment),ol=s(),je=o("p"),je.innerHTML=bn,il=s(),be=o("p"),be.innerHTML=fn,pl=s(),r(fe.$$.fragment),rl=s(),Ie=o("p"),Ie.textContent=In,cl=s(),r(Ce.$$.fragment),Ml=s(),Ze=o("p"),Ze.innerHTML=Cn,dl=s(),r(ve.$$.fragment),ml=s(),r(Ge.$$.fragment),ul=s(),Ae=o("p"),Ae.innerHTML=Zn,hl=s(),r(Be.$$.fragment),yl=s(),Ve=o("p"),Ve.innerHTML=vn,Tl=s(),r(xe.$$.fragment),Jl=s(),r(Re.$$.fragment),wl=s(),ke=o("p"),ke.innerHTML=Gn,gl=s(),$e=o("p"),$e.innerHTML=An,Ul=s(),r(We.$$.fragment),jl=s(),r(Ne.$$.fragment),bl=s(),_e=o("p"),_e.textContent=Bn,fl=s(),r(Xe.$$.fragment),Il=s(),Ee=o("p"),Ee.innerHTML=Vn,Cl=s(),r(Se.$$.fragment),Zl=s(),Fe=o("p"),Fe.textContent=xn,vl=s(),Qe=o("ul"),Qe.innerHTML=Rn,Gl=s(),He=o("p"),He.textContent=kn,Al=s(),r(Le.$$.fragment),Bl=s(),Ye=o("p"),Ye.textContent=$n,Vl=s(),qe=o("ul"),qe.innerHTML=Wn,xl=s(),ze=o("p"),ze.innerHTML=Nn,Rl=s(),r(De.$$.fragment),kl=s(),Pe=o("p"),Pe.textContent=_n,$l=s(),r(Oe.$$.fragment),Wl=s(),et=o("p"),this.h()},l(e){const t=Yn("svelte-u9bgzb",document.head);T=i(t,"META",{name:!0,content:!0}),t.forEach(l),tt=a(e),Ke=i(e,"P",{}),Xn(Ke).forEach(l),lt=a(e),c(J.$$.fragment,e),nt=a(e),w=i(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-9afh3f"&&(w.textContent=Xl),st=a(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-ghxzxz"&&(g.innerHTML=El),at=a(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1tfb3hf"&&(U.innerHTML=Sl),ot=a(e),c(j.$$.fragment,e),it=a(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1o67gfb"&&(b.innerHTML=Fl),pt=a(e),f=i(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1ebrquh"&&(f.innerHTML=Ql),rt=a(e),c(I.$$.fragment,e),ct=a(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1i8n6rq"&&(C.textContent=Hl),Mt=a(e),c(Z.$$.fragment,e),dt=a(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-15nvzfz"&&(v.textContent=Ll),mt=a(e),c(G.$$.fragment,e),ut=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1nm8o2l"&&(A.textContent=Yl),ht=a(e),c(B.$$.fragment,e),yt=a(e),c(V.$$.fragment,e),Tt=a(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1ytajks"&&(x.textContent=ql),Jt=a(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-e12o6k"&&(R.innerHTML=zl),wt=a(e),c(k.$$.fragment,e),gt=a(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-cxcyab"&&($.textContent=Dl),Ut=a(e),c(W.$$.fragment,e),jt=a(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-d11vo2"&&(N.innerHTML=Pl),bt=a(e),c(_.$$.fragment,e),ft=a(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-sdydm2"&&(X.innerHTML=Ol),It=a(e),c(E.$$.fragment,e),Ct=a(e),c(S.$$.fragment,e),Zt=a(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-p7l1hu"&&(F.innerHTML=Kl),vt=a(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1c2zn5r"&&(Q.innerHTML=en),Gt=a(e),c(H.$$.fragment,e),At=a(e),c(L.$$.fragment,e),Bt=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1mqzlv7"&&(Y.innerHTML=tn),Vt=a(e),c(q.$$.fragment,e),xt=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1nja5im"&&(z.innerHTML=ln),Rt=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1kl2jg3"&&(D.innerHTML=nn),kt=a(e),c(P.$$.fragment,e),$t=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-14aynbe"&&(O.innerHTML=sn),Wt=a(e),c(K.$$.fragment,e),Nt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-nto2bx"&&(ee.textContent=an),_t=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-zklutt"&&(te.innerHTML=on),Xt=a(e),le=i(e,"UL",{"data-svelte-h":!0}),p(le)!=="svelte-1fb4x93"&&(le.innerHTML=pn),Et=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1flszm1"&&(ne.innerHTML=rn),St=a(e),c(se.$$.fragment,e),Ft=a(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-wh1hoy"&&(ae.innerHTML=cn),Qt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1qp0mlv"&&(oe.innerHTML=Mn),Ht=a(e),c(ie.$$.fragment,e),Lt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-2nwexf"&&(pe.textContent=dn),Yt=a(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1lovlvw"&&(re.innerHTML=mn),qt=a(e),c(ce.$$.fragment,e),zt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1oxifpd"&&(Me.innerHTML=un),Dt=a(e),de=i(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-it668a"&&(de.textContent=hn),Pt=a(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-njbdvc"&&(me.innerHTML=yn),Ot=a(e),ue=i(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-v5hhrl"&&(ue.innerHTML=Tn),Kt=a(e),he=i(e,"UL",{"data-svelte-h":!0}),p(he)!=="svelte-1mv29i5"&&(he.innerHTML=Jn),el=a(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-9p37qa"&&(ye.innerHTML=wn),tl=a(e),c(Te.$$.fragment,e),ll=a(e),Je=i(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-mraq68"&&(Je.innerHTML=gn),nl=a(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-10wybi0"&&(we.innerHTML=Un),sl=a(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-ffexfv"&&(ge.innerHTML=jn),al=a(e),c(Ue.$$.fragment,e),ol=a(e),je=i(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-166ya0u"&&(je.innerHTML=bn),il=a(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-17alodq"&&(be.innerHTML=fn),pl=a(e),c(fe.$$.fragment,e),rl=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-rj4r5t"&&(Ie.textContent=In),cl=a(e),c(Ce.$$.fragment,e),Ml=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-nq4b4r"&&(Ze.innerHTML=Cn),dl=a(e),c(ve.$$.fragment,e),ml=a(e),c(Ge.$$.fragment,e),ul=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-hnmp6i"&&(Ae.innerHTML=Zn),hl=a(e),c(Be.$$.fragment,e),yl=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-d9pmg3"&&(Ve.innerHTML=vn),Tl=a(e),c(xe.$$.fragment,e),Jl=a(e),c(Re.$$.fragment,e),wl=a(e),ke=i(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-gm5hxo"&&(ke.innerHTML=Gn),gl=a(e),$e=i(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1f4v83r"&&($e.innerHTML=An),Ul=a(e),c(We.$$.fragment,e),jl=a(e),c(Ne.$$.fragment,e),bl=a(e),_e=i(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1ajbcx5"&&(_e.textContent=Bn),fl=a(e),c(Xe.$$.fragment,e),Il=a(e),Ee=i(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-13ph86t"&&(Ee.innerHTML=Vn),Cl=a(e),c(Se.$$.fragment,e),Zl=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-l6tvv1"&&(Fe.textContent=xn),vl=a(e),Qe=i(e,"UL",{"data-svelte-h":!0}),p(Qe)!=="svelte-16ibgml"&&(Qe.innerHTML=Rn),Gl=a(e),He=i(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-8ld85z"&&(He.textContent=kn),Al=a(e),c(Le.$$.fragment,e),Bl=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-sgegyq"&&(Ye.textContent=$n),Vl=a(e),qe=i(e,"UL",{"data-svelte-h":!0}),p(qe)!=="svelte-1p833nz"&&(qe.innerHTML=Wn),xl=a(e),ze=i(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1akxsu0"&&(ze.innerHTML=Nn),Rl=a(e),c(De.$$.fragment,e),kl=a(e),Pe=i(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-s495iv"&&(Pe.textContent=_n),$l=a(e),c(Oe.$$.fragment,e),Wl=a(e),et=i(e,"P",{}),Xn(et).forEach(l),this.h()},h(){En(T,"name","hf:doc:metadata"),En(T,"content",Pn)},m(e,t){qn(document.head,T),n(e,tt,t),n(e,Ke,t),n(e,lt,t),M(J,e,t),n(e,nt,t),n(e,w,t),n(e,st,t),n(e,g,t),n(e,at,t),n(e,U,t),n(e,ot,t),M(j,e,t),n(e,it,t),n(e,b,t),n(e,pt,t),n(e,f,t),n(e,rt,t),M(I,e,t),n(e,ct,t),n(e,C,t),n(e,Mt,t),M(Z,e,t),n(e,dt,t),n(e,v,t),n(e,mt,t),M(G,e,t),n(e,ut,t),n(e,A,t),n(e,ht,t),M(B,e,t),n(e,yt,t),M(V,e,t),n(e,Tt,t),n(e,x,t),n(e,Jt,t),n(e,R,t),n(e,wt,t),M(k,e,t),n(e,gt,t),n(e,$,t),n(e,Ut,t),M(W,e,t),n(e,jt,t),n(e,N,t),n(e,bt,t),M(_,e,t),n(e,ft,t),n(e,X,t),n(e,It,t),M(E,e,t),n(e,Ct,t),M(S,e,t),n(e,Zt,t),n(e,F,t),n(e,vt,t),n(e,Q,t),n(e,Gt,t),M(H,e,t),n(e,At,t),M(L,e,t),n(e,Bt,t),n(e,Y,t),n(e,Vt,t),M(q,e,t),n(e,xt,t),n(e,z,t),n(e,Rt,t),n(e,D,t),n(e,kt,t),M(P,e,t),n(e,$t,t),n(e,O,t),n(e,Wt,t),M(K,e,t),n(e,Nt,t),n(e,ee,t),n(e,_t,t),n(e,te,t),n(e,Xt,t),n(e,le,t),n(e,Et,t),n(e,ne,t),n(e,St,t),M(se,e,t),n(e,Ft,t),n(e,ae,t),n(e,Qt,t),n(e,oe,t),n(e,Ht,t),M(ie,e,t),n(e,Lt,t),n(e,pe,t),n(e,Yt,t),n(e,re,t),n(e,qt,t),M(ce,e,t),n(e,zt,t),n(e,Me,t),n(e,Dt,t),n(e,de,t),n(e,Pt,t),n(e,me,t),n(e,Ot,t),n(e,ue,t),n(e,Kt,t),n(e,he,t),n(e,el,t),n(e,ye,t),n(e,tl,t),M(Te,e,t),n(e,ll,t),n(e,Je,t),n(e,nl,t),n(e,we,t),n(e,sl,t),n(e,ge,t),n(e,al,t),M(Ue,e,t),n(e,ol,t),n(e,je,t),n(e,il,t),n(e,be,t),n(e,pl,t),M(fe,e,t),n(e,rl,t),n(e,Ie,t),n(e,cl,t),M(Ce,e,t),n(e,Ml,t),n(e,Ze,t),n(e,dl,t),M(ve,e,t),n(e,ml,t),M(Ge,e,t),n(e,ul,t),n(e,Ae,t),n(e,hl,t),M(Be,e,t),n(e,yl,t),n(e,Ve,t),n(e,Tl,t),M(xe,e,t),n(e,Jl,t),M(Re,e,t),n(e,wl,t),n(e,ke,t),n(e,gl,t),n(e,$e,t),n(e,Ul,t),M(We,e,t),n(e,jl,t),M(Ne,e,t),n(e,bl,t),n(e,_e,t),n(e,fl,t),M(Xe,e,t),n(e,Il,t),n(e,Ee,t),n(e,Cl,t),M(Se,e,t),n(e,Zl,t),n(e,Fe,t),n(e,vl,t),n(e,Qe,t),n(e,Gl,t),n(e,He,t),n(e,Al,t),M(Le,e,t),n(e,Bl,t),n(e,Ye,t),n(e,Vl,t),n(e,qe,t),n(e,xl,t),n(e,ze,t),n(e,Rl,t),M(De,e,t),n(e,kl,t),n(e,Pe,t),n(e,$l,t),M(Oe,e,t),n(e,Wl,t),n(e,et,t),Nl=!0},p:Fn,i(e){Nl||(d(J.$$.fragment,e),d(j.$$.fragment,e),d(I.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(B.$$.fragment,e),d(V.$$.fragment,e),d(k.$$.fragment,e),d(W.$$.fragment,e),d(_.$$.fragment,e),d(E.$$.fragment,e),d(S.$$.fragment,e),d(H.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),d(ce.$$.fragment,e),d(Te.$$.fragment,e),d(Ue.$$.fragment,e),d(fe.$$.fragment,e),d(Ce.$$.fragment,e),d(ve.$$.fragment,e),d(Ge.$$.fragment,e),d(Be.$$.fragment,e),d(xe.$$.fragment,e),d(Re.$$.fragment,e),d(We.$$.fragment,e),d(Ne.$$.fragment,e),d(Xe.$$.fragment,e),d(Se.$$.fragment,e),d(Le.$$.fragment,e),d(De.$$.fragment,e),d(Oe.$$.fragment,e),Nl=!0)},o(e){m(J.$$.fragment,e),m(j.$$.fragment,e),m(I.$$.fragment,e),m(Z.$$.fragment,e),m(G.$$.fragment,e),m(B.$$.fragment,e),m(V.$$.fragment,e),m(k.$$.fragment,e),m(W.$$.fragment,e),m(_.$$.fragment,e),m(E.$$.fragment,e),m(S.$$.fragment,e),m(H.$$.fragment,e),m(L.$$.fragment,e),m(q.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(se.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),m(Te.$$.fragment,e),m(Ue.$$.fragment,e),m(fe.$$.fragment,e),m(Ce.$$.fragment,e),m(ve.$$.fragment,e),m(Ge.$$.fragment,e),m(Be.$$.fragment,e),m(xe.$$.fragment,e),m(Re.$$.fragment,e),m(We.$$.fragment,e),m(Ne.$$.fragment,e),m(Xe.$$.fragment,e),m(Se.$$.fragment,e),m(Le.$$.fragment,e),m(De.$$.fragment,e),m(Oe.$$.fragment,e),Nl=!1},d(e){e&&(l(tt),l(Ke),l(lt),l(nt),l(w),l(st),l(g),l(at),l(U),l(ot),l(it),l(b),l(pt),l(f),l(rt),l(ct),l(C),l(Mt),l(dt),l(v),l(mt),l(ut),l(A),l(ht),l(yt),l(Tt),l(x),l(Jt),l(R),l(wt),l(gt),l($),l(Ut),l(jt),l(N),l(bt),l(ft),l(X),l(It),l(Ct),l(Zt),l(F),l(vt),l(Q),l(Gt),l(At),l(Bt),l(Y),l(Vt),l(xt),l(z),l(Rt),l(D),l(kt),l($t),l(O),l(Wt),l(Nt),l(ee),l(_t),l(te),l(Xt),l(le),l(Et),l(ne),l(St),l(Ft),l(ae),l(Qt),l(oe),l(Ht),l(Lt),l(pe),l(Yt),l(re),l(qt),l(zt),l(Me),l(Dt),l(de),l(Pt),l(me),l(Ot),l(ue),l(Kt),l(he),l(el),l(ye),l(tl),l(ll),l(Je),l(nl),l(we),l(sl),l(ge),l(al),l(ol),l(je),l(il),l(be),l(pl),l(rl),l(Ie),l(cl),l(Ml),l(Ze),l(dl),l(ml),l(ul),l(Ae),l(hl),l(yl),l(Ve),l(Tl),l(Jl),l(wl),l(ke),l(gl),l($e),l(Ul),l(jl),l(bl),l(_e),l(fl),l(Il),l(Ee),l(Cl),l(Zl),l(Fe),l(vl),l(Qe),l(Gl),l(He),l(Al),l(Bl),l(Ye),l(Vl),l(qe),l(xl),l(ze),l(Rl),l(kl),l(Pe),l($l),l(Wl),l(et)),l(T),u(J,e),u(j,e),u(I,e),u(Z,e),u(G,e),u(B,e),u(V,e),u(k,e),u(W,e),u(_,e),u(E,e),u(S,e),u(H,e),u(L,e),u(q,e),u(P,e),u(K,e),u(se,e),u(ie,e),u(ce,e),u(Te,e),u(Ue,e),u(fe,e),u(Ce,e),u(ve,e),u(Ge,e),u(Be,e),u(xe,e),u(Re,e),u(We,e),u(Ne,e),u(Xe,e),u(Se,e),u(Le,e),u(De,e),u(Oe,e)}}}const Pn='{"title":"Deploy Gemma 7B from GCS with TGI on Vertex AI","local":"deploy-gemma-7b-from-gcs-with-tgi-on-vertex-ai","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Optional: Create bucket and upload model from Hub in GCS","local":"optional-create-bucket-and-upload-model-from-hub-in-gcs","sections":[{"title":"Artifact from disk / local storage","local":"artifact-from-disk--local-storage","sections":[],"depth":3},{"title":"Artifact from Hugging Face Hub","local":"artifact-from-hugging-face-hub","sections":[],"depth":3}],"depth":2},{"title":"Register model on Vertex AI","local":"register-model-on-vertex-ai","sections":[],"depth":2},{"title":"Deploy model on Vertex AI","local":"deploy-model-on-vertex-ai","sections":[],"depth":2},{"title":"Online predictions on Vertex AI","local":"online-predictions-on-vertex-ai","sections":[{"title":"Via Python","local":"via-python","sections":[{"title":"Within the same session","local":"within-the-same-session","sections":[],"depth":4},{"title":"From a different session","local":"from-a-different-session","sections":[],"depth":4}],"depth":3},{"title":"Via the Vertex AI Online Prediction UI","local":"via-the-vertex-ai-online-prediction-ui","sections":[],"depth":3}],"depth":2},{"title":"Resource clean-up","local":"resource-clean-up","sections":[],"depth":2}],"depth":1}';function On(_l){return Qn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends Hn{constructor(T){super(),Ln(this,T,On,Dn,Sn,{})}}export{ns as component};
