import{s as Pt,n as St,o as Xt}from"../chunks/scheduler.b108d059.js";import{S as Ft,i as Dt,g as s,s as o,r as d,A as Yt,h as a,f as l,c as i,j as Nt,u as p,x as r,k as Qt,y as qt,a as n,v as m,d as c,t as u,w as g}from"../chunks/index.008de539.js";import{C as h}from"../chunks/CodeBlock.3968c746.js";import{H as me,E as zt}from"../chunks/EditOnGithub.d1c48e3d.js";function Ot(mt){let f,ge,ce,he,b,fe,y,ct="BGE, standing for BAAI General Embedding, is a collection of embedding models released by BAAI, which is an English base model for general embedding tasks ranked in the MTEB Leaderboard. Text Embeddings Inference (TEI) is a toolkit developed by Hugging Face for deploying and serving open source text embeddings and sequence classification models; enabling high-performance extraction for the most popular models, including FlagEmbedding, Ember, GTE and E5. And, Google Vertex AI is a Machine Learning (ML) platform that lets you train and deploy ML models and AI applications, and customize large language models (LLMs) for use in your AI-powered applications.",be,M,ut='This example showcases how to deploy any supported embedding model, in this case <a href="https://huggingface.co/BAAI/bge-large-en-v1.5" rel="nofollow"><code>BAAI/bge-large-en-v1.5</code></a>, from the Hugging Face Hub on Vertex AI using the TEI DLC available in Google Cloud Platform (GCP) in both CPU and GPU instances.',ye,w,gt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-embedding-on-vertex-ai/assets/model-in-hf-hub.png" alt="&#39;BAAI/bge-large-en-v1.5&#39; in the Hugging Face Hub"/>',Me,v,we,T,ht='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',ve,I,ft="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",Te,x,Ie,$,bt="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",xe,J,$e,C,yt="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",Je,j,Ce,_,Mt="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",je,U,_e,Z,Ue,V,wt="Once everything is set up, you can already initialize the Vertex AI session via the <code>google-cloud-aiplatform</code> Python SDK as follows:",Ze,A,Ve,L,vt="Then you can already “upload” the model i.e. register the model on Vertex AI. It is not an upload per se, since the model will be automatically downloaded from the Hugging Face Hub in the Hugging Face DLC for TEI on startup via the <code>MODEL_ID</code> environment variable, so what is uploaded is only the configuration, not the model weights.",Ae,G,Tt="Before going into the code, let’s quickly review the arguments provided to the <code>upload</code> method:",Le,W,It='<li><p><strong><code>display_name</code></strong> is the name that will be shown in the Vertex AI Model Registry.</p></li> <li><p><strong><code>serving_container_image_uri</code></strong> is the location of the Hugging Face DLC for TEI that will be used for serving the model.</p></li> <li><p><strong><code>serving_container_environment_variables</code></strong> are the environment variables that will be used during the container runtime, so these are aligned with the environment variables defined by <code>text-embeddings-inference</code>, which are analog to the <a href="https://huggingface.co/docs/text-embeddings-inference/en/cli_arguments" rel="nofollow"><code>text-embeddings-router</code> arguments</a>. Additionally, the Hugging Face DLCs for TEI also capture the <code>AIP_</code> environment variables from Vertex AI as in <a href="https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements" rel="nofollow">Vertex AI Documentation - Custom container requirements for prediction</a>.</p> <ul><li><code>MODEL_ID</code> is the identifier of the model in the Hugging Face Hub, to see all the TEI supported models please check <a href="https://huggingface.co/models?other=text-embeddings-inference&amp;sort=trending" rel="nofollow">https://huggingface.co/models?other=text-embeddings-inference&amp;sort=trending</a>.</li></ul></li> <li><p>(optional) <strong><code>serving_container_ports</code></strong> is the port where the Vertex AI endpoint will be exposed, by default 8080.</p></li>',Ge,k,xt='For more information on the supported <code>aiplatform.Model.upload</code> arguments, check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload</a>.',We,E,ke,H,$t='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-embedding-on-vertex-ai/assets/vertex-ai-model.png" alt="Model on Vertex AI Model Registry"/>',Ee,B,He,R,Jt="After the model is registered on Vertex AI, you need to define the endpoint that you want to deploy the model to, and then link the model deployment to that endpoint resource.",Be,N,Ct="To do so, you need to call the method <code>aiplatform.Endpoint.create</code> to create a new Vertex AI endpoint resource (which is not linked to a model or anything usable yet).",Re,Q,Ne,P,jt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-embedding-on-vertex-ai/assets/vertex-ai-endpoint.png" alt="Vertex AI Endpoint created"/>',Qe,S,_t="Now you can deploy the registered model in an endpoint on Vertex AI.",Pe,X,Ut="The <code>deploy</code> method will link the previously created endpoint resource with the model that contains the configuration of the serving container, and then, it will deploy the model on Vertex AI in the specified instance.",Se,F,Zt="Before going into the code, let’s quickly review the arguments provided to the <code>deploy</code> method:",Xe,D,Vt='<li><strong><code>endpoint</code></strong> is the endpoint to deploy the model to, which is optional, and by default will be set to the model display name with the <code>_endpoint</code> suffix.</li> <li><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> are arguments that define which instance to use, and additionally, the accelerator to use and the number of accelerators, respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</li>',Fe,Y,At='For more information on the supported <code>aiplatform.Model.deploy</code> arguments, you can check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy</a>.',De,q,Ye,z,Lt="<strong>WARNING</strong>: <em>The Vertex AI endpoint deployment via the <code>deploy</code> method may take from 15 to 25 minutes.</em>",qe,O,Gt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-embedding-on-vertex-ai/assets/vertex-ai-endpoint-run.png" alt="Vertex AI Endpoint running the model"/>',ze,K,Wt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-embedding-on-vertex-ai/assets/vertex-ai-endpoint-logs.png" alt="Vertex AI Endpoint logs in Cloud Logging"/>',Oe,ee,Ke,te,kt="Finally, you can run the online predictions on Vertex AI using the <code>predict</code> method, which will send the requests to the running endpoint in the <code>/predict</code> route specified within the container following Vertex AI I/O payload formatting.",et,le,tt,ne,Et='Which produces the following output (truncated for brevity, but original tensor length is 1024, which is the embedding dimension of <a href="https://huggingface.co/BAAI/bge-large-en-v1.5" rel="nofollow"><code>BAAI/bge-large-en-v1.5</code></a>):',lt,oe,nt,ie,Ht='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-embedding-on-vertex-ai/assets/vertex-ai-endpoint-logs-predict.png" alt="Vertex AI Endpoint logs in Cloud Logging after predict"/>',ot,se,it,ae,Bt="Finally, you can release the resources programmatically within the same Python session as follows:",st,re,Rt="<li><code>deployed_model.undeploy_all</code> to undeploy the model from all the endpoints.</li> <li><code>deployed_model.delete</code> to delete the endpoint/s where the model was deployed gracefully after the <code>undeploy_all</code>.</li> <li><code>model.delete</code> to delete the model from the registry.</li>",at,de,rt,pe,dt,ue,pt;return b=new me({props:{title:"Deploy Embedding Models with TEI on Vertex AI",local:"deploy-embedding-models-with-tei-on-vertex-ai",headingTag:"h1"}}),v=new me({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),x=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),J=new h({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMENPTlRBSU5FUl9VUkklM0R1cy1kb2NrZXIucGtnLmRldiUyRmRlZXBsZWFybmluZy1wbGF0Zm9ybS1yZWxlYXNlJTJGZ2NyLmlvJTJGaHVnZ2luZ2ZhY2UtdGV4dC1lbWJlZGRpbmdzLWluZmVyZW5jZS1jdTEyMi4xLTQudWJ1bnR1MjIwNA==",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-embeddings-inference-cu122<span class="hljs-number">.1</span>-<span class="hljs-number">4.</span>ubuntu2204`,wrap:!1}}),j=new h({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),U=new h({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),Z=new me({props:{title:"Register model on Vertex AI",local:"register-model-on-vertex-ai",headingTag:"h2"}}),A=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
)`,wrap:!1}}),E=new h({props:{code:"bW9kZWwlMjAlM0QlMjBhaXBsYXRmb3JtLk1vZGVsLnVwbG9hZCglMEElMjAlMjAlMjAlMjBkaXNwbGF5X25hbWUlM0QlMjJCQUFJLS1iZ2UtbGFyZ2UtZW4tdjEuNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX2ltYWdlX3VyaSUzRG9zLmdldGVudiglMjJDT05UQUlORVJfVVJJJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX2Vudmlyb25tZW50X3ZhcmlhYmxlcyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyQkFBSSUyRmJnZS1sYXJnZS1lbi12MS41JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwc2VydmluZ19jb250YWluZXJfcG9ydHMlM0QlNUI4MDgwJTVEJTJDJTBBKSUwQW1vZGVsLndhaXQoKQ==",highlighted:`model = aiplatform.Model.upload(
    display_name=<span class="hljs-string">&quot;BAAI--bge-large-en-v1.5&quot;</span>,
    serving_container_image_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    serving_container_environment_variables={
        <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;BAAI/bge-large-en-v1.5&quot;</span>,
    },
    serving_container_ports=[<span class="hljs-number">8080</span>],
)
model.wait()`,wrap:!1}}),B=new me({props:{title:"Deploy model on Vertex AI",local:"deploy-model-on-vertex-ai",headingTag:"h2"}}),Q=new h({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBhaXBsYXRmb3JtLkVuZHBvaW50LmNyZWF0ZShkaXNwbGF5X25hbWUlM0QlMjJCQUFJLS1iZ2UtbGFyZ2UtZW4tdjEuNS1lbmRwb2ludCUyMik=",highlighted:'endpoint = aiplatform.Endpoint.create(display_name=<span class="hljs-string">&quot;BAAI--bge-large-en-v1.5-endpoint&quot;</span>)',wrap:!1}}),q=new h({props:{code:"ZGVwbG95ZWRfbW9kZWwlMjAlM0QlMjBtb2RlbC5kZXBsb3koJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0RlbmRwb2ludCUyQyUwQSUyMCUyMCUyMCUyMG1hY2hpbmVfdHlwZSUzRCUyMmcyLXN0YW5kYXJkLTQlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl90eXBlJTNEJTIyTlZJRElBX0w0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3JfY291bnQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwc3luYyUzRFRydWUlMkMlMEEp",highlighted:`deployed_model = model.deploy(
    endpoint=endpoint,
    machine_type=<span class="hljs-string">&quot;g2-standard-4&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_L4&quot;</span>,
    accelerator_count=<span class="hljs-number">1</span>,
    sync=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),ee=new me({props:{title:"Online predictions on Vertex AI",local:"online-predictions-on-vertex-ai",headingTag:"h2"}}),le=new h({props:{code:"b3V0cHV0JTIwJTNEJTIwZGVwbG95ZWRfbW9kZWwucHJlZGljdChpbnN0YW5jZXMlM0QlNUIlN0IlMjJpbnB1dHMlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBEZWVwJTIwTGVhcm5pbmclM0YlMjIlN0QlNUQpJTBBcHJpbnQob3V0cHV0LnByZWRpY3Rpb25zJTVCMCU1RCU1QjAlNUQlNUIlM0E1JTVEJTJDJTIwbGVuKG91dHB1dC5wcmVkaWN0aW9ucyU1QjAlNUQlNUIwJTVEKQ==",highlighted:`output = deployed_model.predict(instances=[{<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>}])
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][:<span class="hljs-number">5</span>], <span class="hljs-built_in">len</span>(output.predictions[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),oe=new h({props:{code:"KCU1QjAuMDE4MTA4ODI2JTJDJTIwMC4wMDI5OTkzMTQ2JTJDJTIwLTAuMDQ5ODQ3NjclMkMlMjAtMC4wMzUwODE4MTUlMkMlMjAwLjAxNDIxMDg0NSU1RCUyQyUyMDEwMjQp",highlighted:'([<span class="hljs-number">0.018108826</span>, <span class="hljs-number">0</span>.<span class="hljs-number">0029993146</span>, -<span class="hljs-number">0.04984767</span>, -<span class="hljs-number">0</span>.<span class="hljs-number">035081815</span>, <span class="hljs-number">0.014210845</span>], <span class="hljs-number">1024</span>)',wrap:!1}}),se=new me({props:{title:"Resource clean-up",local:"resource-clean-up",headingTag:"h2"}}),de=new h({props:{code:"ZGVwbG95ZWRfbW9kZWwudW5kZXBsb3lfYWxsKCklMEFkZXBsb3llZF9tb2RlbC5kZWxldGUoKSUwQW1vZGVsLmRlbGV0ZSgp",highlighted:`deployed_model.undeploy_all()
deployed_model.delete()
model.delete()`,wrap:!1}}),pe=new zt({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-deploy-embedding-on-vertex-ai.mdx"}}),{c(){f=s("meta"),ge=o(),ce=s("p"),he=o(),d(b.$$.fragment),fe=o(),y=s("p"),y.textContent=ct,be=o(),M=s("p"),M.innerHTML=ut,ye=o(),w=s("p"),w.innerHTML=gt,Me=o(),d(v.$$.fragment),we=o(),T=s("p"),T.innerHTML=ht,ve=o(),I=s("p"),I.innerHTML=ft,Te=o(),d(x.$$.fragment),Ie=o(),$=s("p"),$.textContent=bt,xe=o(),d(J.$$.fragment),$e=o(),C=s("p"),C.textContent=yt,Je=o(),d(j.$$.fragment),Ce=o(),_=s("p"),_.textContent=Mt,je=o(),d(U.$$.fragment),_e=o(),d(Z.$$.fragment),Ue=o(),V=s("p"),V.innerHTML=wt,Ze=o(),d(A.$$.fragment),Ve=o(),L=s("p"),L.innerHTML=vt,Ae=o(),G=s("p"),G.innerHTML=Tt,Le=o(),W=s("ul"),W.innerHTML=It,Ge=o(),k=s("p"),k.innerHTML=xt,We=o(),d(E.$$.fragment),ke=o(),H=s("p"),H.innerHTML=$t,Ee=o(),d(B.$$.fragment),He=o(),R=s("p"),R.textContent=Jt,Be=o(),N=s("p"),N.innerHTML=Ct,Re=o(),d(Q.$$.fragment),Ne=o(),P=s("p"),P.innerHTML=jt,Qe=o(),S=s("p"),S.textContent=_t,Pe=o(),X=s("p"),X.innerHTML=Ut,Se=o(),F=s("p"),F.innerHTML=Zt,Xe=o(),D=s("ul"),D.innerHTML=Vt,Fe=o(),Y=s("p"),Y.innerHTML=At,De=o(),d(q.$$.fragment),Ye=o(),z=s("p"),z.innerHTML=Lt,qe=o(),O=s("p"),O.innerHTML=Gt,ze=o(),K=s("p"),K.innerHTML=Wt,Oe=o(),d(ee.$$.fragment),Ke=o(),te=s("p"),te.innerHTML=kt,et=o(),d(le.$$.fragment),tt=o(),ne=s("p"),ne.innerHTML=Et,lt=o(),d(oe.$$.fragment),nt=o(),ie=s("p"),ie.innerHTML=Ht,ot=o(),d(se.$$.fragment),it=o(),ae=s("p"),ae.textContent=Bt,st=o(),re=s("ul"),re.innerHTML=Rt,at=o(),d(de.$$.fragment),rt=o(),d(pe.$$.fragment),dt=o(),ue=s("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);f=a(t,"META",{name:!0,content:!0}),t.forEach(l),ge=i(e),ce=a(e,"P",{}),Nt(ce).forEach(l),he=i(e),p(b.$$.fragment,e),fe=i(e),y=a(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1b2ocgc"&&(y.textContent=ct),be=i(e),M=a(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-6mz645"&&(M.innerHTML=ut),ye=i(e),w=a(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1qbhsnw"&&(w.innerHTML=gt),Me=i(e),p(v.$$.fragment,e),we=i(e),T=a(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1o67gfb"&&(T.innerHTML=ht),ve=i(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1ebrquh"&&(I.innerHTML=ft),Te=i(e),p(x.$$.fragment,e),Ie=i(e),$=a(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1i8n6rq"&&($.textContent=bt),xe=i(e),p(J.$$.fragment,e),$e=i(e),C=a(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-15nvzfz"&&(C.textContent=yt),Je=i(e),p(j.$$.fragment,e),Ce=i(e),_=a(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1nm8o2l"&&(_.textContent=Mt),je=i(e),p(U.$$.fragment,e),_e=i(e),p(Z.$$.fragment,e),Ue=i(e),V=a(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-14aynbe"&&(V.innerHTML=wt),Ze=i(e),p(A.$$.fragment,e),Ve=i(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-n76s0j"&&(L.innerHTML=vt),Ae=i(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-zklutt"&&(G.innerHTML=Tt),Le=i(e),W=a(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-t6lsyn"&&(W.innerHTML=It),Ge=i(e),k=a(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1flszm1"&&(k.innerHTML=xt),We=i(e),p(E.$$.fragment,e),ke=i(e),H=a(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1gjgcnp"&&(H.innerHTML=$t),Ee=i(e),p(B.$$.fragment,e),He=i(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-2nwexf"&&(R.textContent=Jt),Be=i(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1lovlvw"&&(N.innerHTML=Ct),Re=i(e),p(Q.$$.fragment,e),Ne=i(e),P=a(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1jzie0c"&&(P.innerHTML=jt),Qe=i(e),S=a(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-it668a"&&(S.textContent=_t),Pe=i(e),X=a(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-njbdvc"&&(X.innerHTML=Ut),Se=i(e),F=a(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1ezlr9j"&&(F.innerHTML=Zt),Xe=i(e),D=a(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-1mv29i5"&&(D.innerHTML=Vt),Fe=i(e),Y=a(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-9p37qa"&&(Y.innerHTML=At),De=i(e),p(q.$$.fragment,e),Ye=i(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-mraq68"&&(z.innerHTML=Lt),qe=i(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-16skh6v"&&(O.innerHTML=Gt),ze=i(e),K=a(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1fuhrre"&&(K.innerHTML=Wt),Oe=i(e),p(ee.$$.fragment,e),Ke=i(e),te=a(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-166ya0u"&&(te.innerHTML=kt),et=i(e),p(le.$$.fragment,e),tt=i(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1kw92uk"&&(ne.innerHTML=Et),lt=i(e),p(oe.$$.fragment,e),nt=i(e),ie=a(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1bqr0qd"&&(ie.innerHTML=Ht),ot=i(e),p(se.$$.fragment,e),it=i(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1a8svyd"&&(ae.textContent=Bt),st=i(e),re=a(e,"UL",{"data-svelte-h":!0}),r(re)!=="svelte-8vrgpw"&&(re.innerHTML=Rt),at=i(e),p(de.$$.fragment,e),rt=i(e),p(pe.$$.fragment,e),dt=i(e),ue=a(e,"P",{}),Nt(ue).forEach(l),this.h()},h(){Qt(f,"name","hf:doc:metadata"),Qt(f,"content",Kt)},m(e,t){qt(document.head,f),n(e,ge,t),n(e,ce,t),n(e,he,t),m(b,e,t),n(e,fe,t),n(e,y,t),n(e,be,t),n(e,M,t),n(e,ye,t),n(e,w,t),n(e,Me,t),m(v,e,t),n(e,we,t),n(e,T,t),n(e,ve,t),n(e,I,t),n(e,Te,t),m(x,e,t),n(e,Ie,t),n(e,$,t),n(e,xe,t),m(J,e,t),n(e,$e,t),n(e,C,t),n(e,Je,t),m(j,e,t),n(e,Ce,t),n(e,_,t),n(e,je,t),m(U,e,t),n(e,_e,t),m(Z,e,t),n(e,Ue,t),n(e,V,t),n(e,Ze,t),m(A,e,t),n(e,Ve,t),n(e,L,t),n(e,Ae,t),n(e,G,t),n(e,Le,t),n(e,W,t),n(e,Ge,t),n(e,k,t),n(e,We,t),m(E,e,t),n(e,ke,t),n(e,H,t),n(e,Ee,t),m(B,e,t),n(e,He,t),n(e,R,t),n(e,Be,t),n(e,N,t),n(e,Re,t),m(Q,e,t),n(e,Ne,t),n(e,P,t),n(e,Qe,t),n(e,S,t),n(e,Pe,t),n(e,X,t),n(e,Se,t),n(e,F,t),n(e,Xe,t),n(e,D,t),n(e,Fe,t),n(e,Y,t),n(e,De,t),m(q,e,t),n(e,Ye,t),n(e,z,t),n(e,qe,t),n(e,O,t),n(e,ze,t),n(e,K,t),n(e,Oe,t),m(ee,e,t),n(e,Ke,t),n(e,te,t),n(e,et,t),m(le,e,t),n(e,tt,t),n(e,ne,t),n(e,lt,t),m(oe,e,t),n(e,nt,t),n(e,ie,t),n(e,ot,t),m(se,e,t),n(e,it,t),n(e,ae,t),n(e,st,t),n(e,re,t),n(e,at,t),m(de,e,t),n(e,rt,t),m(pe,e,t),n(e,dt,t),n(e,ue,t),pt=!0},p:St,i(e){pt||(c(b.$$.fragment,e),c(v.$$.fragment,e),c(x.$$.fragment,e),c(J.$$.fragment,e),c(j.$$.fragment,e),c(U.$$.fragment,e),c(Z.$$.fragment,e),c(A.$$.fragment,e),c(E.$$.fragment,e),c(B.$$.fragment,e),c(Q.$$.fragment,e),c(q.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(oe.$$.fragment,e),c(se.$$.fragment,e),c(de.$$.fragment,e),c(pe.$$.fragment,e),pt=!0)},o(e){u(b.$$.fragment,e),u(v.$$.fragment,e),u(x.$$.fragment,e),u(J.$$.fragment,e),u(j.$$.fragment,e),u(U.$$.fragment,e),u(Z.$$.fragment,e),u(A.$$.fragment,e),u(E.$$.fragment,e),u(B.$$.fragment,e),u(Q.$$.fragment,e),u(q.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(oe.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(pe.$$.fragment,e),pt=!1},d(e){e&&(l(ge),l(ce),l(he),l(fe),l(y),l(be),l(M),l(ye),l(w),l(Me),l(we),l(T),l(ve),l(I),l(Te),l(Ie),l($),l(xe),l($e),l(C),l(Je),l(Ce),l(_),l(je),l(_e),l(Ue),l(V),l(Ze),l(Ve),l(L),l(Ae),l(G),l(Le),l(W),l(Ge),l(k),l(We),l(ke),l(H),l(Ee),l(He),l(R),l(Be),l(N),l(Re),l(Ne),l(P),l(Qe),l(S),l(Pe),l(X),l(Se),l(F),l(Xe),l(D),l(Fe),l(Y),l(De),l(Ye),l(z),l(qe),l(O),l(ze),l(K),l(Oe),l(Ke),l(te),l(et),l(tt),l(ne),l(lt),l(nt),l(ie),l(ot),l(it),l(ae),l(st),l(re),l(at),l(rt),l(dt),l(ue)),l(f),g(b,e),g(v,e),g(x,e),g(J,e),g(j,e),g(U,e),g(Z,e),g(A,e),g(E,e),g(B,e),g(Q,e),g(q,e),g(ee,e),g(le,e),g(oe,e),g(se,e),g(de,e),g(pe,e)}}}const Kt='{"title":"Deploy Embedding Models with TEI on Vertex AI","local":"deploy-embedding-models-with-tei-on-vertex-ai","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Register model on Vertex AI","local":"register-model-on-vertex-ai","sections":[],"depth":2},{"title":"Deploy model on Vertex AI","local":"deploy-model-on-vertex-ai","sections":[],"depth":2},{"title":"Online predictions on Vertex AI","local":"online-predictions-on-vertex-ai","sections":[],"depth":2},{"title":"Resource clean-up","local":"resource-clean-up","sections":[],"depth":2}],"depth":1}';function el(mt){return Xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends Ft{constructor(f){super(),Dt(this,f,el,Ot,Pt,{})}}export{il as component};
