import{s as Is,n as Cs,o as gs}from"../chunks/scheduler.a2b4ca8e.js";import{S as vs,i as Bs,g as i,s as n,r as p,A as Gs,h as o,f as l,c as a,j as bs,u as c,x as r,k as js,y as ks,a as s,v as m,d as u,t as d,w as M}from"../chunks/index.d2f673cc.js";import{C as h}from"../chunks/CodeBlock.792343a6.js";import{H as Le}from"../chunks/Heading.675d4c1e.js";function Zs(Ul){let y,Ye,ze,Ae,w,Ee,T,bl='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/text-generation/llama2-7b-fine-tuning.ipynb" rel="nofollow">here</a></em>.',qe,J,jl='This tutorial will teach you how to fine-tune open LLMs like <a href="https://huggingface.co/meta-llama/Llama-2-7b-hf" rel="nofollow">Llama 2</a> on AWS Trainium. In our example, we are going to leverage Hugging Face <a href="https://huggingface.co/docs/optimum-neuron/index" rel="nofollow">https://huggingface.co/docs/optimum-neuron/index</a>, <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">Transformers</a> and <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">https://huggingface.co/docs/datasets/index</a>.',Pe,f,Il="You will learn how to:",De,U,Cl='<li><a href="#1-setup-aws-environment">Setup AWS environment</a></li> <li><a href="#2-load-and-prepare-the-dataset">Load and process the dataset</a></li> <li><a href="#3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer">Fine-tune Llama on AWS Trainium using the <code>NeuronTrainer</code></a></li> <li><a href="#4-evaluate-and-test-fine-tuned-llama-model">Evaluate and test fine-tuned Llama model</a></li>',Ke,b,Oe,j,gl='<a href="https://aws.amazon.com/de/ec2/instance-types/trn1/" rel="nofollow">AWS Trainium (Trn1)</a> is a purpose-built EC2 for deep learning (DL) training workloads. Trainium is the successor of <a href="https://aws.amazon.com/ec2/instance-types/inf1/?nc1=h_ls" rel="nofollow">AWS Inferentia</a> focused on high-performance training workloads. Trainium has been optimized for training natural language processing, computer vision, and recommender models. The accelerator supports a wide range of data types, including FP32, TF32, BF16, FP16, UINT8, and configurable FP8.',et,I,vl='The biggest Trainium instance, the <code>trn1.32xlarge</code> comes with over 500GB of memory, making it easy to fine-tune ~10B parameter models on a single instance. Below you will find an overview of the available instance types. More details <a href="https://aws.amazon.com/de/ec2/instance-types/trn1/#Product_details" rel="nofollow">here</a>:',tt,C,Bl="<thead><tr><th>instance size</th> <th>accelerators</th> <th>accelerator memory</th> <th>vCPU</th> <th>CPU Memory</th> <th>price per hour</th></tr></thead> <tbody><tr><td>trn1.2xlarge</td> <td>1</td> <td>32</td> <td>8</td> <td>32</td> <td>\\$1.34</td></tr> <tr><td>trn1.32xlarge</td> <td>16</td> <td>512</td> <td>128</td> <td>512</td> <td>\\$21.50</td></tr> <tr><td>trn1n.32xlarge (2x bandwidth)</td> <td>16</td> <td>512</td> <td>128</td> <td>512</td> <td>\\$24.78</td></tr></tbody>",lt,g,Gl="<em>Note: This tutorial was created on a trn1.32xlarge AWS EC2 Instance.</em>",st,v,nt,B,kl='In this example, we will use the <code>trn1.32xlarge</code> instance on AWS with 16 Accelerator, including 32 Neuron Cores and the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a>. The Hugging Face AMI comes with all important libraries, like Transformers, Datasets, Optimum and Neuron packages pre-installed. This makes it super easy to get started, since there is no need for environment management.',at,G,Zl='This tutorial doesn’t cover how to create the instance in detail. You can check out the dedicated tutorial about <a href="https://huggingface.co/docs/optimum-neuron/guides/setup_aws_instance" rel="nofollow">“Setting up AWS Trainium for Hugging Face Transformers”</a>, which includes a step-by-step guide on setting up the environment.',it,k,Wl="Once the instance is up and running, we can ssh into it. But instead of developing inside a terminal we want to use a <code>Jupyter</code> environment, which we can use for preparing our dataset and launching the training. For this, we need to add a port for forwarding in the <code>ssh</code> command, which will tunnel our localhost traffic to the Trainium instance.",ot,Z,rt,W,_l='Let’s now pull the optimum repository with the <a href="https://github.com/huggingface/optimum-neuron/tree/main/notebooks/text-generation" rel="nofollow">example notebook and scripts</a>.',pt,_,ct,x,xl="Next we can change our directory to <code>notbooks/text-generation</code> and launch the <code>jupyter</code> environment.",mt,H,ut,S,Hl="You should see a familiar <strong><code>jupyter</code></strong> output with a URL to the notebook.",dt,$,Sl="<strong><code>http://localhost:8080/?token=8c1739aff1755bd7958c4cfccc8d08cb5da5234f61f129a9</code></strong>",Mt,X,$l="We can click on it, and a <strong><code>jupyter</code></strong> environment opens in our local browser. Open the notebook <strong><code>llama2-7b-fine-tuning.ipynb</code></strong> and lets get started.",ht,Q,Xl="<em>Note: We are going to use the Jupyter environment only for preparing the dataset and then <code>torchrun</code> for launching our training script for distributed training.</em>",yt,R,Ql="If you are going to use official Llama 2 checkpoint you need to login into our hugging face account, which has access to the model, to use your token for accessing the gated repository. We can do this by running the following command:",wt,V,Rl="<em>Note: We also provide an ungated checkpoint.</em>",Tt,N,Jt,z,ft,F,Vl='We will use <a href="https://huggingface.co/datasets/databricks/databricks-dolly-15k" rel="nofollow">Dolly</a> an open source dataset of instruction-following records on categories outlined in the <a href="https://arxiv.org/abs/2203.02155" rel="nofollow">InstructGPT paper</a>, including brainstorming, classification, closed QA, generation, information extraction, open QA, and summarization.',Ut,L,bt,Y,Nl="To load the <code>dolly</code> dataset, we use the <code>load_dataset()</code> method from the 🤗 Datasets library.",jt,A,It,E,zl="To instruct tune our model we need to convert our structured examples into a collection of tasks described via instructions. We define a <code>formatting_function</code> that takes a sample and returns a string with our format instruction.",Ct,q,gt,P,Fl="let’s test our formatting function on a random example.",vt,D,Bt,K,Ll='In addition, to formatting our samples we also want to pack multiple samples to one sequence to have a more efficient training. This means that we are stacking multiple samples to one sequence and split them with an EOS Token. This makes the training more efficient. Packing/stacking samples can be done during training or before. We will do it before training to save time. We created a utility method <a href="https://github.com/huggingface/optimum-neuron/tree/main/notebooks/text-generation/scripts/utils/pack_dataset.py" rel="nofollow">pack_dataset</a> that takes a dataset and a packing function and returns a packed dataset.',Gt,O,kt,ee,Yl="To pack/stack our dataset we need to first tokenize it and then we can pack it with the <code>pack_dataset</code> method. To prepare our dataset we will now:",Zt,te,Al="<li>Format our samples using the template method and add an EOS token at the end of each sample</li> <li>Tokenize our dataset to convert it from text to tokens</li> <li>Pack our dataset to 2048 tokens</li>",Wt,le,_t,se,El="After we processed the datasets we are going save it to disk. You could also save it to S3 or the Hugging Face Hub for later use.",xt,ne,ql="<em>Note: Packing and preprocessing your dataset can be run outside of the Trainium instance.</em>",Ht,ae,St,ie,$t,oe,Pl='Normally you would use the <strong><a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a></strong> and <strong><a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a></strong> to fine-tune PyTorch-based transformer models.',Xt,re,Dl="But together with AWS, we have developed a <code>NeuronTrainer</code> to improve performance, robustness, and safety when training on Trainium instances. The <code>NeuronTrainer</code> is part of the <code>optimum-neuron</code> library and can be used as a 1-to-1 replacement for the <code>Trainer</code>.",Qt,pe,Kl="When it comes to distributed training on AWS Trainium there are a few things we need to take care of. Since Llama is a big model it might not fit on a single accelerator, thats why we added support for different distributed training strategies to the <code>NeuronTrainer</code> including:",Rt,ce,Ol='<li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/frameworks/torch/torch-neuronx/tutorials/training/zero1_gpt2.html" rel="nofollow">ZeRO-1</a>: shards the optimizer state over multiple devices.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/tensor_parallelism_overview.html" rel="nofollow">Tensor Parallelism</a>: shards the model parameters along a given dimension on multiple devices, defined with <code>tensor_parallel_size</code></li> <li><a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Sequence parallelism</a> shards the activations on the sequence axis outside of the tensor parallel regions. It is useful because it saves memory by sharding the activations.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/pipeline_parallelism_overview.html" rel="nofollow">Pipeline Parallelism</a>: <em>coming soon</em></li>',Vt,me,es='We prepared a <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/text-generation/scripts/run_clm.py" rel="nofollow">run_clm.py</a>, which implements those distributed training strategies for you already. If you want to know more about the details you can take a look at the <a href="https://huggingface.co/docs/optimum-neuron/guides/distributed_training" rel="nofollow">documentation</a>. When training models on AWS Accelerators we first need to compile our model with our training arguments.',Nt,ue,ts='To overcome this we added a <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system" rel="nofollow">model cache</a>, which allows us to use precompiled models and configuration from Hugging Face Hub to skip the compilation step. But every change in the config, will lead to a new compilation, which could result in some cache misses.',zt,de,ls='<em>Note: If your configuration is not cached please open an issue on <a href="https://github.com/huggingface/optimum-neuron/issues" rel="nofollow">Github</a>, we are happy to include it.</em>',Ft,Me,ss="We pre-compiled the config for our training already meaning you can either skip the cell below or rerun it will only take a few minutes since it reuses the cached configuration.",Lt,he,Yt,ye,ns="<em>Note: Compiling without a cache can take ~40 minutes. It will also create dummy files in the <code>dolly_llama_sharded</code> during compilation you we have to remove them afterwards. We also need to add <code>MALLOC_ARENA_MAX=64</code> to limit the CPU allocation to avoid potential crashes, don’t remove it for now.</em>",At,we,Et,Te,as=`After the compilation is done we can start our training with a similar command, we just need to remove the <code>neuron_parallel_compile</code>. We will use <code>torchrun</code> to launch our training script. <code>torchrun</code> is a tool that automatically distributes a PyTorch model across multiple accelerators. We can pass the number of accelerators as <code>nproc_per_node</code> arguments alongside our hyperparameters.
The difference to the compilation command is that we changed from <code>max_steps=10</code> to <code>num_train_epochs=3</code>.`,qt,Je,is="Launch the training, with the following command.",Pt,fe,Dt,Ue,os="Thats it, we successfully trained Llama 7B on AWS Trainium. The training took for 3 epochs on dolly (15k samples) took 43:24 minutes where the raw training time was only 31:46 minutes. This leads to a cost of ~$15.5 for the e2e training on the trn1.32xlarge instance. Not Bad!",Kt,be,rs="But before we can share and test our model we need to consolidate our model. Since we used Tensor Parallelism during training, we need to consolidate the model weights before we can use it. Tensor Parallelism shards the model weights accross different workers, only sharded checkpoints will be saved during training.",Ot,je,ps="The Optimum CLI provides a way of doing that very easily via the `optimum neuron consolidate“ command:",el,Ie,tl,Ce,cs="Lets remove our “sharded” checkpoints as we have consolidated them already to safetensors.",ll,ge,sl,ve,ms="## 4. Evaluate and test fine-tuned Llama model",nl,Be,us="Similar to training to be able to run inferece on AWS Trainium or AWS Inferentia2 we need to compile our model for the correct use. We will use our Trainium instance for the inference test, but we recommend customer to switch to Inferentia2 for inference.",al,Ge,ds="Optimum Neuron implements similar to Transformers AutoModel classes for easy inference use. We will use the <code>NeuronModelForCausalLM</code> class to load our vanilla transformers checkpoint and convert it to neuron.",il,ke,ol,Ze,Ms="<em>Note: Inference compilation can take ~25minutes. Luckily, you need to only run this onces. Since you can save the model afterwards. If you are going to run on Inferentia2 you need to recompile again. The compilation is parameter and hardware specific.</em>",rl,We,pl,_e,hs="We can now test inference, but have to make sure we format our input to our prompt format we used for fine-tuning. Therefore we created a helper method, which accepts a <code>dict</code> with our <code>instruction</code> and optionally a <code>context</code>.",cl,xe,ml,He,ys="Lets test inference. First we test without a context.",ul,Se,ws="<em>Note: Inference is not expected to be super fast on AWS Trainium using 2 cores. For Inference we recommend using Inferentia2.</em>",dl,$e,Ml,Xe,Ts="<p>AWS stands for Amazon Web Services. AWS is a suite of remote computing services offered by Amazon. The most widely used of these include Amazon Elastic Compute Cloud (Amazon EC2), which provides resizable compute capacity in the cloud; Amazon Simple Storage Service (Amazon S3), which is an object storage service; and Amazon Elastic Block Store (Amazon EBS), which is designed to provide high performance, durable block storage volumes for use with AWS instances. AWS also provides other services, such as AWS Identity and Access Management (IAM), a service that enables organizations to control access to their AWS resources, and AWS Key Management Service (AWS KMS), which helps customers create and control the use of encryption keys.</p>",hl,Qe,Js="That looks correct. Now, lets add some context, e.g. as you would do for RAG applications",yl,Re,wl,Ve,fs="<p>You can use the Optimum Neuron interface to train models on AWS Trainium.</p>",Tl,Ne,Us="Awesome, our model also correctly uses the provided context. We are done. Congrats on fine-tuning Llama on AWS Trainium.",Jl,Fe,fl;return w=new Le({props:{title:"Fine-tune and Test Llama 2 7B on AWS Trainium",local:"fine-tune-and-test-llama-2-7b-on-aws-trainium",headingTag:"h1"}}),b=new Le({props:{title:"Quick intro: AWS Trainium",local:"quick-intro-aws-trainium",headingTag:"h2"}}),v=new Le({props:{title:"1. Setup AWS environment",local:"1-setup-aws-environment",headingTag:"h2"}}),Z=new h({props:{code:"UFVCTElDX0ROUyUzRCUyMiUyMiUyMCUyMyUyMElQJTIwYWRkcmVzcyUyQyUyMGUuZy4lMjBlYzItMy04MC0uLi4uJTBBS0VZX1BBVEglM0QlMjIlMjIlMjAlMjMlMjBsb2NhbCUyMHBhdGglMjB0byUyMGtleSUyQyUyMGUuZy4lMjBzc2glMkZ0cm4ucGVtJTBBJTBBc3NoJTIwLUwlMjA4MDgwJTNBbG9jYWxob3N0JTNBODA4MCUyMC1pJTIwJTI0JTdCS0VZX05BTUUlN0QucGVtJTIwdWJ1bnR1JTQwJTI0UFVCTElDX0ROUw==",highlighted:`PUBLIC_DNS=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># IP address, e.g. ec2-3-80-....</span>
KEY_PATH=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># local path to key, e.g. ssh/trn.pem</span>

ssh -L 8080:localhost:8080 -i <span class="hljs-variable">\${KEY_NAME}</span>.pem ubuntu@<span class="hljs-variable">$PUBLIC_DNS</span>`,wrap:!1}}),_=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0tbmV1cm9uLmdpdA==",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/optimum-neuron.git',wrap:!1}}),H=new h({props:{code:"JTIzJTIwY2hhbmdlJTIwZGlyZWN0b3J5JTBBY2QlMjBvcHRpbXVtLW5ldXJvbiUyRm5vdGVib29rcyUyRnRleHQtZ2VuZXJhdGlvbiUwQSUyMyUyMGxhdW5jaCUyMGp1cHl0ZXIlMEFweXRob24lMjAtbSUyMG5vdGVib29rJTIwLS1hbGxvdy1yb290JTIwLS1wb3J0JTNEODA4MA==",highlighted:`<span class="hljs-comment"># change directory</span>
<span class="hljs-built_in">cd</span> optimum-neuron/notebooks/text-generation
<span class="hljs-comment"># launch jupyter</span>
python -m notebook --allow-root --port=8080`,wrap:!1}}),N=new h({props:{code:"IWh1Z2dpbmdmYWNlLWNsaSUyMGxvZ2luJTIwLS10b2tlbiUyMFlPVVJfVE9LRU4=",highlighted:"!huggingface-cli login --token YOUR_TOKEN",wrap:!1}}),z=new Le({props:{title:"2. Load and prepare the dataset",local:"2-load-and-prepare-the-dataset",headingTag:"h2"}}),L=new h({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB3b3JsZCUyMG9mJTIwd2FyY3JhZnQlMjIlMkMlMEElMjAlMjAlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTBBJTIwJTIwJTIycmVzcG9uc2UlMjIlM0ElMjAlMjJXb3JsZCUyMG9mJTIwd2FyY3JhZnQlMjBpcyUyMGElMjBtYXNzaXZlJTIwb25saW5lJTIwbXVsdGklMjBwbGF5ZXIlMjByb2xlJTIwcGxheWluZyUyMGdhbWUuJTIwSXQlMjB3YXMlMjByZWxlYXNlZCUyMGluJTIwMjAwNCUyMGJ5JTIwYml6YXJyZSUyMGVudGVydGFpbm1lbnQlMjIlMEElN0Q=",highlighted:`{
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What is world of warcraft&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
  <span class="hljs-string">&quot;response&quot;</span>: <span class="hljs-string">&quot;World of warcraft is a massive online multi player role playing game. It was released in 2004 by bizarre entertainment&quot;</span>
}`,wrap:!1}}),A=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQSUyMyUyMExvYWQlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMGh1YiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZGF0YWJyaWNrcyUyRmRhdGFicmlja3MtZG9sbHktMTVrJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEFwcmludChmJTIyZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4oZGF0YXNldCklN0QlMjIpJTBBcHJpbnQoZGF0YXNldCU1QnJhbmRyYW5nZShsZW4oZGF0YXNldCkpJTVEKSUwQSUyMyUyMGRhdGFzZXQlMjBzaXplJTNBJTIwMTUwMTElMEE=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-comment"># Load dataset from the hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset)}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(dataset[randrange(<span class="hljs-built_in">len</span>(dataset))])
<span class="hljs-comment"># dataset size: 15011</span>
`,wrap:!1}}),q=new h({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5KHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBpbnN0cnVjdGlvbiUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiU1Q24lN0JzYW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwY29udGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBDb250ZXh0JTVDbiU3QnNhbXBsZSU1Qidjb250ZXh0JyU1RCU3RCUyMiUyMGlmJTIwbGVuKHNhbXBsZSU1QiUyMmNvbnRleHQlMjIlNUQpJTIwJTNFJTIwMCUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiU3QnNhbXBsZSU1QidyZXNwb25zZSclNUQlN0QlMjIlMEElMjAlMjAlMjAlMjAlMjMlMjBqb2luJTIwYWxsJTIwdGhlJTIwcGFydHMlMjB0b2dldGhlciUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByb21wdCUwQQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;context&quot;</span>]) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;response&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-comment"># join all the parts together</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt
`,wrap:!1}}),D=new h({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQXByaW50KGZvcm1hdF9kb2xseShkYXRhc2V0JTVCcmFuZHJhbmdlKGxlbihkYXRhc2V0KSklNUQpKQ==",highlighted:`<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-built_in">print</span>(format_dolly(dataset[randrange(<span class="hljs-built_in">len</span>(dataset))]))`,wrap:!1}}),O=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBIdWdnaW5nJTIwRmFjZSUyMG1vZGVsJTIwaWQlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnBoaWxzY2htaWQlMkZMbGFtYS0yLTdiLWhmJTIyJTIwJTIzJTIwdW5nYXRlZCUwQSUyMyUyMG1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItaGYlMjIlMjAlMjMlMjBnYXRlZCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># Hugging Face model id</span>
model_id = <span class="hljs-string">&quot;philschmid/Llama-2-7b-hf&quot;</span> <span class="hljs-comment"># ungated</span>
<span class="hljs-comment"># model_id = &quot;meta-llama/Llama-2-7b-hf&quot; # gated</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)`,wrap:!1}}),le=new h({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRpbnQlMEElMjMlMjBhZGQlMjB1dGlscyUyMG1ldGhvZCUyMHRvJTIwcGF0aCUyMGZvciUyMGxvYWRpbmclMjBkYXRhc2V0JTBBaW1wb3J0JTIwc3lzJTBBc3lzLnBhdGguYXBwZW5kKCUyMi4lMkZzY3JpcHRzJTJGdXRpbHMlMjIpJTIwJTIzJTIwbWFrZSUyMHN1cmUlMjB5b3UlMjBjaGFuZ2UlMjB0aGlzJTIwdG8lMjB0aGUlMjBjb3JyZWN0JTIwcGF0aCUwQWZyb20lMjBwYWNrX2RhdGFzZXQlMjBpbXBvcnQlMjBwYWNrX2RhdGFzZXQlMEElMEElMEElMjMlMjB0ZW1wbGF0ZSUyMGRhdGFzZXQlMjB0byUyMGFkZCUyMHByb21wdCUyMHRvJTIwZWFjaCUyMHNhbXBsZSUwQWRlZiUyMHRlbXBsYXRlX2RhdGFzZXQoc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSU1QiUyMnRleHQlMjIlNUQlMjAlM0QlMjBmJTIyJTdCZm9ybWF0X2RvbGx5KHNhbXBsZSklN0QlN0J0b2tlbml6ZXIuZW9zX3Rva2VuJTdEJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2FtcGxlJTBBJTBBJTIzJTIwYXBwbHklMjBwcm9tcHQlMjB0ZW1wbGF0ZSUyMHBlciUyMHNhbXBsZSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcCh0ZW1wbGF0ZV9kYXRhc2V0JTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0RsaXN0KGRhdGFzZXQuZmVhdHVyZXMpKSUwQSUyMyUyMHByaW50JTIwcmFuZG9tJTIwc2FtcGxlJTBBcHJpbnQoZGF0YXNldCU1QnJhbmRpbnQoMCUyQyUyMGxlbihkYXRhc2V0KSklNUQlNUIlMjJ0ZXh0JTIyJTVEKSUwQSUwQSUyMyUyMHRva2VuaXplJTIwZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjBzYW1wbGUlM0ElMjB0b2tlbml6ZXIoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEbGlzdChkYXRhc2V0LmZlYXR1cmVzKSUwQSklMEElMEElMjMlMjBjaHVuayUyMGRhdGFzZXQlMEFsbV9kYXRhc2V0JTIwJTNEJTIwcGFja19kYXRhc2V0KGRhdGFzZXQlMkMlMjBjaHVua19sZW5ndGglM0QyMDQ4KSUyMCUyMyUyMFdlJTIwdXNlJTIwMjA0OCUyMGFzJTIwdGhlJTIwbWF4aW11bSUyMGxlbmd0aCUyMGZvciUyMHBhY2tpbmc=",highlighted:`<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randint
<span class="hljs-comment"># add utils method to path for loading dataset</span>
<span class="hljs-keyword">import</span> sys
sys.path.append(<span class="hljs-string">&quot;./scripts/utils&quot;</span>) <span class="hljs-comment"># make sure you change this to the correct path</span>
<span class="hljs-keyword">from</span> pack_dataset <span class="hljs-keyword">import</span> pack_dataset


<span class="hljs-comment"># template dataset to add prompt to each sample</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">template_dataset</span>(<span class="hljs-params">sample</span>):
    sample[<span class="hljs-string">&quot;text&quot;</span>] = <span class="hljs-string">f&quot;<span class="hljs-subst">{format_dolly(sample)}</span><span class="hljs-subst">{tokenizer.eos_token}</span>&quot;</span>
    <span class="hljs-keyword">return</span> sample

<span class="hljs-comment"># apply prompt template per sample</span>
dataset = dataset.<span class="hljs-built_in">map</span>(template_dataset, remove_columns=<span class="hljs-built_in">list</span>(dataset.features))
<span class="hljs-comment"># print random sample</span>
<span class="hljs-built_in">print</span>(dataset[randint(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset))][<span class="hljs-string">&quot;text&quot;</span>])

<span class="hljs-comment"># tokenize dataset</span>
dataset = dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> sample: tokenizer(sample[<span class="hljs-string">&quot;text&quot;</span>]), batched=<span class="hljs-literal">True</span>, remove_columns=<span class="hljs-built_in">list</span>(dataset.features)
)

<span class="hljs-comment"># chunk dataset</span>
lm_dataset = pack_dataset(dataset, chunk_length=<span class="hljs-number">2048</span>) <span class="hljs-comment"># We use 2048 as the maximum length for packing</span>`,wrap:!1}}),ae=new h({props:{code:"JTIzJTIwc2F2ZSUyMHRyYWluX2RhdGFzZXQlMjB0byUyMGRpc2slMEFkYXRhc2V0X3BhdGglMjAlM0QlMjAlMjJ0b2tlbml6ZWRfZG9sbHklMjIlMEFsbV9kYXRhc2V0LnNhdmVfdG9fZGlzayhkYXRhc2V0X3BhdGgp",highlighted:`<span class="hljs-comment"># save train_dataset to disk</span>
dataset_path = <span class="hljs-string">&quot;tokenized_dolly&quot;</span>
lm_dataset.save_to_disk(dataset_path)`,wrap:!1}}),ie=new Le({props:{title:"3. Fine-tune Llama on AWS Trainium using the NeuronTrainer",local:"3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer",headingTag:"h2"}}),he=new h({props:{code:"JTIzJTIwcHJlY29tcGlsYXRpb24lMjBjb21tYW5kJTBBIU1BTExPQ19BUkVOQV9NQVglM0Q2NCUyMG5ldXJvbl9wYXJhbGxlbF9jb21waWxlJTIwdG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMzIlMjBzY3JpcHRzJTJGcnVuX2NsbS5weSUyMCU1QyUwQSUyMC0tbW9kZWxfaWQlMjAlN0Jtb2RlbF9pZCU3RCUyMCU1QyUwQSUyMC0tZGF0YXNldF9wYXRoJTIwJTdCZGF0YXNldF9wYXRoJTdEJTIwJTVDJTBBJTIwLS1iZjE2JTIwVHJ1ZSUyMCU1QyUwQSUyMC0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEElMjAtLW91dHB1dF9kaXIlMjBkb2xseV9sbGFtYSUyMCU1QyUwQSUyMC0tb3ZlcndyaXRlX291dHB1dF9kaXIlMjBUcnVlJTIwJTVDJTBBJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxJTIwJTVDJTBBJTIwLS1ncmFkaWVudF9jaGVja3BvaW50aW5nJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tdGVuc29yX3BhcmFsbGVsX3NpemUlMjA4JTIwJTVDJTBBJTIwLS1tYXhfc3RlcHMlMjAxMCUyMCU1QyUwQSUyMC0tbG9nZ2luZ19zdGVwcyUyMDEwJTIwJTVDJTBBJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAxNg==",highlighted:`<span class="hljs-comment"># precompilation command</span>
!MALLOC_ARENA_MAX=<span class="hljs-number">64</span> neuron_parallel_compile torchrun --nproc_per_node=<span class="hljs-number">32</span> scripts/run_clm.py \\
 --model_id {model_id} \\
 --dataset_path {dataset_path} \\
 --bf16 <span class="hljs-literal">True</span> \\
 --learning_rate <span class="hljs-number">5e-5</span> \\
 --output_dir dolly_llama \\
 --overwrite_output_dir <span class="hljs-literal">True</span> \\
 --per_device_train_batch_size <span class="hljs-number">1</span> \\
 --gradient_checkpointing <span class="hljs-literal">True</span> \\
 --tensor_parallel_size <span class="hljs-number">8</span> \\
 --max_steps <span class="hljs-number">10</span> \\
 --logging_steps <span class="hljs-number">10</span> \\
 --gradient_accumulation_steps <span class="hljs-number">16</span>`,wrap:!1}}),we=new h({props:{code:"JTIzJTIwcmVtb3ZlJTIwZHVtbXklMjBhcnRpZmFjdHMlMjB3aGljaCUyMGFyZSUyMGNyZWF0ZWQlMjBieSUyMHRoZSUyMHByZWNvbXBpbGF0aW9uJTIwY29tbWFuZCUwQSFybSUyMC1yZiUyMGRvbGx5X2xsYW1h",highlighted:`<span class="hljs-comment"># remove dummy artifacts which are created by the precompilation command</span>
!rm -rf dolly_llama`,wrap:!1}}),fe=new h({props:{code:"IU1BTExPQ19BUkVOQV9NQVglM0Q2NCUyMHRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDMyJTIwc2NyaXB0cyUyRnJ1bl9jbG0ucHklMjAlNUMlMEElMjAtLW1vZGVsX2lkJTIwJTdCbW9kZWxfaWQlN0QlMjAlNUMlMEElMjAtLWRhdGFzZXRfcGF0aCUyMCU3QmRhdGFzZXRfcGF0aCU3RCUyMCU1QyUwQSUyMC0tYmYxNiUyMFRydWUlMjAlNUMlMEElMjAtLWxlYXJuaW5nX3JhdGUlMjA1ZS01JTIwJTVDJTBBJTIwLS1vdXRwdXRfZGlyJTIwZG9sbHlfbGxhbWElMjAlNUMlMEElMjAtLW92ZXJ3cml0ZV9vdXRwdXRfZGlyJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tc2tpcF9jYWNoZV9wdXNoJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMFRydWUlMjAlNUMlMEElMjAtLXRlbnNvcl9wYXJhbGxlbF9zaXplJTIwOCUyMCU1QyUwQSUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEElMjAtLWxvZ2dpbmdfc3RlcHMlMjAxMCUyMCU1QyUwQSUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwMTY=",highlighted:`!MALLOC_ARENA_MAX=<span class="hljs-number">64</span> torchrun --nproc_per_node=<span class="hljs-number">32</span> scripts/run_clm.py \\
 --model_id {model_id} \\
 --dataset_path {dataset_path} \\
 --bf16 <span class="hljs-literal">True</span> \\
 --learning_rate <span class="hljs-number">5e-5</span> \\
 --output_dir dolly_llama \\
 --overwrite_output_dir <span class="hljs-literal">True</span> \\
 --skip_cache_push <span class="hljs-literal">True</span> \\
 --per_device_train_batch_size <span class="hljs-number">1</span> \\
 --gradient_checkpointing <span class="hljs-literal">True</span> \\
 --tensor_parallel_size <span class="hljs-number">8</span> \\
 --num_train_epochs <span class="hljs-number">3</span> \\
 --logging_steps <span class="hljs-number">10</span> \\
 --gradient_accumulation_steps <span class="hljs-number">16</span>`,wrap:!1}}),Ie=new h({props:{code:"IW9wdGltdW0tY2xpJTIwbmV1cm9uJTIwY29uc29saWRhdGUlMjBkb2xseV9sbGFtYSUyRnRlbnNvcl9wYXJhbGxlbF9zaGFyZHMlMjBkb2xseV9sbGFtYQ==",highlighted:"!optimum-cli neuron consolidate dolly_llama/tensor_parallel_shards dolly_llama",wrap:!1}}),ge=new h({props:{code:"IXJtJTIwLXJmJTIwZG9sbHlfbGxhbWElMkZ0ZW5zb3JfcGFyYWxsZWxfc2hhcmRz",highlighted:"!rm -rf dolly_llama/tensor_parallel_shards",wrap:!1}}),ke=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMm51bV9jb3JlcyUyMiUzQSUyMDIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCdmcDE2JyU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwMjA0OCU3RCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRvbGx5X2xsYW1hJTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZG9sbHlfbGxhbWElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipjb21waWxlcl9hcmdzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMpJTBB",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

compiler_args = {<span class="hljs-string">&quot;num_cores&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&#x27;fp16&#x27;</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">2048</span>}

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;dolly_llama&quot;</span>)
model = NeuronModelForCausalLM.from_pretrained(
        <span class="hljs-string">&quot;dolly_llama&quot;</span>,
        export=<span class="hljs-literal">True</span>,
        **compiler_args,
        **input_shapes)
`,wrap:!1}}),We=new h({props:{code:"JTIzJTIwQ09NTUVOVCUyMElOJTIwaWYlMjB5b3UlMjB3YW50JTIwdG8lMjBzYXZlJTIwdGhlJTIwY29tcGlsZWQlMjBtb2RlbCUwQSUyMyUyMG1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJjb21waWxlZF9kb2xseV9sbGFtYSUyMik=",highlighted:`<span class="hljs-comment"># COMMENT IN if you want to save the compiled model</span>
<span class="hljs-comment"># model.save_pretrained(&quot;compiled_dolly_llama&quot;)</span>`,wrap:!1}}),xe=new h({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5X2luZmVyZW5jZShzYW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW5zdHJ1Y3Rpb24lMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwSW5zdHJ1Y3Rpb24lNUNuJTdCc2FtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMGNvbnRleHQlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQ29udGV4dCU1Q24lN0JzYW1wbGUlNUInY29udGV4dCclNUQlN0QlMjIlMjBpZiUyMCUyMmNvbnRleHQlMjIlMjBpbiUyMHNhbXBsZSUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiUyMiUwQSUyMCUyMCUyMCUyMCUyMyUyMGpvaW4lMjBhbGwlMjB0aGUlMjBwYXJ0cyUyMHRvZ2V0aGVyJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwJTIyJTVDbiU1Q24lMjIuam9pbiglNUJpJTIwZm9yJTIwaSUyMGluJTIwJTVCaW5zdHJ1Y3Rpb24lMkMlMjBjb250ZXh0JTJDJTIwcmVzcG9uc2UlNUQlMjBpZiUyMGklMjBpcyUyMG5vdCUyME5vbmUlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcHJvbXB0JTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGUoc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMGZvcm1hdF9kb2xseV9pbmZlcmVuY2Uoc2FtcGxlKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC45JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9wX2slM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcF9wJTNEMC45KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCbGVuKHByb21wdCklM0ElNUQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly_inference</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;context&quot;</span> <span class="hljs-keyword">in</span> sample <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n&quot;</span>
    <span class="hljs-comment"># join all the parts together</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">sample</span>):
    prompt = format_dolly_inference(sample)
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model.generate(**inputs,
                         max_new_tokens=<span class="hljs-number">512</span>,
                         do_sample=<span class="hljs-literal">True</span>,
                         temperature=<span class="hljs-number">0.9</span>,
                         top_k=<span class="hljs-number">50</span>,
                         top_p=<span class="hljs-number">0.9</span>)
    <span class="hljs-keyword">return</span> tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-built_in">len</span>(prompt):]`,wrap:!1}}),$e=new h({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJDYW4lMjB5b3UlMjB0ZWxsJTIwbWUlMjBzb21ldGhpbmclMjBhYm91dCUyMEFXUyUzRiUyMiUwQSU3RCUwQXJlcyUyMCUzRCUyMGdlbmVyYXRlKHByb21wdCklMEElMEFwcmludChyZXMp",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Can you tell me something about AWS?&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),Re=new h({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJIb3clMjBjYW4lMjBJJTIwdHJhaW4lMjBtb2RlbHMlMjBvbiUyMEFXUyUyMFRyYWluaXVtJTNGJTIyJTJDJTBBJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMiVGMCU5RiVBNCU5NyUyME9wdGltdW0lMjBOZXVyb24lMjBpcyUyMHRoZSUyMGludGVyZmFjZSUyMGJldHdlZW4lMjB0aGUlMjAlRjAlOUYlQTQlOTclMjBUcmFuc2Zvcm1lcnMlMjBsaWJyYXJ5JTIwYW5kJTIwQVdTJTIwQWNjZWxlcmF0b3JzJTIwaW5jbHVkaW5nJTIwJTVCQVdTJTIwVHJhaW5pdW0lNUQoaHR0cHMlM0ElMkYlMkZhd3MuYW1hem9uLmNvbSUyRm1hY2hpbmUtbGVhcm5pbmclMkZ0cmFpbml1bSUyRiUzRm5jMSUzRGhfbHMpJTIwYW5kJTIwJTVCQVdTJTIwSW5mZXJlbnRpYSU1RChodHRwcyUzQSUyRiUyRmF3cy5hbWF6b24uY29tJTJGbWFjaGluZS1sZWFybmluZyUyRmluZmVyZW50aWElMkYlM0ZuYzElM0RoX2xzKS4lMjBJdCUyMHByb3ZpZGVzJTIwYSUyMHNldCUyMG9mJTIwdG9vbHMlMjBlbmFibGluZyUyMGVhc3klMjBtb2RlbCUyMGxvYWRpbmclMkMlMjB0cmFpbmluZyUyMGFuZCUyMGluZmVyZW5jZSUyMG9uJTIwc2luZ2xlLSUyMGFuZCUyMG11bHRpLUFjY2VsZXJhdG9yJTIwc2V0dGluZ3MlMjBmb3IlMjBkaWZmZXJlbnQlMjBkb3duc3RyZWFtJTIwdGFza3MuJTIyJTBBJTdEJTBBcmVzJTIwJTNEJTIwZ2VuZXJhdGUocHJvbXB0KSUwQSUwQXByaW50KHJlcyk=",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;How can I train models on AWS Trainium?&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;🤗 Optimum Neuron is the interface between the 🤗 Transformers library and AWS Accelerators including [AWS Trainium](https://aws.amazon.com/machine-learning/trainium/?nc1=h_ls) and [AWS Inferentia](https://aws.amazon.com/machine-learning/inferentia/?nc1=h_ls). It provides a set of tools enabling easy model loading, training and inference on single- and multi-Accelerator settings for different downstream tasks.&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),{c(){y=i("meta"),Ye=n(),ze=i("p"),Ae=n(),p(w.$$.fragment),Ee=n(),T=i("p"),T.innerHTML=bl,qe=n(),J=i("p"),J.innerHTML=jl,Pe=n(),f=i("p"),f.textContent=Il,De=n(),U=i("ol"),U.innerHTML=Cl,Ke=n(),p(b.$$.fragment),Oe=n(),j=i("p"),j.innerHTML=gl,et=n(),I=i("p"),I.innerHTML=vl,tt=n(),C=i("table"),C.innerHTML=Bl,lt=n(),g=i("p"),g.innerHTML=Gl,st=n(),p(v.$$.fragment),nt=n(),B=i("p"),B.innerHTML=kl,at=n(),G=i("p"),G.innerHTML=Zl,it=n(),k=i("p"),k.innerHTML=Wl,ot=n(),p(Z.$$.fragment),rt=n(),W=i("p"),W.innerHTML=_l,pt=n(),p(_.$$.fragment),ct=n(),x=i("p"),x.innerHTML=xl,mt=n(),p(H.$$.fragment),ut=n(),S=i("p"),S.innerHTML=Hl,dt=n(),$=i("p"),$.innerHTML=Sl,Mt=n(),X=i("p"),X.innerHTML=$l,ht=n(),Q=i("p"),Q.innerHTML=Xl,yt=n(),R=i("p"),R.textContent=Ql,wt=n(),V=i("p"),V.innerHTML=Rl,Tt=n(),p(N.$$.fragment),Jt=n(),p(z.$$.fragment),ft=n(),F=i("p"),F.innerHTML=Vl,Ut=n(),p(L.$$.fragment),bt=n(),Y=i("p"),Y.innerHTML=Nl,jt=n(),p(A.$$.fragment),It=n(),E=i("p"),E.innerHTML=zl,Ct=n(),p(q.$$.fragment),gt=n(),P=i("p"),P.textContent=Fl,vt=n(),p(D.$$.fragment),Bt=n(),K=i("p"),K.innerHTML=Ll,Gt=n(),p(O.$$.fragment),kt=n(),ee=i("p"),ee.innerHTML=Yl,Zt=n(),te=i("ol"),te.innerHTML=Al,Wt=n(),p(le.$$.fragment),_t=n(),se=i("p"),se.textContent=El,xt=n(),ne=i("p"),ne.innerHTML=ql,Ht=n(),p(ae.$$.fragment),St=n(),p(ie.$$.fragment),$t=n(),oe=i("p"),oe.innerHTML=Pl,Xt=n(),re=i("p"),re.innerHTML=Dl,Qt=n(),pe=i("p"),pe.innerHTML=Kl,Rt=n(),ce=i("ul"),ce.innerHTML=Ol,Vt=n(),me=i("p"),me.innerHTML=es,Nt=n(),ue=i("p"),ue.innerHTML=ts,zt=n(),de=i("p"),de.innerHTML=ls,Ft=n(),Me=i("p"),Me.textContent=ss,Lt=n(),p(he.$$.fragment),Yt=n(),ye=i("p"),ye.innerHTML=ns,At=n(),p(we.$$.fragment),Et=n(),Te=i("p"),Te.innerHTML=as,qt=n(),Je=i("p"),Je.textContent=is,Pt=n(),p(fe.$$.fragment),Dt=n(),Ue=i("p"),Ue.textContent=os,Kt=n(),be=i("p"),be.textContent=rs,Ot=n(),je=i("p"),je.textContent=ps,el=n(),p(Ie.$$.fragment),tl=n(),Ce=i("p"),Ce.textContent=cs,ll=n(),p(ge.$$.fragment),sl=n(),ve=i("p"),ve.textContent=ms,nl=n(),Be=i("p"),Be.textContent=us,al=n(),Ge=i("p"),Ge.innerHTML=ds,il=n(),p(ke.$$.fragment),ol=n(),Ze=i("p"),Ze.innerHTML=Ms,rl=n(),p(We.$$.fragment),pl=n(),_e=i("p"),_e.innerHTML=hs,cl=n(),p(xe.$$.fragment),ml=n(),He=i("p"),He.textContent=ys,ul=n(),Se=i("p"),Se.innerHTML=ws,dl=n(),p($e.$$.fragment),Ml=n(),Xe=i("blockquote"),Xe.innerHTML=Ts,hl=n(),Qe=i("p"),Qe.textContent=Js,yl=n(),p(Re.$$.fragment),wl=n(),Ve=i("blockquote"),Ve.innerHTML=fs,Tl=n(),Ne=i("p"),Ne.textContent=Us,Jl=n(),Fe=i("p"),this.h()},l(e){const t=Gs("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),Ye=a(e),ze=o(e,"P",{}),bs(ze).forEach(l),Ae=a(e),c(w.$$.fragment,e),Ee=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1u6blc9"&&(T.innerHTML=bl),qe=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-bteys1"&&(J.innerHTML=jl),Pe=a(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1hahfn0"&&(f.textContent=Il),De=a(e),U=o(e,"OL",{"data-svelte-h":!0}),r(U)!=="svelte-1baq49t"&&(U.innerHTML=Cl),Ke=a(e),c(b.$$.fragment,e),Oe=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1gu40it"&&(j.innerHTML=gl),et=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-f3jgz1"&&(I.innerHTML=vl),tt=a(e),C=o(e,"TABLE",{"data-svelte-h":!0}),r(C)!=="svelte-48yzfd"&&(C.innerHTML=Bl),lt=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1qrp4mv"&&(g.innerHTML=Gl),st=a(e),c(v.$$.fragment,e),nt=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-jip0oh"&&(B.innerHTML=kl),at=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-s32fl1"&&(G.innerHTML=Zl),it=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1w4fiht"&&(k.innerHTML=Wl),ot=a(e),c(Z.$$.fragment,e),rt=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-p2qobr"&&(W.innerHTML=_l),pt=a(e),c(_.$$.fragment,e),ct=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1hi5xni"&&(x.innerHTML=xl),mt=a(e),c(H.$$.fragment,e),ut=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-si97e0"&&(S.innerHTML=Hl),dt=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-7s5jat"&&($.innerHTML=Sl),Mt=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-wrj5fl"&&(X.innerHTML=$l),ht=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-k7cbiv"&&(Q.innerHTML=Xl),yt=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1o2i2ph"&&(R.textContent=Ql),wt=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-rga01y"&&(V.innerHTML=Rl),Tt=a(e),c(N.$$.fragment,e),Jt=a(e),c(z.$$.fragment,e),ft=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-170rdxe"&&(F.innerHTML=Vl),Ut=a(e),c(L.$$.fragment,e),bt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-nx074l"&&(Y.innerHTML=Nl),jt=a(e),c(A.$$.fragment,e),It=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-jgf9sc"&&(E.innerHTML=zl),Ct=a(e),c(q.$$.fragment,e),gt=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-123z1dj"&&(P.textContent=Fl),vt=a(e),c(D.$$.fragment,e),Bt=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1ya9sie"&&(K.innerHTML=Ll),Gt=a(e),c(O.$$.fragment,e),kt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1v8dcxr"&&(ee.innerHTML=Yl),Zt=a(e),te=o(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-v6jbub"&&(te.innerHTML=Al),Wt=a(e),c(le.$$.fragment,e),_t=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-16jyes1"&&(se.textContent=El),xt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1qdlstl"&&(ne.innerHTML=ql),Ht=a(e),c(ae.$$.fragment,e),St=a(e),c(ie.$$.fragment,e),$t=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-3kvj29"&&(oe.innerHTML=Pl),Xt=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-16nqarb"&&(re.innerHTML=Dl),Qt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-d5p0c0"&&(pe.innerHTML=Kl),Rt=a(e),ce=o(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-1cjxveo"&&(ce.innerHTML=Ol),Vt=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-6yisi"&&(me.innerHTML=es),Nt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1gx5zns"&&(ue.innerHTML=ts),zt=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1efdq7y"&&(de.innerHTML=ls),Ft=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1brtt7t"&&(Me.textContent=ss),Lt=a(e),c(he.$$.fragment,e),Yt=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-ro2mv7"&&(ye.innerHTML=ns),At=a(e),c(we.$$.fragment,e),Et=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1lieax4"&&(Te.innerHTML=as),qt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-17lv8z9"&&(Je.textContent=is),Pt=a(e),c(fe.$$.fragment,e),Dt=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-159xyop"&&(Ue.textContent=os),Kt=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1nzjqkj"&&(be.textContent=rs),Ot=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-szrdkh"&&(je.textContent=ps),el=a(e),c(Ie.$$.fragment,e),tl=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-15qqwtu"&&(Ce.textContent=cs),ll=a(e),c(ge.$$.fragment,e),sl=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-zyluxj"&&(ve.textContent=ms),nl=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-8ad54z"&&(Be.textContent=us),al=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1pgrxrm"&&(Ge.innerHTML=ds),il=a(e),c(ke.$$.fragment,e),ol=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1sinvz7"&&(Ze.innerHTML=Ms),rl=a(e),c(We.$$.fragment,e),pl=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-jx2yqv"&&(_e.innerHTML=hs),cl=a(e),c(xe.$$.fragment,e),ml=a(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-uuj81b"&&(He.textContent=ys),ul=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1j8w2o0"&&(Se.innerHTML=ws),dl=a(e),c($e.$$.fragment,e),Ml=a(e),Xe=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Xe)!=="svelte-6l4k0q"&&(Xe.innerHTML=Ts),hl=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-u3q76o"&&(Qe.textContent=Js),yl=a(e),c(Re.$$.fragment,e),wl=a(e),Ve=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Ve)!=="svelte-15xrtpx"&&(Ve.innerHTML=fs),Tl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-q9f4rf"&&(Ne.textContent=Us),Jl=a(e),Fe=o(e,"P",{}),bs(Fe).forEach(l),this.h()},h(){js(y,"name","hf:doc:metadata"),js(y,"content",Ws)},m(e,t){ks(document.head,y),s(e,Ye,t),s(e,ze,t),s(e,Ae,t),m(w,e,t),s(e,Ee,t),s(e,T,t),s(e,qe,t),s(e,J,t),s(e,Pe,t),s(e,f,t),s(e,De,t),s(e,U,t),s(e,Ke,t),m(b,e,t),s(e,Oe,t),s(e,j,t),s(e,et,t),s(e,I,t),s(e,tt,t),s(e,C,t),s(e,lt,t),s(e,g,t),s(e,st,t),m(v,e,t),s(e,nt,t),s(e,B,t),s(e,at,t),s(e,G,t),s(e,it,t),s(e,k,t),s(e,ot,t),m(Z,e,t),s(e,rt,t),s(e,W,t),s(e,pt,t),m(_,e,t),s(e,ct,t),s(e,x,t),s(e,mt,t),m(H,e,t),s(e,ut,t),s(e,S,t),s(e,dt,t),s(e,$,t),s(e,Mt,t),s(e,X,t),s(e,ht,t),s(e,Q,t),s(e,yt,t),s(e,R,t),s(e,wt,t),s(e,V,t),s(e,Tt,t),m(N,e,t),s(e,Jt,t),m(z,e,t),s(e,ft,t),s(e,F,t),s(e,Ut,t),m(L,e,t),s(e,bt,t),s(e,Y,t),s(e,jt,t),m(A,e,t),s(e,It,t),s(e,E,t),s(e,Ct,t),m(q,e,t),s(e,gt,t),s(e,P,t),s(e,vt,t),m(D,e,t),s(e,Bt,t),s(e,K,t),s(e,Gt,t),m(O,e,t),s(e,kt,t),s(e,ee,t),s(e,Zt,t),s(e,te,t),s(e,Wt,t),m(le,e,t),s(e,_t,t),s(e,se,t),s(e,xt,t),s(e,ne,t),s(e,Ht,t),m(ae,e,t),s(e,St,t),m(ie,e,t),s(e,$t,t),s(e,oe,t),s(e,Xt,t),s(e,re,t),s(e,Qt,t),s(e,pe,t),s(e,Rt,t),s(e,ce,t),s(e,Vt,t),s(e,me,t),s(e,Nt,t),s(e,ue,t),s(e,zt,t),s(e,de,t),s(e,Ft,t),s(e,Me,t),s(e,Lt,t),m(he,e,t),s(e,Yt,t),s(e,ye,t),s(e,At,t),m(we,e,t),s(e,Et,t),s(e,Te,t),s(e,qt,t),s(e,Je,t),s(e,Pt,t),m(fe,e,t),s(e,Dt,t),s(e,Ue,t),s(e,Kt,t),s(e,be,t),s(e,Ot,t),s(e,je,t),s(e,el,t),m(Ie,e,t),s(e,tl,t),s(e,Ce,t),s(e,ll,t),m(ge,e,t),s(e,sl,t),s(e,ve,t),s(e,nl,t),s(e,Be,t),s(e,al,t),s(e,Ge,t),s(e,il,t),m(ke,e,t),s(e,ol,t),s(e,Ze,t),s(e,rl,t),m(We,e,t),s(e,pl,t),s(e,_e,t),s(e,cl,t),m(xe,e,t),s(e,ml,t),s(e,He,t),s(e,ul,t),s(e,Se,t),s(e,dl,t),m($e,e,t),s(e,Ml,t),s(e,Xe,t),s(e,hl,t),s(e,Qe,t),s(e,yl,t),m(Re,e,t),s(e,wl,t),s(e,Ve,t),s(e,Tl,t),s(e,Ne,t),s(e,Jl,t),s(e,Fe,t),fl=!0},p:Cs,i(e){fl||(u(w.$$.fragment,e),u(b.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(_.$$.fragment,e),u(H.$$.fragment,e),u(N.$$.fragment,e),u(z.$$.fragment,e),u(L.$$.fragment,e),u(A.$$.fragment,e),u(q.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(he.$$.fragment,e),u(we.$$.fragment,e),u(fe.$$.fragment,e),u(Ie.$$.fragment,e),u(ge.$$.fragment,e),u(ke.$$.fragment,e),u(We.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(Re.$$.fragment,e),fl=!0)},o(e){d(w.$$.fragment,e),d(b.$$.fragment,e),d(v.$$.fragment,e),d(Z.$$.fragment,e),d(_.$$.fragment,e),d(H.$$.fragment,e),d(N.$$.fragment,e),d(z.$$.fragment,e),d(L.$$.fragment,e),d(A.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(he.$$.fragment,e),d(we.$$.fragment,e),d(fe.$$.fragment,e),d(Ie.$$.fragment,e),d(ge.$$.fragment,e),d(ke.$$.fragment,e),d(We.$$.fragment,e),d(xe.$$.fragment,e),d($e.$$.fragment,e),d(Re.$$.fragment,e),fl=!1},d(e){e&&(l(Ye),l(ze),l(Ae),l(Ee),l(T),l(qe),l(J),l(Pe),l(f),l(De),l(U),l(Ke),l(Oe),l(j),l(et),l(I),l(tt),l(C),l(lt),l(g),l(st),l(nt),l(B),l(at),l(G),l(it),l(k),l(ot),l(rt),l(W),l(pt),l(ct),l(x),l(mt),l(ut),l(S),l(dt),l($),l(Mt),l(X),l(ht),l(Q),l(yt),l(R),l(wt),l(V),l(Tt),l(Jt),l(ft),l(F),l(Ut),l(bt),l(Y),l(jt),l(It),l(E),l(Ct),l(gt),l(P),l(vt),l(Bt),l(K),l(Gt),l(kt),l(ee),l(Zt),l(te),l(Wt),l(_t),l(se),l(xt),l(ne),l(Ht),l(St),l($t),l(oe),l(Xt),l(re),l(Qt),l(pe),l(Rt),l(ce),l(Vt),l(me),l(Nt),l(ue),l(zt),l(de),l(Ft),l(Me),l(Lt),l(Yt),l(ye),l(At),l(Et),l(Te),l(qt),l(Je),l(Pt),l(Dt),l(Ue),l(Kt),l(be),l(Ot),l(je),l(el),l(tl),l(Ce),l(ll),l(sl),l(ve),l(nl),l(Be),l(al),l(Ge),l(il),l(ol),l(Ze),l(rl),l(pl),l(_e),l(cl),l(ml),l(He),l(ul),l(Se),l(dl),l(Ml),l(Xe),l(hl),l(Qe),l(yl),l(wl),l(Ve),l(Tl),l(Ne),l(Jl),l(Fe)),l(y),M(w,e),M(b,e),M(v,e),M(Z,e),M(_,e),M(H,e),M(N,e),M(z,e),M(L,e),M(A,e),M(q,e),M(D,e),M(O,e),M(le,e),M(ae,e),M(ie,e),M(he,e),M(we,e),M(fe,e),M(Ie,e),M(ge,e),M(ke,e),M(We,e),M(xe,e),M($e,e),M(Re,e)}}}const Ws='{"title":"Fine-tune and Test Llama 2 7B on AWS Trainium","local":"fine-tune-and-test-llama-2-7b-on-aws-trainium","sections":[{"title":"Quick intro: AWS Trainium","local":"quick-intro-aws-trainium","sections":[],"depth":2},{"title":"1. Setup AWS environment","local":"1-setup-aws-environment","sections":[],"depth":2},{"title":"2. Load and prepare the dataset","local":"2-load-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. Fine-tune Llama on AWS Trainium using the NeuronTrainer","local":"3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer","sections":[],"depth":2}],"depth":1}';function _s(Ul){return gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xs extends vs{constructor(y){super(),Bs(this,y,_s,Zs,Is,{})}}export{Xs as component};
