import{s as Hn,o as Dn,n as pt}from"../chunks/scheduler.b108d059.js";import{S as zn,i as On,g as i,s,r as p,A as Kn,h as u,f as l,c as a,j as b,u as M,x as r,k as Pn,y as m,a as n,v as d,d as T,t as h,w as J}from"../chunks/index.008de539.js";import{T as ct}from"../chunks/Tip.aeb15ab7.js";import{C as w}from"../chunks/CodeBlock.3968c746.js";import{H as U,E as es}from"../chunks/EditOnGithub.d1c48e3d.js";function ts(g){let o,y='GPU support on Cloud Run is only available as a waitlisted public preview. If you’re interested in trying out the feature, <a href="https://cloud.google.com/run/quotas#increase" rel="nofollow">request a quota increase</a> for <code>Total Nvidia L4 GPU allocation, per project per region</code>. At the time of writing this example, NVIDIA L4 GPUs (24GiB VRAM) are the only available GPUs on Cloud Run; enabling automatic scaling up to 7 instances by default (more available via quota), as well as scaling down to zero instances when there are no requests.';return{c(){o=i("p"),o.innerHTML=y},l(c){o=u(c,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1bcphve"&&(o.innerHTML=y)},m(c,f){n(c,o,f)},p:pt,d(c){c&&l(o)}}}function ls(g){let o,y="The first time you deploy a new container on Cloud Run it will take around 5 minutes to deploy as it needs to import it from the Google Cloud Artifact Registry, but on the follow up deployments it will take less time as the image has been already imported before.";return{c(){o=i("p"),o.textContent=y},l(c){o=u(c,"P",{"data-svelte-h":!0}),r(o)!=="svelte-18e6hwd"&&(o.textContent=y)},m(c,f){n(c,o,f)},p:pt,d(c){c&&l(o)}}}function ns(g){let o,y='The alternatives mentioned below are for development scenarios, and should not be used in production-ready scenarios as is. The approach below is following the guide defined in <a href="https://cloud.google.com/run/docs/authenticating/developers" rel="nofollow">Cloud Run Documentation - Authenticate Developers</a>; but you can find every other guide as mentioned above in <a href="https://cloud.google.com/run/docs/authenticating/overview" rel="nofollow">Cloud Run Documentation - Authentication overview</a>.';return{c(){o=i("p"),o.innerHTML=y},l(c){o=u(c,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1qznp3b"&&(o.innerHTML=y)},m(c,f){n(c,o,f)},p:pt,d(c){c&&l(o)}}}function ss(g){let o,y="Note that the examples below are using the <code>/v1/chat/completions</code> TGI endpoint with is OpenAI-compatible, meaning that both <code>cURL</code> and Python are just some proposals, but any OpenAI-compatible client can be used instead.";return{c(){o=i("p"),o.innerHTML=y},l(c){o=u(c,"P",{"data-svelte-h":!0}),r(o)!=="svelte-11wzgde"&&(o.innerHTML=y)},m(c,f){n(c,o,f)},p:pt,d(c){c&&l(o)}}}function as(g){let o,y="The access token is short-lived and will expire, by default after 1 hour. If you want to extend the token lifetime beyond the default, you must create and organization policy and use the <code>--lifetime</code> argument when createing the token. Refer to (Access token lifetime)[[https://cloud.google.com/resource-manager/docs/organization-policy/restricting-service-accounts#extend_oauth_ttl]] to learn more. Otherwise, you can also generate a new token by running the same command again.";return{c(){o=i("p"),o.innerHTML=y},l(c){o=u(c,"P",{"data-svelte-h":!0}),r(o)!=="svelte-jzjamm"&&(o.innerHTML=y)},m(c,f){n(c,o,f)},p:pt,d(c){c&&l(o)}}}function os(g){let o,y="Note that the examples below are using the <code>/v1/chat/completions</code> TGI endpoint with is OpenAI-compatible, meaning that both <code>cURL</code> and Python are just some proposals, but any OpenAI-compatible client can be used instead.";return{c(){o=i("p"),o.innerHTML=y},l(c){o=u(c,"P",{"data-svelte-h":!0}),r(o)!=="svelte-11wzgde"&&(o.innerHTML=y)},m(c,f){n(c,o,f)},p:pt,d(c){c&&l(o)}}}function is(g){let o,y='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/Google-Cloud-Containers/tree/main/examples/cloud-run/tgi-deployment" rel="nofollow">here</a>!';return{c(){o=i("p"),o.innerHTML=y},l(c){o=u(c,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1depu9i"&&(o.innerHTML=y)},m(c,f){n(c,o,f)},p:pt,d(c){c&&l(o)}}}function us(g){let o,y,c,f,L,gt,q,sn="Meta Llama 3.1 is the latest open LLM from Meta, released in July 2024. Meta Llama 3.1 comes in three sizes: 8B for efficient deployment and development on consumer-size GPU, 70B for large-scale AI native applications, and 405B for synthetic data, LLM as a Judge or distillation; among other use cases. Text Generation Inference (TGI) is a toolkit developed by Hugging Face for deploying and serving LLMs, with high performance text generation. Google Cloud Run is a serverless container platform that allows developers to deploy and manage containerized applications without managing infrastructure, enabling automatic scaling and billing only for usage.",Ut,G,an='This example showcases how to deploy an LLM from the Hugging Face Hub, in this case Meta Llama 3.1 8B Instruct model quantized to INT4 using AWQ, with the Hugging Face DLC for TGI on Google Cloud Run with GPU support (<a href="https://cloud.google.com/products#product-launch-stages" rel="nofollow">in preview</a>).',It,v,Ct,x,jt,k,on='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',$t,W,un="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",bt,_,vt,Q,rn="Then you need to login into your Google Cloud account and set the project ID you want to use to deploy Cloud Run.",At,B,Vt,X,cn="Once you are logged in, you need to enable the Cloud Run API, which is required for the Hugging Face DLC for TGI deployment on Cloud Run.",Et,F,Rt,Y,Nt,P,pn="Once you are all set, you can call the <code>gcloud beta run deploy</code> command (still on beta because GPU support is on preview, as mentioned above).",St,H,Mn="The <code>gcloud beta run deploy</code> command needs you to specify the following parameters:",Zt,D,dn='<li><code>--image</code>: The container image URI to deploy.</li> <li><code>--args</code>: The arguments to pass to the container entrypoint, being <code>text-generation-launcher</code> for the Hugging Face DLC for TGI. Read more about the supported arguments at <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher" rel="nofollow">Text-generation-launcher arguments</a>.<ul><li><code>--model-id</code>: The model ID to use, in this case, <a href="https://huggingface.co/hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4" rel="nofollow"><code>hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4</code></a>.</li> <li><code>--quantize</code>: The quantization method to use, in this case, <code>awq</code>. If not specified, it will be retrieved from the <code>quantization_config-&gt;quant_method</code> in the <code>config.json</code> file.</li></ul></li> <li><code>--port</code>: The port the container listens to.</li> <li><code>--cpu</code> and <code>--memory</code>: The number of CPUs and amount of memory to allocate to the container. Needs to be set to 4 and 16Gi (16 GiB), respectively; as that’s the minimum requirement for using the GPU.</li> <li><code>--no-cpu-throttling</code>: Disables CPU throttling, which is required for using the GPU.</li> <li><code>--gpu</code> and <code>--gpu-type</code>: The number of GPUs and the GPU type to use. Needs to be set to 1 and <code>nvidia-l4</code>, respectively; as at the time of writing this tutorial, those are the only available options as Cloud Run on GPUs is still under preview.</li> <li><code>--max-instances</code>: The maximum number of instances to run, set to 3, but default maximum value is 7. Alternatively, one could set it to 1 too, but that could eventually lead to downtime during infrastructure migrations, so anything above 1 is recommended.</li> <li><code>--concurrency</code>: the maximum number of concurrent requests per instance, set to 64. The value is not arbitrary, but determined after running and evaluating the results of <a href="https://github.com/huggingface/text-generation-inference/tree/main/benchmark" rel="nofollow"><code>text-generation-benchmark</code></a>, as the most optimal balance between throughput and latency; where the current default for TGI being 128 is a bit too much. Note that this value is also aligned with the <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher#maxconcurrentrequests" rel="nofollow"><code>--max-concurrent-requests</code></a> argument in TGI.</li> <li><code>--region</code>: The region to deploy the Cloud Run service.</li> <li><code>--no-allow-unauthenticated</code>: Disables unauthenticated access to the service, which is a good practice as adds an authentication layer managed by Google Cloud IAM.</li>',Lt,z,qt,O,Tn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/cloud-run/tgi-deployment/imgs/cloud-run-deployment.png" alt="Cloud Run Deployment"/>',Gt,K,hn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/cloud-run/tgi-deployment/imgs/cloud-run-details.png" alt="Cloud Run Deployment Details"/>',xt,A,kt,ee,Wt,te,Jn='Once deployed, you can send requests to the service via any of the supported TGI endpoints, check <a href="https://huggingface.github.io/text-generation-inference/" rel="nofollow">TGI’s OpenAPI Specification</a> to see all the available endpoints and their respective parameters.',_t,le,mn="All Cloud Run services are deployed privately by default, which means that they can’t be accessed without providing authentication credentials in the request headers. These services are secured by IAM and are only callable by Project Owners, Project Editors, and Cloud Run Admins and Cloud Run Invokers.",Qt,ne,yn='In this case, a couple of alternatives to enable developer access will be showcased; while the other use cases are out of the scope of this example, as those are either not secure due to the authentication being disabled (for public access scenarios), or require additional setup for production-ready scenarios (<a href="https://cloud.google.com/run/docs/authenticating/service-to-service" rel="nofollow">service-to-service authentication</a>, <a href="https://cloud.google.com/run/docs/authenticating/end-users" rel="nofollow">end-user access</a>).',Bt,V,Xt,se,Ft,ae,wn="Cloud Run Proxy runs a server on localhost that proxies requests to the specified Cloud Run Service with credentials attached; which is useful for testing and experimentation.",Yt,oe,Pt,ie,fn='Then you can send requests to the deployed service on Cloud Run, using the <a href="http://localhost:8080" rel="nofollow">http://localhost:8080</a> URL, with no authentication, exposed by the proxy as shown in the examples below.',Ht,E,Dt,ue,zt,re,gn="To send a POST request to the TGI service using <code>cURL</code>, you can run the following command:",Ot,ce,Kt,pe,el,Me,Un="To run the inference using Python, you can either use the <code>huggingface_hub</code> Python SDK (recommended) or the <code>openai</code> Python SDK.",tl,de,ll,Te,In="You can install it via <code>pip</code> as <code>pip install --upgrade --quiet huggingface_hub</code>, and then run:",nl,he,sl,Je,al,me,Cn="You can install it via <code>pip</code> as <code>pip install --upgrade openai</code>, and then run:",ol,ye,il,we,ul,fe,jn="Cloud Run Service has an unique URL assigned that can be used to send requests from anywhere, using the Google Cloud Credentials with Cloud Run Invoke access to the service; which is the recommended approach as it’s more secure and consistent than using the Cloud Run Proxy.",rl,ge,$n="The URL of the Cloud Run service can be obtained via the following command (assigned to the <code>SERVICE_URL</code> variable for convenience):",cl,Ue,pl,Ie,bn="Then you can send requests to the deployed service on Cloud Run, using the <code>SERVICE_URL</code> and any Google Cloud Credentials with Cloud Run Invoke access. For setting up the credentials there are multiple approaches, some of those are listed below:",Ml,R,I,Mt,vn="Using the default identity token from the Google Cloud SDK:",Fl,dt,An="<li>Via <code>gcloud</code> as:</li>",Yl,Ce,Pl,Tt,Vn="<li>Via Python as:</li>",Hl,je,Dl,ht,En="<p>Using a Service Account with Cloud Run Invoke access, which can either be done with any of the following approaches:</p> <ul><li>Create a Service Account before the Cloud Run Service was created, and then set the <code>--service-account</code> flag to the Service Account email when creating the Cloud Run Service. And use an Access Token for that Service Account only using <code>gcloud auth print-access-token --impersonate-service-account=SERVICE_ACCOUNT_EMAIL</code>.</li> <li>Create a Service Account after the Cloud Run Service was created, and then update the Cloud Run Service to use the Service Account. And use an Access Token for that Service Account only using <code>gcloud auth print-access-token --impersonate-service-account=SERVICE_ACCOUNT_EMAIL</code>.</li></ul>",dl,$e,Rn="The recommended approach is to use a Service Account (SA), as the access can be controlled better and the permissions are more granular; as the Cloud Run Service was not created using a SA, which is another nice option, you need to now create the SA, gran it the necessary permissions, update the Cloud Run Service to use the SA, and then generate an access token to set as the authentication token within the requests, that can be revoked later once you are done using it.",Tl,j,be,Jt,Nn="Set the <code>SERVICE_ACCOUNT_NAME</code> environment variable for convenience:",zl,ve,Ol,Ae,mt,Sn="Create the Service Account:",Kl,Ve,en,Ee,yt,Zn="Grant the Service Account the Cloud Run Invoker role:",tn,Re,ln,Ne,wt,Ln="Generate the Access Token for the Service Account:",nn,Se,hl,N,Jl,Ze,qn="Now you can already dive into the different alternatives for sending the requests to the deployed Cloud Run Service using the <code>SERVICE_URL</code> AND <code>ACCESS_TOKEN</code> as described above.",ml,S,yl,Le,wl,qe,Gn="To send a POST request to the TGI service using <code>cURL</code>, you can run the following command:",fl,Ge,gl,xe,Ul,ke,xn="To run the inference using Python, you can either use the <code>huggingface_hub</code> Python SDK (recommended) or the <code>openai</code> Python SDK.",Il,We,Cl,_e,kn="You can install it via <code>pip</code> as <code>pip install --upgrade --quiet huggingface_hub</code>, and then run:",jl,Qe,$l,Be,bl,Xe,Wn="You can install it via <code>pip</code> as <code>pip install --upgrade openai</code>, and then run:",vl,Fe,Al,Ye,Vl,Pe,_n="Finally, once you are done using TGI on the Cloud Run Service, you can safely delete it to avoid incurring in unnecessary costs e.g. if the Cloud Run services are inadvertently invoked more times than your monthly Cloud Run invokement allocation in the free tier.",El,He,Qn='To delete the Cloud Run Service you can either go to the Google Cloud Console at <a href="https://console.cloud.google.com/run" rel="nofollow">https://console.cloud.google.com/run</a> and delete it manually; or use the Google Cloud SDK via <code>gcloud</code> as follows:',Rl,De,Nl,ze,Bn='Additionally, if you followed the steps in <a href="#via-cloud-run-service-url">via Cloud Run Service URL</a> and generated a Service Account and an access token, you can either remove the Service Account, or just revoke the access token if it is still valid.',Sl,Oe,Xn="<li>(recommended) Revoke the Access Token as</li>",Zl,Ke,Ll,et,Fn="<li>(optional) Delete the Service Account as:</li>",ql,tt,Gl,lt,xl,nt,Yn='<li><a href="https://cloud.google.com/run/docs" rel="nofollow">Cloud Run Documentation - Overview</a></li> <li><a href="https://cloud.google.com/run/docs/configuring/services/gpu" rel="nofollow">Cloud Run Documentation - GPU services</a></li> <li><a href="https://cloud.google.com/blog/products/application-development/run-your-ai-inference-applications-on-cloud-run-with-nvidia-gpus" rel="nofollow">Google Cloud Blog - Run your AI inference applications on Cloud Run with NVIDIA GPUs</a></li>',kl,Wl,_l,Z,Ql,st,Bl,ft,Xl;return L=new U({props:{title:"Deploy Meta Llama 3.1 8B with TGI DLC on Cloud Run",local:"deploy-meta-llama-31-8b-with-tgi-dlc-on-cloud-run",headingTag:"h1"}}),v=new ct({props:{$$slots:{default:[ts]},$$scope:{ctx:g}}}),x=new U({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),_=new w({props:{code:"ZXhwb3J0JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQWV4cG9ydCUyMExPQ0FUSU9OJTNEdXMtY2VudHJhbDElMjAlMjMlMjBvciUyMGFueSUyMGxvY2F0aW9uJTIwd2hlcmUlMjBDbG91ZCUyMFJ1biUyMG9mZmVycyUyMEdQVXMlM0ElMjBodHRwcyUzQSUyRiUyRmNsb3VkLmdvb2dsZS5jb20lMkZydW4lMkZkb2NzJTJGbG9jYXRpb25zJTIzZ3B1JTBBZXhwb3J0JTIwQ09OVEFJTkVSX1VSSSUzRHVzLWRvY2tlci5wa2cuZGV2JTJGZGVlcGxlYXJuaW5nLXBsYXRmb3JtLXJlbGVhc2UlMkZnY3IuaW8lMkZodWdnaW5nZmFjZS10ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlLWN1MTIxLjItMi51YnVudHUyMjA0LnB5MzEwJTBBZXhwb3J0JTIwU0VSVklDRV9OQU1FJTNEdGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZQ==",highlighted:`<span class="hljs-built_in">export</span> PROJECT_ID=your-project-id
<span class="hljs-built_in">export</span> LOCATION=us-central1 <span class="hljs-comment"># or any location where Cloud Run offers GPUs: https://cloud.google.com/run/docs/locations#gpu</span>
<span class="hljs-built_in">export</span> CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu121.2-2.ubuntu2204.py310
<span class="hljs-built_in">export</span> SERVICE_NAME=text-generation-inference`,wrap:!1}}),B=new w({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMGxvZ2luJTBBZ2Nsb3VkJTIwYXV0aCUyMGFwcGxpY2F0aW9uLWRlZmF1bHQlMjBsb2dpbiUyMCUyMCUyMyUyMEZvciUyMGxvY2FsJTIwZGV2ZWxvcG1lbnQlMEFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`gcloud auth login
gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
gcloud config <span class="hljs-built_in">set</span> project <span class="hljs-variable">$PROJECT_ID</span>`,wrap:!1}}),F=new w({props:{code:"Z2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBydW4uZ29vZ2xlYXBpcy5jb20=",highlighted:'gcloud services <span class="hljs-built_in">enable</span> run.googleapis.com',wrap:!1}}),Y=new U({props:{title:"Deploy TGI on Cloud Run",local:"deploy-tgi-on-cloud-run",headingTag:"h2"}}),z=new w({props:{code:"Z2Nsb3VkJTIwYmV0YSUyMHJ1biUyMGRlcGxveSUyMCUyNFNFUlZJQ0VfTkFNRSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0taW1hZ2UlM0QlMjRDT05UQUlORVJfVVJJJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1hcmdzJTNEJTIyLS1tb2RlbC1pZCUzRGh1Z2dpbmctcXVhbnRzJTJGTWV0YS1MbGFtYS0zLjEtOEItSW5zdHJ1Y3QtQVdRLUlOVDQlMkMtLXF1YW50aXplJTNEYXdxJTJDLS1tYXgtY29uY3VycmVudC1yZXF1ZXN0cyUzRDY0JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wb3J0JTNEODA4MCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY3B1JTNENCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWVtb3J5JTNEMTZHaSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbm8tY3B1LXRocm90dGxpbmclMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdwdSUzRDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdwdS10eXBlJTNEbnZpZGlhLWw0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXgtaW5zdGFuY2VzJTNEMyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY29uY3VycmVuY3klM0Q2NCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04lMjAlNUMlMEElMjAlMjAlMjAlMjAtLW5vLWFsbG93LXVuYXV0aGVudGljYXRlZA==",highlighted:`gcloud beta run deploy <span class="hljs-variable">$SERVICE_NAME</span> \\
    --image=<span class="hljs-variable">$CONTAINER_URI</span> \\
    --args=<span class="hljs-string">&quot;--model-id=hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4,--quantize=awq,--max-concurrent-requests=64&quot;</span> \\
    --port=8080 \\
    --cpu=4 \\
    --memory=16Gi \\
    --no-cpu-throttling \\
    --gpu=1 \\
    --gpu-type=nvidia-l4 \\
    --max-instances=3 \\
    --concurrency=64 \\
    --region=<span class="hljs-variable">$LOCATION</span> \\
    --no-allow-unauthenticated`,wrap:!1}}),A=new ct({props:{$$slots:{default:[ls]},$$scope:{ctx:g}}}),ee=new U({props:{title:"Inference on Cloud Run",local:"inference-on-cloud-run",headingTag:"h2"}}),V=new ct({props:{$$slots:{default:[ns]},$$scope:{ctx:g}}}),se=new U({props:{title:"Via Cloud Run Proxy",local:"via-cloud-run-proxy",headingTag:"h3"}}),oe=new w({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBwcm94eSUyMCUyNFNFUlZJQ0VfTkFNRSUyMC0tcmVnaW9uJTIwJTI0TE9DQVRJT04=",highlighted:'gcloud run services proxy <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span>',wrap:!1}}),E=new ct({props:{$$slots:{default:[ss]},$$scope:{ctx:g}}}),ue=new U({props:{title:"cURL",local:"curl",headingTag:"h4"}}),ce=new w({props:{code:"Y3VybCUyMGh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGdjElMkZjaGF0JTJGY29tcGxldGlvbnMlMjAlNUMlMEElMjAlMjAlMjAlMjAtWCUyMFBPU1QlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCdDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLWQlMjAnJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWwlMjIlM0ElMjAlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWF4X3Rva2VucyUyMiUzQSUyMDEyOCUwQSUyMCUyMCUyMCUyMCU3RCc=",highlighted:`curl http://localhost:8080/v1/chat/completions \\
    -X POST \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tgi&quot;,
        &quot;messages&quot;: [
            {
                &quot;role&quot;: &quot;system&quot;,
                &quot;content&quot;: &quot;You are a helpful assistant.&quot;
            },
            {
                &quot;role&quot;: &quot;user&quot;,
                &quot;content&quot;: &quot;What is Deep Learning?&quot;
            }
        ],
        &quot;max_tokens&quot;: 128
    }&#x27;</span>`,wrap:!1}}),pe=new U({props:{title:"Python",local:"python",headingTag:"h4"}}),de=new U({props:{title:"huggingface_hub",local:"huggingfacehub",headingTag:"h5"}}),he=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTIyJTJDJTIwYXBpX2tleSUzRCUyMi0lMjIpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMG1vZGVsJTNEJTIyaHVnZ2luZy1xdWFudHMlMkZNZXRhLUxsYW1hLTMuMS04Qi1JbnN0cnVjdC1BV1EtSU5UNCUyMiUyQyUwQSUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBEZWVwJTIwTGVhcm5pbmclM0YlMjIlN0QlMkMlMEElMjAlMjAlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNEMTI4JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(base_url=<span class="hljs-string">&quot;http://localhost:8080&quot;</span>, api_key=<span class="hljs-string">&quot;-&quot;</span>)

chat_completion = client.chat.completions.create(
  model=<span class="hljs-string">&quot;hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4&quot;</span>,
  messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>},
  ],
  max_tokens=<span class="hljs-number">128</span>,
)`,wrap:!1}}),Je=new U({props:{title:"openai",local:"openai",headingTag:"h5"}}),ye=new w({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQWNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGdjElMkYlMjIlMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyLSUyMiUyQyUwQSklMEElMEFjaGF0X2NvbXBsZXRpb24lMjAlM0QlMjBjbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEyOCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:8080/v1/&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>,
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>},
    ],
    max_tokens=<span class="hljs-number">128</span>,
)`,wrap:!1}}),we=new U({props:{title:"(recommended) Via Cloud Run Service URL",local:"recommended-via-cloud-run-service-url",headingTag:"h3"}}),Ue=new w({props:{code:"U0VSVklDRV9VUkwlM0QlMjQoZ2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBkZXNjcmliZSUyMCUyNFNFUlZJQ0VfTkFNRSUyMC0tcmVnaW9uJTIwJTI0TE9DQVRJT04lMjAtLWZvcm1hdCUyMCd2YWx1ZShzdGF0dXMudXJsKScp",highlighted:'SERVICE_URL=$(gcloud run services describe <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span> --format <span class="hljs-string">&#x27;value(status.url)&#x27;</span>)',wrap:!1}}),Ce=new w({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMHByaW50LWlkZW50aXR5LXRva2Vu",highlighted:"gcloud auth print-identity-token",wrap:!1}}),je=new w({props:{code:"aW1wb3J0JTIwZ29vZ2xlLmF1dGglMEFmcm9tJTIwZ29vZ2xlLmF1dGgudHJhbnNwb3J0LnJlcXVlc3RzJTIwaW1wb3J0JTIwUmVxdWVzdCUyMGFzJTIwR29vZ2xlQXV0aFJlcXVlc3QlMEElMEFhdXRoX3JlcSUyMCUzRCUyMEdvb2dsZUF1dGhSZXF1ZXN0KCklMEFjcmVkcyUyQyUyMF8lMjAlM0QlMjBnb29nbGUuYXV0aC5kZWZhdWx0KCklMEFjcmVkcy5yZWZyZXNoKGF1dGhfcmVxKSUwQSUwQWlkX3Rva2VuJTIwJTNEJTIwY3JlZHMuaWRfdG9rZW4=",highlighted:`<span class="hljs-keyword">import</span> google.auth
<span class="hljs-keyword">from</span> google.auth.transport.requests <span class="hljs-keyword">import</span> Request <span class="hljs-keyword">as</span> GoogleAuthRequest

auth_req = GoogleAuthRequest()
creds, _ = google.auth.default()
creds.refresh(auth_req)

id_token = creds.id_token`,wrap:!1}}),ve=new w({props:{code:"ZXhwb3J0JTIwU0VSVklDRV9BQ0NPVU5UX05BTUUlM0R0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlLWludm9rZXI=",highlighted:'<span class="hljs-built_in">export</span> SERVICE_ACCOUNT_NAME=text-generation-inference-invoker',wrap:!1}}),Ve=new w({props:{code:"Z2Nsb3VkJTIwaWFtJTIwc2VydmljZS1hY2NvdW50cyUyMGNyZWF0ZSUyMCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1F",highlighted:'gcloud iam service-accounts create <span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>',wrap:!1}}),Re=new w({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBhZGQtaWFtLXBvbGljeS1iaW5kaW5nJTIwJTI0U0VSVklDRV9OQU1FJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tZW1iZXIlM0QlMjJzZXJ2aWNlQWNjb3VudCUzQSUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcm9sZSUzRCUyMnJvbGVzJTJGcnVuLmludm9rZXIlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlZ2lvbiUzRCUyNExPQ0FUSU9O",highlighted:`gcloud run services add-iam-policy-binding <span class="hljs-variable">$SERVICE_NAME</span> \\
    --member=<span class="hljs-string">&quot;serviceAccount:<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com&quot;</span> \\
    --role=<span class="hljs-string">&quot;roles/run.invoker&quot;</span> \\
    --region=<span class="hljs-variable">$LOCATION</span>`,wrap:!1}}),Se=new w({props:{code:"ZXhwb3J0JTIwQUNDRVNTX1RPS0VOJTNEJTI0KGdjbG91ZCUyMGF1dGglMjBwcmludC1hY2Nlc3MtdG9rZW4lMjAtLWltcGVyc29uYXRlLXNlcnZpY2UtYWNjb3VudCUzRCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSk=",highlighted:'<span class="hljs-built_in">export</span> ACCESS_TOKEN=$(gcloud auth print-access-token --impersonate-service-account=<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com)',wrap:!1}}),N=new ct({props:{warning:!0,$$slots:{default:[as]},$$scope:{ctx:g}}}),S=new ct({props:{$$slots:{default:[os]},$$scope:{ctx:g}}}),Le=new U({props:{title:"cURL",local:"curl",headingTag:"h4"}}),Ge=new w({props:{code:"Y3VybCUyMCUyNFNFUlZJQ0VfVVJMJTJGdjElMkZjaGF0JTJGY29tcGxldGlvbnMlMjAlNUMlMEElMjAlMjAlMjAlMjAtWCUyMFBPU1QlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCUyMkF1dGhvcml6YXRpb24lM0ElMjBCZWFyZXIlMjAlMjRBQ0NFU1NfVE9LRU4lMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCdDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLWQlMjAnJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWwlMjIlM0ElMjAlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWF4X3Rva2VucyUyMiUzQSUyMDEyOCUwQSUyMCUyMCUyMCUyMCU3RCc=",highlighted:`curl <span class="hljs-variable">$SERVICE_URL</span>/v1/chat/completions \\
    -X POST \\
    -H <span class="hljs-string">&quot;Authorization: Bearer <span class="hljs-variable">$ACCESS_TOKEN</span>&quot;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tgi&quot;,
        &quot;messages&quot;: [
            {
                &quot;role&quot;: &quot;system&quot;,
                &quot;content&quot;: &quot;You are a helpful assistant.&quot;
            },
            {
                &quot;role&quot;: &quot;user&quot;,
                &quot;content&quot;: &quot;What is Deep Learning?&quot;
            }
        ],
        &quot;max_tokens&quot;: 128
    }&#x27;</span>`,wrap:!1}}),xe=new U({props:{title:"Python",local:"python",headingTag:"h4"}}),We=new U({props:{title:"huggingface_hub",local:"huggingfacehub",headingTag:"h5"}}),Qe=new w({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNEb3MuZ2V0ZW52KCUyMlNFUlZJQ0VfVVJMJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyQUNDRVNTX1RPS0VOJTIyKSUyQyUwQSklMEElMEFjaGF0X2NvbXBsZXRpb24lMjAlM0QlMjBjbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwbW9kZWwlM0QlMjJodWdnaW5nLXF1YW50cyUyRk1ldGEtTGxhbWEtMy4xLThCLUluc3RydWN0LUFXUS1JTlQ0JTIyJTJDJTBBJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMERlZXAlMjBMZWFybmluZyUzRiUyMiU3RCUyQyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMG1heF90b2tlbnMlM0QxMjglMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(
    base_url=os.getenv(<span class="hljs-string">&quot;SERVICE_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;ACCESS_TOKEN&quot;</span>),
)

chat_completion = client.chat.completions.create(
  model=<span class="hljs-string">&quot;hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4&quot;</span>,
  messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>},
  ],
  max_tokens=<span class="hljs-number">128</span>,
)`,wrap:!1}}),Be=new U({props:{title:"openai",local:"openai",headingTag:"h5"}}),Fe=new w({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBY2xpZW50JTIwJTNEJTIwT3BlbkFJKCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNEb3MuZ2V0ZW52KCUyMlNFUlZJQ0VfVVJMJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyQUNDRVNTX1RPS0VOJTIyKSUyQyUwQSklMEElMEFjaGF0X2NvbXBsZXRpb24lMjAlM0QlMjBjbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEyOCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

client = OpenAI(
    base_url=os.getenv(<span class="hljs-string">&quot;SERVICE_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;ACCESS_TOKEN&quot;</span>),
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>},
    ],
    max_tokens=<span class="hljs-number">128</span>,
)`,wrap:!1}}),Ye=new U({props:{title:"Resource clean up",local:"resource-clean-up",headingTag:"h2"}}),De=new w({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBkZWxldGUlMjAlMjRTRVJWSUNFX05BTUUlMjAtLXJlZ2lvbiUyMCUyNExPQ0FUSU9O",highlighted:'gcloud run services delete <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span>',wrap:!1}}),Ke=new w({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMHJldm9rZSUyMC0taW1wZXJzb25hdGUtc2VydmljZS1hY2NvdW50JTNEJTI0U0VSVklDRV9BQ0NPVU5UX05BTUUlNDAlMjRQUk9KRUNUX0lELmlhbS5nc2VydmljZWFjY291bnQuY29t",highlighted:'gcloud auth revoke --impersonate-service-account=<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com',wrap:!1}}),tt=new w({props:{code:"Z2Nsb3VkJTIwaWFtJTIwc2VydmljZS1hY2NvdW50cyUyMGRlbGV0ZSUyMCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbQ==",highlighted:'gcloud iam service-accounts delete <span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com',wrap:!1}}),lt=new U({props:{title:"References",local:"references",headingTag:"h2"}}),Z=new ct({props:{$$slots:{default:[is]},$$scope:{ctx:g}}}),st=new es({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/cloud-run-tgi-deployment.mdx"}}),{c(){o=i("meta"),y=s(),c=i("p"),f=s(),p(L.$$.fragment),gt=s(),q=i("p"),q.textContent=sn,Ut=s(),G=i("p"),G.innerHTML=an,It=s(),p(v.$$.fragment),Ct=s(),p(x.$$.fragment),jt=s(),k=i("p"),k.innerHTML=on,$t=s(),W=i("p"),W.textContent=un,bt=s(),p(_.$$.fragment),vt=s(),Q=i("p"),Q.textContent=rn,At=s(),p(B.$$.fragment),Vt=s(),X=i("p"),X.textContent=cn,Et=s(),p(F.$$.fragment),Rt=s(),p(Y.$$.fragment),Nt=s(),P=i("p"),P.innerHTML=pn,St=s(),H=i("p"),H.innerHTML=Mn,Zt=s(),D=i("ul"),D.innerHTML=dn,Lt=s(),p(z.$$.fragment),qt=s(),O=i("p"),O.innerHTML=Tn,Gt=s(),K=i("p"),K.innerHTML=hn,xt=s(),p(A.$$.fragment),kt=s(),p(ee.$$.fragment),Wt=s(),te=i("p"),te.innerHTML=Jn,_t=s(),le=i("p"),le.textContent=mn,Qt=s(),ne=i("p"),ne.innerHTML=yn,Bt=s(),p(V.$$.fragment),Xt=s(),p(se.$$.fragment),Ft=s(),ae=i("p"),ae.textContent=wn,Yt=s(),p(oe.$$.fragment),Pt=s(),ie=i("p"),ie.innerHTML=fn,Ht=s(),p(E.$$.fragment),Dt=s(),p(ue.$$.fragment),zt=s(),re=i("p"),re.innerHTML=gn,Ot=s(),p(ce.$$.fragment),Kt=s(),p(pe.$$.fragment),el=s(),Me=i("p"),Me.innerHTML=Un,tl=s(),p(de.$$.fragment),ll=s(),Te=i("p"),Te.innerHTML=In,nl=s(),p(he.$$.fragment),sl=s(),p(Je.$$.fragment),al=s(),me=i("p"),me.innerHTML=Cn,ol=s(),p(ye.$$.fragment),il=s(),p(we.$$.fragment),ul=s(),fe=i("p"),fe.textContent=jn,rl=s(),ge=i("p"),ge.innerHTML=$n,cl=s(),p(Ue.$$.fragment),pl=s(),Ie=i("p"),Ie.innerHTML=bn,Ml=s(),R=i("ul"),I=i("li"),Mt=i("p"),Mt.textContent=vn,Fl=s(),dt=i("ul"),dt.innerHTML=An,Yl=s(),p(Ce.$$.fragment),Pl=s(),Tt=i("ul"),Tt.innerHTML=Vn,Hl=s(),p(je.$$.fragment),Dl=s(),ht=i("li"),ht.innerHTML=En,dl=s(),$e=i("p"),$e.textContent=Rn,Tl=s(),j=i("ul"),be=i("li"),Jt=i("p"),Jt.innerHTML=Nn,zl=s(),p(ve.$$.fragment),Ol=s(),Ae=i("li"),mt=i("p"),mt.textContent=Sn,Kl=s(),p(Ve.$$.fragment),en=s(),Ee=i("li"),yt=i("p"),yt.textContent=Zn,tn=s(),p(Re.$$.fragment),ln=s(),Ne=i("li"),wt=i("p"),wt.textContent=Ln,nn=s(),p(Se.$$.fragment),hl=s(),p(N.$$.fragment),Jl=s(),Ze=i("p"),Ze.innerHTML=qn,ml=s(),p(S.$$.fragment),yl=s(),p(Le.$$.fragment),wl=s(),qe=i("p"),qe.innerHTML=Gn,fl=s(),p(Ge.$$.fragment),gl=s(),p(xe.$$.fragment),Ul=s(),ke=i("p"),ke.innerHTML=xn,Il=s(),p(We.$$.fragment),Cl=s(),_e=i("p"),_e.innerHTML=kn,jl=s(),p(Qe.$$.fragment),$l=s(),p(Be.$$.fragment),bl=s(),Xe=i("p"),Xe.innerHTML=Wn,vl=s(),p(Fe.$$.fragment),Al=s(),p(Ye.$$.fragment),Vl=s(),Pe=i("p"),Pe.textContent=_n,El=s(),He=i("p"),He.innerHTML=Qn,Rl=s(),p(De.$$.fragment),Nl=s(),ze=i("p"),ze.innerHTML=Bn,Sl=s(),Oe=i("ul"),Oe.innerHTML=Xn,Zl=s(),p(Ke.$$.fragment),Ll=s(),et=i("ul"),et.innerHTML=Fn,ql=s(),p(tt.$$.fragment),Gl=s(),p(lt.$$.fragment),xl=s(),nt=i("ul"),nt.innerHTML=Yn,kl=s(),Wl=i("hr"),_l=s(),p(Z.$$.fragment),Ql=s(),p(st.$$.fragment),Bl=s(),ft=i("p"),this.h()},l(e){const t=Kn("svelte-u9bgzb",document.head);o=u(t,"META",{name:!0,content:!0}),t.forEach(l),y=a(e),c=u(e,"P",{}),b(c).forEach(l),f=a(e),M(L.$$.fragment,e),gt=a(e),q=u(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-rqjgi7"&&(q.textContent=sn),Ut=a(e),G=u(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-mah12k"&&(G.innerHTML=an),It=a(e),M(v.$$.fragment,e),Ct=a(e),M(x.$$.fragment,e),jt=a(e),k=u(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1o67gfb"&&(k.innerHTML=on),$t=a(e),W=u(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1i8n6rq"&&(W.textContent=un),bt=a(e),M(_.$$.fragment,e),vt=a(e),Q=u(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-pfbeqd"&&(Q.textContent=rn),At=a(e),M(B.$$.fragment,e),Vt=a(e),X=u(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1usj4y5"&&(X.textContent=cn),Et=a(e),M(F.$$.fragment,e),Rt=a(e),M(Y.$$.fragment,e),Nt=a(e),P=u(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-v1hrv3"&&(P.innerHTML=pn),St=a(e),H=u(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1edwfmt"&&(H.innerHTML=Mn),Zt=a(e),D=u(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-1v1f721"&&(D.innerHTML=dn),Lt=a(e),M(z.$$.fragment,e),qt=a(e),O=u(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-h7x8wp"&&(O.innerHTML=Tn),Gt=a(e),K=u(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-epx368"&&(K.innerHTML=hn),xt=a(e),M(A.$$.fragment,e),kt=a(e),M(ee.$$.fragment,e),Wt=a(e),te=u(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1d9o3zj"&&(te.innerHTML=Jn),_t=a(e),le=u(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1gzo66i"&&(le.textContent=mn),Qt=a(e),ne=u(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1rn2q59"&&(ne.innerHTML=yn),Bt=a(e),M(V.$$.fragment,e),Xt=a(e),M(se.$$.fragment,e),Ft=a(e),ae=u(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1n42sxg"&&(ae.textContent=wn),Yt=a(e),M(oe.$$.fragment,e),Pt=a(e),ie=u(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-yd30oz"&&(ie.innerHTML=fn),Ht=a(e),M(E.$$.fragment,e),Dt=a(e),M(ue.$$.fragment,e),zt=a(e),re=u(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1ks8djk"&&(re.innerHTML=gn),Ot=a(e),M(ce.$$.fragment,e),Kt=a(e),M(pe.$$.fragment,e),el=a(e),Me=u(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-wqgbww"&&(Me.innerHTML=Un),tl=a(e),M(de.$$.fragment,e),ll=a(e),Te=u(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-u758zp"&&(Te.innerHTML=In),nl=a(e),M(he.$$.fragment,e),sl=a(e),M(Je.$$.fragment,e),al=a(e),me=u(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1bjj57d"&&(me.innerHTML=Cn),ol=a(e),M(ye.$$.fragment,e),il=a(e),M(we.$$.fragment,e),ul=a(e),fe=u(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1o5h253"&&(fe.textContent=jn),rl=a(e),ge=u(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-7kvofg"&&(ge.innerHTML=$n),cl=a(e),M(Ue.$$.fragment,e),pl=a(e),Ie=u(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-niuemd"&&(Ie.innerHTML=bn),Ml=a(e),R=u(e,"UL",{});var at=b(R);I=u(at,"LI",{});var C=b(I);Mt=u(C,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-4rg0sg"&&(Mt.textContent=vn),Fl=a(C),dt=u(C,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-1vwi62o"&&(dt.innerHTML=An),Yl=a(C),M(Ce.$$.fragment,C),Pl=a(C),Tt=u(C,"UL",{"data-svelte-h":!0}),r(Tt)!=="svelte-b6nbfv"&&(Tt.innerHTML=Vn),Hl=a(C),M(je.$$.fragment,C),C.forEach(l),Dl=a(at),ht=u(at,"LI",{"data-svelte-h":!0}),r(ht)!=="svelte-1v3f4rq"&&(ht.innerHTML=En),at.forEach(l),dl=a(e),$e=u(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-18iwnqm"&&($e.textContent=Rn),Tl=a(e),j=u(e,"UL",{});var $=b(j);be=u($,"LI",{});var ot=b(be);Jt=u(ot,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-tbapg4"&&(Jt.innerHTML=Nn),zl=a(ot),M(ve.$$.fragment,ot),ot.forEach(l),Ol=a($),Ae=u($,"LI",{});var it=b(Ae);mt=u(it,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1nwc9xz"&&(mt.textContent=Sn),Kl=a(it),M(Ve.$$.fragment,it),it.forEach(l),en=a($),Ee=u($,"LI",{});var ut=b(Ee);yt=u(ut,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-19ickcu"&&(yt.textContent=Zn),tn=a(ut),M(Re.$$.fragment,ut),ut.forEach(l),ln=a($),Ne=u($,"LI",{});var rt=b(Ne);wt=u(rt,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-v6tnr5"&&(wt.textContent=Ln),nn=a(rt),M(Se.$$.fragment,rt),rt.forEach(l),$.forEach(l),hl=a(e),M(N.$$.fragment,e),Jl=a(e),Ze=u(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-ur1pan"&&(Ze.innerHTML=qn),ml=a(e),M(S.$$.fragment,e),yl=a(e),M(Le.$$.fragment,e),wl=a(e),qe=u(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1ks8djk"&&(qe.innerHTML=Gn),fl=a(e),M(Ge.$$.fragment,e),gl=a(e),M(xe.$$.fragment,e),Ul=a(e),ke=u(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-wqgbww"&&(ke.innerHTML=xn),Il=a(e),M(We.$$.fragment,e),Cl=a(e),_e=u(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-u758zp"&&(_e.innerHTML=kn),jl=a(e),M(Qe.$$.fragment,e),$l=a(e),M(Be.$$.fragment,e),bl=a(e),Xe=u(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1bjj57d"&&(Xe.innerHTML=Wn),vl=a(e),M(Fe.$$.fragment,e),Al=a(e),M(Ye.$$.fragment,e),Vl=a(e),Pe=u(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-qym8z6"&&(Pe.textContent=_n),El=a(e),He=u(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1sjp15c"&&(He.innerHTML=Qn),Rl=a(e),M(De.$$.fragment,e),Nl=a(e),ze=u(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-l00oox"&&(ze.innerHTML=Bn),Sl=a(e),Oe=u(e,"UL",{"data-svelte-h":!0}),r(Oe)!=="svelte-hs3g2x"&&(Oe.innerHTML=Xn),Zl=a(e),M(Ke.$$.fragment,e),Ll=a(e),et=u(e,"UL",{"data-svelte-h":!0}),r(et)!=="svelte-1toh59e"&&(et.innerHTML=Fn),ql=a(e),M(tt.$$.fragment,e),Gl=a(e),M(lt.$$.fragment,e),xl=a(e),nt=u(e,"UL",{"data-svelte-h":!0}),r(nt)!=="svelte-1fx9lvo"&&(nt.innerHTML=Yn),kl=a(e),Wl=u(e,"HR",{}),_l=a(e),M(Z.$$.fragment,e),Ql=a(e),M(st.$$.fragment,e),Bl=a(e),ft=u(e,"P",{}),b(ft).forEach(l),this.h()},h(){Pn(o,"name","hf:doc:metadata"),Pn(o,"content",rs)},m(e,t){m(document.head,o),n(e,y,t),n(e,c,t),n(e,f,t),d(L,e,t),n(e,gt,t),n(e,q,t),n(e,Ut,t),n(e,G,t),n(e,It,t),d(v,e,t),n(e,Ct,t),d(x,e,t),n(e,jt,t),n(e,k,t),n(e,$t,t),n(e,W,t),n(e,bt,t),d(_,e,t),n(e,vt,t),n(e,Q,t),n(e,At,t),d(B,e,t),n(e,Vt,t),n(e,X,t),n(e,Et,t),d(F,e,t),n(e,Rt,t),d(Y,e,t),n(e,Nt,t),n(e,P,t),n(e,St,t),n(e,H,t),n(e,Zt,t),n(e,D,t),n(e,Lt,t),d(z,e,t),n(e,qt,t),n(e,O,t),n(e,Gt,t),n(e,K,t),n(e,xt,t),d(A,e,t),n(e,kt,t),d(ee,e,t),n(e,Wt,t),n(e,te,t),n(e,_t,t),n(e,le,t),n(e,Qt,t),n(e,ne,t),n(e,Bt,t),d(V,e,t),n(e,Xt,t),d(se,e,t),n(e,Ft,t),n(e,ae,t),n(e,Yt,t),d(oe,e,t),n(e,Pt,t),n(e,ie,t),n(e,Ht,t),d(E,e,t),n(e,Dt,t),d(ue,e,t),n(e,zt,t),n(e,re,t),n(e,Ot,t),d(ce,e,t),n(e,Kt,t),d(pe,e,t),n(e,el,t),n(e,Me,t),n(e,tl,t),d(de,e,t),n(e,ll,t),n(e,Te,t),n(e,nl,t),d(he,e,t),n(e,sl,t),d(Je,e,t),n(e,al,t),n(e,me,t),n(e,ol,t),d(ye,e,t),n(e,il,t),d(we,e,t),n(e,ul,t),n(e,fe,t),n(e,rl,t),n(e,ge,t),n(e,cl,t),d(Ue,e,t),n(e,pl,t),n(e,Ie,t),n(e,Ml,t),n(e,R,t),m(R,I),m(I,Mt),m(I,Fl),m(I,dt),m(I,Yl),d(Ce,I,null),m(I,Pl),m(I,Tt),m(I,Hl),d(je,I,null),m(R,Dl),m(R,ht),n(e,dl,t),n(e,$e,t),n(e,Tl,t),n(e,j,t),m(j,be),m(be,Jt),m(be,zl),d(ve,be,null),m(j,Ol),m(j,Ae),m(Ae,mt),m(Ae,Kl),d(Ve,Ae,null),m(j,en),m(j,Ee),m(Ee,yt),m(Ee,tn),d(Re,Ee,null),m(j,ln),m(j,Ne),m(Ne,wt),m(Ne,nn),d(Se,Ne,null),n(e,hl,t),d(N,e,t),n(e,Jl,t),n(e,Ze,t),n(e,ml,t),d(S,e,t),n(e,yl,t),d(Le,e,t),n(e,wl,t),n(e,qe,t),n(e,fl,t),d(Ge,e,t),n(e,gl,t),d(xe,e,t),n(e,Ul,t),n(e,ke,t),n(e,Il,t),d(We,e,t),n(e,Cl,t),n(e,_e,t),n(e,jl,t),d(Qe,e,t),n(e,$l,t),d(Be,e,t),n(e,bl,t),n(e,Xe,t),n(e,vl,t),d(Fe,e,t),n(e,Al,t),d(Ye,e,t),n(e,Vl,t),n(e,Pe,t),n(e,El,t),n(e,He,t),n(e,Rl,t),d(De,e,t),n(e,Nl,t),n(e,ze,t),n(e,Sl,t),n(e,Oe,t),n(e,Zl,t),d(Ke,e,t),n(e,Ll,t),n(e,et,t),n(e,ql,t),d(tt,e,t),n(e,Gl,t),d(lt,e,t),n(e,xl,t),n(e,nt,t),n(e,kl,t),n(e,Wl,t),n(e,_l,t),d(Z,e,t),n(e,Ql,t),d(st,e,t),n(e,Bl,t),n(e,ft,t),Xl=!0},p(e,[t]){const at={};t&2&&(at.$$scope={dirty:t,ctx:e}),v.$set(at);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),A.$set(C);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),V.$set($);const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),E.$set(ot);const it={};t&2&&(it.$$scope={dirty:t,ctx:e}),N.$set(it);const ut={};t&2&&(ut.$$scope={dirty:t,ctx:e}),S.$set(ut);const rt={};t&2&&(rt.$$scope={dirty:t,ctx:e}),Z.$set(rt)},i(e){Xl||(T(L.$$.fragment,e),T(v.$$.fragment,e),T(x.$$.fragment,e),T(_.$$.fragment,e),T(B.$$.fragment,e),T(F.$$.fragment,e),T(Y.$$.fragment,e),T(z.$$.fragment,e),T(A.$$.fragment,e),T(ee.$$.fragment,e),T(V.$$.fragment,e),T(se.$$.fragment,e),T(oe.$$.fragment,e),T(E.$$.fragment,e),T(ue.$$.fragment,e),T(ce.$$.fragment,e),T(pe.$$.fragment,e),T(de.$$.fragment,e),T(he.$$.fragment,e),T(Je.$$.fragment,e),T(ye.$$.fragment,e),T(we.$$.fragment,e),T(Ue.$$.fragment,e),T(Ce.$$.fragment,e),T(je.$$.fragment,e),T(ve.$$.fragment,e),T(Ve.$$.fragment,e),T(Re.$$.fragment,e),T(Se.$$.fragment,e),T(N.$$.fragment,e),T(S.$$.fragment,e),T(Le.$$.fragment,e),T(Ge.$$.fragment,e),T(xe.$$.fragment,e),T(We.$$.fragment,e),T(Qe.$$.fragment,e),T(Be.$$.fragment,e),T(Fe.$$.fragment,e),T(Ye.$$.fragment,e),T(De.$$.fragment,e),T(Ke.$$.fragment,e),T(tt.$$.fragment,e),T(lt.$$.fragment,e),T(Z.$$.fragment,e),T(st.$$.fragment,e),Xl=!0)},o(e){h(L.$$.fragment,e),h(v.$$.fragment,e),h(x.$$.fragment,e),h(_.$$.fragment,e),h(B.$$.fragment,e),h(F.$$.fragment,e),h(Y.$$.fragment,e),h(z.$$.fragment,e),h(A.$$.fragment,e),h(ee.$$.fragment,e),h(V.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(E.$$.fragment,e),h(ue.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),h(Je.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(Ue.$$.fragment,e),h(Ce.$$.fragment,e),h(je.$$.fragment,e),h(ve.$$.fragment,e),h(Ve.$$.fragment,e),h(Re.$$.fragment,e),h(Se.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(Le.$$.fragment,e),h(Ge.$$.fragment,e),h(xe.$$.fragment,e),h(We.$$.fragment,e),h(Qe.$$.fragment,e),h(Be.$$.fragment,e),h(Fe.$$.fragment,e),h(Ye.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(tt.$$.fragment,e),h(lt.$$.fragment,e),h(Z.$$.fragment,e),h(st.$$.fragment,e),Xl=!1},d(e){e&&(l(y),l(c),l(f),l(gt),l(q),l(Ut),l(G),l(It),l(Ct),l(jt),l(k),l($t),l(W),l(bt),l(vt),l(Q),l(At),l(Vt),l(X),l(Et),l(Rt),l(Nt),l(P),l(St),l(H),l(Zt),l(D),l(Lt),l(qt),l(O),l(Gt),l(K),l(xt),l(kt),l(Wt),l(te),l(_t),l(le),l(Qt),l(ne),l(Bt),l(Xt),l(Ft),l(ae),l(Yt),l(Pt),l(ie),l(Ht),l(Dt),l(zt),l(re),l(Ot),l(Kt),l(el),l(Me),l(tl),l(ll),l(Te),l(nl),l(sl),l(al),l(me),l(ol),l(il),l(ul),l(fe),l(rl),l(ge),l(cl),l(pl),l(Ie),l(Ml),l(R),l(dl),l($e),l(Tl),l(j),l(hl),l(Jl),l(Ze),l(ml),l(yl),l(wl),l(qe),l(fl),l(gl),l(Ul),l(ke),l(Il),l(Cl),l(_e),l(jl),l($l),l(bl),l(Xe),l(vl),l(Al),l(Vl),l(Pe),l(El),l(He),l(Rl),l(Nl),l(ze),l(Sl),l(Oe),l(Zl),l(Ll),l(et),l(ql),l(Gl),l(xl),l(nt),l(kl),l(Wl),l(_l),l(Ql),l(Bl),l(ft)),l(o),J(L,e),J(v,e),J(x,e),J(_,e),J(B,e),J(F,e),J(Y,e),J(z,e),J(A,e),J(ee,e),J(V,e),J(se,e),J(oe,e),J(E,e),J(ue,e),J(ce,e),J(pe,e),J(de,e),J(he,e),J(Je,e),J(ye,e),J(we,e),J(Ue,e),J(Ce),J(je),J(ve),J(Ve),J(Re),J(Se),J(N,e),J(S,e),J(Le,e),J(Ge,e),J(xe,e),J(We,e),J(Qe,e),J(Be,e),J(Fe,e),J(Ye,e),J(De,e),J(Ke,e),J(tt,e),J(lt,e),J(Z,e),J(st,e)}}}const rs='{"title":"Deploy Meta Llama 3.1 8B with TGI DLC on Cloud Run","local":"deploy-meta-llama-31-8b-with-tgi-dlc-on-cloud-run","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Deploy TGI on Cloud Run","local":"deploy-tgi-on-cloud-run","sections":[],"depth":2},{"title":"Inference on Cloud Run","local":"inference-on-cloud-run","sections":[{"title":"Via Cloud Run Proxy","local":"via-cloud-run-proxy","sections":[{"title":"cURL","local":"curl","sections":[],"depth":4},{"title":"Python","local":"python","sections":[{"title":"huggingface_hub","local":"huggingfacehub","sections":[],"depth":5},{"title":"openai","local":"openai","sections":[],"depth":5}],"depth":4}],"depth":3},{"title":"(recommended) Via Cloud Run Service URL","local":"recommended-via-cloud-run-service-url","sections":[{"title":"cURL","local":"curl","sections":[],"depth":4},{"title":"Python","local":"python","sections":[{"title":"huggingface_hub","local":"huggingfacehub","sections":[],"depth":5},{"title":"openai","local":"openai","sections":[],"depth":5}],"depth":4}],"depth":3}],"depth":2},{"title":"Resource clean up","local":"resource-clean-up","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function cs(g){return Dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Js extends zn{constructor(o){super(),On(this,o,cs,us,Hn,{})}}export{Js as component};
