import{s as Tn,f as wn,o as yn,n as cn}from"../chunks/scheduler.3e4cb221.js";import{S as Jn,i as hn,g as i,s as n,r as M,A as gn,h as o,f as l,c as a,j as yt,u as p,x as r,k as Jt,y as ut,a as s,v as m,d as u,t as d,w as c}from"../chunks/index.bc693fcb.js";import{T as dn}from"../chunks/Tip.26bcdf6b.js";import{C as w}from"../chunks/CodeBlock.4d312707.js";import{C as Un}from"../chunks/CourseFloatingBanner.e22f32dd.js";import{H as y,E as fn}from"../chunks/getInferenceSnippets.322ff9ba.js";function In(dt){let T,h="<li>You need a GPU with at least 8GB VRAM for training. CPU/MPS can run formatting and dataset exploration, but training larger models will likely fail.</li> <li>First run will download several GB of model weights; ensure 15GB+ free disk and a stable connection.</li> <li>If you need access to private repos, authenticate with Hugging Face Hub via <code>login()</code>.</li>";return{c(){T=i("ul"),T.innerHTML=h},l(J){T=o(J,"UL",{"data-svelte-h":!0}),r(T)!=="svelte-dj9x0w"&&(T.innerHTML=h)},m(J,U){s(J,T,U)},p:cn,d(J){J&&l(T)}}}function jn(dt){let T,h='You can create and copy your access token from the <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face tokens page</a> in your profile.';return{c(){T=i("p"),T.innerHTML=h},l(J){T=o(J,"P",{"data-svelte-h":!0}),r(T)!=="svelte-104d433"&&(T.innerHTML=h)},m(J,U){s(J,T,U)},p:cn,d(J){J&&l(T)}}}function bn(dt){let T,h,J,U,$,gt,v,Ut,B,ds=`Welcome to the practical section! Here you’ll put into practice everything you’ve learned about vision language models (VLMs) using <strong>HuggingFaceTB/SmolVLM2-2.2B-Instruct</strong>.<br/>
The exercises progress from foundational concepts to advanced techniques, helping you gain real-world, hands-on experience.`,ft,_,It,Z,cs="By the end of these exercises, you will be able to:",jt,A,Ts="<li><strong>Work with VLM datasets</strong>: Explore and prepare <strong>HuggingFaceM4/ChartQA</strong>.</li> <li><strong>Optimize training</strong>: Apply <strong>quantization</strong> and <strong>PEFT</strong> for efficient fine-tuning.</li> <li><strong>Fine-tune models in practice</strong>: Train <strong>HuggingFaceTB/SmolVLM2-2.2B-Instruct</strong> using both Python APIs and CLI tools.</li> <li><strong>Adapt datasets for TRL</strong>: Prepare VLM datasets to integrate seamlessly with TRL workflows.</li> <li><strong>Move to production</strong>: Understand how to scale and manage <strong>production-ready fine-tuning workflows</strong> for VLMs.</li>",bt,W,Ct,H,ws="<strong>Objective:</strong> Get familiar with the <code>SmolVLM2-2.2B-Instruct</code> model and evaluate the model using a sample from the dataset.",$t,x,vt,f,Bt,R,ys=`First, install the required libraries: <code>transformers</code>, <code>datasets</code>, <code>trl</code>,<code>huggingface_hub</code>, and <code>trackio</code>.<br/>
These packages provide the tools for working with the model, datasets, and Hugging Face Hub.`,_t,F,Zt,L,At,G,Js="Now, import the main dependencies we’ll use:",Wt,k,Ht,V,xt,E,Rt,Q,hs="We start by selecting the device where the model will run. It can be a GPU (<code>cuda</code>), Apple Silicon (<code>mps</code>), or the CPU as a fallback.",Ft,X,Lt,N,Gt,S,gs="To work with private models or to <strong>push your fine-tuned model to the Hub</strong> (as we’ll do in this exercise), you need to authenticate with your Hugging Face account.",kt,I,Vt,Y,Et,z,Qt,q,Us=`Finally, we load the <strong>HuggingFaceTB/SmolVLM2-2.2B-Instruct</strong> model.
The <code>AutoProcessor</code> is also initialized here — it ensures that both text and images are preprocessed correctly before being passed to the model.`,Xt,P,Nt,D,St,K,fs="In this step, we load a small subset of the <strong>ChartQA</strong> dataset — just 10% of the training and validation splits — to keep the exercises fast and manageable for learning purposes.",Yt,O,Is=`We then display one of the chart images using <code>matplotlib</code> to get a visual sense of the model’s input.<br/>
Additionally, we print the corresponding query and label so you can fully understand the dataset structure and the type of tasks the model will handle.`,zt,g,js,qt,ee,Pt,j,ct,bs="Output",ps,te,Dt,le,Kt,se,Cs='<img src="https://huggingface.co/datasets/smol-course/images/resolve/main/model_output.png" alt="Model output"/>',Ot,ne,el,ae,$s="We create a <strong>chat message list</strong> that includes a user query along with the image.",tl,ie,vs="Using <code>processor.apply_chat_template</code>, we transform this into the exact input format the model expects.",ll,oe,sl,b,Tt,Bs="Output",ms,re,nl,Me,al,pe,_s=`We tokenize the chat prompt and image into tensors, then generate a response with the model.
Finally, we decode the output tokens back into text.`,il,me,ol,C,wt,Zs="Output",us,ue,rl,de,As="The model generates a reponse, but it’s not exactly correct. It could be improved with some fine-tuning. Now that we’ve seen how to build prompts and generate responses with <strong>SmolVLM2-2.2B-Instruct</strong>, it’s time to learn how to adapt and <strong>fine-tune</strong> the model efficiently using <strong>LoRA (Low-Rank Adaptation)</strong>. This approach allows training large models with fewer resources and prepares the model for specific downstream tasks.",Ml,ce,pl,Te,Ws="In this exercise, we’ll apply <strong>LoRA (Low-Rank Adaptation)</strong> to fine-tune our Vision-Language Model efficiently.",ml,we,Hs=`LoRA works by injecting <strong>trainable low-rank matrices</strong> into existing model layers, enabling <strong>large models to be fine-tuned with significantly fewer trainable parameters</strong>.<br/>
This approach reduces memory usage and speeds up training while maintaining high performance.`,ul,ye,dl,Je,xs="We’ll format the dataset into a <strong>chatbot-style structure</strong>, where each example includes:",cl,he,Rs="<li>A <strong>system message</strong> defining the assistant’s role</li> <li>The <strong>chart image</strong></li> <li>The <strong>user query</strong></li> <li>The <strong>expected answer</strong></li>",Tl,ge,Fs=`This is the format expected by the <code>SFTTrainer</code>, including the <code>images</code> and <code>messages</code> columns.<br/>
You can learn more about preparing datasets for VLM post-training in the <a href="https://huggingface.co/docs/trl/en/sft_trainer#training-vision-language-models" rel="nofollow">documentation</a>.`,wl,yl,Jl,Ue,hl,fe,Ls=`The first step is to structure the dataset for VLM training.<br/>
We’ll define a <strong>system message</strong> that instructs the model to act as a <strong>chart analysis expert</strong>, providing <strong>concise, accurate answers</strong> about chart images.`,gl,Ie,Ul,je,Gs="Now, let’s format the data using the chatbot structure. This will set up the interactions for the model.",fl,be,Il,Ce,jl,$e,ks="Here we define a <code>LoraConfig</code>:",bl,ve,Vs="<li><code>r</code> and <code>lora_alpha</code> control the rank and scaling of the adaptation matrices.</li> <li><code>target_modules</code> specifies which parts of the model to adapt.</li> <li><code>task_type</code> is set for causal language modeling.</li>",Cl,Be,Es="We then apply LoRA to the base model using <code>get_peft_model</code> and print out the trainable parameters to verify the adaptation.",$l,_e,vl,Ze,Bl,Ae,Qs="We configure the <strong>SFTTrainer</strong> from <code>trl</code> with <code>SFTConfig</code>:",_l,We,Xs="<li><code>num_train_epochs</code>, <code>batch_size</code>, and <code>gradient_accumulation_steps</code> control the training loop.</li> <li><code>gradient_checkpointing</code>, and <code>bf16</code> optimize memory and speed.</li> <li><code>learning_rate</code> manages optimization.</li> <li><code>train_dataset</code> and <code>eval_dataset</code> are aligned with your dataset.</li>",Zl,He,Ns="This prepares the trainer to handle fine-tuning with PEFT/LoRA.",Al,xe,Wl,Re,Hl,Fe,Ss="Now we run the training loop:",xl,Le,Ys="<li><code>trainer.train()</code> starts fine-tuning with LoRA.</li> <li><code>trainer.save_model()</code> stores the locally trained model.</li>",Rl,Ge,zs="This step ensures the model is ready for downstream tasks with minimal additional parameters.",Fl,ke,Ll,Ve,qs="With the foundations of Python-based fine-tuning and LoRA in place, we can now move this workflow to a <strong>production environment</strong> using the <strong>TRL CLI</strong>. This approach lets you automate fine-tuning and create reproducible pipelines without writing full Python scripts.",Gl,Ee,kl,Qe,Ps="In the previous exercises, we focused on using the Python API to fine-tune <strong>SmolVLM2-2.2B-Instruct</strong>, exploring dataset preparation and generating chat-style prompts.",Vl,Xe,Ds='In this exercise, we’ll demonstrate how to perform fine-tuning using the <strong>TRL CLI</strong>, a common workflow in production environments. The CLI allows you to run experiments and manage training without writing Python scripts. If you want a refresher, we previously introduced this tool <a href="../unit1/4#exercise-4-production-workflow-with-trl-cli">here</a>, and the same concepts and troubleshooting tips apply.',El,Ne,Ks="The TRL CLI leverages the same logic and configuration options as the Python API but presents them through a simple command-line interface. This means you can define everything—from the model and dataset to training hyperparameters and output location—in a single command.",Ql,Se,Os="The example below shows how to fine-tune <strong>SmolVLM2-2.2B-Instruct</strong> on the <strong>trl-lib/llava-instruct-mix</strong> dataset, using LoRA for parameter-efficient fine-tuning, mixed precision for faster training, and optional push-to-Hub for sharing your model. The dataset now is different.",Xl,Ye,en="We are using a different dataset here because it already comes formatted in the expected VLM structure, as discussed earlier.",Nl,ze,tn="<li><code>--model_name_or_path</code> specifies the base model to fine-tune.</li> <li><code>--dataset_name</code> and <code>--dataset_config</code> define the dataset and subset.</li> <li><code>--output_dir</code> sets the local directory for saving the fine-tuned model.</li> <li><code>--per_device_train_batch_size</code> and <code>--gradient_accumulation_steps</code> control effective batch size and memory usage.</li> <li><code>--learning_rate</code>, <code>--num_train_epochs</code>, and <code>--max_length</code> define the core training hyperparameters.</li> <li><code>--bf16</code> enables mixed precision for faster and more memory-efficient training on compatible GPUs.</li> <li><code>--push_to_hub</code> and <code>--hub_model_id</code> allow automatic upload of the trained model to your Hugging Face Hub repository.</li>",Sl,qe,ln="Using the TRL CLI is functionally equivalent to writing a full Python training script, but it’s faster to configure, easier to reproduce, and ideal for production pipelines or automated training workflows.",Yl,Pe,zl,De,ql,Ke,sn=`In <a href="../unit1/5">Unit 1</a>, we introduced <strong>Hugging Face Jobs (HF Jobs)</strong> and demonstrated how to fine-tune a model using this managed cloud service.<br/>
HF Jobs provides a <strong>fully managed infrastructure</strong> for training models, eliminating the need to set up GPUs, manage dependencies, or configure environments locally. This is especially useful for <strong>SFT training</strong>, which can be both resource-intensive and time-consuming.`,Pl,Oe,nn=`Following the same approach, we can use HF Jobs to fine-tune our Vision-Language Model (VLM).<br/>
If needed, refer back to Unit 1 to refresh your understanding of HF Jobs and their workflow.`,Dl,et,an="Here’s an example of how to launch a training job using <strong>TRL’s maintained SFT script</strong>:",Kl,tt,Ol,lt,on="After launching the job, HF Jobs will handle the <strong>entire training process</strong> in the cloud. You can monitor progress, view logs, and track metrics directly from the Hugging Face Hub.",es,st,rn="Once the job completes:",ts,nt,Mn="<li>The <strong>fine-tuned model</strong> will be available in the <code>output_dir</code> you specified.</li> <li>If <code>--push_to_hub</code> was used, the model will also be <strong>accessible from your Hugging Face account</strong>, ready for inference or further fine-tuning.</li> <li>You can <strong>resume, replicate, or scale</strong> training easily by re-running or modifying the job configuration.</li>",ls,at,pn="This workflow removes the overhead of managing local resources, allowing you to focus on <strong>model experimentation and evaluation</strong>.",ss,it,ns,ot,mn="Here are some helpful resources to deepen your understanding and continue experimenting with vision language models and TRL workflows:",as,rt,un='<li><strong><a href="https://huggingface.co/docs/trl/" rel="nofollow">TRL Documentation</a></strong> – Complete reference for using TRL, including Python API and CLI.</li> <li><strong><a href="https://huggingface.co/HuggingFaceTB/SmolVLM2-2.2B-Instruct" rel="nofollow">HuggingFaceTB/SmolVLM2-2.2B-Instruct Model Card</a></strong> – Detailed information about the model architecture, training, and usage.</li> <li><strong><a href="https://huggingface.co/datasets/HuggingFaceM4/ChartQA" rel="nofollow">HuggingFaceM4/ChartQA Dataset</a></strong> – Dataset used for training and fine-tuning VLMs.</li> <li><strong><a href="https://huggingface.co/" rel="nofollow">Hugging Face Hub</a></strong> – Platform to share your fine-tuned models and discover community models.</li> <li><strong><a href="https://discord.gg/huggingface" rel="nofollow">Hugging Face Discord Community</a></strong> – Join the community for discussions, support, and troubleshooting.</li>',is,Mt,os,ht,rs;return $=new y({props:{title:"Hands-On Exercises: Fine-Tuning SmolVLM2-2.2B-Instruct",local:"hands-on-exercises-fine-tuning-smolvlm2-22b-instruct",headingTag:"h1"}}),v=new Un({props:{chapter:10,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/4/4.ipynb"}]}}),_=new y({props:{title:"Learning Objectives",local:"learning-objectives",headingTag:"h2"}}),W=new y({props:{title:"Exercise 1: Explore SmolVLM2-2.2B-Instruct",local:"exercise-1-explore-smolvlm2-22b-instruct",headingTag:"h3"}}),x=new y({props:{title:"Environment Setup",local:"environment-setup",headingTag:"h3"}}),f=new dn({props:{warning:!0,$$slots:{default:[In]},$$scope:{ctx:dt}}}),F=new w({props:{code:"JTIzJTIwSW5zdGFsbCUyMHJlcXVpcmVkJTIwcGFja2FnZXMlMjAocnVuJTIwaW4lMjBDb2xhYiUyMG9yJTIweW91ciUyMGVudmlyb25tZW50KSUwQXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cyUyMHRybCUyMGh1Z2dpbmdmYWNlX2h1YiUyMHRyYWNraW8lMjBudW0yd29yZHMlM0QlM0QwLjUuMTQ=",highlighted:`<span class="hljs-comment"># Install required packages (run in Colab or your environment)</span>
pip install transformers datasets trl huggingface_hub trackio num2words==0.5.14`,wrap:!1}}),L=new y({props:{title:"Import dependencies",local:"import-dependencies",headingTag:"h3"}}),k=new w({props:{code:"JTIzJTIwSW1wb3J0JTIwZGVwZW5kZW5jaWVzJTBBJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBvcyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvUHJvY2Vzc29yJTJDJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0JTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5pbWFnZV91dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2U=",highlighted:`<span class="hljs-comment"># Import dependencies</span>

<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText, BitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers.image_utils <span class="hljs-keyword">import</span> load_image`,wrap:!1}}),V=new y({props:{title:"Load the model and processor",local:"load-the-model-and-processor",headingTag:"h3"}}),E=new y({props:{title:"1. Select the device",local:"1-select-the-device",headingTag:"h4"}}),X=new w({props:{code:"ZGV2aWNlJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmN1ZGElMjIlMEElMjAlMjAlMjAlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMEElMjAlMjAlMjAlMjBlbHNlJTIwJTIybXBzJTIyJTIwaWYlMjB0b3JjaC5iYWNrZW5kcy5tcHMuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBKQ==",highlighted:`device = (
    <span class="hljs-string">&quot;cuda&quot;</span>
    <span class="hljs-keyword">if</span> torch.cuda.is_available()
    <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;mps&quot;</span> <span class="hljs-keyword">if</span> torch.backends.mps.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
)`,wrap:!1}}),N=new y({props:{title:"2. Authenticate with Hugging Face",local:"2-authenticate-with-hugging-face",headingTag:"h4"}}),I=new dn({props:{$$slots:{default:[jn]},$$scope:{ctx:dt}}}),Y=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
login()`,wrap:!1}}),z=new y({props:{title:"3. Load the model and processor",local:"3-load-the-model-and-processor",headingTag:"h4"}}),P=new w({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sVkxNMi0yLjJCLUluc3RydWN0JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBkdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKS50byhkZXZpY2UpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolVLM2-2.2B-Instruct&quot;</span>
model = AutoModelForImageTextToText.from_pretrained(
    model_name,
    dtype=torch.bfloat16,
).to(device)

processor = AutoProcessor.from_pretrained(model_name)`,wrap:!1}}),D=new y({props:{title:"Explore the dataset",local:"explore-the-dataset",headingTag:"h3"}}),ee=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXRyYWluX2RhdGFzZXQlMkMlMjBldmFsX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIySHVnZ2luZ0ZhY2VNNCUyRkNoYXJ0UUElMjIlMkMlMjBzcGxpdCUzRCU1QiUyMnRyYWluJTVCJTNBMTAlMjUlNUQlMjIlMkMlMjAlMjJ2YWwlNUIlM0ExMCUyNSU1RCUyMiU1RCklMEFleGFtcGxlJTIwJTNEJTIwdHJhaW5fZGF0YXNldCU1QjElNUQlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoZXhhbXBsZSU1QiUyMmltYWdlJTIyJTVEKSUwQSUwQXByaW50KGV4YW1wbGUlNUIlMjJxdWVyeSUyMiU1RCklMEFwcmludChleGFtcGxlJTVCJTIybGFiZWwlMjIlNUQlNUIwJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

train_dataset, eval_dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceM4/ChartQA&quot;</span>, split=[<span class="hljs-string">&quot;train[:10%]&quot;</span>, <span class="hljs-string">&quot;val[:10%]&quot;</span>])
example = train_dataset[<span class="hljs-number">1</span>]
image = load_image(example[<span class="hljs-string">&quot;image&quot;</span>])

<span class="hljs-built_in">print</span>(example[<span class="hljs-string">&quot;query&quot;</span>])
<span class="hljs-built_in">print</span>(example[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),te=new w({props:{code:"SG93JTIwbWFueSUyMHZhbHVlcyUyMGFyZSUyMGJlbG93JTIwNDAlMjBpbiUyMFVuZmF2b3JhYmxlJTIwZ3JhcGglM0YlMEE2",highlighted:`How many values are below 40 in Unfavorable graph?
6`,wrap:!1}}),le=new w({props:{code:"cGx0Lmltc2hvdyhpbWFnZSklMEFwbHQuYXhpcyglMjJvZmYlMjIpJTBBcGx0LnRpdGxlKCUyMlNhbXBsZSUyMENoYXJ0JTIwSW1hZ2UlMjIpJTBBcGx0LnNob3coKQ==",highlighted:`plt.imshow(image)
plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.title(<span class="hljs-string">&quot;Sample Chart Image&quot;</span>)
plt.show()`,wrap:!1}}),ne=new y({props:{title:"Build a chat-style prompt",local:"build-a-chat-style-prompt",headingTag:"h3"}}),oe=new w({props:{code:"JTIzJTIwRGVmaW5lJTIwYSUyMGNoYXQtc3R5bGUlMjBwcm9tcHQlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZSUyMiUyQyUyMCUyMmltYWdlJTIyJTNBJTIwaW1hZ2UlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycXVlcnklMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlN0QlMEElNUQlMEElMEElMjMlMjBBcHBseSUyMHRoZSUyMGNoYXQlMjB0ZW1wbGF0ZSUwQWNoYXRfcHJvbXB0JTIwJTNEJTIwcHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTVDJTBBKSUwQXByaW50KGNoYXRfcHJvbXB0KQ==",highlighted:`<span class="hljs-comment"># Define a chat-style prompt</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;image&quot;</span>: image},
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;query&quot;</span>]},
    ]}
]

<span class="hljs-comment"># Apply the chat template</span>
chat_prompt = processor.apply_chat_template(
      messages, add_generation_prompt=<span class="hljs-literal">True</span>\\
)
<span class="hljs-built_in">print</span>(chat_prompt)`,wrap:!1}}),re=new w({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VVc2VyJTNBJTNDaW1hZ2UlM0VIb3clMjBtYW55JTIwdmFsdWVzJTIwYXJlJTIwYmVsb3clMjA0MCUyMGluJTIwVW5mYXZvcmFibGUlMjBncmFwaCUzRiUzQ2VuZF9vZl91dHRlcmFuY2UlM0UlMEFBc3Npc3RhbnQlM0E=",highlighted:`&lt;|im_start|&gt;User:&lt;image&gt;How many values are below 40 in Unfavorable graph?&lt;end_of_utterance&gt;
Assistant:`,wrap:!1}}),Me=new y({props:{title:"Run inference",local:"run-inference",headingTag:"h3"}}),me=new w({props:{code:"JTIzJTIwVG9rZW5pemUlMjBpbnB1dCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0QlNUJpbWFnZSU1RCUyQyUyMHRleHQlM0RjaGF0X3Byb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSklMEElMEElMjMlMjBHZW5lcmF0ZSUyMG1vZGVsJTIwb3V0cHV0JTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEElMEElMjMlMjBUcmltJTIwdGhlJTIwZ2VuZXJhdGVkJTIwaWRzJTIwdG8lMjByZW1vdmUlMjB0aGUlMjBpbnB1dCUyMGlkcyUwQXRyaW1tZWRfZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMCU1Qm91dF9pZHMlNUJsZW4oaW5faWRzKSUyMCUzQSU1RCUyMGZvciUyMGluX2lkcyUyQyUyMG91dF9pZHMlMjBpbiUyMHppcChpbnB1dHMuaW5wdXRfaWRzJTJDJTIwb3V0cHV0KSU1RCUwQSUwQSUyMyUyMERlY29kZSUyMHRoZSUyMG91dHB1dCUyMHRleHQlMEFvdXRwdXRfdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoJTBBJTIwJTIwJTIwJTIwdHJpbW1lZF9nZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UlMEEpJTBBcHJpbnQob3V0cHV0X3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-comment"># Tokenize input</span>
inputs = processor(images=[image], text=chat_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Generate model output</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">20</span>)

<span class="hljs-comment"># Trim the generated ids to remove the input ids</span>
trimmed_generated_ids = [out_ids[<span class="hljs-built_in">len</span>(in_ids) :] <span class="hljs-keyword">for</span> in_ids, out_ids <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(inputs.input_ids, output)]

<span class="hljs-comment"># Decode the output text</span>
output_text = processor.batch_decode(
    trimmed_generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>
)
<span class="hljs-built_in">print</span>(output_text[<span class="hljs-number">0</span>])`,wrap:!1}}),ue=new w({props:{code:"JTIwMy4=",highlighted:" 3.",wrap:!1}}),ce=new y({props:{title:"Exercise 2: Fine-Tune the Model Using LoRA",local:"exercise-2-fine-tune-the-model-using-lora",headingTag:"h2"}}),ye=new w({props:{code:"c3lzdGVtX21lc3NhZ2UlMjAlM0QlMjAlMjIlMjIlMjJZb3UlMjBhcmUlMjBhJTIwVmlzaW9uJTIwTGFuZ3VhZ2UlMjBNb2RlbCUyMHNwZWNpYWxpemVkJTIwaW4lMjBpbnRlcnByZXRpbmclMjB2aXN1YWwlMjBkYXRhJTIwZnJvbSUyMGNoYXJ0JTIwaW1hZ2VzLiUwQVlvdXIlMjB0YXNrJTIwaXMlMjB0byUyMGFuYWx5emUlMjB0aGUlMjBwcm92aWRlZCUyMGNoYXJ0JTIwaW1hZ2UlMjBhbmQlMjByZXNwb25kJTIwdG8lMjBxdWVyaWVzJTIwd2l0aCUyMGNvbmNpc2UlMjBhbnN3ZXJzJTJDJTIwdXN1YWxseSUyMGElMjBzaW5nbGUlMjB3b3JkJTJDJTIwbnVtYmVyJTJDJTIwb3IlMjBzaG9ydCUyMHBocmFzZS4lMEFUaGUlMjBjaGFydHMlMjBpbmNsdWRlJTIwYSUyMHZhcmlldHklMjBvZiUyMHR5cGVzJTIwKGUuZy4lMkMlMjBsaW5lJTIwY2hhcnRzJTJDJTIwYmFyJTIwY2hhcnRzKSUyMGFuZCUyMGNvbnRhaW4lMjBjb2xvcnMlMkMlMjBsYWJlbHMlMkMlMjBhbmQlMjB0ZXh0LiUwQUZvY3VzJTIwb24lMjBkZWxpdmVyaW5nJTIwYWNjdXJhdGUlMkMlMjBzdWNjaW5jdCUyMGFuc3dlcnMlMjBiYXNlZCUyMG9uJTIwdGhlJTIwdmlzdWFsJTIwaW5mb3JtYXRpb24uJTIwQXZvaWQlMjBhZGRpdGlvbmFsJTIwZXhwbGFuYXRpb24lMjB1bmxlc3MlMjBhYnNvbHV0ZWx5JTIwbmVjZXNzYXJ5LiUyMiUyMiUyMg==",highlighted:`system_message = <span class="hljs-string">&quot;&quot;&quot;You are a Vision Language Model specialized in interpreting visual data from chart images.
Your task is to analyze the provided chart image and respond to queries with concise answers, usually a single word, number, or short phrase.
The charts include a variety of types (e.g., line charts, bar charts) and contain colors, labels, and text.
Focus on delivering accurate, succinct answers based on the visual information. Avoid additional explanation unless absolutely necessary.&quot;&quot;&quot;</span>`,wrap:!1}}),Ue=new y({props:{title:"Format the Dataset",local:"format-the-dataset",headingTag:"h3"}}),Ie=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_data</span>(<span class="hljs-params">sample</span>):
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;images&quot;</span>: [sample[<span class="hljs-string">&quot;image&quot;</span>]],
        <span class="hljs-string">&quot;messages&quot;</span>: [
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: system_message}],
            },
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: [
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>,
                        <span class="hljs-string">&quot;image&quot;</span>: sample[<span class="hljs-string">&quot;image&quot;</span>],
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: sample[<span class="hljs-string">&quot;query&quot;</span>],
                    },
                ],
            },
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: sample[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-number">0</span>]}],
            },
        ],
    }`,wrap:!1}}),be=new w({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMCU1QmZvcm1hdF9kYXRhKHNhbXBsZSklMjBmb3IlMjBzYW1wbGUlMjBpbiUyMHRyYWluX2RhdGFzZXQlNUQlMEFldmFsX2RhdGFzZXQlMjAlM0QlMjAlNUJmb3JtYXRfZGF0YShzYW1wbGUpJTIwZm9yJTIwc2FtcGxlJTIwaW4lMjBldmFsX2RhdGFzZXQlNUQ=",highlighted:`train_dataset = [format_data(sample) <span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> train_dataset]
eval_dataset = [format_data(sample) <span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> eval_dataset]`,wrap:!1}}),Ce=new y({props:{title:"Configure LoRA",local:"configure-lora",headingTag:"h3"}}),_e=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEElMjMlMjBDb25maWd1cmUlMjBMb1JBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjByJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBKSUwQSUwQSUyMyUyMEFwcGx5JTIwUEVGVCUyMG1vZGVsJTIwYWRhcHRhdGlvbiUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMHBlZnRfY29uZmlnKSUwQSUwQSUyMyUyMFByaW50JTIwdHJhaW5hYmxlJTIwcGFyYW1ldGVycyUwQXBlZnRfbW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

<span class="hljs-comment"># Configure LoRA</span>
peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    r=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># Apply PEFT model adaptation</span>
peft_model = get_peft_model(model, peft_config)

<span class="hljs-comment"># Print trainable parameters</span>
peft_model.print_trainable_parameters()`,wrap:!1}}),Ze=new y({props:{title:"Set up the Trainer",local:"set-up-the-trainer",headingTag:"h3"}}),xe=new w({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEElMjMlMjBDb25maWd1cmUlMjB0cmFpbmluZyUyMGFyZ3VtZW50cyUyMHVzaW5nJTIwU0ZUQ29uZmlnJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyc21vbC1jb3Vyc2Utc21vbHZsbTItMi4yYi1pbnN0cnVjdC10cmwtc2Z0LUNoYXJ0UUElMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTQlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBvcHRpbSUzRCUyMmFkYW13X3RvcmNoX2Z1c2VkJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmYxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlMjJ0cmFja2lvJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRE5vbmUlMkMlMEEpJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMFRyYWluZXIlMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGV2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMkMlMEEpJTBBJTBBJTIzJTIwQWxpZ24lMjB0aGUlMjBTRlRUcmFpbmVyJTIwcGFyYW1zJTIwd2l0aCUyMHlvdXIlMjBjaG9zZW4lMjBkYXRhc2V0Lg==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

<span class="hljs-comment"># Configure training arguments using SFTConfig</span>
training_args = SFTConfig(
    output_dir=<span class="hljs-string">&quot;smol-course-smolvlm2-2.2b-instruct-trl-sft-ChartQA&quot;</span>,
    num_train_epochs=<span class="hljs-number">1</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    learning_rate=<span class="hljs-number">1e-4</span>,
    logging_steps=<span class="hljs-number">25</span>,
    save_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    save_steps=<span class="hljs-number">25</span>,
    optim=<span class="hljs-string">&quot;adamw_torch_fused&quot;</span>,
    bf16=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    report_to=<span class="hljs-string">&quot;trackio&quot;</span>,
    max_length=<span class="hljs-literal">None</span>,
)

<span class="hljs-comment"># Initialize the Trainer</span>
trainer = SFTTrainer(
    model=model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    peft_config=peft_config,
)

<span class="hljs-comment"># Align the SFTTrainer params with your chosen dataset.</span>`,wrap:!1}}),Re=new y({props:{title:"Train and Save the Model",local:"train-and-save-the-model",headingTag:"h3"}}),ke=new w({props:{code:"JTIzJTIwVHJhaW4lMjB0aGUlMjBtb2RlbCUwQXRyYWluZXIudHJhaW4oKSUwQSUwQSUyMyUyMFNhdmUlMjB0aGUlMjBtb2RlbCUwQXRyYWluZXIuc2F2ZV9tb2RlbCh0cmFpbmluZ19hcmdzLm91dHB1dF9kaXIp",highlighted:`<span class="hljs-comment"># Train the model</span>
trainer.train()

<span class="hljs-comment"># Save the model</span>
trainer.save_model(training_args.output_dir)`,wrap:!1}}),Ee=new y({props:{title:"Exercise 3: Production Workflow with TRL CLI",local:"exercise-3-production-workflow-with-trl-cli",headingTag:"h2"}}),Pe=new w({props:{code:"dHJsJTIwc2Z0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBIdWdnaW5nRmFjZVRCJTJGU21vbFZMTTItMi4yQi1JbnN0cnVjdCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwdHJsLWxpYiUyRmxsYXZhLWluc3RydWN0LW1peCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMC4lMkZzbW9sdmxuLWluc3RydWN0LXNmdC1jbGklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDE2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTIwMmUtNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9sZW5ndGglMjAtMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbG9nZ2luZ19zdGVwcyUyMDUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNhdmVfc3RlcHMlMjAxMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXdhcm11cF9zdGVwcyUyMDUwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1iZjE2JTIwVHJ1ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcHVzaF90b19odWIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWh1Yl9tb2RlbF9pZCUyMHlvdXItdXNlcm5hbWUlMkZzbW9sdmxtMi0yLjJiLWluc3RydWN0LXNmdC1jbGk=",highlighted:`trl sft \\
    --model_name_or_path HuggingFaceTB/SmolVLM2-2.2B-Instruct \\
    --dataset_name trl-lib/llava-instruct-mix \\
    --output_dir ./smolvln-instruct-sft-cli \\
    --per_device_train_batch_size 1 \\
    --gradient_accumulation_steps 16 \\
    --learning_rate 2e-4 \\
    --num_train_epochs 3 \\
    --max_length -1 \\
    --logging_steps 5 \\
    --save_steps 100 \\
    --warmup_steps 50 \\
    --bf16 True \\
    --push_to_hub \\
    --hub_model_id your-username/smolvlm2-2.2b-instruct-sft-cli`,wrap:!1}}),De=new y({props:{title:"Exercise 4: Training with Hugging Face Jobs",local:"exercise-4-training-with-hugging-face-jobs",headingTag:"h2"}}),tt=new w({props:{code:"JTIzJTIwVXNlJTIwVFJMJ3MlMjBtYWludGFpbmVkJTIwU0ZUJTIwc2NyaXB0JTIwZGlyZWN0bHklMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZmxhdm9yJTIwYTEwZy1sYXJnZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGltZW91dCUyMDJoJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZWNyZXRzJTIwSEZfVE9LRU4lMjAlNUMlMEElMjAlMjAlMjAlMjAtLXdpdGglMjBudW0yd29yZHMlM0QlM0QwLjUuMTQlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRnRybCUyRm1haW4lMkZ0cmwlMkZzY3JpcHRzJTJGc2Z0LnB5JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBIdWdnaW5nRmFjZVRCJTJGU21vbFZMTTItMi4yQi1JbnN0cnVjdCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwdHJsLWxpYiUyRmxsYXZhLWluc3RydWN0LW1peCU1QyUwQSUyMCUyMCUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9sZW5ndGglMjAtMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4X3N0ZXBzJTIwMTAwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMHNtb2x2bG0yLTIuMmItaW5zdHJ1Y3Qtc2Z0LWpvYnMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXB1c2hfdG9faHViJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1odWJfbW9kZWxfaWQlMjB5b3VyLXVzZXJuYW1lJTJGc21vbHZsbTItMi4yYi1pbnN0cnVjdC1zZnQtam9icyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVwb3J0X3RvJTIwdHJhY2tpbw==",highlighted:`<span class="hljs-comment"># Use TRL&#x27;s maintained SFT script directly</span>
hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a10g-large \\
    --<span class="hljs-built_in">timeout</span> 2h \\
    --secrets HF_TOKEN \\
    --with num2words==0.5.14 \\
    <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/sft.py&quot;</span> \\
    --model_name_or_path HuggingFaceTB/SmolVLM2-2.2B-Instruct \\
    --dataset_name trl-lib/llava-instruct-mix\\
    --learning_rate 5e-5 \\
    --per_device_train_batch_size 4 \\
    --max_length -1 \\
    --max_steps 1000 \\
    --output_dir smolvlm2-2.2b-instruct-sft-jobs \\
    --push_to_hub \\
    --hub_model_id your-username/smolvlm2-2.2b-instruct-sft-jobs \\
    --report_to trackio`,wrap:!1}}),it=new y({props:{title:"Resources for Further Learning",local:"resources-for-further-learning",headingTag:"h2"}}),Mt=new fn({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit4/4.md"}}),{c(){T=i("meta"),h=n(),J=i("p"),U=n(),M($.$$.fragment),gt=n(),M(v.$$.fragment),Ut=n(),B=i("p"),B.innerHTML=ds,ft=n(),M(_.$$.fragment),It=n(),Z=i("p"),Z.textContent=cs,jt=n(),A=i("ul"),A.innerHTML=Ts,bt=n(),M(W.$$.fragment),Ct=n(),H=i("p"),H.innerHTML=ws,$t=n(),M(x.$$.fragment),vt=n(),M(f.$$.fragment),Bt=n(),R=i("p"),R.innerHTML=ys,_t=n(),M(F.$$.fragment),Zt=n(),M(L.$$.fragment),At=n(),G=i("p"),G.textContent=Js,Wt=n(),M(k.$$.fragment),Ht=n(),M(V.$$.fragment),xt=n(),M(E.$$.fragment),Rt=n(),Q=i("p"),Q.innerHTML=hs,Ft=n(),M(X.$$.fragment),Lt=n(),M(N.$$.fragment),Gt=n(),S=i("p"),S.innerHTML=gs,kt=n(),M(I.$$.fragment),Vt=n(),M(Y.$$.fragment),Et=n(),M(z.$$.fragment),Qt=n(),q=i("p"),q.innerHTML=Us,Xt=n(),M(P.$$.fragment),Nt=n(),M(D.$$.fragment),St=n(),K=i("p"),K.innerHTML=fs,Yt=n(),O=i("p"),O.innerHTML=Is,zt=n(),g=i("iframe"),qt=n(),M(ee.$$.fragment),Pt=n(),j=i("details"),ct=i("summary"),ct.textContent=bs,ps=n(),M(te.$$.fragment),Dt=n(),M(le.$$.fragment),Kt=n(),se=i("p"),se.innerHTML=Cs,Ot=n(),M(ne.$$.fragment),el=n(),ae=i("p"),ae.innerHTML=$s,tl=n(),ie=i("p"),ie.innerHTML=vs,ll=n(),M(oe.$$.fragment),sl=n(),b=i("details"),Tt=i("summary"),Tt.textContent=Bs,ms=n(),M(re.$$.fragment),nl=n(),M(Me.$$.fragment),al=n(),pe=i("p"),pe.textContent=_s,il=n(),M(me.$$.fragment),ol=n(),C=i("details"),wt=i("summary"),wt.textContent=Zs,us=n(),M(ue.$$.fragment),rl=n(),de=i("p"),de.innerHTML=As,Ml=n(),M(ce.$$.fragment),pl=n(),Te=i("p"),Te.innerHTML=Ws,ml=n(),we=i("p"),we.innerHTML=Hs,ul=n(),M(ye.$$.fragment),dl=n(),Je=i("p"),Je.innerHTML=xs,cl=n(),he=i("ul"),he.innerHTML=Rs,Tl=n(),ge=i("p"),ge.innerHTML=Fs,wl=n(),yl=i("hr"),Jl=n(),M(Ue.$$.fragment),hl=n(),fe=i("p"),fe.innerHTML=Ls,gl=n(),M(Ie.$$.fragment),Ul=n(),je=i("p"),je.textContent=Gs,fl=n(),M(be.$$.fragment),Il=n(),M(Ce.$$.fragment),jl=n(),$e=i("p"),$e.innerHTML=ks,bl=n(),ve=i("ul"),ve.innerHTML=Vs,Cl=n(),Be=i("p"),Be.innerHTML=Es,$l=n(),M(_e.$$.fragment),vl=n(),M(Ze.$$.fragment),Bl=n(),Ae=i("p"),Ae.innerHTML=Qs,_l=n(),We=i("ul"),We.innerHTML=Xs,Zl=n(),He=i("p"),He.textContent=Ns,Al=n(),M(xe.$$.fragment),Wl=n(),M(Re.$$.fragment),Hl=n(),Fe=i("p"),Fe.textContent=Ss,xl=n(),Le=i("ol"),Le.innerHTML=Ys,Rl=n(),Ge=i("p"),Ge.textContent=zs,Fl=n(),M(ke.$$.fragment),Ll=n(),Ve=i("p"),Ve.innerHTML=qs,Gl=n(),M(Ee.$$.fragment),kl=n(),Qe=i("p"),Qe.innerHTML=Ps,Vl=n(),Xe=i("p"),Xe.innerHTML=Ds,El=n(),Ne=i("p"),Ne.textContent=Ks,Ql=n(),Se=i("p"),Se.innerHTML=Os,Xl=n(),Ye=i("p"),Ye.textContent=en,Nl=n(),ze=i("ul"),ze.innerHTML=tn,Sl=n(),qe=i("p"),qe.textContent=ln,Yl=n(),M(Pe.$$.fragment),zl=n(),M(De.$$.fragment),ql=n(),Ke=i("p"),Ke.innerHTML=sn,Pl=n(),Oe=i("p"),Oe.innerHTML=nn,Dl=n(),et=i("p"),et.innerHTML=an,Kl=n(),M(tt.$$.fragment),Ol=n(),lt=i("p"),lt.innerHTML=on,es=n(),st=i("p"),st.textContent=rn,ts=n(),nt=i("ul"),nt.innerHTML=Mn,ls=n(),at=i("p"),at.innerHTML=pn,ss=n(),M(it.$$.fragment),ns=n(),ot=i("p"),ot.textContent=mn,as=n(),rt=i("ul"),rt.innerHTML=un,is=n(),M(Mt.$$.fragment),os=n(),ht=i("p"),this.h()},l(e){const t=gn("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),h=a(e),J=o(e,"P",{}),yt(J).forEach(l),U=a(e),p($.$$.fragment,e),gt=a(e),p(v.$$.fragment,e),Ut=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1a5nqhq"&&(B.innerHTML=ds),ft=a(e),p(_.$$.fragment,e),It=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1l3bdg3"&&(Z.textContent=cs),jt=a(e),A=o(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-od3cka"&&(A.innerHTML=Ts),bt=a(e),p(W.$$.fragment,e),Ct=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-bijktq"&&(H.innerHTML=ws),$t=a(e),p(x.$$.fragment,e),vt=a(e),p(f.$$.fragment,e),Bt=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-qqkglq"&&(R.innerHTML=ys),_t=a(e),p(F.$$.fragment,e),Zt=a(e),p(L.$$.fragment,e),At=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-zl3b16"&&(G.textContent=Js),Wt=a(e),p(k.$$.fragment,e),Ht=a(e),p(V.$$.fragment,e),xt=a(e),p(E.$$.fragment,e),Rt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-7eoqdg"&&(Q.innerHTML=hs),Ft=a(e),p(X.$$.fragment,e),Lt=a(e),p(N.$$.fragment,e),Gt=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-tskkwt"&&(S.innerHTML=gs),kt=a(e),p(I.$$.fragment,e),Vt=a(e),p(Y.$$.fragment,e),Et=a(e),p(z.$$.fragment,e),Qt=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1b4foh6"&&(q.innerHTML=Us),Xt=a(e),p(P.$$.fragment,e),Nt=a(e),p(D.$$.fragment,e),St=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-er66b7"&&(K.innerHTML=fs),Yt=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-yemwqz"&&(O.innerHTML=Is),zt=a(e),g=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),yt(g).forEach(l),qt=a(e),p(ee.$$.fragment,e),Pt=a(e),j=o(e,"DETAILS",{});var pt=yt(j);ct=o(pt,"SUMMARY",{"data-svelte-h":!0}),r(ct)!=="svelte-nfzy3j"&&(ct.textContent=bs),ps=a(pt),p(te.$$.fragment,pt),pt.forEach(l),Dt=a(e),p(le.$$.fragment,e),Kt=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-12h2lj2"&&(se.innerHTML=Cs),Ot=a(e),p(ne.$$.fragment,e),el=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-jpokh4"&&(ae.innerHTML=$s),tl=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-17uxmem"&&(ie.innerHTML=vs),ll=a(e),p(oe.$$.fragment,e),sl=a(e),b=o(e,"DETAILS",{});var mt=yt(b);Tt=o(mt,"SUMMARY",{"data-svelte-h":!0}),r(Tt)!=="svelte-nfzy3j"&&(Tt.textContent=Bs),ms=a(mt),p(re.$$.fragment,mt),mt.forEach(l),nl=a(e),p(Me.$$.fragment,e),al=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1qdjv1p"&&(pe.textContent=_s),il=a(e),p(me.$$.fragment,e),ol=a(e),C=o(e,"DETAILS",{});var Ms=yt(C);wt=o(Ms,"SUMMARY",{"data-svelte-h":!0}),r(wt)!=="svelte-nfzy3j"&&(wt.textContent=Zs),us=a(Ms),p(ue.$$.fragment,Ms),Ms.forEach(l),rl=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-luk36"&&(de.innerHTML=As),Ml=a(e),p(ce.$$.fragment,e),pl=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-5z70n4"&&(Te.innerHTML=Ws),ml=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-dkenf7"&&(we.innerHTML=Hs),ul=a(e),p(ye.$$.fragment,e),dl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-ejreso"&&(Je.innerHTML=xs),cl=a(e),he=o(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-wqfgg1"&&(he.innerHTML=Rs),Tl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1w4jpzn"&&(ge.innerHTML=Fs),wl=a(e),yl=o(e,"HR",{}),Jl=a(e),p(Ue.$$.fragment,e),hl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-41v40k"&&(fe.innerHTML=Ls),gl=a(e),p(Ie.$$.fragment,e),Ul=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-ximgze"&&(je.textContent=Gs),fl=a(e),p(be.$$.fragment,e),Il=a(e),p(Ce.$$.fragment,e),jl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1h7mh3h"&&($e.innerHTML=ks),bl=a(e),ve=o(e,"UL",{"data-svelte-h":!0}),r(ve)!=="svelte-2ch3wm"&&(ve.innerHTML=Vs),Cl=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1n114ah"&&(Be.innerHTML=Es),$l=a(e),p(_e.$$.fragment,e),vl=a(e),p(Ze.$$.fragment,e),Bl=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-8dwavv"&&(Ae.innerHTML=Qs),_l=a(e),We=o(e,"UL",{"data-svelte-h":!0}),r(We)!=="svelte-1kixzkm"&&(We.innerHTML=Xs),Zl=a(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-170mf7l"&&(He.textContent=Ns),Al=a(e),p(xe.$$.fragment,e),Wl=a(e),p(Re.$$.fragment,e),Hl=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-kxzbug"&&(Fe.textContent=Ss),xl=a(e),Le=o(e,"OL",{"data-svelte-h":!0}),r(Le)!=="svelte-pbze45"&&(Le.innerHTML=Ys),Rl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-tqjfkj"&&(Ge.textContent=zs),Fl=a(e),p(ke.$$.fragment,e),Ll=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1eg4wzk"&&(Ve.innerHTML=qs),Gl=a(e),p(Ee.$$.fragment,e),kl=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-idq95d"&&(Qe.innerHTML=Ps),Vl=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1b32icm"&&(Xe.innerHTML=Ds),El=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-97m84n"&&(Ne.textContent=Ks),Ql=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1smtf1g"&&(Se.innerHTML=Os),Xl=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-hiqun9"&&(Ye.textContent=en),Nl=a(e),ze=o(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-1ajz8o2"&&(ze.innerHTML=tn),Sl=a(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-16jnk0c"&&(qe.textContent=ln),Yl=a(e),p(Pe.$$.fragment,e),zl=a(e),p(De.$$.fragment,e),ql=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-38jf8e"&&(Ke.innerHTML=sn),Pl=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-nf31ng"&&(Oe.innerHTML=nn),Dl=a(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-14o8e9l"&&(et.innerHTML=an),Kl=a(e),p(tt.$$.fragment,e),Ol=a(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1lncu3d"&&(lt.innerHTML=on),es=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-aqr5u9"&&(st.textContent=rn),ts=a(e),nt=o(e,"UL",{"data-svelte-h":!0}),r(nt)!=="svelte-16pbkoa"&&(nt.innerHTML=Mn),ls=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1r3yd65"&&(at.innerHTML=pn),ss=a(e),p(it.$$.fragment,e),ns=a(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-nf8xdu"&&(ot.textContent=mn),as=a(e),rt=o(e,"UL",{"data-svelte-h":!0}),r(rt)!=="svelte-b7ldte"&&(rt.innerHTML=un),is=a(e),p(Mt.$$.fragment,e),os=a(e),ht=o(e,"P",{}),yt(ht).forEach(l),this.h()},h(){Jt(T,"name","hf:doc:metadata"),Jt(T,"content",Cn),wn(g.src,js="https://huggingface.co/datasets/HuggingFaceM4/ChartQA/embed/viewer/default/train")||Jt(g,"src",js),Jt(g,"frameborder","0"),Jt(g,"width","100%"),Jt(g,"height","560px")},m(e,t){ut(document.head,T),s(e,h,t),s(e,J,t),s(e,U,t),m($,e,t),s(e,gt,t),m(v,e,t),s(e,Ut,t),s(e,B,t),s(e,ft,t),m(_,e,t),s(e,It,t),s(e,Z,t),s(e,jt,t),s(e,A,t),s(e,bt,t),m(W,e,t),s(e,Ct,t),s(e,H,t),s(e,$t,t),m(x,e,t),s(e,vt,t),m(f,e,t),s(e,Bt,t),s(e,R,t),s(e,_t,t),m(F,e,t),s(e,Zt,t),m(L,e,t),s(e,At,t),s(e,G,t),s(e,Wt,t),m(k,e,t),s(e,Ht,t),m(V,e,t),s(e,xt,t),m(E,e,t),s(e,Rt,t),s(e,Q,t),s(e,Ft,t),m(X,e,t),s(e,Lt,t),m(N,e,t),s(e,Gt,t),s(e,S,t),s(e,kt,t),m(I,e,t),s(e,Vt,t),m(Y,e,t),s(e,Et,t),m(z,e,t),s(e,Qt,t),s(e,q,t),s(e,Xt,t),m(P,e,t),s(e,Nt,t),m(D,e,t),s(e,St,t),s(e,K,t),s(e,Yt,t),s(e,O,t),s(e,zt,t),s(e,g,t),s(e,qt,t),m(ee,e,t),s(e,Pt,t),s(e,j,t),ut(j,ct),ut(j,ps),m(te,j,null),s(e,Dt,t),m(le,e,t),s(e,Kt,t),s(e,se,t),s(e,Ot,t),m(ne,e,t),s(e,el,t),s(e,ae,t),s(e,tl,t),s(e,ie,t),s(e,ll,t),m(oe,e,t),s(e,sl,t),s(e,b,t),ut(b,Tt),ut(b,ms),m(re,b,null),s(e,nl,t),m(Me,e,t),s(e,al,t),s(e,pe,t),s(e,il,t),m(me,e,t),s(e,ol,t),s(e,C,t),ut(C,wt),ut(C,us),m(ue,C,null),s(e,rl,t),s(e,de,t),s(e,Ml,t),m(ce,e,t),s(e,pl,t),s(e,Te,t),s(e,ml,t),s(e,we,t),s(e,ul,t),m(ye,e,t),s(e,dl,t),s(e,Je,t),s(e,cl,t),s(e,he,t),s(e,Tl,t),s(e,ge,t),s(e,wl,t),s(e,yl,t),s(e,Jl,t),m(Ue,e,t),s(e,hl,t),s(e,fe,t),s(e,gl,t),m(Ie,e,t),s(e,Ul,t),s(e,je,t),s(e,fl,t),m(be,e,t),s(e,Il,t),m(Ce,e,t),s(e,jl,t),s(e,$e,t),s(e,bl,t),s(e,ve,t),s(e,Cl,t),s(e,Be,t),s(e,$l,t),m(_e,e,t),s(e,vl,t),m(Ze,e,t),s(e,Bl,t),s(e,Ae,t),s(e,_l,t),s(e,We,t),s(e,Zl,t),s(e,He,t),s(e,Al,t),m(xe,e,t),s(e,Wl,t),m(Re,e,t),s(e,Hl,t),s(e,Fe,t),s(e,xl,t),s(e,Le,t),s(e,Rl,t),s(e,Ge,t),s(e,Fl,t),m(ke,e,t),s(e,Ll,t),s(e,Ve,t),s(e,Gl,t),m(Ee,e,t),s(e,kl,t),s(e,Qe,t),s(e,Vl,t),s(e,Xe,t),s(e,El,t),s(e,Ne,t),s(e,Ql,t),s(e,Se,t),s(e,Xl,t),s(e,Ye,t),s(e,Nl,t),s(e,ze,t),s(e,Sl,t),s(e,qe,t),s(e,Yl,t),m(Pe,e,t),s(e,zl,t),m(De,e,t),s(e,ql,t),s(e,Ke,t),s(e,Pl,t),s(e,Oe,t),s(e,Dl,t),s(e,et,t),s(e,Kl,t),m(tt,e,t),s(e,Ol,t),s(e,lt,t),s(e,es,t),s(e,st,t),s(e,ts,t),s(e,nt,t),s(e,ls,t),s(e,at,t),s(e,ss,t),m(it,e,t),s(e,ns,t),s(e,ot,t),s(e,as,t),s(e,rt,t),s(e,is,t),m(Mt,e,t),s(e,os,t),s(e,ht,t),rs=!0},p(e,[t]){const pt={};t&2&&(pt.$$scope={dirty:t,ctx:e}),f.$set(pt);const mt={};t&2&&(mt.$$scope={dirty:t,ctx:e}),I.$set(mt)},i(e){rs||(u($.$$.fragment,e),u(v.$$.fragment,e),u(_.$$.fragment,e),u(W.$$.fragment,e),u(x.$$.fragment,e),u(f.$$.fragment,e),u(F.$$.fragment,e),u(L.$$.fragment,e),u(k.$$.fragment,e),u(V.$$.fragment,e),u(E.$$.fragment,e),u(X.$$.fragment,e),u(N.$$.fragment,e),u(I.$$.fragment,e),u(Y.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(Me.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(ce.$$.fragment,e),u(ye.$$.fragment,e),u(Ue.$$.fragment,e),u(Ie.$$.fragment,e),u(be.$$.fragment,e),u(Ce.$$.fragment,e),u(_e.$$.fragment,e),u(Ze.$$.fragment,e),u(xe.$$.fragment,e),u(Re.$$.fragment,e),u(ke.$$.fragment,e),u(Ee.$$.fragment,e),u(Pe.$$.fragment,e),u(De.$$.fragment,e),u(tt.$$.fragment,e),u(it.$$.fragment,e),u(Mt.$$.fragment,e),rs=!0)},o(e){d($.$$.fragment,e),d(v.$$.fragment,e),d(_.$$.fragment,e),d(W.$$.fragment,e),d(x.$$.fragment,e),d(f.$$.fragment,e),d(F.$$.fragment,e),d(L.$$.fragment,e),d(k.$$.fragment,e),d(V.$$.fragment,e),d(E.$$.fragment,e),d(X.$$.fragment,e),d(N.$$.fragment,e),d(I.$$.fragment,e),d(Y.$$.fragment,e),d(z.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(Me.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(ce.$$.fragment,e),d(ye.$$.fragment,e),d(Ue.$$.fragment,e),d(Ie.$$.fragment,e),d(be.$$.fragment,e),d(Ce.$$.fragment,e),d(_e.$$.fragment,e),d(Ze.$$.fragment,e),d(xe.$$.fragment,e),d(Re.$$.fragment,e),d(ke.$$.fragment,e),d(Ee.$$.fragment,e),d(Pe.$$.fragment,e),d(De.$$.fragment,e),d(tt.$$.fragment,e),d(it.$$.fragment,e),d(Mt.$$.fragment,e),rs=!1},d(e){e&&(l(h),l(J),l(U),l(gt),l(Ut),l(B),l(ft),l(It),l(Z),l(jt),l(A),l(bt),l(Ct),l(H),l($t),l(vt),l(Bt),l(R),l(_t),l(Zt),l(At),l(G),l(Wt),l(Ht),l(xt),l(Rt),l(Q),l(Ft),l(Lt),l(Gt),l(S),l(kt),l(Vt),l(Et),l(Qt),l(q),l(Xt),l(Nt),l(St),l(K),l(Yt),l(O),l(zt),l(g),l(qt),l(Pt),l(j),l(Dt),l(Kt),l(se),l(Ot),l(el),l(ae),l(tl),l(ie),l(ll),l(sl),l(b),l(nl),l(al),l(pe),l(il),l(ol),l(C),l(rl),l(de),l(Ml),l(pl),l(Te),l(ml),l(we),l(ul),l(dl),l(Je),l(cl),l(he),l(Tl),l(ge),l(wl),l(yl),l(Jl),l(hl),l(fe),l(gl),l(Ul),l(je),l(fl),l(Il),l(jl),l($e),l(bl),l(ve),l(Cl),l(Be),l($l),l(vl),l(Bl),l(Ae),l(_l),l(We),l(Zl),l(He),l(Al),l(Wl),l(Hl),l(Fe),l(xl),l(Le),l(Rl),l(Ge),l(Fl),l(Ll),l(Ve),l(Gl),l(kl),l(Qe),l(Vl),l(Xe),l(El),l(Ne),l(Ql),l(Se),l(Xl),l(Ye),l(Nl),l(ze),l(Sl),l(qe),l(Yl),l(zl),l(ql),l(Ke),l(Pl),l(Oe),l(Dl),l(et),l(Kl),l(Ol),l(lt),l(es),l(st),l(ts),l(nt),l(ls),l(at),l(ss),l(ns),l(ot),l(as),l(rt),l(is),l(os),l(ht)),l(T),c($,e),c(v,e),c(_,e),c(W,e),c(x,e),c(f,e),c(F,e),c(L,e),c(k,e),c(V,e),c(E,e),c(X,e),c(N,e),c(I,e),c(Y,e),c(z,e),c(P,e),c(D,e),c(ee,e),c(te),c(le,e),c(ne,e),c(oe,e),c(re),c(Me,e),c(me,e),c(ue),c(ce,e),c(ye,e),c(Ue,e),c(Ie,e),c(be,e),c(Ce,e),c(_e,e),c(Ze,e),c(xe,e),c(Re,e),c(ke,e),c(Ee,e),c(Pe,e),c(De,e),c(tt,e),c(it,e),c(Mt,e)}}}const Cn='{"title":"Hands-On Exercises: Fine-Tuning SmolVLM2-2.2B-Instruct","local":"hands-on-exercises-fine-tuning-smolvlm2-22b-instruct","sections":[{"title":"Learning Objectives","local":"learning-objectives","sections":[{"title":"Exercise 1: Explore SmolVLM2-2.2B-Instruct","local":"exercise-1-explore-smolvlm2-22b-instruct","sections":[],"depth":3},{"title":"Environment Setup","local":"environment-setup","sections":[],"depth":3},{"title":"Import dependencies","local":"import-dependencies","sections":[],"depth":3},{"title":"Load the model and processor","local":"load-the-model-and-processor","sections":[{"title":"1. Select the device","local":"1-select-the-device","sections":[],"depth":4},{"title":"2. Authenticate with Hugging Face","local":"2-authenticate-with-hugging-face","sections":[],"depth":4},{"title":"3. Load the model and processor","local":"3-load-the-model-and-processor","sections":[],"depth":4}],"depth":3},{"title":"Explore the dataset","local":"explore-the-dataset","sections":[],"depth":3},{"title":"Build a chat-style prompt","local":"build-a-chat-style-prompt","sections":[],"depth":3},{"title":"Run inference","local":"run-inference","sections":[],"depth":3}],"depth":2},{"title":"Exercise 2: Fine-Tune the Model Using LoRA","local":"exercise-2-fine-tune-the-model-using-lora","sections":[{"title":"Format the Dataset","local":"format-the-dataset","sections":[],"depth":3},{"title":"Configure LoRA","local":"configure-lora","sections":[],"depth":3},{"title":"Set up the Trainer","local":"set-up-the-trainer","sections":[],"depth":3},{"title":"Train and Save the Model","local":"train-and-save-the-model","sections":[],"depth":3}],"depth":2},{"title":"Exercise 3: Production Workflow with TRL CLI","local":"exercise-3-production-workflow-with-trl-cli","sections":[],"depth":2},{"title":"Exercise 4: Training with Hugging Face Jobs","local":"exercise-4-training-with-hugging-face-jobs","sections":[],"depth":2},{"title":"Resources for Further Learning","local":"resources-for-further-learning","sections":[],"depth":2}],"depth":1}';function $n(dt){return yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hn extends Jn{constructor(T){super(),hn(this,T,$n,bn,Tn,{})}}export{Hn as component};
