import{s as rl,n as ml,o as Ml}from"../chunks/scheduler.3e4cb221.js";import{S as cl,i as yl,g as i,s as n,r as o,A as ul,h as p,f as l,c as a,j as Ie,u as r,x as u,k as ol,y as Ue,a as s,v as m,d as M,t as c,w as y}from"../chunks/index.bc693fcb.js";import{C as w}from"../chunks/CodeBlock.4d312707.js";import{H as h,E as hl}from"../chunks/getInferenceSnippets.b0d0900a.js";function wl(xt){let T,Be,je,$e,f,Ce,g,Et="Before we dive into evaluation, we need to understand how to efficiently run inference with our models. While we can use the standard <code>transformers.Pipeline</code> approach:",Ge,b,Le,j,Xt="This approach has significant limitations for evaluation scenarios:",Ze,v,Ht="<li>No batching support: Each request is processed individually</li> <li>Memory inefficiency: Poor KV cache management</li> <li>Limited throughput: Cannot handle concurrent requests efficiently</li> <li>No advanced optimizations: Missing Flash Attention and other performance enhancements</li>",Se,I,Qt='For high-throughput evaluation and production deployment, we need more sophisticated inference engines like <a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a>.',We,B,xe,$,kt='<a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a> (pronounced “vee-LLM”) is a high-throughput and memory-efficient inference engine for large language models. Originally developed in the Sky Computing Lab at UC Berkeley, <a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a> has evolved into a community-driven project that revolutionizes LLM serving with several key innovations:',Ee,C,Xe,G,Nt="<li>State-of-the-art serving throughput with PagedAttention for efficient memory management</li> <li>Continuous batching of incoming requests for optimal GPU utilization</li> <li>Multiple parallelism strategies: tensor, pipeline, data, and expert parallelism</li> <li>Quantization support: GPTQ, AWQ, INT4, INT8, and FP8</li> <li>OpenAI-compatible API server for easy deployment</li>",He,L,Qe,Z,Vt="When running large-scale evaluations, traditional inference methods become bottlenecks:",ke,S,zt="<li>Memory waste: Traditional attention mechanisms store KV cache inefficiently</li> <li>Sequential processing: Cannot batch requests of different lengths effectively</li> <li>GPU underutilization: Frequent memory transfers leave GPUs idle</li>",Ne,W,Ft='<a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a> addresses these issues with revolutionary techniques that can achieve <strong>up to 24x higher throughput</strong> compared to traditional methods.',Ve,x,ze,E,Rt='vLLM integrates deeply with the Hugging Face ecosystem, as detailed in the <a href="https://docs.vllm.ai/en/latest/design/huggingface_integration.html" rel="nofollow">vLLM Hugging Face integration documentation</a>. Here’s how it works:',Fe,X,Re,H,Yt='When you run <a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a> with a Hugging Face model, the following happens:',Ye,Q,At='<li><p>Model Discovery - <a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a> checks for the model’s <code>config.json</code> file</p> <ul><li>Local path: Loads directly from the specified directory</li> <li>HF Model ID: Uses HF local cache or downloads from HF Hub</li></ul></li> <li><p>Configuration Loading - Converts the config file into a dictionary and determines the model type</p></li> <li><p>Model Class Initialization - Uses the <code>architectures</code> field to map to the appropriate <a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a> model class</p></li> <li><p>Tokenizer Integration - Loads the tokenizer using <code>AutoTokenizer.from_pretrained</code></p></li> <li><p>Weight Loading - Downloads model weights in safetensors format (recommended) or PyTorch bin format</p></li>',Ae,k,_e,N,qe,V,_t='PagedAttention is <a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a>’s key innovation that addresses a critical bottleneck in LLM inference: KV cache memory management. During text generation, models store attention keys and values (KV cache) for each generated token to avoid redundant computations. The KV cache can become enormous, especially with long sequences or multiple concurrent requests.',Pe,z,qt='<a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a>’s breakthrough lies in how it manages this cache:',De,F,Pt="<li>Memory Paging - Instead of treating the KV cache as one large block, it’s divided into fixed-size “pages” (similar to virtual memory in operating systems).</li> <li>Non-contiguous Storage - Pages don’t need to be stored contiguously in GPU memory, allowing for more flexible memory allocation.</li> <li>Page Table Management - A page table tracks which pages belong to which sequence, enabling efficient lookup and access.</li> <li>Memory Sharing - For operations like parallel sampling, pages storing the KV cache for the prompt can be shared across multiple sequences.</li>",Ke,R,Dt="The PagedAttention approach can lead to up to 24x higher throughput compared to traditional methods, making it a game-changer for production LLM deployments.",Oe,Y,et,A,Kt='Traditional batching waits for all sequences in a batch to complete before starting the next batch. <a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a> implements <strong>continuous batching</strong>, which:',tt,_,Ot="<li>Processes requests as they arrive</li> <li>Removes completed sequences immediately</li> <li>Adds new requests to the batch without waiting</li> <li>Maintains optimal GPU utilization</li>",lt,q,el="This approach is particularly beneficial for evaluation workloads where requests have varying lengths and completion times.",st,P,nt,D,at,K,it,O,pt,ee,ot,te,rt,le,mt,se,Mt,d,fe,tl="Output",Zt,ne,ct,ae,yt,ie,ll="For instruction-tuned models like SmolLM3, you can use chat templates:",ut,pe,ht,J,ge,sl="Output",St,oe,wt,re,Tt,me,nl="For production deployments, vLLM provides an OpenAI-compatible API server:",dt,Me,Jt,ce,Ut,ye,ft,ue,gt,U,be,al="Output",Wt,he,bt,we,jt,Te,il='Now that you understand how to use <a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a> for efficient inference with Hugging Face models, you’re ready to integrate it into evaluation workflows. In the next section, we’ll explore how <a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a> accelerates model evaluation with LightEval, providing significant speedups for benchmark testing and custom evaluation tasks.',vt,de,pl='The combination of <a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a>’s high-throughput inference and LightEval’s comprehensive evaluation framework creates a powerful toolkit for assessing language model performance efficiently and at scale.',It,Je,Bt,ve,$t;return f=new h({props:{title:"vLLM Inference with Hugging Face Models",local:"vllm-inference-with-hugging-face-models",headingTag:"h1"}}),b=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwQ3JlYXRlJTIwYSUyMHBpcGVsaW5lJTIwd2l0aCUyMGElMjBzcGVjaWZpYyUyMG1vZGVsJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMy0zQiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTIwdGV4dCUwQXJlc3BvbnNlJTIwJTNEJTIwZ2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMldyaXRlJTIwYSUyMHNob3J0JTIwcG9lbSUyMGFib3V0JTIwY29kaW5nJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjclMEEpJTBBcHJpbnQocmVzcG9uc2UlNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># Create a pipeline with a specific model</span>
generator = pipeline(
    <span class="hljs-string">&quot;text-generation&quot;</span>,
    model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

<span class="hljs-comment"># Generate text</span>
response = generator(
    <span class="hljs-string">&quot;Write a short poem about coding:&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
    do_sample=<span class="hljs-literal">True</span>,
    temperature=<span class="hljs-number">0.7</span>
)
<span class="hljs-built_in">print</span>(response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>])`,wrap:!1}}),B=new h({props:{title:"What is vLLM?",local:"what-is-vllm",headingTag:"h2"}}),C=new h({props:{title:"Key Features",local:"key-features",headingTag:"h3"}}),L=new h({props:{title:"Why vLLM Matters for Evaluation",local:"why-vllm-matters-for-evaluation",headingTag:"h3"}}),x=new h({props:{title:"vLLM and Hugging Face Integration",local:"vllm-and-hugging-face-integration",headingTag:"h2"}}),X=new h({props:{title:"Model Loading Process",local:"model-loading-process",headingTag:"h3"}}),k=new h({props:{title:"Core Technologies Behind vLLM",local:"core-technologies-behind-vllm",headingTag:"h2"}}),N=new h({props:{title:"PagedAttention: Revolutionary Memory Management",local:"pagedattention-revolutionary-memory-management",headingTag:"h3"}}),Y=new h({props:{title:"Continuous Batching for Optimal GPU Utilization",local:"continuous-batching-for-optimal-gpu-utilization",headingTag:"h3"}}),P=new h({props:{title:"Installation and Setup",local:"installation-and-setup",headingTag:"h2"}}),D=new h({props:{title:"Basic Installation",local:"basic-installation",headingTag:"h3"}}),K=new w({props:{code:"JTIzJTIwSW5zdGFsbCUyMHZMTE0lMEFwaXAlMjBpbnN0YWxsJTIwdmxsbSUwQSUwQSUyMyUyME9yJTIwd2l0aCUyMHNwZWNpZmljJTIwQ1VEQSUyMHZlcnNpb24lMEFwaXAlMjBpbnN0YWxsJTIwdmxsbSUyMC0tZXh0cmEtaW5kZXgtdXJsJTIwaHR0cHMlM0ElMkYlMkZkb3dubG9hZC5weXRvcmNoLm9yZyUyRndobCUyRmN1MTIx",highlighted:`<span class="hljs-comment"># Install vLLM</span>
pip install vllm

<span class="hljs-comment"># Or with specific CUDA version</span>
pip install vllm --extra-index-url https://download.pytorch.org/whl/cu121`,wrap:!1}}),O=new h({props:{title:"Verify Installation",local:"verify-installation",headingTag:"h3"}}),ee=new w({props:{code:"aW1wb3J0JTIwdmxsbSUwQXByaW50KGYlMjJ2TExNJTIwdmVyc2lvbiUzQSUyMCU3QnZsbG0uX192ZXJzaW9uX18lN0QlMjIp",highlighted:`<span class="hljs-keyword">import</span> vllm
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;vLLM version: <span class="hljs-subst">{vllm.__version__}</span>&quot;</span>)`,wrap:!1}}),te=new h({props:{title:"Basic vLLM Usage with Hugging Face Models",local:"basic-vllm-usage-with-hugging-face-models",headingTag:"h2"}}),le=new h({props:{title:"Simple Text Generation",local:"simple-text-generation",headingTag:"h3"}}),se=new w({props:{code:"ZnJvbSUyMHZsbG0lMjBpbXBvcnQlMjBMTE0lMkMlMjBTYW1wbGluZ1BhcmFtcyUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBtb2RlbCUwQWxsbSUyMCUzRCUyMExMTSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0zLTNCJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0QlMjJmbG9hdDE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X21vZGVsX2xlbiUzRDQwOTYlMkMlMEEpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwc2FtcGxpbmclMjBwYXJhbWV0ZXJzJTBBc2FtcGxpbmdfcGFyYW1zJTIwJTNEJTIwU2FtcGxpbmdQYXJhbXMoJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjYlMkMlMEElMjAlMjAlMjAlMjB0b3BfcCUzRDAuOTUlMkMlMEElMjAlMjAlMjAlMjBtYXhfdG9rZW5zJTNENTEyJTJDJTBBKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTIwdGV4dCUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJFeHBsYWluJTIwdGhlJTIwY29uY2VwdCUyMG9mJTIwbWFjaGluZSUyMGxlYXJuaW5nJTIwaW4lMjBzaW1wbGUlMjB0ZXJtcyUzQSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMldyaXRlJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdG8lMjBjYWxjdWxhdGUlMjBmYWN0b3JpYWwlM0ElMjIlMkMlMEElNUQlMEElMEFvdXRwdXRzJTIwJTNEJTIwbGxtLmdlbmVyYXRlKHByb21wdHMlMkMlMjBzYW1wbGluZ19wYXJhbXMpJTBBJTBBJTIzJTIwUHJpbnQlMjByZXN1bHRzJTBBZm9yJTIwb3V0cHV0JTIwaW4lMjBvdXRwdXRzJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwb3V0cHV0LnByb21wdCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwb3V0cHV0Lm91dHB1dHMlNUIwJTVELnRleHQlMEElMjAlMjAlMjAlMjBwcmludChmJTIyUHJvbXB0JTNBJTIwJTdCcHJvbXB0JTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJHZW5lcmF0ZWQlM0ElMjAlN0JnZW5lcmF0ZWRfdGV4dCU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludCglMjItJTIyJTIwKiUyMDUwKQ==",highlighted:`<span class="hljs-keyword">from</span> vllm <span class="hljs-keyword">import</span> LLM, SamplingParams

<span class="hljs-comment"># Initialize the model</span>
llm = LLM(
    model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>,
    dtype=<span class="hljs-string">&quot;float16&quot;</span>,
    max_model_len=<span class="hljs-number">4096</span>,
)

<span class="hljs-comment"># Create sampling parameters</span>
sampling_params = SamplingParams(
    temperature=<span class="hljs-number">0.6</span>,
    top_p=<span class="hljs-number">0.95</span>,
    max_tokens=<span class="hljs-number">512</span>,
)

<span class="hljs-comment"># Generate text</span>
prompts = [
    <span class="hljs-string">&quot;Explain the concept of machine learning in simple terms:&quot;</span>,
    <span class="hljs-string">&quot;Write a Python function to calculate factorial:&quot;</span>,
]

outputs = llm.generate(prompts, sampling_params)

<span class="hljs-comment"># Print results</span>
<span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> outputs:
    prompt = output.prompt
    generated_text = output.outputs[<span class="hljs-number">0</span>].text
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Prompt: <span class="hljs-subst">{prompt}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated: <span class="hljs-subst">{generated_text}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span> * <span class="hljs-number">50</span>)`,wrap:!1}}),ne=new w({props:{code:"UHJvbXB0JTNBJTIwRXhwbGFpbiUyMHRoZSUyMGNvbmNlcHQlMjBvZiUyMG1hY2hpbmUlMjBsZWFybmluZyUyMGluJTIwc2ltcGxlJTIwdGVybXMlM0ElMEFHZW5lcmF0ZWQlM0ElMjBFeHBsYWluJTIwdGhlJTIwY29uY2VwdCUyMG9mJTIwbWFjaGluZSUyMGxlYXJuaW5nJTIwaW4lMjBzaW1wbGUlMjB0ZXJtcyUzQSUwQS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTBBUHJvbXB0JTNBJTIwV3JpdGUlMjBhJTIwUHl0aG9uJTIwZnVuY3Rpb24lMjB0byUyMGNhbGN1bGF0ZSUyMGZhY3RvcmlhbCUzQSUwQUdlbmVyYXRlZCUzQSUyMFdyaXRlJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdG8lMjBjYWxjdWxhdGUlMjBmYWN0b3JpYWwlM0ElMEEtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQ==",highlighted:`Prompt: Explain the concept of machine learning <span class="hljs-keyword">in</span> simple terms:
Generated: Explain the concept of machine learning <span class="hljs-keyword">in</span> simple terms:
--------------------------------------------------
Prompt: Write a Python function to calculate factorial:
Generated: Write a Python function to calculate factorial:
--------------------------------------------------`,wrap:!1}}),ae=new h({props:{title:"Chat Template Support",local:"chat-template-support",headingTag:"h3"}}),pe=new w({props:{code:"ZnJvbSUyMHZsbG0lMjBpbXBvcnQlMjBMTE0lMkMlMjBTYW1wbGluZ1BhcmFtcyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBJTIzJTIwTG9hZCUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0zLTNCJTIyJTBBbGxtJTIwJTNEJTIwTExNKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWxfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGR0eXBlJTNEJTIyZmxvYXQxNiUyMiUyQyUwQSklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKSUwQSUwQSUyMyUyMFByZXBhcmUlMjBjaGF0JTIwbWVzc2FnZXMlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkdpdmUlMjBtZSUyMGElMjBicmllZiUyMGV4cGxhbmF0aW9uJTIwb2YlMjBncmF2aXR5JTIwaW4lMjBzaW1wbGUlMjB0ZXJtcy4lMjIlN0QlMEElNUQlMEElMEElMjMlMjBBcHBseSUyMGNoYXQlMjB0ZW1wbGF0ZSUwQXByb21wdCUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMEEpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjByZXNwb25zZSUwQXNhbXBsaW5nX3BhcmFtcyUyMCUzRCUyMFNhbXBsaW5nUGFyYW1zKCUwQSUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC42JTJDJTBBJTIwJTIwJTIwJTIwdG9wX3AlM0QwLjk1JTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEwMjQlMkMlMEEpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMGxsbS5nZW5lcmF0ZSglNUJwcm9tcHQlNUQlMkMlMjBzYW1wbGluZ19wYXJhbXMpJTBBcHJpbnQob3V0cHV0cyU1QjAlNUQub3V0cHV0cyU1QjAlNUQudGV4dCk=",highlighted:`<span class="hljs-keyword">from</span> vllm <span class="hljs-keyword">import</span> LLM, SamplingParams
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># Load model and tokenizer</span>
model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>
llm = LLM(
    model=model_name,
    trust_remote_code=<span class="hljs-literal">True</span>,
    dtype=<span class="hljs-string">&quot;float16&quot;</span>,
)

tokenizer = AutoTokenizer.from_pretrained(model_name)

<span class="hljs-comment"># Prepare chat messages</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Give me a brief explanation of gravity in simple terms.&quot;</span>}
]

<span class="hljs-comment"># Apply chat template</span>
prompt = tokenizer.apply_chat_template(
    messages,
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># Generate response</span>
sampling_params = SamplingParams(
    temperature=<span class="hljs-number">0.6</span>,
    top_p=<span class="hljs-number">0.95</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

outputs = llm.generate([prompt], sampling_params)
<span class="hljs-built_in">print</span>(outputs[<span class="hljs-number">0</span>].outputs[<span class="hljs-number">0</span>].text)`,wrap:!1}}),oe=new w({props:{code:"R2l2ZSUyMG1lJTIwYSUyMGJyaWVmJTIwZXhwbGFuYXRpb24lMjBvZiUyMGdyYXZpdHklMjBpbiUyMHNpbXBsZSUyMHRlcm1zLiUwQUdyYXZpdHklMjBpcyUyMHRoZSUyMGZvcmNlJTIwdGhhdCUyMHB1bGxzJTIwb2JqZWN0cyUyMHRvd2FyZHMlMjBlYWNoJTIwb3RoZXIuJTIwSXQlMjBpcyUyMGNhdXNlZCUyMGJ5JTIwdGhlJTIwbWFzcyUyMG9mJTIwdGhlJTIwb2JqZWN0cy4lMjBUaGUlMjBtb3JlJTIwbWFzcyUyMGFuJTIwb2JqZWN0JTIwaGFzJTJDJTIwdGhlJTIwc3Ryb25nZXIlMjBpdHMlMjBncmF2aXR5JTIwaXMu",highlighted:`Give me a brief explanation of gravity <span class="hljs-keyword">in</span> simple terms.
Gravity <span class="hljs-keyword">is</span> the force that pulls objects towards each other. It <span class="hljs-keyword">is</span> caused by the mass of the objects. The more mass an <span class="hljs-built_in">object</span> has, the stronger its gravity <span class="hljs-keyword">is</span>.`,wrap:!1}}),re=new h({props:{title:"vLLM API Server",local:"vllm-api-server",headingTag:"h2"}}),Me=new h({props:{title:"Starting the Server",local:"starting-the-server",headingTag:"h3"}}),ce=new w({props:{code:"JTIzJTIwQmFzaWMlMjBzZXJ2ZXIlMEF2bGxtJTIwc2VydmUlMjBIdWdnaW5nRmFjZVRCJTJGU21vbExNMy0zQiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZHR5cGUlMjBmbG9hdDE2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10cnVzdC1yZW1vdGUtY29kZSUwQSUwQSUyMyUyME11bHRpLUdQVSUyMHNlcnZlciUwQXZsbG0lMjBzZXJ2ZSUyMEh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0zLTNCJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10ZW5zb3ItcGFyYWxsZWwtc2l6ZSUyMDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWR0eXBlJTIwZmxvYXQxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdHJ1c3QtcmVtb3RlLWNvZGUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBvcnQlMjA4MDAw",highlighted:`<span class="hljs-comment"># Basic server</span>
vllm serve HuggingFaceTB/SmolLM3-3B \\
    --dtype float16 \\
    --trust-remote-code

<span class="hljs-comment"># Multi-GPU server</span>
vllm serve HuggingFaceTB/SmolLM3-3B \\
    --tensor-parallel-size 4 \\
    --dtype float16 \\
    --trust-remote-code \\
    --port 8000`,wrap:!1}}),ye=new h({props:{title:"Using the API",local:"using-the-api",headingTag:"h3"}}),ue=new w({props:{code:"aW1wb3J0JTIwb3BlbmFpJTBBJTBBJTIzJTIwQ29uZmlndXJlJTIwY2xpZW50JTBBY2xpZW50JTIwJTNEJTIwb3BlbmFpLk9wZW5BSSglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDAwJTJGdjElMjIlMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIydG9rZW4tYWJjMTIzJTIyJTJDJTIwJTIwJTIzJTIwQ2FuJTIwYmUlMjBhbnklMjBzdHJpbmclMjBmb3IlMjBsb2NhbCUyMHNlcnZlciUwQSklMEElMEElMjMlMjBDaGF0JTIwY29tcGxldGlvbiUwQXJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTMtM0IlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkV4cGxhaW4lMjBxdWFudHVtJTIwY29tcHV0aW5nJTIwYnJpZWZseS4lMjIlN0QlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuNiUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0Q1MTIlMkMlMEEpJTBBJTBBcHJpbnQocmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS5jb250ZW50KQ==",highlighted:`<span class="hljs-keyword">import</span> openai

<span class="hljs-comment"># Configure client</span>
client = openai.OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:8000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;token-abc123&quot;</span>,  <span class="hljs-comment"># Can be any string for local server</span>
)

<span class="hljs-comment"># Chat completion</span>
response = client.chat.completions.create(
    model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Explain quantum computing briefly.&quot;</span>}
    ],
    temperature=<span class="hljs-number">0.6</span>,
    max_tokens=<span class="hljs-number">512</span>,
)

<span class="hljs-built_in">print</span>(response.choices[<span class="hljs-number">0</span>].message.content)`,wrap:!1}}),he=new w({props:{code:"UXVhbnR1bSUyMGNvbXB1dGluZyUyMGlzJTIwYSUyMHR5cGUlMjBvZiUyMGNvbXB1dGluZyUyMHRoYXQlMjB1c2VzJTIwcXVhbnR1bSUyMGJpdHMlMjBpbnN0ZWFkJTIwb2YlMjBjbGFzc2ljYWwlMjBiaXRzLiUyMFF1YW50dW0lMjBiaXRzJTIwYXJlJTIwZGlmZmVyZW50JTIwZnJvbSUyMGNsYXNzaWNhbCUyMGJpdHMlMjBiZWNhdXNlJTIwdGhleSUyMGNhbiUyMGJlJTIwaW4lMjBhJTIwc3VwZXJwb3NpdGlvbiUyMG9mJTIwMCUyMGFuZCUyMDElMkMlMjB3aGljaCUyMGFsbG93cyUyMHRoZW0lMjB0byUyMGJlJTIwaW4lMjBtdWx0aXBsZSUyMHN0YXRlcyUyMGF0JTIwb25jZS4lMjBUaGlzJTIwYWxsb3dzJTIwcXVhbnR1bSUyMGNvbXB1dGVycyUyMHRvJTIwcGVyZm9ybSUyMGNlcnRhaW4lMjBjYWxjdWxhdGlvbnMlMjBtdWNoJTIwZmFzdGVyJTIwdGhhbiUyMGNsYXNzaWNhbCUyMGNvbXB1dGVycy4=",highlighted:'Quantum computing <span class="hljs-keyword">is</span> a <span class="hljs-built_in">type</span> of computing that uses quantum bits instead of classical bits. Quantum bits are different <span class="hljs-keyword">from</span> classical bits because they can be <span class="hljs-keyword">in</span> a superposition of <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> <span class="hljs-number">1</span>, which allows them to be <span class="hljs-keyword">in</span> multiple states at once. This allows quantum computers to perform certain calculations much faster than classical computers.',wrap:!1}}),we=new h({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),Je=new hl({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit2/2.md"}}),{c(){T=i("meta"),Be=n(),je=i("p"),$e=n(),o(f.$$.fragment),Ce=n(),g=i("p"),g.innerHTML=Et,Ge=n(),o(b.$$.fragment),Le=n(),j=i("p"),j.textContent=Xt,Ze=n(),v=i("ul"),v.innerHTML=Ht,Se=n(),I=i("p"),I.innerHTML=Qt,We=n(),o(B.$$.fragment),xe=n(),$=i("p"),$.innerHTML=kt,Ee=n(),o(C.$$.fragment),Xe=n(),G=i("ul"),G.innerHTML=Nt,He=n(),o(L.$$.fragment),Qe=n(),Z=i("p"),Z.textContent=Vt,ke=n(),S=i("ul"),S.innerHTML=zt,Ne=n(),W=i("p"),W.innerHTML=Ft,Ve=n(),o(x.$$.fragment),ze=n(),E=i("p"),E.innerHTML=Rt,Fe=n(),o(X.$$.fragment),Re=n(),H=i("p"),H.innerHTML=Yt,Ye=n(),Q=i("ol"),Q.innerHTML=At,Ae=n(),o(k.$$.fragment),_e=n(),o(N.$$.fragment),qe=n(),V=i("p"),V.innerHTML=_t,Pe=n(),z=i("p"),z.innerHTML=qt,De=n(),F=i("ol"),F.innerHTML=Pt,Ke=n(),R=i("p"),R.textContent=Dt,Oe=n(),o(Y.$$.fragment),et=n(),A=i("p"),A.innerHTML=Kt,tt=n(),_=i("ul"),_.innerHTML=Ot,lt=n(),q=i("p"),q.textContent=el,st=n(),o(P.$$.fragment),nt=n(),o(D.$$.fragment),at=n(),o(K.$$.fragment),it=n(),o(O.$$.fragment),pt=n(),o(ee.$$.fragment),ot=n(),o(te.$$.fragment),rt=n(),o(le.$$.fragment),mt=n(),o(se.$$.fragment),Mt=n(),d=i("details"),fe=i("summary"),fe.textContent=tl,Zt=n(),o(ne.$$.fragment),ct=n(),o(ae.$$.fragment),yt=n(),ie=i("p"),ie.textContent=ll,ut=n(),o(pe.$$.fragment),ht=n(),J=i("details"),ge=i("summary"),ge.textContent=sl,St=n(),o(oe.$$.fragment),wt=n(),o(re.$$.fragment),Tt=n(),me=i("p"),me.textContent=nl,dt=n(),o(Me.$$.fragment),Jt=n(),o(ce.$$.fragment),Ut=n(),o(ye.$$.fragment),ft=n(),o(ue.$$.fragment),gt=n(),U=i("details"),be=i("summary"),be.textContent=al,Wt=n(),o(he.$$.fragment),bt=n(),o(we.$$.fragment),jt=n(),Te=i("p"),Te.innerHTML=il,vt=n(),de=i("p"),de.innerHTML=pl,It=n(),o(Je.$$.fragment),Bt=n(),ve=i("p"),this.h()},l(e){const t=ul("svelte-u9bgzb",document.head);T=p(t,"META",{name:!0,content:!0}),t.forEach(l),Be=a(e),je=p(e,"P",{}),Ie(je).forEach(l),$e=a(e),r(f.$$.fragment,e),Ce=a(e),g=p(e,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1rg5oy6"&&(g.innerHTML=Et),Ge=a(e),r(b.$$.fragment,e),Le=a(e),j=p(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-6k9p7w"&&(j.textContent=Xt),Ze=a(e),v=p(e,"UL",{"data-svelte-h":!0}),u(v)!=="svelte-u1ucvo"&&(v.innerHTML=Ht),Se=a(e),I=p(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-7rocnj"&&(I.innerHTML=Qt),We=a(e),r(B.$$.fragment,e),xe=a(e),$=p(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-cbjvmc"&&($.innerHTML=kt),Ee=a(e),r(C.$$.fragment,e),Xe=a(e),G=p(e,"UL",{"data-svelte-h":!0}),u(G)!=="svelte-vrzji7"&&(G.innerHTML=Nt),He=a(e),r(L.$$.fragment,e),Qe=a(e),Z=p(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-1q9lsnh"&&(Z.textContent=Vt),ke=a(e),S=p(e,"UL",{"data-svelte-h":!0}),u(S)!=="svelte-w86zav"&&(S.innerHTML=zt),Ne=a(e),W=p(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-qblp3g"&&(W.innerHTML=Ft),Ve=a(e),r(x.$$.fragment,e),ze=a(e),E=p(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1fg40hp"&&(E.innerHTML=Rt),Fe=a(e),r(X.$$.fragment,e),Re=a(e),H=p(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-lri8wj"&&(H.innerHTML=Yt),Ye=a(e),Q=p(e,"OL",{"data-svelte-h":!0}),u(Q)!=="svelte-e87yco"&&(Q.innerHTML=At),Ae=a(e),r(k.$$.fragment,e),_e=a(e),r(N.$$.fragment,e),qe=a(e),V=p(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-11z03z0"&&(V.innerHTML=_t),Pe=a(e),z=p(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-yxyxhn"&&(z.innerHTML=qt),De=a(e),F=p(e,"OL",{"data-svelte-h":!0}),u(F)!=="svelte-xrys4j"&&(F.innerHTML=Pt),Ke=a(e),R=p(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1ne37bk"&&(R.textContent=Dt),Oe=a(e),r(Y.$$.fragment,e),et=a(e),A=p(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-1v7sl7l"&&(A.innerHTML=Kt),tt=a(e),_=p(e,"UL",{"data-svelte-h":!0}),u(_)!=="svelte-9k8jif"&&(_.innerHTML=Ot),lt=a(e),q=p(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-npxngs"&&(q.textContent=el),st=a(e),r(P.$$.fragment,e),nt=a(e),r(D.$$.fragment,e),at=a(e),r(K.$$.fragment,e),it=a(e),r(O.$$.fragment,e),pt=a(e),r(ee.$$.fragment,e),ot=a(e),r(te.$$.fragment,e),rt=a(e),r(le.$$.fragment,e),mt=a(e),r(se.$$.fragment,e),Mt=a(e),d=p(e,"DETAILS",{});var Ct=Ie(d);fe=p(Ct,"SUMMARY",{"data-svelte-h":!0}),u(fe)!=="svelte-nfzy3j"&&(fe.textContent=tl),Zt=a(Ct),r(ne.$$.fragment,Ct),Ct.forEach(l),ct=a(e),r(ae.$$.fragment,e),yt=a(e),ie=p(e,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-1qba3f1"&&(ie.textContent=ll),ut=a(e),r(pe.$$.fragment,e),ht=a(e),J=p(e,"DETAILS",{});var Gt=Ie(J);ge=p(Gt,"SUMMARY",{"data-svelte-h":!0}),u(ge)!=="svelte-nfzy3j"&&(ge.textContent=sl),St=a(Gt),r(oe.$$.fragment,Gt),Gt.forEach(l),wt=a(e),r(re.$$.fragment,e),Tt=a(e),me=p(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1vnmf8u"&&(me.textContent=nl),dt=a(e),r(Me.$$.fragment,e),Jt=a(e),r(ce.$$.fragment,e),Ut=a(e),r(ye.$$.fragment,e),ft=a(e),r(ue.$$.fragment,e),gt=a(e),U=p(e,"DETAILS",{});var Lt=Ie(U);be=p(Lt,"SUMMARY",{"data-svelte-h":!0}),u(be)!=="svelte-nfzy3j"&&(be.textContent=al),Wt=a(Lt),r(he.$$.fragment,Lt),Lt.forEach(l),bt=a(e),r(we.$$.fragment,e),jt=a(e),Te=p(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-8ej82p"&&(Te.innerHTML=il),vt=a(e),de=p(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-9erox4"&&(de.innerHTML=pl),It=a(e),r(Je.$$.fragment,e),Bt=a(e),ve=p(e,"P",{}),Ie(ve).forEach(l),this.h()},h(){ol(T,"name","hf:doc:metadata"),ol(T,"content",Tl)},m(e,t){Ue(document.head,T),s(e,Be,t),s(e,je,t),s(e,$e,t),m(f,e,t),s(e,Ce,t),s(e,g,t),s(e,Ge,t),m(b,e,t),s(e,Le,t),s(e,j,t),s(e,Ze,t),s(e,v,t),s(e,Se,t),s(e,I,t),s(e,We,t),m(B,e,t),s(e,xe,t),s(e,$,t),s(e,Ee,t),m(C,e,t),s(e,Xe,t),s(e,G,t),s(e,He,t),m(L,e,t),s(e,Qe,t),s(e,Z,t),s(e,ke,t),s(e,S,t),s(e,Ne,t),s(e,W,t),s(e,Ve,t),m(x,e,t),s(e,ze,t),s(e,E,t),s(e,Fe,t),m(X,e,t),s(e,Re,t),s(e,H,t),s(e,Ye,t),s(e,Q,t),s(e,Ae,t),m(k,e,t),s(e,_e,t),m(N,e,t),s(e,qe,t),s(e,V,t),s(e,Pe,t),s(e,z,t),s(e,De,t),s(e,F,t),s(e,Ke,t),s(e,R,t),s(e,Oe,t),m(Y,e,t),s(e,et,t),s(e,A,t),s(e,tt,t),s(e,_,t),s(e,lt,t),s(e,q,t),s(e,st,t),m(P,e,t),s(e,nt,t),m(D,e,t),s(e,at,t),m(K,e,t),s(e,it,t),m(O,e,t),s(e,pt,t),m(ee,e,t),s(e,ot,t),m(te,e,t),s(e,rt,t),m(le,e,t),s(e,mt,t),m(se,e,t),s(e,Mt,t),s(e,d,t),Ue(d,fe),Ue(d,Zt),m(ne,d,null),s(e,ct,t),m(ae,e,t),s(e,yt,t),s(e,ie,t),s(e,ut,t),m(pe,e,t),s(e,ht,t),s(e,J,t),Ue(J,ge),Ue(J,St),m(oe,J,null),s(e,wt,t),m(re,e,t),s(e,Tt,t),s(e,me,t),s(e,dt,t),m(Me,e,t),s(e,Jt,t),m(ce,e,t),s(e,Ut,t),m(ye,e,t),s(e,ft,t),m(ue,e,t),s(e,gt,t),s(e,U,t),Ue(U,be),Ue(U,Wt),m(he,U,null),s(e,bt,t),m(we,e,t),s(e,jt,t),s(e,Te,t),s(e,vt,t),s(e,de,t),s(e,It,t),m(Je,e,t),s(e,Bt,t),s(e,ve,t),$t=!0},p:ml,i(e){$t||(M(f.$$.fragment,e),M(b.$$.fragment,e),M(B.$$.fragment,e),M(C.$$.fragment,e),M(L.$$.fragment,e),M(x.$$.fragment,e),M(X.$$.fragment,e),M(k.$$.fragment,e),M(N.$$.fragment,e),M(Y.$$.fragment,e),M(P.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(ae.$$.fragment,e),M(pe.$$.fragment,e),M(oe.$$.fragment,e),M(re.$$.fragment,e),M(Me.$$.fragment,e),M(ce.$$.fragment,e),M(ye.$$.fragment,e),M(ue.$$.fragment,e),M(he.$$.fragment,e),M(we.$$.fragment,e),M(Je.$$.fragment,e),$t=!0)},o(e){c(f.$$.fragment,e),c(b.$$.fragment,e),c(B.$$.fragment,e),c(C.$$.fragment,e),c(L.$$.fragment,e),c(x.$$.fragment,e),c(X.$$.fragment,e),c(k.$$.fragment,e),c(N.$$.fragment,e),c(Y.$$.fragment,e),c(P.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(Me.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),c(ue.$$.fragment,e),c(he.$$.fragment,e),c(we.$$.fragment,e),c(Je.$$.fragment,e),$t=!1},d(e){e&&(l(Be),l(je),l($e),l(Ce),l(g),l(Ge),l(Le),l(j),l(Ze),l(v),l(Se),l(I),l(We),l(xe),l($),l(Ee),l(Xe),l(G),l(He),l(Qe),l(Z),l(ke),l(S),l(Ne),l(W),l(Ve),l(ze),l(E),l(Fe),l(Re),l(H),l(Ye),l(Q),l(Ae),l(_e),l(qe),l(V),l(Pe),l(z),l(De),l(F),l(Ke),l(R),l(Oe),l(et),l(A),l(tt),l(_),l(lt),l(q),l(st),l(nt),l(at),l(it),l(pt),l(ot),l(rt),l(mt),l(Mt),l(d),l(ct),l(yt),l(ie),l(ut),l(ht),l(J),l(wt),l(Tt),l(me),l(dt),l(Jt),l(Ut),l(ft),l(gt),l(U),l(bt),l(jt),l(Te),l(vt),l(de),l(It),l(Bt),l(ve)),l(T),y(f,e),y(b,e),y(B,e),y(C,e),y(L,e),y(x,e),y(X,e),y(k,e),y(N,e),y(Y,e),y(P,e),y(D,e),y(K,e),y(O,e),y(ee,e),y(te,e),y(le,e),y(se,e),y(ne),y(ae,e),y(pe,e),y(oe),y(re,e),y(Me,e),y(ce,e),y(ye,e),y(ue,e),y(he),y(we,e),y(Je,e)}}}const Tl='{"title":"vLLM Inference with Hugging Face Models","local":"vllm-inference-with-hugging-face-models","sections":[{"title":"What is vLLM?","local":"what-is-vllm","sections":[{"title":"Key Features","local":"key-features","sections":[],"depth":3},{"title":"Why vLLM Matters for Evaluation","local":"why-vllm-matters-for-evaluation","sections":[],"depth":3}],"depth":2},{"title":"vLLM and Hugging Face Integration","local":"vllm-and-hugging-face-integration","sections":[{"title":"Model Loading Process","local":"model-loading-process","sections":[],"depth":3}],"depth":2},{"title":"Core Technologies Behind vLLM","local":"core-technologies-behind-vllm","sections":[{"title":"PagedAttention: Revolutionary Memory Management","local":"pagedattention-revolutionary-memory-management","sections":[],"depth":3},{"title":"Continuous Batching for Optimal GPU Utilization","local":"continuous-batching-for-optimal-gpu-utilization","sections":[],"depth":3}],"depth":2},{"title":"Installation and Setup","local":"installation-and-setup","sections":[{"title":"Basic Installation","local":"basic-installation","sections":[],"depth":3},{"title":"Verify Installation","local":"verify-installation","sections":[],"depth":3}],"depth":2},{"title":"Basic vLLM Usage with Hugging Face Models","local":"basic-vllm-usage-with-hugging-face-models","sections":[{"title":"Simple Text Generation","local":"simple-text-generation","sections":[],"depth":3},{"title":"Chat Template Support","local":"chat-template-support","sections":[],"depth":3}],"depth":2},{"title":"vLLM API Server","local":"vllm-api-server","sections":[{"title":"Starting the Server","local":"starting-the-server","sections":[],"depth":3},{"title":"Using the API","local":"using-the-api","sections":[],"depth":3}],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function dl(xt){return Ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bl extends cl{constructor(T){super(),yl(this,T,dl,wl,rl,{})}}export{bl as component};
