import{s as ee,n as le,o as se}from"../chunks/scheduler.71ff668b.js";import{S as ae,i as ne,g as o,s as a,r as J,A as oe,h as p,f as l,c as n,j as Kt,u as m,x as U,k as te,y as pe,a as s,v as i,d as M,t as r,w as T}from"../chunks/index.e0973da1.js";import{C as Zt}from"../chunks/CodeBlock.0c9622a3.js";import{C as Ue}from"../chunks/CourseFloatingBanner.69eb4e28.js";import{H as C,E as Je}from"../chunks/getInferenceSnippets.25cce923.js";function me(kt){let f,Y,D,K,y,tt,w,et,V,vt="LoRA는 널리 쓰이는 PEFT 방법으로 자리 잡았습니다. 어텐션 가중치에 작은 랭크 분해 행렬을 추가하는 방식으로 동작작하며 일반적으로 학습 가능한 파라미터를 약 90% 줄여줍니다.",lt,d,st,u,Bt='LoRA(Low-Rank Adaptation)는 사전 학습된 모델 가중치를 고정한 상태에서 학습 가능한 랭크 분해 행렬을 모델 레이어에 주입하는 파라미터 효율적인 미세 조정 기법입니다. 미세 조정 과정에서 모든 모델 파라미터를 학습시키는 대신, LoRA는 저랭크 분해를 통해 가중치 업데이트를 더 작은 행렬로 나눠 모델 성능은 유지하면서 학습 가능한 파라미터 수를 크게 줄입니다. 예를 들어, GPT-3 175B에 LoRA를 적용했을 때 전체 미세 조정 대비 학습 가능한 파라미터 수는 10,000배, GPU 메모리 요구 사항은 3배 감소했습니다. <a href="https://arxiv.org/pdf/2106.09685" rel="nofollow">LoRA 논문</a>에서 LoRA에 관한 자세한 내용을 확인할 수 있습니다.',at,c,At="LoRA는 일반적으로 트랜스포머 레이어 중 어텐션 가중치에 랭크 분해 행렬 쌍을 추가하는 방식으로 동작합니다. 어댑터 가중치는 추론 과정에서 기본 모델과 병합될 수 있고 추가적인 지연 시간이 발생하지 않습니다. LoRA는 자원 요구 사항을 적절한 수준으로 유지하면서 대형 언어 모델을 특정 태스크나 도메인에 맞게 조정하는 데 특히 유용합니다.",nt,$,ot,b,Lt="load_adapter()를 사용하여 사전 학습된 모델에 어댑터를 불러올 수 있으며 가중치가 병합되지 않은 다른 어댑터를 사용해 볼 때 유용합니다. set_adapter() 함수로 활성 어댑터 가중치를 설정합니다. 기본 모델을 반환하려면 unload()를 사용하여 불러온 모든 LoRA 모듈을 내릴 수 있습니다. 이렇게 하면 태스크별 가중치를 쉽게 전환할 수 있습니다.",pt,g,Ut,R,Nt='<img src="./images/lora_adapter.png" alt="lora_load_adapter"/>',Jt,F,mt,Q,Gt="LoRA로 학습한 후에는 더 쉬운 배포를 위해 어댑터 가중치를 기본 모델에 다시 병합할 수 있습니다. 이를 통해 결합된 가중치를 가진 단일 모델을 생성할 수 있기 때문에 추론 과정에서 별도로 어댑터를 불러올 필요가 없습니다.",it,h,xt="병합 과정에서는 메모리 관리와 정밀도에 주의해야 합니다. 기본 모델과 어댑터 가중치를 동시에 불러와야 하므로 GPU/CPU 메모리가 충분해야 합니다. <code>transformers</code>의 <code>device_map=&quot;auto&quot;</code>를 사용하면 메모리를 자동으로 관리할 수 있습니다. 학습 중 사용한 정밀도(예: float16)를 병합 과정에서도 일관되게 유지하고, 병합된 모델을 같은 형식으로 저장하여 배포하세요. 배포 전에 반드시 병합된 모델의 출력 결과와 성능 지표를 어댑터 기반 버전과 비교하여 검증해야 합니다.",Mt,j,Wt="어댑터는 서로 다른 태스크나 도메인 간 전환도 간편하게 만듭니다. 기본 모델과 어댑터 가중치를 별도로 불러오면 빠르게 태스크별 가중치를 전환할 수 있습니다.",rt,I,Tt,E,St="<code>notebooks/</code> 디렉토리에는 다양한 PEFT 방법을 구현하기 위한 실용적인 튜토리얼과 예제가 포함되어 있습니다. <code>load_lora_adapter_example.ipynb</code>에서 기본 소개를 살펴본 다음, <code>lora_finetuning.ipynb</code>를 통해 LoRA와 SFT를 사용한 모델 미세 조정 과정을 더 자세히 탐구해 보세요.",Ct,_,Xt="PEFT 방법을 구현할 때는 LoRA의 랭크를 4~8 정도의 작은 값으로 설정하고 학습 손실을 지속적으로 모니터링하는 것이 좋습니다. 과적합을 방지하기 위해 검증 세트를 활용하고 가능하다면 전체 미세 조정 기준선과 결과를 비교하세요. 다양한 태스크에서 각 방법의 효과는 다를 수 있으므로 실험을 통해 최적의 방법을 찾는 것이 중요합니다.",ft,Z,yt,k,Ot='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a>는 LoRA 어댑터 초기화를 위해 QR 분해를 활용합니다. OLoRA는 모델의 기본 가중치를 QR 분해 계수에 따라 변환합니다. 즉, 모델 학습 전에 가중치를 변경합니다. 이 접근 방식은 안정성을 크게 향상시키고 수렴 속도를 빠르게 하여, 궁극적으로 더 우수한 성능을 달성합니다.',wt,v,Vt,B,Pt="효율적인 미세 조정을 위해 PEFT 방법을 TRL(Transformers Reinforcements Learning)과 결합할 수 있습니다. 이러한 통합은 메모리 요구사항을 줄여주기 때문에 RLHF (Reinforcement Learning from Human Feedback)에 특히 유용합니다.",dt,A,ut,L,Ht="위 코드에서 <code>device_map=&quot;auto&quot;</code>를 사용해 모델을 적절한 디바이스에 자동으로 할당했습니다. <code>device_map={&quot;&quot;: device_index}</code>를 써서 모델을 특정 디바이스에 직접 할당할 수도 있습니다. 또한, 메모리 사용량을 효율적으로 유지하면서 여러 GPU에 걸쳐 학습을 확장할 수도 있습니다.",ct,N,$t,G,qt="LoRA 어댑터 학습이 끝나면 어댑터 가중치를 기본 모델에 합칠 수 있습니다. 합치는 방법은 다음과 같습니다:",bt,x,gt,W,Dt="저장된 모델의 크기가 일치하지 않으면 토크나이저도 함께 저장했는지 확인하세요:",Rt,S,Ft,X,Qt,O,zt=`⏩ <a href="prompt_tuning.md">프롬프트 튜닝</a> 가이드로 이동해 프롬프트 튜닝으로 미세 조정하는 법을 배워보세요.
⏩ <a href="../../../notebooks/ko/3_parameter_efficient_finetuning/load_lora_adapter.ipynb">LoRA 어댑터 튜토리얼</a>에서 LoRA 어댑터를 불러오는 방법을 배워보세요.`,ht,P,jt,H,Yt='<li><a href="https://arxiv.org/pdf/2106.09685" rel="nofollow">LORA: LOW-RANK ADAPTATION OF LARGE LANGUAGE MODELS</a></li> <li><a href="https://huggingface.co/docs/peft" rel="nofollow">Hugging Face PEFT 문서</a></li> <li><a href="https://huggingface.co/blog/peft" rel="nofollow">Hugging Face blog post on PEFT</a></li>',It,q,Et,z,_t;return y=new C({props:{title:"LoRA (Low-Rank Adaptation)",local:"lora-low-rank-adaptation",headingTag:"h1"}}),w=new Ue({props:{chapter:10,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/ko/3_parameter_efficient_finetuning/finetune_sft_peft.ipynb"}]}}),d=new C({props:{title:"LoRA 이해하기",local:"lora-이해하기",headingTag:"h2"}}),$=new C({props:{title:"LoRA 어댑터 불러오기",local:"lora-어댑터-불러오기",headingTag:"h2"}}),g=new Zt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiUzQ2Jhc2VfbW9kZWxfbmFtZSUzRSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyJTNDcGVmdF9hZGFwdGVyX2lkJTNFJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;&lt;base_model_name&gt;&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;&lt;peft_adapter_id&gt;&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),F=new C({props:{title:"LoRA 어댑터 병합",local:"lora-어댑터-병합",headingTag:"h2"}}),I=new C({props:{title:"구현 가이드",local:"구현-가이드",headingTag:"h2"}}),Z=new C({props:{title:"OLoRA",local:"olora",headingTag:"h2"}}),v=new C({props:{title:"PEFT와 함께 TRL 사용하기",local:"peft와-함께-trl-사용하기",headingTag:"h2"}}),A=new Zt({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwUEVGVCUyMGNvbmZpZ3VyYXRpb24lMjAlRUMlODQlQTQlRUMlQTAlOTUlMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwciUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKSUwQSUwQSUyMyUyMCVFRCU4QSVCOSVFQyVBMCU5NSUyMCVFQiU5NCU5NCVFQiVCMCU5NCVFQyU5RCVCNCVFQyU4QSVBNCVFQyU5NyU5MCVFQyU4NCU5QyUyMCVFQiVBQSVBOCVFQiU4RCVCOCUyMCVFQiVCNiU4OCVFQiU5RiVBQyVFQyU5OCVBNCVFQSVCOCVCMCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnlvdXItbW9kZWwtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMjAlMjAlMjMlMjAlRUMlODQlQTAlRUQlODMlOUQlMjAlRUMlODIlQUMlRUQlOTUlQUQlM0ElMjA4JUVCJUI5JTg0JUVEJThBJUI4JTIwJUVDJUEwJTk1JUVCJUIwJTgwJUVCJThGJTg0JTIwJUVDJTgyJUFDJUVDJTlBJUE5JTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-comment"># PEFT configuration 설정</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

<span class="hljs-comment"># 특정 디바이스에서 모델 불러오기</span>
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;your-model-name&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># 선택 사항: 8비트 정밀도 사용</span>
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    peft_config=lora_config
)`,wrap:!1}}),N=new C({props:{title:"기본적인 병합 구현",local:"기본적인-병합-구현",headingTag:"h2"}}),x=new Zt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQSUwQSUyMyUyMDEuJTIwJUVBJUI4JUIwJUVCJUIzJUI4JTIwJUVCJUFBJUE4JUVCJThEJUI4JTIwJUVCJUI2JTg4JUVCJTlGJUFDJUVDJTk4JUE0JUVBJUI4JUIwJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJiYXNlX21vZGVsX25hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUwQSklMEElMEElMjMlMjAyLiUyMCVFQyU5NiVCNCVFQiU4QyU5MSVFRCU4NCVCMCVFQSVCMCU4MCUyMCVFQyU5RSU4OCVFQiU4QSU5NCUyMFBFRlQlMjAlRUIlQUElQTglRUIlOEQlQjglMjAlRUIlQjYlODglRUIlOUYlQUMlRUMlOTglQTQlRUElQjglQjAlMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBiYXNlX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyRnRvJTJGYWRhcHRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEElMjMlMjAzLiUyMCVFQyU5NiVCNCVFQiU4QyU5MSVFRCU4NCVCMCUyMCVFQSVCMCU4MCVFQyVBNCU5MSVFQyVCOSU5OCVFQiVBNSVCQyUyMCVFQSVCOCVCMCVFQiVCMyVCOCUyMCVFQiVBQSVBOCVFQiU4RCVCOCVFQyU5NyU5MCUyMCVFQiVCMyU5MSVFRCU5NSVBOSVFRCU5NSU5OCVFQSVCOCVCMCUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMG1lcmdlZF9tb2RlbCUyMCUzRCUyMHBlZnRfbW9kZWwubWVyZ2VfYW5kX3VubG9hZCgpJTBBZXhjZXB0JTIwUnVudGltZUVycm9yJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMk1lcmdpbmclMjBmYWlsZWQlM0ElMjAlN0JlJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUyMyUyMGZhbGxiYWNrJTIwJUVDJUEwJTg0JUVCJTlFJUI1JTIwJUVCJTk4JTkwJUVCJThBJTk0JTIwJUVCJUE5JTk0JUVCJUFBJUE4JUVCJUE2JUFDJTIwJUVDJUI1JTlDJUVDJUEwJTgxJUVEJTk5JTk0JTIwJUVBJUI1JUFDJUVEJTk4JTg0JTBBJTBBJTIzJTIwNC4lMjAlRUIlQjMlOTElRUQlOTUlQTklRUIlOTAlOUMlMjAlRUIlQUElQTglRUIlOEQlQjglMjAlRUMlQTAlODAlRUMlOUUlQTUlMEFtZXJnZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRnNhdmUlMkZtZXJnZWRfbW9kZWwlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

<span class="hljs-comment"># 1. 기본 모델 불러오기</span>
base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;base_model_name&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

<span class="hljs-comment"># 2. 어댑터가 있는 PEFT 모델 불러오기</span>
peft_model = PeftModel.from_pretrained(
    base_model,
    <span class="hljs-string">&quot;path/to/adapter&quot;</span>,
    torch_dtype=torch.float16
)

<span class="hljs-comment"># 3. 어댑터 가중치를 기본 모델에 병합하기</span>
<span class="hljs-keyword">try</span>:
    merged_model = peft_model.merge_and_unload()
<span class="hljs-keyword">except</span> RuntimeError <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Merging failed: <span class="hljs-subst">{e}</span>&quot;</span>)
    <span class="hljs-comment"># fallback 전략 또는 메모리 최적화 구현</span>

<span class="hljs-comment"># 4. 병합된 모델 저장</span>
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),S=new Zt({props:{code:"JTIzJTIwJUVCJUFBJUE4JUVCJThEJUI4JUVBJUIzJUJDJTIwJUVEJTg2JUEwJUVEJTgxJUFDJUVCJTgyJTk4JUVDJTlEJUI0JUVDJUEwJTgwJUVCJUE1JUJDJTIwJUVCJUFBJUE4JUVCJTkxJTkwJTIwJUVDJUEwJTgwJUVDJTlFJUE1JTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYmFzZV9tb2RlbF9uYW1lJTIyKSUwQW1lcmdlZF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIycGF0aCUyRnRvJTJGc2F2ZSUyRm1lcmdlZF9tb2RlbCUyMiklMEF0b2tlbml6ZXIuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRnNhdmUlMkZtZXJnZWRfbW9kZWwlMjIp",highlighted:`<span class="hljs-comment"># 모델과 토크나이저를 모두 저장</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;base_model_name&quot;</span>)
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),X=new C({props:{title:"다음 단계",local:"다음-단계",headingTag:"h2"}}),P=new C({props:{title:"참고",local:"참고",headingTag:"h1"}}),q=new Je({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/ko/unit3/2.md"}}),{c(){f=o("meta"),Y=a(),D=o("p"),K=a(),J(y.$$.fragment),tt=a(),J(w.$$.fragment),et=a(),V=o("p"),V.textContent=vt,lt=a(),J(d.$$.fragment),st=a(),u=o("p"),u.innerHTML=Bt,at=a(),c=o("p"),c.textContent=At,nt=a(),J($.$$.fragment),ot=a(),b=o("p"),b.textContent=Lt,pt=a(),J(g.$$.fragment),Ut=a(),R=o("p"),R.innerHTML=Nt,Jt=a(),J(F.$$.fragment),mt=a(),Q=o("p"),Q.textContent=Gt,it=a(),h=o("p"),h.innerHTML=xt,Mt=a(),j=o("p"),j.textContent=Wt,rt=a(),J(I.$$.fragment),Tt=a(),E=o("p"),E.innerHTML=St,Ct=a(),_=o("p"),_.textContent=Xt,ft=a(),J(Z.$$.fragment),yt=a(),k=o("p"),k.innerHTML=Ot,wt=a(),J(v.$$.fragment),Vt=a(),B=o("p"),B.textContent=Pt,dt=a(),J(A.$$.fragment),ut=a(),L=o("p"),L.innerHTML=Ht,ct=a(),J(N.$$.fragment),$t=a(),G=o("p"),G.textContent=qt,bt=a(),J(x.$$.fragment),gt=a(),W=o("p"),W.textContent=Dt,Rt=a(),J(S.$$.fragment),Ft=a(),J(X.$$.fragment),Qt=a(),O=o("p"),O.innerHTML=zt,ht=a(),J(P.$$.fragment),jt=a(),H=o("ul"),H.innerHTML=Yt,It=a(),J(q.$$.fragment),Et=a(),z=o("p"),this.h()},l(t){const e=oe("svelte-u9bgzb",document.head);f=p(e,"META",{name:!0,content:!0}),e.forEach(l),Y=n(t),D=p(t,"P",{}),Kt(D).forEach(l),K=n(t),m(y.$$.fragment,t),tt=n(t),m(w.$$.fragment,t),et=n(t),V=p(t,"P",{"data-svelte-h":!0}),U(V)!=="svelte-1kzoi8w"&&(V.textContent=vt),lt=n(t),m(d.$$.fragment,t),st=n(t),u=p(t,"P",{"data-svelte-h":!0}),U(u)!=="svelte-vuu4uk"&&(u.innerHTML=Bt),at=n(t),c=p(t,"P",{"data-svelte-h":!0}),U(c)!=="svelte-jwrhy0"&&(c.textContent=At),nt=n(t),m($.$$.fragment,t),ot=n(t),b=p(t,"P",{"data-svelte-h":!0}),U(b)!=="svelte-17mdnpm"&&(b.textContent=Lt),pt=n(t),m(g.$$.fragment,t),Ut=n(t),R=p(t,"P",{"data-svelte-h":!0}),U(R)!=="svelte-1ljdidi"&&(R.innerHTML=Nt),Jt=n(t),m(F.$$.fragment,t),mt=n(t),Q=p(t,"P",{"data-svelte-h":!0}),U(Q)!=="svelte-3nedjv"&&(Q.textContent=Gt),it=n(t),h=p(t,"P",{"data-svelte-h":!0}),U(h)!=="svelte-ly5mwd"&&(h.innerHTML=xt),Mt=n(t),j=p(t,"P",{"data-svelte-h":!0}),U(j)!=="svelte-ujziak"&&(j.textContent=Wt),rt=n(t),m(I.$$.fragment,t),Tt=n(t),E=p(t,"P",{"data-svelte-h":!0}),U(E)!=="svelte-315uv"&&(E.innerHTML=St),Ct=n(t),_=p(t,"P",{"data-svelte-h":!0}),U(_)!=="svelte-s30r1h"&&(_.textContent=Xt),ft=n(t),m(Z.$$.fragment,t),yt=n(t),k=p(t,"P",{"data-svelte-h":!0}),U(k)!=="svelte-lxr4sa"&&(k.innerHTML=Ot),wt=n(t),m(v.$$.fragment,t),Vt=n(t),B=p(t,"P",{"data-svelte-h":!0}),U(B)!=="svelte-9g7pca"&&(B.textContent=Pt),dt=n(t),m(A.$$.fragment,t),ut=n(t),L=p(t,"P",{"data-svelte-h":!0}),U(L)!=="svelte-1ivgonz"&&(L.innerHTML=Ht),ct=n(t),m(N.$$.fragment,t),$t=n(t),G=p(t,"P",{"data-svelte-h":!0}),U(G)!=="svelte-1pxmmln"&&(G.textContent=qt),bt=n(t),m(x.$$.fragment,t),gt=n(t),W=p(t,"P",{"data-svelte-h":!0}),U(W)!=="svelte-1jdi963"&&(W.textContent=Dt),Rt=n(t),m(S.$$.fragment,t),Ft=n(t),m(X.$$.fragment,t),Qt=n(t),O=p(t,"P",{"data-svelte-h":!0}),U(O)!=="svelte-14qk34a"&&(O.innerHTML=zt),ht=n(t),m(P.$$.fragment,t),jt=n(t),H=p(t,"UL",{"data-svelte-h":!0}),U(H)!=="svelte-1yig8s0"&&(H.innerHTML=Yt),It=n(t),m(q.$$.fragment,t),Et=n(t),z=p(t,"P",{}),Kt(z).forEach(l),this.h()},h(){te(f,"name","hf:doc:metadata"),te(f,"content",ie)},m(t,e){pe(document.head,f),s(t,Y,e),s(t,D,e),s(t,K,e),i(y,t,e),s(t,tt,e),i(w,t,e),s(t,et,e),s(t,V,e),s(t,lt,e),i(d,t,e),s(t,st,e),s(t,u,e),s(t,at,e),s(t,c,e),s(t,nt,e),i($,t,e),s(t,ot,e),s(t,b,e),s(t,pt,e),i(g,t,e),s(t,Ut,e),s(t,R,e),s(t,Jt,e),i(F,t,e),s(t,mt,e),s(t,Q,e),s(t,it,e),s(t,h,e),s(t,Mt,e),s(t,j,e),s(t,rt,e),i(I,t,e),s(t,Tt,e),s(t,E,e),s(t,Ct,e),s(t,_,e),s(t,ft,e),i(Z,t,e),s(t,yt,e),s(t,k,e),s(t,wt,e),i(v,t,e),s(t,Vt,e),s(t,B,e),s(t,dt,e),i(A,t,e),s(t,ut,e),s(t,L,e),s(t,ct,e),i(N,t,e),s(t,$t,e),s(t,G,e),s(t,bt,e),i(x,t,e),s(t,gt,e),s(t,W,e),s(t,Rt,e),i(S,t,e),s(t,Ft,e),i(X,t,e),s(t,Qt,e),s(t,O,e),s(t,ht,e),i(P,t,e),s(t,jt,e),s(t,H,e),s(t,It,e),i(q,t,e),s(t,Et,e),s(t,z,e),_t=!0},p:le,i(t){_t||(M(y.$$.fragment,t),M(w.$$.fragment,t),M(d.$$.fragment,t),M($.$$.fragment,t),M(g.$$.fragment,t),M(F.$$.fragment,t),M(I.$$.fragment,t),M(Z.$$.fragment,t),M(v.$$.fragment,t),M(A.$$.fragment,t),M(N.$$.fragment,t),M(x.$$.fragment,t),M(S.$$.fragment,t),M(X.$$.fragment,t),M(P.$$.fragment,t),M(q.$$.fragment,t),_t=!0)},o(t){r(y.$$.fragment,t),r(w.$$.fragment,t),r(d.$$.fragment,t),r($.$$.fragment,t),r(g.$$.fragment,t),r(F.$$.fragment,t),r(I.$$.fragment,t),r(Z.$$.fragment,t),r(v.$$.fragment,t),r(A.$$.fragment,t),r(N.$$.fragment,t),r(x.$$.fragment,t),r(S.$$.fragment,t),r(X.$$.fragment,t),r(P.$$.fragment,t),r(q.$$.fragment,t),_t=!1},d(t){t&&(l(Y),l(D),l(K),l(tt),l(et),l(V),l(lt),l(st),l(u),l(at),l(c),l(nt),l(ot),l(b),l(pt),l(Ut),l(R),l(Jt),l(mt),l(Q),l(it),l(h),l(Mt),l(j),l(rt),l(Tt),l(E),l(Ct),l(_),l(ft),l(yt),l(k),l(wt),l(Vt),l(B),l(dt),l(ut),l(L),l(ct),l($t),l(G),l(bt),l(gt),l(W),l(Rt),l(Ft),l(Qt),l(O),l(ht),l(jt),l(H),l(It),l(Et),l(z)),l(f),T(y,t),T(w,t),T(d,t),T($,t),T(g,t),T(F,t),T(I,t),T(Z,t),T(v,t),T(A,t),T(N,t),T(x,t),T(S,t),T(X,t),T(P,t),T(q,t)}}}const ie='{"title":"LoRA (Low-Rank Adaptation)","local":"lora-low-rank-adaptation","sections":[{"title":"LoRA 이해하기","local":"lora-이해하기","sections":[],"depth":2},{"title":"LoRA 어댑터 불러오기","local":"lora-어댑터-불러오기","sections":[],"depth":2},{"title":"LoRA 어댑터 병합","local":"lora-어댑터-병합","sections":[],"depth":2},{"title":"구현 가이드","local":"구현-가이드","sections":[],"depth":2},{"title":"OLoRA","local":"olora","sections":[],"depth":2},{"title":"PEFT와 함께 TRL 사용하기","local":"peft와-함께-trl-사용하기","sections":[],"depth":2},{"title":"기본적인 병합 구현","local":"기본적인-병합-구현","sections":[],"depth":2},{"title":"다음 단계","local":"다음-단계","sections":[],"depth":2}],"depth":1}';function Me(kt){return se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class we extends ae{constructor(f){super(),ne(this,f,Me,me,ee,{})}}export{we as component};
