import{s as al,n as il,o as pl}from"../chunks/scheduler.eb244325.js";import{S as ol,i as rl,e as i,s as n,c as r,h as dl,a as p,d as l,b as a,f as sl,g as d,j as o,k as nl,l as yl,m as s,n as y,t as h,o as c,p as w}from"../chunks/index.661680a1.js";import{C as hl,H as M,E as cl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.c047d438.js";import{C as u}from"../chunks/CodeBlock.0d14d0aa.js";function wl(Ut){let T,fe,me,Ie,m,je,J,Ue,f,bt=`In some cases, the model you’re looking to deploy isn’t supported by any of the high-performance inference engines. In this case,
we provide a fallback option. The Inference Toolkit supports models that are implemented in the
Transformers, Sentence-Transformers and Diffusers libraries, and wraps them in a light web server.`,be,I,gt="The Inference Toolkit is perfect for testing models and building demos, but isn’t as production-ready as TGI, vLLM, SGLang, or llama.cpp.",ge,j,Ce,U,Ct=`Hugging Face Endpoints supports all of the Transformers and Sentence-Transformers tasks and can support custom tasks, including
custom pre- &amp; post-processing. The customization can be done through a
<a href="https://huggingface.co/philschmid/distilbert-onnx-banking77/blob/main/handler.py" rel="nofollow">handler.py</a> file in your model repository on
the Hugging Face Hub.`,Be,b,Bt=`The <a href="https://huggingface.co/philschmid/distilbert-onnx-banking77/blob/main/handler.py" rel="nofollow">handler.py</a> needs to implement
the <a href="https://huggingface.co/philschmid/distilbert-onnx-banking77/blob/main/handler.py" rel="nofollow">EndpointHandler</a> class with a
<code>__init__</code> and a <code>__call__</code> method.`,$e,g,$t=`If you want to use custom dependencies, e.g. <a href="https://raw.githubusercontent.com/huggingface/optimum" rel="nofollow">optimum</a>, the dependencies must
be listed in a <code>requirements.txt</code> as described above in “add custom dependencies.”`,Ge,C,ve,B,Gt=`Before creating a Custom Handler, you need a Hugging Face Model repository with your model weights and an Access Token with
<em>write</em> access to the repository. To find, create and manage Access Tokens, click <a href="https://huggingface.co/settings/tokens" rel="nofollow">here</a>.`,xe,$,vt=`If you want to write a Custom Handler for an existing model from the community, you can use the <a href="https://huggingface.co/spaces/osanseviero/repo_duplicator" rel="nofollow">repo_duplicator</a>
to create a repository fork.`,ke,G,xt='The code can also be found in this <a href="https://colab.research.google.com/drive/1hANJeRa1PK1gZaUorobnQGu4bFj4_4Rf?usp=sharing" rel="nofollow">Notebook</a>.',_e,v,kt='You can also search for already existing Custom Handlers here: <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">https://huggingface.co/models?other=endpoints-template</a>',He,x,Ze,k,_t=`The easiest way to develop our custom handler is to set up a local development environment, to implement, test, and iterate there, and then
deploy it as an Inference Endpoint. The first step is to install all required development dependencies. <em>needed to create the custom
handler, not needed for inference</em>`,Ee,_,We,H,Ht="After we have installed our libraries we will clone our repository to our development environment.",Ne,Z,Zt=`We will use <a href="https://huggingface.co/philschmid/distilbert-base-uncased-emotion" rel="nofollow">philschmid/distilbert-base-uncased-emotion</a> during the
tutorial.`,Re,E,Qe,W,Et="To be able to push our model repo later you need to login into our HF account. This can be done by using the <code>huggingface-cli</code>.",Se,N,Wt="<em>Note: Make sure to configure git config as well.</em>",Ye,R,ze,Q,Ae,S,Nt=`After we have set up our environment, we can start creating your custom handler. The custom handler is a Python class
(<code>EndpointHandler</code>) inside a <code>handler.py</code> file in our repository. The <code>EndpointHandler</code> needs to implement an <code>__init__</code> and a
<code>__call__</code> method.`,Le,Y,Rt=`<li>The <code>__init__</code> method will be called when starting the Endpoint and will receive 1 argument, a string with the path to your model
weights. This allows you to load your model correctly.</li> <li>The <code>__call__</code> method will be called on every request and receive a dictionary with your request body as a python dictionary.
It will always contain the <code>inputs</code> key.</li>`,qe,z,Qt="The first step is to create our <code>handler.py</code> in the local clone of our repository.",Fe,A,Xe,L,St="In there, you define your <code>EndpointHandler</code> class with the <code>__init__</code> and <code>__call__ </code>method.",Ve,q,Pe,F,De,X,Yt=`Now, you can add all of the custom logic you want to use during initialization or inference to your Custom Endpoint. You can
already find multiple <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">Custom Handlers on the Hub</a> if you need some
inspiration. In our example, we will add a custom condition based on additional payload information.`,Ke,V,zt=`<em>The model we are using in the tutorial is fine-tuned to detect emotions. We will add an additional payload field for the date, and
will use an external package to check if it is a holiday, to add a condition so that when the input date is a holiday, the model
returns “happy” - since everyone is happy when there are holidays </em>🌴🎉😆`,Oe,P,At=`First, we need to create a new <code>requirements.txt</code> and add our <a href="https://pypi.org/project/holidays/" rel="nofollow">holiday detection package</a> and make
sure we have it installed in our development environment as well.`,et,D,tt,K,Lt="Next, we have to adjust our <code>handler.py</code> and <code>EndpointHandler</code> to match our condition.",lt,O,st,ee,nt,te,qt="To test our EndpointHandler, we can simplify import, initialize and test it. Therefore we only need to prepare a sample payload.",at,le,it,se,Ft="It works!!!! 🎉",pt,ne,Xt=`<em>Note: If you are using a notebook you might have to restart your kernel when you make changes to the handler.py since it is not
automatically re-imported.</em>`,ot,ae,rt,ie,Vt="After you have successfully tested your handler locally, you can push it to your repository by simply using basic git commands.",dt,pe,yt,oe,Pt=`Now, you should see your <code>handler.py</code> and <code>requirements.txt</code> in your repository in the
<a href="https://huggingface.co/philschmid/distilbert-base-uncased-emotion/tree/main" rel="nofollow">“Files and version”</a> tab.`,ht,re,ct,de,Dt=`The last step is to deploy your Custom Handler as an Inference Endpoint. You can deploy your Custom Handler like you would a regular
Inference Endpoint. Add your repository, select your cloud and region, your instance and security setting, and deploy.`,wt,ye,Kt=`When creating your Endpoint, the Inference Endpoint Service will check for an available and valid <code>handler.py</code>, and will use it for
serving requests no matter which “Task” you select.`,Mt,he,Ot=`<em>Note: In your <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">Inference Endpoints dashboard</a>, the Task for this Endpoint should now be set
to Custom</em>`,Tt,ce,ut,we,el=`There are a few examples on the <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">Hugging Face Hub</a> from where you can take
inspiration or directly use them. The repositories are tagged with <code>endpoints-template</code> and can be found under this
<a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">link</a>.`,mt,Me,tl="You’ll find examples are for:",Jt,Te,ll='<li><a href="https://huggingface.co/philschmid/distilbert-onnx-banking77" rel="nofollow">Optimum and ONNX Runtime</a></li> <li><a href="https://huggingface.co/florentgbelidji/blip_image_embeddings" rel="nofollow">Image Embeddings with BLIP</a></li> <li><a href="https://huggingface.co/philschmid/trocr-base-printed" rel="nofollow">TrOCR for OCR Detection</a></li> <li><a href="https://huggingface.co/philschmid/all-MiniLM-L6-v2-optimum-embeddings" rel="nofollow">Optimized Sentence Transformers with Optimum</a></li> <li><a href="https://huggingface.co/philschmid/pyannote-speaker-diarization-endpoint" rel="nofollow">Pyannote Speaker diarization</a></li> <li><a href="https://huggingface.co/philschmid/layoutlm-funsd" rel="nofollow">LayoutLM</a></li> <li><a href="https://huggingface.co/philschmid/flair-ner-english-ontonotes-large" rel="nofollow">Flair NER</a></li> <li><a href="https://huggingface.co/philschmid/gpt-j-6B-fp16-sharded" rel="nofollow">GPT-J 6B Single GPU</a></li> <li><a href="https://huggingface.co/philschmid/donut-base-finetuned-cord-v2" rel="nofollow">Donut Document understanding</a></li> <li><a href="https://huggingface.co/philschmid/setfit-ag-news-endpoint" rel="nofollow">SetFit classifier</a></li>',ft,ue,It,Je,jt;return m=new hl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new M({props:{title:"Inference Toolkit",local:"inference-toolkit",headingTag:"h1"}}),j=new M({props:{title:"Create a custom Inference Handler",local:"create-a-custom-inference-handler",headingTag:"h1"}}),C=new M({props:{title:"Tutorial",local:"tutorial",headingTag:"h2"}}),x=new M({props:{title:"1. Set up Development Environment",local:"1-set-up-development-environment",headingTag:"h3"}}),_=new u({props:{code:"JTIzJTIwaW5zdGFsbCUyMGdpdC1sZnMlMjB0byUyMGludGVyYWN0JTIwd2l0aCUyMHRoZSUyMHJlcG9zaXRvcnklMEFzdWRvJTIwYXB0LWdldCUyMHVwZGF0ZSUwQXN1ZG8lMjBhcHQtZ2V0JTIwaW5zdGFsbCUyMGdpdC1sZnMlMEElMjMlMjBpbnN0YWxsJTIwdHJhbnNmb3JtZXJzJTIwKG5vdCUyMG5lZWRlZCUyMHNpbmNlJTIwaXQlMjBpcyUyMGluc3RhbGxlZCUyMGJ5JTIwZGVmYXVsdCUyMGluJTIwdGhlJTIwY29udGFpbmVyKSUwQXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlNUJza2xlYXJuJTJDc2VudGVuY2VwaWVjZSUyQ2F1ZGlvJTJDdmlzaW9uJTVE",highlighted:`<span class="hljs-comment"># install git-lfs to interact with the repository</span>
sudo apt-<span class="hljs-built_in">get</span> update
sudo apt-<span class="hljs-built_in">get</span> install git-lfs
<span class="hljs-comment"># install transformers (not needed since it is installed by default in the container)</span>
pip install transformers[sklearn,sentencepiece,audio,vision]`,wrap:!1}}),E=new u({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbCUwQWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnBoaWxzY2htaWQlMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1lbW90aW9u",highlighted:`git lfs install
git clone https:<span class="hljs-regexp">//</span>huggingface.co<span class="hljs-regexp">/philschmid/</span>distilbert-base-uncased-emotion`,wrap:!1}}),R=new u({props:{code:"JTIzJTIwc2V0dXAlMjBjbGklMjB3aXRoJTIwdG9rZW4lMEFodWdnaW5nZmFjZS1jbGklMjBsb2dpbiUwQWdpdCUyMGNvbmZpZyUyMC0tZ2xvYmFsJTIwY3JlZGVudGlhbC5oZWxwZXIlMjBzdG9yZQ==",highlighted:`# setup <span class="hljs-keyword">cli</span> with <span class="hljs-keyword">token</span>
huggingface-<span class="hljs-keyword">cli</span> login
git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),Q=new M({props:{title:"2. Create EndpointHandler",local:"2-create-endpointhandler",headingTag:"h3"}}),A=new u({props:{code:"IWNkJTIwZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZW1vdGlvbiUyMCUyNiUyNiUyMHRvdWNoJTIwaGFuZGxlci5weQ==",highlighted:'!<span class="hljs-built_in">cd</span> distilbert-base-uncased-emotion &amp;&amp; <span class="hljs-built_in">touch</span> handler.py',wrap:!1}}),q=new u({props:{code:"ZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMERpY3QlMkMlMjBMaXN0JTJDJTIwQW55JTBBJTBBY2xhc3MlMjBFbmRwb2ludEhhbmRsZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBwYXRoJTNEJTIyJTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByZWxvYWQlMjBhbGwlMjB0aGUlMjBlbGVtZW50cyUyMHlvdSUyMGFyZSUyMGdvaW5nJTIwdG8lMjBuZWVkJTIwYXQlMjBpbmZlcmVuY2UuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwcHNldWRvJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2VsZi5tb2RlbCUzRCUyMGxvYWRfbW9kZWwocGF0aCklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwZGF0YSUzQSUyMERpY3QlNUJzdHIlMkMlMjBBbnklNUQpJTIwLSUzRSUyMExpc3QlNUJEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YSUyMGFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAoJTNBb2JqJTNBJTIwJTYwc3RyJTYwJTIwJTdDJTIwJTYwUElMLkltYWdlJTYwJTIwJTdDJTIwJTYwbnAuYXJyYXklNjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa3dhcmdzJTBBJTIwJTIwJTIwJTIwJTIwJTIwUmV0dXJuJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQSUyMCUzQW9iaiUzQSU2MGxpc3QlNjAlMjAlN0MlMjAlNjBkaWN0JTYwJTNBJTIwd2lsbCUyMGJlJTIwc2VyaWFsaXplZCUyMGFuZCUyMHJldHVybmVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwcHNldWRvJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2VsZi5tb2RlbChpbnB1dCk=",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Any</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">EndpointHandler</span>():
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, path=<span class="hljs-string">&quot;&quot;</span></span>):
        <span class="hljs-comment"># Preload all the elements you are going to need at inference.</span>
        <span class="hljs-comment"># pseudo:</span>
        <span class="hljs-comment"># self.model= load_model(path)</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, data: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]:
        <span class="hljs-string">&quot;&quot;&quot;
       data args:
            inputs (:obj: \`str\` | \`PIL.Image\` | \`np.array\`)
            kwargs
      Return:
            A :obj:\`list\` | \`dict\`: will be serialized and returned
        &quot;&quot;&quot;</span>

        <span class="hljs-comment"># pseudo</span>
        <span class="hljs-comment"># self.model(input)</span>`,wrap:!1}}),F=new M({props:{title:"3. Customize EndpointHandler",local:"3-customize-endpointhandler",headingTag:"h3"}}),D=new u({props:{code:"IWVjaG8lMjAlMjJob2xpZGF5cyUyMiUyMCUzRSUzRSUyMHJlcXVpcmVtZW50cy50eHQlMEEhcGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`!echo <span class="hljs-string">&quot;holidays&quot;</span> &gt;&gt; requirements.txt
!pip install -r requirements.txt`,wrap:!1}}),O=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Any</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> holidays

<span class="hljs-keyword">class</span> <span class="hljs-title class_">EndpointHandler</span>():
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, path=<span class="hljs-string">&quot;&quot;</span></span>):
        self.pipeline = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>,model=path)
        self.holidays = holidays.US()

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, data: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]:
        <span class="hljs-string">&quot;&quot;&quot;
       data args:
            inputs (:obj: \`str\`)
            date (:obj: \`str\`)
      Return:
            A :obj:\`list\` | \`dict\`: will be serialized and returned
        &quot;&quot;&quot;</span>
        <span class="hljs-comment"># get inputs</span>
        inputs = data.pop(<span class="hljs-string">&quot;inputs&quot;</span>,data)
        date = data.pop(<span class="hljs-string">&quot;date&quot;</span>, <span class="hljs-literal">None</span>)

        <span class="hljs-comment"># check if date exists and if it is a holiday</span>
        <span class="hljs-keyword">if</span> date <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> date <span class="hljs-keyword">in</span> self.holidays:
          <span class="hljs-keyword">return</span> [{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;happy&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">1</span>}]


        <span class="hljs-comment"># run normal prediction</span>
        prediction = self.pipeline(inputs)
        <span class="hljs-keyword">return</span> prediction`,wrap:!1}}),ee=new M({props:{title:"4. Test EndpointHandler",local:"4-test-endpointhandler",headingTag:"h3"}}),le=new u({props:{code:"ZnJvbSUyMGhhbmRsZXIlMjBpbXBvcnQlMjBFbmRwb2ludEhhbmRsZXIlMEElMEElMjMlMjBpbml0JTIwaGFuZGxlciUwQW15X2hhbmRsZXIlMjAlM0QlMjBFbmRwb2ludEhhbmRsZXIocGF0aCUzRCUyMi4lMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMHNhbXBsZSUyMHBheWxvYWQlMEFub25faG9saWRheV9wYXlsb2FkJTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIySSUyMGFtJTIwcXVpdGUlMjBleGNpdGVkJTIwaG93JTIwdGhpcyUyMHdpbGwlMjB0dXJuJTIwb3V0JTIyJTJDJTIwJTIyZGF0ZSUyMiUzQSUyMCUyMjIwMjItMDgtMDglMjIlN0QlMEFob2xpZGF5X3BheWxvYWQlMjAlM0QlMjAlN0IlMjJpbnB1dHMlMjIlM0ElMjAlMjJUb2RheSUyMGlzJTIwYSUyMHRvdWdoJTIwZGF5JTIyJTJDJTIwJTIyZGF0ZSUyMiUzQSUyMCUyMjIwMjItMDctMDQlMjIlN0QlMEElMEElMjMlMjB0ZXN0JTIwdGhlJTIwaGFuZGxlciUwQW5vbl9ob2xpZGF5X3ByZWQlM0RteV9oYW5kbGVyKG5vbl9ob2xpZGF5X3BheWxvYWQpJTBBaG9saWRheV9wcmVkJTNEbXlfaGFuZGxlcihob2xpZGF5X3BheWxvYWQpJTBBJTBBJTIzJTIwc2hvdyUyMHJlc3VsdHMlMEFwcmludCglMjJub25faG9saWRheV9wcmVkJTIyJTJDJTIwbm9uX2hvbGlkYXlfcHJlZCklMEFwcmludCglMjJob2xpZGF5X3ByZWQlMjIlMkMlMjBob2xpZGF5X3ByZWQpJTBBJTBBJTIzJTIwbm9uX2hvbGlkYXlfcHJlZCUyMCU1QiU3QidsYWJlbCclM0ElMjAnam95JyUyQyUyMCdzY29yZSclM0ElMjAwLjk5ODU5NDIyNDQ1Mjk3MjQlN0QlNUQlMEElMjMlMjBob2xpZGF5X3ByZWQlMjAlNUIlN0InbGFiZWwnJTNBJTIwJ2hhcHB5JyUyQyUyMCdzY29yZSclM0ElMjAxJTdEJTVE",highlighted:`<span class="hljs-keyword">from</span> handler <span class="hljs-keyword">import</span> EndpointHandler

<span class="hljs-comment"># init handler</span>
my_handler = EndpointHandler(path=<span class="hljs-string">&quot;.&quot;</span>)

<span class="hljs-comment"># prepare sample payload</span>
non_holiday_payload = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;I am quite excited how this will turn out&quot;</span>, <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2022-08-08&quot;</span>}
holiday_payload = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Today is a tough day&quot;</span>, <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2022-07-04&quot;</span>}

<span class="hljs-comment"># test the handler</span>
non_holiday_pred=my_handler(non_holiday_payload)
holiday_pred=my_handler(holiday_payload)

<span class="hljs-comment"># show results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;non_holiday_pred&quot;</span>, non_holiday_pred)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;holiday_pred&quot;</span>, holiday_pred)

<span class="hljs-comment"># non_holiday_pred [{&#x27;label&#x27;: &#x27;joy&#x27;, &#x27;score&#x27;: 0.9985942244529724}]</span>
<span class="hljs-comment"># holiday_pred [{&#x27;label&#x27;: &#x27;happy&#x27;, &#x27;score&#x27;: 1}]</span>`,wrap:!1}}),ae=new M({props:{title:"5. Push the Custom Handler to your repository",local:"5-push-the-custom-handler-to-your-repository",headingTag:"h3"}}),pe=new u({props:{code:"JTIzJTIwYWRkJTIwYWxsJTIwb3VyJTIwbmV3JTIwZmlsZXMlMEEhZ2l0JTIwYWRkJTIwKiUwQSUyMyUyMGNvbW1pdCUyMG91ciUyMGZpbGVzJTBBIWdpdCUyMGNvbW1pdCUyMC1tJTIwJTIyYWRkJTIwY3VzdG9tJTIwaGFuZGxlciUyMiUwQSUyMyUyMHB1c2glMjB0aGUlMjBmaWxlcyUyMHRvJTIwdGhlJTIwaHViJTBBIWdpdCUyMHB1c2g=",highlighted:`# <span class="hljs-built_in">add</span> <span class="hljs-keyword">all</span> our <span class="hljs-keyword">new</span> <span class="hljs-keyword">files</span>
!git <span class="hljs-built_in">add</span> *
# commit our <span class="hljs-keyword">files</span>
!git commit -<span class="hljs-keyword">m</span> <span class="hljs-string">&quot;add custom handler&quot;</span>
# push the <span class="hljs-keyword">files</span> <span class="hljs-keyword">to</span> the hub
!git push`,wrap:!1}}),re=new M({props:{title:"6. Deploy your Custom Handler as an Inference Endpoint",local:"6-deploy-your-custom-handler-as-an-inference-endpoint",headingTag:"h3"}}),ce=new M({props:{title:"Examples",local:"examples",headingTag:"h2"}}),ue=new cl({props:{source:"https://github.com/huggingface/hf-endpoints-documentation/blob/main/docs/source/engines/toolkit.md"}}),{c(){T=i("meta"),fe=n(),me=i("p"),Ie=n(),r(m.$$.fragment),je=n(),r(J.$$.fragment),Ue=n(),f=i("p"),f.textContent=bt,be=n(),I=i("p"),I.textContent=gt,ge=n(),r(j.$$.fragment),Ce=n(),U=i("p"),U.innerHTML=Ct,Be=n(),b=i("p"),b.innerHTML=Bt,$e=n(),g=i("p"),g.innerHTML=$t,Ge=n(),r(C.$$.fragment),ve=n(),B=i("p"),B.innerHTML=Gt,xe=n(),$=i("p"),$.innerHTML=vt,ke=n(),G=i("p"),G.innerHTML=xt,_e=n(),v=i("p"),v.innerHTML=kt,He=n(),r(x.$$.fragment),Ze=n(),k=i("p"),k.innerHTML=_t,Ee=n(),r(_.$$.fragment),We=n(),H=i("p"),H.textContent=Ht,Ne=n(),Z=i("p"),Z.innerHTML=Zt,Re=n(),r(E.$$.fragment),Qe=n(),W=i("p"),W.innerHTML=Et,Se=n(),N=i("p"),N.innerHTML=Wt,Ye=n(),r(R.$$.fragment),ze=n(),r(Q.$$.fragment),Ae=n(),S=i("p"),S.innerHTML=Nt,Le=n(),Y=i("ul"),Y.innerHTML=Rt,qe=n(),z=i("p"),z.innerHTML=Qt,Fe=n(),r(A.$$.fragment),Xe=n(),L=i("p"),L.innerHTML=St,Ve=n(),r(q.$$.fragment),Pe=n(),r(F.$$.fragment),De=n(),X=i("p"),X.innerHTML=Yt,Ke=n(),V=i("p"),V.innerHTML=zt,Oe=n(),P=i("p"),P.innerHTML=At,et=n(),r(D.$$.fragment),tt=n(),K=i("p"),K.innerHTML=Lt,lt=n(),r(O.$$.fragment),st=n(),r(ee.$$.fragment),nt=n(),te=i("p"),te.textContent=qt,at=n(),r(le.$$.fragment),it=n(),se=i("p"),se.textContent=Ft,pt=n(),ne=i("p"),ne.innerHTML=Xt,ot=n(),r(ae.$$.fragment),rt=n(),ie=i("p"),ie.textContent=Vt,dt=n(),r(pe.$$.fragment),yt=n(),oe=i("p"),oe.innerHTML=Pt,ht=n(),r(re.$$.fragment),ct=n(),de=i("p"),de.textContent=Dt,wt=n(),ye=i("p"),ye.innerHTML=Kt,Mt=n(),he=i("p"),he.innerHTML=Ot,Tt=n(),r(ce.$$.fragment),ut=n(),we=i("p"),we.innerHTML=el,mt=n(),Me=i("p"),Me.textContent=tl,Jt=n(),Te=i("ul"),Te.innerHTML=ll,ft=n(),r(ue.$$.fragment),It=n(),Je=i("p"),this.h()},l(e){const t=dl("svelte-u9bgzb",document.head);T=p(t,"META",{name:!0,content:!0}),t.forEach(l),fe=a(e),me=p(e,"P",{}),sl(me).forEach(l),Ie=a(e),d(m.$$.fragment,e),je=a(e),d(J.$$.fragment,e),Ue=a(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-onimv6"&&(f.textContent=bt),be=a(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1x03yvk"&&(I.textContent=gt),ge=a(e),d(j.$$.fragment,e),Ce=a(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1cuhii1"&&(U.innerHTML=Ct),Be=a(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-ek3q7r"&&(b.innerHTML=Bt),$e=a(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1v0h8dt"&&(g.innerHTML=$t),Ge=a(e),d(C.$$.fragment,e),ve=a(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-x923ye"&&(B.innerHTML=Gt),xe=a(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-qyh9p3"&&($.innerHTML=vt),ke=a(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-xuocio"&&(G.innerHTML=xt),_e=a(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-16in619"&&(v.innerHTML=kt),He=a(e),d(x.$$.fragment,e),Ze=a(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-bzdaav"&&(k.innerHTML=_t),Ee=a(e),d(_.$$.fragment,e),We=a(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-12klzx5"&&(H.textContent=Ht),Ne=a(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-68hofi"&&(Z.innerHTML=Zt),Re=a(e),d(E.$$.fragment,e),Qe=a(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-54lmtl"&&(W.innerHTML=Et),Se=a(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-k22wa5"&&(N.innerHTML=Wt),Ye=a(e),d(R.$$.fragment,e),ze=a(e),d(Q.$$.fragment,e),Ae=a(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1b0qtu9"&&(S.innerHTML=Nt),Le=a(e),Y=p(e,"UL",{"data-svelte-h":!0}),o(Y)!=="svelte-1bfhmae"&&(Y.innerHTML=Rt),qe=a(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1xwwutb"&&(z.innerHTML=Qt),Fe=a(e),d(A.$$.fragment,e),Xe=a(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-16cpa65"&&(L.innerHTML=St),Ve=a(e),d(q.$$.fragment,e),Pe=a(e),d(F.$$.fragment,e),De=a(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-174kzrx"&&(X.innerHTML=Yt),Ke=a(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-10cxuyb"&&(V.innerHTML=zt),Oe=a(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1wywlb7"&&(P.innerHTML=At),et=a(e),d(D.$$.fragment,e),tt=a(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1s8qwlb"&&(K.innerHTML=Lt),lt=a(e),d(O.$$.fragment,e),st=a(e),d(ee.$$.fragment,e),nt=a(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-4es9m7"&&(te.textContent=qt),at=a(e),d(le.$$.fragment,e),it=a(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-vtyfqm"&&(se.textContent=Ft),pt=a(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-xvallb"&&(ne.innerHTML=Xt),ot=a(e),d(ae.$$.fragment,e),rt=a(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1ii6eax"&&(ie.textContent=Vt),dt=a(e),d(pe.$$.fragment,e),yt=a(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1u44z0y"&&(oe.innerHTML=Pt),ht=a(e),d(re.$$.fragment,e),ct=a(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-zm7hu6"&&(de.textContent=Dt),wt=a(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1bd3erx"&&(ye.innerHTML=Kt),Mt=a(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1riwy1z"&&(he.innerHTML=Ot),Tt=a(e),d(ce.$$.fragment,e),ut=a(e),we=p(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1vi1jdr"&&(we.innerHTML=el),mt=a(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-18t9mwx"&&(Me.textContent=tl),Jt=a(e),Te=p(e,"UL",{"data-svelte-h":!0}),o(Te)!=="svelte-hgiuvk"&&(Te.innerHTML=ll),ft=a(e),d(ue.$$.fragment,e),It=a(e),Je=p(e,"P",{}),sl(Je).forEach(l),this.h()},h(){nl(T,"name","hf:doc:metadata"),nl(T,"content",Ml)},m(e,t){yl(document.head,T),s(e,fe,t),s(e,me,t),s(e,Ie,t),y(m,e,t),s(e,je,t),y(J,e,t),s(e,Ue,t),s(e,f,t),s(e,be,t),s(e,I,t),s(e,ge,t),y(j,e,t),s(e,Ce,t),s(e,U,t),s(e,Be,t),s(e,b,t),s(e,$e,t),s(e,g,t),s(e,Ge,t),y(C,e,t),s(e,ve,t),s(e,B,t),s(e,xe,t),s(e,$,t),s(e,ke,t),s(e,G,t),s(e,_e,t),s(e,v,t),s(e,He,t),y(x,e,t),s(e,Ze,t),s(e,k,t),s(e,Ee,t),y(_,e,t),s(e,We,t),s(e,H,t),s(e,Ne,t),s(e,Z,t),s(e,Re,t),y(E,e,t),s(e,Qe,t),s(e,W,t),s(e,Se,t),s(e,N,t),s(e,Ye,t),y(R,e,t),s(e,ze,t),y(Q,e,t),s(e,Ae,t),s(e,S,t),s(e,Le,t),s(e,Y,t),s(e,qe,t),s(e,z,t),s(e,Fe,t),y(A,e,t),s(e,Xe,t),s(e,L,t),s(e,Ve,t),y(q,e,t),s(e,Pe,t),y(F,e,t),s(e,De,t),s(e,X,t),s(e,Ke,t),s(e,V,t),s(e,Oe,t),s(e,P,t),s(e,et,t),y(D,e,t),s(e,tt,t),s(e,K,t),s(e,lt,t),y(O,e,t),s(e,st,t),y(ee,e,t),s(e,nt,t),s(e,te,t),s(e,at,t),y(le,e,t),s(e,it,t),s(e,se,t),s(e,pt,t),s(e,ne,t),s(e,ot,t),y(ae,e,t),s(e,rt,t),s(e,ie,t),s(e,dt,t),y(pe,e,t),s(e,yt,t),s(e,oe,t),s(e,ht,t),y(re,e,t),s(e,ct,t),s(e,de,t),s(e,wt,t),s(e,ye,t),s(e,Mt,t),s(e,he,t),s(e,Tt,t),y(ce,e,t),s(e,ut,t),s(e,we,t),s(e,mt,t),s(e,Me,t),s(e,Jt,t),s(e,Te,t),s(e,ft,t),y(ue,e,t),s(e,It,t),s(e,Je,t),jt=!0},p:il,i(e){jt||(h(m.$$.fragment,e),h(J.$$.fragment,e),h(j.$$.fragment,e),h(C.$$.fragment,e),h(x.$$.fragment,e),h(_.$$.fragment,e),h(E.$$.fragment,e),h(R.$$.fragment,e),h(Q.$$.fragment,e),h(A.$$.fragment,e),h(q.$$.fragment,e),h(F.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(pe.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),jt=!0)},o(e){c(m.$$.fragment,e),c(J.$$.fragment,e),c(j.$$.fragment,e),c(C.$$.fragment,e),c(x.$$.fragment,e),c(_.$$.fragment,e),c(E.$$.fragment,e),c(R.$$.fragment,e),c(Q.$$.fragment,e),c(A.$$.fragment,e),c(q.$$.fragment,e),c(F.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),c(re.$$.fragment,e),c(ce.$$.fragment,e),c(ue.$$.fragment,e),jt=!1},d(e){e&&(l(fe),l(me),l(Ie),l(je),l(Ue),l(f),l(be),l(I),l(ge),l(Ce),l(U),l(Be),l(b),l($e),l(g),l(Ge),l(ve),l(B),l(xe),l($),l(ke),l(G),l(_e),l(v),l(He),l(Ze),l(k),l(Ee),l(We),l(H),l(Ne),l(Z),l(Re),l(Qe),l(W),l(Se),l(N),l(Ye),l(ze),l(Ae),l(S),l(Le),l(Y),l(qe),l(z),l(Fe),l(Xe),l(L),l(Ve),l(Pe),l(De),l(X),l(Ke),l(V),l(Oe),l(P),l(et),l(tt),l(K),l(lt),l(st),l(nt),l(te),l(at),l(it),l(se),l(pt),l(ne),l(ot),l(rt),l(ie),l(dt),l(yt),l(oe),l(ht),l(ct),l(de),l(wt),l(ye),l(Mt),l(he),l(Tt),l(ut),l(we),l(mt),l(Me),l(Jt),l(Te),l(ft),l(It),l(Je)),l(T),w(m,e),w(J,e),w(j,e),w(C,e),w(x,e),w(_,e),w(E,e),w(R,e),w(Q,e),w(A,e),w(q,e),w(F,e),w(D,e),w(O,e),w(ee,e),w(le,e),w(ae,e),w(pe,e),w(re,e),w(ce,e),w(ue,e)}}}const Ml='{"title":"Inference Toolkit","local":"inference-toolkit","sections":[],"depth":1}';function Tl(Ut){return pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends ol{constructor(T){super(),rl(this,T,Tl,wl,al,{})}}export{Il as component};
