import{s as sl,n as nl,o as al}from"../chunks/scheduler.f6b352c8.js";import{S as il,i as ol,g as i,s as n,r as d,A as pl,h as o,f as l,c as a,j as tl,u as r,x as p,k as ll,y as dl,a as s,v as y,d as h,t as c,w}from"../chunks/index.b90df637.js";import{C as u}from"../chunks/CodeBlock.e5718f9d.js";import{H as T,E as rl}from"../chunks/getInferenceSnippets.7fe75217.js";function yl(It){let M,Je,ue,fe,m,Ie,J,Ut=`In some cases, the model you’re looking to deploy isn’t supported by any of the high-performance inference engines. In this case,
we provide a fallback option. The Inference Toolkit supports models that are implemented in the
Transformers, Sentence-Transformers and Diffusers libraries, and wraps them in a light web server.`,Ue,f,jt="The Inference Toolkit is perfect for testing models and building demos, but isn’t as production-ready as TGI, vLLM, SGLang, or llama.cpp.",je,I,be,U,bt=`Hugging Face Endpoints supports all of the Transformers and Sentence-Transformers tasks and can support custom tasks, including
custom pre- &amp; post-processing. The customization can be done through a
<a href="https://huggingface.co/philschmid/distilbert-onnx-banking77/blob/main/handler.py" rel="nofollow">handler.py</a> file in your model repository on
the Hugging Face Hub.`,ge,j,gt=`The <a href="https://huggingface.co/philschmid/distilbert-onnx-banking77/blob/main/handler.py" rel="nofollow">handler.py</a> needs to implement
the <a href="https://huggingface.co/philschmid/distilbert-onnx-banking77/blob/main/handler.py" rel="nofollow">EndpointHandler</a> class with a
<code>__init__</code> and a <code>__call__</code> method.`,Ce,b,Ct=`If you want to use custom dependencies, e.g. <a href="https://raw.githubusercontent.com/huggingface/optimum" rel="nofollow">optimum</a>, the dependencies must
be listed in a <code>requirements.txt</code> as described above in “add custom dependencies.”`,Be,g,Ge,C,Bt=`Before creating a Custom Handler, you need a Hugging Face Model repository with your model weights and an Access Token with
<em>write</em> access to the repository. To find, create and manage Access Tokens, click <a href="https://huggingface.co/settings/tokens" rel="nofollow">here</a>.`,$e,B,Gt=`If you want to write a Custom Handler for an existing model from the community, you can use the <a href="https://huggingface.co/spaces/osanseviero/repo_duplicator" rel="nofollow">repo_duplicator</a>
to create a repository fork.`,ve,G,$t='The code can also be found in this <a href="https://colab.research.google.com/drive/1hANJeRa1PK1gZaUorobnQGu4bFj4_4Rf?usp=sharing" rel="nofollow">Notebook</a>.',ke,$,vt='You can also search for already existing Custom Handlers here: <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">https://huggingface.co/models?other=endpoints-template</a>',_e,v,He,k,kt=`The easiest way to develop our custom handler is to set up a local development environment, to implement, test, and iterate there, and then
deploy it as an Inference Endpoint. The first step is to install all required development dependencies. <em>needed to create the custom
handler, not needed for inference</em>`,xe,_,Ze,H,_t="After we have installed our libraries we will clone our repository to our development environment.",Ee,x,Ht=`We will use <a href="https://huggingface.co/philschmid/distilbert-base-uncased-emotion" rel="nofollow">philschmid/distilbert-base-uncased-emotion</a> during the
tutorial.`,We,Z,Re,E,xt="To be able to push our model repo later you need to login into our HF account. This can be done by using the <code>huggingface-cli</code>.",Ne,W,Zt="<em>Note: Make sure to configure git config as well.</em>",Se,R,ze,N,Ae,S,Et=`After we have set up our environment, we can start creating your custom handler. The custom handler is a Python class
(<code>EndpointHandler</code>) inside a <code>handler.py</code> file in our repository. The <code>EndpointHandler</code> needs to implement an <code>__init__</code> and a
<code>__call__</code> method.`,Qe,z,Wt=`<li>The <code>__init__</code> method will be called when starting the Endpoint and will receive 1 argument, a string with the path to your model
weights. This allows you to load your model correctly.</li> <li>The <code>__call__</code> method will be called on every request and receive a dictionary with your request body as a python dictionary.
It will always contain the <code>inputs</code> key.</li>`,Ye,A,Rt="The first step is to create our <code>handler.py</code> in the local clone of our repository.",Le,Q,Ve,Y,Nt="In there, you define your <code>EndpointHandler</code> class with the <code>__init__</code> and <code>__call__ </code>method.",Xe,L,qe,V,Fe,X,St=`Now, you can add all of the custom logic you want to use during initialization or inference to your Custom Endpoint. You can
already find multiple <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">Custom Handlers on the Hub</a> if you need some
inspiration. In our example, we will add a custom condition based on additional payload information.`,Pe,q,zt=`<em>The model we are using in the tutorial is fine-tuned to detect emotions. We will add an additional payload field for the date, and
will use an external package to check if it is a holiday, to add a condition so that when the input date is a holiday, the model
returns “happy” - since everyone is happy when there are holidays </em>🌴🎉😆`,De,F,At=`First, we need to create a new <code>requirements.txt</code> and add our <a href="https://pypi.org/project/holidays/" rel="nofollow">holiday detection package</a> and make
sure we have it installed in our development environment as well.`,Ke,P,Oe,D,Qt="Next, we have to adjust our <code>handler.py</code> and <code>EndpointHandler</code> to match our condition.",et,K,tt,O,lt,ee,Yt="To test our EndpointHandler, we can simplify import, initialize and test it. Therefore we only need to prepare a sample payload.",st,te,nt,le,Lt="It works!!!! 🎉",at,se,Vt=`<em>Note: If you are using a notebook you might have to restart your kernel when you make changes to the handler.py since it is not
automatically re-imported.</em>`,it,ne,ot,ae,Xt="After you have successfully tested your handler locally, you can push it to your repository by simply using basic git commands.",pt,ie,dt,oe,qt=`Now, you should see your <code>handler.py</code> and <code>requirements.txt</code> in your repository in the
<a href="https://huggingface.co/philschmid/distilbert-base-uncased-emotion/tree/main" rel="nofollow">“Files and version”</a> tab.`,rt,pe,yt,de,Ft=`The last step is to deploy your Custom Handler as an Inference Endpoint. You can deploy your Custom Handler like you would a regular
Inference Endpoint. Add your repository, select your cloud and region, your instance and security setting, and deploy.`,ht,re,Pt=`When creating your Endpoint, the Inference Endpoint Service will check for an available and valid <code>handler.py</code>, and will use it for
serving requests no matter which “Task” you select.`,ct,ye,Dt=`<em>Note: In your <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">Inference Endpoints dashboard</a>, the Task for this Endpoint should now be set
to Custom</em>`,wt,he,Tt,ce,Kt=`There are a few examples on the <a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">Hugging Face Hub</a> from where you can take
inspiration or directly use them. The repositories are tagged with <code>endpoints-template</code> and can be found under this
<a href="https://huggingface.co/models?other=endpoints-template" rel="nofollow">link</a>.`,Mt,we,Ot="You’ll find examples are for:",ut,Te,el='<li><a href="https://huggingface.co/philschmid/distilbert-onnx-banking77" rel="nofollow">Optimum and ONNX Runtime</a></li> <li><a href="https://huggingface.co/florentgbelidji/blip_image_embeddings" rel="nofollow">Image Embeddings with BLIP</a></li> <li><a href="https://huggingface.co/philschmid/trocr-base-printed" rel="nofollow">TrOCR for OCR Detection</a></li> <li><a href="https://huggingface.co/philschmid/all-MiniLM-L6-v2-optimum-embeddings" rel="nofollow">Optimized Sentence Transformers with Optimum</a></li> <li><a href="https://huggingface.co/philschmid/pyannote-speaker-diarization-endpoint" rel="nofollow">Pyannote Speaker diarization</a></li> <li><a href="https://huggingface.co/philschmid/layoutlm-funsd" rel="nofollow">LayoutLM</a></li> <li><a href="https://huggingface.co/philschmid/flair-ner-english-ontonotes-large" rel="nofollow">Flair NER</a></li> <li><a href="https://huggingface.co/philschmid/gpt-j-6B-fp16-sharded" rel="nofollow">GPT-J 6B Single GPU</a></li> <li><a href="https://huggingface.co/philschmid/donut-base-finetuned-cord-v2" rel="nofollow">Donut Document understanding</a></li> <li><a href="https://huggingface.co/philschmid/setfit-ag-news-endpoint" rel="nofollow">SetFit classifier</a></li>',mt,Me,Jt,me,ft;return m=new T({props:{title:"Inference Toolkit",local:"inference-toolkit",headingTag:"h1"}}),I=new T({props:{title:"Create a custom Inference Handler",local:"create-a-custom-inference-handler",headingTag:"h1"}}),g=new T({props:{title:"Tutorial",local:"tutorial",headingTag:"h2"}}),v=new T({props:{title:"1. Set up Development Environment",local:"1-set-up-development-environment",headingTag:"h3"}}),_=new u({props:{code:"JTIzJTIwaW5zdGFsbCUyMGdpdC1sZnMlMjB0byUyMGludGVyYWN0JTIwd2l0aCUyMHRoZSUyMHJlcG9zaXRvcnklMEFzdWRvJTIwYXB0LWdldCUyMHVwZGF0ZSUwQXN1ZG8lMjBhcHQtZ2V0JTIwaW5zdGFsbCUyMGdpdC1sZnMlMEElMjMlMjBpbnN0YWxsJTIwdHJhbnNmb3JtZXJzJTIwKG5vdCUyMG5lZWRlZCUyMHNpbmNlJTIwaXQlMjBpcyUyMGluc3RhbGxlZCUyMGJ5JTIwZGVmYXVsdCUyMGluJTIwdGhlJTIwY29udGFpbmVyKSUwQXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlNUJza2xlYXJuJTJDc2VudGVuY2VwaWVjZSUyQ2F1ZGlvJTJDdmlzaW9uJTVE",highlighted:`<span class="hljs-comment"># install git-lfs to interact with the repository</span>
sudo apt-<span class="hljs-built_in">get</span> update
sudo apt-<span class="hljs-built_in">get</span> install git-lfs
<span class="hljs-comment"># install transformers (not needed since it is installed by default in the container)</span>
pip install transformers[sklearn,sentencepiece,audio,vision]`,wrap:!1}}),Z=new u({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbCUwQWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnBoaWxzY2htaWQlMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1lbW90aW9u",highlighted:`git lfs install
git clone https:<span class="hljs-regexp">//</span>huggingface.co<span class="hljs-regexp">/philschmid/</span>distilbert-base-uncased-emotion`,wrap:!1}}),R=new u({props:{code:"JTIzJTIwc2V0dXAlMjBjbGklMjB3aXRoJTIwdG9rZW4lMEFodWdnaW5nZmFjZS1jbGklMjBsb2dpbiUwQWdpdCUyMGNvbmZpZyUyMC0tZ2xvYmFsJTIwY3JlZGVudGlhbC5oZWxwZXIlMjBzdG9yZQ==",highlighted:`# setup <span class="hljs-keyword">cli</span> with <span class="hljs-keyword">token</span>
huggingface-<span class="hljs-keyword">cli</span> login
git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),N=new T({props:{title:"2. Create EndpointHandler",local:"2-create-endpointhandler",headingTag:"h3"}}),Q=new u({props:{code:"IWNkJTIwZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZW1vdGlvbiUyMCUyNiUyNiUyMHRvdWNoJTIwaGFuZGxlci5weQ==",highlighted:'!<span class="hljs-built_in">cd</span> distilbert-base-uncased-emotion &amp;&amp; <span class="hljs-built_in">touch</span> handler.py',wrap:!1}}),L=new u({props:{code:"ZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMERpY3QlMkMlMjBMaXN0JTJDJTIwQW55JTBBJTBBY2xhc3MlMjBFbmRwb2ludEhhbmRsZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBwYXRoJTNEJTIyJTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByZWxvYWQlMjBhbGwlMjB0aGUlMjBlbGVtZW50cyUyMHlvdSUyMGFyZSUyMGdvaW5nJTIwdG8lMjBuZWVkJTIwYXQlMjBpbmZlcmVuY2UuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwcHNldWRvJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2VsZi5tb2RlbCUzRCUyMGxvYWRfbW9kZWwocGF0aCklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwZGF0YSUzQSUyMERpY3QlNUJzdHIlMkMlMjBBbnklNUQpJTIwLSUzRSUyMExpc3QlNUJEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YSUyMGFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAoJTNBb2JqJTNBJTIwJTYwc3RyJTYwJTIwJTdDJTIwJTYwUElMLkltYWdlJTYwJTIwJTdDJTIwJTYwbnAuYXJyYXklNjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa3dhcmdzJTBBJTIwJTIwJTIwJTIwJTIwJTIwUmV0dXJuJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQSUyMCUzQW9iaiUzQSU2MGxpc3QlNjAlMjAlN0MlMjAlNjBkaWN0JTYwJTNBJTIwd2lsbCUyMGJlJTIwc2VyaWFsaXplZCUyMGFuZCUyMHJldHVybmVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwcHNldWRvJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2VsZi5tb2RlbChpbnB1dCk=",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Any</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">EndpointHandler</span>():
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, path=<span class="hljs-string">&quot;&quot;</span></span>):
        <span class="hljs-comment"># Preload all the elements you are going to need at inference.</span>
        <span class="hljs-comment"># pseudo:</span>
        <span class="hljs-comment"># self.model= load_model(path)</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, data: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]:
        <span class="hljs-string">&quot;&quot;&quot;
       data args:
            inputs (:obj: \`str\` | \`PIL.Image\` | \`np.array\`)
            kwargs
      Return:
            A :obj:\`list\` | \`dict\`: will be serialized and returned
        &quot;&quot;&quot;</span>

        <span class="hljs-comment"># pseudo</span>
        <span class="hljs-comment"># self.model(input)</span>`,wrap:!1}}),V=new T({props:{title:"3. Customize EndpointHandler",local:"3-customize-endpointhandler",headingTag:"h3"}}),P=new u({props:{code:"IWVjaG8lMjAlMjJob2xpZGF5cyUyMiUyMCUzRSUzRSUyMHJlcXVpcmVtZW50cy50eHQlMEEhcGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`!echo <span class="hljs-string">&quot;holidays&quot;</span> &gt;&gt; requirements.txt
!pip install -r requirements.txt`,wrap:!1}}),K=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Any</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> holidays

<span class="hljs-keyword">class</span> <span class="hljs-title class_">EndpointHandler</span>():
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, path=<span class="hljs-string">&quot;&quot;</span></span>):
        self.pipeline = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>,model=path)
        self.holidays = holidays.US()

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, data: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]:
        <span class="hljs-string">&quot;&quot;&quot;
       data args:
            inputs (:obj: \`str\`)
            date (:obj: \`str\`)
      Return:
            A :obj:\`list\` | \`dict\`: will be serialized and returned
        &quot;&quot;&quot;</span>
        <span class="hljs-comment"># get inputs</span>
        inputs = data.pop(<span class="hljs-string">&quot;inputs&quot;</span>,data)
        date = data.pop(<span class="hljs-string">&quot;date&quot;</span>, <span class="hljs-literal">None</span>)

        <span class="hljs-comment"># check if date exists and if it is a holiday</span>
        <span class="hljs-keyword">if</span> date <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> date <span class="hljs-keyword">in</span> self.holidays:
          <span class="hljs-keyword">return</span> [{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;happy&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">1</span>}]


        <span class="hljs-comment"># run normal prediction</span>
        prediction = self.pipeline(inputs)
        <span class="hljs-keyword">return</span> prediction`,wrap:!1}}),O=new T({props:{title:"4. Test EndpointHandler",local:"4-test-endpointhandler",headingTag:"h3"}}),te=new u({props:{code:"ZnJvbSUyMGhhbmRsZXIlMjBpbXBvcnQlMjBFbmRwb2ludEhhbmRsZXIlMEElMEElMjMlMjBpbml0JTIwaGFuZGxlciUwQW15X2hhbmRsZXIlMjAlM0QlMjBFbmRwb2ludEhhbmRsZXIocGF0aCUzRCUyMi4lMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMHNhbXBsZSUyMHBheWxvYWQlMEFub25faG9saWRheV9wYXlsb2FkJTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIySSUyMGFtJTIwcXVpdGUlMjBleGNpdGVkJTIwaG93JTIwdGhpcyUyMHdpbGwlMjB0dXJuJTIwb3V0JTIyJTJDJTIwJTIyZGF0ZSUyMiUzQSUyMCUyMjIwMjItMDgtMDglMjIlN0QlMEFob2xpZGF5X3BheWxvYWQlMjAlM0QlMjAlN0IlMjJpbnB1dHMlMjIlM0ElMjAlMjJUb2RheSUyMGlzJTIwYSUyMHRob3VnaCUyMGRheSUyMiUyQyUyMCUyMmRhdGUlMjIlM0ElMjAlMjIyMDIyLTA3LTA0JTIyJTdEJTBBJTBBJTIzJTIwdGVzdCUyMHRoZSUyMGhhbmRsZXIlMEFub25faG9saWRheV9wcmVkJTNEbXlfaGFuZGxlcihub25faG9saWRheV9wYXlsb2FkKSUwQWhvbGlkYXlfcHJlZCUzRG15X2hhbmRsZXIoaG9saWRheV9wYXlsb2FkKSUwQSUwQSUyMyUyMHNob3clMjByZXN1bHRzJTBBcHJpbnQoJTIybm9uX2hvbGlkYXlfcHJlZCUyMiUyQyUyMG5vbl9ob2xpZGF5X3ByZWQpJTBBcHJpbnQoJTIyaG9saWRheV9wcmVkJTIyJTJDJTIwaG9saWRheV9wcmVkKSUwQSUwQSUyMyUyMG5vbl9ob2xpZGF5X3ByZWQlMjAlNUIlN0InbGFiZWwnJTNBJTIwJ2pveSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTg1OTQyMjQ0NTI5NzI0JTdEJTVEJTBBJTIzJTIwaG9saWRheV9wcmVkJTIwJTVCJTdCJ2xhYmVsJyUzQSUyMCdoYXBweSclMkMlMjAnc2NvcmUnJTNBJTIwMSU3RCU1RA==",highlighted:`<span class="hljs-keyword">from</span> handler <span class="hljs-keyword">import</span> EndpointHandler

<span class="hljs-comment"># init handler</span>
my_handler = EndpointHandler(path=<span class="hljs-string">&quot;.&quot;</span>)

<span class="hljs-comment"># prepare sample payload</span>
non_holiday_payload = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;I am quite excited how this will turn out&quot;</span>, <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2022-08-08&quot;</span>}
holiday_payload = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Today is a though day&quot;</span>, <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2022-07-04&quot;</span>}

<span class="hljs-comment"># test the handler</span>
non_holiday_pred=my_handler(non_holiday_payload)
holiday_pred=my_handler(holiday_payload)

<span class="hljs-comment"># show results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;non_holiday_pred&quot;</span>, non_holiday_pred)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;holiday_pred&quot;</span>, holiday_pred)

<span class="hljs-comment"># non_holiday_pred [{&#x27;label&#x27;: &#x27;joy&#x27;, &#x27;score&#x27;: 0.9985942244529724}]</span>
<span class="hljs-comment"># holiday_pred [{&#x27;label&#x27;: &#x27;happy&#x27;, &#x27;score&#x27;: 1}]</span>`,wrap:!1}}),ne=new T({props:{title:"5. Push the Custom Handler to your repository",local:"5-push-the-custom-handler-to-your-repository",headingTag:"h3"}}),ie=new u({props:{code:"JTIzJTIwYWRkJTIwYWxsJTIwb3VyJTIwbmV3JTIwZmlsZXMlMEEhZ2l0JTIwYWRkJTIwKiUwQSUyMyUyMGNvbW1pdCUyMG91ciUyMGZpbGVzJTBBIWdpdCUyMGNvbW1pdCUyMC1tJTIwJTIyYWRkJTIwY3VzdG9tJTIwaGFuZGxlciUyMiUwQSUyMyUyMHB1c2glMjB0aGUlMjBmaWxlcyUyMHRvJTIwdGhlJTIwaHViJTBBIWdpdCUyMHB1c2g=",highlighted:`# <span class="hljs-built_in">add</span> <span class="hljs-keyword">all</span> our <span class="hljs-keyword">new</span> <span class="hljs-keyword">files</span>
!git <span class="hljs-built_in">add</span> *
# commit our <span class="hljs-keyword">files</span>
!git commit -<span class="hljs-keyword">m</span> <span class="hljs-string">&quot;add custom handler&quot;</span>
# push the <span class="hljs-keyword">files</span> <span class="hljs-keyword">to</span> the hub
!git push`,wrap:!1}}),pe=new T({props:{title:"6. Deploy your Custom Handler as an Inference Endpoint",local:"6-deploy-your-custom-handler-as-an-inference-endpoint",headingTag:"h3"}}),he=new T({props:{title:"Examples",local:"examples",headingTag:"h2"}}),Me=new rl({props:{source:"https://github.com/huggingface/hf-endpoints-documentation/blob/main/docs/source/engines/toolkit.mdx"}}),{c(){M=i("meta"),Je=n(),ue=i("p"),fe=n(),d(m.$$.fragment),Ie=n(),J=i("p"),J.textContent=Ut,Ue=n(),f=i("p"),f.textContent=jt,je=n(),d(I.$$.fragment),be=n(),U=i("p"),U.innerHTML=bt,ge=n(),j=i("p"),j.innerHTML=gt,Ce=n(),b=i("p"),b.innerHTML=Ct,Be=n(),d(g.$$.fragment),Ge=n(),C=i("p"),C.innerHTML=Bt,$e=n(),B=i("p"),B.innerHTML=Gt,ve=n(),G=i("p"),G.innerHTML=$t,ke=n(),$=i("p"),$.innerHTML=vt,_e=n(),d(v.$$.fragment),He=n(),k=i("p"),k.innerHTML=kt,xe=n(),d(_.$$.fragment),Ze=n(),H=i("p"),H.textContent=_t,Ee=n(),x=i("p"),x.innerHTML=Ht,We=n(),d(Z.$$.fragment),Re=n(),E=i("p"),E.innerHTML=xt,Ne=n(),W=i("p"),W.innerHTML=Zt,Se=n(),d(R.$$.fragment),ze=n(),d(N.$$.fragment),Ae=n(),S=i("p"),S.innerHTML=Et,Qe=n(),z=i("ul"),z.innerHTML=Wt,Ye=n(),A=i("p"),A.innerHTML=Rt,Le=n(),d(Q.$$.fragment),Ve=n(),Y=i("p"),Y.innerHTML=Nt,Xe=n(),d(L.$$.fragment),qe=n(),d(V.$$.fragment),Fe=n(),X=i("p"),X.innerHTML=St,Pe=n(),q=i("p"),q.innerHTML=zt,De=n(),F=i("p"),F.innerHTML=At,Ke=n(),d(P.$$.fragment),Oe=n(),D=i("p"),D.innerHTML=Qt,et=n(),d(K.$$.fragment),tt=n(),d(O.$$.fragment),lt=n(),ee=i("p"),ee.textContent=Yt,st=n(),d(te.$$.fragment),nt=n(),le=i("p"),le.textContent=Lt,at=n(),se=i("p"),se.innerHTML=Vt,it=n(),d(ne.$$.fragment),ot=n(),ae=i("p"),ae.textContent=Xt,pt=n(),d(ie.$$.fragment),dt=n(),oe=i("p"),oe.innerHTML=qt,rt=n(),d(pe.$$.fragment),yt=n(),de=i("p"),de.textContent=Ft,ht=n(),re=i("p"),re.innerHTML=Pt,ct=n(),ye=i("p"),ye.innerHTML=Dt,wt=n(),d(he.$$.fragment),Tt=n(),ce=i("p"),ce.innerHTML=Kt,Mt=n(),we=i("p"),we.textContent=Ot,ut=n(),Te=i("ul"),Te.innerHTML=el,mt=n(),d(Me.$$.fragment),Jt=n(),me=i("p"),this.h()},l(e){const t=pl("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(l),Je=a(e),ue=o(e,"P",{}),tl(ue).forEach(l),fe=a(e),r(m.$$.fragment,e),Ie=a(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-onimv6"&&(J.textContent=Ut),Ue=a(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1x03yvk"&&(f.textContent=jt),je=a(e),r(I.$$.fragment,e),be=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1cuhii1"&&(U.innerHTML=bt),ge=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-ek3q7r"&&(j.innerHTML=gt),Ce=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1v0h8dt"&&(b.innerHTML=Ct),Be=a(e),r(g.$$.fragment,e),Ge=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-x923ye"&&(C.innerHTML=Bt),$e=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-qyh9p3"&&(B.innerHTML=Gt),ve=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-xuocio"&&(G.innerHTML=$t),ke=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-16in619"&&($.innerHTML=vt),_e=a(e),r(v.$$.fragment,e),He=a(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-bzdaav"&&(k.innerHTML=kt),xe=a(e),r(_.$$.fragment,e),Ze=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-12klzx5"&&(H.textContent=_t),Ee=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-68hofi"&&(x.innerHTML=Ht),We=a(e),r(Z.$$.fragment,e),Re=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-54lmtl"&&(E.innerHTML=xt),Ne=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-k22wa5"&&(W.innerHTML=Zt),Se=a(e),r(R.$$.fragment,e),ze=a(e),r(N.$$.fragment,e),Ae=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1b0qtu9"&&(S.innerHTML=Et),Qe=a(e),z=o(e,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-1bfhmae"&&(z.innerHTML=Wt),Ye=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1xwwutb"&&(A.innerHTML=Rt),Le=a(e),r(Q.$$.fragment,e),Ve=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-16cpa65"&&(Y.innerHTML=Nt),Xe=a(e),r(L.$$.fragment,e),qe=a(e),r(V.$$.fragment,e),Fe=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-174kzrx"&&(X.innerHTML=St),Pe=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-10cxuyb"&&(q.innerHTML=zt),De=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1wywlb7"&&(F.innerHTML=At),Ke=a(e),r(P.$$.fragment,e),Oe=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1s8qwlb"&&(D.innerHTML=Qt),et=a(e),r(K.$$.fragment,e),tt=a(e),r(O.$$.fragment,e),lt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-4es9m7"&&(ee.textContent=Yt),st=a(e),r(te.$$.fragment,e),nt=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-vtyfqm"&&(le.textContent=Lt),at=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-xvallb"&&(se.innerHTML=Vt),it=a(e),r(ne.$$.fragment,e),ot=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1ii6eax"&&(ae.textContent=Xt),pt=a(e),r(ie.$$.fragment,e),dt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1u44z0y"&&(oe.innerHTML=qt),rt=a(e),r(pe.$$.fragment,e),yt=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-zm7hu6"&&(de.textContent=Ft),ht=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1bd3erx"&&(re.innerHTML=Pt),ct=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1riwy1z"&&(ye.innerHTML=Dt),wt=a(e),r(he.$$.fragment,e),Tt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1vi1jdr"&&(ce.innerHTML=Kt),Mt=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-18t9mwx"&&(we.textContent=Ot),ut=a(e),Te=o(e,"UL",{"data-svelte-h":!0}),p(Te)!=="svelte-hgiuvk"&&(Te.innerHTML=el),mt=a(e),r(Me.$$.fragment,e),Jt=a(e),me=o(e,"P",{}),tl(me).forEach(l),this.h()},h(){ll(M,"name","hf:doc:metadata"),ll(M,"content",hl)},m(e,t){dl(document.head,M),s(e,Je,t),s(e,ue,t),s(e,fe,t),y(m,e,t),s(e,Ie,t),s(e,J,t),s(e,Ue,t),s(e,f,t),s(e,je,t),y(I,e,t),s(e,be,t),s(e,U,t),s(e,ge,t),s(e,j,t),s(e,Ce,t),s(e,b,t),s(e,Be,t),y(g,e,t),s(e,Ge,t),s(e,C,t),s(e,$e,t),s(e,B,t),s(e,ve,t),s(e,G,t),s(e,ke,t),s(e,$,t),s(e,_e,t),y(v,e,t),s(e,He,t),s(e,k,t),s(e,xe,t),y(_,e,t),s(e,Ze,t),s(e,H,t),s(e,Ee,t),s(e,x,t),s(e,We,t),y(Z,e,t),s(e,Re,t),s(e,E,t),s(e,Ne,t),s(e,W,t),s(e,Se,t),y(R,e,t),s(e,ze,t),y(N,e,t),s(e,Ae,t),s(e,S,t),s(e,Qe,t),s(e,z,t),s(e,Ye,t),s(e,A,t),s(e,Le,t),y(Q,e,t),s(e,Ve,t),s(e,Y,t),s(e,Xe,t),y(L,e,t),s(e,qe,t),y(V,e,t),s(e,Fe,t),s(e,X,t),s(e,Pe,t),s(e,q,t),s(e,De,t),s(e,F,t),s(e,Ke,t),y(P,e,t),s(e,Oe,t),s(e,D,t),s(e,et,t),y(K,e,t),s(e,tt,t),y(O,e,t),s(e,lt,t),s(e,ee,t),s(e,st,t),y(te,e,t),s(e,nt,t),s(e,le,t),s(e,at,t),s(e,se,t),s(e,it,t),y(ne,e,t),s(e,ot,t),s(e,ae,t),s(e,pt,t),y(ie,e,t),s(e,dt,t),s(e,oe,t),s(e,rt,t),y(pe,e,t),s(e,yt,t),s(e,de,t),s(e,ht,t),s(e,re,t),s(e,ct,t),s(e,ye,t),s(e,wt,t),y(he,e,t),s(e,Tt,t),s(e,ce,t),s(e,Mt,t),s(e,we,t),s(e,ut,t),s(e,Te,t),s(e,mt,t),y(Me,e,t),s(e,Jt,t),s(e,me,t),ft=!0},p:nl,i(e){ft||(h(m.$$.fragment,e),h(I.$$.fragment,e),h(g.$$.fragment,e),h(v.$$.fragment,e),h(_.$$.fragment,e),h(Z.$$.fragment,e),h(R.$$.fragment,e),h(N.$$.fragment,e),h(Q.$$.fragment,e),h(L.$$.fragment,e),h(V.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(Me.$$.fragment,e),ft=!0)},o(e){c(m.$$.fragment,e),c(I.$$.fragment,e),c(g.$$.fragment,e),c(v.$$.fragment,e),c(_.$$.fragment,e),c(Z.$$.fragment,e),c(R.$$.fragment,e),c(N.$$.fragment,e),c(Q.$$.fragment,e),c(L.$$.fragment,e),c(V.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(he.$$.fragment,e),c(Me.$$.fragment,e),ft=!1},d(e){e&&(l(Je),l(ue),l(fe),l(Ie),l(J),l(Ue),l(f),l(je),l(be),l(U),l(ge),l(j),l(Ce),l(b),l(Be),l(Ge),l(C),l($e),l(B),l(ve),l(G),l(ke),l($),l(_e),l(He),l(k),l(xe),l(Ze),l(H),l(Ee),l(x),l(We),l(Re),l(E),l(Ne),l(W),l(Se),l(ze),l(Ae),l(S),l(Qe),l(z),l(Ye),l(A),l(Le),l(Ve),l(Y),l(Xe),l(qe),l(Fe),l(X),l(Pe),l(q),l(De),l(F),l(Ke),l(Oe),l(D),l(et),l(tt),l(lt),l(ee),l(st),l(nt),l(le),l(at),l(se),l(it),l(ot),l(ae),l(pt),l(dt),l(oe),l(rt),l(yt),l(de),l(ht),l(re),l(ct),l(ye),l(wt),l(Tt),l(ce),l(Mt),l(we),l(ut),l(Te),l(mt),l(Jt),l(me)),l(M),w(m,e),w(I,e),w(g,e),w(v,e),w(_,e),w(Z,e),w(R,e),w(N,e),w(Q,e),w(L,e),w(V,e),w(P,e),w(K,e),w(O,e),w(te,e),w(ne,e),w(ie,e),w(pe,e),w(he,e),w(Me,e)}}}const hl='{"title":"Inference Toolkit","local":"inference-toolkit","sections":[],"depth":1}';function cl(It){return al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ml extends il{constructor(M){super(),ol(this,M,cl,yl,sl,{})}}export{ml as component};
