import{s as yn,o as Jn,n as jn}from"../chunks/scheduler.f7e1785c.js";import{S as mn,i as cn,g as p,s as a,r as U,A as wn,h as M,f as t,c as n,j as Un,u as i,x as T,k as Ps,y as rn,a as s,v as y,d as J,t as j,w as m}from"../chunks/index.9f8f0838.js";import{T as un}from"../chunks/Tip.4575d9cf.js";import{C as c}from"../chunks/CodeBlock.4baef5d7.js";import{H as u,E as hn}from"../chunks/getInferenceSnippets.ba5f4cd0.js";function fn(We){let w,o="在我们的示例中，我们将使用大约 40 小时的训练数据。如果您想使用 Google Colab 免费版的 GPU 复现，需要将训练数据量减少到大约 10-15 小时，并减少训练步骤的数量。";return{c(){w=p("p"),w.textContent=o},l(r){w=M(r,"P",{"data-svelte-h":!0}),T(w)!=="svelte-az1j4w"&&(w.textContent=o)},m(r,Ve){s(r,w,Ve)},p:jn,d(r){r&&t(w)}}}function dn(We){let w,o,r,Ve,C,Be,b,Ks="现在您已经熟悉了语音合成任务和 SpeechT5 模型的内部工作原理，该模型是在英语数据上预训练的，让我们看看如何将其微调到另一种语言。",Ge,$,Ye,I,la="如果您想复现这个示例，请确保您有一个 GPU。在笔记本中，您可以使用以下命令检查：",ve,k,Xe,h,Ee,Z,ea="您还需要一些额外的依赖：",Ne,Q,ze,g,ta="最后，不要忘记登录您的 Hugging Face 账户，以便您能够上传并与社区共享您的模型：",Fe,x,He,R,Se,A,sa=`在这个示例中，我们将使用 <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> 数据集的荷兰语（<code>nl</code>）子集。
<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> 是一个大规模的多语言语音语料库，包含了 2009-2020 年欧洲议会事件的录音数据。
它包含 15 种欧洲语言的带标签的音频-转写数据。虽然我们将使用荷兰语子集，但您可以自由选择其他子集。`,qe,V,aa="这是一个语音识别（ASR）数据集，所以，如前所述，它不是训练 TTS 模型的最佳选择。然而，对于这个练习来说，它已经足够好了。",De,_,na="让我们加载数据：",Oe,W,Le,B,pa="<strong>输出：</strong>",Pe,G,Ke,Y,Ma="20968 条数据应该足以进行微调。输入 SpeechT5 的音频数据应具有 16 kHz 的采样率，所以要确保我们的数据集满足这一要求：",lt,v,et,X,tt,E,Ta="处理器包含了分词器和特征提取器，我们需要用它们来预处理训练数据。所以我们先定义要使用的模型检查点，并加载对应的处理器：",st,N,at,z,nt,F,Ua="首先，为了处理文本，我们需要处理器的分词器部分，所以让我们来获取它：",pt,H,Mt,S,ia="让我们看一个示例：",Tt,q,Ut,D,ya="<strong>输出：</strong>",it,O,yt,L,Ja=`您可能会注意到数据包含 <code>raw_text</code> 和 <code>normalized_text</code> 特征。在决定使用哪个特征作为文本输入时，需要注意的是 SpeechT5 分词器没有任何数字的词元。
在 <code>normalized_text</code> 中，数字被写成文本。因此，它更合适，我们应该使用 <code>normalized_text</code> 作为输入文本。`,Jt,P,ja=`因为 SpeechT5 是在英语上训练的，它可能无法识别荷兰语数据集中的某些字符。如果保持原样，这些字符将被转换为 <code>&lt;unk&gt;</code> 词元。
然而，在荷兰语中，某些字符如 <code>à</code> 用于强调音节。为了保留文本的含义，我们可以将此字符替换为普通的 <code>a</code>。`,jt,K,ma=`要识别不支持的词元，使用 <code>SpeechT5Tokenizer</code> 提取数据集中所有独特字符，该分词器将字符视为词元。为此，我们将编写 <code>extract_all_chars</code> 映射函数，
该函数将所有数据样例的转写连接成一个字符串，然后转换为字符集。确保在 <code>dataset.map()</code> 中设置 <code>batched=True</code> 和 <code>batch_size=-1</code>，以便一次性获取所有转写并输入映射函数。`,mt,ll,ct,el,ca="现在您有两组字符：一个来自数据集，另一个来自分词器。要识别数据集中任何不支持的字符，您可以取这两组的差集，结果将包含在数据集中而不在分词器中的字符。",wt,tl,rt,sl,wa="<strong>输出：</strong>",ut,al,ht,nl,ra="为了处理上一步骤中识别的不支持字符，我们可以定义一个将这些字符映射到有效词元的函数。注意，分词器中的空格已经被替换为 <code>▁</code>，因此不需要单独处理。",ft,pl,dt,Ml,ua="现在我们处理好了文本中的特殊字符，是时候将注意力转移到音频数据上了。",ot,Tl,Ct,Ul,ha=`VoxPopuli 数据集包含多个说话人的语音，但到底有多少呢？我们可以计算一下数据集中说话人的数量以及每个说话人贡献的数据量。
数据集总共有 20,968 条数据，这些信息将帮助我们更好地了解数据中的说话人和数据样例的分布。`,bt,il,$t,yl,fa="通过绘制直方图，您可以了解每个说话人的数据量。",It,Jl,kt,f,da='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',Zt,jl,oa="直方图显示，数据集中大约三分之一的说话人的数据少于 100 条，而大约十个说话人的数据超过 500 条。为了提高训练效率并平衡数据集，我们可以将数据限制在有 100 到 400 条数据的说话人之间。",Qt,ml,gt,cl,Ca="让我们检查还剩多少个说话人：",xt,wl,Rt,rl,ba="<strong>输出：</strong>",At,ul,Vt,hl,$a="让我们看看还剩多少条数据：",_t,fl,Wt,dl,Ia="<strong>输出：</strong>",Bt,ol,Gt,Cl,ka="您留下了不到 10,000 条数据，来自大约 40 个独特的说话人，这应该足够用了。",Yt,bl,Za=`请注意，如果某些数据很长，一些看似数据样例量较少的说话人可能有比预想的更多的音频数据。然而，确定每个说话人的总音频量需要扫描整个数据集，
这是一个耗时的过程，涉及加载和解码每个音频文件。因此，我们在这里选择跳过这一步。`,vt,$l,Xt,Il,Qa=`为了使 TTS 模型能够区分多个说话人，您需要为每条数据创建一个说话人嵌入。说话人嵌入是模型的一个额外输入，用于描述特定说话人的声音特征。
要生成这些说话人嵌入，可以使用来自 SpeechBrain 的预训练模型 <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>。`,Et,kl,ga="创建一个 <code>create_speaker_embedding()</code> 函数，该函数接受音频波形作为输入，并输出包含相应说话人嵌入的 512 维向量。",Nt,Zl,zt,Ql,xa=`注意，<code>speechbrain/spkrec-xvect-voxceleb</code> 模型是在 VoxCeleb 数据集的英语语音上训练的，而这个示例训练的是荷兰语。
虽然我们相信这个模型仍然可以为我们的荷兰语数据集生成合理的说话人嵌入，但这个假设可能不总是成立。`,Ft,gl,Ra=`为了获得最佳结果，我们需要首先在目标语音上训练 X-Vector 模型。这将确保模型能够更好地捕捉荷兰语中存在的独特声音特征。如果您想训练自己的 X-向量模型，
可以参考 <a href="https://huggingface.co/mechanicalsea/speecht5-vc/blob/main/manifest/utils/prep_cmu_arctic_spkemb.py" rel="nofollow">此脚本</a>。`,Ht,xl,St,Rl,Aa="最后，让我们将数据处理成模型能够读入的格式。创建一个 <code>prepare_dataset</code> 函数，输入单个示例并使用 <code>SpeechT5Processor</code> 对象来对输入文本进行分词，并将目标音频加载成对数梅尔谱。它还应该额外输入说话人嵌入。",qt,Al,Dt,Vl,Va="查看单个示例来验证处理是否正确：",Ot,_l,Lt,Wl,_a="<strong>输出：</strong>",Pt,Bl,Kt,Gl,Wa="说话人嵌入应该是一个 512 维向量：",ls,Yl,es,vl,Ba="<strong>输出：</strong>",ts,Xl,ss,El,Ga="标签应该是一个有 80 个 mel 频段的对数梅尔谱。",as,Nl,ns,d,Ya='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',ps,zl,va="注：如果您看不明白这个频谱图，可能是因为您习惯将低频放在底部，高频放在顶部。然而，在使用 matplotlib 库将频谱图作为图像绘制时，y 轴是反过来的，频谱图看起来是倒置的。",Ms,Fl,Xa="现在我们需要将处理函数应用于整个数据集。这将花费 5 到 10 分钟的时间。",Ts,Hl,Us,Sl,Ea="您会看到一个警告说数据集中的某些数据长于模型能够处理的最大输入长度（600 词元），得从数据集中删除这些数据。在这里，我们更进一步，为了允许更大的批量大小，删除任何超过 200 词元的内容。",is,ql,ys,Dl,Na="<strong>输出：</strong>",Js,Ol,js,Ll,za="接下来，把数据集分成基本的训练/测试子集：",ms,Pl,cs,Kl,ws,le,Fa=`为了将多条数据组合成一个批次，您需要定义一个自定义数据整理器。这个整理器将使用填充词元填充较短的序列，确保所有示例都具有相同的长度。
对于频谱图标签，填充部分将被特殊值 <code>-100</code> 替换。这个特殊值指示模型在计算频谱图的损失函数时忽略那部分频谱图。`,rs,ee,us,te,Ha=`在 SpeechT5 中，模型的解码器部分的输入减少了 2 倍（reduction factor）。换句话说，它抛弃了目标序列中每两步中的一步。然后，解码器预测一个两倍长度的序列。
由于原来的目标序列长度可能是奇数，数据整理器会确保将批次的最大长度调整为 2 的倍数。`,hs,se,fs,ae,ds,ne,Sa="从与处理器相同的检查点加载预训练模型：",os,pe,Cs,Me,qa="<code>use_cache=True</code> 选项与梯度检查点不兼容。我们在训练时禁用这个选项，并在生成时重新启用缓存以加快推理：",bs,Te,$s,Ue,Da="定义训练参数。这里我们在训练过程中不计算任何评估指标，我们将在本章稍后讨论评估。这里，我们先只关注损失函数：",Is,ie,ks,ye,Oa="实例化 <code>Trainer</code> 对象并将模型、数据集和数据整理器传递给它。",Zs,Je,Qs,je,La="有了这个，我们就准备开始训练了！训练将花费几个小时。由于 GPU 不同，当您开始训练时，可能会遇到 CUDA 报“out-of-memory”（显存不足）的错误。这时，您可以尝试将 <code>per_device_train_batch_size</code> 两倍两倍地减少，并将 <code>gradient_accumulation_steps</code> 增加到两倍以补偿。",gs,me,xs,ce,Pa="将最终的模型上传到 🤗 Hub：",Rs,we,As,re,Vs,ue,Ka="一旦您微调了一个模型，您就可以使用它进行推理！从 🤗 Hub 加载模型（记得在以下代码片段中使用您的账号名）：",_s,he,Ws,fe,ln="选择一个示例，这里我们将从测试数据集中取一个。获取说话人嵌入。",Bs,de,Gs,oe,en="定义一些输入文本并对它进行分词。",Ys,Ce,vs,be,tn="预处理输入文本：",Xs,$e,Es,Ie,sn="实例化一个声码器并生成语音：",Ns,ke,zs,Ze,an="准备好听结果了吗？",Fs,Qe,Hs,ge,nn="用这个模型在新语言上获得的满意结果可能很有挑战性。说话人嵌入的质量可能是一个重要因素。由于 SpeechT5 是使用英语 X-Vector 预训练的，它在使用英语说话人嵌入时表现最佳。如果合成的语音听起来效果不好，尝试使用不同的说话人嵌入。",Ss,xe,pn="增加训练时长也可能提高结果的质量。但即便不继续训练，语音也显然是荷兰语而不是英语，并且它确实学到了说话人的声音特征（与示例中的原始音频相比较）。另一个可以试验的是模型的配置。例如，尝试使用 <code>config.reduction_factor = 1</code> 来看是否能改善结果。",qs,Re,Mn="在下一节中，我们将讨论如何评估语音合成模型。",Ds,Ae,Os,_e,Ls;return C=new u({props:{title:"微调 SpeechT5",local:"微调-speecht5",headingTag:"h1"}}),$=new u({props:{title:"基础准备",local:"基础准备",headingTag:"h2"}}),k=new c({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi",wrap:!1}}),h=new un({props:{warning:!0,$$slots:{default:[fn]},$$scope:{ctx:We}}}),Q=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install transformers datasets soundfile speechbrain accelerate",wrap:!1}}),x=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),R=new u({props:{title:"数据集",local:"数据集",headingTag:"h2"}}),W=new c({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),G=new c({props:{code:"MjA5Njg=",highlighted:"20968",wrap:!1}}),v=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),X=new u({props:{title:"数据预处理",local:"数据预处理",headingTag:"h2"}}),N=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),z=new u({props:{title:"为 SpeechT5 分词进行文本清理",local:"为-speecht5-分词进行文本清理",headingTag:"h3"}}),H=new c({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:"tokenizer = processor.tokenizer",wrap:!1}}),q=new c({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]',wrap:!1}}),O=new c({props:{code:"JTdCJ2F1ZGlvX2lkJyUzQSUyMCcyMDEwMDIxMC0wOTAwLVBMRU5BUlktMy1ubF8yMDEwMDIxMC0wOSUzQTA2JTNBNDNfNCclMkMlMEElMjAnbGFuZ3VhZ2UnJTNBJTIwOSUyQyUwQSUyMCdhdWRpbyclM0ElMjAlN0IncGF0aCclM0ElMjAnJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZkb3dubG9hZHMlMkZleHRyYWN0ZWQlMkYwMmVjNmExOWQ1Yjk3YzAzZTEzNzkyNTAzNzg0NTRkYmYzZmEyOTcyOTQzNTA0YTkxYzdkYTUwNDVhYTI2YTg5JTJGdHJhaW5fcGFydF8wJTJGMjAxMDAyMTAtMDkwMC1QTEVOQVJZLTMtbmxfMjAxMDAyMTAtMDklM0EwNiUzQTQzXzQud2F2JyUyQyUwQSUyMCUyMCdhcnJheSclM0ElMjBhcnJheSglNUIlMjA0LjI3MjQ2MDk0ZS0wNCUyQyUyMCUyMDEuMzEyMjU1ODZlLTAzJTJDJTIwJTIwMS4wMzc1OTc2NmUtMDMlMkMlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtOS4xNTUyNzM0NGUtMDUlMkMlMjAlMjA3LjYyOTM5NDUzZS0wNCUyQyUyMC0yLjQ0MTQwNjI1ZS0wNCU1RCklMkMlMEElMjAlMjAnc2FtcGxpbmdfcmF0ZSclM0ElMjAxNjAwMCU3RCUyQyUwQSUyMCdyYXdfdGV4dCclM0ElMjAnRGF0JTIwa2FuJTIwbmFhciUyMG1pam4lMjBnZXZvZWwlMjBhbGxlZW4lMjBtZXQlMjBlZW4lMjBicmVkZSUyMG1lZXJkZXJoZWlkJTIwZGllJTIwd2lqJTIwc2FtZW4lMjB6b2VrZW4uJyUyQyUwQSUyMCdub3JtYWxpemVkX3RleHQnJTNBJTIwJ2RhdCUyMGthbiUyMG5hYXIlMjBtaWpuJTIwZ2V2b2VsJTIwYWxsZWVuJTIwbWV0JTIwZWVuJTIwYnJlZGUlMjBtZWVyZGVyaGVpZCUyMGRpZSUyMHdpaiUyMHNhbWVuJTIwem9la2VuLiclMkMlMEElMjAnZ2VuZGVyJyUzQSUyMCdmZW1hbGUnJTJDJTBBJTIwJ3NwZWFrZXJfaWQnJTNBJTIwJzExMjInJTJDJTBBJTIwJ2lzX2dvbGRfdHJhbnNjcmlwdCclM0ElMjBUcnVlJTJDJTBBJTIwJ2FjY2VudCclM0ElMjAnTm9uZSclN0Q=",highlighted:`{&#x27;audio_id&#x27;: &#x27;<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4&#x27;,
 &#x27;language&#x27;: <span class="hljs-number">9</span>,
 &#x27;audio&#x27;: {&#x27;path&#x27;: &#x27;/root/.cache/huggingface/datasets/downloads/extracted/02ec6a19d5b97c03e<span class="hljs-number">137925037845</span>4dbf3fa<span class="hljs-number">2972943504</span>a91c7da<span class="hljs-number">5045</span>aa26a89/train_part_0/<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4.wav&#x27;,
  &#x27;array&#x27;: array([ <span class="hljs-number">4.27246094</span>e-<span class="hljs-number">04</span>,  <span class="hljs-number">1.31225586</span>e-<span class="hljs-number">03</span>,  <span class="hljs-number">1.03759766</span>e-<span class="hljs-number">03</span>, ...,
         -<span class="hljs-number">9.15527344</span>e-<span class="hljs-number">05</span>,  <span class="hljs-number">7.62939453</span>e-<span class="hljs-number">04</span>, -<span class="hljs-number">2.44140625</span>e-<span class="hljs-number">04</span>]),
  &#x27;sampling_rate&#x27;: <span class="hljs-number">16000</span>},
 &#x27;raw_text&#x27;: &#x27;Dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;normalized_text&#x27;: &#x27;dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;gender&#x27;: &#x27;female&#x27;,
 &#x27;speaker_id&#x27;: &#x27;<span class="hljs-number">1122</span>&#x27;,
 &#x27;is_gold_transcript&#x27;: True,
 &#x27;accent&#x27;: &#x27;None&#x27;}`,wrap:!1}}),ll=new c({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


vocabs = dataset.<span class="hljs-built_in">map</span>(
    extract_all_chars,
    batched=<span class="hljs-literal">True</span>,
    batch_size=-<span class="hljs-number">1</span>,
    keep_in_memory=<span class="hljs-literal">True</span>,
    remove_columns=dataset.column_names,
)

dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),tl=new c({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:"dataset_vocab - tokenizer_vocab",wrap:!1}}),al=new c({props:{code:"JTdCJyUyMCclMkMlMjAnJUMzJUEwJyUyQyUyMCclQzMlQTcnJTJDJTIwJyVDMyVBOCclMkMlMjAnJUMzJUFCJyUyQyUyMCclQzMlQUQnJTJDJTIwJyVDMyVBRiclMkMlMjAnJUMzJUI2JyUyQyUyMCclQzMlQkMnJTdE",highlighted:"{&#x27; &#x27;, &#x27;à&#x27;, &#x27;ç&#x27;, &#x27;è&#x27;, &#x27;ë&#x27;, &#x27;í&#x27;, &#x27;ï&#x27;, &#x27;ö&#x27;, &#x27;ü&#x27;}",wrap:!1}}),pl=new c({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`replacements = [
    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
    <span class="hljs-keyword">return</span> inputs


dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),Tl=new u({props:{title:"说话人",local:"说话人",headingTag:"h3"}}),il=new c({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),Jl=new c({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
plt.show()`,wrap:!1}}),ml=new c({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),wl=new c({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:'<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))',wrap:!1}}),ul=new c({props:{code:"NDI=",highlighted:"42",wrap:!1}}),fl=new c({props:{code:"bGVuKGRhdGFzZXQp",highlighted:'<span class="hljs-built_in">len</span>(dataset)',wrap:!1}}),ol=new c({props:{code:"OTk3Mw==",highlighted:'<span class="hljs-number">9973</span>',wrap:!1}}),$l=new u({props:{title:"说话人嵌入",local:"说话人嵌入",headingTag:"h3"}}),Zl=new c({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
speaker_model = EncoderClassifier.from_hparams(
    source=spk_model_name,
    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),xl=new u({props:{title:"处理数据集",local:"处理数据集",headingTag:"h3"}}),Al=new c({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTUlOEUlQkIlRTYlOEUlODklRTYlODklQjklRTklODclOEYlRTUlQTQlODQlRTclOTAlODYlRTclOUElODQlRTclQkIlQjQlRTUlQkElQTYlMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCU1QjAlNUQlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTclOTQlQTglMjBTcGVlY2hCcmFpbiUyMCVFOCU4RSVCNyVFNSU4RiU5NiUyMFgtVmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        return_attention_mask=<span class="hljs-literal">False</span>,
    )

    <span class="hljs-comment"># 去掉批量处理的维度</span>
    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-comment"># 用 SpeechBrain 获取 X-Vector</span>
    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),_l=new c({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-built_in">list</span>(processed_example.keys())`,wrap:!1}}),Bl=new c({props:{code:"JTVCJ2lucHV0X2lkcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdG9wX2xhYmVscyclMkMlMjAnc3BlYWtlcl9lbWJlZGRpbmdzJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;input_ids</span>&#x27;, <span class="hljs-symbol">&#x27;labels</span>&#x27;, <span class="hljs-symbol">&#x27;stop_labels</span>&#x27;, <span class="hljs-symbol">&#x27;speaker_embeddings</span>&#x27;]',wrap:!1}}),Yl=new c({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:'processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape',wrap:!1}}),Xl=new c({props:{code:"KDUxMiUyQyk=",highlighted:'(<span class="hljs-number">512</span><span class="hljs-punctuation">,</span>)',wrap:!1}}),Nl=new c({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
plt.show()`,wrap:!1}}),Hl=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),ql=new c({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
    input_length = <span class="hljs-built_in">len</span>(input_ids)
    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),Ol=new c({props:{code:"ODI1OQ==",highlighted:'<span class="hljs-number">8259</span>',wrap:!1}}),Pl=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),Kl=new u({props:{title:"数据整理器",local:"数据整理器",headingTag:"h3"}}),ee=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

        <span class="hljs-comment"># 把输入数据和生成目标整合进一个批次</span>
        batch = processor.pad(
            input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        )

        <span class="hljs-comment"># 把填充词元换成 -100 来正确地忽略这一部分的损失函数</span>
        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(
            batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># 在微调时用不上，删了</span>
        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

        <span class="hljs-comment"># 把目标长度下调到 reduction factor 的整数倍</span>
        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
            target_lengths = torch.tensor(
                [<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features]
            )
            target_lengths = target_lengths.new(
                [
                    length - length % model.config.reduction_factor
                    <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths
                ]
            )
            max_length = <span class="hljs-built_in">max</span>(target_lengths)
            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

        <span class="hljs-comment"># 加上说话人嵌入</span>
        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),se=new c({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:"data_collator = TTSDataCollatorWithPadding(processor=processor)",wrap:!1}}),ae=new u({props:{title:"训练模型",local:"训练模型",headingTag:"h2"}}),pe=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),Te=new c({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjAlRTUlOUMlQTglRTglQUUlQUQlRTclQkIlODMlRTYlOTclQjYlRTclQTYlODElRTclOTQlQTglRTclQkMlOTMlRTUlQUQlOTglMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjAlRTglQUUlQkUlRTclQkQlQUUlRTglQUYlQUQlRTglQTglODAlRTUlOTIlOEMlRTQlQkIlQkIlRTUlOEElQTElRTUlODclODYlRTUlQTQlODclRTYlOEUlQTglRTclOTAlODYlRUYlQkMlOEMlRTUlQjklQjYlRTklODclOEQlRTYlOTYlQjAlRTUlOTAlQUYlRTclOTQlQTglRTclQkMlOTMlRTUlQUQlOTglMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwobW9kZWwuZ2VuZXJhdGUlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># 在训练时禁用缓存</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># 设置语言和任务准备推理，并重新启用缓存</span>
model.generate = partial(model.generate, use_cache=<span class="hljs-literal">True</span>)`,wrap:!1}}),ie=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjAlRTYlOTQlQjklRTYlODglOTAlRTYlODIlQTglRTklODAlODklRTYlOEIlQTklRTclOUElODQlRTQlQkIlOTMlRTUlQkElOTMlRTUlOTAlOEQlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3N0ZXBzJTNENTAwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENDAwMCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwcmVwb3J0X3RvJTNEJTVCJTIydGVuc29yYm9hcmQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGdyZWF0ZXJfaXNfYmV0dGVyJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># 改成您选择的仓库名</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    warmup_steps=<span class="hljs-number">500</span>,
    max_steps=<span class="hljs-number">4000</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_steps=<span class="hljs-number">1000</span>,
    eval_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Je=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor,
)`,wrap:!1}}),me=new c({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),we=new c({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),re=new u({props:{title:"推理",local:"推理",headingTag:"h2"}}),he=new c({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyJUU2JTgyJUE4JUU3JTlBJTg0JUU4JUI0JUE2JUU1JThGJUI3JTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMiUwQSk=",highlighted:`model = SpeechT5ForTextToSpeech.from_pretrained(
    <span class="hljs-string">&quot;您的账号/speecht5_finetuned_voxpopuli_nl&quot;</span>
)`,wrap:!1}}),de=new c({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),Ce=new c({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),$e=new c({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ke=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1SGlmaUdhbiUwQSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpJTBBc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMHZvY29kZXIlM0R2b2NvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5HifiGan

vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)
speech = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings, vocoder=vocoder)`,wrap:!1}}),Qe=new c({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),Ae=new hn({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/zh-CN/chapter6/fine-tuning.mdx"}}),{c(){w=p("meta"),o=a(),r=p("p"),Ve=a(),U(C.$$.fragment),Be=a(),b=p("p"),b.textContent=Ks,Ge=a(),U($.$$.fragment),Ye=a(),I=p("p"),I.textContent=la,ve=a(),U(k.$$.fragment),Xe=a(),U(h.$$.fragment),Ee=a(),Z=p("p"),Z.textContent=ea,Ne=a(),U(Q.$$.fragment),ze=a(),g=p("p"),g.textContent=ta,Fe=a(),U(x.$$.fragment),He=a(),U(R.$$.fragment),Se=a(),A=p("p"),A.innerHTML=sa,qe=a(),V=p("p"),V.textContent=aa,De=a(),_=p("p"),_.textContent=na,Oe=a(),U(W.$$.fragment),Le=a(),B=p("p"),B.innerHTML=pa,Pe=a(),U(G.$$.fragment),Ke=a(),Y=p("p"),Y.textContent=Ma,lt=a(),U(v.$$.fragment),et=a(),U(X.$$.fragment),tt=a(),E=p("p"),E.textContent=Ta,st=a(),U(N.$$.fragment),at=a(),U(z.$$.fragment),nt=a(),F=p("p"),F.textContent=Ua,pt=a(),U(H.$$.fragment),Mt=a(),S=p("p"),S.textContent=ia,Tt=a(),U(q.$$.fragment),Ut=a(),D=p("p"),D.innerHTML=ya,it=a(),U(O.$$.fragment),yt=a(),L=p("p"),L.innerHTML=Ja,Jt=a(),P=p("p"),P.innerHTML=ja,jt=a(),K=p("p"),K.innerHTML=ma,mt=a(),U(ll.$$.fragment),ct=a(),el=p("p"),el.textContent=ca,wt=a(),U(tl.$$.fragment),rt=a(),sl=p("p"),sl.innerHTML=wa,ut=a(),U(al.$$.fragment),ht=a(),nl=p("p"),nl.innerHTML=ra,ft=a(),U(pl.$$.fragment),dt=a(),Ml=p("p"),Ml.textContent=ua,ot=a(),U(Tl.$$.fragment),Ct=a(),Ul=p("p"),Ul.textContent=ha,bt=a(),U(il.$$.fragment),$t=a(),yl=p("p"),yl.textContent=fa,It=a(),U(Jl.$$.fragment),kt=a(),f=p("div"),f.innerHTML=da,Zt=a(),jl=p("p"),jl.textContent=oa,Qt=a(),U(ml.$$.fragment),gt=a(),cl=p("p"),cl.textContent=Ca,xt=a(),U(wl.$$.fragment),Rt=a(),rl=p("p"),rl.innerHTML=ba,At=a(),U(ul.$$.fragment),Vt=a(),hl=p("p"),hl.textContent=$a,_t=a(),U(fl.$$.fragment),Wt=a(),dl=p("p"),dl.innerHTML=Ia,Bt=a(),U(ol.$$.fragment),Gt=a(),Cl=p("p"),Cl.textContent=ka,Yt=a(),bl=p("p"),bl.textContent=Za,vt=a(),U($l.$$.fragment),Xt=a(),Il=p("p"),Il.innerHTML=Qa,Et=a(),kl=p("p"),kl.innerHTML=ga,Nt=a(),U(Zl.$$.fragment),zt=a(),Ql=p("p"),Ql.innerHTML=xa,Ft=a(),gl=p("p"),gl.innerHTML=Ra,Ht=a(),U(xl.$$.fragment),St=a(),Rl=p("p"),Rl.innerHTML=Aa,qt=a(),U(Al.$$.fragment),Dt=a(),Vl=p("p"),Vl.textContent=Va,Ot=a(),U(_l.$$.fragment),Lt=a(),Wl=p("p"),Wl.innerHTML=_a,Pt=a(),U(Bl.$$.fragment),Kt=a(),Gl=p("p"),Gl.textContent=Wa,ls=a(),U(Yl.$$.fragment),es=a(),vl=p("p"),vl.innerHTML=Ba,ts=a(),U(Xl.$$.fragment),ss=a(),El=p("p"),El.textContent=Ga,as=a(),U(Nl.$$.fragment),ns=a(),d=p("div"),d.innerHTML=Ya,ps=a(),zl=p("p"),zl.textContent=va,Ms=a(),Fl=p("p"),Fl.textContent=Xa,Ts=a(),U(Hl.$$.fragment),Us=a(),Sl=p("p"),Sl.textContent=Ea,is=a(),U(ql.$$.fragment),ys=a(),Dl=p("p"),Dl.innerHTML=Na,Js=a(),U(Ol.$$.fragment),js=a(),Ll=p("p"),Ll.textContent=za,ms=a(),U(Pl.$$.fragment),cs=a(),U(Kl.$$.fragment),ws=a(),le=p("p"),le.innerHTML=Fa,rs=a(),U(ee.$$.fragment),us=a(),te=p("p"),te.textContent=Ha,hs=a(),U(se.$$.fragment),fs=a(),U(ae.$$.fragment),ds=a(),ne=p("p"),ne.textContent=Sa,os=a(),U(pe.$$.fragment),Cs=a(),Me=p("p"),Me.innerHTML=qa,bs=a(),U(Te.$$.fragment),$s=a(),Ue=p("p"),Ue.textContent=Da,Is=a(),U(ie.$$.fragment),ks=a(),ye=p("p"),ye.innerHTML=Oa,Zs=a(),U(Je.$$.fragment),Qs=a(),je=p("p"),je.innerHTML=La,gs=a(),U(me.$$.fragment),xs=a(),ce=p("p"),ce.textContent=Pa,Rs=a(),U(we.$$.fragment),As=a(),U(re.$$.fragment),Vs=a(),ue=p("p"),ue.textContent=Ka,_s=a(),U(he.$$.fragment),Ws=a(),fe=p("p"),fe.textContent=ln,Bs=a(),U(de.$$.fragment),Gs=a(),oe=p("p"),oe.textContent=en,Ys=a(),U(Ce.$$.fragment),vs=a(),be=p("p"),be.textContent=tn,Xs=a(),U($e.$$.fragment),Es=a(),Ie=p("p"),Ie.textContent=sn,Ns=a(),U(ke.$$.fragment),zs=a(),Ze=p("p"),Ze.textContent=an,Fs=a(),U(Qe.$$.fragment),Hs=a(),ge=p("p"),ge.textContent=nn,Ss=a(),xe=p("p"),xe.innerHTML=pn,qs=a(),Re=p("p"),Re.textContent=Mn,Ds=a(),U(Ae.$$.fragment),Os=a(),_e=p("p"),this.h()},l(l){const e=wn("svelte-u9bgzb",document.head);w=M(e,"META",{name:!0,content:!0}),e.forEach(t),o=n(l),r=M(l,"P",{}),Un(r).forEach(t),Ve=n(l),i(C.$$.fragment,l),Be=n(l),b=M(l,"P",{"data-svelte-h":!0}),T(b)!=="svelte-1mq8wfv"&&(b.textContent=Ks),Ge=n(l),i($.$$.fragment,l),Ye=n(l),I=M(l,"P",{"data-svelte-h":!0}),T(I)!=="svelte-1e5vilx"&&(I.textContent=la),ve=n(l),i(k.$$.fragment,l),Xe=n(l),i(h.$$.fragment,l),Ee=n(l),Z=M(l,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-f18nl2"&&(Z.textContent=ea),Ne=n(l),i(Q.$$.fragment,l),ze=n(l),g=M(l,"P",{"data-svelte-h":!0}),T(g)!=="svelte-j2pd5z"&&(g.textContent=ta),Fe=n(l),i(x.$$.fragment,l),He=n(l),i(R.$$.fragment,l),Se=n(l),A=M(l,"P",{"data-svelte-h":!0}),T(A)!=="svelte-80f883"&&(A.innerHTML=sa),qe=n(l),V=M(l,"P",{"data-svelte-h":!0}),T(V)!=="svelte-1mt7w1y"&&(V.textContent=aa),De=n(l),_=M(l,"P",{"data-svelte-h":!0}),T(_)!=="svelte-1ee133t"&&(_.textContent=na),Oe=n(l),i(W.$$.fragment,l),Le=n(l),B=M(l,"P",{"data-svelte-h":!0}),T(B)!=="svelte-1yevus4"&&(B.innerHTML=pa),Pe=n(l),i(G.$$.fragment,l),Ke=n(l),Y=M(l,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-14mygxn"&&(Y.textContent=Ma),lt=n(l),i(v.$$.fragment,l),et=n(l),i(X.$$.fragment,l),tt=n(l),E=M(l,"P",{"data-svelte-h":!0}),T(E)!=="svelte-myc28k"&&(E.textContent=Ta),st=n(l),i(N.$$.fragment,l),at=n(l),i(z.$$.fragment,l),nt=n(l),F=M(l,"P",{"data-svelte-h":!0}),T(F)!=="svelte-1k6p6xo"&&(F.textContent=Ua),pt=n(l),i(H.$$.fragment,l),Mt=n(l),S=M(l,"P",{"data-svelte-h":!0}),T(S)!=="svelte-o1gog8"&&(S.textContent=ia),Tt=n(l),i(q.$$.fragment,l),Ut=n(l),D=M(l,"P",{"data-svelte-h":!0}),T(D)!=="svelte-1yevus4"&&(D.innerHTML=ya),it=n(l),i(O.$$.fragment,l),yt=n(l),L=M(l,"P",{"data-svelte-h":!0}),T(L)!=="svelte-qqgwx7"&&(L.innerHTML=Ja),Jt=n(l),P=M(l,"P",{"data-svelte-h":!0}),T(P)!=="svelte-snkesy"&&(P.innerHTML=ja),jt=n(l),K=M(l,"P",{"data-svelte-h":!0}),T(K)!=="svelte-zq9kvx"&&(K.innerHTML=ma),mt=n(l),i(ll.$$.fragment,l),ct=n(l),el=M(l,"P",{"data-svelte-h":!0}),T(el)!=="svelte-1yggo6j"&&(el.textContent=ca),wt=n(l),i(tl.$$.fragment,l),rt=n(l),sl=M(l,"P",{"data-svelte-h":!0}),T(sl)!=="svelte-1yevus4"&&(sl.innerHTML=wa),ut=n(l),i(al.$$.fragment,l),ht=n(l),nl=M(l,"P",{"data-svelte-h":!0}),T(nl)!=="svelte-18q69cr"&&(nl.innerHTML=ra),ft=n(l),i(pl.$$.fragment,l),dt=n(l),Ml=M(l,"P",{"data-svelte-h":!0}),T(Ml)!=="svelte-t46ksf"&&(Ml.textContent=ua),ot=n(l),i(Tl.$$.fragment,l),Ct=n(l),Ul=M(l,"P",{"data-svelte-h":!0}),T(Ul)!=="svelte-si6krf"&&(Ul.textContent=ha),bt=n(l),i(il.$$.fragment,l),$t=n(l),yl=M(l,"P",{"data-svelte-h":!0}),T(yl)!=="svelte-1a4y7jc"&&(yl.textContent=fa),It=n(l),i(Jl.$$.fragment,l),kt=n(l),f=M(l,"DIV",{class:!0,"data-svelte-h":!0}),T(f)!=="svelte-1uufiik"&&(f.innerHTML=da),Zt=n(l),jl=M(l,"P",{"data-svelte-h":!0}),T(jl)!=="svelte-1n2xy9x"&&(jl.textContent=oa),Qt=n(l),i(ml.$$.fragment,l),gt=n(l),cl=M(l,"P",{"data-svelte-h":!0}),T(cl)!=="svelte-w4zc6g"&&(cl.textContent=Ca),xt=n(l),i(wl.$$.fragment,l),Rt=n(l),rl=M(l,"P",{"data-svelte-h":!0}),T(rl)!=="svelte-1yevus4"&&(rl.innerHTML=ba),At=n(l),i(ul.$$.fragment,l),Vt=n(l),hl=M(l,"P",{"data-svelte-h":!0}),T(hl)!=="svelte-3ki28v"&&(hl.textContent=$a),_t=n(l),i(fl.$$.fragment,l),Wt=n(l),dl=M(l,"P",{"data-svelte-h":!0}),T(dl)!=="svelte-1yevus4"&&(dl.innerHTML=Ia),Bt=n(l),i(ol.$$.fragment,l),Gt=n(l),Cl=M(l,"P",{"data-svelte-h":!0}),T(Cl)!=="svelte-1r0ckxv"&&(Cl.textContent=ka),Yt=n(l),bl=M(l,"P",{"data-svelte-h":!0}),T(bl)!=="svelte-115y9a6"&&(bl.textContent=Za),vt=n(l),i($l.$$.fragment,l),Xt=n(l),Il=M(l,"P",{"data-svelte-h":!0}),T(Il)!=="svelte-1vb1v7p"&&(Il.innerHTML=Qa),Et=n(l),kl=M(l,"P",{"data-svelte-h":!0}),T(kl)!=="svelte-15d2tc9"&&(kl.innerHTML=ga),Nt=n(l),i(Zl.$$.fragment,l),zt=n(l),Ql=M(l,"P",{"data-svelte-h":!0}),T(Ql)!=="svelte-1ojzcke"&&(Ql.innerHTML=xa),Ft=n(l),gl=M(l,"P",{"data-svelte-h":!0}),T(gl)!=="svelte-vn616r"&&(gl.innerHTML=Ra),Ht=n(l),i(xl.$$.fragment,l),St=n(l),Rl=M(l,"P",{"data-svelte-h":!0}),T(Rl)!=="svelte-1blnag0"&&(Rl.innerHTML=Aa),qt=n(l),i(Al.$$.fragment,l),Dt=n(l),Vl=M(l,"P",{"data-svelte-h":!0}),T(Vl)!=="svelte-1nl861s"&&(Vl.textContent=Va),Ot=n(l),i(_l.$$.fragment,l),Lt=n(l),Wl=M(l,"P",{"data-svelte-h":!0}),T(Wl)!=="svelte-1yevus4"&&(Wl.innerHTML=_a),Pt=n(l),i(Bl.$$.fragment,l),Kt=n(l),Gl=M(l,"P",{"data-svelte-h":!0}),T(Gl)!=="svelte-crgj40"&&(Gl.textContent=Wa),ls=n(l),i(Yl.$$.fragment,l),es=n(l),vl=M(l,"P",{"data-svelte-h":!0}),T(vl)!=="svelte-1yevus4"&&(vl.innerHTML=Ba),ts=n(l),i(Xl.$$.fragment,l),ss=n(l),El=M(l,"P",{"data-svelte-h":!0}),T(El)!=="svelte-g6mluh"&&(El.textContent=Ga),as=n(l),i(Nl.$$.fragment,l),ns=n(l),d=M(l,"DIV",{class:!0,"data-svelte-h":!0}),T(d)!=="svelte-j4o1b8"&&(d.innerHTML=Ya),ps=n(l),zl=M(l,"P",{"data-svelte-h":!0}),T(zl)!=="svelte-82ihiz"&&(zl.textContent=va),Ms=n(l),Fl=M(l,"P",{"data-svelte-h":!0}),T(Fl)!=="svelte-61um8j"&&(Fl.textContent=Xa),Ts=n(l),i(Hl.$$.fragment,l),Us=n(l),Sl=M(l,"P",{"data-svelte-h":!0}),T(Sl)!=="svelte-19pcez9"&&(Sl.textContent=Ea),is=n(l),i(ql.$$.fragment,l),ys=n(l),Dl=M(l,"P",{"data-svelte-h":!0}),T(Dl)!=="svelte-1yevus4"&&(Dl.innerHTML=Na),Js=n(l),i(Ol.$$.fragment,l),js=n(l),Ll=M(l,"P",{"data-svelte-h":!0}),T(Ll)!=="svelte-1aub7yi"&&(Ll.textContent=za),ms=n(l),i(Pl.$$.fragment,l),cs=n(l),i(Kl.$$.fragment,l),ws=n(l),le=M(l,"P",{"data-svelte-h":!0}),T(le)!=="svelte-1ug6prq"&&(le.innerHTML=Fa),rs=n(l),i(ee.$$.fragment,l),us=n(l),te=M(l,"P",{"data-svelte-h":!0}),T(te)!=="svelte-n9sw30"&&(te.textContent=Ha),hs=n(l),i(se.$$.fragment,l),fs=n(l),i(ae.$$.fragment,l),ds=n(l),ne=M(l,"P",{"data-svelte-h":!0}),T(ne)!=="svelte-kpt5ph"&&(ne.textContent=Sa),os=n(l),i(pe.$$.fragment,l),Cs=n(l),Me=M(l,"P",{"data-svelte-h":!0}),T(Me)!=="svelte-7avbs0"&&(Me.innerHTML=qa),bs=n(l),i(Te.$$.fragment,l),$s=n(l),Ue=M(l,"P",{"data-svelte-h":!0}),T(Ue)!=="svelte-169ijvl"&&(Ue.textContent=Da),Is=n(l),i(ie.$$.fragment,l),ks=n(l),ye=M(l,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-hto4ro"&&(ye.innerHTML=Oa),Zs=n(l),i(Je.$$.fragment,l),Qs=n(l),je=M(l,"P",{"data-svelte-h":!0}),T(je)!=="svelte-4sfz1e"&&(je.innerHTML=La),gs=n(l),i(me.$$.fragment,l),xs=n(l),ce=M(l,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-w4esym"&&(ce.textContent=Pa),Rs=n(l),i(we.$$.fragment,l),As=n(l),i(re.$$.fragment,l),Vs=n(l),ue=M(l,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-ou25m7"&&(ue.textContent=Ka),_s=n(l),i(he.$$.fragment,l),Ws=n(l),fe=M(l,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-xms5tj"&&(fe.textContent=ln),Bs=n(l),i(de.$$.fragment,l),Gs=n(l),oe=M(l,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-4e57y3"&&(oe.textContent=en),Ys=n(l),i(Ce.$$.fragment,l),vs=n(l),be=M(l,"P",{"data-svelte-h":!0}),T(be)!=="svelte-b1ybtn"&&(be.textContent=tn),Xs=n(l),i($e.$$.fragment,l),Es=n(l),Ie=M(l,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-m4c265"&&(Ie.textContent=sn),Ns=n(l),i(ke.$$.fragment,l),zs=n(l),Ze=M(l,"P",{"data-svelte-h":!0}),T(Ze)!=="svelte-v08fsb"&&(Ze.textContent=an),Fs=n(l),i(Qe.$$.fragment,l),Hs=n(l),ge=M(l,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-8y01aj"&&(ge.textContent=nn),Ss=n(l),xe=M(l,"P",{"data-svelte-h":!0}),T(xe)!=="svelte-185eq6j"&&(xe.innerHTML=pn),qs=n(l),Re=M(l,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-g4ct72"&&(Re.textContent=Mn),Ds=n(l),i(Ae.$$.fragment,l),Os=n(l),_e=M(l,"P",{}),Un(_e).forEach(t),this.h()},h(){Ps(w,"name","hf:doc:metadata"),Ps(w,"content",on),Ps(f,"class","flex justify-center"),Ps(d,"class","flex justify-center")},m(l,e){rn(document.head,w),s(l,o,e),s(l,r,e),s(l,Ve,e),y(C,l,e),s(l,Be,e),s(l,b,e),s(l,Ge,e),y($,l,e),s(l,Ye,e),s(l,I,e),s(l,ve,e),y(k,l,e),s(l,Xe,e),y(h,l,e),s(l,Ee,e),s(l,Z,e),s(l,Ne,e),y(Q,l,e),s(l,ze,e),s(l,g,e),s(l,Fe,e),y(x,l,e),s(l,He,e),y(R,l,e),s(l,Se,e),s(l,A,e),s(l,qe,e),s(l,V,e),s(l,De,e),s(l,_,e),s(l,Oe,e),y(W,l,e),s(l,Le,e),s(l,B,e),s(l,Pe,e),y(G,l,e),s(l,Ke,e),s(l,Y,e),s(l,lt,e),y(v,l,e),s(l,et,e),y(X,l,e),s(l,tt,e),s(l,E,e),s(l,st,e),y(N,l,e),s(l,at,e),y(z,l,e),s(l,nt,e),s(l,F,e),s(l,pt,e),y(H,l,e),s(l,Mt,e),s(l,S,e),s(l,Tt,e),y(q,l,e),s(l,Ut,e),s(l,D,e),s(l,it,e),y(O,l,e),s(l,yt,e),s(l,L,e),s(l,Jt,e),s(l,P,e),s(l,jt,e),s(l,K,e),s(l,mt,e),y(ll,l,e),s(l,ct,e),s(l,el,e),s(l,wt,e),y(tl,l,e),s(l,rt,e),s(l,sl,e),s(l,ut,e),y(al,l,e),s(l,ht,e),s(l,nl,e),s(l,ft,e),y(pl,l,e),s(l,dt,e),s(l,Ml,e),s(l,ot,e),y(Tl,l,e),s(l,Ct,e),s(l,Ul,e),s(l,bt,e),y(il,l,e),s(l,$t,e),s(l,yl,e),s(l,It,e),y(Jl,l,e),s(l,kt,e),s(l,f,e),s(l,Zt,e),s(l,jl,e),s(l,Qt,e),y(ml,l,e),s(l,gt,e),s(l,cl,e),s(l,xt,e),y(wl,l,e),s(l,Rt,e),s(l,rl,e),s(l,At,e),y(ul,l,e),s(l,Vt,e),s(l,hl,e),s(l,_t,e),y(fl,l,e),s(l,Wt,e),s(l,dl,e),s(l,Bt,e),y(ol,l,e),s(l,Gt,e),s(l,Cl,e),s(l,Yt,e),s(l,bl,e),s(l,vt,e),y($l,l,e),s(l,Xt,e),s(l,Il,e),s(l,Et,e),s(l,kl,e),s(l,Nt,e),y(Zl,l,e),s(l,zt,e),s(l,Ql,e),s(l,Ft,e),s(l,gl,e),s(l,Ht,e),y(xl,l,e),s(l,St,e),s(l,Rl,e),s(l,qt,e),y(Al,l,e),s(l,Dt,e),s(l,Vl,e),s(l,Ot,e),y(_l,l,e),s(l,Lt,e),s(l,Wl,e),s(l,Pt,e),y(Bl,l,e),s(l,Kt,e),s(l,Gl,e),s(l,ls,e),y(Yl,l,e),s(l,es,e),s(l,vl,e),s(l,ts,e),y(Xl,l,e),s(l,ss,e),s(l,El,e),s(l,as,e),y(Nl,l,e),s(l,ns,e),s(l,d,e),s(l,ps,e),s(l,zl,e),s(l,Ms,e),s(l,Fl,e),s(l,Ts,e),y(Hl,l,e),s(l,Us,e),s(l,Sl,e),s(l,is,e),y(ql,l,e),s(l,ys,e),s(l,Dl,e),s(l,Js,e),y(Ol,l,e),s(l,js,e),s(l,Ll,e),s(l,ms,e),y(Pl,l,e),s(l,cs,e),y(Kl,l,e),s(l,ws,e),s(l,le,e),s(l,rs,e),y(ee,l,e),s(l,us,e),s(l,te,e),s(l,hs,e),y(se,l,e),s(l,fs,e),y(ae,l,e),s(l,ds,e),s(l,ne,e),s(l,os,e),y(pe,l,e),s(l,Cs,e),s(l,Me,e),s(l,bs,e),y(Te,l,e),s(l,$s,e),s(l,Ue,e),s(l,Is,e),y(ie,l,e),s(l,ks,e),s(l,ye,e),s(l,Zs,e),y(Je,l,e),s(l,Qs,e),s(l,je,e),s(l,gs,e),y(me,l,e),s(l,xs,e),s(l,ce,e),s(l,Rs,e),y(we,l,e),s(l,As,e),y(re,l,e),s(l,Vs,e),s(l,ue,e),s(l,_s,e),y(he,l,e),s(l,Ws,e),s(l,fe,e),s(l,Bs,e),y(de,l,e),s(l,Gs,e),s(l,oe,e),s(l,Ys,e),y(Ce,l,e),s(l,vs,e),s(l,be,e),s(l,Xs,e),y($e,l,e),s(l,Es,e),s(l,Ie,e),s(l,Ns,e),y(ke,l,e),s(l,zs,e),s(l,Ze,e),s(l,Fs,e),y(Qe,l,e),s(l,Hs,e),s(l,ge,e),s(l,Ss,e),s(l,xe,e),s(l,qs,e),s(l,Re,e),s(l,Ds,e),y(Ae,l,e),s(l,Os,e),s(l,_e,e),Ls=!0},p(l,[e]){const Tn={};e&2&&(Tn.$$scope={dirty:e,ctx:l}),h.$set(Tn)},i(l){Ls||(J(C.$$.fragment,l),J($.$$.fragment,l),J(k.$$.fragment,l),J(h.$$.fragment,l),J(Q.$$.fragment,l),J(x.$$.fragment,l),J(R.$$.fragment,l),J(W.$$.fragment,l),J(G.$$.fragment,l),J(v.$$.fragment,l),J(X.$$.fragment,l),J(N.$$.fragment,l),J(z.$$.fragment,l),J(H.$$.fragment,l),J(q.$$.fragment,l),J(O.$$.fragment,l),J(ll.$$.fragment,l),J(tl.$$.fragment,l),J(al.$$.fragment,l),J(pl.$$.fragment,l),J(Tl.$$.fragment,l),J(il.$$.fragment,l),J(Jl.$$.fragment,l),J(ml.$$.fragment,l),J(wl.$$.fragment,l),J(ul.$$.fragment,l),J(fl.$$.fragment,l),J(ol.$$.fragment,l),J($l.$$.fragment,l),J(Zl.$$.fragment,l),J(xl.$$.fragment,l),J(Al.$$.fragment,l),J(_l.$$.fragment,l),J(Bl.$$.fragment,l),J(Yl.$$.fragment,l),J(Xl.$$.fragment,l),J(Nl.$$.fragment,l),J(Hl.$$.fragment,l),J(ql.$$.fragment,l),J(Ol.$$.fragment,l),J(Pl.$$.fragment,l),J(Kl.$$.fragment,l),J(ee.$$.fragment,l),J(se.$$.fragment,l),J(ae.$$.fragment,l),J(pe.$$.fragment,l),J(Te.$$.fragment,l),J(ie.$$.fragment,l),J(Je.$$.fragment,l),J(me.$$.fragment,l),J(we.$$.fragment,l),J(re.$$.fragment,l),J(he.$$.fragment,l),J(de.$$.fragment,l),J(Ce.$$.fragment,l),J($e.$$.fragment,l),J(ke.$$.fragment,l),J(Qe.$$.fragment,l),J(Ae.$$.fragment,l),Ls=!0)},o(l){j(C.$$.fragment,l),j($.$$.fragment,l),j(k.$$.fragment,l),j(h.$$.fragment,l),j(Q.$$.fragment,l),j(x.$$.fragment,l),j(R.$$.fragment,l),j(W.$$.fragment,l),j(G.$$.fragment,l),j(v.$$.fragment,l),j(X.$$.fragment,l),j(N.$$.fragment,l),j(z.$$.fragment,l),j(H.$$.fragment,l),j(q.$$.fragment,l),j(O.$$.fragment,l),j(ll.$$.fragment,l),j(tl.$$.fragment,l),j(al.$$.fragment,l),j(pl.$$.fragment,l),j(Tl.$$.fragment,l),j(il.$$.fragment,l),j(Jl.$$.fragment,l),j(ml.$$.fragment,l),j(wl.$$.fragment,l),j(ul.$$.fragment,l),j(fl.$$.fragment,l),j(ol.$$.fragment,l),j($l.$$.fragment,l),j(Zl.$$.fragment,l),j(xl.$$.fragment,l),j(Al.$$.fragment,l),j(_l.$$.fragment,l),j(Bl.$$.fragment,l),j(Yl.$$.fragment,l),j(Xl.$$.fragment,l),j(Nl.$$.fragment,l),j(Hl.$$.fragment,l),j(ql.$$.fragment,l),j(Ol.$$.fragment,l),j(Pl.$$.fragment,l),j(Kl.$$.fragment,l),j(ee.$$.fragment,l),j(se.$$.fragment,l),j(ae.$$.fragment,l),j(pe.$$.fragment,l),j(Te.$$.fragment,l),j(ie.$$.fragment,l),j(Je.$$.fragment,l),j(me.$$.fragment,l),j(we.$$.fragment,l),j(re.$$.fragment,l),j(he.$$.fragment,l),j(de.$$.fragment,l),j(Ce.$$.fragment,l),j($e.$$.fragment,l),j(ke.$$.fragment,l),j(Qe.$$.fragment,l),j(Ae.$$.fragment,l),Ls=!1},d(l){l&&(t(o),t(r),t(Ve),t(Be),t(b),t(Ge),t(Ye),t(I),t(ve),t(Xe),t(Ee),t(Z),t(Ne),t(ze),t(g),t(Fe),t(He),t(Se),t(A),t(qe),t(V),t(De),t(_),t(Oe),t(Le),t(B),t(Pe),t(Ke),t(Y),t(lt),t(et),t(tt),t(E),t(st),t(at),t(nt),t(F),t(pt),t(Mt),t(S),t(Tt),t(Ut),t(D),t(it),t(yt),t(L),t(Jt),t(P),t(jt),t(K),t(mt),t(ct),t(el),t(wt),t(rt),t(sl),t(ut),t(ht),t(nl),t(ft),t(dt),t(Ml),t(ot),t(Ct),t(Ul),t(bt),t($t),t(yl),t(It),t(kt),t(f),t(Zt),t(jl),t(Qt),t(gt),t(cl),t(xt),t(Rt),t(rl),t(At),t(Vt),t(hl),t(_t),t(Wt),t(dl),t(Bt),t(Gt),t(Cl),t(Yt),t(bl),t(vt),t(Xt),t(Il),t(Et),t(kl),t(Nt),t(zt),t(Ql),t(Ft),t(gl),t(Ht),t(St),t(Rl),t(qt),t(Dt),t(Vl),t(Ot),t(Lt),t(Wl),t(Pt),t(Kt),t(Gl),t(ls),t(es),t(vl),t(ts),t(ss),t(El),t(as),t(ns),t(d),t(ps),t(zl),t(Ms),t(Fl),t(Ts),t(Us),t(Sl),t(is),t(ys),t(Dl),t(Js),t(js),t(Ll),t(ms),t(cs),t(ws),t(le),t(rs),t(us),t(te),t(hs),t(fs),t(ds),t(ne),t(os),t(Cs),t(Me),t(bs),t($s),t(Ue),t(Is),t(ks),t(ye),t(Zs),t(Qs),t(je),t(gs),t(xs),t(ce),t(Rs),t(As),t(Vs),t(ue),t(_s),t(Ws),t(fe),t(Bs),t(Gs),t(oe),t(Ys),t(vs),t(be),t(Xs),t(Es),t(Ie),t(Ns),t(zs),t(Ze),t(Fs),t(Hs),t(ge),t(Ss),t(xe),t(qs),t(Re),t(Ds),t(Os),t(_e)),t(w),m(C,l),m($,l),m(k,l),m(h,l),m(Q,l),m(x,l),m(R,l),m(W,l),m(G,l),m(v,l),m(X,l),m(N,l),m(z,l),m(H,l),m(q,l),m(O,l),m(ll,l),m(tl,l),m(al,l),m(pl,l),m(Tl,l),m(il,l),m(Jl,l),m(ml,l),m(wl,l),m(ul,l),m(fl,l),m(ol,l),m($l,l),m(Zl,l),m(xl,l),m(Al,l),m(_l,l),m(Bl,l),m(Yl,l),m(Xl,l),m(Nl,l),m(Hl,l),m(ql,l),m(Ol,l),m(Pl,l),m(Kl,l),m(ee,l),m(se,l),m(ae,l),m(pe,l),m(Te,l),m(ie,l),m(Je,l),m(me,l),m(we,l),m(re,l),m(he,l),m(de,l),m(Ce,l),m($e,l),m(ke,l),m(Qe,l),m(Ae,l)}}}const on='{"title":"微调 SpeechT5","local":"微调-speecht5","sections":[{"title":"基础准备","local":"基础准备","sections":[],"depth":2},{"title":"数据集","local":"数据集","sections":[],"depth":2},{"title":"数据预处理","local":"数据预处理","sections":[{"title":"为 SpeechT5 分词进行文本清理","local":"为-speecht5-分词进行文本清理","sections":[],"depth":3},{"title":"说话人","local":"说话人","sections":[],"depth":3},{"title":"说话人嵌入","local":"说话人嵌入","sections":[],"depth":3},{"title":"处理数据集","local":"处理数据集","sections":[],"depth":3},{"title":"数据整理器","local":"数据整理器","sections":[],"depth":3}],"depth":2},{"title":"训练模型","local":"训练模型","sections":[],"depth":2},{"title":"推理","local":"推理","sections":[],"depth":2}],"depth":1}';function Cn(We){return Jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qn extends mn{constructor(w){super(),cn(this,w,Cn,dn,yn,{})}}export{Qn as component};
