import{s as Vt,o as Yt,n as Pe}from"../chunks/scheduler.9991993c.js";import{S as Qt,i as Et,g as a,s as n,r as o,A as Ht,h as p,f as t,c as M,j as Gt,u as m,x as i,k as xt,y as zt,a as s,v as J,d as r,t as c,w as d}from"../chunks/index.7fc9a5e7.js";import{T as Se}from"../chunks/Tip.9de92fc6.js";import{C as w}from"../chunks/CodeBlock.e11cba92.js";import{H as Bl,E as Ft}from"../chunks/EditOnGithub.84ab7f0e.js";function Lt(f){let y,j="如果你的模型与库中的某个模型非常相似，你可以重用与该模型相同的配置。";return{c(){y=a("p"),y.textContent=j},l(T){y=p(T,"P",{"data-svelte-h":!0}),i(y)!=="svelte-1t5zcat"&&(y.textContent=j)},m(T,U){s(T,y,U)},p:Pe,d(T){T&&t(y)}}}function St(f){let y,j="此 API 是实验性的，未来的发布中可能会有一些轻微的不兼容更改。";return{c(){y=a("p"),y.textContent=j},l(T){y=p(T,"P",{"data-svelte-h":!0}),i(y)!=="svelte-k4mbd2"&&(y.textContent=j)},m(T,U){s(T,y,U)},p:Pe,d(T){T&&t(y)}}}function Pt(f){let y,j="如果从库中复制模型文件，你需要将文件顶部的所有相对导入替换为从 <code>transformers</code> 包中的导入。";return{c(){y=a("p"),y.innerHTML=j},l(T){y=p(T,"P",{"data-svelte-h":!0}),i(y)!=="svelte-3nrr3e"&&(y.innerHTML=j)},m(T,U){s(T,y,U)},p:Pe,d(T){T&&t(y)}}}function qt(f){let y,j,T,U,I,Rl,_,qe="🤗 Transformers 库设计得易于扩展。每个模型的代码都在仓库给定的子文件夹中，没有进行抽象，因此你可以轻松复制模型代码文件并根据需要进行调整。",vl,Z,De="如果你要编写全新的模型，从头开始可能更容易。在本教程中，我们将向你展示如何编写自定义模型及其配置，以便可以在 Transformers 中使用它；以及如何与社区共享它（及其依赖的代码），以便任何人都可以使用，即使它不在 🤗 Transformers 库中。",Xl,h,Ke='我们将以 ResNet 模型为例，通过将 <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timm 库</a> 的 ResNet 类封装到 <a href="/docs/transformers/pr_30962/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> 中来进行说明。',Gl,$,xl,A,Oe="在深入研究模型之前，让我们首先编写其配置。模型的配置是一个对象，其中包含构建模型所需的所有信息。我们将在下一节中看到，模型只能接受一个 <code>config</code> 来进行初始化，因此我们很需要使该对象尽可能完整。",Vl,g,lt="我们将采用一些我们可能想要调整的 ResNet 类的参数举例。不同的配置将为我们提供不同类型可能的 ResNet 模型。在确认其中一些参数的有效性后，我们只需存储这些参数。",Yl,k,Ql,N,et="编写自定义配置时需要记住的三个重要事项如下：",El,B,tt="<li>必须继承自 <code>PretrainedConfig</code>，</li> <li><code>PretrainedConfig</code> 的 <code>__init__</code> 方法必须接受任何 kwargs，</li> <li>这些 <code>kwargs</code> 需要传递给超类的 <code>__init__</code> 方法。</li>",Hl,W,st="继承是为了确保你获得来自 🤗 Transformers 库的所有功能，而另外两个约束源于 <code>PretrainedConfig</code> 的字段比你设置的字段多。在使用 <code>from_pretrained</code> 方法重新加载配置时，这些字段需要被你的配置接受，然后传递给超类。",zl,R,nt="为你的配置定义 <code>model_type</code>（此处为 <code>model_type=&quot;resnet&quot;</code>）不是必须的，除非你想使用自动类注册你的模型（请参阅最后一节）。",Fl,v,Mt="做完这些以后，就可以像使用库里任何其他模型配置一样，轻松地创建和保存配置。以下代码展示了如何创建并保存 resnet50d 配置：",Ll,X,Sl,G,at="这行代码将在 <code>custom-resnet</code> 文件夹内保存一个名为 <code>config.json</code> 的文件。然后，你可以使用 <code>from_pretrained</code> 方法重新加载配置：",Pl,x,ql,V,pt='你还可以使用 <a href="/docs/transformers/pr_30962/zh/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> 类的任何其他方法，例如 <a href="/docs/transformers/pr_30962/zh/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>，直接将配置上传到 Hub。',Dl,Y,Kl,Q,it="有了 ResNet 配置后，就可以继续编写模型了。实际上，我们将编写两个模型：一个模型用于从一批图像中提取隐藏特征（类似于 <code>BertModel</code>），另一个模型适用于图像分类（类似于 <code>BertForSequenceClassification</code>）。",Ol,E,yt="正如之前提到的，我们只会编写一个松散的模型包装，以使示例保持简洁。在编写此类之前，只需要建立起块类型（block types）与实际块类（block classes）之间的映射。然后，通过将所有内容传递给ResNet类，从配置中定义模型：",le,H,ee,z,ot="对用于进行图像分类的模型，我们只需更改前向方法：",te,F,se,L,mt="在这两种情况下，请注意我们如何继承 <code>PreTrainedModel</code> 并使用 <code>config</code> 调用了超类的初始化（有点像编写常规的torch.nn.Module）。设置 <code>config_class</code> 的那行代码不是必须的，除非你想使用自动类注册你的模型（请参阅最后一节）。",ne,u,Me,S,Jt="你可以让模型返回任何你想要的内容，但是像我们为 <code>ResnetModelForImageClassification</code> 做的那样返回一个字典，并在传递标签时包含loss，可以使你的模型能够在 <code>Trainer</code> 类中直接使用。只要你计划使用自己的训练循环或其他库进行训练，也可以使用其他输出格式。",ae,P,rt="现在我们已经有了模型类，让我们创建一个：",pe,q,ie,D,ct='同样的，你可以使用 <a href="/docs/transformers/pr_30962/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> 的任何方法，比如 <a href="/docs/transformers/pr_30962/zh/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> 或者 <a href="/docs/transformers/pr_30962/zh/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>。我们将在下一节中使用第二种方法，并了解如何如何使用我们的模型的代码推送模型权重。但首先，让我们在模型内加载一些预训练权重。',ye,K,dt="在你自己的用例中，你可能会在自己的数据上训练自定义模型。为了快速完成本教程，我们将使用 resnet50d 的预训练版本。由于我们的模型只是它的包装，转移这些权重将会很容易：",oe,O,me,ll,Tt='现在让我们看看，如何确保在执行 <a href="/docs/transformers/pr_30962/zh/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> 或 <a href="/docs/transformers/pr_30962/zh/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> 时，模型的代码被保存。',Je,el,re,C,ce,tl,wt="首先，确保你的模型在一个 <code>.py</code> 文件中完全定义。只要所有文件都位于同一目录中，它就可以依赖于某些其他文件的相对导入（目前我们还不为子模块支持此功能）。对于我们的示例，我们将在当前工作目录中名为 <code>resnet_model</code> 的文件夹中定义一个 <code>modeling_resnet.py</code> 文件和一个 <code>configuration_resnet.py</code> 文件。 配置文件包含 <code>ResnetConfig</code> 的代码，模型文件包含 <code>ResnetModel</code> 和 <code>ResnetModelForImageClassification</code> 的代码。",de,sl,Te,nl,jt="<code>__init__.py</code> 可以为空，它的存在只是为了让 Python 检测到 <code>resnet_model</code> 可以用作模块。",we,b,je,Ml,Ut="请注意，你可以重用（或子类化）现有的配置/模型。",Ue,al,ft="要与社区共享您的模型，请参照以下步骤：首先从新创建的文件中导入ResNet模型和配置：",fe,pl,ue,il,ut="接下来，你需要告诉库，当使用 <code>save_pretrained</code> 方法时，你希望复制这些对象的代码文件，并将它们正确注册到给定的 Auto 类（特别是对于模型），只需要运行以下代码：",Ce,yl,be,ol,Ct="请注意，对于配置（只有一个自动类 <code>AutoConfig</code>），不需要指定自动类，但对于模型来说情况不同。 你的自定义模型可能适用于许多不同的任务，因此你必须指定哪一个自动类适合你的模型。",Ie,ml,bt="接下来，让我们像之前一样创建配置和模型：",_e,Jl,Ze,rl,It="现在要将模型推送到集线器，请确保你已登录。你看可以在终端中运行以下命令：",he,cl,$e,dl,_t="或者在笔记本中运行以下代码：",Ae,Tl,ge,wl,Zt="然后，可以这样将模型推送到自己的命名空间（或你所属的组织）：",ke,jl,Ne,Ul,ht='除了模型权重和 JSON 格式的配置外，这行代码也会复制 <code>custom-resnet50d</code> 文件夹内的模型以及配置的 <code>.py</code> 文件并将结果上传至 Hub。你可以在此<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">模型仓库</a>中查看结果。',Be,fl,$t='有关推推送至 Hub 方法的更多信息，请参阅<a href="model_sharing">共享教程</a>。',We,ul,Re,Cl,At='可以使用自动类（auto-classes）和 <code>from_pretrained</code> 方法，使用模型仓库里带有自定义代码的配置、模型或分词器文件。所有上传到 Hub 的文件和代码都会进行恶意软件扫描（有关更多信息，请参阅 <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hub 安全</a> 文档）, 但你仍应查看模型代码和作者，以避免在你的计算机上执行恶意代码。 设置 <code>trust_remote_code=True</code> 以使用带有自定义代码的模型：',ve,bl,Xe,Il,gt="我们强烈建议为 <code>revision</code> 参数传递提交哈希（commit hash），以确保模型的作者没有使用一些恶意的代码行更新了代码（除非您完全信任模型的作者）。",Ge,_l,xe,Zl,kt="在 Hub 上浏览模型仓库的提交历史时，有一个按钮可以轻松复制任何提交的提交哈希。",Ve,hl,Ye,$l,Nt="如果你在编写一个扩展 🤗 Transformers 的库，你可能想要扩展自动类以包含您自己的模型。这与将代码推送到 Hub 不同，因为用户需要导入你的库才能获取自定义模型（与从 Hub 自动下载模型代码相反）。",Qe,Al,Bt="只要你的配置 <code>model_type</code> 属性与现有模型类型不同，并且你的模型类有正确的 <code>config_class</code> 属性，你可以像这样将它们添加到自动类中：",Ee,gl,He,kl,Wt="请注意，将自定义配置注册到 <code>AutoConfig</code> 时，使用的第一个参数需要与自定义配置的 <code>model_type</code> 匹配；而将自定义模型注册到任何自动模型类时，使用的第一个参数需要与 <code>config_class</code> 匹配。",ze,Nl,Fe,Wl,Le;return I=new Bl({props:{title:"共享自定义模型",local:"共享自定义模型",headingTag:"h1"}}),$=new Bl({props:{title:"编写自定义配置",local:"编写自定义配置",headingTag:"h2"}}),k=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),X=new w({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),x=new w({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),Y=new Bl({props:{title:"编写自定义模型",local:"编写自定义模型",headingTag:"h2"}}),H=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),F=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),u=new Se({props:{$$slots:{default:[Lt]},$$scope:{ctx:f}}}),q=new w({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new w({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),el=new Bl({props:{title:"将代码发送到 Hub",local:"将代码发送到-hub",headingTag:"h2"}}),C=new Se({props:{warning:!0,$$slots:{default:[St]},$$scope:{ctx:f}}}),sl=new w({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),b=new Se({props:{warning:!0,$$slots:{default:[Pt]},$$scope:{ctx:f}}}),pl=new w({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),yl=new w({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),Jl=new w({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),cl=new w({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Tl=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),jl=new w({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),ul=new Bl({props:{title:"使用带有自定义代码的模型",local:"使用带有自定义代码的模型",headingTag:"h2"}}),bl=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),_l=new w({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),hl=new Bl({props:{title:"将自定义代码的模型注册到自动类",local:"将自定义代码的模型注册到自动类",headingTag:"h2"}}),gl=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),Nl=new Ft({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/zh/custom_models.md"}}),{c(){y=a("meta"),j=n(),T=a("p"),U=n(),o(I.$$.fragment),Rl=n(),_=a("p"),_.textContent=qe,vl=n(),Z=a("p"),Z.textContent=De,Xl=n(),h=a("p"),h.innerHTML=Ke,Gl=n(),o($.$$.fragment),xl=n(),A=a("p"),A.innerHTML=Oe,Vl=n(),g=a("p"),g.textContent=lt,Yl=n(),o(k.$$.fragment),Ql=n(),N=a("p"),N.textContent=et,El=n(),B=a("ul"),B.innerHTML=tt,Hl=n(),W=a("p"),W.innerHTML=st,zl=n(),R=a("p"),R.innerHTML=nt,Fl=n(),v=a("p"),v.textContent=Mt,Ll=n(),o(X.$$.fragment),Sl=n(),G=a("p"),G.innerHTML=at,Pl=n(),o(x.$$.fragment),ql=n(),V=a("p"),V.innerHTML=pt,Dl=n(),o(Y.$$.fragment),Kl=n(),Q=a("p"),Q.innerHTML=it,Ol=n(),E=a("p"),E.textContent=yt,le=n(),o(H.$$.fragment),ee=n(),z=a("p"),z.textContent=ot,te=n(),o(F.$$.fragment),se=n(),L=a("p"),L.innerHTML=mt,ne=n(),o(u.$$.fragment),Me=n(),S=a("p"),S.innerHTML=Jt,ae=n(),P=a("p"),P.textContent=rt,pe=n(),o(q.$$.fragment),ie=n(),D=a("p"),D.innerHTML=ct,ye=n(),K=a("p"),K.textContent=dt,oe=n(),o(O.$$.fragment),me=n(),ll=a("p"),ll.innerHTML=Tt,Je=n(),o(el.$$.fragment),re=n(),o(C.$$.fragment),ce=n(),tl=a("p"),tl.innerHTML=wt,de=n(),o(sl.$$.fragment),Te=n(),nl=a("p"),nl.innerHTML=jt,we=n(),o(b.$$.fragment),je=n(),Ml=a("p"),Ml.textContent=Ut,Ue=n(),al=a("p"),al.textContent=ft,fe=n(),o(pl.$$.fragment),ue=n(),il=a("p"),il.innerHTML=ut,Ce=n(),o(yl.$$.fragment),be=n(),ol=a("p"),ol.innerHTML=Ct,Ie=n(),ml=a("p"),ml.textContent=bt,_e=n(),o(Jl.$$.fragment),Ze=n(),rl=a("p"),rl.textContent=It,he=n(),o(cl.$$.fragment),$e=n(),dl=a("p"),dl.textContent=_t,Ae=n(),o(Tl.$$.fragment),ge=n(),wl=a("p"),wl.textContent=Zt,ke=n(),o(jl.$$.fragment),Ne=n(),Ul=a("p"),Ul.innerHTML=ht,Be=n(),fl=a("p"),fl.innerHTML=$t,We=n(),o(ul.$$.fragment),Re=n(),Cl=a("p"),Cl.innerHTML=At,ve=n(),o(bl.$$.fragment),Xe=n(),Il=a("p"),Il.innerHTML=gt,Ge=n(),o(_l.$$.fragment),xe=n(),Zl=a("p"),Zl.textContent=kt,Ve=n(),o(hl.$$.fragment),Ye=n(),$l=a("p"),$l.textContent=Nt,Qe=n(),Al=a("p"),Al.innerHTML=Bt,Ee=n(),o(gl.$$.fragment),He=n(),kl=a("p"),kl.innerHTML=Wt,ze=n(),o(Nl.$$.fragment),Fe=n(),Wl=a("p"),this.h()},l(l){const e=Ht("svelte-u9bgzb",document.head);y=p(e,"META",{name:!0,content:!0}),e.forEach(t),j=M(l),T=p(l,"P",{}),Gt(T).forEach(t),U=M(l),m(I.$$.fragment,l),Rl=M(l),_=p(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-9nxend"&&(_.textContent=qe),vl=M(l),Z=p(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-19a103f"&&(Z.textContent=De),Xl=M(l),h=p(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-efgmjg"&&(h.innerHTML=Ke),Gl=M(l),m($.$$.fragment,l),xl=M(l),A=p(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1227xwf"&&(A.innerHTML=Oe),Vl=M(l),g=p(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-i8hsxz"&&(g.textContent=lt),Yl=M(l),m(k.$$.fragment,l),Ql=M(l),N=p(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1a7oeqv"&&(N.textContent=et),El=M(l),B=p(l,"UL",{"data-svelte-h":!0}),i(B)!=="svelte-1s6yo4g"&&(B.innerHTML=tt),Hl=M(l),W=p(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-tl0pjo"&&(W.innerHTML=st),zl=M(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1atr0z9"&&(R.innerHTML=nt),Fl=M(l),v=p(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1p70ds2"&&(v.textContent=Mt),Ll=M(l),m(X.$$.fragment,l),Sl=M(l),G=p(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-o9rk46"&&(G.innerHTML=at),Pl=M(l),m(x.$$.fragment,l),ql=M(l),V=p(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-foktmc"&&(V.innerHTML=pt),Dl=M(l),m(Y.$$.fragment,l),Kl=M(l),Q=p(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-bmcwbb"&&(Q.innerHTML=it),Ol=M(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1lbtc6j"&&(E.textContent=yt),le=M(l),m(H.$$.fragment,l),ee=M(l),z=p(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-16341pc"&&(z.textContent=ot),te=M(l),m(F.$$.fragment,l),se=M(l),L=p(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-18rfxea"&&(L.innerHTML=mt),ne=M(l),m(u.$$.fragment,l),Me=M(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-od54k8"&&(S.innerHTML=Jt),ae=M(l),P=p(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-ym2h95"&&(P.textContent=rt),pe=M(l),m(q.$$.fragment,l),ie=M(l),D=p(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1ecbert"&&(D.innerHTML=ct),ye=M(l),K=p(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-36p84q"&&(K.textContent=dt),oe=M(l),m(O.$$.fragment,l),me=M(l),ll=p(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-2v9p8i"&&(ll.innerHTML=Tt),Je=M(l),m(el.$$.fragment,l),re=M(l),m(C.$$.fragment,l),ce=M(l),tl=p(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-3w8bak"&&(tl.innerHTML=wt),de=M(l),m(sl.$$.fragment,l),Te=M(l),nl=p(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-n806b8"&&(nl.innerHTML=jt),we=M(l),m(b.$$.fragment,l),je=M(l),Ml=p(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-18wuvr2"&&(Ml.textContent=Ut),Ue=M(l),al=p(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-7gjgjm"&&(al.textContent=ft),fe=M(l),m(pl.$$.fragment,l),ue=M(l),il=p(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-nsc87p"&&(il.innerHTML=ut),Ce=M(l),m(yl.$$.fragment,l),be=M(l),ol=p(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1dt591c"&&(ol.innerHTML=Ct),Ie=M(l),ml=p(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-1vunet5"&&(ml.textContent=bt),_e=M(l),m(Jl.$$.fragment,l),Ze=M(l),rl=p(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-11g63u9"&&(rl.textContent=It),he=M(l),m(cl.$$.fragment,l),$e=M(l),dl=p(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-1emymh6"&&(dl.textContent=_t),Ae=M(l),m(Tl.$$.fragment,l),ge=M(l),wl=p(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-1xi8u2o"&&(wl.textContent=Zt),ke=M(l),m(jl.$$.fragment,l),Ne=M(l),Ul=p(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-1qq9kbx"&&(Ul.innerHTML=ht),Be=M(l),fl=p(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-1e6fo38"&&(fl.innerHTML=$t),We=M(l),m(ul.$$.fragment,l),Re=M(l),Cl=p(l,"P",{"data-svelte-h":!0}),i(Cl)!=="svelte-xah23j"&&(Cl.innerHTML=At),ve=M(l),m(bl.$$.fragment,l),Xe=M(l),Il=p(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-1dvm79h"&&(Il.innerHTML=gt),Ge=M(l),m(_l.$$.fragment,l),xe=M(l),Zl=p(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-8xcaeg"&&(Zl.textContent=kt),Ve=M(l),m(hl.$$.fragment,l),Ye=M(l),$l=p(l,"P",{"data-svelte-h":!0}),i($l)!=="svelte-1y2zt0l"&&($l.textContent=Nt),Qe=M(l),Al=p(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-l7gnnd"&&(Al.innerHTML=Bt),Ee=M(l),m(gl.$$.fragment,l),He=M(l),kl=p(l,"P",{"data-svelte-h":!0}),i(kl)!=="svelte-zrvvjw"&&(kl.innerHTML=Wt),ze=M(l),m(Nl.$$.fragment,l),Fe=M(l),Wl=p(l,"P",{}),Gt(Wl).forEach(t),this.h()},h(){xt(y,"name","hf:doc:metadata"),xt(y,"content",Dt)},m(l,e){zt(document.head,y),s(l,j,e),s(l,T,e),s(l,U,e),J(I,l,e),s(l,Rl,e),s(l,_,e),s(l,vl,e),s(l,Z,e),s(l,Xl,e),s(l,h,e),s(l,Gl,e),J($,l,e),s(l,xl,e),s(l,A,e),s(l,Vl,e),s(l,g,e),s(l,Yl,e),J(k,l,e),s(l,Ql,e),s(l,N,e),s(l,El,e),s(l,B,e),s(l,Hl,e),s(l,W,e),s(l,zl,e),s(l,R,e),s(l,Fl,e),s(l,v,e),s(l,Ll,e),J(X,l,e),s(l,Sl,e),s(l,G,e),s(l,Pl,e),J(x,l,e),s(l,ql,e),s(l,V,e),s(l,Dl,e),J(Y,l,e),s(l,Kl,e),s(l,Q,e),s(l,Ol,e),s(l,E,e),s(l,le,e),J(H,l,e),s(l,ee,e),s(l,z,e),s(l,te,e),J(F,l,e),s(l,se,e),s(l,L,e),s(l,ne,e),J(u,l,e),s(l,Me,e),s(l,S,e),s(l,ae,e),s(l,P,e),s(l,pe,e),J(q,l,e),s(l,ie,e),s(l,D,e),s(l,ye,e),s(l,K,e),s(l,oe,e),J(O,l,e),s(l,me,e),s(l,ll,e),s(l,Je,e),J(el,l,e),s(l,re,e),J(C,l,e),s(l,ce,e),s(l,tl,e),s(l,de,e),J(sl,l,e),s(l,Te,e),s(l,nl,e),s(l,we,e),J(b,l,e),s(l,je,e),s(l,Ml,e),s(l,Ue,e),s(l,al,e),s(l,fe,e),J(pl,l,e),s(l,ue,e),s(l,il,e),s(l,Ce,e),J(yl,l,e),s(l,be,e),s(l,ol,e),s(l,Ie,e),s(l,ml,e),s(l,_e,e),J(Jl,l,e),s(l,Ze,e),s(l,rl,e),s(l,he,e),J(cl,l,e),s(l,$e,e),s(l,dl,e),s(l,Ae,e),J(Tl,l,e),s(l,ge,e),s(l,wl,e),s(l,ke,e),J(jl,l,e),s(l,Ne,e),s(l,Ul,e),s(l,Be,e),s(l,fl,e),s(l,We,e),J(ul,l,e),s(l,Re,e),s(l,Cl,e),s(l,ve,e),J(bl,l,e),s(l,Xe,e),s(l,Il,e),s(l,Ge,e),J(_l,l,e),s(l,xe,e),s(l,Zl,e),s(l,Ve,e),J(hl,l,e),s(l,Ye,e),s(l,$l,e),s(l,Qe,e),s(l,Al,e),s(l,Ee,e),J(gl,l,e),s(l,He,e),s(l,kl,e),s(l,ze,e),J(Nl,l,e),s(l,Fe,e),s(l,Wl,e),Le=!0},p(l,[e]){const Rt={};e&2&&(Rt.$$scope={dirty:e,ctx:l}),u.$set(Rt);const vt={};e&2&&(vt.$$scope={dirty:e,ctx:l}),C.$set(vt);const Xt={};e&2&&(Xt.$$scope={dirty:e,ctx:l}),b.$set(Xt)},i(l){Le||(r(I.$$.fragment,l),r($.$$.fragment,l),r(k.$$.fragment,l),r(X.$$.fragment,l),r(x.$$.fragment,l),r(Y.$$.fragment,l),r(H.$$.fragment,l),r(F.$$.fragment,l),r(u.$$.fragment,l),r(q.$$.fragment,l),r(O.$$.fragment,l),r(el.$$.fragment,l),r(C.$$.fragment,l),r(sl.$$.fragment,l),r(b.$$.fragment,l),r(pl.$$.fragment,l),r(yl.$$.fragment,l),r(Jl.$$.fragment,l),r(cl.$$.fragment,l),r(Tl.$$.fragment,l),r(jl.$$.fragment,l),r(ul.$$.fragment,l),r(bl.$$.fragment,l),r(_l.$$.fragment,l),r(hl.$$.fragment,l),r(gl.$$.fragment,l),r(Nl.$$.fragment,l),Le=!0)},o(l){c(I.$$.fragment,l),c($.$$.fragment,l),c(k.$$.fragment,l),c(X.$$.fragment,l),c(x.$$.fragment,l),c(Y.$$.fragment,l),c(H.$$.fragment,l),c(F.$$.fragment,l),c(u.$$.fragment,l),c(q.$$.fragment,l),c(O.$$.fragment,l),c(el.$$.fragment,l),c(C.$$.fragment,l),c(sl.$$.fragment,l),c(b.$$.fragment,l),c(pl.$$.fragment,l),c(yl.$$.fragment,l),c(Jl.$$.fragment,l),c(cl.$$.fragment,l),c(Tl.$$.fragment,l),c(jl.$$.fragment,l),c(ul.$$.fragment,l),c(bl.$$.fragment,l),c(_l.$$.fragment,l),c(hl.$$.fragment,l),c(gl.$$.fragment,l),c(Nl.$$.fragment,l),Le=!1},d(l){l&&(t(j),t(T),t(U),t(Rl),t(_),t(vl),t(Z),t(Xl),t(h),t(Gl),t(xl),t(A),t(Vl),t(g),t(Yl),t(Ql),t(N),t(El),t(B),t(Hl),t(W),t(zl),t(R),t(Fl),t(v),t(Ll),t(Sl),t(G),t(Pl),t(ql),t(V),t(Dl),t(Kl),t(Q),t(Ol),t(E),t(le),t(ee),t(z),t(te),t(se),t(L),t(ne),t(Me),t(S),t(ae),t(P),t(pe),t(ie),t(D),t(ye),t(K),t(oe),t(me),t(ll),t(Je),t(re),t(ce),t(tl),t(de),t(Te),t(nl),t(we),t(je),t(Ml),t(Ue),t(al),t(fe),t(ue),t(il),t(Ce),t(be),t(ol),t(Ie),t(ml),t(_e),t(Ze),t(rl),t(he),t($e),t(dl),t(Ae),t(ge),t(wl),t(ke),t(Ne),t(Ul),t(Be),t(fl),t(We),t(Re),t(Cl),t(ve),t(Xe),t(Il),t(Ge),t(xe),t(Zl),t(Ve),t(Ye),t($l),t(Qe),t(Al),t(Ee),t(He),t(kl),t(ze),t(Fe),t(Wl)),t(y),d(I,l),d($,l),d(k,l),d(X,l),d(x,l),d(Y,l),d(H,l),d(F,l),d(u,l),d(q,l),d(O,l),d(el,l),d(C,l),d(sl,l),d(b,l),d(pl,l),d(yl,l),d(Jl,l),d(cl,l),d(Tl,l),d(jl,l),d(ul,l),d(bl,l),d(_l,l),d(hl,l),d(gl,l),d(Nl,l)}}}const Dt='{"title":"共享自定义模型","local":"共享自定义模型","sections":[{"title":"编写自定义配置","local":"编写自定义配置","sections":[],"depth":2},{"title":"编写自定义模型","local":"编写自定义模型","sections":[],"depth":2},{"title":"将代码发送到 Hub","local":"将代码发送到-hub","sections":[],"depth":2},{"title":"使用带有自定义代码的模型","local":"使用带有自定义代码的模型","sections":[],"depth":2},{"title":"将自定义代码的模型注册到自动类","local":"将自定义代码的模型注册到自动类","sections":[],"depth":2}],"depth":1}';function Kt(f){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends Qt{constructor(y){super(),Et(this,y,Kt,qt,Vt,{})}}export{ns as component};
