import{s as $t,o as zt,n as Gt}from"../chunks/scheduler.25b97de1.js";import{S as Bt,i as Ct,g as i,s as a,r as c,A as Vt,h as l,f as o,c as r,j as $,u as m,x as u,k as z,y as s,a as n,v as p,d as h,t as f,w as g}from"../chunks/index.d9030fc9.js";import{T as kt}from"../chunks/Tip.baa67368.js";import{D as W}from"../chunks/Docstring.ffac8efa.js";import{C as mt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Zt}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as ie,E as Wt}from"../chunks/EditOnGithub.91d95064.js";function Rt(le){let d,P="Example:",_,T,v;return T=new mt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpeHRyYWxWaXNpb25Nb2RlbCUyQyUyMFBpeHRyYWxWaXNpb25Db25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwUGl4dHJhbC0xMkIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWclMjAlM0QlMjBQaXh0cmFsVmlzaW9uQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbWx5JTIwaW5pdGlhbGl6ZWQlMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBQaXh0cmFsVmlzaW9uTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PixtralVisionModel, PixtralVisionConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Pixtral-12B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PixtralVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with randomly initialized weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PixtralVisionModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=i("p"),d.textContent=P,_=a(),c(T.$$.fragment)},l(M){d=l(M,"P",{"data-svelte-h":!0}),u(d)!=="svelte-11lpom8"&&(d.textContent=P),_=r(M),m(T.$$.fragment,M)},m(M,J){n(M,d,J),n(M,_,J),p(T,M,J),v=!0},p:Gt,i(M){v||(h(T.$$.fragment,M),v=!0)},o(M){f(T.$$.fragment,M),v=!1},d(M){M&&(o(d),o(_)),g(T,M)}}}function Nt(le){let d,P=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=P},l(_){d=l(_,"P",{"data-svelte-h":!0}),u(d)!=="svelte-fincs2"&&(d.innerHTML=P)},m(_,T){n(_,d,T)},p:Gt,d(_){_&&o(d)}}}function Et(le){let d,P,_,T,v,M,J,ve,R,pt='The Pixtral model was released by the Mistral AI team on <a href="https://github.com/vllm-project/vllm/pull/8377" rel="nofollow">vLLM</a>, where a version of the code can be found!',Je,N,ht="Tips:",Ie,E,ft='<li>Pixtral is a multimodal model, taking images and text as input, and producing text as output.</li> <li>This model follows the <a href="llava">Llava</a> family, meaning image embeddings are placed instead of the <code>[IMG]</code> token placeholders. The model uses <a href="/docs/transformers/pr_30950/en/model_doc/pixtral#transformers.PixtralVisionModel">PixtralVisionModel</a> for its vision encoder, and <a href="/docs/transformers/pr_30950/en/model_doc/mistral#transformers.MistralForCausalLM">MistralForCausalLM</a> for its language decoder.</li> <li>The main contribution is the 2d ROPE (rotary postiion embeddings) on the images, and support for arbitrary image sizes (the images are not padded together nor are they resized).</li> <li>The format for one or mulitple prompts is the following:</li>',Ue,S,Pe,H,gt="Then, the processor will replace each <code>[IMG]</code> token with  a number of <code>[IMG]</code> token that depends on the height and the width of the image. Each <em>row</em> of the image is separated by a <code>[IMG_BREAK]</code> token, and each image is separated by a  <code>[IMG_END]</code> token.",je,Y,ut='This model was contributed by <a href="https://huggingface.co/amyeroberts" rel="nofollow">amyeroberts</a> and <a href="https://huggingface.co/ArthurZ" rel="nofollow">ArthurZ</a>. The original code can be found <a href="https://github.com/vllm-project/vllm/pull/8377" rel="nofollow">here</a>.',Ge,L,$e,X,Mt="Here is an example of how to run it:",ze,F,Be,q,Ce,y,D,Fe,de,_t=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30950/en/model_doc/pixtral#transformers.PixtralVisionModel">PixtralVisionModel</a>. It is used to instantiate an
Pixtral vision encoder according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to the vision encoder used by Pixtral-12B.`,qe,ce,yt='e.g. <a href="https://huggingface.co/pixtral-hf/pixtral-9b" rel="nofollow">pixtral-hf/pixtral-9b</a>',De,me,bt=`Configuration objects inherit from <a href="/docs/transformers/pr_30950/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30950/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Qe,B,Ve,Q,ke,w,A,Ae,pe,Tt=`The bare Pixtral vision encoder outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/pr_30950/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ke,he,wt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Oe,j,K,et,fe,xt='The <a href="/docs/transformers/pr_30950/en/model_doc/pixtral#transformers.PixtralVisionModel">PixtralVisionModel</a> forward method, overrides the <code>__call__</code> special method.',tt,C,Ze,O,We,I,ee,ot,ge,vt="Constructs a Pixtral image processor.",at,V,te,rt,ue,Jt="Preprocess an image or batch of images.",Re,oe,Ne,b,ae,nt,Me,It="Constructs a Pixtral processor which wraps a Pixtral image processor and a Pixtral tokenizer into a single processor.",st,_e,Ut=`<a href="/docs/transformers/pr_30950/en/model_doc/pixtral#transformers.PixtralProcessor">PixtralProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_30950/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> and <a href="/docs/transformers/pr_30950/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/pr_30950/en/model_doc/pixtral#transformers.PixtralProcessor.decode">decode()</a> for more information.`,it,k,re,lt,ye,Pt=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,dt,Z,ne,ct,be,jt=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Ee,se,Se,xe,He;return v=new ie({props:{title:"Pixtral",local:"pixtral",headingTag:"h1"}}),J=new ie({props:{title:"Overview",local:"overview",headingTag:"h2"}}),S=new mt({props:{code:"JTIyJTNDcyUzRSU1QklOU1QlNUQlNUJJTUclNUQlNUNuV2hhdCUyMGFyZSUyMHRoZSUyMHRoaW5ncyUyMEklMjBzaG91bGQlMjBiZSUyMGNhdXRpb3VzJTIwYWJvdXQlMjB3aGVuJTIwSSUyMHZpc2l0JTIwdGhpcyUyMHBsYWNlJTNGJTVCJTJGSU5TVCU1RCUyMg==",highlighted:'&quot;&lt;s&gt;<span class="hljs-selector-attr">[INST]</span><span class="hljs-selector-attr">[IMG]</span>\\nWhat are the things <span class="hljs-selector-tag">I</span> should be cautious about when <span class="hljs-selector-tag">I</span> visit this place?<span class="hljs-selector-attr">[/INST]</span>&quot;',wrap:!1}}),L=new ie({props:{title:"Usage",local:"usage",headingTag:"h2"}}),F=new mt({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaForConditionalGeneration, AutoProcessor
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

model_id = <span class="hljs-string">&quot;mistral-community/pixtral-12b&quot;</span>
model = LlavaForConditionalGeneration.from_pretrained(model_id).to(<span class="hljs-string">&quot;cuda&quot;</span>)
processor = AutoProcessor.from_pretrained(model_id)

IMG_URLS = [
    <span class="hljs-string">&quot;https://picsum.photos/id/237/400/300&quot;</span>,
    <span class="hljs-string">&quot;https://picsum.photos/id/231/200/300&quot;</span>,
    <span class="hljs-string">&quot;https://picsum.photos/id/27/500/500&quot;</span>,
    <span class="hljs-string">&quot;https://picsum.photos/id/17/150/600&quot;</span>,
]
PROMPT = <span class="hljs-string">&quot;&lt;s&gt;[INST]Describe the images.\\n[IMG][IMG][IMG][IMG][/INST]&quot;</span>

inputs = processor(images=IMG_URLS, text=PROMPT, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">500</span>)
output = processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]

EXPECTED_GENERATION = <span class="hljs-string">&quot;&quot;&quot;
Describe the images.
Sure, let&#x27;s break down each image description:

1. **Image 1:**
   - **Description:** A black dog with a glossy coat is sitting on a wooden floor. The dog has a focused expression and is looking directly at the camera.
   - **Details:** The wooden floor has a rustic appearance with visible wood grain patterns. The dog&#x27;s eyes are a striking color, possibly brown or amber, which contrasts with its black fur.

2. **Image 2:**
   - **Description:** A scenic view of a mountainous landscape with a winding road cutting through it. The road is surrounded by lush green vegetation and leads to a distant valley.
   - **Details:** The mountains are rugged with steep slopes, and the sky is clear, indicating good weather. The winding road adds a sense of depth and perspective to the image.

3. **Image 3:**
   - **Description:** A beach scene with waves crashing against the shore. There are several people in the water and on the beach, enjoying the waves and the sunset.
   - **Details:** The waves are powerful, creating a dynamic and lively atmosphere. The sky is painted with hues of orange and pink from the setting sun, adding a warm glow to the scene.

4. **Image 4:**
   - **Description:** A garden path leading to a large tree with a bench underneath it. The path is bordered by well-maintained grass and flowers.
   - **Details:** The path is made of small stones or gravel, and the tree provides a shaded area with the bench invitingly placed beneath it. The surrounding area is lush and green, suggesting a well-kept garden.

Each image captures a different scene, from a close-up of a dog to expansive natural landscapes, showcasing various elements of nature and human interaction with it.
&quot;&quot;&quot;</span>
`,wrap:!1}}),q=new ie({props:{title:"PixtralVisionConfig",local:"transformers.PixtralVisionConfig",headingTag:"h2"}}),D=new W({props:{name:"class transformers.PixtralVisionConfig",anchor:"transformers.PixtralVisionConfig",parameters:[{name:"hidden_size",val:" = 1024"},{name:"intermediate_size",val:" = 4096"},{name:"num_hidden_layers",val:" = 24"},{name:"num_attention_heads",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 1024"},{name:"patch_size",val:" = 16"},{name:"hidden_act",val:" = 'gelu'"},{name:"attention_dropout",val:" = 0.0"},{name:"rope_theta",val:" = 10000.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PixtralVisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.PixtralVisionConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.PixtralVisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.PixtralVisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.PixtralVisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of input channels in the input images.`,name:"num_channels"},{anchor:"transformers.PixtralVisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Max dimension of the input images.`,name:"image_size"},{anchor:"transformers.PixtralVisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Size of the image patches.`,name:"patch_size"},{anchor:"transformers.PixtralVisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
Activation function used in the hidden layers.`,name:"hidden_act"},{anchor:"transformers.PixtralVisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Dropout probability for the attention layers.`,name:"attention_dropout"},{anchor:"transformers.PixtralVisionConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/pixtral/configuration_pixtral.py#L23"}}),B=new Zt({props:{anchor:"transformers.PixtralVisionConfig.example",$$slots:{default:[Rt]},$$scope:{ctx:le}}}),Q=new ie({props:{title:"PixtralVisionModel",local:"transformers.PixtralVisionModel",headingTag:"h2"}}),A=new W({props:{name:"class transformers.PixtralVisionModel",anchor:"transformers.PixtralVisionModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PixtralVisionModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30950/en/model_doc/pixtral#transformers.PixtralVisionConfig">PixtralVisionConfig</a>) &#x2014;
Model configuration class with all the parameters of the vision encoder. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30950/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/pixtral/modeling_pixtral.py#L455"}}),K=new W({props:{name:"forward",anchor:"transformers.PixtralVisionModel.forward",parameters:[{name:"pixel_values",val:": List"},{name:"output_hidden_states",val:": Optional = False"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PixtralVisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_30950/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <code>AutoImageProcessor.__call__()</code>
for details.`,name:"pixel_values"},{anchor:"transformers.PixtralVisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PixtralVisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PixtralVisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30950/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/pixtral/modeling_pixtral.py#L476",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>tensor of token features for
all tokens of all images of shape (N_toks, D)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>pixel_values</p>
`}}),C=new kt({props:{$$slots:{default:[Nt]},$$scope:{ctx:le}}}),O=new ie({props:{title:"PixtralImageProcessor",local:"transformers.PixtralImageProcessor",headingTag:"h2"}}),ee=new W({props:{name:"class transformers.PixtralImageProcessor",anchor:"transformers.PixtralImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"patch_size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PixtralImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.PixtralImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;longest_edge&quot; -- 1024}</code>):
Size of the maximum dimension of either the height or width dimension of the image. Used to control how
images are resized. If either the height or width are greater than <code>size[&quot;longest_edge&quot;]</code> then both the height and width are rescaled by <code>height / ratio</code>, <code>width /ratio</code> where <code>ratio = max(height / longest_edge, width / longest_edge)</code>`,name:"size"},{anchor:"transformers.PixtralImageProcessor.patch_size",description:`<strong>patch_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 16, &quot;width&quot;: 16}</code>):
Size of the patches in the model, used to calculate the output image size. Can be overridden by <code>patch_size</code> in the <code>preprocess</code> method.`,name:"patch_size"},{anchor:"transformers.PixtralImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.PixtralImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.PixtralImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.PixtralImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.PixtralImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.PixtralImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.PixtralImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/pixtral/image_processing_pixtral.py#L231"}}),te=new W({props:{name:"preprocess",anchor:"transformers.PixtralImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"patch_size",val:": Dict = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PixtralImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.PixtralImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.PixtralImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.PixtralImageProcessor.preprocess.patch_size",description:`<strong>patch_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.patch_size</code>) &#x2014;
Patch size in the model. Used to calculate the image after resizing.`,name:"patch_size"},{anchor:"transformers.PixtralImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.PixtralImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.PixtralImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.PixtralImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.PixtralImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.PixtralImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.PixtralImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.PixtralImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PixtralImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.PixtralImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/pixtral/image_processing_pixtral.py#L368"}}),oe=new ie({props:{title:"PixtralProcessor",local:"transformers.PixtralProcessor",headingTag:"h2"}}),ae=new W({props:{name:"class transformers.PixtralProcessor",anchor:"transformers.PixtralProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"patch_size",val:": int = 16"},{name:"chat_template",val:" = None"},{name:"image_token",val:" = '[IMG]'"},{name:"image_break_token",val:" = '[IMG_BREAK]'"},{name:"image_end_token",val:" = '[IMG_END]'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PixtralProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/pr_30950/en/model_doc/pixtral#transformers.PixtralImageProcessor">PixtralImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.PixtralProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/pr_30950/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.PixtralProcessor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Patch size from the vision tower.`,name:"patch_size"},{anchor:"transformers.PixtralProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.PixtralProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[IMG]&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.PixtralProcessor.image_break_token",description:`<strong>image_break_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[IMG_BREAK]&quot;</code>) &#x2014;
Special token used to denote the end of a line of pixels in an image.`,name:"image_break_token"},{anchor:"transformers.PixtralProcessor.image_end_token",description:`<strong>image_end_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[IMG_END]&quot;</code>) &#x2014;
Special token used to denote the end of an image input.`,name:"image_end_token"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/pixtral/processing_pixtral.py#L104"}}),re=new W({props:{name:"batch_decode",anchor:"transformers.PixtralProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/pixtral/processing_pixtral.py#L262"}}),ne=new W({props:{name:"decode",anchor:"transformers.PixtralProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/models/pixtral/processing_pixtral.py#L270"}}),se=new Wt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/pixtral.md"}}),{c(){d=i("meta"),P=a(),_=i("p"),T=a(),c(v.$$.fragment),M=a(),c(J.$$.fragment),ve=a(),R=i("p"),R.innerHTML=pt,Je=a(),N=i("p"),N.textContent=ht,Ie=a(),E=i("ul"),E.innerHTML=ft,Ue=a(),c(S.$$.fragment),Pe=a(),H=i("p"),H.innerHTML=gt,je=a(),Y=i("p"),Y.innerHTML=ut,Ge=a(),c(L.$$.fragment),$e=a(),X=i("p"),X.textContent=Mt,ze=a(),c(F.$$.fragment),Be=a(),c(q.$$.fragment),Ce=a(),y=i("div"),c(D.$$.fragment),Fe=a(),de=i("p"),de.innerHTML=_t,qe=a(),ce=i("p"),ce.innerHTML=yt,De=a(),me=i("p"),me.innerHTML=bt,Qe=a(),c(B.$$.fragment),Ve=a(),c(Q.$$.fragment),ke=a(),w=i("div"),c(A.$$.fragment),Ae=a(),pe=i("p"),pe.innerHTML=Tt,Ke=a(),he=i("p"),he.innerHTML=wt,Oe=a(),j=i("div"),c(K.$$.fragment),et=a(),fe=i("p"),fe.innerHTML=xt,tt=a(),c(C.$$.fragment),Ze=a(),c(O.$$.fragment),We=a(),I=i("div"),c(ee.$$.fragment),ot=a(),ge=i("p"),ge.textContent=vt,at=a(),V=i("div"),c(te.$$.fragment),rt=a(),ue=i("p"),ue.textContent=Jt,Re=a(),c(oe.$$.fragment),Ne=a(),b=i("div"),c(ae.$$.fragment),nt=a(),Me=i("p"),Me.textContent=It,st=a(),_e=i("p"),_e.innerHTML=Ut,it=a(),k=i("div"),c(re.$$.fragment),lt=a(),ye=i("p"),ye.innerHTML=Pt,dt=a(),Z=i("div"),c(ne.$$.fragment),ct=a(),be=i("p"),be.innerHTML=jt,Ee=a(),c(se.$$.fragment),Se=a(),xe=i("p"),this.h()},l(e){const t=Vt("svelte-u9bgzb",document.head);d=l(t,"META",{name:!0,content:!0}),t.forEach(o),P=r(e),_=l(e,"P",{}),$(_).forEach(o),T=r(e),m(v.$$.fragment,e),M=r(e),m(J.$$.fragment,e),ve=r(e),R=l(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1h8af4w"&&(R.innerHTML=pt),Je=r(e),N=l(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-axv494"&&(N.textContent=ht),Ie=r(e),E=l(e,"UL",{"data-svelte-h":!0}),u(E)!=="svelte-1yssvnl"&&(E.innerHTML=ft),Ue=r(e),m(S.$$.fragment,e),Pe=r(e),H=l(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-7bcz5w"&&(H.innerHTML=gt),je=r(e),Y=l(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1fxleij"&&(Y.innerHTML=ut),Ge=r(e),m(L.$$.fragment,e),$e=r(e),X=l(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-h0po0h"&&(X.textContent=Mt),ze=r(e),m(F.$$.fragment,e),Be=r(e),m(q.$$.fragment,e),Ce=r(e),y=l(e,"DIV",{class:!0});var x=$(y);m(D.$$.fragment,x),Fe=r(x),de=l(x,"P",{"data-svelte-h":!0}),u(de)!=="svelte-v80gjn"&&(de.innerHTML=_t),qe=r(x),ce=l(x,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-l0qt95"&&(ce.innerHTML=yt),De=r(x),me=l(x,"P",{"data-svelte-h":!0}),u(me)!=="svelte-o0v7bn"&&(me.innerHTML=bt),Qe=r(x),m(B.$$.fragment,x),x.forEach(o),Ve=r(e),m(Q.$$.fragment,e),ke=r(e),w=l(e,"DIV",{class:!0});var U=$(w);m(A.$$.fragment,U),Ae=r(U),pe=l(U,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-14vdi98"&&(pe.innerHTML=Tt),Ke=r(U),he=l(U,"P",{"data-svelte-h":!0}),u(he)!=="svelte-hswkmf"&&(he.innerHTML=wt),Oe=r(U),j=l(U,"DIV",{class:!0});var Te=$(j);m(K.$$.fragment,Te),et=r(Te),fe=l(Te,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-fcdmhe"&&(fe.innerHTML=xt),tt=r(Te),m(C.$$.fragment,Te),Te.forEach(o),U.forEach(o),Ze=r(e),m(O.$$.fragment,e),We=r(e),I=l(e,"DIV",{class:!0});var we=$(I);m(ee.$$.fragment,we),ot=r(we),ge=l(we,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-1eqw4iw"&&(ge.textContent=vt),at=r(we),V=l(we,"DIV",{class:!0});var Ye=$(V);m(te.$$.fragment,Ye),rt=r(Ye),ue=l(Ye,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-1x3yxsa"&&(ue.textContent=Jt),Ye.forEach(o),we.forEach(o),Re=r(e),m(oe.$$.fragment,e),Ne=r(e),b=l(e,"DIV",{class:!0});var G=$(b);m(ae.$$.fragment,G),nt=r(G),Me=l(G,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-1i1eb5d"&&(Me.textContent=It),st=r(G),_e=l(G,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-pv7lff"&&(_e.innerHTML=Ut),it=r(G),k=l(G,"DIV",{class:!0});var Le=$(k);m(re.$$.fragment,Le),lt=r(Le),ye=l(Le,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-12t737h"&&(ye.innerHTML=Pt),Le.forEach(o),dt=r(G),Z=l(G,"DIV",{class:!0});var Xe=$(Z);m(ne.$$.fragment,Xe),ct=r(Xe),be=l(Xe,"P",{"data-svelte-h":!0}),u(be)!=="svelte-l5gitz"&&(be.innerHTML=jt),Xe.forEach(o),G.forEach(o),Ee=r(e),m(se.$$.fragment,e),Se=r(e),xe=l(e,"P",{}),$(xe).forEach(o),this.h()},h(){z(d,"name","hf:doc:metadata"),z(d,"content",St),z(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,d),n(e,P,t),n(e,_,t),n(e,T,t),p(v,e,t),n(e,M,t),p(J,e,t),n(e,ve,t),n(e,R,t),n(e,Je,t),n(e,N,t),n(e,Ie,t),n(e,E,t),n(e,Ue,t),p(S,e,t),n(e,Pe,t),n(e,H,t),n(e,je,t),n(e,Y,t),n(e,Ge,t),p(L,e,t),n(e,$e,t),n(e,X,t),n(e,ze,t),p(F,e,t),n(e,Be,t),p(q,e,t),n(e,Ce,t),n(e,y,t),p(D,y,null),s(y,Fe),s(y,de),s(y,qe),s(y,ce),s(y,De),s(y,me),s(y,Qe),p(B,y,null),n(e,Ve,t),p(Q,e,t),n(e,ke,t),n(e,w,t),p(A,w,null),s(w,Ae),s(w,pe),s(w,Ke),s(w,he),s(w,Oe),s(w,j),p(K,j,null),s(j,et),s(j,fe),s(j,tt),p(C,j,null),n(e,Ze,t),p(O,e,t),n(e,We,t),n(e,I,t),p(ee,I,null),s(I,ot),s(I,ge),s(I,at),s(I,V),p(te,V,null),s(V,rt),s(V,ue),n(e,Re,t),p(oe,e,t),n(e,Ne,t),n(e,b,t),p(ae,b,null),s(b,nt),s(b,Me),s(b,st),s(b,_e),s(b,it),s(b,k),p(re,k,null),s(k,lt),s(k,ye),s(b,dt),s(b,Z),p(ne,Z,null),s(Z,ct),s(Z,be),n(e,Ee,t),p(se,e,t),n(e,Se,t),n(e,xe,t),He=!0},p(e,[t]){const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),B.$set(x);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),C.$set(U)},i(e){He||(h(v.$$.fragment,e),h(J.$$.fragment,e),h(S.$$.fragment,e),h(L.$$.fragment,e),h(F.$$.fragment,e),h(q.$$.fragment,e),h(D.$$.fragment,e),h(B.$$.fragment,e),h(Q.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(C.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(oe.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),He=!0)},o(e){f(v.$$.fragment,e),f(J.$$.fragment,e),f(S.$$.fragment,e),f(L.$$.fragment,e),f(F.$$.fragment,e),f(q.$$.fragment,e),f(D.$$.fragment,e),f(B.$$.fragment,e),f(Q.$$.fragment,e),f(A.$$.fragment,e),f(K.$$.fragment,e),f(C.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(oe.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(ne.$$.fragment,e),f(se.$$.fragment,e),He=!1},d(e){e&&(o(P),o(_),o(T),o(M),o(ve),o(R),o(Je),o(N),o(Ie),o(E),o(Ue),o(Pe),o(H),o(je),o(Y),o(Ge),o($e),o(X),o(ze),o(Be),o(Ce),o(y),o(Ve),o(ke),o(w),o(Ze),o(We),o(I),o(Re),o(Ne),o(b),o(Ee),o(Se),o(xe)),o(d),g(v,e),g(J,e),g(S,e),g(L,e),g(F,e),g(q,e),g(D),g(B),g(Q,e),g(A),g(K),g(C),g(O,e),g(ee),g(te),g(oe,e),g(ae),g(re),g(ne),g(se,e)}}}const St='{"title":"Pixtral","local":"pixtral","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"PixtralVisionConfig","local":"transformers.PixtralVisionConfig","sections":[],"depth":2},{"title":"PixtralVisionModel","local":"transformers.PixtralVisionModel","sections":[],"depth":2},{"title":"PixtralImageProcessor","local":"transformers.PixtralImageProcessor","sections":[],"depth":2},{"title":"PixtralProcessor","local":"transformers.PixtralProcessor","sections":[],"depth":2}],"depth":1}';function Ht(le){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends Bt{constructor(d){super(),Ct(this,d,Ht,Et,$t,{})}}export{At as component};
