import{s as Ns,n as xs,o as Rs}from"../chunks/scheduler.25b97de1.js";import{S as Fs,i as Ss,g as p,s as l,r as i,A as zs,h as r,f as e,c as n,j as As,u as o,x as m,k as Gs,y as Es,a as t,v as c,d as y,t as M,w as h}from"../chunks/index.d9030fc9.js";import{C as T}from"../chunks/CodeBlock.e6cd0d95.js";import{H as Cs,E as Ds}from"../chunks/EditOnGithub.91d95064.js";function Ls(bs){let J,z,F,E,u,D,j,gs='🤗 Transformers provides a <a href="/docs/transformers/pr_30862/en/main_classes/trainer#transformers.Trainer">Trainer</a> class optimized for training 🤗 Transformers models, making it easier to start training without manually writing your own training loop. The <a href="/docs/transformers/pr_30862/en/main_classes/trainer#transformers.Trainer">Trainer</a> provides API for hyperparameter search. This doc shows how to enable it in example.',L,w,P,U,_s=`<a href="/docs/transformers/pr_30862/en/main_classes/trainer#transformers.Trainer">Trainer</a> supports four hyperparameter search backends currently:
<a href="https://optuna.org/" rel="nofollow">optuna</a>, <a href="https://sigopt.com/" rel="nofollow">sigopt</a>, <a href="https://docs.ray.io/en/latest/tune/index.html" rel="nofollow">raytune</a> and <a href="https://wandb.ai/site/sweeps" rel="nofollow">wandb</a>.`,K,d,$s="you should install them before using them as the hyperparameter search backend",O,f,ss,I,as,C,qs="Define the hyperparameter search space, different backends need different format.",es,b,vs='For sigopt, see sigopt <a href="https://docs.sigopt.com/ai-module-api-references/api_reference/objects/object_parameter" rel="nofollow">object_parameter</a>, it’s like following:',ts,g,ls,_,Xs='For optuna, see optuna <a href="https://optuna.readthedocs.io/en/stable/tutorial/10_key_features/002_configurations.html#sphx-glr-tutorial-10-key-features-002-configurations-py" rel="nofollow">object_parameter</a>, it’s like following:',ns,$,ps,q,Ws='Optuna provides multi-objective HPO. You can pass <code>direction</code> in <code>hyperparameter_search</code> and define your own compute_objective to return multiple objective values. The Pareto Front (<code>List[BestRun]</code>) will be returned in hyperparameter_search, you should refer to the test case <code>TrainerHyperParameterMultiObjectOptunaIntegrationTest</code> in <a href="https://github.com/huggingface/transformers/blob/main/tests/trainer/test_trainer.py" rel="nofollow">test_trainer</a>. It’s like following',rs,v,is,X,Ys='For raytune, see raytune <a href="https://docs.ray.io/en/latest/tune/api/search_space.html" rel="nofollow">object_parameter</a>, it’s like following:',os,W,ms,Y,ks='For wandb, see wandb <a href="https://docs.wandb.ai/guides/sweeps/configuration" rel="nofollow">object_parameter</a>, it’s like following:',cs,k,ys,B,Bs='Define a <code>model_init</code> function and pass it to the <a href="/docs/transformers/pr_30862/en/main_classes/trainer#transformers.Trainer">Trainer</a>, as an example:',Ms,Z,hs,V,Zs='Create a <a href="/docs/transformers/pr_30862/en/main_classes/trainer#transformers.Trainer">Trainer</a> with your <code>model_init</code> function, training arguments, training and test datasets, and evaluation function:',Js,H,Ts,Q,Vs="Call hyperparameter search, get the best trial parameters, backend could be <code>&quot;optuna&quot;</code>/<code>&quot;sigopt&quot;</code>/<code>&quot;wandb&quot;</code>/<code>&quot;ray&quot;</code>. direction can be<code>&quot;minimize&quot;</code> or <code>&quot;maximize&quot;</code>, which indicates whether to optimize greater or lower objective.",us,A,Hs="You could define your own compute_objective function, if not defined, the default compute_objective will be called, and the sum of eval metric like f1 is returned as objective value.",js,G,ws,N,Us,x,Qs="Currently, Hyperparameter search for DDP is enabled for optuna and sigopt. Only the rank-zero process will generate the search trial and pass the argument to other ranks.",ds,R,fs,S,Is;return u=new Cs({props:{title:"Hyperparameter Search using Trainer API",local:"hyperparameter-search-using-trainer-api",headingTag:"h1"}}),w=new Cs({props:{title:"Hyperparameter Search backend",local:"hyperparameter-search-backend",headingTag:"h2"}}),f=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdHVuYSUyRnNpZ29wdCUyRndhbmRiJTJGcmF5JTVCdHVuZSU1RCUyMA==",highlighted:"pip install optuna/sigopt/wandb/ray[tune] ",wrap:!1}}),I=new Cs({props:{title:"How to enable Hyperparameter search in example",local:"how-to-enable-hyperparameter-search-in-example",headingTag:"h2"}}),g=new T({props:{code:"ZGVmJTIwc2lnb3B0X2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMmJvdW5kcyUyMiUzQSUyMCU3QiUyMm1pbiUyMiUzQSUyMDFlLTYlMkMlMjAlMjJtYXglMjIlM0ElMjAxZS00JTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlMkMlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZG91YmxlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY2F0ZWdvcmljYWxfdmFsdWVzJTIyJTNBJTIwJTVCJTIyMTYlMjIlMkMlMjAlMjIzMiUyMiUyQyUyMCUyMjY0JTIyJTJDJTIwJTIyMTI4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMnBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJjYXRlZ29yaWNhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sigopt_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;bounds&quot;</span>: {<span class="hljs-string">&quot;min&quot;</span>: <span class="hljs-number">1e-6</span>, <span class="hljs-string">&quot;max&quot;</span>: <span class="hljs-number">1e-4</span>}, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;double&quot;</span>},
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;categorical_values&quot;</span>: [<span class="hljs-string">&quot;16&quot;</span>, <span class="hljs-string">&quot;32&quot;</span>, <span class="hljs-string">&quot;64&quot;</span>, <span class="hljs-string">&quot;128&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;categorical&quot;</span>,
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ]`,wrap:!1}}),$=new T({props:{code:"ZGVmJTIwb3B0dW5hX2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjB0cmlhbC5zdWdnZXN0X2Zsb2F0KCUyMmxlYXJuaW5nX3JhdGUlMjIlMkMlMjAxZS02JTJDJTIwMWUtNCUyQyUyMGxvZyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9jYXRlZ29yaWNhbCglMjJwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjIlMkMlMjAlNUIxNiUyQyUyMDMyJTJDJTIwNjQlMkMlMjAxMjglNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">optuna_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;learning_rate&quot;</span>: trial.suggest_float(<span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>, log=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: trial.suggest_categorical(<span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>, [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]),
<span class="hljs-meta">... </span>    }`,wrap:!1}}),v=new T({props:{code:"YmVzdF90cmlhbHMlMjAlM0QlMjB0cmFpbmVyLmh5cGVycGFyYW1ldGVyX3NlYXJjaCglMEElMjAlMjAlMjAlMjBkaXJlY3Rpb24lM0QlNUIlMjJtaW5pbWl6ZSUyMiUyQyUyMCUyMm1heGltaXplJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYmFja2VuZCUzRCUyMm9wdHVuYSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhwX3NwYWNlJTNEb3B0dW5hX2hwX3NwYWNlJTJDJTBBJTIwJTIwJTIwJTIwbl90cmlhbHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfb2JqZWN0aXZlJTNEY29tcHV0ZV9vYmplY3RpdmUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>best_trials = trainer.hyperparameter_search(
<span class="hljs-meta">... </span>    direction=[<span class="hljs-string">&quot;minimize&quot;</span>, <span class="hljs-string">&quot;maximize&quot;</span>],
<span class="hljs-meta">... </span>    backend=<span class="hljs-string">&quot;optuna&quot;</span>,
<span class="hljs-meta">... </span>    hp_space=optuna_hp_space,
<span class="hljs-meta">... </span>    n_trials=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    compute_objective=compute_objective,
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new T({props:{code:"ZGVmJTIwcmF5X2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjB0dW5lLmxvZ3VuaWZvcm0oMWUtNiUyQyUyMDFlLTQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwdHVuZS5jaG9pY2UoJTVCMTYlMkMlMjAzMiUyQyUyMDY0JTJDJTIwMTI4JTVEKSUyQyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">ray_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;learning_rate&quot;</span>: tune.loguniform(<span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: tune.choice([<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]),
<span class="hljs-meta">... </span>    }`,wrap:!1}}),k=new T({props:{code:"ZGVmJTIwd2FuZGJfaHBfc3BhY2UodHJpYWwpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0aG9kJTIyJTNBJTIwJTIycmFuZG9tJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljJTIyJTNBJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMm9iamVjdGl2ZSUyMiUyQyUyMCUyMmdvYWwlMjIlM0ElMjAlMjJtaW5pbWl6ZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWFybmluZ19yYXRlJTIyJTNBJTIwJTdCJTIyZGlzdHJpYnV0aW9uJTIyJTNBJTIwJTIydW5pZm9ybSUyMiUyQyUyMCUyMm1pbiUyMiUzQSUyMDFlLTYlMkMlMjAlMjJtYXglMjIlM0ElMjAxZS00JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwJTdCJTIydmFsdWVzJTIyJTNBJTIwJTVCMTYlMkMlMjAzMiUyQyUyMDY0JTJDJTIwMTI4JTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">wandb_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;method&quot;</span>: <span class="hljs-string">&quot;random&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;metric&quot;</span>: {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;objective&quot;</span>, <span class="hljs-string">&quot;goal&quot;</span>: <span class="hljs-string">&quot;minimize&quot;</span>},
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;learning_rate&quot;</span>: {<span class="hljs-string">&quot;distribution&quot;</span>: <span class="hljs-string">&quot;uniform&quot;</span>, <span class="hljs-string">&quot;min&quot;</span>: <span class="hljs-number">1e-6</span>, <span class="hljs-string">&quot;max&quot;</span>: <span class="hljs-number">1e-4</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: {<span class="hljs-string">&quot;values&quot;</span>: [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    }`,wrap:!1}}),Z=new T({props:{code:"ZGVmJTIwbW9kZWxfaW5pdCh0cmlhbCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9hcmdzLm1vZGVsX25hbWVfb3JfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZyb21fdGYlM0Rib29sKCUyMi5ja3B0JTIyJTIwaW4lMjBtb2RlbF9hcmdzLm1vZGVsX25hbWVfb3JfcGF0aCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWclM0Rjb25maWclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWNoZV9kaXIlM0Rtb2RlbF9hcmdzLmNhY2hlX2RpciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldmlzaW9uJTNEbW9kZWxfYXJncy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuJTNEVHJ1ZSUyMGlmJTIwbW9kZWxfYXJncy51c2VfYXV0aF90b2tlbiUyMGVsc2UlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">model_init</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> AutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>        model_args.model_name_or_path,
<span class="hljs-meta">... </span>        from_tf=<span class="hljs-built_in">bool</span>(<span class="hljs-string">&quot;.ckpt&quot;</span> <span class="hljs-keyword">in</span> model_args.model_name_or_path),
<span class="hljs-meta">... </span>        config=config,
<span class="hljs-meta">... </span>        cache_dir=model_args.cache_dir,
<span class="hljs-meta">... </span>        revision=model_args.model_revision,
<span class="hljs-meta">... </span>        token=<span class="hljs-literal">True</span> <span class="hljs-keyword">if</span> model_args.use_auth_token <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    )`,wrap:!1}}),H=new T({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEc21hbGxfdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHNtYWxsX2V2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2luaXQlM0Rtb2RlbF9pbml0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=<span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=small_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=small_eval_dataset,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>    tokenizer=tokenizer,
<span class="hljs-meta">... </span>    model_init=model_init,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>)`,wrap:!1}}),G=new T({props:{code:"YmVzdF90cmlhbCUyMCUzRCUyMHRyYWluZXIuaHlwZXJwYXJhbWV0ZXJfc2VhcmNoKCUwQSUyMCUyMCUyMCUyMGRpcmVjdGlvbiUzRCUyMm1heGltaXplJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmFja2VuZCUzRCUyMm9wdHVuYSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhwX3NwYWNlJTNEb3B0dW5hX2hwX3NwYWNlJTJDJTBBJTIwJTIwJTIwJTIwbl90cmlhbHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfb2JqZWN0aXZlJTNEY29tcHV0ZV9vYmplY3RpdmUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>best_trial = trainer.hyperparameter_search(
<span class="hljs-meta">... </span>    direction=<span class="hljs-string">&quot;maximize&quot;</span>,
<span class="hljs-meta">... </span>    backend=<span class="hljs-string">&quot;optuna&quot;</span>,
<span class="hljs-meta">... </span>    hp_space=optuna_hp_space,
<span class="hljs-meta">... </span>    n_trials=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    compute_objective=compute_objective,
<span class="hljs-meta">... </span>)`,wrap:!1}}),N=new Cs({props:{title:"Hyperparameter search For DDP finetune",local:"hyperparameter-search-for-ddp-finetune",headingTag:"h2"}}),R=new Ds({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/hpo_train.md"}}),{c(){J=p("meta"),z=l(),F=p("p"),E=l(),i(u.$$.fragment),D=l(),j=p("p"),j.innerHTML=gs,L=l(),i(w.$$.fragment),P=l(),U=p("p"),U.innerHTML=_s,K=l(),d=p("p"),d.textContent=$s,O=l(),i(f.$$.fragment),ss=l(),i(I.$$.fragment),as=l(),C=p("p"),C.textContent=qs,es=l(),b=p("p"),b.innerHTML=vs,ts=l(),i(g.$$.fragment),ls=l(),_=p("p"),_.innerHTML=Xs,ns=l(),i($.$$.fragment),ps=l(),q=p("p"),q.innerHTML=Ws,rs=l(),i(v.$$.fragment),is=l(),X=p("p"),X.innerHTML=Ys,os=l(),i(W.$$.fragment),ms=l(),Y=p("p"),Y.innerHTML=ks,cs=l(),i(k.$$.fragment),ys=l(),B=p("p"),B.innerHTML=Bs,Ms=l(),i(Z.$$.fragment),hs=l(),V=p("p"),V.innerHTML=Zs,Js=l(),i(H.$$.fragment),Ts=l(),Q=p("p"),Q.innerHTML=Vs,us=l(),A=p("p"),A.textContent=Hs,js=l(),i(G.$$.fragment),ws=l(),i(N.$$.fragment),Us=l(),x=p("p"),x.textContent=Qs,ds=l(),i(R.$$.fragment),fs=l(),S=p("p"),this.h()},l(s){const a=zs("svelte-u9bgzb",document.head);J=r(a,"META",{name:!0,content:!0}),a.forEach(e),z=n(s),F=r(s,"P",{}),As(F).forEach(e),E=n(s),o(u.$$.fragment,s),D=n(s),j=r(s,"P",{"data-svelte-h":!0}),m(j)!=="svelte-f97ygm"&&(j.innerHTML=gs),L=n(s),o(w.$$.fragment,s),P=n(s),U=r(s,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1ohwhsv"&&(U.innerHTML=_s),K=n(s),d=r(s,"P",{"data-svelte-h":!0}),m(d)!=="svelte-ttiwiu"&&(d.textContent=$s),O=n(s),o(f.$$.fragment,s),ss=n(s),o(I.$$.fragment,s),as=n(s),C=r(s,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1jwax0f"&&(C.textContent=qs),es=n(s),b=r(s,"P",{"data-svelte-h":!0}),m(b)!=="svelte-dng8fq"&&(b.innerHTML=vs),ts=n(s),o(g.$$.fragment,s),ls=n(s),_=r(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1o2m9k6"&&(_.innerHTML=Xs),ns=n(s),o($.$$.fragment,s),ps=n(s),q=r(s,"P",{"data-svelte-h":!0}),m(q)!=="svelte-e3s4e6"&&(q.innerHTML=Ws),rs=n(s),o(v.$$.fragment,s),is=n(s),X=r(s,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1fs958e"&&(X.innerHTML=Ys),os=n(s),o(W.$$.fragment,s),ms=n(s),Y=r(s,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-uzyw2c"&&(Y.innerHTML=ks),cs=n(s),o(k.$$.fragment,s),ys=n(s),B=r(s,"P",{"data-svelte-h":!0}),m(B)!=="svelte-x361dg"&&(B.innerHTML=Bs),Ms=n(s),o(Z.$$.fragment,s),hs=n(s),V=r(s,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1pp9odx"&&(V.innerHTML=Zs),Js=n(s),o(H.$$.fragment,s),Ts=n(s),Q=r(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-rd47zq"&&(Q.innerHTML=Vs),us=n(s),A=r(s,"P",{"data-svelte-h":!0}),m(A)!=="svelte-v9khww"&&(A.textContent=Hs),js=n(s),o(G.$$.fragment,s),ws=n(s),o(N.$$.fragment,s),Us=n(s),x=r(s,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1ib1l1l"&&(x.textContent=Qs),ds=n(s),o(R.$$.fragment,s),fs=n(s),S=r(s,"P",{}),As(S).forEach(e),this.h()},h(){Gs(J,"name","hf:doc:metadata"),Gs(J,"content",Ps)},m(s,a){Es(document.head,J),t(s,z,a),t(s,F,a),t(s,E,a),c(u,s,a),t(s,D,a),t(s,j,a),t(s,L,a),c(w,s,a),t(s,P,a),t(s,U,a),t(s,K,a),t(s,d,a),t(s,O,a),c(f,s,a),t(s,ss,a),c(I,s,a),t(s,as,a),t(s,C,a),t(s,es,a),t(s,b,a),t(s,ts,a),c(g,s,a),t(s,ls,a),t(s,_,a),t(s,ns,a),c($,s,a),t(s,ps,a),t(s,q,a),t(s,rs,a),c(v,s,a),t(s,is,a),t(s,X,a),t(s,os,a),c(W,s,a),t(s,ms,a),t(s,Y,a),t(s,cs,a),c(k,s,a),t(s,ys,a),t(s,B,a),t(s,Ms,a),c(Z,s,a),t(s,hs,a),t(s,V,a),t(s,Js,a),c(H,s,a),t(s,Ts,a),t(s,Q,a),t(s,us,a),t(s,A,a),t(s,js,a),c(G,s,a),t(s,ws,a),c(N,s,a),t(s,Us,a),t(s,x,a),t(s,ds,a),c(R,s,a),t(s,fs,a),t(s,S,a),Is=!0},p:xs,i(s){Is||(y(u.$$.fragment,s),y(w.$$.fragment,s),y(f.$$.fragment,s),y(I.$$.fragment,s),y(g.$$.fragment,s),y($.$$.fragment,s),y(v.$$.fragment,s),y(W.$$.fragment,s),y(k.$$.fragment,s),y(Z.$$.fragment,s),y(H.$$.fragment,s),y(G.$$.fragment,s),y(N.$$.fragment,s),y(R.$$.fragment,s),Is=!0)},o(s){M(u.$$.fragment,s),M(w.$$.fragment,s),M(f.$$.fragment,s),M(I.$$.fragment,s),M(g.$$.fragment,s),M($.$$.fragment,s),M(v.$$.fragment,s),M(W.$$.fragment,s),M(k.$$.fragment,s),M(Z.$$.fragment,s),M(H.$$.fragment,s),M(G.$$.fragment,s),M(N.$$.fragment,s),M(R.$$.fragment,s),Is=!1},d(s){s&&(e(z),e(F),e(E),e(D),e(j),e(L),e(P),e(U),e(K),e(d),e(O),e(ss),e(as),e(C),e(es),e(b),e(ts),e(ls),e(_),e(ns),e(ps),e(q),e(rs),e(is),e(X),e(os),e(ms),e(Y),e(cs),e(ys),e(B),e(Ms),e(hs),e(V),e(Js),e(Ts),e(Q),e(us),e(A),e(js),e(ws),e(Us),e(x),e(ds),e(fs),e(S)),e(J),h(u,s),h(w,s),h(f,s),h(I,s),h(g,s),h($,s),h(v,s),h(W,s),h(k,s),h(Z,s),h(H,s),h(G,s),h(N,s),h(R,s)}}}const Ps='{"title":"Hyperparameter Search using Trainer API","local":"hyperparameter-search-using-trainer-api","sections":[{"title":"Hyperparameter Search backend","local":"hyperparameter-search-backend","sections":[],"depth":2},{"title":"How to enable Hyperparameter search in example","local":"how-to-enable-hyperparameter-search-in-example","sections":[],"depth":2},{"title":"Hyperparameter search For DDP finetune","local":"hyperparameter-search-for-ddp-finetune","sections":[],"depth":2}],"depth":1}';function Ks(bs){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ta extends Fs{constructor(J){super(),Ss(this,J,Ks,Ls,Ns,{})}}export{ta as component};
