import{s as Io,o as Bo,n as Oe}from"../chunks/scheduler.25b97de1.js";import{S as Lo,i as Go,g as i,s,r as m,A as No,h as c,f as o,c as n,j,u as h,x as T,k as J,y as a,a as r,v as f,d as u,t as g,w as _}from"../chunks/index.d9030fc9.js";import{T as lo}from"../chunks/Tip.baa67368.js";import{D as z}from"../chunks/Docstring.ffac8efa.js";import{C as zt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Vo}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as B,E as Ro}from"../chunks/EditOnGithub.91d95064.js";function Eo(U){let l,v=`This model is in maintenance mode only, we don’t accept any new PRs changing its code.
If you run into any issues running this model, please reinstall the last version that supported this model: v4.40.2.
You can do so by running the following command: <code>pip install -U transformers==4.40.2</code>.`;return{c(){l=i("p"),l.innerHTML=v},l(p){l=c(p,"P",{"data-svelte-h":!0}),T(l)!=="svelte-1ai9jvr"&&(l.innerHTML=v)},m(p,y){r(p,l,y)},p:Oe,d(p){p&&o(l)}}}function Ho(U){let l,v="Example:",p,y,x;return y=new zt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaDJUZXh0MkNvbmZpZyUyQyUyMFNwZWVjaDJUZXh0MkZvckNhdXNhbExNJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFNwZWVjaDJUZXh0MiUyMHMydF90cmFuc2Zvcm1lcl9zJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFNwZWVjaDJUZXh0MkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBzMnRfdHJhbnNmb3JtZXJfcyUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwU3BlZWNoMlRleHQyRm9yQ2F1c2FsTE0oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Speech2Text2Config, Speech2Text2ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Speech2Text2 s2t_transformer_s style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Speech2Text2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the s2t_transformer_s style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Speech2Text2ForCausalLM(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=i("p"),l.textContent=v,p=s(),m(y.$$.fragment)},l(d){l=c(d,"P",{"data-svelte-h":!0}),T(l)!=="svelte-11lpom8"&&(l.textContent=v),p=n(d),h(y.$$.fragment,d)},m(d,M){r(d,l,M),r(d,p,M),f(y,d,M),x=!0},p:Oe,i(d){x||(u(y.$$.fragment,d),x=!0)},o(d){g(y.$$.fragment,d),x=!1},d(d){d&&(o(l),o(p)),_(y,d)}}}function qo(U){let l,v=`This class method is simply calling the feature extractor
<a href="/docs/transformers/pr_30530/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/pr_30530/en/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){l=i("p"),l.innerHTML=v},l(p){l=c(p,"P",{"data-svelte-h":!0}),T(l)!=="svelte-f5ymql"&&(l.innerHTML=v)},m(p,y){r(p,l,y)},p:Oe,d(p){p&&o(l)}}}function Po(U){let l,v=`This class method is simply calling <a href="/docs/transformers/pr_30530/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){l=i("p"),l.innerHTML=v},l(p){l=c(p,"P",{"data-svelte-h":!0}),T(l)!=="svelte-7uu6ns"&&(l.innerHTML=v)},m(p,y){r(p,l,y)},p:Oe,d(p){p&&o(l)}}}function Xo(U){let l,v="Example:",p,y,x;return y=new zt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SpeechEncoderDecoderModel,
<span class="hljs-meta">... </span>    Speech2Text2ForCausalLM,
<span class="hljs-meta">... </span>    Wav2Vec2Model,
<span class="hljs-meta">... </span>    Speech2Text2Config,
<span class="hljs-meta">... </span>    Wav2Vec2Config,
<span class="hljs-meta">... </span>    Wav2Vec2FeatureExtractor,
<span class="hljs-meta">... </span>    Speech2Text2Tokenizer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = Wav2Vec2FeatureExtractor()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = Speech2Text2Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder = Wav2Vec2Model(Wav2Vec2Config())
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = Speech2Text2ForCausalLM(Speech2Text2Config())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># init random speech2text model</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel(encoder=encoder, decoder=decoder)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = tokenizer.pad_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.decoder_start_token_id = tokenizer.bos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># pre-process inputs and labels</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = inputs.input_values
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(inputs=input_values, labels=decoder_input_ids).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># backprop loss</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()`,wrap:!1}}),{c(){l=i("p"),l.textContent=v,p=s(),m(y.$$.fragment)},l(d){l=c(d,"P",{"data-svelte-h":!0}),T(l)!=="svelte-11lpom8"&&(l.textContent=v),p=n(d),h(y.$$.fragment,d)},m(d,M){r(d,l,M),r(d,p,M),f(y,d,M),x=!0},p:Oe,i(d){x||(u(y.$$.fragment,d),x=!0)},o(d){g(y.$$.fragment,d),x=!1},d(d){d&&(o(l),o(p)),_(y,d)}}}function Yo(U){let l,v,p,y,x,d,M,Ke,Q,et,D,io=`The Speech2Text2 model is used together with <a href="wav2vec2">Wav2Vec2</a> for Speech Translation models proposed in
<a href="https://arxiv.org/abs/2104.06678" rel="nofollow">Large-Scale Self- and Semi-Supervised Learning for Speech Translation</a> by
Changhan Wang, Anne Wu, Juan Pino, Alexei Baevski, Michael Auli, Alexis Conneau.`,tt,A,co=`Speech2Text2 is a <em>decoder-only</em> transformer model that can be used with any speech <em>encoder-only</em>, such as
<a href="wav2vec2">Wav2Vec2</a> or <a href="hubert">HuBERT</a> for Speech-to-Text tasks. Please refer to the
<a href="speech-encoder-decoder">SpeechEncoderDecoder</a> class on how to combine Speech2Text2 with any speech <em>encoder-only</em>
model.`,ot,O,po='This model was contributed by <a href="https://huggingface.co/patrickvonplaten" rel="nofollow">Patrick von Platen</a>.',st,K,mo='The original code can be found <a href="https://github.com/pytorch/fairseq/blob/1f7ef9ed1e1061f8c7f88f8b94c7186834398690/fairseq/models/wav2vec/wav2vec2_asr.py#L266" rel="nofollow">here</a>.',nt,ee,at,te,ho=`<li>Speech2Text2 achieves state-of-the-art results on the CoVoST Speech Translation dataset. For more information, see
the <a href="https://huggingface.co/models?other=speech2text2" rel="nofollow">official models</a> .</li> <li>Speech2Text2 is always used within the <a href="speech-encoder-decoder">SpeechEncoderDecoder</a> framework.</li> <li>Speech2Text2’s tokenizer is based on <a href="https://github.com/glample/fastBPE" rel="nofollow">fastBPE</a>.</li>`,rt,oe,lt,se,fo=`Speech2Text2’s <a href="/docs/transformers/pr_30530/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a> model accepts raw waveform input values from speech and
makes use of <a href="/docs/transformers/pr_30530/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> to translate the input speech
autoregressively to the target language.`,it,ne,uo=`The <a href="/docs/transformers/pr_30530/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> class is responsible for preprocessing the input speech and
<a href="/docs/transformers/pr_30530/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a> decodes the generated target tokens to the target string. The
<a href="/docs/transformers/pr_30530/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor">Speech2Text2Processor</a> wraps <a href="/docs/transformers/pr_30530/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> and
<a href="/docs/transformers/pr_30530/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a> into a single instance to both extract the input features and decode the
predicted token ids.`,ct,ae,go="<li>Step-by-step Speech Translation</li>",dt,re,pt,le,_o="<li><p>Speech Translation via Pipelines</p> <p>The automatic speech recognition pipeline can also be used to translate speech in just a couple lines of code</p></li>",mt,ie,ht,ce,To='See <a href="https://huggingface.co/models?filter=speech2text2" rel="nofollow">model hub</a> to look for Speech2Text2 checkpoints.',ft,de,ut,pe,yo='<li><a href="../tasks/language_modeling">Causal language modeling task guide</a></li>',gt,me,_t,C,he,Ut,ze,bo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30530/en/model_doc/speech_to_text_2#transformers.Speech2Text2ForCausalLM">Speech2Text2ForCausalLM</a>. It is used to
instantiate an Speech2Text2 model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the Speech2Text2
<a href="https://huggingface.co/facebook/s2t-wav2vec2-large-en-de" rel="nofollow">facebook/s2t-wav2vec2-large-en-de</a> architecture.`,Zt,Ue,vo=`Configuration objects inherit from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Wt,L,Tt,fe,yt,k,ue,Ft,Ze,xo="Constructs a Speech2Text2Tokenizer.",Vt,We,ko=`This tokenizer inherits from <a href="/docs/transformers/pr_30530/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains some of the main methods. Users should refer to
the superclass for more information regarding such methods.`,It,G,ge,Bt,Fe,Mo="Convert a list of lists of token ids into a list of strings by calling decode.",Lt,W,_e,Gt,Ve,wo=`Converts a sequence of ids in a string, using the tokenizer and vocabulary with options to remove special
tokens and clean up tokenization spaces.`,Nt,Ie,$o="Similar to doing <code>self.convert_tokens_to_string(self.convert_ids_to_tokens(token_ids))</code>.",Rt,Be,Te,bt,ye,vt,b,be,Et,Le,jo=`Constructs a Speech2Text2 processor which wraps a Speech2Text2 feature extractor and a Speech2Text2 tokenizer into
a single processor.`,Ht,Ge,Jo=`<a href="/docs/transformers/pr_30530/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor">Speech2Text2Processor</a> offers all the functionalities of <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a> and <a href="/docs/transformers/pr_30530/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a>.
See the <a href="/docs/transformers/pr_30530/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor.__call__"><strong>call</strong>()</a> and <a href="/docs/transformers/pr_30530/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor.decode">decode()</a> for more information.`,qt,N,ve,Pt,Ne,Co=`When used in normal mode, this method forwards all its arguments to AutoFeatureExtractor’s
<code>__call__()</code> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to
Speech2Text2Tokenizer’s <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a>. Please refer to the doctsring of the above two
methods for more information.`,Xt,F,xe,Yt,Re,So="Instantiate a processor associated with a pretrained model.",Qt,R,Dt,V,ke,At,Ee,zo=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/pr_30530/en/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,Ot,E,Kt,H,Me,eo,He,Uo=`This method forwards all its arguments to Speech2Text2Tokenizer’s <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,to,q,we,oo,qe,Zo=`This method forwards all its arguments to Speech2Text2Tokenizer’s <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer
to the docstring of this method for more information.`,xt,$e,kt,S,je,so,Pe,Wo=`The Speech2Text2 Decoder with a language modeling head. Can be used as the decoder part of <a href="/docs/transformers/pr_30530/en/model_doc/encoder-decoder#transformers.EncoderDecoderModel">EncoderDecoderModel</a> and <code>SpeechEncoderDecoder</code>.
This model inherits from <a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,no,Xe,Fo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ao,P,Je,ro,X,Mt,Ce,wt,De,$t;return x=new B({props:{title:"Speech2Text2",local:"speech2text2",headingTag:"h1"}}),M=new lo({props:{warning:!0,$$slots:{default:[Eo]},$$scope:{ctx:U}}}),Q=new B({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ee=new B({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),oe=new B({props:{title:"Inference",local:"inference",headingTag:"h2"}}),re=new zt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwU3BlZWNoMlRleHQyUHJvY2Vzc29yJTJDJTIwU3BlZWNoRW5jb2RlckRlY29kZXJNb2RlbCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHNvdW5kZmlsZSUyMGFzJTIwc2YlMEElMEFtb2RlbCUyMCUzRCUyMFNwZWVjaEVuY29kZXJEZWNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGczJ0LXdhdjJ2ZWMyLWxhcmdlLWVuLWRlJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaDJUZXh0MlByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZzMnQtd2F2MnZlYzItbGFyZ2UtZW4tZGUlMjIpJTBBJTBBJTBBZGVmJTIwbWFwX3RvX2FycmF5KGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMHNwZWVjaCUyQyUyMF8lMjAlM0QlMjBzZi5yZWFkKGJhdGNoJTVCJTIyZmlsZSUyMiU1RCklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnNwZWVjaCUyMiU1RCUyMCUzRCUyMHNwZWVjaCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNoJTBBJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRzJTIwJTNEJTIwZHMubWFwKG1hcF90b19hcnJheSklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIlMjJzcGVlY2glMjIlNUQlNUIwJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0cyU1QiUyMmlucHV0X3ZhbHVlcyUyMiU1RCUyQyUyMGF0dGVudGlvbl9tYXNrJTNEaW5wdXRzJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlNUQpJTBBJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Speech2Text2Processor, SpeechEncoderDecoderModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Speech2Text2Processor.from_pretrained(<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], sampling_rate=<span class="hljs-number">16_000</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=inputs[<span class="hljs-string">&quot;input_values&quot;</span>], attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids)`,wrap:!1}}),ie=new zt({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbGlicmlzcGVlY2hfZW4lMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWFzciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGczJ0LXdhdjJ2ZWMyLWxhcmdlLWVuLWRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0QlMjJmYWNlYm9vayUyRnMydC13YXYydmVjMi1sYXJnZS1lbi1kZSUyMiUyQyUwQSklMEElMEF0cmFuc2xhdGlvbl9kZSUyMCUzRCUyMGFzcihsaWJyaXNwZWVjaF9lbiU1QjAlNUQlNUIlMjJmaWxlJTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>librispeech_en = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>asr = pipeline(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>,
<span class="hljs-meta">... </span>    feature_extractor=<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translation_de = asr(librispeech_en[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;file&quot;</span>])`,wrap:!1}}),de=new B({props:{title:"Resources",local:"resources",headingTag:"h2"}}),me=new B({props:{title:"Speech2Text2Config",local:"transformers.Speech2Text2Config",headingTag:"h2"}}),he=new z({props:{name:"class transformers.Speech2Text2Config",anchor:"transformers.Speech2Text2Config",parameters:[{name:"vocab_size",val:" = 10000"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 4"},{name:"decoder_layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"decoder_start_token_id",val:" = 2"},{name:"scale_embedding",val:" = True"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"max_target_positions",val:" = 1024"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50265) &#x2014;
Vocabulary size of the Speech2Text model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30530/en/model_doc/speech_to_text#transformers.Speech2TextModel">Speech2TextModel</a>`,name:"vocab_size"},{anchor:"transformers.Speech2Text2Config.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.Speech2Text2Config.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.Speech2Text2Config.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.Speech2Text2Config.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.Speech2Text2Config.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the pooler. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.Speech2Text2Config.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, and pooler.`,name:"dropout"},{anchor:"transformers.Speech2Text2Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Speech2Text2Config.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.Speech2Text2Config.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.
<a href="https://arxiv.org/abs/1909.11556%3E%60" rel="nofollow">https://arxiv.org/abs/1909.11556&gt;\`</a>__ for more details.`,name:"init_std"},{anchor:"transformers.Speech2Text2Config.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.Speech2Text2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.Speech2Text2Config.max_target_positions",description:`<strong>max_target_positions</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_target_positions"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/deprecated/speech_to_text_2/configuration_speech_to_text_2.py#L24"}}),L=new Vo({props:{anchor:"transformers.Speech2Text2Config.example",$$slots:{default:[Ho]},$$scope:{ctx:U}}}),fe=new B({props:{title:"Speech2TextTokenizer",local:"transformers.Speech2Text2Tokenizer",headingTag:"h2"}}),ue=new z({props:{name:"class transformers.Speech2Text2Tokenizer",anchor:"transformers.Speech2Text2Tokenizer",parameters:[{name:"vocab_file",val:""},{name:"bos_token",val:" = '<s>'"},{name:"pad_token",val:" = '<pad>'"},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"do_lower_case",val:" = False"},{name:"merges_file",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Tokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.Speech2Text2Tokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sentence token.`,name:"bos_token"},{anchor:"transformers.Speech2Text2Tokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sentence token.`,name:"eos_token"},{anchor:"transformers.Speech2Text2Tokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.Speech2Text2Tokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.Speech2Text2Tokenizer.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments passed along to <a href="/docs/transformers/pr_30530/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>`,name:"*kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/deprecated/speech_to_text_2/tokenization_speech_to_text_2.py#L55"}}),ge=new z({props:{name:"batch_decode",anchor:"transformers.Speech2Text2Tokenizer.batch_decode",parameters:[{name:"sequences",val:": typing.Union[typing.List[int], typing.List[typing.List[int]], ForwardRef('np.ndarray'), ForwardRef('torch.Tensor'), ForwardRef('tf.Tensor')]"},{name:"skip_special_tokens",val:": bool = False"},{name:"clean_up_tokenization_spaces",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Tokenizer.batch_decode.sequences",description:`<strong>sequences</strong> (<code>Union[List[int], List[List[int]], np.ndarray, torch.Tensor, tf.Tensor]</code>) &#x2014;
List of tokenized input ids. Can be obtained using the <code>__call__</code> method.`,name:"sequences"},{anchor:"transformers.Speech2Text2Tokenizer.batch_decode.skip_special_tokens",description:`<strong>skip_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to remove special tokens in the decoding.`,name:"skip_special_tokens"},{anchor:"transformers.Speech2Text2Tokenizer.batch_decode.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to clean up the tokenization spaces. If <code>None</code>, will default to
<code>self.clean_up_tokenization_spaces</code>.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.Speech2Text2Tokenizer.batch_decode.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the underlying model specific decode method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/tokenization_utils_base.py#L3783",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of decoded sentences.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),_e=new z({props:{name:"decode",anchor:"transformers.Speech2Text2Tokenizer.decode",parameters:[{name:"token_ids",val:": typing.Union[int, typing.List[int], ForwardRef('np.ndarray'), ForwardRef('torch.Tensor'), ForwardRef('tf.Tensor')]"},{name:"skip_special_tokens",val:": bool = False"},{name:"clean_up_tokenization_spaces",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Tokenizer.decode.token_ids",description:`<strong>token_ids</strong> (<code>Union[int, List[int], np.ndarray, torch.Tensor, tf.Tensor]</code>) &#x2014;
List of tokenized input ids. Can be obtained using the <code>__call__</code> method.`,name:"token_ids"},{anchor:"transformers.Speech2Text2Tokenizer.decode.skip_special_tokens",description:`<strong>skip_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to remove special tokens in the decoding.`,name:"skip_special_tokens"},{anchor:"transformers.Speech2Text2Tokenizer.decode.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to clean up the tokenization spaces. If <code>None</code>, will default to
<code>self.clean_up_tokenization_spaces</code>.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.Speech2Text2Tokenizer.decode.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the underlying model specific decode method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/tokenization_utils_base.py#L3817",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The decoded sentence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Te=new z({props:{name:"save_vocabulary",anchor:"transformers.Speech2Text2Tokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/deprecated/speech_to_text_2/tokenization_speech_to_text_2.py#L220"}}),ye=new B({props:{title:"Speech2Text2Processor",local:"transformers.Speech2Text2Processor",headingTag:"h2"}}),be=new z({props:{name:"class transformers.Speech2Text2Processor",anchor:"transformers.Speech2Text2Processor",parameters:[{name:"feature_extractor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Processor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>AutoFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.Speech2Text2Processor.tokenizer",description:`<strong>tokenizer</strong> (<code>Speech2Text2Tokenizer</code>) &#x2014;
An instance of <a href="/docs/transformers/pr_30530/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/deprecated/speech_to_text_2/processing_speech_to_text_2.py#L25"}}),ve=new z({props:{name:"__call__",anchor:"transformers.Speech2Text2Processor.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/deprecated/speech_to_text_2/processing_speech_to_text_2.py#L48"}}),xe=new z({props:{name:"from_pretrained",anchor:"transformers.Speech2Text2Processor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike]"},{name:"cache_dir",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Processor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/pr_30530/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.Speech2Text2Processor.from_pretrained.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/pr_30530/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.`,name:"*kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/processing_utils.py#L915"}}),R=new lo({props:{$$slots:{default:[qo]},$$scope:{ctx:U}}}),ke=new z({props:{name:"save_pretrained",anchor:"transformers.Speech2Text2Processor.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Processor.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.Speech2Text2Processor.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.Speech2Text2Processor.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/processing_utils.py#L459"}}),E=new lo({props:{$$slots:{default:[Po]},$$scope:{ctx:U}}}),Me=new z({props:{name:"batch_decode",anchor:"transformers.Speech2Text2Processor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/deprecated/speech_to_text_2/processing_speech_to_text_2.py#L87"}}),we=new z({props:{name:"decode",anchor:"transformers.Speech2Text2Processor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/deprecated/speech_to_text_2/processing_speech_to_text_2.py#L94"}}),$e=new B({props:{title:"Speech2Text2ForCausalLM",local:"transformers.Speech2Text2ForCausalLM",headingTag:"h2"}}),je=new z({props:{name:"class transformers.Speech2Text2ForCausalLM",anchor:"transformers.Speech2Text2ForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2ForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30530/en/model_doc/speech_to_text_2#transformers.Speech2Text2Config">Speech2Text2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/deprecated/speech_to_text_2/modeling_speech_to_text_2.py#L685"}}),Je=new z({props:{name:"forward",anchor:"transformers.Speech2Text2ForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Speech2Text2ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you
provide it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong>  (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention
if the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used
in the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:`,name:"encoder_attention_mask"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of
shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>. The two additional
tensors are only required when the model is used as a decoder in a Sequence to Sequence model.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the
cross-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those
that don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of
all <code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding
(see <code>past_key_values</code>).</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"use_cache"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/deprecated/speech_to_text_2/modeling_speech_to_text_2.py#L723",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30530/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30530/en/model_doc/speech_to_text_2#transformers.Speech2Text2Config"
>Speech2Text2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30530/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new Vo({props:{anchor:"transformers.Speech2Text2ForCausalLM.forward.example",$$slots:{default:[Xo]},$$scope:{ctx:U}}}),Ce=new Ro({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/speech_to_text_2.md"}}),{c(){l=i("meta"),v=s(),p=i("p"),y=s(),m(x.$$.fragment),d=s(),m(M.$$.fragment),Ke=s(),m(Q.$$.fragment),et=s(),D=i("p"),D.innerHTML=io,tt=s(),A=i("p"),A.innerHTML=co,ot=s(),O=i("p"),O.innerHTML=po,st=s(),K=i("p"),K.innerHTML=mo,nt=s(),m(ee.$$.fragment),at=s(),te=i("ul"),te.innerHTML=ho,rt=s(),m(oe.$$.fragment),lt=s(),se=i("p"),se.innerHTML=fo,it=s(),ne=i("p"),ne.innerHTML=uo,ct=s(),ae=i("ul"),ae.innerHTML=go,dt=s(),m(re.$$.fragment),pt=s(),le=i("ul"),le.innerHTML=_o,mt=s(),m(ie.$$.fragment),ht=s(),ce=i("p"),ce.innerHTML=To,ft=s(),m(de.$$.fragment),ut=s(),pe=i("ul"),pe.innerHTML=yo,gt=s(),m(me.$$.fragment),_t=s(),C=i("div"),m(he.$$.fragment),Ut=s(),ze=i("p"),ze.innerHTML=bo,Zt=s(),Ue=i("p"),Ue.innerHTML=vo,Wt=s(),m(L.$$.fragment),Tt=s(),m(fe.$$.fragment),yt=s(),k=i("div"),m(ue.$$.fragment),Ft=s(),Ze=i("p"),Ze.textContent=xo,Vt=s(),We=i("p"),We.innerHTML=ko,It=s(),G=i("div"),m(ge.$$.fragment),Bt=s(),Fe=i("p"),Fe.textContent=Mo,Lt=s(),W=i("div"),m(_e.$$.fragment),Gt=s(),Ve=i("p"),Ve.textContent=wo,Nt=s(),Ie=i("p"),Ie.innerHTML=$o,Rt=s(),Be=i("div"),m(Te.$$.fragment),bt=s(),m(ye.$$.fragment),vt=s(),b=i("div"),m(be.$$.fragment),Et=s(),Le=i("p"),Le.textContent=jo,Ht=s(),Ge=i("p"),Ge.innerHTML=Jo,qt=s(),N=i("div"),m(ve.$$.fragment),Pt=s(),Ne=i("p"),Ne.innerHTML=Co,Xt=s(),F=i("div"),m(xe.$$.fragment),Yt=s(),Re=i("p"),Re.textContent=So,Qt=s(),m(R.$$.fragment),Dt=s(),V=i("div"),m(ke.$$.fragment),At=s(),Ee=i("p"),Ee.innerHTML=zo,Ot=s(),m(E.$$.fragment),Kt=s(),H=i("div"),m(Me.$$.fragment),eo=s(),He=i("p"),He.innerHTML=Uo,to=s(),q=i("div"),m(we.$$.fragment),oo=s(),qe=i("p"),qe.innerHTML=Zo,xt=s(),m($e.$$.fragment),kt=s(),S=i("div"),m(je.$$.fragment),so=s(),Pe=i("p"),Pe.innerHTML=Wo,no=s(),Xe=i("p"),Xe.innerHTML=Fo,ao=s(),P=i("div"),m(Je.$$.fragment),ro=s(),m(X.$$.fragment),Mt=s(),m(Ce.$$.fragment),wt=s(),De=i("p"),this.h()},l(e){const t=No("svelte-u9bgzb",document.head);l=c(t,"META",{name:!0,content:!0}),t.forEach(o),v=n(e),p=c(e,"P",{}),j(p).forEach(o),y=n(e),h(x.$$.fragment,e),d=n(e),h(M.$$.fragment,e),Ke=n(e),h(Q.$$.fragment,e),et=n(e),D=c(e,"P",{"data-svelte-h":!0}),T(D)!=="svelte-1q6drml"&&(D.innerHTML=io),tt=n(e),A=c(e,"P",{"data-svelte-h":!0}),T(A)!=="svelte-iqjgnk"&&(A.innerHTML=co),ot=n(e),O=c(e,"P",{"data-svelte-h":!0}),T(O)!=="svelte-pps277"&&(O.innerHTML=po),st=n(e),K=c(e,"P",{"data-svelte-h":!0}),T(K)!=="svelte-1u4lnwc"&&(K.innerHTML=mo),nt=n(e),h(ee.$$.fragment,e),at=n(e),te=c(e,"UL",{"data-svelte-h":!0}),T(te)!=="svelte-1gpn7jr"&&(te.innerHTML=ho),rt=n(e),h(oe.$$.fragment,e),lt=n(e),se=c(e,"P",{"data-svelte-h":!0}),T(se)!=="svelte-1d6rd82"&&(se.innerHTML=fo),it=n(e),ne=c(e,"P",{"data-svelte-h":!0}),T(ne)!=="svelte-pkvfjq"&&(ne.innerHTML=uo),ct=n(e),ae=c(e,"UL",{"data-svelte-h":!0}),T(ae)!=="svelte-acy5fb"&&(ae.innerHTML=go),dt=n(e),h(re.$$.fragment,e),pt=n(e),le=c(e,"UL",{"data-svelte-h":!0}),T(le)!=="svelte-eepefx"&&(le.innerHTML=_o),mt=n(e),h(ie.$$.fragment,e),ht=n(e),ce=c(e,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-1lbi5m8"&&(ce.innerHTML=To),ft=n(e),h(de.$$.fragment,e),ut=n(e),pe=c(e,"UL",{"data-svelte-h":!0}),T(pe)!=="svelte-162aebv"&&(pe.innerHTML=yo),gt=n(e),h(me.$$.fragment,e),_t=n(e),C=c(e,"DIV",{class:!0});var Z=j(C);h(he.$$.fragment,Z),Ut=n(Z),ze=c(Z,"P",{"data-svelte-h":!0}),T(ze)!=="svelte-oahce5"&&(ze.innerHTML=bo),Zt=n(Z),Ue=c(Z,"P",{"data-svelte-h":!0}),T(Ue)!=="svelte-l1blo3"&&(Ue.innerHTML=vo),Wt=n(Z),h(L.$$.fragment,Z),Z.forEach(o),Tt=n(e),h(fe.$$.fragment,e),yt=n(e),k=c(e,"DIV",{class:!0});var $=j(k);h(ue.$$.fragment,$),Ft=n($),Ze=c($,"P",{"data-svelte-h":!0}),T(Ze)!=="svelte-16s7215"&&(Ze.textContent=xo),Vt=n($),We=c($,"P",{"data-svelte-h":!0}),T(We)!=="svelte-1f0sgk7"&&(We.innerHTML=ko),It=n($),G=c($,"DIV",{class:!0});var Se=j(G);h(ge.$$.fragment,Se),Bt=n(Se),Fe=c(Se,"P",{"data-svelte-h":!0}),T(Fe)!=="svelte-1deng2j"&&(Fe.textContent=Mo),Se.forEach(o),Lt=n($),W=c($,"DIV",{class:!0});var I=j(W);h(_e.$$.fragment,I),Gt=n(I),Ve=c(I,"P",{"data-svelte-h":!0}),T(Ve)!=="svelte-vbfkpu"&&(Ve.textContent=wo),Nt=n(I),Ie=c(I,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-125uxon"&&(Ie.innerHTML=$o),I.forEach(o),Rt=n($),Be=c($,"DIV",{class:!0});var Ae=j(Be);h(Te.$$.fragment,Ae),Ae.forEach(o),$.forEach(o),bt=n(e),h(ye.$$.fragment,e),vt=n(e),b=c(e,"DIV",{class:!0});var w=j(b);h(be.$$.fragment,w),Et=n(w),Le=c(w,"P",{"data-svelte-h":!0}),T(Le)!=="svelte-cccwan"&&(Le.textContent=jo),Ht=n(w),Ge=c(w,"P",{"data-svelte-h":!0}),T(Ge)!=="svelte-1nzepd3"&&(Ge.innerHTML=Jo),qt=n(w),N=c(w,"DIV",{class:!0});var jt=j(N);h(ve.$$.fragment,jt),Pt=n(jt),Ne=c(jt,"P",{"data-svelte-h":!0}),T(Ne)!=="svelte-uh0u3k"&&(Ne.innerHTML=Co),jt.forEach(o),Xt=n(w),F=c(w,"DIV",{class:!0});var Ye=j(F);h(xe.$$.fragment,Ye),Yt=n(Ye),Re=c(Ye,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-1cj8dcb"&&(Re.textContent=So),Qt=n(Ye),h(R.$$.fragment,Ye),Ye.forEach(o),Dt=n(w),V=c(w,"DIV",{class:!0});var Qe=j(V);h(ke.$$.fragment,Qe),At=n(Qe),Ee=c(Qe,"P",{"data-svelte-h":!0}),T(Ee)!=="svelte-cm80vy"&&(Ee.innerHTML=zo),Ot=n(Qe),h(E.$$.fragment,Qe),Qe.forEach(o),Kt=n(w),H=c(w,"DIV",{class:!0});var Jt=j(H);h(Me.$$.fragment,Jt),eo=n(Jt),He=c(Jt,"P",{"data-svelte-h":!0}),T(He)!=="svelte-1di8ftj"&&(He.innerHTML=Uo),Jt.forEach(o),to=n(w),q=c(w,"DIV",{class:!0});var Ct=j(q);h(we.$$.fragment,Ct),oo=n(Ct),qe=c(Ct,"P",{"data-svelte-h":!0}),T(qe)!=="svelte-1l8p69x"&&(qe.innerHTML=Zo),Ct.forEach(o),w.forEach(o),xt=n(e),h($e.$$.fragment,e),kt=n(e),S=c(e,"DIV",{class:!0});var Y=j(S);h(je.$$.fragment,Y),so=n(Y),Pe=c(Y,"P",{"data-svelte-h":!0}),T(Pe)!=="svelte-d1p9ej"&&(Pe.innerHTML=Wo),no=n(Y),Xe=c(Y,"P",{"data-svelte-h":!0}),T(Xe)!=="svelte-hswkmf"&&(Xe.innerHTML=Fo),ao=n(Y),P=c(Y,"DIV",{class:!0});var St=j(P);h(Je.$$.fragment,St),ro=n(St),h(X.$$.fragment,St),St.forEach(o),Y.forEach(o),Mt=n(e),h(Ce.$$.fragment,e),wt=n(e),De=c(e,"P",{}),j(De).forEach(o),this.h()},h(){J(l,"name","hf:doc:metadata"),J(l,"content",Qo),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,l),r(e,v,t),r(e,p,t),r(e,y,t),f(x,e,t),r(e,d,t),f(M,e,t),r(e,Ke,t),f(Q,e,t),r(e,et,t),r(e,D,t),r(e,tt,t),r(e,A,t),r(e,ot,t),r(e,O,t),r(e,st,t),r(e,K,t),r(e,nt,t),f(ee,e,t),r(e,at,t),r(e,te,t),r(e,rt,t),f(oe,e,t),r(e,lt,t),r(e,se,t),r(e,it,t),r(e,ne,t),r(e,ct,t),r(e,ae,t),r(e,dt,t),f(re,e,t),r(e,pt,t),r(e,le,t),r(e,mt,t),f(ie,e,t),r(e,ht,t),r(e,ce,t),r(e,ft,t),f(de,e,t),r(e,ut,t),r(e,pe,t),r(e,gt,t),f(me,e,t),r(e,_t,t),r(e,C,t),f(he,C,null),a(C,Ut),a(C,ze),a(C,Zt),a(C,Ue),a(C,Wt),f(L,C,null),r(e,Tt,t),f(fe,e,t),r(e,yt,t),r(e,k,t),f(ue,k,null),a(k,Ft),a(k,Ze),a(k,Vt),a(k,We),a(k,It),a(k,G),f(ge,G,null),a(G,Bt),a(G,Fe),a(k,Lt),a(k,W),f(_e,W,null),a(W,Gt),a(W,Ve),a(W,Nt),a(W,Ie),a(k,Rt),a(k,Be),f(Te,Be,null),r(e,bt,t),f(ye,e,t),r(e,vt,t),r(e,b,t),f(be,b,null),a(b,Et),a(b,Le),a(b,Ht),a(b,Ge),a(b,qt),a(b,N),f(ve,N,null),a(N,Pt),a(N,Ne),a(b,Xt),a(b,F),f(xe,F,null),a(F,Yt),a(F,Re),a(F,Qt),f(R,F,null),a(b,Dt),a(b,V),f(ke,V,null),a(V,At),a(V,Ee),a(V,Ot),f(E,V,null),a(b,Kt),a(b,H),f(Me,H,null),a(H,eo),a(H,He),a(b,to),a(b,q),f(we,q,null),a(q,oo),a(q,qe),r(e,xt,t),f($e,e,t),r(e,kt,t),r(e,S,t),f(je,S,null),a(S,so),a(S,Pe),a(S,no),a(S,Xe),a(S,ao),a(S,P),f(Je,P,null),a(P,ro),f(X,P,null),r(e,Mt,t),f(Ce,e,t),r(e,wt,t),r(e,De,t),$t=!0},p(e,[t]){const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),M.$set(Z);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),L.$set($);const Se={};t&2&&(Se.$$scope={dirty:t,ctx:e}),R.$set(Se);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),E.$set(I);const Ae={};t&2&&(Ae.$$scope={dirty:t,ctx:e}),X.$set(Ae)},i(e){$t||(u(x.$$.fragment,e),u(M.$$.fragment,e),u(Q.$$.fragment,e),u(ee.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(L.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(ge.$$.fragment,e),u(_e.$$.fragment,e),u(Te.$$.fragment,e),u(ye.$$.fragment,e),u(be.$$.fragment,e),u(ve.$$.fragment,e),u(xe.$$.fragment,e),u(R.$$.fragment,e),u(ke.$$.fragment,e),u(E.$$.fragment,e),u(Me.$$.fragment,e),u(we.$$.fragment,e),u($e.$$.fragment,e),u(je.$$.fragment,e),u(Je.$$.fragment,e),u(X.$$.fragment,e),u(Ce.$$.fragment,e),$t=!0)},o(e){g(x.$$.fragment,e),g(M.$$.fragment,e),g(Q.$$.fragment,e),g(ee.$$.fragment,e),g(oe.$$.fragment,e),g(re.$$.fragment,e),g(ie.$$.fragment,e),g(de.$$.fragment,e),g(me.$$.fragment,e),g(he.$$.fragment,e),g(L.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(Te.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g(R.$$.fragment,e),g(ke.$$.fragment,e),g(E.$$.fragment,e),g(Me.$$.fragment,e),g(we.$$.fragment,e),g($e.$$.fragment,e),g(je.$$.fragment,e),g(Je.$$.fragment,e),g(X.$$.fragment,e),g(Ce.$$.fragment,e),$t=!1},d(e){e&&(o(v),o(p),o(y),o(d),o(Ke),o(et),o(D),o(tt),o(A),o(ot),o(O),o(st),o(K),o(nt),o(at),o(te),o(rt),o(lt),o(se),o(it),o(ne),o(ct),o(ae),o(dt),o(pt),o(le),o(mt),o(ht),o(ce),o(ft),o(ut),o(pe),o(gt),o(_t),o(C),o(Tt),o(yt),o(k),o(bt),o(vt),o(b),o(xt),o(kt),o(S),o(Mt),o(wt),o(De)),o(l),_(x,e),_(M,e),_(Q,e),_(ee,e),_(oe,e),_(re,e),_(ie,e),_(de,e),_(me,e),_(he),_(L),_(fe,e),_(ue),_(ge),_(_e),_(Te),_(ye,e),_(be),_(ve),_(xe),_(R),_(ke),_(E),_(Me),_(we),_($e,e),_(je),_(Je),_(X),_(Ce,e)}}}const Qo='{"title":"Speech2Text2","local":"speech2text2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Speech2Text2Config","local":"transformers.Speech2Text2Config","sections":[],"depth":2},{"title":"Speech2TextTokenizer","local":"transformers.Speech2Text2Tokenizer","sections":[],"depth":2},{"title":"Speech2Text2Processor","local":"transformers.Speech2Text2Processor","sections":[],"depth":2},{"title":"Speech2Text2ForCausalLM","local":"transformers.Speech2Text2ForCausalLM","sections":[],"depth":2}],"depth":1}';function Do(U){return Bo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends Lo{constructor(l){super(),Go(this,l,Do,Yo,Io,{})}}export{ns as component};
