import{s as xn,f as qn,o as kn,n as cn}from"../chunks/scheduler.25b97de1.js";import{S as Rn,i as Xn,g as l,s as o,r as i,A as Fn,h as r,f as n,c as a,j as I,u as d,x as g,k as T,y as u,a as s,v as c,d as p,t as m,w as M}from"../chunks/index.d9030fc9.js";import{T as En}from"../chunks/Tip.baa67368.js";import{D as A}from"../chunks/Docstring.ffac8efa.js";import{C as G}from"../chunks/CodeBlock.e6cd0d95.js";import{E as zn}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as j,E as $n}from"../chunks/EditOnGithub.91d95064.js";function Ln(z){let h,J;return h=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFF3ZW4yVkxGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBRd2VuMlZMQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFF3ZW4yVkwlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwUXdlbjJWTENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMFF3ZW4yLVZMLTdCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBRd2VuMlZMRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Qwen2VLForConditionalGeneration, Qwen2VLConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Qwen2VL style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Qwen2VLConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Qwen2-VL-7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Qwen2VLForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){i(h.$$.fragment)},l(y){d(h.$$.fragment,y)},m(y,w){c(h,y,w),J=!0},p:cn,i(y){J||(p(h.$$.fragment,y),J=!0)},o(y){m(h.$$.fragment,y),J=!1},d(y){M(h,y)}}}function Sn(z){let h,J=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){h=l("p"),h.innerHTML=J},l(y){h=r(y,"P",{"data-svelte-h":!0}),g(h)!=="svelte-fincs2"&&(h.innerHTML=J)},m(y,w){s(y,h,w)},p:cn,d(y){y&&n(h)}}}function Yn(z){let h,J="Example:",y,w,v;return w=new G({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFF3ZW4yVkxGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFF3ZW4yVkxGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi1WTC03Qi1JbnN0cnVjdCUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbjItVkwtN0ItSW5zdHJ1Y3QlMjIpJTBBJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnd3dy5pbGFua2VsbWFuLm9yZyUyRnN0b3BzaWducyUyRmF1c3RyYWxpYS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEF0ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRCU1QnRleHQlNUQlMkMlMjBpbWFnZXMlM0QlNUJpbWFnZSU1RCUyQyUyMHZpc2lvbl9pbmZvcyUzRCU1QnZpc2lvbl9pbmZvcyU1RCklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cy5pbnB1dF9pZHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Qwen2VLForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Qwen2VLForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-VL-7B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-VL-7B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
        ],
    },
]
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = processor.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=[text], images=[image], vision_infos=[vision_infos])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;The image shows a street scene with a red stop sign in the foreground. In the background, there is a large red gate with Chinese characters ...&quot;</span>`,wrap:!1}}),{c(){h=l("p"),h.textContent=J,y=o(),i(w.$$.fragment)},l(f){h=r(f,"P",{"data-svelte-h":!0}),g(h)!=="svelte-11lpom8"&&(h.textContent=J),y=a(f),d(w.$$.fragment,f)},m(f,Q){s(f,h,Q),s(f,y,Q),c(w,f,Q),v=!0},p:cn,i(f){v||(p(w.$$.fragment,f),v=!0)},o(f){m(w.$$.fragment,f),v=!1},d(f){f&&(n(h),n(y)),M(w,f)}}}function Hn(z){let h,J,y,w,v,f,Q,Oe,S,pn='The <a href="https://qwenlm.github.io/blog/qwen2-vl/" rel="nofollow">Qwen2-VL</a> model is a major update to <a href="https://arxiv.org/pdf/2308.12966" rel="nofollow">Qwen-VL</a> from the Qwen team at Alibaba Research.',Ke,Y,mn="The abstract from the blog is the following:",et,H,Mn="<em>This blog introduces Qwen2-VL, an advanced version of the Qwen-VL model that has undergone significant enhancements over the past year. Key improvements include enhanced image comprehension, advanced video understanding, integrated visual agent functionality, and expanded multilingual support. The model architecture has been optimized for handling arbitrary image resolutions through Naive Dynamic Resolution support and utilizes Multimodal Rotary Position Embedding (M-ROPE) to effectively process both 1D textual and multi-dimensional visual data. This updated model demonstrates competitive performance against leading AI systems like GPT-4o and Claude 3.5 Sonnet in vision-related tasks and ranks highly among open-source models in text capabilities. These advancements make Qwen2-VL a versatile tool for various applications requiring robust multimodal processing and reasoning abilities.</em>",tt,x,un,nt,D,hn='Qwen2-VL architecture. Taken from the <a href="https://qwenlm.github.io/blog/qwen2-vl/">blog post.</a>',st,P,yn='This model was contributed by <a href="https://huggingface.co/simonJJJ" rel="nofollow">simonJJJ</a>.',ot,O,at,K,lt,ee,gn="The model can accept both images and videos as input. Here’s an example code for inference.",rt,te,it,ne,dt,se,fn="The model can batch inputs composed of mixed samples of various types such as images, videos, and text. Here is an example.",ct,oe,pt,ae,mt,le,Mt,re,wn="The model supports a wide range of resolution inputs. By default, it uses the native resolution for input, but higher resolutions can enhance performance at the cost of more computation. Users can set the minimum and maximum number of pixels to achieve an optimal configuration for their needs.",ut,ie,ht,de,Tn="In case of limited GPU RAM, one can reduce the resolution as follows:",yt,ce,gt,pe,Jn="This ensures each image gets encoded using a number between 256-1024 tokens. The 28 comes from the fact that the model uses a patch size of 14 and a temporal patch size of 2 (14 x 2 = 28).",ft,me,wt,Me,Un="By default, images and video content are directly included in the conversation. When handling multiple images, it’s helpful to add labels to the images and videos for better reference. Users can control this behavior with the following settings:",Tt,ue,Jt,he,Ut,ye,jn="First, make sure to install the latest version of Flash Attention 2:",jt,ge,_t,fe,_n='Also, you should have a hardware that is compatible with Flash-Attention 2. Read more about it in the official documentation of the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">flash attention repository</a>. FlashAttention-2 can only be used when a model is loaded in <code>torch.float16</code> or <code>torch.bfloat16</code>.',bt,we,bn="To load and run a model using Flash Attention-2, simply add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when loading the model as follows:",It,Te,vt,Je,Ct,_,Ue,Et,xe,In=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30530/en/model_doc/qwen2_vl#transformers.Qwen2VLModel">Qwen2VLModel</a>. It is used to instantiate a
Qwen2-VL model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of
Qwen2-VL-7B-Instruct <a href="https://huggingface.co/Qwen/Qwen2-VL-7B-Instruct" rel="nofollow">Qwen/Qwen2-VL-7B-Instruct</a>.`,$t,qe,vn=`Configuration objects inherit from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Lt,q,Qt,je,Vt,V,_e,St,ke,Cn="Constructs a Qwen2-VL image processor that dynamically resizes images based on the original images.",Yt,Re,be,Nt,Ie,At,U,ve,Ht,Xe,Qn=`Constructs a Qwen2-VL processor which wraps a Qwen2-VL image processor and a Qwen2 tokenizer into a single processor.
<a href="/docs/transformers/pr_30530/en/model_doc/qwen2_vl#transformers.Qwen2VLProcessor">Qwen2VLProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_30530/en/model_doc/qwen2_vl#transformers.Qwen2VLImageProcessor">Qwen2VLImageProcessor</a> and <a href="/docs/transformers/pr_30530/en/model_doc/qwen2#transformers.Qwen2TokenizerFast">Qwen2TokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/pr_30530/en/model_doc/qwen2_vl#transformers.Qwen2VLProcessor.decode">decode()</a> for more information.`,Dt,k,Ce,Pt,Fe,Vn=`This method forwards all its arguments to Qwen2TokenizerFast’s <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Ot,R,Qe,Kt,Ee,Nn=`This method forwards all its arguments to Qwen2TokenizerFast’s <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,en,X,Ve,tn,$e,An="Post-process the output of the model to decode the text.",Zt,Ne,Bt,b,Ae,nn,Le,Zn=`The bare Qwen2VL Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,sn,Se,Bn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,on,Ye,Ze,Wt,Be,Gt,B,We,an,C,Ge,ln,He,Wn='The <a href="/docs/transformers/pr_30530/en/model_doc/qwen2_vl#transformers.Qwen2VLForConditionalGeneration">Qwen2VLForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',rn,F,dn,E,zt,ze,xt,De,qt;return v=new j({props:{title:"Qwen2-VL",local:"qwen2-vl",headingTag:"h1"}}),Q=new j({props:{title:"Overview",local:"overview",headingTag:"h2"}}),O=new j({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),K=new j({props:{title:"Single Media inference",local:"single-media-inference",headingTag:"h3"}}),te=new G({props:{code:"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",highlighted:`
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> io
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Qwen2VLForConditionalGeneration, AutoTokenizer, AutoProcessor

<span class="hljs-comment"># Load the model in half-precision on the available device(s)</span>
model = Qwen2VLForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-VL-7B-Instruct&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-VL-7B-Instruct&quot;</span>)

<span class="hljs-comment"># Image</span>
url = <span class="hljs-string">&quot;https://qianwen-res.oss-cn-beijing.aliyuncs.com/Qwen-VL/assets/demo.jpeg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>:<span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>:[
            {
                <span class="hljs-string">&quot;type&quot;</span>:<span class="hljs-string">&quot;image&quot;</span>,
            },
            {
                <span class="hljs-string">&quot;type&quot;</span>:<span class="hljs-string">&quot;text&quot;</span>,
                <span class="hljs-string">&quot;text&quot;</span>:<span class="hljs-string">&quot;Describe this image.&quot;</span>
            }
        ]
    }
]


<span class="hljs-comment"># Preprocess the inputs</span>
text_prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-comment"># Excepted output: &#x27;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\n&lt;|vision_start|&gt;&lt;|image_pad|&gt;&lt;|vision_end|&gt;Describe this image.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&#x27;</span>

inputs = processor(text=[text_prompt], images=[image], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = inputs.to(<span class="hljs-string">&#x27;cuda&#x27;</span>)

<span class="hljs-comment"># Inference: Generation of the output</span>
output_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
generated_ids = [output_ids[<span class="hljs-built_in">len</span>(input_ids):] <span class="hljs-keyword">for</span> input_ids, output_ids <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(inputs.input_ids, output_ids)]
output_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(output_text)

<span class="hljs-comment"># Video</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">fetch_video</span>(<span class="hljs-params">ele: <span class="hljs-type">Dict</span>, nframe_factor=<span class="hljs-number">2</span></span>):
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(ele[<span class="hljs-string">&#x27;video&#x27;</span>], <span class="hljs-built_in">str</span>):
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">round_by_factor</span>(<span class="hljs-params">number: <span class="hljs-built_in">int</span>, factor: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-built_in">round</span>(number / factor) * factor

        video = ele[<span class="hljs-string">&quot;video&quot;</span>]
        <span class="hljs-keyword">if</span> video.startswith(<span class="hljs-string">&quot;file://&quot;</span>):
            video = video[<span class="hljs-number">7</span>:]

        video, _, info = io.read_video(
            video,
            start_pts=ele.get(<span class="hljs-string">&quot;video_start&quot;</span>, <span class="hljs-number">0.0</span>),
            end_pts=ele.get(<span class="hljs-string">&quot;video_end&quot;</span>, <span class="hljs-literal">None</span>),
            pts_unit=<span class="hljs-string">&quot;sec&quot;</span>,
            output_format=<span class="hljs-string">&quot;TCHW&quot;</span>,
        )
        <span class="hljs-keyword">assert</span> <span class="hljs-keyword">not</span> (<span class="hljs-string">&quot;fps&quot;</span> <span class="hljs-keyword">in</span> ele <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;nframes&quot;</span> <span class="hljs-keyword">in</span> ele), <span class="hljs-string">&quot;Only accept either \`fps\` or \`nframes\`&quot;</span>
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;nframes&quot;</span> <span class="hljs-keyword">in</span> ele:
            nframes = round_by_factor(ele[<span class="hljs-string">&quot;nframes&quot;</span>], nframe_factor)
        <span class="hljs-keyword">else</span>:
            fps = ele.get(<span class="hljs-string">&quot;fps&quot;</span>, <span class="hljs-number">1.0</span>)
            nframes = round_by_factor(video.size(<span class="hljs-number">0</span>) / info[<span class="hljs-string">&quot;video_fps&quot;</span>] * fps, nframe_factor)
        idx = torch.linspace(<span class="hljs-number">0</span>, video.size(<span class="hljs-number">0</span>) - <span class="hljs-number">1</span>, nframes, dtype=torch.int64)
        <span class="hljs-keyword">return</span> video[idx]

video_info = {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>, <span class="hljs-string">&quot;video&quot;</span>: <span class="hljs-string">&quot;/path/to/video.mp4&quot;</span>, <span class="hljs-string">&quot;fps&quot;</span>: <span class="hljs-number">1.0</span>}
video = fetch_video(video_info)
conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What happened in the video?&quot;</span>},
        ],
    }
]

<span class="hljs-comment"># Preprocess the inputs</span>
text_prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-comment"># Excepted output: &#x27;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\n&lt;|vision_start|&gt;&lt;|video_pad|&gt;&lt;|vision_end|&gt;What happened in the video?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&#x27;</span>

inputs = processor(text=[text_prompt], videos=[video], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = inputs.to(<span class="hljs-string">&#x27;cuda&#x27;</span>)

<span class="hljs-comment"># Inference: Generation of the output</span>
output_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
generated_ids = [output_ids[<span class="hljs-built_in">len</span>(input_ids):] <span class="hljs-keyword">for</span> input_ids, output_ids <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(inputs.input_ids, output_ids)]
output_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(output_text)`,wrap:!1}}),ne=new j({props:{title:"Batch Mixed Media Inference",local:"batch-mixed-media-inference",headingTag:"h3"}}),oe=new G({props:{code:"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",highlighted:`image1 = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/path/to/image1.jpg&quot;</span>)
image2 = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/path/to/image2.jpg&quot;</span>)
image3 = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/path/to/image3.jpg&quot;</span>)
image4 = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/path/to/image4.jpg&quot;</span>)
image5 = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/path/to/image5.jpg&quot;</span>)
video = fetch_video({
    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>,
    <span class="hljs-string">&quot;video&quot;</span>: <span class="hljs-string">&quot;/path/to/video.mp4&quot;</span>,
    <span class="hljs-string">&quot;fps&quot;</span>: <span class="hljs-number">1.0</span>
})

<span class="hljs-comment"># Conversation for the first image</span>
conversation1 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image.&quot;</span>}
        ]
    }
]

<span class="hljs-comment"># Conversation with two images</span>
conversation2 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is written in the pictures?&quot;</span>}
        ]
    }
]

<span class="hljs-comment"># Conversation with pure text</span>
conversation3 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;who are you?&quot;</span>
    }
]


<span class="hljs-comment"># Conversation with mixed midia</span>
conversation4 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What are the common elements in these medias?&quot;</span>},
        ],
    }
]

conversations = [conversation1, conversation2, conversation3, conversation4]
<span class="hljs-comment"># Preparation for batch inference</span>
texts = [processor.apply_chat_template(msg, add_generation_prompt=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> msg <span class="hljs-keyword">in</span> conversations]
inputs = processor(
    text=texts,
    images=[image1, image2, image3, image4, image5],
    videos=[video],
    padding=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
inputs = inputs.to(<span class="hljs-string">&#x27;cuda&#x27;</span>)

<span class="hljs-comment"># Batch Inference</span>
output_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
generated_ids = [output_ids[<span class="hljs-built_in">len</span>(input_ids):] <span class="hljs-keyword">for</span> input_ids, output_ids <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(inputs.input_ids, output_ids)]
output_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(output_text)`,wrap:!1}}),ae=new j({props:{title:"Usage Tips",local:"usage-tips",headingTag:"h3"}}),le=new j({props:{title:"Image Resolution trade-off",local:"image-resolution-trade-off",headingTag:"h4"}}),ie=new G({props:{code:"bWluX3BpeGVscyUyMCUzRCUyMDIyNCoyMjQlMEFtYXhfcGl4ZWxzJTIwJTNEJTIwMjA0OCoyMDQ4JTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLVZMLTdCLUluc3RydWN0JTIyJTJDJTIwbWluX3BpeGVscyUzRG1pbl9waXhlbHMlMkMlMjBtYXhfcGl4ZWxzJTNEbWF4X3BpeGVscyk=",highlighted:`min_pixels = <span class="hljs-number">224</span>*<span class="hljs-number">224</span>
max_pixels = <span class="hljs-number">2048</span>*<span class="hljs-number">2048</span>
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-VL-7B-Instruct&quot;</span>, min_pixels=min_pixels, max_pixels=max_pixels)`,wrap:!1}}),ce=new G({props:{code:"bWluX3BpeGVscyUyMCUzRCUyMDI1NioyOCoyOCUwQW1heF9waXhlbHMlMjAlM0QlMjAxMDI0KjI4KjI4JTIwJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLVZMLTdCLUluc3RydWN0JTIyJTJDJTIwbWluX3BpeGVscyUzRG1pbl9waXhlbHMlMkMlMjBtYXhfcGl4ZWxzJTNEbWF4X3BpeGVscyk=",highlighted:`min_pixels = <span class="hljs-number">256</span>*<span class="hljs-number">28</span>*<span class="hljs-number">28</span>
max_pixels = <span class="hljs-number">1024</span>*<span class="hljs-number">28</span>*<span class="hljs-number">28</span> 
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-VL-7B-Instruct&quot;</span>, min_pixels=min_pixels, max_pixels=max_pixels)`,wrap:!1}}),me=new j({props:{title:"Multiple Image Inputs",local:"multiple-image-inputs",headingTag:"h4"}}),ue=new G({props:{code:"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",highlighted:`conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}, 
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing well, thank you for asking. How can I assist you today?&quot;</span>
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Can you describe these images and video?&quot;</span>}, 
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}, 
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}, 
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>}, 
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;These are from my vacation.&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d be happy to describe the images and video for you. Could you please provide more context about your vacation?&quot;</span>
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It was a trip to the mountains. Can you see the details in the images and video?&quot;</span>
    }
]

<span class="hljs-comment"># default:</span>
prompt_without_id = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-comment"># Excepted output: &#x27;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\n&lt;|vision_start|&gt;&lt;|image_pad|&gt;&lt;|vision_end|&gt;Hello, how are you?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\nI&#x27;m doing well, thank you for asking. How can I assist you today?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nCan you describe these images and video?&lt;|vision_start|&gt;&lt;|image_pad|&gt;&lt;|vision_end|&gt;&lt;|vision_start|&gt;&lt;|image_pad|&gt;&lt;|vision_end|&gt;&lt;|vision_start|&gt;&lt;|video_pad|&gt;&lt;|vision_end|&gt;These are from my vacation.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\nI&#x27;d be happy to describe the images and video for you. Could you please provide more context about your vacation?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nIt was a trip to the mountains. Can you see the details in the images and video?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&#x27;</span>


<span class="hljs-comment"># add ids</span>
prompt_with_id = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>, add_vision_id=<span class="hljs-literal">True</span>)
<span class="hljs-comment"># Excepted output: &#x27;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nPicture 1: &lt;|vision_start|&gt;&lt;|image_pad|&gt;&lt;|vision_end|&gt;Hello, how are you?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\nI&#x27;m doing well, thank you for asking. How can I assist you today?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nCan you describe these images and video?Picture 2: &lt;|vision_start|&gt;&lt;|image_pad|&gt;&lt;|vision_end|&gt;Picture 3: &lt;|vision_start|&gt;&lt;|image_pad|&gt;&lt;|vision_end|&gt;Video 1: &lt;|vision_start|&gt;&lt;|video_pad|&gt;&lt;|vision_end|&gt;These are from my vacation.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\nI&#x27;d be happy to describe the images and video for you. Could you please provide more context about your vacation?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nIt was a trip to the mountains. Can you see the details in the images and video?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&#x27;</span>
`,wrap:!1}}),he=new j({props:{title:"Flash-Attention 2 to speed up generation",local:"flash-attention-2-to-speed-up-generation",headingTag:"h4"}}),ge=new G({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),Te=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFF3ZW4yVkxGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFF3ZW4yVkxGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlF3ZW4lMkZRd2VuMi1WTC03Qi1JbnN0cnVjdCUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjAlMEElMjAlMjAlMjAlMjBhdHRuX2ltcGxlbWVudGF0aW9uJTNEJTIyZmxhc2hfYXR0ZW50aW9uXzIlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Qwen2VLForConditionalGeneration

model = Qwen2VLForConditionalGeneration.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen2-VL-7B-Instruct&quot;</span>, 
    torch_dtype=torch.bfloat16, 
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)`,wrap:!1}}),Je=new j({props:{title:"Qwen2VLConfig",local:"transformers.Qwen2VLConfig",headingTag:"h2"}}),Ue=new A({props:{name:"class transformers.Qwen2VLConfig",anchor:"transformers.Qwen2VLConfig",parameters:[{name:"vocab_size",val:" = 152064"},{name:"hidden_size",val:" = 8192"},{name:"intermediate_size",val:" = 29568"},{name:"num_hidden_layers",val:" = 80"},{name:"num_attention_heads",val:" = 64"},{name:"num_key_value_heads",val:" = 8"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 32768"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 1000000.0"},{name:"use_sliding_window",val:" = False"},{name:"sliding_window",val:" = 4096"},{name:"max_window_layers",val:" = 80"},{name:"attention_dropout",val:" = 0.0"},{name:"vision_config",val:" = None"},{name:"rope_scaling",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Qwen2VLConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 152064) &#x2014;
Vocabulary size of the Qwen2VL model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30530/en/model_doc/qwen2_vl#transformers.Qwen2VLModel">Qwen2VLModel</a>`,name:"vocab_size"},{anchor:"transformers.Qwen2VLConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.Qwen2VLConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 29568) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.Qwen2VLConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 80) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Qwen2VLConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Qwen2VLConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to <code>32</code>.`,name:"num_key_value_heads"},{anchor:"transformers.Qwen2VLConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.Qwen2VLConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 32768) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.Qwen2VLConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Qwen2VLConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.Qwen2VLConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.Qwen2VLConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.Qwen2VLConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 1000000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.Qwen2VLConfig.use_sliding_window",description:`<strong>use_sliding_window</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use sliding window attention.`,name:"use_sliding_window"},{anchor:"transformers.Qwen2VLConfig.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Sliding window attention (SWA) window size. If not specified, will default to <code>4096</code>.`,name:"sliding_window"},{anchor:"transformers.Qwen2VLConfig.max_window_layers",description:`<strong>max_window_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 80) &#x2014;
The number of layers that use SWA (Sliding Window Attention). The bottom layers use SWA while the top use full attention.`,name:"max_window_layers"},{anchor:"transformers.Qwen2VLConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Qwen2VLConfig.vision_config",description:`<strong>vision_config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The config for the visual encoder initialization.`,name:"vision_config"},{anchor:"transformers.Qwen2VLConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/qwen2_vl/configuration_qwen2_vl.py#L57"}}),q=new zn({props:{anchor:"transformers.Qwen2VLConfig.example",$$slots:{default:[Ln]},$$scope:{ctx:z}}}),je=new j({props:{title:"Qwen2VLImageProcessor",local:"transformers.Qwen2VLImageProcessor",headingTag:"h2"}}),_e=new A({props:{name:"class transformers.Qwen2VLImageProcessor",anchor:"transformers.Qwen2VLImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"min_pixels",val:": int = 3136"},{name:"max_pixels",val:": int = 1003520"},{name:"patch_size",val:": int = 14"},{name:"temporal_patch_size",val:": int = 2"},{name:"merge_size",val:": int = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Qwen2VLImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions.`,name:"do_resize"},{anchor:"transformers.Qwen2VLImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.Qwen2VLImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>.`,name:"do_rescale"},{anchor:"transformers.Qwen2VLImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.Qwen2VLImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.Qwen2VLImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats for each channel in the image.`,name:"image_mean"},{anchor:"transformers.Qwen2VLImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats for each channel in the image.`,name:"image_std"},{anchor:"transformers.Qwen2VLImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.Qwen2VLImageProcessor.min_pixels",description:`<strong>min_pixels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>56 * 56</code>) &#x2014;
The min pixels of the image to resize the image.`,name:"min_pixels"},{anchor:"transformers.Qwen2VLImageProcessor.max_pixels",description:`<strong>max_pixels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>28 * 28 * 1280</code>) &#x2014;
The max pixels of the image to resize the image.`,name:"max_pixels"},{anchor:"transformers.Qwen2VLImageProcessor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
The spacial patch size of the vision encoder.`,name:"patch_size"},{anchor:"transformers.Qwen2VLImageProcessor.temporal_patch_size",description:`<strong>temporal_patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The temporal patch size of the vision encoder.`,name:"temporal_patch_size"},{anchor:"transformers.Qwen2VLImageProcessor.merge_size",description:`<strong>merge_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The merge size of the vision encoder to llm encoder.`,name:"merge_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/qwen2_vl/image_processing_qwen2_vl.py#L130"}}),be=new A({props:{name:"preprocess",anchor:"transformers.Qwen2VLImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"videos",val:": typing.Union[typing.List[ForwardRef('PIL.Image.Image')], ForwardRef('np.ndarray'), ForwardRef('torch.Tensor'), typing.List[ForwardRef('np.ndarray')], typing.List[ForwardRef('torch.Tensor')], typing.List[typing.List[ForwardRef('PIL.Image.Image')]], typing.List[typing.List[ForwardRef('np.ndarrray')]], typing.List[typing.List[ForwardRef('torch.Tensor')]]] = None"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.Qwen2VLImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.Qwen2VLImageProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>VideoInput</code>) &#x2014;
Video to preprocess. Expects a single or batch of videos with pixel values ranging from 0 to 255. If
passing in videos with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"videos"},{anchor:"transformers.Qwen2VLImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.Qwen2VLImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.Qwen2VLImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.Qwen2VLImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.Qwen2VLImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Qwen2VLImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.Qwen2VLImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.Qwen2VLImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.Qwen2VLImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.Qwen2VLImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Qwen2VLImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.Qwen2VLImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/qwen2_vl/image_processing_qwen2_vl.py#L317"}}),Ie=new j({props:{title:"Qwen2VLProcessor",local:"transformers.Qwen2VLProcessor",headingTag:"h2"}}),ve=new A({props:{name:"class transformers.Qwen2VLProcessor",anchor:"transformers.Qwen2VLProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"chat_template",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Qwen2VLProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/pr_30530/en/model_doc/qwen2_vl#transformers.Qwen2VLImageProcessor">Qwen2VLImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.Qwen2VLProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/pr_30530/en/model_doc/qwen2#transformers.Qwen2TokenizerFast">Qwen2TokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.Qwen2VLProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/qwen2_vl/processing_qwen2_vl.py#L44"}}),Ce=new A({props:{name:"batch_decode",anchor:"transformers.Qwen2VLProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/qwen2_vl/processing_qwen2_vl.py#L159"}}),Qe=new A({props:{name:"decode",anchor:"transformers.Qwen2VLProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/qwen2_vl/processing_qwen2_vl.py#L166"}}),Ve=new A({props:{name:"post_process_image_text_to_text",anchor:"transformers.Qwen2VLProcessor.post_process_image_text_to_text",parameters:[{name:"generated_outputs",val:""}],parametersDescription:[{anchor:"transformers.Qwen2VLProcessor.post_process_image_text_to_text.generated_outputs",description:`<strong>generated_outputs</strong> (<code>torch.Tensor</code> or <code>np.ndarray</code>) &#x2014;
The output of the model <code>generate</code> function. The output is expected to be a tensor of shape <code>(batch_size, sequence_length)</code>
or <code>(sequence_length,)</code>.`,name:"generated_outputs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/qwen2_vl/processing_qwen2_vl.py#L173",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The decoded text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Ne=new j({props:{title:"Qwen2VLModel",local:"transformers.Qwen2VLModel",headingTag:"h2"}}),Ae=new A({props:{name:"class transformers.Qwen2VLModel",anchor:"transformers.Qwen2VLModel",parameters:[{name:"config",val:": Qwen2VLConfig"}],parametersDescription:[{anchor:"transformers.Qwen2VLModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30530/en/model_doc/qwen2_vl#transformers.Qwen2VLConfig">Qwen2VLConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/qwen2_vl/modeling_qwen2_vl.py#L1021"}}),Ze=new A({props:{name:"forward",anchor:"transformers.Qwen2VLModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/qwen2_vl/modeling_qwen2_vl.py#L1049"}}),Be=new j({props:{title:"Qwen2VLForConditionalGeneration",local:"transformers.Qwen2VLForConditionalGeneration",headingTag:"h2"}}),We=new A({props:{name:"class transformers.Qwen2VLForConditionalGeneration",anchor:"transformers.Qwen2VLForConditionalGeneration",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/qwen2_vl/modeling_qwen2_vl.py#L1387"}}),Ge=new A({props:{name:"forward",anchor:"transformers.Qwen2VLForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"pixel_values_videos",val:": typing.Optional[torch.FloatTensor] = None"},{name:"image_grid_thw",val:": typing.Optional[torch.LongTensor] = None"},{name:"video_grid_thw",val:": typing.Optional[torch.LongTensor] = None"},{name:"rope_deltas",val:": typing.Optional[torch.LongTensor] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(seq_length, num_channels <em> image_size </em> image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30530/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">Qwen2VLImageProcessor.<strong>call</strong>()</a> for details. <a href="/docs/transformers/pr_30530/en/model_doc/qwen2_vl#transformers.Qwen2VLProcessor">Qwen2VLProcessor</a> uses
<a href="/docs/transformers/pr_30530/en/model_doc/qwen2_vl#transformers.Qwen2VLImageProcessor">Qwen2VLImageProcessor</a> for processing images.`,name:"pixel_values"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.pixel_values_videos",description:`<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape \`(seq_length, num_channels <em> temporal_size </em> image_size * image_size)) &#x2014;
The tensors corresponding to the input videos. Pixel values can be obtained using
<a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30530/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">Qwen2VLImageProcessor.<strong>call</strong>()</a> for details. <a href="/docs/transformers/pr_30530/en/model_doc/qwen2_vl#transformers.Qwen2VLProcessor">Qwen2VLProcessor</a> uses
<a href="/docs/transformers/pr_30530/en/model_doc/qwen2_vl#transformers.Qwen2VLImageProcessor">Qwen2VLImageProcessor</a> for processing videos.`,name:"pixel_values_videos"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.image_grid_thw",description:`<strong>image_grid_thw</strong> (<code>torch.LongTensor</code> of shape <code>(num_images, 3)</code>, <em>optional</em>) &#x2014;
The temporal, height and width of feature shape of each image in LLM.`,name:"image_grid_thw"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.video_grid_thw",description:`<strong>video_grid_thw</strong> (<code>torch.LongTensor</code> of shape <code>(num_videos, 3)</code>, <em>optional</em>) &#x2014;
The temporal, height and width of feature shape of each video in LLM.`,name:"video_grid_thw"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.rope_deltas",description:`<strong>rope_deltas</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) &#x2014;
The rope index difference between sequence length and multimodal rope.`,name:"rope_deltas"},{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.Args",description:`<strong>Args</strong> &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"Args"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/qwen2_vl/modeling_qwen2_vl.py#L1568",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.qwen2_vl.modeling_qwen2_vl.Qwen2VLCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30530/en/model_doc/qwen2_vl#transformers.Qwen2VLConfig"
>Qwen2VLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>rope_deltas</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>) — The rope index difference between sequence length and multimodal rope.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.qwen2_vl.modeling_qwen2_vl.Qwen2VLCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),F=new En({props:{$$slots:{default:[Sn]},$$scope:{ctx:z}}}),E=new zn({props:{anchor:"transformers.Qwen2VLForConditionalGeneration.forward.example",$$slots:{default:[Yn]},$$scope:{ctx:z}}}),ze=new $n({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/qwen2_vl.md"}}),{c(){h=l("meta"),J=o(),y=l("p"),w=o(),i(v.$$.fragment),f=o(),i(Q.$$.fragment),Oe=o(),S=l("p"),S.innerHTML=pn,Ke=o(),Y=l("p"),Y.textContent=mn,et=o(),H=l("p"),H.innerHTML=Mn,tt=o(),x=l("img"),nt=o(),D=l("small"),D.innerHTML=hn,st=o(),P=l("p"),P.innerHTML=yn,ot=o(),i(O.$$.fragment),at=o(),i(K.$$.fragment),lt=o(),ee=l("p"),ee.textContent=gn,rt=o(),i(te.$$.fragment),it=o(),i(ne.$$.fragment),dt=o(),se=l("p"),se.textContent=fn,ct=o(),i(oe.$$.fragment),pt=o(),i(ae.$$.fragment),mt=o(),i(le.$$.fragment),Mt=o(),re=l("p"),re.textContent=wn,ut=o(),i(ie.$$.fragment),ht=o(),de=l("p"),de.textContent=Tn,yt=o(),i(ce.$$.fragment),gt=o(),pe=l("p"),pe.textContent=Jn,ft=o(),i(me.$$.fragment),wt=o(),Me=l("p"),Me.textContent=Un,Tt=o(),i(ue.$$.fragment),Jt=o(),i(he.$$.fragment),Ut=o(),ye=l("p"),ye.textContent=jn,jt=o(),i(ge.$$.fragment),_t=o(),fe=l("p"),fe.innerHTML=_n,bt=o(),we=l("p"),we.innerHTML=bn,It=o(),i(Te.$$.fragment),vt=o(),i(Je.$$.fragment),Ct=o(),_=l("div"),i(Ue.$$.fragment),Et=o(),xe=l("p"),xe.innerHTML=In,$t=o(),qe=l("p"),qe.innerHTML=vn,Lt=o(),i(q.$$.fragment),Qt=o(),i(je.$$.fragment),Vt=o(),V=l("div"),i(_e.$$.fragment),St=o(),ke=l("p"),ke.textContent=Cn,Yt=o(),Re=l("div"),i(be.$$.fragment),Nt=o(),i(Ie.$$.fragment),At=o(),U=l("div"),i(ve.$$.fragment),Ht=o(),Xe=l("p"),Xe.innerHTML=Qn,Dt=o(),k=l("div"),i(Ce.$$.fragment),Pt=o(),Fe=l("p"),Fe.innerHTML=Vn,Ot=o(),R=l("div"),i(Qe.$$.fragment),Kt=o(),Ee=l("p"),Ee.innerHTML=Nn,en=o(),X=l("div"),i(Ve.$$.fragment),tn=o(),$e=l("p"),$e.textContent=An,Zt=o(),i(Ne.$$.fragment),Bt=o(),b=l("div"),i(Ae.$$.fragment),nn=o(),Le=l("p"),Le.innerHTML=Zn,sn=o(),Se=l("p"),Se.innerHTML=Bn,on=o(),Ye=l("div"),i(Ze.$$.fragment),Wt=o(),i(Be.$$.fragment),Gt=o(),B=l("div"),i(We.$$.fragment),an=o(),C=l("div"),i(Ge.$$.fragment),ln=o(),He=l("p"),He.innerHTML=Wn,rn=o(),i(F.$$.fragment),dn=o(),i(E.$$.fragment),zt=o(),i(ze.$$.fragment),xt=o(),De=l("p"),this.h()},l(e){const t=Fn("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(n),J=a(e),y=r(e,"P",{}),I(y).forEach(n),w=a(e),d(v.$$.fragment,e),f=a(e),d(Q.$$.fragment,e),Oe=a(e),S=r(e,"P",{"data-svelte-h":!0}),g(S)!=="svelte-hamayc"&&(S.innerHTML=pn),Ke=a(e),Y=r(e,"P",{"data-svelte-h":!0}),g(Y)!=="svelte-1j9j3g4"&&(Y.textContent=mn),et=a(e),H=r(e,"P",{"data-svelte-h":!0}),g(H)!=="svelte-r7ego0"&&(H.innerHTML=Mn),tt=a(e),x=r(e,"IMG",{src:!0,alt:!0,width:!0}),nt=a(e),D=r(e,"SMALL",{"data-svelte-h":!0}),g(D)!=="svelte-attzn3"&&(D.innerHTML=hn),st=a(e),P=r(e,"P",{"data-svelte-h":!0}),g(P)!=="svelte-1oz6b0p"&&(P.innerHTML=yn),ot=a(e),d(O.$$.fragment,e),at=a(e),d(K.$$.fragment,e),lt=a(e),ee=r(e,"P",{"data-svelte-h":!0}),g(ee)!=="svelte-1r0t8ni"&&(ee.textContent=gn),rt=a(e),d(te.$$.fragment,e),it=a(e),d(ne.$$.fragment,e),dt=a(e),se=r(e,"P",{"data-svelte-h":!0}),g(se)!=="svelte-9fk83r"&&(se.textContent=fn),ct=a(e),d(oe.$$.fragment,e),pt=a(e),d(ae.$$.fragment,e),mt=a(e),d(le.$$.fragment,e),Mt=a(e),re=r(e,"P",{"data-svelte-h":!0}),g(re)!=="svelte-1rlewe6"&&(re.textContent=wn),ut=a(e),d(ie.$$.fragment,e),ht=a(e),de=r(e,"P",{"data-svelte-h":!0}),g(de)!=="svelte-1h7uwi1"&&(de.textContent=Tn),yt=a(e),d(ce.$$.fragment,e),gt=a(e),pe=r(e,"P",{"data-svelte-h":!0}),g(pe)!=="svelte-7vf2io"&&(pe.textContent=Jn),ft=a(e),d(me.$$.fragment,e),wt=a(e),Me=r(e,"P",{"data-svelte-h":!0}),g(Me)!=="svelte-12fryma"&&(Me.textContent=Un),Tt=a(e),d(ue.$$.fragment,e),Jt=a(e),d(he.$$.fragment,e),Ut=a(e),ye=r(e,"P",{"data-svelte-h":!0}),g(ye)!=="svelte-13kjllm"&&(ye.textContent=jn),jt=a(e),d(ge.$$.fragment,e),_t=a(e),fe=r(e,"P",{"data-svelte-h":!0}),g(fe)!=="svelte-dzzatn"&&(fe.innerHTML=_n),bt=a(e),we=r(e,"P",{"data-svelte-h":!0}),g(we)!=="svelte-z3ioid"&&(we.innerHTML=bn),It=a(e),d(Te.$$.fragment,e),vt=a(e),d(Je.$$.fragment,e),Ct=a(e),_=r(e,"DIV",{class:!0});var N=I(_);d(Ue.$$.fragment,N),Et=a(N),xe=r(N,"P",{"data-svelte-h":!0}),g(xe)!=="svelte-115nknn"&&(xe.innerHTML=In),$t=a(N),qe=r(N,"P",{"data-svelte-h":!0}),g(qe)!=="svelte-l1blo3"&&(qe.innerHTML=vn),Lt=a(N),d(q.$$.fragment,N),N.forEach(n),Qt=a(e),d(je.$$.fragment,e),Vt=a(e),V=r(e,"DIV",{class:!0});var W=I(V);d(_e.$$.fragment,W),St=a(W),ke=r(W,"P",{"data-svelte-h":!0}),g(ke)!=="svelte-uygdj3"&&(ke.textContent=Cn),Yt=a(W),Re=r(W,"DIV",{class:!0});var Pe=I(Re);d(be.$$.fragment,Pe),Pe.forEach(n),W.forEach(n),Nt=a(e),d(Ie.$$.fragment,e),At=a(e),U=r(e,"DIV",{class:!0});var Z=I(U);d(ve.$$.fragment,Z),Ht=a(Z),Xe=r(Z,"P",{"data-svelte-h":!0}),g(Xe)!=="svelte-16p5zx0"&&(Xe.innerHTML=Qn),Dt=a(Z),k=r(Z,"DIV",{class:!0});var kt=I(k);d(Ce.$$.fragment,kt),Pt=a(kt),Fe=r(kt,"P",{"data-svelte-h":!0}),g(Fe)!=="svelte-mubyl"&&(Fe.innerHTML=Vn),kt.forEach(n),Ot=a(Z),R=r(Z,"DIV",{class:!0});var Rt=I(R);d(Qe.$$.fragment,Rt),Kt=a(Rt),Ee=r(Rt,"P",{"data-svelte-h":!0}),g(Ee)!=="svelte-c8qktj"&&(Ee.innerHTML=Nn),Rt.forEach(n),en=a(Z),X=r(Z,"DIV",{class:!0});var Xt=I(X);d(Ve.$$.fragment,Xt),tn=a(Xt),$e=r(Xt,"P",{"data-svelte-h":!0}),g($e)!=="svelte-z5vbkk"&&($e.textContent=An),Xt.forEach(n),Z.forEach(n),Zt=a(e),d(Ne.$$.fragment,e),Bt=a(e),b=r(e,"DIV",{class:!0});var $=I(b);d(Ae.$$.fragment,$),nn=a($),Le=r($,"P",{"data-svelte-h":!0}),g(Le)!=="svelte-r2ba92"&&(Le.innerHTML=Zn),sn=a($),Se=r($,"P",{"data-svelte-h":!0}),g(Se)!=="svelte-hswkmf"&&(Se.innerHTML=Bn),on=a($),Ye=r($,"DIV",{class:!0});var Gn=I(Ye);d(Ze.$$.fragment,Gn),Gn.forEach(n),$.forEach(n),Wt=a(e),d(Be.$$.fragment,e),Gt=a(e),B=r(e,"DIV",{class:!0});var Ft=I(B);d(We.$$.fragment,Ft),an=a(Ft),C=r(Ft,"DIV",{class:!0});var L=I(C);d(Ge.$$.fragment,L),ln=a(L),He=r(L,"P",{"data-svelte-h":!0}),g(He)!=="svelte-j2r48q"&&(He.innerHTML=Wn),rn=a(L),d(F.$$.fragment,L),dn=a(L),d(E.$$.fragment,L),L.forEach(n),Ft.forEach(n),zt=a(e),d(ze.$$.fragment,e),xt=a(e),De=r(e,"P",{}),I(De).forEach(n),this.h()},h(){T(h,"name","hf:doc:metadata"),T(h,"content",Dn),qn(x.src,un="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/qwen2_vl_architecture.jpeg")||T(x,"src",un),T(x,"alt","drawing"),T(x,"width","600"),T(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){u(document.head,h),s(e,J,t),s(e,y,t),s(e,w,t),c(v,e,t),s(e,f,t),c(Q,e,t),s(e,Oe,t),s(e,S,t),s(e,Ke,t),s(e,Y,t),s(e,et,t),s(e,H,t),s(e,tt,t),s(e,x,t),s(e,nt,t),s(e,D,t),s(e,st,t),s(e,P,t),s(e,ot,t),c(O,e,t),s(e,at,t),c(K,e,t),s(e,lt,t),s(e,ee,t),s(e,rt,t),c(te,e,t),s(e,it,t),c(ne,e,t),s(e,dt,t),s(e,se,t),s(e,ct,t),c(oe,e,t),s(e,pt,t),c(ae,e,t),s(e,mt,t),c(le,e,t),s(e,Mt,t),s(e,re,t),s(e,ut,t),c(ie,e,t),s(e,ht,t),s(e,de,t),s(e,yt,t),c(ce,e,t),s(e,gt,t),s(e,pe,t),s(e,ft,t),c(me,e,t),s(e,wt,t),s(e,Me,t),s(e,Tt,t),c(ue,e,t),s(e,Jt,t),c(he,e,t),s(e,Ut,t),s(e,ye,t),s(e,jt,t),c(ge,e,t),s(e,_t,t),s(e,fe,t),s(e,bt,t),s(e,we,t),s(e,It,t),c(Te,e,t),s(e,vt,t),c(Je,e,t),s(e,Ct,t),s(e,_,t),c(Ue,_,null),u(_,Et),u(_,xe),u(_,$t),u(_,qe),u(_,Lt),c(q,_,null),s(e,Qt,t),c(je,e,t),s(e,Vt,t),s(e,V,t),c(_e,V,null),u(V,St),u(V,ke),u(V,Yt),u(V,Re),c(be,Re,null),s(e,Nt,t),c(Ie,e,t),s(e,At,t),s(e,U,t),c(ve,U,null),u(U,Ht),u(U,Xe),u(U,Dt),u(U,k),c(Ce,k,null),u(k,Pt),u(k,Fe),u(U,Ot),u(U,R),c(Qe,R,null),u(R,Kt),u(R,Ee),u(U,en),u(U,X),c(Ve,X,null),u(X,tn),u(X,$e),s(e,Zt,t),c(Ne,e,t),s(e,Bt,t),s(e,b,t),c(Ae,b,null),u(b,nn),u(b,Le),u(b,sn),u(b,Se),u(b,on),u(b,Ye),c(Ze,Ye,null),s(e,Wt,t),c(Be,e,t),s(e,Gt,t),s(e,B,t),c(We,B,null),u(B,an),u(B,C),c(Ge,C,null),u(C,ln),u(C,He),u(C,rn),c(F,C,null),u(C,dn),c(E,C,null),s(e,zt,t),c(ze,e,t),s(e,xt,t),s(e,De,t),qt=!0},p(e,[t]){const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),q.$set(N);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),F.$set(W);const Pe={};t&2&&(Pe.$$scope={dirty:t,ctx:e}),E.$set(Pe)},i(e){qt||(p(v.$$.fragment,e),p(Q.$$.fragment,e),p(O.$$.fragment,e),p(K.$$.fragment,e),p(te.$$.fragment,e),p(ne.$$.fragment,e),p(oe.$$.fragment,e),p(ae.$$.fragment,e),p(le.$$.fragment,e),p(ie.$$.fragment,e),p(ce.$$.fragment,e),p(me.$$.fragment,e),p(ue.$$.fragment,e),p(he.$$.fragment,e),p(ge.$$.fragment,e),p(Te.$$.fragment,e),p(Je.$$.fragment,e),p(Ue.$$.fragment,e),p(q.$$.fragment,e),p(je.$$.fragment,e),p(_e.$$.fragment,e),p(be.$$.fragment,e),p(Ie.$$.fragment,e),p(ve.$$.fragment,e),p(Ce.$$.fragment,e),p(Qe.$$.fragment,e),p(Ve.$$.fragment,e),p(Ne.$$.fragment,e),p(Ae.$$.fragment,e),p(Ze.$$.fragment,e),p(Be.$$.fragment,e),p(We.$$.fragment,e),p(Ge.$$.fragment,e),p(F.$$.fragment,e),p(E.$$.fragment,e),p(ze.$$.fragment,e),qt=!0)},o(e){m(v.$$.fragment,e),m(Q.$$.fragment,e),m(O.$$.fragment,e),m(K.$$.fragment,e),m(te.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(ae.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(he.$$.fragment,e),m(ge.$$.fragment,e),m(Te.$$.fragment,e),m(Je.$$.fragment,e),m(Ue.$$.fragment,e),m(q.$$.fragment,e),m(je.$$.fragment,e),m(_e.$$.fragment,e),m(be.$$.fragment,e),m(Ie.$$.fragment,e),m(ve.$$.fragment,e),m(Ce.$$.fragment,e),m(Qe.$$.fragment,e),m(Ve.$$.fragment,e),m(Ne.$$.fragment,e),m(Ae.$$.fragment,e),m(Ze.$$.fragment,e),m(Be.$$.fragment,e),m(We.$$.fragment,e),m(Ge.$$.fragment,e),m(F.$$.fragment,e),m(E.$$.fragment,e),m(ze.$$.fragment,e),qt=!1},d(e){e&&(n(J),n(y),n(w),n(f),n(Oe),n(S),n(Ke),n(Y),n(et),n(H),n(tt),n(x),n(nt),n(D),n(st),n(P),n(ot),n(at),n(lt),n(ee),n(rt),n(it),n(dt),n(se),n(ct),n(pt),n(mt),n(Mt),n(re),n(ut),n(ht),n(de),n(yt),n(gt),n(pe),n(ft),n(wt),n(Me),n(Tt),n(Jt),n(Ut),n(ye),n(jt),n(_t),n(fe),n(bt),n(we),n(It),n(vt),n(Ct),n(_),n(Qt),n(Vt),n(V),n(Nt),n(At),n(U),n(Zt),n(Bt),n(b),n(Wt),n(Gt),n(B),n(zt),n(xt),n(De)),n(h),M(v,e),M(Q,e),M(O,e),M(K,e),M(te,e),M(ne,e),M(oe,e),M(ae,e),M(le,e),M(ie,e),M(ce,e),M(me,e),M(ue,e),M(he,e),M(ge,e),M(Te,e),M(Je,e),M(Ue),M(q),M(je,e),M(_e),M(be),M(Ie,e),M(ve),M(Ce),M(Qe),M(Ve),M(Ne,e),M(Ae),M(Ze),M(Be,e),M(We),M(Ge),M(F),M(E),M(ze,e)}}}const Dn='{"title":"Qwen2-VL","local":"qwen2-vl","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single Media inference","local":"single-media-inference","sections":[],"depth":3},{"title":"Batch Mixed Media Inference","local":"batch-mixed-media-inference","sections":[],"depth":3},{"title":"Usage Tips","local":"usage-tips","sections":[{"title":"Image Resolution trade-off","local":"image-resolution-trade-off","sections":[],"depth":4},{"title":"Multiple Image Inputs","local":"multiple-image-inputs","sections":[],"depth":4},{"title":"Flash-Attention 2 to speed up generation","local":"flash-attention-2-to-speed-up-generation","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Qwen2VLConfig","local":"transformers.Qwen2VLConfig","sections":[],"depth":2},{"title":"Qwen2VLImageProcessor","local":"transformers.Qwen2VLImageProcessor","sections":[],"depth":2},{"title":"Qwen2VLProcessor","local":"transformers.Qwen2VLProcessor","sections":[],"depth":2},{"title":"Qwen2VLModel","local":"transformers.Qwen2VLModel","sections":[],"depth":2},{"title":"Qwen2VLForConditionalGeneration","local":"transformers.Qwen2VLForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Pn(z){return kn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class as extends Rn{constructor(h){super(),Xn(this,h,Pn,Hn,xn,{})}}export{as as component};
