import{s as xo,o as Co,n as te}from"../chunks/scheduler.25b97de1.js";import{S as zo,i as Jo,g as l,s,r as u,A as Fo,h as c,f as n,c as a,j as Z,u as f,x as h,k as q,y as d,a as r,v as g,d as _,t as b,w as y}from"../chunks/index.d9030fc9.js";import{T as Ae}from"../chunks/Tip.baa67368.js";import{D as R}from"../chunks/Docstring.ffac8efa.js";import{C as Oe}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Kt}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as ee,E as Io}from"../chunks/EditOnGithub.91d95064.js";function Wo($){let o,T=`The <code>Persimmon</code> models were trained using <code>bfloat16</code>, but the original inference uses <code>float16</code> The checkpoints uploaded on the hub use <code>torch_dtype = &#39;float16&#39;</code> which will be
used by the <code>AutoModel</code> API to cast the checkpoints from <code>torch.float32</code> to <code>torch.float16</code>.`,i,p,k="The <code>dtype</code> of the online weights is mostly irrelevant, unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>. The reason is that the model will first be downloaded ( using the <code>dtype</code> of the checkpoints online) then it will be cast to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>). Users should specify the <code>torch_dtype</code> they want, and if they don’t it will be <code>torch.float32</code>.",m,w,oe="Finetuning the model in <code>float16</code> is not recommended and known to produce <code>nan</code>, as such the model should be fine-tuned in <code>bfloat16</code>.";return{c(){o=l("p"),o.innerHTML=T,i=s(),p=l("p"),p.innerHTML=k,m=s(),w=l("p"),w.innerHTML=oe},l(v){o=c(v,"P",{"data-svelte-h":!0}),h(o)!=="svelte-17q3pz"&&(o.innerHTML=T),i=a(v),p=c(v,"P",{"data-svelte-h":!0}),h(p)!=="svelte-1mgue3n"&&(p.innerHTML=k),m=a(v),w=c(v,"P",{"data-svelte-h":!0}),h(w)!=="svelte-1p3drsu"&&(w.innerHTML=oe)},m(v,S){r(v,o,S),r(v,i,S),r(v,p,S),r(v,m,S),r(v,w,S)},p:te,d(v){v&&(n(o),n(i),n(p),n(m),n(w))}}}function Lo($){let o,T;return o=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBlcnNpbW1vbk1vZGVsJTJDJTIwUGVyc2ltbW9uQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFBlcnNpbW1vbiUyMHBlcnNpbW1vbi03YiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBQZXJzaW1tb25Db25maWcoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PersimmonModel, PersimmonConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Persimmon persimmon-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PersimmonConfig()`,wrap:!1}}),{c(){u(o.$$.fragment)},l(i){f(o.$$.fragment,i)},m(i,p){g(o,i,p),T=!0},p:te,i(i){T||(_(o.$$.fragment,i),T=!0)},o(i){b(o.$$.fragment,i),T=!1},d(i){y(o,i)}}}function jo($){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=l("p"),o.innerHTML=T},l(i){o=c(i,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(i,p){r(i,o,p)},p:te,d(i){i&&n(o)}}}function Zo($){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=l("p"),o.innerHTML=T},l(i){o=c(i,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(i,p){r(i,o,p)},p:te,d(i){i&&n(o)}}}function qo($){let o,T="Example:",i,p,k;return p=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQZXJzaW1tb25Gb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwUGVyc2ltbW9uRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmFkZXB0JTJGcGVyc2ltbW9uLThiLWJhc2UlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYWRlcHQlMkZwZXJzaW1tb24tOGItYmFzZSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJodW1hbiUzQSUyMEhleSUyQyUyMHdoYXQlMjBzaG91bGQlMjBJJTIwZWF0JTIwZm9yJTIwZGlubmVyJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PersimmonForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PersimmonForCausalLM.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;human: Hey, what should I eat for dinner?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;human: Hey, what should I eat for dinner?\\n\\ncat: 🐱\\n\\nhuman: 😐\\n\\n&#x27;</span>`,wrap:!1}}),{c(){o=l("p"),o.textContent=T,i=s(),u(p.$$.fragment)},l(m){o=c(m,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),i=a(m),f(p.$$.fragment,m)},m(m,w){r(m,o,w),r(m,i,w),g(p,m,w),k=!0},p:te,i(m){k||(_(p.$$.fragment,m),k=!0)},o(m){b(p.$$.fragment,m),k=!1},d(m){m&&(n(o),n(i)),y(p,m)}}}function Uo($){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=l("p"),o.innerHTML=T},l(i){o=c(i,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(i,p){r(i,o,p)},p:te,d(i){i&&n(o)}}}function Go($){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=l("p"),o.innerHTML=T},l(i){o=c(i,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(i,p){r(i,o,p)},p:te,d(i){i&&n(o)}}}function Bo($){let o,T="Example:",i,p,k;return p=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQZXJzaW1tb25Gb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhZGVwdCUyRnBlcnNpbW1vbi04Yi1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwUGVyc2ltbW9uRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYWRlcHQlMkZwZXJzaW1tb24tOGItYmFzZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySHVnZ2luZ0ZhY2UlMjBpcyUyMGElMjBjb21wYW55JTIwYmFzZWQlMjBpbiUyMFBhcmlzJTIwYW5kJTIwTmV3JTIwWW9yayUyMiUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKSUwQSUwQSUyMyUyME5vdGUlMjB0aGF0JTIwdG9rZW5zJTIwYXJlJTIwY2xhc3NpZmllZCUyMHJhdGhlciUyMHRoZW4lMjBpbnB1dCUyMHdvcmRzJTIwd2hpY2glMjBtZWFucyUyMHRoYXQlMEElMjMlMjB0aGVyZSUyMG1pZ2h0JTIwYmUlMjBtb3JlJTIwcHJlZGljdGVkJTIwdG9rZW4lMjBjbGFzc2VzJTIwdGhhbiUyMHdvcmRzLiUwQSUyMyUyME11bHRpcGxlJTIwdG9rZW4lMjBjbGFzc2VzJTIwbWlnaHQlMjBhY2NvdW50JTIwZm9yJTIwdGhlJTIwc2FtZSUyMHdvcmQlMEFwcmVkaWN0ZWRfdG9rZW5zX2NsYXNzZXMlMjAlM0QlMjAlNUJtb2RlbC5jb25maWcuaWQybGFiZWwlNUJ0Lml0ZW0oKSU1RCUyMGZvciUyMHQlMjBpbiUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlNUIwJTVEJTVEJTBBJTBBbGFiZWxzJTIwJTNEJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PersimmonForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PersimmonForTokenClassification.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){o=l("p"),o.textContent=T,i=s(),u(p.$$.fragment)},l(m){o=c(m,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),i=a(m),f(p.$$.fragment,m)},m(m,w){r(m,o,w),r(m,i,w),g(p,m,w),k=!0},p:te,i(m){k||(_(p.$$.fragment,m),k=!0)},o(m){b(p.$$.fragment,m),k=!1},d(m){m&&(n(o),n(i)),y(p,m)}}}function Ho($){let o,T,i,p,k,m,w,oe,v,S='The Persimmon model was created by <a href="https://www.adept.ai/blog/persimmon-8b" rel="nofollow">ADEPT</a>, and authored by Erich Elsen, Augustus Odena, Maxwell Nye, Sağnak Taşırlar, Tri Dao, Curtis Hawthorne, Deepak Moparthi, Arushi Somani.',De,ne,eo="The authors introduced Persimmon-8B, a decoder model based on the classic transformers architecture, with query and key normalization. Persimmon-8B is a fully permissively-licensed model with approximately 8 billion parameters, released under the Apache license.  Some of the key attributes of Persimmon-8B are long context size (16K), performance, and capabilities for multimodal extensions.",Ke,se,to="The authors showcase their approach to model evaluation, focusing on practical text generation, mirroring how users interact with language models. The work also includes a comparative analysis, pitting Persimmon-8B against other prominent models (MPT 7B Instruct and Llama 2 Base 7B 1-Shot), across various evaluation tasks. The results demonstrate Persimmon-8B’s competitive performance, even with limited training data.",et,ae,oo="In terms of model details, the work outlines the architecture and training methodology of Persimmon-8B, providing insights into its design choices, sequence length, and dataset composition. The authors present a fast inference code that outperforms traditional implementations through operator fusion and CUDA graph utilization while maintaining code coherence. They express their anticipation of how the community will leverage this contribution to drive innovation, hinting at further upcoming releases as part of an ongoing series of developments.",tt,re,no=`This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">ArthurZ</a>.
The original code can be found <a href="https://github.com/persimmon-ai-labs/adept-inference" rel="nofollow">here</a>.`,ot,ie,nt,X,st,de,so="Tips:",at,le,ao="<li>To convert the model, you need to clone the original repository using <code>git clone https://github.com/persimmon-ai-labs/adept-inference</code>, then get the checkpoints:</li>",rt,ce,it,me,ro="For the chat model:",dt,pe,lt,he,io="Thereafter, models can be loaded via:",ct,ue,mt,fe,lo=`<li><p>Perismmon uses a <code>sentencepiece</code> based tokenizer, with a <code>Unigram</code> model. It supports bytefallback, which is only available in <code>tokenizers==0.14.0</code> for the fast tokenizer.
The <code>LlamaTokenizer</code> is used as it is a standard wrapper around sentencepiece. The <code>chat</code> template will be updated with the templating functions in a follow up PR!</p></li> <li><p>The authors suggest to use the following prompt format for the chat mode: <code>f&quot;human: {prompt}\\n\\nadept:&quot;</code></p></li>`,pt,ge,ht,z,_e,$t,Ie,co=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30530/en/model_doc/persimmon#transformers.PersimmonModel">PersimmonModel</a>. It is used to instantiate an
Persimmon model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/adept/persimmon-8b-base" rel="nofollow">adept/persimmon-8b-base</a>.`,Pt,We,mo=`Configuration objects inherit from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,xt,V,ut,be,ft,x,ye,Ct,Le,po=`The bare Persimmon Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,zt,je,ho=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Jt,Ze,uo="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>PersimmonDecoderLayer</code>",Ft,U,Te,It,qe,fo='The <a href="/docs/transformers/pr_30530/en/model_doc/persimmon#transformers.PersimmonModel">PersimmonModel</a> forward method, overrides the <code>__call__</code> special method.',Wt,Y,gt,we,_t,B,ve,Lt,I,ke,jt,Ue,go='The <a href="/docs/transformers/pr_30530/en/model_doc/persimmon#transformers.PersimmonForCausalLM">PersimmonForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Zt,E,qt,O,bt,Me,yt,M,$e,Ut,Ge,_o="The Persimmon transformer with a sequence classification head on top (linear layer).",Gt,Be,bo=`<a href="/docs/transformers/pr_30530/en/model_doc/persimmon#transformers.PersimmonForSequenceClassification">PersimmonForSequenceClassification</a> uses the last token in order to do the classification, as other causal
models (e.g. GPT-2) do.`,Bt,He,yo=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,Ht,Ne,To=`This model inherits from <a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Nt,Re,wo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Rt,G,Pe,St,Se,vo='The <a href="/docs/transformers/pr_30530/en/model_doc/persimmon#transformers.PersimmonForSequenceClassification">PersimmonForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Xt,Q,Tt,xe,wt,C,Ce,Vt,Xe,ko=`The Persimmon Model transformer with a token classification head on top (a linear layer on top of the hidden-states
output) e.g. for Named-Entity-Recognition (NER) tasks.`,Yt,Ve,Mo=`This model inherits from <a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Et,Ye,$o=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ot,W,ze,Qt,Ee,Po='The <a href="/docs/transformers/pr_30530/en/model_doc/persimmon#transformers.PersimmonForTokenClassification">PersimmonForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',At,A,Dt,D,vt,Je,kt,Qe,Mt;return k=new ee({props:{title:"Persimmon",local:"persimmon",headingTag:"h1"}}),w=new ee({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ie=new ee({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),X=new Ae({props:{warning:!0,$$slots:{default:[Wo]},$$scope:{ctx:$}}}),ce=new Oe({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZwZXJzaW1tb24tYWktbGFicyUyRmFkZXB0LWluZmVyZW5jZSUwQXdnZXQlMjBodHRwcyUzQSUyRiUyRmF4dGtuNHhsNWNpcC5vYmplY3RzdG9yYWdlLnVzLXBob2VuaXgtMS5vY2kuY3VzdG9tZXItb2NpLmNvbSUyRm4lMkZheHRrbjR4bDVjaXAlMkZiJTJGYWRlcHQtcHVibGljLWRhdGElMkZvJTJGOGJfYmFzZV9tb2RlbF9yZWxlYXNlLnRhciUwQXRhciUyMC14dmYlMjA4Yl9iYXNlX21vZGVsX3JlbGVhc2UudGFyJTBBcHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGcGVyc2ltbW9uJTJGY29udmVydF9wZXJzaW1tb25fd2VpZ2h0c190b19oZi5weSUyMCUyMC0taW5wdXRfZGlyJTIwJTJGcGF0aCUyRnRvJTJGZG93bmxvYWRlZCUyRnBlcnNpbW1vbiUyRndlaWdodHMlMkYlMjAtLW91dHB1dF9kaXIlMjAlMkZvdXRwdXQlMkZwYXRoJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdF9tb2RlbF9wYXRoJTIwJTJGcGF0aCUyRnRvJTJGOGJfY2hhdF9tb2RlbF9yZWxlYXNlJTJGaXRlcl8wMDAxMjUxJTJGbXBfcmFua18wMCUyRm1vZGVsX29wdGltX3JuZy5wdCUwQSUyMCUyMCUyMCUyMC0tYWRhX2xpYl9wYXRoJTIwJTJGcGF0aCUyRnRvJTJGYWRlcHQtaW5mZXJlbmNl",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/persimmon-ai-labs/adept-inference
wget https://axtkn4xl5cip.objectstorage.us-phoenix-1.oci.customer-oci.com/n/axtkn4xl5cip/b/adept-public-data/o/8b_base_model_release.tar
tar -xvf 8b_base_model_release.tar
python src/transformers/models/persimmon/convert_persimmon_weights_to_hf.py  --input_dir /path/to/downloaded/persimmon/weights/ --output_dir /output/path \\
    --pt_model_path /path/to/8b_chat_model_release/iter_0001251/mp_rank_00/model_optim_rng.pt
    --ada_lib_path /path/to/adept-inference`,wrap:!1}}),pe=new Oe({props:{code:"d2dldCUyMGh0dHBzJTNBJTJGJTJGYXh0a240eGw1Y2lwLm9iamVjdHN0b3JhZ2UudXMtcGhvZW5peC0xLm9jaS5jdXN0b21lci1vY2kuY29tJTJGbiUyRmF4dGtuNHhsNWNpcCUyRmIlMkZhZGVwdC1wdWJsaWMtZGF0YSUyRm8lMkY4Yl9jaGF0X21vZGVsX3JlbGVhc2UudGFyJTBBdGFyJTIwLXh2ZiUyMDhiX2Jhc2VfbW9kZWxfcmVsZWFzZS50YXI=",highlighted:`wget https://axtkn4xl5cip.objectstorage.us-phoenix-1.oci.customer-oci.com/n/axtkn4xl5cip/b/adept-public-data/o/8b_chat_model_release.tar
tar -xvf 8b_base_model_release.tar`,wrap:!1}}),ue=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBlcnNpbW1vbkZvckNhdXNhbExNJTJDJTIwUGVyc2ltbW9uVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBQZXJzaW1tb25Gb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTJGb3V0cHV0JTJGcGF0aCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBQZXJzaW1tb25Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMiUyRm91dHB1dCUyRnBhdGglMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PersimmonForCausalLM, PersimmonTokenizer

model = PersimmonForCausalLM.from_pretrained(<span class="hljs-string">&quot;/output/path&quot;</span>)
tokenizer = PersimmonTokenizer.from_pretrained(<span class="hljs-string">&quot;/output/path&quot;</span>)`,wrap:!1}}),ge=new ee({props:{title:"PersimmonConfig",local:"transformers.PersimmonConfig",headingTag:"h2"}}),_e=new R({props:{name:"class transformers.PersimmonConfig",anchor:"transformers.PersimmonConfig",parameters:[{name:"vocab_size",val:" = 262144"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 16384"},{name:"num_hidden_layers",val:" = 36"},{name:"num_attention_heads",val:" = 64"},{name:"hidden_act",val:" = 'relu2'"},{name:"max_position_embeddings",val:" = 16384"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 25000.0"},{name:"rope_scaling",val:" = None"},{name:"qk_layernorm",val:" = True"},{name:"hidden_dropout",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"partial_rotary_factor",val:" = 0.5"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PersimmonConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 262144) &#x2014;
Vocabulary size of the Persimmon model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30530/en/model_doc/persimmon#transformers.PersimmonModel">PersimmonModel</a>`,name:"vocab_size"},{anchor:"transformers.PersimmonConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.PersimmonConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.PersimmonConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 36) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.PersimmonConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.PersimmonConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu2&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.PersimmonConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.PersimmonConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PersimmonConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014;
The epsilon used by the rms normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.PersimmonConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.PersimmonConfig.tie_word_embeddings(bool,",description:`<strong>tie_word_embeddings(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings(bool,"},{anchor:"transformers.PersimmonConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 25000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.PersimmonConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"},{anchor:"transformers.PersimmonConfig.qk_layernorm",description:`<strong>qk_layernorm</strong> (<code>bool</code>, <em>optional</em>, default to <code>True</code>) &#x2014;
Whether or not to normalize the Queries and Keys after projecting the hidden states`,name:"qk_layernorm"},{anchor:"transformers.PersimmonConfig.hidden_dropout",description:`<strong>hidden_dropout</strong> (<code>float</code>, <em>optional</em>, default to 0.0) &#x2014;
The dropout ratio after applying the MLP to the hidden states.`,name:"hidden_dropout"},{anchor:"transformers.PersimmonConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, default to 0.0) &#x2014;
The dropout ratio after computing the attention scores.`,name:"attention_dropout"},{anchor:"transformers.PersimmonConfig.partial_rotary_factor",description:`<strong>partial_rotary_factor</strong> (<code>float</code>, <em>optional</em>, default to 0.5) &#x2014;
Percentage of the query and keys which will have rotary embedding.`,name:"partial_rotary_factor"},{anchor:"transformers.PersimmonConfig.Example",description:"<strong>Example</strong> &#x2014;",name:"Example"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/persimmon/configuration_persimmon.py#L25"}}),V=new Kt({props:{anchor:"transformers.PersimmonConfig.example",$$slots:{default:[Lo]},$$scope:{ctx:$}}}),be=new ee({props:{title:"PersimmonModel",local:"transformers.PersimmonModel",headingTag:"h2"}}),ye=new R({props:{name:"class transformers.PersimmonModel",anchor:"transformers.PersimmonModel",parameters:[{name:"config",val:": PersimmonConfig"}],parametersDescription:[{anchor:"transformers.PersimmonModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30530/en/model_doc/persimmon#transformers.PersimmonConfig">PersimmonConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.PersimmonModel.config",description:"<strong>config</strong> &#x2014; PersimmonConfig",name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/persimmon/modeling_persimmon.py#L537"}}),Te=new R({props:{name:"forward",anchor:"transformers.PersimmonModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.PersimmonModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PersimmonModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PersimmonModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PersimmonModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PersimmonModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PersimmonModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PersimmonModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PersimmonModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PersimmonModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PersimmonModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/persimmon/modeling_persimmon.py#L572"}}),Y=new Ae({props:{$$slots:{default:[jo]},$$scope:{ctx:$}}}),we=new ee({props:{title:"PersimmonForCausalLM",local:"transformers.PersimmonForCausalLM",headingTag:"h2"}}),ve=new R({props:{name:"class transformers.PersimmonForCausalLM",anchor:"transformers.PersimmonForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/persimmon/modeling_persimmon.py#L822"}}),ke=new R({props:{name:"forward",anchor:"transformers.PersimmonForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"num_logits_to_keep",val:": int = 0"}],parametersDescription:[{anchor:"transformers.PersimmonForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PersimmonForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PersimmonForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PersimmonForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PersimmonForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PersimmonForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PersimmonForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PersimmonForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PersimmonForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PersimmonForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.PersimmonForCausalLM.forward.Args",description:`<strong>Args</strong> &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>num_logits_to_keep (<code>int</code>, <em>optional</em>):
Calculate logits for the last <code>num_logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.`,name:"Args"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/persimmon/modeling_persimmon.py#L859",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30530/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30530/en/model_doc/persimmon#transformers.PersimmonConfig"
>PersimmonConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30530/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new Ae({props:{$$slots:{default:[Zo]},$$scope:{ctx:$}}}),O=new Kt({props:{anchor:"transformers.PersimmonForCausalLM.forward.example",$$slots:{default:[qo]},$$scope:{ctx:$}}}),Me=new ee({props:{title:"PersimmonForSequenceClassification",local:"transformers.PersimmonForSequenceClassification",headingTag:"h2"}}),$e=new R({props:{name:"class transformers.PersimmonForSequenceClassification",anchor:"transformers.PersimmonForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PersimmonForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30530/en/model_doc/persimmon#transformers.PersimmonConfig">PersimmonConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/persimmon/modeling_persimmon.py#L957"}}),Pe=new R({props:{name:"forward",anchor:"transformers.PersimmonForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PersimmonForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PersimmonForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PersimmonForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PersimmonForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PersimmonForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PersimmonForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PersimmonForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PersimmonForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PersimmonForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PersimmonForSequenceClassification.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.PersimmonForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/persimmon/modeling_persimmon.py#L989"}}),Q=new Ae({props:{$$slots:{default:[Uo]},$$scope:{ctx:$}}}),xe=new ee({props:{title:"PersimmonForTokenClassification",local:"transformers.PersimmonForTokenClassification",headingTag:"h2"}}),Ce=new R({props:{name:"class transformers.PersimmonForTokenClassification",anchor:"transformers.PersimmonForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PersimmonForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30530/en/model_doc/persimmon#transformers.PersimmonConfig">PersimmonConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/persimmon/modeling_persimmon.py#L1062"}}),ze=new R({props:{name:"forward",anchor:"transformers.PersimmonForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PersimmonForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PersimmonForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PersimmonForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PersimmonForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PersimmonForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PersimmonForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PersimmonForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PersimmonForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PersimmonForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PersimmonForTokenClassification.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.PersimmonForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/models/persimmon/modeling_persimmon.py#L1093",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30530/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30530/en/model_doc/persimmon#transformers.PersimmonConfig"
>PersimmonConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30530/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new Ae({props:{$$slots:{default:[Go]},$$scope:{ctx:$}}}),D=new Kt({props:{anchor:"transformers.PersimmonForTokenClassification.forward.example",$$slots:{default:[Bo]},$$scope:{ctx:$}}}),Je=new Io({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/persimmon.md"}}),{c(){o=l("meta"),T=s(),i=l("p"),p=s(),u(k.$$.fragment),m=s(),u(w.$$.fragment),oe=s(),v=l("p"),v.innerHTML=S,De=s(),ne=l("p"),ne.textContent=eo,Ke=s(),se=l("p"),se.textContent=to,et=s(),ae=l("p"),ae.textContent=oo,tt=s(),re=l("p"),re.innerHTML=no,ot=s(),u(ie.$$.fragment),nt=s(),u(X.$$.fragment),st=s(),de=l("p"),de.textContent=so,at=s(),le=l("ul"),le.innerHTML=ao,rt=s(),u(ce.$$.fragment),it=s(),me=l("p"),me.textContent=ro,dt=s(),u(pe.$$.fragment),lt=s(),he=l("p"),he.textContent=io,ct=s(),u(ue.$$.fragment),mt=s(),fe=l("ul"),fe.innerHTML=lo,pt=s(),u(ge.$$.fragment),ht=s(),z=l("div"),u(_e.$$.fragment),$t=s(),Ie=l("p"),Ie.innerHTML=co,Pt=s(),We=l("p"),We.innerHTML=mo,xt=s(),u(V.$$.fragment),ut=s(),u(be.$$.fragment),ft=s(),x=l("div"),u(ye.$$.fragment),Ct=s(),Le=l("p"),Le.innerHTML=po,zt=s(),je=l("p"),je.innerHTML=ho,Jt=s(),Ze=l("p"),Ze.innerHTML=uo,Ft=s(),U=l("div"),u(Te.$$.fragment),It=s(),qe=l("p"),qe.innerHTML=fo,Wt=s(),u(Y.$$.fragment),gt=s(),u(we.$$.fragment),_t=s(),B=l("div"),u(ve.$$.fragment),Lt=s(),I=l("div"),u(ke.$$.fragment),jt=s(),Ue=l("p"),Ue.innerHTML=go,Zt=s(),u(E.$$.fragment),qt=s(),u(O.$$.fragment),bt=s(),u(Me.$$.fragment),yt=s(),M=l("div"),u($e.$$.fragment),Ut=s(),Ge=l("p"),Ge.textContent=_o,Gt=s(),Be=l("p"),Be.innerHTML=bo,Bt=s(),He=l("p"),He.innerHTML=yo,Ht=s(),Ne=l("p"),Ne.innerHTML=To,Nt=s(),Re=l("p"),Re.innerHTML=wo,Rt=s(),G=l("div"),u(Pe.$$.fragment),St=s(),Se=l("p"),Se.innerHTML=vo,Xt=s(),u(Q.$$.fragment),Tt=s(),u(xe.$$.fragment),wt=s(),C=l("div"),u(Ce.$$.fragment),Vt=s(),Xe=l("p"),Xe.textContent=ko,Yt=s(),Ve=l("p"),Ve.innerHTML=Mo,Et=s(),Ye=l("p"),Ye.innerHTML=$o,Ot=s(),W=l("div"),u(ze.$$.fragment),Qt=s(),Ee=l("p"),Ee.innerHTML=Po,At=s(),u(A.$$.fragment),Dt=s(),u(D.$$.fragment),vt=s(),u(Je.$$.fragment),kt=s(),Qe=l("p"),this.h()},l(e){const t=Fo("svelte-u9bgzb",document.head);o=c(t,"META",{name:!0,content:!0}),t.forEach(n),T=a(e),i=c(e,"P",{}),Z(i).forEach(n),p=a(e),f(k.$$.fragment,e),m=a(e),f(w.$$.fragment,e),oe=a(e),v=c(e,"P",{"data-svelte-h":!0}),h(v)!=="svelte-1dqqllh"&&(v.innerHTML=S),De=a(e),ne=c(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-tohaaf"&&(ne.textContent=eo),Ke=a(e),se=c(e,"P",{"data-svelte-h":!0}),h(se)!=="svelte-gxqz2j"&&(se.textContent=to),et=a(e),ae=c(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-l2kkzt"&&(ae.textContent=oo),tt=a(e),re=c(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-1kv44aj"&&(re.innerHTML=no),ot=a(e),f(ie.$$.fragment,e),nt=a(e),f(X.$$.fragment,e),st=a(e),de=c(e,"P",{"data-svelte-h":!0}),h(de)!=="svelte-axv494"&&(de.textContent=so),at=a(e),le=c(e,"UL",{"data-svelte-h":!0}),h(le)!=="svelte-g9ue9k"&&(le.innerHTML=ao),rt=a(e),f(ce.$$.fragment,e),it=a(e),me=c(e,"P",{"data-svelte-h":!0}),h(me)!=="svelte-1cs7acv"&&(me.textContent=ro),dt=a(e),f(pe.$$.fragment,e),lt=a(e),he=c(e,"P",{"data-svelte-h":!0}),h(he)!=="svelte-nia5es"&&(he.textContent=io),ct=a(e),f(ue.$$.fragment,e),mt=a(e),fe=c(e,"UL",{"data-svelte-h":!0}),h(fe)!=="svelte-yk84b4"&&(fe.innerHTML=lo),pt=a(e),f(ge.$$.fragment,e),ht=a(e),z=c(e,"DIV",{class:!0});var L=Z(z);f(_e.$$.fragment,L),$t=a(L),Ie=c(L,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-jnd24r"&&(Ie.innerHTML=co),Pt=a(L),We=c(L,"P",{"data-svelte-h":!0}),h(We)!=="svelte-l1blo3"&&(We.innerHTML=mo),xt=a(L),f(V.$$.fragment,L),L.forEach(n),ut=a(e),f(be.$$.fragment,e),ft=a(e),x=c(e,"DIV",{class:!0});var J=Z(x);f(ye.$$.fragment,J),Ct=a(J),Le=c(J,"P",{"data-svelte-h":!0}),h(Le)!=="svelte-3zygi5"&&(Le.innerHTML=po),zt=a(J),je=c(J,"P",{"data-svelte-h":!0}),h(je)!=="svelte-hswkmf"&&(je.innerHTML=ho),Jt=a(J),Ze=c(J,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-3gfl0d"&&(Ze.innerHTML=uo),Ft=a(J),U=c(J,"DIV",{class:!0});var H=Z(U);f(Te.$$.fragment,H),It=a(H),qe=c(H,"P",{"data-svelte-h":!0}),h(qe)!=="svelte-urm1vm"&&(qe.innerHTML=fo),Wt=a(H),f(Y.$$.fragment,H),H.forEach(n),J.forEach(n),gt=a(e),f(we.$$.fragment,e),_t=a(e),B=c(e,"DIV",{class:!0});var Fe=Z(B);f(ve.$$.fragment,Fe),Lt=a(Fe),I=c(Fe,"DIV",{class:!0});var j=Z(I);f(ke.$$.fragment,j),jt=a(j),Ue=c(j,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-2j0cm"&&(Ue.innerHTML=go),Zt=a(j),f(E.$$.fragment,j),qt=a(j),f(O.$$.fragment,j),j.forEach(n),Fe.forEach(n),bt=a(e),f(Me.$$.fragment,e),yt=a(e),M=c(e,"DIV",{class:!0});var P=Z(M);f($e.$$.fragment,P),Ut=a(P),Ge=c(P,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-1oalnz1"&&(Ge.textContent=_o),Gt=a(P),Be=c(P,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-d4rsn9"&&(Be.innerHTML=bo),Bt=a(P),He=c(P,"P",{"data-svelte-h":!0}),h(He)!=="svelte-10ugs3m"&&(He.innerHTML=yo),Ht=a(P),Ne=c(P,"P",{"data-svelte-h":!0}),h(Ne)!=="svelte-19piw51"&&(Ne.innerHTML=To),Nt=a(P),Re=c(P,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-hswkmf"&&(Re.innerHTML=wo),Rt=a(P),G=c(P,"DIV",{class:!0});var N=Z(G);f(Pe.$$.fragment,N),St=a(N),Se=c(N,"P",{"data-svelte-h":!0}),h(Se)!=="svelte-i2pwc"&&(Se.innerHTML=vo),Xt=a(N),f(Q.$$.fragment,N),N.forEach(n),P.forEach(n),Tt=a(e),f(xe.$$.fragment,e),wt=a(e),C=c(e,"DIV",{class:!0});var F=Z(C);f(Ce.$$.fragment,F),Vt=a(F),Xe=c(F,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-fb5bx3"&&(Xe.textContent=ko),Yt=a(F),Ve=c(F,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-19piw51"&&(Ve.innerHTML=Mo),Et=a(F),Ye=c(F,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-hswkmf"&&(Ye.innerHTML=$o),Ot=a(F),W=c(F,"DIV",{class:!0});var K=Z(W);f(ze.$$.fragment,K),Qt=a(K),Ee=c(K,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-pbzvc"&&(Ee.innerHTML=Po),At=a(K),f(A.$$.fragment,K),Dt=a(K),f(D.$$.fragment,K),K.forEach(n),F.forEach(n),vt=a(e),f(Je.$$.fragment,e),kt=a(e),Qe=c(e,"P",{}),Z(Qe).forEach(n),this.h()},h(){q(o,"name","hf:doc:metadata"),q(o,"content",No),q(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,o),r(e,T,t),r(e,i,t),r(e,p,t),g(k,e,t),r(e,m,t),g(w,e,t),r(e,oe,t),r(e,v,t),r(e,De,t),r(e,ne,t),r(e,Ke,t),r(e,se,t),r(e,et,t),r(e,ae,t),r(e,tt,t),r(e,re,t),r(e,ot,t),g(ie,e,t),r(e,nt,t),g(X,e,t),r(e,st,t),r(e,de,t),r(e,at,t),r(e,le,t),r(e,rt,t),g(ce,e,t),r(e,it,t),r(e,me,t),r(e,dt,t),g(pe,e,t),r(e,lt,t),r(e,he,t),r(e,ct,t),g(ue,e,t),r(e,mt,t),r(e,fe,t),r(e,pt,t),g(ge,e,t),r(e,ht,t),r(e,z,t),g(_e,z,null),d(z,$t),d(z,Ie),d(z,Pt),d(z,We),d(z,xt),g(V,z,null),r(e,ut,t),g(be,e,t),r(e,ft,t),r(e,x,t),g(ye,x,null),d(x,Ct),d(x,Le),d(x,zt),d(x,je),d(x,Jt),d(x,Ze),d(x,Ft),d(x,U),g(Te,U,null),d(U,It),d(U,qe),d(U,Wt),g(Y,U,null),r(e,gt,t),g(we,e,t),r(e,_t,t),r(e,B,t),g(ve,B,null),d(B,Lt),d(B,I),g(ke,I,null),d(I,jt),d(I,Ue),d(I,Zt),g(E,I,null),d(I,qt),g(O,I,null),r(e,bt,t),g(Me,e,t),r(e,yt,t),r(e,M,t),g($e,M,null),d(M,Ut),d(M,Ge),d(M,Gt),d(M,Be),d(M,Bt),d(M,He),d(M,Ht),d(M,Ne),d(M,Nt),d(M,Re),d(M,Rt),d(M,G),g(Pe,G,null),d(G,St),d(G,Se),d(G,Xt),g(Q,G,null),r(e,Tt,t),g(xe,e,t),r(e,wt,t),r(e,C,t),g(Ce,C,null),d(C,Vt),d(C,Xe),d(C,Yt),d(C,Ve),d(C,Et),d(C,Ye),d(C,Ot),d(C,W),g(ze,W,null),d(W,Qt),d(W,Ee),d(W,At),g(A,W,null),d(W,Dt),g(D,W,null),r(e,vt,t),g(Je,e,t),r(e,kt,t),r(e,Qe,t),Mt=!0},p(e,[t]){const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),X.$set(L);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),V.$set(J);const H={};t&2&&(H.$$scope={dirty:t,ctx:e}),Y.$set(H);const Fe={};t&2&&(Fe.$$scope={dirty:t,ctx:e}),E.$set(Fe);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),O.$set(j);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),Q.$set(P);const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),A.$set(N);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),D.$set(F)},i(e){Mt||(_(k.$$.fragment,e),_(w.$$.fragment,e),_(ie.$$.fragment,e),_(X.$$.fragment,e),_(ce.$$.fragment,e),_(pe.$$.fragment,e),_(ue.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(V.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(Te.$$.fragment,e),_(Y.$$.fragment,e),_(we.$$.fragment,e),_(ve.$$.fragment,e),_(ke.$$.fragment,e),_(E.$$.fragment,e),_(O.$$.fragment,e),_(Me.$$.fragment,e),_($e.$$.fragment,e),_(Pe.$$.fragment,e),_(Q.$$.fragment,e),_(xe.$$.fragment,e),_(Ce.$$.fragment,e),_(ze.$$.fragment,e),_(A.$$.fragment,e),_(D.$$.fragment,e),_(Je.$$.fragment,e),Mt=!0)},o(e){b(k.$$.fragment,e),b(w.$$.fragment,e),b(ie.$$.fragment,e),b(X.$$.fragment,e),b(ce.$$.fragment,e),b(pe.$$.fragment,e),b(ue.$$.fragment,e),b(ge.$$.fragment,e),b(_e.$$.fragment,e),b(V.$$.fragment,e),b(be.$$.fragment,e),b(ye.$$.fragment,e),b(Te.$$.fragment,e),b(Y.$$.fragment,e),b(we.$$.fragment,e),b(ve.$$.fragment,e),b(ke.$$.fragment,e),b(E.$$.fragment,e),b(O.$$.fragment,e),b(Me.$$.fragment,e),b($e.$$.fragment,e),b(Pe.$$.fragment,e),b(Q.$$.fragment,e),b(xe.$$.fragment,e),b(Ce.$$.fragment,e),b(ze.$$.fragment,e),b(A.$$.fragment,e),b(D.$$.fragment,e),b(Je.$$.fragment,e),Mt=!1},d(e){e&&(n(T),n(i),n(p),n(m),n(oe),n(v),n(De),n(ne),n(Ke),n(se),n(et),n(ae),n(tt),n(re),n(ot),n(nt),n(st),n(de),n(at),n(le),n(rt),n(it),n(me),n(dt),n(lt),n(he),n(ct),n(mt),n(fe),n(pt),n(ht),n(z),n(ut),n(ft),n(x),n(gt),n(_t),n(B),n(bt),n(yt),n(M),n(Tt),n(wt),n(C),n(vt),n(kt),n(Qe)),n(o),y(k,e),y(w,e),y(ie,e),y(X,e),y(ce,e),y(pe,e),y(ue,e),y(ge,e),y(_e),y(V),y(be,e),y(ye),y(Te),y(Y),y(we,e),y(ve),y(ke),y(E),y(O),y(Me,e),y($e),y(Pe),y(Q),y(xe,e),y(Ce),y(ze),y(A),y(D),y(Je,e)}}}const No='{"title":"Persimmon","local":"persimmon","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"PersimmonConfig","local":"transformers.PersimmonConfig","sections":[],"depth":2},{"title":"PersimmonModel","local":"transformers.PersimmonModel","sections":[],"depth":2},{"title":"PersimmonForCausalLM","local":"transformers.PersimmonForCausalLM","sections":[],"depth":2},{"title":"PersimmonForSequenceClassification","local":"transformers.PersimmonForSequenceClassification","sections":[],"depth":2},{"title":"PersimmonForTokenClassification","local":"transformers.PersimmonForTokenClassification","sections":[],"depth":2}],"depth":1}';function Ro($){return Co(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ao extends zo{constructor(o){super(),Jo(this,o,Ro,Ho,xo,{})}}export{Ao as component};
