import{s as ce,o as me,n as Ct}from"../chunks/scheduler.25b97de1.js";import{S as ue,i as he,g,s as l,r as c,A as fe,h as y,f as e,c as n,j as pe,u as m,x as M,k as ie,y as de,a,v as u,d as h,t as f,w as d}from"../chunks/index.d9030fc9.js";import{T as It}from"../chunks/Tip.baa67368.js";import{Y as ge}from"../chunks/Youtube.eaf1a617.js";import{C as _}from"../chunks/CodeBlock.e6cd0d95.js";import{D as ye}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{F as re,M as oe}from"../chunks/Markdown.7217f838.js";import{H as Is,E as Me}from"../chunks/EditOnGithub.91d95064.js";function be(W){let p,b='To see all architectures and checkpoints compatible with this task, we recommend checking the <a href="https://huggingface.co/tasks/audio-classification" rel="nofollow">task-page</a>';return{c(){p=g("p"),p.innerHTML=b},l(i){p=y(i,"P",{"data-svelte-h":!0}),M(p)!=="svelte-13xjlu1"&&(p.innerHTML=b)},m(i,j){a(i,p,j)},p:Ct,d(i){i&&e(p)}}}function je(W){let p,b='If you aren’t familiar with finetuning a model with the <a href="/docs/transformers/pr_29969/en/main_classes/trainer#transformers.Trainer">Trainer</a>, take a look at the basic tutorial <a href="../training#train-with-pytorch-trainer">here</a>!';return{c(){p=g("p"),p.innerHTML=b},l(i){p=y(i,"P",{"data-svelte-h":!0}),M(p)!=="svelte-9sclpj"&&(p.innerHTML=b)},m(i,j){a(i,p,j)},p:Ct,d(i){i&&e(p)}}}function $e(W){let p,b,i,j='You’re ready to start training your model now! Load Wav2Vec2 with <a href="/docs/transformers/pr_29969/en/model_doc/auto#transformers.AutoModelForAudioClassification">AutoModelForAudioClassification</a> along with the number of expected labels, and the label mappings:',w,U,Z,v,k="At this point, only three steps remain:",C,J,V='<li>Define your training hyperparameters in <a href="/docs/transformers/pr_29969/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>. The only required parameter is <code>output_dir</code> which specifies where to save your model. You’ll push this model to the Hub by setting <code>push_to_hub=True</code> (you need to be signed in to Hugging Face to upload your model). At the end of each epoch, the <a href="/docs/transformers/pr_29969/en/main_classes/trainer#transformers.Trainer">Trainer</a> will evaluate the accuracy and save the training checkpoint.</li> <li>Pass the training arguments to <a href="/docs/transformers/pr_29969/en/main_classes/trainer#transformers.Trainer">Trainer</a> along with the model, dataset, tokenizer, data collator, and <code>compute_metrics</code> function.</li> <li>Call <a href="/docs/transformers/pr_29969/en/main_classes/trainer#transformers.Trainer.train">train()</a> to finetune your model.</li>',I,T,X,o,x='Once training is completed, share your model to the Hub with the <a href="/docs/transformers/pr_29969/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method so everyone can use your model:',B,G,R;return p=new It({props:{$$slots:{default:[je]},$$scope:{ctx:W}}}),U=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUyMFRyYWluZXIlMEElMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKGlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1iYXNlJTIyJTJDJTIwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlMkMlMjBsYWJlbDJpZCUzRGxhYmVsMmlkJTJDJTIwaWQybGFiZWwlM0RpZDJsYWJlbCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForAudioClassification, TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>, num_labels=num_labels, label2id=label2id, id2label=id2label
<span class="hljs-meta">... </span>)`,wrap:!1}}),T=new _({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJteV9hd2Vzb21lX21pbmRfbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEM2UtNSUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfcmF0aW8lM0QwLjElMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpY19mb3JfYmVzdF9tb2RlbCUzRCUyMmFjY3VyYWN5JTIyJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RlbmNvZGVkX21pbmRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RlbmNvZGVkX21pbmRzJTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHByb2Nlc3NpbmdfY2xhc3MlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;my_awesome_mind_model&quot;</span>,
<span class="hljs-meta">... </span>    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">3e-5</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">32</span>,
<span class="hljs-meta">... </span>    gradient_accumulation_steps=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">32</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    warmup_ratio=<span class="hljs-number">0.1</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    metric_for_best_model=<span class="hljs-string">&quot;accuracy&quot;</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=encoded_minds[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    eval_dataset=encoded_minds[<span class="hljs-string">&quot;test&quot;</span>],
<span class="hljs-meta">... </span>    processing_class=feature_extractor,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),G=new _({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),{c(){c(p.$$.fragment),b=l(),i=g("p"),i.innerHTML=j,w=l(),c(U.$$.fragment),Z=l(),v=g("p"),v.textContent=k,C=l(),J=g("ol"),J.innerHTML=V,I=l(),c(T.$$.fragment),X=l(),o=g("p"),o.innerHTML=x,B=l(),c(G.$$.fragment)},l(r){m(p.$$.fragment,r),b=n(r),i=y(r,"P",{"data-svelte-h":!0}),M(i)!=="svelte-vo6flt"&&(i.innerHTML=j),w=n(r),m(U.$$.fragment,r),Z=n(r),v=y(r,"P",{"data-svelte-h":!0}),M(v)!=="svelte-l42k0i"&&(v.textContent=k),C=n(r),J=y(r,"OL",{"data-svelte-h":!0}),M(J)!=="svelte-c9zy7l"&&(J.innerHTML=V),I=n(r),m(T.$$.fragment,r),X=n(r),o=y(r,"P",{"data-svelte-h":!0}),M(o)!=="svelte-jpge3p"&&(o.innerHTML=x),B=n(r),m(G.$$.fragment,r)},m(r,$){u(p,r,$),a(r,b,$),a(r,i,$),a(r,w,$),u(U,r,$),a(r,Z,$),a(r,v,$),a(r,C,$),a(r,J,$),a(r,I,$),u(T,r,$),a(r,X,$),a(r,o,$),a(r,B,$),u(G,r,$),R=!0},p(r,$){const Rs={};$&2&&(Rs.$$scope={dirty:$,ctx:r}),p.$set(Rs)},i(r){R||(h(p.$$.fragment,r),h(U.$$.fragment,r),h(T.$$.fragment,r),h(G.$$.fragment,r),R=!0)},o(r){f(p.$$.fragment,r),f(U.$$.fragment,r),f(T.$$.fragment,r),f(G.$$.fragment,r),R=!1},d(r){r&&(e(b),e(i),e(w),e(Z),e(v),e(C),e(J),e(I),e(X),e(o),e(B)),d(p,r),d(U,r),d(T,r),d(G,r)}}}function we(W){let p,b;return p=new oe({props:{$$slots:{default:[$e]},$$scope:{ctx:W}}}),{c(){c(p.$$.fragment)},l(i){m(p.$$.fragment,i)},m(i,j){u(p,i,j),b=!0},p(i,j){const w={};j&2&&(w.$$scope={dirty:j,ctx:i}),p.$set(w)},i(i){b||(h(p.$$.fragment,i),b=!0)},o(i){f(p.$$.fragment,i),b=!1},d(i){d(p,i)}}}function Je(W){let p,b='For a more in-depth example of how to finetune a model for audio classification, take a look at the corresponding <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/audio_classification.ipynb" rel="nofollow">PyTorch notebook</a>.';return{c(){p=g("p"),p.innerHTML=b},l(i){p=y(i,"P",{"data-svelte-h":!0}),M(p)!=="svelte-1zzytb"&&(p.innerHTML=b)},m(i,j){a(i,p,j)},p:Ct,d(i){i&&e(p)}}}function Te(W){let p,b="Load a feature extractor to preprocess the audio file and return the <code>input</code> as PyTorch tensors:",i,j,w,U,Z="Pass your inputs to the model and return the logits:",v,k,C,J,V="Get the class with the highest probability, and use the model’s <code>id2label</code> mapping to convert it to a label:",I,T,X;return j=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyc3RldmhsaXUlMkZteV9hd2Vzb21lX21pbmRzX21vZGVsJTIyKSUwQWlucHV0cyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;stevhliu/my_awesome_minds_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),k=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXZobGl1JTJGbXlfYXdlc29tZV9taW5kc19tb2RlbCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;stevhliu/my_awesome_minds_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits`,wrap:!1}}),T=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWRzJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cykuaXRlbSgpJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkcyU1RCUwQXByZWRpY3RlZF9sYWJlbA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label
<span class="hljs-string">&#x27;cash_deposit&#x27;</span>`,wrap:!1}}),{c(){p=g("p"),p.innerHTML=b,i=l(),c(j.$$.fragment),w=l(),U=g("p"),U.textContent=Z,v=l(),c(k.$$.fragment),C=l(),J=g("p"),J.innerHTML=V,I=l(),c(T.$$.fragment)},l(o){p=y(o,"P",{"data-svelte-h":!0}),M(p)!=="svelte-eon9oh"&&(p.innerHTML=b),i=n(o),m(j.$$.fragment,o),w=n(o),U=y(o,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1at92g"&&(U.textContent=Z),v=n(o),m(k.$$.fragment,o),C=n(o),J=y(o,"P",{"data-svelte-h":!0}),M(J)!=="svelte-1w2ymk2"&&(J.innerHTML=V),I=n(o),m(T.$$.fragment,o)},m(o,x){a(o,p,x),a(o,i,x),u(j,o,x),a(o,w,x),a(o,U,x),a(o,v,x),u(k,o,x),a(o,C,x),a(o,J,x),a(o,I,x),u(T,o,x),X=!0},p:Ct,i(o){X||(h(j.$$.fragment,o),h(k.$$.fragment,o),h(T.$$.fragment,o),X=!0)},o(o){f(j.$$.fragment,o),f(k.$$.fragment,o),f(T.$$.fragment,o),X=!1},d(o){o&&(e(p),e(i),e(w),e(U),e(v),e(C),e(J),e(I)),d(j,o),d(k,o),d(T,o)}}}function _e(W){let p,b;return p=new oe({props:{$$slots:{default:[Te]},$$scope:{ctx:W}}}),{c(){c(p.$$.fragment)},l(i){m(p.$$.fragment,i)},m(i,j){u(p,i,j),b=!0},p(i,j){const w={};j&2&&(w.$$scope={dirty:j,ctx:i}),p.$set(w)},i(i){b||(h(p.$$.fragment,i),b=!0)},o(i){f(p.$$.fragment,i),b=!1},d(i){d(p,i)}}}function xe(W){let p,b,i,j,w,U,Z,v,k,C,J,V="Audio classification - just like with text - assigns a class label output from the input data. The only difference is instead of text inputs, you have raw audio waveforms. Some practical applications of audio classification include identifying speaker intent, language classification, and even animal species by their sounds.",I,T,X="This guide will show you how to:",o,x,B='<li>Finetune <a href="https://huggingface.co/facebook/wav2vec2-base" rel="nofollow">Wav2Vec2</a> on the <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MInDS-14</a> dataset to classify speaker intent.</li> <li>Use your finetuned model for inference.</li>',G,R,r,$,Rs="Before you begin, make sure you have all the necessary libraries installed:",Gs,H,Vs,E,Rt="We encourage you to login to your Hugging Face account so you can upload and share your model with the community. When prompted, enter your token to login:",Ys,z,Fs,Q,Ns,A,Xt="Start by loading the MInDS-14 dataset from the 🤗 Datasets library:",Bs,q,Hs,L,Gt='Split the dataset’s <code>train</code> split into a smaller train and test set with the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.train_test_split" rel="nofollow">train_test_split</a> method. This’ll give you a chance to experiment and make sure everything works before spending more time on the full dataset.',Es,S,zs,P,Vt="Then take a look at the dataset:",Qs,D,As,K,Yt='While the dataset contains a lot of useful information, like <code>lang_id</code> and <code>english_transcription</code>, you’ll focus on the <code>audio</code> and <code>intent_class</code> in this guide. Remove the other columns with the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.remove_columns" rel="nofollow">remove_columns</a> method:',qs,O,Ls,ss,Ft="Take a look at an example now:",Ss,ts,Ps,es,Nt="There are two fields:",Ds,as,Bt="<li><code>audio</code>: a 1-dimensional <code>array</code> of the speech signal that must be called to load and resample the audio file.</li> <li><code>intent_class</code>: represents the class id of the speaker’s intent.</li>",Ks,ls,Ht="To make it easier for the model to get the label name from the label id, create a dictionary that maps the label name to an integer and vice versa:",Os,ns,st,ps,Et="Now you can convert the label id to a label name:",tt,is,et,rs,at,os,zt="The next step is to load a Wav2Vec2 feature extractor to process the audio signal:",lt,cs,nt,ms,Qt='The MInDS-14 dataset has a sampling rate of 8000khz (you can find this information in it’s <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">dataset card</a>), which means you’ll need to resample the dataset to 16000kHz to use the pretrained Wav2Vec2 model:',pt,us,it,hs,At="Now create a preprocessing function that:",rt,fs,qt='<li>Calls the <code>audio</code> column to load, and if necessary, resample the audio file.</li> <li>Checks if the sampling rate of the audio file matches the sampling rate of the audio data a model was pretrained with. You can find this information in the Wav2Vec2 <a href="https://huggingface.co/facebook/wav2vec2-base" rel="nofollow">model card</a>.</li> <li>Set a maximum input length to batch longer inputs without truncating them.</li>',ot,ds,ct,gs,Lt='To apply the preprocessing function over the entire dataset, use 🤗 Datasets <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> function. You can speed up <code>map</code> by setting <code>batched=True</code> to process multiple elements of the dataset at once. Remove the columns you don’t need, and rename <code>intent_class</code> to <code>label</code> because that’s the name the model expects:',mt,ys,ut,Ms,ht,bs,St='Including a metric during training is often helpful for evaluating your model’s performance. You can quickly load an evaluation method with the 🤗 <a href="https://huggingface.co/docs/evaluate/index" rel="nofollow">Evaluate</a> library. For this task, load the <a href="https://huggingface.co/spaces/evaluate-metric/accuracy" rel="nofollow">accuracy</a> metric (see the 🤗 Evaluate <a href="https://huggingface.co/docs/evaluate/a_quick_tour" rel="nofollow">quick tour</a> to learn more about how to load and compute a metric):',ft,js,dt,$s,Pt='Then create a function that passes your predictions and labels to <a href="https://huggingface.co/docs/evaluate/main/en/package_reference/main_classes#evaluate.EvaluationModule.compute" rel="nofollow">compute</a> to calculate the accuracy:',gt,ws,yt,Js,Dt="Your <code>compute_metrics</code> function is ready to go now, and you’ll return to it when you setup your training.",Mt,Ts,bt,Y,jt,F,$t,_s,wt,xs,Kt="Great, now that you’ve finetuned a model, you can use it for inference!",Jt,Us,Ot="Load an audio file you’d like to run inference on. Remember to resample the sampling rate of the audio file to match the sampling rate of the model if you need to!",Tt,ks,_t,vs,se='The simplest way to try out your finetuned model for inference is to use it in a <a href="/docs/transformers/pr_29969/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>. Instantiate a <code>pipeline</code> for audio classification with your model, and pass your audio file to it:',xt,Ws,Ut,Zs,te="You can also manually replicate the results of the <code>pipeline</code> if you’d like:",kt,N,vt,Cs,Wt,Xs,Zt;return w=new Is({props:{title:"Audio classification",local:"audio-classification",headingTag:"h1"}}),Z=new ye({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/audio_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/audio_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/audio_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/audio_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/audio_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/audio_classification.ipynb"}]}}),k=new ge({props:{id:"KWwzcmG98Ds"}}),R=new It({props:{$$slots:{default:[be]},$$scope:{ctx:W}}}),H=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwZXZhbHVhdGU=",highlighted:"pip install transformers datasets evaluate",wrap:!1}}),z=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),Q=new Is({props:{title:"Load MInDS-14 dataset",local:"load-minds-14-dataset",headingTag:"h2"}}),q=new _({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZtaW5kczE0JTIyJTJDJTIwbmFtZSUzRCUyMmVuLVVTJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-US&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),S=new _({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.train_test_split(test_size=<span class="hljs-number">0.2</span>)',wrap:!1}}),D=new _({props:{code:"bWluZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;transcription&#x27;</span>, <span class="hljs-string">&#x27;english_transcription&#x27;</span>, <span class="hljs-string">&#x27;intent_class&#x27;</span>, <span class="hljs-string">&#x27;lang_id&#x27;</span>],
        num_rows: <span class="hljs-number">450</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;transcription&#x27;</span>, <span class="hljs-string">&#x27;english_transcription&#x27;</span>, <span class="hljs-string">&#x27;intent_class&#x27;</span>, <span class="hljs-string">&#x27;lang_id&#x27;</span>],
        num_rows: <span class="hljs-number">113</span>
    })
})`,wrap:!1}}),O=new _({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyglNUIlMjJwYXRoJTIyJTJDJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUyQyUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUyQyUyMCUyMmxhbmdfaWQlMjIlNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.remove_columns([<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>, <span class="hljs-string">&quot;lang_id&quot;</span>])',wrap:!1}}),ts=new _({props:{code:"bWluZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;audio&#x27;</span>: {<span class="hljs-string">&#x27;array&#x27;</span>: array([ <span class="hljs-number">0.</span>        ,  <span class="hljs-number">0.</span>        ,  <span class="hljs-number">0.</span>        , ..., -<span class="hljs-number">0.00048828</span>,
         -<span class="hljs-number">0.00024414</span>, -<span class="hljs-number">0.00024414</span>], dtype=float32),
  <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602b9a5fbb1e6d0fbce91f52.wav&#x27;</span>,
  <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">8000</span>},
 <span class="hljs-string">&#x27;intent_class&#x27;</span>: <span class="hljs-number">2</span>}`,wrap:!1}}),ns=new _({props:{code:"bGFiZWxzJTIwJTNEJTIwbWluZHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5uYW1lcyUwQWxhYmVsMmlkJTJDJTIwaWQybGFiZWwlMjAlM0QlMjBkaWN0KCklMkMlMjBkaWN0KCklMEFmb3IlMjBpJTJDJTIwbGFiZWwlMjBpbiUyMGVudW1lcmF0ZShsYWJlbHMpJTNBJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlNUJsYWJlbCU1RCUyMCUzRCUyMHN0cihpKSUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTVCc3RyKGkpJTVEJTIwJTNEJTIwbGFiZWw=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>labels = minds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;intent_class&quot;</span>].names
<span class="hljs-meta">&gt;&gt;&gt; </span>label2id, id2label = <span class="hljs-built_in">dict</span>(), <span class="hljs-built_in">dict</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(labels):
<span class="hljs-meta">... </span>    label2id[label] = <span class="hljs-built_in">str</span>(i)
<span class="hljs-meta">... </span>    id2label[<span class="hljs-built_in">str</span>(i)] = label`,wrap:!1}}),is=new _({props:{code:"aWQybGFiZWwlNUJzdHIoMiklNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>id2label[<span class="hljs-built_in">str</span>(<span class="hljs-number">2</span>)]
<span class="hljs-string">&#x27;app_error&#x27;</span>`,wrap:!1}}),rs=new Is({props:{title:"Preprocess",local:"preprocess",headingTag:"h2"}}),cs=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1iYXNlJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>)`,wrap:!1}}),us=new _({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5jYXN0X2NvbHVtbiglMjJhdWRpbyUyMiUyQyUyMEF1ZGlvKHNhbXBsaW5nX3JhdGUlM0QxNl8wMDApKSUwQW1pbmRzJTVCJTIydHJhaW4lMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>minds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;audio&#x27;</span>: {<span class="hljs-string">&#x27;array&#x27;</span>: array([ <span class="hljs-number">2.2098757e-05</span>,  <span class="hljs-number">4.6582241e-05</span>, -<span class="hljs-number">2.2803260e-05</span>, ...,
         -<span class="hljs-number">2.8419291e-04</span>, -<span class="hljs-number">2.3305941e-04</span>, -<span class="hljs-number">1.1425107e-04</span>], dtype=float32),
  <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602b9a5fbb1e6d0fbce91f52.wav&#x27;</span>,
  <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">16000</span>},
 <span class="hljs-string">&#x27;intent_class&#x27;</span>: <span class="hljs-number">2</span>}`,wrap:!1}}),ds=new _({props:{code:"ZGVmJTIwcHJlcHJvY2Vzc19mdW5jdGlvbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBhdWRpb19hcnJheXMlMjAlM0QlMjAlNUJ4JTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlcyU1QiUyMmF1ZGlvJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fYXJyYXlzJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRGZlYXR1cmVfZXh0cmFjdG9yLnNhbXBsaW5nX3JhdGUlMkMlMjBtYXhfbGVuZ3RoJTNEMTYwMDAlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    audio_arrays = [x[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;audio&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = feature_extractor(
<span class="hljs-meta">... </span>        audio_arrays, sampling_rate=feature_extractor.sampling_rate, max_length=<span class="hljs-number">16000</span>, truncation=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs`,wrap:!1}}),ys=new _({props:{code:"ZW5jb2RlZF9taW5kcyUyMCUzRCUyMG1pbmRzLm1hcChwcmVwcm9jZXNzX2Z1bmN0aW9uJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0QlMjJhdWRpbyUyMiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWVuY29kZWRfbWluZHMlMjAlM0QlMjBlbmNvZGVkX21pbmRzLnJlbmFtZV9jb2x1bW4oJTIyaW50ZW50X2NsYXNzJTIyJTJDJTIwJTIybGFiZWwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_minds = minds.<span class="hljs-built_in">map</span>(preprocess_function, remove_columns=<span class="hljs-string">&quot;audio&quot;</span>, batched=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_minds = encoded_minds.rename_column(<span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>)`,wrap:!1}}),Ms=new Is({props:{title:"Evaluate",local:"evaluate",headingTag:"h2"}}),js=new _({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFhY2N1cmFjeSUyMCUzRCUyMGV2YWx1YXRlLmxvYWQoJTIyYWNjdXJhY3klMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate

<span class="hljs-meta">&gt;&gt;&gt; </span>accuracy = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)`,wrap:!1}}),ws=new _({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG5wLmFyZ21heChldmFsX3ByZWQucHJlZGljdGlvbnMlMkMlMjBheGlzJTNEMSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhY2N1cmFjeS5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEZXZhbF9wcmVkLmxhYmVsX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    predictions = np.argmax(eval_pred.predictions, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> accuracy.compute(predictions=predictions, references=eval_pred.label_ids)`,wrap:!1}}),Ts=new Is({props:{title:"Train",local:"train",headingTag:"h2"}}),Y=new re({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[we]},$$scope:{ctx:W}}}),F=new It({props:{$$slots:{default:[Je]},$$scope:{ctx:W}}}),_s=new Is({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ks=new _({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMlBvbHlBSSUyRm1pbmRzMTQlMjIlMkMlMjBuYW1lJTNEJTIyZW4tVVMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2MDAwKSklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEFhdWRpb19maWxlJTIwJTNEJTIwZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnBhdGglMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-US&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_file = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;path&quot;</span>]`,wrap:!1}}),Ws=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJzdGV2aGxpdSUyRm15X2F3ZXNvbWVfbWluZHNfbW9kZWwlMjIpJTBBY2xhc3NpZmllcihhdWRpb19maWxlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;stevhliu/my_awesome_minds_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(audio_file)
[
    {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.09766869246959686</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cash_deposit&#x27;</span>},
    {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.07998877018690109</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;app_error&#x27;</span>},
    {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0781070664525032</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;joint_account&#x27;</span>},
    {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.07667109370231628</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;pay_bill&#x27;</span>},
    {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0755252093076706</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;balance&#x27;</span>}
]`,wrap:!1}}),N=new re({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[_e]},$$scope:{ctx:W}}}),Cs=new Me({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/audio_classification.md"}}),{c(){p=g("meta"),b=l(),i=g("p"),j=l(),c(w.$$.fragment),U=l(),c(Z.$$.fragment),v=l(),c(k.$$.fragment),C=l(),J=g("p"),J.textContent=V,I=l(),T=g("p"),T.textContent=X,o=l(),x=g("ol"),x.innerHTML=B,G=l(),c(R.$$.fragment),r=l(),$=g("p"),$.textContent=Rs,Gs=l(),c(H.$$.fragment),Vs=l(),E=g("p"),E.textContent=Rt,Ys=l(),c(z.$$.fragment),Fs=l(),c(Q.$$.fragment),Ns=l(),A=g("p"),A.textContent=Xt,Bs=l(),c(q.$$.fragment),Hs=l(),L=g("p"),L.innerHTML=Gt,Es=l(),c(S.$$.fragment),zs=l(),P=g("p"),P.textContent=Vt,Qs=l(),c(D.$$.fragment),As=l(),K=g("p"),K.innerHTML=Yt,qs=l(),c(O.$$.fragment),Ls=l(),ss=g("p"),ss.textContent=Ft,Ss=l(),c(ts.$$.fragment),Ps=l(),es=g("p"),es.textContent=Nt,Ds=l(),as=g("ul"),as.innerHTML=Bt,Ks=l(),ls=g("p"),ls.textContent=Ht,Os=l(),c(ns.$$.fragment),st=l(),ps=g("p"),ps.textContent=Et,tt=l(),c(is.$$.fragment),et=l(),c(rs.$$.fragment),at=l(),os=g("p"),os.textContent=zt,lt=l(),c(cs.$$.fragment),nt=l(),ms=g("p"),ms.innerHTML=Qt,pt=l(),c(us.$$.fragment),it=l(),hs=g("p"),hs.textContent=At,rt=l(),fs=g("ol"),fs.innerHTML=qt,ot=l(),c(ds.$$.fragment),ct=l(),gs=g("p"),gs.innerHTML=Lt,mt=l(),c(ys.$$.fragment),ut=l(),c(Ms.$$.fragment),ht=l(),bs=g("p"),bs.innerHTML=St,ft=l(),c(js.$$.fragment),dt=l(),$s=g("p"),$s.innerHTML=Pt,gt=l(),c(ws.$$.fragment),yt=l(),Js=g("p"),Js.innerHTML=Dt,Mt=l(),c(Ts.$$.fragment),bt=l(),c(Y.$$.fragment),jt=l(),c(F.$$.fragment),$t=l(),c(_s.$$.fragment),wt=l(),xs=g("p"),xs.textContent=Kt,Jt=l(),Us=g("p"),Us.textContent=Ot,Tt=l(),c(ks.$$.fragment),_t=l(),vs=g("p"),vs.innerHTML=se,xt=l(),c(Ws.$$.fragment),Ut=l(),Zs=g("p"),Zs.innerHTML=te,kt=l(),c(N.$$.fragment),vt=l(),c(Cs.$$.fragment),Wt=l(),Xs=g("p"),this.h()},l(s){const t=fe("svelte-u9bgzb",document.head);p=y(t,"META",{name:!0,content:!0}),t.forEach(e),b=n(s),i=y(s,"P",{}),pe(i).forEach(e),j=n(s),m(w.$$.fragment,s),U=n(s),m(Z.$$.fragment,s),v=n(s),m(k.$$.fragment,s),C=n(s),J=y(s,"P",{"data-svelte-h":!0}),M(J)!=="svelte-n3q9of"&&(J.textContent=V),I=n(s),T=y(s,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1aff4p7"&&(T.textContent=X),o=n(s),x=y(s,"OL",{"data-svelte-h":!0}),M(x)!=="svelte-3izmna"&&(x.innerHTML=B),G=n(s),m(R.$$.fragment,s),r=n(s),$=y(s,"P",{"data-svelte-h":!0}),M($)!=="svelte-1c9nexd"&&($.textContent=Rs),Gs=n(s),m(H.$$.fragment,s),Vs=n(s),E=y(s,"P",{"data-svelte-h":!0}),M(E)!=="svelte-k76o1m"&&(E.textContent=Rt),Ys=n(s),m(z.$$.fragment,s),Fs=n(s),m(Q.$$.fragment,s),Ns=n(s),A=y(s,"P",{"data-svelte-h":!0}),M(A)!=="svelte-19euwd1"&&(A.textContent=Xt),Bs=n(s),m(q.$$.fragment,s),Hs=n(s),L=y(s,"P",{"data-svelte-h":!0}),M(L)!=="svelte-q8usl3"&&(L.innerHTML=Gt),Es=n(s),m(S.$$.fragment,s),zs=n(s),P=y(s,"P",{"data-svelte-h":!0}),M(P)!=="svelte-2twqg0"&&(P.textContent=Vt),Qs=n(s),m(D.$$.fragment,s),As=n(s),K=y(s,"P",{"data-svelte-h":!0}),M(K)!=="svelte-tx7o5u"&&(K.innerHTML=Yt),qs=n(s),m(O.$$.fragment,s),Ls=n(s),ss=y(s,"P",{"data-svelte-h":!0}),M(ss)!=="svelte-18u35un"&&(ss.textContent=Ft),Ss=n(s),m(ts.$$.fragment,s),Ps=n(s),es=y(s,"P",{"data-svelte-h":!0}),M(es)!=="svelte-bf7elb"&&(es.textContent=Nt),Ds=n(s),as=y(s,"UL",{"data-svelte-h":!0}),M(as)!=="svelte-1528hkx"&&(as.innerHTML=Bt),Ks=n(s),ls=y(s,"P",{"data-svelte-h":!0}),M(ls)!=="svelte-c16zyh"&&(ls.textContent=Ht),Os=n(s),m(ns.$$.fragment,s),st=n(s),ps=y(s,"P",{"data-svelte-h":!0}),M(ps)!=="svelte-1e9n4a3"&&(ps.textContent=Et),tt=n(s),m(is.$$.fragment,s),et=n(s),m(rs.$$.fragment,s),at=n(s),os=y(s,"P",{"data-svelte-h":!0}),M(os)!=="svelte-f9h4ad"&&(os.textContent=zt),lt=n(s),m(cs.$$.fragment,s),nt=n(s),ms=y(s,"P",{"data-svelte-h":!0}),M(ms)!=="svelte-3ohz7q"&&(ms.innerHTML=Qt),pt=n(s),m(us.$$.fragment,s),it=n(s),hs=y(s,"P",{"data-svelte-h":!0}),M(hs)!=="svelte-8cflje"&&(hs.textContent=At),rt=n(s),fs=y(s,"OL",{"data-svelte-h":!0}),M(fs)!=="svelte-fvrg6s"&&(fs.innerHTML=qt),ot=n(s),m(ds.$$.fragment,s),ct=n(s),gs=y(s,"P",{"data-svelte-h":!0}),M(gs)!=="svelte-cbz02z"&&(gs.innerHTML=Lt),mt=n(s),m(ys.$$.fragment,s),ut=n(s),m(Ms.$$.fragment,s),ht=n(s),bs=y(s,"P",{"data-svelte-h":!0}),M(bs)!=="svelte-1mdztoh"&&(bs.innerHTML=St),ft=n(s),m(js.$$.fragment,s),dt=n(s),$s=y(s,"P",{"data-svelte-h":!0}),M($s)!=="svelte-14irt3v"&&($s.innerHTML=Pt),gt=n(s),m(ws.$$.fragment,s),yt=n(s),Js=y(s,"P",{"data-svelte-h":!0}),M(Js)!=="svelte-183aynn"&&(Js.innerHTML=Dt),Mt=n(s),m(Ts.$$.fragment,s),bt=n(s),m(Y.$$.fragment,s),jt=n(s),m(F.$$.fragment,s),$t=n(s),m(_s.$$.fragment,s),wt=n(s),xs=y(s,"P",{"data-svelte-h":!0}),M(xs)!=="svelte-633ppb"&&(xs.textContent=Kt),Jt=n(s),Us=y(s,"P",{"data-svelte-h":!0}),M(Us)!=="svelte-1j24vrm"&&(Us.textContent=Ot),Tt=n(s),m(ks.$$.fragment,s),_t=n(s),vs=y(s,"P",{"data-svelte-h":!0}),M(vs)!=="svelte-1hbn800"&&(vs.innerHTML=se),xt=n(s),m(Ws.$$.fragment,s),Ut=n(s),Zs=y(s,"P",{"data-svelte-h":!0}),M(Zs)!=="svelte-1njl8vm"&&(Zs.innerHTML=te),kt=n(s),m(N.$$.fragment,s),vt=n(s),m(Cs.$$.fragment,s),Wt=n(s),Xs=y(s,"P",{}),pe(Xs).forEach(e),this.h()},h(){ie(p,"name","hf:doc:metadata"),ie(p,"content",Ue)},m(s,t){de(document.head,p),a(s,b,t),a(s,i,t),a(s,j,t),u(w,s,t),a(s,U,t),u(Z,s,t),a(s,v,t),u(k,s,t),a(s,C,t),a(s,J,t),a(s,I,t),a(s,T,t),a(s,o,t),a(s,x,t),a(s,G,t),u(R,s,t),a(s,r,t),a(s,$,t),a(s,Gs,t),u(H,s,t),a(s,Vs,t),a(s,E,t),a(s,Ys,t),u(z,s,t),a(s,Fs,t),u(Q,s,t),a(s,Ns,t),a(s,A,t),a(s,Bs,t),u(q,s,t),a(s,Hs,t),a(s,L,t),a(s,Es,t),u(S,s,t),a(s,zs,t),a(s,P,t),a(s,Qs,t),u(D,s,t),a(s,As,t),a(s,K,t),a(s,qs,t),u(O,s,t),a(s,Ls,t),a(s,ss,t),a(s,Ss,t),u(ts,s,t),a(s,Ps,t),a(s,es,t),a(s,Ds,t),a(s,as,t),a(s,Ks,t),a(s,ls,t),a(s,Os,t),u(ns,s,t),a(s,st,t),a(s,ps,t),a(s,tt,t),u(is,s,t),a(s,et,t),u(rs,s,t),a(s,at,t),a(s,os,t),a(s,lt,t),u(cs,s,t),a(s,nt,t),a(s,ms,t),a(s,pt,t),u(us,s,t),a(s,it,t),a(s,hs,t),a(s,rt,t),a(s,fs,t),a(s,ot,t),u(ds,s,t),a(s,ct,t),a(s,gs,t),a(s,mt,t),u(ys,s,t),a(s,ut,t),u(Ms,s,t),a(s,ht,t),a(s,bs,t),a(s,ft,t),u(js,s,t),a(s,dt,t),a(s,$s,t),a(s,gt,t),u(ws,s,t),a(s,yt,t),a(s,Js,t),a(s,Mt,t),u(Ts,s,t),a(s,bt,t),u(Y,s,t),a(s,jt,t),u(F,s,t),a(s,$t,t),u(_s,s,t),a(s,wt,t),a(s,xs,t),a(s,Jt,t),a(s,Us,t),a(s,Tt,t),u(ks,s,t),a(s,_t,t),a(s,vs,t),a(s,xt,t),u(Ws,s,t),a(s,Ut,t),a(s,Zs,t),a(s,kt,t),u(N,s,t),a(s,vt,t),u(Cs,s,t),a(s,Wt,t),a(s,Xs,t),Zt=!0},p(s,[t]){const ee={};t&2&&(ee.$$scope={dirty:t,ctx:s}),R.$set(ee);const ae={};t&2&&(ae.$$scope={dirty:t,ctx:s}),Y.$set(ae);const le={};t&2&&(le.$$scope={dirty:t,ctx:s}),F.$set(le);const ne={};t&2&&(ne.$$scope={dirty:t,ctx:s}),N.$set(ne)},i(s){Zt||(h(w.$$.fragment,s),h(Z.$$.fragment,s),h(k.$$.fragment,s),h(R.$$.fragment,s),h(H.$$.fragment,s),h(z.$$.fragment,s),h(Q.$$.fragment,s),h(q.$$.fragment,s),h(S.$$.fragment,s),h(D.$$.fragment,s),h(O.$$.fragment,s),h(ts.$$.fragment,s),h(ns.$$.fragment,s),h(is.$$.fragment,s),h(rs.$$.fragment,s),h(cs.$$.fragment,s),h(us.$$.fragment,s),h(ds.$$.fragment,s),h(ys.$$.fragment,s),h(Ms.$$.fragment,s),h(js.$$.fragment,s),h(ws.$$.fragment,s),h(Ts.$$.fragment,s),h(Y.$$.fragment,s),h(F.$$.fragment,s),h(_s.$$.fragment,s),h(ks.$$.fragment,s),h(Ws.$$.fragment,s),h(N.$$.fragment,s),h(Cs.$$.fragment,s),Zt=!0)},o(s){f(w.$$.fragment,s),f(Z.$$.fragment,s),f(k.$$.fragment,s),f(R.$$.fragment,s),f(H.$$.fragment,s),f(z.$$.fragment,s),f(Q.$$.fragment,s),f(q.$$.fragment,s),f(S.$$.fragment,s),f(D.$$.fragment,s),f(O.$$.fragment,s),f(ts.$$.fragment,s),f(ns.$$.fragment,s),f(is.$$.fragment,s),f(rs.$$.fragment,s),f(cs.$$.fragment,s),f(us.$$.fragment,s),f(ds.$$.fragment,s),f(ys.$$.fragment,s),f(Ms.$$.fragment,s),f(js.$$.fragment,s),f(ws.$$.fragment,s),f(Ts.$$.fragment,s),f(Y.$$.fragment,s),f(F.$$.fragment,s),f(_s.$$.fragment,s),f(ks.$$.fragment,s),f(Ws.$$.fragment,s),f(N.$$.fragment,s),f(Cs.$$.fragment,s),Zt=!1},d(s){s&&(e(b),e(i),e(j),e(U),e(v),e(C),e(J),e(I),e(T),e(o),e(x),e(G),e(r),e($),e(Gs),e(Vs),e(E),e(Ys),e(Fs),e(Ns),e(A),e(Bs),e(Hs),e(L),e(Es),e(zs),e(P),e(Qs),e(As),e(K),e(qs),e(Ls),e(ss),e(Ss),e(Ps),e(es),e(Ds),e(as),e(Ks),e(ls),e(Os),e(st),e(ps),e(tt),e(et),e(at),e(os),e(lt),e(nt),e(ms),e(pt),e(it),e(hs),e(rt),e(fs),e(ot),e(ct),e(gs),e(mt),e(ut),e(ht),e(bs),e(ft),e(dt),e($s),e(gt),e(yt),e(Js),e(Mt),e(bt),e(jt),e($t),e(wt),e(xs),e(Jt),e(Us),e(Tt),e(_t),e(vs),e(xt),e(Ut),e(Zs),e(kt),e(vt),e(Wt),e(Xs)),e(p),d(w,s),d(Z,s),d(k,s),d(R,s),d(H,s),d(z,s),d(Q,s),d(q,s),d(S,s),d(D,s),d(O,s),d(ts,s),d(ns,s),d(is,s),d(rs,s),d(cs,s),d(us,s),d(ds,s),d(ys,s),d(Ms,s),d(js,s),d(ws,s),d(Ts,s),d(Y,s),d(F,s),d(_s,s),d(ks,s),d(Ws,s),d(N,s),d(Cs,s)}}}const Ue='{"title":"Audio classification","local":"audio-classification","sections":[{"title":"Load MInDS-14 dataset","local":"load-minds-14-dataset","sections":[],"depth":2},{"title":"Preprocess","local":"preprocess","sections":[],"depth":2},{"title":"Evaluate","local":"evaluate","sections":[],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function ke(W){return me(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ve extends ue{constructor(p){super(),he(this,p,ke,xe,ce,{})}}export{Ve as component};
