import{s as Nt,o as Qt,n as ht}from"../chunks/scheduler.6062bdaf.js";import{S as Wt,i as Ft,g as i,s as l,r as h,A as zt,h as r,f as a,c as s,j as Rt,u as f,x as d,k as Bt,y as Pt,a as n,v as c,d as u,t as g,w as m}from"../chunks/index.4bca734e.js";import{T as pt}from"../chunks/Tip.b9ac1f03.js";import{C as $}from"../chunks/CodeBlock.fa01571c.js";import{H as _,E as Dt}from"../chunks/EditOnGithub.74ab2baa.js";function St(y){let o,w=`The returned filepath is a pointer to the HF local cache. Therefore, it is important to not modify the file to avoid
having a corrupted cache. If you are interested in getting to know more about how files are cached, please refer to our
<a href="./manage-cache">caching guide</a>.`;return{c(){o=i("p"),o.innerHTML=w},l(p){o=r(p,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1jtqj65"&&(o.innerHTML=w)},m(p,b){n(p,o,b)},p:ht,d(p){p&&a(o)}}}function Vt(y){let o,w='Don’t worry about the <code>.cache/huggingface/</code> folder when committing changes to the Hub! This folder is automatically ignored by both <code>git</code> and <a href="/docs/huggingface_hub/pr_2413/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>.';return{c(){o=i("p"),o.innerHTML=w},l(p){o=r(p,"P",{"data-svelte-h":!0}),d(o)!=="svelte-i703io"&&(o.innerHTML=w)},m(p,b){n(p,o,b)},p:ht,d(p){p&&a(o)}}}function Et(y){let o,w=`<code>hf_transfer</code> is a power user tool!
It is tested and production-ready,
but it lacks user-friendly features like advanced error handling or proxies.
For more details, please take a look at this <a href="https://huggingface.co/docs/huggingface_hub/hf_transfer" rel="nofollow">section</a>.`;return{c(){o=i("p"),o.innerHTML=w},l(p){o=r(p,"P",{"data-svelte-h":!0}),d(o)!=="svelte-ac3n7l"&&(o.innerHTML=w)},m(p,b){n(p,o,b)},p:ht,d(p){p&&a(o)}}}function Kt(y){let o,w,p,b,j,me,J,ft=`The <code>huggingface_hub</code> library provides functions to download files from the repositories
stored on the Hub. You can use these functions independently or integrate them into your
own library, making it more convenient for your users to interact with the Hub. This
guide will show you how to:`,we,H,ct="<li>Download and cache a single file.</li> <li>Download and cache an entire repository.</li> <li>Download files to a local folder.</li>",be,k,_e,x,ut=`The <a href="/docs/huggingface_hub/pr_2413/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> function is the main function for downloading files from the Hub.
It downloads the remote file, caches it on disk (in a version-aware way), and returns its local file path.`,$e,M,ye,Z,Me,q,gt=`Select the file to download using the <code>repo_id</code>, <code>repo_type</code> and <code>filename</code> parameters. By default, the file will
be considered as being part of a <code>model</code> repo.`,ve,U,Te,L,je,Y,mt=`By default, the latest version from the <code>main</code> branch is downloaded. However, in some cases you want to download a file
at a particular version (e.g. from a specific branch, a PR, a tag or a commit hash).
To do so, use the <code>revision</code> parameter:`,Je,C,He,G,wt="<strong>Note:</strong> When using the commit hash, it must be the full-length hash instead of a 7-character commit hash.",ke,I,xe,X,bt=`In case you want to construct the URL used to download a file from a repo, you can use <a href="/docs/huggingface_hub/pr_2413/en/package_reference/file_download#huggingface_hub.hf_hub_url">hf_hub_url()</a> which returns a URL.
Note that it is used internally by <a href="/docs/huggingface_hub/pr_2413/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a>.`,Ze,R,qe,B,_t=`<a href="/docs/huggingface_hub/pr_2413/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> downloads an entire repository at a given revision. It uses internally <a href="/docs/huggingface_hub/pr_2413/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> which
means all downloaded files are also cached on your local disk. Downloads are made concurrently to speed-up the process.`,Ue,N,$t="To download a whole repository, just pass the <code>repo_id</code> and <code>repo_type</code>:",Le,Q,Ye,W,yt=`<a href="/docs/huggingface_hub/pr_2413/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> downloads the latest revision by default. If you want a specific repository revision, use the
<code>revision</code> parameter:`,Ce,F,Ge,z,Ie,P,Mt=`<a href="/docs/huggingface_hub/pr_2413/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> provides an easy way to download a repository. However, you don’t always want to download the
entire content of a repository. For example, you might want to prevent downloading all <code>.bin</code> files if you know you’ll
only use the <code>.safetensors</code> weights. You can do that using <code>allow_patterns</code> and <code>ignore_patterns</code> parameters.`,Xe,D,vt=`These parameters accept either a single pattern or a list of patterns. Patterns are Standard Wildcards (globbing
patterns) as documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>. The pattern matching is
based on <a href="https://docs.python.org/3/library/fnmatch.html" rel="nofollow"><code>fnmatch</code></a>.`,Re,S,Tt="For example, you can use <code>allow_patterns</code> to only download JSON configuration files:",Be,V,Ne,E,jt=`On the other hand, <code>ignore_patterns</code> can exclude certain files from being downloaded. The
following example ignores the <code>.msgpack</code> and <code>.h5</code> file extensions:`,Qe,K,We,A,Jt=`Finally, you can combine both to precisely filter your download. Here is an example to download all json and markdown
files except <code>vocab.json</code>.`,Fe,O,ze,ee,Pe,te,Ht='By default, we recommend using the <a href="./manage-cache">cache system</a> to download files from the Hub. You can specify a custom cache location using the <code>cache_dir</code> parameter in <a href="/docs/huggingface_hub/pr_2413/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/pr_2413/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a>, or by setting the <a href="../package_reference/environment_variables#hf_home"><code>HF_HOME</code></a> environment variable.',De,ae,kt="However, if you need to download files to a specific folder, you can pass a <code>local_dir</code> parameter to the download function. This is useful to get a workflow closer to what the <code>git</code> command offers. The downloaded files will maintain their original file structure within the specified folder. For example, if <code>filename=&quot;data/train.csv&quot;</code> and <code>local_dir=&quot;path/to/folder&quot;</code>, the resulting filepath will be <code>&quot;path/to/folder/data/train.csv&quot;</code>.",Se,ne,xt="A <code>./huggingface/</code> folder is created at the root of your local directory containing metadata about the downloaded files. This prevents re-downloading files if they’re already up-to-date. If the metadata has changed, then the new file version is downloaded. This makes the <code>local_dir</code> optimized for pulling only the latest changes.",Ve,le,Zt="After completing the download, you can safely remove the <code>.cache/huggingface/</code> folder if you no longer need it. However, be aware that re-running your script without this folder may result in longer recovery times, as metadata will be lost. Rest assured that your local data will remain intact and unaffected.",Ee,v,Ke,se,Ae,oe,qt=`You can use the <code>huggingface-cli download</code> command from the terminal to directly download files from the Hub.
Internally, it uses the same <a href="/docs/huggingface_hub/pr_2413/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/pr_2413/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> helpers described above and prints the
returned path to the terminal.`,Oe,ie,et,re,Ut=`You can download multiple files at once which displays a progress bar and returns the snapshot path in which the files
are located:`,tt,de,at,pe,Lt='For more details about the CLI download command, please refer to the <a href="./cli#huggingface-cli-download">CLI guide</a>.',nt,he,lt,fe,Yt=`If you are running on a machine with high bandwidth,
you can increase your download speed with <a href="https://github.com/huggingface/hf_transfer" rel="nofollow"><code>hf_transfer</code></a>,
a Rust-based library developed to speed up file transfers with the Hub.
To enable it:`,st,ce,Ct=`<li>Specify the <code>hf_transfer</code> extra when installing <code>huggingface_hub</code>
(e.g. <code>pip install huggingface_hub[hf_transfer]</code>).</li> <li>Set <code>HF_HUB_ENABLE_HF_TRANSFER=1</code> as an environment variable.</li>`,ot,T,it,ue,rt,ge,dt;return j=new _({props:{title:"Download files from the Hub",local:"download-files-from-the-hub",headingTag:"h1"}}),k=new _({props:{title:"Download a single file",local:"download-a-single-file",headingTag:"h2"}}),M=new pt({props:{$$slots:{default:[St]},$$scope:{ctx:y}}}),Z=new _({props:{title:"From latest version",local:"from-latest-version",headingTag:"h3"}}),U=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIyZ29vZ2xlJTJGZmxldXJzJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJmbGV1cnMucHklMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade/config.json&#x27;</span>

<span class="hljs-comment"># Download from a dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, filename=<span class="hljs-string">&quot;fleurs.py&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34/fleurs.py&#x27;</span>`,wrap:!1}}),L=new _({props:{title:"From specific version",local:"from-specific-version",headingTag:"h3"}}),C=new $({props:{code:"aGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnYxLjAlMjIpJTBBJTBBaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnRlc3QtYnJhbmNoJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYzJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI4NzdiODRhOGY5M2YyZDYxOWZhYTJhNmU1MTRhMzJiZWVmODhhYjBhJTIyKQ==",highlighted:`<span class="hljs-comment"># Download from the \`v1.0\` tag</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;v1.0&quot;</span>)

<span class="hljs-comment"># Download from the \`test-branch\` branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;test-branch&quot;</span>)

<span class="hljs-comment"># Download from Pull Request #3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/3&quot;</span>)

<span class="hljs-comment"># Download from a specific commit hash</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;877b84a8f93f2d619faa2a6e514a32beef88ab0a&quot;</span>)`,wrap:!1}}),I=new _({props:{title:"Construct a download URL",local:"construct-a-download-url",headingTag:"h3"}}),R=new _({props:{title:"Download an entire repository",local:"download-an-entire-repository",headingTag:"h2"}}),Q=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyKSUwQSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlM0QlMjJnb29nbGUlMkZmbGV1cnMlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade&#x27;</span>

<span class="hljs-comment"># Or from a dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34&#x27;</span>`,wrap:!1}}),F=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/1&quot;</span>)`,wrap:!1}}),z=new _({props:{title:"Filter files to download",local:"filter-files-to-download",headingTag:"h3"}}),V=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwYWxsb3dfcGF0dGVybnMlM0QlMjIqLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, allow_patterns=<span class="hljs-string">&quot;*.json&quot;</span>)`,wrap:!1}}),K=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwaWdub3JlX3BhdHRlcm5zJTNEJTVCJTIyKi5tc2dwYWNrJTIyJTJDJTIwJTIyKi5oNSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, ignore_patterns=[<span class="hljs-string">&quot;*.msgpack&quot;</span>, <span class="hljs-string">&quot;*.h5&quot;</span>])`,wrap:!1}}),O=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmdwdDIlMjIlMkMlMjBhbGxvd19wYXR0ZXJucyUzRCU1QiUyMioubWQlMjIlMkMlMjAlMjIqLmpzb24lMjIlNUQlMkMlMjBpZ25vcmVfcGF0dGVybnMlM0QlMjJ2b2NhYi5qc29uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;gpt2&quot;</span>, allow_patterns=[<span class="hljs-string">&quot;*.md&quot;</span>, <span class="hljs-string">&quot;*.json&quot;</span>], ignore_patterns=<span class="hljs-string">&quot;vocab.json&quot;</span>)`,wrap:!1}}),ee=new _({props:{title:"Download file(s) to a local folder",local:"download-files-to-a-local-folder",headingTag:"h2"}}),v=new pt({props:{$$slots:{default:[Vt]},$$scope:{ctx:y}}}),se=new _({props:{title:"Download from the CLI",local:"download-from-the-cli",headingTag:"h2"}}),ie=new $({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24=",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),de=new $({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24lMjBtb2RlbC5zYWZldGVuc29ycw==",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json model.safetensors
Fetching 2 files: 100%|████████████████████████████████████████████| 2/2 [00:00&lt;00:00, 23831.27it/s]
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`,wrap:!1}}),he=new _({props:{title:"Faster downloads",local:"faster-downloads",headingTag:"h2"}}),T=new pt({props:{warning:!0,$$slots:{default:[Et]},$$scope:{ctx:y}}}),ue=new Dt({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/download.md"}}),{c(){o=i("meta"),w=l(),p=i("p"),b=l(),h(j.$$.fragment),me=l(),J=i("p"),J.innerHTML=ft,we=l(),H=i("ul"),H.innerHTML=ct,be=l(),h(k.$$.fragment),_e=l(),x=i("p"),x.innerHTML=ut,$e=l(),h(M.$$.fragment),ye=l(),h(Z.$$.fragment),Me=l(),q=i("p"),q.innerHTML=gt,ve=l(),h(U.$$.fragment),Te=l(),h(L.$$.fragment),je=l(),Y=i("p"),Y.innerHTML=mt,Je=l(),h(C.$$.fragment),He=l(),G=i("p"),G.innerHTML=wt,ke=l(),h(I.$$.fragment),xe=l(),X=i("p"),X.innerHTML=bt,Ze=l(),h(R.$$.fragment),qe=l(),B=i("p"),B.innerHTML=_t,Ue=l(),N=i("p"),N.innerHTML=$t,Le=l(),h(Q.$$.fragment),Ye=l(),W=i("p"),W.innerHTML=yt,Ce=l(),h(F.$$.fragment),Ge=l(),h(z.$$.fragment),Ie=l(),P=i("p"),P.innerHTML=Mt,Xe=l(),D=i("p"),D.innerHTML=vt,Re=l(),S=i("p"),S.innerHTML=Tt,Be=l(),h(V.$$.fragment),Ne=l(),E=i("p"),E.innerHTML=jt,Qe=l(),h(K.$$.fragment),We=l(),A=i("p"),A.innerHTML=Jt,Fe=l(),h(O.$$.fragment),ze=l(),h(ee.$$.fragment),Pe=l(),te=i("p"),te.innerHTML=Ht,De=l(),ae=i("p"),ae.innerHTML=kt,Se=l(),ne=i("p"),ne.innerHTML=xt,Ve=l(),le=i("p"),le.innerHTML=Zt,Ee=l(),h(v.$$.fragment),Ke=l(),h(se.$$.fragment),Ae=l(),oe=i("p"),oe.innerHTML=qt,Oe=l(),h(ie.$$.fragment),et=l(),re=i("p"),re.textContent=Ut,tt=l(),h(de.$$.fragment),at=l(),pe=i("p"),pe.innerHTML=Lt,nt=l(),h(he.$$.fragment),lt=l(),fe=i("p"),fe.innerHTML=Yt,st=l(),ce=i("ol"),ce.innerHTML=Ct,ot=l(),h(T.$$.fragment),it=l(),h(ue.$$.fragment),rt=l(),ge=i("p"),this.h()},l(e){const t=zt("svelte-u9bgzb",document.head);o=r(t,"META",{name:!0,content:!0}),t.forEach(a),w=s(e),p=r(e,"P",{}),Rt(p).forEach(a),b=s(e),f(j.$$.fragment,e),me=s(e),J=r(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-10amgpw"&&(J.innerHTML=ft),we=s(e),H=r(e,"UL",{"data-svelte-h":!0}),d(H)!=="svelte-1jcodts"&&(H.innerHTML=ct),be=s(e),f(k.$$.fragment,e),_e=s(e),x=r(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-p0tbjc"&&(x.innerHTML=ut),$e=s(e),f(M.$$.fragment,e),ye=s(e),f(Z.$$.fragment,e),Me=s(e),q=r(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-18kdxej"&&(q.innerHTML=gt),ve=s(e),f(U.$$.fragment,e),Te=s(e),f(L.$$.fragment,e),je=s(e),Y=r(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-16duplw"&&(Y.innerHTML=mt),Je=s(e),f(C.$$.fragment,e),He=s(e),G=r(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1inqh8h"&&(G.innerHTML=wt),ke=s(e),f(I.$$.fragment,e),xe=s(e),X=r(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-eupply"&&(X.innerHTML=bt),Ze=s(e),f(R.$$.fragment,e),qe=s(e),B=r(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-8sf005"&&(B.innerHTML=_t),Ue=s(e),N=r(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-18b676r"&&(N.innerHTML=$t),Le=s(e),f(Q.$$.fragment,e),Ye=s(e),W=r(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-rzbq6q"&&(W.innerHTML=yt),Ce=s(e),f(F.$$.fragment,e),Ge=s(e),f(z.$$.fragment,e),Ie=s(e),P=r(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1c4algk"&&(P.innerHTML=Mt),Xe=s(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-u3vbhu"&&(D.innerHTML=vt),Re=s(e),S=r(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1dn885x"&&(S.innerHTML=Tt),Be=s(e),f(V.$$.fragment,e),Ne=s(e),E=r(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-uzetax"&&(E.innerHTML=jt),Qe=s(e),f(K.$$.fragment,e),We=s(e),A=r(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-ndvph"&&(A.innerHTML=Jt),Fe=s(e),f(O.$$.fragment,e),ze=s(e),f(ee.$$.fragment,e),Pe=s(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1y7v6ou"&&(te.innerHTML=Ht),De=s(e),ae=r(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-7dqi55"&&(ae.innerHTML=kt),Se=s(e),ne=r(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-d979n2"&&(ne.innerHTML=xt),Ve=s(e),le=r(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-9mgyuw"&&(le.innerHTML=Zt),Ee=s(e),f(v.$$.fragment,e),Ke=s(e),f(se.$$.fragment,e),Ae=s(e),oe=r(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-3jbd9b"&&(oe.innerHTML=qt),Oe=s(e),f(ie.$$.fragment,e),et=s(e),re=r(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-c19wqr"&&(re.textContent=Ut),tt=s(e),f(de.$$.fragment,e),at=s(e),pe=r(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-n4le8a"&&(pe.innerHTML=Lt),nt=s(e),f(he.$$.fragment,e),lt=s(e),fe=r(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-7tg4bb"&&(fe.innerHTML=Yt),st=s(e),ce=r(e,"OL",{"data-svelte-h":!0}),d(ce)!=="svelte-qiartd"&&(ce.innerHTML=Ct),ot=s(e),f(T.$$.fragment,e),it=s(e),f(ue.$$.fragment,e),rt=s(e),ge=r(e,"P",{}),Rt(ge).forEach(a),this.h()},h(){Bt(o,"name","hf:doc:metadata"),Bt(o,"content",At)},m(e,t){Pt(document.head,o),n(e,w,t),n(e,p,t),n(e,b,t),c(j,e,t),n(e,me,t),n(e,J,t),n(e,we,t),n(e,H,t),n(e,be,t),c(k,e,t),n(e,_e,t),n(e,x,t),n(e,$e,t),c(M,e,t),n(e,ye,t),c(Z,e,t),n(e,Me,t),n(e,q,t),n(e,ve,t),c(U,e,t),n(e,Te,t),c(L,e,t),n(e,je,t),n(e,Y,t),n(e,Je,t),c(C,e,t),n(e,He,t),n(e,G,t),n(e,ke,t),c(I,e,t),n(e,xe,t),n(e,X,t),n(e,Ze,t),c(R,e,t),n(e,qe,t),n(e,B,t),n(e,Ue,t),n(e,N,t),n(e,Le,t),c(Q,e,t),n(e,Ye,t),n(e,W,t),n(e,Ce,t),c(F,e,t),n(e,Ge,t),c(z,e,t),n(e,Ie,t),n(e,P,t),n(e,Xe,t),n(e,D,t),n(e,Re,t),n(e,S,t),n(e,Be,t),c(V,e,t),n(e,Ne,t),n(e,E,t),n(e,Qe,t),c(K,e,t),n(e,We,t),n(e,A,t),n(e,Fe,t),c(O,e,t),n(e,ze,t),c(ee,e,t),n(e,Pe,t),n(e,te,t),n(e,De,t),n(e,ae,t),n(e,Se,t),n(e,ne,t),n(e,Ve,t),n(e,le,t),n(e,Ee,t),c(v,e,t),n(e,Ke,t),c(se,e,t),n(e,Ae,t),n(e,oe,t),n(e,Oe,t),c(ie,e,t),n(e,et,t),n(e,re,t),n(e,tt,t),c(de,e,t),n(e,at,t),n(e,pe,t),n(e,nt,t),c(he,e,t),n(e,lt,t),n(e,fe,t),n(e,st,t),n(e,ce,t),n(e,ot,t),c(T,e,t),n(e,it,t),c(ue,e,t),n(e,rt,t),n(e,ge,t),dt=!0},p(e,[t]){const Gt={};t&2&&(Gt.$$scope={dirty:t,ctx:e}),M.$set(Gt);const It={};t&2&&(It.$$scope={dirty:t,ctx:e}),v.$set(It);const Xt={};t&2&&(Xt.$$scope={dirty:t,ctx:e}),T.$set(Xt)},i(e){dt||(u(j.$$.fragment,e),u(k.$$.fragment,e),u(M.$$.fragment,e),u(Z.$$.fragment,e),u(U.$$.fragment,e),u(L.$$.fragment,e),u(C.$$.fragment,e),u(I.$$.fragment,e),u(R.$$.fragment,e),u(Q.$$.fragment,e),u(F.$$.fragment,e),u(z.$$.fragment,e),u(V.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(v.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(de.$$.fragment,e),u(he.$$.fragment,e),u(T.$$.fragment,e),u(ue.$$.fragment,e),dt=!0)},o(e){g(j.$$.fragment,e),g(k.$$.fragment,e),g(M.$$.fragment,e),g(Z.$$.fragment,e),g(U.$$.fragment,e),g(L.$$.fragment,e),g(C.$$.fragment,e),g(I.$$.fragment,e),g(R.$$.fragment,e),g(Q.$$.fragment,e),g(F.$$.fragment,e),g(z.$$.fragment,e),g(V.$$.fragment,e),g(K.$$.fragment,e),g(O.$$.fragment,e),g(ee.$$.fragment,e),g(v.$$.fragment,e),g(se.$$.fragment,e),g(ie.$$.fragment,e),g(de.$$.fragment,e),g(he.$$.fragment,e),g(T.$$.fragment,e),g(ue.$$.fragment,e),dt=!1},d(e){e&&(a(w),a(p),a(b),a(me),a(J),a(we),a(H),a(be),a(_e),a(x),a($e),a(ye),a(Me),a(q),a(ve),a(Te),a(je),a(Y),a(Je),a(He),a(G),a(ke),a(xe),a(X),a(Ze),a(qe),a(B),a(Ue),a(N),a(Le),a(Ye),a(W),a(Ce),a(Ge),a(Ie),a(P),a(Xe),a(D),a(Re),a(S),a(Be),a(Ne),a(E),a(Qe),a(We),a(A),a(Fe),a(ze),a(Pe),a(te),a(De),a(ae),a(Se),a(ne),a(Ve),a(le),a(Ee),a(Ke),a(Ae),a(oe),a(Oe),a(et),a(re),a(tt),a(at),a(pe),a(nt),a(lt),a(fe),a(st),a(ce),a(ot),a(it),a(rt),a(ge)),a(o),m(j,e),m(k,e),m(M,e),m(Z,e),m(U,e),m(L,e),m(C,e),m(I,e),m(R,e),m(Q,e),m(F,e),m(z,e),m(V,e),m(K,e),m(O,e),m(ee,e),m(v,e),m(se,e),m(ie,e),m(de,e),m(he,e),m(T,e),m(ue,e)}}}const At='{"title":"Download files from the Hub","local":"download-files-from-the-hub","sections":[{"title":"Download a single file","local":"download-a-single-file","sections":[{"title":"From latest version","local":"from-latest-version","sections":[],"depth":3},{"title":"From specific version","local":"from-specific-version","sections":[],"depth":3},{"title":"Construct a download URL","local":"construct-a-download-url","sections":[],"depth":3}],"depth":2},{"title":"Download an entire repository","local":"download-an-entire-repository","sections":[{"title":"Filter files to download","local":"filter-files-to-download","sections":[],"depth":3}],"depth":2},{"title":"Download file(s) to a local folder","local":"download-files-to-a-local-folder","sections":[],"depth":2},{"title":"Download from the CLI","local":"download-from-the-cli","sections":[],"depth":2},{"title":"Faster downloads","local":"faster-downloads","sections":[],"depth":2}],"depth":1}';function Ot(y){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sa extends Wt{constructor(o){super(),Ft(this,o,Ot,Kt,Nt,{})}}export{sa as component};
