import{s as ns,o as ss,n as wn}from"../chunks/scheduler.6062bdaf.js";import{S as ts,i as as,g as i,s as a,r,A as ls,h as c,f as s,c as l,j as On,u as g,x as m,k as es,y as ps,a as t,v as o,d as h,t as f,w as u}from"../chunks/index.4bca734e.js";import{T as Un}from"../chunks/Tip.b9ac1f03.js";import{C as M}from"../chunks/CodeBlock.fa01571c.js";import{H as _,E as is}from"../chunks/EditOnGithub.74ab2baa.js";function cs(b){let p,j='이 섹션에서는 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a>, <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>, <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>, <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a> 및 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.delete">delete()</a> 등의 메소드를 살펴볼 것입니다. 모든 메소드는 편의를 위해 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a>에 추가된 별칭입니다. 원한다면 <code>HfApi</code>에 정의된 일반 메소드 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>, <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>, <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>, <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">update_inference_endpoint()</a> 및 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">delete_inference_endpoint()</a>를 사용할 수도 있습니다.';return{c(){p=i("p"),p.innerHTML=j},l(d){p=c(d,"P",{"data-svelte-h":!0}),m(p)!=="svelte-1uesphp"&&(p.innerHTML=j)},m(d,y){t(d,p,y)},p:wn,d(d){d&&s(p)}}}function rs(b){let p,j='<em>일시 중지</em> 또는 <em>0으로 스케일링</em>된 추론 엔드포인트는 비용이 들지 않습니다. 이 두 가지의 차이점은 <em>일시 중지</em> 엔드포인트는 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>를 사용하여 명시적으로 <em>재개</em>해야 한다는 것입니다. 반대로 <em>0으로 스케일링</em>된 엔드포인트는 추론 호출이 있으면 추가 콜드 스타트 지연과 함께 자동으로 시작됩니다. 추론 엔드포인트는 일정 기간 비활성화된 후 자동으로 0으로 스케일링되도록 구성할 수도 있습니다.';return{c(){p=i("p"),p.innerHTML=j},l(d){p=c(d,"P",{"data-svelte-h":!0}),m(p)!=="svelte-yyxm19"&&(p.innerHTML=j)},m(d,y){t(d,p,y)},p:wn,d(d){d&&s(p)}}}function gs(b){let p,j="이것은 돌이킬 수 없는 작업이며, 구성, 로그 및 사용 메트릭을 포함한 엔드포인트를 완전히 제거합니다. 삭제된 추론 엔드포인트는 복원할 수 없습니다.";return{c(){p=i("p"),p.textContent=j},l(d){p=c(d,"P",{"data-svelte-h":!0}),m(p)!=="svelte-17xt5jf"&&(p.textContent=j)},m(d,y){t(d,p,y)},p:wn,d(d){d&&s(p)}}}function os(b){let p,j,d,y,x,$e,T,xn=`추론 엔드포인트는 Hugging Face가 관리하는 전용 및 자동 확장 인프라에 <code>transformers</code>, <code>sentence-transformers</code> 및 <code>diffusers</code> 모델을 쉽게 배포할 수 있는 안전한 프로덕션 솔루션을 제공합니다. 추론 엔드포인트는 <a href="https://huggingface.co/models" rel="nofollow">Hub</a>의 모델로 구축됩니다.
이 가이드에서는 <code>huggingface_hub</code>를 사용하여 프로그래밍 방식으로 추론 엔드포인트를 관리하는 방법을 배웁니다. 추론 엔드포인트 제품 자체에 대한 자세한 내용은 <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">공식 문서</a>를 참조하세요.`,Ue,k,Tn='이 가이드에서는 <code>huggingface_hub</code>가 올바르게 설치 및 로그인되어 있다고 가정합니다. 아직 그렇지 않은 경우 <a href="https://huggingface.co/docs/huggingface_hub/quick-start#quickstart" rel="nofollow">빠른 시작 가이드</a>를 참조하세요. 추론 엔드포인트 API를 지원하는 최소 버전은 <code>v0.19.0</code>입니다.',we,C,xe,I,kn='첫 번째 단계는 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>를 사용하여 추론 엔드포인트를 생성하는 것입니다:',Te,J,ke,Z,Cn='예시에서는 <code>&quot;my-endpoint-name&quot;</code>라는 <code>protected</code> 추론 엔드포인트를 생성하여 <code>text-generation</code>을 위한 <a href="https://huggingface.co/gpt2" rel="nofollow">gpt2</a>를 제공합니다. <code>protected</code> 추론 엔드포인트 API에 액세스하려면 토큰이 필요합니다. 또한 벤더, 지역, 액셀러레이터, 인스턴스 유형, 크기와 같은 하드웨어 요구 사항을 구성하기 위한 추가 정보를 제공해야 합니다. 사용 가능한 리소스 목록은 <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aprovider/list_vendors" rel="nofollow">여기</a>에서 확인할 수 있습니다. 또한 <a href="https://ui.endpoints.huggingface.co/new" rel="nofollow">웹 인터페이스</a>를 사용하여 편리하게 수동으로 추론 엔드포인트를 생성할 수 있습니다. 고급 설정 및 사용법에 대한 자세한 내용은 <a href="https://huggingface.co/docs/inference-endpoints/guides/advanced" rel="nofollow">이 가이드</a>를 참조하세요.',Ce,E,In='<a href="/docs/huggingface_hub/pr_2383/ko/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>에서 반환된 값은 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> 개체입니다:',Ie,W,Je,q,Jn="이것은 엔드포인트에 대한 정보를 저장하는 데이터클래스입니다. <code>name</code>, <code>repository</code>, <code>status</code>, <code>task</code>, <code>created_at</code>, <code>updated_at</code> 등과 같은 중요한 속성에 접근할 수 있습니다. 필요한 경우 <code>endpoint.raw</code>를 통해 서버로부터의 원시 응답에도 접근할 수 있습니다.",Ze,v,Zn='추론 엔드포인트가 생성되면 <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">개인 대시보드</a>에서 확인할 수 있습니다.',Ee,H,En='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/inference_endpoints_created.png"/>',We,Q,qe,A,Wn='기본적으로 추론 엔드포인트는 Hugging Face에서 제공하는 도커 이미지로 구축됩니다. 그러나 <code>custom_image</code> 매개변수를 사용하여 모든 도커 이미지를 지정할 수 있습니다. 일반적인 사용 사례는 <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">text-generation-inference</a> 프레임워크를 사용하여 LLM을 실행하는 것입니다. 다음과 같이 수행할 수 있습니다:',ve,B,He,V,qn='<code>custom_image</code>에 전달할 값은 도커 컨테이너의 URL과 이를 실행하기 위한 구성이 포함된 딕셔너리입니다. 자세한 내용은 <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aendpoint/create_endpoint" rel="nofollow">Swagger 문서</a>를 참조하세요.',Qe,X,Ae,L,vn='경우에 따라 이전에 생성한 추론 엔드포인트를 관리해야 할 수 있습니다. 이름을 알고 있는 경우 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/hf_api#huggingface_hub.HfApi.get_inference_endpoint">get_inference_endpoint()</a>를 사용하여 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> 개체를 가져올 수 있습니다. 또는 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/hf_api#huggingface_hub.HfApi.list_inference_endpoints">list_inference_endpoints()</a>를 사용하여 모든 추론 엔드포인트 리스트를 검색할 수 있습니다. 두 메소드 모두 선택적 <code>namespace</code> 매개변수를 허용합니다. 속해 있는 조직의 <code>namespace</code>를 설정할 수 있습니다. 그렇지 않으면 기본적으로 사용자 이름이 사용됩니다.',Be,G,Ve,N,Xe,Y,Hn='이 가이드의 나머지 부분에서는 <code>endpoint</code>라는 이름의 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> 객체를 가지고 있다고 가정합니다. 엔드포인트에 <code>status</code> 속성이 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointStatus">InferenceEndpointStatus</a> 유형이라는 것을 알 수 있었습니다. 추론 엔드포인트가 배포되고 접근 가능하면 상태가 <code>&quot;running&quot;</code>이 되고 <code>url</code> 속성이 설정됩니다:',Le,R,Ge,S,Qn='<code>추론 엔드포인트가 &quot;running&quot;</code> 상태에 도달하기 전에 일반적으로 <code>&quot;initializing&quot;</code> 또는 <code>&quot;pending&quot;</code> 단계를 거칩니다. <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.fetch">fetch()</a>를 실행하여 엔드포인트의 새로운 상태를 가져올 수 있습니다. <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a>의 다른 메소드와 마찬가지로 이 메소드는 서버에 요청을 하며, <code>endpoint</code>의 내부 속성이 변경됩니다:',Ne,z,Ye,F,An='추론 엔드포인트가 실행될 때까지 기다리면서 상태를 가져오는 대신 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.wait">wait()</a>를 직접 호출할 수 있습니다. 이 헬퍼는 <code>timeout</code>과 <code>fetch_every</code> 매개변수를 입력으로 받아 (초 단위) 추론 엔드포인트가 배포될 때까지 스레드를 차단합니다. 기본값은 각각 <code>None</code>(제한 시간 없음)과 <code>5</code>초입니다.',Re,P,Se,K,Bn="<code>timeout</code>이 설정되어 있고 추론 엔드포인트를 불러오는 데 너무 오래 걸리면, <code>InferenceEndpointTimeoutError</code> 제한 시간 초과 오류가 발생합니다.",ze,D,Fe,O,Vn="추론 엔드포인트가 실행되면, 마침내 추론을 실행할 수 있습니다!",Pe,ee,Xn='<a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a>에는 각각 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>와 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>를 반환하는 <code>client</code>와 <code>async_client</code> 속성이 있습니다.',Ke,ne,De,se,Ln='추론 엔드포인트가 실행 중이 아니면 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError">InferenceEndpointError</a> 오류가 발생합니다:',Oe,te,en,ae,Gn='<a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>를 사용하는 방법에 대한 자세한 내용은 <a href="../guides/inference">추론 가이드</a>를 참조하세요.',nn,le,sn,pe,Nn="이제 추론 엔드포인트를 생성하고 추론을 실행하는 방법을 살펴보았으니, 라이프사이클을 관리하는 방법을 살펴봅시다.",tn,$,an,ie,ln,ce,Yn='추론 엔드포인트를 사용하지 않을 때 비용을 절감하기 위해 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a>를 사용하여 일시 중지하거나 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>를 사용하여 0으로 스케일링할 수 있습니다.',pn,U,cn,re,rn,ge,gn,oe,Rn='경우에 따라 새로운 엔드포인트를 생성하지 않고 추론 엔드포인트를 업데이트하고 싶을 수 있습니다. 호스팅된 모델이나 모델 실행에 필요한 하드웨어 요구 사항을 업데이트할 수 있습니다. 이렇게 하려면 <a href="/docs/huggingface_hub/pr_2383/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a>를 사용합니다:',on,he,hn,fe,fn,ue,Sn="마지막으로 더 이상 추론 엔드포인트를 사용하지 않을 경우, <code>~InferenceEndpoint.delete()</code>를 호출하기만 하면 됩니다.",un,w,mn,me,dn,de,zn="추론 엔드포인트의 일반적인 사용 사례는 한 번에 여러 개의 작업을 처리하여 인프라 비용을 제한하는 것입니다. 이 가이드에서 본 것을 사용하여 이 프로세스를 자동화할 수 있습니다:",jn,je,Mn,Me,Fn="또는 추론 엔드포인트가 이미 존재하고 일시 중지된 경우:",_n,_e,yn,ye,bn,be,$n;return x=new _({props:{title:"추론 엔드포인트",local:"inference-endpoints",headingTag:"h1"}}),C=new _({props:{title:"추론 엔드포인트 생성",local:"create-an-inference-endpoint",headingTag:"h2"}}),J=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybXktZW5kcG9pbnQtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyaW50ZWwtaWNsJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;my-endpoint-name&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;gpt2&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new M({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),Q=new _({props:{title:"사용자 정의 이미지 사용",local:"using-a-custom-image",headingTag:"h4"}}),B=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyYXdzLXplcGh5ci03Yi1iZXRhLTA0ODYlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvc2l0b3J5JTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmdwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDElMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIybnZpZGlhLWExMGclMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21faW1hZ2UlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWFsdGhfcm91dGUlMjIlM0ElMjAlMjIlMkZoZWFsdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlMjIlM0ElMjAlMjIyMDQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX0xFTkdUSCUyMiUzQSUyMCUyMjEwMjQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0ExLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># TGI에서 Zephyr-7b-beta를 실행하는 추론 엔드포인트 시작하기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;aws-zephyr-7b-beta-0486&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>,
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:1.1.0&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)`,wrap:!1}}),X=new _({props:{title:"기존 추론 엔드포인트 가져오기 또는 리스트 조회",local:"get-or-list-existing-inference-endpoints",headingTag:"h3"}}),G=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMEElMEFnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMm15LWVuZHBvaW50LW5hbWUlMjIpJTBBJTBBbGlzdF9pbmZlcmVuY2VfZW5kcG9pbnRzKG5hbWVzcGFjZSUzRCUyMmh1Z2dpbmdmYWNlJTIyKSUwQSUwQWxpc3RfaW5mZXJlbmNlX2VuZHBvaW50cyhuYW1lc3BhY2UlM0QlMjIqJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint, list_inference_endpoints

<span class="hljs-comment"># 엔드포인트 개체 가져오기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>get_inference_endpoint(<span class="hljs-string">&quot;my-endpoint-name&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># 조직의 모든 추론 엔드포인트 나열</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;huggingface&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]

<span class="hljs-comment"># 사용자가 속해있는 모든 조직의 엔드포인트 나열</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;*&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]`,wrap:!1}}),N=new _({props:{title:"배포 상태 확인",local:"check-deployment-status",headingTag:"h2"}}),R=new M({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),z=new M({props:{code:"ZW5kcG9pbnQuZmV0Y2goKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.fetch()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),P=new M({props:{code:"ZW5kcG9pbnQlMEElMEFlbmRwb2ludC53YWl0KHRpbWVvdXQlM0QxMCklMEElMEFlbmRwb2ludC53YWl0KCk=",highlighted:`<span class="hljs-comment"># 엔드포인트 보류</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># 10초 대기 =&gt; InferenceEndpointTimeoutError 발생</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait(timeout=<span class="hljs-number">10</span>)
    <span class="hljs-keyword">raise</span> InferenceEndpointTimeoutError(<span class="hljs-string">&quot;Timeout while waiting for Inference Endpoint to be deployed.&quot;</span>)
huggingface_hub._inference_endpoints.InferenceEndpointTimeoutError: Timeout <span class="hljs-keyword">while</span> waiting <span class="hljs-keyword">for</span> Inference Endpoint to be deployed.

<span class="hljs-comment"># 추가 대기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),D=new _({props:{title:"추론 실행",local:"run-inference",headingTag:"h2"}}),ne=new M({props:{code:"ZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJJJTIwYW0lMjIpJTBBJTBBYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMkklMjBhbSUyMik=",highlighted:`<span class="hljs-comment"># 텍스트 생성 작업 실행:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)
<span class="hljs-string">&#x27; not a fan of the idea of a &quot;big-budget&quot; movie. I think it\\&#x27;s a&#x27;</span>

<span class="hljs-comment"># 비동기 컨텍스트에서도 마찬가지로 실행:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> endpoint.async_client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)`,wrap:!1}}),te=new M({props:{code:"ZW5kcG9pbnQuY2xpZW50",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client\nhuggingface_hub._inference_endpoints.InferenceEndpointError: Cannot create a client <span class="hljs-keyword">for</span> this Inference Endpoint <span class="hljs-keyword">as</span> it <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> yet deployed. Please wait <span class="hljs-keyword">for</span> the Inference Endpoint to be deployed using `endpoint.wait()` <span class="hljs-keyword">and</span> <span class="hljs-keyword">try</span> again.',wrap:!1}}),le=new _({props:{title:"라이프사이클 관리",local:"manage-lifecycle",headingTag:"h2"}}),$=new Un({props:{$$slots:{default:[cs]},$$scope:{ctx:b}}}),ie=new _({props:{title:"일시 중지 또는 0으로 확장",local:"pause-or-scale-to-zero",headingTag:"h3"}}),U=new Un({props:{$$slots:{default:[rs]},$$scope:{ctx:b}}}),re=new M({props:{code:"ZW5kcG9pbnQucGF1c2UoKSUwQWVuZHBvaW50LnJlc3VtZSgpJTBBZW5kcG9pbnQud2FpdCgpLmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUwQSUwQWVuZHBvaW50LnNjYWxlX3RvX3plcm8oKQ==",highlighted:`<span class="hljs-comment"># 엔드포인트 일시중지 및 재시작</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.resume()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait().client.text_generation(...)
...

<span class="hljs-comment"># 0으로 스케일링</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.scale_to_zero()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;scaledToZero&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)
<span class="hljs-comment"># 엔드포인트는 &#x27;running&#x27;은 아니지만 URL�을 가지고 있으며 첫 번째 호출 시 다시 시작됩니다.</span>`,wrap:!1}}),ge=new _({props:{title:"모델 또는 하드웨어 요구 사항 업데이트",local:"update-model-or-hardware-requirements",headingTag:"h3"}}),he=new M({props:{code:"ZW5kcG9pbnQudXBkYXRlKHJlcG9zaXRvcnklM0QlMjJncHQyLWxhcmdlJTIyKSUwQSUwQWVuZHBvaW50LnVwZGF0ZShtaW5fcmVwbGljYSUzRDIlMkMlMjBtYXhfcmVwbGljYSUzRDYpJTBBJTBBZW5kcG9pbnQudXBkYXRlKGFjY2VsZXJhdG9yJTNEJTIyY3B1JTIyJTJDJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMng0JTIyJTJDJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmludGVsLWljbCUyMik=",highlighted:`<span class="hljs-comment"># 타겟 모델 변경</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(repository=<span class="hljs-string">&quot;gpt2-large&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># 복제본 갯수 업데이트</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(min_replica=<span class="hljs-number">2</span>, max_replica=<span class="hljs-number">6</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># 더 큰 인스턴스로 업데이트</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(accelerator=<span class="hljs-string">&quot;cpu&quot;</span>, instance_size=<span class="hljs-string">&quot;x4&quot;</span>, instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),fe=new _({props:{title:"엔드포인트 삭제",local:"delete-the-endpoint",headingTag:"h3"}}),w=new Un({props:{warning:!0,$$slots:{default:[gs]},$$scope:{ctx:b}}}),me=new _({props:{title:"엔드 투 엔드 예제 an-end-to-end-example",local:"엔드-투-엔드-예제-an-end-to-end-example",headingTag:"h2"}}),je=new M({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50KG5hbWUlM0QlMjJiYXRjaC1lbmRwb2ludCUyMiUyQy4uLikud2FpdCgpJTBBJTBBY2xpZW50JTIwJTNEJTIwZW5kcG9pbnQuY2xpZW50JTBBcmVzdWx0cyUyMCUzRCUyMCU1QmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCUwQSUwQWFzeW5jX2NsaWVudCUyMCUzRCUyMGVuZHBvaW50LmFzeW5jX2NsaWVudCUwQXJlc3VsdHMlMjAlM0QlMjBhc3luY2lvLmdhdGhlcigqJTVCYXN5bmNfY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4pJTIwZm9yJTIwam9iJTIwaW4lMjBqb2JzJTVEKSUwQSUwQWVuZHBvaW50LnBhdXNlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-comment"># 엔드포인트 시작 + 초기화될 때까지 대기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(name=<span class="hljs-string">&quot;batch-endpoint&quot;</span>,...).wait()

<span class="hljs-comment"># 추론 실행</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = endpoint.client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = [client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs]

<span class="hljs-comment"># 비동기 추론 실행</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># 엔드포인트 중지</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),_e=new M({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMmJhdGNoLWVuZHBvaW50JTIyKS5yZXN1bWUoKS53YWl0KCklMEElMEFhc3luY19jbGllbnQlMjAlM0QlMjBlbmRwb2ludC5hc3luY19jbGllbnQlMEFyZXN1bHRzJTIwJTNEJTIwYXN5bmNpby5nYXRoZXIoKiU1QmFzeW5jX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCklMEElMEFlbmRwb2ludC5wYXVzZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint

<span class="hljs-comment"># 엔드포인트 가져오기 + 초기화될 때까지 대기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = get_inference_endpoint(<span class="hljs-string">&quot;batch-endpoint&quot;</span>).resume().wait()

<span class="hljs-comment"># 추론 실행</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># 엔드포인트 중지</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),ye=new is({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/guides/inference_endpoints.md"}}),{c(){p=i("meta"),j=a(),d=i("p"),y=a(),r(x.$$.fragment),$e=a(),T=i("p"),T.innerHTML=xn,Ue=a(),k=i("p"),k.innerHTML=Tn,we=a(),r(C.$$.fragment),xe=a(),I=i("p"),I.innerHTML=kn,Te=a(),r(J.$$.fragment),ke=a(),Z=i("p"),Z.innerHTML=Cn,Ce=a(),E=i("p"),E.innerHTML=In,Ie=a(),r(W.$$.fragment),Je=a(),q=i("p"),q.innerHTML=Jn,Ze=a(),v=i("p"),v.innerHTML=Zn,Ee=a(),H=i("p"),H.innerHTML=En,We=a(),r(Q.$$.fragment),qe=a(),A=i("p"),A.innerHTML=Wn,ve=a(),r(B.$$.fragment),He=a(),V=i("p"),V.innerHTML=qn,Qe=a(),r(X.$$.fragment),Ae=a(),L=i("p"),L.innerHTML=vn,Be=a(),r(G.$$.fragment),Ve=a(),r(N.$$.fragment),Xe=a(),Y=i("p"),Y.innerHTML=Hn,Le=a(),r(R.$$.fragment),Ge=a(),S=i("p"),S.innerHTML=Qn,Ne=a(),r(z.$$.fragment),Ye=a(),F=i("p"),F.innerHTML=An,Re=a(),r(P.$$.fragment),Se=a(),K=i("p"),K.innerHTML=Bn,ze=a(),r(D.$$.fragment),Fe=a(),O=i("p"),O.textContent=Vn,Pe=a(),ee=i("p"),ee.innerHTML=Xn,Ke=a(),r(ne.$$.fragment),De=a(),se=i("p"),se.innerHTML=Ln,Oe=a(),r(te.$$.fragment),en=a(),ae=i("p"),ae.innerHTML=Gn,nn=a(),r(le.$$.fragment),sn=a(),pe=i("p"),pe.textContent=Nn,tn=a(),r($.$$.fragment),an=a(),r(ie.$$.fragment),ln=a(),ce=i("p"),ce.innerHTML=Yn,pn=a(),r(U.$$.fragment),cn=a(),r(re.$$.fragment),rn=a(),r(ge.$$.fragment),gn=a(),oe=i("p"),oe.innerHTML=Rn,on=a(),r(he.$$.fragment),hn=a(),r(fe.$$.fragment),fn=a(),ue=i("p"),ue.innerHTML=Sn,un=a(),r(w.$$.fragment),mn=a(),r(me.$$.fragment),dn=a(),de=i("p"),de.textContent=zn,jn=a(),r(je.$$.fragment),Mn=a(),Me=i("p"),Me.textContent=Fn,_n=a(),r(_e.$$.fragment),yn=a(),r(ye.$$.fragment),bn=a(),be=i("p"),this.h()},l(e){const n=ls("svelte-u9bgzb",document.head);p=c(n,"META",{name:!0,content:!0}),n.forEach(s),j=l(e),d=c(e,"P",{}),On(d).forEach(s),y=l(e),g(x.$$.fragment,e),$e=l(e),T=c(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-ah66md"&&(T.innerHTML=xn),Ue=l(e),k=c(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1ql8zue"&&(k.innerHTML=Tn),we=l(e),g(C.$$.fragment,e),xe=l(e),I=c(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-xxnod2"&&(I.innerHTML=kn),Te=l(e),g(J.$$.fragment,e),ke=l(e),Z=c(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1aqjns7"&&(Z.innerHTML=Cn),Ce=l(e),E=c(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-kry8hd"&&(E.innerHTML=In),Ie=l(e),g(W.$$.fragment,e),Je=l(e),q=c(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-qy7mei"&&(q.innerHTML=Jn),Ze=l(e),v=c(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-q97gnz"&&(v.innerHTML=Zn),Ee=l(e),H=c(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1tajtyl"&&(H.innerHTML=En),We=l(e),g(Q.$$.fragment,e),qe=l(e),A=c(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-52wlj1"&&(A.innerHTML=Wn),ve=l(e),g(B.$$.fragment,e),He=l(e),V=c(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-kvtuxg"&&(V.innerHTML=qn),Qe=l(e),g(X.$$.fragment,e),Ae=l(e),L=c(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-rpdxqh"&&(L.innerHTML=vn),Be=l(e),g(G.$$.fragment,e),Ve=l(e),g(N.$$.fragment,e),Xe=l(e),Y=c(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-136lf6k"&&(Y.innerHTML=Hn),Le=l(e),g(R.$$.fragment,e),Ge=l(e),S=c(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-djor9o"&&(S.innerHTML=Qn),Ne=l(e),g(z.$$.fragment,e),Ye=l(e),F=c(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1f5t4p5"&&(F.innerHTML=An),Re=l(e),g(P.$$.fragment,e),Se=l(e),K=c(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1su15dj"&&(K.innerHTML=Bn),ze=l(e),g(D.$$.fragment,e),Fe=l(e),O=c(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-mbyh0u"&&(O.textContent=Vn),Pe=l(e),ee=c(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-anggtq"&&(ee.innerHTML=Xn),Ke=l(e),g(ne.$$.fragment,e),De=l(e),se=c(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1o69qqm"&&(se.innerHTML=Ln),Oe=l(e),g(te.$$.fragment,e),en=l(e),ae=c(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-15rbcme"&&(ae.innerHTML=Gn),nn=l(e),g(le.$$.fragment,e),sn=l(e),pe=c(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-d4vepm"&&(pe.textContent=Nn),tn=l(e),g($.$$.fragment,e),an=l(e),g(ie.$$.fragment,e),ln=l(e),ce=c(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-80g3a1"&&(ce.innerHTML=Yn),pn=l(e),g(U.$$.fragment,e),cn=l(e),g(re.$$.fragment,e),rn=l(e),g(ge.$$.fragment,e),gn=l(e),oe=c(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-15a5viq"&&(oe.innerHTML=Rn),on=l(e),g(he.$$.fragment,e),hn=l(e),g(fe.$$.fragment,e),fn=l(e),ue=c(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-16aox72"&&(ue.innerHTML=Sn),un=l(e),g(w.$$.fragment,e),mn=l(e),g(me.$$.fragment,e),dn=l(e),de=c(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-4lg1fr"&&(de.textContent=zn),jn=l(e),g(je.$$.fragment,e),Mn=l(e),Me=c(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-5upsam"&&(Me.textContent=Fn),_n=l(e),g(_e.$$.fragment,e),yn=l(e),g(ye.$$.fragment,e),bn=l(e),be=c(e,"P",{}),On(be).forEach(s),this.h()},h(){es(p,"name","hf:doc:metadata"),es(p,"content",hs)},m(e,n){ps(document.head,p),t(e,j,n),t(e,d,n),t(e,y,n),o(x,e,n),t(e,$e,n),t(e,T,n),t(e,Ue,n),t(e,k,n),t(e,we,n),o(C,e,n),t(e,xe,n),t(e,I,n),t(e,Te,n),o(J,e,n),t(e,ke,n),t(e,Z,n),t(e,Ce,n),t(e,E,n),t(e,Ie,n),o(W,e,n),t(e,Je,n),t(e,q,n),t(e,Ze,n),t(e,v,n),t(e,Ee,n),t(e,H,n),t(e,We,n),o(Q,e,n),t(e,qe,n),t(e,A,n),t(e,ve,n),o(B,e,n),t(e,He,n),t(e,V,n),t(e,Qe,n),o(X,e,n),t(e,Ae,n),t(e,L,n),t(e,Be,n),o(G,e,n),t(e,Ve,n),o(N,e,n),t(e,Xe,n),t(e,Y,n),t(e,Le,n),o(R,e,n),t(e,Ge,n),t(e,S,n),t(e,Ne,n),o(z,e,n),t(e,Ye,n),t(e,F,n),t(e,Re,n),o(P,e,n),t(e,Se,n),t(e,K,n),t(e,ze,n),o(D,e,n),t(e,Fe,n),t(e,O,n),t(e,Pe,n),t(e,ee,n),t(e,Ke,n),o(ne,e,n),t(e,De,n),t(e,se,n),t(e,Oe,n),o(te,e,n),t(e,en,n),t(e,ae,n),t(e,nn,n),o(le,e,n),t(e,sn,n),t(e,pe,n),t(e,tn,n),o($,e,n),t(e,an,n),o(ie,e,n),t(e,ln,n),t(e,ce,n),t(e,pn,n),o(U,e,n),t(e,cn,n),o(re,e,n),t(e,rn,n),o(ge,e,n),t(e,gn,n),t(e,oe,n),t(e,on,n),o(he,e,n),t(e,hn,n),o(fe,e,n),t(e,fn,n),t(e,ue,n),t(e,un,n),o(w,e,n),t(e,mn,n),o(me,e,n),t(e,dn,n),t(e,de,n),t(e,jn,n),o(je,e,n),t(e,Mn,n),t(e,Me,n),t(e,_n,n),o(_e,e,n),t(e,yn,n),o(ye,e,n),t(e,bn,n),t(e,be,n),$n=!0},p(e,[n]){const Pn={};n&2&&(Pn.$$scope={dirty:n,ctx:e}),$.$set(Pn);const Kn={};n&2&&(Kn.$$scope={dirty:n,ctx:e}),U.$set(Kn);const Dn={};n&2&&(Dn.$$scope={dirty:n,ctx:e}),w.$set(Dn)},i(e){$n||(h(x.$$.fragment,e),h(C.$$.fragment,e),h(J.$$.fragment,e),h(W.$$.fragment,e),h(Q.$$.fragment,e),h(B.$$.fragment,e),h(X.$$.fragment,e),h(G.$$.fragment,e),h(N.$$.fragment,e),h(R.$$.fragment,e),h(z.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(ne.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h($.$$.fragment,e),h(ie.$$.fragment,e),h(U.$$.fragment,e),h(re.$$.fragment,e),h(ge.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),h(w.$$.fragment,e),h(me.$$.fragment,e),h(je.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),$n=!0)},o(e){f(x.$$.fragment,e),f(C.$$.fragment,e),f(J.$$.fragment,e),f(W.$$.fragment,e),f(Q.$$.fragment,e),f(B.$$.fragment,e),f(X.$$.fragment,e),f(G.$$.fragment,e),f(N.$$.fragment,e),f(R.$$.fragment,e),f(z.$$.fragment,e),f(P.$$.fragment,e),f(D.$$.fragment,e),f(ne.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f($.$$.fragment,e),f(ie.$$.fragment,e),f(U.$$.fragment,e),f(re.$$.fragment,e),f(ge.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(w.$$.fragment,e),f(me.$$.fragment,e),f(je.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),$n=!1},d(e){e&&(s(j),s(d),s(y),s($e),s(T),s(Ue),s(k),s(we),s(xe),s(I),s(Te),s(ke),s(Z),s(Ce),s(E),s(Ie),s(Je),s(q),s(Ze),s(v),s(Ee),s(H),s(We),s(qe),s(A),s(ve),s(He),s(V),s(Qe),s(Ae),s(L),s(Be),s(Ve),s(Xe),s(Y),s(Le),s(Ge),s(S),s(Ne),s(Ye),s(F),s(Re),s(Se),s(K),s(ze),s(Fe),s(O),s(Pe),s(ee),s(Ke),s(De),s(se),s(Oe),s(en),s(ae),s(nn),s(sn),s(pe),s(tn),s(an),s(ln),s(ce),s(pn),s(cn),s(rn),s(gn),s(oe),s(on),s(hn),s(fn),s(ue),s(un),s(mn),s(dn),s(de),s(jn),s(Mn),s(Me),s(_n),s(yn),s(bn),s(be)),s(p),u(x,e),u(C,e),u(J,e),u(W,e),u(Q,e),u(B,e),u(X,e),u(G,e),u(N,e),u(R,e),u(z,e),u(P,e),u(D,e),u(ne,e),u(te,e),u(le,e),u($,e),u(ie,e),u(U,e),u(re,e),u(ge,e),u(he,e),u(fe,e),u(w,e),u(me,e),u(je,e),u(_e,e),u(ye,e)}}}const hs='{"title":"추론 엔드포인트","local":"inference-endpoints","sections":[{"title":"추론 엔드포인트 생성","local":"create-an-inference-endpoint","sections":[{"title":"사용자 정의 이미지 사용","local":"using-a-custom-image","sections":[],"depth":4},{"title":"기존 추론 엔드포인트 가져오기 또는 리스트 조회","local":"get-or-list-existing-inference-endpoints","sections":[],"depth":3}],"depth":2},{"title":"배포 상태 확인","local":"check-deployment-status","sections":[],"depth":2},{"title":"추론 실행","local":"run-inference","sections":[],"depth":2},{"title":"라이프사이클 관리","local":"manage-lifecycle","sections":[{"title":"일시 중지 또는 0으로 확장","local":"pause-or-scale-to-zero","sections":[],"depth":3},{"title":"모델 또는 하드웨어 요구 사항 업데이트","local":"update-model-or-hardware-requirements","sections":[],"depth":3},{"title":"엔드포인트 삭제","local":"delete-the-endpoint","sections":[],"depth":3}],"depth":2},{"title":"엔드 투 엔드 예제 an-end-to-end-example","local":"엔드-투-엔드-예제-an-end-to-end-example","sections":[],"depth":2}],"depth":1}';function fs(b){return ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends ts{constructor(p){super(),as(this,p,fs,os,ns,{})}}export{_s as component};
