import{s as Ea,o as Ha,n as ma}from"../chunks/scheduler.bdbef820.js";import{S as Xa,i as Va,g as r,s as n,r as h,A as Wa,h as o,f as t,c as l,j as qa,u as m,x as i,k as za,y as Da,a as e,v as c,d,t as u,w as f}from"../chunks/index.c0aea24a.js";import{T as ha}from"../chunks/Tip.31005f7d.js";import{C as y}from"../chunks/CodeBlock.6ccca92e.js";import{H as U,E as Ya}from"../chunks/EditOnGithub.725ee0c1.js";function Aa(b){let p,j='A <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object is a wrapper of an Arrow table, which allows fast reads from arrays in the dataset to TensorFlow tensors.';return{c(){p=r("p"),p.innerHTML=j},l(g){p=o(g,"P",{"data-svelte-h":!0}),i(p)!=="svelte-1l503fq"&&(p.innerHTML=j)},m(g,M){e(g,p,M)},p:ma,d(g){g&&t(p)}}}function La(b){let p,j=`To use the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Image">Image</a> feature type, you’ll need to install the <code>vision</code> extra as
<code>pip install datasets[vision]</code>.`;return{c(){p=r("p"),p.innerHTML=j},l(g){p=o(g,"P",{"data-svelte-h":!0}),i(p)!=="svelte-xg4rve"&&(p.innerHTML=j)},m(g,M){e(g,p,M)},p:ma,d(g){g&&t(p)}}}function Ba(b){let p,j=`To use the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Audio">Audio</a> feature type, you’ll need to install the <code>audio</code> extra as
<code>pip install datasets[audio]</code>.`;return{c(){p=r("p"),p.innerHTML=j},l(g){p=o(g,"P",{"data-svelte-h":!0}),i(p)!=="svelte-n4tni4"&&(p.innerHTML=j)},m(g,M){e(g,p,M)},p:ma,d(g){g&&t(p)}}}function Sa(b){let p,j,g,M,$,gs,C,ca=`This document is a quick introduction to using <code>datasets</code> with TensorFlow, with a particular focus on how to get
<code>tf.Tensor</code> objects out of our datasets, and how to stream data from Hugging Face <code>Dataset</code> objects to Keras methods
like <code>model.fit()</code>.`,js,R,ys,I,da="By default, datasets return regular Python objects: integers, floats, strings, lists, etc.",Ms,_,ua="To get TensorFlow tensors instead, you can set the format of the dataset to <code>tf</code>:",bs,v,Ts,T,ws,k,fa=`This can be useful for converting your dataset to a dict of <code>Tensor</code> objects, or for writing a generator to load TF
samples from it. If you wish to convert the entire dataset to <code>Tensor</code>, simply query the full dataset:`,Js,x,Us,Q,$s,Z,ga="If your dataset consists of N-dimensional arrays, you will see that by default they are considered as the same tensor if the shape is fixed:",Cs,N,Rs,G,ja="Otherwise, a TensorFlow formatted dataset outputs a <code>RaggedTensor</code> instead of a single tensor:",Is,F,_s,q,ya=`However this logic often requires slow shape comparisons and data copies.
To avoid this, you must explicitly use the <code>Array</code> feature type and specify the shape of your tensors:`,vs,z,ks,E,xs,H,Ma='<a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.ClassLabel">ClassLabel</a> data are properly converted to tensors:',Qs,X,Zs,V,ba="Strings and binary objects are also supported:",Ns,W,Gs,D,Ta="You can also explicitly format certain columns and leave the other columns unformatted:",Fs,Y,qs,A,wa="String and binary objects are unchanged, since PyTorch only supports numbers.",zs,L,Ja='The <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Image">Image</a> and <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Audio">Audio</a> feature types are also supported.',Es,w,Hs,B,Xs,J,Vs,S,Ws,P,Ds,K,Ua=`Although you can load individual samples and batches just by indexing into your dataset, this won’t work if you want
to use Keras methods like <code>fit()</code> and <code>predict()</code>. You could write a generator function that shuffles and loads batches
from your dataset and <code>fit()</code> on that, but that sounds like a lot of unnecessary work. Instead, if you want to stream
data from your dataset on-the-fly, we recommend converting your dataset to a <code>tf.data.Dataset</code> using the
<code>to_tf_dataset()</code> method.`,Ys,O,$a=`The <code>tf.data.Dataset</code> class covers a wide range of use-cases - it is often created from Tensors in memory, or using a load function to read files on disc
or external storage. The dataset can be transformed arbitrarily with the <code>map()</code> method, or methods like <code>batch()</code>
and <code>shuffle()</code> can be used to create a dataset that’s ready for training. These methods do not modify the stored data
in any way - instead, the methods build a data pipeline graph that will be executed when the dataset is iterated over,
usually during model training or inference. This is different from the <code>map()</code> method of Hugging Face <code>Dataset</code> objects,
which runs the map function immediately and saves the new or changed columns.`,As,ss,Ca=`Since the entire data preprocessing pipeline can be compiled in a <code>tf.data.Dataset</code>, this approach allows for massively
parallel, asynchronous data loading and training. However, the requirement for graph compilation can be a limitation,
particularly for Hugging Face tokenizers, which are usually not (yet!) compilable as part of a TF graph. As a result,
we usually advise pre-processing the dataset as a Hugging Face dataset, where arbitrary Python functions can be
used, and then converting to <code>tf.data.Dataset</code> afterwards using <code>to_tf_dataset()</code> to get a batched dataset ready for
training. To see examples of this approach, please see the <a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">examples</a> or <a href="https://huggingface.co/docs/transformers/notebooks" rel="nofollow">notebooks</a> for <code>transformers</code>.`,Ls,as,Bs,ts,Ra="Using <code>to_tf_dataset()</code> is straightforward. Once your dataset is preprocessed and ready, simply call it like so:",Ss,es,Ps,ns,Ia=`The returned <code>tf_ds</code> object here is now fully ready to train on, and can be passed directly to <code>model.fit()</code>. Note
that you set the batch size when creating the dataset, and so you don’t need to specify it when calling <code>fit()</code>:`,Ks,ls,Os,ps,_a=`For a full description of the arguments, please see the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.to_tf_dataset">to_tf_dataset()</a> documentation. In many cases,
you will also need to add a <code>collate_fn</code> to your call. This is a function that takes multiple elements of the dataset
and combines them into a single batch. When all elements have the same length, the built-in default collator will
suffice, but for more complex tasks a custom collator may be necessary. In particular, many tasks have samples
with varying sequence lengths which will require a <a href="https://huggingface.co/docs/transformers/main/en/main_classes/data_collator" rel="nofollow">data collator</a> that can pad batches correctly. You can see examples
of this in the <code>transformers</code> NLP <a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">examples</a> and
<a href="https://huggingface.co/docs/transformers/notebooks" rel="nofollow">notebooks</a>, where variable sequence lengths are very common.`,sa,rs,va=`If you find that loading with <code>to_tf_dataset</code> is slow, you can also use the <code>num_workers</code> argument. This spins
up multiple subprocesses to load data in parallel. This feature is recent and still somewhat experimental - please file
an issue if you encounter any bugs while using it!`,aa,os,ta,is,ka=`The astute reader may have noticed at this point that we have offered two approaches to achieve the same goal - if you
want to pass your dataset to a TensorFlow model, you can either convert the dataset to a <code>Tensor</code> or <code>dict</code> of <code>Tensors</code>
using <code>.with_format(&#39;tf&#39;)</code>, or you can convert the dataset to a <code>tf.data.Dataset</code> with <code>to_tf_dataset()</code>. Either of these
can be passed to <code>model.fit()</code>, so which should you choose?`,ea,hs,xa=`The key thing to recognize is that when you convert the whole dataset to <code>Tensor</code>s, it is static and fully loaded into
RAM. This is simple and convenient, but if any of the following apply, you should probably use <code>to_tf_dataset()</code>
instead:`,na,ms,Qa=`<li>Your dataset is too large to fit in RAM. <code>to_tf_dataset()</code> streams only one batch at a time, so even very large
datasets can be handled with this method.</li> <li>You want to apply random transformations using <code>dataset.with_transform()</code> or the <code>collate_fn</code>. This is
common in several modalities, such as image augmentations when training vision models, or random masking when training
masked language models. Using <code>to_tf_dataset()</code> will apply those transformations
at the moment when a batch is loaded, which means the same samples will get different augmentations each time
they are loaded. This is usually what you want.</li> <li>Your data has a variable dimension, such as input texts in NLP that consist of varying
numbers of tokens. When you create a batch with samples with a variable dimension, the standard solution is to
pad the shorter samples to the length of the longest one. When you stream samples from a dataset with <code>to_tf_dataset</code>,
you can apply this padding to each batch via your <code>collate_fn</code>. However, if you want to convert
such a dataset to dense <code>Tensor</code>s, then you will have to pad samples to the length of the longest sample in <em>the
entire dataset!</em> This can result in huge amounts of padding, which wastes memory and reduces your model’s speed.</li>`,la,cs,pa,ds,Za="Right now, <code>to_tf_dataset()</code> always returns a batched dataset - we will add support for unbatched datasets soon!",ra,us,oa,fs,ia;return $=new U({props:{title:"Using Datasets with TensorFlow",local:"using-datasets-with-tensorflow",headingTag:"h1"}}),R=new U({props:{title:"Dataset format",local:"dataset-format",headingTag:"h2"}}),v=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRmJTIyKSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>,), dtype=int64, numpy=array([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>])&gt;}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=int64, numpy=
array([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
       [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])&gt;}`,wrap:!1}}),T=new ha({props:{$$slots:{default:[Aa]},$$scope:{ctx:b}}}),x=new y({props:{code:"ZHMlNUIlM0ElNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=int64, numpy=
array([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
       [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])&gt;}`,wrap:!1}}),Q=new U({props:{title:"N-dimensional arrays",local:"n-dimensional-arrays",headingTag:"h2"}}),N=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUyMCUyMCUyMyUyMGZpeGVkJTIwc2hhcGUlMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmRhdGElMjIlM0ElMjBkYXRhJTdEKSUwQWRzJTIwJTNEJTIwZHMud2l0aF9mb3JtYXQoJTIydGYlMjIpJTBBZHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],[[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]  <span class="hljs-comment"># fixed shape</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=int64, numpy=
 array([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
        [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])&gt;}`,wrap:!1}}),F=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlNUQlNUQlMkMlNUIlNUI0JTJDJTIwNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUyMCUyMCUyMyUyMHZhcnlpbmclMjBzaGFwZSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElN0QpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMEFkcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>]],[[<span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]  <span class="hljs-comment"># varying shape</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.RaggedTensor [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], [<span class="hljs-number">3</span>]]&gt;}`,wrap:!1}}),z=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXJyYXkyRCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyZGF0YSUyMiUzQSUyMEFycmF5MkQoc2hhcGUlM0QoMiUyQyUyMDIpJTJDJTIwZHR5cGUlM0QnaW50MzInKSU3RCklMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmRhdGElMjIlM0ElMjBkYXRhJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRmJTIyKSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Array2D
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],[[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;data&quot;</span>: Array2D(shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=<span class="hljs-string">&#x27;int32&#x27;</span>)})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data}, features=features)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=int64, numpy=
 array([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
        [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])&gt;}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=int64, numpy=
 array([[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
         [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],
 
        [[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],
         [<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]])&gt;}`,wrap:!1}}),E=new U({props:{title:"Other feature types",local:"other-feature-types",headingTag:"h2"}}),X=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQ2xhc3NMYWJlbCUwQWxhYmVscyUyMCUzRCUyMCU1QjAlMkMlMjAwJTJDJTIwMSU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIybGFiZWwlMjIlM0ElMjBDbGFzc0xhYmVsKG5hbWVzJTNEJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJsYWJlbCUyMiUzQSUyMGxhYmVscyU3RCUyQyUyMGZlYXR1cmVzJTNEZmVhdHVyZXMpJTIwJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0ZiUyMiklMjAlMjAlMEFkcyU1QiUzQTMlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, ClassLabel
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;label&quot;</span>: ClassLabel(names=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>])})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;label&quot;</span>: labels}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">3</span>,), dtype=int64, numpy=array([<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>])&gt;}`,wrap:!1}}),W=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTIwJTBBdGV4dCUyMCUzRCUyMCU1QiUyMmZvbyUyMiUyQyUyMCUyMmJhciUyMiU1RCUwQWRhdGElMjAlM0QlMjAlNUIwJTJDJTIwMSU1RCUyMCUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIydGV4dCUyMiUzQSUyMHRleHQlMkMlMjAlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCklMjAlMjAlMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRmJTIyKSUyMCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features 
<span class="hljs-meta">&gt;&gt;&gt; </span>text = [<span class="hljs-string">&quot;foo&quot;</span>, <span class="hljs-string">&quot;bar&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>] 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;text&quot;</span>: text, <span class="hljs-string">&quot;data&quot;</span>: data})  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>,), dtype=string, numpy=array([<span class="hljs-string">b&#x27;foo&#x27;</span>, <span class="hljs-string">b&#x27;bar&#x27;</span>], dtype=<span class="hljs-built_in">object</span>)&gt;,
 <span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>,), dtype=int64, numpy=array([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])&gt;}`,wrap:!1}}),Y=new y({props:{code:"ZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0ZiUyMiUyQyUyMGNvbHVtbnMlM0QlNUIlMjJkYXRhJTIyJTVEJTJDJTIwb3V0cHV0X2FsbF9jb2x1bW5zJTNEVHJ1ZSklMEFkcyU1QiUzQTIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>, columns=[<span class="hljs-string">&quot;data&quot;</span>], output_all_columns=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>,), dtype=int64, numpy=array([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])&gt;,
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;foo&#x27;</span>, <span class="hljs-string">&#x27;bar&#x27;</span>]}`,wrap:!1}}),w=new ha({props:{$$slots:{default:[La]},$$scope:{ctx:b}}}),B=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMkMlMjBJbWFnZSUwQWltYWdlcyUyMCUzRCUyMCU1QiUyMnBhdGglMkZ0byUyRmltYWdlLnBuZyUyMiU1RCUyMColMjAxMCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyaW1hZ2UlMjIlM0ElMjBJbWFnZSgpJTdEKSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyaW1hZ2UlMjIlM0ElMjBpbWFnZXMlN0QlMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUyMCUwQWRzJTIwJTNEJTIwZHMud2l0aF9mb3JtYXQoJTIydGYlMjIpJTIwJTIwJTBBZHMlNUIwJTVEJTBBZHMlNUIlM0EyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [<span class="hljs-string">&quot;path/to/image.png&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;image&quot;</span>: Image()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;image&quot;</span>: images}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">4</span>), dtype=uint8, numpy=
 array([[[<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
         [<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
         ...,
         [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
         [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]], dtype=uint8)&gt;}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">4</span>), dtype=uint8, numpy=
 array([[[[<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
          [<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
          ...,
          [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
          [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]]], dtype=uint8)&gt;}`,wrap:!1}}),J=new ha({props:{$$slots:{default:[Ba]},$$scope:{ctx:b}}}),S=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMkMlMjBJbWFnZSUwQWF1ZGlvJTIwJTNEJTIwJTVCJTIycGF0aCUyRnRvJTJGYXVkaW8ud2F2JTIyJTVEJTIwKiUyMDEwJTBBZmVhdHVyZXMlMjAlM0QlMjBGZWF0dXJlcyglN0IlMjJhdWRpbyUyMiUzQSUyMEF1ZGlvKCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhdWRpbyUyMiUzQSUyMGF1ZGlvJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMjAlMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRmJTIyKSUyMCUyMCUwQWRzJTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMEFkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = [<span class="hljs-string">&quot;path/to/audio.wav&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;audio&quot;</span>: Audio()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: audio}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
&lt;tf.Tensor: shape=(<span class="hljs-number">202311</span>,), dtype=float32, numpy=
array([ <span class="hljs-number">6.1035156e-05</span>,  <span class="hljs-number">1.5258789e-05</span>,  <span class="hljs-number">1.6784668e-04</span>, ...,
       -<span class="hljs-number">1.5258789e-05</span>, -<span class="hljs-number">1.5258789e-05</span>,  <span class="hljs-number">1.5258789e-05</span>], dtype=float32)&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]
&lt;tf.Tensor: shape=(), dtype=int32, numpy=<span class="hljs-number">44100</span>&gt;`,wrap:!1}}),P=new U({props:{title:"Data loading",local:"data-loading",headingTag:"h2"}}),as=new U({props:{title:"Using to_tf_dataset()",local:"using-totfdataset",headingTag:"h3"}}),es=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlN0IlMjJpbnB1dHMlMjIlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwJTVCMCUyQyUyMDElNUQlN0QlMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KGRhdGEpJTBBdGZfZHMlMjAlM0QlMjBkcy50b190Zl9kYXRhc2V0KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;inputs&quot;</span>: [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]], <span class="hljs-string">&quot;labels&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>tf_ds = ds.to_tf_dataset(
            columns=[<span class="hljs-string">&quot;inputs&quot;</span>],
            label_cols=[<span class="hljs-string">&quot;labels&quot;</span>],
            batch_size=<span class="hljs-number">2</span>,
            shuffle=<span class="hljs-literal">True</span>
            )`,wrap:!1}}),ls=new y({props:{code:"bW9kZWwuZml0KHRmX2RzJTJDJTIwZXBvY2hzJTNEMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(tf_ds, epochs=<span class="hljs-number">2</span>)',wrap:!1}}),os=new U({props:{title:"When to use to_tf_dataset",local:"when-to-use-totfdataset",headingTag:"h3"}}),cs=new U({props:{title:"Caveats and limitations",local:"caveats-and-limitations",headingTag:"h3"}}),us=new Ya({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/use_with_tensorflow.mdx"}}),{c(){p=r("meta"),j=n(),g=r("p"),M=n(),h($.$$.fragment),gs=n(),C=r("p"),C.innerHTML=ca,js=n(),h(R.$$.fragment),ys=n(),I=r("p"),I.textContent=da,Ms=n(),_=r("p"),_.innerHTML=ua,bs=n(),h(v.$$.fragment),Ts=n(),h(T.$$.fragment),ws=n(),k=r("p"),k.innerHTML=fa,Js=n(),h(x.$$.fragment),Us=n(),h(Q.$$.fragment),$s=n(),Z=r("p"),Z.textContent=ga,Cs=n(),h(N.$$.fragment),Rs=n(),G=r("p"),G.innerHTML=ja,Is=n(),h(F.$$.fragment),_s=n(),q=r("p"),q.innerHTML=ya,vs=n(),h(z.$$.fragment),ks=n(),h(E.$$.fragment),xs=n(),H=r("p"),H.innerHTML=Ma,Qs=n(),h(X.$$.fragment),Zs=n(),V=r("p"),V.textContent=ba,Ns=n(),h(W.$$.fragment),Gs=n(),D=r("p"),D.textContent=Ta,Fs=n(),h(Y.$$.fragment),qs=n(),A=r("p"),A.textContent=wa,zs=n(),L=r("p"),L.innerHTML=Ja,Es=n(),h(w.$$.fragment),Hs=n(),h(B.$$.fragment),Xs=n(),h(J.$$.fragment),Vs=n(),h(S.$$.fragment),Ws=n(),h(P.$$.fragment),Ds=n(),K=r("p"),K.innerHTML=Ua,Ys=n(),O=r("p"),O.innerHTML=$a,As=n(),ss=r("p"),ss.innerHTML=Ca,Ls=n(),h(as.$$.fragment),Bs=n(),ts=r("p"),ts.innerHTML=Ra,Ss=n(),h(es.$$.fragment),Ps=n(),ns=r("p"),ns.innerHTML=Ia,Ks=n(),h(ls.$$.fragment),Os=n(),ps=r("p"),ps.innerHTML=_a,sa=n(),rs=r("p"),rs.innerHTML=va,aa=n(),h(os.$$.fragment),ta=n(),is=r("p"),is.innerHTML=ka,ea=n(),hs=r("p"),hs.innerHTML=xa,na=n(),ms=r("ul"),ms.innerHTML=Qa,la=n(),h(cs.$$.fragment),pa=n(),ds=r("p"),ds.innerHTML=Za,ra=n(),h(us.$$.fragment),oa=n(),fs=r("p"),this.h()},l(s){const a=Wa("svelte-u9bgzb",document.head);p=o(a,"META",{name:!0,content:!0}),a.forEach(t),j=l(s),g=o(s,"P",{}),qa(g).forEach(t),M=l(s),m($.$$.fragment,s),gs=l(s),C=o(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1131e0q"&&(C.innerHTML=ca),js=l(s),m(R.$$.fragment,s),ys=l(s),I=o(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-ej8pz8"&&(I.textContent=da),Ms=l(s),_=o(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1jvz2h"&&(_.innerHTML=ua),bs=l(s),m(v.$$.fragment,s),Ts=l(s),m(T.$$.fragment,s),ws=l(s),k=o(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1sidsxe"&&(k.innerHTML=fa),Js=l(s),m(x.$$.fragment,s),Us=l(s),m(Q.$$.fragment,s),$s=l(s),Z=o(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-smjp9l"&&(Z.textContent=ga),Cs=l(s),m(N.$$.fragment,s),Rs=l(s),G=o(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-6gyu92"&&(G.innerHTML=ja),Is=l(s),m(F.$$.fragment,s),_s=l(s),q=o(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1gw41y9"&&(q.innerHTML=ya),vs=l(s),m(z.$$.fragment,s),ks=l(s),m(E.$$.fragment,s),xs=l(s),H=o(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1cotu5f"&&(H.innerHTML=Ma),Qs=l(s),m(X.$$.fragment,s),Zs=l(s),V=o(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1tbbgzx"&&(V.textContent=ba),Ns=l(s),m(W.$$.fragment,s),Gs=l(s),D=o(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1p3x5ww"&&(D.textContent=Ta),Fs=l(s),m(Y.$$.fragment,s),qs=l(s),A=o(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1hobffv"&&(A.textContent=wa),zs=l(s),L=o(s,"P",{"data-svelte-h":!0}),i(L)!=="svelte-2hueiq"&&(L.innerHTML=Ja),Es=l(s),m(w.$$.fragment,s),Hs=l(s),m(B.$$.fragment,s),Xs=l(s),m(J.$$.fragment,s),Vs=l(s),m(S.$$.fragment,s),Ws=l(s),m(P.$$.fragment,s),Ds=l(s),K=o(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-sac77h"&&(K.innerHTML=Ua),Ys=l(s),O=o(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-p0plz9"&&(O.innerHTML=$a),As=l(s),ss=o(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-1nyo297"&&(ss.innerHTML=Ca),Ls=l(s),m(as.$$.fragment,s),Bs=l(s),ts=o(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-lj7mpl"&&(ts.innerHTML=Ra),Ss=l(s),m(es.$$.fragment,s),Ps=l(s),ns=o(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-j57oqq"&&(ns.innerHTML=Ia),Ks=l(s),m(ls.$$.fragment,s),Os=l(s),ps=o(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-18j28s"&&(ps.innerHTML=_a),sa=l(s),rs=o(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-iqwe7b"&&(rs.innerHTML=va),aa=l(s),m(os.$$.fragment,s),ta=l(s),is=o(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-s09fia"&&(is.innerHTML=ka),ea=l(s),hs=o(s,"P",{"data-svelte-h":!0}),i(hs)!=="svelte-1l92k1p"&&(hs.innerHTML=xa),na=l(s),ms=o(s,"UL",{"data-svelte-h":!0}),i(ms)!=="svelte-1no32rr"&&(ms.innerHTML=Qa),la=l(s),m(cs.$$.fragment,s),pa=l(s),ds=o(s,"P",{"data-svelte-h":!0}),i(ds)!=="svelte-15wdpsm"&&(ds.innerHTML=Za),ra=l(s),m(us.$$.fragment,s),oa=l(s),fs=o(s,"P",{}),qa(fs).forEach(t),this.h()},h(){za(p,"name","hf:doc:metadata"),za(p,"content",Pa)},m(s,a){Da(document.head,p),e(s,j,a),e(s,g,a),e(s,M,a),c($,s,a),e(s,gs,a),e(s,C,a),e(s,js,a),c(R,s,a),e(s,ys,a),e(s,I,a),e(s,Ms,a),e(s,_,a),e(s,bs,a),c(v,s,a),e(s,Ts,a),c(T,s,a),e(s,ws,a),e(s,k,a),e(s,Js,a),c(x,s,a),e(s,Us,a),c(Q,s,a),e(s,$s,a),e(s,Z,a),e(s,Cs,a),c(N,s,a),e(s,Rs,a),e(s,G,a),e(s,Is,a),c(F,s,a),e(s,_s,a),e(s,q,a),e(s,vs,a),c(z,s,a),e(s,ks,a),c(E,s,a),e(s,xs,a),e(s,H,a),e(s,Qs,a),c(X,s,a),e(s,Zs,a),e(s,V,a),e(s,Ns,a),c(W,s,a),e(s,Gs,a),e(s,D,a),e(s,Fs,a),c(Y,s,a),e(s,qs,a),e(s,A,a),e(s,zs,a),e(s,L,a),e(s,Es,a),c(w,s,a),e(s,Hs,a),c(B,s,a),e(s,Xs,a),c(J,s,a),e(s,Vs,a),c(S,s,a),e(s,Ws,a),c(P,s,a),e(s,Ds,a),e(s,K,a),e(s,Ys,a),e(s,O,a),e(s,As,a),e(s,ss,a),e(s,Ls,a),c(as,s,a),e(s,Bs,a),e(s,ts,a),e(s,Ss,a),c(es,s,a),e(s,Ps,a),e(s,ns,a),e(s,Ks,a),c(ls,s,a),e(s,Os,a),e(s,ps,a),e(s,sa,a),e(s,rs,a),e(s,aa,a),c(os,s,a),e(s,ta,a),e(s,is,a),e(s,ea,a),e(s,hs,a),e(s,na,a),e(s,ms,a),e(s,la,a),c(cs,s,a),e(s,pa,a),e(s,ds,a),e(s,ra,a),c(us,s,a),e(s,oa,a),e(s,fs,a),ia=!0},p(s,[a]){const Na={};a&2&&(Na.$$scope={dirty:a,ctx:s}),T.$set(Na);const Ga={};a&2&&(Ga.$$scope={dirty:a,ctx:s}),w.$set(Ga);const Fa={};a&2&&(Fa.$$scope={dirty:a,ctx:s}),J.$set(Fa)},i(s){ia||(d($.$$.fragment,s),d(R.$$.fragment,s),d(v.$$.fragment,s),d(T.$$.fragment,s),d(x.$$.fragment,s),d(Q.$$.fragment,s),d(N.$$.fragment,s),d(F.$$.fragment,s),d(z.$$.fragment,s),d(E.$$.fragment,s),d(X.$$.fragment,s),d(W.$$.fragment,s),d(Y.$$.fragment,s),d(w.$$.fragment,s),d(B.$$.fragment,s),d(J.$$.fragment,s),d(S.$$.fragment,s),d(P.$$.fragment,s),d(as.$$.fragment,s),d(es.$$.fragment,s),d(ls.$$.fragment,s),d(os.$$.fragment,s),d(cs.$$.fragment,s),d(us.$$.fragment,s),ia=!0)},o(s){u($.$$.fragment,s),u(R.$$.fragment,s),u(v.$$.fragment,s),u(T.$$.fragment,s),u(x.$$.fragment,s),u(Q.$$.fragment,s),u(N.$$.fragment,s),u(F.$$.fragment,s),u(z.$$.fragment,s),u(E.$$.fragment,s),u(X.$$.fragment,s),u(W.$$.fragment,s),u(Y.$$.fragment,s),u(w.$$.fragment,s),u(B.$$.fragment,s),u(J.$$.fragment,s),u(S.$$.fragment,s),u(P.$$.fragment,s),u(as.$$.fragment,s),u(es.$$.fragment,s),u(ls.$$.fragment,s),u(os.$$.fragment,s),u(cs.$$.fragment,s),u(us.$$.fragment,s),ia=!1},d(s){s&&(t(j),t(g),t(M),t(gs),t(C),t(js),t(ys),t(I),t(Ms),t(_),t(bs),t(Ts),t(ws),t(k),t(Js),t(Us),t($s),t(Z),t(Cs),t(Rs),t(G),t(Is),t(_s),t(q),t(vs),t(ks),t(xs),t(H),t(Qs),t(Zs),t(V),t(Ns),t(Gs),t(D),t(Fs),t(qs),t(A),t(zs),t(L),t(Es),t(Hs),t(Xs),t(Vs),t(Ws),t(Ds),t(K),t(Ys),t(O),t(As),t(ss),t(Ls),t(Bs),t(ts),t(Ss),t(Ps),t(ns),t(Ks),t(Os),t(ps),t(sa),t(rs),t(aa),t(ta),t(is),t(ea),t(hs),t(na),t(ms),t(la),t(pa),t(ds),t(ra),t(oa),t(fs)),t(p),f($,s),f(R,s),f(v,s),f(T,s),f(x,s),f(Q,s),f(N,s),f(F,s),f(z,s),f(E,s),f(X,s),f(W,s),f(Y,s),f(w,s),f(B,s),f(J,s),f(S,s),f(P,s),f(as,s),f(es,s),f(ls,s),f(os,s),f(cs,s),f(us,s)}}}const Pa='{"title":"Using Datasets with TensorFlow","local":"using-datasets-with-tensorflow","sections":[{"title":"Dataset format","local":"dataset-format","sections":[],"depth":2},{"title":"N-dimensional arrays","local":"n-dimensional-arrays","sections":[],"depth":2},{"title":"Other feature types","local":"other-feature-types","sections":[],"depth":2},{"title":"Data loading","local":"data-loading","sections":[{"title":"Using to_tf_dataset()","local":"using-totfdataset","sections":[],"depth":3},{"title":"When to use to_tf_dataset","local":"when-to-use-totfdataset","sections":[],"depth":3},{"title":"Caveats and limitations","local":"caveats-and-limitations","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ka(b){return Ha(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nt extends Xa{constructor(p){super(),Va(this,p,Ka,Sa,Ea,{})}}export{nt as component};
