import{s as Ts,n as ws,o as bs}from"../chunks/scheduler.bdbef820.js";import{S as _s,i as xs,g as p,s as l,r as o,A as Cs,h as i,f as a,c as n,j as Js,u as d,x as r,k as $s,y as qs,a as e,v as m,d as f,t as c,w as h}from"../chunks/index.c0aea24a.js";import{C as u}from"../chunks/CodeBlock.6ccca92e.js";import{H as lt,E as vs}from"../chunks/EditOnGithub.725ee0c1.js";function ks(At){let g,it,nt,rt,M,ot,y,Kt="A tabular dataset is a generic dataset used to describe any data stored in rows and columns, where the rows represent an example and the columns represent a feature (can be continuous or categorical). These datasets are commonly stored in CSV files, Pandas DataFrames, and in database tables. This guide will show you how to load and create a tabular dataset from:",dt,j,Ot="<li>CSV files</li> <li>Pandas DataFrames</li> <li>Databases</li>",mt,J,ft,$,ts='🤗 Datasets can read CSV files by specifying the generic <code>csv</code> dataset builder name in the <a href="/docs/datasets/pr_7043/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a> method. To load more than one CSV file, pass them as a list to the <code>data_files</code> parameter:',ct,T,ht,w,ss="You can also map specific CSV files to the train and test splits:",ut,b,gt,_,as="To load remote CSV files, pass the URLs instead:",Mt,x,yt,C,es="To load zipped CSV files:",jt,q,Jt,v,$t,k,ls='🤗 Datasets also supports loading datasets from <a href="https://pandas.pydata.org/docs/reference/api/pandas.DataFrame.html" rel="nofollow">Pandas DataFrames</a> with the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.from_pandas">from_pandas()</a> method:',Tt,R,wt,U,ns="Use the <code>splits</code> parameter to specify the name of the dataset split:",bt,Z,_t,G,ps='If the dataset doesn’t look as expected, you should explicitly <a href="loading#specify-features">specify your dataset features</a>. A <a href="https://pandas.pydata.org/docs/reference/api/pandas.Series.html" rel="nofollow">pandas.Series</a> may not always carry enough information for Arrow to automatically infer a data type. For example, if a DataFrame is of length <code>0</code> or if the Series only contains <code>None/NaN</code> objects, the type is set to <code>null</code>.',xt,Y,Ct,X,is="Datasets stored in databases are typically accessed with SQL queries. With 🤗 Datasets, you can connect to a database, query for the data you need, and create a dataset out of it. Then you can use all the processing features of 🤗 Datasets to prepare your dataset for training.",qt,I,vt,F,rs="SQLite is a small, lightweight database that is fast and easy to set up. You can use an existing database if you’d like, or follow along and start from scratch.",kt,N,os='Start by creating a quick SQLite database with this <a href="https://github.com/nytimes/covid-19-data/blob/master/us-states.csv" rel="nofollow">Covid-19 data</a> from the New York Times:',Rt,H,Ut,z,ds="This creates a <code>states</code> table in the <code>us_covid_data.db</code> database which you can now load into a dataset.",Zt,L,ms='To connect to the database, you’ll need the <a href="https://docs.sqlalchemy.org/en/13/core/engines.html#database-urls" rel="nofollow">URI string</a> that identifies your database. Connecting to a database with a URI caches the returned dataset. The URI string differs for each database dialect, so be sure to check the <a href="https://docs.sqlalchemy.org/en/13/core/engines.html#database-urls" rel="nofollow">Database URLs</a> for whichever database you’re using.',Gt,Q,fs="For SQLite, it is:",Yt,E,Xt,S,cs='Load the table by passing the table name and URI to <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.from_sql">from_sql()</a>:',It,V,Ft,B,hs='Then you can use all of 🤗 Datasets process features like <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.filter">filter()</a> for example:',Nt,D,Ht,W,us="You can also load a dataset from a SQL query instead of an entire table, which is useful for querying and joining multiple tables.",zt,P,gs='Load the dataset by passing your query and URI to <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.from_sql">from_sql()</a>:',Lt,A,Qt,K,Ms='Then you can use all of 🤗 Datasets process features like <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.filter">filter()</a> for example:',Et,O,St,tt,Vt,st,ys='You can also connect and load a dataset from a PostgreSQL database, however we won’t directly demonstrate how in the documentation because the example is only meant to be run in a notebook. Instead, take a look at how to install and setup a PostgreSQL server in this <a href="https://colab.research.google.com/github/nateraw/huggingface-hub-examples/blob/main/sql_with_huggingface_datasets.ipynb#scrollTo=d83yGQMPHGFi" rel="nofollow">notebook</a>!',Bt,at,js='After you’ve setup your PostgreSQL database, you can use the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.from_sql">from_sql()</a> method to load a dataset from a table or query.',Dt,et,Wt,pt,Pt;return M=new lt({props:{title:"Load tabular data",local:"load-tabular-data",headingTag:"h1"}}),J=new lt({props:{title:"CSV files",local:"csv-files",headingTag:"h2"}}),T=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjc3YlMjIlMkMlMjBkYXRhX2ZpbGVzJTNEJTIybXlfZmlsZS5jc3YlMjIpJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjc3YlMjIlMkMlMjBkYXRhX2ZpbGVzJTNEJTVCJTIybXlfZmlsZV8xLmNzdiUyMiUyQyUyMCUyMm15X2ZpbGVfMi5jc3YlMjIlMkMlMjAlMjJteV9maWxlXzMuY3N2JTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=<span class="hljs-string">&quot;my_file.csv&quot;</span>)

<span class="hljs-comment"># load multiple CSV files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=[<span class="hljs-string">&quot;my_file_1.csv&quot;</span>, <span class="hljs-string">&quot;my_file_2.csv&quot;</span>, <span class="hljs-string">&quot;my_file_3.csv&quot;</span>])`,wrap:!1}}),b=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjc3YlMjIlMkMlMjBkYXRhX2ZpbGVzJTNEJTdCJTIydHJhaW4lMjIlM0ElMjAlNUIlMjJteV90cmFpbl9maWxlXzEuY3N2JTIyJTJDJTIwJTIybXlfdHJhaW5fZmlsZV8yLmNzdiUyMiU1RCUyQyUyMCUyMnRlc3QlMjIlM0ElMjAlMjJteV90ZXN0X2ZpbGUuY3N2JTIyJTdEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files={<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">&quot;my_train_file_1.csv&quot;</span>, <span class="hljs-string">&quot;my_train_file_2.csv&quot;</span>], <span class="hljs-string">&quot;test&quot;</span>: <span class="hljs-string">&quot;my_test_file.csv&quot;</span>})',wrap:!1}}),x=new u({props:{code:"YmFzZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZsaG9lc3RxJTJGZGVtbzElMkZyZXNvbHZlJTJGbWFpbiUyRmRhdGElMkYlMjIlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCdjc3YnJTJDJTIwZGF0YV9maWxlcyUzRCU3QiUyMnRyYWluJTIyJTNBJTIwYmFzZV91cmwlMjAlMkIlMjAlMjJ0cmFpbi5jc3YlMjIlMkMlMjAlMjJ0ZXN0JTIyJTNBJTIwYmFzZV91cmwlMjAlMkIlMjAlMjJ0ZXN0LmNzdiUyMiU3RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>base_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/lhoestq/demo1/resolve/main/data/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;csv&#x27;</span>, data_files={<span class="hljs-string">&quot;train&quot;</span>: base_url + <span class="hljs-string">&quot;train.csv&quot;</span>, <span class="hljs-string">&quot;test&quot;</span>: base_url + <span class="hljs-string">&quot;test.csv&quot;</span>})`,wrap:!1}}),q=new u({props:{code:"dXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZkb21haW4ub3JnJTJGdHJhaW5fZGF0YS56aXAlMjIlMEFkYXRhX2ZpbGVzJTIwJTNEJTIwJTdCJTIydHJhaW4lMjIlM0ElMjB1cmwlN0QlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmNzdiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://domain.org/train_data.zip&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>data_files = {<span class="hljs-string">&quot;train&quot;</span>: url}
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files)`,wrap:!1}}),v=new lt({props:{title:"Pandas DataFrames",local:"pandas-dataframes",headingTag:"h2"}}),R=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEFkZiUyMCUzRCUyMHBkLnJlYWRfY3N2KCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmltb2RlbHMlMkZjcmVkaXQtY2FyZCUyRnJhdyUyRm1haW4lMkZ0cmFpbi5jc3YlMjIpJTBBZGYlMjAlM0QlMjBwZC5EYXRhRnJhbWUoZGYpJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9wYW5kYXMoZGYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-comment"># create a Pandas DataFrame</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;https://huggingface.co/datasets/imodels/credit-card/raw/main/train.csv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.DataFrame(df)
<span class="hljs-comment"># load Dataset from Pandas DataFrame</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = Dataset.from_pandas(df)`,wrap:!1}}),Z=new u({props:{code:"dHJhaW5fZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fcGFuZGFzKHRyYWluX2RmJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEF0ZXN0X2RzJTIwJTNEJTIwRGF0YXNldC5mcm9tX3BhbmRhcyh0ZXN0X2RmJTJDJTIwc3BsaXQlM0QlMjJ0ZXN0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds = Dataset.from_pandas(train_df, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds = Dataset.from_pandas(test_df, split=<span class="hljs-string">&quot;test&quot;</span>)`,wrap:!1}}),Y=new lt({props:{title:"Databases",local:"databases",headingTag:"h2"}}),I=new lt({props:{title:"SQLite",local:"sqlite",headingTag:"h3"}}),H=new u({props:{code:"aW1wb3J0JTIwc3FsaXRlMyUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEFjb25uJTIwJTNEJTIwc3FsaXRlMy5jb25uZWN0KCUyMnVzX2NvdmlkX2RhdGEuZGIlMjIpJTBBZGYlMjAlM0QlMjBwZC5yZWFkX2NzdiglMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZueXRpbWVzJTJGY292aWQtMTktZGF0YSUyRm1hc3RlciUyRnVzLXN0YXRlcy5jc3YlMjIpJTBBZGYudG9fc3FsKCUyMnN0YXRlcyUyMiUyQyUyMGNvbm4lMkMlMjBpZl9leGlzdHMlM0QlMjJyZXBsYWNlJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> sqlite3
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>conn = sqlite3.connect(<span class="hljs-string">&quot;us_covid_data.db&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;https://raw.githubusercontent.com/nytimes/covid-19-data/master/us-states.csv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_sql(<span class="hljs-string">&quot;states&quot;</span>, conn, if_exists=<span class="hljs-string">&quot;replace&quot;</span>)`,wrap:!1}}),E=new u({props:{code:"dXJpJTIwJTNEJTIwJTIyc3FsaXRlJTNBJTJGJTJGJTJGdXNfY292aWRfZGF0YS5kYiUyMg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>uri = <span class="hljs-string">&quot;sqlite:///us_covid_data.db&quot;</span>',wrap:!1}}),V=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX3NxbCglMjJzdGF0ZXMlMjIlMkMlMjB1cmkpJTBBZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_sql(<span class="hljs-string">&quot;states&quot;</span>, uri)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds
Dataset({
    features: [<span class="hljs-string">&#x27;index&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;state&#x27;</span>, <span class="hljs-string">&#x27;fips&#x27;</span>, <span class="hljs-string">&#x27;cases&#x27;</span>, <span class="hljs-string">&#x27;deaths&#x27;</span>],
    num_rows: <span class="hljs-number">54382</span>
})`,wrap:!1}}),D=new u({props:{code:"ZHMuZmlsdGVyKGxhbWJkYSUyMHglM0ElMjB4JTVCJTIyc3RhdGUlMjIlNUQlMjAlM0QlM0QlMjAlMjJDYWxpZm9ybmlhJTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>ds.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;state&quot;</span>] == <span class="hljs-string">&quot;California&quot;</span>)',wrap:!1}}),A=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX3NxbCgnU0VMRUNUJTIwKiUyMEZST00lMjBzdGF0ZXMlMjBXSEVSRSUyMHN0YXRlJTNEJTIyQ2FsaWZvcm5pYSUyMiUzQiclMkMlMjB1cmkpJTBBZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_sql(<span class="hljs-string">&#x27;SELECT * FROM states WHERE state=&quot;California&quot;;&#x27;</span>, uri)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds
Dataset({
    features: [<span class="hljs-string">&#x27;index&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;state&#x27;</span>, <span class="hljs-string">&#x27;fips&#x27;</span>, <span class="hljs-string">&#x27;cases&#x27;</span>, <span class="hljs-string">&#x27;deaths&#x27;</span>],
    num_rows: <span class="hljs-number">1019</span>
})`,wrap:!1}}),O=new u({props:{code:"ZHMuZmlsdGVyKGxhbWJkYSUyMHglM0ElMjB4JTVCJTIyY2FzZXMlMjIlNUQlMjAlM0UlMjAxMDAwMCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>ds.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;cases&quot;</span>] &gt; <span class="hljs-number">10000</span>)',wrap:!1}}),tt=new lt({props:{title:"PostgreSQL",local:"postgresql",headingTag:"h3"}}),et=new vs({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/tabular_load.mdx"}}),{c(){g=p("meta"),it=l(),nt=p("p"),rt=l(),o(M.$$.fragment),ot=l(),y=p("p"),y.textContent=Kt,dt=l(),j=p("ul"),j.innerHTML=Ot,mt=l(),o(J.$$.fragment),ft=l(),$=p("p"),$.innerHTML=ts,ct=l(),o(T.$$.fragment),ht=l(),w=p("p"),w.textContent=ss,ut=l(),o(b.$$.fragment),gt=l(),_=p("p"),_.textContent=as,Mt=l(),o(x.$$.fragment),yt=l(),C=p("p"),C.textContent=es,jt=l(),o(q.$$.fragment),Jt=l(),o(v.$$.fragment),$t=l(),k=p("p"),k.innerHTML=ls,Tt=l(),o(R.$$.fragment),wt=l(),U=p("p"),U.innerHTML=ns,bt=l(),o(Z.$$.fragment),_t=l(),G=p("p"),G.innerHTML=ps,xt=l(),o(Y.$$.fragment),Ct=l(),X=p("p"),X.textContent=is,qt=l(),o(I.$$.fragment),vt=l(),F=p("p"),F.textContent=rs,kt=l(),N=p("p"),N.innerHTML=os,Rt=l(),o(H.$$.fragment),Ut=l(),z=p("p"),z.innerHTML=ds,Zt=l(),L=p("p"),L.innerHTML=ms,Gt=l(),Q=p("p"),Q.textContent=fs,Yt=l(),o(E.$$.fragment),Xt=l(),S=p("p"),S.innerHTML=cs,It=l(),o(V.$$.fragment),Ft=l(),B=p("p"),B.innerHTML=hs,Nt=l(),o(D.$$.fragment),Ht=l(),W=p("p"),W.textContent=us,zt=l(),P=p("p"),P.innerHTML=gs,Lt=l(),o(A.$$.fragment),Qt=l(),K=p("p"),K.innerHTML=Ms,Et=l(),o(O.$$.fragment),St=l(),o(tt.$$.fragment),Vt=l(),st=p("p"),st.innerHTML=ys,Bt=l(),at=p("p"),at.innerHTML=js,Dt=l(),o(et.$$.fragment),Wt=l(),pt=p("p"),this.h()},l(t){const s=Cs("svelte-u9bgzb",document.head);g=i(s,"META",{name:!0,content:!0}),s.forEach(a),it=n(t),nt=i(t,"P",{}),Js(nt).forEach(a),rt=n(t),d(M.$$.fragment,t),ot=n(t),y=i(t,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1wme3lm"&&(y.textContent=Kt),dt=n(t),j=i(t,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-1nq9ez5"&&(j.innerHTML=Ot),mt=n(t),d(J.$$.fragment,t),ft=n(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-d23m3x"&&($.innerHTML=ts),ct=n(t),d(T.$$.fragment,t),ht=n(t),w=i(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-qtb2i7"&&(w.textContent=ss),ut=n(t),d(b.$$.fragment,t),gt=n(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1e176xs"&&(_.textContent=as),Mt=n(t),d(x.$$.fragment,t),yt=n(t),C=i(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1swu4q4"&&(C.textContent=es),jt=n(t),d(q.$$.fragment,t),Jt=n(t),d(v.$$.fragment,t),$t=n(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-j3clo0"&&(k.innerHTML=ls),Tt=n(t),d(R.$$.fragment,t),wt=n(t),U=i(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-11xgfy5"&&(U.innerHTML=ns),bt=n(t),d(Z.$$.fragment,t),_t=n(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-dgrtkz"&&(G.innerHTML=ps),xt=n(t),d(Y.$$.fragment,t),Ct=n(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1wga9b8"&&(X.textContent=is),qt=n(t),d(I.$$.fragment,t),vt=n(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1rscjmw"&&(F.textContent=rs),kt=n(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-m8crgu"&&(N.innerHTML=os),Rt=n(t),d(H.$$.fragment,t),Ut=n(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-e7mw7n"&&(z.innerHTML=ds),Zt=n(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1l5btzf"&&(L.innerHTML=ms),Gt=n(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1hulh3i"&&(Q.textContent=fs),Yt=n(t),d(E.$$.fragment,t),Xt=n(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-12zqjy3"&&(S.innerHTML=cs),It=n(t),d(V.$$.fragment,t),Ft=n(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-8byn37"&&(B.innerHTML=hs),Nt=n(t),d(D.$$.fragment,t),Ht=n(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-zt9jdv"&&(W.textContent=us),zt=n(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-2q1ua0"&&(P.innerHTML=gs),Lt=n(t),d(A.$$.fragment,t),Qt=n(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-8byn37"&&(K.innerHTML=Ms),Et=n(t),d(O.$$.fragment,t),St=n(t),d(tt.$$.fragment,t),Vt=n(t),st=i(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-83xeoy"&&(st.innerHTML=ys),Bt=n(t),at=i(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-tgm9a2"&&(at.innerHTML=js),Dt=n(t),d(et.$$.fragment,t),Wt=n(t),pt=i(t,"P",{}),Js(pt).forEach(a),this.h()},h(){$s(g,"name","hf:doc:metadata"),$s(g,"content",Rs)},m(t,s){qs(document.head,g),e(t,it,s),e(t,nt,s),e(t,rt,s),m(M,t,s),e(t,ot,s),e(t,y,s),e(t,dt,s),e(t,j,s),e(t,mt,s),m(J,t,s),e(t,ft,s),e(t,$,s),e(t,ct,s),m(T,t,s),e(t,ht,s),e(t,w,s),e(t,ut,s),m(b,t,s),e(t,gt,s),e(t,_,s),e(t,Mt,s),m(x,t,s),e(t,yt,s),e(t,C,s),e(t,jt,s),m(q,t,s),e(t,Jt,s),m(v,t,s),e(t,$t,s),e(t,k,s),e(t,Tt,s),m(R,t,s),e(t,wt,s),e(t,U,s),e(t,bt,s),m(Z,t,s),e(t,_t,s),e(t,G,s),e(t,xt,s),m(Y,t,s),e(t,Ct,s),e(t,X,s),e(t,qt,s),m(I,t,s),e(t,vt,s),e(t,F,s),e(t,kt,s),e(t,N,s),e(t,Rt,s),m(H,t,s),e(t,Ut,s),e(t,z,s),e(t,Zt,s),e(t,L,s),e(t,Gt,s),e(t,Q,s),e(t,Yt,s),m(E,t,s),e(t,Xt,s),e(t,S,s),e(t,It,s),m(V,t,s),e(t,Ft,s),e(t,B,s),e(t,Nt,s),m(D,t,s),e(t,Ht,s),e(t,W,s),e(t,zt,s),e(t,P,s),e(t,Lt,s),m(A,t,s),e(t,Qt,s),e(t,K,s),e(t,Et,s),m(O,t,s),e(t,St,s),m(tt,t,s),e(t,Vt,s),e(t,st,s),e(t,Bt,s),e(t,at,s),e(t,Dt,s),m(et,t,s),e(t,Wt,s),e(t,pt,s),Pt=!0},p:ws,i(t){Pt||(f(M.$$.fragment,t),f(J.$$.fragment,t),f(T.$$.fragment,t),f(b.$$.fragment,t),f(x.$$.fragment,t),f(q.$$.fragment,t),f(v.$$.fragment,t),f(R.$$.fragment,t),f(Z.$$.fragment,t),f(Y.$$.fragment,t),f(I.$$.fragment,t),f(H.$$.fragment,t),f(E.$$.fragment,t),f(V.$$.fragment,t),f(D.$$.fragment,t),f(A.$$.fragment,t),f(O.$$.fragment,t),f(tt.$$.fragment,t),f(et.$$.fragment,t),Pt=!0)},o(t){c(M.$$.fragment,t),c(J.$$.fragment,t),c(T.$$.fragment,t),c(b.$$.fragment,t),c(x.$$.fragment,t),c(q.$$.fragment,t),c(v.$$.fragment,t),c(R.$$.fragment,t),c(Z.$$.fragment,t),c(Y.$$.fragment,t),c(I.$$.fragment,t),c(H.$$.fragment,t),c(E.$$.fragment,t),c(V.$$.fragment,t),c(D.$$.fragment,t),c(A.$$.fragment,t),c(O.$$.fragment,t),c(tt.$$.fragment,t),c(et.$$.fragment,t),Pt=!1},d(t){t&&(a(it),a(nt),a(rt),a(ot),a(y),a(dt),a(j),a(mt),a(ft),a($),a(ct),a(ht),a(w),a(ut),a(gt),a(_),a(Mt),a(yt),a(C),a(jt),a(Jt),a($t),a(k),a(Tt),a(wt),a(U),a(bt),a(_t),a(G),a(xt),a(Ct),a(X),a(qt),a(vt),a(F),a(kt),a(N),a(Rt),a(Ut),a(z),a(Zt),a(L),a(Gt),a(Q),a(Yt),a(Xt),a(S),a(It),a(Ft),a(B),a(Nt),a(Ht),a(W),a(zt),a(P),a(Lt),a(Qt),a(K),a(Et),a(St),a(Vt),a(st),a(Bt),a(at),a(Dt),a(Wt),a(pt)),a(g),h(M,t),h(J,t),h(T,t),h(b,t),h(x,t),h(q,t),h(v,t),h(R,t),h(Z,t),h(Y,t),h(I,t),h(H,t),h(E,t),h(V,t),h(D,t),h(A,t),h(O,t),h(tt,t),h(et,t)}}}const Rs='{"title":"Load tabular data","local":"load-tabular-data","sections":[{"title":"CSV files","local":"csv-files","sections":[],"depth":2},{"title":"Pandas DataFrames","local":"pandas-dataframes","sections":[],"depth":2},{"title":"Databases","local":"databases","sections":[{"title":"SQLite","local":"sqlite","sections":[],"depth":3},{"title":"PostgreSQL","local":"postgresql","sections":[],"depth":3}],"depth":2}],"depth":1}';function Us(At){return bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends _s{constructor(g){super(),xs(this,g,Us,ks,Ts,{})}}export{Is as component};
