import{s as yp,o as bp,n as re}from"../chunks/scheduler.bdbef820.js";import{S as wp,i as Tp,g as p,s as n,r as c,A as Jp,h as i,f as e,c as l,j as fp,u as h,x as r,k as Mp,y as _p,a as t,v as o,d as m,t as d,w as u}from"../chunks/index.c0aea24a.js";import{T as ie}from"../chunks/Tip.31005f7d.js";import{C as g}from"../chunks/CodeBlock.6ccca92e.js";import{H as M,E as Up}from"../chunks/EditOnGithub.725ee0c1.js";function xp(w){let j,y='All processing methods in this guide return a new <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object. Modification is not done in-place. Be careful about overriding your previous dataset!';return{c(){j=p("p"),j.innerHTML=y},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1wp4czo"&&(j.innerHTML=y)},m(f,b){t(f,j,b)},p:re,d(f){f&&e(j)}}}function $p(w){let j,y="Casting only works if the original feature type and new feature type are compatible. For example, you can cast a column with the feature type <code>Value(&quot;int32&quot;)</code> to <code>Value(&quot;bool&quot;)</code> if the original column only contains ones and zeros.";return{c(){j=p("p"),j.innerHTML=y},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1cevxd4"&&(j.innerHTML=y)},m(f,b){t(f,j,b)},p:re,d(f){f&&e(j)}}}function Ip(w){let j,y='🤗 Datasets also has a <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.remove_columns">remove_columns()</a> function which is faster because it doesn’t copy the data of the remaining columns.';return{c(){j=p("p"),j.innerHTML=y},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-mgou6s"&&(j.innerHTML=y)},m(f,b){t(f,j,b)},p:re,d(f){f&&e(j)}}}function kp(w){let j,y='🤗 Datasets also provides support for other common data formats such as NumPy, Pandas, and JAX. Check out the <a href="https://huggingface.co/docs/datasets/master/en/use_with_tensorflow#using-totfdataset" rel="nofollow">Using Datasets with TensorFlow</a> guide for more details on how to efficiently create a TensorFlow dataset.';return{c(){j=p("p"),j.innerHTML=y},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1alh0vh"&&(j.innerHTML=y)},m(f,b){t(f,j,b)},p:re,d(f){f&&e(j)}}}function Cp(w){let j,y='Want to save your dataset to a cloud storage provider? Read our <a href="./filesystems">Cloud Storage</a> guide to learn how to save your dataset to AWS or Google Cloud Storage.';return{c(){j=p("p"),j.innerHTML=y},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1vp9a9n"&&(j.innerHTML=y)},m(f,b){t(f,j,b)},p:re,d(f){f&&e(j)}}}function Zp(w){let j,y,f,b,$,ce,I,Dn="🤗 Datasets provides many tools for modifying the structure and content of a dataset. These tools are important for tidying up a dataset, creating additional columns, converting between features and formats, and much more.",he,k,Ln="This guide will show you how to:",oe,C,Pn="<li>Reorder rows and split the dataset.</li> <li>Rename and remove columns, and other common column operations.</li> <li>Apply processing functions to each example in a dataset.</li> <li>Concatenate datasets.</li> <li>Apply a custom formatting transform.</li> <li>Save and export processed datasets.</li>",me,Z,Kn='For more details specific to processing other dataset modalities, take a look at the <a class="underline decoration-pink-400 decoration-2 font-semibold" href="./audio_process">process audio dataset guide</a>, the <a class="underline decoration-yellow-400 decoration-2 font-semibold" href="./image_process">process image dataset guide</a>, or the <a class="underline decoration-green-400 decoration-2 font-semibold" href="./nlp_process">process text dataset guide</a>.',de,G,On="The examples in this guide use the MRPC dataset, but feel free to load any dataset of your choice and follow along!",ue,X,je,T,ge,v,fe,R,sl=`There are several functions for rearranging the structure of a dataset.
These functions are useful for selecting only the rows you want, creating train and test splits, and sharding very large datasets into smaller chunks.`,Me,V,ye,Y,al='Use <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.sort">sort()</a> to sort column values according to their numerical values. The provided column must be NumPy compatible.',be,N,we,F,el=`Under the hood, this creates a list of indices that is sorted according to values of the column.
This indices mapping is then used to access the right rows in the underlying Arrow table.`,Te,B,Je,Q,tl='The <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.shuffle">shuffle()</a> function randomly rearranges the column values. You can specify the <code>generator</code> parameter in this function to use a different <code>numpy.random.Generator</code> if you want more control over the algorithm used to shuffle the dataset.',_e,W,Ue,q,nl=`Shuffling takes the list of indices <code>[0:len(my_dataset)]</code> and shuffles it to create an indices mapping.
However as soon as your <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset">Dataset</a> has an indices mapping, the speed can become 10x slower.
This is because there is an extra step to get the row index to read using the indices mapping, and most importantly, you aren’t reading contiguous chunks of data anymore.
To restore the speed, you’d need to rewrite the entire dataset on your disk again using <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.flatten_indices">Dataset.flatten_indices()</a>, which removes the indices mapping.
Alternatively, you can switch to an <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> and leverage its fast approximate shuffling <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a>:`,xe,z,$e,E,Ie,H,ll='There are two options for filtering rows in a dataset: <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.select">select()</a> and <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.filter">filter()</a>.',ke,A,pl='<li><a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.select">select()</a> returns rows according to a list of indices:</li>',Ce,S,Ze,D,il='<li><a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.filter">filter()</a> returns rows that match a specified condition:</li>',Ge,L,Xe,P,rl='<a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.filter">filter()</a> can also filter by indices if you set <code>with_indices=True</code>:',ve,K,Re,O,cl="Unless the list of indices to keep is contiguous, those methods also create an indices mapping under the hood.",Ve,ss,Ye,as,hl='The <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.train_test_split">train_test_split()</a> function creates train and test splits if your dataset doesn’t already have them. This allows you to adjust the relative proportions or an absolute number of samples in each split. In the example below, use the <code>test_size</code> parameter to create a test split that is 10% of the original dataset:',Ne,es,Fe,ts,ol="The splits are shuffled by default, but you can set <code>shuffle=False</code> to prevent shuffling.",Be,ns,Qe,ls,ml='🤗 Datasets supports sharding to divide a very large dataset into a predefined number of chunks. Specify the <code>num_shards</code> parameter in <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.shard">shard()</a> to determine the number of shards to split the dataset into. You’ll also need to provide the shard you want to return with the <code>index</code> parameter.',We,ps,dl='For example, the <a href="https://huggingface.co/datasets/imdb" rel="nofollow">imdb</a> dataset has 25000 examples:',qe,is,ze,rs,ul="After sharding the dataset into four chunks, the first shard will only have 6250 examples:",Ee,cs,He,hs,Ae,os,jl="The following functions allow you to modify the columns of a dataset. These functions are useful for renaming or removing columns, changing columns to a new set of features, and flattening nested column structures.",Se,ms,De,ds,gl='Use <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.rename_column">rename_column()</a> when you need to rename a column in your dataset. Features associated with the original column are actually moved under the new column name, instead of just replacing the original column in-place.',Le,us,fl='Provide <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.rename_column">rename_column()</a> with the name of the original column, and the new column name:',Pe,js,Ke,gs,Oe,fs,Ml='When you need to remove one or more columns, provide the column name to remove to the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.remove_columns">remove_columns()</a> function. Remove more than one column by providing a list of column names:',st,Ms,at,ys,yl='Conversely, <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.select_columns">select_columns()</a> selects one or more columns to keep and removes the rest. This function takes either one or a list of column names:',et,bs,tt,ws,nt,Ts,bl='The <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.cast">cast()</a> function transforms the feature type of one or more columns. This function accepts your new <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Features">Features</a> as its argument. The example below demonstrates how to change the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.ClassLabel">ClassLabel</a> and <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Value">Value</a> features:',lt,Js,pt,J,it,_s,wl='Use the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.cast_column">cast_column()</a> function to change the feature type of a single column. Pass the column name and its new feature type as arguments:',rt,Us,ct,xs,ht,$s,Tl="Sometimes a column can be a nested structure of several types. Take a look at the nested structure below from the SQuAD dataset:",ot,Is,mt,ks,Jl='The <code>answers</code> field contains two subfields: <code>text</code> and <code>answer_start</code>. Use the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.flatten">flatten()</a> function to extract the subfields into their own separate columns:',dt,Cs,ut,Zs,_l="Notice how the subfields are now their own independent columns: <code>answers.text</code> and <code>answers.answer_start</code>.",jt,Gs,gt,Xs,Ul='Some of the more powerful applications of 🤗 Datasets come from using the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function. The primary purpose of <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.map">map()</a> is to speed up processing functions. It allows you to apply a processing function to each example in a dataset, independently or in batches. This function can even create new rows and columns.',ft,vs,xl="In the following example, prefix each <code>sentence1</code> value in the dataset with <code>&#39;My sentence: &#39;</code>.",Mt,Rs,$l="Start by creating a function that adds <code>&#39;My sentence: &#39;</code> to the beginning of each sentence. The function needs to accept and output a <code>dict</code>:",yt,Vs,bt,Ys,Il='Now use <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.map">map()</a> to apply the <code>add_prefix</code> function to the entire dataset:',wt,Ns,Tt,Fs,kl='Let’s take a look at another example, except this time, you’ll remove a column with <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.map">map()</a>. When you remove a column, it is only removed after the example has been provided to the mapped function. This allows the mapped function to use the content of the columns before they are removed.',Jt,Bs,Cl='Specify the column to remove with the <code>remove_columns</code> parameter in <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.map">map()</a>:',_t,Qs,Ut,_,xt,Ws,Zl='You can also use <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.map">map()</a> with indices if you set <code>with_indices=True</code>. The example below adds the index to the beginning of each sentence:',$t,qs,It,zs,kt,Es,Gl='Multiprocessing significantly speeds up processing by parallelizing processes on the CPU. Set the <code>num_proc</code> parameter in <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.map">map()</a> to set the number of processes to use:',Ct,Hs,Zt,As,Xl='The <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.map">map()</a> also works with the rank of the process if you set <code>with_rank=True</code>. This is analogous to the <code>with_indices</code> parameter. The <code>with_rank</code> parameter in the mapped function goes after the <code>index</code> one if it is already present.',Gt,Ss,Xt,Ds,vl="The main use-case for rank is to parallelize computation across several GPUs. This requires setting <code>multiprocess.set_start_method(&quot;spawn&quot;)</code>. If you don’t you’ll receive the following CUDA error:",vt,Ls,Rt,Ps,Vt,Ks,Rl='The <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function supports working with batches of examples. Operate on batches by setting <code>batched=True</code>. The default batch size is 1000, but you can adjust it with the <code>batch_size</code> parameter. Batch processing enables interesting applications such as splitting long sentences into shorter chunks and data augmentation.',Yt,Os,Nt,sa,Vl="When examples are too long, you may want to split them into several smaller chunks. Begin by creating a function that:",Ft,aa,Yl="<li><p>Splits the <code>sentence1</code> field into chunks of 50 characters.</p></li> <li><p>Stacks all the chunks together to create the new dataset.</p></li>",Bt,ea,Qt,ta,Nl='Apply the function with <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.map">map()</a>:',Wt,na,qt,la,Fl="Notice how the sentences are split into shorter chunks now, and there are more rows in the dataset.",zt,pa,Et,ia,Ht,ra,Bl='The <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function could also be used for data augmentation. The following example generates additional words for a masked token in a sentence.',At,ca,Ql='Load and use the <a href="https://huggingface.co/roberta-base" rel="nofollow">RoBERTA</a> model in 🤗 Transformers’ <a href="https://huggingface.co/transformers/main_classes/pipelines#transformers.FillMaskPipeline" rel="nofollow">FillMaskPipeline</a>:',St,ha,Dt,oa,Wl="Create a function to randomly select a word to mask in the sentence. The function should also return the original sentence and the top two replacements generated by RoBERTA.",Lt,ma,Pt,da,ql='Use <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.map">map()</a> to apply the function over the whole dataset:',Kt,ua,Ot,ja,zl="For each original sentence, RoBERTA augmented a random word with three alternatives. The original word <code>distorting</code> is supplemented by <code>withholding</code>, <code>suppressing</code>, and <code>destroying</code>.",sn,ga,an,fa,El='Many datasets have splits that can be processed simultaneously with <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.DatasetDict.map">DatasetDict.map()</a>. For example, tokenize the <code>sentence1</code> field in the train and test split by:',en,Ma,tn,ya,nn,ba,Hl='When you use <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.map">map()</a> in a distributed setting, you should also use <a href="https://pytorch.org/docs/stable/distributed?highlight=barrier#torch.distributed.barrier" rel="nofollow">torch.distributed.barrier</a>. This ensures the main process performs the mapping, while the other processes load the results, thereby avoiding duplicate work.',ln,wa,Al="The following example shows how you can use <code>torch.distributed.barrier</code> to synchronize the processes:",pn,Ta,rn,Ja,cn,_a,Sl='Separate datasets can be concatenated if they share the same column types. Concatenate datasets with <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.concatenate_datasets">concatenate_datasets()</a>:',hn,Ua,on,xa,Dl="You can also concatenate two datasets horizontally by setting <code>axis=1</code> as long as the datasets have the same number of rows:",mn,$a,dn,Ia,un,ka,Ll=`You can also mix several datasets together by taking alternating examples from each one to create a new dataset. This is known as <em>interleaving</em>, which is enabled by the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.interleave_datasets">interleave_datasets()</a> function. Both <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.interleave_datasets">interleave_datasets()</a> and <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.concatenate_datasets">concatenate_datasets()</a> work with regular <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> objects.
Refer to the <a href="./stream#interleave">Stream</a> guide for an example of how to interleave <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> objects.`,jn,Ca,Pl=`You can define sampling probabilities for each of the original datasets to specify how to interleave the datasets.
In this case, the new dataset is constructed by getting examples one by one from a random dataset until one of the datasets runs out of samples.`,gn,Za,fn,Ga,Kl=`You can also specify the <code>stopping_strategy</code>. The default strategy, <code>first_exhausted</code>, is a subsampling strategy, i.e the dataset construction is stopped as soon one of the dataset runs out of samples.
You can specify <code>stopping_strategy=all_exhausted</code> to execute an oversampling strategy. In this case, the dataset construction is stopped as soon as every samples in every dataset has been added at least once. In practice, it means that if a dataset is exhausted, it will return to the beginning of this dataset until the stop criterion has been reached.
Note that if no sampling probabilities are specified, the new dataset will have <code>max_length_datasets*nb_dataset samples</code>.`,Mn,Xa,yn,va,bn,Ra,Ol='The <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.set_format">set_format()</a> function changes the format of a column to be compatible with some common data formats. Specify the output you’d like in the <code>type</code> parameter and the columns you want to format. Formatting is applied on-the-fly.',wn,Va,sp="For example, create PyTorch tensors by setting <code>type=&quot;torch&quot;</code>:",Tn,Ya,Jn,Na,ap='The <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.with_format">with_format()</a> function also changes the format of a column, except it returns a new <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object:',_n,Fa,Un,U,xn,Ba,ep='If you need to reset the dataset to its original format, use the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.reset_format">reset_format()</a> function:',$n,Qa,In,Wa,kn,qa,tp='The <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function applies a custom formatting transform on-the-fly. This function replaces any previously specified format. For example, you can use this function to tokenize and pad tokens on-the-fly. Tokenization is only applied when examples are accessed:',Cn,za,Zn,Ea,np='You can also use the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function to decode formats not supported by <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Features">Features</a>. For example, the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Audio">Audio</a> feature uses <a href="https://python-soundfile.readthedocs.io/en/0.11.0/" rel="nofollow"><code>soundfile</code></a> - a fast and simple library to install - but it does not provide support for less common audio formats. Here is where you can use <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> to apply a custom decoding transform on the fly. You’re free to use any library you like to decode the audio files.',Gn,Ha,lp='The example below uses the <a href="http://pydub.com/" rel="nofollow"><code>pydub</code></a> package to open an audio format not supported by <code>soundfile</code>:',Xn,Aa,vn,Sa,Rn,Da,pp='Once you are done processing your dataset, you can save and reuse it later with <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.save_to_disk">save_to_disk()</a>.',Vn,La,ip="Save your dataset by providing the path to the directory you wish to save it to:",Yn,Pa,Nn,Ka,rp='Use the <a href="/docs/datasets/pr_7043/en/package_reference/loading_methods#datasets.load_from_disk">load_from_disk()</a> function to reload the dataset:',Fn,Oa,Bn,x,Qn,se,Wn,ae,cp="🤗 Datasets supports exporting as well so you can work with your dataset in other applications. The following table shows currently supported file formats you can export to:",qn,ee,hp='<thead><tr><th>File type</th> <th>Export method</th></tr></thead> <tbody><tr><td>CSV</td> <td><a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.to_csv">Dataset.to_csv()</a></td></tr> <tr><td>JSON</td> <td><a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.to_json">Dataset.to_json()</a></td></tr> <tr><td>Parquet</td> <td><a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.to_parquet">Dataset.to_parquet()</a></td></tr> <tr><td>SQL</td> <td><a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.to_sql">Dataset.to_sql()</a></td></tr> <tr><td>In-memory Python object</td> <td><a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.to_pandas">Dataset.to_pandas()</a> or <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.to_dict">Dataset.to_dict()</a></td></tr></tbody>',zn,te,op="For example, export your dataset to a CSV file like this:",En,ne,Hn,le,An,pe,Sn;return $=new M({props:{title:"Process",local:"process",headingTag:"h1"}}),X=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),T=new ie({props:{warning:!0,$$slots:{default:[xp]},$$scope:{ctx:w}}}),v=new M({props:{title:"Sort, shuffle, select, split, and shard",local:"sort-shuffle-select-split-and-shard",headingTag:"h2"}}),V=new M({props:{title:"Sort",local:"sort",headingTag:"h3"}}),N=new g({props:{code:"ZGF0YXNldCU1QiUyMmxhYmVsJTIyJTVEJTVCJTNBMTAlNUQlMEFzb3J0ZWRfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJsYWJlbCUyMiklMEFzb3J0ZWRfZGF0YXNldCU1QiUyMmxhYmVsJTIyJTVEJTVCJTNBMTAlNUQlMEFzb3J0ZWRfZGF0YXNldCU1QiUyMmxhYmVsJTIyJTVEJTVCLTEwJTNBJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;label&quot;</span>][:<span class="hljs-number">10</span>]
[<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>sorted_dataset = dataset.sort(<span class="hljs-string">&quot;label&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sorted_dataset[<span class="hljs-string">&quot;label&quot;</span>][:<span class="hljs-number">10</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>sorted_dataset[<span class="hljs-string">&quot;label&quot;</span>][-<span class="hljs-number">10</span>:]
[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),B=new M({props:{title:"Shuffle",local:"shuffle",headingTag:"h3"}}),W=new g({props:{code:"c2h1ZmZsZWRfZGF0YXNldCUyMCUzRCUyMHNvcnRlZF9kYXRhc2V0LnNodWZmbGUoc2VlZCUzRDQyKSUwQXNodWZmbGVkX2RhdGFzZXQlNUIlMjJsYWJlbCUyMiU1RCU1QiUzQTEwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>shuffled_dataset = sorted_dataset.shuffle(seed=<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>shuffled_dataset[<span class="hljs-string">&quot;label&quot;</span>][:<span class="hljs-number">10</span>]
[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>]`,wrap:!1}}),z=new g({props:{code:"aXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudG9faXRlcmFibGVfZGF0YXNldChudW1fc2hhcmRzJTNEMTI4KSUwQXNodWZmbGVkX2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBpdGVyYWJsZV9kYXRhc2V0LnNodWZmbGUoc2VlZCUzRDQyJTJDJTIwYnVmZmVyX3NpemUlM0QxMDAwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset(num_shards=<span class="hljs-number">128</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>shuffled_iterable_dataset = iterable_dataset.shuffle(seed=<span class="hljs-number">42</span>, buffer_size=<span class="hljs-number">1000</span>)`,wrap:!1}}),E=new M({props:{title:"Select and Filter",local:"select-and-filter",headingTag:"h3"}}),S=new g({props:{code:"c21hbGxfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc2VsZWN0KCU1QjAlMkMlMjAxMCUyQyUyMDIwJTJDJTIwMzAlMkMlMjA0MCUyQyUyMDUwJTVEKSUwQWxlbihzbWFsbF9kYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_dataset = dataset.select([<span class="hljs-number">0</span>, <span class="hljs-number">10</span>, <span class="hljs-number">20</span>, <span class="hljs-number">30</span>, <span class="hljs-number">40</span>, <span class="hljs-number">50</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(small_dataset)
<span class="hljs-number">6</span>`,wrap:!1}}),L=new g({props:{code:"c3RhcnRfd2l0aF9hciUyMCUzRCUyMGRhdGFzZXQuZmlsdGVyKGxhbWJkYSUyMGV4YW1wbGUlM0ElMjBleGFtcGxlJTVCJTIyc2VudGVuY2UxJTIyJTVELnN0YXJ0c3dpdGgoJTIyQXIlMjIpKSUwQWxlbihzdGFydF93aXRoX2FyKSUwQXN0YXJ0X3dpdGhfYXIlNUIlMjJzZW50ZW5jZTElMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>start_with_ar = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example: example[<span class="hljs-string">&quot;sentence1&quot;</span>].startswith(<span class="hljs-string">&quot;Ar&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(start_with_ar)
<span class="hljs-number">6</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>start_with_ar[<span class="hljs-string">&quot;sentence1&quot;</span>]
[<span class="hljs-string">&#x27;Around 0335 GMT , Tab shares were up 19 cents , or 4.4 % , at A $ 4.56 , having earlier set a record high of A $ 4.57 .&#x27;</span>,
<span class="hljs-string">&#x27;Arison said Mann may have been one of the pioneers of the world music movement and he had a deep love of Brazilian music .&#x27;</span>,
<span class="hljs-string">&#x27;Arts helped coach the youth on an eighth-grade football team at Lombardi Middle School in Green Bay .&#x27;</span>,
<span class="hljs-string">&#x27;Around 9 : 00 a.m. EDT ( 1300 GMT ) , the euro was at $ 1.1566 against the dollar , up 0.07 percent on the day .&#x27;</span>,
<span class="hljs-string">&quot;Arguing that the case was an isolated example , Canada has threatened a trade backlash if Tokyo &#x27;s ban is not justified on scientific grounds .&quot;</span>,
<span class="hljs-string">&#x27;Artists are worried the plan would harm those who need help most - performers who have a difficult time lining up shows .&#x27;</span>
]`,wrap:!1}}),K=new g({props:{code:"ZXZlbl9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIobGFtYmRhJTIwZXhhbXBsZSUyQyUyMGlkeCUzQSUyMGlkeCUyMCUyNSUyMDIlMjAlM0QlM0QlMjAwJTJDJTIwd2l0aF9pbmRpY2VzJTNEVHJ1ZSklMEFsZW4oZXZlbl9kYXRhc2V0KSUwQWxlbihkYXRhc2V0KSUyMCUyRiUyMDI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>even_dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example, idx: idx % <span class="hljs-number">2</span> == <span class="hljs-number">0</span>, with_indices=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(even_dataset)
<span class="hljs-number">1834</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset) / <span class="hljs-number">2</span>
<span class="hljs-number">1834.0</span>`,wrap:!1}}),ss=new M({props:{title:"Split",local:"split",headingTag:"h3"}}),es=new g({props:{code:"ZGF0YXNldC50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMSklMEEwLjElMjAqJTIwbGVuKGRhdGFzZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)
{<span class="hljs-string">&#x27;train&#x27;</span>: Dataset(schema: {<span class="hljs-string">&#x27;sentence1&#x27;</span>: <span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>: <span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-string">&#x27;int32&#x27;</span>}, num_rows: <span class="hljs-number">3301</span>),
<span class="hljs-string">&#x27;test&#x27;</span>: Dataset(schema: {<span class="hljs-string">&#x27;sentence1&#x27;</span>: <span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>: <span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-string">&#x27;int32&#x27;</span>}, num_rows: <span class="hljs-number">367</span>)}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-number">0.1</span> * <span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">366.8</span>`,wrap:!1}}),ns=new M({props:{title:"Shard",local:"shard",headingTag:"h3"}}),is=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJpbWRiJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFwcmludChkYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dataset)
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">25000</span>
})`,wrap:!1}}),cs=new g({props:{code:"ZGF0YXNldC5zaGFyZChudW1fc2hhcmRzJTNENCUyQyUyMGluZGV4JTNEMCklMEFwcmludCgyNTAwMCUyRjQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.shard(num_shards=<span class="hljs-number">4</span>, index=<span class="hljs-number">0</span>)
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">6250</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-number">25000</span>/<span class="hljs-number">4</span>)
<span class="hljs-number">6250.0</span>`,wrap:!1}}),hs=new M({props:{title:"Rename, remove, cast, and flatten",local:"rename-remove-cast-and-flatten",headingTag:"h2"}}),ms=new M({props:{title:"Rename",local:"rename",headingTag:"h3"}}),js=new g({props:{code:"ZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIyc2VudGVuY2UxJTIyJTJDJTIwJTIyc2VudGVuY2VBJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIyc2VudGVuY2UyJTIyJTJDJTIwJTIyc2VudGVuY2VCJTIyKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.rename_column(<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentenceA&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.rename_column(<span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;sentenceB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentenceA&#x27;</span>, <span class="hljs-string">&#x27;sentenceB&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})`,wrap:!1}}),gs=new M({props:{title:"Remove",local:"remove",headingTag:"h3"}}),Ms=new g({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVtb3ZlX2NvbHVtbnMoJTIybGFiZWwlMjIpJTBBZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiU1RCklMEFkYXRhc2V0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns(<span class="hljs-string">&quot;label&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})`,wrap:!1}}),bs=new g({props:{code:"ZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNlbGVjdF9jb2x1bW5zKCU1QidzZW50ZW5jZTEnJTJDJTIwJ3NlbnRlbmNlMiclMkMlMjAnaWR4JyU1RCklMEFkYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc2VsZWN0X2NvbHVtbnMoJ2lkeCcpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.select_columns([<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.select_columns(<span class="hljs-string">&#x27;idx&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})`,wrap:!1}}),ws=new M({props:{title:"Cast",local:"cast",headingTag:"h3"}}),Js=new g({props:{code:"ZGF0YXNldC5mZWF0dXJlcyUwQSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMENsYXNzTGFiZWwlMkMlMjBWYWx1ZSUwQW5ld19mZWF0dXJlcyUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMuY29weSgpJTBBbmV3X2ZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQlMjAlM0QlMjBDbGFzc0xhYmVsKG5hbWVzJTNEJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RCklMEFuZXdfZmVhdHVyZXMlNUIlMjJpZHglMjIlNUQlMjAlM0QlMjBWYWx1ZSglMjJpbnQ2NCUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5jYXN0KG5ld19mZWF0dXJlcyklMEFkYXRhc2V0LmZlYXR1cmVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;not_equivalent&#x27;</span>, <span class="hljs-string">&#x27;equivalent&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> ClassLabel, Value
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features = dataset.features.copy()
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;label&quot;</span>] = ClassLabel(names=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;idx&quot;</span>] = Value(<span class="hljs-string">&quot;int64&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast(new_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;negative&#x27;</span>, <span class="hljs-string">&#x27;positive&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),J=new ie({props:{$$slots:{default:[$p]},$$scope:{ctx:w}}}),Us=new g({props:{code:"ZGF0YXNldC5mZWF0dXJlcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2MDAwKSklMEFkYXRhc2V0LmZlYXR1cmVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">44100</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">16000</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),xs=new M({props:{title:"Flatten",local:"flatten",headingTag:"h3"}}),Is=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzcXVhZCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZGF0YXNldC5mZWF0dXJlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;squad&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;answers&#x27;</span>: <span class="hljs-type">Sequence</span>(feature={<span class="hljs-string">&#x27;text&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), <span class="hljs-string">&#x27;answer_start&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}, length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;context&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;id&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;question&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;title&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),Cs=new g({props:{code:"ZmxhdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5mbGF0dGVuKCklMEFmbGF0X2RhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset = dataset.flatten()
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;id&#x27;</span>, <span class="hljs-string">&#x27;title&#x27;</span>, <span class="hljs-string">&#x27;context&#x27;</span>, <span class="hljs-string">&#x27;question&#x27;</span>, <span class="hljs-string">&#x27;answers.text&#x27;</span>, <span class="hljs-string">&#x27;answers.answer_start&#x27;</span>],
 num_rows: <span class="hljs-number">87599</span>
})`,wrap:!1}}),Gs=new M({props:{title:"Map",local:"map",headingTag:"h2"}}),Vs=new g({props:{code:"ZGVmJTIwYWRkX3ByZWZpeChleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMjAlM0QlMjAnTXklMjBzZW50ZW5jZSUzQSUyMCclMjAlMkIlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UxJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">add_prefix</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;sentence1&quot;</span>] = <span class="hljs-string">&#x27;My sentence: &#x27;</span> + example[<span class="hljs-string">&quot;sentence1&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example`,wrap:!1}}),Ns=new g({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwc21hbGxfZGF0YXNldC5tYXAoYWRkX3ByZWZpeCklMEF1cGRhdGVkX2RhdGFzZXQlNUIlMjJzZW50ZW5jZTElMjIlNUQlNUIlM0E1JTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = small_dataset.<span class="hljs-built_in">map</span>(add_prefix)
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset[<span class="hljs-string">&quot;sentence1&quot;</span>][:<span class="hljs-number">5</span>]
[<span class="hljs-string">&#x27;My sentence: Amrozi accused his brother , whom he called &quot; the witness &quot; , of deliberately distorting his evidence .&#x27;</span>,
<span class="hljs-string">&quot;My sentence: Yucaipa owned Dominick &#x27;s before selling the chain to Safeway in 1998 for $ 2.5 billion .&quot;</span>,
<span class="hljs-string">&#x27;My sentence: They had published an advertisement on the Internet on June 10 , offering the cargo for sale , he added .&#x27;</span>,
<span class="hljs-string">&#x27;My sentence: Around 0335 GMT , Tab shares were up 19 cents , or 4.4 % , at A $ 4.56 , having earlier set a record high of A $ 4.57 .&#x27;</span>,
]`,wrap:!1}}),Qs=new g({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZSUzQSUyMCU3QiUyMm5ld19zZW50ZW5jZSUyMiUzQSUyMGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlN0QlMkMlMjByZW1vdmVfY29sdW1ucyUzRCU1QiUyMnNlbnRlbmNlMSUyMiU1RCklMEF1cGRhdGVkX2RhdGFzZXQuY29sdW1uX25hbWVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> example: {<span class="hljs-string">&quot;new_sentence&quot;</span>: example[<span class="hljs-string">&quot;sentence1&quot;</span>]}, remove_columns=[<span class="hljs-string">&quot;sentence1&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset.column_names
[<span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;new_sentence&#x27;</span>]`,wrap:!1}}),_=new ie({props:{$$slots:{default:[Ip]},$$scope:{ctx:w}}}),qs=new g({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZSUyQyUyMGlkeCUzQSUyMCU3QiUyMnNlbnRlbmNlMiUyMiUzQSUyMGYlMjIlN0JpZHglN0QlM0ElMjAlMjIlMjAlMkIlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTdEJTJDJTIwd2l0aF9pbmRpY2VzJTNEVHJ1ZSklMEF1cGRhdGVkX2RhdGFzZXQlNUIlMjJzZW50ZW5jZTIlMjIlNUQlNUIlM0E1JTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> example, idx: {<span class="hljs-string">&quot;sentence2&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{idx}</span>: &quot;</span> + example[<span class="hljs-string">&quot;sentence2&quot;</span>]}, with_indices=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset[<span class="hljs-string">&quot;sentence2&quot;</span>][:<span class="hljs-number">5</span>]
[<span class="hljs-string">&#x27;0: Referring to him as only &quot; the witness &quot; , Amrozi accused his brother of deliberately distorting his evidence .&#x27;</span>,
 <span class="hljs-string">&quot;1: Yucaipa bought Dominick &#x27;s in 1995 for $ 693 million and sold it to Safeway for $ 1.8 billion in 1998 .&quot;</span>,
 <span class="hljs-string">&quot;2: On June 10 , the ship &#x27;s owners had published an advertisement on the Internet , offering the explosives for sale .&quot;</span>,
 <span class="hljs-string">&#x27;3: Tab shares jumped 20 cents , or 4.6 % , to set a record closing high at A $ 4.57 .&#x27;</span>,
 <span class="hljs-string">&#x27;4: PG &amp; E Corp. shares jumped $ 1.63 or 8 percent to $ 21.03 on the New York Stock Exchange on Friday .&#x27;</span>
]`,wrap:!1}}),zs=new M({props:{title:"Multiprocessing",local:"multiprocessing",headingTag:"h3"}}),Hs=new g({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZSUyQyUyMGlkeCUzQSUyMCU3QiUyMnNlbnRlbmNlMiUyMiUzQSUyMGYlMjIlN0JpZHglN0QlM0ElMjAlMjIlMjAlMkIlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTdEJTJDJTIwd2l0aF9pbmRpY2VzJTNEVHJ1ZSUyQyUyMG51bV9wcm9jJTNENCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> example, idx: {<span class="hljs-string">&quot;sentence2&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{idx}</span>: &quot;</span> + example[<span class="hljs-string">&quot;sentence2&quot;</span>]}, with_indices=<span class="hljs-literal">True</span>, num_proc=<span class="hljs-number">4</span>)',wrap:!1}}),Ss=new g({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> multiprocess <span class="hljs-keyword">import</span> set_start_method
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get an example dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;fka/awesome-chatgpt-prompts&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get an example model and its tokenizer </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen1.5-0.5B-Chat&quot;</span>).<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen1.5-0.5B-Chat&quot;</span>)
&gt;&gt;&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">gpu_computation</span>(<span class="hljs-params">batch, rank</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Move the model on the right GPU if it&#x27;s not there already</span>
<span class="hljs-meta">... </span>    device = <span class="hljs-string">f&quot;cuda:<span class="hljs-subst">{(rank <span class="hljs-keyword">or</span> <span class="hljs-number">0</span>) % torch.cuda.device_count()}</span>&quot;</span>
<span class="hljs-meta">... </span>    model.to(device)
<span class="hljs-meta">... </span>    
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Your big GPU call goes here, for example:</span>
<span class="hljs-meta">... </span>    chats = [[
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}
<span class="hljs-meta">... </span>    ] <span class="hljs-keyword">for</span> prompt <span class="hljs-keyword">in</span> batch[<span class="hljs-string">&quot;prompt&quot;</span>]]
<span class="hljs-meta">... </span>    texts = [tokenizer.apply_chat_template(
<span class="hljs-meta">... </span>        chat,
<span class="hljs-meta">... </span>        tokenize=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        add_generation_prompt=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    ) <span class="hljs-keyword">for</span> chat <span class="hljs-keyword">in</span> chats]
<span class="hljs-meta">... </span>    model_inputs = tokenizer(texts, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        outputs = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">512</span>)
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;output&quot;</span>] = tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch
&gt;&gt;&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
<span class="hljs-meta">... </span>    set_start_method(<span class="hljs-string">&quot;spawn&quot;</span>)
<span class="hljs-meta">... </span>    updated_dataset = dataset.<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>        gpu_computation,
<span class="hljs-meta">... </span>        batched=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        batch_size=<span class="hljs-number">16</span>,
<span class="hljs-meta">... </span>        with_rank=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        num_proc=torch.cuda.device_count(),  <span class="hljs-comment"># one process per GPU</span>
<span class="hljs-meta">... </span>    )`,wrap:!1}}),Ls=new g({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ2Fubm90JTIwcmUtaW5pdGlhbGl6ZSUyMENVREElMjBpbiUyMGZvcmtlZCUyMHN1YnByb2Nlc3MuJTIwVG8lMjB1c2UlMjBDVURBJTIwd2l0aCUyMG11bHRpcHJvY2Vzc2luZyUyQyUyMHlvdSUyMG11c3QlMjB1c2UlMjB0aGUlMjAnc3Bhd24nJTIwc3RhcnQlMjBtZXRob2Qu",highlighted:'RuntimeError: Cannot re-initialize CUDA <span class="hljs-keyword">in</span> forked subprocess. To use CUDA with multiprocessing, you must use the <span class="hljs-string">&#x27;spawn&#x27;</span> start method.',wrap:!1}}),Ps=new M({props:{title:"Batch processing",local:"batch-processing",headingTag:"h3"}}),Os=new M({props:{title:"Split long examples",local:"split-long-examples",headingTag:"h4"}}),ea=new g({props:{code:"ZGVmJTIwY2h1bmtfZXhhbXBsZXMoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwY2h1bmtzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwc2VudGVuY2UlMjBpbiUyMGV4YW1wbGVzJTVCJTIyc2VudGVuY2UxJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2h1bmtzJTIwJTJCJTNEJTIwJTVCc2VudGVuY2UlNUJpJTNBaSUyMCUyQiUyMDUwJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihzZW50ZW5jZSklMkMlMjA1MCklNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJjaHVua3MlMjIlM0ElMjBjaHVua3MlN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">chunk_examples</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    chunks = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> sentence <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;sentence1&quot;</span>]:
<span class="hljs-meta">... </span>        chunks += [sentence[i:i + <span class="hljs-number">50</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(sentence), <span class="hljs-number">50</span>)]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;chunks&quot;</span>: chunks}`,wrap:!1}}),na=new g({props:{code:"Y2h1bmtlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2h1bmtfZXhhbXBsZXMlMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMpJTBBY2h1bmtlZF9kYXRhc2V0JTVCJTNBMTAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>chunked_dataset = dataset.<span class="hljs-built_in">map</span>(chunk_examples, batched=<span class="hljs-literal">True</span>, remove_columns=dataset.column_names)
<span class="hljs-meta">&gt;&gt;&gt; </span>chunked_dataset[:<span class="hljs-number">10</span>]
{<span class="hljs-string">&#x27;chunks&#x27;</span>: [<span class="hljs-string">&#x27;Amrozi accused his brother , whom he called &quot; the &#x27;</span>,
            <span class="hljs-string">&#x27;witness &quot; , of deliberately distorting his evidenc&#x27;</span>,
            <span class="hljs-string">&#x27;e .&#x27;</span>,
            <span class="hljs-string">&quot;Yucaipa owned Dominick &#x27;s before selling the chain&quot;</span>,
            <span class="hljs-string">&#x27; to Safeway in 1998 for $ 2.5 billion .&#x27;</span>,
            <span class="hljs-string">&#x27;They had published an advertisement on the Interne&#x27;</span>,
            <span class="hljs-string">&#x27;t on June 10 , offering the cargo for sale , he ad&#x27;</span>,
            <span class="hljs-string">&#x27;ded .&#x27;</span>,
            <span class="hljs-string">&#x27;Around 0335 GMT , Tab shares were up 19 cents , or&#x27;</span>,
            <span class="hljs-string">&#x27; 4.4 % , at A $ 4.56 , having earlier set a record&#x27;</span>]}`,wrap:!1}}),pa=new g({props:{code:"ZGF0YXNldCUwQWNodW5rZWRfZGF0YXNldA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
 features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
 num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>chunked_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;chunks&#x27;</span>],
    num_rows: <span class="hljs-number">10470</span>
})`,wrap:!1}}),ia=new M({props:{title:"Data augmentation",local:"data-augmentation",headingTag:"h4"}}),ha=new g({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRpbnQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFmaWxsbWFzayUyMCUzRCUyMHBpcGVsaW5lKCUyMmZpbGwtbWFzayUyMiUyQyUyMG1vZGVsJTNEJTIycm9iZXJ0YS1iYXNlJTIyKSUwQW1hc2tfdG9rZW4lMjAlM0QlMjBmaWxsbWFzay50b2tlbml6ZXIubWFza190b2tlbiUwQXNtYWxsZXJfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuZmlsdGVyKGxhbWJkYSUyMGUlMkMlMjBpJTNBJTIwaSUzQzEwMCUyQyUyMHdpdGhfaW5kaWNlcyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randint
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>fillmask = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=<span class="hljs-string">&quot;roberta-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_token = fillmask.tokenizer.mask_token
<span class="hljs-meta">&gt;&gt;&gt; </span>smaller_dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> e, i: i&lt;<span class="hljs-number">100</span>, with_indices=<span class="hljs-literal">True</span>)`,wrap:!1}}),ma=new g({props:{code:"ZGVmJTIwYXVnbWVudF9kYXRhKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBzZW50ZW5jZSUyMGluJTIwZXhhbXBsZXMlNUIlMjJzZW50ZW5jZTElMjIlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3b3JkcyUyMCUzRCUyMHNlbnRlbmNlLnNwbGl0KCclMjAnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEslMjAlM0QlMjByYW5kaW50KDElMkMlMjBsZW4od29yZHMpLTEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWFza2VkX3NlbnRlbmNlJTIwJTNEJTIwJTIyJTIwJTIyLmpvaW4od29yZHMlNUIlM0FLJTVEJTIwJTIwJTJCJTIwJTVCbWFza190b2tlbiU1RCUyMCUyQiUyMHdvcmRzJTVCSyUyQjElM0ElNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBmaWxsbWFzayhtYXNrZWRfc2VudGVuY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVnbWVudGVkX3NlcXVlbmNlcyUyMCUzRCUyMCU1QnByZWRpY3Rpb25zJTVCaSU1RCU1QiUyMnNlcXVlbmNlJTIyJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMyklNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTJCJTNEJTIwJTVCc2VudGVuY2UlNUQlMjAlMkIlMjBhdWdtZW50ZWRfc2VxdWVuY2VzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyZGF0YSUyMiUzQSUyMG91dHB1dHMlN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">augment_data</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    outputs = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> sentence <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;sentence1&quot;</span>]:
<span class="hljs-meta">... </span>        words = sentence.split(<span class="hljs-string">&#x27; &#x27;</span>)
<span class="hljs-meta">... </span>        K = randint(<span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(words)-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>        masked_sentence = <span class="hljs-string">&quot; &quot;</span>.join(words[:K]  + [mask_token] + words[K+<span class="hljs-number">1</span>:])
<span class="hljs-meta">... </span>        predictions = fillmask(masked_sentence)
<span class="hljs-meta">... </span>        augmented_sequences = [predictions[i][<span class="hljs-string">&quot;sequence&quot;</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>)]
<span class="hljs-meta">... </span>        outputs += [sentence] + augmented_sequences
...
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;data&quot;</span>: outputs}`,wrap:!1}}),ua=new g({props:{code:"YXVnbWVudGVkX2RhdGFzZXQlMjAlM0QlMjBzbWFsbGVyX2RhdGFzZXQubWFwKGF1Z21lbnRfZGF0YSUyQyUyMGJhdGNoZWQlM0RUcnVlJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0RkYXRhc2V0LmNvbHVtbl9uYW1lcyUyQyUyMGJhdGNoX3NpemUlM0Q4KSUwQWF1Z21lbnRlZF9kYXRhc2V0JTVCJTNBOSU1RCU1QiUyMmRhdGElMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>augmented_dataset = smaller_dataset.<span class="hljs-built_in">map</span>(augment_data, batched=<span class="hljs-literal">True</span>, remove_columns=dataset.column_names, batch_size=<span class="hljs-number">8</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>augmented_dataset[:<span class="hljs-number">9</span>][<span class="hljs-string">&quot;data&quot;</span>]
[<span class="hljs-string">&#x27;Amrozi accused his brother , whom he called &quot; the witness &quot; , of deliberately distorting his evidence .&#x27;</span>,
 <span class="hljs-string">&#x27;Amrozi accused his brother, whom he called &quot; the witness &quot;, of deliberately withholding his evidence.&#x27;</span>,
 <span class="hljs-string">&#x27;Amrozi accused his brother, whom he called &quot; the witness &quot;, of deliberately suppressing his evidence.&#x27;</span>,
 <span class="hljs-string">&#x27;Amrozi accused his brother, whom he called &quot; the witness &quot;, of deliberately destroying his evidence.&#x27;</span>,
 <span class="hljs-string">&quot;Yucaipa owned Dominick &#x27;s before selling the chain to Safeway in 1998 for $ 2.5 billion .&quot;</span>,
 <span class="hljs-string">&#x27;Yucaipa owned Dominick Stores before selling the chain to Safeway in 1998 for $ 2.5 billion.&#x27;</span>,
 <span class="hljs-string">&quot;Yucaipa owned Dominick&#x27;s before selling the chain to Safeway in 1998 for $ 2.5 billion.&quot;</span>,
 <span class="hljs-string">&#x27;Yucaipa owned Dominick Pizza before selling the chain to Safeway in 1998 for $ 2.5 billion.&#x27;</span>
]`,wrap:!1}}),ga=new M({props:{title:"Process multiple splits",local:"process-multiple-splits",headingTag:"h3"}}),Ma=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnZ2x1ZSclMkMlMjAnbXJwYycpJTBBZW5jb2RlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZXMlM0ElMjB0b2tlbml6ZXIoZXhhbXBsZXMlNUIlMjJzZW50ZW5jZTElMjIlNUQpJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTBBZW5jb2RlZF9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># load all the splits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;glue&#x27;</span>, <span class="hljs-string">&#x27;mrpc&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> examples: tokenizer(examples[<span class="hljs-string">&quot;sentence1&quot;</span>]), batched=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: <span class="hljs-string">&#x27;Amrozi accused his brother , whom he called &quot; the witness &quot; , of deliberately distorting his evidence .&#x27;</span>,
<span class="hljs-string">&#x27;sentence2&#x27;</span>: <span class="hljs-string">&#x27;Referring to him as only &quot; the witness &quot; , Amrozi accused his brother of deliberately distorting his evidence .&#x27;</span>,
<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
<span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-number">0</span>,
<span class="hljs-string">&#x27;input_ids&#x27;</span>: [  <span class="hljs-number">101</span>,  <span class="hljs-number">7277</span>,  <span class="hljs-number">2180</span>,  <span class="hljs-number">5303</span>,  <span class="hljs-number">4806</span>,  <span class="hljs-number">1117</span>,  <span class="hljs-number">1711</span>,   <span class="hljs-number">117</span>,  <span class="hljs-number">2292</span>, <span class="hljs-number">1119</span>,  <span class="hljs-number">1270</span>,   <span class="hljs-number">107</span>,  <span class="hljs-number">1103</span>,  <span class="hljs-number">7737</span>,   <span class="hljs-number">107</span>,   <span class="hljs-number">117</span>,  <span class="hljs-number">1104</span>,  <span class="hljs-number">9938</span>, <span class="hljs-number">4267</span>, <span class="hljs-number">12223</span>, <span class="hljs-number">21811</span>,  <span class="hljs-number">1117</span>,  <span class="hljs-number">2554</span>,   <span class="hljs-number">119</span>,   <span class="hljs-number">102</span>],
<span class="hljs-string">&#x27;token_type_ids&#x27;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
<span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]
}`,wrap:!1}}),ya=new M({props:{title:"Distributed usage",local:"distributed-usage",headingTag:"h3"}}),Ta=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWltcG9ydCUyMHRvcmNoLmRpc3RyaWJ1dGVkJTBBJTBBZGF0YXNldDElMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhJTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTVEJTdEKSUwQSUwQWlmJTIwdHJhaW5pbmdfYXJncy5sb2NhbF9yYW5rJTIwJTNFJTIwMCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMldhaXRpbmclMjBmb3IlMjBtYWluJTIwcHJvY2VzcyUyMHRvJTIwcGVyZm9ybSUyMHRoZSUyMG1hcHBpbmclMjIpJTBBJTIwJTIwJTIwJTIwdG9yY2guZGlzdHJpYnV0ZWQuYmFycmllcigpJTBBJTBBZGF0YXNldDIlMjAlM0QlMjBkYXRhc2V0MS5tYXAobGFtYmRhJTIweCUzQSUyMCU3QiUyMmElMjIlM0ElMjB4JTVCJTIyYSUyMiU1RCUyMCUyQiUyMDElN0QpJTBBJTBBaWYlMjB0cmFpbmluZ19hcmdzLmxvY2FsX3JhbmslMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTG9hZGluZyUyMHJlc3VsdHMlMjBmcm9tJTIwbWFpbiUyMHByb2Nlc3MlMjIpJTBBJTIwJTIwJTIwJTIwdG9yY2guZGlzdHJpYnV0ZWQuYmFycmllcigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.distributed

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset1 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]})

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> training_args.local_rank &gt; <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for main process to perform the mapping&quot;</span>)
<span class="hljs-meta">... </span>    torch.distributed.barrier()

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset2 = dataset1.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;a&quot;</span>: x[<span class="hljs-string">&quot;a&quot;</span>] + <span class="hljs-number">1</span>})

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> training_args.local_rank == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading results from main process&quot;</span>)
<span class="hljs-meta">... </span>    torch.distributed.barrier()`,wrap:!1}}),Ja=new M({props:{title:"Concatenate",local:"concatenate",headingTag:"h2"}}),Ua=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwY29uY2F0ZW5hdGVfZGF0YXNldHMlMkMlMjBsb2FkX2RhdGFzZXQlMEElMEFib29rY29ycHVzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmJvb2tjb3JwdXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQXdpa2klMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyd2lraXBlZGlhJTIyJTJDJTIwJTIyMjAyMjAzMDEuZW4lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQXdpa2klMjAlM0QlMjB3aWtpLnJlbW92ZV9jb2x1bW5zKCU1QmNvbCUyMGZvciUyMGNvbCUyMGluJTIwd2lraS5jb2x1bW5fbmFtZXMlMjBpZiUyMGNvbCUyMCElM0QlMjAlMjJ0ZXh0JTIyJTVEKSUyMCUyMCUyMyUyMG9ubHklMjBrZWVwJTIwdGhlJTIwJ3RleHQnJTIwY29sdW1uJTBBJTBBYXNzZXJ0JTIwYm9va2NvcnB1cy5mZWF0dXJlcy50eXBlJTIwJTNEJTNEJTIwd2lraS5mZWF0dXJlcy50eXBlJTBBYmVydF9kYXRhc2V0JTIwJTNEJTIwY29uY2F0ZW5hdGVfZGF0YXNldHMoJTVCYm9va2NvcnB1cyUyQyUyMHdpa2klNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> concatenate_datasets, load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>bookcorpus = load_dataset(<span class="hljs-string">&quot;bookcorpus&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>wiki = load_dataset(<span class="hljs-string">&quot;wikipedia&quot;</span>, <span class="hljs-string">&quot;20220301.en&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>wiki = wiki.remove_columns([col <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> wiki.column_names <span class="hljs-keyword">if</span> col != <span class="hljs-string">&quot;text&quot;</span>])  <span class="hljs-comment"># only keep the &#x27;text&#x27; column</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> bookcorpus.features.<span class="hljs-built_in">type</span> == wiki.features.<span class="hljs-built_in">type</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bert_dataset = concatenate_datasets([bookcorpus, wiki])`,wrap:!1}}),$a=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWJvb2tjb3JwdXNfaWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyaWRzJTIyJTNBJTIwbGlzdChyYW5nZShsZW4oYm9va2NvcnB1cykpKSU3RCklMEFib29rY29ycHVzX3dpdGhfaWRzJTIwJTNEJTIwY29uY2F0ZW5hdGVfZGF0YXNldHMoJTVCYm9va2NvcnB1cyUyQyUyMGJvb2tjb3JwdXNfaWRzJTVEJTJDJTIwYXhpcyUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>bookcorpus_ids = Dataset.from_dict({<span class="hljs-string">&quot;ids&quot;</span>: <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(bookcorpus)))})
<span class="hljs-meta">&gt;&gt;&gt; </span>bookcorpus_with_ids = concatenate_datasets([bookcorpus, bookcorpus_ids], axis=<span class="hljs-number">1</span>)`,wrap:!1}}),Ia=new M({props:{title:"Interleave",local:"interleave",headingTag:"h3"}}),Za=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMGludGVybGVhdmVfZGF0YXNldHMlMEFzZWVkJTIwJTNEJTIwNDIlMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwJTVCMC4zJTJDJTIwMC41JTJDJTIwMC4yJTVEJTBBZDElMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhJTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTVEJTdEKSUwQWQyJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyYSUyMiUzQSUyMCU1QjEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTVEJTdEKSUwQWQzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyYSUyMiUzQSUyMCU1QjIwJTJDJTIwMjElMkMlMjAyMiU1RCU3RCklMEFkYXRhc2V0JTIwJTNEJTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyglNUJkMSUyQyUyMGQyJTJDJTIwZDMlNUQlMkMlMjBwcm9iYWJpbGl0aWVzJTNEcHJvYmFiaWxpdGllcyUyQyUyMHNlZWQlM0RzZWVkKSUwQWRhdGFzZXQlNUIlMjJhJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, interleave_datasets
<span class="hljs-meta">&gt;&gt;&gt; </span>seed = <span class="hljs-number">42</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.5</span>, <span class="hljs-number">0.2</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>d1 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>d2 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>d3 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = interleave_datasets([d1, d2, d3], probabilities=probabilities, seed=seed)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;a&quot;</span>]
[<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">20</span>, <span class="hljs-number">12</span>, <span class="hljs-number">0</span>, <span class="hljs-number">21</span>, <span class="hljs-number">13</span>]`,wrap:!1}}),Xa=new g({props:{code:"ZDElMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhJTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTVEJTdEKSUwQWQyJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyYSUyMiUzQSUyMCU1QjEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTVEJTdEKSUwQWQzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyYSUyMiUzQSUyMCU1QjIwJTJDJTIwMjElMkMlMjAyMiU1RCU3RCklMEFkYXRhc2V0JTIwJTNEJTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyglNUJkMSUyQyUyMGQyJTJDJTIwZDMlNUQlMkMlMjBzdG9wcGluZ19zdHJhdGVneSUzRCUyMmFsbF9leGhhdXN0ZWQlMjIpJTBBZGF0YXNldCU1QiUyMmElMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>d1 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>d2 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>d3 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = interleave_datasets([d1, d2, d3], stopping_strategy=<span class="hljs-string">&quot;all_exhausted&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;a&quot;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">10</span>, <span class="hljs-number">20</span>, <span class="hljs-number">1</span>, <span class="hljs-number">11</span>, <span class="hljs-number">21</span>, <span class="hljs-number">2</span>, <span class="hljs-number">12</span>, <span class="hljs-number">22</span>, <span class="hljs-number">0</span>, <span class="hljs-number">13</span>, <span class="hljs-number">20</span>]`,wrap:!1}}),va=new M({props:{title:"Format",local:"format",headingTag:"h2"}}),Ya=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFkYXRhc2V0LnNldF9mb3JtYXQodHlwZSUzRCUyMnRvcmNoJTIyJTJDJTIwY29sdW1ucyUzRCU1QiUyMmlucHV0X2lkcyUyMiUyQyUyMCUyMnRva2VuX3R5cGVfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_format(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),Fa=new g({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQud2l0aF9mb3JtYXQodHlwZSUzRCUyMnRvcmNoJTIyJTJDJTIwY29sdW1ucyUzRCU1QiUyMmlucHV0X2lkcyUyMiUyQyUyMCUyMnRva2VuX3R5cGVfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.with_format(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])',wrap:!1}}),U=new ie({props:{$$slots:{default:[kp]},$$scope:{ctx:w}}}),Qa=new g({props:{code:"ZGF0YXNldC5mb3JtYXQlMEFkYXRhc2V0LnJlc2V0X2Zvcm1hdCgpJTBBZGF0YXNldC5mb3JtYXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.<span class="hljs-built_in">format</span>
{<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;torch&#x27;</span>, <span class="hljs-string">&#x27;format_kwargs&#x27;</span>: {}, <span class="hljs-string">&#x27;columns&#x27;</span>: [<span class="hljs-string">&#x27;label&#x27;</span>], <span class="hljs-string">&#x27;output_all_columns&#x27;</span>: <span class="hljs-literal">False</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.reset_format()
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.<span class="hljs-built_in">format</span>
{<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;python&#x27;</span>, <span class="hljs-string">&#x27;format_kwargs&#x27;</span>: {}, <span class="hljs-string">&#x27;columns&#x27;</span>: [<span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>], <span class="hljs-string">&#x27;output_all_columns&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),Wa=new M({props:{title:"Format transform",local:"format-transform",headingTag:"h3"}}),za=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEFkZWYlMjBlbmNvZGUoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGJhdGNoJTVCJTIyc2VudGVuY2UxJTIyJTVEJTJDJTIwYmF0Y2glNUIlMjJzZW50ZW5jZTIlMjIlNUQlMkMlMjBwYWRkaW5nJTNEJTIybG9uZ2VzdCUyMiUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwbWF4X2xlbmd0aCUzRDUxMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZGF0YXNldC5zZXRfdHJhbnNmb3JtKGVuY29kZSklMEFkYXRhc2V0LmZvcm1hdA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">encode</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(batch[<span class="hljs-string">&quot;sentence1&quot;</span>], batch[<span class="hljs-string">&quot;sentence2&quot;</span>], padding=<span class="hljs-string">&quot;longest&quot;</span>, truncation=<span class="hljs-literal">True</span>, max_length=<span class="hljs-number">512</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(encode)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.<span class="hljs-built_in">format</span>
{<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;custom&#x27;</span>, <span class="hljs-string">&#x27;format_kwargs&#x27;</span>: {<span class="hljs-string">&#x27;transform&#x27;</span>: &lt;function __main__.encode(batch)&gt;}, <span class="hljs-string">&#x27;columns&#x27;</span>: [<span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>], <span class="hljs-string">&#x27;output_all_columns&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),Aa=new g({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMHB5ZHViJTIwaW1wb3J0JTIwQXVkaW9TZWdtZW50JTBBJTBBYXVkaW9fZGF0YXNldF9hbXIlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhdWRpbyUyMiUzQSUyMCU1QiUyMmF1ZGlvX3NhbXBsZXMlMkZhdWRpby5hbXIlMjIlNUQlN0QpJTBBJTBBZGVmJTIwZGVjb2RlX2F1ZGlvX3dpdGhfcHlkdWIoYmF0Y2glMkMlMjBzYW1wbGluZ19yYXRlJTNEMTZfMDAwKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHB5ZHViX2RlY29kZV9maWxlKGF1ZGlvX3BhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc291bmQlMjAlM0QlMjBBdWRpb1NlZ21lbnQuZnJvbV9maWxlKGF1ZGlvX3BhdGgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzb3VuZC5mcmFtZV9yYXRlJTIwISUzRCUyMHNhbXBsaW5nX3JhdGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzb3VuZCUyMCUzRCUyMHNvdW5kLnNldF9mcmFtZV9yYXRlKHNhbXBsaW5nX3JhdGUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2hhbm5lbF9zb3VuZHMlMjAlM0QlMjBzb3VuZC5zcGxpdF90b19tb25vKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGVzJTIwJTNEJTIwJTVCcy5nZXRfYXJyYXlfb2Zfc2FtcGxlcygpJTIwZm9yJTIwcyUyMGluJTIwY2hhbm5lbF9zb3VuZHMlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcF9hcnIlMjAlM0QlMjBucC5hcnJheShzYW1wbGVzKS5ULmFzdHlwZShucC5mbG9hdDMyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZwX2FyciUyMCUyRiUzRCUyMG5wLmlpbmZvKHNhbXBsZXMlNUIwJTVELnR5cGVjb2RlKS5tYXglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBmcF9hcnIlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmF1ZGlvJTIyJTVEJTIwJTNEJTIwJTVCcHlkdWJfZGVjb2RlX2ZpbGUoYXVkaW9fcGF0aCklMjBmb3IlMjBhdWRpb19wYXRoJTIwaW4lMjBiYXRjaCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2glMEElMEFhdWRpb19kYXRhc2V0X2Ftci5zZXRfdHJhbnNmb3JtKGRlY29kZV9hdWRpb193aXRoX3B5ZHViKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pydub <span class="hljs-keyword">import</span> AudioSegment

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_dataset_amr = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: [<span class="hljs-string">&quot;audio_samples/audio.amr&quot;</span>]})

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_audio_with_pydub</span>(<span class="hljs-params">batch, sampling_rate=<span class="hljs-number">16_000</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">pydub_decode_file</span>(<span class="hljs-params">audio_path</span>):
<span class="hljs-meta">... </span>        sound = AudioSegment.from_file(audio_path)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> sound.frame_rate != sampling_rate:
<span class="hljs-meta">... </span>            sound = sound.set_frame_rate(sampling_rate)
<span class="hljs-meta">... </span>        channel_sounds = sound.split_to_mono()
<span class="hljs-meta">... </span>        samples = [s.get_array_of_samples() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> channel_sounds]
<span class="hljs-meta">... </span>        fp_arr = np.array(samples).T.astype(np.float32)
<span class="hljs-meta">... </span>        fp_arr /= np.iinfo(samples[<span class="hljs-number">0</span>].typecode).<span class="hljs-built_in">max</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> fp_arr
...
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;audio&quot;</span>] = [pydub_decode_file(audio_path) <span class="hljs-keyword">for</span> audio_path <span class="hljs-keyword">in</span> batch[<span class="hljs-string">&quot;audio&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_dataset_amr.set_transform(decode_audio_with_pydub)`,wrap:!1}}),Sa=new M({props:{title:"Save",local:"save",headingTag:"h2"}}),Pa=new g({props:{code:"ZW5jb2RlZF9kYXRhc2V0LnNhdmVfdG9fZGlzayglMjJwYXRoJTJGb2YlMkZteSUyRmRhdGFzZXQlMkZkaXJlY3RvcnklMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset.save_to_disk(<span class="hljs-string">&quot;path/of/my/dataset/directory&quot;</span>)',wrap:!1}}),Oa=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9mcm9tX2Rpc2slMEFyZWxvYWRlZF9kYXRhc2V0JTIwJTNEJTIwbG9hZF9mcm9tX2Rpc2soJTIycGF0aCUyRm9mJTJGbXklMkZkYXRhc2V0JTJGZGlyZWN0b3J5JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_from_disk
<span class="hljs-meta">&gt;&gt;&gt; </span>reloaded_dataset = load_from_disk(<span class="hljs-string">&quot;path/of/my/dataset/directory&quot;</span>)`,wrap:!1}}),x=new ie({props:{$$slots:{default:[Cp]},$$scope:{ctx:w}}}),se=new M({props:{title:"Export",local:"export",headingTag:"h2"}}),ne=new g({props:{code:"ZW5jb2RlZF9kYXRhc2V0LnRvX2NzdiglMjJwYXRoJTJGb2YlMkZteSUyRmRhdGFzZXQuY3N2JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset.to_csv(<span class="hljs-string">&quot;path/of/my/dataset.csv&quot;</span>)',wrap:!1}}),le=new Up({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/process.mdx"}}),{c(){j=p("meta"),y=n(),f=p("p"),b=n(),c($.$$.fragment),ce=n(),I=p("p"),I.textContent=Dn,he=n(),k=p("p"),k.textContent=Ln,oe=n(),C=p("ul"),C.innerHTML=Pn,me=n(),Z=p("p"),Z.innerHTML=Kn,de=n(),G=p("p"),G.textContent=On,ue=n(),c(X.$$.fragment),je=n(),c(T.$$.fragment),ge=n(),c(v.$$.fragment),fe=n(),R=p("p"),R.textContent=sl,Me=n(),c(V.$$.fragment),ye=n(),Y=p("p"),Y.innerHTML=al,be=n(),c(N.$$.fragment),we=n(),F=p("p"),F.textContent=el,Te=n(),c(B.$$.fragment),Je=n(),Q=p("p"),Q.innerHTML=tl,_e=n(),c(W.$$.fragment),Ue=n(),q=p("p"),q.innerHTML=nl,xe=n(),c(z.$$.fragment),$e=n(),c(E.$$.fragment),Ie=n(),H=p("p"),H.innerHTML=ll,ke=n(),A=p("ul"),A.innerHTML=pl,Ce=n(),c(S.$$.fragment),Ze=n(),D=p("ul"),D.innerHTML=il,Ge=n(),c(L.$$.fragment),Xe=n(),P=p("p"),P.innerHTML=rl,ve=n(),c(K.$$.fragment),Re=n(),O=p("p"),O.textContent=cl,Ve=n(),c(ss.$$.fragment),Ye=n(),as=p("p"),as.innerHTML=hl,Ne=n(),c(es.$$.fragment),Fe=n(),ts=p("p"),ts.innerHTML=ol,Be=n(),c(ns.$$.fragment),Qe=n(),ls=p("p"),ls.innerHTML=ml,We=n(),ps=p("p"),ps.innerHTML=dl,qe=n(),c(is.$$.fragment),ze=n(),rs=p("p"),rs.textContent=ul,Ee=n(),c(cs.$$.fragment),He=n(),c(hs.$$.fragment),Ae=n(),os=p("p"),os.textContent=jl,Se=n(),c(ms.$$.fragment),De=n(),ds=p("p"),ds.innerHTML=gl,Le=n(),us=p("p"),us.innerHTML=fl,Pe=n(),c(js.$$.fragment),Ke=n(),c(gs.$$.fragment),Oe=n(),fs=p("p"),fs.innerHTML=Ml,st=n(),c(Ms.$$.fragment),at=n(),ys=p("p"),ys.innerHTML=yl,et=n(),c(bs.$$.fragment),tt=n(),c(ws.$$.fragment),nt=n(),Ts=p("p"),Ts.innerHTML=bl,lt=n(),c(Js.$$.fragment),pt=n(),c(J.$$.fragment),it=n(),_s=p("p"),_s.innerHTML=wl,rt=n(),c(Us.$$.fragment),ct=n(),c(xs.$$.fragment),ht=n(),$s=p("p"),$s.textContent=Tl,ot=n(),c(Is.$$.fragment),mt=n(),ks=p("p"),ks.innerHTML=Jl,dt=n(),c(Cs.$$.fragment),ut=n(),Zs=p("p"),Zs.innerHTML=_l,jt=n(),c(Gs.$$.fragment),gt=n(),Xs=p("p"),Xs.innerHTML=Ul,ft=n(),vs=p("p"),vs.innerHTML=xl,Mt=n(),Rs=p("p"),Rs.innerHTML=$l,yt=n(),c(Vs.$$.fragment),bt=n(),Ys=p("p"),Ys.innerHTML=Il,wt=n(),c(Ns.$$.fragment),Tt=n(),Fs=p("p"),Fs.innerHTML=kl,Jt=n(),Bs=p("p"),Bs.innerHTML=Cl,_t=n(),c(Qs.$$.fragment),Ut=n(),c(_.$$.fragment),xt=n(),Ws=p("p"),Ws.innerHTML=Zl,$t=n(),c(qs.$$.fragment),It=n(),c(zs.$$.fragment),kt=n(),Es=p("p"),Es.innerHTML=Gl,Ct=n(),c(Hs.$$.fragment),Zt=n(),As=p("p"),As.innerHTML=Xl,Gt=n(),c(Ss.$$.fragment),Xt=n(),Ds=p("p"),Ds.innerHTML=vl,vt=n(),c(Ls.$$.fragment),Rt=n(),c(Ps.$$.fragment),Vt=n(),Ks=p("p"),Ks.innerHTML=Rl,Yt=n(),c(Os.$$.fragment),Nt=n(),sa=p("p"),sa.textContent=Vl,Ft=n(),aa=p("ol"),aa.innerHTML=Yl,Bt=n(),c(ea.$$.fragment),Qt=n(),ta=p("p"),ta.innerHTML=Nl,Wt=n(),c(na.$$.fragment),qt=n(),la=p("p"),la.textContent=Fl,zt=n(),c(pa.$$.fragment),Et=n(),c(ia.$$.fragment),Ht=n(),ra=p("p"),ra.innerHTML=Bl,At=n(),ca=p("p"),ca.innerHTML=Ql,St=n(),c(ha.$$.fragment),Dt=n(),oa=p("p"),oa.textContent=Wl,Lt=n(),c(ma.$$.fragment),Pt=n(),da=p("p"),da.innerHTML=ql,Kt=n(),c(ua.$$.fragment),Ot=n(),ja=p("p"),ja.innerHTML=zl,sn=n(),c(ga.$$.fragment),an=n(),fa=p("p"),fa.innerHTML=El,en=n(),c(Ma.$$.fragment),tn=n(),c(ya.$$.fragment),nn=n(),ba=p("p"),ba.innerHTML=Hl,ln=n(),wa=p("p"),wa.innerHTML=Al,pn=n(),c(Ta.$$.fragment),rn=n(),c(Ja.$$.fragment),cn=n(),_a=p("p"),_a.innerHTML=Sl,hn=n(),c(Ua.$$.fragment),on=n(),xa=p("p"),xa.innerHTML=Dl,mn=n(),c($a.$$.fragment),dn=n(),c(Ia.$$.fragment),un=n(),ka=p("p"),ka.innerHTML=Ll,jn=n(),Ca=p("p"),Ca.textContent=Pl,gn=n(),c(Za.$$.fragment),fn=n(),Ga=p("p"),Ga.innerHTML=Kl,Mn=n(),c(Xa.$$.fragment),yn=n(),c(va.$$.fragment),bn=n(),Ra=p("p"),Ra.innerHTML=Ol,wn=n(),Va=p("p"),Va.innerHTML=sp,Tn=n(),c(Ya.$$.fragment),Jn=n(),Na=p("p"),Na.innerHTML=ap,_n=n(),c(Fa.$$.fragment),Un=n(),c(U.$$.fragment),xn=n(),Ba=p("p"),Ba.innerHTML=ep,$n=n(),c(Qa.$$.fragment),In=n(),c(Wa.$$.fragment),kn=n(),qa=p("p"),qa.innerHTML=tp,Cn=n(),c(za.$$.fragment),Zn=n(),Ea=p("p"),Ea.innerHTML=np,Gn=n(),Ha=p("p"),Ha.innerHTML=lp,Xn=n(),c(Aa.$$.fragment),vn=n(),c(Sa.$$.fragment),Rn=n(),Da=p("p"),Da.innerHTML=pp,Vn=n(),La=p("p"),La.textContent=ip,Yn=n(),c(Pa.$$.fragment),Nn=n(),Ka=p("p"),Ka.innerHTML=rp,Fn=n(),c(Oa.$$.fragment),Bn=n(),c(x.$$.fragment),Qn=n(),c(se.$$.fragment),Wn=n(),ae=p("p"),ae.textContent=cp,qn=n(),ee=p("table"),ee.innerHTML=hp,zn=n(),te=p("p"),te.textContent=op,En=n(),c(ne.$$.fragment),Hn=n(),c(le.$$.fragment),An=n(),pe=p("p"),this.h()},l(s){const a=Jp("svelte-u9bgzb",document.head);j=i(a,"META",{name:!0,content:!0}),a.forEach(e),y=l(s),f=i(s,"P",{}),fp(f).forEach(e),b=l(s),h($.$$.fragment,s),ce=l(s),I=i(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-o0c0lx"&&(I.textContent=Dn),he=l(s),k=i(s,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1aff4p7"&&(k.textContent=Ln),oe=l(s),C=i(s,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-141dx8c"&&(C.innerHTML=Pn),me=l(s),Z=i(s,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1xlvt1h"&&(Z.innerHTML=Kn),de=l(s),G=i(s,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1bplt66"&&(G.textContent=On),ue=l(s),h(X.$$.fragment,s),je=l(s),h(T.$$.fragment,s),ge=l(s),h(v.$$.fragment,s),fe=l(s),R=i(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1bmil1o"&&(R.textContent=sl),Me=l(s),h(V.$$.fragment,s),ye=l(s),Y=i(s,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-ag0qiq"&&(Y.innerHTML=al),be=l(s),h(N.$$.fragment,s),we=l(s),F=i(s,"P",{"data-svelte-h":!0}),r(F)!=="svelte-50nyg6"&&(F.textContent=el),Te=l(s),h(B.$$.fragment,s),Je=l(s),Q=i(s,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-vbw0a5"&&(Q.innerHTML=tl),_e=l(s),h(W.$$.fragment,s),Ue=l(s),q=i(s,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1lyfhkv"&&(q.innerHTML=nl),xe=l(s),h(z.$$.fragment,s),$e=l(s),h(E.$$.fragment,s),Ie=l(s),H=i(s,"P",{"data-svelte-h":!0}),r(H)!=="svelte-n3f8rz"&&(H.innerHTML=ll),ke=l(s),A=i(s,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-t9ng2j"&&(A.innerHTML=pl),Ce=l(s),h(S.$$.fragment,s),Ze=l(s),D=i(s,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-1827bkp"&&(D.innerHTML=il),Ge=l(s),h(L.$$.fragment,s),Xe=l(s),P=i(s,"P",{"data-svelte-h":!0}),r(P)!=="svelte-18ahjmr"&&(P.innerHTML=rl),ve=l(s),h(K.$$.fragment,s),Re=l(s),O=i(s,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1y27i4k"&&(O.textContent=cl),Ve=l(s),h(ss.$$.fragment,s),Ye=l(s),as=i(s,"P",{"data-svelte-h":!0}),r(as)!=="svelte-unmvp8"&&(as.innerHTML=hl),Ne=l(s),h(es.$$.fragment,s),Fe=l(s),ts=i(s,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-kxs7ja"&&(ts.innerHTML=ol),Be=l(s),h(ns.$$.fragment,s),Qe=l(s),ls=i(s,"P",{"data-svelte-h":!0}),r(ls)!=="svelte-x1g7uv"&&(ls.innerHTML=ml),We=l(s),ps=i(s,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-1fijfvt"&&(ps.innerHTML=dl),qe=l(s),h(is.$$.fragment,s),ze=l(s),rs=i(s,"P",{"data-svelte-h":!0}),r(rs)!=="svelte-189aje2"&&(rs.textContent=ul),Ee=l(s),h(cs.$$.fragment,s),He=l(s),h(hs.$$.fragment,s),Ae=l(s),os=i(s,"P",{"data-svelte-h":!0}),r(os)!=="svelte-1vk4iy9"&&(os.textContent=jl),Se=l(s),h(ms.$$.fragment,s),De=l(s),ds=i(s,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-5s5ifk"&&(ds.innerHTML=gl),Le=l(s),us=i(s,"P",{"data-svelte-h":!0}),r(us)!=="svelte-lfsetp"&&(us.innerHTML=fl),Pe=l(s),h(js.$$.fragment,s),Ke=l(s),h(gs.$$.fragment,s),Oe=l(s),fs=i(s,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-1hfe112"&&(fs.innerHTML=Ml),st=l(s),h(Ms.$$.fragment,s),at=l(s),ys=i(s,"P",{"data-svelte-h":!0}),r(ys)!=="svelte-1i8hs8f"&&(ys.innerHTML=yl),et=l(s),h(bs.$$.fragment,s),tt=l(s),h(ws.$$.fragment,s),nt=l(s),Ts=i(s,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-s5tc36"&&(Ts.innerHTML=bl),lt=l(s),h(Js.$$.fragment,s),pt=l(s),h(J.$$.fragment,s),it=l(s),_s=i(s,"P",{"data-svelte-h":!0}),r(_s)!=="svelte-zxaexs"&&(_s.innerHTML=wl),rt=l(s),h(Us.$$.fragment,s),ct=l(s),h(xs.$$.fragment,s),ht=l(s),$s=i(s,"P",{"data-svelte-h":!0}),r($s)!=="svelte-68ctim"&&($s.textContent=Tl),ot=l(s),h(Is.$$.fragment,s),mt=l(s),ks=i(s,"P",{"data-svelte-h":!0}),r(ks)!=="svelte-stfr8g"&&(ks.innerHTML=Jl),dt=l(s),h(Cs.$$.fragment,s),ut=l(s),Zs=i(s,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-80t9a4"&&(Zs.innerHTML=_l),jt=l(s),h(Gs.$$.fragment,s),gt=l(s),Xs=i(s,"P",{"data-svelte-h":!0}),r(Xs)!=="svelte-n65eqq"&&(Xs.innerHTML=Ul),ft=l(s),vs=i(s,"P",{"data-svelte-h":!0}),r(vs)!=="svelte-1tkgss"&&(vs.innerHTML=xl),Mt=l(s),Rs=i(s,"P",{"data-svelte-h":!0}),r(Rs)!=="svelte-1t98b4r"&&(Rs.innerHTML=$l),yt=l(s),h(Vs.$$.fragment,s),bt=l(s),Ys=i(s,"P",{"data-svelte-h":!0}),r(Ys)!=="svelte-kdep9x"&&(Ys.innerHTML=Il),wt=l(s),h(Ns.$$.fragment,s),Tt=l(s),Fs=i(s,"P",{"data-svelte-h":!0}),r(Fs)!=="svelte-1nrgeq5"&&(Fs.innerHTML=kl),Jt=l(s),Bs=i(s,"P",{"data-svelte-h":!0}),r(Bs)!=="svelte-1ba84ir"&&(Bs.innerHTML=Cl),_t=l(s),h(Qs.$$.fragment,s),Ut=l(s),h(_.$$.fragment,s),xt=l(s),Ws=i(s,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-1i48cg9"&&(Ws.innerHTML=Zl),$t=l(s),h(qs.$$.fragment,s),It=l(s),h(zs.$$.fragment,s),kt=l(s),Es=i(s,"P",{"data-svelte-h":!0}),r(Es)!=="svelte-1hc5l3i"&&(Es.innerHTML=Gl),Ct=l(s),h(Hs.$$.fragment,s),Zt=l(s),As=i(s,"P",{"data-svelte-h":!0}),r(As)!=="svelte-1h2or5g"&&(As.innerHTML=Xl),Gt=l(s),h(Ss.$$.fragment,s),Xt=l(s),Ds=i(s,"P",{"data-svelte-h":!0}),r(Ds)!=="svelte-1k52pqi"&&(Ds.innerHTML=vl),vt=l(s),h(Ls.$$.fragment,s),Rt=l(s),h(Ps.$$.fragment,s),Vt=l(s),Ks=i(s,"P",{"data-svelte-h":!0}),r(Ks)!=="svelte-1nge001"&&(Ks.innerHTML=Rl),Yt=l(s),h(Os.$$.fragment,s),Nt=l(s),sa=i(s,"P",{"data-svelte-h":!0}),r(sa)!=="svelte-1k1qy5p"&&(sa.textContent=Vl),Ft=l(s),aa=i(s,"OL",{"data-svelte-h":!0}),r(aa)!=="svelte-75f7q"&&(aa.innerHTML=Yl),Bt=l(s),h(ea.$$.fragment,s),Qt=l(s),ta=i(s,"P",{"data-svelte-h":!0}),r(ta)!=="svelte-m6x4yj"&&(ta.innerHTML=Nl),Wt=l(s),h(na.$$.fragment,s),qt=l(s),la=i(s,"P",{"data-svelte-h":!0}),r(la)!=="svelte-cmzler"&&(la.textContent=Fl),zt=l(s),h(pa.$$.fragment,s),Et=l(s),h(ia.$$.fragment,s),Ht=l(s),ra=i(s,"P",{"data-svelte-h":!0}),r(ra)!=="svelte-g0bmvd"&&(ra.innerHTML=Bl),At=l(s),ca=i(s,"P",{"data-svelte-h":!0}),r(ca)!=="svelte-2g3b8l"&&(ca.innerHTML=Ql),St=l(s),h(ha.$$.fragment,s),Dt=l(s),oa=i(s,"P",{"data-svelte-h":!0}),r(oa)!=="svelte-17o5i9a"&&(oa.textContent=Wl),Lt=l(s),h(ma.$$.fragment,s),Pt=l(s),da=i(s,"P",{"data-svelte-h":!0}),r(da)!=="svelte-1irdf63"&&(da.innerHTML=ql),Kt=l(s),h(ua.$$.fragment,s),Ot=l(s),ja=i(s,"P",{"data-svelte-h":!0}),r(ja)!=="svelte-1ww14wc"&&(ja.innerHTML=zl),sn=l(s),h(ga.$$.fragment,s),an=l(s),fa=i(s,"P",{"data-svelte-h":!0}),r(fa)!=="svelte-knkewp"&&(fa.innerHTML=El),en=l(s),h(Ma.$$.fragment,s),tn=l(s),h(ya.$$.fragment,s),nn=l(s),ba=i(s,"P",{"data-svelte-h":!0}),r(ba)!=="svelte-4bfwrb"&&(ba.innerHTML=Hl),ln=l(s),wa=i(s,"P",{"data-svelte-h":!0}),r(wa)!=="svelte-1jo5sei"&&(wa.innerHTML=Al),pn=l(s),h(Ta.$$.fragment,s),rn=l(s),h(Ja.$$.fragment,s),cn=l(s),_a=i(s,"P",{"data-svelte-h":!0}),r(_a)!=="svelte-joqh9y"&&(_a.innerHTML=Sl),hn=l(s),h(Ua.$$.fragment,s),on=l(s),xa=i(s,"P",{"data-svelte-h":!0}),r(xa)!=="svelte-qilcw"&&(xa.innerHTML=Dl),mn=l(s),h($a.$$.fragment,s),dn=l(s),h(Ia.$$.fragment,s),un=l(s),ka=i(s,"P",{"data-svelte-h":!0}),r(ka)!=="svelte-1rmxkbj"&&(ka.innerHTML=Ll),jn=l(s),Ca=i(s,"P",{"data-svelte-h":!0}),r(Ca)!=="svelte-1k6sf3c"&&(Ca.textContent=Pl),gn=l(s),h(Za.$$.fragment,s),fn=l(s),Ga=i(s,"P",{"data-svelte-h":!0}),r(Ga)!=="svelte-13euv56"&&(Ga.innerHTML=Kl),Mn=l(s),h(Xa.$$.fragment,s),yn=l(s),h(va.$$.fragment,s),bn=l(s),Ra=i(s,"P",{"data-svelte-h":!0}),r(Ra)!=="svelte-1tgyehi"&&(Ra.innerHTML=Ol),wn=l(s),Va=i(s,"P",{"data-svelte-h":!0}),r(Va)!=="svelte-n6dynl"&&(Va.innerHTML=sp),Tn=l(s),h(Ya.$$.fragment,s),Jn=l(s),Na=i(s,"P",{"data-svelte-h":!0}),r(Na)!=="svelte-xif185"&&(Na.innerHTML=ap),_n=l(s),h(Fa.$$.fragment,s),Un=l(s),h(U.$$.fragment,s),xn=l(s),Ba=i(s,"P",{"data-svelte-h":!0}),r(Ba)!=="svelte-n8alwg"&&(Ba.innerHTML=ep),$n=l(s),h(Qa.$$.fragment,s),In=l(s),h(Wa.$$.fragment,s),kn=l(s),qa=i(s,"P",{"data-svelte-h":!0}),r(qa)!=="svelte-1x9i1zr"&&(qa.innerHTML=tp),Cn=l(s),h(za.$$.fragment,s),Zn=l(s),Ea=i(s,"P",{"data-svelte-h":!0}),r(Ea)!=="svelte-exxhh8"&&(Ea.innerHTML=np),Gn=l(s),Ha=i(s,"P",{"data-svelte-h":!0}),r(Ha)!=="svelte-14kj1ho"&&(Ha.innerHTML=lp),Xn=l(s),h(Aa.$$.fragment,s),vn=l(s),h(Sa.$$.fragment,s),Rn=l(s),Da=i(s,"P",{"data-svelte-h":!0}),r(Da)!=="svelte-1vgipse"&&(Da.innerHTML=pp),Vn=l(s),La=i(s,"P",{"data-svelte-h":!0}),r(La)!=="svelte-14rfihg"&&(La.textContent=ip),Yn=l(s),h(Pa.$$.fragment,s),Nn=l(s),Ka=i(s,"P",{"data-svelte-h":!0}),r(Ka)!=="svelte-1ykl8rs"&&(Ka.innerHTML=rp),Fn=l(s),h(Oa.$$.fragment,s),Bn=l(s),h(x.$$.fragment,s),Qn=l(s),h(se.$$.fragment,s),Wn=l(s),ae=i(s,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-t9rz5l"&&(ae.textContent=cp),qn=l(s),ee=i(s,"TABLE",{"data-svelte-h":!0}),r(ee)!=="svelte-kdk9wa"&&(ee.innerHTML=hp),zn=l(s),te=i(s,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1w51t97"&&(te.textContent=op),En=l(s),h(ne.$$.fragment,s),Hn=l(s),h(le.$$.fragment,s),An=l(s),pe=i(s,"P",{}),fp(pe).forEach(e),this.h()},h(){Mp(j,"name","hf:doc:metadata"),Mp(j,"content",Gp)},m(s,a){_p(document.head,j),t(s,y,a),t(s,f,a),t(s,b,a),o($,s,a),t(s,ce,a),t(s,I,a),t(s,he,a),t(s,k,a),t(s,oe,a),t(s,C,a),t(s,me,a),t(s,Z,a),t(s,de,a),t(s,G,a),t(s,ue,a),o(X,s,a),t(s,je,a),o(T,s,a),t(s,ge,a),o(v,s,a),t(s,fe,a),t(s,R,a),t(s,Me,a),o(V,s,a),t(s,ye,a),t(s,Y,a),t(s,be,a),o(N,s,a),t(s,we,a),t(s,F,a),t(s,Te,a),o(B,s,a),t(s,Je,a),t(s,Q,a),t(s,_e,a),o(W,s,a),t(s,Ue,a),t(s,q,a),t(s,xe,a),o(z,s,a),t(s,$e,a),o(E,s,a),t(s,Ie,a),t(s,H,a),t(s,ke,a),t(s,A,a),t(s,Ce,a),o(S,s,a),t(s,Ze,a),t(s,D,a),t(s,Ge,a),o(L,s,a),t(s,Xe,a),t(s,P,a),t(s,ve,a),o(K,s,a),t(s,Re,a),t(s,O,a),t(s,Ve,a),o(ss,s,a),t(s,Ye,a),t(s,as,a),t(s,Ne,a),o(es,s,a),t(s,Fe,a),t(s,ts,a),t(s,Be,a),o(ns,s,a),t(s,Qe,a),t(s,ls,a),t(s,We,a),t(s,ps,a),t(s,qe,a),o(is,s,a),t(s,ze,a),t(s,rs,a),t(s,Ee,a),o(cs,s,a),t(s,He,a),o(hs,s,a),t(s,Ae,a),t(s,os,a),t(s,Se,a),o(ms,s,a),t(s,De,a),t(s,ds,a),t(s,Le,a),t(s,us,a),t(s,Pe,a),o(js,s,a),t(s,Ke,a),o(gs,s,a),t(s,Oe,a),t(s,fs,a),t(s,st,a),o(Ms,s,a),t(s,at,a),t(s,ys,a),t(s,et,a),o(bs,s,a),t(s,tt,a),o(ws,s,a),t(s,nt,a),t(s,Ts,a),t(s,lt,a),o(Js,s,a),t(s,pt,a),o(J,s,a),t(s,it,a),t(s,_s,a),t(s,rt,a),o(Us,s,a),t(s,ct,a),o(xs,s,a),t(s,ht,a),t(s,$s,a),t(s,ot,a),o(Is,s,a),t(s,mt,a),t(s,ks,a),t(s,dt,a),o(Cs,s,a),t(s,ut,a),t(s,Zs,a),t(s,jt,a),o(Gs,s,a),t(s,gt,a),t(s,Xs,a),t(s,ft,a),t(s,vs,a),t(s,Mt,a),t(s,Rs,a),t(s,yt,a),o(Vs,s,a),t(s,bt,a),t(s,Ys,a),t(s,wt,a),o(Ns,s,a),t(s,Tt,a),t(s,Fs,a),t(s,Jt,a),t(s,Bs,a),t(s,_t,a),o(Qs,s,a),t(s,Ut,a),o(_,s,a),t(s,xt,a),t(s,Ws,a),t(s,$t,a),o(qs,s,a),t(s,It,a),o(zs,s,a),t(s,kt,a),t(s,Es,a),t(s,Ct,a),o(Hs,s,a),t(s,Zt,a),t(s,As,a),t(s,Gt,a),o(Ss,s,a),t(s,Xt,a),t(s,Ds,a),t(s,vt,a),o(Ls,s,a),t(s,Rt,a),o(Ps,s,a),t(s,Vt,a),t(s,Ks,a),t(s,Yt,a),o(Os,s,a),t(s,Nt,a),t(s,sa,a),t(s,Ft,a),t(s,aa,a),t(s,Bt,a),o(ea,s,a),t(s,Qt,a),t(s,ta,a),t(s,Wt,a),o(na,s,a),t(s,qt,a),t(s,la,a),t(s,zt,a),o(pa,s,a),t(s,Et,a),o(ia,s,a),t(s,Ht,a),t(s,ra,a),t(s,At,a),t(s,ca,a),t(s,St,a),o(ha,s,a),t(s,Dt,a),t(s,oa,a),t(s,Lt,a),o(ma,s,a),t(s,Pt,a),t(s,da,a),t(s,Kt,a),o(ua,s,a),t(s,Ot,a),t(s,ja,a),t(s,sn,a),o(ga,s,a),t(s,an,a),t(s,fa,a),t(s,en,a),o(Ma,s,a),t(s,tn,a),o(ya,s,a),t(s,nn,a),t(s,ba,a),t(s,ln,a),t(s,wa,a),t(s,pn,a),o(Ta,s,a),t(s,rn,a),o(Ja,s,a),t(s,cn,a),t(s,_a,a),t(s,hn,a),o(Ua,s,a),t(s,on,a),t(s,xa,a),t(s,mn,a),o($a,s,a),t(s,dn,a),o(Ia,s,a),t(s,un,a),t(s,ka,a),t(s,jn,a),t(s,Ca,a),t(s,gn,a),o(Za,s,a),t(s,fn,a),t(s,Ga,a),t(s,Mn,a),o(Xa,s,a),t(s,yn,a),o(va,s,a),t(s,bn,a),t(s,Ra,a),t(s,wn,a),t(s,Va,a),t(s,Tn,a),o(Ya,s,a),t(s,Jn,a),t(s,Na,a),t(s,_n,a),o(Fa,s,a),t(s,Un,a),o(U,s,a),t(s,xn,a),t(s,Ba,a),t(s,$n,a),o(Qa,s,a),t(s,In,a),o(Wa,s,a),t(s,kn,a),t(s,qa,a),t(s,Cn,a),o(za,s,a),t(s,Zn,a),t(s,Ea,a),t(s,Gn,a),t(s,Ha,a),t(s,Xn,a),o(Aa,s,a),t(s,vn,a),o(Sa,s,a),t(s,Rn,a),t(s,Da,a),t(s,Vn,a),t(s,La,a),t(s,Yn,a),o(Pa,s,a),t(s,Nn,a),t(s,Ka,a),t(s,Fn,a),o(Oa,s,a),t(s,Bn,a),o(x,s,a),t(s,Qn,a),o(se,s,a),t(s,Wn,a),t(s,ae,a),t(s,qn,a),t(s,ee,a),t(s,zn,a),t(s,te,a),t(s,En,a),o(ne,s,a),t(s,Hn,a),o(le,s,a),t(s,An,a),t(s,pe,a),Sn=!0},p(s,[a]){const mp={};a&2&&(mp.$$scope={dirty:a,ctx:s}),T.$set(mp);const dp={};a&2&&(dp.$$scope={dirty:a,ctx:s}),J.$set(dp);const up={};a&2&&(up.$$scope={dirty:a,ctx:s}),_.$set(up);const jp={};a&2&&(jp.$$scope={dirty:a,ctx:s}),U.$set(jp);const gp={};a&2&&(gp.$$scope={dirty:a,ctx:s}),x.$set(gp)},i(s){Sn||(m($.$$.fragment,s),m(X.$$.fragment,s),m(T.$$.fragment,s),m(v.$$.fragment,s),m(V.$$.fragment,s),m(N.$$.fragment,s),m(B.$$.fragment,s),m(W.$$.fragment,s),m(z.$$.fragment,s),m(E.$$.fragment,s),m(S.$$.fragment,s),m(L.$$.fragment,s),m(K.$$.fragment,s),m(ss.$$.fragment,s),m(es.$$.fragment,s),m(ns.$$.fragment,s),m(is.$$.fragment,s),m(cs.$$.fragment,s),m(hs.$$.fragment,s),m(ms.$$.fragment,s),m(js.$$.fragment,s),m(gs.$$.fragment,s),m(Ms.$$.fragment,s),m(bs.$$.fragment,s),m(ws.$$.fragment,s),m(Js.$$.fragment,s),m(J.$$.fragment,s),m(Us.$$.fragment,s),m(xs.$$.fragment,s),m(Is.$$.fragment,s),m(Cs.$$.fragment,s),m(Gs.$$.fragment,s),m(Vs.$$.fragment,s),m(Ns.$$.fragment,s),m(Qs.$$.fragment,s),m(_.$$.fragment,s),m(qs.$$.fragment,s),m(zs.$$.fragment,s),m(Hs.$$.fragment,s),m(Ss.$$.fragment,s),m(Ls.$$.fragment,s),m(Ps.$$.fragment,s),m(Os.$$.fragment,s),m(ea.$$.fragment,s),m(na.$$.fragment,s),m(pa.$$.fragment,s),m(ia.$$.fragment,s),m(ha.$$.fragment,s),m(ma.$$.fragment,s),m(ua.$$.fragment,s),m(ga.$$.fragment,s),m(Ma.$$.fragment,s),m(ya.$$.fragment,s),m(Ta.$$.fragment,s),m(Ja.$$.fragment,s),m(Ua.$$.fragment,s),m($a.$$.fragment,s),m(Ia.$$.fragment,s),m(Za.$$.fragment,s),m(Xa.$$.fragment,s),m(va.$$.fragment,s),m(Ya.$$.fragment,s),m(Fa.$$.fragment,s),m(U.$$.fragment,s),m(Qa.$$.fragment,s),m(Wa.$$.fragment,s),m(za.$$.fragment,s),m(Aa.$$.fragment,s),m(Sa.$$.fragment,s),m(Pa.$$.fragment,s),m(Oa.$$.fragment,s),m(x.$$.fragment,s),m(se.$$.fragment,s),m(ne.$$.fragment,s),m(le.$$.fragment,s),Sn=!0)},o(s){d($.$$.fragment,s),d(X.$$.fragment,s),d(T.$$.fragment,s),d(v.$$.fragment,s),d(V.$$.fragment,s),d(N.$$.fragment,s),d(B.$$.fragment,s),d(W.$$.fragment,s),d(z.$$.fragment,s),d(E.$$.fragment,s),d(S.$$.fragment,s),d(L.$$.fragment,s),d(K.$$.fragment,s),d(ss.$$.fragment,s),d(es.$$.fragment,s),d(ns.$$.fragment,s),d(is.$$.fragment,s),d(cs.$$.fragment,s),d(hs.$$.fragment,s),d(ms.$$.fragment,s),d(js.$$.fragment,s),d(gs.$$.fragment,s),d(Ms.$$.fragment,s),d(bs.$$.fragment,s),d(ws.$$.fragment,s),d(Js.$$.fragment,s),d(J.$$.fragment,s),d(Us.$$.fragment,s),d(xs.$$.fragment,s),d(Is.$$.fragment,s),d(Cs.$$.fragment,s),d(Gs.$$.fragment,s),d(Vs.$$.fragment,s),d(Ns.$$.fragment,s),d(Qs.$$.fragment,s),d(_.$$.fragment,s),d(qs.$$.fragment,s),d(zs.$$.fragment,s),d(Hs.$$.fragment,s),d(Ss.$$.fragment,s),d(Ls.$$.fragment,s),d(Ps.$$.fragment,s),d(Os.$$.fragment,s),d(ea.$$.fragment,s),d(na.$$.fragment,s),d(pa.$$.fragment,s),d(ia.$$.fragment,s),d(ha.$$.fragment,s),d(ma.$$.fragment,s),d(ua.$$.fragment,s),d(ga.$$.fragment,s),d(Ma.$$.fragment,s),d(ya.$$.fragment,s),d(Ta.$$.fragment,s),d(Ja.$$.fragment,s),d(Ua.$$.fragment,s),d($a.$$.fragment,s),d(Ia.$$.fragment,s),d(Za.$$.fragment,s),d(Xa.$$.fragment,s),d(va.$$.fragment,s),d(Ya.$$.fragment,s),d(Fa.$$.fragment,s),d(U.$$.fragment,s),d(Qa.$$.fragment,s),d(Wa.$$.fragment,s),d(za.$$.fragment,s),d(Aa.$$.fragment,s),d(Sa.$$.fragment,s),d(Pa.$$.fragment,s),d(Oa.$$.fragment,s),d(x.$$.fragment,s),d(se.$$.fragment,s),d(ne.$$.fragment,s),d(le.$$.fragment,s),Sn=!1},d(s){s&&(e(y),e(f),e(b),e(ce),e(I),e(he),e(k),e(oe),e(C),e(me),e(Z),e(de),e(G),e(ue),e(je),e(ge),e(fe),e(R),e(Me),e(ye),e(Y),e(be),e(we),e(F),e(Te),e(Je),e(Q),e(_e),e(Ue),e(q),e(xe),e($e),e(Ie),e(H),e(ke),e(A),e(Ce),e(Ze),e(D),e(Ge),e(Xe),e(P),e(ve),e(Re),e(O),e(Ve),e(Ye),e(as),e(Ne),e(Fe),e(ts),e(Be),e(Qe),e(ls),e(We),e(ps),e(qe),e(ze),e(rs),e(Ee),e(He),e(Ae),e(os),e(Se),e(De),e(ds),e(Le),e(us),e(Pe),e(Ke),e(Oe),e(fs),e(st),e(at),e(ys),e(et),e(tt),e(nt),e(Ts),e(lt),e(pt),e(it),e(_s),e(rt),e(ct),e(ht),e($s),e(ot),e(mt),e(ks),e(dt),e(ut),e(Zs),e(jt),e(gt),e(Xs),e(ft),e(vs),e(Mt),e(Rs),e(yt),e(bt),e(Ys),e(wt),e(Tt),e(Fs),e(Jt),e(Bs),e(_t),e(Ut),e(xt),e(Ws),e($t),e(It),e(kt),e(Es),e(Ct),e(Zt),e(As),e(Gt),e(Xt),e(Ds),e(vt),e(Rt),e(Vt),e(Ks),e(Yt),e(Nt),e(sa),e(Ft),e(aa),e(Bt),e(Qt),e(ta),e(Wt),e(qt),e(la),e(zt),e(Et),e(Ht),e(ra),e(At),e(ca),e(St),e(Dt),e(oa),e(Lt),e(Pt),e(da),e(Kt),e(Ot),e(ja),e(sn),e(an),e(fa),e(en),e(tn),e(nn),e(ba),e(ln),e(wa),e(pn),e(rn),e(cn),e(_a),e(hn),e(on),e(xa),e(mn),e(dn),e(un),e(ka),e(jn),e(Ca),e(gn),e(fn),e(Ga),e(Mn),e(yn),e(bn),e(Ra),e(wn),e(Va),e(Tn),e(Jn),e(Na),e(_n),e(Un),e(xn),e(Ba),e($n),e(In),e(kn),e(qa),e(Cn),e(Zn),e(Ea),e(Gn),e(Ha),e(Xn),e(vn),e(Rn),e(Da),e(Vn),e(La),e(Yn),e(Nn),e(Ka),e(Fn),e(Bn),e(Qn),e(Wn),e(ae),e(qn),e(ee),e(zn),e(te),e(En),e(Hn),e(An),e(pe)),e(j),u($,s),u(X,s),u(T,s),u(v,s),u(V,s),u(N,s),u(B,s),u(W,s),u(z,s),u(E,s),u(S,s),u(L,s),u(K,s),u(ss,s),u(es,s),u(ns,s),u(is,s),u(cs,s),u(hs,s),u(ms,s),u(js,s),u(gs,s),u(Ms,s),u(bs,s),u(ws,s),u(Js,s),u(J,s),u(Us,s),u(xs,s),u(Is,s),u(Cs,s),u(Gs,s),u(Vs,s),u(Ns,s),u(Qs,s),u(_,s),u(qs,s),u(zs,s),u(Hs,s),u(Ss,s),u(Ls,s),u(Ps,s),u(Os,s),u(ea,s),u(na,s),u(pa,s),u(ia,s),u(ha,s),u(ma,s),u(ua,s),u(ga,s),u(Ma,s),u(ya,s),u(Ta,s),u(Ja,s),u(Ua,s),u($a,s),u(Ia,s),u(Za,s),u(Xa,s),u(va,s),u(Ya,s),u(Fa,s),u(U,s),u(Qa,s),u(Wa,s),u(za,s),u(Aa,s),u(Sa,s),u(Pa,s),u(Oa,s),u(x,s),u(se,s),u(ne,s),u(le,s)}}}const Gp='{"title":"Process","local":"process","sections":[{"title":"Sort, shuffle, select, split, and shard","local":"sort-shuffle-select-split-and-shard","sections":[{"title":"Sort","local":"sort","sections":[],"depth":3},{"title":"Shuffle","local":"shuffle","sections":[],"depth":3},{"title":"Select and Filter","local":"select-and-filter","sections":[],"depth":3},{"title":"Split","local":"split","sections":[],"depth":3},{"title":"Shard","local":"shard","sections":[],"depth":3}],"depth":2},{"title":"Rename, remove, cast, and flatten","local":"rename-remove-cast-and-flatten","sections":[{"title":"Rename","local":"rename","sections":[],"depth":3},{"title":"Remove","local":"remove","sections":[],"depth":3},{"title":"Cast","local":"cast","sections":[],"depth":3},{"title":"Flatten","local":"flatten","sections":[],"depth":3}],"depth":2},{"title":"Map","local":"map","sections":[{"title":"Multiprocessing","local":"multiprocessing","sections":[],"depth":3},{"title":"Batch processing","local":"batch-processing","sections":[{"title":"Split long examples","local":"split-long-examples","sections":[],"depth":4},{"title":"Data augmentation","local":"data-augmentation","sections":[],"depth":4}],"depth":3},{"title":"Process multiple splits","local":"process-multiple-splits","sections":[],"depth":3},{"title":"Distributed usage","local":"distributed-usage","sections":[],"depth":3}],"depth":2},{"title":"Concatenate","local":"concatenate","sections":[{"title":"Interleave","local":"interleave","sections":[],"depth":3}],"depth":2},{"title":"Format","local":"format","sections":[{"title":"Format transform","local":"format-transform","sections":[],"depth":3}],"depth":2},{"title":"Save","local":"save","sections":[],"depth":2},{"title":"Export","local":"export","sections":[],"depth":2}],"depth":1}';function Xp(w){return bp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fp extends wp{constructor(j){super(),Tp(this,j,Xp,Zp,yp,{})}}export{Fp as component};
