import{s as ns,o as rs,n as S}from"../chunks/scheduler.bdbef820.js";import{S as ds,i as ls,g as i,s as n,r as m,A as is,h as c,f as a,c as r,j as N,u as g,x,k as C,y as p,a as s,v as f,d as u,t as h,w as _}from"../chunks/index.c0aea24a.js";import{D as O}from"../chunks/Docstring.20f7ed2e.js";import{C as R}from"../chunks/CodeBlock.6ccca92e.js";import{E as G}from"../chunks/ExampleCodeBlock.da027134.js";import{H as U,E as cs}from"../chunks/EditOnGithub.725ee0c1.js";function ps(D){let d,k="Example:",b,l,v;return l=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbGlzdF9kYXRhc2V0cyUwQWxpc3RfZGF0YXNldHMoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> list_datasets
<span class="hljs-meta">&gt;&gt;&gt; </span>list_datasets()
[<span class="hljs-string">&#x27;acronym_identification&#x27;</span>,
 <span class="hljs-string">&#x27;ade_corpus_v2&#x27;</span>,
 <span class="hljs-string">&#x27;adversarial_qa&#x27;</span>,
 <span class="hljs-string">&#x27;aeslc&#x27;</span>,
 <span class="hljs-string">&#x27;afrikaans_ner_corpus&#x27;</span>,
 <span class="hljs-string">&#x27;ag_news&#x27;</span>,
 ...
]`,wrap:!1}}),{c(){d=i("p"),d.textContent=k,b=n(),m(l.$$.fragment)},l(t){d=c(t,"P",{"data-svelte-h":!0}),x(d)!=="svelte-11lpom8"&&(d.textContent=k),b=r(t),g(l.$$.fragment,t)},m(t,$){s(t,d,$),s(t,b,$),f(l,t,$),v=!0},p:S,i(t){v||(u(l.$$.fragment,t),v=!0)},o(t){h(l.$$.fragment,t),v=!1},d(t){t&&(a(d),a(b)),_(l,t)}}}function ms(D){let d,k="Load a dataset from the Hugging Face Hub:",b,l,v;return l=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJ3JvdHRlbl90b21hdG9lcyclMkMlMjBzcGxpdCUzRCd0cmFpbicpJTBBJTBBZGF0YV9maWxlcyUyMCUzRCUyMCU3Qid0cmFpbiclM0ElMjAndHJhaW4uY3N2JyUyQyUyMCd0ZXN0JyUzQSUyMCd0ZXN0LmNzdiclN0QlMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCgnbmFtZXNwYWNlJTJGeW91cl9kYXRhc2V0X25hbWUnJTJDJTIwZGF0YV9maWxlcyUzRGRhdGFfZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)

<span class="hljs-comment"># Map data files to splits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>data_files = {<span class="hljs-string">&#x27;train&#x27;</span>: <span class="hljs-string">&#x27;train.csv&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>: <span class="hljs-string">&#x27;test.csv&#x27;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&#x27;namespace/your_dataset_name&#x27;</span>, data_files=data_files)`,wrap:!1}}),{c(){d=i("p"),d.textContent=k,b=n(),m(l.$$.fragment)},l(t){d=c(t,"P",{"data-svelte-h":!0}),x(d)!=="svelte-cpjyx5"&&(d.textContent=k),b=r(t),g(l.$$.fragment,t)},m(t,$){s(t,d,$),s(t,b,$),f(l,t,$),v=!0},p:S,i(t){v||(u(l.$$.fragment,t),v=!0)},o(t){h(l.$$.fragment,t),v=!1},d(t){t&&(a(d),a(b)),_(l,t)}}}function gs(D){let d,k="Load a local dataset:",b,l,v;return l=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJ2NzdiclMkMlMjBkYXRhX2ZpbGVzJTNEJ3BhdGglMkZ0byUyRmxvY2FsJTJGbXlfZGF0YXNldC5jc3YnKSUwQSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCdqc29uJyUyQyUyMGRhdGFfZmlsZXMlM0QncGF0aCUyRnRvJTJGbG9jYWwlMkZteV9kYXRhc2V0Lmpzb24nKSUwQSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCdwYXRoJTJGdG8lMkZsb2NhbCUyRmxvYWRpbmdfc2NyaXB0JTJGbG9hZGluZ19zY3JpcHQucHknJTJDJTIwc3BsaXQlM0QndHJhaW4nKQ==",highlighted:`<span class="hljs-comment"># Load a CSV file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&#x27;csv&#x27;</span>, data_files=<span class="hljs-string">&#x27;path/to/local/my_dataset.csv&#x27;</span>)

<span class="hljs-comment"># Load a JSON file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&#x27;json&#x27;</span>, data_files=<span class="hljs-string">&#x27;path/to/local/my_dataset.json&#x27;</span>)

<span class="hljs-comment"># Load from a local loading script</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&#x27;path/to/local/loading_script/loading_script.py&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=k,b=n(),m(l.$$.fragment)},l(t){d=c(t,"P",{"data-svelte-h":!0}),x(d)!=="svelte-18tmtyu"&&(d.textContent=k),b=r(t),g(l.$$.fragment,t)},m(t,$){s(t,d,$),s(t,b,$),f(l,t,$),v=!0},p:S,i(t){v||(u(l.$$.fragment,t),v=!0)},o(t){h(l.$$.fragment,t),v=!1},d(t){t&&(a(d),a(b)),_(l,t)}}}function fs(D){let d,k='Load an <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',b,l,v;return l=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJ3JvdHRlbl90b21hdG9lcyclMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){d=i("p"),d.innerHTML=k,b=n(),m(l.$$.fragment)},l(t){d=c(t,"P",{"data-svelte-h":!0}),x(d)!=="svelte-17kp12g"&&(d.innerHTML=k),b=r(t),g(l.$$.fragment,t)},m(t,$){s(t,d,$),s(t,b,$),f(l,t,$),v=!0},p:S,i(t){v||(u(l.$$.fragment,t),v=!0)},o(t){h(l.$$.fragment,t),v=!1},d(t){t&&(a(d),a(b)),_(l,t)}}}function us(D){let d,k="Load an image dataset with the <code>ImageFolder</code> dataset builder:",b,l,v;return l=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJ2ltYWdlZm9sZGVyJyUyQyUyMGRhdGFfZGlyJTNEJyUyRnBhdGglMkZ0byUyRmltYWdlcyclMkMlMjBzcGxpdCUzRCd0cmFpbicp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&#x27;imagefolder&#x27;</span>, data_dir=<span class="hljs-string">&#x27;/path/to/images&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)`,wrap:!1}}),{c(){d=i("p"),d.innerHTML=k,b=n(),m(l.$$.fragment)},l(t){d=c(t,"P",{"data-svelte-h":!0}),x(d)!=="svelte-9alpt2"&&(d.innerHTML=k),b=r(t),g(l.$$.fragment,t)},m(t,$){s(t,d,$),s(t,b,$),f(l,t,$),v=!0},p:S,i(t){v||(u(l.$$.fragment,t),v=!0)},o(t){h(l.$$.fragment,t),v=!1},d(t){t&&(a(d),a(b)),_(l,t)}}}function hs(D){let d,k="Example:",b,l,v;return l=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9mcm9tX2Rpc2slMEFkcyUyMCUzRCUyMGxvYWRfZnJvbV9kaXNrKCdwYXRoJTJGdG8lMkZkYXRhc2V0JTJGZGlyZWN0b3J5Jyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_from_disk
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_from_disk(<span class="hljs-string">&#x27;path/to/dataset/directory&#x27;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=k,b=n(),m(l.$$.fragment)},l(t){d=c(t,"P",{"data-svelte-h":!0}),x(d)!=="svelte-11lpom8"&&(d.textContent=k),b=r(t),g(l.$$.fragment,t)},m(t,$){s(t,d,$),s(t,b,$),f(l,t,$),v=!0},p:S,i(t){v||(u(l.$$.fragment,t),v=!0)},o(t){h(l.$$.fragment,t),v=!1},d(t){t&&(a(d),a(b)),_(l,t)}}}function _s(D){let d,k="Example:",b,l,v;return l=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFkc19idWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJ3JvdHRlbl90b21hdG9lcycpJTBBZHNfYnVpbGRlci5pbmZvLmZlYXR1cmVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder = load_dataset_builder(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder.info.features
{<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;neg&#x27;</span>, <span class="hljs-string">&#x27;pos&#x27;</span>], <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;text&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),{c(){d=i("p"),d.textContent=k,b=n(),m(l.$$.fragment)},l(t){d=c(t,"P",{"data-svelte-h":!0}),x(d)!=="svelte-11lpom8"&&(d.textContent=k),b=r(t),g(l.$$.fragment,t)},m(t,$){s(t,d,$),s(t,b,$),f(l,t,$),v=!0},p:S,i(t){v||(u(l.$$.fragment,t),v=!0)},o(t){h(l.$$.fragment,t),v=!1},d(t){t&&(a(d),a(b)),_(l,t)}}}function vs(D){let d,k="Example:",b,l,v;return l=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwZ2V0X2RhdGFzZXRfY29uZmlnX25hbWVzJTBBZ2V0X2RhdGFzZXRfY29uZmlnX25hbWVzKCUyMmdsdWUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> get_dataset_config_names
<span class="hljs-meta">&gt;&gt;&gt; </span>get_dataset_config_names(<span class="hljs-string">&quot;glue&quot;</span>)
[<span class="hljs-string">&#x27;cola&#x27;</span>,
 <span class="hljs-string">&#x27;sst2&#x27;</span>,
 <span class="hljs-string">&#x27;mrpc&#x27;</span>,
 <span class="hljs-string">&#x27;qqp&#x27;</span>,
 <span class="hljs-string">&#x27;stsb&#x27;</span>,
 <span class="hljs-string">&#x27;mnli&#x27;</span>,
 <span class="hljs-string">&#x27;mnli_mismatched&#x27;</span>,
 <span class="hljs-string">&#x27;mnli_matched&#x27;</span>,
 <span class="hljs-string">&#x27;qnli&#x27;</span>,
 <span class="hljs-string">&#x27;rte&#x27;</span>,
 <span class="hljs-string">&#x27;wnli&#x27;</span>,
 <span class="hljs-string">&#x27;ax&#x27;</span>]`,wrap:!1}}),{c(){d=i("p"),d.textContent=k,b=n(),m(l.$$.fragment)},l(t){d=c(t,"P",{"data-svelte-h":!0}),x(d)!=="svelte-11lpom8"&&(d.textContent=k),b=r(t),g(l.$$.fragment,t)},m(t,$){s(t,d,$),s(t,b,$),f(l,t,$),v=!0},p:S,i(t){v||(u(l.$$.fragment,t),v=!0)},o(t){h(l.$$.fragment,t),v=!1},d(t){t&&(a(d),a(b)),_(l,t)}}}function bs(D){let d,k="Example:",b,l,v;return l=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwZ2V0X2RhdGFzZXRfaW5mb3MlMEFnZXRfZGF0YXNldF9pbmZvcygncm90dGVuX3RvbWF0b2VzJyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> get_dataset_infos
<span class="hljs-meta">&gt;&gt;&gt; </span>get_dataset_infos(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
{<span class="hljs-string">&#x27;default&#x27;</span>: DatasetInfo(description=<span class="hljs-string">&quot;Movie Review Dataset.
 is a dataset of containing 5,331 positive and 5,331 negative processed
ences from Rotten Tomatoes movie reviews...), ...}</span>`,wrap:!1}}),{c(){d=i("p"),d.textContent=k,b=n(),m(l.$$.fragment)},l(t){d=c(t,"P",{"data-svelte-h":!0}),x(d)!=="svelte-11lpom8"&&(d.textContent=k),b=r(t),g(l.$$.fragment,t)},m(t,$){s(t,d,$),s(t,b,$),f(l,t,$),v=!0},p:S,i(t){v||(u(l.$$.fragment,t),v=!0)},o(t){h(l.$$.fragment,t),v=!1},d(t){t&&(a(d),a(b)),_(l,t)}}}function $s(D){let d,k="Example:",b,l,v;return l=new R({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwZ2V0X2RhdGFzZXRfc3BsaXRfbmFtZXMlMEFnZXRfZGF0YXNldF9zcGxpdF9uYW1lcygncm90dGVuX3RvbWF0b2VzJyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> get_dataset_split_names
<span class="hljs-meta">&gt;&gt;&gt; </span>get_dataset_split_names(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
[<span class="hljs-string">&#x27;train&#x27;</span>, <span class="hljs-string">&#x27;validation&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>]`,wrap:!1}}),{c(){d=i("p"),d.textContent=k,b=n(),m(l.$$.fragment)},l(t){d=c(t,"P",{"data-svelte-h":!0}),x(d)!=="svelte-11lpom8"&&(d.textContent=k),b=r(t),g(l.$$.fragment,t)},m(t,$){s(t,d,$),s(t,b,$),f(l,t,$),v=!0},p:S,i(t){v||(u(l.$$.fragment,t),v=!0)},o(t){h(l.$$.fragment,t),v=!1},d(t){t&&(a(d),a(b)),_(l,t)}}}function xs(D){let d,k,b,l,v,t,$,bo="Methods for listing and loading datasets:",Gt,ce,St,F,pe,qa,lt,$o="List all the datasets scripts available on the Hugging Face Hub.",Ia,ee,Zt,w,me,Ja,it,xo="Load a dataset from the Hugging Face Hub, or a local dataset.",Ra,ct,ko='You can find the list of datasets on the <a href="https://huggingface.co/datasets" rel="nofollow">Hub</a> or with <code>huggingface_hub.list_datasets</code>.',Ga,pt,wo="A dataset is a directory that contains:",Sa,mt,yo="<li>some data files in generic formats (JSON, CSV, Parquet, text, etc.).</li> <li>and optionally a dataset script, if it requires some code to read the data files. This is used to load any kind of formats or structures.</li>",Za,gt,No="Note that dataset scripts can also download and read data files from anywhere - in case your data files already exist online.",Ha,ft,Co="This function does the following under the hood:",za,ut,Oo=`<li><p>Download and import in the library the dataset script from <code>path</code> if it’s not already cached inside the library.</p> <p>If the dataset has no dataset script, then a generic dataset script is imported instead (JSON, CSV, Parquet, text, etc.)</p> <p>Dataset scripts are small python scripts that define dataset builders. They define the citation, info and format of the dataset,
contain the path or URL to the original data files and the code to load examples from the original data files.</p> <p>You can find the complete list of datasets in the Datasets <a href="https://huggingface.co/datasets" rel="nofollow">Hub</a>.</p></li> <li><p>Run the dataset script which will:</p> <ul><li><p>Download the dataset file from the original URL (see the script) if it’s not already available locally or cached.</p></li> <li><p>Process and cache the dataset in typed Arrow tables for caching.</p> <p>Arrow table are arbitrarily long, typed tables which can store nested objects and be mapped to numpy/pandas/python generic types.
They can be directly accessed from disk, loaded in RAM or even streamed over the web.</p></li></ul></li> <li><p>Return a dataset built from the requested splits in <code>split</code> (default: all).</p></li>`,Va,ht,Do=`It also allows to load a dataset from a local directory or a dataset repository on the Hugging Face Hub without dataset script.
In this case, it automatically loads all the data files from the directory or the dataset repository.`,Xa,_t,jo="Example:",Ea,te,La,ae,Pa,oe,Aa,se,Ht,M,ge,Ba,vt,To=`Loads a dataset that was previously saved using <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset.save_to_disk">save_to_disk()</a> from a dataset directory, or
from a filesystem using any implementation of <code>fsspec.spec.AbstractFileSystem</code>.`,Ya,ne,zt,j,fe,Wa,bt,Uo=`Load a dataset builder from the Hugging Face Hub, or a local dataset. A dataset builder can be used to inspect general information that is required to build a dataset (cache directory, config, dataset info, etc.)
without downloading the dataset itself.`,Qa,$t,Fo='You can find the list of datasets on the <a href="https://huggingface.co/datasets" rel="nofollow">Hub</a> or with <code>huggingface_hub.list_datasets</code>.',Ka,xt,Mo="A dataset is a directory that contains:",eo,kt,qo="<li>some data files in generic formats (JSON, CSV, Parquet, text, etc.)</li> <li>and optionally a dataset script, if it requires some code to read the data files. This is used to load any kind of formats or structures.</li>",to,wt,Io="Note that dataset scripts can also download and read data files from anywhere - in case your data files already exist online.",ao,re,Vt,q,ue,oo,yt,Jo="Get the list of available config names for a particular dataset.",so,de,Xt,I,he,no,Nt,Ro="Get the meta information about a dataset, returned as a dict mapping config name to DatasetInfoDict.",ro,le,Et,J,_e,lo,Ct,Go="Get the list of available splits for a particular config and dataset.",io,ie,Lt,Z,ve,co,Ot,So="Allow inspection/modification of a dataset script by copying on local drive at local_path.",Pt,be,At,$e,Zo=`Configurations used to load data files.
They are used when loading local files or a dataset repository:`,Bt,xe,Ho="<li>local files: <code>load_dataset(&quot;parquet&quot;, data_dir=&quot;path/to/data/dir&quot;)</code></li> <li>dataset repository: <code>load_dataset(&quot;allenai/c4&quot;)</code></li>",Yt,ke,zo=`You can pass arguments to <code>load_dataset</code> to configure data loading.
For example you can specify the <code>sep</code> parameter to define the <a href="/docs/datasets/pr_7043/en/package_reference/loading_methods#datasets.packaged_modules.csv.CsvConfig">CsvConfig</a> that is used to load the data:`,Wt,we,Qt,ye,Kt,H,Ne,po,Dt,Vo="BuilderConfig for text files.",ea,Ce,Oe,ta,De,aa,z,je,mo,jt,Xo="BuilderConfig for CSV.",oa,Te,Ue,sa,Fe,na,V,Me,go,Tt,Eo="BuilderConfig for JSON.",ra,qe,Ie,da,Je,la,X,Re,fo,Ut,Lo="BuilderConfig for Parquet.",ia,Ge,Se,ca,Ze,pa,E,He,uo,Ft,Po="BuilderConfig for Arrow.",ma,ze,Ve,ga,Xe,fa,L,Ee,ho,Mt,Ao="BuilderConfig for SQL.",ua,Le,Pe,ha,Ae,_a,P,Be,_o,qt,Bo="BuilderConfig for ImageFolder.",va,Ye,We,ba,Qe,$a,A,Ke,vo,It,Yo="Builder Config for AudioFolder.",xa,et,tt,ka,at,wa,ot,st,ya,nt,Na,Jt,Ca;return v=new U({props:{title:"Loading methods",local:"loading-methods",headingTag:"h1"}}),ce=new U({props:{title:"Datasets",local:"datasets.list_datasets",headingTag:"h2"}}),pe=new O({props:{name:"datasets.list_datasets",anchor:"datasets.list_datasets",parameters:[{name:"with_community_datasets",val:" = True"},{name:"with_details",val:" = False"}],parametersDescription:[{anchor:"datasets.list_datasets.with_community_datasets",description:`<strong>with_community_datasets</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Include the community provided datasets.`,name:"with_community_datasets"},{anchor:"datasets.list_datasets.with_details",description:`<strong>with_details</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Return the full details on the datasets instead of only the short name.`,name:"with_details"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/inspect.py#L48"}}),ee=new G({props:{anchor:"datasets.list_datasets.example",$$slots:{default:[ps]},$$scope:{ctx:D}}}),me=new O({props:{name:"datasets.load_dataset",anchor:"datasets.load_dataset",parameters:[{name:"path",val:": str"},{name:"name",val:": Optional = None"},{name:"data_dir",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"split",val:": Union = None"},{name:"cache_dir",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"download_config",val:": Optional = None"},{name:"download_mode",val:": Union = None"},{name:"verification_mode",val:": Union = None"},{name:"ignore_verifications",val:" = 'deprecated'"},{name:"keep_in_memory",val:": Optional = None"},{name:"save_infos",val:": bool = False"},{name:"revision",val:": Union = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"task",val:" = 'deprecated'"},{name:"streaming",val:": bool = False"},{name:"num_proc",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"trust_remote_code",val:": bool = None"},{name:"**config_kwargs",val:""}],parametersDescription:[{anchor:"datasets.load_dataset.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Path or name of the dataset.
Depending on <code>path</code>, the dataset builder that is used comes from a generic dataset script (JSON, CSV, Parquet, text etc.) or from the dataset script (a python file) inside the dataset directory.</p>
<p>For local datasets:</p>
<ul>
<li>if <code>path</code> is a local directory (containing data files only)
-&gt; load a generic dataset builder (csv, json, text etc.) based on the content of the directory
e.g. <code>&apos;./path/to/directory/with/my/csv/data&apos;</code>.</li>
<li>if <code>path</code> is a local dataset script or a directory containing a local dataset script (if the script has the same name as the directory)
-&gt; load the dataset builder from the dataset script
e.g. <code>&apos;./dataset/squad&apos;</code> or <code>&apos;./dataset/squad/squad.py&apos;</code>.</li>
</ul>
<p>For datasets on the Hugging Face Hub (list all available datasets with <code>huggingface_hub.list_datasets</code>)</p>
<ul>
<li>if <code>path</code> is a dataset repository on the HF hub (containing data files only)
-&gt; load a generic dataset builder (csv, text etc.) based on the content of the repository
e.g. <code>&apos;username/dataset_name&apos;</code>, a dataset repository on the HF hub containing your data files.</li>
<li>if <code>path</code> is a dataset repository on the HF hub with a dataset script (if the script has the same name as the directory)
-&gt; load the dataset builder from the dataset script in the dataset repository
e.g. <code>glue</code>, <code>squad</code>, <code>&apos;username/dataset_name&apos;</code>, a dataset repository on the HF hub containing a dataset script <code>&apos;dataset_name.py&apos;</code>.</li>
</ul>`,name:"path"},{anchor:"datasets.load_dataset.name",description:`<strong>name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Defining the name of the dataset configuration.`,name:"name"},{anchor:"datasets.load_dataset.data_dir",description:`<strong>data_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Defining the <code>data_dir</code> of the dataset configuration. If specified for the generic builders (csv, text etc.) or the Hub datasets and <code>data_files</code> is <code>None</code>,
the behavior is equal to passing <code>os.path.join(data_dir, **)</code> as <code>data_files</code> to reference all the files in a directory.`,name:"data_dir"},{anchor:"datasets.load_dataset.data_files",description:`<strong>data_files</strong> (<code>str</code> or <code>Sequence</code> or <code>Mapping</code>, <em>optional</em>) &#x2014;
Path(s) to source data file(s).`,name:"data_files"},{anchor:"datasets.load_dataset.split",description:`<strong>split</strong> (<code>Split</code> or <code>str</code>) &#x2014;
Which split of the data to load.
If <code>None</code>, will return a <code>dict</code> with all splits (typically <code>datasets.Split.TRAIN</code> and <code>datasets.Split.TEST</code>).
If given, will return a single Dataset.
Splits can be combined and specified like in tensorflow-datasets.`,name:"split"},{anchor:"datasets.load_dataset.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Directory to read/write data. Defaults to <code>&quot;~/.cache/huggingface/datasets&quot;</code>.`,name:"cache_dir"},{anchor:"datasets.load_dataset.features",description:`<strong>features</strong> (<code>Features</code>, <em>optional</em>) &#x2014;
Set the features type to use for this dataset.`,name:"features"},{anchor:"datasets.load_dataset.download_config",description:`<strong>download_config</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadConfig">DownloadConfig</a>, <em>optional</em>) &#x2014;
Specific download configuration parameters.`,name:"download_config"},{anchor:"datasets.load_dataset.download_mode",description:`<strong>download_mode</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadMode">DownloadMode</a> or <code>str</code>, defaults to <code>REUSE_DATASET_IF_EXISTS</code>) &#x2014;
Download/generate mode.`,name:"download_mode"},{anchor:"datasets.load_dataset.verification_mode",description:`<strong>verification_mode</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.VerificationMode">VerificationMode</a> or <code>str</code>, defaults to <code>BASIC_CHECKS</code>) &#x2014;
Verification mode determining the checks to run on the downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.9.1</p>
						
					</div>`,name:"verification_mode"},{anchor:"datasets.load_dataset.ignore_verifications",description:`<strong>ignore_verifications</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Ignore the verifications of the downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.9.1</p>
						
<p><code>ignore_verifications</code> was deprecated in version 2.9.1 and will be removed in 3.0.0.
Please use <code>verification_mode</code> instead.</p>

					</div>`,name:"ignore_verifications"},{anchor:"datasets.load_dataset.keep_in_memory",description:`<strong>keep_in_memory</strong> (<code>bool</code>, defaults to <code>None</code>) &#x2014;
Whether to copy the dataset in-memory. If <code>None</code>, the dataset
will not be copied in-memory unless explicitly enabled by setting <code>datasets.config.IN_MEMORY_MAX_SIZE</code> to
nonzero. See more details in the <a href="../cache#improve-performance">improve performance</a> section.`,name:"keep_in_memory"},{anchor:"datasets.load_dataset.save_infos",description:`<strong>save_infos</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Save the dataset information (checksums/size/splits/&#x2026;).`,name:"save_infos"},{anchor:"datasets.load_dataset.revision",description:`<strong>revision</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.Version">Version</a> or <code>str</code>, <em>optional</em>) &#x2014;
Version of the dataset script to load.
As datasets have their own git repository on the Datasets Hub, the default version &#x201C;main&#x201D; corresponds to their &#x201C;main&#x201D; branch.
You can specify a different version than the default &#x201C;main&#x201D; by using a commit SHA or a git tag of the dataset repository.`,name:"revision"},{anchor:"datasets.load_dataset.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token for remote files on the Datasets Hub.
If <code>True</code>, or not specified, will get token from <code>&quot;~/.huggingface&quot;</code>.`,name:"token"},{anchor:"datasets.load_dataset.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token for remote files on the Datasets Hub.
If <code>True</code>, or not specified, will get token from <code>&quot;~/.huggingface&quot;</code>.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.14.0</p>
						
<p><code>use_auth_token</code> was deprecated in favor of <code>token</code> in version 2.14.0 and will be removed in 3.0.0.</p>

					</div>`,name:"use_auth_token"},{anchor:"datasets.load_dataset.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task to prepare the dataset for during training and evaluation. Casts the dataset&#x2019;s <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Features">Features</a> to standardized column names and types as detailed in <code>datasets.tasks</code>.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.13.0</p>
						
<p><code>task</code> was deprecated in version 2.13.0 and will be removed in 3.0.0.</p>

					</div>`,name:"task"},{anchor:"datasets.load_dataset.streaming",description:`<strong>streaming</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, don&#x2019;t download the data files. Instead, it streams the data progressively while
iterating on the dataset. An <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> or <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.IterableDatasetDict">IterableDatasetDict</a> is returned instead in this case.</p>
<p>Note that streaming works for datasets that use data formats that support being iterated over like txt, csv, jsonl for example.
Json files may be downloaded completely. Also streaming from remote zip or gzip files is supported but other compressed formats
like rar and xz are not yet supported. The tgz format doesn&#x2019;t allow streaming.`,name:"streaming"},{anchor:"datasets.load_dataset.num_proc",description:`<strong>num_proc</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes when downloading and generating the dataset locally.
Multiprocessing is disabled by default.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.7.0</p>
						
					</div>`,name:"num_proc"},{anchor:"datasets.load_dataset.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
<strong>Experimental</strong>. Key/value pairs to be passed on to the dataset file-system backend, if any.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.11.0</p>
						
					</div>`,name:"storage_options"},{anchor:"datasets.load_dataset.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for datasets defined on the Hub using a dataset script. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.16.0</p>
						
					</div>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Changed in 2.20.0</p>
						
<p><code>trust_remote_code</code> defaults to <code>False</code> if not specified.</p>

					</div>`,name:"trust_remote_code"},{anchor:"datasets.load_dataset.*config_kwargs",description:`*<strong>*config_kwargs</strong> (additional keyword arguments) &#x2014;
Keyword arguments to be passed to the <code>BuilderConfig</code>
and used in the <a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DatasetBuilder">DatasetBuilder</a>.`,name:"*config_kwargs"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/load.py#L1850",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>if <code>split</code> is not <code>None</code>: the dataset requested,</li>
<li>if <code>split</code> is <code>None</code>, a <a
  href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.DatasetDict"
>DatasetDict</a> with each split.</li>
</ul>
<p>or <a
  href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.IterableDataset"
>IterableDataset</a> or <a
  href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.IterableDatasetDict"
>IterableDatasetDict</a>: if <code>streaming=True</code></p>
<ul>
<li>if <code>split</code> is not <code>None</code>, the dataset is requested</li>
<li>if <code>split</code> is <code>None</code>, a <code>~datasets.streaming.IterableDatasetDict</code> with each split.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset"
>Dataset</a> or <a
  href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.DatasetDict"
>DatasetDict</a></p>
`}}),te=new G({props:{anchor:"datasets.load_dataset.example",$$slots:{default:[ms]},$$scope:{ctx:D}}}),ae=new G({props:{anchor:"datasets.load_dataset.example-2",$$slots:{default:[gs]},$$scope:{ctx:D}}}),oe=new G({props:{anchor:"datasets.load_dataset.example-3",$$slots:{default:[fs]},$$scope:{ctx:D}}}),se=new G({props:{anchor:"datasets.load_dataset.example-4",$$slots:{default:[us]},$$scope:{ctx:D}}}),ge=new O({props:{name:"datasets.load_from_disk",anchor:"datasets.load_from_disk",parameters:[{name:"dataset_path",val:": str"},{name:"fs",val:" = 'deprecated'"},{name:"keep_in_memory",val:": Optional = None"},{name:"storage_options",val:": Optional = None"}],parametersDescription:[{anchor:"datasets.load_from_disk.dataset_path",description:`<strong>dataset_path</strong> (<code>str</code>) &#x2014;
Path (e.g. <code>&quot;dataset/train&quot;</code>) or remote URI (e.g.
<code>&quot;s3://my-bucket/dataset/train&quot;</code>) of the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset">Dataset</a> or <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.DatasetDict">DatasetDict</a> directory where the dataset will be
loaded from.`,name:"dataset_path"},{anchor:"datasets.load_from_disk.fs",description:`<strong>fs</strong> (<code>~filesystems.S3FileSystem</code> or <code>fsspec.spec.AbstractFileSystem</code>, <em>optional</em>) &#x2014;
Instance of the remote filesystem used to download the files from.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.9.0</p>
						
<p><code>fs</code> was deprecated in version 2.9.0 and will be removed in 3.0.0.
Please use <code>storage_options</code> instead, e.g. <code>storage_options=fs.storage_options</code>.</p>

					</div>`,name:"fs"},{anchor:"datasets.load_from_disk.keep_in_memory",description:`<strong>keep_in_memory</strong> (<code>bool</code>, defaults to <code>None</code>) &#x2014;
Whether to copy the dataset in-memory. If <code>None</code>, the dataset
will not be copied in-memory unless explicitly enabled by setting <code>datasets.config.IN_MEMORY_MAX_SIZE</code> to
nonzero. See more details in the <a href="../cache#improve-performance">improve performance</a> section.`,name:"keep_in_memory"},{anchor:"datasets.load_from_disk.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Key/value pairs to be passed on to the file-system backend, if any.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.9.0</p>
						
					</div>`,name:"storage_options"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/load.py#L2170",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>If <code>dataset_path</code> is a path of a dataset directory: the dataset requested.</li>
<li>If <code>dataset_path</code> is a path of a dataset dict directory, a <a
  href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.DatasetDict"
>DatasetDict</a> with each split.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset"
>Dataset</a> or <a
  href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.DatasetDict"
>DatasetDict</a></p>
`}}),ne=new G({props:{anchor:"datasets.load_from_disk.example",$$slots:{default:[hs]},$$scope:{ctx:D}}}),fe=new O({props:{name:"datasets.load_dataset_builder",anchor:"datasets.load_dataset_builder",parameters:[{name:"path",val:": str"},{name:"name",val:": Optional = None"},{name:"data_dir",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"cache_dir",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"download_config",val:": Optional = None"},{name:"download_mode",val:": Union = None"},{name:"revision",val:": Union = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"storage_options",val:": Optional = None"},{name:"trust_remote_code",val:": Optional = None"},{name:"_require_default_config_name",val:" = True"},{name:"**config_kwargs",val:""}],parametersDescription:[{anchor:"datasets.load_dataset_builder.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Path or name of the dataset.
Depending on <code>path</code>, the dataset builder that is used comes from a generic dataset script (JSON, CSV, Parquet, text etc.) or from the dataset script (a python file) inside the dataset directory.</p>
<p>For local datasets:</p>
<ul>
<li>if <code>path</code> is a local directory (containing data files only)
-&gt; load a generic dataset builder (csv, json, text etc.) based on the content of the directory
e.g. <code>&apos;./path/to/directory/with/my/csv/data&apos;</code>.</li>
<li>if <code>path</code> is a local dataset script or a directory containing a local dataset script (if the script has the same name as the directory)
-&gt; load the dataset builder from the dataset script
e.g. <code>&apos;./dataset/squad&apos;</code> or <code>&apos;./dataset/squad/squad.py&apos;</code>.</li>
</ul>
<p>For datasets on the Hugging Face Hub (list all available datasets with <code>huggingface_hub.list_datasets</code>)</p>
<ul>
<li>if <code>path</code> is a dataset repository on the HF hub (containing data files only)
-&gt; load a generic dataset builder (csv, text etc.) based on the content of the repository
e.g. <code>&apos;username/dataset_name&apos;</code>, a dataset repository on the HF hub containing your data files.</li>
<li>if <code>path</code> is a dataset repository on the HF hub with a dataset script (if the script has the same name as the directory)
-&gt; load the dataset builder from the dataset script in the dataset repository
e.g. <code>glue</code>, <code>squad</code>, <code>&apos;username/dataset_name&apos;</code>, a dataset repository on the HF hub containing a dataset script <code>&apos;dataset_name.py&apos;</code>.</li>
</ul>`,name:"path"},{anchor:"datasets.load_dataset_builder.name",description:`<strong>name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Defining the name of the dataset configuration.`,name:"name"},{anchor:"datasets.load_dataset_builder.data_dir",description:`<strong>data_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Defining the <code>data_dir</code> of the dataset configuration. If specified for the generic builders (csv, text etc.) or the Hub datasets and <code>data_files</code> is <code>None</code>,
the behavior is equal to passing <code>os.path.join(data_dir, **)</code> as <code>data_files</code> to reference all the files in a directory.`,name:"data_dir"},{anchor:"datasets.load_dataset_builder.data_files",description:`<strong>data_files</strong> (<code>str</code> or <code>Sequence</code> or <code>Mapping</code>, <em>optional</em>) &#x2014;
Path(s) to source data file(s).`,name:"data_files"},{anchor:"datasets.load_dataset_builder.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Directory to read/write data. Defaults to <code>&quot;~/.cache/huggingface/datasets&quot;</code>.`,name:"cache_dir"},{anchor:"datasets.load_dataset_builder.features",description:`<strong>features</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Features">Features</a>, <em>optional</em>) &#x2014;
Set the features type to use for this dataset.`,name:"features"},{anchor:"datasets.load_dataset_builder.download_config",description:`<strong>download_config</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadConfig">DownloadConfig</a>, <em>optional</em>) &#x2014;
Specific download configuration parameters.`,name:"download_config"},{anchor:"datasets.load_dataset_builder.download_mode",description:`<strong>download_mode</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadMode">DownloadMode</a> or <code>str</code>, defaults to <code>REUSE_DATASET_IF_EXISTS</code>) &#x2014;
Download/generate mode.`,name:"download_mode"},{anchor:"datasets.load_dataset_builder.revision",description:`<strong>revision</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.Version">Version</a> or <code>str</code>, <em>optional</em>) &#x2014;
Version of the dataset script to load.
As datasets have their own git repository on the Datasets Hub, the default version &#x201C;main&#x201D; corresponds to their &#x201C;main&#x201D; branch.
You can specify a different version than the default &#x201C;main&#x201D; by using a commit SHA or a git tag of the dataset repository.`,name:"revision"},{anchor:"datasets.load_dataset_builder.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token for remote files on the Datasets Hub.
If <code>True</code>, or not specified, will get token from <code>&quot;~/.huggingface&quot;</code>.`,name:"token"},{anchor:"datasets.load_dataset_builder.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token for remote files on the Datasets Hub.
If <code>True</code>, or not specified, will get token from <code>&quot;~/.huggingface&quot;</code>.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.14.0</p>
						
<p><code>use_auth_token</code> was deprecated in favor of <code>token</code> in version 2.14.0 and will be removed in 3.0.0.</p>

					</div>`,name:"use_auth_token"},{anchor:"datasets.load_dataset_builder.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
<strong>Experimental</strong>. Key/value pairs to be passed on to the dataset file-system backend, if any.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.11.0</p>
						
					</div>`,name:"storage_options"},{anchor:"datasets.load_dataset_builder.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for datasets defined on the Hub using a dataset script. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.16.0</p>
						
					</div>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Changed in 2.20.0</p>
						
<p><code>trust_remote_code</code> defaults to <code>False</code> if not specified.</p>

					</div>`,name:"trust_remote_code"},{anchor:"datasets.load_dataset_builder.*config_kwargs",description:`*<strong>*config_kwargs</strong> (additional keyword arguments) &#x2014;
Keyword arguments to be passed to the <a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a>
and used in the <a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DatasetBuilder">DatasetBuilder</a>.`,name:"*config_kwargs"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/load.py#L1662",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DatasetBuilder"
>DatasetBuilder</a></p>
`}}),re=new G({props:{anchor:"datasets.load_dataset_builder.example",$$slots:{default:[_s]},$$scope:{ctx:D}}}),ue=new O({props:{name:"datasets.get_dataset_config_names",anchor:"datasets.get_dataset_config_names",parameters:[{name:"path",val:": str"},{name:"revision",val:": Union = None"},{name:"download_config",val:": Optional = None"},{name:"download_mode",val:": Union = None"},{name:"dynamic_modules_path",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"**download_kwargs",val:""}],parametersDescription:[{anchor:"datasets.get_dataset_config_names.path",description:`<strong>path</strong> (<code>str</code>) &#x2014; path to the dataset processing script with the dataset builder. Can be either:</p>
<ul>
<li>a local path to processing script or the directory containing the script (if the script has the same name as the directory),
e.g. <code>&apos;./dataset/squad&apos;</code> or <code>&apos;./dataset/squad/squad.py&apos;</code></li>
<li>a dataset identifier on the Hugging Face Hub (list all available datasets and ids with <a href="/docs/datasets/pr_7043/en/package_reference/loading_methods#datasets.list_datasets">datasets.list_datasets()</a>)
e.g. <code>&apos;squad&apos;</code>, <code>&apos;glue&apos;</code> or <code>&apos;openai/webtext&apos;</code></li>
</ul>`,name:"path"},{anchor:"datasets.get_dataset_config_names.revision",description:`<strong>revision</strong> (<code>Union[str, datasets.Version]</code>, <em>optional</em>) &#x2014;
If specified, the dataset module will be loaded from the datasets repository at this version.
By default:</p>
<ul>
<li>it is set to the local version of the lib.</li>
<li>it will also try to load it from the main branch if it&#x2019;s not available at the local version of the lib.
Specifying a version that is different from your local version of the lib might cause compatibility issues.</li>
</ul>`,name:"revision"},{anchor:"datasets.get_dataset_config_names.download_config",description:`<strong>download_config</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadConfig">DownloadConfig</a>, <em>optional</em>) &#x2014;
Specific download configuration parameters.`,name:"download_config"},{anchor:"datasets.get_dataset_config_names.download_mode",description:`<strong>download_mode</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadMode">DownloadMode</a> or <code>str</code>, defaults to <code>REUSE_DATASET_IF_EXISTS</code>) &#x2014;
Download/generate mode.`,name:"download_mode"},{anchor:"datasets.get_dataset_config_names.dynamic_modules_path",description:`<strong>dynamic_modules_path</strong> (<code>str</code>, defaults to <code>~/.cache/huggingface/modules/datasets_modules</code>) &#x2014;
Optional path to the directory in which the dynamic modules are saved. It must have been initialized with <code>init_dynamic_modules</code>.
By default the datasets are stored inside the <code>datasets_modules</code> module.`,name:"dynamic_modules_path"},{anchor:"datasets.get_dataset_config_names.data_files",description:`<strong>data_files</strong> (<code>Union[Dict, List, str]</code>, <em>optional</em>) &#x2014;
Defining the data_files of the dataset configuration.`,name:"data_files"},{anchor:"datasets.get_dataset_config_names.*download_kwargs",description:`*<strong>*download_kwargs</strong> (additional keyword arguments) &#x2014;
Optional attributes for <a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadConfig">DownloadConfig</a> which will override the attributes in <code>download_config</code> if supplied,
for example <code>token</code>.`,name:"*download_kwargs"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/inspect.py#L204"}}),de=new G({props:{anchor:"datasets.get_dataset_config_names.example",$$slots:{default:[vs]},$$scope:{ctx:D}}}),he=new O({props:{name:"datasets.get_dataset_infos",anchor:"datasets.get_dataset_infos",parameters:[{name:"path",val:": str"},{name:"data_files",val:": Union = None"},{name:"download_config",val:": Optional = None"},{name:"download_mode",val:": Union = None"},{name:"revision",val:": Union = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],parametersDescription:[{anchor:"datasets.get_dataset_infos.path",description:`<strong>path</strong> (<code>str</code>) &#x2014; path to the dataset processing script with the dataset builder. Can be either:</p>
<ul>
<li>a local path to processing script or the directory containing the script (if the script has the same name as the directory),
e.g. <code>&apos;./dataset/squad&apos;</code> or <code>&apos;./dataset/squad/squad.py&apos;</code></li>
<li>a dataset identifier on the Hugging Face Hub (list all available datasets and ids with <a href="/docs/datasets/pr_7043/en/package_reference/loading_methods#datasets.list_datasets">datasets.list_datasets()</a>)
e.g. <code>&apos;squad&apos;</code>, <code>&apos;glue&apos;</code> or\`<code>&apos;openai/webtext&apos;</code></li>
</ul>`,name:"path"},{anchor:"datasets.get_dataset_infos.revision",description:`<strong>revision</strong> (<code>Union[str, datasets.Version]</code>, <em>optional</em>) &#x2014;
If specified, the dataset module will be loaded from the datasets repository at this version.
By default:</p>
<ul>
<li>it is set to the local version of the lib.</li>
<li>it will also try to load it from the main branch if it&#x2019;s not available at the local version of the lib.
Specifying a version that is different from your local version of the lib might cause compatibility issues.</li>
</ul>`,name:"revision"},{anchor:"datasets.get_dataset_infos.download_config",description:`<strong>download_config</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadConfig">DownloadConfig</a>, <em>optional</em>) &#x2014;
Specific download configuration parameters.`,name:"download_config"},{anchor:"datasets.get_dataset_infos.download_mode",description:`<strong>download_mode</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadMode">DownloadMode</a> or <code>str</code>, defaults to <code>REUSE_DATASET_IF_EXISTS</code>) &#x2014;
Download/generate mode.`,name:"download_mode"},{anchor:"datasets.get_dataset_infos.data_files",description:`<strong>data_files</strong> (<code>Union[Dict, List, str]</code>, <em>optional</em>) &#x2014;
Defining the data_files of the dataset configuration.`,name:"data_files"},{anchor:"datasets.get_dataset_infos.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token for remote files on the Datasets Hub.
If <code>True</code>, or not specified, will get token from <code>&quot;~/.huggingface&quot;</code>.`,name:"token"},{anchor:"datasets.get_dataset_infos.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token for remote files on the Datasets Hub.
If <code>True</code>, or not specified, will get token from <code>&quot;~/.huggingface&quot;</code>.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.14.0</p>
						
<p><code>use_auth_token</code> was deprecated in favor of <code>token</code> in version 2.14.0 and will be removed in 3.0.0.</p>

					</div>`,name:"use_auth_token"},{anchor:"datasets.get_dataset_infos.*config_kwargs",description:`*<strong>*config_kwargs</strong> (additional keyword arguments) &#x2014;
Optional attributes for builder class which will override the attributes if supplied.`,name:"*config_kwargs"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/inspect.py#L118"}}),le=new G({props:{anchor:"datasets.get_dataset_infos.example",$$slots:{default:[bs]},$$scope:{ctx:D}}}),_e=new O({props:{name:"datasets.get_dataset_split_names",anchor:"datasets.get_dataset_split_names",parameters:[{name:"path",val:": str"},{name:"config_name",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"download_config",val:": Optional = None"},{name:"download_mode",val:": Union = None"},{name:"revision",val:": Union = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],parametersDescription:[{anchor:"datasets.get_dataset_split_names.path",description:`<strong>path</strong> (<code>str</code>) &#x2014; path to the dataset processing script with the dataset builder. Can be either:</p>
<ul>
<li>a local path to processing script or the directory containing the script (if the script has the same name as the directory),
e.g. <code>&apos;./dataset/squad&apos;</code> or <code>&apos;./dataset/squad/squad.py&apos;</code></li>
<li>a dataset identifier on the Hugging Face Hub (list all available datasets and ids with <a href="/docs/datasets/pr_7043/en/package_reference/loading_methods#datasets.list_datasets">datasets.list_datasets()</a>)
e.g. <code>&apos;squad&apos;</code>, <code>&apos;glue&apos;</code> or <code>&apos;openai/webtext&apos;</code></li>
</ul>`,name:"path"},{anchor:"datasets.get_dataset_split_names.config_name",description:`<strong>config_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Defining the name of the dataset configuration.`,name:"config_name"},{anchor:"datasets.get_dataset_split_names.data_files",description:`<strong>data_files</strong> (<code>str</code> or <code>Sequence</code> or <code>Mapping</code>, <em>optional</em>) &#x2014;
Path(s) to source data file(s).`,name:"data_files"},{anchor:"datasets.get_dataset_split_names.download_config",description:`<strong>download_config</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadConfig">DownloadConfig</a>, <em>optional</em>) &#x2014;
Specific download configuration parameters.`,name:"download_config"},{anchor:"datasets.get_dataset_split_names.download_mode",description:`<strong>download_mode</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadMode">DownloadMode</a> or <code>str</code>, defaults to <code>REUSE_DATASET_IF_EXISTS</code>) &#x2014;
Download/generate mode.`,name:"download_mode"},{anchor:"datasets.get_dataset_split_names.revision",description:`<strong>revision</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.Version">Version</a> or <code>str</code>, <em>optional</em>) &#x2014;
Version of the dataset script to load.
As datasets have their own git repository on the Datasets Hub, the default version &#x201C;main&#x201D; corresponds to their &#x201C;main&#x201D; branch.
You can specify a different version than the default &#x201C;main&#x201D; by using a commit SHA or a git tag of the dataset repository.`,name:"revision"},{anchor:"datasets.get_dataset_split_names.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token for remote files on the Datasets Hub.
If <code>True</code>, or not specified, will get token from <code>&quot;~/.huggingface&quot;</code>.`,name:"token"},{anchor:"datasets.get_dataset_split_names.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token for remote files on the Datasets Hub.
If <code>True</code>, or not specified, will get token from <code>&quot;~/.huggingface&quot;</code>.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.14.0</p>
						
<p><code>use_auth_token</code> was deprecated in favor of <code>token</code> in version 2.14.0 and will be removed in 3.0.0.</p>

					</div>`,name:"use_auth_token"},{anchor:"datasets.get_dataset_split_names.*config_kwargs",description:`*<strong>*config_kwargs</strong> (additional keyword arguments) &#x2014;
Optional attributes for builder class which will override the attributes if supplied.`,name:"*config_kwargs"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/inspect.py#L421"}}),ie=new G({props:{anchor:"datasets.get_dataset_split_names.example",$$slots:{default:[$s]},$$scope:{ctx:D}}}),ve=new O({props:{name:"datasets.inspect_dataset",anchor:"datasets.inspect_dataset",parameters:[{name:"path",val:": str"},{name:"local_path",val:": str"},{name:"download_config",val:": Optional = None"},{name:"**download_kwargs",val:""}],parametersDescription:[{anchor:"datasets.inspect_dataset.path",description:`<strong>path</strong> (<code>str</code>) &#x2014; Path to the dataset processing script with the dataset builder. Can be either:</p>
<ul>
<li>a local path to processing script or the directory containing the script (if the script has the same name
as the directory),
e.g. <code>&apos;./dataset/squad&apos;</code> or <code>&apos;./dataset/squad/squad.py&apos;</code>.</li>
<li>a dataset identifier on the Hugging Face Hub (list all available datasets and ids with <a href="/docs/datasets/pr_7043/en/package_reference/loading_methods#datasets.list_datasets">list_datasets()</a>)
e.g. <code>&apos;squad&apos;</code>, <code>&apos;glue&apos;</code> or <code>&apos;openai/webtext&apos;</code>.</li>
</ul>`,name:"path"},{anchor:"datasets.inspect_dataset.local_path",description:`<strong>local_path</strong> (<code>str</code>) &#x2014;
Path to the local folder to copy the dataset script to.`,name:"local_path"},{anchor:"datasets.inspect_dataset.download_config",description:`<strong>download_config</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadConfig">DownloadConfig</a>, <em>optional</em>) &#x2014;
Specific download configuration parameters.`,name:"download_config"},{anchor:"datasets.inspect_dataset.*download_kwargs",description:`*<strong>*download_kwargs</strong> (additional keyword arguments) &#x2014;
Optional arguments for <a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadConfig">DownloadConfig</a> which will override
the attributes of <code>download_config</code> if supplied.`,name:"*download_kwargs"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/inspect.py#L81"}}),be=new U({props:{title:"From files",local:"from-files",headingTag:"h2"}}),we=new R({props:{code:"bG9hZF9kYXRhc2V0KCUyMmNzdiUyMiUyQyUyMGRhdGFfZGlyJTNEJTIycGF0aCUyRnRvJTJGZGF0YSUyRmRpciUyMiUyQyUyMHNlcCUzRCUyMiU1Q3QlMjIp",highlighted:'load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_dir=<span class="hljs-string">&quot;path/to/data/dir&quot;</span>, sep=<span class="hljs-string">&quot;\\t&quot;</span>)',wrap:!1}}),ye=new U({props:{title:"Text",local:"datasets.packaged_modules.text.TextConfig",headingTag:"h3"}}),Ne=new O({props:{name:"class datasets.packaged_modules.text.TextConfig",anchor:"datasets.packaged_modules.text.TextConfig",parameters:[{name:"name",val:": str = 'default'"},{name:"version",val:": Union = 0.0.0"},{name:"data_dir",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"description",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"encoding",val:": str = 'utf-8'"},{name:"errors",val:": dataclasses.InitVar[typing.Optional[str]] = 'deprecated'"},{name:"encoding_errors",val:": Optional = None"},{name:"chunksize",val:": int = 10485760"},{name:"keep_linebreaks",val:": bool = False"},{name:"sample_by",val:": str = 'line'"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/text/text.py#L17"}}),Oe=new O({props:{name:"class datasets.packaged_modules.text.Text",anchor:"datasets.packaged_modules.text.Text",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/text/text.py#L40"}}),De=new U({props:{title:"CSV",local:"datasets.packaged_modules.csv.CsvConfig",headingTag:"h3"}}),je=new O({props:{name:"class datasets.packaged_modules.csv.CsvConfig",anchor:"datasets.packaged_modules.csv.CsvConfig",parameters:[{name:"name",val:": str = 'default'"},{name:"version",val:": Union = 0.0.0"},{name:"data_dir",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"description",val:": Optional = None"},{name:"sep",val:": str = ','"},{name:"delimiter",val:": Optional = None"},{name:"header",val:": Union = 'infer'"},{name:"names",val:": Optional = None"},{name:"column_names",val:": Optional = None"},{name:"index_col",val:": Union = None"},{name:"usecols",val:": Union = None"},{name:"prefix",val:": Optional = None"},{name:"mangle_dupe_cols",val:": bool = True"},{name:"engine",val:": Optional = None"},{name:"converters",val:": Dict = None"},{name:"true_values",val:": Optional = None"},{name:"false_values",val:": Optional = None"},{name:"skipinitialspace",val:": bool = False"},{name:"skiprows",val:": Union = None"},{name:"nrows",val:": Optional = None"},{name:"na_values",val:": Union = None"},{name:"keep_default_na",val:": bool = True"},{name:"na_filter",val:": bool = True"},{name:"verbose",val:": bool = False"},{name:"skip_blank_lines",val:": bool = True"},{name:"thousands",val:": Optional = None"},{name:"decimal",val:": str = '.'"},{name:"lineterminator",val:": Optional = None"},{name:"quotechar",val:`: str = '"'`},{name:"quoting",val:": int = 0"},{name:"escapechar",val:": Optional = None"},{name:"comment",val:": Optional = None"},{name:"encoding",val:": Optional = None"},{name:"dialect",val:": Optional = None"},{name:"error_bad_lines",val:": bool = True"},{name:"warn_bad_lines",val:": bool = True"},{name:"skipfooter",val:": int = 0"},{name:"doublequote",val:": bool = True"},{name:"memory_map",val:": bool = False"},{name:"float_precision",val:": Optional = None"},{name:"chunksize",val:": int = 10000"},{name:"features",val:": Optional = None"},{name:"encoding_errors",val:": Optional = 'strict'"},{name:"on_bad_lines",val:": Literal = 'error'"},{name:"date_format",val:": Optional = None"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/csv/csv.py#L24"}}),Ue=new O({props:{name:"class datasets.packaged_modules.csv.Csv",anchor:"datasets.packaged_modules.csv.Csv",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/csv/csv.py#L145"}}),Fe=new U({props:{title:"JSON",local:"datasets.packaged_modules.json.JsonConfig",headingTag:"h3"}}),Me=new O({props:{name:"class datasets.packaged_modules.json.JsonConfig",anchor:"datasets.packaged_modules.json.JsonConfig",parameters:[{name:"name",val:": str = 'default'"},{name:"version",val:": Union = 0.0.0"},{name:"data_dir",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"description",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"encoding",val:": str = 'utf-8'"},{name:"encoding_errors",val:": Optional = None"},{name:"field",val:": Optional = None"},{name:"use_threads",val:": bool = True"},{name:"block_size",val:": Optional = None"},{name:"chunksize",val:": int = 10485760"},{name:"newlines_in_values",val:": Optional = None"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/json/json.py#L41"}}),Ie=new O({props:{name:"class datasets.packaged_modules.json.Json",anchor:"datasets.packaged_modules.json.Json",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/json/json.py#L58"}}),Je=new U({props:{title:"Parquet",local:"datasets.packaged_modules.parquet.ParquetConfig",headingTag:"h3"}}),Re=new O({props:{name:"class datasets.packaged_modules.parquet.ParquetConfig",anchor:"datasets.packaged_modules.parquet.ParquetConfig",parameters:[{name:"name",val:": str = 'default'"},{name:"version",val:": Union = 0.0.0"},{name:"data_dir",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"description",val:": Optional = None"},{name:"batch_size",val:": Optional = None"},{name:"columns",val:": Optional = None"},{name:"features",val:": Optional = None"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/parquet/parquet.py#L15"}}),Se=new O({props:{name:"class datasets.packaged_modules.parquet.Parquet",anchor:"datasets.packaged_modules.parquet.Parquet",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/parquet/parquet.py#L27"}}),Ze=new U({props:{title:"Arrow",local:"datasets.packaged_modules.arrow.ArrowConfig",headingTag:"h3"}}),He=new O({props:{name:"class datasets.packaged_modules.arrow.ArrowConfig",anchor:"datasets.packaged_modules.arrow.ArrowConfig",parameters:[{name:"name",val:": str = 'default'"},{name:"version",val:": Union = 0.0.0"},{name:"data_dir",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"description",val:": Optional = None"},{name:"features",val:": Optional = None"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/arrow/arrow.py#L14"}}),Ve=new O({props:{name:"class datasets.packaged_modules.arrow.Arrow",anchor:"datasets.packaged_modules.arrow.Arrow",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/arrow/arrow.py#L24"}}),Xe=new U({props:{title:"SQL",local:"datasets.packaged_modules.sql.SqlConfig",headingTag:"h3"}}),Ee=new O({props:{name:"class datasets.packaged_modules.sql.SqlConfig",anchor:"datasets.packaged_modules.sql.SqlConfig",parameters:[{name:"name",val:": str = 'default'"},{name:"version",val:": Union = 0.0.0"},{name:"data_dir",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"description",val:": Optional = None"},{name:"sql",val:": Union = None"},{name:"con",val:": Union = None"},{name:"index_col",val:": Union = None"},{name:"coerce_float",val:": bool = True"},{name:"params",val:": Union = None"},{name:"parse_dates",val:": Union = None"},{name:"columns",val:": Optional = None"},{name:"chunksize",val:": Optional = 10000"},{name:"features",val:": Optional = None"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/sql/sql.py#L23"}}),Pe=new O({props:{name:"class datasets.packaged_modules.sql.Sql",anchor:"datasets.packaged_modules.sql.Sql",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/sql/sql.py#L91"}}),Ae=new U({props:{title:"Images",local:"datasets.packaged_modules.imagefolder.ImageFolderConfig",headingTag:"h3"}}),Be=new O({props:{name:"class datasets.packaged_modules.imagefolder.ImageFolderConfig",anchor:"datasets.packaged_modules.imagefolder.ImageFolderConfig",parameters:[{name:"name",val:": str = 'default'"},{name:"version",val:": Union = 0.0.0"},{name:"data_dir",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"description",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"drop_labels",val:": bool = None"},{name:"drop_metadata",val:": bool = None"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/imagefolder/imagefolder.py#L12"}}),We=new O({props:{name:"class datasets.packaged_modules.imagefolder.ImageFolder",anchor:"datasets.packaged_modules.imagefolder.ImageFolder",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/imagefolder/imagefolder.py#L22"}}),Qe=new U({props:{title:"Audio",local:"datasets.packaged_modules.audiofolder.AudioFolderConfig",headingTag:"h3"}}),Ke=new O({props:{name:"class datasets.packaged_modules.audiofolder.AudioFolderConfig",anchor:"datasets.packaged_modules.audiofolder.AudioFolderConfig",parameters:[{name:"name",val:": str = 'default'"},{name:"version",val:": Union = 0.0.0"},{name:"data_dir",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"description",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"drop_labels",val:": bool = None"},{name:"drop_metadata",val:": bool = None"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/audiofolder/audiofolder.py#L12"}}),tt=new O({props:{name:"class datasets.packaged_modules.audiofolder.AudioFolder",anchor:"datasets.packaged_modules.audiofolder.AudioFolder",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/audiofolder/audiofolder.py#L22"}}),at=new U({props:{title:"WebDataset",local:"datasets.packaged_modules.webdataset.WebDataset",headingTag:"h3"}}),st=new O({props:{name:"class datasets.packaged_modules.webdataset.WebDataset",anchor:"datasets.packaged_modules.webdataset.WebDataset",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/packaged_modules/webdataset/webdataset.py#L18"}}),nt=new cs({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/package_reference/loading_methods.mdx"}}),{c(){d=i("meta"),k=n(),b=i("p"),l=n(),m(v.$$.fragment),t=n(),$=i("p"),$.textContent=bo,Gt=n(),m(ce.$$.fragment),St=n(),F=i("div"),m(pe.$$.fragment),qa=n(),lt=i("p"),lt.textContent=$o,Ia=n(),m(ee.$$.fragment),Zt=n(),w=i("div"),m(me.$$.fragment),Ja=n(),it=i("p"),it.textContent=xo,Ra=n(),ct=i("p"),ct.innerHTML=ko,Ga=n(),pt=i("p"),pt.textContent=wo,Sa=n(),mt=i("ul"),mt.innerHTML=yo,Za=n(),gt=i("p"),gt.textContent=No,Ha=n(),ft=i("p"),ft.textContent=Co,za=n(),ut=i("ol"),ut.innerHTML=Oo,Va=n(),ht=i("p"),ht.textContent=Do,Xa=n(),_t=i("p"),_t.textContent=jo,Ea=n(),m(te.$$.fragment),La=n(),m(ae.$$.fragment),Pa=n(),m(oe.$$.fragment),Aa=n(),m(se.$$.fragment),Ht=n(),M=i("div"),m(ge.$$.fragment),Ba=n(),vt=i("p"),vt.innerHTML=To,Ya=n(),m(ne.$$.fragment),zt=n(),j=i("div"),m(fe.$$.fragment),Wa=n(),bt=i("p"),bt.textContent=Uo,Qa=n(),$t=i("p"),$t.innerHTML=Fo,Ka=n(),xt=i("p"),xt.textContent=Mo,eo=n(),kt=i("ul"),kt.innerHTML=qo,to=n(),wt=i("p"),wt.textContent=Io,ao=n(),m(re.$$.fragment),Vt=n(),q=i("div"),m(ue.$$.fragment),oo=n(),yt=i("p"),yt.textContent=Jo,so=n(),m(de.$$.fragment),Xt=n(),I=i("div"),m(he.$$.fragment),no=n(),Nt=i("p"),Nt.textContent=Ro,ro=n(),m(le.$$.fragment),Et=n(),J=i("div"),m(_e.$$.fragment),lo=n(),Ct=i("p"),Ct.textContent=Go,io=n(),m(ie.$$.fragment),Lt=n(),Z=i("div"),m(ve.$$.fragment),co=n(),Ot=i("p"),Ot.textContent=So,Pt=n(),m(be.$$.fragment),At=n(),$e=i("p"),$e.textContent=Zo,Bt=n(),xe=i("ul"),xe.innerHTML=Ho,Yt=n(),ke=i("p"),ke.innerHTML=zo,Wt=n(),m(we.$$.fragment),Qt=n(),m(ye.$$.fragment),Kt=n(),H=i("div"),m(Ne.$$.fragment),po=n(),Dt=i("p"),Dt.textContent=Vo,ea=n(),Ce=i("div"),m(Oe.$$.fragment),ta=n(),m(De.$$.fragment),aa=n(),z=i("div"),m(je.$$.fragment),mo=n(),jt=i("p"),jt.textContent=Xo,oa=n(),Te=i("div"),m(Ue.$$.fragment),sa=n(),m(Fe.$$.fragment),na=n(),V=i("div"),m(Me.$$.fragment),go=n(),Tt=i("p"),Tt.textContent=Eo,ra=n(),qe=i("div"),m(Ie.$$.fragment),da=n(),m(Je.$$.fragment),la=n(),X=i("div"),m(Re.$$.fragment),fo=n(),Ut=i("p"),Ut.textContent=Lo,ia=n(),Ge=i("div"),m(Se.$$.fragment),ca=n(),m(Ze.$$.fragment),pa=n(),E=i("div"),m(He.$$.fragment),uo=n(),Ft=i("p"),Ft.textContent=Po,ma=n(),ze=i("div"),m(Ve.$$.fragment),ga=n(),m(Xe.$$.fragment),fa=n(),L=i("div"),m(Ee.$$.fragment),ho=n(),Mt=i("p"),Mt.textContent=Ao,ua=n(),Le=i("div"),m(Pe.$$.fragment),ha=n(),m(Ae.$$.fragment),_a=n(),P=i("div"),m(Be.$$.fragment),_o=n(),qt=i("p"),qt.textContent=Bo,va=n(),Ye=i("div"),m(We.$$.fragment),ba=n(),m(Qe.$$.fragment),$a=n(),A=i("div"),m(Ke.$$.fragment),vo=n(),It=i("p"),It.textContent=Yo,xa=n(),et=i("div"),m(tt.$$.fragment),ka=n(),m(at.$$.fragment),wa=n(),ot=i("div"),m(st.$$.fragment),ya=n(),m(nt.$$.fragment),Na=n(),Jt=i("p"),this.h()},l(e){const o=is("svelte-u9bgzb",document.head);d=c(o,"META",{name:!0,content:!0}),o.forEach(a),k=r(e),b=c(e,"P",{}),N(b).forEach(a),l=r(e),g(v.$$.fragment,e),t=r(e),$=c(e,"P",{"data-svelte-h":!0}),x($)!=="svelte-spmsxp"&&($.textContent=bo),Gt=r(e),g(ce.$$.fragment,e),St=r(e),F=c(e,"DIV",{class:!0});var B=N(F);g(pe.$$.fragment,B),qa=r(B),lt=c(B,"P",{"data-svelte-h":!0}),x(lt)!=="svelte-109dx7d"&&(lt.textContent=$o),Ia=r(B),g(ee.$$.fragment,B),B.forEach(a),Zt=r(e),w=c(e,"DIV",{class:!0});var y=N(w);g(me.$$.fragment,y),Ja=r(y),it=c(y,"P",{"data-svelte-h":!0}),x(it)!=="svelte-x6t4fm"&&(it.textContent=xo),Ra=r(y),ct=c(y,"P",{"data-svelte-h":!0}),x(ct)!=="svelte-1j3dvna"&&(ct.innerHTML=ko),Ga=r(y),pt=c(y,"P",{"data-svelte-h":!0}),x(pt)!=="svelte-gersvb"&&(pt.textContent=wo),Sa=r(y),mt=c(y,"UL",{"data-svelte-h":!0}),x(mt)!=="svelte-o5t8md"&&(mt.innerHTML=yo),Za=r(y),gt=c(y,"P",{"data-svelte-h":!0}),x(gt)!=="svelte-1uisk85"&&(gt.textContent=No),Ha=r(y),ft=c(y,"P",{"data-svelte-h":!0}),x(ft)!=="svelte-1osovlg"&&(ft.textContent=Co),za=r(y),ut=c(y,"OL",{"data-svelte-h":!0}),x(ut)!=="svelte-9lyw3k"&&(ut.innerHTML=Oo),Va=r(y),ht=c(y,"P",{"data-svelte-h":!0}),x(ht)!=="svelte-zu0m02"&&(ht.textContent=Do),Xa=r(y),_t=c(y,"P",{"data-svelte-h":!0}),x(_t)!=="svelte-11lpom8"&&(_t.textContent=jo),Ea=r(y),g(te.$$.fragment,y),La=r(y),g(ae.$$.fragment,y),Pa=r(y),g(oe.$$.fragment,y),Aa=r(y),g(se.$$.fragment,y),y.forEach(a),Ht=r(e),M=c(e,"DIV",{class:!0});var Y=N(M);g(ge.$$.fragment,Y),Ba=r(Y),vt=c(Y,"P",{"data-svelte-h":!0}),x(vt)!=="svelte-hfs23o"&&(vt.innerHTML=To),Ya=r(Y),g(ne.$$.fragment,Y),Y.forEach(a),zt=r(e),j=c(e,"DIV",{class:!0});var T=N(j);g(fe.$$.fragment,T),Wa=r(T),bt=c(T,"P",{"data-svelte-h":!0}),x(bt)!=="svelte-j91dbc"&&(bt.textContent=Uo),Qa=r(T),$t=c(T,"P",{"data-svelte-h":!0}),x($t)!=="svelte-1j3dvna"&&($t.innerHTML=Fo),Ka=r(T),xt=c(T,"P",{"data-svelte-h":!0}),x(xt)!=="svelte-gersvb"&&(xt.textContent=Mo),eo=r(T),kt=c(T,"UL",{"data-svelte-h":!0}),x(kt)!=="svelte-9ksyn3"&&(kt.innerHTML=qo),to=r(T),wt=c(T,"P",{"data-svelte-h":!0}),x(wt)!=="svelte-1uisk85"&&(wt.textContent=Io),ao=r(T),g(re.$$.fragment,T),T.forEach(a),Vt=r(e),q=c(e,"DIV",{class:!0});var W=N(q);g(ue.$$.fragment,W),oo=r(W),yt=c(W,"P",{"data-svelte-h":!0}),x(yt)!=="svelte-2twqqm"&&(yt.textContent=Jo),so=r(W),g(de.$$.fragment,W),W.forEach(a),Xt=r(e),I=c(e,"DIV",{class:!0});var Q=N(I);g(he.$$.fragment,Q),no=r(Q),Nt=c(Q,"P",{"data-svelte-h":!0}),x(Nt)!=="svelte-vg9yfc"&&(Nt.textContent=Ro),ro=r(Q),g(le.$$.fragment,Q),Q.forEach(a),Et=r(e),J=c(e,"DIV",{class:!0});var K=N(J);g(_e.$$.fragment,K),lo=r(K),Ct=c(K,"P",{"data-svelte-h":!0}),x(Ct)!=="svelte-hrdkoe"&&(Ct.textContent=Go),io=r(K),g(ie.$$.fragment,K),K.forEach(a),Lt=r(e),Z=c(e,"DIV",{class:!0});var rt=N(Z);g(ve.$$.fragment,rt),co=r(rt),Ot=c(rt,"P",{"data-svelte-h":!0}),x(Ot)!=="svelte-i9uyl"&&(Ot.textContent=So),rt.forEach(a),Pt=r(e),g(be.$$.fragment,e),At=r(e),$e=c(e,"P",{"data-svelte-h":!0}),x($e)!=="svelte-psk543"&&($e.textContent=Zo),Bt=r(e),xe=c(e,"UL",{"data-svelte-h":!0}),x(xe)!=="svelte-mua0wr"&&(xe.innerHTML=Ho),Yt=r(e),ke=c(e,"P",{"data-svelte-h":!0}),x(ke)!=="svelte-1iak8h3"&&(ke.innerHTML=zo),Wt=r(e),g(we.$$.fragment,e),Qt=r(e),g(ye.$$.fragment,e),Kt=r(e),H=c(e,"DIV",{class:!0});var dt=N(H);g(Ne.$$.fragment,dt),po=r(dt),Dt=c(dt,"P",{"data-svelte-h":!0}),x(Dt)!=="svelte-jpahu0"&&(Dt.textContent=Vo),dt.forEach(a),ea=r(e),Ce=c(e,"DIV",{class:!0});var Rt=N(Ce);g(Oe.$$.fragment,Rt),Rt.forEach(a),ta=r(e),g(De.$$.fragment,e),aa=r(e),z=c(e,"DIV",{class:!0});var Oa=N(z);g(je.$$.fragment,Oa),mo=r(Oa),jt=c(Oa,"P",{"data-svelte-h":!0}),x(jt)!=="svelte-993wsc"&&(jt.textContent=Xo),Oa.forEach(a),oa=r(e),Te=c(e,"DIV",{class:!0});var Wo=N(Te);g(Ue.$$.fragment,Wo),Wo.forEach(a),sa=r(e),g(Fe.$$.fragment,e),na=r(e),V=c(e,"DIV",{class:!0});var Da=N(V);g(Me.$$.fragment,Da),go=r(Da),Tt=c(Da,"P",{"data-svelte-h":!0}),x(Tt)!=="svelte-12lz3xe"&&(Tt.textContent=Eo),Da.forEach(a),ra=r(e),qe=c(e,"DIV",{class:!0});var Qo=N(qe);g(Ie.$$.fragment,Qo),Qo.forEach(a),da=r(e),g(Je.$$.fragment,e),la=r(e),X=c(e,"DIV",{class:!0});var ja=N(X);g(Re.$$.fragment,ja),fo=r(ja),Ut=c(ja,"P",{"data-svelte-h":!0}),x(Ut)!=="svelte-1kivgjw"&&(Ut.textContent=Lo),ja.forEach(a),ia=r(e),Ge=c(e,"DIV",{class:!0});var Ko=N(Ge);g(Se.$$.fragment,Ko),Ko.forEach(a),ca=r(e),g(Ze.$$.fragment,e),pa=r(e),E=c(e,"DIV",{class:!0});var Ta=N(E);g(He.$$.fragment,Ta),uo=r(Ta),Ft=c(Ta,"P",{"data-svelte-h":!0}),x(Ft)!=="svelte-1ah41nl"&&(Ft.textContent=Po),Ta.forEach(a),ma=r(e),ze=c(e,"DIV",{class:!0});var es=N(ze);g(Ve.$$.fragment,es),es.forEach(a),ga=r(e),g(Xe.$$.fragment,e),fa=r(e),L=c(e,"DIV",{class:!0});var Ua=N(L);g(Ee.$$.fragment,Ua),ho=r(Ua),Mt=c(Ua,"P",{"data-svelte-h":!0}),x(Mt)!=="svelte-18rutfs"&&(Mt.textContent=Ao),Ua.forEach(a),ua=r(e),Le=c(e,"DIV",{class:!0});var ts=N(Le);g(Pe.$$.fragment,ts),ts.forEach(a),ha=r(e),g(Ae.$$.fragment,e),_a=r(e),P=c(e,"DIV",{class:!0});var Fa=N(P);g(Be.$$.fragment,Fa),_o=r(Fa),qt=c(Fa,"P",{"data-svelte-h":!0}),x(qt)!=="svelte-myiztp"&&(qt.textContent=Bo),Fa.forEach(a),va=r(e),Ye=c(e,"DIV",{class:!0});var as=N(Ye);g(We.$$.fragment,as),as.forEach(a),ba=r(e),g(Qe.$$.fragment,e),$a=r(e),A=c(e,"DIV",{class:!0});var Ma=N(A);g(Ke.$$.fragment,Ma),vo=r(Ma),It=c(Ma,"P",{"data-svelte-h":!0}),x(It)!=="svelte-obgmtg"&&(It.textContent=Yo),Ma.forEach(a),xa=r(e),et=c(e,"DIV",{class:!0});var os=N(et);g(tt.$$.fragment,os),os.forEach(a),ka=r(e),g(at.$$.fragment,e),wa=r(e),ot=c(e,"DIV",{class:!0});var ss=N(ot);g(st.$$.fragment,ss),ss.forEach(a),ya=r(e),g(nt.$$.fragment,e),Na=r(e),Jt=c(e,"P",{}),N(Jt).forEach(a),this.h()},h(){C(d,"name","hf:doc:metadata"),C(d,"content",ks),C(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){p(document.head,d),s(e,k,o),s(e,b,o),s(e,l,o),f(v,e,o),s(e,t,o),s(e,$,o),s(e,Gt,o),f(ce,e,o),s(e,St,o),s(e,F,o),f(pe,F,null),p(F,qa),p(F,lt),p(F,Ia),f(ee,F,null),s(e,Zt,o),s(e,w,o),f(me,w,null),p(w,Ja),p(w,it),p(w,Ra),p(w,ct),p(w,Ga),p(w,pt),p(w,Sa),p(w,mt),p(w,Za),p(w,gt),p(w,Ha),p(w,ft),p(w,za),p(w,ut),p(w,Va),p(w,ht),p(w,Xa),p(w,_t),p(w,Ea),f(te,w,null),p(w,La),f(ae,w,null),p(w,Pa),f(oe,w,null),p(w,Aa),f(se,w,null),s(e,Ht,o),s(e,M,o),f(ge,M,null),p(M,Ba),p(M,vt),p(M,Ya),f(ne,M,null),s(e,zt,o),s(e,j,o),f(fe,j,null),p(j,Wa),p(j,bt),p(j,Qa),p(j,$t),p(j,Ka),p(j,xt),p(j,eo),p(j,kt),p(j,to),p(j,wt),p(j,ao),f(re,j,null),s(e,Vt,o),s(e,q,o),f(ue,q,null),p(q,oo),p(q,yt),p(q,so),f(de,q,null),s(e,Xt,o),s(e,I,o),f(he,I,null),p(I,no),p(I,Nt),p(I,ro),f(le,I,null),s(e,Et,o),s(e,J,o),f(_e,J,null),p(J,lo),p(J,Ct),p(J,io),f(ie,J,null),s(e,Lt,o),s(e,Z,o),f(ve,Z,null),p(Z,co),p(Z,Ot),s(e,Pt,o),f(be,e,o),s(e,At,o),s(e,$e,o),s(e,Bt,o),s(e,xe,o),s(e,Yt,o),s(e,ke,o),s(e,Wt,o),f(we,e,o),s(e,Qt,o),f(ye,e,o),s(e,Kt,o),s(e,H,o),f(Ne,H,null),p(H,po),p(H,Dt),s(e,ea,o),s(e,Ce,o),f(Oe,Ce,null),s(e,ta,o),f(De,e,o),s(e,aa,o),s(e,z,o),f(je,z,null),p(z,mo),p(z,jt),s(e,oa,o),s(e,Te,o),f(Ue,Te,null),s(e,sa,o),f(Fe,e,o),s(e,na,o),s(e,V,o),f(Me,V,null),p(V,go),p(V,Tt),s(e,ra,o),s(e,qe,o),f(Ie,qe,null),s(e,da,o),f(Je,e,o),s(e,la,o),s(e,X,o),f(Re,X,null),p(X,fo),p(X,Ut),s(e,ia,o),s(e,Ge,o),f(Se,Ge,null),s(e,ca,o),f(Ze,e,o),s(e,pa,o),s(e,E,o),f(He,E,null),p(E,uo),p(E,Ft),s(e,ma,o),s(e,ze,o),f(Ve,ze,null),s(e,ga,o),f(Xe,e,o),s(e,fa,o),s(e,L,o),f(Ee,L,null),p(L,ho),p(L,Mt),s(e,ua,o),s(e,Le,o),f(Pe,Le,null),s(e,ha,o),f(Ae,e,o),s(e,_a,o),s(e,P,o),f(Be,P,null),p(P,_o),p(P,qt),s(e,va,o),s(e,Ye,o),f(We,Ye,null),s(e,ba,o),f(Qe,e,o),s(e,$a,o),s(e,A,o),f(Ke,A,null),p(A,vo),p(A,It),s(e,xa,o),s(e,et,o),f(tt,et,null),s(e,ka,o),f(at,e,o),s(e,wa,o),s(e,ot,o),f(st,ot,null),s(e,ya,o),f(nt,e,o),s(e,Na,o),s(e,Jt,o),Ca=!0},p(e,[o]){const B={};o&2&&(B.$$scope={dirty:o,ctx:e}),ee.$set(B);const y={};o&2&&(y.$$scope={dirty:o,ctx:e}),te.$set(y);const Y={};o&2&&(Y.$$scope={dirty:o,ctx:e}),ae.$set(Y);const T={};o&2&&(T.$$scope={dirty:o,ctx:e}),oe.$set(T);const W={};o&2&&(W.$$scope={dirty:o,ctx:e}),se.$set(W);const Q={};o&2&&(Q.$$scope={dirty:o,ctx:e}),ne.$set(Q);const K={};o&2&&(K.$$scope={dirty:o,ctx:e}),re.$set(K);const rt={};o&2&&(rt.$$scope={dirty:o,ctx:e}),de.$set(rt);const dt={};o&2&&(dt.$$scope={dirty:o,ctx:e}),le.$set(dt);const Rt={};o&2&&(Rt.$$scope={dirty:o,ctx:e}),ie.$set(Rt)},i(e){Ca||(u(v.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(ee.$$.fragment,e),u(me.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(se.$$.fragment,e),u(ge.$$.fragment,e),u(ne.$$.fragment,e),u(fe.$$.fragment,e),u(re.$$.fragment,e),u(ue.$$.fragment,e),u(de.$$.fragment,e),u(he.$$.fragment,e),u(le.$$.fragment,e),u(_e.$$.fragment,e),u(ie.$$.fragment,e),u(ve.$$.fragment,e),u(be.$$.fragment,e),u(we.$$.fragment,e),u(ye.$$.fragment,e),u(Ne.$$.fragment,e),u(Oe.$$.fragment,e),u(De.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(Fe.$$.fragment,e),u(Me.$$.fragment,e),u(Ie.$$.fragment,e),u(Je.$$.fragment,e),u(Re.$$.fragment,e),u(Se.$$.fragment,e),u(Ze.$$.fragment,e),u(He.$$.fragment,e),u(Ve.$$.fragment,e),u(Xe.$$.fragment,e),u(Ee.$$.fragment,e),u(Pe.$$.fragment,e),u(Ae.$$.fragment,e),u(Be.$$.fragment,e),u(We.$$.fragment,e),u(Qe.$$.fragment,e),u(Ke.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(st.$$.fragment,e),u(nt.$$.fragment,e),Ca=!0)},o(e){h(v.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(ee.$$.fragment,e),h(me.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(se.$$.fragment,e),h(ge.$$.fragment,e),h(ne.$$.fragment,e),h(fe.$$.fragment,e),h(re.$$.fragment,e),h(ue.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),h(le.$$.fragment,e),h(_e.$$.fragment,e),h(ie.$$.fragment,e),h(ve.$$.fragment,e),h(be.$$.fragment,e),h(we.$$.fragment,e),h(ye.$$.fragment,e),h(Ne.$$.fragment,e),h(Oe.$$.fragment,e),h(De.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h(Fe.$$.fragment,e),h(Me.$$.fragment,e),h(Ie.$$.fragment,e),h(Je.$$.fragment,e),h(Re.$$.fragment,e),h(Se.$$.fragment,e),h(Ze.$$.fragment,e),h(He.$$.fragment,e),h(Ve.$$.fragment,e),h(Xe.$$.fragment,e),h(Ee.$$.fragment,e),h(Pe.$$.fragment,e),h(Ae.$$.fragment,e),h(Be.$$.fragment,e),h(We.$$.fragment,e),h(Qe.$$.fragment,e),h(Ke.$$.fragment,e),h(tt.$$.fragment,e),h(at.$$.fragment,e),h(st.$$.fragment,e),h(nt.$$.fragment,e),Ca=!1},d(e){e&&(a(k),a(b),a(l),a(t),a($),a(Gt),a(St),a(F),a(Zt),a(w),a(Ht),a(M),a(zt),a(j),a(Vt),a(q),a(Xt),a(I),a(Et),a(J),a(Lt),a(Z),a(Pt),a(At),a($e),a(Bt),a(xe),a(Yt),a(ke),a(Wt),a(Qt),a(Kt),a(H),a(ea),a(Ce),a(ta),a(aa),a(z),a(oa),a(Te),a(sa),a(na),a(V),a(ra),a(qe),a(da),a(la),a(X),a(ia),a(Ge),a(ca),a(pa),a(E),a(ma),a(ze),a(ga),a(fa),a(L),a(ua),a(Le),a(ha),a(_a),a(P),a(va),a(Ye),a(ba),a($a),a(A),a(xa),a(et),a(ka),a(wa),a(ot),a(ya),a(Na),a(Jt)),a(d),_(v,e),_(ce,e),_(pe),_(ee),_(me),_(te),_(ae),_(oe),_(se),_(ge),_(ne),_(fe),_(re),_(ue),_(de),_(he),_(le),_(_e),_(ie),_(ve),_(be,e),_(we,e),_(ye,e),_(Ne),_(Oe),_(De,e),_(je),_(Ue),_(Fe,e),_(Me),_(Ie),_(Je,e),_(Re),_(Se),_(Ze,e),_(He),_(Ve),_(Xe,e),_(Ee),_(Pe),_(Ae,e),_(Be),_(We),_(Qe,e),_(Ke),_(tt),_(at,e),_(st),_(nt,e)}}}const ks='{"title":"Loading methods","local":"loading-methods","sections":[{"title":"Datasets","local":"datasets.list_datasets","sections":[],"depth":2},{"title":"From files","local":"from-files","sections":[{"title":"Text","local":"datasets.packaged_modules.text.TextConfig","sections":[],"depth":3},{"title":"CSV","local":"datasets.packaged_modules.csv.CsvConfig","sections":[],"depth":3},{"title":"JSON","local":"datasets.packaged_modules.json.JsonConfig","sections":[],"depth":3},{"title":"Parquet","local":"datasets.packaged_modules.parquet.ParquetConfig","sections":[],"depth":3},{"title":"Arrow","local":"datasets.packaged_modules.arrow.ArrowConfig","sections":[],"depth":3},{"title":"SQL","local":"datasets.packaged_modules.sql.SqlConfig","sections":[],"depth":3},{"title":"Images","local":"datasets.packaged_modules.imagefolder.ImageFolderConfig","sections":[],"depth":3},{"title":"Audio","local":"datasets.packaged_modules.audiofolder.AudioFolderConfig","sections":[],"depth":3},{"title":"WebDataset","local":"datasets.packaged_modules.webdataset.WebDataset","sections":[],"depth":3}],"depth":2}],"depth":1}';function ws(D){return rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ts extends ds{constructor(d){super(),ls(this,d,ws,xs,ns,{})}}export{Ts as component};
