import{s as Nr,o as Ir,n as C}from"../chunks/scheduler.bdbef820.js";import{S as Xr,i as Zr,g as c,s as o,r as f,A as Br,h as p,f as i,c as r,j as M,u as h,x as v,k,y as n,a as u,v as _,d as b,t as $,w as x}from"../chunks/index.c0aea24a.js";import{D as T}from"../chunks/Docstring.20f7ed2e.js";import{C as U}from"../chunks/CodeBlock.6ccca92e.js";import{E as J}from"../chunks/ExampleCodeBlock.da027134.js";import{H as os,E as Dr}from"../chunks/EditOnGithub.725ee0c1.js";function Fr(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFidWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJ3JvdHRlbl90b21hdG9lcycpJTBBYnVpbGRlci5kb3dubG9hZF9hbmRfcHJlcGFyZSgpJTBBZHMlMjAlM0QlMjBidWlsZGVyLmFzX2RhdGFzZXQoc3BsaXQlM0QndHJhaW4nKSUwQWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare()
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = builder.as_dataset(split=<span class="hljs-string">&#x27;train&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">8530</span>
})`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function zr(y){let a,w="Download and prepare the dataset as Arrow files that can be loaded as a Dataset using <code>builder.as_dataset()</code>:",d,s,l;return s=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFidWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJTIycm90dGVuX3RvbWF0b2VzJTIyKSUwQWJ1aWxkZXIuZG93bmxvYWRfYW5kX3ByZXBhcmUoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare()`,wrap:!1}}),{c(){a=c("p"),a.innerHTML=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-i6fpq7"&&(a.innerHTML=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Vr(y){let a,w="Download and prepare the dataset as sharded Parquet files locally:",d,s,l;return s=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFidWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJTIycm90dGVuX3RvbWF0b2VzJTIyKSUwQWJ1aWxkZXIuZG93bmxvYWRfYW5kX3ByZXBhcmUoJTIyLiUyRm91dHB1dF9kaXIlMjIlMkMlMjBmaWxlX2Zvcm1hdCUzRCUyMnBhcnF1ZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(<span class="hljs-string">&quot;./output_dir&quot;</span>, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-1035kd7"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Sr(y){let a,w="Download and prepare the dataset as sharded Parquet files in a cloud storage:",d,s,l;return s=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFzdG9yYWdlX29wdGlvbnMlMjAlM0QlMjAlN0IlMjJrZXklMjIlM0ElMjBhd3NfYWNjZXNzX2tleV9pZCUyQyUyMCUyMnNlY3JldCUyMiUzQSUyMGF3c19zZWNyZXRfYWNjZXNzX2tleSU3RCUwQWJ1aWxkZXIlMjAlM0QlMjBsb2FkX2RhdGFzZXRfYnVpbGRlciglMjJyb3R0ZW5fdG9tYXRvZXMlMjIpJTBBYnVpbGRlci5kb3dubG9hZF9hbmRfcHJlcGFyZSglMjJzMyUzQSUyRiUyRm15LWJ1Y2tldCUyRm15X3JvdHRlbl90b21hdG9lcyUyMiUyQyUyMHN0b3JhZ2Vfb3B0aW9ucyUzRHN0b3JhZ2Vfb3B0aW9ucyUyQyUyMGZpbGVfZm9ybWF0JTNEJTIycGFycXVldCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;key&quot;</span>: aws_access_key_id, <span class="hljs-string">&quot;secret&quot;</span>: aws_secret_access_key}
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(<span class="hljs-string">&quot;s3://my-bucket/my_rotten_tomatoes&quot;</span>, storage_options=storage_options, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-y7m7rz"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Er(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFkc19idWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJ3JvdHRlbl90b21hdG9lcycpJTBBZHNfYnVpbGRlci5nZXRfYWxsX2V4cG9ydGVkX2RhdGFzZXRfaW5mb3MoKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder = load_dataset_builder(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder.get_all_exported_dataset_infos()
{<span class="hljs-string">&#x27;default&#x27;</span>: DatasetInfo(description=<span class="hljs-string">&quot;Movie Review Dataset.
a dataset of containing 5,331 positive and 5,331 negative processed
s from Rotten Tomatoes movie reviews. This data was first used in Bo
 Lillian Lee, \`\`Seeing stars: Exploiting class relationships for
t categorization with respect to rating scales.&#x27;&#x27;, Proceedings of the
5.
ion=&#x27;@InProceedings{Pang+Lee:05a,
 =       {Bo Pang and Lillian Lee},
=        {Seeing stars: Exploiting class relationships for sentiment
          categorization with respect to rating scales},
tle =    {Proceedings of the ACL},
         2005

age=&#x27;http://www.cs.cornell.edu/people/pabo/movie-review-data/&#x27;, license=&#x27;&#x27;, features={&#x27;text&#x27;: Value(dtype=&#x27;string&#x27;, id=None), &#x27;label&#x27;: ClassLabel(num_classes=2, names=[&#x27;neg&#x27;, &#x27;pos&#x27;], id=None)}, post_processed=None, supervised_keys=SupervisedKeysData(input=&#x27;&#x27;, output=&#x27;&#x27;), task_templates=[TextClassification(task=&#x27;text-classification&#x27;, text_column=&#x27;text&#x27;, label_column=&#x27;label&#x27;)], builder_name=&#x27;rotten_tomatoes_movie_review&#x27;, config_name=&#x27;default&#x27;, version=1.0.0, splits={&#x27;train&#x27;: SplitInfo(name=&#x27;train&#x27;, num_bytes=1074810, num_examples=8530, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;validation&#x27;: SplitInfo(name=&#x27;validation&#x27;, num_bytes=134679, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;test&#x27;: SplitInfo(name=&#x27;test&#x27;, num_bytes=135972, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;)}, download_checksums={&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;: {&#x27;num_bytes&#x27;: 487770, &#x27;checksum&#x27;: &#x27;a05befe52aafda71d458d188a1c54506a998b1308613ba76bbda2e5029409ce9&#x27;}}, download_size=487770, post_processing_size=None, dataset_size=1345461, size_in_bytes=1833231)}</span>`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Lr(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFkc19idWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJ3JvdHRlbl90b21hdG9lcycpJTBBZHNfYnVpbGRlci5nZXRfZXhwb3J0ZWRfZGF0YXNldF9pbmZvKCklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder = load_dataset_builder(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder.get_exported_dataset_info()
DatasetInfo(description=<span class="hljs-string">&quot;Movie Review Dataset.
a dataset of containing 5,331 positive and 5,331 negative processed
s from Rotten Tomatoes movie reviews. This data was first used in Bo
 Lillian Lee, \`\`Seeing stars: Exploiting class relationships for
t categorization with respect to rating scales.&#x27;&#x27;, Proceedings of the
5.
ion=&#x27;@InProceedings{Pang+Lee:05a,
 =       {Bo Pang and Lillian Lee},
=        {Seeing stars: Exploiting class relationships for sentiment
          categorization with respect to rating scales},
tle =    {Proceedings of the ACL},
         2005

age=&#x27;http://www.cs.cornell.edu/people/pabo/movie-review-data/&#x27;, license=&#x27;&#x27;, features={&#x27;text&#x27;: Value(dtype=&#x27;string&#x27;, id=None), &#x27;label&#x27;: ClassLabel(num_classes=2, names=[&#x27;neg&#x27;, &#x27;pos&#x27;], id=None)}, post_processed=None, supervised_keys=SupervisedKeysData(input=&#x27;&#x27;, output=&#x27;&#x27;), task_templates=[TextClassification(task=&#x27;text-classification&#x27;, text_column=&#x27;text&#x27;, label_column=&#x27;label&#x27;)], builder_name=&#x27;rotten_tomatoes_movie_review&#x27;, config_name=&#x27;default&#x27;, version=1.0.0, splits={&#x27;train&#x27;: SplitInfo(name=&#x27;train&#x27;, num_bytes=1074810, num_examples=8530, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;validation&#x27;: SplitInfo(name=&#x27;validation&#x27;, num_bytes=134679, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;test&#x27;: SplitInfo(name=&#x27;test&#x27;, num_bytes=135972, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;)}, download_checksums={&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;: {&#x27;num_bytes&#x27;: 487770, &#x27;checksum&#x27;: &#x27;a05befe52aafda71d458d188a1c54506a998b1308613ba76bbda2e5029409ce9&#x27;}}, download_size=487770, post_processing_size=None, dataset_size=1345461, size_in_bytes=1833231)</span>`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Qr(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Yr(y){let a,w="Is roughly equivalent to:",d,s,l;return s=new U({props:{code:"ZXh0cmFjdGVkX3BhdGhzJTIwJTNEJTIwZGxfbWFuYWdlci5leHRyYWN0KGRsX21hbmFnZXIuZG93bmxvYWQodXJsX29yX3VybHMpKQ==",highlighted:'<span class="hljs-attr">extracted_paths</span> = dl_manager.extract(dl_manager.download(url_or_urls))',wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-yva38v"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Wr(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWRfY3VzdG9tKCdzMyUzQSUyRiUyRm15LWJ1Y2tldCUyRmRhdGEuemlwJyUyQyUyMGN1c3RvbV9kb3dubG9hZF9mb3JfbXlfcHJpdmF0ZV9idWNrZXQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download_custom(<span class="hljs-string">&#x27;s3://my-bucket/data.zip&#x27;</span>, custom_download_for_my_private_bucket)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Hr(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZXh0cmFjdGVkX2ZpbGVzJTIwJTNEJTIwZGxfbWFuYWdlci5leHRyYWN0KGRvd25sb2FkZWRfZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>extracted_files = dl_manager.extract(downloaded_files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Pr(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"YXJjaGl2ZSUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfYXJjaGl2ZShhcmNoaXZlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>archive = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_archive(archive)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Ar(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"ZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZF9leHRyYWN0KCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZiZWFucyUyRnJlc29sdmUlMkZtYWluJTJGZGF0YSUyRnRyYWluLnppcCcpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfZmlsZXMoZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.download_and_extract(<span class="hljs-string">&#x27;https://huggingface.co/datasets/beans/resolve/main/data/train.zip&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_files(files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function qr(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Or(y){let a,w="Is equivalent to:",d,s,l;return s=new U({props:{code:"dXJscyUyMCUzRCUyMGRsX21hbmFnZXIuZXh0cmFjdChkbF9tYW5hZ2VyLmRvd25sb2FkKHVybF9vcl91cmxzKSk=",highlighted:'<span class="hljs-attribute">urls</span> <span class="hljs-operator">=</span> dl_manager.extract(dl_manager.download(url_or_urls))',wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-b0lbw9"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function Kr(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZXh0cmFjdGVkX2ZpbGVzJTIwJTNEJTIwZGxfbWFuYWdlci5leHRyYWN0KGRvd25sb2FkZWRfZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>extracted_files = dl_manager.extract(downloaded_files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function el(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"YXJjaGl2ZSUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfYXJjaGl2ZShhcmNoaXZlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>archive = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_archive(archive)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function tl(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"ZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZF9leHRyYWN0KCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZiZWFucyUyRnJlc29sdmUlMkZtYWluJTJGZGF0YSUyRnRyYWluLnppcCcpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfZmlsZXMoZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.download_and_extract(<span class="hljs-string">&#x27;https://huggingface.co/datasets/beans/resolve/main/data/train.zip&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_files(files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function al(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"ZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRGRhdGFzZXRzLlNwbGl0LlRSQUlOJTJDJTBBJTIwJTIwJTIwJTIwZ2VuX2t3YXJncyUzRCU3QiUyMnNwbGl0X2tleSUyMiUzQSUyMCUyMnRyYWluJTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZF9leHRyYWN0KHVybCklN0QlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.TRAIN,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and_extract(url)},
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function sl(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"ZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRGRhdGFzZXRzLlNwbGl0LlRSQUlOJTJDJTBBJTIwJTIwJTIwJTIwZ2VuX2t3YXJncyUzRCU3QiUyMnNwbGl0X2tleSUyMiUzQSUyMCUyMnRyYWluJTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZCUyMGV4dHJhY3QodXJsKSU3RCUyQyUwQSklMkMlMEFkYXRhc2V0cy5TcGxpdEdlbmVyYXRvciglMEElMjAlMjAlMjAlMjBuYW1lJTNEZGF0YXNldHMuU3BsaXQuVkFMSURBVElPTiUyQyUwQSUyMCUyMCUyMCUyMGdlbl9rd2FyZ3MlM0QlN0IlMjJzcGxpdF9rZXklMjIlM0ElMjAlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZCUyMGV4dHJhY3QodXJsKSU3RCUyQyUwQSklMkMlMEFkYXRhc2V0cy5TcGxpdEdlbmVyYXRvciglMEElMjAlMjAlMjAlMjBuYW1lJTNEZGF0YXNldHMuU3BsaXQuVEVTVCUyQyUwQSUyMCUyMCUyMCUyMGdlbl9rd2FyZ3MlM0QlN0IlMjJzcGxpdF9rZXklMjIlM0ElMjAlMjJ0ZXN0JTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZCUyMGV4dHJhY3QodXJsKSU3RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.TRAIN,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and extract(url)},
<span class="hljs-meta">... </span>),
<span class="hljs-meta">... </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.VALIDATION,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;validation&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and extract(url)},
<span class="hljs-meta">... </span>),
<span class="hljs-meta">... </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.TEST,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;test&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and extract(url)},
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function nl(y){let a,w="Each descriptor can be composed with other using addition or slice:",d,s,l;return s=new U({props:{code:"c3BsaXQlMjAlM0QlMjBkYXRhc2V0cy5TcGxpdC5UUkFJTi5zdWJzcGxpdChkYXRhc2V0cy5wZXJjZW50JTVCMCUzQTI1JTVEKSUyMCUyQiUyMGRhdGFzZXRzLlNwbGl0LlRFU1Q=",highlighted:'split = datasets.Split.TRAIN.subsplit(datasets.percent[<span class="hljs-number">0</span>:<span class="hljs-number">25</span>]) + datasets.Split.TEST',wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-in376m"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function ol(y){let a,w="A split cannot be added twice, so the following will fail:",d,s,l;return s=new U({props:{code:"c3BsaXQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXQuVFJBSU4uc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTI1JTVEKSUyMCUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRzLlNwbGl0LlRSQUlOLnN1YnNwbGl0KGRhdGFzZXRzLnBlcmNlbnQlNUI3NSUzQSU1RCklMEEpJTIwJTIwJTIzJTIwRXJyb3IlMEFzcGxpdCUyMCUzRCUyMGRhdGFzZXRzLlNwbGl0LlRFU1QlMjAlMkIlMjBkYXRhc2V0cy5TcGxpdC5BTEwlMjAlMjAlMjMlMjBFcnJvcg==",highlighted:`split = (
        datasets.Split.TRAIN.subsplit(datasets.percent[:<span class="hljs-number">25</span>]) +
        datasets.Split.TRAIN.subsplit(datasets.percent[<span class="hljs-number">75</span>:])
)  <span class="hljs-comment"># Error</span>
split = datasets.Split.TEST + datasets.Split.ALL  <span class="hljs-comment"># Error</span>`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-1dn84z5"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function rl(y){let a,w="The slices can be applied only one time. So the following are valid:",d,s,l;return s=new U({props:{code:"c3BsaXQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXQuVFJBSU4uc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTI1JTVEKSUyMCUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRzLlNwbGl0LlRFU1Quc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTUwJTVEKSUwQSklMEFzcGxpdCUyMCUzRCUyMChkYXRhc2V0cy5TcGxpdC5UUkFJTiUyMCUyQiUyMGRhdGFzZXRzLlNwbGl0LlRFU1QpLnN1YnNwbGl0KGRhdGFzZXRzLnBlcmNlbnQlNUIlM0E1MCU1RCk=",highlighted:`split = (
        datasets.Split.TRAIN.subsplit(datasets.percent[:<span class="hljs-number">25</span>]) +
        datasets.Split.TEST.subsplit(datasets.percent[:<span class="hljs-number">50</span>])
)
split = (datasets.Split.TRAIN + datasets.Split.TEST).subsplit(datasets.percent[:<span class="hljs-number">50</span>])`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-f377rx"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function ll(y){let a,w="But this is not valid:",d,s,l;return s=new U({props:{code:"dHJhaW4lMjAlM0QlMjBkYXRhc2V0cy5TcGxpdC5UUkFJTiUwQXRlc3QlMjAlM0QlMjBkYXRhc2V0cy5TcGxpdC5URVNUJTBBc3BsaXQlMjAlM0QlMjB0cmFpbi5zdWJzcGxpdChkYXRhc2V0cy5wZXJjZW50JTVCJTNBMjUlNUQpLnN1YnNwbGl0KGRhdGFzZXRzLnBlcmNlbnQlNUIlM0EyNSU1RCklMEFzcGxpdCUyMCUzRCUyMCh0cmFpbi5zdWJzcGxpdChkYXRhc2V0cy5wZXJjZW50JTVCJTNBMjUlNUQpJTIwJTJCJTIwdGVzdCkuc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTUwJTVEKQ==",highlighted:`train = datasets.Split.TRAIN
test = datasets.Split.TEST
split = train.subsplit(datasets.percent[:<span class="hljs-number">25</span>]).subsplit(datasets.percent[:<span class="hljs-number">25</span>])
split = (train.subsplit(datasets.percent[:<span class="hljs-number">25</span>]) + test).subsplit(datasets.percent[:<span class="hljs-number">50</span>])`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-1jf0xuu"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function dl(y){let a,w="Examples:",d,s,l;return s=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># The following lines are equivalent:</span>
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=<span class="hljs-string">&#x27;test[:33%]&#x27;</span>)
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction.from_spec(<span class="hljs-string">&#x27;test[:33%]&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction(<span class="hljs-string">&#x27;test&#x27;</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction(
<span class="hljs-string">&#x27;test&#x27;</span>, from_=<span class="hljs-number">0</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>))

<span class="hljs-comment"># The following lines are equivalent:</span>
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=<span class="hljs-string">&#x27;test[:33%]+train[1:-1]&#x27;</span>)
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction.from_spec(
<span class="hljs-string">&#x27;test[:33%]+train[1:-1]&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=(
datasets.ReadInstruction(<span class="hljs-string">&#x27;test&#x27;</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>) +
datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, from_=<span class="hljs-number">1</span>, to=-<span class="hljs-number">1</span>, unit=<span class="hljs-string">&#x27;abs&#x27;</span>)))

<span class="hljs-comment"># The following lines are equivalent:</span>
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=<span class="hljs-string">&#x27;test[:33%](pct1_dropremainder)&#x27;</span>)
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction.from_spec(
<span class="hljs-string">&#x27;test[:33%](pct1_dropremainder)&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction(
<span class="hljs-string">&#x27;test&#x27;</span>, from_=<span class="hljs-number">0</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>, rounding=<span class="hljs-string">&quot;pct1_dropremainder&quot;</span>))

<span class="hljs-comment"># 10-fold validation:</span>
tests = datasets.load_dataset(
<span class="hljs-string">&#x27;mnist&#x27;</span>,
[datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, from_=k, to=k+<span class="hljs-number">10</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>)
<span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-number">100</span>, <span class="hljs-number">10</span>)])
trains = datasets.load_dataset(
<span class="hljs-string">&#x27;mnist&#x27;</span>,
[datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, to=k, unit=<span class="hljs-string">&#x27;%&#x27;</span>) + datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, from_=k+<span class="hljs-number">10</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>)
<span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-number">100</span>, <span class="hljs-number">10</span>)])`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function il(y){let a,w="Examples:",d,s,l;return s=new U({props:{code:"dGVzdCUzQSUyMHRlc3QlMjBzcGxpdC4lMEF0ZXN0JTIwJTJCJTIwdmFsaWRhdGlvbiUzQSUyMHRlc3QlMjBzcGxpdCUyMCUyQiUyMHZhbGlkYXRpb24lMjBzcGxpdC4lMEF0ZXN0JTVCMTAlM0ElNUQlM0ElMjB0ZXN0JTIwc3BsaXQlMkMlMjBtaW51cyUyMGl0cyUyMGZpcnN0JTIwMTAlMjByZWNvcmRzLiUwQXRlc3QlNUIlM0ExMCUyNSU1RCUzQSUyMGZpcnN0JTIwMTAlMjUlMjByZWNvcmRzJTIwb2YlMjB0ZXN0JTIwc3BsaXQuJTBBdGVzdCU1QiUzQTIwJTI1JTVEKHBjdDFfZHJvcHJlbWFpbmRlciklM0ElMjBmaXJzdCUyMDEwJTI1JTIwcmVjb3JkcyUyQyUyMHJvdW5kZWQlMjB3aXRoJTIwdGhlJTIwcGN0MV9kcm9wcmVtYWluZGVyJTIwcm91bmRpbmcuJTBBdGVzdCU1QiUzQS01JTI1JTVEJTJCdHJhaW4lNUI0MCUyNSUzQTYwJTI1JTVEJTNBJTIwZmlyc3QlMjA5NSUyNSUyMG9mJTIwdGVzdCUyMCUyQiUyMG1pZGRsZSUyMDIwJTI1JTIwb2YlMjB0cmFpbi4=",highlighted:`<span class="hljs-keyword">test: test</span> split.
<span class="hljs-keyword">test </span>+ validation: test split + validation split.
test[10:]: test split, minus its first 10 records.
test[:10%]: first 10% records of test split.
test[:20%](pct1_dropremainder): first 10% records, rounded with the pct1_dropremainder rounding.
test[:<span class="hljs-string">-5</span>%]+train[40%:60%]: first 95% of test + middle 20% of train.`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function cl(y){let a,w="Example:",d,s,l;return s=new U({props:{code:"VkVSU0lPTiUyMCUzRCUyMGRhdGFzZXRzLlZlcnNpb24oJTIyMS4wLjAlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>VERSION = datasets.Version(<span class="hljs-string">&quot;1.0.0&quot;</span>)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,d=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),d=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,d,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(i(a),i(d)),x(s,e)}}}function pl(y){let a,w,d,s,l,e,m,ls,it,Co='🤗 Datasets relies on two main classes during the dataset building process: <a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DatasetBuilder">DatasetBuilder</a> and <a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a>.',ds,R,ct,js,Ot,Uo="Abstract base class for all datasets.",Gs,Kt,Ro="<code>DatasetBuilder</code> has 3 key methods:",Ns,ea,jo=`<li><code>DatasetBuilder.info</code>: Documents the dataset, including feature
names, types, shapes, version, splits, citation, etc.</li> <li><a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DatasetBuilder.download_and_prepare">DatasetBuilder.download_and_prepare()</a>: Downloads the source data
and writes it to disk.</li> <li><a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DatasetBuilder.as_dataset">DatasetBuilder.as_dataset()</a>: Generates a <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Dataset">Dataset</a>.</li>`,Is,ta,Go=`Some <code>DatasetBuilder</code>s expose multiple variants of the
dataset by defining a <a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> subclass and accepting a
config object (or name) on construction. Configurable datasets expose a
pre-defined set of configurations in <code>DatasetBuilder.builder_configs()</code>.`,Xs,re,pt,Zs,aa,No="Return a Dataset for the specified split.",Bs,Xe,Ds,D,mt,Fs,sa,Io="Downloads and prepares dataset for reading.",zs,na,Xo="Example:",Vs,Ze,Ss,Be,Es,De,Ls,le,gt,Qs,oa,Zo="Empty dict if doesn’t exist",Ys,Fe,Ws,de,ut,Hs,ra,Bo="Empty <code>DatasetInfo</code> if doesn’t exist",Ps,ze,As,Ve,ft,qs,la,Do="Return the path of the module of this class or subclass.",is,K,ht,Os,da,Fo="Base class for datasets with data generation based on dict generators.",Ks,ia,zo=`<code>GeneratorBasedBuilder</code> is a convenience class that abstracts away much
of the data writing and reading of <code>DatasetBuilder</code>. It expects subclasses to
implement generators of feature dictionaries across the dataset splits
(<code>_split_generators</code>). See the method docstrings for details.`,cs,xe,_t,en,ca,Vo="Base class for datasets with data generation based on Arrow loading functions (CSV/JSON/Parquet).",ps,Q,bt,tn,pa,So="Base class for <code>DatasetBuilder</code> data configuration.",an,ma,Eo=`<code>DatasetBuilder</code> subclasses with data configuration options should subclass
<code>BuilderConfig</code> and add their own properties.`,sn,P,$t,nn,ga,Lo=`The config id is used to build the cache directory.
By default it is equal to the config name.
However the name of a config is not sufficient to have a unique identifier for the dataset being generated
since it doesn’t take into account:`,on,ua,Qo="<li>the config kwargs that can be used to overwrite attributes</li> <li>the custom features used to write the dataset</li> <li>the data_files for json/text/csv/pandas datasets</li>",rn,fa,Yo="Therefore the config id is just the config name with an optional suffix based on these.",ms,xt,gs,N,vt,ln,A,wt,dn,ha,Wo="Download given URL(s).",cn,_a,Ho="By default, only one process is used for download. Pass customized <code>download_config.num_proc</code> to change this behavior.",pn,Se,mn,ie,yt,gn,ba,Po="Download and extract given <code>url_or_urls</code>.",un,Ee,fn,ce,Mt,hn,$a,Ao="Download given urls(s) by calling <code>custom_download</code>.",_n,Le,bn,pe,kt,$n,xa,qo="Extract given path(s).",xn,Qe,vn,me,Tt,wn,va,Oo="Iterate over files within an archive.",yn,Ye,Mn,ge,Jt,kn,wa,Ko="Iterate over file paths.",Tn,We,us,I,Ct,Jn,ya,er=`Download manager that uses the ”::” separator to navigate through (possibly remote) compressed archives.
Contrary to the regular <code>DownloadManager</code>, the <code>download</code> and <code>extract</code> methods don’t actually download nor extract
data, but they rather return the path or url that could be opened using the <code>xopen</code> function which extends the
built-in <code>open</code> function to stream data from remote files.`,Cn,ue,Ut,Un,Ma,tr=`Normalize URL(s) of files to stream data from.
This is the lazy version of <code>DownloadManager.download</code> for streaming.`,Rn,He,jn,q,Rt,Gn,ka,ar="Prepare given <code>url_or_urls</code> for streaming (add extraction protocol).",Nn,Ta,sr="This is the lazy version of <code>DownloadManager.download_and_extract</code> for streaming.",In,Pe,Xn,O,jt,Zn,Ja,nr="Add extraction protocol for given url(s) for streaming.",Bn,Ca,or="This is the lazy version of <code>DownloadManager.extract</code> for streaming.",Dn,Ae,Fn,fe,Gt,zn,Ua,rr="Iterate over files within an archive.",Vn,qe,Sn,he,Nt,En,Ra,lr="Iterate over files.",Ln,Oe,fs,ve,It,Qn,ja,dr="Configuration for our cached path manager.",hs,z,Xt,Yn,Ga,ir="<code>Enum</code> for how to treat pre-existing downloads and data.",Wn,Na,cr=`The default mode is <code>REUSE_DATASET_IF_EXISTS</code>, which will reuse both
raw downloads and the prepared dataset if they exist.`,Hn,Ia,pr="The generations modes:",Pn,Xa,mr="<thead><tr><th></th> <th>Downloads</th> <th>Dataset</th></tr></thead> <tbody><tr><td><code>REUSE_DATASET_IF_EXISTS</code> (default)</td> <td>Reuse</td> <td>Reuse</td></tr> <tr><td><code>REUSE_CACHE_IF_EXISTS</code></td> <td>Reuse</td> <td>Fresh</td></tr> <tr><td><code>FORCE_REDOWNLOAD</code></td> <td>Fresh</td> <td>Fresh</td></tr></tbody>",_s,Zt,bs,V,Bt,An,Za,gr="<code>Enum</code> that specifies which verification checks to run.",qn,Ba,ur=`The default mode is <code>BASIC_CHECKS</code>, which will perform only rudimentary checks to avoid slowdowns
when generating/downloading a dataset for the first time.`,On,Da,fr="The verification modes:",Kn,Fa,hr="<thead><tr><th></th> <th>Verification checks</th></tr></thead> <tbody><tr><td><code>ALL_CHECKS</code></td> <td>Split checks, uniqueness of the keys yielded in case of the GeneratorBuilder</td></tr> <tr><td></td> <td>and the validity (number of files, checksums, etc.) of downloaded files</td></tr> <tr><td><code>BASIC_CHECKS</code> (default)</td> <td>Same as <code>ALL_CHECKS</code> but without checking downloaded files</td></tr> <tr><td><code>NO_CHECKS</code></td> <td>None</td></tr></tbody>",$s,Dt,xs,Y,Ft,eo,za,_r="Defines the split information for the generator.",to,Va,br=`This should be used as returned value of
<code>GeneratorBasedBuilder._split_generators</code>.
See <code>GeneratorBasedBuilder._split_generators</code> for more info and example
of usage.`,ao,Ke,vs,X,zt,so,Sa,$r="<code>Enum</code> for dataset splits.",no,Ea,xr=`Datasets are typically split into different subsets to be used at various
stages of training and evaluation.`,oo,La,vr=`<li><code>TRAIN</code>: the training data.</li> <li><code>VALIDATION</code>: the validation data. If present, this is typically used as
evaluation data while iterating on a model (e.g. changing hyperparameters,
model architecture, etc.).</li> <li><code>TEST</code>: the testing data. This is the data to report metrics on. Typically
you do not want to use this during model iteration as you may overfit to it.</li> <li><code>ALL</code>: the union of all defined dataset splits.</li>`,ro,Qa,wr="All splits, including compositions inherit from <code>datasets.SplitBase</code>.",lo,Ya,yr='See the <a href="../load_hub#splits">guide</a> on splits for more information.',io,et,ws,G,Vt,co,Wa,Mr="Descriptor corresponding to a named split (train, test, …).",po,Ha,kr="Example:",mo,tt,go,Pa,Tr=`The resulting split will correspond to 25% of the train split merged with
100% of the test split.`,uo,at,fo,st,ho,nt,ys,we,St,_o,Aa,Jr="Split corresponding to the union of all defined dataset splits.",Ms,S,Et,bo,qa,Cr="Reading instruction for a dataset.",$o,ot,xo,_e,Lt,vo,Oa,Ur="Creates a <code>ReadInstruction</code> instance out of a string spec.",wo,rt,yo,be,Qt,Mo,Ka,Rr="Translate instruction into a list of absolute instructions.",ko,es,jr="Those absolute instructions are then to be added together.",ks,Yt,Ts,ee,Wt,To,ts,Gr="Dataset version <code>MAJOR.MINOR.PATCH</code>.",Jo,lt,Js,Ht,Cs,rs,Us;return l=new os({props:{title:"Builder classes",local:"builder-classes",headingTag:"h1"}}),m=new os({props:{title:"Builders",local:"datasets.DatasetBuilder",headingTag:"h2"}}),ct=new T({props:{name:"class datasets.DatasetBuilder",anchor:"datasets.DatasetBuilder",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],parametersDescription:[{anchor:"datasets.DatasetBuilder.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Directory to cache data. Defaults to <code>&quot;~/.cache/huggingface/datasets&quot;</code>.`,name:"cache_dir"},{anchor:"datasets.DatasetBuilder.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the dataset, if different from the builder name. Useful for packaged builders
like csv, imagefolder, audiofolder, etc. to reflect the difference between datasets
that use the same packaged builder.`,name:"dataset_name"},{anchor:"datasets.DatasetBuilder.config_name",description:`<strong>config_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the dataset configuration.
It affects the data generated on disk. Different configurations will have their own subdirectories and
versions.
If not provided, the default configuration is used (if it exists).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.3.0</p>
						
<p>Parameter <code>name</code> was renamed to <code>config_name</code>.</p>

					</div>`,name:"config_name"},{anchor:"datasets.DatasetBuilder.hash",description:`<strong>hash</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Hash specific to the dataset code. Used to update the caching directory when the
dataset loading script code is updated (to avoid reusing old data).
The typical caching directory (defined in <code>self._relative_data_dir</code>) is <code>name/version/hash/</code>.`,name:"hash"},{anchor:"datasets.DatasetBuilder.base_path",description:`<strong>base_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Base path for relative paths that are used to download files.
This can be a remote URL.`,name:"base_path"},{anchor:"datasets.DatasetBuilder.features",description:`<strong>features</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Features">Features</a>, <em>optional</em>) &#x2014;
Features types to use with this dataset.
It can be used to change the <a href="/docs/datasets/pr_7043/en/package_reference/main_classes#datasets.Features">Features</a> types of a dataset, for example.`,name:"features"},{anchor:"datasets.DatasetBuilder.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
String or boolean to use as Bearer token for remote files on the
Datasets Hub. If <code>True</code>, will get token from <code>&quot;~/.huggingface&quot;</code>.`,name:"token"},{anchor:"datasets.DatasetBuilder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of the dataset repository.
Used to distinguish builders with the same name but not coming from the same namespace, for example &#x201C;squad&#x201D;
and &#x201C;lhoestq/squad&#x201D; repo IDs. In the latter, the builder name would be &#x201C;lhoestq___squad&#x201D;.`,name:"repo_id"},{anchor:"datasets.DatasetBuilder.data_files",description:`<strong>data_files</strong> (<code>str</code> or <code>Sequence</code> or <code>Mapping</code>, <em>optional</em>) &#x2014;
Path(s) to source data file(s).
For builders like &#x201C;csv&#x201D; or &#x201C;json&#x201D; that need the user to specify data files. They can be either
local or remote files. For convenience, you can use a <code>DataFilesDict</code>.`,name:"data_files"},{anchor:"datasets.DatasetBuilder.data_dir",description:`<strong>data_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to directory containing source data file(s).
Use only if <code>data_files</code> is not passed, in which case it is equivalent to passing
<code>os.path.join(data_dir, &quot;**&quot;)</code> as <code>data_files</code>.
For builders that require manual download, it must be the path to the local directory containing the
manually downloaded data.`,name:"data_dir"},{anchor:"datasets.DatasetBuilder.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Key/value pairs to be passed on to the dataset file-system backend, if any.`,name:"storage_options"},{anchor:"datasets.DatasetBuilder.writer_batch_size",description:`<strong>writer_batch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Batch size used by the ArrowWriter.
It defines the number of samples that are kept in memory before writing them
and also the length of the arrow chunks.
None means that the ArrowWriter will use its default value.`,name:"writer_batch_size"},{anchor:"datasets.DatasetBuilder.name",description:`<strong>name</strong> (<code>str</code>) &#x2014; Configuration name for the dataset.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.3.0</p>
						
<p>Use <code>config_name</code> instead.</p>

					</div>`,name:"name"},{anchor:"datasets.DatasetBuilder.*config_kwargs",description:`*<strong>*config_kwargs</strong> (additional keyword arguments) &#x2014; Keyword arguments to be passed to the corresponding builder
configuration class, set on the class attribute <a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.BuilderConfig">DatasetBuilder.BUILDER_CONFIG_CLASS</a>. The builder
configuration class is <a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> or a subclass of it.`,name:"*config_kwargs"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/builder.py#L214"}}),pt=new T({props:{name:"as_dataset",anchor:"datasets.DatasetBuilder.as_dataset",parameters:[{name:"split",val:": Optional = None"},{name:"run_post_process",val:" = True"},{name:"verification_mode",val:": Union = None"},{name:"ignore_verifications",val:" = 'deprecated'"},{name:"in_memory",val:" = False"}],parametersDescription:[{anchor:"datasets.DatasetBuilder.as_dataset.split",description:`<strong>split</strong> (<code>datasets.Split</code>) &#x2014;
Which subset of the data to return.`,name:"split"},{anchor:"datasets.DatasetBuilder.as_dataset.run_post_process",description:`<strong>run_post_process</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to run post-processing dataset transforms and/or add
indexes.`,name:"run_post_process"},{anchor:"datasets.DatasetBuilder.as_dataset.verification_mode",description:`<strong>verification_mode</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.VerificationMode">VerificationMode</a> or <code>str</code>, defaults to <code>BASIC_CHECKS</code>) &#x2014;
Verification mode determining the checks to run on the
downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.9.1</p>
						
					</div>`,name:"verification_mode"},{anchor:"datasets.DatasetBuilder.as_dataset.ignore_verifications",description:`<strong>ignore_verifications</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to ignore the verifications of the
downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.9.1</p>
						
<p><code>ignore_verifications</code> was deprecated in version 2.9.1 and will be removed in 3.0.0.
Please use <code>verification_mode</code> instead.</p>

					</div>`,name:"ignore_verifications"},{anchor:"datasets.DatasetBuilder.as_dataset.in_memory",description:`<strong>in_memory</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to copy the data in-memory.`,name:"in_memory"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/builder.py#L1188",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>datasets.Dataset</p>
`}}),Xe=new J({props:{anchor:"datasets.DatasetBuilder.as_dataset.example",$$slots:{default:[Fr]},$$scope:{ctx:y}}}),mt=new T({props:{name:"download_and_prepare",anchor:"datasets.DatasetBuilder.download_and_prepare",parameters:[{name:"output_dir",val:": Optional = None"},{name:"download_config",val:": Optional = None"},{name:"download_mode",val:": Union = None"},{name:"verification_mode",val:": Union = None"},{name:"ignore_verifications",val:" = 'deprecated'"},{name:"try_from_hf_gcs",val:" = 'deprecated'"},{name:"dl_manager",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"file_format",val:": str = 'arrow'"},{name:"max_shard_size",val:": Union = None"},{name:"num_proc",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"**download_and_prepare_kwargs",val:""}],parametersDescription:[{anchor:"datasets.DatasetBuilder.download_and_prepare.output_dir",description:`<strong>output_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Output directory for the dataset.
Default to this builder&#x2019;s <code>cache_dir</code>, which is inside <code>~/.cache/huggingface/datasets</code> by default.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"output_dir"},{anchor:"datasets.DatasetBuilder.download_and_prepare.download_config",description:`<strong>download_config</strong> (<code>DownloadConfig</code>, <em>optional</em>) &#x2014;
Specific download configuration parameters.`,name:"download_config"},{anchor:"datasets.DatasetBuilder.download_and_prepare.download_mode",description:`<strong>download_mode</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.DownloadMode">DownloadMode</a> or <code>str</code>, <em>optional</em>) &#x2014;
Select the download/generate mode, default to <code>REUSE_DATASET_IF_EXISTS</code>.`,name:"download_mode"},{anchor:"datasets.DatasetBuilder.download_and_prepare.verification_mode",description:`<strong>verification_mode</strong> (<a href="/docs/datasets/pr_7043/en/package_reference/builder_classes#datasets.VerificationMode">VerificationMode</a> or <code>str</code>, defaults to <code>BASIC_CHECKS</code>) &#x2014;
Verification mode determining the checks to run on the downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.9.1</p>
						
					</div>`,name:"verification_mode"},{anchor:"datasets.DatasetBuilder.download_and_prepare.ignore_verifications",description:`<strong>ignore_verifications</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Ignore the verifications of the downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.9.1</p>
						
<p><code>ignore_verifications</code> was deprecated in version 2.9.1 and will be removed in 3.0.0.
Please use <code>verification_mode</code> instead.</p>

					</div>`,name:"ignore_verifications"},{anchor:"datasets.DatasetBuilder.download_and_prepare.try_from_hf_gcs",description:`<strong>try_from_hf_gcs</strong> (<code>bool</code>) &#x2014;
If <code>True</code>, it will try to download the already prepared dataset from the HF Google cloud storage.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.16.0</p>
						
<p><code>try_from_hf_gcs</code> was deprecated in version 2.16.0 and will be removed in 3.0.0.
Host the processed files on the Hugging Face Hub instead.</p>

					</div>`,name:"try_from_hf_gcs"},{anchor:"datasets.DatasetBuilder.download_and_prepare.dl_manager",description:`<strong>dl_manager</strong> (<code>DownloadManager</code>, <em>optional</em>) &#x2014;
Specific <code>DownloadManger</code> to use.`,name:"dl_manager"},{anchor:"datasets.DatasetBuilder.download_and_prepare.base_path",description:`<strong>base_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Base path for relative paths that are used to download files. This can be a remote url.
If not specified, the value of the <code>base_path</code> attribute (<code>self.base_path</code>) will be used instead.`,name:"base_path"},{anchor:"datasets.DatasetBuilder.download_and_prepare.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Union[str, bool]</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token for remote files on the Datasets Hub.
If True, or not specified, will get token from ~/.huggingface.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.7.1</p>
						
<p>Pass <code>use_auth_token</code> to <code>load_dataset_builder</code> instead.</p>

					</div>`,name:"use_auth_token"},{anchor:"datasets.DatasetBuilder.download_and_prepare.file_format",description:`<strong>file_format</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Format of the data files in which the dataset will be written.
Supported formats: &#x201C;arrow&#x201D;, &#x201C;parquet&#x201D;. Default to &#x201C;arrow&#x201D; format.
If the format is &#x201C;parquet&#x201D;, then image and audio data are embedded into the Parquet files instead of pointing to local files.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"file_format"},{anchor:"datasets.DatasetBuilder.download_and_prepare.max_shard_size",description:`<strong>max_shard_size</strong> (<code>Union[str, int]</code>, <em>optional</em>) &#x2014;
Maximum number of bytes written per shard, default is &#x201C;500MB&#x201D;.
The size is based on uncompressed data size, so in practice your shard files may be smaller than
<code>max_shard_size</code> thanks to Parquet compression for example.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"max_shard_size"},{anchor:"datasets.DatasetBuilder.download_and_prepare.num_proc",description:`<strong>num_proc</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes when downloading and generating the dataset locally.
Multiprocessing is disabled by default.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.7.0</p>
						
					</div>`,name:"num_proc"},{anchor:"datasets.DatasetBuilder.download_and_prepare.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Key/value pairs to be passed on to the caching file-system backend, if any.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"storage_options"},{anchor:"datasets.DatasetBuilder.download_and_prepare.*download_and_prepare_kwargs",description:"*<strong>*download_and_prepare_kwargs</strong> (additional keyword arguments) &#x2014; Keyword arguments.",name:"*download_and_prepare_kwargs"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/builder.py#L751"}}),Ze=new J({props:{anchor:"datasets.DatasetBuilder.download_and_prepare.example",$$slots:{default:[zr]},$$scope:{ctx:y}}}),Be=new J({props:{anchor:"datasets.DatasetBuilder.download_and_prepare.example-2",$$slots:{default:[Vr]},$$scope:{ctx:y}}}),De=new J({props:{anchor:"datasets.DatasetBuilder.download_and_prepare.example-3",$$slots:{default:[Sr]},$$scope:{ctx:y}}}),gt=new T({props:{name:"get_all_exported_dataset_infos",anchor:"datasets.DatasetBuilder.get_all_exported_dataset_infos",parameters:[],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/builder.py#L535"}}),Fe=new J({props:{anchor:"datasets.DatasetBuilder.get_all_exported_dataset_infos.example",$$slots:{default:[Er]},$$scope:{ctx:y}}}),ut=new T({props:{name:"get_exported_dataset_info",anchor:"datasets.DatasetBuilder.get_exported_dataset_info",parameters:[],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/builder.py#L550"}}),ze=new J({props:{anchor:"datasets.DatasetBuilder.get_exported_dataset_info.example",$$slots:{default:[Lr]},$$scope:{ctx:y}}}),ft=new T({props:{name:"get_imported_module_dir",anchor:"datasets.DatasetBuilder.get_imported_module_dir",parameters:[],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/builder.py#L743"}}),ht=new T({props:{name:"class datasets.GeneratorBasedBuilder",anchor:"datasets.GeneratorBasedBuilder",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/builder.py#L1535"}}),_t=new T({props:{name:"class datasets.ArrowBasedBuilder",anchor:"datasets.ArrowBasedBuilder",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/builder.py#L1800"}}),bt=new T({props:{name:"class datasets.BuilderConfig",anchor:"datasets.BuilderConfig",parameters:[{name:"name",val:": str = 'default'"},{name:"version",val:": Union = 0.0.0"},{name:"data_dir",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"description",val:": Optional = None"}],parametersDescription:[{anchor:"datasets.BuilderConfig.name",description:`<strong>name</strong> (<code>str</code>, defaults to <code>default</code>) &#x2014;
The name of the configuration.`,name:"name"},{anchor:"datasets.BuilderConfig.version",description:`<strong>version</strong> (<code>Version</code> or <code>str</code>, defaults to <code>0.0.0</code>) &#x2014;
The version of the configuration.`,name:"version"},{anchor:"datasets.BuilderConfig.data_dir",description:`<strong>data_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to the directory containing the source data.`,name:"data_dir"},{anchor:"datasets.BuilderConfig.data_files",description:`<strong>data_files</strong> (<code>str</code> or <code>Sequence</code> or <code>Mapping</code>, <em>optional</em>) &#x2014;
Path(s) to source data file(s).`,name:"data_files"},{anchor:"datasets.BuilderConfig.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A human description of the configuration.`,name:"description"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/builder.py#L100"}}),$t=new T({props:{name:"create_config_id",anchor:"datasets.BuilderConfig.create_config_id",parameters:[{name:"config_kwargs",val:": dict"},{name:"custom_features",val:": Optional = None"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/builder.py#L144"}}),xt=new os({props:{title:"Download",local:"datasets.DownloadManager",headingTag:"h2"}}),vt=new T({props:{name:"class datasets.DownloadManager",anchor:"datasets.DownloadManager",parameters:[{name:"dataset_name",val:": Optional = None"},{name:"data_dir",val:": Optional = None"},{name:"download_config",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"record_checksums",val:" = True"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/download_manager.py#L85"}}),wt=new T({props:{name:"download",anchor:"datasets.DownloadManager.download",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.download.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL or <code>list</code> or <code>dict</code> of URLs to download. Each URL is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/download_manager.py#L192",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The downloaded paths matching the given input <code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code> or <code>list</code> or <code>dict</code></p>
`}}),Se=new J({props:{anchor:"datasets.DownloadManager.download.example",$$slots:{default:[Qr]},$$scope:{ctx:y}}}),yt=new T({props:{name:"download_and_extract",anchor:"datasets.DownloadManager.download_and_extract",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.download_and_extract.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL or <code>list</code> or <code>dict</code> of URLs to download and extract. Each URL is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/download_manager.py#L381",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code>, extracted paths of given URL(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>extracted_path(s)</p>
`}}),Ee=new J({props:{anchor:"datasets.DownloadManager.download_and_extract.example",$$slots:{default:[Yr]},$$scope:{ctx:y}}}),Mt=new T({props:{name:"download_custom",anchor:"datasets.DownloadManager.download_custom",parameters:[{name:"url_or_urls",val:""},{name:"custom_download",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.download_custom.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL or <code>list</code> or <code>dict</code> of URLs to download and extract. Each URL is a <code>str</code>.`,name:"url_or_urls"},{anchor:"datasets.DownloadManager.download_custom.custom_download",description:`<strong>custom_download</strong> (<code>Callable[src_url, dst_path]</code>) &#x2014;
The source URL and destination path. For example
<code>tf.io.gfile.copy</code>, that lets you download from  Google storage.`,name:"custom_download"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/download_manager.py#L145",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code>, The downloaded paths matching the given input
<code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>downloaded_path(s)</p>
`}}),Le=new J({props:{anchor:"datasets.DownloadManager.download_custom.example",$$slots:{default:[Wr]},$$scope:{ctx:y}}}),kt=new T({props:{name:"extract",anchor:"datasets.DownloadManager.extract",parameters:[{name:"path_or_paths",val:""},{name:"num_proc",val:" = 'deprecated'"}],parametersDescription:[{anchor:"datasets.DownloadManager.extract.path_or_paths",description:`<strong>path_or_paths</strong> (path or <code>list</code> or <code>dict</code>) &#x2014;
Path of file to extract. Each path is a <code>str</code>.`,name:"path_or_paths"},{anchor:"datasets.DownloadManager.extract.num_proc",description:`<strong>num_proc</strong> (<code>int</code>) &#x2014;
Use multi-processing if <code>num_proc</code> &gt; 1 and the length of
<code>path_or_paths</code> is larger than <code>num_proc</code>.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.6.2</p>
						
<p>Pass <code>DownloadConfig(num_proc=&lt;num_proc&gt;)</code> to the initializer instead.</p>

					</div>`,name:"num_proc"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/download_manager.py#L335",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code>, The extracted paths matching the given input
path_or_paths.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>extracted_path(s)</p>
`}}),Qe=new J({props:{anchor:"datasets.DownloadManager.extract.example",$$slots:{default:[Hr]},$$scope:{ctx:y}}}),Tt=new T({props:{name:"iter_archive",anchor:"datasets.DownloadManager.iter_archive",parameters:[{name:"path_or_buf",val:": Union"}],parametersDescription:[{anchor:"datasets.DownloadManager.iter_archive.path_or_buf",description:`<strong>path_or_buf</strong> (<code>str</code> or <code>io.BufferedReader</code>) &#x2014;
Archive path or archive binary file object.`,name:"path_or_buf"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/download_manager.py#L291",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tuple[str, io.BufferedReader]</code></p>
`,isYield:!0}}),Ye=new J({props:{anchor:"datasets.DownloadManager.iter_archive.example",$$slots:{default:[Pr]},$$scope:{ctx:y}}}),Jt=new T({props:{name:"iter_files",anchor:"datasets.DownloadManager.iter_files",parameters:[{name:"paths",val:": Union"}],parametersDescription:[{anchor:"datasets.DownloadManager.iter_files.paths",description:`<strong>paths</strong> (<code>str</code> or <code>list</code> of <code>str</code>) &#x2014;
Root paths.`,name:"paths"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/download_manager.py#L316",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,isYield:!0}}),We=new J({props:{anchor:"datasets.DownloadManager.iter_files.example",$$slots:{default:[Ar]},$$scope:{ctx:y}}}),Ct=new T({props:{name:"class datasets.StreamingDownloadManager",anchor:"datasets.StreamingDownloadManager",parameters:[{name:"dataset_name",val:": Optional = None"},{name:"data_dir",val:": Optional = None"},{name:"download_config",val:": Optional = None"},{name:"base_path",val:": Optional = None"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/streaming_download_manager.py#L46"}}),Ut=new T({props:{name:"download",anchor:"datasets.StreamingDownloadManager.download",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.download.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL(s) of files to stream data from. Each url is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/streaming_download_manager.py#L72",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(<code>str</code> or <code>list</code> or <code>dict</code>), URL(s) to stream data from matching the given input url_or_urls.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>url(s)</p>
`}}),He=new J({props:{anchor:"datasets.StreamingDownloadManager.download.example",$$slots:{default:[qr]},$$scope:{ctx:y}}}),Rt=new T({props:{name:"download_and_extract",anchor:"datasets.StreamingDownloadManager.download_and_extract",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.download_and_extract.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL(s) to stream from data from. Each url is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/streaming_download_manager.py#L148",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(<code>str</code> or <code>list</code> or <code>dict</code>), URL(s) to stream data from matching the given input <code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>url(s)</p>
`}}),Pe=new J({props:{anchor:"datasets.StreamingDownloadManager.download_and_extract.example",$$slots:{default:[Or]},$$scope:{ctx:y}}}),jt=new T({props:{name:"extract",anchor:"datasets.StreamingDownloadManager.extract",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.extract.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL(s) of files to stream data from. Each url is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/streaming_download_manager.py#L99",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(<code>str</code> or <code>list</code> or <code>dict</code>), URL(s) to stream data from matching the given input <code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>url(s)</p>
`}}),Ae=new J({props:{anchor:"datasets.StreamingDownloadManager.extract.example",$$slots:{default:[Kr]},$$scope:{ctx:y}}}),Gt=new T({props:{name:"iter_archive",anchor:"datasets.StreamingDownloadManager.iter_archive",parameters:[{name:"urlpath_or_buf",val:": Union"}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.iter_archive.urlpath_or_buf",description:`<strong>urlpath_or_buf</strong> (<code>str</code> or <code>io.BufferedReader</code>) &#x2014;
Archive path or archive binary file object.`,name:"urlpath_or_buf"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/streaming_download_manager.py#L168",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tuple[str, io.BufferedReader]</code></p>
`,isYield:!0}}),qe=new J({props:{anchor:"datasets.StreamingDownloadManager.iter_archive.example",$$slots:{default:[el]},$$scope:{ctx:y}}}),Nt=new T({props:{name:"iter_files",anchor:"datasets.StreamingDownloadManager.iter_files",parameters:[{name:"urlpaths",val:": Union"}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.iter_files.urlpaths",description:`<strong>urlpaths</strong> (<code>str</code> or <code>list</code> of <code>str</code>) &#x2014;
Root paths.`,name:"urlpaths"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/streaming_download_manager.py#L193",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>str</p>
`,isYield:!0}}),Oe=new J({props:{anchor:"datasets.StreamingDownloadManager.iter_files.example",$$slots:{default:[tl]},$$scope:{ctx:y}}}),It=new T({props:{name:"class datasets.DownloadConfig",anchor:"datasets.DownloadConfig",parameters:[{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"resume_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"proxies",val:": Optional = None"},{name:"user_agent",val:": Optional = None"},{name:"extract_compressed_file",val:": bool = False"},{name:"force_extract",val:": bool = False"},{name:"delete_extracted",val:": bool = False"},{name:"extract_on_the_fly",val:": bool = False"},{name:"use_etag",val:": bool = True"},{name:"num_proc",val:": Optional = None"},{name:"max_retries",val:": int = 1"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:": dataclasses.InitVar[typing.Union[str, bool, NoneType]] = 'deprecated'"},{name:"ignore_url_params",val:": bool = False"},{name:"storage_options",val:": Dict = <factory>"},{name:"download_desc",val:": Optional = None"},{name:"disable_tqdm",val:": bool = False"}],parametersDescription:[{anchor:"datasets.DownloadConfig.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
Specify a cache directory to save the file to (overwrite the
default cache dir).`,name:"cache_dir"},{anchor:"datasets.DownloadConfig.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, re-dowload the file even if it&#x2019;s already cached in
the cache dir.`,name:"force_download"},{anchor:"datasets.DownloadConfig.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, resume the download if an incompletely received file is
found.`,name:"resume_download"},{anchor:"datasets.DownloadConfig.proxies",description:"<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;",name:"proxies"},{anchor:"datasets.DownloadConfig.user_agent",description:`<strong>user_agent</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Optional string or dict that will be appended to the user-agent on remote
requests.`,name:"user_agent"},{anchor:"datasets.DownloadConfig.extract_compressed_file",description:`<strong>extract_compressed_file</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code> and the path point to a zip or tar file,
extract the compressed file in a folder along the archive.`,name:"extract_compressed_file"},{anchor:"datasets.DownloadConfig.force_extract",description:`<strong>force_extract</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code> when <code>extract_compressed_file</code> is <code>True</code> and the archive
was already extracted, re-extract the archive and override the folder where it was extracted.`,name:"force_extract"},{anchor:"datasets.DownloadConfig.delete_extracted",description:`<strong>delete_extracted</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to delete (or keep) the extracted files.`,name:"delete_extracted"},{anchor:"datasets.DownloadConfig.extract_on_the_fly",description:`<strong>extract_on_the_fly</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, extract compressed files while they are being read.`,name:"extract_on_the_fly"},{anchor:"datasets.DownloadConfig.use_etag",description:`<strong>use_etag</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use the ETag HTTP response header to validate the cached files.`,name:"use_etag"},{anchor:"datasets.DownloadConfig.num_proc",description:`<strong>num_proc</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of processes to launch to download the files in parallel.`,name:"num_proc"},{anchor:"datasets.DownloadConfig.max_retries",description:`<strong>max_retries</strong> (<code>int</code>, default to <code>1</code>) &#x2014;
The number of times to retry an HTTP request if it fails.`,name:"max_retries"},{anchor:"datasets.DownloadConfig.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token
for remote files on the Datasets Hub. If <code>True</code>, or not specified, will get token from <code>~/.huggingface</code>.`,name:"token"},{anchor:"datasets.DownloadConfig.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token
for remote files on the Datasets Hub. If <code>True</code>, or not specified, will get token from <code>~/.huggingface</code>.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.14.0</p>
						
<p><code>use_auth_token</code> was deprecated in favor of <code>token</code> in version 2.14.0 and will be removed in 3.0.0.</p>

					</div>`,name:"use_auth_token"},{anchor:"datasets.DownloadConfig.ignore_url_params",description:`<strong>ignore_url_params</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to strip all query parameters and fragments from
the download URL before using it for caching the file.`,name:"ignore_url_params"},{anchor:"datasets.DownloadConfig.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Key/value pairs to be passed on to the dataset file-system backend, if any.`,name:"storage_options"},{anchor:"datasets.DownloadConfig.download_desc",description:`<strong>download_desc</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A description to be displayed alongside with the progress bar while downloading the files.`,name:"download_desc"},{anchor:"datasets.DownloadConfig.disable_tqdm",description:`<strong>disable_tqdm</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable the individual files download progress bar`,name:"disable_tqdm"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/download_config.py#L10"}}),Xt=new T({props:{name:"class datasets.DownloadMode",anchor:"datasets.DownloadMode",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/download/download_manager.py#L54"}}),Zt=new os({props:{title:"Verification",local:"datasets.VerificationMode",headingTag:"h2"}}),Bt=new T({props:{name:"class datasets.VerificationMode",anchor:"datasets.VerificationMode",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/utils/info_utils.py#L22"}}),Dt=new os({props:{title:"Splits",local:"datasets.SplitGenerator",headingTag:"h2"}}),Ft=new T({props:{name:"class datasets.SplitGenerator",anchor:"datasets.SplitGenerator",parameters:[{name:"name",val:": str"},{name:"gen_kwargs",val:": Dict = <factory>"}],parametersDescription:[{anchor:"datasets.SplitGenerator.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
Name of the <code>Split</code> for which the generator will
create the examples.`,name:"name"},{anchor:"datasets.SplitGenerator.*gen_kwargs",description:`*<strong>*gen_kwargs</strong> (additional keyword arguments) &#x2014;
Keyword arguments to forward to the <code>DatasetBuilder._generate_examples</code> method
of the builder.`,name:"*gen_kwargs"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/splits.py#L601"}}),Ke=new J({props:{anchor:"datasets.SplitGenerator.example",$$slots:{default:[al]},$$scope:{ctx:y}}}),zt=new T({props:{name:"class datasets.Split",anchor:"datasets.Split",parameters:[{name:"name",val:""}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/splits.py#L406"}}),et=new J({props:{anchor:"datasets.Split.example",$$slots:{default:[sl]},$$scope:{ctx:y}}}),Vt=new T({props:{name:"class datasets.NamedSplit",anchor:"datasets.NamedSplit",parameters:[{name:"name",val:""}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/splits.py#L314"}}),tt=new J({props:{anchor:"datasets.NamedSplit.example",$$slots:{default:[nl]},$$scope:{ctx:y}}}),at=new J({props:{anchor:"datasets.NamedSplit.example-2",$$slots:{default:[ol]},$$scope:{ctx:y}}}),st=new J({props:{anchor:"datasets.NamedSplit.example-3",$$slots:{default:[rl]},$$scope:{ctx:y}}}),nt=new J({props:{anchor:"datasets.NamedSplit.example-4",$$slots:{default:[ll]},$$scope:{ctx:y}}}),St=new T({props:{name:"class datasets.NamedSplitAll",anchor:"datasets.NamedSplitAll",parameters:[],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/splits.py#L391"}}),Et=new T({props:{name:"class datasets.ReadInstruction",anchor:"datasets.ReadInstruction",parameters:[{name:"split_name",val:""},{name:"rounding",val:" = None"},{name:"from_",val:" = None"},{name:"to",val:" = None"},{name:"unit",val:" = None"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/arrow_reader.py#L499"}}),ot=new J({props:{anchor:"datasets.ReadInstruction.example",$$slots:{default:[dl]},$$scope:{ctx:y}}}),Lt=new T({props:{name:"from_spec",anchor:"datasets.ReadInstruction.from_spec",parameters:[{name:"spec",val:""}],parametersDescription:[{anchor:"datasets.ReadInstruction.from_spec.spec",description:`<strong>spec</strong> (<code>str</code>) &#x2014;
Split(s) + optional slice(s) to read + optional rounding
if percents are used as the slicing unit. A slice can be specified,
using absolute numbers (<code>int</code>) or percentages (<code>int</code>).`,name:"spec"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/arrow_reader.py#L579",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>ReadInstruction instance.</p>
`}}),rt=new J({props:{anchor:"datasets.ReadInstruction.from_spec.example",$$slots:{default:[il]},$$scope:{ctx:y}}}),Qt=new T({props:{name:"to_absolute",anchor:"datasets.ReadInstruction.to_absolute",parameters:[{name:"name2len",val:""}],parametersDescription:[{anchor:"datasets.ReadInstruction.to_absolute.name2len",description:`<strong>name2len</strong> (<code>dict</code>) &#x2014;
Associating split names to number of examples.`,name:"name2len"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/arrow_reader.py#L651",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of _AbsoluteInstruction instances (corresponds to the + in spec).</p>
`}}),Yt=new os({props:{title:"Version",local:"datasets.Version",headingTag:"h2"}}),Wt=new T({props:{name:"class datasets.Version",anchor:"datasets.Version",parameters:[{name:"version_str",val:": str"},{name:"description",val:": Optional = None"},{name:"major",val:": Union = None"},{name:"minor",val:": Union = None"},{name:"patch",val:": Union = None"}],parametersDescription:[{anchor:"datasets.Version.version_str",description:`<strong>version_str</strong> (<code>str</code>) &#x2014;
The dataset version.`,name:"version_str"},{anchor:"datasets.Version.description",description:`<strong>description</strong> (<code>str</code>) &#x2014;
A description of what is new in this version.`,name:"description"},{anchor:"datasets.Version.major",description:"<strong>major</strong> (<code>str</code>) &#x2014;",name:"major"},{anchor:"datasets.Version.minor",description:"<strong>minor</strong> (<code>str</code>) &#x2014;",name:"minor"},{anchor:"datasets.Version.patch",description:"<strong>patch</strong> (<code>str</code>) &#x2014;",name:"patch"}],source:"https://github.com/huggingface/datasets/blob/r_7043/src/datasets/utils/version.py#L28"}}),lt=new J({props:{anchor:"datasets.Version.example",$$slots:{default:[cl]},$$scope:{ctx:y}}}),Ht=new Dr({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/package_reference/builder_classes.mdx"}}),{c(){a=c("meta"),w=o(),d=c("p"),s=o(),f(l.$$.fragment),e=o(),f(m.$$.fragment),ls=o(),it=c("p"),it.innerHTML=Co,ds=o(),R=c("div"),f(ct.$$.fragment),js=o(),Ot=c("p"),Ot.textContent=Uo,Gs=o(),Kt=c("p"),Kt.innerHTML=Ro,Ns=o(),ea=c("ul"),ea.innerHTML=jo,Is=o(),ta=c("p"),ta.innerHTML=Go,Xs=o(),re=c("div"),f(pt.$$.fragment),Zs=o(),aa=c("p"),aa.textContent=No,Bs=o(),f(Xe.$$.fragment),Ds=o(),D=c("div"),f(mt.$$.fragment),Fs=o(),sa=c("p"),sa.textContent=Io,zs=o(),na=c("p"),na.textContent=Xo,Vs=o(),f(Ze.$$.fragment),Ss=o(),f(Be.$$.fragment),Es=o(),f(De.$$.fragment),Ls=o(),le=c("div"),f(gt.$$.fragment),Qs=o(),oa=c("p"),oa.textContent=Zo,Ys=o(),f(Fe.$$.fragment),Ws=o(),de=c("div"),f(ut.$$.fragment),Hs=o(),ra=c("p"),ra.innerHTML=Bo,Ps=o(),f(ze.$$.fragment),As=o(),Ve=c("div"),f(ft.$$.fragment),qs=o(),la=c("p"),la.textContent=Do,is=o(),K=c("div"),f(ht.$$.fragment),Os=o(),da=c("p"),da.textContent=Fo,Ks=o(),ia=c("p"),ia.innerHTML=zo,cs=o(),xe=c("div"),f(_t.$$.fragment),en=o(),ca=c("p"),ca.textContent=Vo,ps=o(),Q=c("div"),f(bt.$$.fragment),tn=o(),pa=c("p"),pa.innerHTML=So,an=o(),ma=c("p"),ma.innerHTML=Eo,sn=o(),P=c("div"),f($t.$$.fragment),nn=o(),ga=c("p"),ga.textContent=Lo,on=o(),ua=c("ul"),ua.innerHTML=Qo,rn=o(),fa=c("p"),fa.textContent=Yo,ms=o(),f(xt.$$.fragment),gs=o(),N=c("div"),f(vt.$$.fragment),ln=o(),A=c("div"),f(wt.$$.fragment),dn=o(),ha=c("p"),ha.textContent=Wo,cn=o(),_a=c("p"),_a.innerHTML=Ho,pn=o(),f(Se.$$.fragment),mn=o(),ie=c("div"),f(yt.$$.fragment),gn=o(),ba=c("p"),ba.innerHTML=Po,un=o(),f(Ee.$$.fragment),fn=o(),ce=c("div"),f(Mt.$$.fragment),hn=o(),$a=c("p"),$a.innerHTML=Ao,_n=o(),f(Le.$$.fragment),bn=o(),pe=c("div"),f(kt.$$.fragment),$n=o(),xa=c("p"),xa.textContent=qo,xn=o(),f(Qe.$$.fragment),vn=o(),me=c("div"),f(Tt.$$.fragment),wn=o(),va=c("p"),va.textContent=Oo,yn=o(),f(Ye.$$.fragment),Mn=o(),ge=c("div"),f(Jt.$$.fragment),kn=o(),wa=c("p"),wa.textContent=Ko,Tn=o(),f(We.$$.fragment),us=o(),I=c("div"),f(Ct.$$.fragment),Jn=o(),ya=c("p"),ya.innerHTML=er,Cn=o(),ue=c("div"),f(Ut.$$.fragment),Un=o(),Ma=c("p"),Ma.innerHTML=tr,Rn=o(),f(He.$$.fragment),jn=o(),q=c("div"),f(Rt.$$.fragment),Gn=o(),ka=c("p"),ka.innerHTML=ar,Nn=o(),Ta=c("p"),Ta.innerHTML=sr,In=o(),f(Pe.$$.fragment),Xn=o(),O=c("div"),f(jt.$$.fragment),Zn=o(),Ja=c("p"),Ja.textContent=nr,Bn=o(),Ca=c("p"),Ca.innerHTML=or,Dn=o(),f(Ae.$$.fragment),Fn=o(),fe=c("div"),f(Gt.$$.fragment),zn=o(),Ua=c("p"),Ua.textContent=rr,Vn=o(),f(qe.$$.fragment),Sn=o(),he=c("div"),f(Nt.$$.fragment),En=o(),Ra=c("p"),Ra.textContent=lr,Ln=o(),f(Oe.$$.fragment),fs=o(),ve=c("div"),f(It.$$.fragment),Qn=o(),ja=c("p"),ja.textContent=dr,hs=o(),z=c("div"),f(Xt.$$.fragment),Yn=o(),Ga=c("p"),Ga.innerHTML=ir,Wn=o(),Na=c("p"),Na.innerHTML=cr,Hn=o(),Ia=c("p"),Ia.textContent=pr,Pn=o(),Xa=c("table"),Xa.innerHTML=mr,_s=o(),f(Zt.$$.fragment),bs=o(),V=c("div"),f(Bt.$$.fragment),An=o(),Za=c("p"),Za.innerHTML=gr,qn=o(),Ba=c("p"),Ba.innerHTML=ur,On=o(),Da=c("p"),Da.textContent=fr,Kn=o(),Fa=c("table"),Fa.innerHTML=hr,$s=o(),f(Dt.$$.fragment),xs=o(),Y=c("div"),f(Ft.$$.fragment),eo=o(),za=c("p"),za.textContent=_r,to=o(),Va=c("p"),Va.innerHTML=br,ao=o(),f(Ke.$$.fragment),vs=o(),X=c("div"),f(zt.$$.fragment),so=o(),Sa=c("p"),Sa.innerHTML=$r,no=o(),Ea=c("p"),Ea.textContent=xr,oo=o(),La=c("ul"),La.innerHTML=vr,ro=o(),Qa=c("p"),Qa.innerHTML=wr,lo=o(),Ya=c("p"),Ya.innerHTML=yr,io=o(),f(et.$$.fragment),ws=o(),G=c("div"),f(Vt.$$.fragment),co=o(),Wa=c("p"),Wa.textContent=Mr,po=o(),Ha=c("p"),Ha.textContent=kr,mo=o(),f(tt.$$.fragment),go=o(),Pa=c("p"),Pa.textContent=Tr,uo=o(),f(at.$$.fragment),fo=o(),f(st.$$.fragment),ho=o(),f(nt.$$.fragment),ys=o(),we=c("div"),f(St.$$.fragment),_o=o(),Aa=c("p"),Aa.textContent=Jr,Ms=o(),S=c("div"),f(Et.$$.fragment),bo=o(),qa=c("p"),qa.textContent=Cr,$o=o(),f(ot.$$.fragment),xo=o(),_e=c("div"),f(Lt.$$.fragment),vo=o(),Oa=c("p"),Oa.innerHTML=Ur,wo=o(),f(rt.$$.fragment),yo=o(),be=c("div"),f(Qt.$$.fragment),Mo=o(),Ka=c("p"),Ka.textContent=Rr,ko=o(),es=c("p"),es.textContent=jr,ks=o(),f(Yt.$$.fragment),Ts=o(),ee=c("div"),f(Wt.$$.fragment),To=o(),ts=c("p"),ts.innerHTML=Gr,Jo=o(),f(lt.$$.fragment),Js=o(),f(Ht.$$.fragment),Cs=o(),rs=c("p"),this.h()},l(t){const g=Br("svelte-u9bgzb",document.head);a=p(g,"META",{name:!0,content:!0}),g.forEach(i),w=r(t),d=p(t,"P",{}),M(d).forEach(i),s=r(t),h(l.$$.fragment,t),e=r(t),h(m.$$.fragment,t),ls=r(t),it=p(t,"P",{"data-svelte-h":!0}),v(it)!=="svelte-1uftt40"&&(it.innerHTML=Co),ds=r(t),R=p(t,"DIV",{class:!0});var j=M(R);h(ct.$$.fragment,j),js=r(j),Ot=p(j,"P",{"data-svelte-h":!0}),v(Ot)!=="svelte-krqj9a"&&(Ot.textContent=Uo),Gs=r(j),Kt=p(j,"P",{"data-svelte-h":!0}),v(Kt)!=="svelte-apl31e"&&(Kt.innerHTML=Ro),Ns=r(j),ea=p(j,"UL",{"data-svelte-h":!0}),v(ea)!=="svelte-rdwmw5"&&(ea.innerHTML=jo),Is=r(j),ta=p(j,"P",{"data-svelte-h":!0}),v(ta)!=="svelte-ofwbvd"&&(ta.innerHTML=Go),Xs=r(j),re=p(j,"DIV",{class:!0});var ye=M(re);h(pt.$$.fragment,ye),Zs=r(ye),aa=p(ye,"P",{"data-svelte-h":!0}),v(aa)!=="svelte-1q1652n"&&(aa.textContent=No),Bs=r(ye),h(Xe.$$.fragment,ye),ye.forEach(i),Ds=r(j),D=p(j,"DIV",{class:!0});var E=M(D);h(mt.$$.fragment,E),Fs=r(E),sa=p(E,"P",{"data-svelte-h":!0}),v(sa)!=="svelte-9mag6f"&&(sa.textContent=Io),zs=r(E),na=p(E,"P",{"data-svelte-h":!0}),v(na)!=="svelte-11lpom8"&&(na.textContent=Xo),Vs=r(E),h(Ze.$$.fragment,E),Ss=r(E),h(Be.$$.fragment,E),Es=r(E),h(De.$$.fragment,E),E.forEach(i),Ls=r(j),le=p(j,"DIV",{class:!0});var Me=M(le);h(gt.$$.fragment,Me),Qs=r(Me),oa=p(Me,"P",{"data-svelte-h":!0}),v(oa)!=="svelte-1o5q38l"&&(oa.textContent=Zo),Ys=r(Me),h(Fe.$$.fragment,Me),Me.forEach(i),Ws=r(j),de=p(j,"DIV",{class:!0});var ke=M(de);h(ut.$$.fragment,ke),Hs=r(ke),ra=p(ke,"P",{"data-svelte-h":!0}),v(ra)!=="svelte-168h2s0"&&(ra.innerHTML=Bo),Ps=r(ke),h(ze.$$.fragment,ke),ke.forEach(i),As=r(j),Ve=p(j,"DIV",{class:!0});var Pt=M(Ve);h(ft.$$.fragment,Pt),qs=r(Pt),la=p(Pt,"P",{"data-svelte-h":!0}),v(la)!=="svelte-1jq5ljq"&&(la.textContent=Do),Pt.forEach(i),j.forEach(i),is=r(t),K=p(t,"DIV",{class:!0});var Te=M(K);h(ht.$$.fragment,Te),Os=r(Te),da=p(Te,"P",{"data-svelte-h":!0}),v(da)!=="svelte-5e48ll"&&(da.textContent=Fo),Ks=r(Te),ia=p(Te,"P",{"data-svelte-h":!0}),v(ia)!=="svelte-1b18j1y"&&(ia.innerHTML=zo),Te.forEach(i),cs=r(t),xe=p(t,"DIV",{class:!0});var At=M(xe);h(_t.$$.fragment,At),en=r(At),ca=p(At,"P",{"data-svelte-h":!0}),v(ca)!=="svelte-17aolem"&&(ca.textContent=Vo),At.forEach(i),ps=r(t),Q=p(t,"DIV",{class:!0});var te=M(Q);h(bt.$$.fragment,te),tn=r(te),pa=p(te,"P",{"data-svelte-h":!0}),v(pa)!=="svelte-15gz2dy"&&(pa.innerHTML=So),an=r(te),ma=p(te,"P",{"data-svelte-h":!0}),v(ma)!=="svelte-1m2o9um"&&(ma.innerHTML=Eo),sn=r(te),P=p(te,"DIV",{class:!0});var ae=M(P);h($t.$$.fragment,ae),nn=r(ae),ga=p(ae,"P",{"data-svelte-h":!0}),v(ga)!=="svelte-1h03lp6"&&(ga.textContent=Lo),on=r(ae),ua=p(ae,"UL",{"data-svelte-h":!0}),v(ua)!=="svelte-y69nf2"&&(ua.innerHTML=Qo),rn=r(ae),fa=p(ae,"P",{"data-svelte-h":!0}),v(fa)!=="svelte-d2y9u1"&&(fa.textContent=Yo),ae.forEach(i),te.forEach(i),ms=r(t),h(xt.$$.fragment,t),gs=r(t),N=p(t,"DIV",{class:!0});var Z=M(N);h(vt.$$.fragment,Z),ln=r(Z),A=p(Z,"DIV",{class:!0});var se=M(A);h(wt.$$.fragment,se),dn=r(se),ha=p(se,"P",{"data-svelte-h":!0}),v(ha)!=="svelte-19i8z0e"&&(ha.textContent=Wo),cn=r(se),_a=p(se,"P",{"data-svelte-h":!0}),v(_a)!=="svelte-a30fyv"&&(_a.innerHTML=Ho),pn=r(se),h(Se.$$.fragment,se),se.forEach(i),mn=r(Z),ie=p(Z,"DIV",{class:!0});var Je=M(ie);h(yt.$$.fragment,Je),gn=r(Je),ba=p(Je,"P",{"data-svelte-h":!0}),v(ba)!=="svelte-xkawo0"&&(ba.innerHTML=Po),un=r(Je),h(Ee.$$.fragment,Je),Je.forEach(i),fn=r(Z),ce=p(Z,"DIV",{class:!0});var Ce=M(ce);h(Mt.$$.fragment,Ce),hn=r(Ce),$a=p(Ce,"P",{"data-svelte-h":!0}),v($a)!=="svelte-1tww4ej"&&($a.innerHTML=Ao),_n=r(Ce),h(Le.$$.fragment,Ce),Ce.forEach(i),bn=r(Z),pe=p(Z,"DIV",{class:!0});var Ue=M(pe);h(kt.$$.fragment,Ue),$n=r(Ue),xa=p(Ue,"P",{"data-svelte-h":!0}),v(xa)!=="svelte-1vlembv"&&(xa.textContent=qo),xn=r(Ue),h(Qe.$$.fragment,Ue),Ue.forEach(i),vn=r(Z),me=p(Z,"DIV",{class:!0});var Re=M(me);h(Tt.$$.fragment,Re),wn=r(Re),va=p(Re,"P",{"data-svelte-h":!0}),v(va)!=="svelte-1ephcm7"&&(va.textContent=Oo),yn=r(Re),h(Ye.$$.fragment,Re),Re.forEach(i),Mn=r(Z),ge=p(Z,"DIV",{class:!0});var je=M(ge);h(Jt.$$.fragment,je),kn=r(je),wa=p(je,"P",{"data-svelte-h":!0}),v(wa)!=="svelte-1sadrg0"&&(wa.textContent=Ko),Tn=r(je),h(We.$$.fragment,je),je.forEach(i),Z.forEach(i),us=r(t),I=p(t,"DIV",{class:!0});var B=M(I);h(Ct.$$.fragment,B),Jn=r(B),ya=p(B,"P",{"data-svelte-h":!0}),v(ya)!=="svelte-2x5qds"&&(ya.innerHTML=er),Cn=r(B),ue=p(B,"DIV",{class:!0});var Ge=M(ue);h(Ut.$$.fragment,Ge),Un=r(Ge),Ma=p(Ge,"P",{"data-svelte-h":!0}),v(Ma)!=="svelte-z89fig"&&(Ma.innerHTML=tr),Rn=r(Ge),h(He.$$.fragment,Ge),Ge.forEach(i),jn=r(B),q=p(B,"DIV",{class:!0});var ne=M(q);h(Rt.$$.fragment,ne),Gn=r(ne),ka=p(ne,"P",{"data-svelte-h":!0}),v(ka)!=="svelte-vb22br"&&(ka.innerHTML=ar),Nn=r(ne),Ta=p(ne,"P",{"data-svelte-h":!0}),v(Ta)!=="svelte-1hkl2pt"&&(Ta.innerHTML=sr),In=r(ne),h(Pe.$$.fragment,ne),ne.forEach(i),Xn=r(B),O=p(B,"DIV",{class:!0});var oe=M(O);h(jt.$$.fragment,oe),Zn=r(oe),Ja=p(oe,"P",{"data-svelte-h":!0}),v(Ja)!=="svelte-sgtbuc"&&(Ja.textContent=nr),Bn=r(oe),Ca=p(oe,"P",{"data-svelte-h":!0}),v(Ca)!=="svelte-5qr3om"&&(Ca.innerHTML=or),Dn=r(oe),h(Ae.$$.fragment,oe),oe.forEach(i),Fn=r(B),fe=p(B,"DIV",{class:!0});var Ne=M(fe);h(Gt.$$.fragment,Ne),zn=r(Ne),Ua=p(Ne,"P",{"data-svelte-h":!0}),v(Ua)!=="svelte-1ephcm7"&&(Ua.textContent=rr),Vn=r(Ne),h(qe.$$.fragment,Ne),Ne.forEach(i),Sn=r(B),he=p(B,"DIV",{class:!0});var Ie=M(he);h(Nt.$$.fragment,Ie),En=r(Ie),Ra=p(Ie,"P",{"data-svelte-h":!0}),v(Ra)!=="svelte-1kdi5en"&&(Ra.textContent=lr),Ln=r(Ie),h(Oe.$$.fragment,Ie),Ie.forEach(i),B.forEach(i),fs=r(t),ve=p(t,"DIV",{class:!0});var qt=M(ve);h(It.$$.fragment,qt),Qn=r(qt),ja=p(qt,"P",{"data-svelte-h":!0}),v(ja)!=="svelte-1equdtb"&&(ja.textContent=dr),qt.forEach(i),hs=r(t),z=p(t,"DIV",{class:!0});var W=M(z);h(Xt.$$.fragment,W),Yn=r(W),Ga=p(W,"P",{"data-svelte-h":!0}),v(Ga)!=="svelte-nmj2uv"&&(Ga.innerHTML=ir),Wn=r(W),Na=p(W,"P",{"data-svelte-h":!0}),v(Na)!=="svelte-xtdw9q"&&(Na.innerHTML=cr),Hn=r(W),Ia=p(W,"P",{"data-svelte-h":!0}),v(Ia)!=="svelte-a4zsdi"&&(Ia.textContent=pr),Pn=r(W),Xa=p(W,"TABLE",{"data-svelte-h":!0}),v(Xa)!=="svelte-pv0x4r"&&(Xa.innerHTML=mr),W.forEach(i),_s=r(t),h(Zt.$$.fragment,t),bs=r(t),V=p(t,"DIV",{class:!0});var H=M(V);h(Bt.$$.fragment,H),An=r(H),Za=p(H,"P",{"data-svelte-h":!0}),v(Za)!=="svelte-1eqexd"&&(Za.innerHTML=gr),qn=r(H),Ba=p(H,"P",{"data-svelte-h":!0}),v(Ba)!=="svelte-13iynk4"&&(Ba.innerHTML=ur),On=r(H),Da=p(H,"P",{"data-svelte-h":!0}),v(Da)!=="svelte-1luabaw"&&(Da.textContent=fr),Kn=r(H),Fa=p(H,"TABLE",{"data-svelte-h":!0}),v(Fa)!=="svelte-6p84mg"&&(Fa.innerHTML=hr),H.forEach(i),$s=r(t),h(Dt.$$.fragment,t),xs=r(t),Y=p(t,"DIV",{class:!0});var dt=M(Y);h(Ft.$$.fragment,dt),eo=r(dt),za=p(dt,"P",{"data-svelte-h":!0}),v(za)!=="svelte-18qkgha"&&(za.textContent=_r),to=r(dt),Va=p(dt,"P",{"data-svelte-h":!0}),v(Va)!=="svelte-fn7w0y"&&(Va.innerHTML=br),ao=r(dt),h(Ke.$$.fragment,dt),dt.forEach(i),vs=r(t),X=p(t,"DIV",{class:!0});var L=M(X);h(zt.$$.fragment,L),so=r(L),Sa=p(L,"P",{"data-svelte-h":!0}),v(Sa)!=="svelte-ewaslg"&&(Sa.innerHTML=$r),no=r(L),Ea=p(L,"P",{"data-svelte-h":!0}),v(Ea)!=="svelte-l59ai2"&&(Ea.textContent=xr),oo=r(L),La=p(L,"UL",{"data-svelte-h":!0}),v(La)!=="svelte-sbyekb"&&(La.innerHTML=vr),ro=r(L),Qa=p(L,"P",{"data-svelte-h":!0}),v(Qa)!=="svelte-20xdby"&&(Qa.innerHTML=wr),lo=r(L),Ya=p(L,"P",{"data-svelte-h":!0}),v(Ya)!=="svelte-1cn2wk0"&&(Ya.innerHTML=yr),io=r(L),h(et.$$.fragment,L),L.forEach(i),ws=r(t),G=p(t,"DIV",{class:!0});var F=M(G);h(Vt.$$.fragment,F),co=r(F),Wa=p(F,"P",{"data-svelte-h":!0}),v(Wa)!=="svelte-124iux6"&&(Wa.textContent=Mr),po=r(F),Ha=p(F,"P",{"data-svelte-h":!0}),v(Ha)!=="svelte-11lpom8"&&(Ha.textContent=kr),mo=r(F),h(tt.$$.fragment,F),go=r(F),Pa=p(F,"P",{"data-svelte-h":!0}),v(Pa)!=="svelte-5jjbkq"&&(Pa.textContent=Tr),uo=r(F),h(at.$$.fragment,F),fo=r(F),h(st.$$.fragment,F),ho=r(F),h(nt.$$.fragment,F),F.forEach(i),ys=r(t),we=p(t,"DIV",{class:!0});var Rs=M(we);h(St.$$.fragment,Rs),_o=r(Rs),Aa=p(Rs,"P",{"data-svelte-h":!0}),v(Aa)!=="svelte-11ie63y"&&(Aa.textContent=Jr),Rs.forEach(i),Ms=r(t),S=p(t,"DIV",{class:!0});var $e=M(S);h(Et.$$.fragment,$e),bo=r($e),qa=p($e,"P",{"data-svelte-h":!0}),v(qa)!=="svelte-3dhs2m"&&(qa.textContent=Cr),$o=r($e),h(ot.$$.fragment,$e),xo=r($e),_e=p($e,"DIV",{class:!0});var as=M(_e);h(Lt.$$.fragment,as),vo=r(as),Oa=p(as,"P",{"data-svelte-h":!0}),v(Oa)!=="svelte-1g1y80g"&&(Oa.innerHTML=Ur),wo=r(as),h(rt.$$.fragment,as),as.forEach(i),yo=r($e),be=p($e,"DIV",{class:!0});var ss=M(be);h(Qt.$$.fragment,ss),Mo=r(ss),Ka=p(ss,"P",{"data-svelte-h":!0}),v(Ka)!=="svelte-14tg07e"&&(Ka.textContent=Rr),ko=r(ss),es=p(ss,"P",{"data-svelte-h":!0}),v(es)!=="svelte-l773xk"&&(es.textContent=jr),ss.forEach(i),$e.forEach(i),ks=r(t),h(Yt.$$.fragment,t),Ts=r(t),ee=p(t,"DIV",{class:!0});var ns=M(ee);h(Wt.$$.fragment,ns),To=r(ns),ts=p(ns,"P",{"data-svelte-h":!0}),v(ts)!=="svelte-14lq7j5"&&(ts.innerHTML=Gr),Jo=r(ns),h(lt.$$.fragment,ns),ns.forEach(i),Js=r(t),h(Ht.$$.fragment,t),Cs=r(t),rs=p(t,"P",{}),M(rs).forEach(i),this.h()},h(){k(a,"name","hf:doc:metadata"),k(a,"content",ml),k(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,g){n(document.head,a),u(t,w,g),u(t,d,g),u(t,s,g),_(l,t,g),u(t,e,g),_(m,t,g),u(t,ls,g),u(t,it,g),u(t,ds,g),u(t,R,g),_(ct,R,null),n(R,js),n(R,Ot),n(R,Gs),n(R,Kt),n(R,Ns),n(R,ea),n(R,Is),n(R,ta),n(R,Xs),n(R,re),_(pt,re,null),n(re,Zs),n(re,aa),n(re,Bs),_(Xe,re,null),n(R,Ds),n(R,D),_(mt,D,null),n(D,Fs),n(D,sa),n(D,zs),n(D,na),n(D,Vs),_(Ze,D,null),n(D,Ss),_(Be,D,null),n(D,Es),_(De,D,null),n(R,Ls),n(R,le),_(gt,le,null),n(le,Qs),n(le,oa),n(le,Ys),_(Fe,le,null),n(R,Ws),n(R,de),_(ut,de,null),n(de,Hs),n(de,ra),n(de,Ps),_(ze,de,null),n(R,As),n(R,Ve),_(ft,Ve,null),n(Ve,qs),n(Ve,la),u(t,is,g),u(t,K,g),_(ht,K,null),n(K,Os),n(K,da),n(K,Ks),n(K,ia),u(t,cs,g),u(t,xe,g),_(_t,xe,null),n(xe,en),n(xe,ca),u(t,ps,g),u(t,Q,g),_(bt,Q,null),n(Q,tn),n(Q,pa),n(Q,an),n(Q,ma),n(Q,sn),n(Q,P),_($t,P,null),n(P,nn),n(P,ga),n(P,on),n(P,ua),n(P,rn),n(P,fa),u(t,ms,g),_(xt,t,g),u(t,gs,g),u(t,N,g),_(vt,N,null),n(N,ln),n(N,A),_(wt,A,null),n(A,dn),n(A,ha),n(A,cn),n(A,_a),n(A,pn),_(Se,A,null),n(N,mn),n(N,ie),_(yt,ie,null),n(ie,gn),n(ie,ba),n(ie,un),_(Ee,ie,null),n(N,fn),n(N,ce),_(Mt,ce,null),n(ce,hn),n(ce,$a),n(ce,_n),_(Le,ce,null),n(N,bn),n(N,pe),_(kt,pe,null),n(pe,$n),n(pe,xa),n(pe,xn),_(Qe,pe,null),n(N,vn),n(N,me),_(Tt,me,null),n(me,wn),n(me,va),n(me,yn),_(Ye,me,null),n(N,Mn),n(N,ge),_(Jt,ge,null),n(ge,kn),n(ge,wa),n(ge,Tn),_(We,ge,null),u(t,us,g),u(t,I,g),_(Ct,I,null),n(I,Jn),n(I,ya),n(I,Cn),n(I,ue),_(Ut,ue,null),n(ue,Un),n(ue,Ma),n(ue,Rn),_(He,ue,null),n(I,jn),n(I,q),_(Rt,q,null),n(q,Gn),n(q,ka),n(q,Nn),n(q,Ta),n(q,In),_(Pe,q,null),n(I,Xn),n(I,O),_(jt,O,null),n(O,Zn),n(O,Ja),n(O,Bn),n(O,Ca),n(O,Dn),_(Ae,O,null),n(I,Fn),n(I,fe),_(Gt,fe,null),n(fe,zn),n(fe,Ua),n(fe,Vn),_(qe,fe,null),n(I,Sn),n(I,he),_(Nt,he,null),n(he,En),n(he,Ra),n(he,Ln),_(Oe,he,null),u(t,fs,g),u(t,ve,g),_(It,ve,null),n(ve,Qn),n(ve,ja),u(t,hs,g),u(t,z,g),_(Xt,z,null),n(z,Yn),n(z,Ga),n(z,Wn),n(z,Na),n(z,Hn),n(z,Ia),n(z,Pn),n(z,Xa),u(t,_s,g),_(Zt,t,g),u(t,bs,g),u(t,V,g),_(Bt,V,null),n(V,An),n(V,Za),n(V,qn),n(V,Ba),n(V,On),n(V,Da),n(V,Kn),n(V,Fa),u(t,$s,g),_(Dt,t,g),u(t,xs,g),u(t,Y,g),_(Ft,Y,null),n(Y,eo),n(Y,za),n(Y,to),n(Y,Va),n(Y,ao),_(Ke,Y,null),u(t,vs,g),u(t,X,g),_(zt,X,null),n(X,so),n(X,Sa),n(X,no),n(X,Ea),n(X,oo),n(X,La),n(X,ro),n(X,Qa),n(X,lo),n(X,Ya),n(X,io),_(et,X,null),u(t,ws,g),u(t,G,g),_(Vt,G,null),n(G,co),n(G,Wa),n(G,po),n(G,Ha),n(G,mo),_(tt,G,null),n(G,go),n(G,Pa),n(G,uo),_(at,G,null),n(G,fo),_(st,G,null),n(G,ho),_(nt,G,null),u(t,ys,g),u(t,we,g),_(St,we,null),n(we,_o),n(we,Aa),u(t,Ms,g),u(t,S,g),_(Et,S,null),n(S,bo),n(S,qa),n(S,$o),_(ot,S,null),n(S,xo),n(S,_e),_(Lt,_e,null),n(_e,vo),n(_e,Oa),n(_e,wo),_(rt,_e,null),n(S,yo),n(S,be),_(Qt,be,null),n(be,Mo),n(be,Ka),n(be,ko),n(be,es),u(t,ks,g),_(Yt,t,g),u(t,Ts,g),u(t,ee,g),_(Wt,ee,null),n(ee,To),n(ee,ts),n(ee,Jo),_(lt,ee,null),u(t,Js,g),_(Ht,t,g),u(t,Cs,g),u(t,rs,g),Us=!0},p(t,[g]){const j={};g&2&&(j.$$scope={dirty:g,ctx:t}),Xe.$set(j);const ye={};g&2&&(ye.$$scope={dirty:g,ctx:t}),Ze.$set(ye);const E={};g&2&&(E.$$scope={dirty:g,ctx:t}),Be.$set(E);const Me={};g&2&&(Me.$$scope={dirty:g,ctx:t}),De.$set(Me);const ke={};g&2&&(ke.$$scope={dirty:g,ctx:t}),Fe.$set(ke);const Pt={};g&2&&(Pt.$$scope={dirty:g,ctx:t}),ze.$set(Pt);const Te={};g&2&&(Te.$$scope={dirty:g,ctx:t}),Se.$set(Te);const At={};g&2&&(At.$$scope={dirty:g,ctx:t}),Ee.$set(At);const te={};g&2&&(te.$$scope={dirty:g,ctx:t}),Le.$set(te);const ae={};g&2&&(ae.$$scope={dirty:g,ctx:t}),Qe.$set(ae);const Z={};g&2&&(Z.$$scope={dirty:g,ctx:t}),Ye.$set(Z);const se={};g&2&&(se.$$scope={dirty:g,ctx:t}),We.$set(se);const Je={};g&2&&(Je.$$scope={dirty:g,ctx:t}),He.$set(Je);const Ce={};g&2&&(Ce.$$scope={dirty:g,ctx:t}),Pe.$set(Ce);const Ue={};g&2&&(Ue.$$scope={dirty:g,ctx:t}),Ae.$set(Ue);const Re={};g&2&&(Re.$$scope={dirty:g,ctx:t}),qe.$set(Re);const je={};g&2&&(je.$$scope={dirty:g,ctx:t}),Oe.$set(je);const B={};g&2&&(B.$$scope={dirty:g,ctx:t}),Ke.$set(B);const Ge={};g&2&&(Ge.$$scope={dirty:g,ctx:t}),et.$set(Ge);const ne={};g&2&&(ne.$$scope={dirty:g,ctx:t}),tt.$set(ne);const oe={};g&2&&(oe.$$scope={dirty:g,ctx:t}),at.$set(oe);const Ne={};g&2&&(Ne.$$scope={dirty:g,ctx:t}),st.$set(Ne);const Ie={};g&2&&(Ie.$$scope={dirty:g,ctx:t}),nt.$set(Ie);const qt={};g&2&&(qt.$$scope={dirty:g,ctx:t}),ot.$set(qt);const W={};g&2&&(W.$$scope={dirty:g,ctx:t}),rt.$set(W);const H={};g&2&&(H.$$scope={dirty:g,ctx:t}),lt.$set(H)},i(t){Us||(b(l.$$.fragment,t),b(m.$$.fragment,t),b(ct.$$.fragment,t),b(pt.$$.fragment,t),b(Xe.$$.fragment,t),b(mt.$$.fragment,t),b(Ze.$$.fragment,t),b(Be.$$.fragment,t),b(De.$$.fragment,t),b(gt.$$.fragment,t),b(Fe.$$.fragment,t),b(ut.$$.fragment,t),b(ze.$$.fragment,t),b(ft.$$.fragment,t),b(ht.$$.fragment,t),b(_t.$$.fragment,t),b(bt.$$.fragment,t),b($t.$$.fragment,t),b(xt.$$.fragment,t),b(vt.$$.fragment,t),b(wt.$$.fragment,t),b(Se.$$.fragment,t),b(yt.$$.fragment,t),b(Ee.$$.fragment,t),b(Mt.$$.fragment,t),b(Le.$$.fragment,t),b(kt.$$.fragment,t),b(Qe.$$.fragment,t),b(Tt.$$.fragment,t),b(Ye.$$.fragment,t),b(Jt.$$.fragment,t),b(We.$$.fragment,t),b(Ct.$$.fragment,t),b(Ut.$$.fragment,t),b(He.$$.fragment,t),b(Rt.$$.fragment,t),b(Pe.$$.fragment,t),b(jt.$$.fragment,t),b(Ae.$$.fragment,t),b(Gt.$$.fragment,t),b(qe.$$.fragment,t),b(Nt.$$.fragment,t),b(Oe.$$.fragment,t),b(It.$$.fragment,t),b(Xt.$$.fragment,t),b(Zt.$$.fragment,t),b(Bt.$$.fragment,t),b(Dt.$$.fragment,t),b(Ft.$$.fragment,t),b(Ke.$$.fragment,t),b(zt.$$.fragment,t),b(et.$$.fragment,t),b(Vt.$$.fragment,t),b(tt.$$.fragment,t),b(at.$$.fragment,t),b(st.$$.fragment,t),b(nt.$$.fragment,t),b(St.$$.fragment,t),b(Et.$$.fragment,t),b(ot.$$.fragment,t),b(Lt.$$.fragment,t),b(rt.$$.fragment,t),b(Qt.$$.fragment,t),b(Yt.$$.fragment,t),b(Wt.$$.fragment,t),b(lt.$$.fragment,t),b(Ht.$$.fragment,t),Us=!0)},o(t){$(l.$$.fragment,t),$(m.$$.fragment,t),$(ct.$$.fragment,t),$(pt.$$.fragment,t),$(Xe.$$.fragment,t),$(mt.$$.fragment,t),$(Ze.$$.fragment,t),$(Be.$$.fragment,t),$(De.$$.fragment,t),$(gt.$$.fragment,t),$(Fe.$$.fragment,t),$(ut.$$.fragment,t),$(ze.$$.fragment,t),$(ft.$$.fragment,t),$(ht.$$.fragment,t),$(_t.$$.fragment,t),$(bt.$$.fragment,t),$($t.$$.fragment,t),$(xt.$$.fragment,t),$(vt.$$.fragment,t),$(wt.$$.fragment,t),$(Se.$$.fragment,t),$(yt.$$.fragment,t),$(Ee.$$.fragment,t),$(Mt.$$.fragment,t),$(Le.$$.fragment,t),$(kt.$$.fragment,t),$(Qe.$$.fragment,t),$(Tt.$$.fragment,t),$(Ye.$$.fragment,t),$(Jt.$$.fragment,t),$(We.$$.fragment,t),$(Ct.$$.fragment,t),$(Ut.$$.fragment,t),$(He.$$.fragment,t),$(Rt.$$.fragment,t),$(Pe.$$.fragment,t),$(jt.$$.fragment,t),$(Ae.$$.fragment,t),$(Gt.$$.fragment,t),$(qe.$$.fragment,t),$(Nt.$$.fragment,t),$(Oe.$$.fragment,t),$(It.$$.fragment,t),$(Xt.$$.fragment,t),$(Zt.$$.fragment,t),$(Bt.$$.fragment,t),$(Dt.$$.fragment,t),$(Ft.$$.fragment,t),$(Ke.$$.fragment,t),$(zt.$$.fragment,t),$(et.$$.fragment,t),$(Vt.$$.fragment,t),$(tt.$$.fragment,t),$(at.$$.fragment,t),$(st.$$.fragment,t),$(nt.$$.fragment,t),$(St.$$.fragment,t),$(Et.$$.fragment,t),$(ot.$$.fragment,t),$(Lt.$$.fragment,t),$(rt.$$.fragment,t),$(Qt.$$.fragment,t),$(Yt.$$.fragment,t),$(Wt.$$.fragment,t),$(lt.$$.fragment,t),$(Ht.$$.fragment,t),Us=!1},d(t){t&&(i(w),i(d),i(s),i(e),i(ls),i(it),i(ds),i(R),i(is),i(K),i(cs),i(xe),i(ps),i(Q),i(ms),i(gs),i(N),i(us),i(I),i(fs),i(ve),i(hs),i(z),i(_s),i(bs),i(V),i($s),i(xs),i(Y),i(vs),i(X),i(ws),i(G),i(ys),i(we),i(Ms),i(S),i(ks),i(Ts),i(ee),i(Js),i(Cs),i(rs)),i(a),x(l,t),x(m,t),x(ct),x(pt),x(Xe),x(mt),x(Ze),x(Be),x(De),x(gt),x(Fe),x(ut),x(ze),x(ft),x(ht),x(_t),x(bt),x($t),x(xt,t),x(vt),x(wt),x(Se),x(yt),x(Ee),x(Mt),x(Le),x(kt),x(Qe),x(Tt),x(Ye),x(Jt),x(We),x(Ct),x(Ut),x(He),x(Rt),x(Pe),x(jt),x(Ae),x(Gt),x(qe),x(Nt),x(Oe),x(It),x(Xt),x(Zt,t),x(Bt),x(Dt,t),x(Ft),x(Ke),x(zt),x(et),x(Vt),x(tt),x(at),x(st),x(nt),x(St),x(Et),x(ot),x(Lt),x(rt),x(Qt),x(Yt,t),x(Wt),x(lt),x(Ht,t)}}}const ml='{"title":"Builder classes","local":"builder-classes","sections":[{"title":"Builders","local":"datasets.DatasetBuilder","sections":[],"depth":2},{"title":"Download","local":"datasets.DownloadManager","sections":[],"depth":2},{"title":"Verification","local":"datasets.VerificationMode","sections":[],"depth":2},{"title":"Splits","local":"datasets.SplitGenerator","sections":[],"depth":2},{"title":"Version","local":"datasets.Version","sections":[],"depth":2}],"depth":1}';function gl(y){return Ir(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xl extends Xr{constructor(a){super(),Zr(this,a,gl,pl,Nr,{})}}export{xl as component};
