import{s as at,o as tt,n as fa}from"../chunks/scheduler.bdbef820.js";import{S as et,i as lt,g as r,s as l,r as m,A as nt,h as c,f as t,c as n,j as Oa,u as i,x as h,k as st,y as pt,a as e,v as d,d as o,t as u,w as j}from"../chunks/index.c0aea24a.js";import{T as Ta}from"../chunks/Tip.31005f7d.js";import{C as J}from"../chunks/CodeBlock.6ccca92e.js";import{H as b,E as rt}from"../chunks/EditOnGithub.725ee0c1.js";function ct(w){let p,y='A <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object is a wrapper of an Arrow table, which allows fast zero-copy reads from arrays in the dataset to PyTorch tensors.';return{c(){p=r("p"),p.innerHTML=y},l(g){p=c(g,"P",{"data-svelte-h":!0}),h(p)!=="svelte-1ebzaix"&&(p.innerHTML=y)},m(g,M){e(g,p,M)},p:fa,d(g){g&&t(p)}}}function ht(w){let p,y=`To use the <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Image">Image</a> feature type, you’ll need to install the <code>vision</code> extra as
<code>pip install datasets[vision]</code>.`;return{c(){p=r("p"),p.innerHTML=y},l(g){p=c(g,"P",{"data-svelte-h":!0}),h(p)!=="svelte-1rg98sr"&&(p.innerHTML=y)},m(g,M){e(g,p,M)},p:fa,d(g){g&&t(p)}}}function mt(w){let p,y=`To use the <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Audio">Audio</a> feature type, you’ll need to install the <code>audio</code> extra as
<code>pip install datasets[audio]</code>.`;return{c(){p=r("p"),p.innerHTML=y},l(g){p=c(g,"P",{"data-svelte-h":!0}),h(p)!=="svelte-1juzzql"&&(p.innerHTML=y)},m(g,M){e(g,p,M)},p:fa,d(g){g&&t(p)}}}function it(w){let p,y,g,M,I,Ts,$,Ua=`This document is a quick introduction to using <code>datasets</code> with PyTorch, with a particular focus on how to get
<code>torch.Tensor</code> objects out of our datasets, and how to use a PyTorch <code>DataLoader</code> and a Hugging Face <code>Dataset</code>
with the best performance.`,fs,R,Us,k,Ia="By default, datasets return regular python objects: integers, floats, strings, lists, etc.",Is,C,$a='To get PyTorch tensors instead, you can set the format of the dataset to <code>pytorch</code> using <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Dataset.with_format">Dataset.with_format()</a>:',$s,G,Rs,T,ks,_,Ra="To load the data as tensors on a GPU, specify the <code>device</code> argument:",Cs,Z,Gs,X,_s,v,ka="If your dataset consists of N-dimensional arrays, you will see that by default they are considered as the same tensor if the shape is fixed:",Zs,Q,Xs,Y,vs,F,Ca=`However this logic often requires slow shape comparisons and data copies.
To avoid this, you must explicitly use the <code>Array</code> feature type and specify the shape of your tensors:`,Qs,z,Ys,x,Fs,N,Ga='<a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.ClassLabel">ClassLabel</a> data are properly converted to tensors:',zs,V,xs,W,_a="String and binary objects are unchanged, since PyTorch only supports numbers.",Ns,q,Za='The <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Image">Image</a> and <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Audio">Audio</a> feature types are also supported.',Vs,f,Ws,E,qs,U,Es,B,Bs,D,Ds,H,Xa='Like <code>torch.utils.data.Dataset</code> objects, a <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Dataset">Dataset</a> can be passed directly to a PyTorch <code>DataLoader</code>:',Hs,S,Ss,L,Ls,A,va=`There are several ways you can increase the speed your data is loaded which can save you time, especially if you are working with large datasets.
PyTorch offers parallelized data loading, retrieving batches of indices instead of individually, and streaming to iterate over the dataset without downloading it on disk.`,As,P,Ps,K,Qa="You can parallelize data loading with the <code>num_workers</code> argument of a PyTorch <code>DataLoader</code> and get a higher throughput.",Ks,O,Ya=`Under the hood, the <code>DataLoader</code> starts <code>num_workers</code> processes.
Each process reloads the dataset passed to the <code>DataLoader</code> and is used to query examples.
Reloading the dataset inside a worker doesn’t fill up your RAM, since it simply memory-maps the dataset again from your disk.`,Os,ss,sa,as,aa,ts,Fa=`Stream a dataset by loading it as an <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>. This allows you to progressively iterate over a remote dataset without downloading it on disk and or over local data files.
Learn more about which type of dataset is best for your use case in the <a href="./about_mapstyle_vs_iterable">choosing between a regular dataset or an iterable dataset</a> guide.`,ta,es,za="An iterable dataset from <code>datasets</code> inherits from <code>torch.utils.data.IterableDataset</code> so you can pass it to a <code>torch.utils.data.DataLoader</code>:",ea,ls,la,ns,xa="If the dataset is split in several shards (i.e. if the dataset consists of multiple data files), then you can stream in parallel using <code>num_workers</code>:",na,ps,pa,rs,Na="In this case each worker is given a subset of the list of shards to stream from.",ra,cs,Va='If you need a DataLoader that you can checkpoint and resume in the middle of training, you can use the <code>StatefulDataLoader</code> from <a href="https://github.com/pytorch/data" rel="nofollow">torchdata</a>:',ca,hs,ha,ms,Wa='This is possible thanks to <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.state_dict">IterableDataset.state_dict()</a> and <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.load_state_dict">IterableDataset.load_state_dict()</a>.',ma,is,ia,ds,qa='To split your dataset across your training nodes, you can use <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.distributed.split_dataset_by_node">datasets.distributed.split_dataset_by_node()</a>:',da,os,oa,us,Ea=`This works for both map-style datasets and iterable datasets.
The dataset is split for the node at rank <code>rank</code> in a pool of nodes of size <code>world_size</code>.`,ua,js,Ba="For map-style datasets:",ja,gs,Da="Each node is assigned a chunk of data, e.g. rank 0 is given the first chunk of the dataset.",ga,Js,Ha="For iterable datasets:",Ja,ys,Sa=`If the dataset has a number of shards that is a factor of <code>world_size</code> (i.e. if <code>dataset.n_shards % world_size == 0</code>),
then the shards are evenly assigned across the nodes, which is the most optimized.
Otherwise, each node keeps 1 example out of <code>world_size</code>, skipping the other examples.`,ya,Ms,La="This can also be combined with a <code>torch.utils.data.DataLoader</code> if you want each node to use multiple workers to load the data.",Ma,bs,ba,ws,wa;return I=new b({props:{title:"Use with PyTorch",local:"use-with-pytorch",headingTag:"h1"}}),R=new b({props:{title:"Dataset format",local:"dataset-format",headingTag:"h2"}}),G=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRvcmNoJTIyKSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>])}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
         [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])}`,wrap:!1}}),T=new Ta({props:{$$slots:{default:[ct]},$$scope:{ctx:w}}}),Z=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiUyQyUyMGRldmljZSUzRGRldmljZSklMEFkcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>, device=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], device=<span class="hljs-string">&#x27;cuda:0&#x27;</span>)}`,wrap:!1}}),X=new b({props:{title:"N-dimensional arrays",local:"n-dimensional-arrays",headingTag:"h2"}}),Q=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUyMCUyMCUyMyUyMGZpeGVkJTIwc2hhcGUlMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmRhdGElMjIlM0ElMjBkYXRhJTdEKSUwQWRzJTIwJTNEJTIwZHMud2l0aF9mb3JtYXQoJTIydG9yY2glMjIpJTBBZHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],[[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]  <span class="hljs-comment"># fixed shape</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
         [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])}`,wrap:!1}}),Y=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlNUQlNUQlMkMlNUIlNUI0JTJDJTIwNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUyMCUyMCUyMyUyMHZhcnlpbmclMjBzaGFwZSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElN0QpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMEFkcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>]],[[<span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]  <span class="hljs-comment"># varying shape</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: [tensor([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]), tensor([<span class="hljs-number">3</span>])]}`,wrap:!1}}),z=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXJyYXkyRCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyZGF0YSUyMiUzQSUyMEFycmF5MkQoc2hhcGUlM0QoMiUyQyUyMDIpJTJDJTIwZHR5cGUlM0QnaW50MzInKSU3RCklMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmRhdGElMjIlM0ElMjBkYXRhJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRvcmNoJTIyKSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Array2D
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],[[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;data&quot;</span>: Array2D(shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=<span class="hljs-string">&#x27;int32&#x27;</span>)})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data}, features=features)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
         [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
          [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],
 
         [[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],
          [<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]])}`,wrap:!1}}),x=new b({props:{title:"Other feature types",local:"other-feature-types",headingTag:"h2"}}),V=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQ2xhc3NMYWJlbCUwQWxhYmVscyUyMCUzRCUyMCU1QjAlMkMlMjAwJTJDJTIwMSU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIybGFiZWwlMjIlM0ElMjBDbGFzc0xhYmVsKG5hbWVzJTNEJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJsYWJlbCUyMiUzQSUyMGxhYmVscyU3RCUyQyUyMGZlYXR1cmVzJTNEZmVhdHVyZXMpJTIwJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMjAlMjAlMEFkcyU1QiUzQTMlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, ClassLabel
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;label&quot;</span>: ClassLabel(names=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>])})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;label&quot;</span>: labels}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>])}`,wrap:!1}}),f=new Ta({props:{$$slots:{default:[ht]},$$scope:{ctx:w}}}),E=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMkMlMjBJbWFnZSUwQWltYWdlcyUyMCUzRCUyMCU1QiUyMnBhdGglMkZ0byUyRmltYWdlLnBuZyUyMiU1RCUyMColMjAxMCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyaW1hZ2UlMjIlM0ElMjBJbWFnZSgpJTdEKSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyaW1hZ2UlMjIlM0ElMjBpbWFnZXMlN0QlMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUyMCUwQWRzJTIwJTNEJTIwZHMud2l0aF9mb3JtYXQoJTIydG9yY2glMjIpJTBBZHMlNUIwJTVEJTVCJTIyaW1hZ2UlMjIlNUQuc2hhcGUlMEFkcyU1QjAlNUQlMEFkcyU1QiUzQTIlNUQlNUIlMjJpbWFnZSUyMiU1RC5zaGFwZSUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [<span class="hljs-string">&quot;path/to/image.png&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;image&quot;</span>: Image()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;image&quot;</span>: images}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>].shape
torch.Size([<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">4</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: tensor([[[<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
         [<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
         ...,
         [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
         [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]], dtype=torch.uint8)}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;image&quot;</span>].shape
torch.Size([<span class="hljs-number">2</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">4</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: tensor([[[[<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
          [<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
          ...,
          [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
          [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]]], dtype=torch.uint8)}`,wrap:!1}}),U=new Ta({props:{$$slots:{default:[mt]},$$scope:{ctx:w}}}),B=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMkMlMjBJbWFnZSUwQWF1ZGlvJTIwJTNEJTIwJTVCJTIycGF0aCUyRnRvJTJGYXVkaW8ud2F2JTIyJTVEJTIwKiUyMDEwJTBBZmVhdHVyZXMlMjAlM0QlMjBGZWF0dXJlcyglN0IlMjJhdWRpbyUyMiUzQSUyMEF1ZGlvKCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhdWRpbyUyMiUzQSUyMGF1ZGlvJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMjAlMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRvcmNoJTIyKSUyMCUyMCUwQWRzJTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMEFkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = [<span class="hljs-string">&quot;path/to/audio.wav&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;audio&quot;</span>: Audio()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: audio}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
tensor([ <span class="hljs-number">6.1035e-05</span>,  <span class="hljs-number">1.5259e-05</span>,  <span class="hljs-number">1.6785e-04</span>,  ..., -<span class="hljs-number">1.5259e-05</span>,
        -<span class="hljs-number">1.5259e-05</span>,  <span class="hljs-number">1.5259e-05</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]
tensor(<span class="hljs-number">44100</span>)`,wrap:!1}}),D=new b({props:{title:"Data loading",local:"data-loading",headingTag:"h2"}}),S=new J({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyMCUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhJTIwaW1wb3J0JTIwRGF0YUxvYWRlciUwQWRhdGElMjAlM0QlMjBucC5yYW5kb20ucmFuZCgxNiklMEFsYWJlbCUyMCUzRCUyMG5wLnJhbmRvbS5yYW5kaW50KDAlMkMlMjAyJTJDJTIwc2l6ZSUzRDE2KSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElMkMlMjAlMjJsYWJlbCUyMiUzQSUyMGxhYmVsJTdEKS53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMEFkYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihkcyUyQyUyMGJhdGNoX3NpemUlM0Q0KSUwQWZvciUyMGJhdGNoJTIwaW4lMjBkYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoYmF0Y2gpJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIw",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span>data = np.random.rand(<span class="hljs-number">16</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>label = np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, size=<span class="hljs-number">16</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data, <span class="hljs-string">&quot;label&quot;</span>: label}).with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(ds, batch_size=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(batch)                                                                                            
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">0.0047</span>, <span class="hljs-number">0.4979</span>, <span class="hljs-number">0.6726</span>, <span class="hljs-number">0.8105</span>]), <span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>])}
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">0.4832</span>, <span class="hljs-number">0.2723</span>, <span class="hljs-number">0.4259</span>, <span class="hljs-number">0.2224</span>]), <span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>])}
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">0.5837</span>, <span class="hljs-number">0.3444</span>, <span class="hljs-number">0.4658</span>, <span class="hljs-number">0.6417</span>]), <span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>])}
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">0.7022</span>, <span class="hljs-number">0.1225</span>, <span class="hljs-number">0.7228</span>, <span class="hljs-number">0.8259</span>]), <span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>])}`,wrap:!1}}),L=new b({props:{title:"Optimize data loading",local:"optimize-data-loading",headingTag:"h3"}}),P=new b({props:{title:"Use multiple Workers",local:"use-multiple-workers",headingTag:"h4"}}),ss=new J({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMGxvYWRfZnJvbV9kaXNrJTBBZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBZGF0YSUyMCUzRCUyMG5wLnJhbmRvbS5yYW5kKDEwXzAwMCklMEFEYXRhc2V0LmZyb21fZGljdCglN0IlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCkuc2F2ZV90b19kaXNrKCUyMm15X2RhdGFzZXQlMjIpJTBBZHMlMjAlM0QlMjBsb2FkX2Zyb21fZGlzayglMjJteV9kYXRhc2V0JTIyKS53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMEFkYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihkcyUyQyUyMGJhdGNoX3NpemUlM0QzMiUyQyUyMG51bV93b3JrZXJzJTNENCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, load_from_disk
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span>data = np.random.rand(<span class="hljs-number">10_000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data}).save_to_disk(<span class="hljs-string">&quot;my_dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_from_disk(<span class="hljs-string">&quot;my_dataset&quot;</span>).with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(ds, batch_size=<span class="hljs-number">32</span>, num_workers=<span class="hljs-number">4</span>)`,wrap:!1}}),as=new b({props:{title:"Stream data",local:"stream-data",headingTag:"h3"}}),ls=new J({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhJTIwaW1wb3J0JTIwRGF0YUxvYWRlciUwQWRhdGElMjAlM0QlMjBucC5yYW5kb20ucmFuZCgxMF8wMDApJTBBRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElN0QpLnB1c2hfdG9faHViKCUyMiUzQ3VzZXJuYW1lJTNFJTJGbXlfZGF0YXNldCUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB0byUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTBBbXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjIlM0N1c2VybmFtZSUzRSUyRm15X2RhdGFzZXQlMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihteV9pdGVyYWJsZV9kYXRhc2V0JTJDJTIwYmF0Y2hfc2l6ZSUzRDMyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span>data = np.random.rand(<span class="hljs-number">10_000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data}).push_to_hub(<span class="hljs-string">&quot;&lt;username&gt;/my_dataset&quot;</span>)  <span class="hljs-comment"># Upload to the Hugging Face Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;&lt;username&gt;/my_dataset&quot;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(my_iterable_dataset, batch_size=<span class="hljs-number">32</span>)`,wrap:!1}}),ps=new J({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJkZWVwbWluZCUyRmNvZGVfY29udGVzdHMlMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFteV9pdGVyYWJsZV9kYXRhc2V0Lm5fc2hhcmRzJTBBZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIobXlfaXRlcmFibGVfZGF0YXNldCUyQyUyMGJhdGNoX3NpemUlM0QzMiUyQyUyMG51bV93b3JrZXJzJTNENCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;deepmind/code_contests&quot;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>my_iterable_dataset.n_shards
<span class="hljs-number">39</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(my_iterable_dataset, batch_size=<span class="hljs-number">32</span>, num_workers=<span class="hljs-number">4</span>)`,wrap:!1}}),hs=new J({props:{code:"ZnJvbSUyMHRvcmNoZGF0YS5zdGF0ZWZ1bF9kYXRhbG9hZGVyJTIwaW1wb3J0JTIwU3RhdGVmdWxEYXRhTG9hZGVyJTBBbXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJkZWVwbWluZCUyRmNvZGVfY29udGVzdHMlMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhbG9hZGVyJTIwJTNEJTIwU3RhdGVmdWxEYXRhTG9hZGVyKG15X2l0ZXJhYmxlX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEMzIlMkMlMjBudW1fd29ya2VycyUzRDQpJTBBJTIzJTIwc2F2ZSUyMGluJTIwdGhlJTIwbWlkZGxlJTIwb2YlMjB0cmFpbmluZyUwQXN0YXRlX2RpY3QlMjAlM0QlMjBkYXRhbG9hZGVyLnN0YXRlX2RpY3QoKSUwQSUyMyUyMGFuZCUyMHJlc3VtZSUyMGxhdGVyJTBBZGF0YWxvYWRlci5sb2FkX3N0YXRlX2RpY3Qoc3RhdGVfZGljdCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchdata.stateful_dataloader <span class="hljs-keyword">import</span> StatefulDataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span>my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;deepmind/code_contests&quot;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = StatefulDataLoader(my_iterable_dataset, batch_size=<span class="hljs-number">32</span>, num_workers=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save in the middle of training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>state_dict = dataloader.state_dict()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and resume later</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader.load_state_dict(state_dict)`,wrap:!1}}),is=new b({props:{title:"Distributed",local:"distributed",headingTag:"h3"}}),os=new J({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZGF0YXNldHMuZGlzdHJpYnV0ZWQlMjBpbXBvcnQlMjBzcGxpdF9kYXRhc2V0X2J5X25vZGUlMEElMEFkcyUyMCUzRCUyMHNwbGl0X2RhdGFzZXRfYnlfbm9kZShkcyUyQyUyMHJhbmslM0RpbnQob3MuZW52aXJvbiU1QiUyMlJBTkslMjIlNUQpJTJDJTIwd29ybGRfc2l6ZSUzRGludChvcy5lbnZpcm9uJTVCJTIyV09STERfU0laRSUyMiU1RCkp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> datasets.distributed <span class="hljs-keyword">import</span> split_dataset_by_node

ds = split_dataset_by_node(ds, rank=<span class="hljs-built_in">int</span>(os.environ[<span class="hljs-string">&quot;RANK&quot;</span>]), world_size=<span class="hljs-built_in">int</span>(os.environ[<span class="hljs-string">&quot;WORLD_SIZE&quot;</span>]))`,wrap:!1}}),bs=new rt({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/use_with_pytorch.mdx"}}),{c(){p=r("meta"),y=l(),g=r("p"),M=l(),m(I.$$.fragment),Ts=l(),$=r("p"),$.innerHTML=Ua,fs=l(),m(R.$$.fragment),Us=l(),k=r("p"),k.textContent=Ia,Is=l(),C=r("p"),C.innerHTML=$a,$s=l(),m(G.$$.fragment),Rs=l(),m(T.$$.fragment),ks=l(),_=r("p"),_.innerHTML=Ra,Cs=l(),m(Z.$$.fragment),Gs=l(),m(X.$$.fragment),_s=l(),v=r("p"),v.textContent=ka,Zs=l(),m(Q.$$.fragment),Xs=l(),m(Y.$$.fragment),vs=l(),F=r("p"),F.innerHTML=Ca,Qs=l(),m(z.$$.fragment),Ys=l(),m(x.$$.fragment),Fs=l(),N=r("p"),N.innerHTML=Ga,zs=l(),m(V.$$.fragment),xs=l(),W=r("p"),W.textContent=_a,Ns=l(),q=r("p"),q.innerHTML=Za,Vs=l(),m(f.$$.fragment),Ws=l(),m(E.$$.fragment),qs=l(),m(U.$$.fragment),Es=l(),m(B.$$.fragment),Bs=l(),m(D.$$.fragment),Ds=l(),H=r("p"),H.innerHTML=Xa,Hs=l(),m(S.$$.fragment),Ss=l(),m(L.$$.fragment),Ls=l(),A=r("p"),A.textContent=va,As=l(),m(P.$$.fragment),Ps=l(),K=r("p"),K.innerHTML=Qa,Ks=l(),O=r("p"),O.innerHTML=Ya,Os=l(),m(ss.$$.fragment),sa=l(),m(as.$$.fragment),aa=l(),ts=r("p"),ts.innerHTML=Fa,ta=l(),es=r("p"),es.innerHTML=za,ea=l(),m(ls.$$.fragment),la=l(),ns=r("p"),ns.innerHTML=xa,na=l(),m(ps.$$.fragment),pa=l(),rs=r("p"),rs.textContent=Na,ra=l(),cs=r("p"),cs.innerHTML=Va,ca=l(),m(hs.$$.fragment),ha=l(),ms=r("p"),ms.innerHTML=Wa,ma=l(),m(is.$$.fragment),ia=l(),ds=r("p"),ds.innerHTML=qa,da=l(),m(os.$$.fragment),oa=l(),us=r("p"),us.innerHTML=Ea,ua=l(),js=r("p"),js.textContent=Ba,ja=l(),gs=r("p"),gs.textContent=Da,ga=l(),Js=r("p"),Js.textContent=Ha,Ja=l(),ys=r("p"),ys.innerHTML=Sa,ya=l(),Ms=r("p"),Ms.innerHTML=La,Ma=l(),m(bs.$$.fragment),ba=l(),ws=r("p"),this.h()},l(s){const a=nt("svelte-u9bgzb",document.head);p=c(a,"META",{name:!0,content:!0}),a.forEach(t),y=n(s),g=c(s,"P",{}),Oa(g).forEach(t),M=n(s),i(I.$$.fragment,s),Ts=n(s),$=c(s,"P",{"data-svelte-h":!0}),h($)!=="svelte-1116k3w"&&($.innerHTML=Ua),fs=n(s),i(R.$$.fragment,s),Us=n(s),k=c(s,"P",{"data-svelte-h":!0}),h(k)!=="svelte-j9f3ms"&&(k.textContent=Ia),Is=n(s),C=c(s,"P",{"data-svelte-h":!0}),h(C)!=="svelte-11qfj0n"&&(C.innerHTML=$a),$s=n(s),i(G.$$.fragment,s),Rs=n(s),i(T.$$.fragment,s),ks=n(s),_=c(s,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1ezbzoy"&&(_.innerHTML=Ra),Cs=n(s),i(Z.$$.fragment,s),Gs=n(s),i(X.$$.fragment,s),_s=n(s),v=c(s,"P",{"data-svelte-h":!0}),h(v)!=="svelte-smjp9l"&&(v.textContent=ka),Zs=n(s),i(Q.$$.fragment,s),Xs=n(s),i(Y.$$.fragment,s),vs=n(s),F=c(s,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1gw41y9"&&(F.innerHTML=Ca),Qs=n(s),i(z.$$.fragment,s),Ys=n(s),i(x.$$.fragment,s),Fs=n(s),N=c(s,"P",{"data-svelte-h":!0}),h(N)!=="svelte-jvjwyo"&&(N.innerHTML=Ga),zs=n(s),i(V.$$.fragment,s),xs=n(s),W=c(s,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1hobffv"&&(W.textContent=_a),Ns=n(s),q=c(s,"P",{"data-svelte-h":!0}),h(q)!=="svelte-1z1new"&&(q.innerHTML=Za),Vs=n(s),i(f.$$.fragment,s),Ws=n(s),i(E.$$.fragment,s),qs=n(s),i(U.$$.fragment,s),Es=n(s),i(B.$$.fragment,s),Bs=n(s),i(D.$$.fragment,s),Ds=n(s),H=c(s,"P",{"data-svelte-h":!0}),h(H)!=="svelte-laso34"&&(H.innerHTML=Xa),Hs=n(s),i(S.$$.fragment,s),Ss=n(s),i(L.$$.fragment,s),Ls=n(s),A=c(s,"P",{"data-svelte-h":!0}),h(A)!=="svelte-nw1d6c"&&(A.textContent=va),As=n(s),i(P.$$.fragment,s),Ps=n(s),K=c(s,"P",{"data-svelte-h":!0}),h(K)!=="svelte-1wyypch"&&(K.innerHTML=Qa),Ks=n(s),O=c(s,"P",{"data-svelte-h":!0}),h(O)!=="svelte-1u9vub"&&(O.innerHTML=Ya),Os=n(s),i(ss.$$.fragment,s),sa=n(s),i(as.$$.fragment,s),aa=n(s),ts=c(s,"P",{"data-svelte-h":!0}),h(ts)!=="svelte-1ptu4lc"&&(ts.innerHTML=Fa),ta=n(s),es=c(s,"P",{"data-svelte-h":!0}),h(es)!=="svelte-1t3p6zv"&&(es.innerHTML=za),ea=n(s),i(ls.$$.fragment,s),la=n(s),ns=c(s,"P",{"data-svelte-h":!0}),h(ns)!=="svelte-gqi02o"&&(ns.innerHTML=xa),na=n(s),i(ps.$$.fragment,s),pa=n(s),rs=c(s,"P",{"data-svelte-h":!0}),h(rs)!=="svelte-i7csup"&&(rs.textContent=Na),ra=n(s),cs=c(s,"P",{"data-svelte-h":!0}),h(cs)!=="svelte-1x5nhsq"&&(cs.innerHTML=Va),ca=n(s),i(hs.$$.fragment,s),ha=n(s),ms=c(s,"P",{"data-svelte-h":!0}),h(ms)!=="svelte-aoxzye"&&(ms.innerHTML=Wa),ma=n(s),i(is.$$.fragment,s),ia=n(s),ds=c(s,"P",{"data-svelte-h":!0}),h(ds)!=="svelte-1tblw4x"&&(ds.innerHTML=qa),da=n(s),i(os.$$.fragment,s),oa=n(s),us=c(s,"P",{"data-svelte-h":!0}),h(us)!=="svelte-utgciv"&&(us.innerHTML=Ea),ua=n(s),js=c(s,"P",{"data-svelte-h":!0}),h(js)!=="svelte-1a3gkys"&&(js.textContent=Ba),ja=n(s),gs=c(s,"P",{"data-svelte-h":!0}),h(gs)!=="svelte-41cx6v"&&(gs.textContent=Da),ga=n(s),Js=c(s,"P",{"data-svelte-h":!0}),h(Js)!=="svelte-1kujsme"&&(Js.textContent=Ha),Ja=n(s),ys=c(s,"P",{"data-svelte-h":!0}),h(ys)!=="svelte-nsc411"&&(ys.innerHTML=Sa),ya=n(s),Ms=c(s,"P",{"data-svelte-h":!0}),h(Ms)!=="svelte-19jtkan"&&(Ms.innerHTML=La),Ma=n(s),i(bs.$$.fragment,s),ba=n(s),ws=c(s,"P",{}),Oa(ws).forEach(t),this.h()},h(){st(p,"name","hf:doc:metadata"),st(p,"content",dt)},m(s,a){pt(document.head,p),e(s,y,a),e(s,g,a),e(s,M,a),d(I,s,a),e(s,Ts,a),e(s,$,a),e(s,fs,a),d(R,s,a),e(s,Us,a),e(s,k,a),e(s,Is,a),e(s,C,a),e(s,$s,a),d(G,s,a),e(s,Rs,a),d(T,s,a),e(s,ks,a),e(s,_,a),e(s,Cs,a),d(Z,s,a),e(s,Gs,a),d(X,s,a),e(s,_s,a),e(s,v,a),e(s,Zs,a),d(Q,s,a),e(s,Xs,a),d(Y,s,a),e(s,vs,a),e(s,F,a),e(s,Qs,a),d(z,s,a),e(s,Ys,a),d(x,s,a),e(s,Fs,a),e(s,N,a),e(s,zs,a),d(V,s,a),e(s,xs,a),e(s,W,a),e(s,Ns,a),e(s,q,a),e(s,Vs,a),d(f,s,a),e(s,Ws,a),d(E,s,a),e(s,qs,a),d(U,s,a),e(s,Es,a),d(B,s,a),e(s,Bs,a),d(D,s,a),e(s,Ds,a),e(s,H,a),e(s,Hs,a),d(S,s,a),e(s,Ss,a),d(L,s,a),e(s,Ls,a),e(s,A,a),e(s,As,a),d(P,s,a),e(s,Ps,a),e(s,K,a),e(s,Ks,a),e(s,O,a),e(s,Os,a),d(ss,s,a),e(s,sa,a),d(as,s,a),e(s,aa,a),e(s,ts,a),e(s,ta,a),e(s,es,a),e(s,ea,a),d(ls,s,a),e(s,la,a),e(s,ns,a),e(s,na,a),d(ps,s,a),e(s,pa,a),e(s,rs,a),e(s,ra,a),e(s,cs,a),e(s,ca,a),d(hs,s,a),e(s,ha,a),e(s,ms,a),e(s,ma,a),d(is,s,a),e(s,ia,a),e(s,ds,a),e(s,da,a),d(os,s,a),e(s,oa,a),e(s,us,a),e(s,ua,a),e(s,js,a),e(s,ja,a),e(s,gs,a),e(s,ga,a),e(s,Js,a),e(s,Ja,a),e(s,ys,a),e(s,ya,a),e(s,Ms,a),e(s,Ma,a),d(bs,s,a),e(s,ba,a),e(s,ws,a),wa=!0},p(s,[a]){const Aa={};a&2&&(Aa.$$scope={dirty:a,ctx:s}),T.$set(Aa);const Pa={};a&2&&(Pa.$$scope={dirty:a,ctx:s}),f.$set(Pa);const Ka={};a&2&&(Ka.$$scope={dirty:a,ctx:s}),U.$set(Ka)},i(s){wa||(o(I.$$.fragment,s),o(R.$$.fragment,s),o(G.$$.fragment,s),o(T.$$.fragment,s),o(Z.$$.fragment,s),o(X.$$.fragment,s),o(Q.$$.fragment,s),o(Y.$$.fragment,s),o(z.$$.fragment,s),o(x.$$.fragment,s),o(V.$$.fragment,s),o(f.$$.fragment,s),o(E.$$.fragment,s),o(U.$$.fragment,s),o(B.$$.fragment,s),o(D.$$.fragment,s),o(S.$$.fragment,s),o(L.$$.fragment,s),o(P.$$.fragment,s),o(ss.$$.fragment,s),o(as.$$.fragment,s),o(ls.$$.fragment,s),o(ps.$$.fragment,s),o(hs.$$.fragment,s),o(is.$$.fragment,s),o(os.$$.fragment,s),o(bs.$$.fragment,s),wa=!0)},o(s){u(I.$$.fragment,s),u(R.$$.fragment,s),u(G.$$.fragment,s),u(T.$$.fragment,s),u(Z.$$.fragment,s),u(X.$$.fragment,s),u(Q.$$.fragment,s),u(Y.$$.fragment,s),u(z.$$.fragment,s),u(x.$$.fragment,s),u(V.$$.fragment,s),u(f.$$.fragment,s),u(E.$$.fragment,s),u(U.$$.fragment,s),u(B.$$.fragment,s),u(D.$$.fragment,s),u(S.$$.fragment,s),u(L.$$.fragment,s),u(P.$$.fragment,s),u(ss.$$.fragment,s),u(as.$$.fragment,s),u(ls.$$.fragment,s),u(ps.$$.fragment,s),u(hs.$$.fragment,s),u(is.$$.fragment,s),u(os.$$.fragment,s),u(bs.$$.fragment,s),wa=!1},d(s){s&&(t(y),t(g),t(M),t(Ts),t($),t(fs),t(Us),t(k),t(Is),t(C),t($s),t(Rs),t(ks),t(_),t(Cs),t(Gs),t(_s),t(v),t(Zs),t(Xs),t(vs),t(F),t(Qs),t(Ys),t(Fs),t(N),t(zs),t(xs),t(W),t(Ns),t(q),t(Vs),t(Ws),t(qs),t(Es),t(Bs),t(Ds),t(H),t(Hs),t(Ss),t(Ls),t(A),t(As),t(Ps),t(K),t(Ks),t(O),t(Os),t(sa),t(aa),t(ts),t(ta),t(es),t(ea),t(la),t(ns),t(na),t(pa),t(rs),t(ra),t(cs),t(ca),t(ha),t(ms),t(ma),t(ia),t(ds),t(da),t(oa),t(us),t(ua),t(js),t(ja),t(gs),t(ga),t(Js),t(Ja),t(ys),t(ya),t(Ms),t(Ma),t(ba),t(ws)),t(p),j(I,s),j(R,s),j(G,s),j(T,s),j(Z,s),j(X,s),j(Q,s),j(Y,s),j(z,s),j(x,s),j(V,s),j(f,s),j(E,s),j(U,s),j(B,s),j(D,s),j(S,s),j(L,s),j(P,s),j(ss,s),j(as,s),j(ls,s),j(ps,s),j(hs,s),j(is,s),j(os,s),j(bs,s)}}}const dt='{"title":"Use with PyTorch","local":"use-with-pytorch","sections":[{"title":"Dataset format","local":"dataset-format","sections":[],"depth":2},{"title":"N-dimensional arrays","local":"n-dimensional-arrays","sections":[],"depth":2},{"title":"Other feature types","local":"other-feature-types","sections":[],"depth":2},{"title":"Data loading","local":"data-loading","sections":[{"title":"Optimize data loading","local":"optimize-data-loading","sections":[{"title":"Use multiple Workers","local":"use-multiple-workers","sections":[],"depth":4}],"depth":3},{"title":"Stream data","local":"stream-data","sections":[],"depth":3},{"title":"Distributed","local":"distributed","sections":[],"depth":3}],"depth":2}],"depth":1}';function ot(w){return tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mt extends et{constructor(p){super(),lt(this,p,ot,it,at,{})}}export{Mt as component};
