import{s as Lt,o as Et,n as ra}from"../chunks/scheduler.bdbef820.js";import{S as At,i as qt,g as r,s as l,r as h,A as Kt,h as c,f as e,c as n,j as qe,u as m,x as d,k as Ae,y as Pt,a as t,v as o,d as f,t as u,w as g}from"../chunks/index.c0aea24a.js";import{T as da}from"../chunks/Tip.31005f7d.js";import{C as M}from"../chunks/CodeBlock.6ccca92e.js";import{F as Ot,M as sl}from"../chunks/Markdown.1f17db59.js";import{H as T,E as al}from"../chunks/EditOnGithub.725ee0c1.js";function el(w){let p,j=`An <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is useful for iterative jobs like training a model.
You shouldn’t use a <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> for jobs that require random access to examples because you have to iterate all over it using a for loop. Getting the last example in an iterable dataset would require you to iterate over all the previous examples.
You can find more details in the <a href="./about_mapstyle_vs_iterable">Dataset vs. IterableDataset guide</a>.`;return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1bd0ijw"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:ra,d(i){i&&e(p)}}}function tl(w){let p,j='<a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a> will also shuffle the order of the shards if the dataset is sharded into multiple files.';return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),d(p)!=="svelte-qnrc7b"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:ra,d(i){i&&e(p)}}}function ll(w){let p,j="<code>take</code> and <code>skip</code> prevent future calls to <code>shuffle</code> because they lock in the order of the shards. You should <code>shuffle</code> your dataset before splitting it.";return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kg825l"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:ra,d(i){i&&e(p)}}}function nl(w){let p,j="Casting only works if the original feature type and new feature type are compatible. For example, you can cast a column with the feature type <code>Value(&#39;int32&#39;)</code> to <code>Value(&#39;bool&#39;)</code> if the original column only contains ones and zeros.";return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),d(p)!=="svelte-19jja92"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:ra,d(i){i&&e(p)}}}function pl(w){let p,j='See other examples of batch processing in the <a href="./process#batch-processing">batched map processing</a> documentation. They work the same for iterable datasets.';return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),d(p)!=="svelte-csithm"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:ra,d(i){i&&e(p)}}}function il(w){let p,j,i,b="Lastly, create a simple training loop and start training:",J,x,_;return p=new M({props:{code:"c2VlZCUyQyUyMGJ1ZmZlcl9zaXplJTIwJTNEJTIwNDIlMkMlMjAxMF8wMDAlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zaHVmZmxlKHNlZWQlMkMlMjBidWZmZXJfc2l6ZSUzRGJ1ZmZlcl9zaXplKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>seed, buffer_size = <span class="hljs-number">42</span>, <span class="hljs-number">10_000</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.shuffle(seed, buffer_size=buffer_size)`,wrap:!1}}),x=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yTWFza2VkTE0lMkMlMjBEYXRhQ29sbGF0b3JGb3JMYW5ndWFnZU1vZGVsaW5nJTBBZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQud2l0aF9mb3JtYXQoJTIydG9yY2glMjIpJTBBZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZGF0YXNldCUyQyUyMGNvbGxhdGVfZm4lM0REYXRhQ29sbGF0b3JGb3JMYW5ndWFnZU1vZGVsaW5nKHRva2VuaXplcikpJTBBZGV2aWNlJTIwJTNEJTIwJ2N1ZGEnJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCdjcHUnJTIwJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBbW9kZWwudHJhaW4oKS50byhkZXZpY2UpJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcocGFyYW1zJTNEbW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QxZS01KSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMGRhdGFzZXQuc2V0X2Vwb2NoKGVwb2NoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGklMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKHRxZG0oZGF0YWxvYWRlciUyQyUyMHRvdGFsJTNENSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTNEJTNEJTIwNSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cyU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTI1JTIwMTAlMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMmxvc3MlM0ElMjAlN0Jsb3NzJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForMaskedLM, DataCollatorForLanguageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(dataset, collate_fn=DataCollatorForLanguageModeling(tokenizer))
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span> 
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.train().to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.AdamW(params=model.parameters(), lr=<span class="hljs-number">1e-5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
<span class="hljs-meta">... </span>    dataset.set_epoch(epoch)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(dataloader, total=<span class="hljs-number">5</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i == <span class="hljs-number">5</span>:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        loss.backward()
<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i % <span class="hljs-number">10</span> == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;loss: <span class="hljs-subst">{loss}</span>&quot;</span>)`,wrap:!1}}),{c(){h(p.$$.fragment),j=l(),i=r("p"),i.textContent=b,J=l(),h(x.$$.fragment)},l(y){m(p.$$.fragment,y),j=n(y),i=c(y,"P",{"data-svelte-h":!0}),d(i)!=="svelte-uyzjf"&&(i.textContent=b),J=n(y),m(x.$$.fragment,y)},m(y,$){o(p,y,$),t(y,j,$),t(y,i,$),t(y,J,$),o(x,y,$),_=!0},p:ra,i(y){_||(f(p.$$.fragment,y),f(x.$$.fragment,y),_=!0)},o(y){u(p.$$.fragment,y),u(x.$$.fragment,y),_=!1},d(y){y&&(e(j),e(i),e(J)),g(p,y),g(x,y)}}}function rl(w){let p,j;return p=new sl({props:{$$slots:{default:[il]},$$scope:{ctx:w}}}),{c(){h(p.$$.fragment)},l(i){m(p.$$.fragment,i)},m(i,b){o(p,i,b),j=!0},p(i,b){const J={};b&2&&(J.$$scope={dirty:b,ctx:i}),p.$set(J)},i(i){j||(f(p.$$.fragment,i),j=!0)},o(i){u(p.$$.fragment,i),j=!1},d(i){g(p,i)}}}function cl(w){let p,j="Resuming returns exactly where the checkpoint was saved except if <code>.shuffle()</code> is used: examples from shuffle buffers are lost when resuming and the buffers are refilled with new data.";return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1aaqobe"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:ra,d(i){i&&e(p)}}}function dl(w){let p,j,i,b,J,x,_,y=`Dataset streaming lets you work with a dataset without downloading it.
The data is streamed as you iterate over the dataset.
This is especially helpful when:`,$,v,Ke="<li>You don’t want to wait for an extremely large dataset to download.</li> <li>The dataset size exceeds the amount of available disk space on your computer.</li> <li>You want to quickly explore just a few samples of a dataset.</li>",ma,k,Pe='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/streaming.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/streaming-dark.gif"/>',oa,F,Oe='For example, the English split of the <a href="https://huggingface.co/datasets/oscar-corpus/OSCAR-2201" rel="nofollow">oscar-corpus/OSCAR-2201</a> dataset is 1.2 terabytes, but you can use it instantly with streaming. Stream a dataset by setting <code>streaming=True</code> in <a href="/docs/datasets/pr_7028/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a> as shown below:',fa,Y,ua,V,st=`Dataset streaming also lets you work with a dataset made of local files without doing any conversion.
In this case, the data is streamed from the local files as you iterate over the dataset.
This is especially helpful when:`,ga,W,at="<li>You don’t want to wait for an extremely large local dataset to be converted to Arrow.</li> <li>The converted files size would exceed the amount of available disk space on your computer.</li> <li>You want to quickly explore just a few samples of a dataset.</li>",ja,z,et='For example, you can stream a local dataset of hundreds of compressed JSONL files like <a href="https://huggingface.co/datasets/oscar-corpus/OSCAR-2201" rel="nofollow">oscar-corpus/OSCAR-2201</a> to use it instantly:',Ma,B,ba,N,tt=`Loading a dataset in streaming mode creates a new dataset type instance (instead of the classic <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object), known as an <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
This special type of dataset has its own set of processing methods shown below.`,ya,Z,wa,Q,Ta,H,lt='If you have an existing <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, you can convert it to an <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> with the <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Dataset.to_iterable_dataset">to_iterable_dataset()</a> function. This is actually faster than setting the <code>streaming=True</code> argument in <a href="/docs/datasets/pr_7028/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a> because the data is streamed from local files.',Ja,S,xa,D,nt='The <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Dataset.to_iterable_dataset">to_iterable_dataset()</a> function supports sharding when the <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is instantiated. This is useful when working with big datasets, and you’d like to shuffle the dataset or to enable fast parallel loading with a PyTorch DataLoader.',_a,L,$a,E,ka,A,pt='Like a regular <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, you can also shuffle a <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> with <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a>.',Za,q,it='The <code>buffer_size</code> argument controls the size of the buffer to randomly sample examples from. Let’s say your dataset has one million examples, and you set the <code>buffer_size</code> to ten thousand. <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a> will randomly select examples from the first ten thousand examples in the buffer. Selected examples in the buffer are replaced with new examples. By default, the buffer size is 1,000.',Ua,K,Ga,U,Xa,P,Ra,O,rt="Sometimes you may want to reshuffle the dataset after each epoch. This will require you to set a different seed for each epoch. Use <code>IterableDataset.set_epoch()</code> in between epochs to tell the dataset what epoch you’re on.",Ia,ss,ct="Your seed effectively becomes: <code>initial seed + current epoch</code>.",Ca,as,va,es,Fa,ts,dt="You can split your dataset one of two ways:",Ya,ls,ht='<li><a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a> returns the first <code>n</code> examples in a dataset:</li>',Va,ns,Wa,ps,mt='<li><a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.skip">IterableDataset.skip()</a> omits the first <code>n</code> examples in a dataset and returns the remaining examples:</li>',za,is,Ba,G,Na,ca,Qa,rs,Ha,cs,ot='<a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.interleave_datasets">interleave_datasets()</a> can combine an <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> with other datasets. The combined dataset returns alternating examples from each of the original datasets.',Sa,ds,Da,hs,ft="Define sampling probabilities from each of the original datasets for more control over how each of them are sampled and combined. Set the <code>probabilities</code> argument with your desired sampling probabilities:",La,ms,Ea,os,ut="Around 80% of the final dataset is made of the <code>en_dataset</code>, and 20% of the <code>fr_dataset</code>.",Aa,fs,gt=`You can also specify the <code>stopping_strategy</code>. The default strategy, <code>first_exhausted</code>, is a subsampling strategy, i.e the dataset construction is stopped as soon one of the dataset runs out of samples.
You can specify <code>stopping_strategy=all_exhausted</code> to execute an oversampling strategy. In this case, the dataset construction is stopped as soon as every samples in every dataset has been added at least once. In practice, it means that if a dataset is exhausted, it will return to the beginning of this dataset until the stop criterion has been reached.
Note that if no sampling probabilities are specified, the new dataset will have <code>max_length_datasets*nb_dataset samples</code>.`,qa,us,Ka,gs,jt="The following methods allow you to modify the columns of a dataset. These methods are useful for renaming or removing columns and changing columns to a new set of features.",Pa,js,Oa,Ms,Mt='Use <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.rename_column">IterableDataset.rename_column()</a> when you need to rename a column in your dataset. Features associated with the original column are actually moved under the new column name, instead of just replacing the original column in-place.',se,bs,bt='Provide <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.rename_column">IterableDataset.rename_column()</a> with the name of the original column, and the new column name:',ae,ys,ee,ws,te,Ts,yt='When you need to remove one or more columns, give <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.remove_columns">IterableDataset.remove_columns()</a> the name of the column to remove. Remove more than one column by providing a list of column names:',le,Js,ne,xs,pe,_s,wt='<a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.cast">IterableDataset.cast()</a> changes the feature type of one or more columns. This method takes your new <code>Features</code> as its argument. The following sample code shows how to change the feature types of <code>ClassLabel</code> and <code>Value</code>:',ie,$s,re,X,ce,ks,Tt='Use <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.cast_column">IterableDataset.cast_column()</a> to change the feature type of just one column. Pass the column name and its new feature type as arguments:',de,Zs,he,Us,me,Gs,Jt=`Similar to the <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Dataset.map">Dataset.map()</a> function for a regular <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Dataset">Dataset</a>, 🤗  Datasets features <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> for processing an <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
<a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> applies processing on-the-fly when examples are streamed.`,oe,Xs,xt="It allows you to apply a processing function to each example in a dataset, independently or in batches. This function can even create new rows and columns.",fe,Rs,_t='The following example demonstrates how to tokenize a <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>. The function needs to accept and output a <code>dict</code>:',ue,Is,ge,Cs,$t='Next, apply this function to the dataset with <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a>:',je,vs,Me,Fs,kt='Let’s take a look at another example, except this time, you will remove a column with <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a>. When you remove a column, it is only removed after the example has been provided to the mapped function. This allows the mapped function to use the content of the columns before they are removed.',be,Ys,Zt='Specify the column to remove with the <code>remove_columns</code> argument in <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a>:',ye,Vs,we,Ws,Te,zs,Ut='<a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> also supports working with batches of examples. Operate on batches by setting <code>batched=True</code>. The default batch size is 1000, but you can adjust it with the <code>batch_size</code> argument. This opens the door to many interesting applications such as tokenization, splitting long sentences into shorter chunks, and data augmentation.',Je,Bs,xe,Ns,_e,R,$e,Qs,ke,Hs,Gt='You can filter rows in the dataset based on a predicate function using <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Dataset.filter">Dataset.filter()</a>. It returns rows that match a specified condition:',Ze,Ss,Ue,Ds,Xt='<a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.Dataset.filter">Dataset.filter()</a> can also filter by indices if you set <code>with_indices=True</code>:',Ge,Ls,Xe,Es,Re,As,Rt='<a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> can be integrated into a training loop. First, shuffle the dataset:',Ie,I,Ce,qs,ve,Ks,It="If your training loop stops, you may want to restart the training from where it was. To do so you can save a checkpoint of your model and optimizers, as well as your data loader.",Fe,Ps,Ct='Iterable datasets don’t provide random access to a specific example index to resume from, but you can use <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.state_dict">IterableDataset.state_dict()</a> and <a href="/docs/datasets/pr_7028/en/package_reference/main_classes#datasets.IterableDataset.load_state_dict">IterableDataset.load_state_dict()</a> to resume from a checkpoint instead, similarly to what you can do for models and optimizers:',Ye,Os,Ve,sa,vt="Returns:",We,aa,ze,ea,Ft="Under the hood, the iterable dataset keeps track of the current shard being read and the example index in the current shard and it stores this info in the <code>state_dict</code>.",Be,ta,Yt=`To resume from a checkpoint, the dataset skips all the shards that were previously read to restart from the current shard.
Then it reads the shard and skips examples until it reaches the exact example from the checkpoint.`,Ne,la,Vt="Therefore restarting a dataset is quite fast, since it will not re-read the shards that have already been iterated on. Still, resuming a dataset is generally not instantaneous since it has to restart reading from the beginning of the current shard and skip examples until it reaches the checkpoint location.",Qe,na,Wt="This can be used with the <code>StatefulDataLoader</code> from <code>torchdata</code>:",He,pa,Se,C,De,ia,Le,ha,Ee;return J=new T({props:{title:"Stream",local:"stream",headingTag:"h1"}}),Y=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXItY29ycHVzJTJGT1NDQVItMjIwMSclMkMlMjAnZW4nJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFwcmludChuZXh0KGl0ZXIoZGF0YXNldCkpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar-corpus/OSCAR-2201&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset)))
{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Founded in 2015, Golden Bees is a leading programmatic recruitment platform dedicated to employers, HR agencies and job boards. The company has developed unique HR-custom technologies and predictive algorithms to identify and attract the best candidates for a job opportunity.&#x27;</span>, ...`,wrap:!1}}),B=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YV9maWxlcyUyMCUzRCUyMCU3Qid0cmFpbiclM0ElMjAncGF0aCUyRnRvJTJGT1NDQVItMjIwMSUyRmNvbXByZXNzZWQlMkZlbl9tZXRhJTJGKi5qc29ubC5neiclN0QlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCdqc29uJyUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFwcmludChuZXh0KGl0ZXIoZGF0YXNldCkpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data_files = {<span class="hljs-string">&#x27;train&#x27;</span>: <span class="hljs-string">&#x27;path/to/OSCAR-2201/compressed/en_meta/*.jsonl.gz&#x27;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;json&#x27;</span>, data_files=data_files, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset)))
{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Founded in 2015, Golden Bees is a leading programmatic recruitment platform dedicated to employers, HR agencies and job boards. The company has developed unique HR-custom technologies and predictive algorithms to identify and attract the best candidates for a job opportunity.&#x27;</span>, ...`,wrap:!1}}),Z=new da({props:{$$slots:{default:[el]},$$scope:{ctx:w}}}),Q=new T({props:{title:"Convert from a Dataset",local:"convert-from-a-dataset",headingTag:"h2"}}),S=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmb29kMTAxJTIyKSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnRvX2l0ZXJhYmxlX2RhdGFzZXQoKSUwQSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZm9vZDEwMSUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># faster 🐇</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset()

<span class="hljs-comment"># slower 🐢</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>, streaming=<span class="hljs-literal">True</span>)`,wrap:!1}}),L=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZvb2QxMDElMjIpJTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudG9faXRlcmFibGVfZGF0YXNldChudW1fc2hhcmRzJTNENjQpJTIwJTIzJTIwc2hhcmQlMjB0aGUlMjBkYXRhc2V0JTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGl0ZXJhYmxlX2RhdGFzZXQuc2h1ZmZsZShidWZmZXJfc2l6ZSUzRDEwXzAwMCklMjAlMjAlMjMlMjBzaHVmZmxlcyUyMHRoZSUyMHNoYXJkcyUyMG9yZGVyJTIwYW5kJTIwdXNlJTIwYSUyMHNodWZmbGUlMjBidWZmZXIlMjB3aGVuJTIweW91JTIwc3RhcnQlMjBpdGVyYXRpbmc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset(num_shards=<span class="hljs-number">64</span>) <span class="hljs-comment"># shard the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = iterable_dataset.shuffle(buffer_size=<span class="hljs-number">10_000</span>)  <span class="hljs-comment"># shuffles the shards order and use a shuffle buffer when you start iterating</span>
dataloader = torch.utils.data.DataLoader(iterable_dataset, num_workers=<span class="hljs-number">4</span>)  <span class="hljs-comment"># assigns 64 / 4 = 16 shards from the shuffled list of shards to each worker when you start iterating</span>`,wrap:!1}}),E=new T({props:{title:"Shuffle",local:"shuffle",headingTag:"h2"}}),K=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJTIydW5zaHVmZmxlZF9kZWR1cGxpY2F0ZWRfZW4lMjIlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQXNodWZmbGVkX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNodWZmbGUoc2VlZCUzRDQyJTJDJTIwYnVmZmVyX3NpemUlM0QxMF8wMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_en&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>shuffled_dataset = dataset.shuffle(seed=<span class="hljs-number">42</span>, buffer_size=<span class="hljs-number">10_000</span>)`,wrap:!1}}),U=new da({props:{$$slots:{default:[tl]},$$scope:{ctx:w}}}),P=new T({props:{title:"Reshuffle",local:"reshuffle",headingTag:"h2"}}),as=new M({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKGVwb2NocyklM0ElMEElMjAlMjAlMjAlMjBzaHVmZmxlZF9kYXRhc2V0LnNldF9lcG9jaChlcG9jaCklMEElMjAlMjAlMjAlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBzaHVmZmxlZF9kYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(epochs):
<span class="hljs-meta">... </span>    shuffled_dataset.set_epoch(epoch)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> shuffled_dataset:
<span class="hljs-meta">... </span>        ...`,wrap:!1}}),es=new T({props:{title:"Split dataset",local:"split-dataset",headingTag:"h2"}}),ns=new M({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJTIydW5zaHVmZmxlZF9kZWR1cGxpY2F0ZWRfZW4lMjIlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWRhdGFzZXRfaGVhZCUyMCUzRCUyMGRhdGFzZXQudGFrZSgyKSUwQWxpc3QoZGF0YXNldF9oZWFkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_en&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_head = dataset.take(<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(dataset_head)
[{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was...&#x27;</span>}, {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Lily James cannot fight the music...&#x27;</span>}]`,wrap:!1}}),is=new M({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMHNodWZmbGVkX2RhdGFzZXQuc2tpcCgxMDAwKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = shuffled_dataset.skip(<span class="hljs-number">1000</span>)',wrap:!1}}),G=new da({props:{warning:!0,$$slots:{default:[ll]},$$scope:{ctx:w}}}),rs=new T({props:{title:"Interleave",local:"interleave",headingTag:"h2"}}),ds=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyUwQWVuX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJ29zY2FyJyUyQyUyMCUyMnVuc2h1ZmZsZWRfZGVkdXBsaWNhdGVkX2VuJTIyJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFmcl9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCdvc2NhciclMkMlMjAlMjJ1bnNodWZmbGVkX2RlZHVwbGljYXRlZF9mciUyMiUyQyUyMHNwbGl0JTNEJ3RyYWluJyUyQyUyMHN0cmVhbWluZyUzRFRydWUlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBJTBBbXVsdGlsaW5ndWFsX2RhdGFzZXQlMjAlM0QlMjBpbnRlcmxlYXZlX2RhdGFzZXRzKCU1QmVuX2RhdGFzZXQlMkMlMjBmcl9kYXRhc2V0JTVEKSUwQWxpc3QobXVsdGlsaW5ndWFsX2RhdGFzZXQudGFrZSgyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> interleave_datasets
<span class="hljs-meta">&gt;&gt;&gt; </span>en_dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_en&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fr_dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_fr&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>multilingual_dataset = interleave_datasets([en_dataset, fr_dataset])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(multilingual_dataset.take(<span class="hljs-number">2</span>))
[{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was inspired by the vision...&#x27;</span>}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot;Média de débat d&#x27;idées, de culture et de littérature...&quot;</span>}]`,wrap:!1}}),ms=new M({props:{code:"bXVsdGlsaW5ndWFsX2RhdGFzZXRfd2l0aF9vdmVyc2FtcGxpbmclMjAlM0QlMjBpbnRlcmxlYXZlX2RhdGFzZXRzKCU1QmVuX2RhdGFzZXQlMkMlMjBmcl9kYXRhc2V0JTVEJTJDJTIwcHJvYmFiaWxpdGllcyUzRCU1QjAuOCUyQyUyMDAuMiU1RCUyQyUyMHNlZWQlM0Q0MiklMEFsaXN0KG11bHRpbGluZ3VhbF9kYXRhc2V0X3dpdGhfb3ZlcnNhbXBsaW5nLnRha2UoMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>multilingual_dataset_with_oversampling = interleave_datasets([en_dataset, fr_dataset], probabilities=[<span class="hljs-number">0.8</span>, <span class="hljs-number">0.2</span>], seed=<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(multilingual_dataset_with_oversampling.take(<span class="hljs-number">2</span>))
[{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was inspired by the vision...&#x27;</span>}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Lily James cannot fight the music...&#x27;</span>}]`,wrap:!1}}),us=new T({props:{title:"Rename, remove, and cast",local:"rename-remove-and-cast",headingTag:"h2"}}),js=new T({props:{title:"Rename",local:"rename",headingTag:"h3"}}),ys=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnbWM0JyUyQyUyMCdlbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIydGV4dCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;mc4&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.rename_column(<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>)`,wrap:!1}}),ws=new T({props:{title:"Remove",local:"remove",headingTag:"h3"}}),Js=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnbWM0JyUyQyUyMCdlbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCd0aW1lc3RhbXAnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;mc4&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns(<span class="hljs-string">&#x27;timestamp&#x27;</span>)`,wrap:!1}}),xs=new T({props:{title:"Cast",local:"cast",headingTag:"h3"}}),$s=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnZ2x1ZSclMkMlMjAnbXJwYyclMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWRhdGFzZXQuZmVhdHVyZXMlMEElMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBDbGFzc0xhYmVsJTJDJTIwVmFsdWUlMEFuZXdfZmVhdHVyZXMlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzLmNvcHkoKSUwQW5ld19mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVEJTIwJTNEJTIwQ2xhc3NMYWJlbChuYW1lcyUzRCU1QiduZWdhdGl2ZSclMkMlMjAncG9zaXRpdmUnJTVEKSUwQW5ld19mZWF0dXJlcyU1QiUyMmlkeCUyMiU1RCUyMCUzRCUyMFZhbHVlKCdpbnQ2NCcpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdChuZXdfZmVhdHVyZXMpJTBBZGF0YXNldC5mZWF0dXJlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;glue&#x27;</span>, <span class="hljs-string">&#x27;mrpc&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;not_equivalent&#x27;</span>, <span class="hljs-string">&#x27;equivalent&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> ClassLabel, Value
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features = dataset.features.copy()
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;label&quot;</span>] = ClassLabel(names=[<span class="hljs-string">&#x27;negative&#x27;</span>, <span class="hljs-string">&#x27;positive&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;idx&quot;</span>] = Value(<span class="hljs-string">&#x27;int64&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast(new_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;negative&#x27;</span>, <span class="hljs-string">&#x27;positive&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),X=new da({props:{$$slots:{default:[nl]},$$scope:{ctx:w}}}),Zs=new M({props:{code:"ZGF0YXNldC5mZWF0dXJlcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2MDAwKSklMEFkYXRhc2V0LmZlYXR1cmVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">44100</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">16000</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),Us=new T({props:{title:"Map",local:"map",headingTag:"h2"}}),Is=new M({props:{code:"ZGVmJTIwYWRkX3ByZWZpeChleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGUlNUIndGV4dCclNUQlMjAlM0QlMjAnTXklMjB0ZXh0JTNBJTIwJyUyMCUyQiUyMGV4YW1wbGUlNUIndGV4dCclNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBleGFtcGxl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">add_prefix</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&#x27;text&#x27;</span>] = <span class="hljs-string">&#x27;My text: &#x27;</span> + example[<span class="hljs-string">&#x27;text&#x27;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example`,wrap:!1}}),vs=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJ3Vuc2h1ZmZsZWRfZGVkdXBsaWNhdGVkX2VuJyUyQyUyMHN0cmVhbWluZyUzRFRydWUlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBdXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoYWRkX3ByZWZpeCklMEFsaXN0KHVwZGF0ZWRfZGF0YXNldC50YWtlKDMpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&#x27;unshuffled_deduplicated_en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(add_prefix)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(updated_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Mtendere Village was inspired by...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Lily James cannot fight the music...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: &quot;I\\&#x27;d love to help kickstart...&#x27;</span>}]`,wrap:!1}}),Vs=new M({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoYWRkX3ByZWZpeCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIyaWQlMjIlNUQpJTBBbGlzdCh1cGRhdGVkX2RhdGFzZXQudGFrZSgzKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(add_prefix, remove_columns=[<span class="hljs-string">&quot;id&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(updated_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Mtendere Village was inspired by...&#x27;</span>},
 {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Lily James cannot fight the music...&#x27;</span>},
 {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: &quot;I\\&#x27;d love to help kickstart...&#x27;</span>}]`,wrap:!1}}),Ws=new T({props:{title:"Batch processing",local:"batch-processing",headingTag:"h3"}}),Bs=new T({props:{title:"Tokenization",local:"tokenization",headingTag:"h4"}}),Ns=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm1jNCUyMiUyQyUyMCUyMmVuJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2Rpc3RpbGJlcnQtYmFzZS11bmNhc2VkJyklMEFkZWYlMjBlbmNvZGUoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJ3RleHQnJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjBwYWRkaW5nJTNEJ21heF9sZW5ndGgnKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChlbmNvZGUlMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIydGV4dCUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUyQyUyMCUyMnVybCUyMiU1RCklMEFuZXh0KGl0ZXIoZGF0YXNldCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;mc4&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&quot;train&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;distilbert-base-uncased&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">encode</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&#x27;text&#x27;</span>], truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-string">&#x27;max_length&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(encode, batched=<span class="hljs-literal">True</span>, remove_columns=[<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;timestamp&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))
{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">8466</span>, <span class="hljs-number">1018</span>, <span class="hljs-number">1010</span>, <span class="hljs-number">4029</span>, <span class="hljs-number">2475</span>, <span class="hljs-number">2062</span>, <span class="hljs-number">18558</span>, <span class="hljs-number">3100</span>, <span class="hljs-number">2061</span>, ...,<span class="hljs-number">1106</span>, <span class="hljs-number">3739</span>, <span class="hljs-number">102</span>],
<span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]}`,wrap:!1}}),R=new da({props:{$$slots:{default:[pl]},$$scope:{ctx:w}}}),Qs=new T({props:{title:"Filter",local:"filter",headingTag:"h3"}}),Ss=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJ3Vuc2h1ZmZsZWRfZGVkdXBsaWNhdGVkX2VuJyUyQyUyMHN0cmVhbWluZyUzRFRydWUlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBc3RhcnRfd2l0aF9hciUyMCUzRCUyMGRhdGFzZXQuZmlsdGVyKGxhbWJkYSUyMGV4YW1wbGUlM0ElMjBleGFtcGxlJTVCJ3RleHQnJTVELnN0YXJ0c3dpdGgoJ0FyJykpJTBBbmV4dChpdGVyKHN0YXJ0X3dpdGhfYXIpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&#x27;unshuffled_deduplicated_en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_with_ar = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example: example[<span class="hljs-string">&#x27;text&#x27;</span>].startswith(<span class="hljs-string">&#x27;Ar&#x27;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(start_with_ar))
{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Are you looking for Number the Stars (Essential Modern Classics)?...&#x27;</span>}`,wrap:!1}}),Ls=new M({props:{code:"ZXZlbl9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIobGFtYmRhJTIwZXhhbXBsZSUyQyUyMGlkeCUzQSUyMGlkeCUyMCUyNSUyMDIlMjAlM0QlM0QlMjAwJTJDJTIwd2l0aF9pbmRpY2VzJTNEVHJ1ZSklMEFsaXN0KGV2ZW5fZGF0YXNldC50YWtlKDMpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>even_dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example, idx: idx % <span class="hljs-number">2</span> == <span class="hljs-number">0</span>, with_indices=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(even_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was inspired by the vision of Chief Napoleon Dzombe, ...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;&quot;I\\&#x27;d love to help kickstart continued development! And 0 EUR/month...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Are you looking for Number the Stars (Essential Modern Classics)? Normally, ...&#x27;</span>}]`,wrap:!1}}),Es=new T({props:{title:"Stream in a training loop",local:"stream-in-a-training-loop",headingTag:"h2"}}),I=new Ot({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[rl]},$$scope:{ctx:w}}}),qs=new T({props:{title:"Save a dataset checkpoint and resume iteration",local:"save-a-dataset-checkpoint-and-resume-iteration",headingTag:"h3"}}),Os=new M({props:{code:"aXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmElMjIlM0ElMjByYW5nZSg2KSU3RCkudG9faXRlcmFibGVfZGF0YXNldChudW1fc2hhcmRzJTNEMyklMEFmb3IlMjBpZHglMkMlMjBleGFtcGxlJTIwaW4lMjBlbnVtZXJhdGUoaXRlcmFibGVfZGF0YXNldCklM0ElMEElMjAlMjAlMjAlMjBwcmludChleGFtcGxlKSUwQSUyMCUyMCUyMCUyMGlmJTIwaWR4JTIwJTNEJTNEJTIwMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRlX2RpY3QlMjAlM0QlMjBpdGVyYWJsZV9kYXRhc2V0LnN0YXRlX2RpY3QoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMmNoZWNrcG9pbnQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWslMEFpdGVyYWJsZV9kYXRhc2V0LmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0KSUwQXByaW50KGYlMjJyZXN0YXJ0JTIwZnJvbSUyMGNoZWNrcG9pbnQlMjIpJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwaXRlcmFibGVfZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGV4YW1wbGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: <span class="hljs-built_in">range</span>(<span class="hljs-number">6</span>)}).to_iterable_dataset(num_shards=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> idx, example <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(iterable_dataset):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> idx == <span class="hljs-number">2</span>:
<span class="hljs-meta">... </span>        state_dict = iterable_dataset.state_dict()
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;checkpoint&quot;</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">break</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset.load_state_dict(state_dict)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;restart from checkpoint&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)`,wrap:!1}}),aa=new M({props:{code:"JTdCJ2EnJTNBJTIwMCU3RCUwQSU3QidhJyUzQSUyMDElN0QlMEElN0InYSclM0ElMjAyJTdEJTBBY2hlY2twb2ludCUwQXJlc3RhcnQlMjBmcm9tJTIwY2hlY2twb2ludCUwQSU3QidhJyUzQSUyMDMlN0QlMEElN0InYSclM0ElMjA0JTdEJTBBJTdCJ2EnJTNBJTIwNSU3RA==",highlighted:`{<span class="hljs-string">&#x27;a&#x27;</span>: <span class="hljs-number">0</span>}
{<span class="hljs-string">&#x27;a&#x27;</span>: <span class="hljs-number">1</span>}
{<span class="hljs-string">&#x27;a&#x27;</span>: <span class="hljs-number">2</span>}
<span class="hljs-keyword">checkpoint</span>
<span class="hljs-keyword">restart</span> <span class="hljs-keyword">from</span> <span class="hljs-keyword">checkpoint</span>
{<span class="hljs-string">&#x27;a&#x27;</span>: <span class="hljs-number">3</span>}
{<span class="hljs-string">&#x27;a&#x27;</span>: <span class="hljs-number">4</span>}
{<span class="hljs-string">&#x27;a&#x27;</span>: <span class="hljs-number">5</span>}`,wrap:!1}}),pa=new M({props:{code:"ZnJvbSUyMHRvcmNoZGF0YS5zdGF0ZWZ1bF9kYXRhbG9hZGVyJTIwaW1wb3J0JTIwU3RhdGVmdWxEYXRhTG9hZGVyJTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJkZWVwbWluZCUyRmNvZGVfY29udGVzdHMlMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhbG9hZGVyJTIwJTNEJTIwU3RhdGVmdWxEYXRhTG9hZGVyKGl0ZXJhYmxlX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEMzIlMkMlMjBudW1fd29ya2VycyUzRDQpJTBBJTIzJTIwY2hlY2twb2ludCUwQXN0YXRlX2RpY3QlMjAlM0QlMjBkYXRhbG9hZGVyLnN0YXRlX2RpY3QoKSUyMCUyMCUyMyUyMHVzZXMlMjBpdGVyYWJsZV9kYXRhc2V0LnN0YXRlX2RpY3QoKSUyMHVuZGVyJTIwdGhlJTIwaG9vZCUwQSUyMyUyMHJlc3VtZSUyMGZyb20lMjBjaGVja3BvaW50JTBBZGF0YWxvYWRlci5sb2FkX3N0YXRlX2RpY3Qoc3RhdGVfZGljdCklMjAlMjAlMjMlMjB1c2VzJTIwaXRlcmFibGVfZGF0YXNldC5sb2FkX3N0YXRlX2RpY3QoKSUyMHVuZGVyJTIwdGhlJTIwaG9vZA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchdata.stateful_dataloader <span class="hljs-keyword">import</span> StatefulDataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = load_dataset(<span class="hljs-string">&quot;deepmind/code_contests&quot;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = StatefulDataLoader(iterable_dataset, batch_size=<span class="hljs-number">32</span>, num_workers=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># checkpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>state_dict = dataloader.state_dict()  <span class="hljs-comment"># uses iterable_dataset.state_dict() under the hood</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># resume from checkpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader.load_state_dict(state_dict)  <span class="hljs-comment"># uses iterable_dataset.load_state_dict() under the hood</span>`,wrap:!1}}),C=new da({props:{$$slots:{default:[cl]},$$scope:{ctx:w}}}),ia=new al({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/stream.mdx"}}),{c(){p=r("meta"),j=l(),i=r("p"),b=l(),h(J.$$.fragment),x=l(),_=r("p"),_.textContent=y,$=l(),v=r("ul"),v.innerHTML=Ke,ma=l(),k=r("div"),k.innerHTML=Pe,oa=l(),F=r("p"),F.innerHTML=Oe,fa=l(),h(Y.$$.fragment),ua=l(),V=r("p"),V.textContent=st,ga=l(),W=r("ul"),W.innerHTML=at,ja=l(),z=r("p"),z.innerHTML=et,Ma=l(),h(B.$$.fragment),ba=l(),N=r("p"),N.innerHTML=tt,ya=l(),h(Z.$$.fragment),wa=l(),h(Q.$$.fragment),Ta=l(),H=r("p"),H.innerHTML=lt,Ja=l(),h(S.$$.fragment),xa=l(),D=r("p"),D.innerHTML=nt,_a=l(),h(L.$$.fragment),$a=l(),h(E.$$.fragment),ka=l(),A=r("p"),A.innerHTML=pt,Za=l(),q=r("p"),q.innerHTML=it,Ua=l(),h(K.$$.fragment),Ga=l(),h(U.$$.fragment),Xa=l(),h(P.$$.fragment),Ra=l(),O=r("p"),O.innerHTML=rt,Ia=l(),ss=r("p"),ss.innerHTML=ct,Ca=l(),h(as.$$.fragment),va=l(),h(es.$$.fragment),Fa=l(),ts=r("p"),ts.textContent=dt,Ya=l(),ls=r("ul"),ls.innerHTML=ht,Va=l(),h(ns.$$.fragment),Wa=l(),ps=r("ul"),ps.innerHTML=mt,za=l(),h(is.$$.fragment),Ba=l(),h(G.$$.fragment),Na=l(),ca=r("a"),Qa=l(),h(rs.$$.fragment),Ha=l(),cs=r("p"),cs.innerHTML=ot,Sa=l(),h(ds.$$.fragment),Da=l(),hs=r("p"),hs.innerHTML=ft,La=l(),h(ms.$$.fragment),Ea=l(),os=r("p"),os.innerHTML=ut,Aa=l(),fs=r("p"),fs.innerHTML=gt,qa=l(),h(us.$$.fragment),Ka=l(),gs=r("p"),gs.textContent=jt,Pa=l(),h(js.$$.fragment),Oa=l(),Ms=r("p"),Ms.innerHTML=Mt,se=l(),bs=r("p"),bs.innerHTML=bt,ae=l(),h(ys.$$.fragment),ee=l(),h(ws.$$.fragment),te=l(),Ts=r("p"),Ts.innerHTML=yt,le=l(),h(Js.$$.fragment),ne=l(),h(xs.$$.fragment),pe=l(),_s=r("p"),_s.innerHTML=wt,ie=l(),h($s.$$.fragment),re=l(),h(X.$$.fragment),ce=l(),ks=r("p"),ks.innerHTML=Tt,de=l(),h(Zs.$$.fragment),he=l(),h(Us.$$.fragment),me=l(),Gs=r("p"),Gs.innerHTML=Jt,oe=l(),Xs=r("p"),Xs.textContent=xt,fe=l(),Rs=r("p"),Rs.innerHTML=_t,ue=l(),h(Is.$$.fragment),ge=l(),Cs=r("p"),Cs.innerHTML=$t,je=l(),h(vs.$$.fragment),Me=l(),Fs=r("p"),Fs.innerHTML=kt,be=l(),Ys=r("p"),Ys.innerHTML=Zt,ye=l(),h(Vs.$$.fragment),we=l(),h(Ws.$$.fragment),Te=l(),zs=r("p"),zs.innerHTML=Ut,Je=l(),h(Bs.$$.fragment),xe=l(),h(Ns.$$.fragment),_e=l(),h(R.$$.fragment),$e=l(),h(Qs.$$.fragment),ke=l(),Hs=r("p"),Hs.innerHTML=Gt,Ze=l(),h(Ss.$$.fragment),Ue=l(),Ds=r("p"),Ds.innerHTML=Xt,Ge=l(),h(Ls.$$.fragment),Xe=l(),h(Es.$$.fragment),Re=l(),As=r("p"),As.innerHTML=Rt,Ie=l(),h(I.$$.fragment),Ce=l(),h(qs.$$.fragment),ve=l(),Ks=r("p"),Ks.textContent=It,Fe=l(),Ps=r("p"),Ps.innerHTML=Ct,Ye=l(),h(Os.$$.fragment),Ve=l(),sa=r("p"),sa.textContent=vt,We=l(),h(aa.$$.fragment),ze=l(),ea=r("p"),ea.innerHTML=Ft,Be=l(),ta=r("p"),ta.textContent=Yt,Ne=l(),la=r("p"),la.textContent=Vt,Qe=l(),na=r("p"),na.innerHTML=Wt,He=l(),h(pa.$$.fragment),Se=l(),h(C.$$.fragment),De=l(),h(ia.$$.fragment),Le=l(),ha=r("p"),this.h()},l(s){const a=Kt("svelte-u9bgzb",document.head);p=c(a,"META",{name:!0,content:!0}),a.forEach(e),j=n(s),i=c(s,"P",{}),qe(i).forEach(e),b=n(s),m(J.$$.fragment,s),x=n(s),_=c(s,"P",{"data-svelte-h":!0}),d(_)!=="svelte-1sf84jt"&&(_.textContent=y),$=n(s),v=c(s,"UL",{"data-svelte-h":!0}),d(v)!=="svelte-1y6qvic"&&(v.innerHTML=Ke),ma=n(s),k=c(s,"DIV",{class:!0,"data-svelte-h":!0}),d(k)!=="svelte-p91s8d"&&(k.innerHTML=Pe),oa=n(s),F=c(s,"P",{"data-svelte-h":!0}),d(F)!=="svelte-xzls0u"&&(F.innerHTML=Oe),fa=n(s),m(Y.$$.fragment,s),ua=n(s),V=c(s,"P",{"data-svelte-h":!0}),d(V)!=="svelte-xdwdpa"&&(V.textContent=st),ga=n(s),W=c(s,"UL",{"data-svelte-h":!0}),d(W)!=="svelte-lffs3"&&(W.innerHTML=at),ja=n(s),z=c(s,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1newt0m"&&(z.innerHTML=et),Ma=n(s),m(B.$$.fragment,s),ba=n(s),N=c(s,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1bzl318"&&(N.innerHTML=tt),ya=n(s),m(Z.$$.fragment,s),wa=n(s),m(Q.$$.fragment,s),Ta=n(s),H=c(s,"P",{"data-svelte-h":!0}),d(H)!=="svelte-q978iq"&&(H.innerHTML=lt),Ja=n(s),m(S.$$.fragment,s),xa=n(s),D=c(s,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1wcqsif"&&(D.innerHTML=nt),_a=n(s),m(L.$$.fragment,s),$a=n(s),m(E.$$.fragment,s),ka=n(s),A=c(s,"P",{"data-svelte-h":!0}),d(A)!=="svelte-1pf2lx4"&&(A.innerHTML=pt),Za=n(s),q=c(s,"P",{"data-svelte-h":!0}),d(q)!=="svelte-pevzww"&&(q.innerHTML=it),Ua=n(s),m(K.$$.fragment,s),Ga=n(s),m(U.$$.fragment,s),Xa=n(s),m(P.$$.fragment,s),Ra=n(s),O=c(s,"P",{"data-svelte-h":!0}),d(O)!=="svelte-l7znh1"&&(O.innerHTML=rt),Ia=n(s),ss=c(s,"P",{"data-svelte-h":!0}),d(ss)!=="svelte-flznjz"&&(ss.innerHTML=ct),Ca=n(s),m(as.$$.fragment,s),va=n(s),m(es.$$.fragment,s),Fa=n(s),ts=c(s,"P",{"data-svelte-h":!0}),d(ts)!=="svelte-1y9p9l9"&&(ts.textContent=dt),Ya=n(s),ls=c(s,"UL",{"data-svelte-h":!0}),d(ls)!=="svelte-nd5zuy"&&(ls.innerHTML=ht),Va=n(s),m(ns.$$.fragment,s),Wa=n(s),ps=c(s,"UL",{"data-svelte-h":!0}),d(ps)!=="svelte-14uvbgf"&&(ps.innerHTML=mt),za=n(s),m(is.$$.fragment,s),Ba=n(s),m(G.$$.fragment,s),Na=n(s),ca=c(s,"A",{id:!0}),qe(ca).forEach(e),Qa=n(s),m(rs.$$.fragment,s),Ha=n(s),cs=c(s,"P",{"data-svelte-h":!0}),d(cs)!=="svelte-11vgww6"&&(cs.innerHTML=ot),Sa=n(s),m(ds.$$.fragment,s),Da=n(s),hs=c(s,"P",{"data-svelte-h":!0}),d(hs)!=="svelte-1t5oa18"&&(hs.innerHTML=ft),La=n(s),m(ms.$$.fragment,s),Ea=n(s),os=c(s,"P",{"data-svelte-h":!0}),d(os)!=="svelte-1oi4bk"&&(os.innerHTML=ut),Aa=n(s),fs=c(s,"P",{"data-svelte-h":!0}),d(fs)!=="svelte-13euv56"&&(fs.innerHTML=gt),qa=n(s),m(us.$$.fragment,s),Ka=n(s),gs=c(s,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-mlzv10"&&(gs.textContent=jt),Pa=n(s),m(js.$$.fragment,s),Oa=n(s),Ms=c(s,"P",{"data-svelte-h":!0}),d(Ms)!=="svelte-1hmiksh"&&(Ms.innerHTML=Mt),se=n(s),bs=c(s,"P",{"data-svelte-h":!0}),d(bs)!=="svelte-wlu2rw"&&(bs.innerHTML=bt),ae=n(s),m(ys.$$.fragment,s),ee=n(s),m(ws.$$.fragment,s),te=n(s),Ts=c(s,"P",{"data-svelte-h":!0}),d(Ts)!=="svelte-bqdlpd"&&(Ts.innerHTML=yt),le=n(s),m(Js.$$.fragment,s),ne=n(s),m(xs.$$.fragment,s),pe=n(s),_s=c(s,"P",{"data-svelte-h":!0}),d(_s)!=="svelte-x1hqb3"&&(_s.innerHTML=wt),ie=n(s),m($s.$$.fragment,s),re=n(s),m(X.$$.fragment,s),ce=n(s),ks=c(s,"P",{"data-svelte-h":!0}),d(ks)!=="svelte-3mm9cd"&&(ks.innerHTML=Tt),de=n(s),m(Zs.$$.fragment,s),he=n(s),m(Us.$$.fragment,s),me=n(s),Gs=c(s,"P",{"data-svelte-h":!0}),d(Gs)!=="svelte-mq2a9k"&&(Gs.innerHTML=Jt),oe=n(s),Xs=c(s,"P",{"data-svelte-h":!0}),d(Xs)!=="svelte-1rfoeeh"&&(Xs.textContent=xt),fe=n(s),Rs=c(s,"P",{"data-svelte-h":!0}),d(Rs)!=="svelte-11m5sg7"&&(Rs.innerHTML=_t),ue=n(s),m(Is.$$.fragment,s),ge=n(s),Cs=c(s,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-qt7cqs"&&(Cs.innerHTML=$t),je=n(s),m(vs.$$.fragment,s),Me=n(s),Fs=c(s,"P",{"data-svelte-h":!0}),d(Fs)!=="svelte-1ik0u5t"&&(Fs.innerHTML=kt),be=n(s),Ys=c(s,"P",{"data-svelte-h":!0}),d(Ys)!=="svelte-1nldwvi"&&(Ys.innerHTML=Zt),ye=n(s),m(Vs.$$.fragment,s),we=n(s),m(Ws.$$.fragment,s),Te=n(s),zs=c(s,"P",{"data-svelte-h":!0}),d(zs)!=="svelte-yj7n2q"&&(zs.innerHTML=Ut),Je=n(s),m(Bs.$$.fragment,s),xe=n(s),m(Ns.$$.fragment,s),_e=n(s),m(R.$$.fragment,s),$e=n(s),m(Qs.$$.fragment,s),ke=n(s),Hs=c(s,"P",{"data-svelte-h":!0}),d(Hs)!=="svelte-95f4d4"&&(Hs.innerHTML=Gt),Ze=n(s),m(Ss.$$.fragment,s),Ue=n(s),Ds=c(s,"P",{"data-svelte-h":!0}),d(Ds)!=="svelte-256j16"&&(Ds.innerHTML=Xt),Ge=n(s),m(Ls.$$.fragment,s),Xe=n(s),m(Es.$$.fragment,s),Re=n(s),As=c(s,"P",{"data-svelte-h":!0}),d(As)!=="svelte-1ynne77"&&(As.innerHTML=Rt),Ie=n(s),m(I.$$.fragment,s),Ce=n(s),m(qs.$$.fragment,s),ve=n(s),Ks=c(s,"P",{"data-svelte-h":!0}),d(Ks)!=="svelte-qoizba"&&(Ks.textContent=It),Fe=n(s),Ps=c(s,"P",{"data-svelte-h":!0}),d(Ps)!=="svelte-1g1itcr"&&(Ps.innerHTML=Ct),Ye=n(s),m(Os.$$.fragment,s),Ve=n(s),sa=c(s,"P",{"data-svelte-h":!0}),d(sa)!=="svelte-f816x"&&(sa.textContent=vt),We=n(s),m(aa.$$.fragment,s),ze=n(s),ea=c(s,"P",{"data-svelte-h":!0}),d(ea)!=="svelte-ul64r3"&&(ea.innerHTML=Ft),Be=n(s),ta=c(s,"P",{"data-svelte-h":!0}),d(ta)!=="svelte-fghrva"&&(ta.textContent=Yt),Ne=n(s),la=c(s,"P",{"data-svelte-h":!0}),d(la)!=="svelte-1i92o70"&&(la.textContent=Vt),Qe=n(s),na=c(s,"P",{"data-svelte-h":!0}),d(na)!=="svelte-10pdp7c"&&(na.innerHTML=Wt),He=n(s),m(pa.$$.fragment,s),Se=n(s),m(C.$$.fragment,s),De=n(s),m(ia.$$.fragment,s),Le=n(s),ha=c(s,"P",{}),qe(ha).forEach(e),this.h()},h(){Ae(p,"name","hf:doc:metadata"),Ae(p,"content",hl),Ae(k,"class","flex justify-center"),Ae(ca,"id","interleave_datasets")},m(s,a){Pt(document.head,p),t(s,j,a),t(s,i,a),t(s,b,a),o(J,s,a),t(s,x,a),t(s,_,a),t(s,$,a),t(s,v,a),t(s,ma,a),t(s,k,a),t(s,oa,a),t(s,F,a),t(s,fa,a),o(Y,s,a),t(s,ua,a),t(s,V,a),t(s,ga,a),t(s,W,a),t(s,ja,a),t(s,z,a),t(s,Ma,a),o(B,s,a),t(s,ba,a),t(s,N,a),t(s,ya,a),o(Z,s,a),t(s,wa,a),o(Q,s,a),t(s,Ta,a),t(s,H,a),t(s,Ja,a),o(S,s,a),t(s,xa,a),t(s,D,a),t(s,_a,a),o(L,s,a),t(s,$a,a),o(E,s,a),t(s,ka,a),t(s,A,a),t(s,Za,a),t(s,q,a),t(s,Ua,a),o(K,s,a),t(s,Ga,a),o(U,s,a),t(s,Xa,a),o(P,s,a),t(s,Ra,a),t(s,O,a),t(s,Ia,a),t(s,ss,a),t(s,Ca,a),o(as,s,a),t(s,va,a),o(es,s,a),t(s,Fa,a),t(s,ts,a),t(s,Ya,a),t(s,ls,a),t(s,Va,a),o(ns,s,a),t(s,Wa,a),t(s,ps,a),t(s,za,a),o(is,s,a),t(s,Ba,a),o(G,s,a),t(s,Na,a),t(s,ca,a),t(s,Qa,a),o(rs,s,a),t(s,Ha,a),t(s,cs,a),t(s,Sa,a),o(ds,s,a),t(s,Da,a),t(s,hs,a),t(s,La,a),o(ms,s,a),t(s,Ea,a),t(s,os,a),t(s,Aa,a),t(s,fs,a),t(s,qa,a),o(us,s,a),t(s,Ka,a),t(s,gs,a),t(s,Pa,a),o(js,s,a),t(s,Oa,a),t(s,Ms,a),t(s,se,a),t(s,bs,a),t(s,ae,a),o(ys,s,a),t(s,ee,a),o(ws,s,a),t(s,te,a),t(s,Ts,a),t(s,le,a),o(Js,s,a),t(s,ne,a),o(xs,s,a),t(s,pe,a),t(s,_s,a),t(s,ie,a),o($s,s,a),t(s,re,a),o(X,s,a),t(s,ce,a),t(s,ks,a),t(s,de,a),o(Zs,s,a),t(s,he,a),o(Us,s,a),t(s,me,a),t(s,Gs,a),t(s,oe,a),t(s,Xs,a),t(s,fe,a),t(s,Rs,a),t(s,ue,a),o(Is,s,a),t(s,ge,a),t(s,Cs,a),t(s,je,a),o(vs,s,a),t(s,Me,a),t(s,Fs,a),t(s,be,a),t(s,Ys,a),t(s,ye,a),o(Vs,s,a),t(s,we,a),o(Ws,s,a),t(s,Te,a),t(s,zs,a),t(s,Je,a),o(Bs,s,a),t(s,xe,a),o(Ns,s,a),t(s,_e,a),o(R,s,a),t(s,$e,a),o(Qs,s,a),t(s,ke,a),t(s,Hs,a),t(s,Ze,a),o(Ss,s,a),t(s,Ue,a),t(s,Ds,a),t(s,Ge,a),o(Ls,s,a),t(s,Xe,a),o(Es,s,a),t(s,Re,a),t(s,As,a),t(s,Ie,a),o(I,s,a),t(s,Ce,a),o(qs,s,a),t(s,ve,a),t(s,Ks,a),t(s,Fe,a),t(s,Ps,a),t(s,Ye,a),o(Os,s,a),t(s,Ve,a),t(s,sa,a),t(s,We,a),o(aa,s,a),t(s,ze,a),t(s,ea,a),t(s,Be,a),t(s,ta,a),t(s,Ne,a),t(s,la,a),t(s,Qe,a),t(s,na,a),t(s,He,a),o(pa,s,a),t(s,Se,a),o(C,s,a),t(s,De,a),o(ia,s,a),t(s,Le,a),t(s,ha,a),Ee=!0},p(s,[a]){const zt={};a&2&&(zt.$$scope={dirty:a,ctx:s}),Z.$set(zt);const Bt={};a&2&&(Bt.$$scope={dirty:a,ctx:s}),U.$set(Bt);const Nt={};a&2&&(Nt.$$scope={dirty:a,ctx:s}),G.$set(Nt);const Qt={};a&2&&(Qt.$$scope={dirty:a,ctx:s}),X.$set(Qt);const Ht={};a&2&&(Ht.$$scope={dirty:a,ctx:s}),R.$set(Ht);const St={};a&2&&(St.$$scope={dirty:a,ctx:s}),I.$set(St);const Dt={};a&2&&(Dt.$$scope={dirty:a,ctx:s}),C.$set(Dt)},i(s){Ee||(f(J.$$.fragment,s),f(Y.$$.fragment,s),f(B.$$.fragment,s),f(Z.$$.fragment,s),f(Q.$$.fragment,s),f(S.$$.fragment,s),f(L.$$.fragment,s),f(E.$$.fragment,s),f(K.$$.fragment,s),f(U.$$.fragment,s),f(P.$$.fragment,s),f(as.$$.fragment,s),f(es.$$.fragment,s),f(ns.$$.fragment,s),f(is.$$.fragment,s),f(G.$$.fragment,s),f(rs.$$.fragment,s),f(ds.$$.fragment,s),f(ms.$$.fragment,s),f(us.$$.fragment,s),f(js.$$.fragment,s),f(ys.$$.fragment,s),f(ws.$$.fragment,s),f(Js.$$.fragment,s),f(xs.$$.fragment,s),f($s.$$.fragment,s),f(X.$$.fragment,s),f(Zs.$$.fragment,s),f(Us.$$.fragment,s),f(Is.$$.fragment,s),f(vs.$$.fragment,s),f(Vs.$$.fragment,s),f(Ws.$$.fragment,s),f(Bs.$$.fragment,s),f(Ns.$$.fragment,s),f(R.$$.fragment,s),f(Qs.$$.fragment,s),f(Ss.$$.fragment,s),f(Ls.$$.fragment,s),f(Es.$$.fragment,s),f(I.$$.fragment,s),f(qs.$$.fragment,s),f(Os.$$.fragment,s),f(aa.$$.fragment,s),f(pa.$$.fragment,s),f(C.$$.fragment,s),f(ia.$$.fragment,s),Ee=!0)},o(s){u(J.$$.fragment,s),u(Y.$$.fragment,s),u(B.$$.fragment,s),u(Z.$$.fragment,s),u(Q.$$.fragment,s),u(S.$$.fragment,s),u(L.$$.fragment,s),u(E.$$.fragment,s),u(K.$$.fragment,s),u(U.$$.fragment,s),u(P.$$.fragment,s),u(as.$$.fragment,s),u(es.$$.fragment,s),u(ns.$$.fragment,s),u(is.$$.fragment,s),u(G.$$.fragment,s),u(rs.$$.fragment,s),u(ds.$$.fragment,s),u(ms.$$.fragment,s),u(us.$$.fragment,s),u(js.$$.fragment,s),u(ys.$$.fragment,s),u(ws.$$.fragment,s),u(Js.$$.fragment,s),u(xs.$$.fragment,s),u($s.$$.fragment,s),u(X.$$.fragment,s),u(Zs.$$.fragment,s),u(Us.$$.fragment,s),u(Is.$$.fragment,s),u(vs.$$.fragment,s),u(Vs.$$.fragment,s),u(Ws.$$.fragment,s),u(Bs.$$.fragment,s),u(Ns.$$.fragment,s),u(R.$$.fragment,s),u(Qs.$$.fragment,s),u(Ss.$$.fragment,s),u(Ls.$$.fragment,s),u(Es.$$.fragment,s),u(I.$$.fragment,s),u(qs.$$.fragment,s),u(Os.$$.fragment,s),u(aa.$$.fragment,s),u(pa.$$.fragment,s),u(C.$$.fragment,s),u(ia.$$.fragment,s),Ee=!1},d(s){s&&(e(j),e(i),e(b),e(x),e(_),e($),e(v),e(ma),e(k),e(oa),e(F),e(fa),e(ua),e(V),e(ga),e(W),e(ja),e(z),e(Ma),e(ba),e(N),e(ya),e(wa),e(Ta),e(H),e(Ja),e(xa),e(D),e(_a),e($a),e(ka),e(A),e(Za),e(q),e(Ua),e(Ga),e(Xa),e(Ra),e(O),e(Ia),e(ss),e(Ca),e(va),e(Fa),e(ts),e(Ya),e(ls),e(Va),e(Wa),e(ps),e(za),e(Ba),e(Na),e(ca),e(Qa),e(Ha),e(cs),e(Sa),e(Da),e(hs),e(La),e(Ea),e(os),e(Aa),e(fs),e(qa),e(Ka),e(gs),e(Pa),e(Oa),e(Ms),e(se),e(bs),e(ae),e(ee),e(te),e(Ts),e(le),e(ne),e(pe),e(_s),e(ie),e(re),e(ce),e(ks),e(de),e(he),e(me),e(Gs),e(oe),e(Xs),e(fe),e(Rs),e(ue),e(ge),e(Cs),e(je),e(Me),e(Fs),e(be),e(Ys),e(ye),e(we),e(Te),e(zs),e(Je),e(xe),e(_e),e($e),e(ke),e(Hs),e(Ze),e(Ue),e(Ds),e(Ge),e(Xe),e(Re),e(As),e(Ie),e(Ce),e(ve),e(Ks),e(Fe),e(Ps),e(Ye),e(Ve),e(sa),e(We),e(ze),e(ea),e(Be),e(ta),e(Ne),e(la),e(Qe),e(na),e(He),e(Se),e(De),e(Le),e(ha)),e(p),g(J,s),g(Y,s),g(B,s),g(Z,s),g(Q,s),g(S,s),g(L,s),g(E,s),g(K,s),g(U,s),g(P,s),g(as,s),g(es,s),g(ns,s),g(is,s),g(G,s),g(rs,s),g(ds,s),g(ms,s),g(us,s),g(js,s),g(ys,s),g(ws,s),g(Js,s),g(xs,s),g($s,s),g(X,s),g(Zs,s),g(Us,s),g(Is,s),g(vs,s),g(Vs,s),g(Ws,s),g(Bs,s),g(Ns,s),g(R,s),g(Qs,s),g(Ss,s),g(Ls,s),g(Es,s),g(I,s),g(qs,s),g(Os,s),g(aa,s),g(pa,s),g(C,s),g(ia,s)}}}const hl='{"title":"Stream","local":"stream","sections":[{"title":"Convert from a Dataset","local":"convert-from-a-dataset","sections":[],"depth":2},{"title":"Shuffle","local":"shuffle","sections":[],"depth":2},{"title":"Reshuffle","local":"reshuffle","sections":[],"depth":2},{"title":"Split dataset","local":"split-dataset","sections":[],"depth":2},{"title":"Interleave","local":"interleave","sections":[],"depth":2},{"title":"Rename, remove, and cast","local":"rename-remove-and-cast","sections":[{"title":"Rename","local":"rename","sections":[],"depth":3},{"title":"Remove","local":"remove","sections":[],"depth":3},{"title":"Cast","local":"cast","sections":[],"depth":3}],"depth":2},{"title":"Map","local":"map","sections":[{"title":"Batch processing","local":"batch-processing","sections":[{"title":"Tokenization","local":"tokenization","sections":[],"depth":4}],"depth":3},{"title":"Filter","local":"filter","sections":[],"depth":3}],"depth":2},{"title":"Stream in a training loop","local":"stream-in-a-training-loop","sections":[{"title":"Save a dataset checkpoint and resume iteration","local":"save-a-dataset-checkpoint-and-resume-iteration","sections":[],"depth":3}],"depth":2}],"depth":1}';function ml(w){return Et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bl extends At{constructor(p){super(),qt(this,p,ml,dl,Lt,{})}}export{bl as component};
