import{s as js,o as ws,n as _s}from"../chunks/scheduler.bdbef820.js";import{S as vs,i as ks,g as c,s as l,r as o,A as Zs,h as u,f as s,c as n,j as Js,u as i,x as g,k as $,y as Us,a,v as p,d as r,t as d,w as m}from"../chunks/index.c0aea24a.js";import{T as Gs}from"../chunks/Tip.31005f7d.js";import{C as f}from"../chunks/CodeBlock.6ccca92e.js";import{H as M,E as zs}from"../chunks/EditOnGithub.725ee0c1.js";function Rs(It){let y,U='Remember to define your credentials in your <a href="#set-up-your-cloud-storage-filesystem">FileSystem instance</a> <code>fs</code> whenever you are interacting with a private cloud storage.';return{c(){y=c("p"),y.innerHTML=U},l(h){y=u(h,"P",{"data-svelte-h":!0}),g(y)!=="svelte-f0wftp"&&(y.innerHTML=U)},m(h,zt){a(h,y,zt)},p:_s,d(h){h&&s(y)}}}function Is(It){let y,U,h,zt,G,Wt,z,xe=`🤗 Datasets supports access to cloud storage providers through a <code>fsspec</code> FileSystem implementations.
You can save and load datasets from any cloud storage in a Pythonic way.
Take a look at the following table for some example of supported cloud storage providers:`,Ct,R,Se='<thead><tr><th>Storage provider</th> <th>Filesystem implementation</th></tr></thead> <tbody><tr><td>Amazon S3</td> <td><a href="https://s3fs.readthedocs.io/en/latest/" rel="nofollow">s3fs</a></td></tr> <tr><td>Google Cloud Storage</td> <td><a href="https://gcsfs.readthedocs.io/en/latest/" rel="nofollow">gcsfs</a></td></tr> <tr><td>Azure Blob/DataLake</td> <td><a href="https://github.com/fsspec/adlfs" rel="nofollow">adlfs</a></td></tr> <tr><td>Dropbox</td> <td><a href="https://github.com/MarineChap/dropboxdrivefs" rel="nofollow">dropboxdrivefs</a></td></tr> <tr><td>Google Drive</td> <td><a href="https://github.com/intake/gdrivefs" rel="nofollow">gdrivefs</a></td></tr> <tr><td>Oracle Cloud Storage</td> <td><a href="https://ocifs.readthedocs.io/en/latest/" rel="nofollow">ocifs</a></td></tr></tbody>',Xt,I,Qe=`This guide will show you how to save and load datasets with any cloud storage.
Here are examples for S3, Google Cloud Storage, Azure Blob Storage, and Oracle Cloud Object Storage.`,Ht,W,qt,C,Vt,X,Ee="<li>Install the S3 FileSystem implementation:</li>",Ft,H,Yt,b,Ae="<li>Define your credentials</li>",Bt,q,De=`To use an anonymous connection, use <code>anon=True</code>.
Otherwise, include your <code>aws_access_key_id</code> and <code>aws_secret_access_key</code> whenever you are interacting with a private S3 bucket.`,Lt,V,Nt,T,Oe="<li>Create your FileSystem instance</li>",xt,F,St,Y,Qt,B,Pe="<li>Install the Google Cloud Storage implementation:</li>",Et,L,At,J,Ke="<li>Define your credentials</li>",Dt,N,Ot,j,ts="<li>Create your FileSystem instance</li>",Pt,x,Kt,S,te,Q,es="<li>Install the Azure Blob Storage implementation:</li>",ee,E,se,w,ss="<li>Define your credentials</li>",ae,A,le,_,as="<li>Create your FileSystem instance</li>",ne,D,oe,O,ie,P,ls="<li>Install the OCI FileSystem implementation:</li>",pe,K,re,v,ns="<li>Define your credentials</li>",de,tt,me,k,os="<li>Create your FileSystem instance</li>",ce,et,ue,st,ge,at,fe,lt,is=`You can download and prepare a dataset into your cloud storage by specifying a remote <code>output_dir</code> in <code>download_and_prepare</code>.
Don’t forget to use the previously defined <code>storage_options</code> containing your credentials to write into a private cloud storage.`,ye,nt,ps="The <code>download_and_prepare</code> method works in two steps:",Me,ot,rs='<li>it first downloads the raw data files (if any) in your local cache. You can set your cache directory by passing <code>cache_dir</code> to <a href="/docs/datasets/pr_6998/en/package_reference/loading_methods#datasets.load_dataset_builder">load_dataset_builder()</a></li> <li>then it generates the dataset in Arrow or Parquet format in your cloud storage by iterating over the raw data files.</li>',he,it,ds='Load a dataset builder from the Hugging Face Hub (see <a href="./loading#hugging-face-hub">how to load from the Hugging Face Hub</a>):',$e,pt,be,rt,ms='Load a dataset builder using a loading script (see <a href="./loading#local-loading-script">how to load a local loading script</a>):',Te,dt,Je,mt,cs='Use your own data files (see <a href="./loading#local-and-remote-files">how to load local and remote files</a>):',je,ct,we,ut,us=`It is highly recommended to save the files as compressed Parquet files to optimize I/O by specifying <code>file_format=&quot;parquet&quot;</code>.
Otherwise the dataset is saved as an uncompressed Arrow file.`,_e,gt,gs="You can also specify the size of the shards using <code>max_shard_size</code> (default is 500MB):",ve,ft,ke,yt,Ze,Mt,fs=`Dask is a parallel computing library and it has a pandas-like API for working with larger than memory Parquet datasets in parallel.
Dask can use multiple threads or processes on a single machine, or a cluster of machines to process data in parallel.
Dask supports local data but also data from a cloud storage.`,Ue,ht,ys="Therefore you can load a dataset saved as sharded Parquet files in Dask with",Ge,$t,ze,bt,Ms='You can find more about dask dataframes in their <a href="https://docs.dask.org/en/stable/dataframe.html" rel="nofollow">documentation</a>.',Re,Tt,Ie,Jt,hs='After you have processed your dataset, you can save it to your cloud storage with <a href="/docs/datasets/pr_6998/en/package_reference/main_classes#datasets.Dataset.save_to_disk">Dataset.save_to_disk()</a>:',We,jt,Ce,Z,Xe,wt,He,_t,$s="List files from a cloud storage with your FileSystem instance <code>fs</code>, using <code>fs.ls</code>:",qe,vt,Ve,kt,Fe,Zt,bs='When you are ready to use your dataset again, reload it with <a href="/docs/datasets/pr_6998/en/package_reference/main_classes#datasets.Dataset.load_from_disk">Dataset.load_from_disk()</a>:',Ye,Ut,Be,Gt,Le,Rt,Ne;return G=new M({props:{title:"Cloud storage",local:"cloud-storage",headingTag:"h1"}}),W=new M({props:{title:"Set up your cloud storage FileSystem",local:"set-up-your-cloud-storage-filesystem",headingTag:"h2"}}),C=new M({props:{title:"Amazon S3",local:"amazon-s3",headingTag:"h3"}}),H=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHMzZnM=",highlighted:'<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pip install s3fs</span>',wrap:!1}}),V=new f({props:{code:"c3RvcmFnZV9vcHRpb25zJTIwJTNEJTIwJTdCJTIyYW5vbiUyMiUzQSUyMFRydWUlN0QlMjAlMjAlMjMlMjBmb3IlMjBhbm9ueW1vdXMlMjBjb25uZWN0aW9uJTBBc3RvcmFnZV9vcHRpb25zJTIwJTNEJTIwJTdCJTIya2V5JTIyJTNBJTIwYXdzX2FjY2Vzc19rZXlfaWQlMkMlMjAlMjJzZWNyZXQlMjIlM0ElMjBhd3Nfc2VjcmV0X2FjY2Vzc19rZXklN0QlMjAlMjAlMjMlMjBmb3IlMjBwcml2YXRlJTIwYnVja2V0cyUwQWltcG9ydCUyMGFpb2JvdG9jb3JlLnNlc3Npb24lMEFzM19zZXNzaW9uJTIwJTNEJTIwYWlvYm90b2NvcmUuc2Vzc2lvbi5BaW9TZXNzaW9uKHByb2ZpbGUlM0QlMjJteV9wcm9maWxlX25hbWUlMjIpJTBBc3RvcmFnZV9vcHRpb25zJTIwJTNEJTIwJTdCJTIyc2Vzc2lvbiUyMiUzQSUyMHMzX3Nlc3Npb24lN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;anon&quot;</span>: <span class="hljs-literal">True</span>}  <span class="hljs-comment"># for anonymous connection</span>
<span class="hljs-comment"># or use your credentials</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;key&quot;</span>: aws_access_key_id, <span class="hljs-string">&quot;secret&quot;</span>: aws_secret_access_key}  <span class="hljs-comment"># for private buckets</span>
<span class="hljs-comment"># or use a botocore session</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> aiobotocore.session
<span class="hljs-meta">&gt;&gt;&gt; </span>s3_session = aiobotocore.session.AioSession(profile=<span class="hljs-string">&quot;my_profile_name&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;session&quot;</span>: s3_session}`,wrap:!1}}),F=new f({props:{code:"aW1wb3J0JTIwczNmcyUwQWZzJTIwJTNEJTIwczNmcy5TM0ZpbGVTeXN0ZW0oKipzdG9yYWdlX29wdGlvbnMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> s3fs
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = s3fs.S3FileSystem(**storage_options)`,wrap:!1}}),Y=new M({props:{title:"Google Cloud Storage",local:"google-cloud-storage",headingTag:"h3"}}),L=new f({props:{code:"Y29uZGElMjBpbnN0YWxsJTIwLWMlMjBjb25kYS1mb3JnZSUyMGdjc2ZzJTBBcGlwJTIwaW5zdGFsbCUyMGdjc2Zz",highlighted:`<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">conda install -c conda-forge gcsfs</span>
# or install with pip
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pip install gcsfs</span>`,wrap:!1}}),N=new f({props:{code:"c3RvcmFnZV9vcHRpb25zJTNEJTdCJTIydG9rZW4lMjIlM0ElMjAlMjJhbm9uJTIyJTdEJTIwJTIwJTIzJTIwZm9yJTIwYW5vbnltb3VzJTIwY29ubmVjdGlvbiUwQXN0b3JhZ2Vfb3B0aW9ucyUzRCU3QiUyMnByb2plY3QlMjIlM0ElMjAlMjJteS1nb29nbGUtcHJvamVjdCUyMiU3RCUwQXN0b3JhZ2Vfb3B0aW9ucyUzRCU3QiUyMnByb2plY3QlMjIlM0ElMjAlMjJteS1nb29nbGUtcHJvamVjdCUyMiUyQyUyMCUyMnRva2VuJTIyJTNBJTIwVE9LRU4lN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options={<span class="hljs-string">&quot;token&quot;</span>: <span class="hljs-string">&quot;anon&quot;</span>}  <span class="hljs-comment"># for anonymous connection</span>
<span class="hljs-comment"># or use your credentials of your default gcloud credentials or from the google metadata service</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options={<span class="hljs-string">&quot;project&quot;</span>: <span class="hljs-string">&quot;my-google-project&quot;</span>}
<span class="hljs-comment"># or use your credentials from elsewhere, see the documentation at https://gcsfs.readthedocs.io/</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options={<span class="hljs-string">&quot;project&quot;</span>: <span class="hljs-string">&quot;my-google-project&quot;</span>, <span class="hljs-string">&quot;token&quot;</span>: TOKEN}`,wrap:!1}}),x=new f({props:{code:"aW1wb3J0JTIwZ2NzZnMlMEFmcyUyMCUzRCUyMGdjc2ZzLkdDU0ZpbGVTeXN0ZW0oKipzdG9yYWdlX29wdGlvbnMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> gcsfs
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = gcsfs.GCSFileSystem(**storage_options)`,wrap:!1}}),S=new M({props:{title:"Azure Blob Storage",local:"azure-blob-storage",headingTag:"h3"}}),E=new f({props:{code:"Y29uZGElMjBpbnN0YWxsJTIwLWMlMjBjb25kYS1mb3JnZSUyMGFkbGZzJTBBcGlwJTIwaW5zdGFsbCUyMGFkbGZz",highlighted:`<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">conda install -c conda-forge adlfs</span>
# or install with pip
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pip install adlfs</span>`,wrap:!1}}),A=new f({props:{code:"c3RvcmFnZV9vcHRpb25zJTIwJTNEJTIwJTdCJTIyYW5vbiUyMiUzQSUyMFRydWUlN0QlMjAlMjAlMjMlMjBmb3IlMjBhbm9ueW1vdXMlMjBjb25uZWN0aW9uJTBBc3RvcmFnZV9vcHRpb25zJTIwJTNEJTIwJTdCJTIyYWNjb3VudF9uYW1lJTIyJTNBJTIwQUNDT1VOVF9OQU1FJTJDJTIwJTIyYWNjb3VudF9rZXklMjIlM0ElMjBBQ0NPVU5UX0tFWSU3RCUyMCUyMCUyMyUyMGdlbiUyMDIlMjBmaWxlc3lzdGVtJTBBc3RvcmFnZV9vcHRpb25zJTNEJTdCJTIydGVuYW50X2lkJTIyJTNBJTIwVEVOQU5UX0lEJTJDJTIwJTIyY2xpZW50X2lkJTIyJTNBJTIwQ0xJRU5UX0lEJTJDJTIwJTIyY2xpZW50X3NlY3JldCUyMiUzQSUyMENMSUVOVF9TRUNSRVQlN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;anon&quot;</span>: <span class="hljs-literal">True</span>}  <span class="hljs-comment"># for anonymous connection</span>
<span class="hljs-comment"># or use your credentials</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;account_name&quot;</span>: ACCOUNT_NAME, <span class="hljs-string">&quot;account_key&quot;</span>: ACCOUNT_KEY}  <span class="hljs-comment"># gen 2 filesystem</span>
<span class="hljs-comment"># or use your credentials with the gen 1 filesystem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options={<span class="hljs-string">&quot;tenant_id&quot;</span>: TENANT_ID, <span class="hljs-string">&quot;client_id&quot;</span>: CLIENT_ID, <span class="hljs-string">&quot;client_secret&quot;</span>: CLIENT_SECRET}`,wrap:!1}}),D=new f({props:{code:"aW1wb3J0JTIwYWRsZnMlMEFmcyUyMCUzRCUyMGFkbGZzLkF6dXJlQmxvYkZpbGVTeXN0ZW0oKipzdG9yYWdlX29wdGlvbnMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> adlfs
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = adlfs.AzureBlobFileSystem(**storage_options)`,wrap:!1}}),O=new M({props:{title:"Oracle Cloud Object Storage",local:"oracle-cloud-object-storage",headingTag:"h3"}}),K=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9jaWZz",highlighted:'<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pip install ocifs</span>',wrap:!1}}),tt=new f({props:{code:"c3RvcmFnZV9vcHRpb25zJTIwJTNEJTIwJTdCJTIyY29uZmlnJTIyJTNBJTIwJTIyfiUyRi5vY2klMkZjb25maWclMjIlMkMlMjAlMjJyZWdpb24lMjIlM0ElMjAlMjJ1cy1hc2hidXJuLTElMjIlN0QlMjA=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;config&quot;</span>: <span class="hljs-string">&quot;~/.oci/config&quot;</span>, <span class="hljs-string">&quot;region&quot;</span>: <span class="hljs-string">&quot;us-ashburn-1&quot;</span>} ',wrap:!1}}),et=new f({props:{code:"aW1wb3J0JTIwb2NpZnMlMEFmcyUyMCUzRCUyMG9jaWZzLk9DSUZpbGVTeXN0ZW0oKipzdG9yYWdlX29wdGlvbnMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> ocifs
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = ocifs.OCIFileSystem(**storage_options)`,wrap:!1}}),st=new M({props:{title:"Load and Save your datasets using your cloud storage FileSystem",local:"load-and-save-your-datasets-using-your-cloud-storage-filesystem",headingTag:"h2"}}),at=new M({props:{title:"Download and prepare a dataset into a cloud storage",local:"download-and-prepare-a-dataset-into-a-cloud-storage",headingTag:"h3"}}),pt=new f({props:{code:"b3V0cHV0X2RpciUyMCUzRCUyMCUyMnMzJTNBJTJGJTJGbXktYnVja2V0JTJGaW1kYiUyMiUwQWJ1aWxkZXIlMjAlM0QlMjBsb2FkX2RhdGFzZXRfYnVpbGRlciglMjJpbWRiJTIyKSUwQWJ1aWxkZXIuZG93bmxvYWRfYW5kX3ByZXBhcmUob3V0cHV0X2RpciUyQyUyMHN0b3JhZ2Vfb3B0aW9ucyUzRHN0b3JhZ2Vfb3B0aW9ucyUyQyUyMGZpbGVfZm9ybWF0JTNEJTIycGFycXVldCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>output_dir = <span class="hljs-string">&quot;s3://my-bucket/imdb&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;imdb&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(output_dir, storage_options=storage_options, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),dt=new f({props:{code:"b3V0cHV0X2RpciUyMCUzRCUyMCUyMnMzJTNBJTJGJTJGbXktYnVja2V0JTJGaW1kYiUyMiUwQWJ1aWxkZXIlMjAlM0QlMjBsb2FkX2RhdGFzZXRfYnVpbGRlciglMjJwYXRoJTJGdG8lMkZsb2NhbCUyRmxvYWRpbmdfc2NyaXB0JTJGbG9hZGluZ19zY3JpcHQucHklMjIpJTBBYnVpbGRlci5kb3dubG9hZF9hbmRfcHJlcGFyZShvdXRwdXRfZGlyJTJDJTIwc3RvcmFnZV9vcHRpb25zJTNEc3RvcmFnZV9vcHRpb25zJTJDJTIwZmlsZV9mb3JtYXQlM0QlMjJwYXJxdWV0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>output_dir = <span class="hljs-string">&quot;s3://my-bucket/imdb&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;path/to/local/loading_script/loading_script.py&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(output_dir, storage_options=storage_options, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),ct=new f({props:{code:"ZGF0YV9maWxlcyUyMCUzRCUyMCU3QiUyMnRyYWluJTIyJTNBJTIwJTVCJTIycGF0aCUyRnRvJTJGdHJhaW4uY3N2JTIyJTVEJTdEJTBBb3V0cHV0X2RpciUyMCUzRCUyMCUyMnMzJTNBJTJGJTJGbXktYnVja2V0JTJGaW1kYiUyMiUwQWJ1aWxkZXIlMjAlM0QlMjBsb2FkX2RhdGFzZXRfYnVpbGRlciglMjJjc3YlMjIlMkMlMjBkYXRhX2ZpbGVzJTNEZGF0YV9maWxlcyklMEFidWlsZGVyLmRvd25sb2FkX2FuZF9wcmVwYXJlKG91dHB1dF9kaXIlMkMlMjBzdG9yYWdlX29wdGlvbnMlM0RzdG9yYWdlX29wdGlvbnMlMkMlMjBmaWxlX2Zvcm1hdCUzRCUyMnBhcnF1ZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>data_files = {<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">&quot;path/to/train.csv&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>output_dir = <span class="hljs-string">&quot;s3://my-bucket/imdb&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(output_dir, storage_options=storage_options, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),ft=new f({props:{code:"YnVpbGRlci5kb3dubG9hZF9hbmRfcHJlcGFyZShvdXRwdXRfZGlyJTJDJTIwc3RvcmFnZV9vcHRpb25zJTNEc3RvcmFnZV9vcHRpb25zJTJDJTIwZmlsZV9mb3JtYXQlM0QlMjJwYXJxdWV0JTIyJTJDJTIwbWF4X3NoYXJkX3NpemUlM0QlMjIxR0IlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(output_dir, storage_options=storage_options, file_format=<span class="hljs-string">&quot;parquet&quot;</span>, max_shard_size=<span class="hljs-string">&quot;1GB&quot;</span>)',wrap:!1}}),yt=new M({props:{title:"Dask",local:"dask",headingTag:"h4"}}),$t=new f({props:{code:"aW1wb3J0JTIwZGFzay5kYXRhZnJhbWUlMjBhcyUyMGRkJTBBJTBBZGYlMjAlM0QlMjBkZC5yZWFkX3BhcnF1ZXQob3V0cHV0X2RpciUyQyUyMHN0b3JhZ2Vfb3B0aW9ucyUzRHN0b3JhZ2Vfb3B0aW9ucyklMEElMEElMjMlMjBvciUyMGlmJTIweW91ciUyMGRhdGFzZXQlMjBpcyUyMHNwbGl0JTIwaW50byUyMHRyYWluJTJGdmFsaWQlMkZ0ZXN0JTBBZGZfdHJhaW4lMjAlM0QlMjBkZC5yZWFkX3BhcnF1ZXQob3V0cHV0X2RpciUyMCUyQiUyMGYlMjIlMkYlN0JidWlsZGVyLm5hbWUlN0QtdHJhaW4tKi5wYXJxdWV0JTIyJTJDJTIwc3RvcmFnZV9vcHRpb25zJTNEc3RvcmFnZV9vcHRpb25zKSUwQWRmX3ZhbGlkJTIwJTNEJTIwZGQucmVhZF9wYXJxdWV0KG91dHB1dF9kaXIlMjAlMkIlMjBmJTIyJTJGJTdCYnVpbGRlci5uYW1lJTdELXZhbGlkYXRpb24tKi5wYXJxdWV0JTIyJTJDJTIwc3RvcmFnZV9vcHRpb25zJTNEc3RvcmFnZV9vcHRpb25zKSUwQWRmX3Rlc3QlMjAlM0QlMjBkZC5yZWFkX3BhcnF1ZXQob3V0cHV0X2RpciUyMCUyQiUyMGYlMjIlMkYlN0JidWlsZGVyLm5hbWUlN0QtdGVzdC0qLnBhcnF1ZXQlMjIlMkMlMjBzdG9yYWdlX29wdGlvbnMlM0RzdG9yYWdlX29wdGlvbnMp",highlighted:`<span class="hljs-keyword">import</span> dask.dataframe <span class="hljs-keyword">as</span> dd

df = dd.read_parquet(output_dir, storage_options=storage_options)

<span class="hljs-comment"># or if your dataset is split into train/valid/test</span>
df_train = dd.read_parquet(output_dir + <span class="hljs-string">f&quot;/<span class="hljs-subst">{builder.name}</span>-train-*.parquet&quot;</span>, storage_options=storage_options)
df_valid = dd.read_parquet(output_dir + <span class="hljs-string">f&quot;/<span class="hljs-subst">{builder.name}</span>-validation-*.parquet&quot;</span>, storage_options=storage_options)
df_test = dd.read_parquet(output_dir + <span class="hljs-string">f&quot;/<span class="hljs-subst">{builder.name}</span>-test-*.parquet&quot;</span>, storage_options=storage_options)`,wrap:!1}}),Tt=new M({props:{title:"Saving serialized datasets",local:"saving-serialized-datasets",headingTag:"h2"}}),jt=new f({props:{code:"ZW5jb2RlZF9kYXRhc2V0LnNhdmVfdG9fZGlzayglMjJzMyUzQSUyRiUyRm15LXByaXZhdGUtZGF0YXNldHMlMkZpbWRiJTJGdHJhaW4lMjIlMkMlMjBzdG9yYWdlX29wdGlvbnMlM0RzdG9yYWdlX29wdGlvbnMpJTBBZW5jb2RlZF9kYXRhc2V0LnNhdmVfdG9fZGlzayglMjJnY3MlM0ElMkYlMkZteS1wcml2YXRlLWRhdGFzZXRzJTJGaW1kYiUyRnRyYWluJTIyJTJDJTIwc3RvcmFnZV9vcHRpb25zJTNEc3RvcmFnZV9vcHRpb25zKSUwQWVuY29kZWRfZGF0YXNldC5zYXZlX3RvX2Rpc2soJTIyYWRsJTNBJTJGJTJGbXktcHJpdmF0ZS1kYXRhc2V0cyUyRmltZGIlMkZ0cmFpbiUyMiUyQyUyMHN0b3JhZ2Vfb3B0aW9ucyUzRHN0b3JhZ2Vfb3B0aW9ucyk=",highlighted:`<span class="hljs-comment"># saves encoded_dataset to amazon s3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset.save_to_disk(<span class="hljs-string">&quot;s3://my-private-datasets/imdb/train&quot;</span>, storage_options=storage_options)
<span class="hljs-comment"># saves encoded_dataset to google cloud storage</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset.save_to_disk(<span class="hljs-string">&quot;gcs://my-private-datasets/imdb/train&quot;</span>, storage_options=storage_options)
<span class="hljs-comment"># saves encoded_dataset to microsoft azure blob/datalake</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset.save_to_disk(<span class="hljs-string">&quot;adl://my-private-datasets/imdb/train&quot;</span>, storage_options=storage_options)`,wrap:!1}}),Z=new Gs({props:{$$slots:{default:[Rs]},$$scope:{ctx:It}}}),wt=new M({props:{title:"Listing serialized datasets",local:"listing-serialized-datasets",headingTag:"h2"}}),vt=new f({props:{code:"ZnMubHMoJTIybXktcHJpdmF0ZS1kYXRhc2V0cyUyRmltZGIlMkZ0cmFpbiUyMiUyQyUyMGRldGFpbCUzREZhbHNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;my-private-datasets/imdb/train&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&quot;dataset_info.json.json&quot;</span>,<span class="hljs-string">&quot;dataset.arrow&quot;</span>,<span class="hljs-string">&quot;state.json&quot;</span>]`,wrap:!1}}),kt=new M({props:{title:"Load serialized datasets",local:"load-serialized-datasets",headingTag:"h3"}}),Ut=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9mcm9tX2Rpc2slMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9mcm9tX2Rpc2soJTIyczMlM0ElMkYlMkZhLXB1YmxpYy1kYXRhc2V0cyUyRmltZGIlMkZ0cmFpbiUyMiUyQyUyMHN0b3JhZ2Vfb3B0aW9ucyUzRHN0b3JhZ2Vfb3B0aW9ucyklMjAlMjAlMEFwcmludChsZW4oZGF0YXNldCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_from_disk
<span class="hljs-comment"># load encoded_dataset from cloud storage</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_from_disk(<span class="hljs-string">&quot;s3://a-public-datasets/imdb/train&quot;</span>, storage_options=storage_options)  
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(dataset))
<span class="hljs-number">25000</span>`,wrap:!1}}),Gt=new zs({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/filesystems.mdx"}}),{c(){y=c("meta"),U=l(),h=c("p"),zt=l(),o(G.$$.fragment),Wt=l(),z=c("p"),z.innerHTML=xe,Ct=l(),R=c("table"),R.innerHTML=Se,Xt=l(),I=c("p"),I.textContent=Qe,Ht=l(),o(W.$$.fragment),qt=l(),o(C.$$.fragment),Vt=l(),X=c("ol"),X.innerHTML=Ee,Ft=l(),o(H.$$.fragment),Yt=l(),b=c("ol"),b.innerHTML=Ae,Bt=l(),q=c("p"),q.innerHTML=De,Lt=l(),o(V.$$.fragment),Nt=l(),T=c("ol"),T.innerHTML=Oe,xt=l(),o(F.$$.fragment),St=l(),o(Y.$$.fragment),Qt=l(),B=c("ol"),B.innerHTML=Pe,Et=l(),o(L.$$.fragment),At=l(),J=c("ol"),J.innerHTML=Ke,Dt=l(),o(N.$$.fragment),Ot=l(),j=c("ol"),j.innerHTML=ts,Pt=l(),o(x.$$.fragment),Kt=l(),o(S.$$.fragment),te=l(),Q=c("ol"),Q.innerHTML=es,ee=l(),o(E.$$.fragment),se=l(),w=c("ol"),w.innerHTML=ss,ae=l(),o(A.$$.fragment),le=l(),_=c("ol"),_.innerHTML=as,ne=l(),o(D.$$.fragment),oe=l(),o(O.$$.fragment),ie=l(),P=c("ol"),P.innerHTML=ls,pe=l(),o(K.$$.fragment),re=l(),v=c("ol"),v.innerHTML=ns,de=l(),o(tt.$$.fragment),me=l(),k=c("ol"),k.innerHTML=os,ce=l(),o(et.$$.fragment),ue=l(),o(st.$$.fragment),ge=l(),o(at.$$.fragment),fe=l(),lt=c("p"),lt.innerHTML=is,ye=l(),nt=c("p"),nt.innerHTML=ps,Me=l(),ot=c("ol"),ot.innerHTML=rs,he=l(),it=c("p"),it.innerHTML=ds,$e=l(),o(pt.$$.fragment),be=l(),rt=c("p"),rt.innerHTML=ms,Te=l(),o(dt.$$.fragment),Je=l(),mt=c("p"),mt.innerHTML=cs,je=l(),o(ct.$$.fragment),we=l(),ut=c("p"),ut.innerHTML=us,_e=l(),gt=c("p"),gt.innerHTML=gs,ve=l(),o(ft.$$.fragment),ke=l(),o(yt.$$.fragment),Ze=l(),Mt=c("p"),Mt.textContent=fs,Ue=l(),ht=c("p"),ht.textContent=ys,Ge=l(),o($t.$$.fragment),ze=l(),bt=c("p"),bt.innerHTML=Ms,Re=l(),o(Tt.$$.fragment),Ie=l(),Jt=c("p"),Jt.innerHTML=hs,We=l(),o(jt.$$.fragment),Ce=l(),o(Z.$$.fragment),Xe=l(),o(wt.$$.fragment),He=l(),_t=c("p"),_t.innerHTML=$s,qe=l(),o(vt.$$.fragment),Ve=l(),o(kt.$$.fragment),Fe=l(),Zt=c("p"),Zt.innerHTML=bs,Ye=l(),o(Ut.$$.fragment),Be=l(),o(Gt.$$.fragment),Le=l(),Rt=c("p"),this.h()},l(t){const e=Zs("svelte-u9bgzb",document.head);y=u(e,"META",{name:!0,content:!0}),e.forEach(s),U=n(t),h=u(t,"P",{}),Js(h).forEach(s),zt=n(t),i(G.$$.fragment,t),Wt=n(t),z=u(t,"P",{"data-svelte-h":!0}),g(z)!=="svelte-1xcb7pv"&&(z.innerHTML=xe),Ct=n(t),R=u(t,"TABLE",{"data-svelte-h":!0}),g(R)!=="svelte-14du81h"&&(R.innerHTML=Se),Xt=n(t),I=u(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-jhnqvu"&&(I.textContent=Qe),Ht=n(t),i(W.$$.fragment,t),qt=n(t),i(C.$$.fragment,t),Vt=n(t),X=u(t,"OL",{"data-svelte-h":!0}),g(X)!=="svelte-16p50yk"&&(X.innerHTML=Ee),Ft=n(t),i(H.$$.fragment,t),Yt=n(t),b=u(t,"OL",{start:!0,"data-svelte-h":!0}),g(b)!=="svelte-172a894"&&(b.innerHTML=Ae),Bt=n(t),q=u(t,"P",{"data-svelte-h":!0}),g(q)!=="svelte-1m0nrhz"&&(q.innerHTML=De),Lt=n(t),i(V.$$.fragment,t),Nt=n(t),T=u(t,"OL",{start:!0,"data-svelte-h":!0}),g(T)!=="svelte-zc3ks6"&&(T.innerHTML=Oe),xt=n(t),i(F.$$.fragment,t),St=n(t),i(Y.$$.fragment,t),Qt=n(t),B=u(t,"OL",{"data-svelte-h":!0}),g(B)!=="svelte-tzsteu"&&(B.innerHTML=Pe),Et=n(t),i(L.$$.fragment,t),At=n(t),J=u(t,"OL",{start:!0,"data-svelte-h":!0}),g(J)!=="svelte-172a894"&&(J.innerHTML=Ke),Dt=n(t),i(N.$$.fragment,t),Ot=n(t),j=u(t,"OL",{start:!0,"data-svelte-h":!0}),g(j)!=="svelte-zc3ks6"&&(j.innerHTML=ts),Pt=n(t),i(x.$$.fragment,t),Kt=n(t),i(S.$$.fragment,t),te=n(t),Q=u(t,"OL",{"data-svelte-h":!0}),g(Q)!=="svelte-zykrn6"&&(Q.innerHTML=es),ee=n(t),i(E.$$.fragment,t),se=n(t),w=u(t,"OL",{start:!0,"data-svelte-h":!0}),g(w)!=="svelte-172a894"&&(w.innerHTML=ss),ae=n(t),i(A.$$.fragment,t),le=n(t),_=u(t,"OL",{start:!0,"data-svelte-h":!0}),g(_)!=="svelte-zc3ks6"&&(_.innerHTML=as),ne=n(t),i(D.$$.fragment,t),oe=n(t),i(O.$$.fragment,t),ie=n(t),P=u(t,"OL",{"data-svelte-h":!0}),g(P)!=="svelte-33zejz"&&(P.innerHTML=ls),pe=n(t),i(K.$$.fragment,t),re=n(t),v=u(t,"OL",{start:!0,"data-svelte-h":!0}),g(v)!=="svelte-172a894"&&(v.innerHTML=ns),de=n(t),i(tt.$$.fragment,t),me=n(t),k=u(t,"OL",{start:!0,"data-svelte-h":!0}),g(k)!=="svelte-zc3ks6"&&(k.innerHTML=os),ce=n(t),i(et.$$.fragment,t),ue=n(t),i(st.$$.fragment,t),ge=n(t),i(at.$$.fragment,t),fe=n(t),lt=u(t,"P",{"data-svelte-h":!0}),g(lt)!=="svelte-1dq9go1"&&(lt.innerHTML=is),ye=n(t),nt=u(t,"P",{"data-svelte-h":!0}),g(nt)!=="svelte-sha7eh"&&(nt.innerHTML=ps),Me=n(t),ot=u(t,"OL",{"data-svelte-h":!0}),g(ot)!=="svelte-1hwge6g"&&(ot.innerHTML=rs),he=n(t),it=u(t,"P",{"data-svelte-h":!0}),g(it)!=="svelte-1ypj8lj"&&(it.innerHTML=ds),$e=n(t),i(pt.$$.fragment,t),be=n(t),rt=u(t,"P",{"data-svelte-h":!0}),g(rt)!=="svelte-1xv3q0z"&&(rt.innerHTML=ms),Te=n(t),i(dt.$$.fragment,t),Je=n(t),mt=u(t,"P",{"data-svelte-h":!0}),g(mt)!=="svelte-1yv9guc"&&(mt.innerHTML=cs),je=n(t),i(ct.$$.fragment,t),we=n(t),ut=u(t,"P",{"data-svelte-h":!0}),g(ut)!=="svelte-1ksm788"&&(ut.innerHTML=us),_e=n(t),gt=u(t,"P",{"data-svelte-h":!0}),g(gt)!=="svelte-s9cwoq"&&(gt.innerHTML=gs),ve=n(t),i(ft.$$.fragment,t),ke=n(t),i(yt.$$.fragment,t),Ze=n(t),Mt=u(t,"P",{"data-svelte-h":!0}),g(Mt)!=="svelte-pl160m"&&(Mt.textContent=fs),Ue=n(t),ht=u(t,"P",{"data-svelte-h":!0}),g(ht)!=="svelte-r3cnvj"&&(ht.textContent=ys),Ge=n(t),i($t.$$.fragment,t),ze=n(t),bt=u(t,"P",{"data-svelte-h":!0}),g(bt)!=="svelte-e328yx"&&(bt.innerHTML=Ms),Re=n(t),i(Tt.$$.fragment,t),Ie=n(t),Jt=u(t,"P",{"data-svelte-h":!0}),g(Jt)!=="svelte-1117u2f"&&(Jt.innerHTML=hs),We=n(t),i(jt.$$.fragment,t),Ce=n(t),i(Z.$$.fragment,t),Xe=n(t),i(wt.$$.fragment,t),He=n(t),_t=u(t,"P",{"data-svelte-h":!0}),g(_t)!=="svelte-19hbo6c"&&(_t.innerHTML=$s),qe=n(t),i(vt.$$.fragment,t),Ve=n(t),i(kt.$$.fragment,t),Fe=n(t),Zt=u(t,"P",{"data-svelte-h":!0}),g(Zt)!=="svelte-1alymil"&&(Zt.innerHTML=bs),Ye=n(t),i(Ut.$$.fragment,t),Be=n(t),i(Gt.$$.fragment,t),Le=n(t),Rt=u(t,"P",{}),Js(Rt).forEach(s),this.h()},h(){$(y,"name","hf:doc:metadata"),$(y,"content",Ws),$(b,"start","2"),$(T,"start","3"),$(J,"start","2"),$(j,"start","3"),$(w,"start","2"),$(_,"start","3"),$(v,"start","2"),$(k,"start","3")},m(t,e){Us(document.head,y),a(t,U,e),a(t,h,e),a(t,zt,e),p(G,t,e),a(t,Wt,e),a(t,z,e),a(t,Ct,e),a(t,R,e),a(t,Xt,e),a(t,I,e),a(t,Ht,e),p(W,t,e),a(t,qt,e),p(C,t,e),a(t,Vt,e),a(t,X,e),a(t,Ft,e),p(H,t,e),a(t,Yt,e),a(t,b,e),a(t,Bt,e),a(t,q,e),a(t,Lt,e),p(V,t,e),a(t,Nt,e),a(t,T,e),a(t,xt,e),p(F,t,e),a(t,St,e),p(Y,t,e),a(t,Qt,e),a(t,B,e),a(t,Et,e),p(L,t,e),a(t,At,e),a(t,J,e),a(t,Dt,e),p(N,t,e),a(t,Ot,e),a(t,j,e),a(t,Pt,e),p(x,t,e),a(t,Kt,e),p(S,t,e),a(t,te,e),a(t,Q,e),a(t,ee,e),p(E,t,e),a(t,se,e),a(t,w,e),a(t,ae,e),p(A,t,e),a(t,le,e),a(t,_,e),a(t,ne,e),p(D,t,e),a(t,oe,e),p(O,t,e),a(t,ie,e),a(t,P,e),a(t,pe,e),p(K,t,e),a(t,re,e),a(t,v,e),a(t,de,e),p(tt,t,e),a(t,me,e),a(t,k,e),a(t,ce,e),p(et,t,e),a(t,ue,e),p(st,t,e),a(t,ge,e),p(at,t,e),a(t,fe,e),a(t,lt,e),a(t,ye,e),a(t,nt,e),a(t,Me,e),a(t,ot,e),a(t,he,e),a(t,it,e),a(t,$e,e),p(pt,t,e),a(t,be,e),a(t,rt,e),a(t,Te,e),p(dt,t,e),a(t,Je,e),a(t,mt,e),a(t,je,e),p(ct,t,e),a(t,we,e),a(t,ut,e),a(t,_e,e),a(t,gt,e),a(t,ve,e),p(ft,t,e),a(t,ke,e),p(yt,t,e),a(t,Ze,e),a(t,Mt,e),a(t,Ue,e),a(t,ht,e),a(t,Ge,e),p($t,t,e),a(t,ze,e),a(t,bt,e),a(t,Re,e),p(Tt,t,e),a(t,Ie,e),a(t,Jt,e),a(t,We,e),p(jt,t,e),a(t,Ce,e),p(Z,t,e),a(t,Xe,e),p(wt,t,e),a(t,He,e),a(t,_t,e),a(t,qe,e),p(vt,t,e),a(t,Ve,e),p(kt,t,e),a(t,Fe,e),a(t,Zt,e),a(t,Ye,e),p(Ut,t,e),a(t,Be,e),p(Gt,t,e),a(t,Le,e),a(t,Rt,e),Ne=!0},p(t,[e]){const Ts={};e&2&&(Ts.$$scope={dirty:e,ctx:t}),Z.$set(Ts)},i(t){Ne||(r(G.$$.fragment,t),r(W.$$.fragment,t),r(C.$$.fragment,t),r(H.$$.fragment,t),r(V.$$.fragment,t),r(F.$$.fragment,t),r(Y.$$.fragment,t),r(L.$$.fragment,t),r(N.$$.fragment,t),r(x.$$.fragment,t),r(S.$$.fragment,t),r(E.$$.fragment,t),r(A.$$.fragment,t),r(D.$$.fragment,t),r(O.$$.fragment,t),r(K.$$.fragment,t),r(tt.$$.fragment,t),r(et.$$.fragment,t),r(st.$$.fragment,t),r(at.$$.fragment,t),r(pt.$$.fragment,t),r(dt.$$.fragment,t),r(ct.$$.fragment,t),r(ft.$$.fragment,t),r(yt.$$.fragment,t),r($t.$$.fragment,t),r(Tt.$$.fragment,t),r(jt.$$.fragment,t),r(Z.$$.fragment,t),r(wt.$$.fragment,t),r(vt.$$.fragment,t),r(kt.$$.fragment,t),r(Ut.$$.fragment,t),r(Gt.$$.fragment,t),Ne=!0)},o(t){d(G.$$.fragment,t),d(W.$$.fragment,t),d(C.$$.fragment,t),d(H.$$.fragment,t),d(V.$$.fragment,t),d(F.$$.fragment,t),d(Y.$$.fragment,t),d(L.$$.fragment,t),d(N.$$.fragment,t),d(x.$$.fragment,t),d(S.$$.fragment,t),d(E.$$.fragment,t),d(A.$$.fragment,t),d(D.$$.fragment,t),d(O.$$.fragment,t),d(K.$$.fragment,t),d(tt.$$.fragment,t),d(et.$$.fragment,t),d(st.$$.fragment,t),d(at.$$.fragment,t),d(pt.$$.fragment,t),d(dt.$$.fragment,t),d(ct.$$.fragment,t),d(ft.$$.fragment,t),d(yt.$$.fragment,t),d($t.$$.fragment,t),d(Tt.$$.fragment,t),d(jt.$$.fragment,t),d(Z.$$.fragment,t),d(wt.$$.fragment,t),d(vt.$$.fragment,t),d(kt.$$.fragment,t),d(Ut.$$.fragment,t),d(Gt.$$.fragment,t),Ne=!1},d(t){t&&(s(U),s(h),s(zt),s(Wt),s(z),s(Ct),s(R),s(Xt),s(I),s(Ht),s(qt),s(Vt),s(X),s(Ft),s(Yt),s(b),s(Bt),s(q),s(Lt),s(Nt),s(T),s(xt),s(St),s(Qt),s(B),s(Et),s(At),s(J),s(Dt),s(Ot),s(j),s(Pt),s(Kt),s(te),s(Q),s(ee),s(se),s(w),s(ae),s(le),s(_),s(ne),s(oe),s(ie),s(P),s(pe),s(re),s(v),s(de),s(me),s(k),s(ce),s(ue),s(ge),s(fe),s(lt),s(ye),s(nt),s(Me),s(ot),s(he),s(it),s($e),s(be),s(rt),s(Te),s(Je),s(mt),s(je),s(we),s(ut),s(_e),s(gt),s(ve),s(ke),s(Ze),s(Mt),s(Ue),s(ht),s(Ge),s(ze),s(bt),s(Re),s(Ie),s(Jt),s(We),s(Ce),s(Xe),s(He),s(_t),s(qe),s(Ve),s(Fe),s(Zt),s(Ye),s(Be),s(Le),s(Rt)),s(y),m(G,t),m(W,t),m(C,t),m(H,t),m(V,t),m(F,t),m(Y,t),m(L,t),m(N,t),m(x,t),m(S,t),m(E,t),m(A,t),m(D,t),m(O,t),m(K,t),m(tt,t),m(et,t),m(st,t),m(at,t),m(pt,t),m(dt,t),m(ct,t),m(ft,t),m(yt,t),m($t,t),m(Tt,t),m(jt,t),m(Z,t),m(wt,t),m(vt,t),m(kt,t),m(Ut,t),m(Gt,t)}}}const Ws='{"title":"Cloud storage","local":"cloud-storage","sections":[{"title":"Set up your cloud storage FileSystem","local":"set-up-your-cloud-storage-filesystem","sections":[{"title":"Amazon S3","local":"amazon-s3","sections":[],"depth":3},{"title":"Google Cloud Storage","local":"google-cloud-storage","sections":[],"depth":3},{"title":"Azure Blob Storage","local":"azure-blob-storage","sections":[],"depth":3},{"title":"Oracle Cloud Object Storage","local":"oracle-cloud-object-storage","sections":[],"depth":3}],"depth":2},{"title":"Load and Save your datasets using your cloud storage FileSystem","local":"load-and-save-your-datasets-using-your-cloud-storage-filesystem","sections":[{"title":"Download and prepare a dataset into a cloud storage","local":"download-and-prepare-a-dataset-into-a-cloud-storage","sections":[{"title":"Dask","local":"dask","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Saving serialized datasets","local":"saving-serialized-datasets","sections":[],"depth":2},{"title":"Listing serialized datasets","local":"listing-serialized-datasets","sections":[{"title":"Load serialized datasets","local":"load-serialized-datasets","sections":[],"depth":3}],"depth":2}],"depth":1}';function Cs(It){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ys extends vs{constructor(y){super(),ks(this,y,Cs,Is,js,{})}}export{Ys as component};
