import{s as kt,n as vt,o as xt}from"../chunks/scheduler.bdbef820.js";import{S as Xt,i as $t,g as p,s as l,r as h,A as At,h as i,f as a,c as n,j as Gt,u as c,x as m,k as w,y as Rt,a as e,v as o,d as M,t as d,w as r}from"../chunks/index.c0aea24a.js";import{C as j}from"../chunks/CodeBlock.6ccca92e.js";import{H as Wt,E as Et}from"../chunks/EditOnGithub.725ee0c1.js";function Ht(tt){let u,hs,is,cs,C,os,_,at=`Depth estimation datasets are used to train a model to approximate the relative distance of every pixel in an
image from the camera, also known as depth. The applications enabled by these datasets primarily lie in areas like visual machine
perception and perception in robotics. Example applications include mapping streets for self-driving cars. This guide will show you how to apply transformations
to a depth estimation dataset.`,Ms,I,et="Before you start, make sure you have up-to-date versions of <code>albumentations</code> installed:",ds,Z,rs,B,lt=`<a href="https://albumentations.ai/" rel="nofollow">Albumentations</a> is a Python library for performing data augmentation
for computer vision. It supports various computer vision tasks such as image classification, object
detection, segmentation, and keypoint estimation.`,js,G,nt=`This guide uses the <a href="https://huggingface.co/datasets/sayakpaul/nyu_depth_v2" rel="nofollow">NYU Depth V2</a> dataset which is
comprised of video sequences from various indoor scenes, recorded by RGB and depth cameras. The dataset consists of scenes from 3 cities and provides images along with
their depth maps as labels.`,us,k,pt="Load the <code>train</code> split of the dataset and take a look at an example:",ws,v,ys,x,it="The dataset has two fields:",gs,X,mt="<li><code>image</code>: a PIL PNG image object with <code>uint8</code> data type.</li> <li><code>depth_map</code>: a PIL Tiff image object with <code>float32</code> data type which is the depth map of the image.</li>",Js,$,ht="It is mention-worthy that JPEG/PNG format can only store <code>uint8</code> or <code>uint16</code> data. As the depth map is <code>float32</code> data, it can’t be stored using PNG/JPEG. However, we can save the depth map using TIFF format as it supports a wider range of data types, including <code>float32</code> data.",fs,A,ct="Next, check out an image with:",Ts,R,Us,y,ot='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_sample.png"/>',bs,W,Mt="Before we look at the depth map, we need to first convert its data type to <code>uint8</code> using <code>.convert(&#39;RGB&#39;)</code> as PIL can’t display <code>float32</code> images. Now take a look at its corresponding depth map:",Cs,E,_s,g,dt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_target.png"/>',Is,H,rt='It’s all black! You’ll need to add some color to the depth map to visualize it properly. To do that, either we can apply color automatically during display using <code>plt.imshow()</code> or create a colored depth map using <code>plt.cm</code> and then display it. In this example, we have used the latter one, as we can save/write the colored depth map later. (the utility below is taken from the <a href="https://github.com/dwofk/fast-depth/blob/master/utils.py" rel="nofollow">FastDepth repository</a>).',Zs,F,Bs,J,jt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_target_viz.png"/>',Gs,Q,ut="You can also visualize several different images and their corresponding depth maps.",ks,V,vs,f,wt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_collage.png"/>',xs,N,yt="Now apply some augmentations with <code>albumentations</code>. The augmentation transformations include:",Xs,Y,gt="<li>Random horizontal flipping</li> <li>Random cropping</li> <li>Random brightness and contrast</li> <li>Random gamma correction</li> <li>Random hue saturation</li>",$s,z,As,S,Jt="Additionally, define a mapping to better reflect the target key name.",Rs,L,Ws,q,ft=`With <code>additional_targets</code> defined, you can pass the target depth maps to the <code>depth</code> argument of <code>aug</code> instead of <code>mask</code>. You’ll notice this change
in the <code>apply_transforms()</code> function defined below.`,Es,K,Tt="Create a function to apply the transformation to the images as well as their depth maps:",Hs,P,Fs,D,Ut='Use the <a href="/docs/datasets/pr_6998/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function to apply the transformation on-the-fly to batches of the dataset to consume less disk space:',Qs,O,Vs,ss,bt="You can verify the transformation worked by indexing into the <code>pixel_values</code> and <code>labels</code> of an example image:",Ns,ts,Ys,T,Ct='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_sample_aug.png"/>',zs,as,_t="Visualize the same transformation on the image’s corresponding depth map:",Ss,es,Ls,U,It='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_target_aug.png"/>',qs,ls,Zt="You can also visualize multiple training samples reusing the previous <code>random_indices</code>:",Ks,ns,Ps,b,Bt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_aug_collage.png"/>',Ds,ps,Os,ms,st;return C=new Wt({props:{title:"Depth estimation",local:"depth-estimation",headingTag:"h1"}}),Z=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYWxidW1lbnRhdGlvbnMlMjA=",highlighted:"pip install -U albumentations ",wrap:!1}}),v=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzYXlha3BhdWwlMkZueXVfZGVwdGhfdjIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWluZGV4JTIwJTNEJTIwMTclMEFleGFtcGxlJTIwJTNEJTIwdHJhaW5fZGF0YXNldCU1QmluZGV4JTVEJTBBZXhhbXBsZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = load_dataset(<span class="hljs-string">&quot;sayakpaul/nyu_depth_v2&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>index = <span class="hljs-number">17</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>example = train_dataset[index]
<span class="hljs-meta">&gt;&gt;&gt; </span>example
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.PngImagePlugin.PngImageFile image mode=RGB size=640x480&gt;,
 <span class="hljs-string">&#x27;depth_map&#x27;</span>: &lt;PIL.TiffImagePlugin.TiffImageFile image mode=F size=640x480&gt;}`,wrap:!1}}),R=new j({props:{code:"ZXhhbXBsZSU1QiUyMmltYWdlJTIyJTVE",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>example[<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),E=new j({props:{code:"ZXhhbXBsZSU1QiUyMmRlcHRoX21hcCUyMiU1RC5jb252ZXJ0KCUyMlJHQiUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>example[<span class="hljs-string">&quot;depth_map&quot;</span>].convert(<span class="hljs-string">&quot;RGB&quot;</span>)',wrap:!1}}),F=new j({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWNtYXAlMjAlM0QlMjBwbHQuY20udmlyaWRpcyUwQSUwQWRlZiUyMGNvbG9yZWRfZGVwdGhtYXAoZGVwdGglMkMlMjBkX21pbiUzRE5vbmUlMkMlMjBkX21heCUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBkX21pbiUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRfbWluJTIwJTNEJTIwbnAubWluKGRlcHRoKSUwQSUyMCUyMCUyMCUyMGlmJTIwZF9tYXglMjBpcyUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkX21heCUyMCUzRCUyMG5wLm1heChkZXB0aCklMEElMjAlMjAlMjAlMjBkZXB0aF9yZWxhdGl2ZSUyMCUzRCUyMChkZXB0aCUyMC0lMjBkX21pbiklMjAlMkYlMjAoZF9tYXglMjAtJTIwZF9taW4pJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwMjU1JTIwKiUyMGNtYXAoZGVwdGhfcmVsYXRpdmUpJTVCJTNBJTJDJTNBJTJDJTNBMyU1RCUwQSUwQWRlZiUyMHNob3dfZGVwdGhtYXAoZGVwdGhfbWFwKSUzQSUwQSUyMCUyMCUyMGlmJTIwbm90JTIwaXNpbnN0YW5jZShkZXB0aF9tYXAlMkMlMjBucC5uZGFycmF5KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlcHRoX21hcCUyMCUzRCUyMG5wLmFycmF5KGRlcHRoX21hcCklMEElMjAlMjAlMjBpZiUyMGRlcHRoX21hcC5uZGltJTIwJTNEJTNEJTIwMyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlcHRoX21hcCUyMCUzRCUyMGRlcHRoX21hcC5zcXVlZXplKCklMEElMEElMjAlMjAlMjBkX21pbiUyMCUzRCUyMG5wLm1pbihkZXB0aF9tYXApJTBBJTIwJTIwJTIwZF9tYXglMjAlM0QlMjBucC5tYXgoZGVwdGhfbWFwKSUwQSUyMCUyMCUyMGRlcHRoX21hcCUyMCUzRCUyMGNvbG9yZWRfZGVwdGhtYXAoZGVwdGhfbWFwJTJDJTIwZF9taW4lMkMlMjBkX21heCklMEElMEElMjAlMjAlMjBwbHQuaW1zaG93KGRlcHRoX21hcC5hc3R5cGUoJTIydWludDglMjIpKSUwQSUyMCUyMCUyMHBsdC5heGlzKCUyMm9mZiUyMiklMEElMjAlMjAlMjBwbHQuc2hvdygpJTBBJTBBc2hvd19kZXB0aG1hcChleGFtcGxlJTVCJTIyZGVwdGhfbWFwJTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>cmap = plt.cm.viridis

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">colored_depthmap</span>(<span class="hljs-params">depth, d_min=<span class="hljs-literal">None</span>, d_max=<span class="hljs-literal">None</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> d_min <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>        d_min = np.<span class="hljs-built_in">min</span>(depth)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> d_max <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>        d_max = np.<span class="hljs-built_in">max</span>(depth)
<span class="hljs-meta">... </span>    depth_relative = (depth - d_min) / (d_max - d_min)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-number">255</span> * cmap(depth_relative)[:,:,:<span class="hljs-number">3</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">show_depthmap</span>(<span class="hljs-params">depth_map</span>):
<span class="hljs-meta">... </span>   <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> <span class="hljs-built_in">isinstance</span>(depth_map, np.ndarray):
<span class="hljs-meta">... </span>       depth_map = np.array(depth_map)
<span class="hljs-meta">... </span>   <span class="hljs-keyword">if</span> depth_map.ndim == <span class="hljs-number">3</span>:
<span class="hljs-meta">... </span>       depth_map = depth_map.squeeze()

<span class="hljs-meta">... </span>   d_min = np.<span class="hljs-built_in">min</span>(depth_map)
<span class="hljs-meta">... </span>   d_max = np.<span class="hljs-built_in">max</span>(depth_map)
<span class="hljs-meta">... </span>   depth_map = colored_depthmap(depth_map, d_min, d_max)

<span class="hljs-meta">... </span>   plt.imshow(depth_map.astype(<span class="hljs-string">&quot;uint8&quot;</span>))
<span class="hljs-meta">... </span>   plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
<span class="hljs-meta">... </span>   plt.show()

<span class="hljs-meta">&gt;&gt;&gt; </span>show_depthmap(example[<span class="hljs-string">&quot;depth_map&quot;</span>])`,wrap:!1}}),V=new j({props:{code:"ZGVmJTIwbWVyZ2VfaW50b19yb3coaW5wdXRfaW1hZ2UlMkMlMjBkZXB0aF90YXJnZXQpJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpc2luc3RhbmNlKGlucHV0X2ltYWdlJTJDJTIwbnAubmRhcnJheSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9pbWFnZSUyMCUzRCUyMG5wLmFycmF5KGlucHV0X2ltYWdlKSUwQSUyMCUyMCUyMCUyMGRfbWluJTIwJTNEJTIwbnAubWluKGRlcHRoX3RhcmdldCklMEElMjAlMjAlMjAlMjBkX21heCUyMCUzRCUyMG5wLm1heChkZXB0aF90YXJnZXQpJTBBJTIwJTIwJTIwJTIwZGVwdGhfdGFyZ2V0X2NvbCUyMCUzRCUyMGNvbG9yZWRfZGVwdGhtYXAoZGVwdGhfdGFyZ2V0JTJDJTIwZF9taW4lMkMlMjBkX21heCklMEElMjAlMjAlMjAlMjBpbWdfbWVyZ2UlMjAlM0QlMjBucC5oc3RhY2soJTVCaW5wdXRfaW1hZ2UlMkMlMjBkZXB0aF90YXJnZXRfY29sJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltZ19tZXJnZSUwQSUwQXJhbmRvbV9pbmRpY2VzJTIwJTNEJTIwbnAucmFuZG9tLmNob2ljZShsZW4odHJhaW5fZGF0YXNldCklMkMlMjA5KS50b2xpc3QoKSUwQXBsdC5maWd1cmUoZmlnc2l6ZSUzRCgxNSUyQyUyMDYpKSUwQWZvciUyMGklMkMlMjBpZHglMjBpbiUyMGVudW1lcmF0ZShyYW5kb21faW5kaWNlcyklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwdHJhaW5fZGF0YXNldCU1QmlkeCU1RCUwQSUyMCUyMCUyMCUyMGF4JTIwJTNEJTIwcGx0LnN1YnBsb3QoMyUyQyUyMDMlMkMlMjBpJTIwJTJCJTIwMSklMEElMjAlMjAlMjAlMjBpbWFnZV92aXolMjAlM0QlMjBtZXJnZV9pbnRvX3JvdyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyZGVwdGhfbWFwJTIyJTVEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHBsdC5pbXNob3coaW1hZ2Vfdml6LmFzdHlwZSglMjJ1aW50OCUyMikpJTBBJTIwJTIwJTIwJTIwcGx0LmF4aXMoJTIyb2ZmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_into_row</span>(<span class="hljs-params">input_image, depth_target</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> <span class="hljs-built_in">isinstance</span>(input_image, np.ndarray):
<span class="hljs-meta">... </span>        input_image = np.array(input_image)
...
<span class="hljs-meta">... </span>    d_min = np.<span class="hljs-built_in">min</span>(depth_target)
<span class="hljs-meta">... </span>    d_max = np.<span class="hljs-built_in">max</span>(depth_target)
<span class="hljs-meta">... </span>    depth_target_col = colored_depthmap(depth_target, d_min, d_max)
<span class="hljs-meta">... </span>    img_merge = np.hstack([input_image, depth_target_col])
...
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> img_merge

<span class="hljs-meta">&gt;&gt;&gt; </span>random_indices = np.random.choice(<span class="hljs-built_in">len</span>(train_dataset), <span class="hljs-number">9</span>).tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure(figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">6</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(random_indices):
<span class="hljs-meta">... </span>    example = train_dataset[idx]
<span class="hljs-meta">... </span>    ax = plt.subplot(<span class="hljs-number">3</span>, <span class="hljs-number">3</span>, i + <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    image_viz = merge_into_row(
<span class="hljs-meta">... </span>        example[<span class="hljs-string">&quot;image&quot;</span>], example[<span class="hljs-string">&quot;depth_map&quot;</span>]
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    plt.imshow(image_viz.astype(<span class="hljs-string">&quot;uint8&quot;</span>))
<span class="hljs-meta">... </span>    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)`,wrap:!1}}),z=new j({props:{code:"aW1wb3J0JTIwYWxidW1lbnRhdGlvbnMlMjBhcyUyMEElMEElMEFjcm9wX3NpemUlMjAlM0QlMjAoNDQ4JTJDJTIwNTc2KSUwQXRyYW5zZm9ybXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBBLkhvcml6b250YWxGbGlwKHAlM0QwLjUpJTJDJTBBJTIwJTIwJTIwJTIwQS5SYW5kb21Dcm9wKGNyb3Bfc2l6ZSU1QjAlNUQlMkMlMjBjcm9wX3NpemUlNUIxJTVEKSUyQyUwQSUyMCUyMCUyMCUyMEEuUmFuZG9tQnJpZ2h0bmVzc0NvbnRyYXN0KCklMkMlMEElMjAlMjAlMjAlMjBBLlJhbmRvbUdhbW1hKCklMkMlMEElMjAlMjAlMjAlMjBBLkh1ZVNhdHVyYXRpb25WYWx1ZSgpJTBBJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> albumentations <span class="hljs-keyword">as</span> A

<span class="hljs-meta">&gt;&gt;&gt; </span>crop_size = (<span class="hljs-number">448</span>, <span class="hljs-number">576</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transforms = [
<span class="hljs-meta">... </span>    A.HorizontalFlip(p=<span class="hljs-number">0.5</span>),
<span class="hljs-meta">... </span>    A.RandomCrop(crop_size[<span class="hljs-number">0</span>], crop_size[<span class="hljs-number">1</span>]),
<span class="hljs-meta">... </span>    A.RandomBrightnessContrast(),
<span class="hljs-meta">... </span>    A.RandomGamma(),
<span class="hljs-meta">... </span>    A.HueSaturationValue()
<span class="hljs-meta">... </span>]`,wrap:!1}}),L=new j({props:{code:"YWRkaXRpb25hbF90YXJnZXRzJTIwJTNEJTIwJTdCJTIyZGVwdGglMjIlM0ElMjAlMjJtYXNrJTIyJTdEJTBBYXVnJTIwJTNEJTIwQS5Db21wb3NlKHRyYW5zZm9ybXMlM0R0cmFuc2Zvcm1zJTJDJTIwYWRkaXRpb25hbF90YXJnZXRzJTNEYWRkaXRpb25hbF90YXJnZXRzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>additional_targets = {<span class="hljs-string">&quot;depth&quot;</span>: <span class="hljs-string">&quot;mask&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>aug = A.Compose(transforms=transforms, additional_targets=additional_targets)`,wrap:!1}}),P=new j({props:{code:"ZGVmJTIwYXBwbHlfdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lZF9pbWFnZXMlMkMlMjB0cmFuc2Zvcm1lZF9tYXBzJTIwJTNEJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaW1hZ2UlMkMlMjBkZXB0aF9tYXAlMjBpbiUyMHppcChleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTJDJTIwZXhhbXBsZXMlNUIlMjJkZXB0aF9tYXAlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMkMlMjBkZXB0aF9tYXAlMjAlM0QlMjBucC5hcnJheShpbWFnZSklMkMlMjBucC5hcnJheShkZXB0aF9tYXApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3JtZWQlMjAlM0QlMjBhdWcoaW1hZ2UlM0RpbWFnZSUyQyUyMGRlcHRoJTNEZGVwdGhfbWFwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybWVkX2ltYWdlcy5hcHBlbmQodHJhbnNmb3JtZWQlNUIlMjJpbWFnZSUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1lZF9tYXBzLmFwcGVuZCh0cmFuc2Zvcm1lZCU1QiUyMmRlcHRoJTIyJTVEKSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwdHJhbnNmb3JtZWRfaW1hZ2VzJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjB0cmFuc2Zvcm1lZF9tYXBzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">apply_transforms</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    transformed_images, transformed_maps = [], []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> image, depth_map <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;image&quot;</span>], examples[<span class="hljs-string">&quot;depth_map&quot;</span>]):
<span class="hljs-meta">... </span>        image, depth_map = np.array(image), np.array(depth_map)
<span class="hljs-meta">... </span>        transformed = aug(image=image, depth=depth_map)
<span class="hljs-meta">... </span>        transformed_images.append(transformed[<span class="hljs-string">&quot;image&quot;</span>])
<span class="hljs-meta">... </span>        transformed_maps.append(transformed[<span class="hljs-string">&quot;depth&quot;</span>])
...
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = transformed_images
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;labels&quot;</span>] = transformed_maps
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),O=new j({props:{code:"dHJhaW5fZGF0YXNldC5zZXRfdHJhbnNmb3JtKGFwcGx5X3RyYW5zZm9ybXMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset.set_transform(apply_transforms)',wrap:!1}}),ts=new j({props:{code:"ZXhhbXBsZSUyMCUzRCUyMHRyYWluX2RhdGFzZXQlNUJpbmRleCU1RCUwQSUwQXBsdC5pbXNob3coZXhhbXBsZSU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCklMEFwbHQuYXhpcyglMjJvZmYlMjIpJTBBcGx0LnNob3coKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = train_dataset[index]

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(example[<span class="hljs-string">&quot;pixel_values&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),es=new j({props:{code:"c2hvd19kZXB0aG1hcChleGFtcGxlJTVCJTIybGFiZWxzJTIyJTVEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>show_depthmap(example[<span class="hljs-string">&quot;labels&quot;</span>])',wrap:!1}}),ns=new j({props:{code:"cGx0LmZpZ3VyZShmaWdzaXplJTNEKDE1JTJDJTIwNikpJTBBJTBBZm9yJTIwaSUyQyUyMGlkeCUyMGluJTIwZW51bWVyYXRlKHJhbmRvbV9pbmRpY2VzKSUzQSUwQSUyMCUyMCUyMCUyMGF4JTIwJTNEJTIwcGx0LnN1YnBsb3QoMyUyQyUyMDMlMkMlMjBpJTIwJTJCJTIwMSklMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwdHJhaW5fZGF0YXNldCU1QmlkeCU1RCUwQSUyMCUyMCUyMCUyMGltYWdlX3ZpeiUyMCUzRCUyMG1lcmdlX2ludG9fcm93KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4YW1wbGUlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIybGFiZWxzJTIyJTVEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHBsdC5pbXNob3coaW1hZ2Vfdml6LmFzdHlwZSglMjJ1aW50OCUyMikpJTBBJTIwJTIwJTIwJTIwcGx0LmF4aXMoJTIyb2ZmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure(figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">6</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(random_indices):
<span class="hljs-meta">... </span>    ax = plt.subplot(<span class="hljs-number">3</span>, <span class="hljs-number">3</span>, i + <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    example = train_dataset[idx]
<span class="hljs-meta">... </span>    image_viz = merge_into_row(
<span class="hljs-meta">... </span>        example[<span class="hljs-string">&quot;pixel_values&quot;</span>], example[<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    plt.imshow(image_viz.astype(<span class="hljs-string">&quot;uint8&quot;</span>))
<span class="hljs-meta">... </span>    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)`,wrap:!1}}),ps=new Et({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/depth_estimation.mdx"}}),{c(){u=p("meta"),hs=l(),is=p("p"),cs=l(),h(C.$$.fragment),os=l(),_=p("p"),_.textContent=at,Ms=l(),I=p("p"),I.innerHTML=et,ds=l(),h(Z.$$.fragment),rs=l(),B=p("p"),B.innerHTML=lt,js=l(),G=p("p"),G.innerHTML=nt,us=l(),k=p("p"),k.innerHTML=pt,ws=l(),h(v.$$.fragment),ys=l(),x=p("p"),x.textContent=it,gs=l(),X=p("ul"),X.innerHTML=mt,Js=l(),$=p("p"),$.innerHTML=ht,fs=l(),A=p("p"),A.textContent=ct,Ts=l(),h(R.$$.fragment),Us=l(),y=p("div"),y.innerHTML=ot,bs=l(),W=p("p"),W.innerHTML=Mt,Cs=l(),h(E.$$.fragment),_s=l(),g=p("div"),g.innerHTML=dt,Is=l(),H=p("p"),H.innerHTML=rt,Zs=l(),h(F.$$.fragment),Bs=l(),J=p("div"),J.innerHTML=jt,Gs=l(),Q=p("p"),Q.textContent=ut,ks=l(),h(V.$$.fragment),vs=l(),f=p("div"),f.innerHTML=wt,xs=l(),N=p("p"),N.innerHTML=yt,Xs=l(),Y=p("ul"),Y.innerHTML=gt,$s=l(),h(z.$$.fragment),As=l(),S=p("p"),S.textContent=Jt,Rs=l(),h(L.$$.fragment),Ws=l(),q=p("p"),q.innerHTML=ft,Es=l(),K=p("p"),K.textContent=Tt,Hs=l(),h(P.$$.fragment),Fs=l(),D=p("p"),D.innerHTML=Ut,Qs=l(),h(O.$$.fragment),Vs=l(),ss=p("p"),ss.innerHTML=bt,Ns=l(),h(ts.$$.fragment),Ys=l(),T=p("div"),T.innerHTML=Ct,zs=l(),as=p("p"),as.textContent=_t,Ss=l(),h(es.$$.fragment),Ls=l(),U=p("div"),U.innerHTML=It,qs=l(),ls=p("p"),ls.innerHTML=Zt,Ks=l(),h(ns.$$.fragment),Ps=l(),b=p("div"),b.innerHTML=Bt,Ds=l(),h(ps.$$.fragment),Os=l(),ms=p("p"),this.h()},l(s){const t=At("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(a),hs=n(s),is=i(s,"P",{}),Gt(is).forEach(a),cs=n(s),c(C.$$.fragment,s),os=n(s),_=i(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-10bebb7"&&(_.textContent=at),Ms=n(s),I=i(s,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1e3jamv"&&(I.innerHTML=et),ds=n(s),c(Z.$$.fragment,s),rs=n(s),B=i(s,"P",{"data-svelte-h":!0}),m(B)!=="svelte-180f5nb"&&(B.innerHTML=lt),js=n(s),G=i(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-rbl7ww"&&(G.innerHTML=nt),us=n(s),k=i(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-pju1x0"&&(k.innerHTML=pt),ws=n(s),c(v.$$.fragment,s),ys=n(s),x=i(s,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1wdl8tg"&&(x.textContent=it),gs=n(s),X=i(s,"UL",{"data-svelte-h":!0}),m(X)!=="svelte-18g7ww2"&&(X.innerHTML=mt),Js=n(s),$=i(s,"P",{"data-svelte-h":!0}),m($)!=="svelte-lgny84"&&($.innerHTML=ht),fs=n(s),A=i(s,"P",{"data-svelte-h":!0}),m(A)!=="svelte-15dthpv"&&(A.textContent=ct),Ts=n(s),c(R.$$.fragment,s),Us=n(s),y=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(y)!=="svelte-1f5za0g"&&(y.innerHTML=ot),bs=n(s),W=i(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1rod9tf"&&(W.innerHTML=Mt),Cs=n(s),c(E.$$.fragment,s),_s=n(s),g=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(g)!=="svelte-130rqhd"&&(g.innerHTML=dt),Is=n(s),H=i(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-16bopxj"&&(H.innerHTML=rt),Zs=n(s),c(F.$$.fragment,s),Bs=n(s),J=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(J)!=="svelte-16ha3wj"&&(J.innerHTML=jt),Gs=n(s),Q=i(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-llua6z"&&(Q.textContent=ut),ks=n(s),c(V.$$.fragment,s),vs=n(s),f=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(f)!=="svelte-16sg8kz"&&(f.innerHTML=wt),xs=n(s),N=i(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-18gbq1z"&&(N.innerHTML=yt),Xs=n(s),Y=i(s,"UL",{"data-svelte-h":!0}),m(Y)!=="svelte-1r8fe9e"&&(Y.innerHTML=gt),$s=n(s),c(z.$$.fragment,s),As=n(s),S=i(s,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1yx9z74"&&(S.textContent=Jt),Rs=n(s),c(L.$$.fragment,s),Ws=n(s),q=i(s,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1obm0dg"&&(q.innerHTML=ft),Es=n(s),K=i(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-11hy1qw"&&(K.textContent=Tt),Hs=n(s),c(P.$$.fragment,s),Fs=n(s),D=i(s,"P",{"data-svelte-h":!0}),m(D)!=="svelte-10bzaw4"&&(D.innerHTML=Ut),Qs=n(s),c(O.$$.fragment,s),Vs=n(s),ss=i(s,"P",{"data-svelte-h":!0}),m(ss)!=="svelte-k3k6ue"&&(ss.innerHTML=bt),Ns=n(s),c(ts.$$.fragment,s),Ys=n(s),T=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(T)!=="svelte-1vylqwk"&&(T.innerHTML=Ct),zs=n(s),as=i(s,"P",{"data-svelte-h":!0}),m(as)!=="svelte-1yo7m5l"&&(as.textContent=_t),Ss=n(s),c(es.$$.fragment,s),Ls=n(s),U=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(U)!=="svelte-1wigtnh"&&(U.innerHTML=It),qs=n(s),ls=i(s,"P",{"data-svelte-h":!0}),m(ls)!=="svelte-wsimbk"&&(ls.innerHTML=Zt),Ks=n(s),c(ns.$$.fragment,s),Ps=n(s),b=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-9icv47"&&(b.innerHTML=Bt),Ds=n(s),c(ps.$$.fragment,s),Os=n(s),ms=i(s,"P",{}),Gt(ms).forEach(a),this.h()},h(){w(u,"name","hf:doc:metadata"),w(u,"content",Ft),w(y,"class","flex justify-center"),w(g,"class","flex justify-center"),w(J,"class","flex justify-center"),w(f,"class","flex justify-center"),w(T,"class","flex justify-center"),w(U,"class","flex justify-center"),w(b,"class","flex justify-center")},m(s,t){Rt(document.head,u),e(s,hs,t),e(s,is,t),e(s,cs,t),o(C,s,t),e(s,os,t),e(s,_,t),e(s,Ms,t),e(s,I,t),e(s,ds,t),o(Z,s,t),e(s,rs,t),e(s,B,t),e(s,js,t),e(s,G,t),e(s,us,t),e(s,k,t),e(s,ws,t),o(v,s,t),e(s,ys,t),e(s,x,t),e(s,gs,t),e(s,X,t),e(s,Js,t),e(s,$,t),e(s,fs,t),e(s,A,t),e(s,Ts,t),o(R,s,t),e(s,Us,t),e(s,y,t),e(s,bs,t),e(s,W,t),e(s,Cs,t),o(E,s,t),e(s,_s,t),e(s,g,t),e(s,Is,t),e(s,H,t),e(s,Zs,t),o(F,s,t),e(s,Bs,t),e(s,J,t),e(s,Gs,t),e(s,Q,t),e(s,ks,t),o(V,s,t),e(s,vs,t),e(s,f,t),e(s,xs,t),e(s,N,t),e(s,Xs,t),e(s,Y,t),e(s,$s,t),o(z,s,t),e(s,As,t),e(s,S,t),e(s,Rs,t),o(L,s,t),e(s,Ws,t),e(s,q,t),e(s,Es,t),e(s,K,t),e(s,Hs,t),o(P,s,t),e(s,Fs,t),e(s,D,t),e(s,Qs,t),o(O,s,t),e(s,Vs,t),e(s,ss,t),e(s,Ns,t),o(ts,s,t),e(s,Ys,t),e(s,T,t),e(s,zs,t),e(s,as,t),e(s,Ss,t),o(es,s,t),e(s,Ls,t),e(s,U,t),e(s,qs,t),e(s,ls,t),e(s,Ks,t),o(ns,s,t),e(s,Ps,t),e(s,b,t),e(s,Ds,t),o(ps,s,t),e(s,Os,t),e(s,ms,t),st=!0},p:vt,i(s){st||(M(C.$$.fragment,s),M(Z.$$.fragment,s),M(v.$$.fragment,s),M(R.$$.fragment,s),M(E.$$.fragment,s),M(F.$$.fragment,s),M(V.$$.fragment,s),M(z.$$.fragment,s),M(L.$$.fragment,s),M(P.$$.fragment,s),M(O.$$.fragment,s),M(ts.$$.fragment,s),M(es.$$.fragment,s),M(ns.$$.fragment,s),M(ps.$$.fragment,s),st=!0)},o(s){d(C.$$.fragment,s),d(Z.$$.fragment,s),d(v.$$.fragment,s),d(R.$$.fragment,s),d(E.$$.fragment,s),d(F.$$.fragment,s),d(V.$$.fragment,s),d(z.$$.fragment,s),d(L.$$.fragment,s),d(P.$$.fragment,s),d(O.$$.fragment,s),d(ts.$$.fragment,s),d(es.$$.fragment,s),d(ns.$$.fragment,s),d(ps.$$.fragment,s),st=!1},d(s){s&&(a(hs),a(is),a(cs),a(os),a(_),a(Ms),a(I),a(ds),a(rs),a(B),a(js),a(G),a(us),a(k),a(ws),a(ys),a(x),a(gs),a(X),a(Js),a($),a(fs),a(A),a(Ts),a(Us),a(y),a(bs),a(W),a(Cs),a(_s),a(g),a(Is),a(H),a(Zs),a(Bs),a(J),a(Gs),a(Q),a(ks),a(vs),a(f),a(xs),a(N),a(Xs),a(Y),a($s),a(As),a(S),a(Rs),a(Ws),a(q),a(Es),a(K),a(Hs),a(Fs),a(D),a(Qs),a(Vs),a(ss),a(Ns),a(Ys),a(T),a(zs),a(as),a(Ss),a(Ls),a(U),a(qs),a(ls),a(Ks),a(Ps),a(b),a(Ds),a(Os),a(ms)),a(u),r(C,s),r(Z,s),r(v,s),r(R,s),r(E,s),r(F,s),r(V,s),r(z,s),r(L,s),r(P,s),r(O,s),r(ts,s),r(es,s),r(ns,s),r(ps,s)}}}const Ft='{"title":"Depth estimation","local":"depth-estimation","sections":[],"depth":1}';function Qt(tt){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends Xt{constructor(u){super(),$t(this,u,Qt,Ht,kt,{})}}export{St as component};
