import{s as jM,f as wM,n as cM,o as uM}from"../chunks/scheduler.65852ee5.js";import{S as rM,i as dM,g as n,s as M,r as U,A as IM,h as y,f as e,c as a,j as TM,u as i,x as J,k as os,y as mM,a as t,v as o,d as p,t as w,w as T}from"../chunks/index.aa74147d.js";import{D as hM,C as j}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as c,E as bM}from"../chunks/EditOnGithub.4eda6a96.js";function CM(it){let u,Ts,ps,js,d,cs,I,us,m,ot='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',rs,h,pt="This notebook demonstrates how you can evaluate your RAG (Retrieval Augmented Generation), by building a synthetic evaluation dataset and using LLM-as-a-judge to compute the accuracy of your system.",ds,b,wt='For an introduction to RAG, you can check <a href="rag_zephyr_langchain">this other cookbook</a>!',Is,C,Tt="RAG systems are complex: here a RAG diagram, where we noted in blue all possibilities for system enhancement:",ms,B,jt,hs,Z,ct=`Implementing any of these improvements can bring a huge performance boost; but changing anything is useless if you cannot monitor the impact of your changes on the system’s performance!
So let’s see how to evaluate our RAG system.`,bs,G,Cs,A,ut="Since there are so many moving parts to tune with a big impact on performance, benchmarking the RAG system is crucial.",Bs,g,rt="For our evaluation pipeline, we will need:",Zs,f,dt="<li>An evaluation dataset with question - answer couples (QA couples)</li> <li>An evaluator to compute the accuracy of our system on the above evaluation dataset.</li>",Gs,Q,It="➡️ It turns out, we can use LLMs to help us all along the way!",As,W,mt='<li>The evaluation dataset will be synthetically generated by an LLM 🤖, and questions will be filtered out by other LLMs 🤖</li> <li>An <a href="https://huggingface.co/papers/2306.05685" rel="nofollow">LLM-as-a-judge</a> agent 🤖 will then perform the evaluation on this synthetic dataset.</li>',gs,V,ht="<strong>Let’s dig into it and start building our evaluation pipeline!</strong> First, we install the required model dependancies.",fs,R,Qs,v,Ws,X,Vs,k,Rs,N,vs,E,Xs,Y,ks,S,bt="We first build a synthetic dataset of questions and associated contexts. The method is to get elements from our knowledge base, and ask an LLM to generate questions based on these documents.",Ns,F,Ct="Then we setup other LLM agents to act as quality filters for the generated QA couples: each of them will act as the filter for a specific flaw.",Es,_,Ys,q,Ss,x,Fs,z,Bt='We use <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow">Mixtral</a> for QA couple generation because it it has excellent performance in leaderboards such as <a href="https://huggingface.co/spaces/lmsys/chatbot-arena-leaderboard" rel="nofollow">Chatbot Arena</a>.',_s,H,qs,$,xs,L,Zt=`Now let’s generate our QA couples.
For this example, we generate only 10 QA couples and will load the rest from the Hub.`,zs,D,Gt="But for your specific knowledge base, given that you want to get at least ~100 test samples, and accounting for the fact that we will filter out around half of these with our critique agents later on, you should generate much more, in the >200 samples.",Hs,K,$s,P,Ls,O,Ds,ll,At="The questions generated by the previous agent can have many flaws: we should do a quality check before validating these questions.",Ks,sl,gt='We thus build critique agents that will rate each question on several criteria, given in <a href="https://huggingface.co/papers/2312.10003" rel="nofollow">this paper</a>:',Ps,el,ft="<li><strong>Groundedness:</strong> can the question be answered from the given context?</li> <li><strong>Relevance:</strong> is the question relevant to users? For instance, <code>&quot;What is the date when transformers 4.29.1 was released?&quot;</code> is not relevant for ML practicioners.</li>",Os,tl,Qt=`One last failure case we’ve noticed is when a function is tailored for the particular setting where the question was generated, but undecipherable by itself, like <code>&quot;What is the name of the function used in this guide?&quot;</code>.
We also build a critique agent for this criteria:`,le,Ml,Wt="<li><strong>Stand-alone</strong>: is the question understandable free of any context, for someone with domain knowledge/Internet access? The opposite of this would be <code>What is the function used in this article?</code> for a question generated from a specific blog article.</li>",se,al,Vt="We systematically score functions with all these agents, and whenever the score is too low for any one of the agents, we eliminate the question from our eval dataset.",ee,nl,Rt="💡 <strong><em>When asking the agents to output a score, we first ask them to produce its rationale. This will help us verify scores, but most importantly, asking it to first output rationale gives the model more tokens to think and elaborate an answer before summarizing it into a single score token.</em></strong>",te,yl,vt="We now build and run these critique agents.",Me,Jl,ae,Ul,ne,il,Xt="Now let us filter out bad questions based on our critique agent scores:",ye,ol,Je,pl,kt=`Evaluation dataset before filtering:
`,Ue,wl,Nt="Now our synthetic evaluation dataset is complete! We can evaluate different RAG systems on this evaluation dataset.",ie,Tl,Et="We have generated only a few QA couples here to reduce time and cost. But let’s kick start the next part by loading a pre-generated dataset:",oe,jl,pe,cl,we,ul,Te,rl,Yt="<li>In this part, <strong>we split the documents from our knowledge base into smaller chunks</strong>: these will be the snippets that are picked by the Retriever, to then be ingested by the Reader LLM as supporting elements for its answer.</li> <li>The goal is to build semantically relevant snippets: not too small to be sufficient for supporting an answer, and not too large too avoid diluting individual ideas.</li>",je,dl,St="Many options exist for text splitting:",ce,Il,Ft="<li>split every <code>n</code> words / characters, but this has the risk of cutting in half paragraphs or even sentences</li> <li>split after <code>n</code> words / character, but only on sentence boundaries</li> <li><strong>recursive split</strong> tries to preserve even more of the document structure, by processing it tree-like way, splitting first on the largest units (chapters) then recursively splitting on smaller units (paragraphs, sentences).</li>",ue,ml,_t='To learn more about chunking, I recommend you read <a href="https://github.com/FullStackRetrieval-com/RetrievalTutorials/blob/main/tutorials/LevelsOfTextSplitting/5_Levels_Of_Text_Splitting.ipynb" rel="nofollow">this great notebook</a> by Greg Kamradt.',re,hl,qt='<a href="https://huggingface.co/spaces/m-ric/chunk_visualizer" rel="nofollow">This space</a> lets you visualize how different splitting options affect the chunks you get.',de,bl,xt="<p>In the following, we use Langchain’s <code>RecursiveCharacterTextSplitter</code>.</p>",Ie,Cl,zt="💡 <em>To measure chunk length in our Text Splitter, our length function will not be the count of characters, but the count of tokens in the tokenized text: indeed, for subsequent embedder that processes token, measuring length in tokens is more relevant and empirically performs better.</em>",me,Bl,he,Zl,be,Gl,Ce,Al,Ht="The <strong>retriever acts like an internal search engine</strong>: given the user query, it returns the most relevant documents from your knowledge base.",Be,gl,$t='<p>For the knowledge base, we use Langchain vector databases since <strong>it offers a convenient <a href="https://github.com/facebookresearch/faiss" rel="nofollow">FAISS</a> index and allows us to keep document metadata throughout the processing</strong>.</p>',Ze,fl,Lt="🛠️ <strong>Options included:</strong>",Ge,Ql,Dt='<li>Tune the chunking method:<ul><li>Size of the chunks</li> <li>Method: split on different separators, use <a href="https://python.langchain.com/docs/modules/data_connection/document_transformers/semantic-chunker" rel="nofollow">semantic chunking</a>…</li></ul></li> <li>Change the embedding model</li>',Ae,Wl,ge,Vl,fe,Rl,Kt="In this part, the <strong>LLM Reader reads the retrieved documents to formulate its answer.</strong>",Qe,vl,Pt="🛠️ Here we tried the following options to improve results:",We,Xl,Ot="<li>Switch reranking on/off</li> <li>Change the reader model</li>",Ve,kl,Re,Nl,ve,El,Xe,Yl,ke,Sl,lM="The RAG system and the evaluation datasets are now ready. The last step is to judge the RAG system’s output on this evlauation dataset.",Ne,Fl,sM="To this end, <strong>we setup a judge agent</strong>. ⚖️🤖",Ee,_l,eM='Out of <a href="https://docs.ragas.io/en/latest/concepts/metrics/index.html" rel="nofollow">the different RAG evaluation metrics</a>, we choose to focus only on faithfulness since it the best end-to-end metric of our system’s performance.',Ye,ql,tM='<p>We use GPT4 as a judge for its empirically good performance, but you could try with other models such as <a href="https://huggingface.co/kaist-ai/prometheus-13b-v1.0" rel="nofollow">kaist-ai/prometheus-13b-v1.0</a> or <a href="https://huggingface.co/BAAI/JudgeLM-33B-v1.0" rel="nofollow">BAAI/JudgeLM-33B-v1.0</a>.</p>',Se,xl,MM='💡 <em>In the evaluation prompt, we give a detailed description each metric on the scale 1-5, as is done in <a href="https://huggingface.co/kaist-ai/prometheus-13b-v1.0" rel="nofollow">Prometheus’s prompt template</a>: this helps the model ground its metric precisely. If instead you give the judge LLM a vague scale to work with, the outputs will not be consistent enough between different examples.</em>',Fe,zl,aM="💡 <em>Again, prompting the LLM to output rationale before giving its final score gives it more tokens to help it formalize and elaborate a judgement.</em>",_e,Hl,qe,$l,xe,Ll,ze,Dl,nM="🚀 Let’s run the tests and evaluate answers!👇",He,Kl,$e,Pl,Le,Ol,De,ls,Ke,ss,Pe,es,Oe,ts,yM=`Let us load the results that I obtained by tweaking the different options available in this notebook.
For more detail on why these options could work on not, see the notebook on <a href="advanced_rag">advanced_RAG</a>.`,lt,Ms,JM="As you can see in the graph below, some tweaks do not bring any improvement, some give huge performance boosts.",st,as,UM="➡️ <strong><em>There is no single good recipe: you should try several different directions when tuning your RAG systems.</em></strong>",et,ns,tt,ys,Mt,r,iM,at,Js,oM="As you can see, these had varying impact on performance. In particular, tuning the chunk size is both easy and very impactful.",nt,Us,pM="But this is our case: your results could be very different: now that you have a robust evaluation pipeline, you can set on to explore other options! 🗺️",yt,is,Jt,ws,Ut;return d=new hM({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/ko-advanced-rag/notebooks/en/rag_evaluation.ipynb"}]}}),I=new c({props:{title:"RAG Evaluation",local:"rag-evaluation",headingTag:"h1"}}),G=new c({props:{title:"Evaluating RAG performance",local:"evaluating-rag-performance",headingTag:"h3"}}),R=new j({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwdHJhbnNmb3JtZXJzJTIwbGFuZ2NoYWluJTIwc2VudGVuY2UtdHJhbnNmb3JtZXJzJTIwdHFkbSUyMG9wZW5weXhsJTIwb3BlbmFpJTIwcGFuZGFzJTIwZGF0YXNldHMlMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwcmFnYXRvdWlsbGU=",highlighted:"!pip install -q torch transformers transformers langchain sentence-transformers tqdm openpyxl openai pandas datasets langchain-community ragatouille",wrap:!1}}),v=new j({props:{code:"JTI1cmVsb2FkX2V4dCUyMGF1dG9yZWxvYWQlMEElMjVhdXRvcmVsb2FkJTIwMg==",highlighted:`%reload_ext autoreload
%autoreload <span class="hljs-number">2</span>`,wrap:!1}}),X=new j({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyME9wdGlvbmFsJTJDJTIwTGlzdCUyQyUyMFR1cGxlJTBBaW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMGRhdGFzZXRzJTBBJTBBcGQuc2V0X29wdGlvbiglMjJkaXNwbGF5Lm1heF9jb2x3aWR0aCUyMiUyQyUyME5vbmUp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Tuple</span>
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> datasets

pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)`,wrap:!1}}),k=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),N=new c({props:{title:"Load your knowledge base",local:"load-your-knowledge-base",headingTag:"h3"}}),E=new j({props:{code:"ZHMlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIybS1yaWMlMkZodWdnaW5nZmFjZV9kb2MlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:'ds = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)',wrap:!1}}),Y=new c({props:{title:"1. Build a synthetic dataset for evaluation",local:"1-build-a-synthetic-dataset-for-evaluation",headingTag:"h1"}}),_=new c({props:{title:"1.1. Prepare source documents",local:"11-prepare-source-documents",headingTag:"h3"}}),q=new j({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTIwYXMlMjBMYW5nY2hhaW5Eb2N1bWVudCUwQSUwQWxhbmdjaGFpbl9kb2NzJTIwJTNEJTIwJTVCTGFuZ2NoYWluRG9jdW1lbnQocGFnZV9jb250ZW50JTNEZG9jJTVCJTIydGV4dCUyMiU1RCUyQyUyMG1ldGFkYXRhJTNEJTdCJTIyc291cmNlJTIyJTNBJTIwZG9jJTVCJTIyc291cmNlJTIyJTVEJTdEKSUyMGZvciUyMGRvYyUyMGluJTIwdHFkbShkcyklNUQlMEElMEElMEF0ZXh0X3NwbGl0dGVyJTIwJTNEJTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyKCUwQSUyMCUyMCUyMCUyMGNodW5rX3NpemUlM0QyMDAwJTJDJTBBJTIwJTIwJTIwJTIwY2h1bmtfb3ZlcmxhcCUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMGFkZF9zdGFydF9pbmRleCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzZXBhcmF0b3JzJTNEJTVCJTIyJTVDbiU1Q24lMjIlMkMlMjAlMjIlNUNuJTIyJTJDJTIwJTIyLiUyMiUyQyUyMCUyMiUyMCUyMiUyQyUyMCUyMiUyMiU1RCUyQyUwQSklMEElMEFkb2NzX3Byb2Nlc3NlZCUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMGRvYyUyMGluJTIwbGFuZ2NoYWluX2RvY3MlM0ElMEElMjAlMjAlMjAlMjBkb2NzX3Byb2Nlc3NlZCUyMCUyQiUzRCUyMHRleHRfc3BsaXR0ZXIuc3BsaXRfZG9jdW1lbnRzKCU1QmRvYyU1RCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document <span class="hljs-keyword">as</span> LangchainDocument

langchain_docs = [LangchainDocument(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(ds)]


text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">2000</span>,
    chunk_overlap=<span class="hljs-number">200</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)

docs_processed = []
<span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> langchain_docs:
    docs_processed += text_splitter.split_documents([doc])`,wrap:!1}}),x=new c({props:{title:"1.2. Setup agents for question generation",local:"12-setup-agents-for-question-generation",headingTag:"h3"}}),H=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJtaXN0cmFsYWklMkZNaXh0cmFsLTh4N0ItSW5zdHJ1Y3QtdjAuMSUyMiUwQSUwQWxsbV9jbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwdGltZW91dCUzRDEyMCUyQyUwQSklMEElMEElMEFkZWYlMjBjYWxsX2xsbShpbmZlcmVuY2VfY2xpZW50JTNBJTIwSW5mZXJlbmNlQ2xpZW50JTJDJTIwcHJvbXB0JTNBJTIwc3RyKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwaW5mZXJlbmNlX2NsaWVudC5wb3N0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGpzb24lM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnB1dHMlMjIlM0ElMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYXJhbWV0ZXJzJTIyJTNBJTIwJTdCJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMDAwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBqc29uLmxvYWRzKHJlc3BvbnNlLmRlY29kZSgpKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCUwQSUwQSUwQWNhbGxfbGxtKGxsbV9jbGllbnQlMkMlMjAlMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMGNvbnRleHQlMjIp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient


repo_id = <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>

llm_client = InferenceClient(
    model=repo_id,
    timeout=<span class="hljs-number">120</span>,
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">call_llm</span>(<span class="hljs-params">inference_client: InferenceClient, prompt: <span class="hljs-built_in">str</span></span>):
    response = inference_client.post(
        json={
            <span class="hljs-string">&quot;inputs&quot;</span>: prompt,
            <span class="hljs-string">&quot;parameters&quot;</span>: {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">1000</span>},
            <span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;text-generation&quot;</span>,
        },
    )
    <span class="hljs-keyword">return</span> json.loads(response.decode())[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]


call_llm(llm_client, <span class="hljs-string">&quot;This is a test context&quot;</span>)`,wrap:!1}}),$=new j({props:{code:"UUFfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFZb3VyJTIwdGFzayUyMGlzJTIwdG8lMjB3cml0ZSUyMGElMjBmYWN0b2lkJTIwcXVlc3Rpb24lMjBhbmQlMjBhbiUyMGFuc3dlciUyMGdpdmVuJTIwYSUyMGNvbnRleHQuJTBBWW91ciUyMGZhY3RvaWQlMjBxdWVzdGlvbiUyMHNob3VsZCUyMGJlJTIwYW5zd2VyYWJsZSUyMHdpdGglMjBhJTIwc3BlY2lmaWMlMkMlMjBjb25jaXNlJTIwcGllY2UlMjBvZiUyMGZhY3R1YWwlMjBpbmZvcm1hdGlvbiUyMGZyb20lMjB0aGUlMjBjb250ZXh0LiUwQVlvdXIlMjBmYWN0b2lkJTIwcXVlc3Rpb24lMjBzaG91bGQlMjBiZSUyMGZvcm11bGF0ZWQlMjBpbiUyMHRoZSUyMHNhbWUlMjBzdHlsZSUyMGFzJTIwcXVlc3Rpb25zJTIwdXNlcnMlMjBjb3VsZCUyMGFzayUyMGluJTIwYSUyMHNlYXJjaCUyMGVuZ2luZS4lMEFUaGlzJTIwbWVhbnMlMjB0aGF0JTIweW91ciUyMGZhY3RvaWQlMjBxdWVzdGlvbiUyME1VU1QlMjBOT1QlMjBtZW50aW9uJTIwc29tZXRoaW5nJTIwbGlrZSUyMCUyMmFjY29yZGluZyUyMHRvJTIwdGhlJTIwcGFzc2FnZSUyMiUyMG9yJTIwJTIyY29udGV4dCUyMi4lMEElMEFQcm92aWRlJTIweW91ciUyMGFuc3dlciUyMGFzJTIwZm9sbG93cyUzQSUwQSUwQU91dHB1dCUzQSUzQSUzQSUwQUZhY3RvaWQlMjBxdWVzdGlvbiUzQSUyMCh5b3VyJTIwZmFjdG9pZCUyMHF1ZXN0aW9uKSUwQUFuc3dlciUzQSUyMCh5b3VyJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjBmYWN0b2lkJTIwcXVlc3Rpb24pJTBBJTBBTm93JTIwaGVyZSUyMGlzJTIwdGhlJTIwY29udGV4dC4lMEElMEFDb250ZXh0JTNBJTIwJTdCY29udGV4dCU3RCU1Q24lMEFPdXRwdXQlM0ElM0ElM0ElMjIlMjIlMjI=",highlighted:`QA_generation_prompt = <span class="hljs-string">&quot;&quot;&quot;
Your task is to write a factoid question and an answer given a context.
Your factoid question should be answerable with a specific, concise piece of factual information from the context.
Your factoid question should be formulated in the same style as questions users could ask in a search engine.
This means that your factoid question MUST NOT mention something like &quot;according to the passage&quot; or &quot;context&quot;.

Provide your answer as follows:

Output:::
Factoid question: (your factoid question)
Answer: (your answer to the factoid question)

Now here is the context.

Context: {context}\\n
Output:::&quot;&quot;&quot;</span>`,wrap:!1}}),K=new j({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBJTBBTl9HRU5FUkFUSU9OUyUyMCUzRCUyMDEwJTIwJTIwJTIzJTIwV2UlMjBpbnRlbnRpb25hbGx5JTIwZ2VuZXJhdGUlMjBvbmx5JTIwMTAlMjBRQSUyMGNvdXBsZXMlMjBoZXJlJTIwZm9yJTIwY29zdCUyMGFuZCUyMHRpbWUlMjBjb25zaWRlcmF0aW9ucyUwQSUwQXByaW50KGYlMjJHZW5lcmF0aW5nJTIwJTdCTl9HRU5FUkFUSU9OUyU3RCUyMFFBJTIwY291cGxlcy4uLiUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwc2FtcGxlZF9jb250ZXh0JTIwaW4lMjB0cWRtKHJhbmRvbS5zYW1wbGUoZG9jc19wcm9jZXNzZWQlMkMlMjBOX0dFTkVSQVRJT05TKSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBHZW5lcmF0ZSUyMFFBJTIwY291cGxlJTBBJTIwJTIwJTIwJTIwb3V0cHV0X1FBX2NvdXBsZSUyMCUzRCUyMGNhbGxfbGxtKGxsbV9jbGllbnQlMkMlMjBRQV9nZW5lcmF0aW9uX3Byb21wdC5mb3JtYXQoY29udGV4dCUzRHNhbXBsZWRfY29udGV4dC5wYWdlX2NvbnRlbnQpKSUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXN0aW9uJTIwJTNEJTIwb3V0cHV0X1FBX2NvdXBsZS5zcGxpdCglMjJGYWN0b2lkJTIwcXVlc3Rpb24lM0ElMjAlMjIpJTVCLTElNUQuc3BsaXQoJTIyQW5zd2VyJTNBJTIwJTIyKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbnN3ZXIlMjAlM0QlMjBvdXRwdXRfUUFfY291cGxlLnNwbGl0KCUyMkFuc3dlciUzQSUyMCUyMiklNUItMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFzc2VydCUyMGxlbihhbnN3ZXIpJTIwJTNDJTIwMzAwJTJDJTIwJTIyQW5zd2VyJTIwaXMlMjB0b28lMjBsb25nJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cy5hcHBlbmQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMHNhbXBsZWRfY29udGV4dC5wYWdlX2NvbnRlbnQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbiUyMiUzQSUyMHF1ZXN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYW5zd2VyJTIyJTNBJTIwYW5zd2VyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc291cmNlX2RvYyUyMiUzQSUyMHNhbXBsZWRfY29udGV4dC5tZXRhZGF0YSU1QiUyMnNvdXJjZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBleGNlcHQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb250aW51ZQ==",highlighted:`<span class="hljs-keyword">import</span> random

N_GENERATIONS = <span class="hljs-number">10</span>  <span class="hljs-comment"># We intentionally generate only 10 QA couples here for cost and time considerations</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generating <span class="hljs-subst">{N_GENERATIONS}</span> QA couples...&quot;</span>)

outputs = []
<span class="hljs-keyword">for</span> sampled_context <span class="hljs-keyword">in</span> tqdm(random.sample(docs_processed, N_GENERATIONS)):
    <span class="hljs-comment"># Generate QA couple</span>
    output_QA_couple = call_llm(llm_client, QA_generation_prompt.<span class="hljs-built_in">format</span>(context=sampled_context.page_content))
    <span class="hljs-keyword">try</span>:
        question = output_QA_couple.split(<span class="hljs-string">&quot;Factoid question: &quot;</span>)[-<span class="hljs-number">1</span>].split(<span class="hljs-string">&quot;Answer: &quot;</span>)[<span class="hljs-number">0</span>]
        answer = output_QA_couple.split(<span class="hljs-string">&quot;Answer: &quot;</span>)[-<span class="hljs-number">1</span>]
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">len</span>(answer) &lt; <span class="hljs-number">300</span>, <span class="hljs-string">&quot;Answer is too long&quot;</span>
        outputs.append(
            {
                <span class="hljs-string">&quot;context&quot;</span>: sampled_context.page_content,
                <span class="hljs-string">&quot;question&quot;</span>: question,
                <span class="hljs-string">&quot;answer&quot;</span>: answer,
                <span class="hljs-string">&quot;source_doc&quot;</span>: sampled_context.metadata[<span class="hljs-string">&quot;source&quot;</span>],
            }
        )
    <span class="hljs-keyword">except</span>:
        <span class="hljs-keyword">continue</span>`,wrap:!1}}),P=new j({props:{code:"ZGlzcGxheShwZC5EYXRhRnJhbWUob3V0cHV0cykuaGVhZCgxKSk=",highlighted:'display(pd.DataFrame(outputs).head(<span class="hljs-number">1</span>))',wrap:!1}}),O=new c({props:{title:"1.3. Setup critique agents",local:"13-setup-critique-agents",headingTag:"h3"}}),Jl=new j({props:{code:"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",highlighted:`question_groundedness_critique_prompt = <span class="hljs-string">&quot;&quot;&quot;
You will be given a context and a question.
Your task is to provide a &#x27;total rating&#x27; scoring how well one can answer the given question unambiguously with the given context.
Give your answer on a scale of 1 to 5, where 1 means that the question is not answerable at all given the context, and 5 means that the question is clearly and unambiguously answerable with the context.

Provide your answer as follows:

Answer:::
Evaluation: (your rationale for the rating, as a text)
Total rating: (your rating, as a number between 1 and 5)

You MUST provide values for &#x27;Evaluation:&#x27; and &#x27;Total rating:&#x27; in your answer.

Now here are the question and context.

Question: {question}\\n
Context: {context}\\n
Answer::: &quot;&quot;&quot;</span>

question_relevance_critique_prompt = <span class="hljs-string">&quot;&quot;&quot;
You will be given a question.
Your task is to provide a &#x27;total rating&#x27; representing how useful this question can be to machine learning developers building NLP applications with the Hugging Face ecosystem.
Give your answer on a scale of 1 to 5, where 1 means that the question is not useful at all, and 5 means that the question is extremely useful.

Provide your answer as follows:

Answer:::
Evaluation: (your rationale for the rating, as a text)
Total rating: (your rating, as a number between 1 and 5)

You MUST provide values for &#x27;Evaluation:&#x27; and &#x27;Total rating:&#x27; in your answer.

Now here is the question.

Question: {question}\\n
Answer::: &quot;&quot;&quot;</span>

question_standalone_critique_prompt = <span class="hljs-string">&quot;&quot;&quot;
You will be given a question.
Your task is to provide a &#x27;total rating&#x27; representing how context-independant this question is.
Give your answer on a scale of 1 to 5, where 1 means that the question depends on additional information to be understood, and 5 means that the question makes sense by itself.
For instance, if the question refers to a particular setting, like &#x27;in the context&#x27; or &#x27;in the document&#x27;, the rating must be 1.
The questions can contain obscure technical nouns or acronyms like Gradio, Hub, Hugging Face or Space and still be a 5: it must simply be clear to an operator with access to documentation what the question is about.

For instance, &quot;What is the name of the checkpoint from which the ViT model is imported?&quot; should receive a 1, since there is an implicit mention of a context, thus the question is not independant from the context.

Provide your answer as follows:

Answer:::
Evaluation: (your rationale for the rating, as a text)
Total rating: (your rating, as a number between 1 and 5)

You MUST provide values for &#x27;Evaluation:&#x27; and &#x27;Total rating:&#x27; in your answer.

Now here is the question.

Question: {question}\\n
Answer::: &quot;&quot;&quot;</span>`,wrap:!1}}),Ul=new j({props:{code:"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",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Generating critique for each QA couple...&quot;</span>)
<span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> tqdm(outputs):
    evaluations = {
        <span class="hljs-string">&quot;groundedness&quot;</span>: call_llm(
            llm_client,
            question_groundedness_critique_prompt.<span class="hljs-built_in">format</span>(context=output[<span class="hljs-string">&quot;context&quot;</span>], question=output[<span class="hljs-string">&quot;question&quot;</span>]),
        ),
        <span class="hljs-string">&quot;relevance&quot;</span>: call_llm(
            llm_client,
            question_relevance_critique_prompt.<span class="hljs-built_in">format</span>(question=output[<span class="hljs-string">&quot;question&quot;</span>]),
        ),
        <span class="hljs-string">&quot;standalone&quot;</span>: call_llm(
            llm_client,
            question_standalone_critique_prompt.<span class="hljs-built_in">format</span>(question=output[<span class="hljs-string">&quot;question&quot;</span>]),
        ),
    }
    <span class="hljs-keyword">try</span>:
        <span class="hljs-keyword">for</span> criterion, evaluation <span class="hljs-keyword">in</span> evaluations.items():
            score, <span class="hljs-built_in">eval</span> = (
                <span class="hljs-built_in">int</span>(evaluation.split(<span class="hljs-string">&quot;Total rating: &quot;</span>)[-<span class="hljs-number">1</span>].strip()),
                evaluation.split(<span class="hljs-string">&quot;Total rating: &quot;</span>)[-<span class="hljs-number">2</span>].split(<span class="hljs-string">&quot;Evaluation: &quot;</span>)[<span class="hljs-number">1</span>],
            )
            output.update(
                {
                    <span class="hljs-string">f&quot;<span class="hljs-subst">{criterion}</span>_score&quot;</span>: score,
                    <span class="hljs-string">f&quot;<span class="hljs-subst">{criterion}</span>_eval&quot;</span>: <span class="hljs-built_in">eval</span>,
                }
            )
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">continue</span>`,wrap:!1}}),ol=new j({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_questions = pd.DataFrame.from_dict(outputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Evaluation dataset before filtering:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>display(
<span class="hljs-meta">... </span>    generated_questions[
<span class="hljs-meta">... </span>        [
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;question&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;answer&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;groundedness_score&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;relevance_score&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;standalone_score&quot;</span>,
<span class="hljs-meta">... </span>        ]
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_questions = generated_questions.loc[
<span class="hljs-meta">... </span>    (generated_questions[<span class="hljs-string">&quot;groundedness_score&quot;</span>] &gt;= <span class="hljs-number">4</span>)
<span class="hljs-meta">... </span>    &amp; (generated_questions[<span class="hljs-string">&quot;relevance_score&quot;</span>] &gt;= <span class="hljs-number">4</span>)
<span class="hljs-meta">... </span>    &amp; (generated_questions[<span class="hljs-string">&quot;standalone_score&quot;</span>] &gt;= <span class="hljs-number">4</span>)
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;============================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final evaluation dataset:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>display(
<span class="hljs-meta">... </span>    generated_questions[
<span class="hljs-meta">... </span>        [
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;question&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;answer&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;groundedness_score&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;relevance_score&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;standalone_score&quot;</span>,
<span class="hljs-meta">... </span>        ]
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>eval_dataset = datasets.Dataset.from_pandas(generated_questions, split=<span class="hljs-string">&quot;train&quot;</span>, preserve_index=<span class="hljs-literal">False</span>)`,wrap:!1}}),jl=new j({props:{code:"ZXZhbF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGaHVnZ2luZ2ZhY2VfZG9jX3FhX2V2YWwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:'eval_dataset = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc_qa_eval&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)',wrap:!1}}),cl=new c({props:{title:"2. Build our RAG System",local:"2-build-our-rag-system",headingTag:"h1"}}),ul=new c({props:{title:"2.1. Preprocessing documents to build our vector database",local:"21-preprocessing-documents-to-build-our-vector-database",headingTag:"h3"}}),Bl=new j({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTIwYXMlMjBMYW5nY2hhaW5Eb2N1bWVudCUwQSUwQVJBV19LTk9XTEVER0VfQkFTRSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMExhbmdjaGFpbkRvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMHRxZG0oZHMpJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document <span class="hljs-keyword">as</span> LangchainDocument

RAW_KNOWLEDGE_BASE = [
    LangchainDocument(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(ds)
]`,wrap:!1}}),Zl=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer


<span class="hljs-keyword">def</span> <span class="hljs-title function_">split_documents</span>(<span class="hljs-params">
    chunk_size: <span class="hljs-built_in">int</span>,
    knowledge_base: <span class="hljs-type">List</span>[LangchainDocument],
    tokenizer_name: <span class="hljs-built_in">str</span>,
</span>) -&gt; <span class="hljs-type">List</span>[LangchainDocument]:
    <span class="hljs-string">&quot;&quot;&quot;
    Split documents into chunks of size \`chunk_size\` characters and return a list of documents.
    &quot;&quot;&quot;</span>
    text_splitter = RecursiveCharacterTextSplitter.from_huggingface_tokenizer(
        AutoTokenizer.from_pretrained(tokenizer_name),
        chunk_size=chunk_size,
        chunk_overlap=<span class="hljs-built_in">int</span>(chunk_size / <span class="hljs-number">10</span>),
        add_start_index=<span class="hljs-literal">True</span>,
        strip_whitespace=<span class="hljs-literal">True</span>,
        separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
    )

    docs_processed = []
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base:
        docs_processed += text_splitter.split_documents([doc])

    <span class="hljs-comment"># Remove duplicates</span>
    unique_texts = {}
    docs_processed_unique = []
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed:
        <span class="hljs-keyword">if</span> doc.page_content <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> unique_texts:
            unique_texts[doc.page_content] = <span class="hljs-literal">True</span>
            docs_processed_unique.append(doc)

    <span class="hljs-keyword">return</span> docs_processed_unique`,wrap:!1}}),Gl=new c({props:{title:"2.2. Retriever - embeddings 🗂️",local:"22-retriever---embeddings-",headingTag:"h3"}}),Wl=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings
<span class="hljs-keyword">from</span> langchain_community.vectorstores.utils <span class="hljs-keyword">import</span> DistanceStrategy
<span class="hljs-keyword">import</span> os


<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_embeddings</span>(<span class="hljs-params">
    langchain_docs: <span class="hljs-type">List</span>[LangchainDocument],
    chunk_size: <span class="hljs-built_in">int</span>,
    embedding_model_name: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = <span class="hljs-string">&quot;thenlper/gte-small&quot;</span>,
</span>) -&gt; FAISS:
    <span class="hljs-string">&quot;&quot;&quot;
    Creates a FAISS index from the given embedding model and documents. Loads the index directly if it already exists.

    Args:
        langchain_docs: list of documents
        chunk_size: size of the chunks to split the documents into
        embedding_model_name: name of the embedding model to use

    Returns:
        FAISS index
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># load embedding_model</span>
    embedding_model = HuggingFaceEmbeddings(
        model_name=embedding_model_name,
        multi_process=<span class="hljs-literal">True</span>,
        model_kwargs={<span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cuda&quot;</span>},
        encode_kwargs={<span class="hljs-string">&quot;normalize_embeddings&quot;</span>: <span class="hljs-literal">True</span>},  <span class="hljs-comment"># set True to compute cosine similarity</span>
    )

    <span class="hljs-comment"># Check if embeddings already exist on disk</span>
    index_name = <span class="hljs-string">f&quot;index_chunk:<span class="hljs-subst">{chunk_size}</span>_embeddings:<span class="hljs-subst">{embedding_model_name.replace(<span class="hljs-string">&#x27;/&#x27;</span>, <span class="hljs-string">&#x27;~&#x27;</span>)}</span>&quot;</span>
    index_folder_path = <span class="hljs-string">f&quot;./data/indexes/<span class="hljs-subst">{index_name}</span>/&quot;</span>
    <span class="hljs-keyword">if</span> os.path.isdir(index_folder_path):
        <span class="hljs-keyword">return</span> FAISS.load_local(
            index_folder_path,
            embedding_model,
            distance_strategy=DistanceStrategy.COSINE,
        )

    <span class="hljs-keyword">else</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Index not found, generating it...&quot;</span>)
        docs_processed = split_documents(
            chunk_size,
            langchain_docs,
            embedding_model_name,
        )
        knowledge_index = FAISS.from_documents(
            docs_processed, embedding_model, distance_strategy=DistanceStrategy.COSINE
        )
        knowledge_index.save_local(index_folder_path)
        <span class="hljs-keyword">return</span> knowledge_index`,wrap:!1}}),Vl=new c({props:{title:"2.3. Reader - LLM 💬",local:"23-reader---llm-",headingTag:"h3"}}),kl=new j({props:{code:"UkFHX1BST01QVF9URU1QTEFURSUyMCUzRCUyMCUyMiUyMiUyMiUwQSUzQyU3Q3N5c3RlbSU3QyUzRSUwQVVzaW5nJTIwdGhlJTIwaW5mb3JtYXRpb24lMjBjb250YWluZWQlMjBpbiUyMHRoZSUyMGNvbnRleHQlMkMlMEFnaXZlJTIwYSUyMGNvbXByZWhlbnNpdmUlMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHF1ZXN0aW9uLiUwQVJlc3BvbmQlMjBvbmx5JTIwdG8lMjB0aGUlMjBxdWVzdGlvbiUyMGFza2VkJTJDJTIwcmVzcG9uc2UlMjBzaG91bGQlMjBiZSUyMGNvbmNpc2UlMjBhbmQlMjByZWxldmFudCUyMHRvJTIwdGhlJTIwcXVlc3Rpb24uJTBBUHJvdmlkZSUyMHRoZSUyMG51bWJlciUyMG9mJTIwdGhlJTIwc291cmNlJTIwZG9jdW1lbnQlMjB3aGVuJTIwcmVsZXZhbnQuJTBBSWYlMjB0aGUlMjBhbnN3ZXIlMjBjYW5ub3QlMjBiZSUyMGRlZHVjZWQlMjBmcm9tJTIwdGhlJTIwY29udGV4dCUyQyUyMGRvJTIwbm90JTIwZ2l2ZSUyMGFuJTIwYW5zd2VyLiUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBQ29udGV4dCUzQSUwQSU3QmNvbnRleHQlN0QlMEEtLS0lMEFOb3clMjBoZXJlJTIwaXMlMjB0aGUlMjBxdWVzdGlvbiUyMHlvdSUyMG5lZWQlMjB0byUyMGFuc3dlci4lMEElMEFRdWVzdGlvbiUzQSUyMCU3QnF1ZXN0aW9uJTdEJTBBJTNDJTJGcyUzRSUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`RAG_PROMPT_TEMPLATE = <span class="hljs-string">&quot;&quot;&quot;
&lt;|system|&gt;
Using the information contained in the context,
give a comprehensive answer to the question.
Respond only to the question asked, response should be concise and relevant to the question.
Provide the number of the source document when relevant.
If the answer cannot be deduced from the context, do not give an answer.&lt;/s&gt;
&lt;|user|&gt;
Context:
{context}
---
Now here is the question you need to answer.

Question: {question}
&lt;/s&gt;
&lt;|assistant|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),Nl=new j({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkubGxtcyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlSHViJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiUwQVJFQURFUl9NT0RFTF9OQU1FJTIwJTNEJTIwJTIyemVwaHlyLTdiLWJldGElMjIlMEFIRl9BUElfVE9LRU4lMjAlM0QlMjAlMjIlMjIlMEElMEFSRUFERVJfTExNJTIwJTNEJTIwSHVnZ2luZ0ZhY2VIdWIoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRHJlcG9faWQlMkMlMEElMjAlMjAlMjAlMjB0YXNrJTNEJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwaHVnZ2luZ2ZhY2VodWJfYXBpX3Rva2VuJTNESEZfQVBJX1RPS0VOJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfa3dhcmdzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjA1MTIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3BfayUyMiUzQSUyMDMwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXBldGl0aW9uX3BlbmFsdHklMjIlM0ElMjAxLjAzJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_community.llms <span class="hljs-keyword">import</span> HuggingFaceHub

repo_id = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
READER_MODEL_NAME = <span class="hljs-string">&quot;zephyr-7b-beta&quot;</span>
HF_API_TOKEN = <span class="hljs-string">&quot;&quot;</span>

READER_LLM = HuggingFaceHub(
    repo_id=repo_id,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    huggingfacehub_api_token=HF_API_TOKEN,
    model_kwargs={
        <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>,
        <span class="hljs-string">&quot;top_k&quot;</span>: <span class="hljs-number">30</span>,
        <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.1</span>,
        <span class="hljs-string">&quot;repetition_penalty&quot;</span>: <span class="hljs-number">1.03</span>,
    },
)`,wrap:!1}}),El=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> ragatouille <span class="hljs-keyword">import</span> RAGPretrainedModel
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore
<span class="hljs-keyword">from</span> langchain_core.language_models.llms <span class="hljs-keyword">import</span> LLM


<span class="hljs-keyword">def</span> <span class="hljs-title function_">answer_with_rag</span>(<span class="hljs-params">
    question: <span class="hljs-built_in">str</span>,
    llm: LLM,
    knowledge_index: VectorStore,
    reranker: <span class="hljs-type">Optional</span>[RAGPretrainedModel] = <span class="hljs-literal">None</span>,
    num_retrieved_docs: <span class="hljs-built_in">int</span> = <span class="hljs-number">30</span>,
    num_docs_final: <span class="hljs-built_in">int</span> = <span class="hljs-number">7</span>,
</span>) -&gt; <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">List</span>[LangchainDocument]]:
    <span class="hljs-string">&quot;&quot;&quot;Answer a question using RAG with the given knowledge index.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># Gather documents with retriever</span>
    relevant_docs = knowledge_index.similarity_search(query=question, k=num_retrieved_docs)
    relevant_docs = [doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs]  <span class="hljs-comment"># keep only the text</span>

    <span class="hljs-comment"># Optionally rerank results</span>
    <span class="hljs-keyword">if</span> reranker:
        relevant_docs = reranker.rerank(question, relevant_docs, k=num_docs_final)
        relevant_docs = [doc[<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs]

    relevant_docs = relevant_docs[:num_docs_final]

    <span class="hljs-comment"># Build the final prompt</span>
    context = <span class="hljs-string">&quot;\\nExtracted documents:\\n&quot;</span>
    context += <span class="hljs-string">&quot;&quot;</span>.join([<span class="hljs-string">f&quot;Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span>:::\\n&quot;</span> + doc <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(relevant_docs)])

    final_prompt = RAG_PROMPT_TEMPLATE.<span class="hljs-built_in">format</span>(question=question, context=context)

    <span class="hljs-comment"># Redact an answer</span>
    answer = llm(final_prompt)

    <span class="hljs-keyword">return</span> answer, relevant_docs`,wrap:!1}}),Yl=new c({props:{title:"3. Benchmarking the RAG system",local:"3-benchmarking-the-rag-system",headingTag:"h1"}}),Hl=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain_core.language_models <span class="hljs-keyword">import</span> BaseChatModel


<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_rag_tests</span>(<span class="hljs-params">
    eval_dataset: datasets.Dataset,
    llm,
    knowledge_index: VectorStore,
    output_file: <span class="hljs-built_in">str</span>,
    reranker: <span class="hljs-type">Optional</span>[RAGPretrainedModel] = <span class="hljs-literal">None</span>,
    verbose: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">True</span>,
    test_settings: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = <span class="hljs-literal">None</span>,  <span class="hljs-comment"># To document the test settings used</span>
</span>):
    <span class="hljs-string">&quot;&quot;&quot;Runs RAG tests on the given dataset and saves the results to the given output file.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:  <span class="hljs-comment"># load previous generations if they exist</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(output_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
            outputs = json.load(f)
    <span class="hljs-keyword">except</span>:
        outputs = []

    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
        question = example[<span class="hljs-string">&quot;question&quot;</span>]
        <span class="hljs-keyword">if</span> question <span class="hljs-keyword">in</span> [output[<span class="hljs-string">&quot;question&quot;</span>] <span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> outputs]:
            <span class="hljs-keyword">continue</span>

        answer, relevant_docs = answer_with_rag(question, llm, knowledge_index, reranker=reranker)
        <span class="hljs-keyword">if</span> verbose:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)
        result = {
            <span class="hljs-string">&quot;question&quot;</span>: question,
            <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
            <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
            <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
            <span class="hljs-string">&quot;retrieved_docs&quot;</span>: [doc <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs],
        }
        <span class="hljs-keyword">if</span> test_settings:
            result[<span class="hljs-string">&quot;test_settings&quot;</span>] = test_settings
        outputs.append(result)

        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(output_file, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
            json.dump(outputs, f)`,wrap:!1}}),$l=new j({props:{code:"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",highlighted:`EVALUATION_PROMPT = <span class="hljs-string">&quot;&quot;&quot;###Task Description:
An instruction (might include an Input inside it), a response to evaluate, a reference answer that gets a score of 5, and a score rubric representing a evaluation criteria are given.
1. Write a detailed feedback that assess the quality of the response strictly based on the given score rubric, not evaluating in general.
2. After writing a feedback, write a score that is an integer between 1 and 5. You should refer to the score rubric.
3. The output format should look as follows: \\&quot;Feedback: {{write a feedback for criteria}} [RESULT] {{an integer number between 1 and 5}}\\&quot;
4. Please do not generate any other opening, closing, and explanations. Be sure to include [RESULT] in your output.

###The instruction to evaluate:
{instruction}

###Response to evaluate:
{response}

###Reference Answer (Score 5):
{reference_answer}

###Score Rubrics:
[Is the response correct, accurate, and factual based on the reference answer?]
Score 1: The response is completely incorrect, inaccurate, and/or not factual.
Score 2: The response is mostly incorrect, inaccurate, and/or not factual.
Score 3: The response is somewhat correct, accurate, and/or factual.
Score 4: The response is mostly correct, accurate, and factual.
Score 5: The response is completely correct, accurate, and factual.

###Feedback:&quot;&quot;&quot;</span>

<span class="hljs-keyword">from</span> langchain.prompts.chat <span class="hljs-keyword">import</span> (
    ChatPromptTemplate,
    HumanMessagePromptTemplate,
)
<span class="hljs-keyword">from</span> langchain.schema <span class="hljs-keyword">import</span> SystemMessage


evaluation_prompt_template = ChatPromptTemplate.from_messages(
    [
        SystemMessage(content=<span class="hljs-string">&quot;You are a fair evaluator language model.&quot;</span>),
        HumanMessagePromptTemplate.from_template(EVALUATION_PROMPT),
    ]
)`,wrap:!1}}),Ll=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.chat_models <span class="hljs-keyword">import</span> ChatOpenAI

OPENAI_API_KEY = <span class="hljs-string">&quot;&quot;</span>

eval_chat_model = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4-1106-preview&quot;</span>, temperature=<span class="hljs-number">0</span>, openai_api_key=OPENAI_API_KEY)
evaluator_name = <span class="hljs-string">&quot;GPT4&quot;</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate_answers</span>(<span class="hljs-params">
    answer_path: <span class="hljs-built_in">str</span>,
    eval_chat_model,
    evaluator_name: <span class="hljs-built_in">str</span>,
    evaluation_prompt_template: ChatPromptTemplate,
</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;Evaluates generated answers. Modifies the given answer file in place for better checkpointing.&quot;&quot;&quot;</span>
    answers = []
    <span class="hljs-keyword">if</span> os.path.isfile(answer_path):  <span class="hljs-comment"># load previous generations if they exist</span>
        answers = json.load(<span class="hljs-built_in">open</span>(answer_path, <span class="hljs-string">&quot;r&quot;</span>))

    <span class="hljs-keyword">for</span> experiment <span class="hljs-keyword">in</span> tqdm(answers):
        <span class="hljs-keyword">if</span> <span class="hljs-string">f&quot;eval_score_<span class="hljs-subst">{evaluator_name}</span>&quot;</span> <span class="hljs-keyword">in</span> experiment:
            <span class="hljs-keyword">continue</span>

        eval_prompt = evaluation_prompt_template.format_messages(
            instruction=experiment[<span class="hljs-string">&quot;question&quot;</span>],
            response=experiment[<span class="hljs-string">&quot;generated_answer&quot;</span>],
            reference_answer=experiment[<span class="hljs-string">&quot;true_answer&quot;</span>],
        )
        eval_result = eval_chat_model.invoke(eval_prompt)
        feedback, score = [item.strip() <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> eval_result.content.split(<span class="hljs-string">&quot;[RESULT]&quot;</span>)]
        experiment[<span class="hljs-string">f&quot;eval_score_<span class="hljs-subst">{evaluator_name}</span>&quot;</span>] = score
        experiment[<span class="hljs-string">f&quot;eval_feedback_<span class="hljs-subst">{evaluator_name}</span>&quot;</span>] = feedback

        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(answer_path, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
            json.dump(answers, f)`,wrap:!1}}),Kl=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(<span class="hljs-string">&quot;./output&quot;</span>):
    os.mkdir(<span class="hljs-string">&quot;./output&quot;</span>)

<span class="hljs-keyword">for</span> chunk_size <span class="hljs-keyword">in</span> [<span class="hljs-number">200</span>]:  <span class="hljs-comment"># Add other chunk sizes (in tokens) as needed</span>
    <span class="hljs-keyword">for</span> embeddings <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>]:  <span class="hljs-comment"># Add other embeddings as needed</span>
        <span class="hljs-keyword">for</span> rerank <span class="hljs-keyword">in</span> [<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>]:
            settings_name = <span class="hljs-string">f&quot;chunk:<span class="hljs-subst">{chunk_size}</span>_embeddings:<span class="hljs-subst">{embeddings.replace(<span class="hljs-string">&#x27;/&#x27;</span>, <span class="hljs-string">&#x27;~&#x27;</span>)}</span>_rerank:<span class="hljs-subst">{rerank}</span>_reader-model:<span class="hljs-subst">{READER_MODEL_NAME}</span>&quot;</span>
            output_file_name = <span class="hljs-string">f&quot;./output/rag_<span class="hljs-subst">{settings_name}</span>.json&quot;</span>

            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Running evaluation for <span class="hljs-subst">{settings_name}</span>:&quot;</span>)

            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading knowledge base embeddings...&quot;</span>)
            knowledge_index = load_embeddings(
                RAW_KNOWLEDGE_BASE,
                chunk_size=chunk_size,
                embedding_model_name=embeddings,
            )

            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Running RAG...&quot;</span>)
            reranker = RAGPretrainedModel.from_pretrained(<span class="hljs-string">&quot;colbert-ir/colbertv2.0&quot;</span>) <span class="hljs-keyword">if</span> rerank <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
            run_rag_tests(
                eval_dataset=eval_dataset,
                llm=READER_LLM,
                knowledge_index=knowledge_index,
                output_file=output_file_name,
                reranker=reranker,
                verbose=<span class="hljs-literal">False</span>,
                test_settings=settings_name,
            )

            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Running evaluation...&quot;</span>)
            evaluate_answers(
                output_file_name,
                eval_chat_model,
                evaluator_name,
                evaluation_prompt_template,
            )`,wrap:!1}}),Pl=new c({props:{title:"Inspect results",local:"inspect-results",headingTag:"h3"}}),Ol=new j({props:{code:"aW1wb3J0JTIwZ2xvYiUwQSUwQW91dHB1dHMlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjBmaWxlJTIwaW4lMjBnbG9iLmdsb2IoJTIyLiUyRm91dHB1dCUyRiouanNvbiUyMiklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBwZC5EYXRhRnJhbWUoanNvbi5sb2FkKG9wZW4oZmlsZSUyQyUyMCUyMnIlMjIpKSklMEElMjAlMjAlMjAlMjBvdXRwdXQlNUIlMjJzZXR0aW5ncyUyMiU1RCUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBvdXRwdXRzLmFwcGVuZChvdXRwdXQpJTBBcmVzdWx0JTIwJTNEJTIwcGQuY29uY2F0KG91dHB1dHMp",highlighted:`<span class="hljs-keyword">import</span> glob

outputs = []
<span class="hljs-keyword">for</span> file <span class="hljs-keyword">in</span> glob.glob(<span class="hljs-string">&quot;./output/*.json&quot;</span>):
    output = pd.DataFrame(json.load(<span class="hljs-built_in">open</span>(file, <span class="hljs-string">&quot;r&quot;</span>)))
    output[<span class="hljs-string">&quot;settings&quot;</span>] = file
    outputs.append(output)
result = pd.concat(outputs)`,wrap:!1}}),ls=new j({props:{code:"cmVzdWx0JTVCJTIyZXZhbF9zY29yZV9HUFQ0JTIyJTVEJTIwJTNEJTIwcmVzdWx0JTVCJTIyZXZhbF9zY29yZV9HUFQ0JTIyJTVELmFwcGx5KGxhbWJkYSUyMHglM0ElMjBpbnQoeCklMjBpZiUyMGlzaW5zdGFuY2UoeCUyQyUyMHN0ciklMjBlbHNlJTIwMSklMEFyZXN1bHQlNUIlMjJldmFsX3Njb3JlX0dQVDQlMjIlNUQlMjAlM0QlMjAocmVzdWx0JTVCJTIyZXZhbF9zY29yZV9HUFQ0JTIyJTVEJTIwLSUyMDEpJTIwJTJGJTIwNA==",highlighted:`result[<span class="hljs-string">&quot;eval_score_GPT4&quot;</span>] = result[<span class="hljs-string">&quot;eval_score_GPT4&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">int</span>(x) <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(x, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">else</span> <span class="hljs-number">1</span>)
result[<span class="hljs-string">&quot;eval_score_GPT4&quot;</span>] = (result[<span class="hljs-string">&quot;eval_score_GPT4&quot;</span>] - <span class="hljs-number">1</span>) / <span class="hljs-number">4</span>`,wrap:!1}}),ss=new j({props:{code:"YXZlcmFnZV9zY29yZXMlMjAlM0QlMjByZXN1bHQuZ3JvdXBieSglMjJzZXR0aW5ncyUyMiklNUIlMjJldmFsX3Njb3JlX0dQVDQlMjIlNUQubWVhbigpJTBBYXZlcmFnZV9zY29yZXMuc29ydF92YWx1ZXMoKQ==",highlighted:`average_scores = result.groupby(<span class="hljs-string">&quot;settings&quot;</span>)[<span class="hljs-string">&quot;eval_score_GPT4&quot;</span>].mean()
average_scores.sort_values()`,wrap:!1}}),es=new c({props:{title:"Example results",local:"example-results",headingTag:"h2"}}),ns=new j({props:{code:"aW1wb3J0JTIwcGxvdGx5LmV4cHJlc3MlMjBhcyUyMHB4JTBBJTBBc2NvcmVzJTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGcmFnX3Njb3Jlc19jb29rYm9vayUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBc2NvcmVzJTIwJTNEJTIwcGQuU2VyaWVzKHNjb3JlcyU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwaW5kZXglM0RzY29yZXMlNUIlMjJzZXR0aW5ncyUyMiU1RCk=",highlighted:`<span class="hljs-keyword">import</span> plotly.express <span class="hljs-keyword">as</span> px

scores = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/rag_scores_cookbook&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
scores = pd.Series(scores[<span class="hljs-string">&quot;score&quot;</span>], index=scores[<span class="hljs-string">&quot;settings&quot;</span>])`,wrap:!1}}),ys=new j({props:{code:"ZmlnJTIwJTNEJTIwcHguYmFyKCUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyQyUwQSUyMCUyMCUyMCUyMGNvbG9yJTNEc2NvcmVzJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmFsdWUlMjIlM0ElMjAlMjJBY2N1cmFjeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNldHRpbmdzJTIyJTNBJTIwJTIyQ29uZmlndXJhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMGNvbG9yX2NvbnRpbnVvdXNfc2NhbGUlM0QlMjJibHVlcmVkJTIyJTJDJTBBKSUwQWZpZy51cGRhdGVfbGF5b3V0KCUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDYwMCUyQyUwQSUyMCUyMCUyMCUyMGJhcm1vZGUlM0QlMjJncm91cCUyMiUyQyUwQSUyMCUyMCUyMCUyMHlheGlzX3JhbmdlJTNEJTVCMCUyQyUyMDEwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyJTNDYiUzRUFjY3VyYWN5JTIwb2YlMjBkaWZmZXJlbnQlMjBSQUclMjBjb25maWd1cmF0aW9ucyUzQyUyRmIlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB4YXhpc190aXRsZSUzRCUyMlJBRyUyMHNldHRpbmdzJTIyJTJDJTBBJTIwJTIwJTIwJTIwZm9udCUzRGRpY3Qoc2l6ZSUzRDE1KSUyQyUwQSklMEFmaWcubGF5b3V0LnlheGlzLnRpY2tzdWZmaXglMjAlM0QlMjAlMjIlMjUlMjIlMEFmaWcudXBkYXRlX2NvbG9yYXhlcyhzaG93c2NhbGUlM0RGYWxzZSklMEFmaWcudXBkYXRlX3RyYWNlcyh0ZXh0dGVtcGxhdGUlM0QlMjIlMjUlN0J5JTNBLjFmJTdEJTIyJTJDJTIwdGV4dHBvc2l0aW9uJTNEJTIyb3V0c2lkZSUyMiklMEFmaWcuc2hvdygp",highlighted:`fig = px.bar(
    scores,
    color=scores,
    labels={
        <span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-string">&quot;Accuracy&quot;</span>,
        <span class="hljs-string">&quot;settings&quot;</span>: <span class="hljs-string">&quot;Configuration&quot;</span>,
    },
    color_continuous_scale=<span class="hljs-string">&quot;bluered&quot;</span>,
)
fig.update_layout(
    width=<span class="hljs-number">1000</span>,
    height=<span class="hljs-number">600</span>,
    barmode=<span class="hljs-string">&quot;group&quot;</span>,
    yaxis_range=[<span class="hljs-number">0</span>, <span class="hljs-number">100</span>],
    title=<span class="hljs-string">&quot;&lt;b&gt;Accuracy of different RAG configurations&lt;/b&gt;&quot;</span>,
    xaxis_title=<span class="hljs-string">&quot;RAG settings&quot;</span>,
    font=<span class="hljs-built_in">dict</span>(size=<span class="hljs-number">15</span>),
)
fig.layout.yaxis.ticksuffix = <span class="hljs-string">&quot;%&quot;</span>
fig.update_coloraxes(showscale=<span class="hljs-literal">False</span>)
fig.update_traces(texttemplate=<span class="hljs-string">&quot;%{y:.1f}&quot;</span>, textposition=<span class="hljs-string">&quot;outside&quot;</span>)
fig.show()`,wrap:!1}}),is=new bM({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_evaluation.md"}}),{c(){u=n("meta"),Ts=M(),ps=n("p"),js=M(),U(d.$$.fragment),cs=M(),U(I.$$.fragment),us=M(),m=n("p"),m.innerHTML=ot,rs=M(),h=n("p"),h.textContent=pt,ds=M(),b=n("p"),b.innerHTML=wt,Is=M(),C=n("p"),C.textContent=Tt,ms=M(),B=n("img"),hs=M(),Z=n("p"),Z.textContent=ct,bs=M(),U(G.$$.fragment),Cs=M(),A=n("p"),A.textContent=ut,Bs=M(),g=n("p"),g.textContent=rt,Zs=M(),f=n("ol"),f.innerHTML=dt,Gs=M(),Q=n("p"),Q.textContent=It,As=M(),W=n("ol"),W.innerHTML=mt,gs=M(),V=n("p"),V.innerHTML=ht,fs=M(),U(R.$$.fragment),Qs=M(),U(v.$$.fragment),Ws=M(),U(X.$$.fragment),Vs=M(),U(k.$$.fragment),Rs=M(),U(N.$$.fragment),vs=M(),U(E.$$.fragment),Xs=M(),U(Y.$$.fragment),ks=M(),S=n("p"),S.textContent=bt,Ns=M(),F=n("p"),F.textContent=Ct,Es=M(),U(_.$$.fragment),Ys=M(),U(q.$$.fragment),Ss=M(),U(x.$$.fragment),Fs=M(),z=n("p"),z.innerHTML=Bt,_s=M(),U(H.$$.fragment),qs=M(),U($.$$.fragment),xs=M(),L=n("p"),L.textContent=Zt,zs=M(),D=n("p"),D.textContent=Gt,Hs=M(),U(K.$$.fragment),$s=M(),U(P.$$.fragment),Ls=M(),U(O.$$.fragment),Ds=M(),ll=n("p"),ll.textContent=At,Ks=M(),sl=n("p"),sl.innerHTML=gt,Ps=M(),el=n("ul"),el.innerHTML=ft,Os=M(),tl=n("p"),tl.innerHTML=Qt,le=M(),Ml=n("ul"),Ml.innerHTML=Wt,se=M(),al=n("p"),al.textContent=Vt,ee=M(),nl=n("p"),nl.innerHTML=Rt,te=M(),yl=n("p"),yl.textContent=vt,Me=M(),U(Jl.$$.fragment),ae=M(),U(Ul.$$.fragment),ne=M(),il=n("p"),il.textContent=Xt,ye=M(),U(ol.$$.fragment),Je=M(),pl=n("pre"),pl.textContent=kt,Ue=M(),wl=n("p"),wl.textContent=Nt,ie=M(),Tl=n("p"),Tl.textContent=Et,oe=M(),U(jl.$$.fragment),pe=M(),U(cl.$$.fragment),we=M(),U(ul.$$.fragment),Te=M(),rl=n("ul"),rl.innerHTML=Yt,je=M(),dl=n("p"),dl.textContent=St,ce=M(),Il=n("ul"),Il.innerHTML=Ft,ue=M(),ml=n("p"),ml.innerHTML=_t,re=M(),hl=n("p"),hl.innerHTML=qt,de=M(),bl=n("blockquote"),bl.innerHTML=xt,Ie=M(),Cl=n("p"),Cl.innerHTML=zt,me=M(),U(Bl.$$.fragment),he=M(),U(Zl.$$.fragment),be=M(),U(Gl.$$.fragment),Ce=M(),Al=n("p"),Al.innerHTML=Ht,Be=M(),gl=n("blockquote"),gl.innerHTML=$t,Ze=M(),fl=n("p"),fl.innerHTML=Lt,Ge=M(),Ql=n("ul"),Ql.innerHTML=Dt,Ae=M(),U(Wl.$$.fragment),ge=M(),U(Vl.$$.fragment),fe=M(),Rl=n("p"),Rl.innerHTML=Kt,Qe=M(),vl=n("p"),vl.textContent=Pt,We=M(),Xl=n("ul"),Xl.innerHTML=Ot,Ve=M(),U(kl.$$.fragment),Re=M(),U(Nl.$$.fragment),ve=M(),U(El.$$.fragment),Xe=M(),U(Yl.$$.fragment),ke=M(),Sl=n("p"),Sl.textContent=lM,Ne=M(),Fl=n("p"),Fl.innerHTML=sM,Ee=M(),_l=n("p"),_l.innerHTML=eM,Ye=M(),ql=n("blockquote"),ql.innerHTML=tM,Se=M(),xl=n("p"),xl.innerHTML=MM,Fe=M(),zl=n("p"),zl.innerHTML=aM,_e=M(),U(Hl.$$.fragment),qe=M(),U($l.$$.fragment),xe=M(),U(Ll.$$.fragment),ze=M(),Dl=n("p"),Dl.textContent=nM,He=M(),U(Kl.$$.fragment),$e=M(),U(Pl.$$.fragment),Le=M(),U(Ol.$$.fragment),De=M(),U(ls.$$.fragment),Ke=M(),U(ss.$$.fragment),Pe=M(),U(es.$$.fragment),Oe=M(),ts=n("p"),ts.innerHTML=yM,lt=M(),Ms=n("p"),Ms.textContent=JM,st=M(),as=n("p"),as.innerHTML=UM,et=M(),U(ns.$$.fragment),tt=M(),U(ys.$$.fragment),Mt=M(),r=n("img"),at=M(),Js=n("p"),Js.textContent=oM,nt=M(),Us=n("p"),Us.textContent=pM,yt=M(),U(is.$$.fragment),Jt=M(),ws=n("p"),this.h()},l(l){const s=IM("svelte-u9bgzb",document.head);u=y(s,"META",{name:!0,content:!0}),s.forEach(e),Ts=a(l),ps=y(l,"P",{}),TM(ps).forEach(e),js=a(l),i(d.$$.fragment,l),cs=a(l),i(I.$$.fragment,l),us=a(l),m=y(l,"P",{"data-svelte-h":!0}),J(m)!=="svelte-1xlqnsv"&&(m.innerHTML=ot),rs=a(l),h=y(l,"P",{"data-svelte-h":!0}),J(h)!=="svelte-2xiv25"&&(h.textContent=pt),ds=a(l),b=y(l,"P",{"data-svelte-h":!0}),J(b)!=="svelte-1460hpm"&&(b.innerHTML=wt),Is=a(l),C=y(l,"P",{"data-svelte-h":!0}),J(C)!=="svelte-9eyhtm"&&(C.textContent=Tt),ms=a(l),B=y(l,"IMG",{src:!0,height:!0}),hs=a(l),Z=y(l,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-1wwknqm"&&(Z.textContent=ct),bs=a(l),i(G.$$.fragment,l),Cs=a(l),A=y(l,"P",{"data-svelte-h":!0}),J(A)!=="svelte-vv8zeo"&&(A.textContent=ut),Bs=a(l),g=y(l,"P",{"data-svelte-h":!0}),J(g)!=="svelte-baonz3"&&(g.textContent=rt),Zs=a(l),f=y(l,"OL",{"data-svelte-h":!0}),J(f)!=="svelte-12qpxq2"&&(f.innerHTML=dt),Gs=a(l),Q=y(l,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-gq3s7j"&&(Q.textContent=It),As=a(l),W=y(l,"OL",{"data-svelte-h":!0}),J(W)!=="svelte-qbxvp7"&&(W.innerHTML=mt),gs=a(l),V=y(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-15hqrk"&&(V.innerHTML=ht),fs=a(l),i(R.$$.fragment,l),Qs=a(l),i(v.$$.fragment,l),Ws=a(l),i(X.$$.fragment,l),Vs=a(l),i(k.$$.fragment,l),Rs=a(l),i(N.$$.fragment,l),vs=a(l),i(E.$$.fragment,l),Xs=a(l),i(Y.$$.fragment,l),ks=a(l),S=y(l,"P",{"data-svelte-h":!0}),J(S)!=="svelte-1wbiyhw"&&(S.textContent=bt),Ns=a(l),F=y(l,"P",{"data-svelte-h":!0}),J(F)!=="svelte-1o0ze03"&&(F.textContent=Ct),Es=a(l),i(_.$$.fragment,l),Ys=a(l),i(q.$$.fragment,l),Ss=a(l),i(x.$$.fragment,l),Fs=a(l),z=y(l,"P",{"data-svelte-h":!0}),J(z)!=="svelte-162gsjg"&&(z.innerHTML=Bt),_s=a(l),i(H.$$.fragment,l),qs=a(l),i($.$$.fragment,l),xs=a(l),L=y(l,"P",{"data-svelte-h":!0}),J(L)!=="svelte-1v7z1mr"&&(L.textContent=Zt),zs=a(l),D=y(l,"P",{"data-svelte-h":!0}),J(D)!=="svelte-jsmlwo"&&(D.textContent=Gt),Hs=a(l),i(K.$$.fragment,l),$s=a(l),i(P.$$.fragment,l),Ls=a(l),i(O.$$.fragment,l),Ds=a(l),ll=y(l,"P",{"data-svelte-h":!0}),J(ll)!=="svelte-xa68th"&&(ll.textContent=At),Ks=a(l),sl=y(l,"P",{"data-svelte-h":!0}),J(sl)!=="svelte-1rn1tpr"&&(sl.innerHTML=gt),Ps=a(l),el=y(l,"UL",{"data-svelte-h":!0}),J(el)!=="svelte-mge22a"&&(el.innerHTML=ft),Os=a(l),tl=y(l,"P",{"data-svelte-h":!0}),J(tl)!=="svelte-1a9sdbs"&&(tl.innerHTML=Qt),le=a(l),Ml=y(l,"UL",{"data-svelte-h":!0}),J(Ml)!=="svelte-17ofou1"&&(Ml.innerHTML=Wt),se=a(l),al=y(l,"P",{"data-svelte-h":!0}),J(al)!=="svelte-1bu41t1"&&(al.textContent=Vt),ee=a(l),nl=y(l,"P",{"data-svelte-h":!0}),J(nl)!=="svelte-v7jbl8"&&(nl.innerHTML=Rt),te=a(l),yl=y(l,"P",{"data-svelte-h":!0}),J(yl)!=="svelte-1kwgyx1"&&(yl.textContent=vt),Me=a(l),i(Jl.$$.fragment,l),ae=a(l),i(Ul.$$.fragment,l),ne=a(l),il=y(l,"P",{"data-svelte-h":!0}),J(il)!=="svelte-yms2wp"&&(il.textContent=Xt),ye=a(l),i(ol.$$.fragment,l),Je=a(l),pl=y(l,"PRE",{"data-svelte-h":!0}),J(pl)!=="svelte-1k8l62p"&&(pl.textContent=kt),Ue=a(l),wl=y(l,"P",{"data-svelte-h":!0}),J(wl)!=="svelte-1asqnia"&&(wl.textContent=Nt),ie=a(l),Tl=y(l,"P",{"data-svelte-h":!0}),J(Tl)!=="svelte-alkdir"&&(Tl.textContent=Et),oe=a(l),i(jl.$$.fragment,l),pe=a(l),i(cl.$$.fragment,l),we=a(l),i(ul.$$.fragment,l),Te=a(l),rl=y(l,"UL",{"data-svelte-h":!0}),J(rl)!=="svelte-1fnij86"&&(rl.innerHTML=Yt),je=a(l),dl=y(l,"P",{"data-svelte-h":!0}),J(dl)!=="svelte-53zzzq"&&(dl.textContent=St),ce=a(l),Il=y(l,"UL",{"data-svelte-h":!0}),J(Il)!=="svelte-1g19xro"&&(Il.innerHTML=Ft),ue=a(l),ml=y(l,"P",{"data-svelte-h":!0}),J(ml)!=="svelte-1ns6yk3"&&(ml.innerHTML=_t),re=a(l),hl=y(l,"P",{"data-svelte-h":!0}),J(hl)!=="svelte-1hitev5"&&(hl.innerHTML=qt),de=a(l),bl=y(l,"BLOCKQUOTE",{"data-svelte-h":!0}),J(bl)!=="svelte-w4wn00"&&(bl.innerHTML=xt),Ie=a(l),Cl=y(l,"P",{"data-svelte-h":!0}),J(Cl)!=="svelte-1toh8cv"&&(Cl.innerHTML=zt),me=a(l),i(Bl.$$.fragment,l),he=a(l),i(Zl.$$.fragment,l),be=a(l),i(Gl.$$.fragment,l),Ce=a(l),Al=y(l,"P",{"data-svelte-h":!0}),J(Al)!=="svelte-xymbek"&&(Al.innerHTML=Ht),Be=a(l),gl=y(l,"BLOCKQUOTE",{"data-svelte-h":!0}),J(gl)!=="svelte-1k8ukvt"&&(gl.innerHTML=$t),Ze=a(l),fl=y(l,"P",{"data-svelte-h":!0}),J(fl)!=="svelte-1hqptzf"&&(fl.innerHTML=Lt),Ge=a(l),Ql=y(l,"UL",{"data-svelte-h":!0}),J(Ql)!=="svelte-1w0jpt6"&&(Ql.innerHTML=Dt),Ae=a(l),i(Wl.$$.fragment,l),ge=a(l),i(Vl.$$.fragment,l),fe=a(l),Rl=y(l,"P",{"data-svelte-h":!0}),J(Rl)!=="svelte-1m0x0qs"&&(Rl.innerHTML=Kt),Qe=a(l),vl=y(l,"P",{"data-svelte-h":!0}),J(vl)!=="svelte-1e3sl85"&&(vl.textContent=Pt),We=a(l),Xl=y(l,"UL",{"data-svelte-h":!0}),J(Xl)!=="svelte-1scj3jf"&&(Xl.innerHTML=Ot),Ve=a(l),i(kl.$$.fragment,l),Re=a(l),i(Nl.$$.fragment,l),ve=a(l),i(El.$$.fragment,l),Xe=a(l),i(Yl.$$.fragment,l),ke=a(l),Sl=y(l,"P",{"data-svelte-h":!0}),J(Sl)!=="svelte-z2wcut"&&(Sl.textContent=lM),Ne=a(l),Fl=y(l,"P",{"data-svelte-h":!0}),J(Fl)!=="svelte-1tiikby"&&(Fl.innerHTML=sM),Ee=a(l),_l=y(l,"P",{"data-svelte-h":!0}),J(_l)!=="svelte-13s04hx"&&(_l.innerHTML=eM),Ye=a(l),ql=y(l,"BLOCKQUOTE",{"data-svelte-h":!0}),J(ql)!=="svelte-jkfwyy"&&(ql.innerHTML=tM),Se=a(l),xl=y(l,"P",{"data-svelte-h":!0}),J(xl)!=="svelte-qutlt3"&&(xl.innerHTML=MM),Fe=a(l),zl=y(l,"P",{"data-svelte-h":!0}),J(zl)!=="svelte-1sle7mx"&&(zl.innerHTML=aM),_e=a(l),i(Hl.$$.fragment,l),qe=a(l),i($l.$$.fragment,l),xe=a(l),i(Ll.$$.fragment,l),ze=a(l),Dl=y(l,"P",{"data-svelte-h":!0}),J(Dl)!=="svelte-ieknxj"&&(Dl.textContent=nM),He=a(l),i(Kl.$$.fragment,l),$e=a(l),i(Pl.$$.fragment,l),Le=a(l),i(Ol.$$.fragment,l),De=a(l),i(ls.$$.fragment,l),Ke=a(l),i(ss.$$.fragment,l),Pe=a(l),i(es.$$.fragment,l),Oe=a(l),ts=y(l,"P",{"data-svelte-h":!0}),J(ts)!=="svelte-5h9xp6"&&(ts.innerHTML=yM),lt=a(l),Ms=y(l,"P",{"data-svelte-h":!0}),J(Ms)!=="svelte-6vrle6"&&(Ms.textContent=JM),st=a(l),as=y(l,"P",{"data-svelte-h":!0}),J(as)!=="svelte-1l99caq"&&(as.innerHTML=UM),et=a(l),i(ns.$$.fragment,l),tt=a(l),i(ys.$$.fragment,l),Mt=a(l),r=y(l,"IMG",{src:!0,height:!0,width:!0}),at=a(l),Js=y(l,"P",{"data-svelte-h":!0}),J(Js)!=="svelte-i71q2k"&&(Js.textContent=oM),nt=a(l),Us=y(l,"P",{"data-svelte-h":!0}),J(Us)!=="svelte-5zkqt2"&&(Us.textContent=pM),yt=a(l),i(is.$$.fragment,l),Jt=a(l),ws=y(l,"P",{}),TM(ws).forEach(e),this.h()},h(){os(u,"name","hf:doc:metadata"),os(u,"content",BM),wM(B.src,jt="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/RAG_workflow.png")||os(B,"src",jt),os(B,"height","700"),wM(r.src,iM="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/RAG_settings_accuracy.png")||os(r,"src",iM),os(r,"height","500"),os(r,"width","800")},m(l,s){mM(document.head,u),t(l,Ts,s),t(l,ps,s),t(l,js,s),o(d,l,s),t(l,cs,s),o(I,l,s),t(l,us,s),t(l,m,s),t(l,rs,s),t(l,h,s),t(l,ds,s),t(l,b,s),t(l,Is,s),t(l,C,s),t(l,ms,s),t(l,B,s),t(l,hs,s),t(l,Z,s),t(l,bs,s),o(G,l,s),t(l,Cs,s),t(l,A,s),t(l,Bs,s),t(l,g,s),t(l,Zs,s),t(l,f,s),t(l,Gs,s),t(l,Q,s),t(l,As,s),t(l,W,s),t(l,gs,s),t(l,V,s),t(l,fs,s),o(R,l,s),t(l,Qs,s),o(v,l,s),t(l,Ws,s),o(X,l,s),t(l,Vs,s),o(k,l,s),t(l,Rs,s),o(N,l,s),t(l,vs,s),o(E,l,s),t(l,Xs,s),o(Y,l,s),t(l,ks,s),t(l,S,s),t(l,Ns,s),t(l,F,s),t(l,Es,s),o(_,l,s),t(l,Ys,s),o(q,l,s),t(l,Ss,s),o(x,l,s),t(l,Fs,s),t(l,z,s),t(l,_s,s),o(H,l,s),t(l,qs,s),o($,l,s),t(l,xs,s),t(l,L,s),t(l,zs,s),t(l,D,s),t(l,Hs,s),o(K,l,s),t(l,$s,s),o(P,l,s),t(l,Ls,s),o(O,l,s),t(l,Ds,s),t(l,ll,s),t(l,Ks,s),t(l,sl,s),t(l,Ps,s),t(l,el,s),t(l,Os,s),t(l,tl,s),t(l,le,s),t(l,Ml,s),t(l,se,s),t(l,al,s),t(l,ee,s),t(l,nl,s),t(l,te,s),t(l,yl,s),t(l,Me,s),o(Jl,l,s),t(l,ae,s),o(Ul,l,s),t(l,ne,s),t(l,il,s),t(l,ye,s),o(ol,l,s),t(l,Je,s),t(l,pl,s),t(l,Ue,s),t(l,wl,s),t(l,ie,s),t(l,Tl,s),t(l,oe,s),o(jl,l,s),t(l,pe,s),o(cl,l,s),t(l,we,s),o(ul,l,s),t(l,Te,s),t(l,rl,s),t(l,je,s),t(l,dl,s),t(l,ce,s),t(l,Il,s),t(l,ue,s),t(l,ml,s),t(l,re,s),t(l,hl,s),t(l,de,s),t(l,bl,s),t(l,Ie,s),t(l,Cl,s),t(l,me,s),o(Bl,l,s),t(l,he,s),o(Zl,l,s),t(l,be,s),o(Gl,l,s),t(l,Ce,s),t(l,Al,s),t(l,Be,s),t(l,gl,s),t(l,Ze,s),t(l,fl,s),t(l,Ge,s),t(l,Ql,s),t(l,Ae,s),o(Wl,l,s),t(l,ge,s),o(Vl,l,s),t(l,fe,s),t(l,Rl,s),t(l,Qe,s),t(l,vl,s),t(l,We,s),t(l,Xl,s),t(l,Ve,s),o(kl,l,s),t(l,Re,s),o(Nl,l,s),t(l,ve,s),o(El,l,s),t(l,Xe,s),o(Yl,l,s),t(l,ke,s),t(l,Sl,s),t(l,Ne,s),t(l,Fl,s),t(l,Ee,s),t(l,_l,s),t(l,Ye,s),t(l,ql,s),t(l,Se,s),t(l,xl,s),t(l,Fe,s),t(l,zl,s),t(l,_e,s),o(Hl,l,s),t(l,qe,s),o($l,l,s),t(l,xe,s),o(Ll,l,s),t(l,ze,s),t(l,Dl,s),t(l,He,s),o(Kl,l,s),t(l,$e,s),o(Pl,l,s),t(l,Le,s),o(Ol,l,s),t(l,De,s),o(ls,l,s),t(l,Ke,s),o(ss,l,s),t(l,Pe,s),o(es,l,s),t(l,Oe,s),t(l,ts,s),t(l,lt,s),t(l,Ms,s),t(l,st,s),t(l,as,s),t(l,et,s),o(ns,l,s),t(l,tt,s),o(ys,l,s),t(l,Mt,s),t(l,r,s),t(l,at,s),t(l,Js,s),t(l,nt,s),t(l,Us,s),t(l,yt,s),o(is,l,s),t(l,Jt,s),t(l,ws,s),Ut=!0},p:cM,i(l){Ut||(p(d.$$.fragment,l),p(I.$$.fragment,l),p(G.$$.fragment,l),p(R.$$.fragment,l),p(v.$$.fragment,l),p(X.$$.fragment,l),p(k.$$.fragment,l),p(N.$$.fragment,l),p(E.$$.fragment,l),p(Y.$$.fragment,l),p(_.$$.fragment,l),p(q.$$.fragment,l),p(x.$$.fragment,l),p(H.$$.fragment,l),p($.$$.fragment,l),p(K.$$.fragment,l),p(P.$$.fragment,l),p(O.$$.fragment,l),p(Jl.$$.fragment,l),p(Ul.$$.fragment,l),p(ol.$$.fragment,l),p(jl.$$.fragment,l),p(cl.$$.fragment,l),p(ul.$$.fragment,l),p(Bl.$$.fragment,l),p(Zl.$$.fragment,l),p(Gl.$$.fragment,l),p(Wl.$$.fragment,l),p(Vl.$$.fragment,l),p(kl.$$.fragment,l),p(Nl.$$.fragment,l),p(El.$$.fragment,l),p(Yl.$$.fragment,l),p(Hl.$$.fragment,l),p($l.$$.fragment,l),p(Ll.$$.fragment,l),p(Kl.$$.fragment,l),p(Pl.$$.fragment,l),p(Ol.$$.fragment,l),p(ls.$$.fragment,l),p(ss.$$.fragment,l),p(es.$$.fragment,l),p(ns.$$.fragment,l),p(ys.$$.fragment,l),p(is.$$.fragment,l),Ut=!0)},o(l){w(d.$$.fragment,l),w(I.$$.fragment,l),w(G.$$.fragment,l),w(R.$$.fragment,l),w(v.$$.fragment,l),w(X.$$.fragment,l),w(k.$$.fragment,l),w(N.$$.fragment,l),w(E.$$.fragment,l),w(Y.$$.fragment,l),w(_.$$.fragment,l),w(q.$$.fragment,l),w(x.$$.fragment,l),w(H.$$.fragment,l),w($.$$.fragment,l),w(K.$$.fragment,l),w(P.$$.fragment,l),w(O.$$.fragment,l),w(Jl.$$.fragment,l),w(Ul.$$.fragment,l),w(ol.$$.fragment,l),w(jl.$$.fragment,l),w(cl.$$.fragment,l),w(ul.$$.fragment,l),w(Bl.$$.fragment,l),w(Zl.$$.fragment,l),w(Gl.$$.fragment,l),w(Wl.$$.fragment,l),w(Vl.$$.fragment,l),w(kl.$$.fragment,l),w(Nl.$$.fragment,l),w(El.$$.fragment,l),w(Yl.$$.fragment,l),w(Hl.$$.fragment,l),w($l.$$.fragment,l),w(Ll.$$.fragment,l),w(Kl.$$.fragment,l),w(Pl.$$.fragment,l),w(Ol.$$.fragment,l),w(ls.$$.fragment,l),w(ss.$$.fragment,l),w(es.$$.fragment,l),w(ns.$$.fragment,l),w(ys.$$.fragment,l),w(is.$$.fragment,l),Ut=!1},d(l){l&&(e(Ts),e(ps),e(js),e(cs),e(us),e(m),e(rs),e(h),e(ds),e(b),e(Is),e(C),e(ms),e(B),e(hs),e(Z),e(bs),e(Cs),e(A),e(Bs),e(g),e(Zs),e(f),e(Gs),e(Q),e(As),e(W),e(gs),e(V),e(fs),e(Qs),e(Ws),e(Vs),e(Rs),e(vs),e(Xs),e(ks),e(S),e(Ns),e(F),e(Es),e(Ys),e(Ss),e(Fs),e(z),e(_s),e(qs),e(xs),e(L),e(zs),e(D),e(Hs),e($s),e(Ls),e(Ds),e(ll),e(Ks),e(sl),e(Ps),e(el),e(Os),e(tl),e(le),e(Ml),e(se),e(al),e(ee),e(nl),e(te),e(yl),e(Me),e(ae),e(ne),e(il),e(ye),e(Je),e(pl),e(Ue),e(wl),e(ie),e(Tl),e(oe),e(pe),e(we),e(Te),e(rl),e(je),e(dl),e(ce),e(Il),e(ue),e(ml),e(re),e(hl),e(de),e(bl),e(Ie),e(Cl),e(me),e(he),e(be),e(Ce),e(Al),e(Be),e(gl),e(Ze),e(fl),e(Ge),e(Ql),e(Ae),e(ge),e(fe),e(Rl),e(Qe),e(vl),e(We),e(Xl),e(Ve),e(Re),e(ve),e(Xe),e(ke),e(Sl),e(Ne),e(Fl),e(Ee),e(_l),e(Ye),e(ql),e(Se),e(xl),e(Fe),e(zl),e(_e),e(qe),e(xe),e(ze),e(Dl),e(He),e($e),e(Le),e(De),e(Ke),e(Pe),e(Oe),e(ts),e(lt),e(Ms),e(st),e(as),e(et),e(tt),e(Mt),e(r),e(at),e(Js),e(nt),e(Us),e(yt),e(Jt),e(ws)),e(u),T(d,l),T(I,l),T(G,l),T(R,l),T(v,l),T(X,l),T(k,l),T(N,l),T(E,l),T(Y,l),T(_,l),T(q,l),T(x,l),T(H,l),T($,l),T(K,l),T(P,l),T(O,l),T(Jl,l),T(Ul,l),T(ol,l),T(jl,l),T(cl,l),T(ul,l),T(Bl,l),T(Zl,l),T(Gl,l),T(Wl,l),T(Vl,l),T(kl,l),T(Nl,l),T(El,l),T(Yl,l),T(Hl,l),T($l,l),T(Ll,l),T(Kl,l),T(Pl,l),T(Ol,l),T(ls,l),T(ss,l),T(es,l),T(ns,l),T(ys,l),T(is,l)}}}const BM='{"title":"RAG Evaluation","local":"rag-evaluation","sections":[{"title":"Evaluating RAG performance","local":"evaluating-rag-performance","sections":[],"depth":3},{"title":"Load your knowledge base","local":"load-your-knowledge-base","sections":[],"depth":3}],"depth":1}';function ZM(it){return uM(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class QM extends rM{constructor(u){super(),dM(this,u,ZM,CM,jM,{})}}export{QM as component};
